/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cloud.autoscaling;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.cloud.SolrCloudManager;
import org.apache.solr.client.solrj.cloud.autoscaling.AutoScalingConfig;
import org.apache.solr.client.solrj.cloud.autoscaling.NoneSuggester;
import org.apache.solr.client.solrj.cloud.autoscaling.Policy;
import org.apache.solr.client.solrj.cloud.autoscaling.PolicyHelper;
import org.apache.solr.client.solrj.cloud.autoscaling.Suggester;
import org.apache.solr.client.solrj.cloud.autoscaling.UnsupportedSuggester;
import org.apache.solr.cloud.autoscaling.ActionContext;
import org.apache.solr.cloud.autoscaling.TriggerActionBase;
import org.apache.solr.cloud.autoscaling.TriggerEvent;
import org.apache.solr.cloud.autoscaling.TriggerUtils;
import org.apache.solr.cloud.autoscaling.TriggerValidationException;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.ClusterState;
import org.apache.solr.common.cloud.DocCollection;
import org.apache.solr.common.cloud.Replica;
import org.apache.solr.common.params.CollectionParams;
import org.apache.solr.common.util.Pair;
import org.apache.solr.common.util.StrUtils;
import org.apache.solr.core.SolrResourceLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ComputePlanAction
extends TriggerActionBase {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final String DIAGNOSTICS = "__compute_diag__";
    Predicate<String> collectionsPredicate = s -> true;
    private static final String START = "__start__";

    public ComputePlanAction() {
        TriggerUtils.validProperties(this.validProperties, "collections");
    }

    @Override
    public void configure(SolrResourceLoader loader, SolrCloudManager cloudManager, Map<String, Object> properties) throws TriggerValidationException {
        super.configure(loader, cloudManager, properties);
        Object value = properties.get("collections");
        if (value instanceof String) {
            String colString = (String)value;
            if (!colString.isEmpty()) {
                List whiteListedCollections = StrUtils.splitSmart((String)colString, (char)',');
                this.collectionsPredicate = whiteListedCollections::contains;
            }
        } else if (value instanceof Map) {
            Map matchConditions = (Map)value;
            this.collectionsPredicate = collectionName -> {
                try {
                    DocCollection collection = cloudManager.getClusterStateProvider().getCollection(collectionName);
                    if (collection == null) {
                        log.debug("Collection: {} was not found while evaluating conditions", collectionName);
                        return false;
                    }
                    for (Map.Entry entry : matchConditions.entrySet()) {
                        if (((String)entry.getValue()).equals(collection.get((String)entry.getKey()))) continue;
                        if (log.isDebugEnabled()) {
                            log.debug("Collection: {} does not match condition: {}:{}", new Object[]{collectionName, entry.getKey(), entry.getValue()});
                        }
                        return false;
                    }
                    return true;
                }
                catch (IOException e) {
                    log.error("Exception fetching collection information for: {}", collectionName, (Object)e);
                    return false;
                }
            };
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void process(TriggerEvent event, ActionContext context) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug("-- processing event: {} with context properties: {}", (Object)event, context.getProperties());
        }
        SolrCloudManager cloudManager = context.getCloudManager();
        try {
            AutoScalingConfig autoScalingConf = cloudManager.getDistribStateManager().getAutoScalingConfig();
            if (autoScalingConf.isEmpty()) {
                throw new Exception("Action: " + this.getName() + " executed but no policy is configured");
            }
            PolicyHelper.SessionWrapper sessionWrapper = PolicyHelper.getSession((SolrCloudManager)cloudManager);
            Policy.Session session = sessionWrapper.get();
            ClusterState clusterState = cloudManager.getClusterStateProvider().getClusterState();
            if (log.isTraceEnabled()) {
                log.trace("-- session: {}", (Object)session);
                log.trace("-- state: {}", (Object)clusterState);
            }
            try {
                Suggester suggester = this.getSuggester(session, event, context, cloudManager);
                int maxOperations = this.getMaxNumOps(event, autoScalingConf, clusterState);
                int requestedOperations = this.getRequestedNumOps(event);
                if (requestedOperations > maxOperations) {
                    log.warn("Requested number of operations {} higher than maximum {}, adjusting...", (Object)requestedOperations, (Object)maxOperations);
                }
                int opCount = 0;
                int opLimit = maxOperations;
                if (requestedOperations > 0) {
                    log.debug("-- adjusting limit due to explicitly requested number of ops={}", (Object)requestedOperations);
                    opLimit = requestedOperations;
                }
                this.addDiagnostics(event, "maxOperations", maxOperations);
                this.addDiagnostics(event, "requestedOperations", requestedOperations);
                this.addDiagnostics(event, "opLimit", opLimit);
                do {
                    if (Thread.currentThread().isInterrupted()) {
                        throw new InterruptedException("stopping - thread was interrupted");
                    }
                    SolrRequest operation = suggester.getSuggestion();
                    ++opCount;
                    if (suggester.getSession() != null) {
                        session = suggester.getSession();
                    }
                    suggester = this.getSuggester(session, event, context, cloudManager);
                    if (operation == null) {
                        if (requestedOperations < 0) {
                            log.debug("-- no more operations suggested, stopping after {} ops...", (Object)(opCount - 1));
                            this.addDiagnostics(event, "noSuggestionsStopAfter", opCount - 1);
                            break;
                        }
                        log.info("Computed plan empty, remained {} requested ops to try.", (Object)(opCount - opLimit));
                        continue;
                    }
                    if (log.isDebugEnabled()) {
                        log.debug("Computed Plan: {}", (Object)operation.getParams());
                    }
                    Map<String, Object> props = context.getProperties();
                    props.compute("operations", (k, v) -> {
                        ArrayList<SolrRequest> operations = (ArrayList<SolrRequest>)v;
                        if (operations == null) {
                            operations = new ArrayList<SolrRequest>();
                        }
                        operations.add(operation);
                        return operations;
                    });
                    if (opCount < opLimit) continue;
                    log.debug("-- reached limit of maxOps={}, stopping.", (Object)opLimit);
                    this.addDiagnostics(event, "opLimitReached", true);
                } while (opCount < opLimit);
            }
            finally {
                this.releasePolicySession(sessionWrapper, session);
            }
        }
        catch (Exception e) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Unexpected exception while processing event: " + event, (Throwable)e);
        }
    }

    private void releasePolicySession(PolicyHelper.SessionWrapper sessionWrapper, Policy.Session session) {
        sessionWrapper.returnSession(session);
        sessionWrapper.release();
    }

    private void addDiagnostics(TriggerEvent event, String key, Object value) {
        if (log.isDebugEnabled()) {
            Map diag = (Map)event.getProperties().computeIfAbsent(DIAGNOSTICS, n -> new HashMap());
            diag.put(key, value);
        }
    }

    protected int getMaxNumOps(TriggerEvent event, AutoScalingConfig autoScalingConfig, ClusterState clusterState) {
        AtomicInteger totalRF = new AtomicInteger();
        clusterState.forEachCollection(coll -> {
            Integer rf = coll.getReplicationFactor();
            if (rf == null) {
                rf = coll.getSlices().isEmpty() ? Integer.valueOf(1) : Integer.valueOf(coll.getReplicas().size() / coll.getSlices().size());
            }
            totalRF.addAndGet(rf * coll.getSlices().size());
        });
        int totalMax = clusterState.getLiveNodes().size() * totalRF.get() * 3;
        this.addDiagnostics(event, "estimatedMaxOps", totalMax);
        int maxOp = ((Number)autoScalingConfig.getProperties().getOrDefault("maxComputeOperations", totalMax)).intValue();
        Object o = event.getProperty("maxComputeOperations", maxOp);
        if (o != null) {
            try {
                maxOp = Integer.parseInt(String.valueOf(o));
            }
            catch (Exception e) {
                log.warn("Invalid '{}' event property: {}, using default {}", new Object[]{"maxComputeOperations", o, maxOp});
            }
        }
        if (maxOp < 0) {
            maxOp = Integer.MAX_VALUE;
        } else if (maxOp < 1) {
            log.debug("-- estimated maxOp={}, resetting to 1...", (Object)maxOp);
            maxOp = 1;
        }
        log.debug("-- estimated total max ops={}, effective maxOps={}", (Object)totalMax, (Object)maxOp);
        return maxOp;
    }

    protected int getRequestedNumOps(TriggerEvent event) {
        Collection ops = (Collection)event.getProperty("requestedOps", Collections.emptyList());
        if (ops.isEmpty()) {
            return -1;
        }
        return ops.size();
    }

    protected Suggester getSuggester(Policy.Session session, TriggerEvent event, ActionContext context, SolrCloudManager cloudManager) throws IOException {
        Suggester suggester;
        switch (event.getEventType()) {
            case NODEADDED: {
                suggester = this.getNodeAddedSuggester(cloudManager, session, event);
                break;
            }
            case NODELOST: {
                suggester = this.getNodeLostSuggester(cloudManager, session, event);
                break;
            }
            case SEARCHRATE: 
            case METRIC: 
            case INDEXSIZE: {
                List ops = (List)event.getProperty("requestedOps", Collections.emptyList());
                int start = (Integer)event.getProperty(START, 0);
                if (ops.isEmpty() || start >= ops.size()) {
                    return NoneSuggester.get((Policy.Session)session);
                }
                TriggerEvent.Op op = (TriggerEvent.Op)ops.get(start);
                suggester = session.getSuggester(op.getAction());
                if (suggester instanceof UnsupportedSuggester) {
                    List unsupportedOps = (List)context.getProperties().computeIfAbsent("unsupportedOps", k -> new ArrayList());
                    unsupportedOps.add(op);
                }
                for (Map.Entry entry : op.getHints().entrySet()) {
                    suggester = suggester.hint((Suggester.Hint)entry.getKey(), entry.getValue());
                }
                if (this.applyCollectionHints(cloudManager, suggester) == 0) {
                    return NoneSuggester.get((Policy.Session)session);
                }
                suggester = suggester.forceOperation(true);
                event.getProperties().put(START, ++start);
                break;
            }
            case SCHEDULED: {
                String preferredOp = (String)event.getProperty("preferredOperation", CollectionParams.CollectionAction.MOVEREPLICA.toLower());
                CollectionParams.CollectionAction collectionAction = CollectionParams.CollectionAction.get((String)preferredOp);
                suggester = session.getSuggester(collectionAction);
                if (this.applyCollectionHints(cloudManager, suggester) != 0) break;
                return NoneSuggester.get((Policy.Session)session);
            }
            default: {
                throw new UnsupportedOperationException("No support for events other than nodeAdded, nodeLost, searchRate, metric, scheduled and indexSize. Received: " + event.getEventType());
            }
        }
        return suggester;
    }

    private Suggester getNodeLostSuggester(SolrCloudManager cloudManager, Policy.Session session, TriggerEvent event) throws IOException {
        String preferredOp = (String)event.getProperty("preferredOperation", CollectionParams.CollectionAction.MOVEREPLICA.toLower());
        CollectionParams.CollectionAction action = CollectionParams.CollectionAction.get((String)preferredOp);
        switch (action) {
            case MOVEREPLICA: {
                Suggester s = session.getSuggester(action).hint(Suggester.Hint.SRC_NODE, event.getProperty("nodeNames"));
                if (this.applyCollectionHints(cloudManager, s) == 0) {
                    this.addDiagnostics(event, "noRelevantCollections", true);
                    return NoneSuggester.get((Policy.Session)session);
                }
                return s;
            }
            case DELETENODE: {
                int start = (Integer)event.getProperty(START, 0);
                List srcNodes = (List)event.getProperty("nodeNames");
                if (srcNodes.isEmpty() || start >= srcNodes.size()) {
                    this.addDiagnostics(event, "noSourceNodes", true);
                    return NoneSuggester.get((Policy.Session)session);
                }
                String sourceNode = (String)srcNodes.get(start);
                Suggester s = session.getSuggester(action).hint(Suggester.Hint.SRC_NODE, event.getProperty("nodeNames"));
                if (this.applyCollectionHints(cloudManager, s) == 0) {
                    log.debug("-- no relevant collections on {}, no operations computed.", (Object)srcNodes);
                    this.addDiagnostics(event, "noRelevantCollections", true);
                    return NoneSuggester.get((Policy.Session)session);
                }
                s.hint(Suggester.Hint.SRC_NODE, Collections.singletonList(sourceNode));
                event.getProperties().put(START, ++start);
                return s;
            }
            case NONE: {
                return NoneSuggester.get((Policy.Session)session);
            }
        }
        throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Unsupported preferredOperation: " + action.toLower() + " specified for node lost trigger");
    }

    private int applyCollectionHints(SolrCloudManager cloudManager, Suggester s) throws IOException {
        ClusterState clusterState = cloudManager.getClusterStateProvider().getClusterState();
        Set<String> set = clusterState.getCollectionStates().keySet().stream().filter(collectionRef -> this.collectionsPredicate.test((String)collectionRef)).collect(Collectors.toSet());
        if (set.size() < clusterState.getCollectionStates().size()) {
            set.forEach(c -> s.hint(Suggester.Hint.COLL, c));
        }
        return set.size();
    }

    private Suggester getNodeAddedSuggester(SolrCloudManager cloudManager, Policy.Session session, TriggerEvent event) throws IOException {
        String preferredOp = (String)event.getProperty("preferredOperation", CollectionParams.CollectionAction.MOVEREPLICA.toLower());
        Replica.Type replicaType = (Replica.Type)event.getProperty("replicaType", Replica.Type.NRT);
        CollectionParams.CollectionAction action = CollectionParams.CollectionAction.get((String)preferredOp);
        Suggester suggester = session.getSuggester(action).hint(Suggester.Hint.TARGET_NODE, event.getProperty("nodeNames"));
        switch (action) {
            case ADDREPLICA: {
                ClusterState clusterState = cloudManager.getClusterStateProvider().getClusterState();
                HashSet collShards = new HashSet();
                clusterState.getCollectionStates().entrySet().stream().filter(e -> this.collectionsPredicate.test((String)e.getKey())).forEach(entry -> {
                    DocCollection docCollection = ((ClusterState.CollectionRef)entry.getValue()).get();
                    if (docCollection != null) {
                        docCollection.getActiveSlices().stream().map(slice -> new Pair(entry.getKey(), (Object)slice.getName())).forEach(collShards::add);
                    }
                });
                log.debug("-- NODE_ADDED: ADDREPLICA suggester configured with {} collection/shard hints.", (Object)collShards.size());
                this.addDiagnostics(event, "relevantCollShard", collShards);
                suggester.hint(Suggester.Hint.COLL_SHARD, collShards);
                suggester.hint(Suggester.Hint.REPLICATYPE, (Object)replicaType);
                break;
            }
            case MOVEREPLICA: {
                log.debug("-- NODE_ADDED event specified MOVEREPLICA - no hints added.");
                break;
            }
            case NONE: {
                log.debug("-- NODE_ADDED event specified NONE - no operations suggested.");
                break;
            }
            default: {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Unsupported preferredOperation=" + preferredOp + " for node added event");
            }
        }
        return suggester;
    }
}

