/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.DocWriter;
import com.lowagie.text.DocumentException;
import com.lowagie.text.pdf.PdfCopyFieldsImp;
import com.lowagie.text.pdf.PdfEncodings;
import com.lowagie.text.pdf.PdfReader;
import com.lowagie.text.pdf.PdfWriter;
import com.lowagie.text.pdf.SequenceList;
import java.io.OutputStream;
import java.util.List;

public class PdfCopyFields {
    private PdfCopyFieldsImp fc;

    public PdfCopyFields(OutputStream os) throws DocumentException {
        this.fc = new PdfCopyFieldsImp(os);
    }

    public PdfCopyFields(OutputStream os, char pdfVersion) throws DocumentException {
        this.fc = new PdfCopyFieldsImp(os, pdfVersion);
    }

    public void addDocument(PdfReader reader) throws DocumentException {
        this.fc.addDocument(reader);
    }

    public void addDocument(PdfReader reader, List pagesToKeep) throws DocumentException {
        this.fc.addDocument(reader, pagesToKeep);
    }

    public void addDocument(PdfReader reader, String ranges) throws DocumentException {
        this.fc.addDocument(reader, SequenceList.expand(ranges, reader.getNumberOfPages()));
    }

    public void setEncryption(byte[] userPassword, byte[] ownerPassword, int permissions, boolean strength128Bits) throws DocumentException {
        this.fc.setEncryption(userPassword, ownerPassword, permissions, strength128Bits);
    }

    public void setEncryption(boolean strength, String userPassword, String ownerPassword, int permissions) throws DocumentException {
        this.setEncryption(DocWriter.getISOBytes(userPassword), DocWriter.getISOBytes(ownerPassword), permissions, strength);
    }

    public void close() {
        this.fc.close();
    }

    public void open() {
        this.fc.openDoc();
    }

    public void addJavaScript(String js) {
        this.fc.addJavaScript(js, !PdfEncodings.isPdfDocEncoding(js));
    }

    public void setOutlines(List outlines) {
        this.fc.setOutlines(outlines);
    }

    public PdfWriter getWriter() {
        return this.fc;
    }

    public boolean isFullCompression() {
        return this.fc.isFullCompression();
    }

    public void setFullCompression() {
        this.fc.setFullCompression();
    }
}

