/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.config;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import javax.faces.FacesException;
import javax.faces.FactoryFinder;
import javax.faces.application.Application;
import javax.faces.application.ApplicationFactory;
import javax.faces.application.NavigationHandler;
import javax.faces.application.StateManager;
import javax.faces.application.ViewHandler;
import javax.faces.context.ExternalContext;
import javax.faces.el.PropertyResolver;
import javax.faces.el.VariableResolver;
import javax.faces.event.ActionListener;
import javax.faces.event.PhaseListener;
import javax.faces.lifecycle.Lifecycle;
import javax.faces.lifecycle.LifecycleFactory;
import javax.faces.render.RenderKit;
import javax.faces.render.RenderKitFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.myfaces.application.ApplicationFactoryImpl;
import org.apache.myfaces.config.FacesConfigDispenser;
import org.apache.myfaces.config.FacesConfigUnmarshaller;
import org.apache.myfaces.config.RuntimeConfig;
import org.apache.myfaces.config.element.ManagedBean;
import org.apache.myfaces.config.element.NavigationRule;
import org.apache.myfaces.config.element.Renderer;
import org.apache.myfaces.config.impl.digester.DigesterFacesConfigDispenserImpl;
import org.apache.myfaces.config.impl.digester.DigesterFacesConfigUnmarshallerImpl;
import org.apache.myfaces.context.FacesContextFactoryImpl;
import org.apache.myfaces.lifecycle.LifecycleFactoryImpl;
import org.apache.myfaces.renderkit.RenderKitFactoryImpl;
import org.apache.myfaces.renderkit.html.HtmlRenderKitImpl;
import org.apache.myfaces.shared_impl.config.MyfacesConfig;
import org.apache.myfaces.shared_impl.util.ClassUtils;
import org.apache.myfaces.shared_impl.util.LocaleUtils;
import org.apache.myfaces.shared_impl.util.serial.DefaultSerialFactory;
import org.apache.myfaces.shared_impl.util.serial.SerialFactory;
import org.xml.sax.SAXException;

public class FacesConfigurator {
    private static final Log log = LogFactory.getLog((Class)FacesConfigurator.class);
    private static final String STANDARD_FACES_CONFIG_RESOURCE = "org.apache.myfaces.resource".replace('.', '/') + "/standard-faces-config.xml";
    private static final String FACES_CONFIG_RESOURCE = "META-INF/faces-config.xml";
    private static final String META_INF_SERVICES_RESOURCE_PREFIX = "META-INF/services/";
    private static final String DEFAULT_RENDER_KIT_CLASS = HtmlRenderKitImpl.class.getName();
    private static final String DEFAULT_APPLICATION_FACTORY = ApplicationFactoryImpl.class.getName();
    private static final String DEFAULT_FACES_CONTEXT_FACTORY = FacesContextFactoryImpl.class.getName();
    private static final String DEFAULT_LIFECYCLE_FACTORY = LifecycleFactoryImpl.class.getName();
    private static final String DEFAULT_RENDER_KIT_FACTORY = RenderKitFactoryImpl.class.getName();
    private static final String DEFAULT_FACES_CONFIG = "/WEB-INF/faces-config.xml";
    private static final Set FACTORY_NAMES = new HashSet();
    private ExternalContext _externalContext;
    private FacesConfigUnmarshaller _unmarshaller;
    private FacesConfigDispenser _dispenser;
    private static final String JAR_EXTENSION = ".jar";
    private static final String META_INF_MANIFEST_SUFFIX = "!/META-INF/MANIFEST.MF";
    private static final String JAR_PREFIX = "jar:";
    private static long lastUpdate;
    public static final String MYFACES_API_PACKAGE_NAME = "myfaces-api";
    public static final String MYFACES_IMPL_PACKAGE_NAME = "myfaces-impl";
    public static final String MYFACES_TOMAHAWK_PACKAGE_NAME = "tomahawk";
    public static final String MYFACES_TOMAHAWK_SANDBOX_PACKAGE_NAME = "tomahawk-sandbox";
    public static final String MYFACES_TOBAGO_PACKAGE_NAME = "tobago-core";
    public static final String COMMONS_EL_PACKAGE_NAME = "commons-el";
    public static final String JSP_API_PACKAGE_NAME = "jsp-api";

    public FacesConfigurator(ExternalContext externalContext) {
        FACTORY_NAMES.add("javax.faces.application.ApplicationFactory");
        FACTORY_NAMES.add("javax.faces.context.FacesContextFactory");
        FACTORY_NAMES.add("javax.faces.lifecycle.LifecycleFactory");
        FACTORY_NAMES.add("javax.faces.render.RenderKitFactory");
        this._externalContext = externalContext;
    }

    private long getResourceLastModified(String resource) {
        try {
            URL url = this._externalContext.getResource(resource);
            if (url != null) {
                return this.getResourceLastModified(url);
            }
        }
        catch (IOException e) {
            log.error((Object)("Could not read resource " + resource), (Throwable)e);
        }
        return 0L;
    }

    private long getResourceLastModified(URL url) throws IOException {
        if ("file".equals(url.getProtocol())) {
            String externalForm = url.toExternalForm();
            File file = new File(externalForm.substring(5));
            return file.lastModified();
        }
        return this.getResourceLastModified(url.openConnection());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long getResourceLastModified(URLConnection connection) throws IOException {
        long modified;
        if (connection instanceof JarURLConnection) {
            URL jarFileUrl = ((JarURLConnection)connection).getJarFileURL();
            URLConnection jarFileConnection = jarFileUrl.openConnection();
            try {
                modified = jarFileConnection.getLastModified();
            }
            finally {
                try {
                    jarFileConnection.getInputStream().close();
                }
                catch (Exception exception) {}
            }
        }
        modified = connection.getLastModified();
        return modified;
    }

    private long getLastModifiedTime() {
        long lastModified = 0L;
        long resModified = this.getResourceLastModified(DEFAULT_FACES_CONFIG);
        if (resModified > lastModified) {
            lastModified = resModified;
        }
        List configFilesList = this.getConfigFilesList();
        for (int i = 0; i < configFilesList.size(); ++i) {
            String systemId = (String)configFilesList.get(i);
            resModified = this.getResourceLastModified(systemId);
            if (resModified <= lastModified) continue;
            lastModified = resModified;
        }
        return lastModified;
    }

    public void update() {
        long refreshPeriod = MyfacesConfig.getCurrentInstance(this._externalContext).getConfigRefreshPeriod() * 1000L;
        if (refreshPeriod > 0L) {
            long ttl = lastUpdate + refreshPeriod;
            if (System.currentTimeMillis() > ttl && this.getLastModifiedTime() > ttl) {
                log.info((Object)"Faces config-files are being reloaded. If you don't want this reload to happen (e.g. in production), set the web-xml-parameter: org.apache.myfaces.CONFIG_REFRESH_PERIOD to -1.");
                this.purgeConfiguration();
                this.configure();
            }
        }
    }

    private void purgeConfiguration() {
        Method appplicationPurgeMethod = null;
        Method renderKitPurgeMethod = null;
        Method lifecyclePurgeMethod = null;
        Object[] emptyParameterList = new Class[]{};
        ApplicationFactory applicationFactory = (ApplicationFactory)FactoryFinder.getFactory((String)"javax.faces.application.ApplicationFactory");
        RenderKitFactory renderKitFactory = (RenderKitFactory)FactoryFinder.getFactory((String)"javax.faces.render.RenderKitFactory");
        LifecycleFactory lifecycleFactory = (LifecycleFactory)FactoryFinder.getFactory((String)"javax.faces.lifecycle.LifecycleFactory");
        try {
            appplicationPurgeMethod = applicationFactory.getClass().getMethod("purgeApplication", (Class<?>[])emptyParameterList);
            renderKitPurgeMethod = renderKitFactory.getClass().getMethod("purgeRenderKit", (Class<?>[])emptyParameterList);
            lifecyclePurgeMethod = lifecycleFactory.getClass().getMethod("purgeLifecycle", (Class<?>[])emptyParameterList);
        }
        catch (NoSuchMethodException e) {
            log.error((Object)"Configuration objects do not support clean-up. Update aborted", (Throwable)e);
            return;
        }
        if (appplicationPurgeMethod != null && renderKitPurgeMethod != null && lifecyclePurgeMethod != null) {
            try {
                RuntimeConfig.getCurrentInstance(this._externalContext).purge();
                appplicationPurgeMethod.invoke((Object)applicationFactory, emptyParameterList);
                renderKitPurgeMethod.invoke((Object)renderKitFactory, emptyParameterList);
                lifecyclePurgeMethod.invoke((Object)lifecycleFactory, emptyParameterList);
            }
            catch (IllegalAccessException e) {
                log.fatal((Object)("Error during configuration clean-up" + e.getMessage()), (Throwable)e);
            }
            catch (InvocationTargetException e) {
                log.fatal((Object)("Error during configuration clean-up" + e.getMessage()), (Throwable)e);
            }
        }
    }

    public void configure() throws FacesException {
        this._unmarshaller = new DigesterFacesConfigUnmarshallerImpl(this._externalContext);
        this._dispenser = new DigesterFacesConfigDispenserImpl();
        try {
            this.feedStandardConfig();
            this.feedMetaInfServicesFactories();
            this.feedClassloaderConfigurations();
            this.feedContextSpecifiedConfig();
            this.feedWebAppConfig();
            if (log.isInfoEnabled()) {
                this.logMetaInf();
            }
        }
        catch (IOException e) {
            throw new FacesException((Throwable)e);
        }
        catch (SAXException e) {
            throw new FacesException((Throwable)e);
        }
        this.configureFactories();
        this.configureApplication();
        this.configureRenderKits();
        this.configureRuntimeConfig();
        this.configureLifecycle();
        this.handleSerialFactory();
        lastUpdate = System.currentTimeMillis();
    }

    private void feedStandardConfig() throws IOException, SAXException {
        InputStream stream = ClassUtils.getResourceAsStream(STANDARD_FACES_CONFIG_RESOURCE);
        if (stream == null) {
            throw new FacesException("Standard faces config " + STANDARD_FACES_CONFIG_RESOURCE + " not found");
        }
        if (log.isInfoEnabled()) {
            log.info((Object)("Reading standard config " + STANDARD_FACES_CONFIG_RESOURCE));
        }
        this._dispenser.feed(this._unmarshaller.getFacesConfig(stream, STANDARD_FACES_CONFIG_RESOURCE));
        stream.close();
    }

    protected void logMetaInf() {
        try {
            ArrayList<VersionInfo> li = new ArrayList<VersionInfo>();
            li.add(new VersionInfo(MYFACES_API_PACKAGE_NAME));
            li.add(new VersionInfo(MYFACES_IMPL_PACKAGE_NAME));
            li.add(new VersionInfo(MYFACES_TOMAHAWK_SANDBOX_PACKAGE_NAME));
            li.add(new VersionInfo(MYFACES_TOMAHAWK_PACKAGE_NAME));
            li.add(new VersionInfo(MYFACES_TOBAGO_PACKAGE_NAME));
            Iterator it = ClassUtils.getResources("META-INF/MANIFEST.MF", this);
            while (it.hasNext()) {
                VersionInfo versionInfo;
                URL url = (URL)it.next();
                for (int i = 0; i < li.size() && !FacesConfigurator.checkJar(versionInfo = (VersionInfo)li.get(i), url); ++i) {
                }
            }
            for (int i = 0; i < li.size(); ++i) {
                VersionInfo versionInfo = (VersionInfo)li.get(i);
                if (versionInfo.getUsedVersion() != null) {
                    if (!log.isInfoEnabled()) continue;
                    log.info((Object)("Artifact '" + versionInfo.getPackageName() + "' was found in version '" + versionInfo.getUsedVersion() + "' from path '" + versionInfo.getUsedVersionPath() + "'"));
                    continue;
                }
                if (!log.isInfoEnabled()) continue;
                log.info((Object)("Artifact '" + versionInfo.getPackageName() + "' was not found."));
            }
        }
        catch (Throwable e) {
            throw new FacesException(e);
        }
    }

    private static boolean checkJar(VersionInfo versionInfo, URL path) {
        int index;
        String version = versionInfo.getLastVersion();
        String pathString = path.toString();
        if (!pathString.startsWith(JAR_PREFIX)) {
            return false;
        }
        if (pathString.length() <= META_INF_MANIFEST_SUFFIX.length() + JAR_PREFIX.length()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("PathString : " + pathString + " not long enough to be parsed."));
            }
            return false;
        }
        File file = new File(pathString = pathString.substring(JAR_PREFIX.length(), pathString.length() - META_INF_MANIFEST_SUFFIX.length()));
        String fileName = file.getName();
        if (fileName.endsWith(JAR_EXTENSION) && (index = fileName.indexOf(versionInfo.getPackageName())) != -1) {
            int beginIndex = index + versionInfo.getPackageName().length() + 1;
            if (beginIndex > fileName.length() - 1) {
                log.debug((Object)("beginIndex out of bounds. fileName: " + fileName));
                return false;
            }
            int endIndex = fileName.length() - JAR_EXTENSION.length();
            if (endIndex < 0 || endIndex <= beginIndex) {
                log.debug((Object)("endIndex out of bounds. fileName: " + fileName));
                return false;
            }
            String newVersion = fileName.substring(beginIndex, endIndex);
            if (version == null) {
                versionInfo.addJarInfo(pathString, newVersion);
            } else if (version.equals(newVersion)) {
                versionInfo.addJarInfo(pathString, version);
            } else {
                log.error((Object)("You are using the MyFaces-package : " + versionInfo.getPackageName() + " in different versions; first (and probably used) version is : " + versionInfo.getUsedVersion() + ", currently encountered version is : " + newVersion + ". This will cause undesired behaviour. Please clean out your class-path." + " The first encountered version is loaded from : " + versionInfo.getUsedVersionPath() + ". The currently encountered version is loaded from : " + path));
            }
            return true;
        }
        return false;
    }

    protected void feedMetaInfServicesFactories() {
        try {
            Iterator iterator = FACTORY_NAMES.iterator();
            while (iterator.hasNext()) {
                String factoryName = (String)iterator.next();
                Iterator it = ClassUtils.getResources(META_INF_SERVICES_RESOURCE_PREFIX + factoryName, this);
                while (it.hasNext()) {
                    String className;
                    URL url = (URL)it.next();
                    InputStream stream = this.openStreamWithoutCache(url);
                    InputStreamReader isr = new InputStreamReader(stream);
                    BufferedReader br = new BufferedReader(isr);
                    try {
                        className = br.readLine();
                    }
                    catch (IOException e) {
                        throw new FacesException("Unable to read class name from file " + url.toExternalForm(), (Throwable)e);
                    }
                    br.close();
                    isr.close();
                    stream.close();
                    if (log.isInfoEnabled()) {
                        log.info((Object)("Found " + factoryName + " factory implementation: " + className));
                    }
                    if (factoryName.equals("javax.faces.application.ApplicationFactory")) {
                        this._dispenser.feedApplicationFactory(className);
                        continue;
                    }
                    if (factoryName.equals("javax.faces.context.FacesContextFactory")) {
                        this._dispenser.feedFacesContextFactory(className);
                        continue;
                    }
                    if (factoryName.equals("javax.faces.lifecycle.LifecycleFactory")) {
                        this._dispenser.feedLifecycleFactory(className);
                        continue;
                    }
                    if (factoryName.equals("javax.faces.render.RenderKitFactory")) {
                        this._dispenser.feedRenderKitFactory(className);
                        continue;
                    }
                    throw new IllegalStateException("Unexpected factory name " + factoryName);
                }
            }
        }
        catch (Throwable e) {
            throw new FacesException(e);
        }
    }

    private InputStream openStreamWithoutCache(URL url) throws IOException {
        URLConnection connection = url.openConnection();
        connection.setUseCaches(false);
        return connection.getInputStream();
    }

    private void feedClassloaderConfigurations() {
        try {
            Iterator it = ClassUtils.getResources(FACES_CONFIG_RESOURCE, this);
            while (it.hasNext()) {
                URL url = (URL)it.next();
                InputStream stream = this.openStreamWithoutCache(url);
                String systemId = url.toExternalForm();
                if (log.isInfoEnabled()) {
                    log.info((Object)("Reading config " + systemId));
                }
                this._dispenser.feed(this._unmarshaller.getFacesConfig(stream, systemId));
                stream.close();
            }
        }
        catch (Throwable e) {
            throw new FacesException(e);
        }
    }

    private void feedContextSpecifiedConfig() throws IOException, SAXException {
        List configFilesList = this.getConfigFilesList();
        for (int i = 0; i < configFilesList.size(); ++i) {
            String systemId = (String)configFilesList.get(i);
            InputStream stream = this._externalContext.getResourceAsStream(systemId);
            if (stream == null) {
                log.error((Object)("Faces config resource " + systemId + " not found"));
                continue;
            }
            if (log.isInfoEnabled()) {
                log.info((Object)("Reading config " + systemId));
            }
            this._dispenser.feed(this._unmarshaller.getFacesConfig(stream, systemId));
            stream.close();
        }
    }

    private List getConfigFilesList() {
        String configFiles = this._externalContext.getInitParameter("javax.faces.CONFIG_FILES");
        ArrayList<String> configFilesList = new ArrayList<String>();
        if (configFiles != null) {
            StringTokenizer st = new StringTokenizer(configFiles, ",", false);
            while (st.hasMoreTokens()) {
                String systemId = st.nextToken().trim();
                if (DEFAULT_FACES_CONFIG.equals(systemId)) {
                    if (!log.isWarnEnabled()) continue;
                    log.warn((Object)"/WEB-INF/faces-config.xml has been specified in the javax.faces.CONFIG_FILES context parameter of the deployment descriptor. This will automatically be removed, if we wouldn't do this, it would be loaded twice.  See JSF spec 1.1, 10.3.2");
                    continue;
                }
                configFilesList.add(systemId);
            }
        }
        return configFilesList;
    }

    private void feedWebAppConfig() throws IOException, SAXException {
        InputStream stream = this._externalContext.getResourceAsStream(DEFAULT_FACES_CONFIG);
        if (stream != null) {
            if (log.isInfoEnabled()) {
                log.info((Object)"Reading config /WEB-INF/faces-config.xml");
            }
            this._dispenser.feed(this._unmarshaller.getFacesConfig(stream, DEFAULT_FACES_CONFIG));
            stream.close();
        }
    }

    private void configureFactories() {
        this.setFactories("javax.faces.application.ApplicationFactory", this._dispenser.getApplicationFactoryIterator(), DEFAULT_APPLICATION_FACTORY);
        this.setFactories("javax.faces.context.FacesContextFactory", this._dispenser.getFacesContextFactoryIterator(), DEFAULT_FACES_CONTEXT_FACTORY);
        this.setFactories("javax.faces.lifecycle.LifecycleFactory", this._dispenser.getLifecycleFactoryIterator(), DEFAULT_LIFECYCLE_FACTORY);
        this.setFactories("javax.faces.render.RenderKitFactory", this._dispenser.getRenderKitFactoryIterator(), DEFAULT_RENDER_KIT_FACTORY);
    }

    private void setFactories(String factoryName, Iterator factories, String defaultFactory) {
        FactoryFinder.setFactory((String)factoryName, (String)defaultFactory);
        while (factories.hasNext()) {
            FactoryFinder.setFactory((String)factoryName, (String)((String)factories.next()));
        }
    }

    private void configureApplication() {
        Application application = ((ApplicationFactory)FactoryFinder.getFactory((String)"javax.faces.application.ApplicationFactory")).getApplication();
        application.setActionListener((ActionListener)this.getApplicationObject(ActionListener.class, this._dispenser.getActionListenerIterator(), null));
        if (this._dispenser.getDefaultLocale() != null) {
            application.setDefaultLocale(LocaleUtils.toLocale(this._dispenser.getDefaultLocale()));
        }
        if (this._dispenser.getDefaultRenderKitId() != null) {
            application.setDefaultRenderKitId(this._dispenser.getDefaultRenderKitId());
        }
        if (this._dispenser.getMessageBundle() != null) {
            application.setMessageBundle(this._dispenser.getMessageBundle());
        }
        application.setNavigationHandler((NavigationHandler)this.getApplicationObject(NavigationHandler.class, this._dispenser.getNavigationHandlerIterator(), application.getNavigationHandler()));
        application.setPropertyResolver((PropertyResolver)this.getApplicationObject(PropertyResolver.class, this._dispenser.getPropertyResolverIterator(), application.getPropertyResolver()));
        application.setStateManager((StateManager)this.getApplicationObject(StateManager.class, this._dispenser.getStateManagerIterator(), application.getStateManager()));
        ArrayList<Locale> locales = new ArrayList<Locale>();
        Iterator it = this._dispenser.getSupportedLocalesIterator();
        while (it.hasNext()) {
            locales.add(LocaleUtils.toLocale((String)it.next()));
        }
        application.setSupportedLocales(locales);
        application.setVariableResolver((VariableResolver)this.getApplicationObject(VariableResolver.class, this._dispenser.getVariableResolverIterator(), application.getVariableResolver()));
        application.setViewHandler((ViewHandler)this.getApplicationObject(ViewHandler.class, this._dispenser.getViewHandlerIterator(), application.getViewHandler()));
        it = this._dispenser.getComponentTypes();
        while (it.hasNext()) {
            String componentType = (String)it.next();
            application.addComponent(componentType, this._dispenser.getComponentClass(componentType));
        }
        it = this._dispenser.getConverterIds();
        while (it.hasNext()) {
            String converterId = (String)it.next();
            application.addConverter(converterId, this._dispenser.getConverterClassById(converterId));
        }
        it = this._dispenser.getConverterClasses();
        while (it.hasNext()) {
            String converterClass = (String)it.next();
            try {
                application.addConverter(ClassUtils.simpleClassForName(converterClass), this._dispenser.getConverterClassByClass(converterClass));
            }
            catch (Exception ex) {
                log.error((Object)"Converter could not be added. Reason:", (Throwable)ex);
            }
        }
        it = this._dispenser.getValidatorIds();
        while (it.hasNext()) {
            String validatorId = (String)it.next();
            application.addValidator(validatorId, this._dispenser.getValidatorClass(validatorId));
        }
    }

    private Object getApplicationObject(Class interfaceClass, Iterator classNamesIterator, Object defaultObject) {
        Object current = defaultObject;
        while (classNamesIterator.hasNext()) {
            String implClassName = (String)classNamesIterator.next();
            Class implClass = ClassUtils.simpleClassForName(implClassName);
            if (!interfaceClass.isAssignableFrom(implClass)) {
                throw new IllegalArgumentException("Class " + implClassName + " is no " + interfaceClass.getName());
            }
            if (current == null) {
                current = ClassUtils.newInstance(implClass);
                continue;
            }
            try {
                Constructor delegationConstructor = implClass.getConstructor(interfaceClass);
                try {
                    current = delegationConstructor.newInstance(current);
                }
                catch (InstantiationException e) {
                    log.error((Object)e.getMessage(), (Throwable)e);
                    throw new FacesException((Throwable)e);
                }
                catch (IllegalAccessException e) {
                    log.error((Object)e.getMessage(), (Throwable)e);
                    throw new FacesException((Throwable)e);
                }
                catch (InvocationTargetException e) {
                    log.error((Object)e.getMessage(), (Throwable)e);
                    throw new FacesException((Throwable)e);
                }
            }
            catch (NoSuchMethodException e) {
                current = ClassUtils.newInstance(implClass);
            }
        }
        return current;
    }

    private void configureRuntimeConfig() {
        RuntimeConfig runtimeConfig = RuntimeConfig.getCurrentInstance(this._externalContext);
        Iterator iterator = this._dispenser.getManagedBeans();
        while (iterator.hasNext()) {
            ManagedBean bean = (ManagedBean)iterator.next();
            ManagedBean oldBean = runtimeConfig.getManagedBean(bean.getManagedBeanName());
            if (log.isWarnEnabled() && oldBean != null) {
                log.warn((Object)("More than one managed bean w/ the name of '" + bean.getManagedBeanName() + "' registered. First managed bean was registered in :" + oldBean.getConfigLocation() + ", new managed bean was registered in : " + bean.getConfigLocation() + ". The first definition of the managed-bean will be ignored by the standard MyFaces variable resolver!"));
            }
            runtimeConfig.addManagedBean(bean.getManagedBeanName(), bean);
        }
        this.removePurgedBeansFromSessionAndApplication(runtimeConfig);
        iterator = this._dispenser.getNavigationRules();
        while (iterator.hasNext()) {
            NavigationRule rule = (NavigationRule)iterator.next();
            runtimeConfig.addNavigationRule(rule);
        }
        Iterator it = this._dispenser.getConverterConfigurationByClassName();
        while (it.hasNext()) {
            String converterClassName = (String)it.next();
            runtimeConfig.addConverterConfiguration(converterClassName, this._dispenser.getConverterConfiguration(converterClassName));
        }
    }

    private void removePurgedBeansFromSessionAndApplication(RuntimeConfig runtimeConfig) {
        Map oldManagedBeans = runtimeConfig.getManagedBeansNotReaddedAfterPurge();
        if (oldManagedBeans != null) {
            Iterator it = oldManagedBeans.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                ManagedBean bean = (ManagedBean)entry.getValue();
                String scope = bean.getManagedBeanScope();
                if (scope != null && scope.equalsIgnoreCase("session")) {
                    this._externalContext.getSessionMap().remove(entry.getKey());
                    continue;
                }
                if (scope == null || !scope.equalsIgnoreCase("application")) continue;
                this._externalContext.getApplicationMap().remove(entry.getKey());
            }
        }
        runtimeConfig.resetManagedBeansNotReaddedAfterPurge();
    }

    private void configureRenderKits() {
        RenderKitFactory renderKitFactory = (RenderKitFactory)FactoryFinder.getFactory((String)"javax.faces.render.RenderKitFactory");
        Iterator iterator = this._dispenser.getRenderKitIds();
        while (iterator.hasNext()) {
            String renderKitId = (String)iterator.next();
            String renderKitClass = this._dispenser.getRenderKitClass(renderKitId);
            if (renderKitClass == null) {
                renderKitClass = DEFAULT_RENDER_KIT_CLASS;
            }
            RenderKit renderKit = (RenderKit)ClassUtils.newInstance(renderKitClass);
            Iterator renderers = this._dispenser.getRenderers(renderKitId);
            while (renderers.hasNext()) {
                javax.faces.render.Renderer renderer;
                Renderer element = (Renderer)renderers.next();
                try {
                    renderer = (javax.faces.render.Renderer)ClassUtils.newInstance(element.getRendererClass());
                }
                catch (Throwable e) {
                    log.error((Object)("failed to configure class " + element.getRendererClass()), e);
                    continue;
                }
                renderKit.addRenderer(element.getComponentFamily(), element.getRendererType(), renderer);
            }
            renderKitFactory.addRenderKit(renderKitId, renderKit);
        }
    }

    private void configureLifecycle() {
        LifecycleFactory lifecycleFactory = (LifecycleFactory)FactoryFinder.getFactory((String)"javax.faces.lifecycle.LifecycleFactory");
        Lifecycle lifecycle = lifecycleFactory.getLifecycle(this.getLifecycleId());
        Iterator iterator = this._dispenser.getLifecyclePhaseListeners();
        while (iterator.hasNext()) {
            String listenerClassName = (String)iterator.next();
            try {
                lifecycle.addPhaseListener((PhaseListener)ClassUtils.newInstance(listenerClassName));
            }
            catch (ClassCastException e) {
                log.error((Object)("Class " + listenerClassName + " does not implement PhaseListener"), (Throwable)e);
            }
        }
    }

    private String getLifecycleId() {
        String id = this._externalContext.getInitParameter("javax.faces.LIFECYCLE_ID");
        if (id != null) {
            return id;
        }
        return "DEFAULT";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleSerialFactory() {
        String serialProvider = this._externalContext.getInitParameter("org.apache.myfaces.SERIAL_FACTORY");
        SerialFactory serialFactory = null;
        if (serialProvider == null) {
            serialFactory = new DefaultSerialFactory();
        } else {
            try {
                serialFactory = (SerialFactory)ClassUtils.newInstance(serialProvider);
            }
            catch (ClassCastException e) {
                log.error((Object)("Make sure '" + serialProvider + "' implements the correct interface"), (Throwable)e);
            }
            catch (Exception e) {
                log.error((Object)e);
            }
            finally {
                if (serialFactory == null) {
                    serialFactory = new DefaultSerialFactory();
                    log.error((Object)"Using default serialization provider");
                }
            }
        }
        log.info((Object)("Serialization provider : " + serialFactory.getClass()));
        this._externalContext.getApplicationMap().put("org.apache.myfaces.SERIAL_FACTORY", serialFactory);
    }

    public static class JarInfo {
        private String url;
        private String version;

        public JarInfo(String url, String version) {
            this.url = url;
            this.version = version;
        }

        public String getVersion() {
            return this.version;
        }

        public void setVersion(String version) {
            this.version = version;
        }

        public String getUrl() {
            return this.url;
        }

        public void setUrl(String url) {
            this.url = url;
        }
    }

    public static class VersionInfo {
        private String packageName;
        private List jarInfos;

        public VersionInfo(String packageName) {
            this.packageName = packageName;
        }

        public String getPackageName() {
            return this.packageName;
        }

        public void setPackageName(String packageName) {
            this.packageName = packageName;
        }

        public void addJarInfo(String path, String version) {
            if (this.jarInfos == null) {
                this.jarInfos = new ArrayList();
            }
            this.jarInfos.add(new JarInfo(path, version));
        }

        public String getLastVersion() {
            if (this.jarInfos == null) {
                return null;
            }
            if (this.jarInfos.size() == 0) {
                return null;
            }
            return ((JarInfo)this.jarInfos.get(this.jarInfos.size() - 1)).getVersion();
        }

        public String getUsedVersion() {
            if (this.jarInfos == null) {
                return null;
            }
            if (this.jarInfos.size() == 0) {
                return null;
            }
            return ((JarInfo)this.jarInfos.get(0)).getVersion();
        }

        public String getUsedVersionPath() {
            if (this.jarInfos == null) {
                return null;
            }
            if (this.jarInfos.size() == 0) {
                return null;
            }
            return ((JarInfo)this.jarInfos.get(0)).getUrl();
        }
    }
}

