/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.view.facelets.compiler;

import java.util.HashSet;
import java.util.Set;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.event.ExceptionQueuedEvent;
import javax.faces.event.ExceptionQueuedEventContext;
import javax.faces.view.Location;
import org.apache.myfaces.shared.renderkit.RendererUtils;
import org.apache.myfaces.view.facelets.compiler.DuplicateIdException;
import org.apache.myfaces.view.facelets.compiler.UILeaf;

public final class CheckDuplicateIdFaceletUtils {
    public static void checkIdsStatefulComponents(FacesContext context, UIComponent view) {
        CheckDuplicateIdFaceletUtils.checkIdsStatefulComponents(context, view, new HashSet<String>());
    }

    private static void checkIdsStatefulComponents(FacesContext context, UIComponent component, Set<String> existingIds) {
        if (component == null) {
            return;
        }
        String id = component.getClientId(context);
        if (!existingIds.add(id)) {
            DuplicateIdException duplicateIdException = CheckDuplicateIdFaceletUtils.createAndQueueException(context, component, id);
            throw duplicateIdException;
        }
        int facetCount = component.getFacetCount();
        if (facetCount > 0) {
            for (UIComponent facet : component.getFacets().values()) {
                if (facet instanceof UILeaf) continue;
                CheckDuplicateIdFaceletUtils.checkIdsStatefulComponents(context, facet, existingIds);
            }
        }
        int childCount = component.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            UIComponent child = component.getChildren().get(i);
            if (child instanceof UILeaf) continue;
            CheckDuplicateIdFaceletUtils.checkIdsStatefulComponents(context, child, existingIds);
        }
    }

    public static void checkIds(FacesContext context, UIComponent view) {
        CheckDuplicateIdFaceletUtils.checkIds(context, view, new HashSet<String>());
    }

    private static void checkIds(FacesContext context, UIComponent component, Set<String> existingIds) {
        if (component == null) {
            return;
        }
        String id = component.getClientId(context);
        if (!existingIds.add(id)) {
            DuplicateIdException duplicateIdException = CheckDuplicateIdFaceletUtils.createAndQueueException(context, component, id);
            throw duplicateIdException;
        }
        int facetCount = component.getFacetCount();
        if (facetCount > 0) {
            for (UIComponent facet : component.getFacets().values()) {
                CheckDuplicateIdFaceletUtils.checkIds(context, facet, existingIds);
            }
        }
        int childCount = component.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            UIComponent child = component.getChildren().get(i);
            CheckDuplicateIdFaceletUtils.checkIds(context, child, existingIds);
        }
    }

    private static DuplicateIdException createAndQueueException(FacesContext context, UIComponent component, String id) {
        String message = "Component with duplicate id \"" + id + "\" found. The first component is ";
        UIComponent firstComponent = context.getViewRoot().findComponent(id);
        Location location = (Location)firstComponent.getAttributes().get("javax.faces.component.VIEW_LOCATION_KEY");
        message = location != null ? message + location.toString() : message + RendererUtils.getPathToComponent(firstComponent);
        DuplicateIdException duplicateIdException = new DuplicateIdException(message, firstComponent, component);
        ExceptionQueuedEventContext exceptionContext = new ExceptionQueuedEventContext(context, duplicateIdException, component, context.getCurrentPhaseId());
        context.getApplication().publishEvent(context, ExceptionQueuedEvent.class, exceptionContext);
        return duplicateIdException;
    }
}

