/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.view.impl;

import jakarta.faces.context.ExternalContext;
import jakarta.faces.context.FacesContext;
import java.math.BigInteger;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.myfaces.config.ManagedBeanDestroyer;
import org.apache.myfaces.config.RuntimeConfig;
import org.apache.myfaces.config.annotation.LifecycleProvider;
import org.apache.myfaces.config.annotation.LifecycleProviderFactory;
import org.apache.myfaces.shared.util.SubKeyMap;
import org.apache.myfaces.spi.ViewScopeProvider;

public class DefaultViewScopeHandler
extends ViewScopeProvider {
    private static final String VIEW_SCOPE_PREFIX = "oam.view.SCOPE";
    private static final String VIEW_SCOPE_PREFIX_KEY = "oam.view.SCOPE.KEY";
    private static final String VIEW_SCOPE_PREFIX_MAP = "oam.view.SCOPE.MAP";
    static final char SEPARATOR_CHAR = '.';
    private final AtomicLong _count = new AtomicLong(DefaultViewScopeHandler._getSeed());
    private ManagedBeanDestroyer _mbDestroyer;

    private static long _getSeed() {
        SecureRandom rng;
        try {
            rng = SecureRandom.getInstance("SHA1PRNG");
        }
        catch (NoSuchAlgorithmException e) {
            rng = new SecureRandom();
        }
        byte[] randomBytes = new byte[6];
        rng.nextBytes(randomBytes);
        return new BigInteger(randomBytes).longValue();
    }

    private String _getNextToken() {
        long nextToken = this._count.incrementAndGet();
        return Long.toString(nextToken, 36);
    }

    @Override
    public void onSessionDestroyed() {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        if (facesContext.getExternalContext().getSession(false) != null) {
            ExternalContext external = facesContext.getExternalContext();
            Map<String, Object> sessionMap = external.getSessionMap();
            String prefix = "oam.view.SCOPE.MAP.";
            HashSet<String> viewScopeIdSet = new HashSet<String>();
            for (Map.Entry<String, Object> entry : sessionMap.entrySet()) {
                if (entry.getKey() == null || !entry.getKey().startsWith(prefix)) continue;
                String viewScopeId = entry.getKey().substring(prefix.length(), entry.getKey().indexOf(46, prefix.length()));
                viewScopeIdSet.add(viewScopeId);
            }
            if (!viewScopeIdSet.isEmpty()) {
                for (String viewScopeId : viewScopeIdSet) {
                    this.destroyViewScopeMap(facesContext, viewScopeId);
                }
            }
        }
    }

    @Override
    public Map<String, Object> createViewScopeMap(FacesContext facesContext, String viewScopeId) {
        String fullToken = "oam.view.SCOPE.MAP." + viewScopeId + '.';
        Map<String, Object> map = this._createSubKeyMap(facesContext, fullToken);
        return map;
    }

    @Override
    public Map<String, Object> restoreViewScopeMap(FacesContext facesContext, String viewScopeId) {
        String fullToken = "oam.view.SCOPE.MAP." + viewScopeId + '.';
        Map<String, Object> map = this._createSubKeyMap(facesContext, fullToken);
        return map;
    }

    private Map<String, Object> _createSubKeyMap(FacesContext context, String prefix) {
        ExternalContext external = context.getExternalContext();
        Map<String, Object> sessionMap = external.getSessionMap();
        return new SubKeyMap<Object>(sessionMap, prefix);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String generateViewScopeId(FacesContext facesContext) {
        ExternalContext externalContext = facesContext.getExternalContext();
        Object sessionObj = externalContext.getSession(true);
        Integer sequence = null;
        Object object = sessionObj;
        synchronized (object) {
            Map<String, Object> map = externalContext.getSessionMap();
            sequence = (Integer)map.get(VIEW_SCOPE_PREFIX_KEY);
            sequence = sequence == null || sequence == Integer.MAX_VALUE ? Integer.valueOf(1) : Integer.valueOf(sequence);
            map.put(VIEW_SCOPE_PREFIX_KEY, sequence);
        }
        return this._getNextToken() + '_' + sequence.toString();
    }

    @Override
    public void destroyViewScopeMap(FacesContext facesContext, String viewScopeId) {
        if (facesContext.getExternalContext().getSession(false) != null) {
            String fullToken = "oam.view.SCOPE.MAP." + viewScopeId + '.';
            Map<String, Object> map = this._createSubKeyMap(facesContext, fullToken);
            ManagedBeanDestroyer mbDestroyer = this.getManagedBeanDestroyer(facesContext.getExternalContext());
            for (Map.Entry<String, Object> entry : map.entrySet()) {
                mbDestroyer.destroy(entry.getKey(), entry.getValue());
            }
            map.clear();
        }
    }

    protected ManagedBeanDestroyer getManagedBeanDestroyer(ExternalContext externalContext) {
        if (this._mbDestroyer == null) {
            RuntimeConfig runtimeConfig = RuntimeConfig.getCurrentInstance(externalContext);
            LifecycleProvider lifecycleProvider = LifecycleProviderFactory.getLifecycleProviderFactory(externalContext).getLifecycleProvider(externalContext);
            this._mbDestroyer = new ManagedBeanDestroyer(lifecycleProvider, runtimeConfig);
        }
        return this._mbDestroyer;
    }
}

