/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.extensions.validator.core;

import java.io.Serializable;
import java.util.Comparator;
import org.apache.myfaces.extensions.validator.core.InvocationOrder;
import org.apache.myfaces.extensions.validator.internal.UsageCategory;
import org.apache.myfaces.extensions.validator.internal.UsageInformation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@UsageInformation(value={UsageCategory.INTERNAL})
public class InvocationOrderComparator<T>
implements Comparator<T>,
Serializable {
    private static final long serialVersionUID = 2287258656373616584L;

    @Override
    public int compare(T nm1, T nm2) {
        if (this.hasPriority(nm1) && this.hasPriority(nm2)) {
            return this.isPriorityHigher(nm1.getClass().getAnnotation(InvocationOrder.class), nm2.getClass().getAnnotation(InvocationOrder.class));
        }
        if (!this.hasPriority(nm1) && !this.hasPriority(nm2)) {
            return 0;
        }
        return this.hasPriority(nm1) ? -1 : 1;
    }

    private int isPriorityHigher(InvocationOrder priority1, InvocationOrder priority2) {
        if (priority1.value() == priority2.value()) {
            return 0;
        }
        return priority1.value() < priority2.value() ? -1 : 1;
    }

    private boolean hasPriority(Object nm) {
        return nm.getClass().isAnnotationPresent(InvocationOrder.class);
    }
}

