/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.extensions.validator.core.renderkit;

import java.util.logging.Logger;
import javax.faces.event.ListenerFor;
import javax.faces.event.ListenersFor;
import javax.faces.render.RenderKit;
import javax.faces.render.RenderKitWrapper;
import javax.faces.render.Renderer;
import org.apache.myfaces.extensions.validator.core.renderkit.ExtValRendererWrapper;
import org.apache.myfaces.extensions.validator.internal.Priority;
import org.apache.myfaces.extensions.validator.internal.ToDo;
import org.apache.myfaces.extensions.validator.internal.UsageCategory;
import org.apache.myfaces.extensions.validator.internal.UsageInformation;

@UsageInformation(value={UsageCategory.INTERNAL})
public class ExtValRenderKit
extends RenderKitWrapper {
    protected final Logger logger = Logger.getLogger(((Object)((Object)this)).getClass().getName());
    protected RenderKit wrapped;

    public ExtValRenderKit(RenderKit wrapped) {
        this.wrapped = wrapped;
        this.logger.fine(((Object)((Object)this)).getClass().getName() + " instantiated");
    }

    public void addRenderer(String family, String rendererType, Renderer renderer) {
        if (renderer instanceof ExtValRendererWrapper) {
            this.wrapped.addRenderer(family, rendererType, renderer);
        } else {
            this.wrapped.addRenderer(family, rendererType, this.createWrapper(renderer));
        }
    }

    public Renderer getRenderer(String family, String rendererType) {
        Renderer renderer = this.wrapped.getRenderer(family, rendererType);
        if (renderer != null) {
            return renderer instanceof ExtValRendererWrapper ? renderer : this.createWrapper(renderer);
        }
        return renderer;
    }

    @UsageInformation(value={UsageCategory.REUSE})
    @ToDo(value=Priority.HIGH, description="log warning + hint that a (generic) component support module is needed")
    protected Renderer createWrapper(Renderer renderer) {
        if (renderer == null) {
            return null;
        }
        if (renderer.getClass().isAnnotationPresent(ListenerFor.class) || renderer.getClass().isAnnotationPresent(ListenersFor.class)) {
            return renderer;
        }
        return new ExtValRendererWrapper(renderer);
    }

    public RenderKit getWrapped() {
        return this.wrapped;
    }
}

