/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.extensions.validator.core.startup;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.event.PhaseEvent;
import javax.faces.event.PhaseId;
import javax.faces.event.PhaseListener;
import org.apache.myfaces.extensions.validator.core.ExtValContext;
import org.apache.myfaces.extensions.validator.core.ExtValCoreConfiguration;
import org.apache.myfaces.extensions.validator.core.ProjectStageResolver;
import org.apache.myfaces.extensions.validator.internal.Priority;
import org.apache.myfaces.extensions.validator.internal.ToDo;
import org.apache.myfaces.extensions.validator.internal.UsageCategory;
import org.apache.myfaces.extensions.validator.internal.UsageInformation;
import org.apache.myfaces.extensions.validator.util.ExtValUtils;
import org.apache.myfaces.extensions.validator.util.JsfUtils;
import org.apache.myfaces.extensions.validator.util.WebXmlUtils;

@UsageInformation(value={UsageCategory.REUSE})
public abstract class AbstractStartupListener
implements PhaseListener {
    protected final Logger logger = Logger.getLogger(this.getClass().getName());
    private static List<Class> initializedListeners = new ArrayList<Class>();
    private static boolean defaultProjectStageResolverInitialized = false;

    protected AbstractStartupListener() {
        this.logger.fine(this.getClass().getName() + " instantiated");
    }

    public void afterPhase(PhaseEvent event) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void beforePhase(PhaseEvent event) {
        Class<AbstractStartupListener> clazz = AbstractStartupListener.class;
        synchronized (AbstractStartupListener.class) {
            if (!initializedListeners.contains(this.getClass())) {
                try {
                    this.logger.info("start init of " + this.getClass().getName());
                    try {
                        if (!this.isStartupListenerDeactivated()) {
                            this.initModuleConfig();
                            this.initProjectStageResolver();
                            this.init();
                        } else {
                            this.logger.info("init of " + this.getClass().getName() + " deactivated");
                        }
                        this.logger.info("init of " + this.getClass().getName() + " finished");
                    }
                    finally {
                        JsfUtils.deregisterPhaseListener(this);
                    }
                }
                catch (Exception e) {
                    this.logger.log(Level.WARNING, "an exception occurred while deregistering the phase-listener" + this.getClass().getName() + " -> there is just a little overhead," + " but everything else works correctly." + " however, please inform the community about your configuration", e);
                }
                finally {
                    initializedListeners.add(this.getClass());
                }
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    protected void initModuleConfig() {
    }

    public PhaseId getPhaseId() {
        return PhaseId.RESTORE_VIEW;
    }

    protected boolean isStartupListenerDeactivated() {
        return ExtValUtils.isExtValDeactivated() || "true".equalsIgnoreCase(WebXmlUtils.getInitParameter(null, this.getClass().getName() + ":DEACTIVATED"));
    }

    @ToDo(value=Priority.LOW, description="ProjectStage#getCurrentProjectStage is using the config and not the globalproperty. align.")
    protected void initProjectStageResolver() {
        if (!defaultProjectStageResolverInitialized) {
            ExtValContext.getContext().addGlobalProperty(ProjectStageResolver.class.getName(), this.getProjectStageResolver(), false);
            defaultProjectStageResolverInitialized = true;
        }
    }

    protected ProjectStageResolver getProjectStageResolver() {
        return ExtValCoreConfiguration.get().projectStageResolver();
    }

    protected abstract void init();
}

