/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.orchestra.viewController;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.myfaces.orchestra.annotation.AnnotationInfo;
import org.apache.myfaces.orchestra.annotation.AnnotationInfoManager;
import org.apache.myfaces.orchestra.lib.OrchestraException;
import org.apache.myfaces.orchestra.viewController.AbstractViewControllerExecutor;

public class AnnotationsViewControllerExecutor
extends AbstractViewControllerExecutor {
    private final AnnotationInfoManager annotationInfoManager;

    public AnnotationsViewControllerExecutor(AnnotationInfoManager annotationInfoManager) {
        this.annotationInfoManager = annotationInfoManager;
    }

    protected void invokeMethod(Object bean, Method method) {
        try {
            method.invoke(bean, (Object[])null);
        }
        catch (IllegalAccessException e) {
            throw new OrchestraException(e);
        }
        catch (InvocationTargetException e) {
            throw new OrchestraException(e);
        }
    }

    public boolean invokeInitView(String beanName, Object bean) {
        Method method;
        AnnotationInfo annotationsInfo = this.annotationInfoManager.getAnnotationInfoByBeanName(beanName);
        if (annotationsInfo != null && (method = annotationsInfo.getInitViewMethod()) != null) {
            this.invokeMethod(bean, method);
            return true;
        }
        return false;
    }

    public boolean invokePreRenderView(String beanName, Object bean) {
        Method method;
        AnnotationInfo annotationsInfo = this.annotationInfoManager.getAnnotationInfoByBeanName(beanName);
        if (annotationsInfo != null && (method = annotationsInfo.getPreRenderViewMethod()) != null) {
            this.invokeMethod(bean, method);
            return true;
        }
        return false;
    }

    public boolean invokePreProcess(String beanName, Object bean) {
        Method method;
        AnnotationInfo annotationsInfo = this.annotationInfoManager.getAnnotationInfoByBeanName(beanName);
        if (annotationsInfo != null && (method = annotationsInfo.getPreProcessMethod()) != null) {
            this.invokeMethod(bean, method);
            return true;
        }
        return false;
    }
}

