/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.internal.renderkit.renderer;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import org.apache.myfaces.tobago.component.Facets;
import org.apache.myfaces.tobago.component.RendererTypes;
import org.apache.myfaces.tobago.context.Markup;
import org.apache.myfaces.tobago.internal.component.AbstractUIBar;
import org.apache.myfaces.tobago.internal.component.AbstractUIForm;
import org.apache.myfaces.tobago.internal.component.AbstractUILinks;
import org.apache.myfaces.tobago.internal.util.HtmlRendererUtils;
import org.apache.myfaces.tobago.internal.util.JsonUtils;
import org.apache.myfaces.tobago.renderkit.RendererBase;
import org.apache.myfaces.tobago.renderkit.css.BootstrapClass;
import org.apache.myfaces.tobago.renderkit.css.CssItem;
import org.apache.myfaces.tobago.renderkit.css.TobagoClass;
import org.apache.myfaces.tobago.renderkit.html.Arias;
import org.apache.myfaces.tobago.renderkit.html.DataAttributes;
import org.apache.myfaces.tobago.renderkit.html.HtmlAttributes;
import org.apache.myfaces.tobago.renderkit.html.HtmlButtonTypes;
import org.apache.myfaces.tobago.renderkit.html.HtmlElements;
import org.apache.myfaces.tobago.renderkit.html.HtmlRoleValues;
import org.apache.myfaces.tobago.renderkit.html.MarkupLanguageAttributes;
import org.apache.myfaces.tobago.util.ComponentUtils;
import org.apache.myfaces.tobago.webapp.TobagoResponseWriter;

public class BarRenderer
extends RendererBase {
    public void encodeBegin(FacesContext facesContext, UIComponent component) throws IOException {
        AbstractUIBar bar = (AbstractUIBar)component;
        TobagoResponseWriter writer = this.getResponseWriter(facesContext);
        String clientId = bar.getClientId(facesContext);
        String navbarId = clientId + "::navbar";
        Markup markup = bar.getMarkup();
        writer.startElement(HtmlElements.NAV);
        writer.writeIdAttribute(clientId);
        writer.writeAttribute(DataAttributes.MARKUP, JsonUtils.encode(markup), false);
        writer.writeClassAttribute((CssItem)TobagoClass.BAR, TobagoClass.BAR.createMarkup(bar.getMarkup()), new CssItem[]{BootstrapClass.NAVBAR, this.getNavbarExpand(markup), this.getNavbarColorScheme(markup), bar.getCustomClass()});
        writer.writeAttribute(HtmlAttributes.ROLE, HtmlRoleValues.NAVIGATION.toString(), false);
        HtmlRendererUtils.writeDataAttributes(facesContext, writer, (UIComponent)bar);
        this.encodeOpener(facesContext, bar, writer, navbarId);
        writer.startElement(HtmlElements.DIV);
        writer.writeIdAttribute(navbarId);
        writer.writeClassAttribute(BootstrapClass.COLLAPSE, BootstrapClass.NAVBAR_COLLAPSE, BootstrapClass.ALIGN_ITEMS_CENTER);
    }

    private BootstrapClass getNavbarExpand(Markup markup) {
        if (markup != null) {
            if (markup.contains(Markup.EXTRA_LARGE)) {
                return BootstrapClass.NAVBAR_EXPAND_XL;
            }
            if (markup.contains(Markup.LARGE)) {
                return BootstrapClass.NAVBAR_EXPAND_LG;
            }
            if (markup.contains(Markup.MEDIUM)) {
                return BootstrapClass.NAVBAR_EXPAND_MD;
            }
            if (markup.contains(Markup.SMALL)) {
                return BootstrapClass.NAVBAR_EXPAND_SM;
            }
        }
        return BootstrapClass.NAVBAR_EXPAND;
    }

    private BootstrapClass getNavbarColorScheme(Markup markup) {
        if (markup != null) {
            if (markup.contains(Markup.DARK)) {
                return BootstrapClass.NAVBAR_DARK;
            }
            if (markup.contains(Markup.LIGHT)) {
                return BootstrapClass.NAVBAR_LIGHT;
            }
        }
        return null;
    }

    public boolean getRendersChildren() {
        return true;
    }

    public void encodeChildren(FacesContext facesContext, UIComponent component) throws IOException {
        this.setRenderTypes(component);
        for (UIComponent child : component.getChildren()) {
            child.encodeAll(facesContext);
        }
    }

    private void setRenderTypes(UIComponent component) throws IOException {
        for (UIComponent child : component.getChildren()) {
            if (!child.isRendered()) continue;
            if (child instanceof AbstractUIForm) {
                this.setRenderTypes(child);
                continue;
            }
            if (!(child instanceof AbstractUILinks)) continue;
            child.setRendererType(RendererTypes.LinksInsideBar.name());
        }
    }

    public void encodeEnd(FacesContext facesContext, UIComponent component) throws IOException {
        AbstractUIBar bar = (AbstractUIBar)component;
        TobagoResponseWriter writer = this.getResponseWriter(facesContext);
        UIComponent after = ComponentUtils.getFacet((UIComponent)bar, Facets.after);
        if (after != null) {
            writer.startElement(HtmlElements.DIV);
            writer.writeClassAttribute(BootstrapClass.MY_LG_0, BootstrapClass.ML_AUTO);
            this.setRenderTypes(after);
            after.encodeAll(facesContext);
            writer.endElement(HtmlElements.DIV);
        }
        writer.endElement(HtmlElements.DIV);
        writer.endElement(HtmlElements.NAV);
    }

    private void encodeOpener(FacesContext facesContext, AbstractUIBar bar, TobagoResponseWriter writer, String navbarId) throws IOException {
        boolean togglerLeft = bar.getMarkup() != null && bar.getMarkup().contains(Markup.TOGGLER_LEFT);
        UIComponent brand = ComponentUtils.getFacet((UIComponent)bar, Facets.brand);
        String escapedNavbarId = navbarId.replace(":", "\\:");
        if (brand != null && !togglerLeft) {
            writer.startElement(HtmlElements.SPAN);
            writer.writeClassAttribute(BootstrapClass.NAVBAR_BRAND);
            brand.encodeAll(facesContext);
            writer.endElement(HtmlElements.SPAN);
        }
        writer.startElement(HtmlElements.BUTTON);
        writer.writeAttribute((MarkupLanguageAttributes)HtmlAttributes.TYPE, HtmlButtonTypes.BUTTON);
        writer.writeClassAttribute(BootstrapClass.NAVBAR_TOGGLER);
        writer.writeAttribute(DataAttributes.TOGGLE, "collapse", false);
        writer.writeAttribute(DataAttributes.TARGET, "#" + escapedNavbarId, true);
        writer.writeAttribute(Arias.EXPANDED, Boolean.FALSE.toString(), false);
        writer.writeAttribute(Arias.CONTROLS, navbarId, false);
        writer.writeAttribute(Arias.LABEL, "Toggle navigation", false);
        writer.startElement(HtmlElements.SPAN);
        writer.writeClassAttribute(BootstrapClass.NAVBAR_TOGGLER_ICON);
        writer.endElement(HtmlElements.SPAN);
        writer.endElement(HtmlElements.BUTTON);
        if (brand != null && togglerLeft) {
            writer.startElement(HtmlElements.SPAN);
            writer.writeClassAttribute(BootstrapClass.NAVBAR_BRAND);
            brand.encodeAll(facesContext);
            writer.endElement(HtmlElements.SPAN);
        }
    }
}

