/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.internal.renderkit.renderer;

import java.io.IOException;
import javax.faces.context.FacesContext;
import org.apache.myfaces.tobago.internal.component.AbstractUICommand;
import org.apache.myfaces.tobago.internal.renderkit.renderer.LinkRenderer;
import org.apache.myfaces.tobago.internal.util.JsonUtils;
import org.apache.myfaces.tobago.renderkit.css.BootstrapClass;
import org.apache.myfaces.tobago.renderkit.css.CssItem;
import org.apache.myfaces.tobago.renderkit.html.DataAttributes;
import org.apache.myfaces.tobago.renderkit.html.HtmlElements;
import org.apache.myfaces.tobago.webapp.TobagoResponseWriter;

public class LinkInsideLinksRenderer
extends LinkRenderer {
    @Override
    protected void encodeBeginOuter(FacesContext facesContext, AbstractUICommand command) throws IOException {
        String clientId = command.getClientId(facesContext);
        boolean parentOfCommands = command.isParentOfCommands();
        TobagoResponseWriter writer = this.getResponseWriter(facesContext);
        writer.startElement(HtmlElements.LI);
        if (parentOfCommands) {
            writer.writeIdAttribute(clientId);
            writer.writeAttribute(DataAttributes.MARKUP, JsonUtils.encode(command.getMarkup()), false);
        }
        writer.writeClassAttribute(BootstrapClass.NAV_ITEM, parentOfCommands ? BootstrapClass.DROPDOWN : null);
    }

    @Override
    protected void encodeEndOuter(FacesContext facesContext, AbstractUICommand command) throws IOException {
        TobagoResponseWriter writer = this.getResponseWriter(facesContext);
        writer.endElement(HtmlElements.LI);
    }

    @Override
    protected CssItem[] getCssItems(FacesContext facesContext, AbstractUICommand command) {
        return new CssItem[]{BootstrapClass.NAV_LINK};
    }
}

