/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.internal.renderkit.renderer;

import java.io.IOException;
import java.util.List;
import javax.faces.application.FacesMessage;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import org.apache.myfaces.tobago.component.LabelLayout;
import org.apache.myfaces.tobago.component.SupportsHelp;
import org.apache.myfaces.tobago.component.SupportsLabelLayout;
import org.apache.myfaces.tobago.context.TobagoResourceBundle;
import org.apache.myfaces.tobago.internal.renderkit.renderer.LabelLayoutRendererBase;
import org.apache.myfaces.tobago.internal.util.StringUtils;
import org.apache.myfaces.tobago.renderkit.css.BootstrapClass;
import org.apache.myfaces.tobago.renderkit.css.Icons;
import org.apache.myfaces.tobago.renderkit.css.TobagoClass;
import org.apache.myfaces.tobago.renderkit.html.DataAttributes;
import org.apache.myfaces.tobago.renderkit.html.HtmlAttributes;
import org.apache.myfaces.tobago.renderkit.html.HtmlButtonTypes;
import org.apache.myfaces.tobago.renderkit.html.HtmlElements;
import org.apache.myfaces.tobago.renderkit.html.MarkupLanguageAttributes;
import org.apache.myfaces.tobago.util.ComponentUtils;
import org.apache.myfaces.tobago.webapp.TobagoResponseWriter;

public abstract class MessageLayoutRendererBase
extends LabelLayoutRendererBase {
    @Override
    public void encodeBeginMessageField(FacesContext facesContext, UIComponent component) throws IOException {
        LabelLayout labelLayout = ((SupportsLabelLayout)component).getLabelLayout();
        LabelLayout segment = LabelLayout.getSegment(facesContext);
        if (labelLayout == LabelLayout.segmentLeft && segment != LabelLayout.segmentRight || labelLayout == LabelLayout.segmentRight && segment != LabelLayout.segmentLeft) {
            return;
        }
        this.encodeBeginMessagesContainer(facesContext, component);
        this.encodeBeginField(facesContext, component);
    }

    @Override
    public void encodeEndMessageField(FacesContext facesContext, UIComponent component) throws IOException {
        LabelLayout labelLayout = ((SupportsLabelLayout)component).getLabelLayout();
        LabelLayout segment = LabelLayout.getSegment(facesContext);
        if (labelLayout == LabelLayout.segmentLeft && segment != LabelLayout.segmentRight || labelLayout == LabelLayout.segmentRight && segment != LabelLayout.segmentLeft) {
            return;
        }
        this.encodeEndField(facesContext, component);
        this.encodeEndMessagesContainer(facesContext, component);
    }

    private void encodeBeginMessagesContainer(FacesContext facesContext, UIComponent component) throws IOException {
        boolean hasHelp;
        TobagoResponseWriter writer = this.getResponseWriter(facesContext);
        String clientId = component.getClientId();
        List messages = facesContext.getMessageList(clientId);
        String help = component instanceof SupportsHelp ? ((SupportsHelp)component).getHelp() : null;
        boolean hasMessage = !messages.isEmpty();
        boolean bl = hasHelp = !StringUtils.isEmpty(help);
        if (hasMessage || hasHelp) {
            writer.startElement(HtmlElements.DIV);
            writer.writeClassAttribute(TobagoClass.MESSAGES__CONTAINER, TobagoClass.FLEX_LAYOUT, BootstrapClass.D_FLEX);
        }
    }

    private void encodeEndMessagesContainer(FacesContext facesContext, UIComponent component) throws IOException {
        boolean hasHelp;
        TobagoResponseWriter writer = this.getResponseWriter(facesContext);
        String clientId = component.getClientId();
        List messages = facesContext.getMessageList(clientId);
        String help = component instanceof SupportsHelp ? ((SupportsHelp)component).getHelp() : null;
        boolean hasMessage = !messages.isEmpty();
        boolean bl = hasHelp = !StringUtils.isEmpty(help);
        if (hasMessage || hasHelp) {
            if (hasMessage) {
                this.encodeFacesMessagesButton(writer, messages);
            }
            if (hasHelp) {
                this.encodeHelpButton(facesContext, writer, help);
            }
            writer.endElement(HtmlElements.DIV);
        }
    }

    protected abstract void encodeBeginField(FacesContext var1, UIComponent var2) throws IOException;

    protected abstract void encodeEndField(FacesContext var1, UIComponent var2) throws IOException;

    private void encodeFacesMessagesButton(TobagoResponseWriter writer, List<FacesMessage> messages) throws IOException {
        writer.startElement(HtmlElements.A);
        writer.writeAttribute(HtmlAttributes.TABINDEX, "0", false);
        writer.writeAttribute((MarkupLanguageAttributes)HtmlAttributes.ROLE, HtmlButtonTypes.BUTTON);
        writer.writeClassAttribute(TobagoClass.MESSAGES__BUTTON, BootstrapClass.BTN, BootstrapClass.buttonColor(ComponentUtils.getMaximumSeverity(messages)));
        writer.writeAttribute(DataAttributes.TOGGLE, "popover", false);
        writer.writeAttribute(DataAttributes.TITLE, this.getTitle(messages), true);
        writer.writeAttribute(DataAttributes.CONTENT, this.getMessage(messages), true);
        writer.startElement(HtmlElements.I);
        writer.writeClassAttribute(Icons.FA, Icons.EXCLAMATION);
        writer.endElement(HtmlElements.I);
        writer.endElement(HtmlElements.A);
    }

    private String getTitle(List<FacesMessage> messages) {
        int fatalCount = 0;
        int errorCount = 0;
        int warningCount = 0;
        int informationCount = 0;
        for (FacesMessage message : messages) {
            if (FacesMessage.SEVERITY_FATAL.equals(message.getSeverity())) {
                ++fatalCount;
                continue;
            }
            if (FacesMessage.SEVERITY_ERROR.equals(message.getSeverity())) {
                ++errorCount;
                continue;
            }
            if (FacesMessage.SEVERITY_WARN.equals(message.getSeverity())) {
                ++warningCount;
                continue;
            }
            if (!FacesMessage.SEVERITY_INFO.equals(message.getSeverity())) continue;
            ++informationCount;
        }
        StringBuilder stringBuilder = new StringBuilder();
        if (messages.size() > 1) {
            if (fatalCount > 0) {
                stringBuilder.append(fatalCount);
                stringBuilder.append(" Fatal");
                if (errorCount + warningCount + informationCount > 0) {
                    stringBuilder.append(", ");
                }
            }
            if (errorCount > 0) {
                stringBuilder.append(errorCount);
                stringBuilder.append(" Error");
                if (errorCount > 1) {
                    stringBuilder.append("s");
                }
                if (warningCount + informationCount > 0) {
                    stringBuilder.append(", ");
                }
            }
            if (warningCount > 0) {
                stringBuilder.append(warningCount);
                stringBuilder.append(" Warning");
                if (warningCount > 1) {
                    stringBuilder.append("s");
                }
                if (informationCount > 0) {
                    stringBuilder.append(", ");
                }
            }
            if (informationCount > 0) {
                stringBuilder.append(informationCount);
                stringBuilder.append(" Information");
            }
        } else if (fatalCount == 1) {
            stringBuilder.append("Fatal");
        } else if (errorCount == 1) {
            stringBuilder.append("Error");
        } else if (warningCount == 1) {
            stringBuilder.append("Warning");
        } else if (informationCount == 1) {
            stringBuilder.append("Information");
        }
        return stringBuilder.toString();
    }

    private String getMessage(List<FacesMessage> messages) {
        StringBuilder stringBuilder = new StringBuilder();
        boolean firstMessage = true;
        for (FacesMessage message : messages) {
            if (firstMessage) {
                firstMessage = false;
            } else {
                stringBuilder.append("\n\n");
            }
            stringBuilder.append(message.getDetail());
        }
        return stringBuilder.toString();
    }

    private void encodeHelpButton(FacesContext facesContext, TobagoResponseWriter writer, String help) throws IOException {
        writer.startElement(HtmlElements.A);
        writer.writeAttribute(HtmlAttributes.TABINDEX, "0", false);
        writer.writeAttribute((MarkupLanguageAttributes)HtmlAttributes.ROLE, HtmlButtonTypes.BUTTON);
        writer.writeClassAttribute(TobagoClass.HELP__BUTTON, BootstrapClass.BTN, BootstrapClass.BTN_OUTLINE_INFO);
        writer.writeAttribute(DataAttributes.TOGGLE, "popover", false);
        writer.writeAttribute(HtmlAttributes.TITLE, TobagoResourceBundle.getString(facesContext, "helpTitle"), true);
        writer.writeAttribute(DataAttributes.CONTENT, help, true);
        writer.startElement(HtmlElements.I);
        writer.writeClassAttribute(Icons.FA, Icons.QUESTION);
        writer.endElement(HtmlElements.I);
        writer.endElement(HtmlElements.A);
    }
}

