/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.internal.renderkit.renderer;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.component.UINamingContainer;
import javax.faces.context.FacesContext;
import org.apache.myfaces.tobago.context.Markup;
import org.apache.myfaces.tobago.internal.component.AbstractUIData;
import org.apache.myfaces.tobago.internal.component.AbstractUITreeListbox;
import org.apache.myfaces.tobago.internal.component.AbstractUITreeNodeBase;
import org.apache.myfaces.tobago.internal.component.AbstractUITreeSelect;
import org.apache.myfaces.tobago.internal.util.HtmlRendererUtils;
import org.apache.myfaces.tobago.internal.util.JsonUtils;
import org.apache.myfaces.tobago.internal.util.RenderUtils;
import org.apache.myfaces.tobago.internal.util.StringUtils;
import org.apache.myfaces.tobago.model.Selectable;
import org.apache.myfaces.tobago.renderkit.RendererBase;
import org.apache.myfaces.tobago.renderkit.css.BootstrapClass;
import org.apache.myfaces.tobago.renderkit.css.CssItem;
import org.apache.myfaces.tobago.renderkit.css.TobagoClass;
import org.apache.myfaces.tobago.renderkit.html.DataAttributes;
import org.apache.myfaces.tobago.renderkit.html.HtmlAttributes;
import org.apache.myfaces.tobago.renderkit.html.HtmlElements;
import org.apache.myfaces.tobago.renderkit.html.HtmlInputTypes;
import org.apache.myfaces.tobago.renderkit.html.MarkupLanguageAttributes;
import org.apache.myfaces.tobago.util.ComponentUtils;
import org.apache.myfaces.tobago.webapp.TobagoResponseWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TreeSelectRenderer
extends RendererBase {
    private static final Logger LOG = LoggerFactory.getLogger(TreeSelectRenderer.class);

    public void decode(FacesContext facesContext, UIComponent component) {
        AbstractUITreeSelect select = (AbstractUITreeSelect)component;
        AbstractUITreeNodeBase node = ComponentUtils.findAncestor((UIComponent)select, AbstractUITreeNodeBase.class);
        AbstractUIData data = ComponentUtils.findAncestor((UIComponent)node, AbstractUIData.class);
        if (ComponentUtils.isOutputOnly((UIComponent)select)) {
            return;
        }
        String clientId = select.getClientId(facesContext);
        String name = data.getSelectable().isSingle() ? this.getClientIdWithoutRowIndex(data, clientId) : clientId;
        String parameter = (String)facesContext.getExternalContext().getRequestParameterMap().get(name);
        if (LOG.isDebugEnabled()) {
            LOG.debug("parameter = '" + parameter + "'");
        }
        boolean selected = clientId.equals(parameter);
        if (!select.isValueStoredInState()) {
            select.setSubmittedValue(selected ? "true" : "false");
        }
    }

    public void encodeBegin(FacesContext facesContext, UIComponent component) throws IOException {
        String label;
        AbstractUITreeSelect treeSelect = (AbstractUITreeSelect)component;
        AbstractUITreeNodeBase node = ComponentUtils.findAncestor((UIComponent)treeSelect, AbstractUITreeNodeBase.class);
        AbstractUIData data = ComponentUtils.findAncestor((UIComponent)node, AbstractUIData.class);
        TobagoResponseWriter writer = this.getResponseWriter(facesContext);
        if (data instanceof AbstractUITreeListbox) {
            writer.write(StringUtils.defaultString(treeSelect.getLabel()));
            return;
        }
        String id = treeSelect.getClientId(facesContext);
        String currentValue = this.getCurrentValue(facesContext, (UIComponent)treeSelect);
        boolean checked = treeSelect.isValueStoredInState() ? data.getSelectedState().isSelected(node.getPath()) : "true".equals(currentValue);
        boolean folder = data.isFolder();
        Selectable selectable = data.getSelectable();
        writer.startElement(HtmlElements.SPAN);
        Markup markup = treeSelect.getMarkup();
        writer.writeAttribute(DataAttributes.MARKUP, JsonUtils.encode(markup), false);
        writer.writeClassAttribute((CssItem)TobagoClass.TREE_SELECT, TobagoClass.TREE_SELECT.createMarkup(markup), new CssItem[]{treeSelect.getCustomClass()});
        HtmlRendererUtils.writeDataAttributes(facesContext, writer, (UIComponent)treeSelect);
        if (!(!treeSelect.isShowCheckbox() || selectable == Selectable.none || selectable.isLeafOnly() && folder)) {
            writer.startElement(HtmlElements.INPUT);
            writer.writeClassAttribute(BootstrapClass.FORM_CHECK_INLINE);
            if (selectable.isSingle()) {
                writer.writeAttribute((MarkupLanguageAttributes)HtmlAttributes.TYPE, HtmlInputTypes.RADIO);
                writer.writeNameAttribute(this.getClientIdWithoutRowIndex(data, id));
            } else {
                writer.writeAttribute((MarkupLanguageAttributes)HtmlAttributes.TYPE, HtmlInputTypes.CHECKBOX);
                writer.writeNameAttribute(id);
            }
            writer.writeAttribute(HtmlAttributes.VALUE, id, false);
            writer.writeIdAttribute(id);
            writer.writeAttribute((MarkupLanguageAttributes)HtmlAttributes.CHECKED, checked);
            writer.writeCommandMapAttribute(JsonUtils.encode(RenderUtils.getBehaviorCommands(facesContext, treeSelect)));
            writer.endElement(HtmlElements.INPUT);
        }
        if (StringUtils.isNotEmpty(label = treeSelect.getLabel())) {
            writer.startElement(HtmlElements.LABEL);
            writer.writeClassAttribute(TobagoClass.TREE_SELECT__LABEL);
            String title = HtmlRendererUtils.getTitleFromTipAndMessages(facesContext, (UIComponent)treeSelect);
            if (title != null) {
                writer.writeAttribute(HtmlAttributes.TITLE, title, true);
            }
            writer.writeAttribute(HtmlAttributes.FOR, id, false);
            writer.writeText(label);
            writer.endElement(HtmlElements.LABEL);
        }
        writer.endElement(HtmlElements.SPAN);
    }

    private String getClientIdWithoutRowIndex(AbstractUIData data, String id) {
        char separatorChar = UINamingContainer.getSeparatorChar((FacesContext)FacesContext.getCurrentInstance());
        return id.substring(0, id.indexOf("" + separatorChar + data.getRowIndex() + separatorChar));
    }

    public void encodeEnd(FacesContext facesContext, UIComponent component) throws IOException {
    }
}

