/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.renderkit.html.ext;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.faces.application.FacesMessage;
import javax.faces.component.UIColumn;
import javax.faces.component.UIComponent;
import javax.faces.component.ValueHolder;
import javax.faces.component.behavior.ClientBehaviorHolder;
import javax.faces.component.html.HtmlOutputLabel;
import javax.faces.component.html.HtmlOutputText;
import javax.faces.context.FacesContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.myfaces.component.html.ext.HtmlMessage;
import org.apache.myfaces.component.html.ext.HtmlMessages;
import org.apache.myfaces.shared_tomahawk.renderkit.RendererUtils;
import org.apache.myfaces.shared_tomahawk.renderkit.html.HtmlMessageRendererBase;
import org.apache.myfaces.shared_tomahawk.renderkit.html.HtmlRendererUtils;
import org.apache.myfaces.shared_tomahawk.renderkit.html.util.ResourceUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HtmlMessageRenderer
extends HtmlMessageRendererBase {
    private static final Log log = LogFactory.getLog(HtmlMessageRenderer.class);
    private static final String OUTPUT_LABEL_MAP = HtmlMessageRenderer.class.getName() + ".OUTPUT_LABEL_MAP";

    public void decode(FacesContext context, UIComponent component) {
        super.decode(context, component);
        HtmlRendererUtils.decodeClientBehaviors(context, component);
    }

    public void encodeEnd(FacesContext facesContext, UIComponent component) throws IOException {
        super.encodeEnd(facesContext, component);
        Map behaviors = null;
        if (component instanceof ClientBehaviorHolder && !(behaviors = ((ClientBehaviorHolder)component).getClientBehaviors()).isEmpty()) {
            ResourceUtils.renderDefaultJsfJsInlineIfNecessary(facesContext, facesContext.getResponseWriter());
        }
        boolean forceSpan = false;
        if (component instanceof HtmlMessage && ((HtmlMessage)component).getForceSpan()) {
            forceSpan = true;
        }
        this.renderMessage(facesContext, component, forceSpan, true);
    }

    @Override
    protected String getSummary(FacesContext facesContext, UIComponent message, FacesMessage facesMessage, String msgClientId) {
        String summaryFormat;
        String msgSummary = facesMessage.getSummary();
        if (msgSummary == null) {
            return null;
        }
        String inputLabel = null;
        if (msgClientId != null) {
            inputLabel = HtmlMessageRenderer.findInputLabel(facesContext, msgClientId);
        }
        if (inputLabel == null) {
            inputLabel = "";
        }
        if ((message instanceof HtmlMessages && ((HtmlMessages)message).isReplaceIdWithLabel() || message instanceof HtmlMessage && ((HtmlMessage)message).isReplaceIdWithLabel()) && inputLabel.length() != 0) {
            msgSummary = msgSummary.replaceAll(HtmlMessageRenderer.findInputId(facesContext, msgClientId), inputLabel);
        }
        if ((summaryFormat = message instanceof HtmlMessage ? ((HtmlMessage)message).getSummaryFormat() : (String)message.getAttributes().get("summaryFormat")) == null) {
            return msgSummary;
        }
        MessageFormat format = new MessageFormat(summaryFormat, facesContext.getViewRoot().getLocale());
        return format.format(new Object[]{msgSummary, inputLabel});
    }

    @Override
    protected String getDetail(FacesContext facesContext, UIComponent message, FacesMessage facesMessage, String msgClientId) {
        String detailFormat;
        String msgDetail = facesMessage.getDetail();
        if (msgDetail == null) {
            return null;
        }
        String inputLabel = null;
        if (msgClientId != null) {
            inputLabel = HtmlMessageRenderer.findInputLabel(facesContext, msgClientId);
        }
        if (inputLabel == null) {
            inputLabel = "";
        }
        if ((message instanceof HtmlMessages && ((HtmlMessages)message).isReplaceIdWithLabel() || message instanceof HtmlMessage && ((HtmlMessage)message).isReplaceIdWithLabel()) && inputLabel.length() != 0) {
            msgDetail = msgDetail.replaceAll(HtmlMessageRenderer.findInputId(facesContext, msgClientId), inputLabel);
        }
        if ((detailFormat = message instanceof HtmlMessage ? ((HtmlMessage)message).getDetailFormat() : (String)message.getAttributes().get("detailFormat")) == null) {
            return msgDetail;
        }
        MessageFormat format = new MessageFormat(detailFormat, facesContext.getViewRoot().getLocale());
        return format.format(new Object[]{msgDetail, inputLabel});
    }

    public static String findInputLabel(FacesContext facesContext, String inputClientId) {
        Map<String, MessageLabelInfo> outputLabelMap = HtmlMessageRenderer.getOutputLabelMap(facesContext);
        MessageLabelInfo info = outputLabelMap.get(inputClientId);
        if (info == null) {
            UIColumn column;
            UIComponent comp;
            UIComponent parent = comp = facesContext.getViewRoot().findComponent(inputClientId);
            while (parent != null && !((parent = parent.getParent()) instanceof UIColumn)) {
            }
            if (parent != null && (column = (UIColumn)parent).getHeader() != null) {
                UIComponent header = column.getHeader();
                return HtmlMessageRenderer.getComponentText(facesContext, header);
            }
        }
        return info == null ? null : info.getText(facesContext);
    }

    public static String findInputId(FacesContext facesContext, String inputClientId) {
        Map<String, MessageLabelInfo> outputLabelMap = HtmlMessageRenderer.getOutputLabelMap(facesContext);
        MessageLabelInfo info = outputLabelMap.get(inputClientId);
        UIComponent comp = null;
        comp = info == null ? facesContext.getViewRoot().findComponent(inputClientId) : info.getForComponent();
        if (comp == null) {
            return null;
        }
        if (inputClientId.contains(":")) {
            return comp.getClientId(facesContext);
        }
        return comp.getId();
    }

    private static Map<String, MessageLabelInfo> getOutputLabelMap(FacesContext facesContext) {
        HashMap<String, MessageLabelInfo> map = (HashMap<String, MessageLabelInfo>)facesContext.getExternalContext().getRequestMap().get(OUTPUT_LABEL_MAP);
        if (map == null) {
            map = new HashMap<String, MessageLabelInfo>();
            HtmlMessageRenderer.createOutputLabelMap(facesContext, (UIComponent)facesContext.getViewRoot(), map);
            facesContext.getExternalContext().getRequestMap().put(OUTPUT_LABEL_MAP, map);
        }
        return map;
    }

    private static void createOutputLabelMap(FacesContext facesContext, UIComponent root, Map<String, MessageLabelInfo> map) {
        Iterator it = root.getFacetsAndChildren();
        while (it.hasNext()) {
            UIComponent child = (UIComponent)it.next();
            if (child instanceof HtmlOutputLabel) {
                String forAttr = ((HtmlOutputLabel)child).getFor();
                if (forAttr == null) continue;
                UIComponent input = child.findComponent(forAttr);
                if (input == null) {
                    log.warn((Object)("Unable to find component '" + forAttr + "' (calling findComponent on component '" + child.getClientId(facesContext) + "')"));
                    continue;
                }
                if (child.getValueExpression("value") == null) {
                    map.put(input.getClientId(facesContext), new MessageDefferedLabelInfo(input, child));
                    continue;
                }
                map.put(input.getClientId(facesContext), new MessageTextLabelInfo(input, HtmlMessageRenderer.getComponentText(facesContext, (UIComponent)((HtmlOutputLabel)child))));
                continue;
            }
            HtmlMessageRenderer.createOutputLabelMap(facesContext, child, map);
        }
    }

    private static String getComponentText(FacesContext facesContext, UIComponent component) {
        String text = null;
        if (component instanceof ValueHolder) {
            text = RendererUtils.getStringValue(facesContext, component);
        }
        if (text == null || text.length() < 1) {
            StringBuffer buf = new StringBuffer();
            List li = component.getChildren();
            for (int i = 0; i < li.size(); ++i) {
                String str;
                UIComponent child = (UIComponent)li.get(i);
                if (!(child instanceof HtmlOutputText) || (str = RendererUtils.getStringValue(facesContext, child)) == null) continue;
                buf.append(str);
            }
            text = buf.toString();
        }
        return text;
    }

    public static final class MessageDefferedLabelInfo
    implements MessageLabelInfo {
        private final UIComponent _forComponent;
        private final UIComponent _labelComponent;
        private String _text;

        public MessageDefferedLabelInfo(UIComponent forComponent, UIComponent labelComponent) {
            this._forComponent = forComponent;
            this._labelComponent = labelComponent;
        }

        public UIComponent getForComponent() {
            return this._forComponent;
        }

        public String getText(FacesContext context) {
            if (this._text == null) {
                this._text = HtmlMessageRenderer.getComponentText(context, (UIComponent)((HtmlOutputLabel)this._labelComponent));
            }
            return this._text;
        }
    }

    public static final class MessageTextLabelInfo
    implements MessageLabelInfo {
        private final UIComponent _forComponent;
        private final String _text;

        public MessageTextLabelInfo(UIComponent forComponent, String text) {
            this._forComponent = forComponent;
            this._text = text;
        }

        public UIComponent getForComponent() {
            return this._forComponent;
        }

        public String getText(FacesContext context) {
            return this._text;
        }
    }

    public static interface MessageLabelInfo {
        public UIComponent getForComponent();

        public String getText(FacesContext var1);
    }
}

