/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.image;

import org.apache.myfaces.trinidad.logging.TrinidadLogger;
import org.apache.myfaces.trinidad.util.ClassLoaderUtils;

public class PropertyInstantiator {
    private String _className;
    private static final TrinidadLogger _LOG = TrinidadLogger.createTrinidadLogger(PropertyInstantiator.class);

    public PropertyInstantiator(String className) {
        if (className == null) {
            throw new IllegalArgumentException();
        }
        this._className = className;
    }

    public String getClassName() {
        return this._className;
    }

    public Object instantiate() {
        try {
            Class classInstance = ClassLoaderUtils.loadClass((String)this._className);
            return classInstance.newInstance();
        }
        catch (ClassNotFoundException cnfe) {
            this._showInstantiationError(cnfe);
        }
        catch (IllegalAccessException iae) {
            this._showInstantiationError(iae);
        }
        catch (InstantiationException ie) {
            this._showInstantiationError(ie);
        }
        return null;
    }

    private void _showInstantiationError(Throwable e) {
        _LOG.severe("FAIL_INSTANTIATE_PROPERTY", (Object)this._className);
        _LOG.severe(e);
    }
}

