/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.image.xml.parse;

import java.util.ResourceBundle;
import org.apache.myfaces.trinidad.context.LocaleContext;
import org.apache.myfaces.trinidad.logging.TrinidadLogger;
import org.apache.myfaces.trinidadinternal.image.xml.XMLConstants;
import org.apache.myfaces.trinidadinternal.share.xml.BaseNodeParser;
import org.apache.myfaces.trinidadinternal.share.xml.NodeParser;
import org.apache.myfaces.trinidadinternal.share.xml.ParseContext;
import org.apache.myfaces.trinidadinternal.share.xml.ParseErrorUtils;
import org.xml.sax.Attributes;
import org.xml.sax.SAXParseException;

public class TextParser
extends BaseNodeParser {
    private String _bundleName;
    private String _key;
    private String _text;
    private static final String _BUNDLE_ERROR = "Missing translatedText bundle attribute.";
    private static final String _KEY_ERROR = "Missing translatedText key attribute.";
    private static final TrinidadLogger _LOG = TrinidadLogger.createTrinidadLogger(TextParser.class);

    public void startElement(ParseContext context, String namespaceURI, String localName, Attributes attrs) throws SAXParseException {
        this._bundleName = attrs.getValue("bundle");
        this._key = attrs.getValue("key");
    }

    public Object endElement(ParseContext context, String namespaceURI, String localName) {
        if (this._text != null || this._key == null && this._bundleName == null) {
            return this._text;
        }
        ResourceBundle bundle = (ResourceBundle)context.getProperty("http://myfaces.apache.org/uix/image", XMLConstants.RESOURCE_BUNDLE_PROPERTY);
        if (this._bundleName != null) {
            LocaleContext localeContext = (LocaleContext)context.getProperty("http://myfaces.apache.org/uix/image", XMLConstants.LOCALE_CONTEXT_PROPERTY);
            bundle = localeContext.getBundle(this._bundleName);
        }
        if (bundle == null || this._key == null) {
            if (_LOG.isWarning()) {
                String message = bundle == null ? _BUNDLE_ERROR : _KEY_ERROR;
                _LOG.warning(ParseErrorUtils.getErrorMessage(context, message));
            }
            return null;
        }
        Object value = bundle.getObject(this._key);
        if (value == null) {
            return null;
        }
        return value.toString();
    }

    public NodeParser startChildElement(ParseContext context, String namespaceURI, String localName, Attributes attrs) {
        return null;
    }

    public void addText(ParseContext context, char[] text, int start, int length) throws SAXParseException {
        String moreText = new String(text, start, length);
        this._text = this._text == null ? moreText : this._text + moreText;
    }

    public void addWhitespace(ParseContext context, char[] text, int start, int length) throws SAXParseException {
        this.addText(context, text, start, length);
    }
}

