/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.renderkit.core.xhtml;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.apache.myfaces.trinidad.bean.FacesBean;
import org.apache.myfaces.trinidad.bean.PropertyKey;
import org.apache.myfaces.trinidad.component.core.layout.CorePanelBox;
import org.apache.myfaces.trinidad.context.RenderingContext;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.OutputUtils;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.XhtmlRenderer;

public class PanelBoxRenderer
extends XhtmlRenderer {
    private PropertyKey _textKey;
    private PropertyKey _iconKey;
    private PropertyKey _contentStyleKey;
    private PropertyKey _backgroundKey;
    private static final String _BACKGROUND_LIGHT = "light";
    private static final String _BACKGROUND_TRANSPARENT = "transparent";
    private static final String _BACKGROUND_MEDIUM = "medium";
    private static final String _BACKGROUND_DARK = "dark";
    private static final String _BACKGROUND_DEFAULT_STYLE_CLASS = "af|panelBox::light";

    public PanelBoxRenderer() {
        this(CorePanelBox.TYPE);
    }

    protected PanelBoxRenderer(FacesBean.Type type) {
        super(type);
    }

    protected void findTypeConstants(FacesBean.Type type) {
        super.findTypeConstants(type);
        this._textKey = type.findKey("text");
        this._iconKey = type.findKey("icon");
        this._backgroundKey = type.findKey("background");
        this._contentStyleKey = type.findKey("contentStyle");
    }

    public String getDefaultStyleClass(FacesBean bean) {
        String background = this.getBackground(bean);
        if (_BACKGROUND_TRANSPARENT.equals(background)) {
            return "af|panelBox::transparent";
        }
        if (_BACKGROUND_LIGHT.equals(background)) {
            return _BACKGROUND_DEFAULT_STYLE_CLASS;
        }
        if (_BACKGROUND_MEDIUM.equals(background)) {
            return "af|panelBox::medium";
        }
        if (_BACKGROUND_DARK.equals(background)) {
            return "af|panelBox::dark";
        }
        return _BACKGROUND_DEFAULT_STYLE_CLASS;
    }

    public boolean getRendersChildren() {
        return true;
    }

    protected boolean hasChildren(UIComponent component) {
        return component.getChildCount() > 0;
    }

    protected void encodeAll(FacesContext context, RenderingContext arc, UIComponent component, FacesBean bean) throws IOException {
        super.encodeAll(context, arc, component, bean);
        String icon = this.getIcon(bean);
        String text = this.getText(bean);
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("table", component);
        this.renderId(context, component);
        this.renderAllAttributes(context, arc, bean);
        writer.startElement("tbody", null);
        if (this.hasChildren(component) || text != null || icon != null) {
            this._renderContainerTopRow(context, arc);
            this._renderMiddleRow(context, arc, component, bean, icon, text);
            this._renderContainerBottomRow(context, arc);
        }
        writer.endElement("tbody");
        writer.endElement("table");
    }

    protected void renderAllAttributes(FacesContext context, RenderingContext arc, FacesBean bean) throws IOException {
        super.renderAllAttributes(context, arc, bean);
        OutputUtils.renderLayoutTableAttributes(context, arc, "0", null);
    }

    private void _renderContainerTopRow(FacesContext context, RenderingContext arc) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("tr", null);
        if (arc.isRightToLeft()) {
            writer.startElement("td", null);
            PanelBoxRenderer.renderStyleClass((FacesContext)context, (RenderingContext)arc, (String)"af|panelBox::top-end");
            writer.endElement("td");
            writer.startElement("td", null);
            PanelBoxRenderer.renderStyleClass((FacesContext)context, (RenderingContext)arc, (String)"af|panelBox::top");
            writer.endElement("td");
            writer.startElement("td", null);
            PanelBoxRenderer.renderStyleClass((FacesContext)context, (RenderingContext)arc, (String)"af|panelBox::top-start");
            writer.endElement("td");
        } else {
            writer.startElement("td", null);
            PanelBoxRenderer.renderStyleClass((FacesContext)context, (RenderingContext)arc, (String)"af|panelBox::top-start");
            writer.endElement("td");
            writer.startElement("td", null);
            PanelBoxRenderer.renderStyleClass((FacesContext)context, (RenderingContext)arc, (String)"af|panelBox::top");
            writer.endElement("td");
            writer.startElement("td", null);
            PanelBoxRenderer.renderStyleClass((FacesContext)context, (RenderingContext)arc, (String)"af|panelBox::top-end");
            writer.endElement("td");
        }
        writer.endElement("tr");
    }

    private void _renderContainerBottomRow(FacesContext context, RenderingContext arc) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("tr", null);
        if (arc.isRightToLeft()) {
            writer.startElement("td", null);
            PanelBoxRenderer.renderStyleClass((FacesContext)context, (RenderingContext)arc, (String)"af|panelBox::bottom-end");
            writer.endElement("td");
            writer.startElement("td", null);
            PanelBoxRenderer.renderStyleClass((FacesContext)context, (RenderingContext)arc, (String)"af|panelBox::bottom");
            writer.endElement("td");
            writer.startElement("td", null);
            PanelBoxRenderer.renderStyleClass((FacesContext)context, (RenderingContext)arc, (String)"af|panelBox::bottom-start");
            writer.endElement("td");
        } else {
            writer.startElement("td", null);
            PanelBoxRenderer.renderStyleClass((FacesContext)context, (RenderingContext)arc, (String)"af|panelBox::bottom-start");
            writer.endElement("td");
            writer.startElement("td", null);
            PanelBoxRenderer.renderStyleClass((FacesContext)context, (RenderingContext)arc, (String)"af|panelBox::bottom");
            writer.endElement("td");
            writer.startElement("td", null);
            PanelBoxRenderer.renderStyleClass((FacesContext)context, (RenderingContext)arc, (String)"af|panelBox::bottom-end");
            writer.endElement("td");
        }
        writer.endElement("tr");
    }

    private void _renderMiddleRow(FacesContext context, RenderingContext arc, UIComponent component, FacesBean bean, Object icon, Object text) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("tr", null);
        if (arc.isRightToLeft()) {
            writer.startElement("td", null);
            PanelBoxRenderer.renderStyleClass((FacesContext)context, (RenderingContext)arc, (String)"af|panelBox::end");
            writer.endElement("td");
        } else {
            writer.startElement("td", null);
            PanelBoxRenderer.renderStyleClass((FacesContext)context, (RenderingContext)arc, (String)"af|panelBox::start");
            writer.endElement("td");
        }
        writer.startElement("td", null);
        this.renderBody(context, arc, component, bean, icon, text);
        writer.endElement("td");
        if (arc.isRightToLeft()) {
            writer.startElement("td", null);
            PanelBoxRenderer.renderStyleClass((FacesContext)context, (RenderingContext)arc, (String)"af|panelBox::start");
            writer.endElement("td");
        } else {
            writer.startElement("td", null);
            PanelBoxRenderer.renderStyleClass((FacesContext)context, (RenderingContext)arc, (String)"af|panelBox::end");
            writer.endElement("td");
        }
        writer.endElement("tr");
    }

    protected void renderBody(FacesContext context, RenderingContext arc, UIComponent component, FacesBean bean, Object icon, Object text) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        PanelBoxRenderer.renderStyleClass((FacesContext)context, (RenderingContext)arc, (String)"af|panelBox::body");
        if (this.hasChildren(component) && (text != null || icon != null)) {
            writer.startElement("table", null);
            OutputUtils.renderLayoutTableAttributes(context, arc, "0", "100%");
            writer.startElement("tbody", null);
            writer.startElement("tr", null);
            writer.startElement("td", null);
            this._renderHeader(context, arc, icon, text);
            writer.endElement("td");
            writer.endElement("tr");
            writer.startElement("tr", null);
            writer.startElement("td", null);
            this.renderContent(context, arc, bean, component);
            writer.endElement("td");
            writer.endElement("tr");
            writer.endElement("tbody");
            writer.endElement("table");
        } else if (text != null || icon != null) {
            writer.startElement("div", null);
            this._renderHeader(context, arc, icon, text);
            writer.endElement("div");
        } else {
            writer.startElement("div", null);
            this.renderContent(context, arc, bean, component);
            writer.endElement("div");
        }
    }

    private void _renderHeader(FacesContext context, RenderingContext arc, Object icon, Object text) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        PanelBoxRenderer.renderStyleClass((FacesContext)context, (RenderingContext)arc, (String)"af|panelBox::header");
        if (arc.isRightToLeft()) {
            if (text != null) {
                writer.writeText(text, this._textKey.getName());
            }
            if (icon != null) {
                writer.startElement("img", null);
                OutputUtils.renderAltAndTooltipForImage(context, arc, "");
                this.renderEncodedResourceURI(context, "src", icon);
                writer.endElement("img");
            }
        } else {
            if (icon != null) {
                writer.startElement("img", null);
                OutputUtils.renderAltAndTooltipForImage(context, arc, "");
                this.renderEncodedResourceURI(context, "src", icon);
                writer.endElement("img");
            }
            if (text != null) {
                writer.writeText(text, this._textKey.getName());
            }
        }
    }

    protected void renderContent(FacesContext context, RenderingContext arc, FacesBean bean, UIComponent component) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        PanelBoxRenderer.renderStyleClass((FacesContext)context, (RenderingContext)arc, (String)"af|panelBox::content");
        String style = this.getContentStyle(bean);
        if (style != null) {
            writer.writeAttribute("style", (Object)style, null);
        }
        this.encodeAllChildren(context, component);
    }

    protected String getText(FacesBean bean) {
        if (this._textKey == null) {
            return null;
        }
        return PanelBoxRenderer.toString((Object)bean.getProperty(this._textKey));
    }

    protected String getIcon(FacesBean bean) {
        if (this._iconKey == null) {
            return null;
        }
        return PanelBoxRenderer.toResourceUri((FacesContext)FacesContext.getCurrentInstance(), (Object)bean.getProperty(this._iconKey));
    }

    protected String getContentStyle(FacesBean bean) {
        if (this._contentStyleKey == null) {
            return null;
        }
        return PanelBoxRenderer.toString((Object)bean.getProperty(this._contentStyleKey));
    }

    protected String getBackground(FacesBean bean) {
        if (this._backgroundKey == null) {
            return null;
        }
        return PanelBoxRenderer.toString((Object)bean.getProperty(this._backgroundKey));
    }
}

