/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.renderkit.html;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.apache.myfaces.trinidad.bean.FacesBean;
import org.apache.myfaces.trinidad.bean.PropertyKey;
import org.apache.myfaces.trinidad.component.html.HtmlCellFormat;
import org.apache.myfaces.trinidad.context.RenderingContext;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.XhtmlRenderer;

public class CellFormatRenderer
extends XhtmlRenderer {
    private PropertyKey _widthKey;
    private PropertyKey _heightKey;
    private PropertyKey _halignKey;
    private PropertyKey _valignKey;
    private PropertyKey _shortTextKey;
    private PropertyKey _columnSpanKey;
    private PropertyKey _rowSpanKey;
    private PropertyKey _wrappingDisabledKey;
    private PropertyKey _headersKey;
    private PropertyKey _headerKey;

    public CellFormatRenderer() {
        super(HtmlCellFormat.TYPE);
    }

    protected void findTypeConstants(FacesBean.Type type) {
        super.findTypeConstants(type);
        this._widthKey = type.findKey("width");
        this._heightKey = type.findKey("height");
        this._halignKey = type.findKey("halign");
        this._valignKey = type.findKey("valign");
        this._shortTextKey = type.findKey("shortText");
        this._columnSpanKey = type.findKey("columnSpan");
        this._rowSpanKey = type.findKey("rowSpan");
        this._wrappingDisabledKey = type.findKey("wrappingDisabled");
        this._headersKey = type.findKey("headers");
        this._headerKey = type.findKey("header");
    }

    public boolean getRendersChildren() {
        return true;
    }

    protected void encodeAll(FacesContext context, RenderingContext arc, UIComponent component, FacesBean bean) throws IOException {
        int rowspan;
        ResponseWriter rw = context.getResponseWriter();
        String element = this.isHeader(bean) ? "th" : "td";
        rw.startElement(element, component);
        this.renderId(context, component);
        this.renderAllAttributes(context, arc, bean);
        CellFormatRenderer.renderHAlign(context, arc, this.getHalign(bean));
        rw.writeAttribute("valign", this.getValign(bean), "valign");
        rw.writeAttribute("abbr", this.getShortText(bean), "shortText");
        rw.writeAttribute("headers", this.getHeaders(bean), "headers");
        rw.writeAttribute("width", this.getWidth(bean), "width");
        rw.writeAttribute("height", this.getHeight(bean), "height");
        int colspan = this.getColumnSpan(bean);
        if (colspan > 1) {
            rw.writeAttribute("colspan", (Object)colspan, "columnSpan");
        }
        if ((rowspan = this.getRowSpan(bean)) > 1) {
            rw.writeAttribute("rowspan", (Object)rowspan, "rowSpan");
        }
        if (this.isWrappingDisabled(bean) && CellFormatRenderer.isDesktop((RenderingContext)arc)) {
            rw.writeAttribute("nowrap", (Object)Boolean.TRUE, "wrappingDisabled");
        }
        this.encodeAllChildren(context, component);
        rw.endElement(element);
    }

    protected Object getWidth(FacesBean bean) {
        return bean.getProperty(this._widthKey);
    }

    protected Object getHeight(FacesBean bean) {
        return bean.getProperty(this._heightKey);
    }

    protected Object getHalign(FacesBean bean) {
        return bean.getProperty(this._halignKey);
    }

    protected Object getValign(FacesBean bean) {
        return bean.getProperty(this._valignKey);
    }

    protected boolean isWrappingDisabled(FacesBean bean) {
        return Boolean.TRUE.equals(bean.getProperty(this._wrappingDisabledKey));
    }

    protected Object getShortText(FacesBean bean) {
        return bean.getProperty(this._shortTextKey);
    }

    protected int getColumnSpan(FacesBean bean) {
        Object o = bean.getProperty(this._columnSpanKey);
        if (o == null) {
            return 1;
        }
        return CellFormatRenderer.toInt((Object)o);
    }

    protected int getRowSpan(FacesBean bean) {
        Object o = bean.getProperty(this._rowSpanKey);
        if (o == null) {
            return 1;
        }
        return CellFormatRenderer.toInt((Object)o);
    }

    protected Object getHeaders(FacesBean bean) {
        return bean.getProperty(this._headersKey);
    }

    protected boolean isHeader(FacesBean bean) {
        return Boolean.TRUE.equals(bean.getProperty(this._headerKey));
    }
}

