/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.ui.laf.base.desktop;

import java.awt.Color;
import java.io.IOException;
import java.util.Collection;
import javax.faces.component.UIComponent;
import javax.faces.context.ResponseWriter;
import org.apache.myfaces.trinidadinternal.image.ImageContext;
import org.apache.myfaces.trinidadinternal.image.ImageProvider;
import org.apache.myfaces.trinidadinternal.image.ImageProviderRequest;
import org.apache.myfaces.trinidadinternal.image.ImageProviderResponse;
import org.apache.myfaces.trinidadinternal.style.CSSStyle;
import org.apache.myfaces.trinidadinternal.style.Style;
import org.apache.myfaces.trinidadinternal.style.util.CSSUtils;
import org.apache.myfaces.trinidadinternal.style.util.FontProxy;
import org.apache.myfaces.trinidadinternal.style.util.MutableFontProxy;
import org.apache.myfaces.trinidadinternal.ui.AttributeKey;
import org.apache.myfaces.trinidadinternal.ui.Renderer;
import org.apache.myfaces.trinidadinternal.ui.UIConstants;
import org.apache.myfaces.trinidadinternal.ui.UINode;
import org.apache.myfaces.trinidadinternal.ui.UIXRenderingContext;
import org.apache.myfaces.trinidadinternal.ui.action.ClientAction;
import org.apache.myfaces.trinidadinternal.ui.action.ClientActionUtils;
import org.apache.myfaces.trinidadinternal.ui.action.FireAction;
import org.apache.myfaces.trinidadinternal.ui.laf.base.BaseLafRenderer;
import org.apache.myfaces.trinidadinternal.ui.laf.base.desktop.BaseDesktopUtils;
import org.apache.myfaces.trinidadinternal.ui.laf.base.desktop.GeneratedImageRenderer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Deprecated
public abstract class ButtonRenderer
extends GeneratedImageRenderer {
    private static final AttributeKey _START_ROUNDED_ATTR = ButtonRenderer.getAttributeKey("_startRounded");
    private static final AttributeKey _END_ROUNDED_ATTR = ButtonRenderer.getAttributeKey("_endRounded");
    private static final String _EMPTY_LABEL = "";
    private static final String _SERVER_STYLE_NAME = "BLAFServerButtonText";
    private static final String _SERVER_DISABLED_STYLE_NAME = "BLAFServerButtonTextDisabled";
    private static final Object _ON_CLICK_NONE = new Object();
    private static final Object _LOCAL_ON_CLICK_KEY = new Object();
    private static final Object _ON_KEY_DOWN_RENDERED = new Object();
    private static final Object _ADF_BTN_ATTR = new Object();
    private static final Renderer _ALTERNATE_RENDERER = new org.apache.myfaces.trinidadinternal.ui.laf.base.xhtml.ButtonRenderer();
    private final Renderer _LINK_ALTERNATE_RENDERER = new AlternateRenderer();

    @Override
    protected final void prerender(UIXRenderingContext context, UINode node) throws IOException {
    }

    @Override
    protected final void postrender(UIXRenderingContext context, UINode node) throws IOException {
    }

    @Override
    protected final void renderContent(UIXRenderingContext context, UINode node) throws IOException {
        ImageProviderResponse response = this._getImage(context, node);
        if (response != null) {
            this.renderImageContent(context, node, response);
        } else {
            this.renderAltContent(context, node);
        }
    }

    protected boolean doRenderImageContent(UIXRenderingContext context, UINode node) {
        return !ButtonRenderer.isScreenReaderMode(context);
    }

    protected void renderImageContent(UIXRenderingContext context, UINode node, ImageProviderResponse response) throws IOException {
        ButtonRenderer._writeClientActionDependency(context, node);
        this.renderImage(context, node, response, null);
        ButtonRenderer._renderOnKeyDownScript(context);
    }

    @Override
    public final void render(UIXRenderingContext context, UINode node) throws IOException {
        if (ButtonRenderer.supportsNavigation(context)) {
            if (this.doRenderImageContent(context, node)) {
                super.render(context, node);
            } else {
                this.renderAltContent(context, node);
            }
        }
    }

    protected void renderAltContent(UIXRenderingContext context, UINode node) throws IOException {
        this._getAlternateRenderer(context).render(context, node);
    }

    protected Renderer getAltRenderer() {
        return _ALTERNATE_RENDERER;
    }

    @Override
    protected Object getOnClick(UIXRenderingContext context, UINode node) {
        UIComponent component;
        Object prop = context.getLocalProperty(0, _LOCAL_ON_CLICK_KEY, _ON_CLICK_NONE);
        if (prop != _ON_CLICK_NONE) {
            return prop;
        }
        Object onClick = super.getOnClick(context, node);
        ClientAction action = ClientActionUtils.getPrimaryClientAction(context, node);
        String actionScript = null;
        if (action instanceof FireAction && (component = node.getUIComponent()) != null && Boolean.TRUE.equals(component.getAttributes().get("blocking"))) {
            ((FireAction)action).setBlocking(true);
        }
        if (action != null) {
            actionScript = action.getScript(context, node, Boolean.FALSE);
        }
        Object chainedScript = BaseDesktopUtils.getChainedJS(onClick, actionScript, true);
        context.setLocalProperty(_LOCAL_ON_CLICK_KEY, chainedScript);
        return chainedScript;
    }

    @Override
    protected Object getText(UIXRenderingContext context, UINode node) {
        Object text = node.getAttributeValue(context, TEXT_ATTR);
        if (text == null) {
            return _EMPTY_LABEL;
        }
        return text;
    }

    @Override
    protected Object getStyleClass(UIXRenderingContext context, UINode node) {
        return null;
    }

    @Override
    protected Object getVAlign(UIXRenderingContext context, UINode node) {
        int application = context.getAgent().getAgentApplication();
        String align = application == 1 || application == 3 || ButtonRenderer.isScreenReaderMode(context) ? "middle" : "absmiddle";
        return align;
    }

    @Override
    protected void renderButtonAccessKey(UIXRenderingContext context, UINode node) throws IOException {
        Object accessKey = node.getAttributeValue(context, ACCESS_KEY_ATTR);
        if (accessKey != null) {
            this.renderAttribute(context, "accesskey", accessKey);
            if (ButtonRenderer.isIE(context) && context.getAgent().getAgentOS() != 2) {
                context.getResponseWriter().writeAttribute("adfbtn", (Object)"t", null);
                ButtonRenderer.setRenderingProperty(context, _ADF_BTN_ATTR, Boolean.TRUE);
            }
        }
    }

    protected abstract ImageProviderRequest createImageProviderRequest(UIXRenderingContext var1, Object var2, Object var3, Color var4, Color var5, Color var6, FontProxy var7, boolean var8, boolean var9, boolean var10, boolean var11, char var12);

    protected String getServerStyleName(UIXRenderingContext context, UINode node, boolean disabled) {
        return disabled ? _SERVER_DISABLED_STYLE_NAME : _SERVER_STYLE_NAME;
    }

    private ImageProviderResponse _getImage(UIXRenderingContext context, UINode node) {
        ImageProvider provider = (ImageProvider)context.getProperty("http://myfaces.apache.org/uix/image", IMAGE_PROVIDER_PROPERTY);
        if (provider == null) {
            return null;
        }
        boolean disabled = this.isDisabled(context, node);
        Object text = this.getText(context, node);
        boolean startRounded = ButtonRenderer.getBooleanAttributeValue(context, node, _START_ROUNDED_ATTR, true);
        boolean endRounded = ButtonRenderer.getBooleanAttributeValue(context, node, _END_ROUNDED_ATTR, true);
        Object name = this.getImageName(context, node);
        String styleName = this.getServerStyleName(context, node, disabled);
        Style style = ButtonRenderer.getStyle(context, node, styleName);
        Object inlineStyleObj = this.getInlineStyle(context, node);
        CSSStyle inlineStyle = inlineStyleObj == null ? null : CSSUtils.parseStyle(inlineStyleObj.toString());
        Color background = ButtonRenderer.getBackground(context, node, style, inlineStyle, styleName);
        Color foreground = ButtonRenderer.getForeground(context, node, style, inlineStyle, styleName);
        Color surroundingColor = ButtonRenderer.getSurroundingColor(context);
        char realAccessKey = this._getAccessKey(context, node);
        char accessKey = ButtonRenderer.supportsAccessKeys(context) ? realAccessKey : (char)'\uffff';
        boolean textAntialias = ButtonRenderer.isTextAntialiased(context, node, style, inlineStyle);
        int fontStyle = ButtonRenderer.getFontStyle(context, node, style, inlineStyle, styleName);
        int fontSize = ButtonRenderer.getFontSize(context, node, style, inlineStyle, styleName);
        Collection<Object> fontFamilies = ButtonRenderer.getFontFamilies(context, node, style, styleName);
        Collection<Object> inlineFontFamilies = ButtonRenderer.getFontFamilies(context, node, inlineStyle, null);
        MutableFontProxy font = new MutableFontProxy(null, fontStyle, fontSize);
        ImageProviderRequest request = this.createImageProviderRequest(context, name, text, foreground, background, surroundingColor, font, disabled, textAntialias, startRounded, endRounded, accessKey);
        return this._getImage(context, provider, request, font, fontFamilies, inlineFontFamilies);
    }

    private ImageProviderResponse _getImage(UIXRenderingContext context, ImageProvider provider, ImageProviderRequest request, MutableFontProxy font, Collection<Object> fontFamilies, Collection<Object> inlineFontFamilies) {
        ImageContext imageContext = context.getImageContext();
        ImageProviderResponse response = null;
        if (inlineFontFamilies != null) {
            for (String string : inlineFontFamilies) {
                font.setName(string);
                response = provider.getImage(imageContext, request);
                if (response == null) continue;
                return response;
            }
        }
        if (fontFamilies != null) {
            for (String string : fontFamilies) {
                font.setName(string);
                response = provider.getImage(imageContext, request);
                if (response == null) continue;
                return response;
            }
        }
        font.setName(null);
        return provider.getImage(imageContext, request);
    }

    private char _getAccessKey(UIXRenderingContext context, UINode node) {
        char ch = BaseDesktopUtils.getCharacterAttr(context, node, ACCESS_KEY_ATTR);
        if (ch == '\uffff') {
            return '\uffff';
        }
        return ch;
    }

    private static void _writeClientActionDependency(UIXRenderingContext context, UINode node) throws IOException {
        ClientAction action = ClientActionUtils.getPrimaryClientAction(context, node);
        if (action != null) {
            action.writeDependencies(context, node);
        }
    }

    private static void _renderOnKeyDownScript(UIXRenderingContext context) throws IOException {
        if (Boolean.TRUE.equals(ButtonRenderer.getRenderingProperty(context, _ADF_BTN_ATTR))) {
            ButtonRenderer.renderScriptOnce(context, "document.onkeydown=_monitor;", _ON_KEY_DOWN_RENDERED);
        }
    }

    private boolean _useLinkAlternateContent(UIXRenderingContext context) {
        return !ButtonRenderer.supportsAdvancedButtons(context) && ButtonRenderer.getParentFormName(context) == null;
    }

    private Renderer _getAlternateRenderer(UIXRenderingContext context) {
        if (this._useLinkAlternateContent(context)) {
            return this._LINK_ALTERNATE_RENDERER;
        }
        return this.getAltRenderer();
    }

    @Deprecated
    private class AlternateRenderer
    implements Renderer {
        private AlternateRenderer() {
        }

        public void render(UIXRenderingContext context, UINode node) throws IOException {
            ButtonRenderer._writeClientActionDependency(context, node);
            Object text = ButtonRenderer.this.getText(context, node);
            Object destination = ButtonRenderer.this.getDestination(context, node);
            boolean disabled = ButtonRenderer.this.isDisabled(context, node);
            boolean isLink = destination != null && !disabled;
            String element = isLink ? "a" : "span";
            ResponseWriter writer = context.getResponseWriter();
            writer.startElement(element, node.getUIComponent());
            ButtonRenderer.this.renderAttributes(context, node);
            if (isLink) {
                ButtonRenderer.this.renderEncodedActionURI(context, "href", destination);
                ButtonRenderer.this.renderAttribute(context, node, "target", UIConstants.TARGET_FRAME_ATTR);
                if (BaseLafRenderer.supportsAccessKeys(context)) {
                    ButtonRenderer.this.renderButtonAccessKey(context, node);
                }
                ButtonRenderer.this.renderAccessKeyText(context, node, text, "AFLinkAccessKeyStyle");
            } else {
                ButtonRenderer.this.renderText(context, node);
            }
            writer.endElement(element);
        }
    }
}

