/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.image.encode;

import java.awt.Image;
import java.awt.image.PixelGrabber;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.util.Hashtable;
import org.apache.myfaces.trinidad.logging.TrinidadLogger;
import org.apache.myfaces.trinidadinternal.image.painter.ImageLoader;

final class GifEncoder {
    private static final int _LARGEST_CODE = 4096;
    private static final int _BLOCK_SIZE = 254;
    private static final int _MAXIMUM_COLOR_TABLE_SIZE = 256;
    private static final int _NO_COLOR = -2;
    private static final int _TRANSPARENT_COLOR = -1;
    private static final byte[] _HEADER = "GIF89a".getBytes();
    private static final int _TRANSPARENCY_THRESHHOLD = 1;
    private static final TrinidadLogger _LOG = TrinidadLogger.createTrinidadLogger(GifEncoder.class);

    public static void encode(Image image, OutputStream stream) throws IOException {
        int off;
        ImageLoader il = new ImageLoader(image);
        il.start();
        if (!il.waitFor()) {
            throw new IllegalArgumentException(_LOG.getMessage("PROBLEM_LOADING"));
        }
        int width = image.getWidth(il);
        int height = image.getHeight(il);
        int[] pixels = new int[width * height];
        PixelGrabber grabber = new PixelGrabber(image.getSource(), 0, 0, width, height, pixels, 0, width);
        try {
            grabber.grabPixels();
        }
        catch (InterruptedException e) {
            throw new InterruptedIOException(_LOG.getMessage("GRABBING_PIXELS"));
        }
        if ((grabber.getStatus() & 0x80) != 0) {
            throw new IllegalArgumentException(_LOG.getMessage("ERROR_FETCHING_IMAGE", new Object[]{pixels.length, width, height}));
        }
        byte[] globalColorTable = new byte[768];
        Hashtable<Integer, Integer> hsh = new Hashtable<Integer, Integer>(256);
        int colorIndex = 0;
        int background = 0;
        int lastColor = -2;
        int lastColorIndex = 0;
        boolean transparency = false;
        for (int i = 0; i < pixels.length; ++i) {
            int color = pixels[i];
            if (lastColor == color) {
                pixels[i] = lastColorIndex;
                continue;
            }
            if (GifEncoder._isTransparent(color)) {
                pixels[i] = -1;
                if (GifEncoder._isFullyTransparent(color)) {
                    background = colorIndex;
                }
                transparency = true;
                continue;
            }
            Integer colorKey = color & 0xFFFFFF;
            Integer colorIndexValue = (Integer)hsh.get(colorKey);
            if (colorIndexValue != null) {
                lastColorIndex = colorIndexValue;
            } else {
                if (colorIndex >= 256) {
                    throw new IllegalArgumentException(_LOG.getMessage("EXCEEDED_GIF_COLOR_LIMIT"));
                }
                off = 3 * colorIndex;
                globalColorTable[off] = GifEncoder._getRed(color);
                globalColorTable[off + 1] = GifEncoder._getGreen(color);
                globalColorTable[off + 2] = GifEncoder._getBlue(color);
                hsh.put(colorKey, colorIndex);
                lastColorIndex = colorIndex++;
            }
            lastColor = color;
            pixels[i] = lastColorIndex;
        }
        int transparentIndex = 0;
        if (transparency) {
            if (colorIndex >= 256) {
                throw new IllegalArgumentException(_LOG.getMessage("NO_SPACE_LEFT_FOR_TRANSPARENCY"));
            }
            int i = 0xFF00FF;
            while (i < 0xFFFFFF) {
                int col;
                Integer icol;
                if (hsh.containsKey(icol = Integer.valueOf(col = i++))) continue;
                off = 3 * colorIndex;
                transparentIndex = colorIndex + 2;
                globalColorTable[off] = GifEncoder._getRed(col);
                globalColorTable[off + 1] = GifEncoder._getGreen(col);
                globalColorTable[off + 2] = GifEncoder._getBlue(col);
                break;
            }
        }
        int codeSize = GifEncoder.getLog(colorIndex);
        int globalColorTableSize = 3 * (1 << codeSize);
        stream.write(_HEADER);
        byte[] blocks = new byte[18];
        blocks[0] = (byte)width;
        blocks[1] = (byte)(width >>> 8);
        blocks[2] = (byte)height;
        blocks[3] = (byte)(height >>> 8);
        blocks[4] = (byte)(0xFFFFFF80 | (byte)(codeSize - 1 << 4) | (byte)(codeSize - 1));
        blocks[5] = (byte)background;
        stream.write(blocks, 0, 7);
        blocks[13] = blocks[0];
        blocks[14] = blocks[1];
        blocks[15] = blocks[2];
        blocks[16] = blocks[3];
        blocks[0] = 33;
        blocks[1] = transparency ? -7 : -2;
        blocks[2] = 4;
        blocks[3] = 1;
        blocks[4] = transparency ? 0 : 74;
        blocks[5] = transparency ? 0 : 68;
        blocks[6] = transparency ? (int)(transparentIndex - 2) : 76;
        blocks[8] = 44;
        stream.write(globalColorTable, 0, globalColorTableSize);
        stream.write(blocks);
        if (codeSize < 2) {
            codeSize = 2;
        }
        stream.write((byte)codeSize);
        hsh = new Hashtable(4096);
        int code = (1 << codeSize) + 2;
        int clearCode = code++ - 2;
        int endOfInformation = code++ - 2;
        int sqnc = 0;
        int newcol = 0;
        int sqnc_newcol = 0;
        Integer fsqnc_newcol = null;
        Info info = new Info();
        info.compressionSize = codeSize + 1;
        info.theByte = 0;
        info.bitsLeft = 8;
        info.blockOffset = 1;
        info.byteData = new byte[256];
        info.byteData[0] = -2;
        double infoCompSizeExp = 1 << info.compressionSize;
        GifEncoder._writeByte(stream, clearCode, info);
        for (int i = 0; i < pixels.length; ++i) {
            int pixel = pixels[i];
            int n = newcol = pixel >= 0 ? pixel + 2 : transparentIndex;
            assert (sqnc <= 65535);
            assert (newcol <= 65535);
            sqnc_newcol = 0xFFFF0000 & sqnc << 16 | 0xFFFF & newcol;
            if (sqnc > 0) {
                fsqnc_newcol = sqnc_newcol;
                Integer sqnc_newcol_code = (Integer)hsh.get(fsqnc_newcol);
                if (sqnc_newcol_code == null) {
                    GifEncoder._writeByte(stream, sqnc - 2, info);
                    hsh.put(fsqnc_newcol, code++);
                    if ((double)(code - 2) > infoCompSizeExp) {
                        infoCompSizeExp = 1 << ++info.compressionSize;
                    }
                    if (code - 2 == 4096) {
                        GifEncoder._writeByte(stream, clearCode, info);
                        hsh.clear();
                        code = (1 << codeSize) + 4;
                        info.compressionSize = codeSize + 1;
                        infoCompSizeExp = 1 << info.compressionSize;
                    }
                    sqnc = newcol;
                    continue;
                }
                sqnc = sqnc_newcol_code;
                continue;
            }
            sqnc = newcol;
        }
        GifEncoder._writeByte(stream, sqnc - 2, info);
        GifEncoder._writeByte(stream, endOfInformation, info);
        if (info.bitsLeft < 8) {
            info.byteData[info.blockOffset++] = info.theByte;
            info.theByte = 0;
            info.bitsLeft = 8;
        }
        info.byteData[0] = (byte)(info.blockOffset - 1);
        info.byteData[info.blockOffset++] = 0;
        stream.write(info.byteData, 0, info.blockOffset);
        stream.write(59);
    }

    private GifEncoder() {
    }

    private static void _writeByte(OutputStream stream, int data, Info info) throws IOException {
        int numBits;
        int offset = info.blockOffset;
        byte b = info.theByte;
        int bitsLeft = info.bitsLeft;
        for (int size = info.compressionSize; size > 0; size -= numBits) {
            numBits = bitsLeft < size ? bitsLeft : size;
            byte new_bits = (byte)(data & (1 << numBits) - 1);
            data >>>= numBits;
            new_bits = (byte)(new_bits << 8 - bitsLeft);
            b = (byte)(b | new_bits);
            if ((bitsLeft -= numBits) != 0) continue;
            info.byteData[offset++] = b;
            b = 0;
            bitsLeft = 8;
            if (offset <= 254) continue;
            stream.write(info.byteData, 0, offset);
            info.byteData[0] = -2;
            offset = 1;
        }
        info.blockOffset = offset;
        info.bitsLeft = bitsLeft;
        info.theByte = b;
    }

    private static byte _getRed(int c) {
        return (byte)(c >> 16 & 0xFF);
    }

    private static byte _getGreen(int c) {
        return (byte)(c >> 8 & 0xFF);
    }

    private static byte _getBlue(int c) {
        return (byte)(c & 0xFF);
    }

    private static boolean _isTransparent(int c) {
        return (c >> 24 & 0xFF) < 1;
    }

    private static boolean _isFullyTransparent(int c) {
        return (c & 0xFF000000) == 0;
    }

    private static int getLog(int n) {
        int i = 0;
        while (n != 0) {
            n >>= 1;
            ++i;
        }
        return i;
    }

    private static class Info {
        public int bitsLeft;
        public int compressionSize;
        public int blockOffset;
        public byte theByte;
        public byte[] byteData;

        private Info() {
        }
    }
}

