/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.renderkit.core;

import java.io.IOException;
import java.util.Map;
import javax.faces.application.StateManager;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.render.ResponseStateManager;
import org.apache.myfaces.trinidad.logging.TrinidadLogger;
import org.apache.myfaces.trinidadinternal.util.StateUtils;

public class CoreResponseStateManager
extends ResponseStateManager {
    public static final String FORM_FIELD_NAME = "org.apache.myfaces.trinidad.faces.FORM";
    private static final int _BUFFER_SIZE = 2048;
    private static final String _CACHED_SERIALIZED_VIEW = "org.apache.myfaces.trinidadinternal.renderkit.CACHED_SERIALIZED_VIEW";
    private static final String _TOKEN_PREFIX = "!";
    private static final TrinidadLogger _LOG = TrinidadLogger.createTrinidadLogger(CoreResponseStateManager.class);

    public void writeState(FacesContext context, StateManager.SerializedView serializedView) throws IOException {
        ResponseWriter rw = context.getResponseWriter();
        rw.startElement("input", null);
        rw.writeAttribute("type", (Object)"hidden", null);
        rw.writeAttribute("name", (Object)"javax.faces.ViewState", null);
        String s = this.encodeSerializedViewAsString(context, serializedView);
        rw.writeAttribute("value", (Object)s, null);
        rw.endElement("input");
    }

    public boolean isPostback(FacesContext context) {
        Map requestParams = context.getExternalContext().getRequestParameterMap();
        return requestParams.containsKey("javax.faces.ViewState");
    }

    protected String encodeSerializedViewAsString(FacesContext context, StateManager.SerializedView serializedView) throws IOException {
        if (serializedView.getState() == null && serializedView.getStructure() instanceof String) {
            return _TOKEN_PREFIX + StateUtils.construct(serializedView.getStructure(), context.getExternalContext());
        }
        return StateUtils.construct(new Object[]{serializedView.getStructure(), serializedView.getState()}, context.getExternalContext());
    }

    public Object getTreeStructureToRestore(FacesContext context, String viewId) {
        Object[] view = this._restoreSerializedView(context);
        if (view == null) {
            return null;
        }
        return view[0];
    }

    public Object getComponentStateToRestore(FacesContext context) {
        Object[] view = this._restoreSerializedView(context);
        if (view == null) {
            return null;
        }
        return view[1];
    }

    private Object[] _restoreSerializedView(FacesContext context) {
        ExternalContext external = context.getExternalContext();
        Map requestMap = external.getRequestMap();
        Object[] view = (Object[])requestMap.get(_CACHED_SERIALIZED_VIEW);
        if (view == null) {
            Map requestParamMap = context.getExternalContext().getRequestParameterMap();
            String stateString = (String)requestParamMap.get("javax.faces.ViewState");
            if (stateString == null) {
                return null;
            }
            if (stateString.startsWith(_TOKEN_PREFIX)) {
                String tokenString = stateString.substring(_TOKEN_PREFIX.length());
                view = new Object[]{StateUtils.reconstruct(tokenString, context.getExternalContext()), null};
            } else if (stateString != null) {
                view = (Object[])StateUtils.reconstruct(stateString, context.getExternalContext());
            }
            if (view != null) {
                requestMap.put(_CACHED_SERIALIZED_VIEW, view);
            }
        }
        return view;
    }
}

