/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.renderkit.core.xhtml;

import java.io.IOException;
import java.util.List;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.render.Renderer;
import org.apache.myfaces.trinidad.bean.FacesBean;
import org.apache.myfaces.trinidad.bean.PropertyKey;
import org.apache.myfaces.trinidad.context.PartialPageContext;
import org.apache.myfaces.trinidad.context.RenderingContext;
import org.apache.myfaces.trinidad.logging.TrinidadLogger;
import org.apache.myfaces.trinidad.render.CoreRenderer;
import org.apache.myfaces.trinidad.render.TypedRenderer;
import org.apache.myfaces.trinidadinternal.agent.TrinidadAgent;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.OutputUtils;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.XhtmlFormattedText;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.XhtmlUtils;
import org.apache.myfaces.trinidadinternal.util.FormattedTextParser;
import org.apache.myfaces.trinidadinternal.webapp.TrinidadFilterImpl;

public class XhtmlRenderer
extends CoreRenderer
implements TypedRenderer,
Cloneable {
    public static final String TRANSPARENT_GIF = "t.gif";
    private PropertyKey _shortDescKey;
    private PropertyKey _styleClassKey;
    private PropertyKey _inlineStyleKey;
    private PropertyKey _onclickKey;
    private PropertyKey _ondblclickKey;
    private PropertyKey _onkeydownKey;
    private PropertyKey _onkeyupKey;
    private PropertyKey _onkeypressKey;
    private PropertyKey _onmousedownKey;
    private PropertyKey _onmousemoveKey;
    private PropertyKey _onmouseoutKey;
    private PropertyKey _onmouseoverKey;
    private PropertyKey _onmouseupKey;
    private PropertyKey _partialTriggersKey;
    private static final String _ACCESSIBILITY_SCRIPT_TYPE = "text/javascript";
    private static final Object _SCRIPT_SPACER_COUNT = new Object();
    private static final String _TRANSPARENT_FUNCTION_WRITTEN_KEY = "_t.gif";
    private static final TrinidadLogger _LOG = TrinidadLogger.createTrinidadLogger(XhtmlRenderer.class);

    protected XhtmlRenderer(FacesBean.Type type) {
        this.findTypeConstants(type);
    }

    public Renderer cloneWithType(FacesBean.Type type) {
        try {
            XhtmlRenderer that = (XhtmlRenderer)this.clone();
            that.findTypeConstants(type);
            return that;
        }
        catch (CloneNotSupportedException cnse) {
            _LOG.severe((Throwable)cnse);
            return null;
        }
    }

    protected void findTypeConstants(FacesBean.Type type) {
        this._shortDescKey = type.findKey("shortDesc");
        this._styleClassKey = type.findKey("styleClass");
        this._inlineStyleKey = type.findKey("inlineStyle");
        this._onclickKey = type.findKey("onclick");
        this._ondblclickKey = type.findKey("ondblclick");
        this._onkeydownKey = type.findKey("onkeydown");
        this._onkeyupKey = type.findKey("onkeyup");
        this._onkeypressKey = type.findKey("onkeypress");
        this._onmousedownKey = type.findKey("onmousedown");
        this._onmousemoveKey = type.findKey("onmousemove");
        this._onmouseoutKey = type.findKey("onmouseout");
        this._onmouseoverKey = type.findKey("onmouseover");
        this._onmouseupKey = type.findKey("onmouseup");
        this._partialTriggersKey = type.findKey("partialTriggers");
    }

    public static boolean supportsScripting(RenderingContext arc) {
        Object scriptingSpeed = arc.getAgent().getCapabilities().get(TrinidadAgent.CAP_SCRIPTING_SPEED);
        return scriptingSpeed != null && TrinidadAgent.SCRIPTING_SPEED_CAP_NONE != scriptingSpeed;
    }

    public static boolean supportsEditing(RenderingContext arc) {
        Object cap = arc.getAgent().getCapabilities().get(TrinidadAgent.CAP_EDITING);
        return !Boolean.FALSE.equals(cap);
    }

    public static boolean supportsAdvancedForms(RenderingContext arc) {
        Object cap = arc.getAgent().getCapabilities().get(TrinidadAgent.CAP_ADVANCED_FORMS);
        return !Boolean.FALSE.equals(cap);
    }

    public static boolean supportsIntrinsicEvents(RenderingContext arc) {
        Object cap = arc.getAgent().getCapabilities().get(TrinidadAgent.CAP_INTRINSIC_EVENTS);
        return !Boolean.FALSE.equals(cap);
    }

    public static boolean supportsStyleAttributes(RenderingContext arc) {
        return arc.getAgent().getCapabilities().get(TrinidadAgent.CAP_STYLE_ATTRIBUTES) != TrinidadAgent.STYLES_NONE;
    }

    public static boolean supportsNavigation(RenderingContext arc) {
        Object cap = arc.getAgent().getCapabilities().get(TrinidadAgent.CAP_NAVIGATION);
        return !Boolean.FALSE.equals(cap);
    }

    public static boolean supportsTextPresentation(RenderingContext arc) {
        Object cap = arc.getAgent().getCapabilities().get(TrinidadAgent.CAP_TEXT_PRESENTATION);
        return !Boolean.FALSE.equals(cap);
    }

    public static boolean supportsAccessKeys(RenderingContext arc) {
        if (XhtmlRenderer.isScreenReaderMode((RenderingContext)arc)) {
            return false;
        }
        Object cap = arc.getAgent().getCapabilities().get(TrinidadAgent.CAP_ACCESS_KEYS);
        return !Boolean.FALSE.equals(cap);
    }

    public static final boolean supportsDisabledFormElements(RenderingContext arc) {
        Object cap = arc.getAgent().getCapabilities().get(TrinidadAgent.CAP_DISABLED_FORM_ELEMENTS);
        return !Boolean.FALSE.equals(cap);
    }

    public static final boolean supportsReadonlyFormElements(RenderingContext arc) {
        Object cap = arc.getAgent().getCapabilities().get(TrinidadAgent.CAP_READONLY_FORM_ELEMENTS);
        return !Boolean.FALSE.equals(cap);
    }

    public static final boolean supportsAutoCompleteFormElements(RenderingContext arc) {
        Object cap = arc.getAgent().getCapabilities().get(TrinidadAgent.CAP_AUTO_COMPLETE_FORM_ELEMENTS);
        return !Boolean.FALSE.equals(cap);
    }

    public static final boolean supportsSeparateWindow(RenderingContext arc) {
        return XhtmlUtils.supportsSeparateWindow(arc.getAgent());
    }

    public static final boolean supportsTarget(RenderingContext arc) {
        Object cap = arc.getAgent().getCapabilities().get(TrinidadAgent.CAP_TARGET);
        return !Boolean.FALSE.equals(cap);
    }

    public static boolean supportsNarrowScreen(RenderingContext arc) {
        Object cap = arc.getAgent().getCapabilities().get(TrinidadAgent.CAP_NARROW_SCREEN);
        return Boolean.TRUE.equals(cap);
    }

    protected boolean skipDecode(FacesContext context) {
        return TrinidadFilterImpl.isExecutingDialogReturn(context);
    }

    protected boolean canSkipRendering(RenderingContext rc, String clientId) {
        PartialPageContext ppc = rc.getPartialPageContext();
        return ppc != null && !ppc.isInsidePartialTarget() && !ppc.isPartialTarget(clientId);
    }

    protected boolean canSkipRendering(FacesContext context, RenderingContext rc, UIComponent component) {
        PartialPageContext ppc = rc.getPartialPageContext();
        if (ppc == null || ppc.isInsidePartialTarget()) {
            return false;
        }
        String clientId = component.getClientId(context);
        return !ppc.isPartialTarget(clientId);
    }

    protected boolean shouldRenderId(FacesContext context, UIComponent component) {
        if (this.getPartialTriggers(this.getFacesBean(component)) != null) {
            return true;
        }
        return super.shouldRenderId(context, component);
    }

    protected void renderAllAttributes(FacesContext context, RenderingContext arc, FacesBean bean) throws IOException {
        this.renderAllAttributes(context, arc, bean, true);
    }

    protected void renderAllAttributes(FacesContext context, RenderingContext arc, FacesBean bean, boolean renderStyleAttrs) throws IOException {
        this.renderShortDescAttribute(context, arc, bean);
        if (XhtmlRenderer.supportsScripting(arc)) {
            this.renderEventHandlers(context, bean);
        }
        if (renderStyleAttrs) {
            this.renderStyleAttributes(context, arc, bean);
        }
    }

    public static void renderInlineStyleAttribute(FacesContext context, RenderingContext arc, String style) throws IOException {
        if (style != null && XhtmlRenderer.supportsStyleAttributes(arc)) {
            ResponseWriter writer = context.getResponseWriter();
            writer.writeAttribute("style", (Object)style, null);
        }
    }

    protected void renderInlineStyle(FacesContext context, RenderingContext arc, FacesBean bean) throws IOException {
        String style = this.getInlineStyle(bean);
        if (style != null) {
            context.getResponseWriter().writeAttribute("style", (Object)style, "inlineStyle");
        }
    }

    protected void renderShortDescAttribute(FacesContext context, RenderingContext arc, FacesBean bean) throws IOException {
        String shortDesc = this.getShortDesc(bean);
        if (shortDesc != null) {
            context.getResponseWriter().writeAttribute("title", (Object)shortDesc, "shortDesc");
        }
    }

    protected void renderStyleAttributes(FacesContext context, RenderingContext arc, FacesBean bean) throws IOException {
        this.renderStyleAttributes(context, arc, bean, this.getDefaultStyleClass(bean));
    }

    protected String getDefaultStyleClass(FacesBean bean) {
        return null;
    }

    protected void renderStyleAttributes(FacesContext context, RenderingContext arc, FacesBean bean, String defaultStyleClass) throws IOException {
        String styleClass = this.getStyleClass(bean);
        List<String> parsedStyleClasses = OutputUtils.parseStyleClassList(styleClass);
        if (defaultStyleClass != null) {
            if (styleClass != null) {
                int styleCount = parsedStyleClasses == null ? 1 : parsedStyleClasses.size();
                String[] styleClasses = new String[1 + styleCount];
                if (parsedStyleClasses != null) {
                    for (int i = 0; i < styleCount; ++i) {
                        styleClasses[i] = parsedStyleClasses.get(i);
                    }
                } else {
                    styleClasses[0] = styleClass;
                }
                styleClasses[styleCount] = defaultStyleClass;
                XhtmlRenderer.renderStyleClasses((FacesContext)context, (RenderingContext)arc, (String[])styleClasses);
            } else {
                XhtmlRenderer.renderStyleClass((FacesContext)context, (RenderingContext)arc, (String)defaultStyleClass);
            }
        } else if (styleClass != null) {
            if (parsedStyleClasses == null) {
                styleClass = arc.getStyleClass(styleClass);
                context.getResponseWriter().writeAttribute("class", (Object)arc.getStyleClass(styleClass), "styleClass");
            } else {
                XhtmlRenderer.renderStyleClasses((FacesContext)context, (RenderingContext)arc, (String[])parsedStyleClasses.toArray(new String[parsedStyleClasses.size()]));
            }
        }
        String style = this.getInlineStyle(bean);
        if (style != null) {
            context.getResponseWriter().writeAttribute("style", (Object)style, "inlineStyle");
        }
    }

    protected void renderEventHandlers(FacesContext context, FacesBean bean) throws IOException {
        ResponseWriter rw = context.getResponseWriter();
        rw.writeAttribute("onclick", (Object)this.getOnclick(bean), "onclick");
        rw.writeAttribute("ondblclick", (Object)this.getOndblclick(bean), "ondblclick");
        rw.writeAttribute("onkeydown", (Object)this.getOnkeydown(bean), "onkeydown");
        rw.writeAttribute("onkeyup", (Object)this.getOnkeyup(bean), "onkeyup");
        rw.writeAttribute("onkeypress", (Object)this.getOnkeypress(bean), "onkeypress");
        rw.writeAttribute("onmousedown", (Object)this.getOnmousedown(bean), "onmousedown");
        rw.writeAttribute("onmousemove", (Object)this.getOnmousemove(bean), "onmousemove");
        rw.writeAttribute("onmouseout", (Object)this.getOnmouseout(bean), "onmouseout");
        rw.writeAttribute("onmouseover", (Object)this.getOnmouseover(bean), "onmouseover");
        rw.writeAttribute("onmouseup", (Object)this.getOnmouseup(bean), "onmouseup");
    }

    protected static void renderHAlign(FacesContext context, RenderingContext arc, Object hAlign) throws IOException {
        if (hAlign != null) {
            boolean rtl = arc.isRightToLeft();
            if ("start".equals(hAlign)) {
                hAlign = rtl ? "right" : "left";
            } else if ("end".equals(hAlign)) {
                hAlign = rtl ? "left" : "right";
            }
            context.getResponseWriter().writeAttribute("align", hAlign, null);
        }
    }

    protected final void renderPossiblyFormattedText(FacesContext context, Object textValue) throws IOException {
        if (textValue != null) {
            String textStr = textValue.toString();
            if (this._isTextFormatted(textStr)) {
                this._getFormattedTextParser().writeFormattedText(context, textStr);
            } else {
                context.getResponseWriter().writeText((Object)textStr, null);
            }
        }
    }

    protected final void renderFormattedText(FacesContext context, Object textValue) throws IOException {
        if (textValue != null) {
            String textStr = textValue.toString();
            this._getFormattedTextParser().writeFormattedText(context, textStr);
        }
    }

    private boolean _isTextFormatted(String textStr) {
        return textStr.startsWith("<html>");
    }

    private FormattedTextParser _getFormattedTextParser() {
        return XhtmlFormattedText.getFormattedTextParser();
    }

    public static String getAbsoluteImageUri(FacesContext context, RenderingContext arc, String imagePath) {
        return XhtmlRenderer.getBaseImageUri(context, arc) + imagePath;
    }

    protected static String getBaseImageUri(FacesContext context, RenderingContext arc) {
        String contextUri = context.getExternalContext().getRequestContextPath();
        return contextUri + "/adf/images/";
    }

    protected final void renderDecorativeIcon(FacesContext context, RenderingContext arc, String iconUri, Object width, Object height, Object id, Object altText) throws IOException {
        this.renderDecorativeIcon(context, arc, iconUri, width, height, id, altText, null);
    }

    protected final void renderDecorativeIcon(FacesContext context, RenderingContext arc, String iconUri, Object width, Object height, Object id, Object altText, UIComponent comp) throws IOException {
        String absoluteUri = XhtmlRenderer.getAbsoluteImageUri(context, arc, iconUri);
        if (altText == null && !XhtmlRenderer.isInaccessibleMode((RenderingContext)arc)) {
            altText = "";
        }
        OutputUtils.renderImage(context, arc, absoluteUri, width, height, id, altText, comp);
    }

    protected final void renderVerticalSpacer(FacesContext context, Object height, Object id, UIComponent comp) throws IOException {
        if (height != null) {
            ResponseWriter writer = context.getResponseWriter();
            writer.startElement("div", comp);
            writer.writeAttribute("id", id, null);
            String heightString = height.toString();
            if (heightString.length() != 0) {
                boolean isUnitsNotSpecified = Character.isDigit(heightString.charAt(heightString.length() - 1));
                if (isUnitsNotSpecified) {
                    heightString = heightString + "px";
                }
                writer.writeAttribute("style", (Object)("margin-top:" + heightString), null);
            }
            writer.endElement("div");
        }
    }

    protected final void renderSpacer(FacesContext context, RenderingContext arc, String width, String height) throws IOException {
        this.renderTransparent(context, arc, width, height, false, null);
    }

    protected final void renderTransparent(FacesContext context, RenderingContext arc, String width, String height, boolean needsQuoting, Object id) throws IOException {
        int count;
        Counter counter = (Counter)XhtmlRenderer.getRenderingProperty((RenderingContext)arc, (Object)_SCRIPT_SPACER_COUNT);
        if (counter == null) {
            counter = new Counter();
            XhtmlRenderer.setRenderingProperty((RenderingContext)arc, (Object)_SCRIPT_SPACER_COUNT, (Object)counter);
        }
        boolean useScript = (count = counter.count++) < 800 && TrinidadAgent.SCRIPTING_SPEED_CAP_FAST == arc.getAgent().getCapabilities().get(TrinidadAgent.CAP_SCRIPTING_SPEED);
        this._renderTransparent(context, arc, width, height, needsQuoting, id, useScript);
    }

    protected Object resolveProperty(FacesBean bean, PropertyKey key) {
        return this.resolveProperty(bean, key, true);
    }

    protected Object resolveProperty(FacesBean bean, PropertyKey key, boolean checkDefault) {
        if (key == null) {
            return null;
        }
        Object value = bean.getProperty(key);
        if (value == null && checkDefault) {
            value = key.getDefault();
        }
        return value;
    }

    private void _renderTransparent(FacesContext context, RenderingContext arc, String width, String height, boolean needsQuoting, Object id, boolean useScript) throws IOException {
        PartialPageContext pContext = arc.getPartialPageContext();
        if (!useScript || pContext != null) {
            this.renderDecorativeIcon(context, arc, TRANSPARENT_GIF, width, height, id, null);
        } else {
            ResponseWriter writer = context.getResponseWriter();
            if (XhtmlRenderer.getRenderingProperty((RenderingContext)arc, (Object)_TRANSPARENT_FUNCTION_WRITTEN_KEY) == null) {
                String transparentURI = XhtmlRenderer.getAbsoluteImageUri(context, arc, TRANSPARENT_GIF);
                XhtmlRenderer.setRenderingProperty((RenderingContext)arc, (Object)_TRANSPARENT_FUNCTION_WRITTEN_KEY, (Object)Boolean.TRUE);
                XhtmlUtils.addLib(context, arc, "t()");
                writer.startElement("script", null);
                XhtmlRenderer.renderScriptTypeAttribute(context, arc);
                writer.writeAttribute("id", id, null);
                writer.write("var _tURL=\"" + transparentURI + "\";");
                writer.write("var _axm");
                if (!XhtmlRenderer.isInaccessibleMode((RenderingContext)arc)) {
                    writer.write("=1");
                }
                writer.write(";");
            } else {
                writer.startElement("script", null);
                XhtmlRenderer.renderScriptTypeAttribute(context, arc);
                writer.writeAttribute("id", id, null);
            }
            writer.write("t(");
            if (width != null || height != null) {
                String widthParam = "void 0";
                if (width != null) {
                    widthParam = width;
                    if (needsQuoting) {
                        writer.write("'");
                    }
                }
                writer.write(widthParam);
                if (needsQuoting && width != null) {
                    writer.write("'");
                }
                if (height != null) {
                    writer.write(",");
                    if (needsQuoting) {
                        writer.write("'");
                    }
                    writer.write(height);
                    if (needsQuoting) {
                        writer.write("'");
                    }
                }
            }
            writer.write(")");
            writer.endElement("script");
        }
    }

    public static void renderScriptDeferAttribute(FacesContext context, RenderingContext arc) throws IOException {
    }

    public static void renderScriptTypeAttribute(FacesContext context, RenderingContext arc) throws IOException {
        if (!XhtmlRenderer.isInaccessibleMode((RenderingContext)arc)) {
            context.getResponseWriter().writeAttribute("type", (Object)_ACCESSIBILITY_SCRIPT_TYPE, null);
        }
    }

    public static void renderSubmitButtonNonJSBrowser(FacesContext context, RenderingContext arc, String valueAttri, String nameAttri) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("input", null);
        writer.writeAttribute("type", (Object)"submit", null);
        writer.writeAttribute("value", (Object)valueAttri, null);
        writer.writeAttribute("name", (Object)nameAttri, null);
        XhtmlRenderer.renderStyleClass((FacesContext)context, (RenderingContext)arc, (String)"af|commandButton");
        writer.endElement("input");
    }

    protected String getShortDesc(FacesBean bean) {
        return XhtmlRenderer.toString((Object)bean.getProperty(this._shortDescKey));
    }

    protected String getStyleClass(FacesBean bean) {
        return XhtmlRenderer.toString((Object)bean.getProperty(this._styleClassKey));
    }

    protected String getInlineStyle(FacesBean bean) {
        return XhtmlRenderer.toString((Object)bean.getProperty(this._inlineStyleKey));
    }

    protected String getOnclick(FacesBean bean) {
        if (this._onclickKey == null) {
            return null;
        }
        return XhtmlRenderer.toString((Object)bean.getProperty(this._onclickKey));
    }

    protected String getOndblclick(FacesBean bean) {
        if (this._ondblclickKey == null) {
            return null;
        }
        return XhtmlRenderer.toString((Object)bean.getProperty(this._ondblclickKey));
    }

    protected String getOnkeydown(FacesBean bean) {
        if (this._onkeydownKey == null) {
            return null;
        }
        return XhtmlRenderer.toString((Object)bean.getProperty(this._onkeydownKey));
    }

    protected String getOnkeyup(FacesBean bean) {
        if (this._onkeyupKey == null) {
            return null;
        }
        return XhtmlRenderer.toString((Object)bean.getProperty(this._onkeyupKey));
    }

    protected String getOnkeypress(FacesBean bean) {
        if (this._onkeypressKey == null) {
            return null;
        }
        return XhtmlRenderer.toString((Object)bean.getProperty(this._onkeypressKey));
    }

    protected String getOnmousedown(FacesBean bean) {
        if (this._onmousedownKey == null) {
            return null;
        }
        return XhtmlRenderer.toString((Object)bean.getProperty(this._onmousedownKey));
    }

    protected String getOnmousemove(FacesBean bean) {
        if (this._onmousemoveKey == null) {
            return null;
        }
        return XhtmlRenderer.toString((Object)bean.getProperty(this._onmousemoveKey));
    }

    protected String getOnmouseout(FacesBean bean) {
        if (this._onmouseoutKey == null) {
            return null;
        }
        return XhtmlRenderer.toString((Object)bean.getProperty(this._onmouseoutKey));
    }

    protected String getOnmouseover(FacesBean bean) {
        if (this._onmouseoverKey == null) {
            return null;
        }
        return XhtmlRenderer.toString((Object)bean.getProperty(this._onmouseoverKey));
    }

    protected String getOnmouseup(FacesBean bean) {
        if (this._onmouseupKey == null) {
            return null;
        }
        return XhtmlRenderer.toString((Object)bean.getProperty(this._onmouseupKey));
    }

    protected String[] getPartialTriggers(FacesBean bean) {
        if (this._partialTriggersKey == null) {
            return null;
        }
        return (String[])bean.getProperty(this._partialTriggersKey);
    }

    public static boolean supportsOnClickOnImgInput(RenderingContext arc) {
        Object cap = arc.getAgent().getCapabilities().get(TrinidadAgent.CAP_ONCLICK_IMG_INPUT);
        return !Boolean.FALSE.equals(cap);
    }

    private static final class Counter {
        public int count = 0;

        private Counter() {
        }
    }
}

