/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.renderkit.core.xhtml;

import java.awt.Dimension;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.render.Renderer;
import org.apache.myfaces.trinidad.bean.FacesBean;
import org.apache.myfaces.trinidad.bean.PropertyKey;
import org.apache.myfaces.trinidad.component.ComponentProcessingContext;
import org.apache.myfaces.trinidad.component.ComponentProcessor;
import org.apache.myfaces.trinidad.component.UIXComponent;
import org.apache.myfaces.trinidad.component.UIXEditableValue;
import org.apache.myfaces.trinidad.component.core.layout.CorePanelFormLayout;
import org.apache.myfaces.trinidad.context.Agent;
import org.apache.myfaces.trinidad.context.RenderingContext;
import org.apache.myfaces.trinidad.render.CoreRenderer;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.InputLabelAndMessageRenderer;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.LabelAndMessageRenderer;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.OutputUtils;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.XhtmlRenderer;

public class PanelFormLayoutRenderer
extends XhtmlRenderer {
    protected static final String PANEL_FORM_LAYOUT_LABELS_START_ALIGNED_KEY = "oracle.adfinternal.PanelFormLayoutLabelsStartAligned";
    private PropertyKey _labelAlignmentKey;
    private PropertyKey _labelWidthKey;
    private PropertyKey _fieldWidthKey;
    private PropertyKey _rowsKey;
    private PropertyKey _maxColumnsKey;
    private final RenderedItemExtractor _renderedItemExtractor = new RenderedItemExtractor();
    private final FormColumnEncoder _formColumnEncoder = new FormColumnEncoder();
    private static final Set<String> _UNSUPPORTED_RENDERER_TYPES = new HashSet<String>(64);
    private static final String _PANEL_FORM_LAYOUT_FORM_ITEM_KEY = "org.apache.myfaces.trinidadinternal.PanelFormLayoutFormItem";
    private static final String _PANEL_FORM_LAYOUT_NEST_LEVEL_KEY = "org.apache.myfaces.trinidadinternal.PanelFormNestLevel";
    private static final int _COLUMNS_DEFAULT = 3;
    private static final Map<String, String> _RESOURCE_KEY_SIDE_BY_SIDE_MAP;
    private static final Map<String, String> _RESOURCE_KEY_STACKED_MAP;

    public PanelFormLayoutRenderer() {
        super(CorePanelFormLayout.TYPE);
    }

    @Override
    protected void findTypeConstants(FacesBean.Type type) {
        super.findTypeConstants(type);
        this._labelAlignmentKey = type.findKey("labelAlignment");
        this._labelWidthKey = type.findKey("labelWidth");
        this._fieldWidthKey = type.findKey("fieldWidth");
        this._rowsKey = type.findKey("rows");
        this._maxColumnsKey = type.findKey("maxColumns");
    }

    public boolean getRendersChildren() {
        return true;
    }

    @Override
    protected void renderStyleAttributes(FacesContext context, RenderingContext rc, UIComponent component, FacesBean bean) throws IOException {
        this.renderStyleAttributes(context, rc, component, bean, "af|panelFormLayout");
    }

    @Override
    protected String getDefaultStyleClass(UIComponent component, FacesBean bean) {
        return "AFLabelText";
    }

    protected void encodeAll(FacesContext context, RenderingContext rc, UIComponent component, FacesBean bean) throws IOException {
        Number rowsNumber;
        ResponseWriter rw = context.getResponseWriter();
        rw.startElement("div", component);
        this.renderId(context, component);
        this.renderAllAttributes(context, rc, component, bean);
        int maxColumns = 0;
        Number maxColumnsNumber = this._getMaxColumns(component, bean);
        maxColumns = maxColumnsNumber != null ? maxColumnsNumber.intValue() : this._getColumnsDefault();
        int rows = 0;
        if (PanelFormLayoutRenderer.isPDA((RenderingContext)rc)) {
            maxColumns = 1;
        }
        if ((rowsNumber = this._getRows(component, bean)) == null) {
            rows = Integer.MAX_VALUE;
        } else {
            rows = rowsNumber.intValue();
            if (rows < 1) {
                rows = Integer.MAX_VALUE;
            }
        }
        this._encodeChildren(context, rc, component, bean, maxColumns, rows);
        rw.endElement("div");
    }

    static boolean __isInPanelFormLayout(FacesContext context, UIComponent component) {
        Map requestMap = context.getExternalContext().getRequestMap();
        Object formItem = requestMap.get(_PANEL_FORM_LAYOUT_FORM_ITEM_KEY);
        return component.equals(formItem);
    }

    private void _encodeChildren(FacesContext context, RenderingContext rc, UIComponent component, FacesBean bean, int maxColumns, int rows) throws IOException {
        boolean startAlignedLabels;
        int nestLevel = PanelFormLayoutRenderer._getNestLevel(context, -1) + 1;
        Map requestMap = context.getExternalContext().getRequestMap();
        requestMap.put(_PANEL_FORM_LAYOUT_NEST_LEVEL_KEY, nestLevel);
        List formChildren = component.getChildren();
        GroupingState renderedGroupingStates = new GroupingState(formChildren.size());
        UIXComponent.processFlattenedChildren((FacesContext)context, (ComponentProcessor)this._renderedItemExtractor, (Iterable)formChildren, (Object)renderedGroupingStates);
        List<GroupState> renderedGroupStates = renderedGroupingStates.groupStates;
        int totalFormItemCount = renderedGroupStates.size();
        UIComponent footerFacetComponent = PanelFormLayoutRenderer.getFacet((UIComponent)component, (String)"footer");
        int totalFooterItemCount = 0;
        List<GroupState> footerGroupStates = null;
        if (footerFacetComponent != null) {
            GroupingState footerGroupingStates = new GroupingState(footerFacetComponent.getChildCount());
            UIXComponent.processFlattenedChildren((FacesContext)context, (ComponentProcessor)this._renderedItemExtractor, (UIComponent)footerFacetComponent, (Object)footerGroupingStates);
            footerGroupStates = footerGroupingStates.groupStates;
            totalFooterItemCount = footerGroupStates.size();
        }
        int[] renderedGroupSizes = new int[totalFormItemCount];
        int renderedGroupsCount = PanelFormLayoutRenderer._computeRenderedGroupSizes(renderedGroupStates, renderedGroupSizes);
        int actualColumns = maxColumns;
        int actualRows = rows;
        Object labelAlignment = PanelFormLayoutRenderer.supportsNarrowScreen(rc) ? "top" : this._getLabelAlignment(component, bean);
        boolean forceSingleColumn = nestLevel != 0;
        boolean bl = startAlignedLabels = !forceSingleColumn;
        if ("start".equals(labelAlignment)) {
            startAlignedLabels = true;
        } else if ("top".equals(labelAlignment)) {
            startAlignedLabels = false;
        }
        if (forceSingleColumn || totalFormItemCount == 0) {
            actualColumns = 1;
            actualRows = Integer.MAX_VALUE;
        } else if (actualColumns == 1) {
            actualRows = Integer.MAX_VALUE;
        } else {
            Dimension actualResults = PanelFormLayoutRenderer._computeActualColumnsAndRows(actualColumns, actualRows, totalFormItemCount, renderedGroupSizes, renderedGroupsCount);
            actualColumns = (int)actualResults.getWidth();
            actualRows = (int)actualResults.getHeight();
        }
        if (actualColumns < 1) {
            return;
        }
        String labelWidth = (String)this._getLabelWidth(component, bean);
        String fieldWidth = (String)this._getFieldWidth(component, bean);
        ResponseWriter rw = context.getResponseWriter();
        rw.startElement("table", null);
        OutputUtils.renderLayoutTableAttributes(context, rc, "0", null);
        FormWidths effectiveWidths = this._getFormWidths(startAlignedLabels, labelWidth, fieldWidth, actualColumns);
        rw.writeAttribute("style", (Object)("width: " + effectiveWidths.getOverallWidth()), null);
        rw.startElement("tbody", null);
        rw.startElement("tr", null);
        List<LayoutAction> renderedLayoutActions = PanelFormLayoutRenderer._computeLayoutActions(actualRows, renderedGroupSizes, renderedGroupStates);
        ColumnEncodingState columnEncodingState = new ColumnEncodingState(rc, startAlignedLabels, effectiveWidths.getMainLabelWidth(), effectiveWidths.getMainFieldWidth(), actualColumns, actualRows, 1, renderedLayoutActions);
        UIXComponent.encodeFlattenedChildren((FacesContext)context, (ComponentProcessor)this._formColumnEncoder, (Iterable)formChildren, (Object)columnEncodingState);
        rw.endElement("tr");
        if (totalFooterItemCount > 0) {
            rw.startElement("tr", null);
            int[] footerGroupSizes = new int[totalFooterItemCount];
            PanelFormLayoutRenderer._computeRenderedGroupSizes(footerGroupStates, footerGroupSizes);
            List<LayoutAction> footerLayoutActions = PanelFormLayoutRenderer._computeLayoutActions(totalFooterItemCount, footerGroupSizes, footerGroupStates);
            ColumnEncodingState footerEncodingState = new ColumnEncodingState(rc, startAlignedLabels, effectiveWidths.getFooterLabelWidth(), effectiveWidths.getFooterFieldWidth(), 1, totalFooterItemCount, actualColumns, footerLayoutActions);
            UIXComponent.encodeFlattenedChild((FacesContext)context, (ComponentProcessor)this._formColumnEncoder, (UIComponent)footerFacetComponent, (Object)footerEncodingState);
            rw.endElement("tr");
        }
        if (nestLevel == 0) {
            requestMap.remove(_PANEL_FORM_LAYOUT_NEST_LEVEL_KEY);
        } else {
            requestMap.put(_PANEL_FORM_LAYOUT_NEST_LEVEL_KEY, nestLevel - 1);
        }
        rw.endElement("tbody");
        rw.endElement("table");
    }

    private static int _computeRenderedGroupSizes(List<GroupState> groupStates, int[] renderedGroupSizes) {
        int totalFormItemCount = renderedGroupSizes.length;
        int currGroupSize = 0;
        int renderedGroupsCount = 0;
        for (int itemIndex = 0; itemIndex < totalFormItemCount; ++itemIndex) {
            GroupState currGroupState = groupStates.get(itemIndex);
            if (GroupState.IN_GROUP.equals((Object)currGroupState)) {
                ++currGroupSize;
                continue;
            }
            assert (GroupState.START_GROUP.equals((Object)currGroupState) || GroupState.OUTSIDE_GROUP.equals((Object)currGroupState) || GroupState.IN_GROUP_TRANSITION.equals((Object)currGroupState)) : "unexpected groups state";
            if (currGroupSize > 0) {
                renderedGroupSizes[renderedGroupsCount++] = currGroupSize;
            }
            currGroupSize = 1;
        }
        if (currGroupSize > 0) {
            renderedGroupSizes[renderedGroupsCount++] = currGroupSize;
        }
        return renderedGroupsCount;
    }

    private static List<LayoutAction> _computeLayoutActions(int rowCount, int[] renderedGroupSizes, List<GroupState> groupStates) {
        int totalFormItemCount = groupStates.size();
        if (totalFormItemCount == 0) {
            return Collections.emptyList();
        }
        ArrayList<LayoutAction> layoutActions = new ArrayList<LayoutAction>(totalFormItemCount);
        int currRowIndex = 0;
        int renderedGroupIndex = 0;
        int groupEndIndex = renderedGroupSizes[0];
        GroupState lastGroupState = GroupState.OUTSIDE_GROUP;
        for (int i = 0; i < totalFormItemCount; ++i) {
            if (i == groupEndIndex) {
                int groupSize = renderedGroupSizes[++renderedGroupIndex];
                groupEndIndex += groupSize;
                if (currRowIndex + groupSize > rowCount) {
                    currRowIndex = 0;
                }
            }
            GroupState currGroupState = groupStates.get(i);
            LayoutAction layoutAction = currRowIndex == 0 ? LayoutAction.NEW_COLUMN : (GroupState.START_GROUP.equals((Object)currGroupState) || GroupState.IN_GROUP_TRANSITION.equals((Object)currGroupState) || GroupState.OUTSIDE_GROUP.equals((Object)currGroupState) && GroupState.IN_GROUP.equals((Object)lastGroupState) || GroupState.OUTSIDE_GROUP.equals((Object)currGroupState) && GroupState.IN_GROUP_TRANSITION.equals((Object)lastGroupState) || GroupState.OUTSIDE_GROUP.equals((Object)currGroupState) && GroupState.START_GROUP.equals((Object)lastGroupState) ? LayoutAction.NEW_GROUP : LayoutAction.FLAT);
            layoutActions.add(layoutAction);
            lastGroupState = currGroupState;
            ++currRowIndex;
        }
        return layoutActions;
    }

    private static Dimension _computeActualColumnsAndRows(int guessColumns, int guessRows, int totalFormItemCount, int[] renderedGroupSizes, int renderedGroupsCount) {
        if (totalFormItemCount == 0) {
            return new Dimension(0, 0);
        }
        int actualColumns = guessColumns;
        int rowsPerColumn = (totalFormItemCount + actualColumns - 1) / actualColumns;
        int actualRows = guessRows;
        if (rowsPerColumn > actualRows) {
            actualRows = rowsPerColumn;
        }
        boolean itemsWillFit = false;
        while (!itemsWillFit) {
            int currentItemIndex = 0;
            block1: for (int col = 0; col < actualColumns && !itemsWillFit; ++col) {
                int itemSize;
                for (int currentRow = 0; currentRow < actualRows; currentRow += itemSize) {
                    itemSize = renderedGroupSizes[currentItemIndex];
                    if (currentRow != 0 && currentRow + itemSize > actualRows) continue block1;
                    if (++currentItemIndex < renderedGroupsCount) continue;
                    actualColumns = 1 + col;
                    itemsWillFit = true;
                    continue block1;
                }
            }
            if (itemsWillFit) continue;
            ++actualRows;
        }
        return new Dimension(actualColumns, actualRows);
    }

    private FormWidths _getFormWidths(boolean startAlignLabels, String labelWidth, String fieldWidth, int actualColumns) {
        int percentCharIndex;
        WidthType labelWidthType = WidthType.NONE;
        WidthType fieldWidthType = WidthType.NONE;
        if (labelWidth != null) {
            percentCharIndex = labelWidth.indexOf("%");
            WidthType widthType = labelWidthType = percentCharIndex == -1 ? WidthType.PIXEL : WidthType.PERCENT;
        }
        if (fieldWidth != null) {
            percentCharIndex = fieldWidth.indexOf("%");
            fieldWidthType = percentCharIndex == -1 ? WidthType.PIXEL : WidthType.PERCENT;
        }
        return startAlignLabels ? this._getStartAlignedFormWidths(labelWidth, labelWidthType, fieldWidth, fieldWidthType, actualColumns) : this._getTopAlignedFormWidths(labelWidth, labelWidthType, fieldWidth, fieldWidthType, actualColumns);
    }

    private FormWidths _getStartAlignedFormWidths(String labelWidth, WidthType labelWidthType, String fieldWidth, WidthType fieldWidthType, int actualColumns) {
        String effectiveLabelWidth = null;
        String effectiveFieldWidth = null;
        String effectiveFooterLabelWidth = null;
        String effectiveFooterFieldWidth = null;
        String outerTableWidth = "100%";
        double labelRatio = 1.0;
        double fieldRatio = 1.0;
        if (labelWidthType.equals((Object)WidthType.PERCENT) ^ fieldWidthType.equals((Object)WidthType.PERCENT)) {
            int percentValue;
            int percentCharIndex;
            if (labelWidthType.equals((Object)WidthType.PERCENT)) {
                percentCharIndex = labelWidth.indexOf("%");
                percentValue = Integer.valueOf(labelWidth.substring(0, percentCharIndex));
                fieldWidth = 100 - percentValue + "%";
                fieldWidthType = WidthType.PERCENT;
            } else {
                percentCharIndex = fieldWidth.indexOf("%");
                percentValue = Integer.valueOf(fieldWidth.substring(0, percentCharIndex));
                labelWidth = 100 - percentValue + "%";
                labelWidthType = WidthType.PERCENT;
            }
        }
        if (labelWidthType.equals((Object)WidthType.PIXEL)) {
            effectiveFooterLabelWidth = effectiveLabelWidth = labelWidth + "px";
        }
        if (fieldWidthType.equals((Object)WidthType.PIXEL)) {
            effectiveFooterFieldWidth = effectiveFieldWidth = fieldWidth + "px";
        }
        if (labelWidthType.equals((Object)WidthType.PERCENT) && fieldWidthType.equals((Object)WidthType.PERCENT)) {
            int labelPercentCharIndex = labelWidth.indexOf("%");
            labelRatio = Double.valueOf(labelWidth.substring(0, labelPercentCharIndex));
            int fieldPercentCharIndex = fieldWidth.indexOf("%");
            fieldRatio = Double.valueOf(fieldWidth.substring(0, fieldPercentCharIndex));
            RenderingContext arc = RenderingContext.getCurrentInstance();
            Agent agent = arc.getAgent();
            boolean isBlackBerry = "blackberry".equals(agent.getAgentName());
            double ratioTotal = (labelRatio + fieldRatio) / 100.0;
            double effectiveLabelWidthDouble = labelRatio / ratioTotal;
            double footerLabel = effectiveLabelWidthDouble / (double)actualColumns;
            double footerField = 100.0 - footerLabel;
            if (isBlackBerry) {
                effectiveLabelWidth = (int)effectiveLabelWidthDouble + "%";
                effectiveFieldWidth = (int)(fieldRatio / ratioTotal) + "%";
                effectiveFooterLabelWidth = (int)this._roundTo2DecimalPlaces(footerLabel) + "%";
                effectiveFooterFieldWidth = (int)this._roundTo2DecimalPlaces(footerField) + "%";
            } else {
                effectiveLabelWidth = Math.floor(effectiveLabelWidthDouble) + "%";
                effectiveFieldWidth = Math.floor(fieldRatio / ratioTotal) + "%";
                effectiveFooterLabelWidth = this._roundTo2DecimalPlaces(footerLabel) + "%";
                effectiveFooterFieldWidth = this._roundTo2DecimalPlaces(footerField) + "%";
            }
        } else if (labelWidthType.equals((Object)WidthType.PIXEL) && fieldWidthType.equals((Object)WidthType.PIXEL)) {
            int labelPixels = Integer.valueOf(labelWidth);
            int fieldPixels = Integer.valueOf(fieldWidth);
            int outerTablePixels = (labelPixels + fieldPixels) * actualColumns;
            outerTableWidth = outerTablePixels + "px";
            effectiveFooterFieldWidth = outerTablePixels - labelPixels + "px";
        } else {
            outerTableWidth = "auto";
        }
        return new FormWidths(effectiveLabelWidth, effectiveFieldWidth, effectiveFooterLabelWidth, effectiveFooterFieldWidth, outerTableWidth);
    }

    private FormWidths _getTopAlignedFormWidths(String labelWidth, WidthType labelWidthType, String fieldWidth, WidthType fieldWidthType, int actualColumns) {
        String outerTableWidth;
        String effectiveLabelWidth = null;
        String effectiveFieldWidth = null;
        String effectiveFooterLabelWidth = null;
        String effectiveFooterFieldWidth = null;
        if (labelWidthType.equals((Object)WidthType.NONE) && fieldWidthType.equals((Object)WidthType.NONE)) {
            outerTableWidth = "auto";
        } else if (labelWidthType.equals((Object)WidthType.PERCENT) || fieldWidthType.equals((Object)WidthType.PERCENT)) {
            outerTableWidth = "100%";
            effectiveLabelWidth = labelWidthType.equals((Object)WidthType.PERCENT) ? "100%" : null;
            effectiveFieldWidth = fieldWidthType.equals((Object)WidthType.PERCENT) ? "100%" : null;
            effectiveFooterLabelWidth = effectiveLabelWidth;
            effectiveFooterFieldWidth = effectiveFieldWidth;
        } else {
            int labelPixels = 0;
            int fieldPixels = 0;
            if (labelWidthType.equals((Object)WidthType.PIXEL)) {
                effectiveFooterLabelWidth = effectiveLabelWidth = labelWidth + "px";
                labelPixels = Integer.valueOf(labelWidth);
            }
            if (fieldWidthType.equals((Object)WidthType.PIXEL)) {
                effectiveFooterFieldWidth = effectiveFieldWidth = fieldWidth + "px";
                fieldPixels = Integer.valueOf(fieldWidth);
            }
            int tableSize = Math.max(labelPixels, fieldPixels) * actualColumns;
            outerTableWidth = tableSize + "px";
        }
        return new FormWidths(effectiveLabelWidth, effectiveFieldWidth, effectiveFooterLabelWidth, effectiveFooterFieldWidth, outerTableWidth);
    }

    private double _roundTo2DecimalPlaces(double value) {
        return (double)Math.round(value * 100.0) / 100.0;
    }

    private static void _encodeGroupDivider(FacesContext context, RenderingContext rc, boolean startAlignedLabels) throws IOException {
        ResponseWriter rw = context.getResponseWriter();
        rw.startElement("tr", null);
        rw.startElement("td", null);
        if (startAlignedLabels) {
            rw.writeAttribute("colspan", (Object)"2", null);
        }
        rw.startElement("div", null);
        PanelFormLayoutRenderer.renderStyleClass((FacesContext)context, (RenderingContext)rc, (String)"af|panelFormLayout::separator");
        rw.endElement("div");
        rw.endElement("td");
        rw.endElement("tr");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _encodeFormItem(FacesContext context, RenderingContext rc, boolean startAlignedLabels, UIComponent item) throws IOException {
        ResponseWriter rw = context.getResponseWriter();
        boolean isFullRow = this._isFullRow(context, item);
        if (isFullRow) {
            PanelFormLayoutRenderer._encodeBeforeLabelTd(context, startAlignedLabels);
            Map originalResourceKeyMap = rc.getSkinResourceKeyMap();
            Map<String, String> resourceKeys = startAlignedLabels ? _RESOURCE_KEY_SIDE_BY_SIDE_MAP : _RESOURCE_KEY_STACKED_MAP;
            rc.setSkinResourceKeyMap(resourceKeys);
            try {
                Map requestMap = context.getExternalContext().getRequestMap();
                Object formItemToRestore = requestMap.get(_PANEL_FORM_LAYOUT_FORM_ITEM_KEY);
                Object startAlignToRestore = requestMap.get(PANEL_FORM_LAYOUT_LABELS_START_ALIGNED_KEY);
                requestMap.put(_PANEL_FORM_LAYOUT_FORM_ITEM_KEY, item);
                requestMap.put(PANEL_FORM_LAYOUT_LABELS_START_ALIGNED_KEY, startAlignedLabels);
                Renderer renderer = this._getRenderer(context, item);
                boolean isSimple = this._isSimple(item, renderer);
                if (isSimple) {
                    rw.startElement("tr", null);
                    if (startAlignedLabels) {
                        rw.startElement("td", null);
                        rw.endElement("td");
                    }
                    rw.startElement("td", null);
                    PanelFormLayoutRenderer.renderStyleClass((FacesContext)context, (RenderingContext)rc, (String)"af|panelFormLayout::content-cell");
                }
                this.encodeChild(context, item);
                if (isSimple) {
                    rw.endElement("td");
                    rw.endElement("tr");
                }
                requestMap.put(_PANEL_FORM_LAYOUT_FORM_ITEM_KEY, formItemToRestore);
                requestMap.put(PANEL_FORM_LAYOUT_LABELS_START_ALIGNED_KEY, startAlignToRestore);
            }
            finally {
                rc.setSkinResourceKeyMap(originalResourceKeyMap);
            }
            PanelFormLayoutRenderer._encodeAfterFieldTd(context, startAlignedLabels);
        } else if (startAlignedLabels) {
            rw.startElement("tr", null);
            rw.startElement("td", null);
            rw.endElement("td");
            rw.startElement("td", null);
            PanelFormLayoutRenderer.renderStyleClass((FacesContext)context, (RenderingContext)rc, (String)"af|panelFormLayout::content-cell");
            this.encodeChild(context, item);
            rw.endElement("td");
            rw.endElement("tr");
        } else {
            rw.startElement("tr", null);
            rw.startElement("td", null);
            PanelFormLayoutRenderer.renderStyleClass((FacesContext)context, (RenderingContext)rc, (String)"af|panelFormLayout::content-cell");
            this.encodeChild(context, item);
            rw.endElement("td");
            rw.endElement("tr");
        }
    }

    private static void _encodeBeforeLabelTd(FacesContext context, boolean startAlignedLabels) throws IOException {
        ResponseWriter rw = context.getResponseWriter();
        if (!startAlignedLabels) {
            rw.startElement("tr", null);
            rw.startElement("td", null);
        }
    }

    private static void _encodeAfterFieldTd(FacesContext context, boolean startAlignedLabels) throws IOException {
        ResponseWriter rw = context.getResponseWriter();
        if (!startAlignedLabels) {
            rw.endElement("td");
            rw.endElement("tr");
        }
    }

    private boolean _isFullRow(FacesContext context, UIComponent component) {
        String rendererType = component.getRendererType();
        if (component instanceof UIXEditableValue) {
            return !_UNSUPPORTED_RENDERER_TYPES.contains(rendererType);
        }
        if ("org.apache.myfaces.trinidad.Panel".equals(component.getFamily()) && ("org.apache.myfaces.trinidad.LabelAndMessage".equals(rendererType) || "org.apache.myfaces.trinidad.rich.LabelAndMessage".equals(rendererType))) {
            return true;
        }
        Renderer renderer = this._getRenderer(context, component);
        if (renderer == null) {
            return false;
        }
        return renderer instanceof LabelAndMessageRenderer;
    }

    private boolean _isSimple(UIComponent component, Renderer renderer) {
        if (renderer != null && renderer instanceof InputLabelAndMessageRenderer) {
            return ((InputLabelAndMessageRenderer)renderer).getSimple(component, this.getFacesBean(component));
        }
        return false;
    }

    private Renderer _getRenderer(FacesContext context, UIComponent component) {
        String family = component.getFamily();
        String rendererType = component.getRendererType();
        if (rendererType == null) {
            return null;
        }
        return context.getRenderKit().getRenderer(family, rendererType);
    }

    private int _getColumnsDefault() {
        return 3;
    }

    private Object _getLabelWidth(UIComponent component, FacesBean bean) {
        return bean.getProperty(this._labelWidthKey);
    }

    private Object _getLabelAlignment(UIComponent component, FacesBean bean) {
        return bean.getProperty(this._labelAlignmentKey);
    }

    private Object _getFieldWidth(UIComponent component, FacesBean bean) {
        return bean.getProperty(this._fieldWidthKey);
    }

    private Number _getRows(UIComponent component, FacesBean bean) {
        return (Number)bean.getProperty(this._rowsKey);
    }

    private Number _getMaxColumns(UIComponent component, FacesBean bean) {
        return (Number)bean.getProperty(this._maxColumnsKey);
    }

    private static int _getNestLevel(FacesContext context, int defaultValue) {
        Map requestMap = context.getExternalContext().getRequestMap();
        Object nestLevelObject = requestMap.get(_PANEL_FORM_LAYOUT_NEST_LEVEL_KEY);
        return nestLevelObject != null ? (Integer)nestLevelObject : defaultValue;
    }

    static {
        _UNSUPPORTED_RENDERER_TYPES.add("org.apache.myfaces.trinidad.Hidden");
        _UNSUPPORTED_RENDERER_TYPES.add("org.apache.myfaces.trinidad.Shuttle");
        _UNSUPPORTED_RENDERER_TYPES.add("org.apache.myfaces.trinidad.rich.Hidden");
        _UNSUPPORTED_RENDERER_TYPES.add("org.apache.myfaces.trinidad.rich.Shuttle");
        _RESOURCE_KEY_SIDE_BY_SIDE_MAP = new HashMap<String, String>();
        _RESOURCE_KEY_STACKED_MAP = new HashMap<String, String>();
        _RESOURCE_KEY_SIDE_BY_SIDE_MAP.put("AFLabelText", "af|panelFormLayout::label-cell");
        _RESOURCE_KEY_SIDE_BY_SIDE_MAP.put("AFContentCell", "af|panelFormLayout::content-cell");
        _RESOURCE_KEY_SIDE_BY_SIDE_MAP.put("AFComponentMessageCell", "af|panelFormLayout::message-cell");
        _RESOURCE_KEY_STACKED_MAP.put("AFLabelText", "af|panelFormLayout::label-stacked-cell");
        _RESOURCE_KEY_STACKED_MAP.put("AFContentCell", "af|panelFormLayout::content-cell");
        _RESOURCE_KEY_STACKED_MAP.put("AFComponentMessageCell", "af|panelFormLayout::message-cell");
    }

    private class FormColumnEncoder
    implements ComponentProcessor<ColumnEncodingState> {
        private FormColumnEncoder() {
        }

        public void processComponent(FacesContext context, ComponentProcessingContext cpContext, UIComponent currChild, ColumnEncodingState columnEncodingState) throws IOException {
            ResponseWriter rw = context.getResponseWriter();
            boolean startAlignedLabels = columnEncodingState.startAlignedLabels;
            List<LayoutAction> layoutActions = columnEncodingState.layoutActions;
            LayoutAction currLayoutAction = layoutActions.get(columnEncodingState.childIndex);
            if (LayoutAction.NEW_COLUMN.equals((Object)currLayoutAction)) {
                if (columnEncodingState.childIndex > 0) {
                    this._finishColumn(rw);
                }
                int columnIndex = ++columnEncodingState.columnIndex;
                int columnCount = columnEncodingState.columnCount;
                int columnPercentage = 100 / columnCount;
                String outerColumnWidth = columnPercentage + "%";
                rw.startElement("td", null);
                CoreRenderer.renderStyleClass((FacesContext)context, (RenderingContext)columnEncodingState.rc, (String)"af|panelFormLayout::column");
                rw.writeAttribute("colspan", (Object)columnEncodingState.colSpan, null);
                if (columnIndex < columnCount - 1) {
                    rw.writeAttribute("width", (Object)outerColumnWidth, null);
                }
                rw.startElement("table", null);
                OutputUtils.renderLayoutTableAttributes(context, columnEncodingState.rc, "0", "100%");
                rw.startElement("tbody", null);
                if (startAlignedLabels) {
                    rw.startElement("tr", null);
                    rw.startElement("td", null);
                    if (columnEncodingState.effectiveLabelWidth != null) {
                        rw.writeAttribute("style", (Object)("width: " + columnEncodingState.effectiveLabelWidth), null);
                    }
                    rw.endElement("td");
                    rw.startElement("td", null);
                    if (columnEncodingState.effectiveFieldWidth != null) {
                        rw.writeAttribute("style", (Object)("width: " + columnEncodingState.effectiveFieldWidth), null);
                    }
                    rw.endElement("td");
                    rw.endElement("tr");
                }
            }
            if (LayoutAction.NEW_GROUP.equals((Object)currLayoutAction)) {
                PanelFormLayoutRenderer._encodeGroupDivider(context, columnEncodingState.rc, startAlignedLabels);
            }
            PanelFormLayoutRenderer.this._encodeFormItem(context, columnEncodingState.rc, startAlignedLabels, currChild);
            ++columnEncodingState.childIndex;
            if (columnEncodingState.childIndex == layoutActions.size()) {
                this._finishColumn(rw);
            }
        }

        private void _finishColumn(ResponseWriter rw) throws IOException {
            rw.endElement("tbody");
            rw.endElement("table");
            rw.endElement("td");
        }
    }

    private static class ColumnEncodingState {
        protected final RenderingContext rc;
        protected final boolean startAlignedLabels;
        protected final String effectiveLabelWidth;
        protected final String effectiveFieldWidth;
        protected final int columnCount;
        protected final int rowCount;
        protected final int colSpan;
        protected final List<LayoutAction> layoutActions;
        protected int childIndex;
        protected int columnIndex = -1;

        public ColumnEncodingState(RenderingContext rc, boolean startAlignedLabels, String effectiveLabelWidth, String effectiveFieldWidth, int columnCount, int rowCount, int colSpan, List<LayoutAction> layoutActions) {
            this.rc = rc;
            this.startAlignedLabels = startAlignedLabels;
            this.effectiveLabelWidth = effectiveLabelWidth;
            this.effectiveFieldWidth = effectiveFieldWidth;
            this.columnCount = columnCount;
            this.rowCount = rowCount;
            this.colSpan = colSpan;
            this.layoutActions = layoutActions;
        }
    }

    private class RenderedItemExtractor
    implements ComponentProcessor<GroupingState> {
        private RenderedItemExtractor() {
        }

        public void processComponent(FacesContext context, ComponentProcessingContext cpContext, UIComponent currChild, GroupingState groupingState) throws IOException {
            int groupDepth = cpContext.getGroupDepth();
            groupingState.groupStates.add(groupDepth == 0 ? GroupState.OUTSIDE_GROUP : (cpContext.getStartDepth() > 0 ? (groupingState.lastDepth == 0 ? GroupState.START_GROUP : GroupState.IN_GROUP_TRANSITION) : (groupingState.lastDepth == groupDepth ? GroupState.IN_GROUP : GroupState.IN_GROUP_TRANSITION)));
            groupingState.lastDepth = groupDepth;
        }
    }

    private static enum LayoutAction {
        NEW_COLUMN,
        NEW_GROUP,
        FLAT;

    }

    private static enum GroupState {
        START_GROUP,
        IN_GROUP,
        IN_GROUP_TRANSITION,
        OUTSIDE_GROUP;

    }

    private static class GroupingState {
        protected final List<GroupState> groupStates;
        protected int lastDepth;

        public GroupingState(int initialSize) {
            this.groupStates = new ArrayList<GroupState>(initialSize);
        }
    }

    private static class FormWidths {
        String _mainLabelWidth;
        String _mainFieldWidth;
        String _footerLabelWidth;
        String _footerFieldWidth;
        String _overallWidth;

        FormWidths(String mainLabelWidth, String mainFieldWidth, String footerLabelWidth, String footerFieldWidth, String overallWidth) {
            this._mainLabelWidth = mainLabelWidth;
            this._mainFieldWidth = mainFieldWidth;
            this._footerLabelWidth = footerLabelWidth;
            this._footerFieldWidth = footerFieldWidth;
            this._overallWidth = overallWidth;
        }

        String getMainLabelWidth() {
            return this._mainLabelWidth;
        }

        String getMainFieldWidth() {
            return this._mainFieldWidth;
        }

        String getFooterLabelWidth() {
            return this._footerLabelWidth;
        }

        String getFooterFieldWidth() {
            return this._footerFieldWidth;
        }

        String getOverallWidth() {
            return this._overallWidth;
        }
    }

    private static enum WidthType {
        NONE,
        PIXEL,
        PERCENT;

    }
}

