/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.skin;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Stack;
import javax.el.ValueExpression;
import javax.faces.context.FacesContext;
import org.apache.myfaces.trinidad.context.LocaleContext;
import org.apache.myfaces.trinidad.context.RenderingContext;
import org.apache.myfaces.trinidad.logging.TrinidadLogger;
import org.apache.myfaces.trinidad.skin.Icon;
import org.apache.myfaces.trinidad.skin.Skin;
import org.apache.myfaces.trinidad.skin.SkinAddition;
import org.apache.myfaces.trinidad.skin.SkinFeatures;
import org.apache.myfaces.trinidad.skin.SkinMetadata;
import org.apache.myfaces.trinidad.skin.SkinVersion;
import org.apache.myfaces.trinidad.util.ToStringHelper;
import org.apache.myfaces.trinidadinternal.skin.RequestSkinWrapper;
import org.apache.myfaces.trinidadinternal.skin.SkinImpl;
import org.apache.myfaces.trinidadinternal.skin.icon.ReferenceIcon;
import org.apache.myfaces.trinidadinternal.style.StyleContext;
import org.apache.myfaces.trinidadinternal.style.xml.StyleSheetDocumentUtils;
import org.apache.myfaces.trinidadinternal.style.xml.parse.StyleSheetDocument;

public class SkinExtension
extends SkinImpl {
    private final String _id;
    private final String _family;
    private final String _renderKitId;
    private final Skin _baseSkin;
    private final ValueExpression _translationSourceVE;
    private final SkinVersion _version;
    private final Map<String, String> _skinFeatures;
    private final boolean _isCacheable;
    private String _styleSheetName;
    private String _bundleName;
    private StyleSheetDocument _baseStyleSheetDocument;
    private StyleSheetDocument _extensionStyleSheetDocument;
    private StyleSheetDocument _fullStyleSheetDocument;
    private static final Icon _NULL_ICON = new NullIcon();
    private static final String _DEFAULT_RENDERKIT = "org.apache.myfaces.trinidad.desktop";
    private static final String _CIRCULAR_INCLUDE_ERROR = "Circular dependency detected in skin reference icon ";
    private static final TrinidadLogger _LOG = TrinidadLogger.createTrinidadLogger(SkinExtension.class);

    @Deprecated
    public SkinExtension(Skin baseSkin, String id, String family, String renderKitId, String styleSheetName, ValueExpression translationSourceValueExpression, SkinVersion version, Map<String, String> features, String resourceBundleName) {
        this(baseSkin, new SkinMetadata.Builder().id(id).family(family).renderKitId(SkinMetadata.RenderKitId.fromId((String)renderKitId)).styleSheetName(styleSheetName).translationSource(translationSourceValueExpression).version(version).features(new SkinFeatures(features)).resourceBundleName(resourceBundleName).build(), true);
    }

    @Deprecated
    public SkinExtension(Skin baseSkin, String id, String family, String renderKitId, String styleSheetName, String resourceBundleName) {
        this(baseSkin, id, family, renderKitId, styleSheetName, resourceBundleName, SkinVersion.EMPTY_SKIN_VERSION);
    }

    @Deprecated
    public SkinExtension(Skin baseSkin, String id, String family, String renderKitId, String styleSheetName, String resourceBundleName, SkinVersion version) {
        this(baseSkin, new SkinMetadata.Builder().id(id).family(family).renderKitId(SkinMetadata.RenderKitId.fromId((String)renderKitId)).styleSheetName(styleSheetName).resourceBundleName(resourceBundleName).version(version).build(), true);
    }

    @Deprecated
    public SkinExtension(Skin baseSkin, String id, String family, String renderKitId, String styleSheetName, ValueExpression translationSourceValueExpression) {
        this(baseSkin, id, family, renderKitId, styleSheetName, translationSourceValueExpression, SkinVersion.EMPTY_SKIN_VERSION);
    }

    @Deprecated
    public SkinExtension(Skin baseSkin, String id, String family, String renderKitId, String styleSheetName, ValueExpression translationSourceValueExpression, SkinVersion version) {
        this(baseSkin, new SkinMetadata.Builder().id(id).family(family).renderKitId(SkinMetadata.RenderKitId.fromId((String)renderKitId)).styleSheetName(styleSheetName).translationSource(translationSourceValueExpression).version(version).build(), true);
    }

    @Deprecated
    public SkinExtension(Skin baseSkin, String id, String family, String renderKitId, String styleSheetName) {
        this(baseSkin, id, family, renderKitId, styleSheetName, SkinVersion.EMPTY_SKIN_VERSION);
    }

    @Deprecated
    public SkinExtension(Skin baseSkin, String id, String family, String renderKitId, String styleSheetName, SkinVersion version) {
        this(baseSkin, new SkinMetadata.Builder().id(id).family(family).renderKitId(SkinMetadata.RenderKitId.fromId((String)renderKitId)).styleSheetName(styleSheetName).version(version).build(), true);
    }

    @Deprecated
    public SkinExtension(Skin baseSkin, String id, String family, String renderKitId) {
        this(baseSkin, id, family, renderKitId, null);
    }

    public SkinExtension(Skin baseSkin, SkinMetadata skinMetadata) {
        this(baseSkin, skinMetadata, false);
    }

    public SkinExtension(Skin baseSkin, SkinMetadata skinMetadata, boolean isCacheable) {
        String id = skinMetadata.getId();
        String family = skinMetadata.getFamily();
        String renderKitId = skinMetadata.getRenderKitId();
        String styleSheetName = skinMetadata.getStyleSheetName();
        ValueExpression translationSourceValueExpression = skinMetadata.getTranslationSource();
        SkinVersion version = skinMetadata.getVersion();
        Map features = skinMetadata.getFeatures().getFeatures();
        String resourceBundleName = skinMetadata.getResourceBundleName();
        if (baseSkin == null) {
            throw new NullPointerException("Null baseSkin");
        }
        if (id == null) {
            throw new NullPointerException(_LOG.getMessage("NULL_SKIN_ID"));
        }
        if (family == null) {
            throw new NullPointerException("Null family");
        }
        if (renderKitId == null) {
            renderKitId = _DEFAULT_RENDERKIT;
        }
        if (version == null) {
            version = SkinVersion.EMPTY_SKIN_VERSION;
        }
        baseSkin = this._ensureBaseSkinType(baseSkin);
        if (resourceBundleName != null && translationSourceValueExpression != null) {
            translationSourceValueExpression = null;
        }
        this._baseSkin = baseSkin;
        this._id = id;
        this._family = family;
        this._renderKitId = renderKitId;
        this._styleSheetName = styleSheetName;
        this._bundleName = resourceBundleName;
        this._translationSourceVE = translationSourceValueExpression;
        this._version = version;
        this._skinFeatures = features;
        this._isCacheable = isCacheable;
    }

    public Skin getBaseSkin() {
        return this._baseSkin;
    }

    @Override
    public String getId() {
        return this._id;
    }

    @Override
    public String getFamily() {
        return this._family;
    }

    @Override
    public SkinVersion getVersion() {
        return this._version;
    }

    public Map<String, String> getSkinFeatures() {
        List<SkinAddition> additions;
        Map inheritedFeatures;
        HashMap<String, String> allFeatures = new HashMap<String, String>();
        if (this._baseSkin != null && (inheritedFeatures = this._baseSkin.getSkinFeatures()) != null) {
            allFeatures.putAll(inheritedFeatures);
        }
        if (this._skinFeatures != null) {
            allFeatures.putAll(this._skinFeatures);
        }
        if ((additions = this.getSkinAdditions()) != null && additions.size() > 0) {
            for (SkinAddition addition : additions) {
                Map additionFeatures = addition.getSkinFeatures();
                if (additionFeatures == null || additionFeatures.size() <= 0) continue;
                allFeatures.putAll(additionFeatures);
            }
        }
        return allFeatures;
    }

    @Override
    public String getStyleSheetName() {
        return this._styleSheetName;
    }

    @Override
    public String getRenderKitId() {
        return this._renderKitId;
    }

    @Override
    public String getBundleName() {
        return this._bundleName;
    }

    @Deprecated
    public void setBundleName(String bundleName) {
        this._bundleName = bundleName;
    }

    @Override
    public ValueExpression getTranslationSourceValueExpression() {
        return this._translationSourceVE;
    }

    @Override
    public void registerIcon(String iconName, Icon icon) {
        if (icon == null) {
            icon = _NULL_ICON;
        }
        super.registerIcon(iconName, icon);
    }

    @Override
    public Map<String, String> getStyleClassMap(RenderingContext arc) {
        return this._baseSkin.getStyleClassMap(arc);
    }

    @Override
    public Object getTranslatedValue(LocaleContext lContext, String key) throws MissingResourceException {
        Object translatedValue = this.getCachedTranslatedValue(lContext, key);
        if (translatedValue == null && (translatedValue = this.getBaseSkin().getTranslatedValue(lContext, key)) != null) {
            this.putTranslatedValueInLocaleCache(lContext, key, translatedValue);
        }
        return translatedValue;
    }

    @Override
    public Object getProperty(Object key) {
        Object value = super.getProperty(key);
        if (value == null) {
            Skin baseSkin = this.getBaseSkin();
            value = baseSkin.getProperty(key);
        }
        return value;
    }

    @Override
    public Icon getIcon(String iconName, boolean resolve) {
        Icon icon = super.getIcon(iconName, false);
        if (icon != null) {
            if (icon == _NULL_ICON) {
                return null;
            }
            if (resolve && icon instanceof ReferenceIcon) {
                Icon resolvedIcon = this._resolveReferenceIcon((ReferenceIcon)icon, null);
                this.registerIcon(iconName, resolvedIcon);
                return resolvedIcon;
            }
            return icon;
        }
        Skin baseSkin = this.getBaseSkin();
        icon = baseSkin.getIcon(iconName, false);
        if (resolve && icon instanceof ReferenceIcon) {
            Icon resolvedIcon = this._resolveReferenceIcon((ReferenceIcon)icon, null);
            this.registerIcon(iconName, resolvedIcon);
            return resolvedIcon;
        }
        this.registerIcon(iconName, icon);
        return icon;
    }

    @Deprecated
    public void setStyleSheetName(String styleSheetName) {
        this._styleSheetName = styleSheetName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StyleSheetDocument getStyleSheetDocument(StyleContext context) {
        SkinImpl baseSkin = (SkinImpl)this.getBaseSkin();
        StyleSheetDocument baseDocument = baseSkin.getStyleSheetDocument(context);
        StyleSheetDocument extensionDocument = super.getStyleSheetDocument(context);
        SkinExtension skinExtension = this;
        synchronized (skinExtension) {
            if (baseDocument != this._baseStyleSheetDocument || extensionDocument != this._extensionStyleSheetDocument) {
                this._baseStyleSheetDocument = baseDocument;
                this._extensionStyleSheetDocument = extensionDocument;
                this._fullStyleSheetDocument = StyleSheetDocumentUtils.mergeStyleSheetDocuments(baseDocument, extensionDocument);
            }
            return this._fullStyleSheetDocument;
        }
    }

    @Override
    public void setDirty(boolean dirty) {
        super.setDirty(dirty);
        this.getBaseSkin().setDirty(dirty);
    }

    @Override
    public boolean isCacheable() {
        return this._isCacheable;
    }

    @Override
    protected void addPropertiesToString(ToStringHelper helper) {
        super.addPropertiesToString(helper);
        ArrayList<String> baseSkinIds = new ArrayList<String>();
        for (Skin baseSkin = this.getBaseSkin(); baseSkin != null; baseSkin = baseSkin.getBaseSkin()) {
            baseSkinIds.add(baseSkin.getId());
        }
        helper.append("extends", baseSkinIds);
    }

    private Skin _ensureBaseSkinType(Skin baseSkin) {
        while (baseSkin instanceof RequestSkinWrapper) {
            baseSkin = ((RequestSkinWrapper)baseSkin).getWrappedSkin();
        }
        if (!(baseSkin instanceof SkinImpl)) {
            throw new ClassCastException("Base skin is expected to be of type SkinImpl. Obtain the base skin from SkinProvider.");
        }
        return baseSkin;
    }

    private Icon _resolveReferenceIcon(ReferenceIcon refIcon, Stack<String> referencedIconStack) {
        String refName = refIcon.getName();
        if (SkinExtension._stackContains(referencedIconStack, refName)) {
            if (_LOG.isWarning()) {
                _LOG.warning(_CIRCULAR_INCLUDE_ERROR + refName);
            }
            return null;
        }
        if (referencedIconStack == null) {
            referencedIconStack = new Stack();
        }
        referencedIconStack.push(refName);
        Icon icon = super.getIcon(refName, false);
        if (icon != null) {
            if (icon instanceof ReferenceIcon) {
                Icon resolvedIcon = this._resolveReferenceIcon((ReferenceIcon)icon, referencedIconStack);
                return resolvedIcon;
            }
            return icon;
        }
        Skin baseSkin = this.getBaseSkin();
        icon = baseSkin.getIcon(refName, false);
        if (icon instanceof ReferenceIcon) {
            Icon resolvedIcon = this._resolveReferenceIcon((ReferenceIcon)icon, referencedIconStack);
            return resolvedIcon;
        }
        return icon;
    }

    private static boolean _stackContains(Stack<String> stack, Object value) {
        if (stack == null) {
            return false;
        }
        return stack.contains(value);
    }

    private static class NullIcon
    extends Icon {
        private NullIcon() {
        }

        public void renderIcon(FacesContext context, RenderingContext arc, Map<String, ? extends Object> attrs) throws IOException {
        }
    }
}

