/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidad.bean;

import java.io.Serializable;
import javax.el.ELException;
import javax.el.ValueExpression;
import javax.faces.component.StateHolder;
import javax.faces.context.FacesContext;
import javax.faces.el.EvaluationException;
import javax.faces.el.ValueBinding;
import org.apache.myfaces.trinidad.bean.ValueBindingValueExpression;

public class ValueExpressionValueBinding
extends ValueBinding {
    private final ValueExpression _ve;

    public static ValueBinding getValueBinding(ValueExpression ve) {
        if (ve instanceof ValueBindingValueExpression) {
            return ((ValueBindingValueExpression)ve).getValueBinding();
        }
        if (ve instanceof StateHolder) {
            if (ve instanceof Serializable) {
                return new SerializableStateHolderValueExpressionValueBinding(ve);
            }
            return new StateHolderValueExpressionValueBinding(ve);
        }
        if (ve instanceof Serializable) {
            return new SerializableValueExpressionValueBinding(ve);
        }
        return new ValueExpressionValueBinding(ve);
    }

    private ValueExpressionValueBinding(ValueExpression ve) {
        if (ve == null) {
            throw new NullPointerException();
        }
        this._ve = ve;
    }

    public ValueExpression getValueExpression() {
        return this._ve;
    }

    public Object getValue(FacesContext facesContext) {
        try {
            return this._ve.getValue(facesContext.getELContext());
        }
        catch (ELException ee) {
            throw new EvaluationException(ee.getMessage(), ee.getCause());
        }
    }

    public void setValue(FacesContext facesContext, Object object) {
        try {
            this._ve.setValue(facesContext.getELContext(), object);
        }
        catch (ELException ee) {
            throw new EvaluationException(ee.getMessage(), ee.getCause());
        }
    }

    public boolean isReadOnly(FacesContext facesContext) {
        try {
            return this._ve.isReadOnly(facesContext.getELContext());
        }
        catch (ELException ee) {
            throw new EvaluationException(ee.getMessage(), ee.getCause());
        }
    }

    public Class getType(FacesContext facesContext) {
        try {
            return this._ve.getType(facesContext.getELContext());
        }
        catch (ELException ee) {
            throw new EvaluationException(ee.getMessage(), ee.getCause());
        }
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ValueExpressionValueBinding)) {
            return false;
        }
        ValueExpressionValueBinding that = (ValueExpressionValueBinding)((Object)o);
        return that._ve.equals((Object)this._ve);
    }

    public int hashCode() {
        return this._ve.hashCode();
    }

    public String toString() {
        return super.toString() + ", expression=" + this._ve;
    }

    private static class SerializableStateHolderValueExpressionValueBinding
    extends StateHolderValueExpressionValueBinding
    implements Serializable {
        private static final long serialVersionUID = 1L;

        public SerializableStateHolderValueExpressionValueBinding(ValueExpression ve) {
            super(ve);
        }
    }

    private static class StateHolderValueExpressionValueBinding
    extends ValueExpressionValueBinding
    implements StateHolder {
        private final StateHolder _stateHolder;
        private static final long serialVersionUID = 1L;

        public StateHolderValueExpressionValueBinding(ValueExpression ve) {
            super(ve);
            this._stateHolder = (StateHolder)ve;
        }

        public Object saveState(FacesContext facesContext) {
            return this._stateHolder.saveState(facesContext);
        }

        public void restoreState(FacesContext facesContext, Object object) {
            this._stateHolder.restoreState(facesContext, object);
        }

        public boolean isTransient() {
            return this._stateHolder.isTransient();
        }

        public void setTransient(boolean b) {
            this._stateHolder.setTransient(b);
        }
    }

    private static class SerializableValueExpressionValueBinding
    extends ValueExpressionValueBinding
    implements Serializable {
        private static final long serialVersionUID = 1L;

        public SerializableValueExpressionValueBinding(ValueExpression ve) {
            super(ve);
        }
    }
}

