/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidad.resource;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import org.apache.myfaces.trinidad.logging.TrinidadLogger;
import org.apache.myfaces.trinidad.resource.ResourceLoader;

public class DirectoryResourceLoader
extends ResourceLoader {
    private final File _directory;
    private final String _directoryPath;
    private static final TrinidadLogger _LOG = TrinidadLogger.createTrinidadLogger(DirectoryResourceLoader.class);

    public DirectoryResourceLoader(File directory) {
        if (directory == null) {
            throw new NullPointerException();
        }
        if (!directory.isDirectory()) {
            throw new IllegalArgumentException();
        }
        this._directory = directory;
        try {
            this._directoryPath = this._directory.getCanonicalPath();
        }
        catch (IOException ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    public DirectoryResourceLoader(File directory, ResourceLoader parent) {
        super(parent);
        if (directory == null) {
            throw new NullPointerException();
        }
        if (!directory.isDirectory()) {
            throw new IllegalArgumentException();
        }
        this._directory = directory;
        try {
            this._directoryPath = this._directory.getCanonicalPath();
        }
        catch (IOException ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    @Override
    protected URL findResource(String path) throws IOException {
        File file;
        boolean isContained;
        if (path.charAt(0) == '/') {
            path = path.substring(1);
        }
        return (isContained = (file = new File(this._directory, path).getCanonicalFile()).getCanonicalPath().startsWith(this._directoryPath)) && file.exists() ? file.toURI().toURL() : null;
    }

    protected final String getDirectoryPath() {
        return this._directoryPath;
    }
}

