/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidad.util;

import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import org.apache.myfaces.trinidad.util.ExternalContextURLEncoder;
import org.apache.myfaces.trinidad.util.ExternalContextUtils;
import org.apache.myfaces.trinidad.util.PortletURLEncoder;
import org.apache.myfaces.trinidad.util.ThreadLocalUtils;
import org.apache.myfaces.trinidad.util.URLEncoder;

public class URLEncoderFactory {
    private static final URLEncoderFactory _ENCODER = new URLEncoderFactory();
    private static final ThreadLocal<URLEncoder> _local = ThreadLocalUtils.newRequestThreadLocal();

    public static URLEncoderFactory getFactory() {
        return _ENCODER;
    }

    public URLEncoder getURLEncoder() {
        FacesContext fc = FacesContext.getCurrentInstance();
        if (null == fc) {
            return this.getURLEncoder(null);
        }
        return this.getURLEncoder(fc.getExternalContext());
    }

    public URLEncoder getURLEncoder(ExternalContext ec) {
        URLEncoder enc = _local.get();
        if (null != enc) {
            return enc;
        }
        if (null == ec) {
            throw new IllegalStateException("An ExternalContext must be a available");
        }
        if (ExternalContextUtils.isPortlet(ec)) {
            this.setURLEncoder(new PortletURLEncoder(ec));
        } else {
            this.setURLEncoder(new ExternalContextURLEncoder(ec));
        }
        return _local.get();
    }

    public void setURLEncoder(URLEncoder encoder) {
        _local.set(encoder);
    }
}

