/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.messenger;

import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.MessageProducer;
import javax.jms.Queue;
import javax.jms.QueueSender;
import javax.jms.QueueSession;
import javax.jms.ServerSessionPool;
import javax.jms.Session;
import javax.jms.Topic;
import javax.jms.TopicPublisher;
import javax.jms.TopicSession;
import javax.naming.Context;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.messenger.JNDISessionFactory;
import org.apache.commons.messenger.MessengerSession;
import org.apache.commons.messenger.MessengerSupport;
import org.apache.commons.messenger.SessionFactory;

public class DefaultMessenger
extends MessengerSupport {
    private static final boolean SHARE_CONNECTION = true;
    private static final Log log = LogFactory.getLog((Class)(class$org$apache$commons$messenger$DefaultMessenger == null ? (class$org$apache$commons$messenger$DefaultMessenger = DefaultMessenger.class$("org.apache.commons.messenger.DefaultMessenger")) : class$org$apache$commons$messenger$DefaultMessenger));
    private ThreadLocal messengerSessionPool = new ThreadLocal();
    private SessionFactory sessionFactory;
    static /* synthetic */ Class class$org$apache$commons$messenger$DefaultMessenger;

    public SessionFactory getSessionFactory() throws JMSException {
        if (this.sessionFactory == null) {
            this.sessionFactory = this.createSessionFactory();
        }
        return this.sessionFactory;
    }

    public void setSessionFactory(SessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    public Connection getConnection() throws JMSException {
        return this.getSessionFactory().getConnection();
    }

    public ServerSessionPool createServerSessionPool(MessageListener messageListener, int maxThreads) throws JMSException {
        return this.getSessionFactory().createServerSessionPool(messageListener, maxThreads);
    }

    public synchronized void close() throws JMSException {
        MessengerSession session = this.getMessengerSession();
        this.messengerSessionPool = new ThreadLocal();
        session.close();
        this.getSessionFactory().close();
    }

    public Session getSession() throws JMSException {
        return this.getMessengerSession().getSession();
    }

    public Session getAsyncSession() throws JMSException {
        return this.getMessengerSession().getListenerSession();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Message call(Destination destination, Message message) throws JMSException {
        MessengerSession session = this.borrowMessengerSession();
        try {
            Destination replyTo = this.getReplyToDestination();
            message.setJMSReplyTo(replyTo);
            MessageProducer producer = session.getMessageProducer(destination);
            MessageConsumer consumer = this.getReplyToConsumer();
            if (session.isTopic()) {
                ((TopicPublisher)producer).publish((Topic)destination, message);
            } else {
                ((QueueSender)producer).send((Queue)destination, message);
            }
            Message response = consumer.receive();
            if (response == null) {
                this.clearReplyToDestination();
            }
            Message message2 = response;
            Object var10_9 = null;
            this.returnMessengerSession(session);
            return message2;
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            this.returnMessengerSession(session);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Message call(Destination destination, Message message, long timeoutMillis) throws JMSException {
        MessengerSession session = this.borrowMessengerSession();
        try {
            Destination replyTo = this.getReplyToDestination();
            message.setJMSReplyTo(replyTo);
            MessageProducer producer = session.getMessageProducer(destination);
            MessageConsumer consumer = this.getReplyToConsumer();
            if (session.isTopic()) {
                ((TopicPublisher)producer).publish((Topic)destination, message);
            } else {
                ((QueueSender)producer).send((Queue)destination, message);
            }
            Message response = consumer.receive(timeoutMillis);
            if (response == null) {
                this.clearReplyToDestination();
            }
            Message message2 = response;
            Object var12_10 = null;
            this.returnMessengerSession(session);
            return message2;
        }
        catch (Throwable throwable) {
            Object var12_11 = null;
            this.returnMessengerSession(session);
            throw throwable;
        }
    }

    protected boolean isTopic(Connection connection) throws JMSException {
        return this.getSessionFactory().isTopic();
    }

    protected boolean isTopic(ConnectionFactory factory) throws JMSException {
        return this.getSessionFactory().isTopic();
    }

    protected MessageConsumer getReplyToConsumer() throws JMSException {
        MessengerSession messengerSession = this.getMessengerSession();
        MessageConsumer consumer = messengerSession.getReplyToConsumer();
        if (consumer == null) {
            consumer = this.createMessageConsumer(messengerSession, messengerSession.getSession(), messengerSession.getReplyToDestination());
            messengerSession.setReplyToConsumer(consumer);
        }
        return consumer;
    }

    protected void clearReplyToDestination() throws JMSException {
        MessengerSession messengerSession = this.getMessengerSession();
        messengerSession.setReplyToDestination(null);
        MessageConsumer consumer = messengerSession.getReplyToConsumer();
        if (consumer != null) {
            messengerSession.setReplyToConsumer(null);
            consumer.close();
        }
    }

    protected Destination getReplyToDestination() throws JMSException {
        return this.getMessengerSession().getReplyToDestination();
    }

    protected MessengerSession getMessengerSession() throws JMSException {
        return this.borrowMessengerSession();
    }

    protected MessengerSession borrowMessengerSession() throws JMSException {
        MessengerSession answer = (MessengerSession)this.messengerSessionPool.get();
        if (answer == null) {
            answer = this.createMessengerSession();
            this.messengerSessionPool.set(answer);
        }
        return answer;
    }

    protected void returnMessengerSession(MessengerSession session) {
    }

    protected MessengerSession createMessengerSession() throws JMSException {
        return new MessengerSession(this, this.getSessionFactory());
    }

    protected SessionFactory createSessionFactory() throws JMSException {
        throw new JMSException("No SessionFactory configured for this Messenger. Cannot create a new JMS Session");
    }

    public Queue getQueue(QueueSession session, String subject) throws JMSException {
        Context ctx = null;
        JNDISessionFactory factory = null;
        Queue queue = null;
        if (this.isJndiDestinations()) {
            try {
                factory = (JNDISessionFactory)this.getSessionFactory();
                ctx = factory.getContext();
                queue = (Queue)ctx.lookup(subject);
            }
            catch (Exception e) {
                log.error((Object)("Unable to lookup subject: " + subject + ". Exception: " + e), (Throwable)e);
            }
        } else {
            queue = session.createQueue(subject);
        }
        return queue;
    }

    public Topic getTopic(TopicSession session, String subject) throws JMSException {
        Context ctx = null;
        JNDISessionFactory factory = null;
        Topic topic = null;
        if (this.isJndiDestinations()) {
            try {
                factory = (JNDISessionFactory)this.getSessionFactory();
                ctx = factory.getContext();
                topic = (Topic)ctx.lookup(subject);
            }
            catch (Exception e) {
                log.error((Object)("Unable to lookup subject: " + subject + ". Exception: " + e), (Throwable)e);
            }
        } else {
            topic = session.createTopic(subject);
        }
        return topic;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

