/*
 * Decompiled with CFR 0.152.
 */
package ojb.broker.server;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.NoSuchElementException;
import ojb.broker.Identity;
import ojb.broker.PersistenceBroker;
import ojb.broker.PersistenceBrokerException;
import ojb.broker.PersistenceBrokerFactory;
import ojb.broker.accesslayer.PkIterator;
import ojb.broker.accesslayer.RsIterator;
import ojb.broker.query.Query;
import ojb.broker.server.BrokerPool;
import ojb.broker.server.PersistenceBrokerClient;
import ojb.broker.server.PersistenceBrokerServer;
import ojb.broker.server.PkEnumerationStub;
import ojb.broker.server.Request;
import ojb.broker.server.RsIteratorStub;
import ojb.broker.server.RsIteratorTable;
import ojb.broker.singlevm.PersistenceBrokerImpl;
import ojb.broker.util.ObjectModification;
import org.odmg.TransactionAbortedException;
import org.odmg.TransactionInProgressException;
import org.odmg.TransactionNotInProgressException;

public class RequestProcessor
implements Runnable {
    private File repositoryFile;
    private PersistenceBrokerServer server;
    private BrokerPool brokerpool;
    private static RsIteratorTable iterators = new RsIteratorTable();
    private static final boolean DEBUG = false;
    private Socket connection = null;

    public synchronized void setSocket(Socket s) {
        this.connection = s;
        this.notify();
    }

    public RequestProcessor(PersistenceBrokerServer srv, BrokerPool pool) {
        this.brokerpool = pool;
        this.server = srv;
    }

    /*
     * Loose catch block
     */
    public synchronized void run() {
        while (true) {
            if (this.connection == null) {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    continue;
                }
            }
            this.dispatch(this.connection);
            Object var3_4 = null;
            try {
                this.connection.close();
                this.connection = null;
                this.server.releaseProcessor(this);
            }
            catch (IOException e2) {
                this.connection = null;
                this.server.releaseProcessor(this);
            }
            continue;
            {
                catch (Exception e) {
                    System.out.println(e.getMessage());
                    e.printStackTrace();
                    var3_4 = null;
                    try {
                        this.connection.close();
                        this.connection = null;
                        this.server.releaseProcessor(this);
                    }
                    catch (IOException e2) {
                        this.connection = null;
                        this.server.releaseProcessor(this);
                    }
                    continue;
                }
            }
            catch (Throwable throwable) {
                var3_4 = null;
                try {
                    this.connection.close();
                    this.connection = null;
                    this.server.releaseProcessor(this);
                }
                catch (IOException e2) {
                    this.connection = null;
                    this.server.releaseProcessor(this);
                }
                throw throwable;
            }
        }
    }

    private void dispatch(Socket connection) throws IOException, ClassNotFoundException {
        connection.setSoTimeout(10000);
        connection.setTcpNoDelay(true);
        InputStream instream = connection.getInputStream();
        BufferedInputStream bis = new BufferedInputStream(instream);
        ObjectInputStream ois = new ObjectInputStream(bis);
        Request request = (Request)ois.readObject();
        int methodIndex = request.getMethodIndex();
        int brokerId = request.getBrokerId();
        Object arg1 = request.getArg1();
        Object arg2 = request.getArg2();
        Object result = null;
        switch (methodIndex) {
            case 2: {
                if (brokerId == -1) {
                    brokerId = this.brokerpool.getFreeBrokerId();
                    result = new Integer(brokerId);
                    PersistenceBroker broker = this.brokerpool.getBrokerById(brokerId);
                    try {
                        broker.beginTransaction();
                        System.out.println("Broker" + brokerId + " started tx");
                    }
                    catch (TransactionInProgressException e) {
                        System.out.println("Server ERR: told client to take an already used broker");
                        this.brokerpool.releaseBrokerId(brokerId);
                        result = new TransactionInProgressException();
                    }
                    break;
                }
                System.out.println("Client ERR: Client tries to open tx twice");
                this.brokerpool.releaseBrokerId(brokerId);
                result = new TransactionInProgressException();
                break;
            }
            case 1: {
                if (brokerId != -1) {
                    PersistenceBroker broker = this.brokerpool.getBrokerById(brokerId);
                    try {
                        broker.abortTransaction();
                        this.brokerpool.releaseBrokerId(brokerId);
                        result = new Integer(-1);
                    }
                    catch (TransactionNotInProgressException e) {
                        result = new TransactionNotInProgressException();
                    }
                    break;
                }
                result = new TransactionNotInProgressException();
                break;
            }
            case 3: {
                if (brokerId != -1) {
                    PersistenceBroker broker = this.brokerpool.getBrokerById(brokerId);
                    try {
                        broker.commitTransaction();
                        this.brokerpool.releaseBrokerId(brokerId);
                        result = new Integer(-1);
                    }
                    catch (TransactionNotInProgressException e) {
                        this.brokerpool.releaseBrokerId(brokerId);
                        result = e;
                    }
                    catch (TransactionAbortedException e) {
                        this.brokerpool.releaseBrokerId(brokerId);
                        result = e;
                    }
                    break;
                }
                result = new TransactionNotInProgressException();
                break;
            }
            case 4: {
                if (brokerId == -1) {
                    brokerId = this.brokerpool.getFreeBrokerId();
                }
                PersistenceBroker broker = this.brokerpool.getBrokerById(brokerId);
                try {
                    broker.delete(arg1);
                    this.brokerpool.releaseBrokerId(brokerId);
                    result = null;
                }
                catch (PersistenceBrokerException e) {
                    this.brokerpool.releaseBrokerId(brokerId);
                    result = e;
                }
                break;
            }
            case 5: {
                if (brokerId == -1) {
                    brokerId = this.brokerpool.getFreeBrokerId();
                }
                PersistenceBroker broker = this.brokerpool.getBrokerById(brokerId);
                try {
                    result = broker.getCollectionByQuery((Class)arg1, (Query)arg2);
                    this.brokerpool.releaseBrokerId(brokerId);
                }
                catch (PersistenceBrokerException e) {
                    this.brokerpool.releaseBrokerId(brokerId);
                    result = e;
                }
                break;
            }
            case 6: {
                if (brokerId == -1) {
                    brokerId = this.brokerpool.getFreeBrokerId();
                }
                PersistenceBroker broker = this.brokerpool.getBrokerById(brokerId);
                try {
                    result = broker.getCollectionByQuery((Query)arg1);
                    this.brokerpool.releaseBrokerId(brokerId);
                }
                catch (PersistenceBrokerException e) {
                    this.brokerpool.releaseBrokerId(brokerId);
                    result = e;
                }
                break;
            }
            case 7: {
                if (brokerId == -1) {
                    brokerId = this.brokerpool.getFreeBrokerId();
                }
                PersistenceBroker broker = this.brokerpool.getBrokerById(brokerId);
                try {
                    RsIterator rsiter = (RsIterator)broker.getIteratorByQuery((Query)arg1);
                    Integer iid = iterators.getUniqueId();
                    iterators.register(iid, rsiter);
                    result = new RsIteratorStub((PersistenceBrokerClient)PersistenceBrokerFactory.createPersistenceBroker(), iid);
                    this.brokerpool.releaseBrokerId(brokerId);
                }
                catch (PersistenceBrokerException e) {
                    this.brokerpool.releaseBrokerId(brokerId);
                    result = e;
                }
                break;
            }
            case 8: {
                if (brokerId == -1) {
                    brokerId = this.brokerpool.getFreeBrokerId();
                }
                PersistenceBroker broker = this.brokerpool.getBrokerById(brokerId);
                try {
                    result = broker.getObjectByIdentity((Identity)arg1);
                    this.brokerpool.releaseBrokerId(brokerId);
                }
                catch (PersistenceBrokerException e) {
                    this.brokerpool.releaseBrokerId(brokerId);
                    result = e;
                }
                break;
            }
            case 9: {
                if (brokerId == -1) {
                    brokerId = this.brokerpool.getFreeBrokerId();
                }
                PersistenceBroker broker = this.brokerpool.getBrokerById(brokerId);
                try {
                    result = broker.getObjectByQuery((Query)arg1);
                    this.brokerpool.releaseBrokerId(brokerId);
                }
                catch (PersistenceBrokerException e) {
                    this.brokerpool.releaseBrokerId(brokerId);
                    result = e;
                }
                break;
            }
            case 10: {
                Iterator iter;
                if (brokerId == -1) {
                    brokerId = this.brokerpool.getFreeBrokerId();
                }
                PersistenceBroker broker = this.brokerpool.getBrokerById(brokerId);
                try {
                    Enumeration enumeration = broker.getPKEnumerationByQuery((Class)arg1, (Query)arg2);
                    iter = new PkIterator(enumeration);
                    Integer iid = iterators.getUniqueId();
                    iterators.register(iid, iter);
                    result = new PkEnumerationStub((PersistenceBrokerClient)PersistenceBrokerFactory.createPersistenceBroker(), iid);
                    this.brokerpool.releaseBrokerId(brokerId);
                }
                catch (PersistenceBrokerException e) {
                    this.brokerpool.releaseBrokerId(brokerId);
                    result = e;
                }
                break;
            }
            case 11: {
                if (brokerId == -1) {
                    brokerId = this.brokerpool.getFreeBrokerId();
                }
                PersistenceBroker broker = this.brokerpool.getBrokerById(brokerId);
                try {
                    broker.store(arg1);
                    ((PersistenceBrokerImpl)broker).checkPoint();
                    this.brokerpool.releaseBrokerId(brokerId);
                    result = null;
                }
                catch (PersistenceBrokerException e) {
                    this.brokerpool.releaseBrokerId(brokerId);
                    result = e;
                }
                break;
            }
            case 12: {
                if (brokerId == -1) {
                    brokerId = this.brokerpool.getFreeBrokerId();
                }
                PersistenceBroker broker = this.brokerpool.getBrokerById(brokerId);
                try {
                    broker.store(arg1, (ObjectModification)arg2);
                    ((PersistenceBrokerImpl)broker).checkPoint();
                    this.brokerpool.releaseBrokerId(brokerId);
                    result = null;
                }
                catch (PersistenceBrokerException e) {
                    this.brokerpool.releaseBrokerId(brokerId);
                    result = e;
                }
                break;
            }
            case 13: {
                if (brokerId == -1) {
                    brokerId = this.brokerpool.getFreeBrokerId();
                }
                PersistenceBroker broker = this.brokerpool.getBrokerById(brokerId);
                try {
                    int uid = broker.getUniqueId((Class)arg1, (String)arg2);
                    this.brokerpool.releaseBrokerId(brokerId);
                    result = new Integer(uid);
                }
                catch (PersistenceBrokerException e) {
                    this.brokerpool.releaseBrokerId(brokerId);
                    result = e;
                }
                break;
            }
            case 18: {
                if (brokerId == -1) {
                    brokerId = this.brokerpool.getFreeBrokerId();
                }
                PersistenceBroker broker = this.brokerpool.getBrokerById(brokerId);
                try {
                    result = broker.getUniqueString((Class)arg1, (String)arg2);
                    this.brokerpool.releaseBrokerId(brokerId);
                }
                catch (PersistenceBrokerException e) {
                    this.brokerpool.releaseBrokerId(brokerId);
                    result = e;
                }
                break;
            }
            case 14: {
                Integer id = (Integer)arg1;
                Iterator iter = iterators.getIteratorById(id);
                boolean hasnext = iter.hasNext();
                result = new Boolean(hasnext);
                if (hasnext) break;
                iterators.release(id);
                break;
            }
            case 15: {
                Integer id = (Integer)arg1;
                Iterator iter = iterators.getIteratorById(id);
                try {
                    result = iter.next();
                }
                catch (NoSuchElementException e) {
                    result = e;
                    iterators.release(id);
                }
                break;
            }
            case 16: {
                Integer id = (Integer)arg1;
                iterators.release(id);
                break;
            }
            case 17: {
                if (brokerId == -1) {
                    brokerId = this.brokerpool.getFreeBrokerId();
                }
                PersistenceBroker broker = this.brokerpool.getBrokerById(brokerId);
                try {
                    broker.removeFromCache(arg1);
                    this.brokerpool.releaseBrokerId(brokerId);
                    result = null;
                }
                catch (PersistenceBrokerException e) {
                    this.brokerpool.releaseBrokerId(brokerId);
                    result = e;
                }
                break;
            }
            case 9999: {
                result = "ping " + connection.getLocalAddress() + ":" + connection.getPort() + " from " + connection.getInetAddress() + " " + Thread.currentThread().getName() + ", using broker: " + brokerId;
                break;
            }
        }
        OutputStream outstream = connection.getOutputStream();
        BufferedOutputStream bos = new BufferedOutputStream(outstream);
        ObjectOutputStream oos = new ObjectOutputStream(bos);
        oos.writeObject(result);
        oos.flush();
        outstream.flush();
    }
}

