/*
 * Decompiled with CFR 0.152.
 */
package org.apache.torque.om.mapper;

import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.torque.TorqueException;
import org.apache.torque.criteria.Criteria;
import org.apache.torque.om.mapper.RecordMapper;

public class LongMapper
implements RecordMapper<Long> {
    private static final long serialVersionUID = 1L;
    private final int internalOffset;

    public LongMapper() {
        this.internalOffset = 0;
    }

    public LongMapper(int offset) {
        this.internalOffset = offset;
    }

    @Override
    public Long processRow(ResultSet resultSet, int rowOffset, Criteria criteria) throws TorqueException {
        try {
            Long result = resultSet.getLong(rowOffset + this.internalOffset + 1);
            if (result == 0L && resultSet.wasNull()) {
                return null;
            }
            return result;
        }
        catch (SQLException e) {
            throw new TorqueException("Result could not be mapped to a Long", e);
        }
    }
}

