/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.caseditor.view.tree;

import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.FeatureStructure;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.ruta.caseditor.view.tree.AbstractTreeNode;
import org.apache.uima.ruta.caseditor.view.tree.AnnotationTreeNode;
import org.apache.uima.ruta.caseditor.view.tree.FSTreeNode;
import org.apache.uima.ruta.caseditor.view.tree.IRootTreeNode;
import org.apache.uima.ruta.caseditor.view.tree.ITreeNode;
import org.apache.uima.ruta.caseditor.view.tree.TreeComparator;
import org.apache.uima.ruta.caseditor.view.tree.TypeTreeNode;

public class TypeOrderedRootTreeNode
extends AbstractTreeNode
implements IRootTreeNode {
    private Map<Type, TypeTreeNode> typeMap = new HashMap<Type, TypeTreeNode>();

    public TypeOrderedRootTreeNode(CAS cas) {
        super(cas);
    }

    @Override
    public String getName() {
        return null;
    }

    @Override
    public Type getType() {
        return null;
    }

    public TypeTreeNode getTreeNode(Type type, CAS cas) {
        TypeTreeNode typeTreeNode = this.typeMap.get(type);
        if (typeTreeNode == null) {
            typeTreeNode = new TypeTreeNode(cas, this, type);
            this.typeMap.put(type, typeTreeNode);
            this.addChild(typeTreeNode);
        }
        return typeTreeNode;
    }

    @Override
    public void insertFS(FeatureStructure fs, CAS cas, boolean withParents) {
        Type type = fs.getType();
        if (type.getShortName().equals("RutaBasic") || type.getShortName().equals("DebugBlockApply") || type.getShortName().equals("DebugMatchedRuleMatch") || type.getShortName().equals("DebugFailedRuleMatch") || type.getShortName().equals("DebugScriptApply") || type.getShortName().equals("DebugRuleElementMatches") || type.getShortName().equals("DebugRuleElementMatch")) {
            return;
        }
        this.insertFS(fs, type, cas, withParents);
    }

    private void insertFS(FeatureStructure fs, Type type, CAS cas, boolean withParents) {
        Type parent;
        TypeTreeNode typeTreeNode = this.getTreeNode(type, cas);
        FSTreeNode node = this.createFSNode(typeTreeNode, fs);
        typeTreeNode.addChild(node);
        if (withParents && (parent = fs.getCAS().getTypeSystem().getParent(type)) != null) {
            this.insertFS(fs, parent, cas, withParents);
        }
    }

    private FSTreeNode createFSNode(ITreeNode parent, FeatureStructure fs) {
        if (fs instanceof AnnotationFS) {
            return new AnnotationTreeNode(this.cas, parent, (AnnotationFS)fs, new Stack<Type>());
        }
        return new FSTreeNode(this.cas, parent, fs);
    }

    @Override
    public void sort() {
        this.sort(new TreeComparator());
    }

    public Object getAdapter(Class adapter) {
        if (TypeTreeNode.class.equals((Object)adapter)) {
            return this;
        }
        if (Type.class.equals((Object)adapter)) {
            return null;
        }
        return null;
    }
}

