/*
 * Decompiled with CFR 0.152.
 */
package org.apache.woden.ant;

import java.net.URI;
import java.util.Arrays;
import java.util.Comparator;
import javax.xml.namespace.QName;
import org.apache.woden.ant.CmBaseWriter;
import org.apache.woden.ant.CmHttpWriter;
import org.apache.woden.ant.NamespaceWriter;
import org.apache.woden.ant.XMLWriter;
import org.apache.woden.wsdl20.ElementDeclaration;
import org.apache.woden.wsdl20.extensions.http.HTTPLocation;
import org.apache.woden.wsdl20.extensions.soap.SOAPBindingExtensions;
import org.apache.woden.wsdl20.extensions.soap.SOAPBindingFaultExtensions;
import org.apache.woden.wsdl20.extensions.soap.SOAPBindingFaultReferenceExtensions;
import org.apache.woden.wsdl20.extensions.soap.SOAPBindingMessageReferenceExtensions;
import org.apache.woden.wsdl20.extensions.soap.SOAPBindingOperationExtensions;
import org.apache.woden.wsdl20.extensions.soap.SOAPEndpointExtensions;
import org.apache.woden.wsdl20.extensions.soap.SOAPFaultCode;
import org.apache.woden.wsdl20.extensions.soap.SOAPFaultSubcodes;
import org.apache.woden.wsdl20.extensions.soap.SOAPHeaderBlock;
import org.apache.woden.wsdl20.extensions.soap.SOAPModule;

public class CmSoapWriter
extends NamespaceWriter {
    public static final String NS = "http://www.w3.org/2002/ws/desc/wsdl/component-soap";
    public static final String PREFIX = "cmsoap";
    private CmBaseWriter cmbase;
    private CmHttpWriter cmhttp;

    public CmSoapWriter(XMLWriter out) {
        super(out, NS, PREFIX);
        this.cmbase = (CmBaseWriter)out.lookup("http://www.w3.org/2002/ws/desc/wsdl/component-base");
        this.cmhttp = (CmHttpWriter)out.lookup("http://www.w3.org/2002/ws/desc/wsdl/component-http");
    }

    public void soapBindingExtension(SOAPBindingExtensions soap) {
        if (soap == null) {
            return;
        }
        this.out.beginElement("cmsoap:soapBindingExtension");
        this.out.write("cmhttp:httpCookies", soap.isHttpCookies());
        this.out.write("cmhttp:httpContentEncodingDefault", soap.getHttpContentEncodingDefault());
        this.out.write("cmhttp:httpQueryParameterSeparatorDefault", soap.getHttpQueryParameterSeparatorDefault());
        this.write("cmsoap:soapMepDefault", soap.getSoapMepDefault());
        this.write("cmsoap:soapModules", soap.getSoapModules());
        this.write("cmsoap:soapUnderlyingProtocol", soap.getSoapUnderlyingProtocol());
        this.out.write("cmsoap:soapVersion", soap.getSoapVersion());
        this.out.endElement();
    }

    public void soapBindingFaultExtension(SOAPBindingFaultExtensions soap) {
        if (soap == null) {
            return;
        }
        this.out.beginElement("cmsoap:soapBindingFaultExtension");
        this.cmhttp.write("cmhttp:httpHeaders", soap.getHttpHeaders());
        this.out.write("cmhttp:httpContentEncoding", soap.getHttpContentEncoding());
        this.write("cmsoap:soapFaultCode", soap.getSoapFaultCode());
        this.write("cmsoap:soapFaultSubcodes", soap.getSoapFaultSubcodes());
        this.write("cmsoap:soapHeaders", soap.getSoapHeaders());
        this.write("cmsoap:soapModules", soap.getSoapModules());
        this.out.endElement();
    }

    public void soapBindingOperationExtension(SOAPBindingOperationExtensions soap) {
        if (soap == null) {
            return;
        }
        this.out.beginElement("cmsoap:soapBindingOperationExtension");
        this.write("cmhttp:httpLocation", soap.getHttpLocation());
        this.out.write("cmhttp:httpContentEncodingDefault", soap.getHttpContentEncodingDefault());
        this.out.write("cmhttp:httpQueryParameterSeparator", soap.getHttpQueryParameterSeparator());
        this.write("cmsoap:soapAction", soap.getSoapAction());
        this.write("cmsoap:soapMep", soap.getSoapMep());
        this.write("cmsoap:soapModules", soap.getSoapModules());
        this.out.endElement();
    }

    public void soapBindingMessageReferenceExtension(SOAPBindingMessageReferenceExtensions soap) {
        if (soap == null) {
            return;
        }
        this.out.beginElement("cmsoap:soapBindingMessageReferenceExtension");
        this.cmhttp.write("cmhttp:httpHeaders", soap.getHttpHeaders());
        this.out.write("cmhttp:httpContentEncoding", soap.getHttpContentEncoding());
        this.write("cmsoap:soapHeaders", soap.getSoapHeaders());
        this.write("cmsoap:soapModules", soap.getSoapModules());
        this.out.endElement();
    }

    public void soapBindingFaultReferenceExtension(SOAPBindingFaultReferenceExtensions soap) {
        if (soap == null) {
            return;
        }
        this.out.beginElement("cmsoap:soapBindingFaultReferenceExtension");
        this.write("cmsoap:soapModules", soap.getSoapModules());
        this.out.endElement();
    }

    public void soapEndpointExtension(SOAPEndpointExtensions soap) {
        if (soap == null) {
            return;
        }
        this.out.beginElement("cmsoap:soapEndpointExtension");
        this.out.write("cmhttp:httpAuthenticationRealm", soap.getHttpAuthenticationRealm());
        this.cmhttp.write("cmhttp:httpAuthenticationScheme", soap.getHttpAuthenticationScheme());
        this.out.endElement();
    }

    private void write(String tag, SOAPModule[] components) {
        if (components.length == 0) {
            return;
        }
        Arrays.sort(components, new Comparator(){

            public int compare(Object o1, Object o2) {
                URI uri1 = ((SOAPModule)o1).getRef();
                URI uri2 = ((SOAPModule)o2).getRef();
                return uri1.compareTo(uri2);
            }
        });
        this.out.beginElement(tag);
        for (int i = 0; i < components.length; ++i) {
            this.write("cmsoap:soapModuleComponent", components[i]);
        }
        this.out.endElement();
    }

    private void write(String tag, SOAPModule component) {
        this.out.beginElement(tag, this.cmbase.idAttribute(component));
        this.cmbase.write("cmsoap:ref", component.getRef());
        this.out.write("cmsoap:required", (boolean)component.isRequired());
        this.cmbase.parent(component.getParent());
        this.out.endElement();
    }

    private void write(String tag, SOAPFaultSubcodes soapFaultSubcodes) {
        this.out.beginElement(tag);
        if (soapFaultSubcodes.isQNames()) {
            this.out.beginElement("cmsoap:subcodes");
            QName[] codes = soapFaultSubcodes.getQNames();
            for (int i = 0; i < codes.length; ++i) {
                this.cmbase.write("cmsoap:code", codes[i]);
            }
            this.out.endElement();
        }
        this.out.endElement();
    }

    private void write(String tag, SOAPFaultCode soapFaultCode) {
        this.out.beginElement(tag);
        if (soapFaultCode.isQName()) {
            this.cmbase.write("cmsoap:code", soapFaultCode.getQName());
        }
        this.out.endElement();
    }

    private void write(String tag, SOAPHeaderBlock[] components) {
        if (components.length == 0) {
            return;
        }
        Arrays.sort(components, new Comparator(){

            public int compare(Object o1, Object o2) {
                ElementDeclaration ed2;
                ElementDeclaration ed1 = ((SOAPHeaderBlock)o1).getElementDeclaration();
                if (ed1 == (ed2 = ((SOAPHeaderBlock)o2).getElementDeclaration())) {
                    return 0;
                }
                if (ed1 == null) {
                    return -1;
                }
                if (ed2 == null) {
                    return 1;
                }
                QName x1 = ed1.getName();
                QName x2 = ed2.getName();
                return CmBaseWriter.compareQName(x1, x2);
            }
        });
        this.out.beginElement(tag);
        for (int i = 0; i < components.length; ++i) {
            this.write("cmsoap:soapHeaderBlockComponent", components[i]);
        }
        this.out.endElement();
    }

    private void write(String tag, SOAPHeaderBlock component) {
        this.out.beginElement(tag, this.cmbase.idAttribute(component));
        this.cmbase.writeRef("cmsoap:elementDeclaration", component.getElementDeclaration());
        this.out.write("cmsoap:mustUnderstand", (boolean)component.mustUnderstand());
        this.out.write("cmsoap:required", (boolean)component.isRequired());
        this.cmbase.parent(component.getParent());
        this.out.endElement();
    }

    private void write(String tag, HTTPLocation location) {
        if (location == null) {
            return;
        }
        this.out.write(tag, location.getOriginalLocation());
    }
}

