/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.test.xml;

import java.io.File;
import java.io.FileOutputStream;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.batik.test.TestException;
import org.apache.batik.test.xml.XMLTestReportProcessor;

public class XSLXMLReportConsumer
implements XMLTestReportProcessor.XMLReportConsumer {
    public static final String ERROR_OUTPUT_DIRECTORY_UNUSABLE = "xml.XSLXMLReportConsumer.error.output.directory.unusable";
    private String stylesheet;
    private String outputDirectory;
    private String outputFileName;

    public XSLXMLReportConsumer(String stylesheet, String outputDirectory, String outputFileName) {
        this.stylesheet = stylesheet;
        this.outputDirectory = outputDirectory;
        this.outputFileName = outputFileName;
    }

    @Override
    public void onNewReport(File xmlReport, File reportDirectory) throws Exception {
        TransformerFactory tFactory = TransformerFactory.newInstance();
        Transformer transformer = tFactory.newTransformer(new StreamSource(this.stylesheet));
        transformer.transform(new StreamSource(xmlReport.toURI().toURL().toString()), new StreamResult(new FileOutputStream(this.createNewReportOutput(reportDirectory).getAbsolutePath())));
    }

    public File createNewReportOutput(File reportDirectory) throws Exception {
        File dir = new File(reportDirectory, this.outputDirectory);
        this.checkDirectory(dir);
        return new File(dir, this.outputFileName);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void checkDirectory(File dir) throws TestException {
        boolean dirOK = false;
        try {
            if (!dir.exists()) {
                dirOK = dir.mkdir();
            } else if (dir.isDirectory()) {
                return;
            }
            if (dirOK) return;
        }
        catch (Throwable throwable) {
            if (dirOK) throw throwable;
            throw new TestException(ERROR_OUTPUT_DIRECTORY_UNUSABLE, new Object[]{dir.getAbsolutePath()}, null);
        }
        throw new TestException(ERROR_OUTPUT_DIRECTORY_UNUSABLE, new Object[]{dir.getAbsolutePath()}, null);
    }
}

