# Maik Justus < fg # mjustus : de >, partly based on bo105.nas by Melchior FRANZ, < mfranz # aon : at >
# *****************************************************************************************************
# ***********************************************
# Updated : BARANGER Emmanuel aka Helijah 04/2023
# ***********************************************

if (!contains(globals, "cprint")) {
  globals.cprint = func {};
}

var optarg         = aircraft.optarg;
var makeNode       = aircraft.makeNode;

var sin            = func(a) { math.sin(a * math.pi / 180.0) }
var cos            = func(a) { math.cos(a * math.pi / 180.0) }
var pow            = func(v, w) { math.exp(math.ln(v) * w) }
var npow           = func(v, w) { math.exp(math.ln(abs(v)) * w) * (v < 0 ? -1 : 1) }
var clamp          = func(v, min = 0, max = 1) { v < min ? min : v > max ? max : v }
var normatan       = func(x) { math.atan2(x, 1) * 2 / math.pi }

var e_gear         = props.globals.getNode("sim/model/pogo/erection-gear", 1);

# engines ===================================================================
var state          = props.globals.getNode("sim/model/pogo/state");
var engine         = props.globals.getNode("sim/model/pogo/engine");
var shutdown       = props.globals.getNode("sim/model/pogo/shutdown");
var rotor          = props.globals.getNode("controls/engines/engine/magnetos");
var rotor_rpm      = props.globals.getNode("rotors/main/rpm");
var collective     = props.globals.getNode("controls/engines/engine[0]/throttle");
var target_rel_rpm = props.globals.getNode("controls/rotor/reltarget", 1);
var max_rel_torque = props.globals.getNode("controls/rotor/maxreltorque", 1);

var update_state = func {
  var s = state.getValue();
  var new_state = arg[0];
  if (new_state == (s+1)) {
    state.setValue(new_state);
    if (new_state == (1)) {
      settimer(func { update_state(2) }, 2);
      interpolate(engine, 0.03, 0.1, 0.002, 0.3, 0.02, 0.1, 0.003, 0.7, 0.03, 0.1, 0.01, 0.7);
    } else {
      if (new_state == (2)) {
        settimer(func { update_state(3) }, 3);
        rotor.setValue(1);
        max_rel_torque.setValue(0.01);
        target_rel_rpm.setValue(0.002);
        interpolate(engine, 0.05, 0.2, 0.03, 1, 0.07, 0.1, 0.04, 0.9, 0.02, 0.5);
      } else {
        if (new_state == (3)) {
          if (rotor_rpm.getValue() > 100) {
            #rotor is running at high rpm, so accel. engine faster
            max_rel_torque.setValue(1);
            target_rel_rpm.setValue(1.03);
            state.setValue(5);
            interpolate(engine, 1.03, 10);
          } else {
            settimer(func { update_state(4) }, 7);
            max_rel_torque.setValue(0.05);
            target_rel_rpm.setValue(0.02);
            interpolate(engine, 0.07, 0.1, 0.03, 0.25, 0.075, 0.2, 0.08, 1, 0.06,2);
          }
        } else {
          if (new_state == (4)) {
            settimer(func { update_state(5) }, 30);
            max_rel_torque.setValue(0.25);
            target_rel_rpm.setValue(0.8);
          } else {
            if (new_state == (5)) {
              max_rel_torque.setValue(1);
              target_rel_rpm.setValue(1.03);
            }
          }
        }
      }
    }
  }
}

var engines = func {
  if (props.globals.getNode("sim/crashed",1).getBoolValue()) {return; }
  var s = state.getValue();
  if (arg[0] == 1) {
    if (s == 0) {
      setprop("sim/model/pogo/shutdown",0);
      setprop("controls/lighting/instruments-norm",0.8);
      update_state(1);
    }
  } else {
    setprop("controls/lighting/instruments-norm",0);
    rotor.setValue(0);        # engines stopped
    state.setValue(0);
    setprop("sim/model/pogo/shutdown",1);
    interpolate(engine, 0, 4);
  }
}

# main() ============================================================
var delta_time   = props.globals.getNode("/sim/time/delta-realtime-sec", 1);
var adf_rotation = props.globals.getNode("/instrumentation/adf/rotation-deg", 1);
var hi_heading   = props.globals.getNode("/instrumentation/heading-indicator/indicated-heading-deg", 1);

var main_loop = func {
  # adf_rotation.setDoubleValue(hi_heading.getValue());

  var dt = delta_time.getValue();
  update_engine();
  settimer(main_loop, 0);
}

# initialization
setlistener("/sim/signals/fdm-initialized", func {

  e_gear.setDoubleValue(1);
  settimer(func { e_gear.setDoubleValue(0) }, 15);

  setlistener("/sim/signals/reinit", func {
    cmdarg().getBoolValue() and return;
    cprint("32;1", "reinit");
    e_gear.setDoubleValue(1);
    var rpm  = props.globals.getNode("/engines/engine/oil-temperature-degC", 1);
    setprop("engines/engine/rpm",rpm * 60);
    settimer(func { e_gear.setDoubleValue(0) }, 7);
  });

});
