/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.ui;

import com.sun.electric.database.CellUsage;
import com.sun.electric.database.geometry.DBMath;
import com.sun.electric.database.geometry.EGraphics;
import com.sun.electric.database.geometry.GenMath;
import com.sun.electric.database.geometry.Orientation;
import com.sun.electric.database.geometry.Poly;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Export;
import com.sun.electric.database.hierarchy.View;
import com.sun.electric.database.prototype.NodeProto;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.Connection;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.database.variable.ImmutableTextDescriptor;
import com.sun.electric.database.variable.MutableTextDescriptor;
import com.sun.electric.database.variable.TextDescriptor;
import com.sun.electric.database.variable.VarContext;
import com.sun.electric.database.variable.Variable;
import com.sun.electric.technology.ArcProto;
import com.sun.electric.technology.Layer;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.technology.Technology;
import com.sun.electric.technology.technologies.Generic;
import com.sun.electric.tool.user.User;
import com.sun.electric.tool.user.ui.EditWindow;
import com.sun.electric.tool.user.ui.PixelDrawing;
import com.sun.electric.tool.user.ui.TopLevel;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public class VectorDrawing {
    private static final boolean TAKE_STATS = false;
    private static final boolean DEBUGIMAGES = false;
    private static final int MAXGREEKSIZE = 25;
    private EditWindow wnd;
    private PixelDrawing offscreen;
    private float scale;
    private float offX;
    private float offY;
    private float factorX;
    private float factorY;
    private boolean fullInstantiate;
    private long startTime;
    private boolean takingLongTime;
    private boolean stopRendering;
    private int szHalfWidth;
    private int szHalfHeight;
    private int screenLX;
    private int screenHX;
    private int screenLY;
    private int screenHY;
    private int boxCount;
    private int tinyBoxCount;
    private int lineBoxCount;
    private int lineCount;
    private int polygonCount;
    private int crossCount;
    private int textCount;
    private int circleCount;
    private int arcCount;
    private int subCellCount;
    private int tinySubCellCount;
    private float maxObjectSize;
    private float maxCellSize;
    private Point tempPt1 = new Point();
    private Point tempPt2 = new Point();
    private Point tempPt3 = new Point();
    private Point tempPt4 = new Point();
    private Rectangle tempRect = new Rectangle();
    private Color textColor;
    private static HashMap cachedCells = new HashMap();
    private static VectorDrawing topVD;
    private static int debugXP;
    private static int debugYP;
    private static final Rectangle2D CENTERRECT;
    private static EGraphics textGraphics;
    private static EGraphics instanceGraphics;
    private static EGraphics portGraphics;
    private static final Variable.Key NCCKEY;

    public VectorDrawing(EditWindow wnd) {
        this.wnd = wnd;
    }

    public void render(Cell cell, boolean fullInstantiate, Rectangle2D drawLimitBounds, VarContext context) {
        textGraphics.setColor(new Color(User.getColorText()));
        instanceGraphics.setColor(new Color(User.getColorInstanceOutline()));
        this.textColor = new Color(User.getColorText() & 0xFFFFFF);
        this.offscreen = this.wnd.getOffscreen();
        this.offscreen.highlightingLayers = false;
        Iterator it = Technology.getCurrent().getLayers();
        while (it.hasNext()) {
            Layer layer = (Layer)it.next();
            if (!layer.isDimmed()) continue;
            this.offscreen.highlightingLayers = true;
            break;
        }
        this.scale = (float)this.wnd.getScale();
        this.maxObjectSize = (float)User.getGreekSizeLimit() / this.scale;
        Rectangle2D screenBounds = this.wnd.getDisplayedBounds();
        double screenArea = screenBounds.getWidth() * screenBounds.getHeight();
        this.maxCellSize = (float)(User.getGreekCellSizeLimit() * screenArea);
        this.startTime = System.currentTimeMillis();
        long initialUsed = Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory();
        this.takingLongTime = false;
        this.polygonCount = 0;
        this.lineCount = 0;
        this.lineBoxCount = 0;
        this.tinyBoxCount = 0;
        this.boxCount = 0;
        this.arcCount = 0;
        this.circleCount = 0;
        this.textCount = 0;
        this.crossCount = 0;
        this.tinySubCellCount = 0;
        this.subCellCount = 0;
        this.fullInstantiate = fullInstantiate;
        Dimension sz = this.offscreen.getSize();
        this.szHalfWidth = sz.width / 2;
        this.szHalfHeight = sz.height / 2;
        this.screenLX = 0;
        this.screenHX = sz.width;
        this.screenLY = 0;
        this.screenHY = sz.height;
        Point2D offset = this.wnd.getOffset();
        this.offX = (float)offset.getX();
        this.offY = (float)offset.getY();
        this.factorX = (float)this.szHalfWidth - this.offX * this.scale;
        this.factorY = (float)this.szHalfHeight + this.offY * this.scale;
        if (drawLimitBounds != null) {
            Rectangle screenLimit = this.wnd.databaseToScreen(drawLimitBounds);
            this.screenLX = screenLimit.x;
            if (this.screenLX < 0) {
                this.screenLX = 0;
            }
            this.screenHX = screenLimit.x + screenLimit.width;
            if (this.screenHX >= sz.width) {
                this.screenHX = sz.width - 1;
            }
            this.screenLY = screenLimit.y;
            if (this.screenLY < 0) {
                this.screenLY = 0;
            }
            this.screenHY = screenLimit.y + screenLimit.height;
            if (this.screenHY >= sz.height) {
                this.screenHY = sz.height - 1;
            }
        }
        this.stopRendering = false;
        try {
            VectorCell topVC = this.drawCell(cell, Orientation.IDENT, context);
            this.render(topVC, 0.0f, 0.0f, Orientation.IDENT, context, 0);
        }
        catch (AbortRenderingException e) {
            // empty catch block
        }
        if (this.takingLongTime) {
            TopLevel.setBusyCursor(false);
            System.out.println("Done");
        }
    }

    private boolean isCellParameterized(Cell cell) {
        Variable var;
        Iterator vIt;
        Iterator vIt2 = cell.getVariables();
        while (vIt2.hasNext()) {
            Variable var2 = (Variable)vIt2.next();
            if (!var2.isParam() || var2.getKey() == NCCKEY) continue;
            return true;
        }
        Iterator it = cell.getNodes();
        while (it.hasNext()) {
            NodeInst ni = (NodeInst)it.next();
            vIt = ni.getVariables();
            while (vIt.hasNext()) {
                var = (Variable)vIt.next();
                if (var.getCode() == TextDescriptor.Code.NONE) continue;
                return true;
            }
        }
        it = cell.getArcs();
        while (it.hasNext()) {
            ArcInst ai = (ArcInst)it.next();
            vIt = ai.getVariables();
            while (vIt.hasNext()) {
                var = (Variable)vIt.next();
                if (var.getCode() == TextDescriptor.Code.NONE) continue;
                return true;
            }
        }
        return false;
    }

    public static void cellChanged(Cell cell) {
        VectorCellGroup vcg;
        if (cell.isLinked() && (vcg = (VectorCellGroup)cachedCells.get(cell)) != null && vcg.exports != null) {
            boolean changed = false;
            Rectangle2D cellBounds = cell.getBounds();
            if (vcg.sizeX != cellBounds.getWidth() || vcg.sizeY != cellBounds.getHeight()) {
                changed = true;
            } else {
                Iterator cIt = vcg.exports.iterator();
                Iterator it = cell.getPorts();
                while (it.hasNext()) {
                    Export e = (Export)it.next();
                    if (!cIt.hasNext()) {
                        changed = true;
                        break;
                    }
                    VectorCellExport vce = (VectorCellExport)cIt.next();
                    if (!vce.exportName.equals(e.getName())) {
                        changed = true;
                        break;
                    }
                    Poly poly = e.getOriginalPort().getPoly();
                    if (vce.exportCtr.getX() == poly.getCenterX() && vce.exportCtr.getY() == poly.getCenterY()) continue;
                    changed = true;
                    break;
                }
                if (cIt.hasNext()) {
                    changed = true;
                }
            }
            if (changed) {
                Iterator it = cell.getUsagesOf();
                while (it.hasNext()) {
                    CellUsage u = (CellUsage)it.next();
                    VectorDrawing.cellChanged(u.getParent());
                }
            }
        }
        cachedCells.remove(cell);
    }

    public static void technologyChanged(Technology tech) {
        Iterator it = cachedCells.keySet().iterator();
        while (it.hasNext()) {
            Cell cell = (Cell)it.next();
            if (cell.getTechnology() != tech) continue;
            VectorCellGroup vcg = (VectorCellGroup)cachedCells.get(cell);
            vcg.clear();
        }
    }

    public static void layerVisibilityChanged() {
        Iterator it = cachedCells.keySet().iterator();
        while (it.hasNext()) {
            Cell cell = (Cell)it.next();
            VectorCellGroup vcg = (VectorCellGroup)cachedCells.get(cell);
            Iterator oIt = vcg.orientations.keySet().iterator();
            while (oIt.hasNext()) {
                String orientationName = (String)oIt.next();
                VectorCell vc = (VectorCell)vcg.orientations.get(orientationName);
                vc.fadeImageColors = null;
                vc.fadeImage = false;
            }
        }
    }

    public void abortRendering() {
        this.stopRendering = true;
    }

    private void render(VectorCell vc, float oX, float oY, Orientation trans, VarContext context, int level) throws AbortRenderingException {
        if (level == 0) {
            topVD = this;
        }
        this.drawList(oX, oY, vc.shapes, level);
        Iterator it = vc.subCells.iterator();
        while (it.hasNext()) {
            List path;
            VectorSubCell vsc = (VectorSubCell)it.next();
            ++this.subCellCount;
            float p1x = (float)vsc.outlinePoints[0].getX() + oX;
            float p2x = (float)vsc.outlinePoints[1].getX() + oX;
            float p3x = (float)vsc.outlinePoints[2].getX() + oX;
            float p4x = (float)vsc.outlinePoints[3].getX() + oX;
            float p1y = (float)vsc.outlinePoints[0].getY() + oY;
            float p2y = (float)vsc.outlinePoints[1].getY() + oY;
            float p3y = (float)vsc.outlinePoints[2].getY() + oY;
            float p4y = (float)vsc.outlinePoints[3].getY() + oY;
            this.databaseToScreen(p1x, p1y, this.tempPt1);
            this.databaseToScreen(p2x, p2y, this.tempPt2);
            this.databaseToScreen(p3x, p3y, this.tempPt3);
            this.databaseToScreen(p4x, p4y, this.tempPt4);
            int lX = Math.min(Math.min(this.tempPt1.x, this.tempPt2.x), Math.min(this.tempPt3.x, this.tempPt4.x));
            int hX = Math.max(Math.max(this.tempPt1.x, this.tempPt2.x), Math.max(this.tempPt3.x, this.tempPt4.x));
            int lY = Math.min(Math.min(this.tempPt1.y, this.tempPt2.y), Math.min(this.tempPt3.y, this.tempPt4.y));
            int hY = Math.max(Math.max(this.tempPt1.y, this.tempPt2.y), Math.max(this.tempPt3.y, this.tempPt4.y));
            if (hX < this.screenLX || lX >= this.screenHX || hY < this.screenLY || lY >= this.screenHY) continue;
            if (vsc.size < this.maxObjectSize) {
                Orientation thisOrient = vsc.ni.getOrient();
                Orientation recurseTrans = trans.concatenate(thisOrient);
                VarContext subContext = context.push(vsc.ni);
                VectorCell subVC = this.drawCell(vsc.subCell, recurseTrans, subContext);
                this.makeGreekedImage(vsc, subVC);
                int fadeColor = this.getFadeColor(subVC, subContext);
                this.drawTinyBox(lX, hX, lY, hY, fadeColor, subVC);
                ++this.tinySubCellCount;
                continue;
            }
            boolean expanded = vsc.ni.isExpanded();
            if (this.fullInstantiate) {
                expanded = true;
            }
            if (!expanded && (path = this.wnd.getInPlaceEditNodePath()) != null) {
                for (int pathIndex = 0; pathIndex < path.size(); ++pathIndex) {
                    NodeInst niOnPath = (NodeInst)path.get(pathIndex);
                    if (niOnPath.getProto() != vsc.subCell) continue;
                    expanded = true;
                    break;
                }
            }
            if (expanded) {
                int subLevel;
                Orientation thisOrient = vsc.ni.getOrient();
                Orientation recurseTrans = trans.concatenate(thisOrient);
                VarContext subContext = context.push(vsc.ni);
                VectorCell subVC = this.drawCell(vsc.subCell, recurseTrans, subContext);
                if (vsc.subCell.getView() != View.ICON) {
                    boolean allTinyInside;
                    if (subVC.maxFeatureSize > 0.0f && subVC.maxFeatureSize < this.maxObjectSize && subVC.cellSize < this.maxCellSize && (allTinyInside = this.isContentsTiny(vsc.subCell, subVC, recurseTrans, context))) {
                        this.makeGreekedImage(vsc, subVC);
                        int fadeColor = this.getFadeColor(subVC, context);
                        this.drawTinyBox(lX, hX, lY, hY, fadeColor, subVC);
                        ++this.tinySubCellCount;
                        continue;
                    }
                    if (hX - lX <= 25 && hY - lY <= 25) {
                        this.makeGreekedImage(vsc, subVC);
                        int fadeColor = this.getFadeColor(subVC, context);
                        this.drawTinyBox(lX, hX, lY, hY, fadeColor, subVC);
                        ++this.tinySubCellCount;
                        continue;
                    }
                }
                if ((subLevel = level) == 0) {
                    subLevel = 1;
                }
                this.render(subVC, vsc.offsetX + oX, vsc.offsetY + oY, recurseTrans, subContext, subLevel);
            } else {
                this.databaseToScreen(p1x, p1y, this.tempPt1);
                this.databaseToScreen(p2x, p2y, this.tempPt2);
                this.offscreen.drawLine(this.tempPt1, this.tempPt2, null, instanceGraphics, 0, false);
                this.databaseToScreen(p2x, p2y, this.tempPt1);
                this.databaseToScreen(p3x, p3y, this.tempPt2);
                this.offscreen.drawLine(this.tempPt1, this.tempPt2, null, instanceGraphics, 0, false);
                this.databaseToScreen(p3x, p3y, this.tempPt1);
                this.databaseToScreen(p4x, p4y, this.tempPt2);
                this.offscreen.drawLine(this.tempPt1, this.tempPt2, null, instanceGraphics, 0, false);
                this.databaseToScreen(p1x, p1y, this.tempPt1);
                this.databaseToScreen(p4x, p4y, this.tempPt2);
                this.offscreen.drawLine(this.tempPt1, this.tempPt2, null, instanceGraphics, 0, false);
                if (User.isTextVisibilityOnInstance()) {
                    this.tempRect.setRect(lX, lY, hX - lX, hY - lY);
                    ImmutableTextDescriptor descript = vsc.ni.getTextDescriptor(NodeInst.NODE_PROTO_TD);
                    NodeProto np = vsc.ni.getProto();
                    this.offscreen.drawText(this.tempRect, Poly.Type.TEXTBOX, descript, np.describe(false), null, textGraphics, false);
                }
            }
            this.drawList(oX, oY, vsc.portShapes, level);
        }
        if (this.stopRendering) {
            throw new AbortRenderingException();
        }
    }

    private void drawList(float oX, float oY, List shapes, int level) {
        Iterator it = shapes.iterator();
        block14: while (it.hasNext()) {
            int layerNum;
            VectorBase vb = (VectorBase)it.next();
            if (vb.hideOnLowLevel && level != 0) continue;
            Layer layer = vb.layer;
            boolean dimmed = false;
            if (layer != null) {
                Layer.Function fun;
                if (level < 0 && ((fun = layer.getFunction()).isContact() || fun.isWell() || fun.isSubstrate()) || !layer.isVisible()) continue;
                dimmed = layer.isDimmed();
            }
            if (vb instanceof VectorManhattan) {
                int layerNum2;
                int hY;
                int lY;
                int hX;
                int lX;
                ++this.boxCount;
                VectorManhattan vm = (VectorManhattan)vb;
                if (vm.minSize < this.maxObjectSize) {
                    int hY2;
                    int lY2;
                    int hX2;
                    int lX2;
                    int col = vm.tinyColor;
                    if (col < 0) continue;
                    if (vm.maxSize < this.maxObjectSize) {
                        this.databaseToScreen(vm.c1X + oX, vm.c1Y + oY, this.tempPt1);
                        int x = this.tempPt1.x;
                        int y = this.tempPt1.y;
                        if (x < this.screenLX || x >= this.screenHX || y < this.screenLY || y >= this.screenHY) continue;
                        this.offscreen.drawPoint(x, y, (byte[][])null, col);
                        ++this.tinyBoxCount;
                        continue;
                    }
                    this.databaseToScreen(vm.c1X + oX, vm.c1Y + oY, this.tempPt1);
                    this.databaseToScreen(vm.c2X + oX, vm.c2Y + oY, this.tempPt2);
                    if (this.tempPt1.x < this.tempPt2.x) {
                        lX2 = this.tempPt1.x;
                        hX2 = this.tempPt2.x;
                    } else {
                        lX2 = this.tempPt2.x;
                        hX2 = this.tempPt1.x;
                    }
                    if (hX2 < this.screenLX || lX2 >= this.screenHX) continue;
                    if (this.tempPt1.y < this.tempPt2.y) {
                        lY2 = this.tempPt1.y;
                        hY2 = this.tempPt2.y;
                    } else {
                        lY2 = this.tempPt2.y;
                        hY2 = this.tempPt1.y;
                    }
                    if (hY2 < this.screenLY || lY2 >= this.screenHY) continue;
                    this.drawTinyBox(lX2, hX2, lY2, hY2, col, null);
                    ++this.lineBoxCount;
                    continue;
                }
                this.databaseToScreen(vm.c1X + oX, vm.c1Y + oY, this.tempPt1);
                this.databaseToScreen(vm.c2X + oX, vm.c2Y + oY, this.tempPt2);
                if (this.tempPt1.x < this.tempPt2.x) {
                    lX = this.tempPt1.x;
                    hX = this.tempPt2.x;
                } else {
                    lX = this.tempPt2.x;
                    hX = this.tempPt1.x;
                }
                if (hX < this.screenLX || lX >= this.screenHX) continue;
                if (this.tempPt1.y < this.tempPt2.y) {
                    lY = this.tempPt1.y;
                    hY = this.tempPt2.y;
                } else {
                    lY = this.tempPt2.y;
                    hY = this.tempPt1.y;
                }
                if (hY < this.screenLY || lY >= this.screenHY) continue;
                if (lX < this.screenLX) {
                    lX = this.screenLX;
                }
                if (hX >= this.screenHX) {
                    hX = this.screenHX - 1;
                }
                if (lY < this.screenLY) {
                    lY = this.screenLY;
                }
                if (hY >= this.screenHY) {
                    hY = this.screenHY - 1;
                }
                byte[][] layerBitMap = null;
                EGraphics graphics = vb.graphics;
                if (graphics != null && (layerNum2 = graphics.getTransparentLayer() - 1) < this.offscreen.numLayerBitMaps) {
                    layerBitMap = this.offscreen.getLayerBitMap(layerNum2);
                }
                this.offscreen.drawBox(lX, hX, lY, hY, layerBitMap, graphics, dimmed);
                continue;
            }
            byte[][] layerBitMap = null;
            EGraphics graphics = vb.graphics;
            if (graphics != null && (layerNum = graphics.getTransparentLayer() - 1) < this.offscreen.numLayerBitMaps) {
                layerBitMap = this.offscreen.getLayerBitMap(layerNum);
            }
            if (vb instanceof VectorLine) {
                ++this.lineCount;
                VectorLine vl = (VectorLine)vb;
                this.databaseToScreen(vl.fX + oX, vl.fY + oY, this.tempPt1);
                this.databaseToScreen(vl.tX + oX, vl.tY + oY, this.tempPt2);
                this.offscreen.drawLine(this.tempPt1, this.tempPt2, layerBitMap, graphics, vl.texture, dimmed);
                continue;
            }
            if (vb instanceof VectorPolygon) {
                ++this.polygonCount;
                VectorPolygon vp = (VectorPolygon)vb;
                Point[] intPoints = new Point[vp.points.length];
                for (int i = 0; i < vp.points.length; ++i) {
                    intPoints[i] = new Point();
                    this.databaseToScreen(vp.points[i].getX() + (double)oX, vp.points[i].getY() + (double)oY, intPoints[i]);
                }
                Point[] clippedPoints = GenMath.clipPoly(intPoints, this.screenLX, this.screenHX - 1, this.screenLY, this.screenHY - 1);
                this.offscreen.drawPolygon(clippedPoints, layerBitMap, graphics, dimmed);
                continue;
            }
            if (vb instanceof VectorCross) {
                ++this.crossCount;
                VectorCross vcr = (VectorCross)vb;
                this.databaseToScreen(vcr.x + oX, vcr.y + oY, this.tempPt1);
                int size = 5;
                if (vcr.small) {
                    size = 3;
                }
                this.offscreen.drawLine(new Point(this.tempPt1.x - size, this.tempPt1.y), new Point(this.tempPt1.x + size, this.tempPt1.y), null, graphics, 0, dimmed);
                this.offscreen.drawLine(new Point(this.tempPt1.x, this.tempPt1.y - size), new Point(this.tempPt1.x, this.tempPt1.y + size), null, graphics, 0, dimmed);
                continue;
            }
            if (vb instanceof VectorText) {
                int hY;
                int lY;
                int hX;
                int lX;
                VectorText vt = (VectorText)vb;
                switch (vt.textType) {
                    case 4: {
                        if (User.isTextVisibilityOnArc()) break;
                        continue block14;
                    }
                    case 3: {
                        if (User.isTextVisibilityOnNode()) break;
                        continue block14;
                    }
                    case 1: {
                        if (User.isTextVisibilityOnCell()) break;
                        continue block14;
                    }
                    case 2: {
                        if (User.isTextVisibilityOnExport()) break;
                        continue block14;
                    }
                    case 5: {
                        if (User.isTextVisibilityOnAnnotation()) break;
                        continue block14;
                    }
                    case 6: {
                        if (User.isTextVisibilityOnInstance()) break;
                        continue block14;
                    }
                    case 7: {
                        if (User.isTextVisibilityOnPort()) break;
                        continue block14;
                    }
                }
                if (vt.height < this.maxObjectSize) continue;
                String drawString = vt.str;
                this.databaseToScreen(vt.bounds.getMinX() + (double)oX, vt.bounds.getMinY() + (double)oY, this.tempPt1);
                this.databaseToScreen(vt.bounds.getMaxX() + (double)oX, vt.bounds.getMaxY() + (double)oY, this.tempPt2);
                if (this.tempPt1.x < this.tempPt2.x) {
                    lX = this.tempPt1.x;
                    hX = this.tempPt2.x;
                } else {
                    lX = this.tempPt2.x;
                    hX = this.tempPt1.x;
                }
                if (this.tempPt1.y < this.tempPt2.y) {
                    lY = this.tempPt1.y;
                    hY = this.tempPt2.y;
                } else {
                    lY = this.tempPt2.y;
                    hY = this.tempPt1.y;
                }
                if (vt.textType == 7) {
                    int portDisplayLevel = User.getPortDisplayLevel();
                    Color portColor = vt.e.getBasePort().getPortColor();
                    if (vt.ni.isExpanded()) {
                        portColor = this.textColor;
                    }
                    if (portColor != null) {
                        portGraphics.setColor(portColor);
                    }
                    int cX = (lX + hX) / 2;
                    int cY = (lY + hY) / 2;
                    if (portDisplayLevel == 2) {
                        int size = 3;
                        this.offscreen.drawLine(new Point(cX - size, cY), new Point(cX + size, cY), null, portGraphics, 0, false);
                        this.offscreen.drawLine(new Point(cX, cY - size), new Point(cX, cY + size), null, portGraphics, 0, false);
                        ++this.crossCount;
                        continue;
                    }
                    drawString = portDisplayLevel == 1 ? vt.e.getShortName() : vt.e.getName();
                    graphics = portGraphics;
                    layerBitMap = null;
                    lX = hX = cX;
                    lY = hY = cY;
                } else if (vt.textType == 2 && vt.e != null) {
                    int exportDisplayLevel = User.getExportDisplayLevel();
                    if (exportDisplayLevel == 2) {
                        int cX = (lX + hX) / 2;
                        int cY = (lY + hY) / 2;
                        int size = 3;
                        this.offscreen.drawLine(new Point(cX - size, cY), new Point(cX + size, cY), null, textGraphics, 0, false);
                        this.offscreen.drawLine(new Point(cX, cY - size), new Point(cX, cY + size), null, textGraphics, 0, false);
                        ++this.crossCount;
                        continue;
                    }
                    drawString = exportDisplayLevel == 1 ? vt.e.getShortName() : vt.e.getName();
                    graphics = textGraphics;
                    layerBitMap = null;
                }
                ++this.textCount;
                this.tempRect.setRect(lX, lY, hX - lX, hY - lY);
                this.offscreen.drawText(this.tempRect, vt.style, vt.descript, drawString, layerBitMap, graphics, dimmed);
                continue;
            }
            if (vb instanceof VectorCircle) {
                ++this.circleCount;
                VectorCircle vci = (VectorCircle)vb;
                this.databaseToScreen(vci.cX + oX, vci.cY + oY, this.tempPt1);
                this.databaseToScreen(vci.eX + oX, vci.eY + oY, this.tempPt2);
                switch (vci.nature) {
                    case 0: {
                        this.offscreen.drawCircle(this.tempPt1, this.tempPt2, layerBitMap, graphics, dimmed);
                        break;
                    }
                    case 1: {
                        this.offscreen.drawThickCircle(this.tempPt1, this.tempPt2, layerBitMap, graphics, dimmed);
                        break;
                    }
                    case 2: {
                        this.offscreen.drawDisc(this.tempPt1, this.tempPt2, layerBitMap, graphics, dimmed);
                    }
                }
                continue;
            }
            if (!(vb instanceof VectorCircleArc)) continue;
            ++this.arcCount;
            VectorCircleArc vca = (VectorCircleArc)vb;
            this.databaseToScreen(vca.cX + oX, vca.cY + oY, this.tempPt1);
            this.databaseToScreen(vca.eX1 + oX, vca.eY1 + oY, this.tempPt2);
            this.databaseToScreen(vca.eX2 + oX, vca.eY2 + oY, this.tempPt3);
            this.offscreen.drawCircleArc(this.tempPt1, this.tempPt2, this.tempPt3, vca.thick, layerBitMap, graphics, dimmed);
        }
    }

    public void databaseToScreen(double dbX, double dbY, Point result) {
        double scrX = dbX * (double)this.scale + (double)this.factorX;
        double scrY = (double)this.factorY - dbY * (double)this.scale;
        result.x = (int)(scrX >= 0.0 ? scrX + 0.5 : scrX - 0.5);
        result.y = (int)(scrY >= 0.0 ? scrY + 0.5 : scrY - 0.5);
    }

    private void drawTinyBox(int lX, int hX, int lY, int hY, int col, VectorCell greekedCell) {
        if (lX < this.screenLX) {
            lX = this.screenLX;
        }
        if (hX >= this.screenHX) {
            hX = this.screenHX - 1;
        }
        if (lY < this.screenLY) {
            lY = this.screenLY;
        }
        if (hY >= this.screenHY) {
            hY = this.screenHY - 1;
        }
        if (greekedCell != null && greekedCell.fadeImageColors != null) {
            int backgroundColor = User.getColorBackground();
            int backgroundRed = backgroundColor >> 16 & 0xFF;
            int backgroundGreen = backgroundColor >> 8 & 0xFF;
            int backgroundBlue = backgroundColor & 0xFF;
            int greekWid = greekedCell.fadeImageWid;
            int greekHei = greekedCell.fadeImageHei;
            int wid = hX - lX;
            int hei = hY - lY;
            float xInc = (float)greekWid / (float)wid;
            float yInc = (float)greekHei / (float)hei;
            float yPos = 0.0f;
            for (int y = 0; y < hei; ++y) {
                float yEndPos = yPos + yInc;
                int yS = (int)yPos;
                int yE = (int)yEndPos;
                float xPos = 0.0f;
                for (int x = 0; x < wid; ++x) {
                    float xEndPos = xPos + xInc;
                    int xS = (int)xPos;
                    int xE = (int)xEndPos;
                    float r = 0.0f;
                    float g = 0.0f;
                    float b = 0.0f;
                    float totalArea = 0.0f;
                    for (int yGrab = yS; yGrab <= yE; ++yGrab) {
                        if (yGrab >= greekHei) continue;
                        float yArea = 1.0f;
                        if (yGrab == yS) {
                            yArea = 1.0f - (yPos - (float)yS);
                        }
                        if (yGrab == yE) {
                            yArea *= yEndPos - (float)yE;
                        }
                        for (int xGrab = xS; xGrab <= xE; ++xGrab) {
                            if (xGrab >= greekWid) continue;
                            int value = greekedCell.fadeImageColors[xGrab + yGrab * greekedCell.fadeImageWid];
                            int red = value >> 16 & 0xFF;
                            int green = value >> 8 & 0xFF;
                            int blue = value & 0xFF;
                            float area = yArea;
                            if (xGrab == xS) {
                                area *= 1.0f - (xPos - (float)xS);
                            }
                            if (xGrab == xE) {
                                area *= xEndPos - (float)xE;
                            }
                            if (area <= 0.0f) continue;
                            r += (float)red * area;
                            g += (float)green * area;
                            b += (float)blue * area;
                            totalArea += area;
                        }
                    }
                    if (totalArea > 0.0f) {
                        int blue;
                        int green;
                        int red = (int)(r / totalArea);
                        if (red > 255) {
                            red = 255;
                        }
                        if ((green = (int)(g / totalArea)) > 255) {
                            green = 255;
                        }
                        if ((blue = (int)(b / totalArea)) > 255) {
                            blue = 255;
                        }
                        if (Math.abs(backgroundRed - red) > 2 || Math.abs(backgroundGreen - green) > 2 || Math.abs(backgroundBlue - blue) > 2) {
                            this.offscreen.drawPoint(lX + x, lY + y, (byte[][])null, red << 16 | green << 8 | blue);
                        }
                    }
                    xPos = xEndPos;
                }
                yPos = yEndPos;
            }
            return;
        }
        for (int y = lY; y <= hY; ++y) {
            for (int x = lX; x <= hX; ++x) {
                this.offscreen.drawPoint(x, y, (byte[][])null, col);
            }
        }
    }

    private boolean isContentsTiny(Cell cell, VectorCell vc, Orientation trans, VarContext context) throws AbortRenderingException {
        if (vc.maxFeatureSize > this.maxObjectSize) {
            return false;
        }
        boolean isAllTiny = true;
        Iterator it = vc.subCells.iterator();
        while (it.hasNext()) {
            VarContext subContext;
            Orientation thisOrient;
            Orientation recurseTrans;
            VectorCell subVC;
            boolean subCellTiny;
            VectorSubCell vsc = (VectorSubCell)it.next();
            NodeInst ni = vsc.ni;
            boolean expanded = ni.isExpanded();
            if (this.fullInstantiate) {
                expanded = true;
            }
            if (!(expanded ? !(subCellTiny = this.isContentsTiny(vsc.subCell, subVC = this.drawCell(vsc.subCell, recurseTrans = (thisOrient = ni.getOrient()).concatenate(trans), subContext = context.push(ni)), recurseTrans, subContext)) : vsc.size > this.maxObjectSize)) continue;
            return false;
        }
        return true;
    }

    private void makeGreekedImage(VectorSubCell vsc, VectorCell subVC) throws AbortRenderingException {
        int greekHei;
        int greekWid;
        if (subVC.fadeImage) {
            return;
        }
        Rectangle2D cellBounds = vsc.subCell.getBounds();
        Rectangle2D.Double ownBounds = new Rectangle2D.Double(cellBounds.getMinX(), cellBounds.getMinY(), cellBounds.getWidth(), cellBounds.getHeight());
        AffineTransform trans = vsc.pureRotate.rotateAbout(0.0, 0.0);
        GenMath.transformRect(ownBounds, trans);
        double greekScale = 25.0 / ((RectangularShape)ownBounds).getHeight();
        if (((RectangularShape)ownBounds).getWidth() > ((RectangularShape)ownBounds).getHeight()) {
            greekScale = 25.0 / ((RectangularShape)ownBounds).getWidth();
        }
        if ((greekWid = (int)(((RectangularShape)ownBounds).getWidth() * greekScale + 0.5)) <= 0) {
            greekWid = 1;
        }
        if ((greekHei = (int)(((RectangularShape)ownBounds).getHeight() * greekScale + 0.5)) <= 0) {
            greekHei = 1;
        }
        EditWindow fadeWnd = EditWindow.CreateElectricDoc(vsc.subCell, null);
        fadeWnd.setScreenSize(new Dimension(greekWid, greekHei));
        fadeWnd.setScale(greekScale);
        Point2D.Double cellCtr = new Point2D.Double(ownBounds.getCenterX(), ownBounds.getCenterY());
        fadeWnd.setOffset(cellCtr);
        VectorDrawing subVD = new VectorDrawing(fadeWnd);
        subVC.fadeOffsetX = debugXP;
        subVC.fadeOffsetY = debugYP;
        if (topVD != null && (debugXP += 30) + 25 + 2 >= VectorDrawing.topVD.offscreen.getSize().width) {
            debugXP = 0;
            debugYP += 30;
        }
        subVD.offscreen = fadeWnd.getOffscreen();
        subVD.screenLX = 0;
        subVD.screenHX = greekWid;
        subVD.screenLY = 0;
        subVD.screenHY = greekHei;
        subVD.szHalfWidth = greekWid / 2;
        subVD.szHalfHeight = greekHei / 2;
        subVD.maxObjectSize = 0.0f;
        subVD.scale = (float)greekScale;
        subVD.offX = (float)((Point2D)cellCtr).getX();
        subVD.offY = (float)((Point2D)cellCtr).getY();
        subVD.factorX = (float)subVD.szHalfWidth - subVD.offX * subVD.scale;
        subVD.factorY = (float)subVD.szHalfHeight + subVD.offY * subVD.scale;
        subVD.fullInstantiate = true;
        subVD.takingLongTime = true;
        subVD.offscreen.clearImage(false, null);
        subVD.render(subVC, 0.0f, 0.0f, vsc.pureRotate, VarContext.globalContext, -1);
        subVD.offscreen.composite(null);
        BufferedImage img = subVD.offscreen.getBufferedImage();
        subVC.fadeImageWid = img.getWidth();
        subVC.fadeImageHei = img.getHeight();
        subVC.fadeImageColors = new int[subVC.fadeImageWid * subVC.fadeImageHei];
        int i = 0;
        for (int y = 0; y < subVC.fadeImageHei; ++y) {
            for (int x = 0; x < subVC.fadeImageWid; ++x) {
                int value = img.getRGB(x, y);
                subVC.fadeImageColors[i++] = value & 0xFFFFFF;
            }
        }
        subVD.wnd.finished();
        subVC.fadeImage = true;
    }

    private int getFadeColor(VectorCell vc, VarContext context) throws AbortRenderingException {
        vc.fadeColor = 0;
        return vc.fadeColor;
    }

    private void gatherContents(VectorCell vc, HashMap layerAreas, VarContext context) throws AbortRenderingException {
        Iterator it = vc.shapes.iterator();
        while (it.hasNext()) {
            Layer.Function fun;
            Layer layer;
            VectorBase vb = (VectorBase)it.next();
            if (vb.hideOnLowLevel || (layer = vb.layer) == null || (fun = layer.getFunction()).isImplant() || fun.isSubstrate()) continue;
            double area = 0.0;
            if (vb instanceof VectorManhattan) {
                VectorManhattan vm = (VectorManhattan)vb;
                area = Math.abs((vm.c1X - vm.c2X) * (vm.c1Y - vm.c2Y));
            } else if (vb instanceof VectorLine) {
                VectorLine vl = (VectorLine)vb;
                area = new Point2D.Double(vl.fX, vl.fY).distance(new Point2D.Double(vl.tX, vl.tY));
            } else if (vb instanceof VectorPolygon) {
                VectorPolygon vp = (VectorPolygon)vb;
                area = GenMath.getAreaOfPoints(vp.points);
            } else if (vb instanceof VectorCircle) {
                VectorCircle vci = (VectorCircle)vb;
                double radius = new Point2D.Double(vci.cX, vci.cY).distance(new Point2D.Double(vci.eX, vci.eY));
                area = radius * radius * Math.PI;
            }
            if (area == 0.0) continue;
            GenMath.MutableDouble md = (GenMath.MutableDouble)layerAreas.get(layer);
            if (md == null) {
                md = new GenMath.MutableDouble(0.0);
                layerAreas.put(layer, md);
            }
            md.setValue(md.doubleValue() + area);
        }
        it = vc.subCells.iterator();
        while (it.hasNext()) {
            VectorSubCell vsc = (VectorSubCell)it.next();
            VectorCellGroup vcg = VectorCellGroup.findCellGroup(vsc.subCell);
            VectorCell subVC = vcg.getAnyCell();
            VarContext subContext = context.push(vsc.ni);
            if (subVC == null) {
                subVC = this.drawCell(vsc.subCell, Orientation.IDENT, subContext);
            }
            this.gatherContents(subVC, layerAreas, subContext);
        }
    }

    private VectorCell drawCell(Cell cell, Orientation prevTrans, VarContext context) throws AbortRenderingException {
        long currentTime;
        VectorCellGroup vcg = VectorCellGroup.findCellGroup(cell);
        String orientationName = VectorDrawing.makeOrientationName(prevTrans);
        VectorCell vc = (VectorCell)vcg.orientations.get(orientationName);
        if (vc != null && vc.isParameterized) {
            vc = null;
        }
        if (vc != null) {
            return vc;
        }
        if (this.stopRendering) {
            throw new AbortRenderingException();
        }
        if (!this.takingLongTime && (currentTime = System.currentTimeMillis()) - this.startTime > 1000L) {
            System.out.print("Display caching, please wait...");
            TopLevel.setBusyCursor(true);
            this.takingLongTime = true;
        }
        vc = new VectorCell();
        vcg.addCell(vc, prevTrans);
        vc.isParameterized = this.isCellParameterized(cell);
        Rectangle2D cellBounds = cell.getBounds();
        vc.cellSize = (float)(cellBounds.getWidth() * cellBounds.getHeight());
        AffineTransform trans = prevTrans.pureRotate();
        if (vcg.exports == null) {
            vcg.exports = new ArrayList();
            vcg.sizeX = cellBounds.getWidth();
            vcg.sizeY = cellBounds.getHeight();
            Iterator it = cell.getPorts();
            while (it.hasNext()) {
                Export e = (Export)it.next();
                VectorCellExport vce = new VectorCellExport();
                vce.exportName = e.getName();
                Poly poly = e.getOriginalPort().getPoly();
                vce.exportCtr = new Point2D.Double(poly.getCenterX(), poly.getCenterY());
                vcg.exports.add(vce);
            }
        }
        Iterator arcs = cell.getArcs();
        while (arcs.hasNext()) {
            ArcInst ai = (ArcInst)arcs.next();
            this.drawArc(ai, trans, vc);
        }
        Iterator nodes = cell.getNodes();
        while (nodes.hasNext()) {
            NodeInst ni = (NodeInst)nodes.next();
            this.drawNode(ni, trans, context, vc);
        }
        if (cell.getView() == View.SCHEMATIC) {
            Collections.sort(vc.shapes, new ShapeByLayer());
        }
        int numPolys = cell.numDisplayableVariables(true);
        Poly[] polys = new Poly[numPolys];
        cell.addDisplayableVariables(CENTERRECT, polys, 0, this.wnd, true);
        this.drawPolys(polys, DBMath.MATID, vc, true, 1, false);
        if (cell.getView() == View.ICON) {
            vc.maxFeatureSize = 0.0f;
        }
        return vc;
    }

    public void drawNode(NodeInst ni, AffineTransform trans, VarContext context, VectorCell vc) {
        NodeProto np = ni.getProto();
        AffineTransform localTrans = ni.rotateOut(trans);
        boolean hideOnLowLevel = false;
        if (ni.isVisInside() || np == Generic.tech.cellCenterNode) {
            hideOnLowLevel = true;
        }
        if (np instanceof Cell) {
            Cell subCell = (Cell)np;
            AffineTransform outlineTrans = ni.translateOut(localTrans);
            Rectangle2D cellBounds = subCell.getBounds();
            Poly outlinePoly = new Poly(cellBounds);
            outlinePoly.transform(outlineTrans);
            Point2D.Double ctrShift = new Point2D.Double(ni.getAnchorCenterX(), ni.getAnchorCenterY());
            localTrans.transform(ctrShift, ctrShift);
            VectorSubCell vsc = new VectorSubCell(ni, ctrShift, outlinePoly.getPoints());
            vc.subCells.add(vsc);
            this.showCellPorts(ni, vc, vsc, localTrans);
            int numPolys = ni.numDisplayableVariables(true);
            Poly[] polys = new Poly[numPolys];
            Rectangle2D rect = ni.getUntransformedBounds();
            ni.addDisplayableVariables(rect, polys, 0, this.wnd, true);
            this.drawPolys(polys, localTrans, vc, false, 3, false);
        } else {
            PrimitiveNode prim = (PrimitiveNode)np;
            int textType = 3;
            if (prim == Generic.tech.invisiblePinNode) {
                textType = 5;
            }
            Technology tech = prim.getTechnology();
            Poly[] polys = tech.getShapeOfNode(ni, this.wnd, context, false, false, null);
            boolean pureLayer = ni.getFunction() == PrimitiveNode.Function.NODE;
            this.drawPolys(polys, localTrans, vc, hideOnLowLevel, textType, pureLayer);
        }
        Iterator it = ni.getExports();
        while (it.hasNext()) {
            Export e = (Export)it.next();
            Poly poly = e.getNamePoly();
            Rectangle2D rect = (Rectangle2D)poly.getBounds2D().clone();
            TextDescriptor descript = poly.getTextDescriptor();
            Poly.Type style = descript.getPos().getPolyType();
            style = Poly.rotateType(style, ni);
            VectorText vt = new VectorText(poly.getBounds2D(), style, descript, null, 2, null, e, true, null, null);
            vc.shapes.add(vt);
            int numPolys = e.numDisplayableVariables(true);
            if (numPolys <= 0) continue;
            Poly[] polys = new Poly[numPolys];
            e.addDisplayableVariables(rect, polys, 0, this.wnd, true);
            this.drawPolys(polys, localTrans, vc, true, 2, false);
        }
    }

    public void drawArc(ArcInst ai, AffineTransform trans, VectorCell vc) {
        Rectangle2D arcBounds = ai.getBounds();
        Rectangle2D dbBounds = new Rectangle2D.Double(arcBounds.getX(), arcBounds.getY(), arcBounds.getWidth(), arcBounds.getHeight());
        Poly p = new Poly(dbBounds);
        p.transform(trans);
        dbBounds = p.getBounds2D();
        ArcProto ap = ai.getProto();
        Technology tech = ap.getTechnology();
        Poly[] polys = tech.getShapeOfArc(ai, this.wnd);
        this.drawPolys(polys, trans, vc, false, 4, false);
    }

    private void showCellPorts(NodeInst ni, VectorCell vc, VectorSubCell vsc, AffineTransform localTrans) {
        PortInst pi;
        int numPorts = ni.getProto().getNumPorts();
        boolean[] shownPorts = new boolean[numPorts];
        Iterator it = ni.getConnections();
        while (it.hasNext()) {
            Connection con = (Connection)it.next();
            pi = con.getPortInst();
            shownPorts[pi.getPortIndex()] = true;
        }
        it = ni.getExports();
        while (it.hasNext()) {
            Export exp = (Export)it.next();
            pi = exp.getOriginalPort();
            shownPorts[pi.getPortIndex()] = true;
        }
        AffineTransform thisTrans = ni.rotateIn();
        for (int i = 0; i < numPorts; ++i) {
            Export pp;
            Poly portPoly;
            if (shownPorts[i] || (portPoly = ni.getShapeOfPort(pp = (Export)ni.getProto().getPort(i))) == null) continue;
            portPoly.transform(thisTrans);
            portPoly.transform(localTrans);
            TextDescriptor descript = portPoly.getTextDescriptor();
            MutableTextDescriptor portDescript = pp.getMutableTextDescriptor(Export.EXPORT_NAME_TD);
            Poly.Type style = Poly.Type.FILLED;
            if (descript != null) {
                portDescript.setColorIndex(descript.getColorIndex());
                style = descript.getPos().getPolyType();
            }
            Rectangle rect = new Rectangle(this.tempPt1);
            VectorText vt = new VectorText(portPoly.getBounds2D(), style, descript, null, 7, ni, pp, false, null, null);
            vsc.portShapes.add(vt);
        }
    }

    private void drawPolys(Poly[] polys, AffineTransform trans, VectorCell vc, boolean hideOnLowLevel, int textType, boolean pureLayer) {
        if (polys == null) {
            return;
        }
        for (int i = 0; i < polys.length; ++i) {
            Poly poly = polys[i];
            if (poly == null) continue;
            poly.transform(trans);
            this.renderPoly(poly, vc, hideOnLowLevel, textType, pureLayer);
        }
    }

    private void renderPoly(Poly poly, VectorCell vc, boolean hideOnLowLevel, int textType, boolean pureLayer) {
        Poly.Type style;
        Point2D[] points = poly.getPoints();
        Layer layer = poly.getLayer();
        EGraphics graphics = null;
        if (layer != null) {
            graphics = layer.getGraphics();
        }
        if ((style = poly.getStyle()) == Poly.Type.FILLED) {
            Rectangle2D bounds = poly.getBox();
            if (bounds != null) {
                float lX = (float)bounds.getMinX();
                float hX = (float)bounds.getMaxX();
                float lY = (float)bounds.getMinY();
                float hY = (float)bounds.getMaxY();
                VectorManhattan vm = new VectorManhattan(lX, lY, hX, hY, layer, graphics, hideOnLowLevel);
                if (layer != null) {
                    Layer.Function fun = layer.getFunction();
                    if (!pureLayer && (fun.isImplant() || fun.isSubstrate())) {
                        float dX = hX - lX;
                        float dY = hY - lY;
                        vm.setSize(dX / 10.0f, dY / 10.0f);
                    }
                }
                vm.hideOnLowLevel = hideOnLowLevel;
                vc.shapes.add(vm);
                vc.maxFeatureSize = Math.max(vc.maxFeatureSize, vm.minSize);
                return;
            }
            VectorPolygon vp = new VectorPolygon(points, layer, graphics, hideOnLowLevel);
            vc.shapes.add(vp);
            return;
        }
        if (style == Poly.Type.CROSSED) {
            VectorLine vl1 = new VectorLine(points[0].getX(), points[0].getY(), points[1].getX(), points[1].getY(), 0, layer, graphics, hideOnLowLevel);
            VectorLine vl2 = new VectorLine(points[1].getX(), points[1].getY(), points[2].getX(), points[2].getY(), 0, layer, graphics, hideOnLowLevel);
            VectorLine vl3 = new VectorLine(points[2].getX(), points[2].getY(), points[3].getX(), points[3].getY(), 0, layer, graphics, hideOnLowLevel);
            VectorLine vl4 = new VectorLine(points[3].getX(), points[3].getY(), points[0].getX(), points[0].getY(), 0, layer, graphics, hideOnLowLevel);
            VectorLine vl5 = new VectorLine(points[0].getX(), points[0].getY(), points[2].getX(), points[2].getY(), 0, layer, graphics, hideOnLowLevel);
            VectorLine vl6 = new VectorLine(points[1].getX(), points[1].getY(), points[3].getX(), points[3].getY(), 0, layer, graphics, hideOnLowLevel);
            vc.shapes.add(vl1);
            vc.shapes.add(vl2);
            vc.shapes.add(vl3);
            vc.shapes.add(vl4);
            vc.shapes.add(vl5);
            vc.shapes.add(vl6);
            return;
        }
        if (style.isText()) {
            Rectangle2D bounds = poly.getBounds2D();
            TextDescriptor descript = poly.getTextDescriptor();
            String str = poly.getString();
            VectorText vt = new VectorText(bounds, style, descript, str, textType, null, null, hideOnLowLevel, layer, graphics);
            vc.shapes.add(vt);
            vc.maxFeatureSize = Math.max(vc.maxFeatureSize, vt.height);
            return;
        }
        if (style == Poly.Type.CLOSED || style == Poly.Type.OPENED || style == Poly.Type.OPENEDT1 || style == Poly.Type.OPENEDT2 || style == Poly.Type.OPENEDT3) {
            int lineType = 0;
            if (style == Poly.Type.OPENEDT1) {
                lineType = 1;
            } else if (style == Poly.Type.OPENEDT2) {
                lineType = 2;
            } else if (style == Poly.Type.OPENEDT3) {
                lineType = 3;
            }
            for (int j = 1; j < points.length; ++j) {
                Point2D oldPt = points[j - 1];
                Point2D newPt = points[j];
                VectorLine vl = new VectorLine(oldPt.getX(), oldPt.getY(), newPt.getX(), newPt.getY(), lineType, layer, graphics, hideOnLowLevel);
                vc.shapes.add(vl);
            }
            if (style == Poly.Type.CLOSED) {
                Point2D oldPt = points[points.length - 1];
                Point2D newPt = points[0];
                VectorLine vl = new VectorLine(oldPt.getX(), oldPt.getY(), newPt.getX(), newPt.getY(), lineType, layer, graphics, hideOnLowLevel);
                vc.shapes.add(vl);
            }
            return;
        }
        if (style == Poly.Type.VECTORS) {
            for (int j = 0; j < points.length; j += 2) {
                Point2D oldPt = points[j];
                Point2D newPt = points[j + 1];
                VectorLine vl = new VectorLine(oldPt.getX(), oldPt.getY(), newPt.getX(), newPt.getY(), 0, layer, graphics, hideOnLowLevel);
                vc.shapes.add(vl);
            }
            return;
        }
        if (style == Poly.Type.CIRCLE) {
            VectorCircle vci = new VectorCircle(points[0].getX(), points[0].getY(), points[1].getX(), points[1].getY(), 0, layer, graphics, hideOnLowLevel);
            vc.shapes.add(vci);
            return;
        }
        if (style == Poly.Type.THICKCIRCLE) {
            VectorCircle vci = new VectorCircle(points[0].getX(), points[0].getY(), points[1].getX(), points[1].getY(), 1, layer, graphics, hideOnLowLevel);
            vc.shapes.add(vci);
            return;
        }
        if (style == Poly.Type.DISC) {
            VectorCircle vci = new VectorCircle(points[0].getX(), points[0].getY(), points[1].getX(), points[1].getY(), 2, layer, graphics, hideOnLowLevel);
            vc.shapes.add(vci);
            return;
        }
        if (style == Poly.Type.CIRCLEARC || style == Poly.Type.THICKCIRCLEARC) {
            VectorCircleArc vca = new VectorCircleArc(points[0].getX(), points[0].getY(), points[1].getX(), points[1].getY(), points[2].getX(), points[2].getY(), style == Poly.Type.THICKCIRCLEARC, layer, graphics, hideOnLowLevel);
            vc.shapes.add(vca);
            return;
        }
        if (style == Poly.Type.CROSS) {
            VectorCross vcr = new VectorCross(points[0].getX(), points[0].getY(), true, layer, graphics, hideOnLowLevel);
            vc.shapes.add(vcr);
            return;
        }
        if (style == Poly.Type.BIGCROSS) {
            VectorCross vcr = new VectorCross(points[0].getX(), points[0].getY(), false, layer, graphics, hideOnLowLevel);
            vc.shapes.add(vcr);
            return;
        }
    }

    private static String makeOrientationName(Orientation orient) {
        String oName = Integer.toString(orient.getCAngle());
        if (orient.isCTranspose()) {
            oName = oName + "T";
        }
        return oName;
    }

    static {
        CENTERRECT = new Rectangle2D.Double(0.0, 0.0, 0.0, 0.0);
        textGraphics = new EGraphics(0, 0, 0, 0, 0, 0, 1.0, true, new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0});
        instanceGraphics = new EGraphics(0, 0, 0, 0, 0, 0, 1.0, true, new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0});
        portGraphics = new EGraphics(0, 0, 0, 255, 0, 0, 1.0, true, new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0});
        NCCKEY = Variable.newKey("ATTR_NCC");
    }

    public static class ShapeByLayer
    implements Comparator {
        public int compare(Object o1, Object o2) {
            VectorBase vb1 = (VectorBase)o1;
            VectorBase vb2 = (VectorBase)o2;
            int level1 = 1000;
            int level2 = 1000;
            if (vb1.layer != null) {
                level1 = vb1.layer.getFunction().getLevel();
            }
            if (vb2.layer != null) {
                level2 = vb2.layer.getFunction().getLevel();
            }
            return level1 - level2;
        }
    }

    class AbortRenderingException
    extends Exception {
        AbortRenderingException() {
        }
    }

    private static class VectorCell {
        List shapes = new ArrayList();
        List subCells = new ArrayList();
        int fadeColor;
        float maxFeatureSize = 0.0f;
        boolean isParameterized;
        float cellSize;
        boolean fadeImage = false;
        int fadeOffsetX;
        int fadeOffsetY;
        int[] fadeImageColors;
        int fadeImageWid;
        int fadeImageHei;

        VectorCell() {
        }
    }

    private static class VectorCellExport {
        String exportName;
        Point2D exportCtr;

        private VectorCellExport() {
        }
    }

    private static class VectorCellGroup {
        Cell cell;
        HashMap orientations;
        VectorCell any;
        double sizeX;
        double sizeY;
        List exports;

        VectorCellGroup(Cell cell) {
            this.cell = cell;
            this.orientations = new HashMap();
            this.any = null;
        }

        static VectorCellGroup findCellGroup(Cell cell) {
            VectorCellGroup vcg = (VectorCellGroup)cachedCells.get(cell);
            if (vcg == null) {
                vcg = new VectorCellGroup(cell);
                cachedCells.put(cell, vcg);
            }
            return vcg;
        }

        void clear() {
            this.orientations.clear();
            this.exports.clear();
            this.any = null;
        }

        VectorCell getAnyCell() {
            return this.any;
        }

        void addCell(VectorCell vc, Orientation trans) {
            String orientationName = VectorDrawing.makeOrientationName(trans);
            this.orientations.put(orientationName, vc);
            this.any = vc;
        }
    }

    private static class VectorSubCell {
        NodeInst ni;
        Orientation pureRotate;
        Cell subCell;
        float offsetX;
        float offsetY;
        Point2D[] outlinePoints;
        float size;
        List portShapes;

        VectorSubCell(NodeInst ni, Point2D offset, Point2D[] outlinePoints) {
            this.ni = ni;
            this.pureRotate = ni.getOrient();
            this.subCell = (Cell)ni.getProto();
            this.offsetX = (float)offset.getX();
            this.offsetY = (float)offset.getY();
            this.outlinePoints = outlinePoints;
            this.size = (float)Math.min(ni.getXSize(), ni.getYSize());
            this.portShapes = new ArrayList();
        }
    }

    private static class VectorCross
    extends VectorBase {
        float x;
        float y;
        boolean small;

        VectorCross(double x, double y, boolean small, Layer layer, EGraphics graphics, boolean hideOnLowLevel) {
            super(layer, graphics, hideOnLowLevel);
            this.x = (float)x;
            this.y = (float)y;
            this.small = small;
        }
    }

    private static class VectorText
    extends VectorBase {
        static final int TEXTTYPECELL = 1;
        static final int TEXTTYPEEXPORT = 2;
        static final int TEXTTYPENODE = 3;
        static final int TEXTTYPEARC = 4;
        static final int TEXTTYPEANNOTATION = 5;
        static final int TEXTTYPEINSTANCE = 6;
        static final int TEXTTYPEPORT = 7;
        Rectangle2D bounds;
        Poly.Type style;
        TextDescriptor descript;
        String str;
        float height;
        int textType;
        NodeInst ni;
        Export e;

        VectorText(Rectangle2D bounds, Poly.Type style, TextDescriptor descript, String str, int textType, NodeInst ni, Export e, boolean hideOnLowLevel, Layer layer, EGraphics graphics) {
            super(layer, graphics, hideOnLowLevel);
            TextDescriptor.Size tds;
            this.bounds = bounds;
            this.style = style;
            this.descript = descript;
            this.str = str;
            this.textType = textType;
            this.ni = ni;
            this.e = e;
            this.height = 1.0f;
            if (descript != null && !(tds = descript.getSize()).isAbsolute()) {
                this.height = (float)tds.getSize();
            }
        }
    }

    private static class VectorCircleArc
    extends VectorBase {
        float cX;
        float cY;
        float eX1;
        float eY1;
        float eX2;
        float eY2;
        boolean thick;

        VectorCircleArc(double cX, double cY, double eX1, double eY1, double eX2, double eY2, boolean thick, Layer layer, EGraphics graphics, boolean hideOnLowLevel) {
            super(layer, graphics, hideOnLowLevel);
            this.cX = (float)cX;
            this.cY = (float)cY;
            this.eX1 = (float)eX1;
            this.eY1 = (float)eY1;
            this.eX2 = (float)eX2;
            this.eY2 = (float)eY2;
            this.thick = thick;
        }
    }

    private static class VectorCircle
    extends VectorBase {
        float cX;
        float cY;
        float eX;
        float eY;
        int nature;

        VectorCircle(double cX, double cY, double eX, double eY, int nature, Layer layer, EGraphics graphics, boolean hideOnLowLevel) {
            super(layer, graphics, hideOnLowLevel);
            this.cX = (float)cX;
            this.cY = (float)cY;
            this.eX = (float)eX;
            this.eY = (float)eY;
            this.nature = nature;
        }
    }

    private static class VectorLine
    extends VectorBase {
        float fX;
        float fY;
        float tX;
        float tY;
        int texture;

        VectorLine(double fX, double fY, double tX, double tY, int texture, Layer layer, EGraphics graphics, boolean hideOnLowLevel) {
            super(layer, graphics, hideOnLowLevel);
            this.fX = (float)fX;
            this.fY = (float)fY;
            this.tX = (float)tX;
            this.tY = (float)tY;
            this.texture = texture;
        }
    }

    private static class VectorPolygon
    extends VectorBase {
        Point2D[] points;

        VectorPolygon(Point2D[] points, Layer layer, EGraphics graphics, boolean hideOnLowLevel) {
            super(layer, graphics, hideOnLowLevel);
            this.points = points;
        }
    }

    private static class VectorManhattan
    extends VectorBase {
        float c1X;
        float c1Y;
        float c2X;
        float c2Y;
        int tinyColor;

        VectorManhattan(float c1X, float c1Y, float c2X, float c2Y, Layer layer, EGraphics graphics, boolean hideOnLowLevel) {
            super(layer, graphics, hideOnLowLevel);
            Layer.Function fun;
            this.c1X = c1X;
            this.c1Y = c1Y;
            this.c2X = c2X;
            this.c2Y = c2Y;
            float dX = Math.abs(c1X - c2X);
            float dY = Math.abs(c1Y - c2Y);
            this.setSize(dX, dY);
            this.tinyColor = -1;
            if (layer != null && !(fun = layer.getFunction()).isImplant() && !fun.isSubstrate() && graphics != null) {
                this.tinyColor = graphics.getColor().getRGB() & 0xFFFFFF;
            }
        }
    }

    private static class VectorBase {
        Layer layer;
        EGraphics graphics;
        boolean hideOnLowLevel;
        float minSize;
        float maxSize;

        VectorBase(Layer layer, EGraphics graphics, boolean hideOnLowLevel) {
            this.layer = layer;
            this.graphics = graphics;
            this.hideOnLowLevel = hideOnLowLevel;
            this.maxSize = -1.0f;
            this.minSize = -1.0f;
            hideOnLowLevel = false;
        }

        void setSize(float size1, float size2) {
            this.minSize = Math.min(size1, size2);
            this.maxSize = Math.max(size1, size2);
        }
    }
}

