/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.ui;

import java.awt.Toolkit;
import java.awt.event.KeyEvent;
import java.util.HashMap;
import javax.swing.KeyStroke;

public class KeyStrokePair {
    private KeyStroke prefixStroke;
    private KeyStroke stroke;
    private static HashMap<KeyStrokePair, KeyStrokePair> cache = new HashMap();
    private static final String sep = ", ";
    private static KeyStroke[] specialKeyStrokes = new KeyStroke[]{KeyStroke.getKeyStroke(150, 0), KeyStroke.getKeyStroke(127, 0), KeyStroke.getKeyStroke(8, 0), KeyStroke.getKeyStroke('>'), KeyStroke.getKeyStroke('<')};

    private KeyStrokePair() {
    }

    public static KeyStrokePair getKeyStrokePair(KeyStroke prefixStroke, KeyStroke stroke) {
        return KeyStrokePair.getCachedKeyStrokePair(prefixStroke, stroke);
    }

    public static KeyStrokePair getKeyStrokePair(String keyString) {
        KeyStroke prefixStroke = null;
        KeyStroke stroke = null;
        String[] strokes = keyString.split(sep);
        if (strokes.length == 1) {
            stroke = KeyStrokePair.stringToKeyStroke(strokes[0]);
            return KeyStrokePair.getCachedKeyStrokePair(prefixStroke, stroke);
        }
        if (strokes.length == 2) {
            prefixStroke = KeyStrokePair.stringToKeyStroke(strokes[0]);
            stroke = KeyStrokePair.stringToKeyStroke(strokes[1]);
            return KeyStrokePair.getCachedKeyStrokePair(prefixStroke, stroke);
        }
        return null;
    }

    public String toString() {
        if (this.stroke == null) {
            return "";
        }
        if (this.prefixStroke == null) {
            return KeyStrokePair.keyStrokeToString(this.stroke);
        }
        return KeyStrokePair.keyStrokeToString(this.prefixStroke) + sep + KeyStrokePair.keyStrokeToString(this.stroke);
    }

    public static String getStringFromKeyStroke(KeyStroke key) {
        String id = "";
        id = key.getKeyCode() == 0 ? String.valueOf(key.getKeyChar()) : KeyEvent.getKeyText(key.getKeyCode());
        return id;
    }

    public static String keyStrokeToString(KeyStroke key) {
        if (key == null) {
            return "";
        }
        String mods = KeyEvent.getKeyModifiersText(key.getModifiers());
        String id = KeyStrokePair.getStringFromKeyStroke(key);
        if (mods.equals("")) {
            return id;
        }
        mods = mods.replace('+', ' ');
        mods = mods.toLowerCase();
        return mods + " " + id;
    }

    public static KeyStroke stringToKeyStroke(String str) {
        if ((str = str.replaceAll("NumPad\\-", "NUMPAD")).matches(".*?command.*")) {
            str = str.replaceAll("command", "");
            str = str.trim();
            KeyStroke key = KeyStroke.getKeyStroke(str);
            int command_mask = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
            if (key != null) {
                key = KeyStroke.getKeyStroke(key.getKeyCode(), key.getModifiers() | command_mask);
                return key;
            }
            return null;
        }
        KeyStroke key = KeyStroke.getKeyStroke(str);
        if (key == null) {
            for (KeyStroke k : specialKeyStrokes) {
                if (!str.equals(KeyStrokePair.getStringFromKeyStroke(k))) continue;
                key = k;
                break;
            }
        }
        return key;
    }

    public KeyStroke getPrefixStroke() {
        return this.prefixStroke;
    }

    public KeyStroke getStroke() {
        return this.stroke;
    }

    public int hashCode() {
        int prefixCode = this.prefixStroke == null ? 0 : this.prefixStroke.hashCode();
        int strokeCode = this.stroke == null ? 0 : this.stroke.hashCode();
        return (prefixCode + 1) * strokeCode;
    }

    private static KeyStrokePair getCachedKeyStrokePair(KeyStroke prefixStroke, KeyStroke stroke) {
        if (prefixStroke == null && stroke == null) {
            return null;
        }
        KeyStrokePair k = new KeyStrokePair();
        k.prefixStroke = prefixStroke;
        k.stroke = stroke;
        if (!cache.containsKey(k)) {
            cache.put(k, k);
        } else {
            k = cache.get(k);
        }
        return k;
    }
}

