/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.io.input.verilog;

import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.text.TextUtils;
import com.sun.electric.tool.io.input.Simulate;
import com.sun.electric.tool.simulation.DigitalAnalysis;
import com.sun.electric.tool.simulation.DigitalSignal;
import com.sun.electric.tool.simulation.Stimuli;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VerilogOut
extends Simulate {
    private String lastLine = null;
    private int linePos;
    private int lineLen;

    @Override
    protected Stimuli readSimulationOutput(URL fileURL, Cell cell) throws IOException {
        if (this.openTextInput(fileURL)) {
            return null;
        }
        VerilogOut.startProgressDialog("Verilog output", fileURL.getFile());
        Stimuli sd = this.readVerilogFile(cell);
        VerilogOut.stopProgressDialog();
        this.closeInput();
        return sd;
    }

    private Stimuli readVerilogFile(Cell cell) throws IOException {
        String keyword;
        Stimuli sd = new Stimuli();
        DigitalAnalysis an = new DigitalAnalysis(sd);
        sd.setCell(cell);
        double timeScale = 1.0;
        String currentScope = "";
        int curLevel = 0;
        int numSignals = 0;
        HashMap<String, Object> symbolTable = new HashMap<String, Object>();
        HashMap dataMap = new HashMap();
        ArrayList<DigitalSignal> curArray = null;
        while ((keyword = this.getNextKeyword()) != null) {
            String currentLine;
            DigitalSignal sig;
            if (keyword.equals("$date") || keyword.equals("$version")) {
                this.parseToEnd();
                continue;
            }
            if (keyword.equals("$timescale")) {
                String units = this.getNextKeyword();
                timeScale = TextUtils.atof(units);
                if (units.endsWith("ms")) {
                    timeScale /= 1000.0;
                } else if (units.endsWith("us")) {
                    timeScale /= 1000000.0;
                } else if (units.endsWith("ns")) {
                    timeScale /= 1.0E9;
                } else if (units.endsWith("ps")) {
                    timeScale /= 1.0E12;
                } else if (units.endsWith("fs")) {
                    timeScale /= 1.0E15;
                }
                this.parseToEnd();
                continue;
            }
            if (keyword.equals("$scope")) {
                String scope = this.getNextKeyword();
                if (scope == null) break;
                if (scope.equals("module") || scope.equals("task") || scope.equals("function")) {
                    this.cleanUpScope(curArray, an);
                    curArray = new ArrayList<DigitalSignal>();
                    String scopeName = this.getNextKeyword();
                    if (scopeName == null) break;
                    if (currentScope.length() > 0) {
                        currentScope = currentScope + ".";
                    }
                    currentScope = currentScope + scopeName;
                    ++curLevel;
                    curArray = new ArrayList();
                }
                this.parseToEnd();
                continue;
            }
            if (keyword.equals("$upscope")) {
                if (curLevel <= 0 || currentScope.length() == 0) {
                    System.out.println("Unbalanced $upscope on line " + this.lineReader.getLineNumber());
                    continue;
                }
                this.cleanUpScope(curArray, an);
                curArray = new ArrayList();
                int dotPos = currentScope.lastIndexOf(46);
                if (dotPos >= 0) {
                    currentScope = currentScope.substring(0, dotPos);
                    --curLevel;
                }
                this.parseToEnd();
                continue;
            }
            if (keyword.equals("$var")) {
                String index;
                String signalName;
                String varName = this.getNextKeyword();
                if (varName == null) break;
                if (!varName.equals("wire") && !varName.equals("reg") && !varName.equals("supply0") && !varName.equals("supply1") && !varName.equals("parameter") && !varName.equals("trireg") && !varName.equals("in") && !varName.equals("out") && !varName.equals("inout")) continue;
                String widthText = this.getNextKeyword();
                if (widthText == null) break;
                int width = TextUtils.atoi(widthText);
                String symbol = this.getNextKeyword();
                if (symbol == null || (signalName = this.getNextKeyword()) == null || (index = this.getNextKeyword()) == null) break;
                if (index.equals("$end")) {
                    index = "";
                } else {
                    this.parseToEnd();
                }
                ++numSignals;
                sig = new DigitalSignal(an);
                sig.setSignalName(signalName + index, currentScope);
                dataMap.put(sig, new ArrayList());
                if (index.length() > 0 && width == 1) {
                    curArray.add(sig);
                }
                if (width > 1) {
                    sig.setSignalName(signalName + "[0:" + (width - 1) + "]", null);
                    sig.buildBussedSignalList();
                    for (int i = 0; i < width; ++i) {
                        DigitalSignal subSig = new DigitalSignal(an);
                        subSig.setSignalName(signalName + "[" + i + "]", currentScope);
                        dataMap.put(subSig, new ArrayList());
                        sig.addToBussedSignalList(subSig);
                        this.addSignalToHashMap(subSig, symbol + "[" + i + "]", symbolTable);
                        ++numSignals;
                    }
                }
                this.addSignalToHashMap(sig, symbol, symbolTable);
                continue;
            }
            if (keyword.equals("$enddefinitions")) {
                this.parseToEnd();
                System.out.println("Found " + numSignals + " signal names");
                continue;
            }
            if (!keyword.equals("$dumpvars")) continue;
            double curTime = 0.0;
            while ((currentLine = this.getLineFromSimulator()) != null) {
                char chr = currentLine.charAt(0);
                String restOfLine = currentLine.substring(1);
                if (chr == '0' || chr == '1' || chr == 'x' || chr == 'X' || chr == 'z' || chr == 'Z') {
                    Object entry = symbolTable.get(restOfLine);
                    if (entry == null) {
                        System.out.println("Unknown symbol '" + restOfLine + "' on line " + this.lineReader.getLineNumber());
                        continue;
                    }
                    if (entry instanceof List) {
                        entry = ((List)entry).get(0);
                    }
                    sig = (DigitalSignal)entry;
                    int state = 0;
                    switch (chr) {
                        case '0': {
                            state = 8;
                            break;
                        }
                        case '1': {
                            state = 10;
                            break;
                        }
                        case 'X': 
                        case 'x': {
                            state = 9;
                            break;
                        }
                        case 'Z': 
                        case 'z': {
                            state = 11;
                        }
                    }
                    VerilogStimuli vs = new VerilogStimuli(curTime, state);
                    List listForSig = (List)dataMap.get(sig);
                    listForSig.add(vs);
                    continue;
                }
                if (chr == '$') {
                    if (restOfLine.equals("end") || restOfLine.equals("dumpon") || restOfLine.equals("dumpoff") || restOfLine.equals("dumpall")) continue;
                    System.out.println("Unknown directive on line " + this.lineReader.getLineNumber() + ": " + currentLine);
                    continue;
                }
                if (chr == '#') {
                    curTime = TextUtils.atof(restOfLine) * timeScale;
                    continue;
                }
                if (chr == 'b') {
                    int spacePos = restOfLine.indexOf(32);
                    if (spacePos < 0) {
                        System.out.println("Bus has missing signal name on line " + this.lineReader.getLineNumber() + ": " + currentLine);
                        continue;
                    }
                    String symName = restOfLine.substring(spacePos + 1);
                    Object entry = symbolTable.get(symName);
                    if (entry == null) {
                        System.out.println("Unknown symbol '" + symName + "' on line " + this.lineReader.getLineNumber());
                        continue;
                    }
                    if (entry instanceof List) {
                        entry = ((List)entry).get(0);
                    }
                    DigitalSignal sig2 = (DigitalSignal)entry;
                    int i = 0;
                    Iterator<DigitalSignal> i$ = sig2.getBussedSignals().iterator();
                    while (i$.hasNext()) {
                        DigitalSignal anySig;
                        DigitalSignal subSig = anySig = i$.next();
                        char bit = restOfLine.charAt(i++);
                        int state = 0;
                        switch (bit) {
                            case '0': {
                                state = 8;
                                break;
                            }
                            case '1': {
                                state = 10;
                                break;
                            }
                            case 'X': 
                            case 'x': {
                                state = 9;
                                break;
                            }
                            case 'Z': 
                            case 'z': {
                                state = 11;
                            }
                        }
                        VerilogStimuli vs = new VerilogStimuli(curTime, state);
                        List listForSig = (List)dataMap.get(subSig);
                        listForSig.add(vs);
                    }
                    continue;
                }
                System.out.println("Unknown stimulus on line " + this.lineReader.getLineNumber() + ": " + currentLine);
            }
        }
        for (Object entry : symbolTable.values()) {
            DigitalSignal sig;
            List listForSig;
            int numStimuli;
            List fullList = null;
            if (entry instanceof List) {
                fullList = (List)entry;
                entry = fullList.get(0);
            }
            if ((numStimuli = (listForSig = (List)dataMap.get(sig = (DigitalSignal)entry)).size()) == 0) continue;
            sig.buildTime(numStimuli);
            sig.buildState(numStimuli);
            int i = 0;
            for (VerilogStimuli vs : listForSig) {
                sig.setTime(i, vs.time);
                sig.setState(i, vs.state);
                ++i;
            }
            if (fullList == null) continue;
            for (DigitalSignal oSig : fullList) {
                if (oSig.getTimeVector() == null) {
                    oSig.setTimeVector(sig.getTimeVector());
                }
                if (oSig.getStateVector() != null) continue;
                oSig.setStateVector(sig.getStateVector());
            }
        }
        String singularPrefix = null;
        for (DigitalSignal sSig : an.getSignals()) {
            String context = sSig.getSignalContext();
            if (context == null) {
                singularPrefix = null;
                break;
            }
            int dotPos = context.indexOf(46);
            if (dotPos >= 0) {
                context = context.substring(0, dotPos);
            }
            if (singularPrefix == null) {
                singularPrefix = context;
                continue;
            }
            if (singularPrefix.equals(context)) continue;
            singularPrefix = null;
            break;
        }
        if (singularPrefix != null) {
            int len = singularPrefix.length();
            for (DigitalSignal sSig : an.getSignals()) {
                String context = sSig.getSignalContext();
                if (context == null || context.length() <= len) {
                    sSig.setSignalContext(null);
                    continue;
                }
                sSig.setSignalContext(context.substring(len + 1));
            }
        }
        return sd;
    }

    private void cleanUpScope(List<DigitalSignal> curArray, DigitalAnalysis an) {
        if (curArray == null) {
            return;
        }
        String last = null;
        String scope = null;
        int firstEntry = 0;
        int firstIndex = 0;
        int lastIndex = 0;
        int numSignalsInArray = curArray.size();
        for (int j = 0; j < numSignalsInArray; ++j) {
            DigitalSignal sig = curArray.get(j);
            int squarePos = sig.getSignalName().indexOf(91);
            if (squarePos < 0) continue;
            String purename = sig.getSignalName().substring(0, squarePos);
            int index = TextUtils.atoi(sig.getSignalName().substring(squarePos + 1));
            if (last == null) {
                firstEntry = j;
                last = purename;
                firstIndex = lastIndex = index;
                scope = sig.getSignalContext();
                continue;
            }
            if (last.equals(purename)) {
                lastIndex = index;
                continue;
            }
            DigitalSignal arraySig = new DigitalSignal(an);
            arraySig.setSignalName(last + "[" + firstIndex + ":" + lastIndex + "]", scope);
            arraySig.buildBussedSignalList();
            int width = j - firstEntry;
            for (int i = 0; i < width; ++i) {
                DigitalSignal subSig = curArray.get(firstEntry + i);
                arraySig.addToBussedSignalList(subSig);
            }
            last = null;
        }
        if (last != null) {
            DigitalSignal arraySig = new DigitalSignal(an);
            arraySig.setSignalName(last + "[" + firstIndex + ":" + lastIndex + "]", scope);
            arraySig.buildBussedSignalList();
            int width = numSignalsInArray - firstEntry;
            for (int i = 0; i < width; ++i) {
                DigitalSignal subSig = curArray.get(firstEntry + i);
                arraySig.addToBussedSignalList(subSig);
            }
        }
    }

    private void addSignalToHashMap(DigitalSignal sig, String symbol, HashMap<String, Object> symbolTable) {
        Object entry = symbolTable.get(symbol);
        if (entry == null) {
            symbolTable.put(symbol, sig);
        } else if (entry instanceof DigitalSignal) {
            ArrayList<Object> manySigs = new ArrayList<Object>();
            manySigs.add(entry);
            manySigs.add(sig);
            symbolTable.put(symbol, manySigs);
        } else if (entry instanceof List) {
            ((List)entry).add(sig);
        }
    }

    private void parseToEnd() throws IOException {
        String keyword;
        while ((keyword = this.getNextKeyword()) != null && !keyword.equals("$end")) {
        }
    }

    private String getNextKeyword() throws IOException {
        String keyword = null;
        do {
            if (this.lastLine == null) {
                this.lastLine = this.getLineFromSimulator();
                if (this.lastLine == null) break;
                this.lineLen = this.lastLine.length();
                this.linePos = 0;
            }
            if (this.linePos < this.lineLen) {
                char ch = this.lastLine.charAt(this.linePos);
                if (ch == ' ' || ch == '\t') {
                    ++this.linePos;
                } else {
                    int startOfKeyword = this.linePos++;
                    while (this.linePos < this.lineLen && this.lastLine.charAt(this.linePos) != ' ') {
                        ++this.linePos;
                    }
                    keyword = this.lastLine.substring(startOfKeyword, this.linePos);
                }
            }
            if (this.linePos < this.lineLen) continue;
            this.lastLine = null;
        } while (keyword == null);
        return keyword;
    }

    private static class VerilogStimuli {
        double time;
        int state;

        VerilogStimuli(double time, int state) {
            this.time = time;
            this.state = state;
        }
    }
}

