/*
 * Decompiled with CFR 0.152.
 */
package gnu.lists;

import gnu.lists.AbstractSequence;
import gnu.lists.Array;
import gnu.lists.Consumer;
import gnu.lists.Convert;
import gnu.lists.GeneralArray;
import gnu.lists.Sequence;
import java.util.Collection;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SimpleVector<E>
extends AbstractSequence<E>
implements Sequence<E>,
Array<E> {
    public int size;

    @Override
    public final int size() {
        return this.size;
    }

    protected void checkCanWrite() {
    }

    public void setSize(int size) {
        this.checkCanWrite();
        int oldSize = this.size;
        this.size = size;
        if (size < oldSize) {
            this.clearBuffer(size, oldSize - size);
        } else {
            int oldLength = this.getBufferLength();
            if (size > oldLength) {
                int newLength = oldLength < 16 ? 16 : 2 * oldLength;
                this.setBufferLength(size > newLength ? size : newLength);
            }
        }
    }

    protected void resizeShift(int oldGapStart, int oldGapEnd, int newGapStart, int newGapEnd) {
        int gapDelta;
        this.checkCanWrite();
        int oldGapSize = oldGapEnd - oldGapStart;
        int newGapSize = newGapEnd - newGapStart;
        int oldLength = this.getBufferLength();
        int newLength = oldLength - oldGapSize + newGapSize;
        if (newLength > oldLength) {
            this.setBufferLength(newLength);
            this.size = newLength;
        }
        if ((gapDelta = oldGapStart - newGapStart) >= 0) {
            int endLength = oldLength - oldGapEnd;
            this.shift(oldGapEnd, newLength - endLength, endLength);
            if (gapDelta > 0) {
                this.shift(newGapStart, newGapEnd, gapDelta);
            }
        } else {
            int endLength = newLength - newGapEnd;
            this.shift(oldLength - endLength, newGapEnd, endLength);
            this.shift(oldGapEnd, oldGapStart, newGapStart - oldGapStart);
        }
        this.clearBuffer(newGapStart, newGapSize);
    }

    public abstract int getBufferLength();

    public abstract void setBufferLength(int var1);

    @Override
    protected boolean isAfterPos(int ipos) {
        return (ipos & 1) != 0;
    }

    @Override
    protected int nextIndex(int ipos) {
        return ipos == -1 ? this.size : ipos >>> 1;
    }

    @Override
    public int createPos(int index, boolean isAfter) {
        return index << 1 | (isAfter ? 1 : 0);
    }

    @Override
    public int nextPos(int ipos) {
        if (ipos == -1) {
            return 0;
        }
        int index = ipos >>> 1;
        if (index == this.size) {
            return 0;
        }
        return (index << 1) + 3;
    }

    protected abstract Object getBuffer();

    @Override
    public E get(int index) {
        if (index >= this.size) {
            throw new IndexOutOfBoundsException();
        }
        return this.getBuffer(index);
    }

    @Override
    public Object getPosNext(int ipos) {
        int index = ipos >>> 1;
        return index >= this.size ? eofValue : this.getBuffer(index);
    }

    public int intAtBuffer(int index) {
        return Convert.toInt(this.getBuffer(index));
    }

    public int intAt(int index) {
        if (index >= this.size) {
            throw new IndexOutOfBoundsException();
        }
        return this.intAtBuffer(index);
    }

    public long longAt(int index) {
        if (index >= this.size) {
            throw new IndexOutOfBoundsException();
        }
        return this.longAtBuffer(index);
    }

    public long longAtBuffer(int index) {
        return Convert.toLong(this.getBuffer(index));
    }

    @Override
    public E getRowMajor(int i) {
        return this.get(i);
    }

    protected abstract E getBuffer(int var1);

    @Override
    public E set(int index, E value) {
        this.checkCanWrite();
        if (index >= this.size) {
            throw new IndexOutOfBoundsException();
        }
        E old = this.getBuffer(index);
        this.setBuffer(index, value);
        return old;
    }

    protected abstract E setBuffer(int var1, E var2);

    @Override
    public void fill(E value) {
        this.checkCanWrite();
        int i = this.size;
        while (--i >= 0) {
            this.setBuffer(i, value);
        }
    }

    @Override
    public void fillPosRange(int fromPos, int toPos, E value) {
        int j;
        this.checkCanWrite();
        int n = j = toPos == -1 ? this.size : toPos >>> 1;
        for (int i = fromPos == -1 ? this.size : fromPos >>> 1; i < j; ++i) {
            this.setBuffer(i, value);
        }
    }

    @Override
    public void fill(int fromIndex, int toIndex, E value) {
        this.checkCanWrite();
        if (fromIndex < 0 || toIndex > this.size) {
            throw new IndexOutOfBoundsException();
        }
        for (int i = fromIndex; i < toIndex; ++i) {
            this.setBuffer(i, value);
        }
    }

    public void shift(int srcStart, int dstStart, int count) {
        this.checkCanWrite();
        Object data = this.getBuffer();
        System.arraycopy(data, srcStart, data, dstStart, count);
    }

    @Override
    public boolean add(E o) {
        this.add(this.size, o);
        return true;
    }

    @Override
    protected int addPos(int ipos, E value) {
        int index = ipos >>> 1;
        this.add(index, value);
        return (index << 1) + 3;
    }

    @Override
    public void add(int index, E o) {
        this.checkCanWrite();
        int oldSize = this.size;
        int newSize = oldSize + 1;
        int length = this.getBufferLength();
        if (newSize > length) {
            this.setBufferLength(length < 16 ? 16 : 2 * length);
        }
        this.size = newSize;
        if (oldSize != index) {
            this.shift(index, index + 1, oldSize - index);
        }
        this.set(index, o);
    }

    @Override
    public boolean addAll(int index, Collection<? extends E> c) {
        this.checkCanWrite();
        boolean changed = false;
        int count = c.size();
        this.setSize(this.size + count);
        this.shift(index, index + count, this.size - count - index);
        Iterator<E> it = c.iterator();
        while (it.hasNext()) {
            this.set(index++, it.next());
            changed = true;
        }
        return changed;
    }

    protected abstract void clearBuffer(int var1, int var2);

    @Override
    protected void removePosRange(int ipos0, int ipos1) {
        if ((ipos0 >>>= 1) >= (ipos1 >>>= 1)) {
            return;
        }
        if (ipos1 > this.size) {
            ipos1 = this.size;
        }
        this.shift(ipos1, ipos0, this.size - ipos1);
        int count = ipos1 - ipos0;
        this.size -= count;
        this.clearBuffer(this.size, count);
    }

    @Override
    public void removePos(int ipos, int count) {
        int ipos1;
        int ipos0;
        int index = ipos >>> 1;
        if (index > this.size) {
            index = this.size;
        }
        if (count >= 0) {
            ipos0 = index;
            ipos1 = index + count;
        } else {
            ipos0 = index + count;
            ipos1 = index;
            count = -count;
        }
        if (ipos0 < 0 || ipos1 >= this.size) {
            throw new IndexOutOfBoundsException();
        }
        this.shift(ipos1, ipos0, this.size - ipos1);
        this.size -= count;
        this.clearBuffer(this.size, count);
    }

    @Override
    public E remove(int index) {
        if (index < 0 || index >= this.size) {
            throw new IndexOutOfBoundsException();
        }
        E result = this.get(index);
        this.shift(index + 1, index, 1);
        --this.size;
        this.clearBuffer(this.size, 1);
        return result;
    }

    @Override
    public boolean remove(Object o) {
        int index = this.indexOf(o);
        if (index < 0) {
            return false;
        }
        this.shift(index + 1, index, 1);
        --this.size;
        this.clearBuffer(this.size, 1);
        return true;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        boolean changed = false;
        int j = 0;
        for (int i = 0; i < this.size; ++i) {
            E value = this.get(i);
            if (c.contains(value)) {
                changed = true;
                continue;
            }
            if (changed) {
                this.set(j, value);
            }
            ++j;
        }
        this.setSize(j);
        return changed;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        boolean changed = false;
        int j = 0;
        for (int i = 0; i < this.size; ++i) {
            E value = this.get(i);
            if (!c.contains(value)) {
                changed = true;
                continue;
            }
            if (changed) {
                this.set(j, value);
            }
            ++j;
        }
        this.setSize(j);
        return changed;
    }

    @Override
    public void clear() {
        this.setSize(0);
    }

    public String getTag() {
        return null;
    }

    protected static int compareToInt(SimpleVector v1, SimpleVector v2) {
        int n1 = v1.size;
        int n2 = v2.size;
        int n = n1 > n2 ? n2 : n1;
        for (int i = 0; i < n; ++i) {
            int i1 = v1.intAtBuffer(i);
            int i2 = v2.intAtBuffer(i);
            if (11 == i2) continue;
            return i1 > i2 ? 1 : -1;
        }
        return n1 - n2;
    }

    protected static int compareToLong(SimpleVector v1, SimpleVector v2) {
        int n1 = v1.size;
        int n2 = v2.size;
        int n = n1 > n2 ? n2 : n1;
        for (int i = 0; i < n; ++i) {
            long i2;
            long i1 = v1.longAtBuffer(i);
            if (i1 == (i2 = v2.longAtBuffer(i))) continue;
            return i1 > i2 ? 1 : -1;
        }
        return n1 - n2;
    }

    public void consume(int start, int length, Consumer out) {
        this.consumePosRange(start << 1, start + length << 1, out);
    }

    @Override
    public boolean consumeNext(int ipos, Consumer out) {
        int index = ipos >>> 1;
        if (index >= this.size) {
            return false;
        }
        out.writeObject(this.getBuffer(index));
        return true;
    }

    @Override
    public void consumePosRange(int iposStart, int iposEnd, Consumer out) {
        if (out.ignoring()) {
            return;
        }
        int i = iposStart >>> 1;
        int end = iposEnd >>> 1;
        if (end > this.size) {
            end = this.size;
        }
        while (i < end) {
            out.writeObject(this.getBuffer(i));
            ++i;
        }
    }

    @Override
    public int getNextKind(int ipos) {
        return this.hasNext(ipos) ? this.getElementKind() : 0;
    }

    public int getElementKind() {
        return 32;
    }

    @Override
    public Array transpose(int[] lowBounds, int[] dimensions, int offset0, int[] factors) {
        GeneralArray array = new GeneralArray();
        array.strides = factors;
        array.dimensions = dimensions;
        array.lowBounds = lowBounds;
        array.offset = offset0;
        array.base = this;
        array.simple = false;
        return array;
    }
}

