/*
 * Decompiled with CFR 0.152.
 */
package gnu.kawa.lispexpr;

import gnu.expr.Keyword;
import gnu.kawa.lispexpr.LispReader;
import gnu.kawa.lispexpr.ReadTableEntry;
import gnu.mapping.InPort;
import gnu.mapping.Values;
import gnu.text.Lexer;
import gnu.text.LineBufferedReader;
import gnu.text.SyntaxException;
import java.io.IOException;

public class ReaderDispatchMisc
extends ReadTableEntry {
    protected int code;
    private static ReaderDispatchMisc instance = new ReaderDispatchMisc();

    public static ReaderDispatchMisc getInstance() {
        return instance;
    }

    public ReaderDispatchMisc() {
        this.code = -1;
    }

    public ReaderDispatchMisc(int n) {
        this.code = n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object read(Lexer lexer, int n, int n2) throws IOException, SyntaxException {
        LispReader lispReader = (LispReader)lexer;
        char c = '\u0000';
        if (this.code >= 0) {
            n = this.code;
        }
        switch (n) {
            case 58: {
                int n3 = lispReader.tokenBufferLength;
                lispReader.readToken(lispReader.read(), false, 'P');
                int n4 = lispReader.tokenBufferLength - n3;
                String string = new String(lispReader.tokenBuffer, n3, n4);
                lispReader.tokenBufferLength = n3;
                return Keyword.make(string.intern());
            }
            case 92: {
                return LispReader.readCharacter(lispReader);
            }
            case 33: {
                return LispReader.readSpecial(lispReader);
            }
            case 84: {
                return Boolean.TRUE;
            }
            case 70: {
                n = lexer.peek();
                if (Character.isDigit((char)n)) {
                    return LispReader.readSimpleVector(lispReader, 'F');
                }
                return Boolean.FALSE;
            }
            case 83: 
            case 85: {
                return LispReader.readSimpleVector(lispReader, (char)n);
            }
            case 82: {
                if (n2 > 36) {
                    lexer.error("the radix " + n2 + " is too big (max is 36)");
                    n2 = 36;
                }
                return LispReader.readNumberWithRadix(0, lispReader, n2);
            }
            case 88: {
                return LispReader.readNumberWithRadix(0, lispReader, 16);
            }
            case 68: {
                return LispReader.readNumberWithRadix(0, lispReader, 10);
            }
            case 79: {
                return LispReader.readNumberWithRadix(0, lispReader, 8);
            }
            case 66: {
                return LispReader.readNumberWithRadix(0, lispReader, 2);
            }
            case 69: 
            case 73: {
                lispReader.tokenBufferAppend(35);
                lispReader.tokenBufferAppend(n);
                return LispReader.readNumberWithRadix(2, lispReader, 0);
            }
            case 124: {
                LineBufferedReader lineBufferedReader = lispReader.getPort();
                if (lineBufferedReader instanceof InPort) {
                    c = ((InPort)lineBufferedReader).readState;
                    ((InPort)lineBufferedReader).readState = (char)124;
                }
                try {
                    lispReader.readNestedComment('#', '|');
                }
                finally {
                    if (lineBufferedReader instanceof InPort) {
                        ((InPort)lineBufferedReader).readState = c;
                    }
                }
                return Values.empty;
            }
        }
        lexer.error("An invalid #-construct was read.");
        return Values.empty;
    }
}

