/*
 * Decompiled with CFR 0.152.
 */
package gnu.expr;

import gnu.bytecode.ArrayClassLoader;
import gnu.bytecode.ArrayType;
import gnu.bytecode.ClassType;
import gnu.bytecode.CodeAttr;
import gnu.bytecode.Field;
import gnu.bytecode.Label;
import gnu.bytecode.Method;
import gnu.bytecode.PrimType;
import gnu.bytecode.SwitchState;
import gnu.bytecode.Type;
import gnu.bytecode.Variable;
import gnu.expr.ChainLambdas;
import gnu.expr.CheckedTarget;
import gnu.expr.ClassExp;
import gnu.expr.ConditionalTarget;
import gnu.expr.ConsumerTarget;
import gnu.expr.Declaration;
import gnu.expr.Expression;
import gnu.expr.FindCapturedVars;
import gnu.expr.FindTailCalls;
import gnu.expr.IgnoreTarget;
import gnu.expr.Initializer;
import gnu.expr.InlineCalls;
import gnu.expr.Interpreter;
import gnu.expr.LambdaExp;
import gnu.expr.LitTable;
import gnu.expr.Literal;
import gnu.expr.ModuleExp;
import gnu.expr.NameLookup;
import gnu.expr.PairClassType;
import gnu.expr.PushApply;
import gnu.expr.ScopeExp;
import gnu.expr.SeriesTarget;
import gnu.expr.StackTarget;
import gnu.expr.Target;
import gnu.mapping.OutPort;
import gnu.mapping.Procedure;
import gnu.mapping.Values;
import gnu.text.SourceMessages;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Vector;
import java.util.zip.CRC32;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import kawa.Shell;

public class Compilation {
    int maxSelectorValue;
    public ClassType curClass;
    public ClassType mainClass;
    public LambdaExp curLambda;
    public ModuleExp mainLambda;
    public Variable thisDecl;
    Field instanceField;
    public static boolean fewerClasses;
    public static boolean debugPrintFinalExpr;
    public static boolean usingCPStyle;
    public static boolean usingTailCalls;
    public static int moduleStatic;
    ClassType[] classes;
    int numClasses;
    ArrayClassLoader loader;
    public boolean immediate;
    public Method method;
    int method_counter;
    SwitchState fswitch;
    Field fswitchIndex;
    public static ClassType typeObject;
    public static ClassType scmBooleanType;
    public static ClassType typeString;
    public static ClassType javaStringType;
    public static ClassType scmSymbolType;
    public static ClassType scmKeywordType;
    public static ClassType scmSequenceType;
    public static ClassType javaIntegerType;
    public static ClassType scmListType;
    public static ClassType typePair;
    public static ClassType scmPairType;
    public static ClassType scmUndefinedType;
    public static final ArrayType objArrayType;
    public static final ArrayType symbolArrayType;
    public static ClassType scmNamedType;
    public static ClassType typeRunnable;
    public static ClassType typeObjectType;
    public static ClassType typeClassType;
    public static ClassType typeProcedure;
    public static ClassType typeInterpreter;
    public static ClassType typeMacro;
    public static ClassType typeEnvironment;
    public static ClassType typeLocation;
    public static ClassType typeSymbol;
    public static final Method getSymbolValueMethod;
    public static final Method getSymbolProcedureMethod;
    public static final Method getLocationMethod;
    public static final Method getProcedureBindingMethod;
    public static final Field trueConstant;
    public static final Field falseConstant;
    static final Field voidConstant;
    static final Field undefinedConstant;
    static final Field emptyConstant;
    static final Field eofConstant;
    static final Method setNameMethod;
    static Method initIntegerMethod;
    static Method lookupGlobalMethod;
    static Method defineGlobalMethod;
    static Method defineFunctionMethod;
    static Method putGlobalMethod;
    static Method makeListMethod;
    public static final Type[] int1Args;
    public static final Type[] string1Arg;
    public static final Type[] sym1Arg;
    public static final Method getSymbolEnvironmentMethod;
    public static Method getCurrentEnvironmentMethod;
    public static Type[] apply0args;
    public static Type[] apply1args;
    public static Type[] apply2args;
    public static Type[] applyNargs;
    static Method checkArgCountMethod;
    public static Method apply0method;
    public static Method apply1method;
    public static Method apply2method;
    public static Method apply3method;
    public static Method apply4method;
    public static Method applyNmethod;
    public static Method[] applymethods;
    public static ClassType typeProcedure0;
    public static ClassType typeProcedure1;
    public static ClassType typeProcedure2;
    public static ClassType typeProcedure3;
    public static ClassType typeProcedure4;
    public static ClassType typeProcedureN;
    public static ClassType typeModuleBody;
    public static ClassType typeApplet;
    public static ClassType typeServlet;
    public static ClassType typeModuleMethod;
    public static ClassType typeApplyMethodProc;
    public static ClassType typeApplyMethodContainer;
    public static ClassType typeCallContext;
    public static final ClassType typeConsumer;
    public static Method getCallContextInstanceMethod;
    public static ClassType typeValues;
    public static Field noArgsField;
    public static Field pcCallContextField;
    public static ClassType typeCpsProcedure;
    public static ClassType typeCallFrame;
    public static ClassType typeCpsMethodProc;
    public static ClassType typeCpsMethodContainer;
    public static Field numArgsCallFrameField;
    public static Field argsCallContextField;
    public static Field procCallContextField;
    public static Field callerCallFrameField;
    public static Field saved_pcCallFrameField;
    private static Type[] applyCpsArgs;
    public static Method applyCpsMethod;
    public static ClassType[] typeProcedureArray;
    Initializer clinitChain;
    public static boolean generateMainDefault;
    public boolean generateMain = generateMainDefault;
    LitTable litTable;
    public static boolean generateAppletDefault;
    public boolean generateApplet = generateAppletDefault;
    public static boolean generateServletDefault;
    public boolean generateServlet = generateServletDefault;
    public static boolean inlineOk;
    public String classPrefix;
    String source_filename;
    int localFieldIndex;
    public NameLookup lexical;
    protected ScopeExp current_scope;
    protected SourceMessages messages;

    public final CodeAttr getCode() {
        return this.method.getCode();
    }

    public static final ClassType getMethodProcType(ClassType classType) {
        return usingTailCalls ? typeCpsMethodProc : (classType.getSuperclass().isSubtype(typeProcedure) ? typeModuleMethod : typeApplyMethodProc);
    }

    public final ClassType getModuleSuperType(ModuleExp moduleExp) {
        ClassType classType = moduleExp.getSuperType();
        return classType != null ? classType : (Compilation.usingCPStyle() ? typeCallFrame : (this.generateApplet ? typeApplet : (this.generateServlet ? typeServlet : typeModuleBody)));
    }

    public void compileConstant(Object object2) {
        CodeAttr codeAttr = this.getCode();
        if (object2 == null) {
            codeAttr.emitPushNull();
        } else if (object2 instanceof String && !this.immediate) {
            codeAttr.emitPushString((String)object2);
        } else {
            Literal literal = this.litTable.findLiteral(object2);
            if (literal.field == null) {
                literal.assign(this.litTable);
            }
            codeAttr.emitGetStatic(literal.field);
        }
    }

    public boolean inlineOk(Expression expression) {
        if (expression instanceof LambdaExp && !(((LambdaExp)expression).currentLambda() instanceof ModuleExp)) {
            return true;
        }
        return inlineOk;
    }

    public boolean inlineOk(Procedure procedure) {
        return inlineOk;
    }

    public void compileConstant(Object object2, Target target) {
        if (target instanceof IgnoreTarget) {
            return;
        }
        if (object2 instanceof Values && (target instanceof ConsumerTarget || target instanceof SeriesTarget)) {
            Object[] objectArray = ((Values)object2).getValues();
            int n = 0;
            while (n < objectArray.length) {
                this.compileConstant(objectArray[n], target);
                ++n;
            }
            return;
        }
        if (target instanceof ConditionalTarget) {
            ConditionalTarget conditionalTarget = (ConditionalTarget)target;
            this.getCode().emitGoto(this.getInterpreter().isTrue(object2) ? conditionalTarget.ifTrue : conditionalTarget.ifFalse);
            return;
        }
        if (target instanceof StackTarget) {
            Object object3;
            Type type = ((StackTarget)target).getType();
            if (type instanceof PrimType) {
                try {
                    int n;
                    String string = type.getSignature();
                    object3 = this.getCode();
                    int n2 = n = string == null || string.length() != 1 ? 32 : (int)string.charAt(0);
                    if (object2 instanceof Number) {
                        Number number = (Number)object2;
                        switch (n) {
                            case 73: {
                                ((CodeAttr)object3).emitPushInt(number.intValue());
                                return;
                            }
                            case 83: {
                                ((CodeAttr)object3).emitPushInt(number.shortValue());
                                return;
                            }
                            case 66: {
                                ((CodeAttr)object3).emitPushInt(number.byteValue());
                                return;
                            }
                            case 74: {
                                ((CodeAttr)object3).emitPushLong(number.longValue());
                                return;
                            }
                            case 70: {
                                ((CodeAttr)object3).emitPushFloat(number.floatValue());
                                return;
                            }
                            case 68: {
                                ((CodeAttr)object3).emitPushDouble(number.doubleValue());
                                return;
                            }
                        }
                    }
                    if (n == 67) {
                        ((CodeAttr)object3).emitPushInt(((PrimType)type).charValue(object2));
                        return;
                    }
                    if (n == 90) {
                        PrimType cfr_ignored_0 = (PrimType)type;
                        boolean bl = PrimType.booleanValue(object2);
                        ((CodeAttr)object3).emitPushInt(bl ? 1 : 0);
                        return;
                    }
                }
                catch (ClassCastException classCastException) {
                    // empty catch block
                }
            }
            try {
                object2 = type.coerceFromObject(object2);
            }
            catch (Exception exception) {
                object3 = new StringBuffer();
                if (object2 == Values.empty) {
                    ((StringBuffer)object3).append("cannot convert void to ");
                } else {
                    ((StringBuffer)object3).append("cannot convert literal (of type ");
                    ((StringBuffer)object3).append(object2.getClass().getName());
                    ((StringBuffer)object3).append(") to ");
                }
                ((StringBuffer)object3).append(type.getName());
                this.error('w', ((StringBuffer)object3).toString());
            }
        }
        this.compileConstant(object2);
        target.compileFromStack(this, object2 == null ? target.getType() : Type.make(object2.getClass()));
    }

    private void emitLiterals() {
        if (!this.immediate && this.litTable.literalsChain != null) {
            try {
                this.litTable.emit();
            }
            catch (Throwable throwable) {
                this.error('e', "Literals: Internal error:" + throwable);
                throwable.printStackTrace(System.err);
            }
        }
    }

    private void dumpInitializers(Initializer initializer) {
        Initializer initializer2 = Initializer.reverse(initializer);
        while (initializer2 != null) {
            initializer2.emit(this);
            initializer2 = initializer2.next;
        }
    }

    public ClassType findNamedClass(String string) {
        int n = 0;
        while (n < this.numClasses) {
            if (string.equals(this.classes[n].getName())) {
                return this.classes[n];
            }
            ++n;
        }
        return null;
    }

    public static String mangleName(String string) {
        return Compilation.mangleName(string, false);
    }

    public static String mangleNameIfNeeded(String string) {
        if (Compilation.isValidJavaName(string)) {
            return string;
        }
        return Compilation.mangleName(string, true);
    }

    public static boolean isValidJavaName(String string) {
        int n = string.length();
        if (n == 0 || !Character.isJavaIdentifierStart(string.charAt(0))) {
            return false;
        }
        int n2 = n;
        while (--n2 > 0) {
            if (Character.isJavaIdentifierPart(string.charAt(n2))) continue;
            return false;
        }
        return true;
    }

    public static String mangleName(String string, boolean bl) {
        int n = string.length();
        StringBuffer stringBuffer = new StringBuffer(n);
        boolean bl2 = false;
        int n2 = 0;
        while (n2 < n) {
            char c = string.charAt(n2);
            if (bl2) {
                c = Character.toTitleCase(c);
                bl2 = false;
            }
            if (Character.isDigit(c)) {
                if (n2 == 0) {
                    stringBuffer.append("$N");
                }
                stringBuffer.append(c);
            } else if (Character.isLetter(c) || c == '_') {
                stringBuffer.append(c);
            } else if (c == '$') {
                stringBuffer.append(bl ? "$$" : "$");
            } else {
                switch (c) {
                    case '+': {
                        stringBuffer.append("$Pl");
                        break;
                    }
                    case '-': {
                        char c2;
                        if (bl) {
                            stringBuffer.append("$Mn");
                            break;
                        }
                        char c3 = c2 = n2 + 1 < n ? string.charAt(n2 + 1) : (char)'\u0000';
                        if (c2 == '>') {
                            stringBuffer.append("$To$");
                            ++n2;
                            break;
                        }
                        if (Character.isLowerCase(c2)) break;
                        stringBuffer.append("$Mn");
                        break;
                    }
                    case '*': {
                        stringBuffer.append("$St");
                        break;
                    }
                    case '/': {
                        stringBuffer.append("$Sl");
                        break;
                    }
                    case '=': {
                        stringBuffer.append("$Eq");
                        break;
                    }
                    case '<': {
                        stringBuffer.append("$Ls");
                        break;
                    }
                    case '>': {
                        stringBuffer.append("$Gr");
                        break;
                    }
                    case '@': {
                        stringBuffer.append("$At");
                        break;
                    }
                    case '~': {
                        stringBuffer.append("$Tl");
                        break;
                    }
                    case '%': {
                        stringBuffer.append("$Pc");
                        break;
                    }
                    case '.': {
                        stringBuffer.append("$Dt");
                        break;
                    }
                    case ',': {
                        stringBuffer.append("$Cm");
                        break;
                    }
                    case '(': {
                        stringBuffer.append("$LP");
                        break;
                    }
                    case ')': {
                        stringBuffer.append("$RP");
                        break;
                    }
                    case '[': {
                        stringBuffer.append("$LB");
                        break;
                    }
                    case ']': {
                        stringBuffer.append("$RB");
                        break;
                    }
                    case '{': {
                        stringBuffer.append("$LC");
                        break;
                    }
                    case '}': {
                        stringBuffer.append("$RC");
                        break;
                    }
                    case '\'': {
                        stringBuffer.append("$Sq");
                        break;
                    }
                    case '\"': {
                        stringBuffer.append("$Dq");
                        break;
                    }
                    case '&': {
                        stringBuffer.append("$Am");
                        break;
                    }
                    case '#': {
                        stringBuffer.append("$Nm");
                        break;
                    }
                    case '?': {
                        char c2;
                        char c4 = c2 = stringBuffer.length() > 0 ? stringBuffer.charAt(0) : (char)'\u0000';
                        if (!bl && n2 + 1 == n && Character.isLowerCase(c2)) {
                            stringBuffer.setCharAt(0, Character.toTitleCase(c2));
                            stringBuffer.insert(0, "is");
                            break;
                        }
                        stringBuffer.append("$Qu");
                        break;
                    }
                    case '!': {
                        stringBuffer.append("$Ex");
                        break;
                    }
                    case ':': {
                        stringBuffer.append("$Cl");
                        break;
                    }
                    case ';': {
                        stringBuffer.append("$SC");
                        break;
                    }
                    case '^': {
                        stringBuffer.append("$Up");
                        break;
                    }
                    case '|': {
                        stringBuffer.append("$VB");
                        break;
                    }
                    default: {
                        stringBuffer.append('$');
                        stringBuffer.append(Character.forDigit(c >> 12 & 0xF, 16));
                        stringBuffer.append(Character.forDigit(c >> 8 & 0xF, 16));
                        stringBuffer.append(Character.forDigit(c >> 4 & 0xF, 16));
                        stringBuffer.append(Character.forDigit(c & 0xF, 16));
                    }
                }
                if (!bl) {
                    bl2 = true;
                }
            }
            ++n2;
        }
        String string2 = stringBuffer.toString();
        return string2.equals(string) ? string : string2;
    }

    public static char demangle2(char c, char c2) {
        switch (c << 16 | c2) {
            case 4259949: {
                return '&';
            }
            case 4259956: {
                return '@';
            }
            case 4391020: {
                return ':';
            }
            case 4391021: {
                return ',';
            }
            case 4456561: {
                return '\"';
            }
            case 0x440074: {
                return '.';
            }
            case 4522097: {
                return '=';
            }
            case 4522104: {
                return '!';
            }
            case 4653170: {
                return '>';
            }
            case 4980802: {
                return '[';
            }
            case 4980803: {
                return '{';
            }
            case 4980816: {
                return '(';
            }
            case 4980851: {
                return '<';
            }
            case 5046371: {
                return '%';
            }
            case 5046382: {
                return '-';
            }
            case 5111917: {
                return '#';
            }
            case 5242979: {
                return '%';
            }
            case 5242988: {
                return '+';
            }
            case 5308533: {
                return '?';
            }
            case 5374018: {
                return ']';
            }
            case 5374019: {
                return '}';
            }
            case 0x520050: {
                return ')';
            }
            case 5439555: {
                return ';';
            }
            case 5439596: {
                return '/';
            }
            case 5439601: {
                return '\\';
            }
            case 5439604: {
                return '*';
            }
            case 5505132: {
                return '~';
            }
            case 0x550070: {
                return '^';
            }
            case 5636162: {
                return '|';
            }
        }
        return '\uffff';
    }

    public static String demangleName(String string) {
        return Compilation.demangleName(string, false);
    }

    public static String demangleName(String string, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = string.length();
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        int n2 = 0;
        while (n2 < n) {
            block6: {
                char c;
                block9: {
                    block7: {
                        char c2;
                        char c3;
                        block8: {
                            char c4;
                            block5: {
                                c = string.charAt(n2);
                                if (bl4 && !bl) {
                                    c = Character.toLowerCase(c);
                                    bl4 = false;
                                }
                                if (bl || c != 'i' || n2 != 0 || n <= 2 || string.charAt(n2 + 1) != 's' || Character.isLowerCase(c4 = string.charAt(n2 + 2))) break block5;
                                bl2 = true;
                                bl3 = true;
                                ++n2;
                                if (Character.isUpperCase(c4) || Character.isTitleCase(c4)) {
                                    stringBuffer.append(Character.toLowerCase(c4));
                                    ++n2;
                                }
                                break block6;
                            }
                            if (c != '$' || n2 + 2 >= n) break block7;
                            c3 = string.charAt(n2 + 1);
                            c4 = Compilation.demangle2(c3, c2 = string.charAt(n2 + 2));
                            if (c4 == '\uffff') break block8;
                            stringBuffer.append(c4);
                            n2 += 2;
                            bl2 = true;
                            bl4 = true;
                            break block6;
                        }
                        if (c3 != 'T' || c2 != 'o' || n2 + 3 >= n || string.charAt(n2 + 3) != '$') break block9;
                        stringBuffer.append("->");
                        n2 += 3;
                        bl2 = true;
                        bl4 = true;
                        break block6;
                    }
                    if (!bl && n2 > 1 && (Character.isUpperCase(c) || Character.isTitleCase(c)) && Character.isLowerCase(string.charAt(n2 - 1))) {
                        stringBuffer.append('-');
                        bl2 = true;
                        c = Character.toLowerCase(c);
                    }
                }
                stringBuffer.append(c);
            }
            ++n2;
        }
        if (bl3) {
            stringBuffer.append('?');
        }
        return bl2 ? stringBuffer.toString() : string;
    }

    public String generateClassName(String string) {
        string = Compilation.mangleName(string, true);
        if (this.mainClass != null) {
            string = this.mainClass.getName() + '$' + string;
        } else if (this.classPrefix != null) {
            string = this.classPrefix + string;
        }
        if (this.findNamedClass(string) == null) {
            return string;
        }
        int n = 0;
        String string2;
        while (this.findNamedClass(string2 = string + n) != null) {
            ++n;
        }
        return string2;
    }

    public Compilation(boolean bl, SourceMessages sourceMessages) {
        this(sourceMessages);
        this.immediate = bl;
    }

    public Compilation(SourceMessages sourceMessages) {
        this.messages = sourceMessages;
        this.lexical = new NameLookup(this.getInterpreter());
    }

    public void compile(ModuleExp moduleExp, String string, String string2) {
        this.source_filename = moduleExp.filename;
        this.classPrefix = string2;
        this.mainLambda = moduleExp;
        if (this.messages.seenErrors()) {
            return;
        }
        this.mainClass = new ClassType(string);
        PushApply.pushApply(moduleExp);
        InlineCalls.inlineCalls(moduleExp, this);
        ChainLambdas.chainLambdas(moduleExp, this);
        FindTailCalls.findTailCalls(moduleExp);
        moduleExp.setCanRead(true);
        FindCapturedVars.findCapturedVars(moduleExp);
        if (this.messages.seenErrors()) {
            return;
        }
        if (debugPrintFinalExpr) {
            OutPort outPort = OutPort.outDefault();
            outPort.println("[Compiling final " + moduleExp.getName() + " class=" + string + ':');
            moduleExp.print(outPort);
            outPort.println(']');
            outPort.flush();
        }
        this.mainClass = this.addClass(moduleExp, this.mainClass);
        this.litTable = new LitTable(this);
        try {
            this.addClass(moduleExp);
        }
        catch (RuntimeException runtimeException) {
            this.error('f', "Internal compiler exception: " + runtimeException);
            throw runtimeException;
        }
    }

    public void compileToFiles(ModuleExp moduleExp, String string, String string2, String string3) throws IOException {
        if (string2 == null || string2.length() == 0) {
            string2 = "";
        } else if (string2.charAt(string2.length() - 1) != File.separatorChar) {
            string2 = string2 + File.separatorChar;
        }
        String string4 = moduleExp.getName();
        if (string4 != null) {
            int n;
            string = string4;
            if (string3 == null && (n = string4.lastIndexOf(46)) >= 0) {
                string3 = string4.substring(0, n + 1);
            }
        }
        if (ModuleExp.debugPrintExpr) {
            OutPort outPort = OutPort.outDefault();
            outPort.println("[Compiling module-name:" + moduleExp.getName() + " top:" + string + " prefix=" + string3 + " :");
            moduleExp.print(outPort);
            outPort.println(']');
            outPort.flush();
        }
        this.compile(moduleExp, string, string3);
        this.outputClass(string2);
    }

    public void outputClass(String string) throws IOException {
        char c = File.separatorChar;
        int n = 0;
        while (n < this.numClasses) {
            ClassType classType = this.classes[n];
            String string2 = string + classType.getName().replace('.', c) + ".class";
            String string3 = new File(string2).getParent();
            if (string3 != null) {
                new File(string3).mkdirs();
            }
            classType.writeToFile(string2);
            ++n;
        }
    }

    public void compileToArchive(ModuleExp moduleExp, String string) throws IOException {
        boolean bl = false;
        if (string.endsWith(".zip")) {
            bl = false;
        } else if (string.endsWith(".jar")) {
            bl = true;
        } else {
            string = string + ".zip";
            bl = false;
        }
        this.compile(moduleExp, LambdaExp.fileFunctionName, null);
        File file = new File(string);
        if (file.exists()) {
            file.delete();
        }
        ZipOutputStream zipOutputStream = new ZipOutputStream(new FileOutputStream(file));
        zipOutputStream.setMethod(0);
        byte[][] byArrayArray = new byte[this.numClasses][];
        CRC32 cRC32 = new CRC32();
        int n = 0;
        while (n < this.numClasses) {
            ClassType classType = this.classes[n];
            byArrayArray[n] = classType.writeToArray();
            ZipEntry zipEntry = new ZipEntry(classType.getName().replace('.', '/') + ".class");
            zipEntry.setSize(byArrayArray[n].length);
            cRC32.reset();
            cRC32.update(byArrayArray[n], 0, byArrayArray[n].length);
            zipEntry.setCrc(cRC32.getValue());
            zipOutputStream.putNextEntry(zipEntry);
            zipOutputStream.write(byArrayArray[n]);
            ++n;
        }
        zipOutputStream.close();
    }

    public void addClass(ClassType classType) {
        if (this.source_filename != null) {
            classType.setSourceFile(this.source_filename);
        }
        if (this.classes == null) {
            this.classes = new ClassType[20];
        } else if (this.numClasses >= this.classes.length) {
            ClassType[] classTypeArray = new ClassType[2 * this.classes.length];
            System.arraycopy(this.classes, 0, classTypeArray, 0, this.numClasses);
            this.classes = classTypeArray;
        }
        this.classes[this.numClasses++] = classType;
        classType.access_flags |= 0x21;
    }

    ClassType allocClass(ModuleExp moduleExp) {
        String string = moduleExp.getJavaName();
        string = this.generateClassName(string);
        return this.addClass(moduleExp, new ClassType(string));
    }

    ClassType addClass(ModuleExp moduleExp, ClassType classType) {
        ClassType[] classTypeArray = moduleExp.getInterfaces();
        if (classTypeArray != null) {
            classType.setInterfaces(classTypeArray);
        }
        classType.setSuper(this.getModuleSuperType(moduleExp));
        moduleExp.type = classType;
        this.addClass(classType);
        return classType;
    }

    public final Method getConstructor(LambdaExp lambdaExp) {
        return Compilation.getConstructor(lambdaExp.getHeapFrameType(), lambdaExp);
    }

    public static final Method getConstructor(ClassType classType, LambdaExp lambdaExp) {
        Type[] typeArray = lambdaExp instanceof ClassExp && lambdaExp.staticLinkField != null ? new Type[]{lambdaExp.staticLinkField.getType()} : apply0args;
        return classType.addMethod("<init>", 1, typeArray, Type.void_type);
    }

    public final void generateConstructor(LambdaExp lambdaExp) {
        this.generateConstructor(lambdaExp.getHeapFrameType(), lambdaExp);
    }

    public final void generateConstructor(ClassType classType, LambdaExp lambdaExp) {
        LambdaExp lambdaExp2;
        Method method;
        Method method2 = this.method;
        ClassType classType2 = this.curClass;
        this.curClass = classType;
        classType.constructor = method = Compilation.getConstructor(classType, lambdaExp);
        Method method3 = classType.getSuperclass().addMethod("<init>", 1, apply0args, Type.void_type);
        this.method = method;
        CodeAttr codeAttr = method.startCode();
        codeAttr.emitPushThis();
        codeAttr.emitInvokeSpecial(method3);
        if (lambdaExp instanceof ClassExp && lambdaExp.staticLinkField != null) {
            codeAttr.emitPushThis();
            codeAttr.emitLoad(codeAttr.getCurrentScope().getVariable(1));
            codeAttr.emitPutField(lambdaExp.staticLinkField);
        }
        lambdaExp.initChain = Initializer.reverse(lambdaExp.initChain);
        if (lambdaExp.initChain != null) {
            Initializer initializer;
            lambdaExp2 = this.curLambda;
            this.curLambda = new LambdaExp();
            this.curLambda.closureEnv = codeAttr.getArg(0);
            this.curLambda.outer = lambdaExp2;
            while ((initializer = lambdaExp.initChain) != null) {
                lambdaExp.initChain = initializer.next;
                initializer.emit(this);
            }
            this.curLambda = lambdaExp2;
        }
        if (lambdaExp instanceof ClassExp) {
            lambdaExp2 = (ClassExp)lambdaExp;
            this.callInitMethods(((ClassExp)lambdaExp2).getCompiledClassType(this), new Vector(10));
        }
        codeAttr.emitReturn();
        this.method = method2;
        this.curClass = classType2;
    }

    private void callInitMethods(ClassType classType, Vector vector) {
        int n;
        if (classType == null) {
            return;
        }
        String string = classType.getName();
        if ("java.lang.Object".equals(string)) {
            return;
        }
        int n2 = vector.size();
        while (--n2 >= 0) {
            if (((ClassType)vector.elementAt(n2)).getName() != string) continue;
            return;
        }
        vector.addElement(classType);
        this.callInitMethods(classType.getSuperclass(), vector);
        ClassType[] classTypeArray = classType.getInterfaces();
        if (classTypeArray != null) {
            n = classTypeArray.length;
            int n3 = 0;
            while (n3 < n) {
                this.callInitMethods(classTypeArray[n3], vector);
                ++n3;
            }
        }
        n = 1;
        if (classType instanceof PairClassType) {
            classType = ((PairClassType)classType).instanceType;
        } else if (classType.isInterface()) {
            try {
                classType = (ClassType)Type.make(Class.forName(classType.getName() + "$class"));
            }
            catch (Throwable throwable) {
                return;
            }
        } else {
            n = 0;
        }
        Method method = classType.getDeclaredMethod("$finit$", n);
        if (method != null) {
            CodeAttr codeAttr = this.getCode();
            codeAttr.emitPushThis();
            codeAttr.emitInvoke(method);
        }
    }

    public void generateApplyMethods(LambdaExp lambdaExp) {
        int n;
        int n2 = n = lambdaExp.applyMethods == null ? 0 : lambdaExp.applyMethods.size();
        if (n == 0) {
            return;
        }
        boolean bl = !this.curClass.getSuperclass().isSubtype(typeProcedure);
        ClassType classType = Compilation.getMethodProcType(this.curClass);
        if (usingTailCalls) {
            this.curClass.addInterface(typeCpsMethodContainer);
        } else if (bl) {
            this.curClass.addInterface(typeApplyMethodContainer);
        }
        Method method = this.method;
        CodeAttr codeAttr = null;
        int n3 = usingTailCalls ? 5 : 0;
        while (n3 < 6) {
            Object object2;
            boolean bl2 = false;
            SwitchState switchState = null;
            String string = null;
            Type[] typeArray = null;
            int n4 = n;
            while (--n4 >= 0) {
                Type type;
                int n5;
                int n6;
                object2 = (LambdaExp)lambdaExp.applyMethods.elementAt(n4);
                Method[] methodArray = ((LambdaExp)object2).primMethods;
                int n7 = methodArray.length;
                boolean bl3 = ((LambdaExp)object2).max_args < 0 || usingTailCalls || ((LambdaExp)object2).max_args >= ((LambdaExp)object2).min_args + n7;
                boolean bl4 = false;
                if (n3 < 5) {
                    n6 = n3 - ((LambdaExp)object2).min_args;
                    if (n6 < 0 || n6 >= n7 || n6 == n7 - 1 && bl3) {
                        bl4 = true;
                    }
                    n7 = 1;
                    bl3 = false;
                } else {
                    n6 = 5 - ((LambdaExp)object2).min_args;
                    if (n6 > 0 && n7 <= n6 && !bl3) {
                        bl4 = true;
                    }
                    n6 = n7 - 1;
                }
                if (bl4 && !bl) continue;
                if (!bl2) {
                    if (n3 < 5) {
                        string = "apply" + n3;
                        typeArray = new Type[n3 + 1];
                        int n8 = n3;
                        while (n8 > 0) {
                            typeArray[n8] = typeObject;
                            --n8;
                        }
                    } else if (usingTailCalls) {
                        string = "apply";
                        typeArray = new Type[2];
                        typeArray[1] = typeCallContext;
                    } else {
                        string = "applyN";
                        typeArray = new Type[2];
                        typeArray[1] = objArrayType;
                    }
                    typeArray[0] = classType;
                    this.method = this.curClass.addMethod(string, typeArray, usingTailCalls ? Type.void_type : Type.pointer_type, 1);
                    codeAttr = this.method.startCode();
                    codeAttr.emitLoad(codeAttr.getArg(1));
                    codeAttr.emitGetField(classType.getDeclaredField("selector"));
                    switchState = new SwitchState(codeAttr);
                    bl2 = true;
                }
                if (bl4 && bl) continue;
                switchState.addCase(((LambdaExp)object2).getSelectorValue(this), codeAttr);
                Method method2 = methodArray[n6];
                Type[] typeArray2 = method2.getParameterTypes();
                int n9 = typeArray2.length;
                int n10 = bl3 ? n9 - 1 : n9;
                Variable variable = null;
                int n11 = 0;
                if (n3 > 4 && n7 > 1) {
                    variable = codeAttr.addLocal(Type.int_type);
                    codeAttr.emitLoad(codeAttr.getArg(2));
                    codeAttr.emitArrayLength();
                    if (((LambdaExp)object2).min_args != 0) {
                        codeAttr.emitPushInt(((LambdaExp)object2).min_args);
                        codeAttr.emitSub(Type.int_type);
                    }
                    codeAttr.emitStore(variable);
                }
                int n12 = n5 = method2.getStaticFlag() ? 0 : 1;
                if (n5 > 0) {
                    codeAttr.emitPushThis();
                }
                Declaration declaration = ((ScopeExp)object2).firstDecl();
                int n13 = 0;
                while (n13 < n10) {
                    if (variable != null && n13 >= ((LambdaExp)object2).min_args) {
                        codeAttr.emitLoad(variable);
                        codeAttr.emitIfIntLEqZero();
                        codeAttr.emitInvoke(methodArray[n13 - ((LambdaExp)object2).min_args]);
                        codeAttr.emitElse();
                        ++n11;
                        codeAttr.emitInc(variable, (short)-1);
                    }
                    if (n3 > 4) {
                        codeAttr.emitLoad(codeAttr.getArg(2));
                        codeAttr.emitPushInt(n13);
                        codeAttr.emitArrayLoad(Type.pointer_type);
                    } else {
                        codeAttr.emitLoad(codeAttr.getArg(n13 + 2));
                    }
                    type = declaration.getType();
                    if (type != Type.pointer_type) {
                        CheckedTarget.emitCheckedCoerce(this, (LambdaExp)object2, n13, type);
                    }
                    declaration = declaration.nextDecl();
                    ++n13;
                }
                if (bl3) {
                    type = typeArray2[n10];
                    if (type instanceof ArrayType) {
                        boolean bl5;
                        Type type2 = ((ArrayType)type).getComponentType();
                        boolean bl6 = bl5 = !"java.lang.Object".equals(type2.getName());
                        if (n10 == 0 && !bl5) {
                            codeAttr.emitLoad(codeAttr.getArg(2));
                        } else {
                            codeAttr.pushScope();
                            if (variable == null) {
                                variable = codeAttr.addLocal(Type.int_type);
                                codeAttr.emitLoad(codeAttr.getArg(2));
                                codeAttr.emitArrayLength();
                                if (n10 != 0) {
                                    codeAttr.emitPushInt(n10);
                                    codeAttr.emitSub(Type.int_type);
                                }
                                codeAttr.emitStore(variable);
                            }
                            codeAttr.emitLoad(variable);
                            codeAttr.emitNewArray(type2);
                            Label label = new Label(codeAttr);
                            codeAttr.emitGoto(label);
                            Label label2 = new Label(codeAttr);
                            label2.define(codeAttr);
                            codeAttr.emitDup(1);
                            codeAttr.emitLoad(variable);
                            codeAttr.emitLoad(codeAttr.getArg(2));
                            codeAttr.emitLoad(variable);
                            if (n10 != 0) {
                                codeAttr.emitPushInt(n10);
                                codeAttr.emitAdd(Type.int_type);
                            }
                            codeAttr.emitArrayLoad(Type.pointer_type);
                            if (bl5) {
                                CheckedTarget.emitCheckedCoerce(this, (LambdaExp)object2, ((LambdaExp)object2).getName(), -1, type2);
                            }
                            codeAttr.emitArrayStore(type2);
                            label.define(codeAttr);
                            codeAttr.emitInc(variable, (short)-1);
                            codeAttr.emitLoad(variable);
                            codeAttr.emitGotoIfIntGeZero(label2);
                            codeAttr.popScope();
                        }
                    } else if ("gnu.lists.LList".equals(type.getName())) {
                        codeAttr.emitLoad(codeAttr.getArg(2));
                        codeAttr.emitPushInt(n10);
                        codeAttr.emitInvokeStatic(makeListMethod);
                    } else if (type == typeCallContext) {
                        codeAttr.emitLoad(codeAttr.getArg(2));
                    } else {
                        throw new RuntimeException("unsupported #!rest type:" + type);
                    }
                }
                codeAttr.emitInvoke(method2);
                while (--n11 >= 0) {
                    codeAttr.emitFi();
                }
                if (!usingTailCalls) {
                    Target.pushObject.compileFromStack(this, ((LambdaExp)object2).getReturnType());
                }
                codeAttr.emitReturn();
            }
            if (bl2) {
                switchState.addDefault(codeAttr);
                if (usingTailCalls) {
                    codeAttr.emitLoad(codeAttr.getArg(1));
                    object2 = typeCpsMethodProc.getDeclaredMethod("applyError", 0);
                    codeAttr.emitInvokeVirtual((Method)object2);
                } else {
                    int n14 = n3 > 4 ? 2 : n3 + 1;
                    ++n14;
                    int n15 = bl ? 1 : 0;
                    while (n15 < n14) {
                        codeAttr.emitLoad(codeAttr.getArg(n15));
                        ++n15;
                    }
                    if (bl) {
                        string = string + "Default";
                        Method method3 = typeApplyMethodProc.getDeclaredMethod(string, typeArray);
                        codeAttr.emitInvokeStatic(method3);
                    } else {
                        codeAttr.emitInvokeSpecial(this.curClass.getSuperclass().getDeclaredMethod(string, typeArray));
                    }
                }
                codeAttr.emitReturn();
                switchState.finish(codeAttr);
            }
            ++n3;
        }
        this.method = method;
    }

    private Method startClassInit() {
        ClassType classType;
        Method method;
        this.method = this.curClass.addMethod("<clinit>", apply0args, Type.void_type, 9);
        CodeAttr codeAttr = this.method.startCode();
        if ((this.generateMain || this.generateApplet || this.generateServlet) && (method = (classType = (ClassType)Type.make(this.getInterpreter().getClass())).getDeclaredMethod("registerEnvironment", 0)) != null) {
            codeAttr.emitInvokeStatic(method);
        }
        return this.method;
    }

    public final ClassType addClass(ModuleExp moduleExp) {
        Object object2;
        int n;
        Type[] typeArray;
        Method method;
        Type[] typeArray2;
        int n2;
        ClassType classType = moduleExp.type;
        if (classType == typeProcedure) {
            classType = this.allocClass(moduleExp);
        }
        this.curClass = classType;
        String string = moduleExp.getFile();
        moduleExp.type = classType;
        if (string != null) {
            classType.setSourceFile(string);
        }
        LambdaExp lambdaExp = this.curLambda;
        this.curLambda = moduleExp;
        if (moduleExp.isHandlingTailCalls() || Compilation.usingCPStyle()) {
            boolean bl = true;
            n2 = 63;
            typeArray2 = new Type[]{typeCallContext};
        } else if (moduleExp.min_args != moduleExp.max_args || moduleExp.min_args > 4 || fewerClasses && this.curClass == this.mainClass) {
            boolean bl = true;
            n2 = 78;
            typeArray2 = new Type[]{new ArrayType(typeObject)};
        } else {
            int n3 = moduleExp.min_args;
            n2 = Character.forDigit(n3, 10);
            typeArray2 = new Type[n3];
            int n4 = n3;
            while (--n4 >= 0) {
                typeArray2[n4] = typeObject;
            }
        }
        if (n2 == 78 || n2 == 63) {
            this.method = this.curClass.addMethod("numArgs", apply0args, Type.int_type, 1);
            CodeAttr codeAttr = this.method.startCode();
            codeAttr.emitPushInt(moduleExp.min_args | moduleExp.max_args << 12);
            codeAttr.emitReturn();
        }
        Expression expression = moduleExp.body;
        Variable variable = moduleExp.heapFrame;
        boolean bl = false;
        Label label = null;
        Label label2 = null;
        if (Compilation.usingCPStyle()) {
            method = this.curClass.addMethod("step", typeArray2, Type.void_type, 17);
        } else if (moduleExp.isHandlingTailCalls()) {
            method = this.curClass.addMethod("apply", typeArray2, Type.void_type, 17);
        } else {
            bl = true;
            this.generateConstructor(moduleExp);
            this.instanceField = this.curClass.addField("$instance", this.curClass, 24);
            method = this.startClassInit();
            CodeAttr codeAttr = this.getCode();
            codeAttr.emitNew(this.curClass);
            codeAttr.emitDup(this.curClass);
            codeAttr.emitInvokeSpecial(this.curClass.constructor);
            codeAttr.emitPutStatic(this.instanceField);
            label = new Label(codeAttr);
            label2 = new Label(codeAttr);
            codeAttr.emitGoto(label);
            label2.define(codeAttr);
        }
        this.method = method;
        this.method.initCode();
        CodeAttr codeAttr = this.getCode();
        this.thisDecl = this.method.getStaticFlag() ? null : moduleExp.declareThis(classType);
        moduleExp.closureEnv = moduleExp.thisVariable;
        moduleExp.heapFrame = moduleExp.thisVariable;
        moduleExp.allocChildClasses(this);
        if (moduleExp.isHandlingTailCalls() || Compilation.usingCPStyle()) {
            Variable variable2 = new Variable("$ctx", typeCallContext);
            typeArray = moduleExp.scope;
            typeArray.addVariableAfter(this.thisDecl, variable2);
            variable2.setParameter(true);
            variable2.setArtificial(true);
        }
        if ((n = moduleExp.getLine()) > 0) {
            codeAttr.putLineNumber(n);
        }
        moduleExp.allocParameters(this);
        moduleExp.enterFunction(this);
        if (Compilation.usingCPStyle()) {
            this.loadCallContext();
            codeAttr.emitGetField(pcCallContextField);
            this.fswitch = new SwitchState(codeAttr);
            typeArray = new Label(codeAttr);
            typeArray.define(codeAttr);
            this.fswitch.addCase(0, (Label)typeArray, codeAttr);
        }
        try {
            moduleExp.compileBody(this);
        }
        catch (Exception exception) {
            this.error('f', "internal error while compiling - caught: " + exception);
            exception.printStackTrace(System.err);
            System.exit(-1);
        }
        moduleExp.compileEnd(this);
        if (fewerClasses) {
            this.method.popScope();
        }
        moduleExp.heapFrame = variable;
        moduleExp.compileChildMethods(this);
        if (Compilation.usingCPStyle() || fewerClasses && this.curClass == this.mainClass) {
            codeAttr = this.getCode();
            this.fswitch.finish(codeAttr);
        }
        if (this.curClass == this.mainClass && (bl || this.clinitChain != null || this.litTable.literalsChain != null || this.generateMain || this.generateApplet || this.generateServlet)) {
            typeArray = this.method;
            if (bl) {
                label.define(codeAttr);
            } else {
                this.startClassInit();
            }
            codeAttr = this.getCode();
            if (this.clinitChain != null) {
                object2 = new Label(codeAttr);
                Label label3 = new Label(codeAttr);
                Label label4 = new Label(codeAttr);
                codeAttr.emitGoto(label3);
                ((Label)object2).define(codeAttr);
                this.dumpInitializers(this.clinitChain);
                codeAttr.emitGoto(label4);
                label3.define(codeAttr);
                this.emitLiterals();
                codeAttr.emitGoto((Label)object2);
                label4.define(codeAttr);
            } else {
                this.emitLiterals();
            }
            if (bl) {
                codeAttr.emitGoto(label2);
            } else {
                codeAttr.emitReturn();
            }
            this.method = typeArray;
        }
        this.curLambda = lambdaExp;
        if (this.generateMain && this.curClass == this.mainClass) {
            typeArray = new Type[]{new ArrayType(javaStringType)};
            this.method = this.curClass.addMethod("main", 9, typeArray, Type.void_type);
            codeAttr = this.method.startCode();
            if (Shell.defaultFormatName != null) {
                codeAttr.emitPushString(Shell.defaultFormatName);
                codeAttr.emitInvokeStatic(ClassType.make("kawa.Shell").getDeclaredMethod("setDefaultFormat", 1));
            }
            codeAttr.emitNew(this.curClass);
            codeAttr.emitDup(this.curClass);
            codeAttr.emitInvokeSpecial(this.curClass.constructor);
            codeAttr.emitLoad(codeAttr.getArg(0));
            object2 = typeModuleBody.addMethod("runAsMain", 1, typeArray, Type.void_type);
            codeAttr.emitInvokeVirtual((Method)object2);
            codeAttr.emitReturn();
        }
        return classType;
    }

    public static boolean usingCPStyle() {
        return usingCPStyle;
    }

    public boolean usingTailCalls() {
        return usingTailCalls;
    }

    public Field allocLocalField(Type type, String string) {
        if (string == null) {
            string = "tmp_" + ++this.localFieldIndex;
        }
        Field field = this.curClass.addField(string, type, 0);
        return field;
    }

    public final void loadCallContext() {
        Variable variable;
        CodeAttr codeAttr = this.getCode();
        if (this.curLambda.isHandlingTailCalls() && (variable = this.curLambda.scope.lookup("$ctx")) != null && variable.getType() == typeCallContext) {
            codeAttr.emitLoad(variable);
            return;
        }
        codeAttr.emitInvokeStatic(getCallContextInstanceMethod);
    }

    public void freeLocalField(Field field) {
    }

    public Expression parse(Object object2) {
        throw new Error("unimeplemented parse");
    }

    public Interpreter getInterpreter() {
        return Interpreter.getInterpreter();
    }

    public LambdaExp currentLambda() {
        return this.current_scope.currentLambda();
    }

    public final ModuleExp getModule() {
        return this.mainLambda;
    }

    public void setModule(ModuleExp moduleExp) {
        this.mainLambda = moduleExp;
    }

    public ModuleExp currentModule() {
        return this.current_scope.currentModule();
    }

    public void mustCompileHere() {
        ScopeExp scopeExp = this.current_scope;
        while (scopeExp != null) {
            if (scopeExp instanceof ModuleExp) {
                ((ModuleExp)scopeExp).mustCompile = true;
                return;
            }
            scopeExp = scopeExp.outer;
        }
        return;
    }

    public ScopeExp currentScope() {
        return this.current_scope;
    }

    public void push(ScopeExp scopeExp) {
        if (scopeExp instanceof ModuleExp) {
            if (this.mainLambda == null) {
                this.mainLambda = (ModuleExp)scopeExp;
            }
        } else {
            this.mustCompileHere();
        }
        scopeExp.outer = this.current_scope;
        this.current_scope = scopeExp;
        this.lexical.push(scopeExp);
    }

    public void pop(ScopeExp scopeExp) {
        this.lexical.pop(scopeExp);
        this.current_scope = scopeExp.outer;
    }

    public final void pop() {
        this.pop(this.current_scope);
    }

    public void push(Declaration declaration) {
        this.lexical.push(declaration);
    }

    public Declaration lookup(Object object2, int n) {
        return this.lexical.lookup(object2, n);
    }

    public void usedClass(ClassType classType) {
        if (this.loader != null && classType.isExisting()) {
            this.loader.addClass(classType.getReflectClass());
        }
    }

    public SourceMessages getMessages() {
        return this.messages;
    }

    public void setMessages(SourceMessages sourceMessages) {
        this.messages = sourceMessages;
    }

    public void error(char c, String string) {
        this.messages.error(c, this.getFile(), this.getLine(), this.getColumn(), string);
    }

    public void error(char c, Declaration declaration, String string, String string2) {
        String string3 = this.getFile();
        int n = this.getLine();
        int n2 = this.getColumn();
        int n3 = declaration.getLine();
        if (n3 > 0) {
            string3 = declaration.getFile();
            n = n3;
            n2 = declaration.getColumn();
        }
        this.messages.error(c, string3, n, n2, string + declaration.getName() + string2);
    }

    public final String getFile() {
        return this.messages.getFile();
    }

    public final int getLine() {
        return this.messages.getLine();
    }

    public final int getColumn() {
        return this.messages.getColumn();
    }

    public void setFile(String string) {
        this.messages.setFile(string);
    }

    public void setLine(int n) {
        this.messages.setLine(n);
    }

    public void setColumn(int n) {
        this.messages.setColumn(n);
    }

    public void setLine(String string, int n, int n2) {
        this.messages.setLine(string, n, n2);
    }

    static {
        usingTailCalls = false;
        moduleStatic = 0;
        typeObject = Type.pointer_type;
        scmBooleanType = ClassType.make("java.lang.Boolean");
        javaStringType = typeString = ClassType.make("java.lang.String");
        scmSymbolType = typeString;
        scmKeywordType = ClassType.make("gnu.expr.Keyword");
        scmSequenceType = ClassType.make("gnu.lists.Sequence");
        javaIntegerType = ClassType.make("java.lang.Integer");
        scmListType = ClassType.make("gnu.lists.LList");
        scmPairType = typePair = ClassType.make("gnu.lists.Pair");
        scmUndefinedType = ClassType.make("gnu.expr.Undefined");
        objArrayType = ArrayType.make(typeObject);
        symbolArrayType = ArrayType.make(scmSymbolType);
        scmNamedType = ClassType.make("gnu.mapping.Named");
        typeRunnable = ClassType.make("java.lang.Runnable");
        typeObjectType = ClassType.make("gnu.bytecode.ObjectType");
        typeClassType = ClassType.make("gnu.bytecode.ClassType", typeObjectType);
        typeProcedure = ClassType.make("gnu.mapping.Procedure");
        typeInterpreter = ClassType.make("gnu.expr.Interpreter");
        typeMacro = ClassType.make("kawa.lang.Macro");
        typeEnvironment = ClassType.make("gnu.mapping.Environment");
        typeLocation = ClassType.make("gnu.mapping.Location");
        typeSymbol = ClassType.make("gnu.mapping.Symbol", typeLocation);
        getSymbolValueMethod = typeInterpreter.getDeclaredMethod("getSymbolValue", 1);
        getSymbolProcedureMethod = typeInterpreter.getDeclaredMethod("getSymbolProcedure", 1);
        getLocationMethod = typeLocation.addMethod("get", Type.typeArray0, Type.pointer_type, 1);
        getProcedureBindingMethod = typeSymbol.addMethod("getProcedure", Type.typeArray0, typeProcedure, 1);
        trueConstant = scmBooleanType.addField("TRUE", scmBooleanType, 9);
        falseConstant = scmBooleanType.addField("FALSE", scmBooleanType, 9);
        voidConstant = typeInterpreter.addField("voidObject", typeObject, 9);
        undefinedConstant = typeInterpreter.addField("undefinedObject", scmUndefinedType, 9);
        emptyConstant = scmListType.addField("Empty", scmListType, 9);
        eofConstant = scmSequenceType.addField("eofValue", typeObject, 9);
        setNameMethod = typeProcedure.getDeclaredMethod("setName", 1);
        int1Args = new Type[]{Type.int_type};
        string1Arg = new Type[]{javaStringType};
        sym1Arg = string1Arg;
        getSymbolEnvironmentMethod = typeEnvironment.addMethod("getSymbol", string1Arg, typeSymbol, 1);
        Type[] typeArray = new Type[]{objArrayType, Type.int_type};
        makeListMethod = scmListType.addMethod("makeList", typeArray, scmListType, 9);
        initIntegerMethod = javaIntegerType.addMethod("<init>", int1Args, Type.void_type, 1);
        lookupGlobalMethod = typeEnvironment.addMethod("lookup_global", sym1Arg, typeObject, 9);
        Type[] typeArray2 = new Type[]{scmSymbolType, typeObject};
        defineGlobalMethod = typeEnvironment.addMethod("define_global", typeArray2, Type.void_type, 9);
        defineFunctionMethod = typeEnvironment.addMethod("defineFunction", typeArray2, Type.void_type, 9);
        putGlobalMethod = typeEnvironment.addMethod("put_global", typeArray2, Type.void_type, 9);
        getCurrentEnvironmentMethod = typeEnvironment.addMethod("getCurrent", Type.typeArray0, typeEnvironment, 9);
        apply0args = Type.typeArray0;
        apply1args = new Type[]{typeObject};
        apply2args = new Type[]{typeObject, typeObject};
        applyNargs = new Type[]{objArrayType};
        apply0method = typeProcedure.addMethod("apply0", apply0args, typeObject, 17);
        apply1method = typeProcedure.addMethod("apply1", apply1args, typeObject, 1);
        apply2method = typeProcedure.addMethod("apply2", apply2args, typeObject, 1);
        typeArray = new Type[]{typeObject, typeObject, typeObject};
        apply3method = typeProcedure.addMethod("apply3", typeArray, typeObject, 1);
        typeArray2 = new Type[]{typeObject, typeObject, typeObject, typeObject};
        apply4method = typeProcedure.addMethod("apply4", typeArray2, typeObject, 1);
        applyNmethod = typeProcedure.addMethod("applyN", applyNargs, typeObject, 1);
        Type[] typeArray3 = new Type[]{typeProcedure, Type.int_type};
        checkArgCountMethod = typeProcedure.addMethod("checkArgCount", typeArray3, Type.void_type, 9);
        applymethods = new Method[]{apply0method, apply1method, apply2method, apply3method, apply4method, applyNmethod};
        typeProcedure0 = ClassType.make("gnu.mapping.Procedure0", typeProcedure);
        typeProcedure1 = ClassType.make("gnu.mapping.Procedure1", typeProcedure);
        typeProcedure2 = ClassType.make("gnu.mapping.Procedure2", typeProcedure);
        typeProcedure3 = ClassType.make("gnu.mapping.Procedure3", typeProcedure);
        typeProcedure4 = ClassType.make("gnu.mapping.Procedure4", typeProcedure);
        typeProcedureN = ClassType.make("gnu.mapping.ProcedureN", typeProcedure);
        typeModuleBody = ClassType.make("gnu.expr.ModuleBody", typeProcedure0);
        typeApplet = ClassType.make("java.applet.Applet");
        typeServlet = ClassType.make("gnu.kawa.servlet.KawaServlet");
        typeModuleMethod = ClassType.make("gnu.expr.ModuleMethod", typeProcedureN);
        typeApplyMethodProc = ClassType.make("gnu.mapping.ApplyMethodProc", typeProcedureN);
        typeApplyMethodContainer = ClassType.make("gnu.mapping.ApplyMethodContainer");
        typeCallContext = ClassType.make("gnu.mapping.CallContext");
        typeConsumer = ClassType.make("gnu.lists.Consumer");
        getCallContextInstanceMethod = typeCallContext.getDeclaredMethod("getInstance", 0);
        typeValues = ClassType.make("gnu.mapping.Values");
        noArgsField = typeValues.addField("noArgs", objArrayType, 9);
        pcCallContextField = typeCallContext.addField("pc", Type.int_type, 4);
        typeCpsProcedure = ClassType.make("gnu.mapping.CpsProcedure");
        typeCallFrame = ClassType.make("gnu.mapping.CallFrame");
        typeCpsMethodProc = ClassType.make("gnu.mapping.CpsMethodProc", typeCpsProcedure);
        typeCpsMethodContainer = ClassType.make("gnu.mapping.CpsMethodContainer");
        numArgsCallFrameField = typeCallFrame.addField("numArgs", Type.int_type, 4);
        argsCallContextField = typeCallContext.addField("values", objArrayType, 4);
        procCallContextField = typeCallContext.addField("proc", typeProcedure, 4);
        callerCallFrameField = typeCallFrame.addField("caller", typeCallFrame, 4);
        saved_pcCallFrameField = typeCallFrame.addField("saved_pc", Type.int_type, 4);
        applyCpsArgs = new Type[]{typeCallContext};
        applyCpsMethod = typeProcedure.addMethod("apply", applyCpsArgs, Type.void_type, 1);
        typeProcedureArray = new ClassType[]{typeProcedure0, typeProcedure1, typeProcedure2, typeProcedure3, typeProcedure4};
        generateMainDefault = false;
        generateAppletDefault = false;
        generateServletDefault = false;
        inlineOk = true;
    }
}

