/*
 * Decompiled with CFR 0.152.
 */
package gnu.expr;

import gnu.bytecode.CodeAttr;
import gnu.bytecode.PrimType;
import gnu.bytecode.Type;
import gnu.expr.BindingInitializer;
import gnu.expr.CheckedTarget;
import gnu.expr.Compilation;
import gnu.expr.Declaration;
import gnu.expr.ExpWalker;
import gnu.expr.Expression;
import gnu.expr.QuoteExp;
import gnu.expr.ScopeExp;
import gnu.expr.Target;
import gnu.mapping.CallContext;
import gnu.mapping.Location;
import gnu.mapping.OutPort;

public class LetExp
extends ScopeExp {
    public Expression[] inits;
    public Expression body;

    public LetExp(Expression[] i) {
        this.inits = i;
    }

    public Expression getBody() {
        return this.body;
    }

    public void setBody(Expression body) {
        this.body = body;
    }

    protected boolean mustCompile() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void apply(CallContext ctx) throws Throwable {
        this.setIndexes();
        int level = ScopeExp.nesting(this);
        int i = this.frameSize;
        Object[] evalFrame = new Object[i];
        Object[][] evalFrames = ctx.evalFrames;
        if (evalFrames == null) {
            ctx.evalFrames = evalFrames = new Object[level + 10][];
        } else if (level >= evalFrames.length) {
            Object[][] newFrames = new Object[level + 10][];
            System.arraycopy(evalFrames, 0, newFrames, 0, evalFrames.length);
            evalFrames = newFrames;
            ctx.evalFrames = newFrames;
        }
        evalFrames[level] = evalFrame;
        try {
            i = 0;
            Declaration decl = this.firstDecl();
            while (decl != null) {
                Expression init = this.inits[i];
                if (init != QuoteExp.undefined_exp) {
                    Object value = init.eval(ctx);
                    Type type = decl.type;
                    if (type != null && type != Type.pointer_type) {
                        value = type.coerceFromObject(value);
                    }
                    if (decl.isIndirectBinding()) {
                        Location loc = decl.makeIndirectLocationFor();
                        loc.set(value);
                        value = loc;
                    }
                    evalFrame[i] = value;
                }
                decl = decl.nextDecl();
                ++i;
            }
            this.body.apply(ctx);
        }
        finally {
            evalFrames[level] = null;
        }
    }

    void store_rest(Compilation comp, int i, Declaration decl) {
        if (decl != null) {
            this.store_rest(comp, i + 1, decl.nextDecl());
            if (decl.needsInit()) {
                if (decl.isIndirectBinding()) {
                    CodeAttr code = comp.getCode();
                    if (this.inits[i] == QuoteExp.undefined_exp) {
                        Object name = decl.getSymbol();
                        comp.compileConstant(name, Target.pushObject);
                        code.emitInvokeStatic(BindingInitializer.makeLocationMethod(name));
                    } else {
                        decl.pushIndirectBinding(comp);
                    }
                }
                decl.compileStore(comp);
            }
        }
    }

    public void compile(Compilation comp, Target target) {
        CodeAttr code = comp.getCode();
        Declaration decl = this.firstDecl();
        int i = 0;
        while (i < this.inits.length) {
            Target varTarget;
            Expression init = this.inits[i];
            boolean needsInit = decl.needsInit();
            if (needsInit) {
                decl.allocateVariable(code);
            }
            if (!needsInit || decl.isIndirectBinding() && init == QuoteExp.undefined_exp) {
                varTarget = Target.Ignore;
            } else {
                Type varType = decl.getType();
                varTarget = CheckedTarget.getInstance(varType);
                if (init == QuoteExp.undefined_exp) {
                    if (varType instanceof PrimType) {
                        init = new QuoteExp(new Byte(0));
                    } else if (varType != null && varType != Type.pointer_type) {
                        init = QuoteExp.nullExp;
                    }
                }
            }
            init.compile(comp, varTarget);
            ++i;
            decl = decl.nextDecl();
        }
        code.enterScope(this.getVarScope());
        this.store_rest(comp, 0, this.firstDecl());
        this.body.compileWithPosition(comp, target);
        this.popScope(code);
    }

    public final Type getType() {
        return this.body.getType();
    }

    protected Expression walk(ExpWalker walker) {
        return walker.walkLetExp(this);
    }

    public void walkInitializers(ExpWalker walker) {
        Declaration decl = this.firstDecl();
        int i = 0;
        while (i < this.inits.length) {
            Expression init;
            Expression init0 = this.inits[i];
            this.inits[i] = init = walker.walk(init0);
            if (decl.value == init0) {
                decl.value = init;
            }
            ++i;
            decl = decl.nextDecl();
        }
    }

    protected void walkChildren(ExpWalker walker) {
        this.walkInitializers(walker);
        if (walker.exitValue == null) {
            this.body = walker.walk(this.body);
        }
    }

    public void print(OutPort out) {
        this.print(out, "(Let", ")");
    }

    public void print(OutPort out, String startTag, String endTag) {
        out.startLogicalBlock(startTag + "#" + this.id, endTag, 2);
        out.writeSpaceFill();
        this.printLineColumn(out);
        out.startLogicalBlock("(", false, ")");
        int i = 0;
        for (Declaration decl = this.firstDecl(); decl != null; decl = decl.nextDecl()) {
            if (i > 0) {
                out.writeSpaceFill();
            }
            out.startLogicalBlock("(", false, ")");
            decl.printInfo(out);
            if (this.inits != null) {
                out.writeSpaceFill();
                out.print('=');
                out.writeSpaceFill();
                if (i >= this.inits.length) {
                    out.print("<missing init>");
                } else if (this.inits[i] == null) {
                    out.print("<null>");
                } else {
                    this.inits[i].print(out);
                }
                ++i;
            }
            out.endLogicalBlock(")");
        }
        out.endLogicalBlock(")");
        out.writeSpaceLinear();
        if (this.body == null) {
            out.print("<null body>");
        } else {
            this.body.print(out);
        }
        out.endLogicalBlock(endTag);
    }
}

