/*
 * Copyright (C) 2007-2021 Apple Inc. All rights reserved.
 * Copyright (C) 2008 Matt Lilek. All rights reserved.
 * Copyright (C) 2008-2009 Anthony Ricaud <rik@webkit.org>
 * Copyright (C) 2009-2010 Joseph Pecoraro. All rights reserved.
 * Copyright (C) 2009-2011 Google Inc. All rights reserved.
 * Copyright (C) 2009 280 North Inc. All Rights Reserved.
 * Copyright (C) 2010 Nikita Vasilyev. All rights reserved.
 * Copyright (C) 2011 Brian Grinstead All rights reserved.
 * Copyright (C) 2013 Matt Holden <jftholden@yahoo.com>
 * Copyright (C) 2013 Samsung Electronics. All rights reserved.
 * Copyright (C) 2013 Seokju Kwon (seokju.kwon@gmail.com)
 * Copyright (C) 2013 Adobe Systems Inc. All rights reserved.
 * Copyright (C) 2013-2015 University of Washington. All rights reserved.
 * Copyright (C) 2014-2015 Saam Barati <saambarati1@gmail.com>
 * Copyright (C) 2014 Antoine Quint
 * Copyright (C) 2015 Tobias Reiss <tobi+webkit@basecode.de>
 * Copyright (C) 2015-2017 Devin Rousso <webkit@devinrousso.com>. All rights reserved.
 * Copyright (C) 2017 The Chromium Authors
 * Copyright (C) 2017-2018 Sony Interactive Entertainment Inc.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY APPLE INC. AND ITS CONTRIBUTORS ``AS IS''
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL APPLE INC. OR ITS CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */
var WI={};WI.Platform={name:InspectorFrontendHost.platform,version:{name:InspectorFrontendHost.platformVersionName,}};class Debouncer
{constructor(callback)
{this._callback=callback;this._lastArguments=[];this._timeoutIdentifier=undefined;this._animationFrameIdentifier=undefined;this._promiseIdentifier=undefined;}
force()
{this._lastArguments=arguments;this._execute();}
delayForTime(time,...args)
{this.cancel();this._lastArguments=args;this._timeoutIdentifier=setTimeout(()=>{this._execute();},time);}
delayForFrame()
{this.cancel();this._lastArguments=arguments;this._animationFrameIdentifier=requestAnimationFrame(()=>{this._execute();});}
delayForMicrotask()
{this.cancel();this._lastArguments=arguments;let promiseIdentifier=Symbol("next-microtask");this._promiseIdentifier=promiseIdentifier;queueMicrotask(()=>{if(this._promiseIdentifier===promiseIdentifier)
this._execute();});}
cancel()
{this._lastArguments=[];if(this._timeoutIdentifier){clearTimeout(this._timeoutIdentifier);this._timeoutIdentifier=undefined;}
if(this._animationFrameIdentifier){cancelAnimationFrame(this._animationFrameIdentifier);this._animationFrameIdentifier=undefined;}
if(this._promiseIdentifier)
this._promiseIdentifier=undefined;}
_execute()
{let args=this._lastArguments;this.cancel();this._callback.apply(undefined,args);}}
WI.DebuggableType={ITML:"itml",JavaScript:"javascript",Page:"page",ServiceWorker:"service-worker",WebPage:"web-page",};WI.DebuggableType.fromString=function(type){switch(type){case"itml":return WI.DebuggableType.ITML;case"javascript":return WI.DebuggableType.JavaScript;case"page":return WI.DebuggableType.Page;case"service-worker":return WI.DebuggableType.ServiceWorker;case"web-page":return WI.DebuggableType.WebPage;}
return null;};WI.DebuggableType.supportedTargetTypes=function(debuggableType){let targetTypes=new Set;switch(debuggableType){case WI.DebuggableType.ITML:targetTypes.add(WI.TargetType.ITML);break;case WI.DebuggableType.JavaScript:targetTypes.add(WI.TargetType.JavaScript);break;case WI.DebuggableType.Page:targetTypes.add(WI.TargetType.Page);targetTypes.add(WI.TargetType.Worker);break;case WI.DebuggableType.ServiceWorker:targetTypes.add(WI.TargetType.ServiceWorker);break;case WI.DebuggableType.WebPage:targetTypes.add(WI.TargetType.Page);targetTypes.add(WI.TargetType.WebPage);targetTypes.add(WI.TargetType.Worker);break;}
return targetTypes;};class IterableWeakSet
{constructor(items=[])
{this._wrappers=new Set;this._wrapperForItem=new WeakMap;for(let item of items)
this.add(item);}
get size()
{let size=0;for(let wrapper of this._wrappers){if(wrapper.deref())
++size;}
return size;}
has(item)
{let result=this._wrapperForItem.has(item);return result;}
add(item)
{if(this.has(item))
return;let wrapper=new WeakRef(item);this._wrappers.add(wrapper);this._wrapperForItem.set(item,wrapper);this._finalizationRegistry.register(item,{weakThis:new WeakRef(this),wrapper},wrapper);}
delete(item)
{return!!this.take(item);}
take(item)
{let wrapper=this._wrapperForItem.get(item);if(!wrapper)
return undefined;let itemDeleted=this._wrapperForItem.delete(item);let wrapperDeleted=this._wrappers.delete(wrapper);this._finalizationRegistry.unregister(wrapper);return item;}
clear()
{for(let wrapper of this._wrappers){this._wrapperForItem.delete(wrapper);this._finalizationRegistry.unregister(wrapper);}
this._wrappers.clear();}
keys()
{return this.values();}*values()
{for(let wrapper of this._wrappers){let item=wrapper.deref();if(item)
yield item;}}
[Symbol.iterator]()
{return this.values();}
copy()
{return new IterableWeakSet(this.toJSON());}
toJSON()
{return Array.from(this);}
get _finalizationRegistry()
{return IterableWeakSet._finalizationRegistry??=new FinalizationRegistry(function(heldValue){heldValue.weakThis.deref()?._wrappers.delete(heldValue.wrapper);});}}
class Multimap
{constructor(items=[])
{this._map=new Map;for(let[key,value]of items)
this.add(key,value);}
get size()
{return this._map.size;}
has(key,value)
{let valueSet=this._map.get(key);if(!valueSet)
return false;return value===undefined||valueSet.has(value);}
get(key)
{return this._map.get(key);}
add(key,value)
{let valueSet=this._map.get(key);if(!valueSet){valueSet=new Set;this._map.set(key,valueSet);}
valueSet.add(value);return this;}
delete(key,value)
{if(arguments.length===1)
return this._map.delete(key);let valueSet=this._map.get(key);if(!valueSet)
return false;let deleted=valueSet.delete(value);if(!valueSet.size)
this._map.delete(key);return deleted;}
take(key,value)
{if(arguments.length===1)
return this._map.take(key);let valueSet=this._map.get(key);if(!valueSet)
return undefined;let result=valueSet.take(value);if(!valueSet.size)
this._map.delete(key);return result;}
clear()
{this._map.clear();}
keys()
{return this._map.keys();}*values()
{for(let valueSet of this._map.values()){for(let value of valueSet)
yield value;}}
sets()
{return this._map.entries();}*[Symbol.iterator]()
{for(let[key,valueSet]of this._map){for(let value of valueSet)
yield[key,value];}}
copy()
{return new Multimap(this.toJSON());}
toJSON()
{return Array.from(this);}}
WI.Object=class WebInspectorObject
{constructor()
{this._listeners=null;}
static addEventListener(eventType,listener,thisObject)
{thisObject??=this;let data={listener,thisObjectWeakRef:new WeakRef(thisObject),};WI.Object._listenerThisObjectFinalizationRegistry.register(thisObject,{eventTargetWeakRef:new WeakRef(this),eventType,data},data);this._listeners??=new Multimap;this._listeners.add(eventType,data);return listener;}
static singleFireEventListener(eventType,listener,thisObject)
{let eventTargetWeakRef=new WeakRef(this);return this.addEventListener(eventType,function wrappedCallback(){eventTargetWeakRef.deref()?.removeEventListener(eventType,wrappedCallback,this);listener.apply(this,arguments);},thisObject);}
static awaitEvent(eventType,thisObject)
{return new Promise((resolve,reject)=>{this.singleFireEventListener(eventType,resolve,thisObject);});}
static removeEventListener(eventType,listener,thisObject)
{if(!this._listeners)
return;thisObject??=this;let listenersForEventType=this._listeners.get(eventType);if(!listenersForEventType)
return;let didDelete=false;for(let data of listenersForEventType){let unwrapped=data.thisObjectWeakRef.deref();if(!unwrapped||unwrapped!==thisObject||data.listener!==listener)
continue;if(this._listeners.delete(eventType,data))
didDelete=true;WI.Object._listenerThisObjectFinalizationRegistry.unregister(data);}}
addEventListener(){return WI.Object.addEventListener.apply(this,arguments);}
singleFireEventListener(){return WI.Object.singleFireEventListener.apply(this,arguments);}
awaitEvent(){return WI.Object.awaitEvent.apply(this,arguments);}
removeEventListener(){return WI.Object.removeEventListener.apply(this,arguments);}
dispatchEventToListeners(eventType,eventData)
{let event=new WI.Event(this,eventType,eventData);function dispatch(object)
{if(!object||event._stoppedPropagation)
return;let listeners=object._listeners;if(!listeners||!object.hasOwnProperty("_listeners")||!listeners.size)
return;let listenersForEventType=listeners.get(eventType);if(!listenersForEventType)
return;for(let data of Array.from(listenersForEventType)){let unwrapped=data.thisObjectWeakRef.deref();if(!unwrapped)
continue;data.listener.call(unwrapped,event);if(event._stoppedPropagation)
break;}}
dispatch(this);event._stoppedPropagation=false;let constructor=this.constructor;while(constructor){dispatch(constructor);if(!constructor.prototype.__proto__)
break;constructor=constructor.prototype.__proto__.constructor;}
return event.defaultPrevented;}
static hasEventListeners(eventType)
{return this._listeners?.has(eventType);}
static activelyListeningObjectsWithPrototype(proto)
{let results=new Set;if(this._listeners){for(let data of this._listeners.values()){let unwrapped=data.thisObjectWeakRef.deref();if(unwrapped instanceof proto)
results.add(unwrapped);}}
return results;}
hasEventListeners(){return WI.Object.hasEventListeners.apply(this,arguments);}
activelyListeningObjectsWithPrototype(){return WI.Object.activelyListeningObjectsWithPrototype.apply(this,arguments);}};WI.Object._listenerThisObjectFinalizationRegistry=new FinalizationRegistry((heldValue)=>{heldValue.eventTargetWeakRef.deref()?._listeners.delete(heldValue.eventType,heldValue.data);});WI.Event=class Event
{constructor(target,type,data)
{this.target=target;this.type=type;this.data=data;this.defaultPrevented=false;this._stoppedPropagation=false;}
stopPropagation()
{this._stoppedPropagation=true;}
preventDefault()
{this.defaultPrevented=true;}};WI.notifications=new WI.Object;WI.Notification={GlobalModifierKeysDidChange:"global-modifiers-did-change",PageArchiveStarted:"page-archive-started",PageArchiveEnded:"page-archive-ended",ExtraDomainsActivated:"extra-domains-activated",VisibilityStateDidChange:"visibility-state-did-change",TransitionPageTarget:"transition-page-target",};WI.ReferencePage=class ReferencePage{constructor(page,{topic}={})
{if(page instanceof WI.ReferencePage)
page=page.page;this._page=page;this._topic=topic||"";}
get page(){return this._page;}
get topic(){return this._topic;}
createLinkElement()
{let url="https://webkit.org/web-inspector/"+this._page+"/";if(this._topic)
url+="#"+this._topic;let wrapper=document.createElement("span");wrapper.className="reference-page-link-container";let link=wrapper.appendChild(document.createElement("a"));link.className="reference-page-link";link.href=link.title=url;link.textContent="?";link.addEventListener("click",(event)=>{event.preventDefault();event.stopPropagation();WI.openURL(link.href,{alwaysOpenExternally:true});});return wrapper;}};WI.ReferencePage.AuditTab=new WI.ReferencePage("audit-tab");WI.ReferencePage.AuditTab.AuditResults=new WI.ReferencePage(WI.ReferencePage.AuditTab,{topic:"audit-results"});WI.ReferencePage.AuditTab.CreatingAudits=new WI.ReferencePage(WI.ReferencePage.AuditTab,{topic:"creating-audits"});WI.ReferencePage.AuditTab.EditingAudits=new WI.ReferencePage(WI.ReferencePage.AuditTab,{topic:"editing-audits"});WI.ReferencePage.AuditTab.RunningAudits=new WI.ReferencePage(WI.ReferencePage.AuditTab,{topic:"running-audits"});WI.ReferencePage.DOMBreakpoints=new WI.ReferencePage("dom-breakpoints");WI.ReferencePage.DOMBreakpoints.Configuration=new WI.ReferencePage(WI.ReferencePage.DOMBreakpoints,{topic:"configuration"});WI.ReferencePage.DeviceSettings=new WI.ReferencePage("device-settings");WI.ReferencePage.DeviceSettings.Configuration=new WI.ReferencePage(WI.ReferencePage.DeviceSettings,{topic:"configuration"});WI.ReferencePage.EventBreakpoints=new WI.ReferencePage("event-breakpoints");WI.ReferencePage.EventBreakpoints.Configuration=new WI.ReferencePage(WI.ReferencePage.EventBreakpoints,{topic:"configuration"});WI.ReferencePage.JavaScriptBreakpoints=new WI.ReferencePage("javascript-breakpoints");WI.ReferencePage.JavaScriptBreakpoints.Configuration=new WI.ReferencePage(WI.ReferencePage.JavaScriptBreakpoints,{topic:"configuration"});WI.ReferencePage.LayersTab=new WI.ReferencePage("layers-tab");WI.ReferencePage.LocalOverrides=new WI.ReferencePage("local-overrides");WI.ReferencePage.LocalOverrides.ConfiguringLocalOverrides=new WI.ReferencePage(WI.ReferencePage.LocalOverrides,{topic:"configuring-local-overrides"});WI.ReferencePage.TimelinesTab=new WI.ReferencePage("timelines-tab");WI.ReferencePage.TimelinesTab.CPUTimeline=new WI.ReferencePage(WI.ReferencePage.TimelinesTab,{topic:"cpu-timeline"});WI.ReferencePage.TimelinesTab.EventsView=new WI.ReferencePage(WI.ReferencePage.TimelinesTab,{topic:"events-view"});WI.ReferencePage.TimelinesTab.FramesView=new WI.ReferencePage(WI.ReferencePage.TimelinesTab,{topic:"frames-view"});WI.ReferencePage.TimelinesTab.JavaScriptAllocationsTimeline=new WI.ReferencePage(WI.ReferencePage.TimelinesTab,{topic:"javascript-allocations-timeline"});WI.ReferencePage.TimelinesTab.JavaScriptAndEventsTimeline=new WI.ReferencePage(WI.ReferencePage.TimelinesTab,{topic:"javascript-events-timeline"});WI.ReferencePage.TimelinesTab.LayoutAndRenderingTimeline=new WI.ReferencePage(WI.ReferencePage.TimelinesTab,{topic:"layout-rendering-timeline"});WI.ReferencePage.TimelinesTab.MediaAndAnimationsTimeline=new WI.ReferencePage(WI.ReferencePage.TimelinesTab,{topic:"media-animations-timeline"});WI.ReferencePage.TimelinesTab.MemoryTimeline=new WI.ReferencePage(WI.ReferencePage.TimelinesTab,{topic:"memory-timeline"});WI.ReferencePage.TimelinesTab.NetworkRequestsTimeline=new WI.ReferencePage(WI.ReferencePage.TimelinesTab,{topic:"network-timeline"});WI.ReferencePage.TimelinesTab.ScreenshotsTimeline=new WI.ReferencePage(WI.ReferencePage.TimelinesTab,{topic:"screenshots-timeline"});WI.ReferencePage.URLBreakpoints=new WI.ReferencePage("url-breakpoints");WI.ReferencePage.URLBreakpoints.Configuration=new WI.ReferencePage(WI.ReferencePage.URLBreakpoints,{topic:"configuration"});WI.TargetType={ITML:"itml",JavaScript:"javascript",Page:"page",ServiceWorker:"service-worker",WebPage:"web-page",Worker:"worker",};WI.TargetType.all=Object.values(WI.TargetType);class Throttler
{constructor(callback,delay)
{this._callback=callback;this._delay=delay;this._lastArguments=[];this._timeoutIdentifier=undefined;this._lastFireTime=-this._delay;}
force()
{this._lastArguments=arguments;this._execute();}
fire()
{this._lastArguments=arguments;let remaining=this._delay-(Date.now()-this._lastFireTime);if(remaining<=0){this._execute();return;}
if(this._timeoutIdentifier)
return;this._timeoutIdentifier=setTimeout(()=>{this._execute();},remaining);}
cancel()
{this._lastArguments=[];if(this._timeoutIdentifier){clearTimeout(this._timeoutIdentifier);this._timeoutIdentifier=undefined;}}
_execute()
{this._lastFireTime=Date.now();let args=this._lastArguments;this.cancel();this._callback.apply(undefined,args);}}
WI.BlobUtilities=class BlobUtilities{static blobForContent(content,base64Encoded,mimeType)
{if(base64Encoded)
return BlobUtilities.decodeBase64ToBlob(content,mimeType);return BlobUtilities.textToBlob(content,mimeType);}
static decodeBase64ToBlob(base64Data,mimeType)
{mimeType=mimeType||"";const sliceSize=1024;let byteCharacters=atob(base64Data);let bytesLength=byteCharacters.length;let slicesCount=Math.ceil(bytesLength/sliceSize);let byteArrays=new Array(slicesCount);for(let sliceIndex=0;sliceIndex<slicesCount;++sliceIndex){let begin=sliceIndex*sliceSize;let end=Math.min(begin+sliceSize,bytesLength);let bytes=new Array(end-begin);for(let offset=begin,i=0;offset<end;++i,++offset)
bytes[i]=byteCharacters[offset].charCodeAt(0);byteArrays[sliceIndex]=new Uint8Array(bytes);}
return new Blob(byteArrays,{type:mimeType});}
static textToBlob(text,mimeType)
{return new Blob([text],{type:mimeType});}
static blobAsText(blob,callback)
{let fileReader=new FileReader;fileReader.addEventListener("loadend",()=>{callback(fileReader.result);});fileReader.readAsText(blob);}};WI.roleSelectorForNode=function(node)
{var title="";var role=node.computedRole();if(role)
title=":role("+role+")";return title;};WI.linkifyAccessibilityNodeReference=function(node)
{if(!node)
return null;var link=WI.linkifyNodeReference(node);var tagIdSelector=link.title;var classSelectorIndex=tagIdSelector.indexOf(".");if(classSelectorIndex>-1)
tagIdSelector=tagIdSelector.substring(0,classSelectorIndex);var roleSelector=WI.roleSelectorForNode(node);link.textContent=tagIdSelector+roleSelector;link.title+=roleSelector;return link;};WI.linkifyStyleable=function(styleable)
{let displayName=styleable.displayName;let link=document.createElement("span");link.append(displayName);return WI.linkifyNodeReferenceElement(styleable.node,link,{displayName});};WI.linkifyNodeReference=function(node,options={})
{let displayName=node.displayName;if(!isNaN(options.maxLength))
displayName=displayName.truncate(options.maxLength);let link=document.createElement("span");link.append(displayName);return WI.linkifyNodeReferenceElement(node,link,{...options,displayName});};WI.linkifyNodeReferenceElement=function(node,element,options={})
{element.setAttribute("role","link");element.title=options.displayName||node.displayName;let nodeType=node.nodeType();if(!options.ignoreClick&&(nodeType!==Node.DOCUMENT_NODE||node.parentNode)&&nodeType!==Node.TEXT_NODE)
element.classList.add("node-link");WI.bindInteractionsForNodeToElement(node,element,options);return element;};WI.bindInteractionsForNodeToElement=function(node,element,options={}){if(!options.ignoreClick){element.addEventListener("click",(event)=>{WI.domManager.inspectElement(node.id,{initiatorHint:WI.TabBrowser.TabNavigationInitiator.LinkClick,});});}
element.addEventListener("mouseover",(event)=>{node.highlight();});element.addEventListener("mouseout",(event)=>{WI.domManager.hideDOMNodeHighlight();});element.addEventListener("contextmenu",(event)=>{let contextMenu=WI.ContextMenu.createFromEvent(event);WI.appendContextMenuItemsForDOMNode(contextMenu,node,options);});};function createSVGElement(tagName)
{return document.createElementNS("http://www.w3.org/2000/svg",tagName);}
WI.cssPath=function(node,options={})
{if(node.nodeType()!==Node.ELEMENT_NODE)
return"";let suffix="";if(node.isPseudoElement()){suffix="::"+node.pseudoType();node=node.parentNode;}
let components=[];while(node){let component=WI.cssPathComponent(node,options);if(!component)
break;components.push(component);if(component.done)
break;node=node.parentNode;}
components.reverse();return components.map((x)=>x.value).join(" > ")+suffix;};WI.cssPathComponent=function(node,options={})
{if(node.nodeType()!==Node.ELEMENT_NODE)
return null;let nodeName=node.nodeNameInCorrectCase();if(!node.parentNode||node.parentNode.nodeType()===Node.DOCUMENT_NODE)
return{value:nodeName,done:true};if(options.full){function getUniqueAttributes(domNode){let uniqueAttributes=new Map;for(let attribute of domNode.attributes()){let values=[attribute.value];if(attribute.name==="id"||attribute.name==="class")
values=attribute.value.split(/\s+/);uniqueAttributes.set(attribute.name,new Set(values));}
return uniqueAttributes;}
let nodeIndex=0;let needsNthChild=false;let uniqueAttributes=getUniqueAttributes(node);node.parentNode.children.forEach((child,i)=>{if(child.nodeType()!==Node.ELEMENT_NODE)
return;if(child===node){nodeIndex=i;return;}
if(needsNthChild||child.nodeNameInCorrectCase()!==nodeName)
return;let childUniqueAttributes=getUniqueAttributes(child);let subsetCount=0;for(let[name,values]of uniqueAttributes){let childValues=childUniqueAttributes.get(name);if(childValues&&values.size<=childValues.size&&values.isSubsetOf(childValues))
++subsetCount;}
if(subsetCount===uniqueAttributes.size)
needsNthChild=true;});function selectorForAttribute(values,prefix="",shouldCSSEscape=false){if(!values||!values.size)
return"";values=Array.from(values);values=values.filter((value)=>value&&value.length);if(!values.length)
return"";values=values.map((value)=>shouldCSSEscape?CSS.escape(value):value.escapeCharacters("\""));return prefix+values.join(prefix);}
let selector=nodeName;selector+=selectorForAttribute(uniqueAttributes.get("id"),"#",true);selector+=selectorForAttribute(uniqueAttributes.get("class"),".",true);for(let[attribute,values]of uniqueAttributes){if(attribute!=="id"&&attribute!=="class")
selector+=`[${attribute}="${selectorForAttribute(values)}"]`;}
if(needsNthChild)
selector+=`:nth-child(${nodeIndex + 1})`;return{value:selector,done:false};}
let lowerNodeName=node.nodeName().toLowerCase();if(lowerNodeName==="body"||lowerNodeName==="head"||lowerNodeName==="html")
return{value:nodeName,done:true};let id=node.getAttribute("id");if(id)
return{value:node.escapedIdSelector,done:true};function classNames(node){let classAttribute=node.getAttribute("class");return classAttribute?classAttribute.trim().split(/\s+/):[];}
let nthChildIndex=-1;let hasUniqueTagName=true;let uniqueClasses=new Set(classNames(node));let siblings=node.parentNode.children;let elementIndex=0;for(let sibling of siblings){if(sibling.nodeType()!==Node.ELEMENT_NODE)
continue;elementIndex++;if(sibling===node){nthChildIndex=elementIndex;continue;}
if(sibling.nodeNameInCorrectCase()===nodeName)
hasUniqueTagName=false;if(uniqueClasses.size){let siblingClassNames=classNames(sibling);for(let className of siblingClassNames)
uniqueClasses.delete(className);}}
let selector=nodeName;if(lowerNodeName==="input"&&node.getAttribute("type")&&!uniqueClasses.size)
selector+=`[type="${node.getAttribute("type")}"]`;if(!hasUniqueTagName){if(uniqueClasses.size)
selector+=node.escapedClassSelector;else
selector+=`:nth-child(${nthChildIndex})`;}
return{value:selector,done:false};};WI.xpath=function(node)
{if(node.nodeType()===Node.DOCUMENT_NODE)
return"/";let components=[];while(node){let component=WI.xpathComponent(node);if(!component)
break;components.push(component);if(component.done)
break;node=node.parentNode;}
components.reverse();let prefix=components.length&&components[0].done?"":"/";return prefix+components.map((x)=>x.value).join("/");};WI.xpathComponent=function(node)
{let index=WI.xpathIndex(node);if(index===-1)
return null;let value;switch(node.nodeType()){case Node.DOCUMENT_NODE:return{value:"",done:true};case Node.ELEMENT_NODE:var id=node.getAttribute("id");if(id)
return{value:`//*[@id="${id}"]`,done:true};value=node.localName();break;case Node.ATTRIBUTE_NODE:value=`@${node.nodeName()}`;break;case Node.TEXT_NODE:case Node.CDATA_SECTION_NODE:value="text()";break;case Node.COMMENT_NODE:value="comment()";break;case Node.PROCESSING_INSTRUCTION_NODE:value="processing-instruction()";break;default:value="";break;}
if(index>0)
value+=`[${index}]`;return{value,done:false};};WI.xpathIndex=function(node)
{if(!node.parentNode)
return 0;let siblings=node.parentNode.children;if(siblings.length<=1)
return 0;function isSimiliarNode(a,b){if(a===b)
return true;let aType=a.nodeType();let bType=b.nodeType();if(aType===Node.ELEMENT_NODE&&bType===Node.ELEMENT_NODE)
return a.localName()===b.localName();if(aType===Node.CDATA_SECTION_NODE)
return aType===Node.TEXT_NODE;if(bType===Node.CDATA_SECTION_NODE)
return bType===Node.TEXT_NODE;return aType===bType;}
let unique=true;let xPathIndex=-1;let xPathIndexCounter=1;for(let sibling of siblings){if(!isSimiliarNode(node,sibling))
continue;if(node===sibling){xPathIndex=xPathIndexCounter;if(!unique)
return xPathIndex;}else{unique=false;if(xPathIndex!==-1)
return xPathIndex;}
xPathIndexCounter++;}
if(unique)
return 0;return xPathIndex;};WI.FileUtilities=class FileUtilities{static screenshotString()
{let date=new Date;let values=[date.getFullYear(),Number.zeroPad(date.getMonth()+1,2),Number.zeroPad(date.getDate(),2),Number.zeroPad(date.getHours(),2),Number.zeroPad(date.getMinutes(),2),Number.zeroPad(date.getSeconds(),2),];return WI.UIString("Screen Shot %s-%s-%s at %s.%s.%s").format(...values);}
static sanitizeFilename(filename)
{return filename.replace(/:+/g,"-");}
static inspectorURLForFilename(filename)
{return"web-inspector:///"+encodeURIComponent(FileUtilities.sanitizeFilename(filename));}
static canSave(saveMode)
{return InspectorFrontendHost.canSave(saveMode);}
static async save(saveMode,fileVariants,forceSaveAs)
{if(!fileVariants){InspectorFrontendHost.beep();return;}
let isFileVariantsMode=saveMode===WI.FileUtilities.SaveMode.FileVariants;if(isFileVariantsMode)
forceSaveAs=true;if(typeof fileVariants.customSaveHandler==="function"){fileVariants.customSaveHandler(forceSaveAs);return;}
if(!isFileVariantsMode&&!Array.isArray(fileVariants))
fileVariants=[fileVariants];if(!Array.isArray(fileVariants)){InspectorFrontendHost.beep();return;}
let promises=fileVariants.map((fileVariant)=>{let content=fileVariant.content;if(!content)
return null;let displayType=fileVariant.displayType||"";if(!fileVariant.displayType&&isFileVariantsMode)
return null;let suggestedName=fileVariant.suggestedName;if(!suggestedName){let url=fileVariant.url||"";suggestedName=parseURL(url).lastPathComponent;if(!suggestedName){suggestedName=WI.UIString("Untitled");let dataURLTypeMatch=/^data:([^;]+)/.exec(url);if(dataURLTypeMatch){let fileExtension=WI.fileExtensionForMIMEType(dataURLTypeMatch[1]);if(fileExtension)
suggestedName+="."+fileExtension;}}}
let url=WI.FileUtilities.inspectorURLForFilename(suggestedName);if(typeof content==="string"){return Promise.resolve({displayType,url,content,base64Encoded:!!fileVariant.base64Encoded,});}
let wrappedPromise=new WI.WrappedPromise;let fileReader=new FileReader;fileReader.addEventListener("loadend",()=>{wrappedPromise.resolve({displayType,url,content:parseDataURL(fileReader.result).data,base64Encoded:true,});});fileReader.readAsDataURL(content);return wrappedPromise.promise;});if(promises.includes(null)){InspectorFrontendHost.beep();return;}
let saveDatas=await Promise.all(promises);InspectorFrontendHost.save(saveDatas,!!forceSaveAs);}
static import(callback,{multiple}={})
{let inputElement=document.createElement("input");inputElement.type="file";inputElement.value=null;inputElement.multiple=!!multiple;inputElement.addEventListener("change",(event)=>{callback(inputElement.files);});inputElement.click();FileUtilities.importInputElement=inputElement;}
static importText(callback,options={})
{FileUtilities.import((files)=>{FileUtilities.readText(files,callback);},options);}
static importJSON(callback,options={})
{FileUtilities.import((files)=>{FileUtilities.readJSON(files,callback);},options);}
static importData(callback,options={})
{FileUtilities.import((files)=>{FileUtilities.readData(files,callback);},options);}
static async readText(fileOrList,callback)
{await FileUtilities._read(fileOrList,async(file,result)=>{await new Promise((resolve,reject)=>{let reader=new FileReader;reader.addEventListener("loadend",(event)=>{result.text=reader.result;resolve(event);});reader.addEventListener("error",reject);reader.readAsText(file);});},callback);}
static async readJSON(fileOrList,callback)
{await WI.FileUtilities.readText(fileOrList,async(result)=>{if(result.text&&!result.error){try{result.json=JSON.parse(result.text);}catch(e){result.error=e;}}
await callback(result);});}
static async readData(fileOrList,callback)
{await FileUtilities._read(fileOrList,async(file,result)=>{await new Promise((resolve,reject)=>{let reader=new FileReader;reader.addEventListener("loadend",(event)=>{let{mimeType,base64,data}=parseDataURL(reader.result);if(!mimeType||mimeType==="text/plain"){let extension=WI.fileExtensionForFilename(result.filename);if(extension)
mimeType=WI.mimeTypeForFileExtension(extension);}
result.mimeType=mimeType;result.base64Encoded=base64;result.content=data;resolve(event);});reader.addEventListener("error",reject);reader.readAsDataURL(file);});},callback);}
static async _read(fileOrList,operation,callback)
{let files=[];if(fileOrList instanceof File)
files.push(fileOrList);else if(fileOrList instanceof FileList)
files=Array.from(fileOrList);for(let file of files){let result={filename:file.name,};try{await operation(file,result);}catch(e){result.error=e;}
await callback(result);}}};WI.FileUtilities.SaveMode={SingleFile:"single-file",FileVariants:"file-variants",};WI.HTTPUtilities=class HTTPUtilities{static statusTextForStatusCode(code)
{switch(code){case 0:return"OK";case 100:return"Continue";case 101:return"Switching Protocols";case 200:return"OK";case 201:return"Created";case 202:return"Accepted";case 203:return"Non-Authoritative Information";case 204:return"No Content";case 205:return"Reset Content";case 206:return"Partial Content";case 207:return"Multi-Status";case 300:return"Multiple Choices";case 301:return"Moved Permanently";case 302:return"Found";case 303:return"See Other";case 304:return"Not Modified";case 305:return"Use Proxy";case 307:return"Temporary Redirect";case 308:return"Permanent Redirect";case 400:return"Bad Request";case 401:return"Unauthorized";case 402:return"Payment Required";case 403:return"Forbidden";case 404:return"Not Found";case 405:return"Method Not Allowed";case 406:return"Not Acceptable";case 407:return"Proxy Authentication Required";case 408:return"Request Time-out";case 409:return"Conflict";case 410:return"Gone";case 411:return"Length Required";case 412:return"Precondition Failed";case 413:return"Request Entity Too Large";case 414:return"Request-URI Too Large";case 415:return"Unsupported Media Type";case 416:return"Requested range not satisfiable";case 417:return"Expectation Failed";case 500:return"Internal Server Error";case 501:return"Not Implemented";case 502:return"Bad Gateway";case 503:return"Service Unavailable";case 504:return"Gateway Time-out";case 505:return"HTTP Version not supported";}
if(code<200)
return"Continue";if(code<300)
return"OK";if(code<400)
return"Multiple Choices";if(code<500)
return"Bad Request";return"Internal Server Error";}};WI.HTTPUtilities.RequestMethod={CONNECT:"CONNECT",DELETE:"DELETE",GET:"GET",HEAD:"HEAD",OPTIONS:"OPTIONS",PATCH:"PATCH",POST:"POST",PUT:"PUT",TRACE:"TRACE",};WI.HTTPUtilities.RequestMethodsWithBody=new Set([WI.HTTPUtilities.RequestMethod.DELETE,WI.HTTPUtilities.RequestMethod.PATCH,WI.HTTPUtilities.RequestMethod.POST,WI.HTTPUtilities.RequestMethod.PUT,]);WI.ImageUtilities=class ImageUtilities{static useSVGSymbol(url,className,title)
{const svgNamespace="http://www.w3.org/2000/svg";const xlinkNamespace="http://www.w3.org/1999/xlink";let svgElement=document.createElementNS(svgNamespace,"svg");svgElement.style.width="100%";svgElement.style.height="100%";if(!url.includes("#"))
url+="#root";let useElement=document.createElementNS(svgNamespace,"use");useElement.setAttributeNS(xlinkNamespace,"xlink:href",url);svgElement.appendChild(useElement);let wrapper=document.createElement("div");wrapper.appendChild(svgElement);if(className)
wrapper.className=className;if(title)
wrapper.title=title;return wrapper;}
static promisifyLoad(src)
{return new Promise((resolve,reject)=>{let image=new Image;let resolveWithImage=()=>{resolve(image);};image.addEventListener("load",resolveWithImage);image.addEventListener("error",resolveWithImage);image.src=src;});}
static scratchCanvasContext2D(callback)
{if(!WI.ImageUtilities._scratchContext2D)
WI.ImageUtilities._scratchContext2D=document.createElement("canvas").getContext("2d");let context=WI.ImageUtilities._scratchContext2D;context.clearRect(0,0,context.canvas.width,context.canvas.height);context.save();callback(context);context.restore();}
static imageFromImageBitmap(data)
{let image=null;WI.ImageUtilities.scratchCanvasContext2D((context)=>{context.canvas.width=data.width;context.canvas.height=data.height;context.drawImage(data,0,0);image=new Image;image.src=context.canvas.toDataURL();});return image;}
static imageFromImageData(data)
{let image=null;WI.ImageUtilities.scratchCanvasContext2D((context)=>{context.canvas.width=data.width;context.canvas.height=data.height;context.putImageData(data,0,0);image=new Image;image.src=context.canvas.toDataURL();});return image;}
static imageFromCanvasGradient(gradient,width,height)
{let image=null;WI.ImageUtilities.scratchCanvasContext2D((context)=>{context.canvas.width=width;context.canvas.height=height;context.fillStyle=gradient;context.fillRect(0,0,width,height);image=new Image;image.src=context.canvas.toDataURL();});return image;}};WI.ImageUtilities._scratchContext2D=null;(function(){if(WI.dontLocalizeUserInterface)
return;let localizedStringsURL=InspectorFrontendHost.localizedStringsURL;if(localizedStringsURL)
document.write("<script src=\""+localizedStringsURL+"\"></script>");})();WI.unlocalizedString=function(string)
{return string;};WI.UIString=function(string,key,comment)
{"use strict";if(WI.dontLocalizeUserInterface)
return string;if(arguments.length===2){comment=key;key=undefined;}
key=key||string;if(window.localizedStrings&&key in window.localizedStrings)
return window.localizedStrings[key];if(!window.localizedStrings)
console.error(`Attempted to load localized string "${key}" before localizedStrings was initialized.`,comment);if(!this._missingLocalizedStrings)
this._missingLocalizedStrings={};if(!(key in this._missingLocalizedStrings)){console.error(`Localized string "${key}" was not found.`,comment);this._missingLocalizedStrings[key]=true;}
return"LOCALIZED STRING NOT FOUND";};WI.repeatedUIString={};WI.repeatedUIString.timelineRecordLayout=function(){return WI.UIString("Layout","Layout @ Timeline record","Layout phase timeline records");};WI.repeatedUIString.timelineRecordPaint=function(){return WI.UIString("Paint","Paint @ Timeline record","Paint (render) phase timeline records");};WI.repeatedUIString.timelineRecordComposite=function(){return WI.UIString("Composite","Composite @ Timeline record","Composite phase timeline records, where graphic layers are combined");};WI.repeatedUIString.debuggerStatements=function(){return WI.UIString("Debugger Statements","Debugger Statements @ JavaScript Breakpoint","Break (pause) on debugger statements");};WI.repeatedUIString.allExceptions=function(){return WI.UIString("All Exceptions","All Exceptions @ JavaScript Breakpoint","Break (pause) on all exceptions");};WI.repeatedUIString.uncaughtExceptions=function(){return WI.UIString("Uncaught Exceptions","Uncaught Exceptions @ JavaScript Breakpoint","Break (pause) on uncaught (unhandled) exceptions");};WI.repeatedUIString.assertionFailures=function(){return WI.UIString("Assertion Failures","Assertion Failures @ JavaScript Breakpoint","Break (pause) when console.assert() fails");};WI.repeatedUIString.allMicrotasks=function(){return WI.UIString("All Microtasks","All Microtasks @ JavaScript Breakpoint","Break (pause) on all microtasks");};WI.repeatedUIString.allAnimationFrames=function(){return WI.UIString("All Animation Frames","All Animation Frames @ Event Breakpoint","Break (pause) on All animation frames");};WI.repeatedUIString.allIntervals=function(){return WI.UIString("All Intervals","All Intervals @ Event Breakpoint","Break (pause) on all intervals");};WI.repeatedUIString.allEvents=function(){return WI.UIString("All Events","All Events @ Event Breakpoint","Break (pause) on all events");};WI.repeatedUIString.allTimeouts=function(){return WI.UIString("All Timeouts","All Timeouts @ Event Breakpoint","Break (pause) on all timeouts");};WI.repeatedUIString.allRequests=function(){return WI.UIString("All Requests","A submenu item of 'Break on' that breaks (pauses) before all network requests");};WI.repeatedUIString.fetch=function(){return WI.UIString("Fetch","Resource loaded via 'fetch' method");};WI.repeatedUIString.revealInDOMTree=function(){return WI.UIString("Reveal in DOM Tree","Open Elements tab and select this node in DOM tree");};WI.repeatedUIString.showTransparencyGridTooltip=function(){return WI.UIString("Show transparency grid","Show transparency grid (tooltip)","Tooltip for showing the checkered transparency grid under images and canvases")};WI.fileExtensionForFilename=function(filename)
{if(!filename)
return null;let index=filename.lastIndexOf(".");if(index===-1)
return null;if(index===filename.length-1)
return null;return filename.substr(index+1);};WI.fileExtensionForURL=function(url)
{let lastPathComponent=parseURL(url).lastPathComponent;return WI.fileExtensionForFilename(lastPathComponent);};WI.mimeTypeForFileExtension=function(extension)
{const extensionToMIMEType={"html":"text/html","xhtml":"application/xhtml+xml","xml":"text/xml","js":"text/javascript","mjs":"text/javascript","json":"application/json","clj":"text/x-clojure","coffee":"text/x-coffeescript","ls":"text/x-livescript","ts":"text/typescript","ps":"application/postscript","jsx":"text/jsx","css":"text/css","less":"text/x-less","sass":"text/x-sass","scss":"text/x-scss","avif":"image/avif","bmp":"image/bmp","gif":"image/gif","ico":"image/x-icon","jp2":"image/jp2","jpeg":"image/jpeg","jpg":"image/jpeg","jxl":"image/jxl","pdf":"application/pdf","png":"image/png","tif":"image/tiff","tiff":"image/tiff","webp":"image/webp","xbm":"image/x-xbitmap","ogx":"application/ogg","ogg":"audio/ogg","oga":"audio/ogg","ogv":"video/ogg","anx":"application/annodex","axa":"audio/annodex","axv":"video/annodex","spx":"audio/speex","webm":"video/webm","m1a":"audio/mpeg","m2a":"audio/mpeg","mpg":"video/mpeg","m15":"video/mpeg","m1s":"video/mpeg","m1v":"video/mpeg","m75":"video/mpeg","mpa":"video/mpeg","mpeg":"video/mpeg","mpm":"video/mpeg","mpv":"video/mpeg","m3u8":"application/x-mpegurl","m3url":"audio/x-mpegurl","m3u":"audio/x-mpegurl","m4v":"video/x-m4v","m4a":"audio/x-m4a","m4b":"audio/x-m4b","m4p":"audio/x-m4p","mp3":"audio/mp3","mp2":"video/x-mpeg2","vob":"video/mpeg2","mod":"video/mpeg2","m2ts":"video/m2ts","m2t":"video/x-m2ts","3gpp":"audio/3gpp","3g2":"audio/3gpp2","amc":"application/x-mpeg","aac":"audio/aac","adts":"audio/aac","m4r":"audio/x-aac","caf":"audio/x-caf","gsm":"audio/x-gsm","wav":"audio/x-wav","vtt":"text/vtt","woff":"font/woff","woff2":"font/woff2","otf":"font/otf","ttf":"font/ttf","sfnt":"font/sfnt","svg":"image/svg+xml","txt":"text/plain","xsl":"text/xsl"};return extensionToMIMEType[extension]||null;};WI.fileExtensionForMIMEType=function(mimeType)
{if(!mimeType)
return null;const mimeTypeToExtension={"text/html":"html","application/xhtml+xml":"xhtml","application/xml":"xml","text/xml":"xml","application/ecmascript":"js","application/javascript":"js","application/x-ecmascript":"js","application/x-javascript":"js","text/ecmascript":"js","text/javascript":"js","text/javascript1.0":"js","text/javascript1.1":"js","text/javascript1.2":"js","text/javascript1.3":"js","text/javascript1.4":"js","text/javascript1.5":"js","text/jscript":"js","text/x-ecmascript":"js","text/x-javascript":"js","application/json":"json","text/x-clojure":"clj","text/x-coffeescript":"coffee","text/livescript":"ls","text/x-livescript":"ls","text/typescript":"ts","application/postscript":"ps","text/jsx":"jsx","text/css":"css","text/x-less":"less","text/x-sass":"sass","text/x-scss":"scss","image/avif":"avif","image/bmp":"bmp","image/gif":"gif","image/vnd.microsoft.icon":"ico","image/x-icon":"ico","image/jp2":"jp2","image/jpeg":"jpg","image/jxl":"jxl","application/pdf":"pdf","text/pdf":"pdf","image/png":"png","image/tiff":"tiff","image/webp":"webp","image/x-xbitmap":"xbm","application/ogg":"ogx","audio/ogg":"ogg","application/annodex":"anx","audio/annodex":"axa","video/annodex":"axv","audio/speex":"spx","video/webm":"webm","audio/webm":"webm","video/mpeg":"mpeg","application/vnd.apple.mpegurl":"m3u8","application/mpegurl":"m3u8","application/x-mpegurl":"m3u8","audio/mpegurl":"m3u","audio/x-mpegurl":"m3u","video/x-m4v":"m4v","audio/x-m4a":"m4a","audio/x-m4b":"m4b","audio/x-m4p":"m4p","audio/mp4":"m4a","audio/mp3":"mp3","audio/x-mp3":"mp3","audio/x-mpeg":"mp3","video/x-mpeg2":"mp2","video/mpeg2":"vob","video/m2ts":"m2ts","video/x-m2ts":"m2t","audio/3gpp":"3gpp","audio/3gpp2":"3g2","application/x-mpeg":"amc","audio/aac":"aac","audio/x-aac":"m4r","audio/x-caf":"caf","audio/x-gsm":"gsm","audio/x-wav":"wav","audio/vnd.wave":"wav","text/vtt":"vtt","font/woff":"woff","font/woff2":"woff2","font/otf":"otf","font/ttf":"ttf","font/sfnt":"sfnt","image/svg+xml":"svg","text/plain":"txt","text/xsl":"xsl",};let extension=mimeTypeToExtension[mimeType];if(extension)
return extension;if(mimeType.endsWith("+json"))
return"json";if(mimeType.endsWith("+xml"))
return"xml";return null;};WI.shouldTreatMIMETypeAsText=function(mimeType)
{if(!mimeType)
return false;if(mimeType.startsWith("text/"))
return true;if(mimeType.endsWith("+json")||mimeType.endsWith("+xml"))
return true;let extension=WI.fileExtensionForMIMEType(mimeType);if(extension==="xml")
return true;if(extension==="js"||extension==="json")
return true;if(extension==="m3u8"||extension==="m3u")
return true;if(mimeType.startsWith("application/"))
return mimeType.endsWith("script")||mimeType.endsWith("json")||mimeType.endsWith("xml");return false;};WI.ObjectStore=class ObjectStore
{constructor(name,options={})
{this._name=name;this._options=options;}
static supported()
{return(!window.InspectorTest||WI.ObjectStore.__testObjectStore)&&window.indexedDB;}
static async reset()
{if(WI.ObjectStore._database)
WI.ObjectStore._database.close();await window.indexedDB.deleteDatabase(ObjectStore._databaseName);}
static get _databaseName()
{let inspectionLevel=InspectorFrontendHost?InspectorFrontendHost.inspectionLevel:1;let levelString=(inspectionLevel>1)?"-"+inspectionLevel:"";return"com.apple.WebInspector"+levelString;}
static _open(callback)
{if(WI.ObjectStore._database){callback(WI.ObjectStore._database);return;}
if(Array.isArray(WI.ObjectStore._databaseCallbacks)){WI.ObjectStore._databaseCallbacks.push(callback);return;}
WI.ObjectStore._databaseCallbacks=[callback];const version=6;let databaseRequest=window.indexedDB.open(WI.ObjectStore._databaseName,version);databaseRequest.addEventListener("upgradeneeded",(event)=>{let database=databaseRequest.result;let objectStores=Object.values(WI.objectStores);if(WI.ObjectStore.__testObjectStore)
objectStores.push(WI.ObjectStore.__testObjectStore);let existingNames=new Set;for(let objectStore of objectStores){if(!database.objectStoreNames.contains(objectStore._name))
database.createObjectStore(objectStore._name,objectStore._options);existingNames.add(objectStore._name);}
for(let objectStoreName of database.objectStoreNames){if(!existingNames.has(objectStoreName))
database.deleteObjectStore(objectStoreName);}});databaseRequest.addEventListener("success",(successEvent)=>{WI.ObjectStore._database=databaseRequest.result;WI.ObjectStore._database.addEventListener("close",(closeEvent)=>{WI.ObjectStore._database=null;});for(let databaseCallback of WI.ObjectStore._databaseCallbacks)
databaseCallback(WI.ObjectStore._database);WI.ObjectStore._databaseCallbacks=null;});}
get keyPath()
{return(this._options||{}).keyPath;}
associateObject(object,key,value)
{if(typeof value==="object")
value=this._resolveKeyPath(value,key).value;let resolved=this._resolveKeyPath(object,key);resolved.object[resolved.key]=value;}
async get(...args)
{if(!WI.ObjectStore.supported())
return undefined;return this._operation("readonly",(objectStore)=>objectStore.get(...args));}
async getAll(...args)
{if(!WI.ObjectStore.supported())
return[];return this._operation("readonly",(objectStore)=>objectStore.getAll(...args));}
async getAllKeys(...args)
{if(!WI.ObjectStore.supported())
return[];return this._operation("readonly",(objectStore)=>objectStore.getAllKeys(...args));}
async put(...args)
{if(!WI.ObjectStore.supported())
return undefined;return this._operation("readwrite",(objectStore)=>objectStore.put(...args));}
async putObject(object,...args)
{if(!WI.ObjectStore.supported())
return undefined;let result=await this.put(object.toJSON(WI.ObjectStore.toJSONSymbol),...args);this.associateObject(object,args[0],result);return result;}
async delete(...args)
{if(!WI.ObjectStore.supported())
return undefined;return this._operation("readwrite",(objectStore)=>objectStore.delete(...args));}
async deleteObject(object,...args)
{if(!WI.ObjectStore.supported())
return undefined;return this.delete(this._resolveKeyPath(object).value,...args);}
async clear(...args)
{if(!WI.ObjectStore.supported())
return undefined;return this._operation("readwrite",(objectStore)=>objectStore.clear(...args));}
_resolveKeyPath(object,keyPath)
{keyPath=keyPath||this._options.keyPath||"";let parts=keyPath.split(".");let key=parts.splice(-1,1);while(parts.length){if(!object.hasOwnProperty(parts[0]))
break;object=object[parts.shift()];}
if(parts.length)
key=parts.join(".")+"."+key;return{object,key,value:object[key],};}
async _operation(mode,func)
{return new Promise((resolve,reject)=>{WI.ObjectStore._open((database)=>{let transaction=database.transaction([this._name],mode);let objectStore=transaction.objectStore(this._name);let request=null;try{request=func(objectStore);}catch(e){reject(e);return;}
function listener(event){transaction.removeEventListener("complete",listener);transaction.removeEventListener("error",listener);request.removeEventListener("success",listener);request.removeEventListener("error",listener);if(request.error){reject(request.error);return;}
resolve(request.result);}
transaction.addEventListener("complete",listener,{once:true});transaction.addEventListener("error",listener,{once:true});request.addEventListener("success",listener,{once:true});request.addEventListener("error",listener,{once:true});});});}};WI.ObjectStore._database=null;WI.ObjectStore._databaseCallbacks=null;WI.ObjectStore.toJSONSymbol=Symbol("ObjectStore-toJSON");WI.objectStores={audits:new WI.ObjectStore("audit-manager-tests",{keyPath:"__id",autoIncrement:true}),breakpoints:new WI.ObjectStore("debugger-breakpoints",{keyPath:"__id"}),domBreakpoints:new WI.ObjectStore("dom-debugger-dom-breakpoints",{keyPath:"__id"}),eventBreakpoints:new WI.ObjectStore("dom-debugger-event-breakpoints",{keyPath:"__id"}),urlBreakpoints:new WI.ObjectStore("dom-debugger-url-breakpoints",{keyPath:"__id"}),localResourceOverrides:new WI.ObjectStore("local-resource-overrides",{keyPath:"__id"}),general:new WI.ObjectStore("general"),cssPropertyNameCounts:new WI.ObjectStore("css-property-name-counts"),};function removeURLFragment(url)
{var hashIndex=url.indexOf("#");if(hashIndex>=0)
return url.substring(0,hashIndex);return url;}
function relativePath(path,basePath)
{var pathComponents=path.split("/");var baseComponents=basePath.replace(/\/$/,"").split("/");var finalComponents=[];var index=1;for(;index<pathComponents.length&&index<baseComponents.length;++index){if(pathComponents[index]!==baseComponents[index])
break;}
for(var i=index;i<baseComponents.length;++i)
finalComponents.push("..");for(var i=index;i<pathComponents.length;++i)
finalComponents.push(pathComponents[i]);return finalComponents.join("/");}
function parseSecurityOrigin(securityOrigin)
{securityOrigin=securityOrigin?securityOrigin.trim():"";let match=securityOrigin.match(/^(?<scheme>[^:]+):\/\/(?<host>[^\/:]*)(?::(?<port>[\d]+))?$/i);if(!match)
return{scheme:null,host:null,port:null};let scheme=match.groups.scheme.toLowerCase();let host=match.groups.host.toLowerCase();let port=Number(match.groups.port)||null;return{scheme,host,port};}
function parseDataURL(url)
{if(!url.startsWith("data:"))
return null;let match=url.match(/^data:(?<mime>[^;,]*)?(?:;charset=(?<charset>[^;,]*?))?(?<base64>;base64)?,(?<data>.*)$/);if(!match)
return null;let scheme="data";let mimeType=match.groups.mime||"text/plain";let charset=match.groups.charset||"US-ASCII";let base64=!!match.groups.base64;let data=decodeURIComponent(match.groups.data);return{scheme,mimeType,charset,base64,data};}
function parseURL(url)
{let result={scheme:null,userinfo:null,host:null,port:null,origin:null,path:null,queryString:null,fragment:null,lastPathComponent:null,};if(url&&url.startsWith("data:")){result.scheme="data";return result;}
if(isWebKitInternalScript(url))
return result;let parsed=null;try{parsed=new URL(url);}catch{return result;}
result.scheme=parsed.protocol.slice(0,-1);if(parsed.username)
result.userinfo=parsed.username;if(parsed.password)
result.userinfo=(result.userinfo||"")+":"+parsed.password;if(parsed.hostname)
result.host=parsed.hostname;if(parsed.port)
result.port=Number(parsed.port);if(parsed.origin&&parsed.origin!=="null")
result.origin=parsed.origin;else if(result.scheme&&result.host){result.origin=result.scheme+"://"+result.host;if(result.port)
result.origin+=":"+result.port;}
if(parsed.pathname)
result.path=parsed.pathname;if(parsed.search)
result.queryString=parsed.search.substring(1);if(parsed.hash)
result.fragment=parsed.hash.substring(1);if(result.path&&result.path!=="/"){let endOffset=result.path.endsWith("/")?1:0;let lastSlashIndex=result.path.lastIndexOf("/",result.path.length-1-endOffset);if(lastSlashIndex!==-1)
result.lastPathComponent=result.path.substring(lastSlashIndex+1,result.path.length-endOffset);}
return result;}
function absoluteURL(partialURL,baseURL)
{partialURL=partialURL?partialURL.trim():"";if(partialURL.startsWith("data:")||partialURL.startsWith("javascript:")||partialURL.startsWith("mailto:"))
return partialURL;if(parseURL(partialURL).scheme)
return partialURL;if(!partialURL)
return baseURL||null;var baseURLComponents=parseURL(baseURL);if(!baseURLComponents.scheme)
return null;if(partialURL[0]==="/"&&partialURL[1]==="/")
return baseURLComponents.scheme+":"+partialURL;if(!baseURLComponents.path)
baseURLComponents.path="/";var baseURLPrefix=baseURLComponents.scheme+"://"+baseURLComponents.host+(baseURLComponents.port?(":"+baseURLComponents.port):"");if(partialURL[0]==="?")
return baseURLPrefix+baseURLComponents.path+partialURL;if(partialURL[0]==="/")
return baseURLPrefix+resolveDotsInPath(partialURL);if(partialURL[0]==="#"){let queryStringComponent=baseURLComponents.queryString?"?"+baseURLComponents.queryString:"";return baseURLPrefix+baseURLComponents.path+queryStringComponent+partialURL;}
var basePath=baseURLComponents.path.substring(0,baseURLComponents.path.lastIndexOf("/"))+"/";return baseURLPrefix+resolveDotsInPath(basePath+partialURL);}
function parseQueryString(queryString,arrayResult)
{if(!queryString)
return arrayResult?[]:{};function decode(string)
{try{return decodeURIComponent(string.replace(/\+/g," "));}catch{return string;}}
var parameters=arrayResult?[]:{};for(let parameterString of queryString.split("&")){let index=parameterString.indexOf("=");if(index===-1)
index=parameterString.length;let name=decode(parameterString.substring(0,index));let value=decode(parameterString.substring(index+1));if(arrayResult)
parameters.push({name,value});else
parameters[name]=value;}
return parameters;}
WI.displayNameForURL=function(url,urlComponents,options={})
{if(url.startsWith("data:"))
return WI.truncateURL(url);if(!urlComponents)
urlComponents=parseURL(url);var displayName;try{displayName=decodeURIComponent(urlComponents.lastPathComponent||"");}catch{displayName=urlComponents.lastPathComponent;}
if(options.allowDirectoryAsName&&(urlComponents.path==="/"||(displayName&&urlComponents.path.endsWith(displayName+"/"))))
displayName="/";return displayName||WI.displayNameForHost(urlComponents.host)||url;};WI.truncateURL=function(url,multiline=false,dataURIMaxSize=6)
{if(!url.startsWith("data:"))
return url;const dataIndex=url.indexOf(",")+1;let header=url.slice(0,dataIndex);if(multiline)
header+="\n";const data=url.slice(dataIndex);if(data.length<dataURIMaxSize)
return header+data;const firstChunk=data.slice(0,Math.ceil(dataURIMaxSize/2));const ellipsis="\u2026";const middleChunk=multiline?`\n${ellipsis}\n`:ellipsis;const lastChunk=data.slice(-Math.floor(dataURIMaxSize/2));return header+firstChunk+middleChunk+lastChunk;};WI.urlWithoutExtension=function(urlString)
{let url=null;try{url=new URL(urlString);}catch{}
if(!url)
return urlString;let firstDotInLastPathComponentIndex=url.pathname.indexOf(".",url.pathname.lastIndexOf("/"));if(firstDotInLastPathComponentIndex!==-1)
url.pathname=url.pathname.substring(0,firstDotInLastPathComponentIndex);url.search="";url.hash="";return url.toString();};WI.urlWithoutFragment=function(urlString)
{try{let url=new URL(urlString);if(url.hash){url.hash="";return url.toString();}
let result=url.toString();if(result.endsWith("#"))
return result.substring(0,result.length-1);return result;}catch{}
return urlString;};WI.displayNameForHost=function(host)
{let extensionName=WI.browserManager.extensionNameForId(host);if(extensionName)
return extensionName;return host;};WI.h2Authority=function(components)
{let{scheme,userinfo,host,port}=components;let result=host||"";if(userinfo&&(scheme!=="http"&&scheme!=="https"))
result=userinfo+"@"+result;if(port)
result+=":"+port;return result;};WI.h2Path=function(components)
{let{scheme,path,queryString}=components;let result=path||"";if(!path&&(scheme==="http"||scheme==="https"))
result="/";if(queryString)
result+="?"+queryString;return result;};var emDash="\u2014";var enDash="\u2013";var figureDash="\u2012";var ellipsis="\u2026";var zeroWidthSpace="\u200b";var multiplicationSign="\u00d7";function xor(a,b)
{if(a)
return b?false:a;return b||false;}
Object.defineProperty(Object,"shallowCopy",{value(object)
{var copy={};var keys=Object.keys(object);for(var i=0;i<keys.length;++i)
copy[keys[i]]=object[keys[i]];return copy;}});Object.defineProperty(Object,"shallowEqual",{value(a,b)
{if(!(a instanceof Object)||!(b instanceof Object))
return false;if(a===b)
return true;if(Array.shallowEqual(a,b))
return true;if(a.constructor!==b.constructor)
return false;let aKeys=Object.keys(a);let bKeys=Object.keys(b);if(aKeys.length!==bKeys.length)
return false;for(let aKey of aKeys){if(!(aKey in b))
return false;let aValue=a[aKey];let bValue=b[aKey];if(aValue!==bValue&&!Array.shallowEqual(aValue,bValue))
return false;}
return true;}});Object.defineProperty(Object,"filter",{value(object,callback)
{let filtered={};for(let key in object){if(callback(key,object[key]))
filtered[key]=object[key];}
return filtered;}});Object.defineProperty(Object.prototype,"valueForCaseInsensitiveKey",{value(key)
{if(this.hasOwnProperty(key))
return this[key];var lowerCaseKey=key.toLowerCase();for(var currentKey in this){if(currentKey.toLowerCase()===lowerCaseKey)
return this[currentKey];}
return undefined;}});Object.defineProperty(Map,"fromObject",{value(object)
{let map=new Map;for(let key in object)
map.set(key,object[key]);return map;}});Object.defineProperty(Map.prototype,"take",{value(key)
{let deletedValue=this.get(key);this.delete(key);return deletedValue;}});Object.defineProperty(Map.prototype,"getOrInitialize",{value(key,initialValue)
{let value=this.get(key);if(value)
return value;if(typeof initialValue==="function")
initialValue=initialValue();this.set(key,initialValue);return initialValue;}});Object.defineProperty(WeakMap.prototype,"getOrInitialize",{value(key,initialValue)
{let value=this.get(key);if(value)
return value;if(typeof initialValue==="function")
initialValue=initialValue();this.set(key,initialValue);return initialValue;}});Object.defineProperty(Set.prototype,"find",{value(predicate)
{for(let item of this){if(predicate(item,this))
return item;}
return undefined;},});Object.defineProperty(Set.prototype,"addAll",{value(iterable)
{for(let item of iterable)
this.add(item);},});Object.defineProperty(Set.prototype,"take",{value(key)
{if(this.has(key)){this.delete(key);return key;}
return undefined;}});Object.defineProperty(Set.prototype,"equals",{value(other)
{return this.size===other.size&&this.isSubsetOf(other);}});Object.defineProperty(Set.prototype,"difference",{value(other)
{if(other===this)
return new Set;let result=new Set;for(let item of this){if(!other.has(item))
result.add(item);}
return result;}});Object.defineProperty(Set.prototype,"firstValue",{get()
{return this.values().next().value;}});Object.defineProperty(Set.prototype,"lastValue",{get()
{return Array.from(this.values()).lastValue;}});Object.defineProperty(Set.prototype,"intersects",{value(other)
{if(!this.size||!other.size)
return false;for(let item of this){if(other.has(item))
return true;}
return false;}});Object.defineProperty(Set.prototype,"isSubsetOf",{value(other)
{for(let item of this){if(!other.has(item))
return false;}
return true;}});Object.defineProperty(Node.prototype,"traverseNextNode",{value(stayWithin)
{var node=this.firstChild;if(node)
return node;if(stayWithin&&this===stayWithin)
return null;node=this.nextSibling;if(node)
return node;node=this;while(node&&!node.nextSibling&&(!stayWithin||!node.parentNode||node.parentNode!==stayWithin))
node=node.parentNode;if(!node)
return null;return node.nextSibling;}});Object.defineProperty(Node.prototype,"traversePreviousNode",{value(stayWithin)
{if(stayWithin&&this===stayWithin)
return null;var node=this.previousSibling;while(node&&node.lastChild)
node=node.lastChild;if(node)
return node;return this.parentNode;}});Object.defineProperty(Node.prototype,"rangeOfWord",{value(offset,stopCharacters,stayWithinNode,direction)
{var startNode;var startOffset=0;var endNode;var endOffset=0;if(!stayWithinNode)
stayWithinNode=this;if(!direction||direction==="backward"||direction==="both"){var node=this;while(node){if(node===stayWithinNode){if(!startNode)
startNode=stayWithinNode;break;}
if(node.nodeType===Node.TEXT_NODE){let start=node===this?(offset-1):(node.nodeValue.length-1);for(var i=start;i>=0;--i){if(stopCharacters.indexOf(node.nodeValue[i])!==-1){startNode=node;startOffset=i+1;break;}}}
if(startNode)
break;node=node.traversePreviousNode(stayWithinNode);}
if(!startNode){startNode=stayWithinNode;startOffset=0;}}else{startNode=this;startOffset=offset;}
if(!direction||direction==="forward"||direction==="both"){node=this;while(node){if(node===stayWithinNode){if(!endNode)
endNode=stayWithinNode;break;}
if(node.nodeType===Node.TEXT_NODE){let start=node===this?offset:0;for(var i=start;i<node.nodeValue.length;++i){if(stopCharacters.indexOf(node.nodeValue[i])!==-1){endNode=node;endOffset=i;break;}}}
if(endNode)
break;node=node.traverseNextNode(stayWithinNode);}
if(!endNode){endNode=stayWithinNode;endOffset=stayWithinNode.nodeType===Node.TEXT_NODE?stayWithinNode.nodeValue.length:stayWithinNode.childNodes.length;}}else{endNode=this;endOffset=offset;}
var result=this.ownerDocument.createRange();result.setStart(startNode,startOffset);result.setEnd(endNode,endOffset);return result;}});Object.defineProperty(Element.prototype,"realOffsetWidth",{get()
{return this.getBoundingClientRect().width;}});Object.defineProperty(Element.prototype,"realOffsetHeight",{get()
{return this.getBoundingClientRect().height;}});Object.defineProperty(Element.prototype,"totalOffsetLeft",{get()
{return this.getBoundingClientRect().left;}});Object.defineProperty(Element.prototype,"totalOffsetRight",{get()
{return this.getBoundingClientRect().right;}});Object.defineProperty(Element.prototype,"totalOffsetTop",{get()
{return this.getBoundingClientRect().top;}});Object.defineProperty(Element.prototype,"totalOffsetBottom",{get()
{return this.getBoundingClientRect().bottom;}});Object.defineProperty(Element.prototype,"removeChildren",{value()
{if(this.firstChild)
this.textContent="";}});Object.defineProperty(Element.prototype,"isInsertionCaretInside",{value()
{var selection=window.getSelection();if(!selection.rangeCount||!selection.isCollapsed)
return false;var selectionRange=selection.getRangeAt(0);return selectionRange.startContainer===this||this.contains(selectionRange.startContainer);}});Object.defineProperty(Element.prototype,"createChild",{value(elementName,className)
{var element=this.ownerDocument.createElement(elementName);if(className)
element.className=className;this.appendChild(element);return element;}});Object.defineProperty(Element.prototype,"isScrolledToBottom",{value()
{return this.scrollTop+this.clientHeight===this.scrollHeight;}});Object.defineProperty(Element.prototype,"recalculateStyles",{value()
{this.ownerDocument.defaultView.getComputedStyle(this);}});Object.defineProperty(Element.prototype,"getComputedCSSPropertyNumberValue",{value(property){let result=undefined;result??=this.computedStyleMap?.().get(property)?.value;result??=window.getComputedStyle(this).getPropertyCSSValue(property)?.getFloatValue(CSSPrimitiveValue.CSS_PX);return result;},});Object.defineProperty(DocumentFragment.prototype,"createChild",{value:Element.prototype.createChild});(function(){const fontSymbol=Symbol("font");Object.defineProperty(HTMLInputElement.prototype,"autosize",{value(extra=0)
{extra+=6;if(this.type==="number")
extra+=13;extra+=2;WI.ImageUtilities.scratchCanvasContext2D((context)=>{this[fontSymbol]||=window.getComputedStyle(this).font;context.font=this[fontSymbol];let textMetrics=context.measureText(this.value||this.placeholder);this.style.setProperty("width",(textMetrics.width+extra)+"px");});},});})();Object.defineProperty(Event.prototype,"stop",{value()
{this.stopImmediatePropagation();this.preventDefault();}});Object.defineProperty(KeyboardEvent.prototype,"commandOrControlKey",{get()
{return WI.Platform.name==="mac"?this.metaKey:this.ctrlKey;}});Object.defineProperty(MouseEvent.prototype,"commandOrControlKey",{get()
{return WI.Platform.name==="mac"?this.metaKey:this.ctrlKey;}});Object.defineProperty(Array,"isTypedArray",{value(array)
{if(!array)
return false;let constructor=array.constructor;return constructor===Int8Array||constructor===Int16Array||constructor===Int32Array||constructor===Uint8Array||constructor===Uint8ClampedArray||constructor===Uint16Array||constructor===Uint32Array||constructor===Float32Array||constructor===Float64Array;}});Object.defineProperty(Array,"shallowEqual",{value(a,b)
{function isArrayLike(x){return Array.isArray(x)||Array.isTypedArray(x);}
if(!isArrayLike(a)||!isArrayLike(b))
return false;if(a===b)
return true;let length=a.length;if(length!==b.length)
return false;for(let i=0;i<length;++i){if(a[i]===b[i])
continue;if(!Object.shallowEqual(a[i],b[i]))
return false;}
return true;}});Object.defineProperty(Array,"diffArrays",{value(initialArray,currentArray,onEach,comparator)
{"use strict";function defaultComparator(initial,current){return initial===current;}
comparator=comparator||defaultComparator;function findShortestEdit(){let deletionCount=initialArray.length;let additionCount=currentArray.length;let editCount=deletionCount+additionCount;for(let i=0;i<initialArray.length;++i){if(i>editCount){break;}
for(let j=0;j<currentArray.length;++j){let newEditCount=i+j;if(newEditCount>editCount){break;}
if(comparator(initialArray[i],currentArray[j])){if(newEditCount<editCount){editCount=newEditCount;deletionCount=i;additionCount=j;}
break;}}}
return[deletionCount,additionCount];}
function commonPrefixLength(listA,listB){let shorterListLength=Math.min(listA.length,listB.length);let i=0;while(i<shorterListLength){if(!comparator(listA[i],listB[i]))
break;++i;}
return i;}
function fireOnEach(count,diffAction,array){for(let i=0;i<count;++i)
onEach(array[i],diffAction);}
while(initialArray.length||currentArray.length){let prefixLength=commonPrefixLength(initialArray,currentArray);if(prefixLength){fireOnEach(prefixLength,0,currentArray);initialArray=initialArray.slice(prefixLength);currentArray=currentArray.slice(prefixLength);}
if(!initialArray.length&&!currentArray.length)
break;let[deletionCount,additionCount]=findShortestEdit();fireOnEach(deletionCount,-1,initialArray);fireOnEach(additionCount,1,currentArray);initialArray=initialArray.slice(deletionCount);currentArray=currentArray.slice(additionCount);}}});Object.defineProperty(Array.prototype,"lastValue",{get()
{if(!this.length)
return undefined;return this[this.length-1];}});Object.defineProperty(Array.prototype,"adjacencies",{value:function*(){for(let i=1;i<this.length;++i)
yield[this[i-1],this[i]];}});Object.defineProperty(Array.prototype,"remove",{value(value)
{for(let i=0;i<this.length;++i){if(this[i]===value){this.splice(i,1);return true;}}
return false;}});Object.defineProperty(Array.prototype,"removeAll",{value(value)
{for(let i=this.length-1;i>=0;--i){if(this[i]===value)
this.splice(i,1);}}});Object.defineProperty(Array.prototype,"toggleIncludes",{value(value,force)
{let exists=this.includes(value);if(exists===!!force)
return;if(exists)
this.remove(value);else
this.push(value);}});Object.defineProperty(Array.prototype,"insertAtIndex",{value(value,index)
{this.splice(index,0,value);}});Object.defineProperty(Array.prototype,"pushAll",{value(iterable)
{for(let item of iterable)
this.push(item);},});Object.defineProperty(Array.prototype,"partition",{value(callback)
{let positive=[];let negative=[];for(let i=0;i<this.length;++i){let value=this[i];if(callback(value))
positive.push(value);else
negative.push(value);}
return[positive,negative];}});Object.defineProperty(String.prototype,"isLowerCase",{value()
{return /^[a-z]+$/.test(this);}});Object.defineProperty(String.prototype,"isUpperCase",{value()
{return /^[A-Z]+$/.test(this);}});Object.defineProperty(String.prototype,"isJSON",{value(predicate)
{try{let json=JSON.parse(this);return!predicate||predicate(json);}catch{}
return false;}});Object.defineProperty(String.prototype,"truncateStart",{value(maxLength)
{"use strict";if(this.length<=maxLength)
return this;return ellipsis+this.substr(this.length-maxLength+1);}});Object.defineProperty(String.prototype,"truncateMiddle",{value(maxLength)
{"use strict";if(this.length<=maxLength)
return this;var leftHalf=maxLength>>1;var rightHalf=maxLength-leftHalf-1;return this.substr(0,leftHalf)+ellipsis+this.substr(this.length-rightHalf,rightHalf);}});Object.defineProperty(String.prototype,"truncateEnd",{value(maxLength)
{"use strict";if(this.length<=maxLength)
return this;return this.substr(0,maxLength-1)+ellipsis;}});Object.defineProperty(String.prototype,"truncate",{value(maxLength)
{"use strict";if(this.length<=maxLength)
return this;let clipped=this.slice(0,maxLength);let indexOfLastWhitespace=clipped.search(/\s\S*$/);if(indexOfLastWhitespace>Math.floor(maxLength/2))
clipped=clipped.slice(0,indexOfLastWhitespace-1);return clipped+ellipsis;}});Object.defineProperty(String.prototype,"collapseWhitespace",{value()
{return this.replace(/[\s\xA0]+/g," ");}});Object.defineProperty(String.prototype,"removeWhitespace",{value()
{return this.replace(/[\s\xA0]+/g,"");}});Object.defineProperty(String.prototype,"escapeCharacters",{value(charactersToEscape)
{if(!charactersToEscape)
return this.valueOf();let charactersToEscapeSet=new Set(charactersToEscape);let foundCharacter=false;for(let c of this){if(!charactersToEscapeSet.has(c))
continue;foundCharacter=true;break;}
if(!foundCharacter)
return this.valueOf();let result="";for(let c of this){if(charactersToEscapeSet.has(c))
result+="\\";result+=c;}
return result.valueOf();}});Object.defineProperty(String.prototype,"escapeForRegExp",{value()
{return this.escapeCharacters("^[]{}()\\.$*+?|");}});Object.defineProperty(String.prototype,"capitalize",{value()
{return this.charAt(0).toUpperCase()+this.slice(1);}});Object.defineProperty(String.prototype,"extendedLocaleCompare",{value(other)
{return this.localeCompare(other,undefined,{numeric:true});}});Object.defineProperty(String,"tokenizeFormatString",{value(format)
{var tokens=[];var substitutionIndex=0;function addStringToken(str)
{tokens.push({type:"string",value:str});}
function addSpecifierToken(specifier,precision,substitutionIndex)
{tokens.push({type:"specifier",specifier,precision,substitutionIndex});}
var index=0;for(var precentIndex=format.indexOf("%",index);precentIndex!==-1;precentIndex=format.indexOf("%",index)){addStringToken(format.substring(index,precentIndex));index=precentIndex+1;if(format[index]==="%"){addStringToken("%");++index;continue;}
if(!isNaN(format[index])){var number=parseInt(format.substring(index),10);while(!isNaN(format[index]))
++index;if(number>0&&format[index]==="$"){substitutionIndex=(number-1);++index;}}
const defaultPrecision=6;let precision=defaultPrecision;if(format[index]==="."){++index;precision=parseInt(format.substring(index),10);if(isNaN(precision))
precision=defaultPrecision;while(!isNaN(format[index]))
++index;}
addSpecifierToken(format[index],precision,substitutionIndex);++substitutionIndex;++index;}
addStringToken(format.substring(index));return tokens;}});Object.defineProperty(String.prototype,"lineCount",{get()
{"use strict";let lineCount=1;let index=0;while(true){index=this.indexOf("\n",index);if(index===-1)
return lineCount;index+="\n".length;lineCount++;}}});Object.defineProperty(String.prototype,"lastLine",{get()
{"use strict";let index=this.lastIndexOf("\n");if(index===-1)
return this;return this.slice(index+"\n".length);}});Object.defineProperty(String.prototype,"hash",{get()
{const stringHashingStartValue=0x9e3779b9;var result=stringHashingStartValue;var pendingCharacter=null;for(var i=0;i<this.length;++i){var currentCharacter=this[i].charCodeAt(0);if(pendingCharacter===null){pendingCharacter=currentCharacter;continue;}
result+=pendingCharacter;result=(result<<16)^((currentCharacter<<11)^result);result+=result>>11;pendingCharacter=null;}
if(pendingCharacter!==null){result+=pendingCharacter;result^=result<<11;result+=result>>17;}
result^=result<<3;result+=result>>5;result^=result<<2;result+=result>>15;result^=result<<10;return(0xffffffff+result+1).toString(36);}});Object.defineProperty(String,"standardFormatters",{value:{d:function(substitution)
{return parseInt(substitution).toLocaleString();},f:function(substitution,token)
{let value=parseFloat(substitution);if(isNaN(value))
return NaN;let options={minimumFractionDigits:token.precision,maximumFractionDigits:token.precision,useGrouping:false};return value.toLocaleString(undefined,options);},s:function(substitution)
{return substitution;}}});Object.defineProperty(String,"format",{value(format,substitutions,formatters,initialValue,append)
{if(!format||!substitutions||!substitutions.length)
return{formattedResult:append(initialValue,format),unusedSubstitutions:substitutions};function prettyFunctionName()
{return"String.format(\""+format+"\", \""+Array.from(substitutions).join("\", \"")+"\")";}
function warn(msg)
{console.warn(prettyFunctionName()+": "+msg);}
function error(msg)
{console.error(prettyFunctionName()+": "+msg);}
var result=initialValue;var tokens=String.tokenizeFormatString(format);var usedSubstitutionIndexes={};let ignoredUnknownSpecifierCount=0;for(var i=0;i<tokens.length;++i){var token=tokens[i];if(token.type==="string"){result=append(result,token.value);continue;}
if(token.type!=="specifier"){error("Unknown token type \""+token.type+"\" found.");continue;}
let substitutionIndex=token.substitutionIndex-ignoredUnknownSpecifierCount;if(substitutionIndex>=substitutions.length){error("not enough substitution arguments. Had "+substitutions.length+" but needed "+(substitutionIndex+1)+", so substitution was skipped.");result=append(result,"%"+(token.precision>-1?token.precision:"")+token.specifier);continue;}
if(!(token.specifier in formatters)){warn(`Unsupported format specifier "%${token.specifier}" will be ignored.`);result=append(result,"%"+token.specifier);++ignoredUnknownSpecifierCount;continue;}
usedSubstitutionIndexes[substitutionIndex]=true;result=append(result,formatters[token.specifier](substitutions[substitutionIndex],token));}
var unusedSubstitutions=[];for(var i=0;i<substitutions.length;++i){if(i in usedSubstitutionIndexes)
continue;unusedSubstitutions.push(substitutions[i]);}
return{formattedResult:result,unusedSubstitutions};}});Object.defineProperty(String.prototype,"format",{value()
{return String.format(this,arguments,String.standardFormatters,"",function(a,b){return a+b;}).formattedResult;}});Object.defineProperty(String.prototype,"insertWordBreakCharacters",{value()
{return this.replace(/([\/;:\)\]\}&?])/g,"$1\u200b");}});Object.defineProperty(String.prototype,"removeWordBreakCharacters",{value()
{return this.replace(/\u200b/g,"");}});Object.defineProperty(String.prototype,"levenshteinDistance",{value(s)
{var m=this.length;var n=s.length;var d=new Array(m+1);for(var i=0;i<=m;++i){d[i]=new Array(n+1);d[i][0]=i;}
for(var j=0;j<=n;++j)
d[0][j]=j;for(var j=1;j<=n;++j){for(var i=1;i<=m;++i){if(this[i-1]===s[j-1])
d[i][j]=d[i-1][j-1];else{var deletion=d[i-1][j]+1;var insertion=d[i][j-1]+1;var substitution=d[i-1][j-1]+1;d[i][j]=Math.min(deletion,insertion,substitution);}}}
return d[m][n];}});Object.defineProperty(String.prototype,"toCamelCase",{value()
{return this.toLowerCase().replace(/[^\w]+(\w)/g,(match,group)=>group.toUpperCase());}});Object.defineProperty(String.prototype,"hasMatchingEscapedQuotes",{value()
{return /^\"(?:[^\"\\]|\\.)*\"$/.test(this)||/^\'(?:[^\'\\]|\\.)*\'$/.test(this);}});Object.defineProperty(Math,"roundTo",{value(num,step)
{return Math.round(num/step)*step;}});Object.defineProperty(Math,"multiplyMatrixByVector",{value(matrix,vector)
{let height=matrix.length;let width=matrix[0].length;let result=Array(width).fill(0);for(let i=0;i<width;++i){for(let rowIndex=0;rowIndex<height;++rowIndex)
result[i]+=vector[rowIndex]*matrix[i][rowIndex];}
return result;}});Object.defineProperty(Number,"constrain",{value(num,min,max)
{if(isNaN(num)||max<min)
return min;if(num<min)
num=min;else if(num>max)
num=max;return num;}});Object.defineProperty(Number,"percentageString",{value(fraction,precision=1)
{return fraction.toLocaleString(undefined,{minimumFractionDigits:precision,style:"percent"});}});Object.defineProperty(Number,"secondsToMillisecondsString",{value(seconds,higherResolution)
{let ms=seconds*1000;if(higherResolution)
return WI.UIString("%.2fms").format(ms);return WI.UIString("%.1fms").format(ms);}});Object.defineProperty(Number,"secondsToString",{value(seconds,higherResolution)
{const epsilon=0.0001;let ms=seconds*1000;if(ms<epsilon)
return WI.UIString("%.0fms").format(0);if(Math.abs(ms)<(10+epsilon)){if(higherResolution)
return WI.UIString("%.3fms").format(ms);return WI.UIString("%.2fms").format(ms);}
if(Math.abs(ms)<(100+epsilon)){if(higherResolution)
return WI.UIString("%.2fms").format(ms);return WI.UIString("%.1fms").format(ms);}
if(Math.abs(ms)<(1000+epsilon)){if(higherResolution)
return WI.UIString("%.1fms").format(ms);return WI.UIString("%.0fms").format(ms);}
if(higherResolution||Math.abs(seconds)<60)
return WI.UIString("%.2fs").format(seconds);let minutes=seconds/60;if(Math.abs(minutes)<60)
return WI.UIString("%.1fmin").format(minutes);let hours=minutes/60;if(Math.abs(hours)<24)
return WI.UIString("%.1fhrs").format(hours);let days=hours/24;return WI.UIString("%.1f days").format(days);}});Object.defineProperty(Number,"bytesToString",{value(bytes,higherResolution,bytesThreshold)
{higherResolution??=true;bytesThreshold??=1000;if(Math.abs(bytes)<bytesThreshold)
return WI.UIString("%.0f B").format(bytes);let kilobytes=bytes/1000;if(Math.abs(kilobytes)<1000){if(higherResolution||Math.abs(kilobytes)<10)
return WI.UIString("%.2f KB").format(kilobytes);return WI.UIString("%.1f KB").format(kilobytes);}
let megabytes=kilobytes/1000;if(Math.abs(megabytes)<1000){if(higherResolution||Math.abs(megabytes)<10)
return WI.UIString("%.2f MB").format(megabytes);return WI.UIString("%.1f MB").format(megabytes);}
let gigabytes=megabytes/1000;if(higherResolution||Math.abs(gigabytes)<10)
return WI.UIString("%.2f GB").format(gigabytes);return WI.UIString("%.1f GB").format(gigabytes);}});Object.defineProperty(Number,"abbreviate",{value(num)
{if(num<1000)
return num.toLocaleString();if(num<1_000_000)
return WI.UIString("%.1fK").format(Math.round(num/100)/10);if(num<1_000_000_000)
return WI.UIString("%.1fM").format(Math.round(num/100_000)/10);return WI.UIString("%.1fB").format(Math.round(num/100_000_000)/10);}});Object.defineProperty(Number,"zeroPad",{value(num,length)
{let string=num.toLocaleString();return string.padStart(length,"0");},});Object.defineProperty(Number,"countDigits",{value(num)
{if(num===0)
return 1;num=Math.abs(num);return Math.floor(Math.log(num)*Math.LOG10E)+1;}});Object.defineProperty(Number.prototype,"maxDecimals",{value(decimals)
{let power=10**decimals;return Math.round(this*power)/power;}});Object.defineProperty(Uint32Array,"isLittleEndian",{value()
{if("_isLittleEndian"in this)
return this._isLittleEndian;var buffer=new ArrayBuffer(4);var longData=new Uint32Array(buffer);var data=new Uint8Array(buffer);longData[0]=0x0a0b0c0d;this._isLittleEndian=data[0]===0x0d&&data[1]===0x0c&&data[2]===0x0b&&data[3]===0x0a;return this._isLittleEndian;}});function isEmptyObject(object)
{for(var property in object)
return false;return true;}
function isEnterKey(event)
{return event.keyCode!==229&&event.keyIdentifier==="Enter";}
function resolveDotsInPath(path)
{if(!path)
return path;if(path.indexOf("./")===-1)
return path;var result=[];var components=path.split("/");for(var i=0;i<components.length;++i){var component=components[i];if(component===".")
continue;if(component===".."){if(result.length===1)
continue;result.pop();continue;}
result.push(component);}
return result.join("/");}
function parseMIMEType(fullMimeType)
{if(!fullMimeType)
return{type:fullMimeType,boundary:null,encoding:null};var typeParts=fullMimeType.split(/\s*;\s*/);var type=typeParts[0];var boundary=null;var encoding=null;for(var i=1;i<typeParts.length;++i){var subparts=typeParts[i].split(/\s*=\s*/);if(subparts.length!==2)
continue;if(subparts[0].toLowerCase()==="boundary")
boundary=subparts[1];else if(subparts[0].toLowerCase()==="charset")
encoding=subparts[1].replace("^\"|\"$","");}
return{type,boundary:boundary||null,encoding:encoding||null};}
function simpleGlobStringToRegExp(globString,regExpFlags)
{if(!globString)
return null;var regexString=globString.escapeCharacters("^[]{}()\\.$+?|");regexString=regexString.replace(/\\\\\*/g,"\\*");var unescapedAsteriskRegex=/(^|[^\\])\*+/g;if(unescapedAsteriskRegex.test(globString)){regexString=regexString.replace(unescapedAsteriskRegex,"$1.*");regexString="\\b"+regexString+"\\b";}
return new RegExp(regexString,regExpFlags);}
Object.defineProperty(Array.prototype,"minIndex",{value(comparator)
{function defaultComparator(a,b)
{return a-b;}
comparator=comparator||defaultComparator;let minIndex=0;for(let i=1;i<this.length;++i){if(comparator(this[minIndex],this[i])>0)
minIndex=i;}
return minIndex;},});Object.defineProperty(Array.prototype,"lowerBound",{value(object,comparator)
{function defaultComparator(a,b)
{return a-b;}
comparator=comparator||defaultComparator;var l=0;var r=this.length;while(l<r){var m=(l+r)>>1;if(comparator(object,this[m])>0)
l=m+1;else
r=m;}
return r;}});Object.defineProperty(Array.prototype,"upperBound",{value(object,comparator)
{function defaultComparator(a,b)
{return a-b;}
comparator=comparator||defaultComparator;var l=0;var r=this.length;while(l<r){var m=(l+r)>>1;if(comparator(object,this[m])>=0)
l=m+1;else
r=m;}
return r;}});Object.defineProperty(Array.prototype,"binaryIndexOf",{value(value,comparator)
{function defaultComparator(a,b)
{return a-b;}
comparator=comparator||defaultComparator;var index=this.lowerBound(value,comparator);return index<this.length&&comparator(value,this[index])===0?index:-1;}});Object.defineProperty(Promise,"chain",{async value(callbacks,initialValue)
{let results=[];for(let i=0;i<callbacks.length;++i)
results.push(await callbacks[i](results.lastValue||initialValue||null,i));return results;}});Object.defineProperty(Promise,"delay",{value(delay)
{return new Promise((resolve)=>setTimeout(resolve,delay||0));}});function appendWebInspectorSourceURL(string)
{if(string.includes("//# sourceURL"))
return string;return"\n//# sourceURL=__WebInspectorInternal__\n"+string;}
function appendWebInspectorConsoleEvaluationSourceURL(string)
{if(string.includes("//# sourceURL"))
return string;return"\n//# sourceURL=__WebInspectorConsoleEvaluation__\n"+string;}
function isWebInspectorBootstrapScript(url)
{return url===WI.NetworkManager.bootstrapScriptURL;}
function isWebInspectorInternalScript(url)
{return url==="__WebInspectorInternal__";}
function isWebInspectorConsoleEvaluationScript(url)
{return url==="__WebInspectorConsoleEvaluation__";}
function isWebKitInjectedScript(url)
{return url&&url.startsWith("__InjectedScript_")&&url.endsWith(".js");}
function isWebKitInternalScript(url)
{if(isWebInspectorConsoleEvaluationScript(url))
return false;if(isWebKitInjectedScript(url))
return true;return url&&url.startsWith("__Web")&&url.endsWith("__");}
function isFunctionStringNativeCode(str)
{return str.endsWith("{\n    [native code]\n}");}
function whitespaceRatio(content,start,end)
{let whitespaceScore=0;let size=end-start;for(let i=start;i<end;i++){let char=content[i];if(char===" ")
whitespaceScore++;else if(char==="\t")
whitespaceScore+=4;else if(char==="\n")
whitespaceScore+=8;}
let ratio=whitespaceScore/size;return ratio;}
function isTextLikelyMinified(content)
{const autoFormatMaxCharactersToCheck=2500;const autoFormatWhitespaceRatio=0.2;if(content.length<=autoFormatMaxCharactersToCheck){let ratio=whitespaceRatio(content,0,content.length);return ratio<autoFormatWhitespaceRatio;}
let startRatio=whitespaceRatio(content,0,autoFormatMaxCharactersToCheck);if(startRatio<autoFormatWhitespaceRatio)
return true;let endRatio=whitespaceRatio(content,content.length-autoFormatMaxCharactersToCheck,content.length);if(endRatio<autoFormatWhitespaceRatio)
return true;return false;}
function doubleQuotedString(str)
{return JSON.stringify(str);}
function insertionIndexForObjectInListSortedByFunction(object,list,comparator,insertionIndexAfter)
{if(insertionIndexAfter){return list.upperBound(object,comparator);}else{return list.lowerBound(object,comparator);}}
function insertObjectIntoSortedArray(object,array,comparator)
{array.splice(insertionIndexForObjectInListSortedByFunction(object,array,comparator),0,object);}
WI.setReentrantCheck=function(object,key)
{key="__checkReentrant_"+key;object[key]=(object[key]||0)+1;return object[key]===1;};WI.clearReentrantCheck=function(object,key)
{key="__checkReentrant_"+key;object[key]=(object[key]||0)-1;return object[key]===0;};WI.SearchUtilities=class SearchUtilities{static get defaultSettings()
{return{caseSensitive:WI.settings.searchCaseSensitive,regularExpression:WI.settings.searchRegularExpression,};}
static createSettings(namePrefix)
{let settings={};for(let[key,defaultSetting]of Object.entries(WI.SearchUtilities.defaultSettings)){let setting=new WI.Setting(namePrefix+"-"+defaultSetting.name,defaultSetting.value);defaultSetting.addEventListener(WI.Setting.Event.Changed,function(event){this.value=defaultSetting.value;},setting);settings[key]=setting;}
return settings;}
static searchRegExpForString(query,settings={})
{return WI.SearchUtilities._regExpForString(query,settings,{global:true});}
static filterRegExpForString(query,settings={})
{return WI.SearchUtilities._regExpForString(query,settings);}
static createSettingsButton(settings)
{let button=document.createElement("button");button.classList.add("search-settings");button.tabIndex=-1;WI.addMouseDownContextMenuHandlers(button,(contextMenu)=>{if(settings.caseSensitive){contextMenu.appendCheckboxItem(WI.UIString("Case Sensitive","Case Sensitive @ Context Menu","Context menu label for whether searches should be case sensitive."),()=>{settings.caseSensitive.value=!settings.caseSensitive.value;},settings.caseSensitive.value);}
if(settings.regularExpression){contextMenu.appendCheckboxItem(WI.UIString("Regular Expression","Regular Expression @ Context Menu","Context menu label for whether searches should be treated as regular expressions."),()=>{settings.regularExpression.value=!settings.regularExpression.value;},settings.regularExpression.value);}});button.appendChild(WI.ImageUtilities.useSVGSymbol("Images/Gear.svg","glyph"));function toggleActive(){button.classList.toggle("active",Object.values(settings).some((setting)=>!!setting.value));}
settings.caseSensitive.addEventListener(WI.Setting.Event.Changed,toggleActive,button);settings.regularExpression.addEventListener(WI.Setting.Event.Changed,toggleActive,button);toggleActive();return button;}
static _regExpForString(query,settings={},options={})
{function checkSetting(setting){return setting instanceof WI.Setting?setting.value:!!setting;}
if(!checkSetting(settings.regularExpression)){try{query=simpleGlobStringToRegExp(String(query));}catch{return null;}}
let flags="";if(options.global)
flags+="g"
if(!checkSetting(settings.caseSensitive))
flags+="i";try{return new RegExp(query,flags);}catch{return null;}}};WI.Setting=class Setting extends WI.Object
{constructor(name,defaultValue)
{super();this._name=name;this._defaultValue=defaultValue;}
static migrateValue(key)
{let localStorageKey=WI.Setting._localStorageKeyPrefix+key;let value=undefined;if(!window.InspectorTest&&window.localStorage){let item=window.localStorage.getItem(localStorageKey);if(item!==null){try{value=JSON.parse(item);}catch{}
window.localStorage.removeItem(localStorageKey);}}
return value;}
static reset()
{let prefix=WI.Setting._localStorageKeyPrefix;let keysToRemove=[];for(let i=0;i<window.localStorage.length;++i){let key=window.localStorage.key(i);if(key.startsWith(prefix))
keysToRemove.push(key);}
for(let key of keysToRemove)
window.localStorage.removeItem(key);}
get name(){return this._name;}
get defaultValue(){return this._defaultValue;}
get value()
{if("_value"in this)
return this._value;this._value=JSON.parse(JSON.stringify(this._defaultValue));if(!window.InspectorTest&&window.localStorage){let key=WI.Setting._localStorageKeyPrefix+this._name;let item=window.localStorage.getItem(key);if(item!==null){try{this._value=JSON.parse(item);}catch{window.localStorage.removeItem(key);}}}
return this._value;}
set value(value)
{if(this._value===value)
return;this._value=value;this.save();}
save()
{if(!window.InspectorTest&&window.localStorage){let key=WI.Setting._localStorageKeyPrefix+this._name;try{if(Object.shallowEqual(this._value,this._defaultValue))
window.localStorage.removeItem(key);else
window.localStorage.setItem(key,JSON.stringify(this._value));}catch{console.error("Error saving setting with name: "+this._name);}}
this.dispatchEventToListeners(WI.Setting.Event.Changed,this._value,{name:this._name});}
reset()
{this.value=JSON.parse(JSON.stringify(this._defaultValue));}};WI.Setting._localStorageKeyPrefix=(function(){let inspectionLevel=InspectorFrontendHost?InspectorFrontendHost.inspectionLevel:1;let levelString=inspectionLevel>1?"-"+inspectionLevel:"";return`com.apple.WebInspector${levelString}.`;})();WI.Setting.isFirstLaunch=!!window.InspectorTest||(window.localStorage&&Object.keys(window.localStorage).every((key)=>!key.startsWith(WI.Setting._localStorageKeyPrefix)));WI.Setting.Event={Changed:"setting-changed"};WI.EngineeringSetting=class EngineeringSetting extends WI.Setting
{get value()
{if(WI.isEngineeringBuild)
return super.value;return this.defaultValue;}
set value(value)
{if(WI.isEngineeringBuild)
super.value=value;}};WI.DebugSetting=class DebugSetting extends WI.Setting
{get value()
{if(WI.isDebugUIEnabled())
return super.value;return this.defaultValue;}
set value(value)
{if(WI.isDebugUIEnabled())
super.value=value;}};WI.settings={blackboxBreakpointEvaluations:new WI.Setting("blackbox-breakpoint-evaluations",true),canvasRecordingAutoCaptureEnabled:new WI.Setting("canvas-recording-auto-capture-enabled",false),canvasRecordingAutoCaptureFrameCount:new WI.Setting("canvas-recording-auto-capture-frame-count",1),consoleAutoExpandTrace:new WI.Setting("console-auto-expand-trace",true),consoleSavedResultAlias:new WI.Setting("console-saved-result-alias",""),cssChangesPerNode:new WI.Setting("css-changes-per-node",false),clearLogOnNavigate:new WI.Setting("clear-log-on-navigate",true),clearNetworkOnNavigate:new WI.Setting("clear-network-on-navigate",true),cpuTimelineThreadDetailsExpanded:new WI.Setting("cpu-timeline-thread-details-expanded",false),emulateInUserGesture:new WI.Setting("emulate-in-user-gesture",false),enableControlFlowProfiler:new WI.Setting("enable-control-flow-profiler",false),enableElementsTabIndependentStylesDetailsSidebarPanel:new WI.Setting("elements-tab-independent-styles-details-panel",true),enableLineWrapping:new WI.Setting("enable-line-wrapping",true),flexOverlayShowOrderNumbers:new WI.Setting("flex-overlay-show-order-numbers",false),frontendAppearance:new WI.Setting("frontend-appearance","system"),gridOverlayShowAreaNames:new WI.Setting("grid-overlay-show-area-names",false),gridOverlayShowExtendedGridLines:new WI.Setting("grid-overlay-show-extended-grid-lines",false),gridOverlayShowLineNames:new WI.Setting("grid-overlay-show-line-names",false),gridOverlayShowLineNumbers:new WI.Setting("grid-overlay-show-line-numbers",true),gridOverlayShowTrackSizes:new WI.Setting("grid-overlay-show-track-sizes",true),groupMediaRequestsByDOMNode:new WI.Setting("group-media-requests-by-dom-node",WI.Setting.migrateValue("group-by-dom-node")||false),indentUnit:new WI.Setting("indent-unit",4),indentWithTabs:new WI.Setting("indent-with-tabs",false),resourceCachingDisabled:new WI.Setting("disable-resource-caching",false),searchCaseSensitive:new WI.Setting("search-case-sensitive",false),searchFromSelection:new WI.Setting("search-from-selection",false),searchRegularExpression:new WI.Setting("search-regular-expression",false),selectedNetworkDetailContentViewIdentifier:new WI.Setting("network-detail-content-view-identifier","preview"),sourceMapsEnabled:new WI.Setting("source-maps-enabled",true),showCSSPropertySyntaxInDocumentationPopover:new WI.Setting("show-css-property-syntax-in-documentation-popover",false),showCanvasPath:new WI.Setting("show-canvas-path",false),showImageGrid:new WI.Setting("show-image-grid",true),showInvisibleCharacters:new WI.Setting("show-invisible-characters",!!WI.Setting.migrateValue("show-invalid-characters")),showJavaScriptTypeInformation:new WI.Setting("show-javascript-type-information",false),showRulers:new WI.Setting("show-rulers",false),showRulersDuringElementSelection:new WI.Setting("show-rulers-during-element-selection",true),showScopeChainOnPause:new WI.Setting("show-scope-chain-sidebar",true),showWhitespaceCharacters:new WI.Setting("show-whitespace-characters",false),tabSize:new WI.Setting("tab-size",4),timelinesAutoStop:new WI.Setting("timelines-auto-stop",true),timelineOverviewGroupBySourceCode:new WI.Setting("timeline-overview-group-by-source-code",true),zoomFactor:new WI.Setting("zoom-factor",1),experimentalEnableStylesJumpToEffective:new WI.Setting("experimental-styles-jump-to-effective",false),experimentalEnableStylesJumpToVariableDeclaration:new WI.Setting("experimental-styles-jump-to-variable-declaration",false),experimentalAllowInspectingInspector:new WI.Setting("experimental-allow-inspecting-inspector",false),experimentalCSSSortPropertyNameAutocompletionByUsage:new WI.Setting("experimental-css-sort-property-name-autocompletion-by-usage",true),protocolLogAsText:new WI.Setting("protocol-log-as-text",false),protocolAutoLogMessages:new WI.Setting("protocol-auto-log-messages",false),protocolAutoLogTimeStats:new WI.Setting("protocol-auto-log-time-stats",false),protocolFilterMultiplexingBackendMessages:new WI.Setting("protocol-filter-multiplexing-backend-messages",true),engineeringShowInternalExecutionContexts:new WI.EngineeringSetting("engineering-show-internal-execution-contexts",false),engineeringShowInternalScripts:new WI.EngineeringSetting("engineering-show-internal-scripts",false),engineeringPauseForInternalScripts:new WI.EngineeringSetting("engineering-pause-for-internal-scripts",false),engineeringShowInternalObjectsInHeapSnapshot:new WI.EngineeringSetting("engineering-show-internal-objects-in-heap-snapshot",false),engineeringShowPrivateSymbolsInHeapSnapshot:new WI.EngineeringSetting("engineering-show-private-symbols-in-heap-snapshot",false),engineeringAllowEditingUserAgentShadowTrees:new WI.EngineeringSetting("engineering-allow-editing-user-agent-shadow-trees",false),engineeringShowMockWebExtensionTab:new WI.EngineeringSetting("engineering-show-mock-web-extension-tab",false),debugShowConsoleEvaluations:new WI.DebugSetting("debug-show-console-evaluations",false),debugOutlineFocusedElement:new WI.DebugSetting("debug-outline-focused-element",false),debugEnableLayoutFlashing:new WI.DebugSetting("debug-enable-layout-flashing",false),debugEnableStyleEditingDebugMode:new WI.DebugSetting("debug-enable-style-editing-debug-mode",false),debugEnableUncaughtExceptionReporter:new WI.DebugSetting("debug-enable-uncaught-exception-reporter",true),debugEnableDiagnosticLogging:new WI.DebugSetting("debug-enable-diagnostic-logging",true),debugAutoLogDiagnosticEvents:new WI.DebugSetting("debug-auto-log-diagnostic-events",false),debugLayoutDirection:new WI.DebugSetting("debug-layout-direction-override","system"),};WI.YieldableTask=class YieldableTask
{constructor(delegate,items,options={})
{let{workInterval,idleInterval}=options;this._workInterval=workInterval||10;this._idleInterval=idleInterval||0;this._delegate=delegate;this._items=items;this._idleTimeoutIdentifier=undefined;this._processing=false;this._processing=false;this._cancelled=false;}
get processing(){return this._processing;}
get cancelled(){return this._cancelled;}
get idleInterval(){return this._idleInterval;}
get workInterval(){return this._workInterval;}
start()
{if(this._processing)
return;if(this._cancelled)
return;function*createIteratorForProcessingItems()
{let startTime=Date.now();let processedItems=[];for(let item of this._items){if(this._cancelled)
break;this._delegate.yieldableTaskWillProcessItem(this,item);processedItems.push(item);if(this._cancelled)
break;let elapsedTime=Date.now()-startTime;if(elapsedTime>this._workInterval){let returnedItems=processedItems.slice();processedItems=[];this._willYield(returnedItems,elapsedTime);yield;startTime=Date.now();}}
if(processedItems.length)
this._willYield(processedItems,Date.now()-startTime);}
this._processing=true;this._pendingItemsIterator=createIteratorForProcessingItems.call(this);this._processPendingItems();}
cancel()
{if(!this._processing)
return;this._cancelled=true;}
_processPendingItems()
{if(this._cancelled)
return;if(!this._pendingItemsIterator.next().done){this._idleTimeoutIdentifier=setTimeout(()=>{this._processPendingItems();},this._idleInterval);return;}
this._didFinish();}
_willYield(processedItems,elapsedTime)
{if(typeof this._delegate.yieldableTaskDidYield==="function")
this._delegate.yieldableTaskDidYield(this,processedItems,elapsedTime);}
_didFinish()
{this._processing=false;this._pendingItemsIterator=null;if(this._idleTimeoutIdentifier){clearTimeout(this._idleTimeoutIdentifier);this._idleTimeoutIdentifier=undefined;}
if(typeof this._delegate.yieldableTaskDidFinish==="function")
this._delegate.yieldableTaskDidFinish(this);}};Object.defineProperty(File.prototype,"getPath",{value(){return InspectorFrontendHost.getPath(this);},});Object.defineProperty(CanvasRenderingContext2D.prototype,"currentX",{get(){return InspectorFrontendHost.getCurrentX(this);},});Object.defineProperty(CanvasRenderingContext2D.prototype,"currentY",{get(){return InspectorFrontendHost.getCurrentY(this);},});Object.defineProperty(CanvasRenderingContext2D.prototype,"getPath",{value(){return InspectorFrontendHost.getPath(this);},});Object.defineProperty(CanvasRenderingContext2D.prototype,"setPath",{value(path){return InspectorFrontendHost.setPath(this,path);},});WI.ProtocolTracer=class ProtocolTracer
{logStarted()
{}
logFrontendException(connection,message,exception)
{}
logFrontendRequest(connection,message)
{}
logWillHandleResponse(connection,message)
{}
logDidHandleResponse(connection,message,timings=null)
{}
logWillHandleEvent(connection,message)
{}
logDidHandleEvent(connection,message,timings=null)
{}
logFinished()
{}};WI.LoggingProtocolTracer=class LoggingProtocolTracer extends WI.ProtocolTracer
{constructor()
{super();this._dumpMessagesToConsole=false;this._dumpTimingDataToConsole=false;this._filterMultiplexingBackend=true;this._logToConsole=window.InspectorTest?InspectorFrontendHost.unbufferedLog.bind(InspectorFrontendHost):console.log;}
set dumpMessagesToConsole(value)
{this._dumpMessagesToConsole=!!value;}
get dumpMessagesToConsole()
{return this._dumpMessagesToConsole;}
set dumpTimingDataToConsole(value)
{this._dumpTimingDataToConsole=!!value;}
get dumpTimingDataToConsole()
{return this._dumpTimingDataToConsole;}
set filterMultiplexingBackend(value)
{this._filterMultiplexingBackend=!!value;}
get filterMultiplexingBackend()
{return this._filterMultiplexingBackend;}
logFrontendException(connection,message,exception)
{this._processEntry({type:"exception",connection,message,exception});}
logFrontendRequest(connection,message)
{this._processEntry({type:"request",connection,message});}
logWillHandleResponse(connection,message)
{let entry={type:"response",connection,message};this._processEntry(entry);}
logDidHandleResponse(connection,message,timings=null)
{let entry={type:"response",connection,message};if(timings)
entry.timings=Object.shallowCopy(timings);this._processEntry(entry);}
logWillHandleEvent(connection,message)
{let entry={type:"event",connection,message};this._processEntry(entry);}
logDidHandleEvent(connection,message,timings=null)
{let entry={type:"event",connection,message};if(timings)
entry.timings=Object.shallowCopy(timings);this._processEntry(entry);}
_processEntry(entry)
{if(this._dumpTimingDataToConsole&&entry.timings){if(entry.timings.rtt&&entry.timings.dispatch)
this._logToConsole(`time-stats: Handling: ${entry.timings.dispatch || NaN}ms; RTT: ${entry.timings.rtt}ms`);else if(entry.timings.dispatch)
this._logToConsole(`time-stats: Handling: ${entry.timings.dispatch || NaN}ms`);}else if(this._dumpMessagesToConsole&&!entry.timings){let connection=entry.connection;let targetId=connection&&connection.target?connection.target.identifier:"unknown";if(this._filterMultiplexingBackend&&targetId==="multi")
return;let prefix=`${entry.type} (${targetId})`;if(!window.InspectorTest&&InspectorFrontendHost.isBeingInspected()&&!WI.settings.protocolLogAsText.value){if(entry.type==="request"||entry.type==="exception")
console.trace(prefix,entry.message);else
this._logToConsole(prefix,entry.message);}else
this._logToConsole(`${prefix}: ${JSON.stringify(entry.message)}`);if(entry.exception){this._logToConsole(entry.exception);if(entry.exception.stack)
this._logToConsole(entry.exception.stack);}}}};InspectorBackendClass=class InspectorBackendClass
{constructor()
{this._registeredDomains={};this._activeDomains={};this._customTracer=null;this._defaultTracer=new WI.LoggingProtocolTracer;this._activeTracers=[this._defaultTracer];this._supportedDomainsForTargetType=new Multimap;this._supportedCommandParameters=new Map;this._supportedEventParameters=new Map;WI.settings.protocolAutoLogMessages.addEventListener(WI.Setting.Event.Changed,this._startOrStopAutomaticTracing,this);WI.settings.protocolAutoLogTimeStats.addEventListener(WI.Setting.Event.Changed,this._startOrStopAutomaticTracing,this);this._startOrStopAutomaticTracing();this.currentDispatchState={event:null,request:null,response:null,};}
get Enum()
{return this._registeredDomains;}
set dumpInspectorProtocolMessages(value)
{WI.settings.protocolAutoLogMessages.value=value;this._defaultTracer.dumpMessagesToConsole=value;}
get dumpInspectorProtocolMessages()
{return WI.settings.protocolAutoLogMessages.value;}
set dumpInspectorTimeStats(value)
{WI.settings.protocolAutoLogTimeStats.value=value;if(!this.dumpInspectorProtocolMessages)
this.dumpInspectorProtocolMessages=true;this._defaultTracer.dumpTimingDataToConsole=value;}
get dumpInspectorTimeStats()
{return WI.settings.protocolAutoLogTimeStats.value;}
set filterMultiplexingBackendInspectorProtocolMessages(value)
{WI.settings.protocolFilterMultiplexingBackendMessages.value=value;this._defaultTracer.filterMultiplexingBackend=value;}
get filterMultiplexingBackendInspectorProtocolMessages()
{return WI.settings.protocolFilterMultiplexingBackendMessages.value;}
set customTracer(tracer)
{if(!tracer&&!this._customTracer)
return;if(tracer===this._customTracer)
return;if(tracer===this._defaultTracer)
return;if(this._customTracer)
this._customTracer.logFinished();this._customTracer=tracer;this._activeTracers=[this._defaultTracer];if(this._customTracer){this._customTracer.logStarted();this._activeTracers.push(this._customTracer);}}
get activeTracers()
{return this._activeTracers;}
registerDomain(domainName,targetTypes)
{targetTypes=targetTypes||WI.TargetType.all;for(let targetType of targetTypes)
this._supportedDomainsForTargetType.add(targetType,domainName);this._registeredDomains[domainName]=new InspectorBackend.Domain(domainName);}
registerVersion(domainName,version)
{let domain=this._registeredDomains[domainName];domain.VERSION=version;}
registerEnum(qualifiedName,enumValues)
{let[domainName,enumName]=qualifiedName.split(".");let domain=this._registeredDomains[domainName];domain._addEnum(enumName,enumValues);}
registerCommand(qualifiedName,targetTypes,callSignature,replySignature)
{let[domainName,commandName]=qualifiedName.split(".");let domain=this._registeredDomains[domainName];domain._addCommand(targetTypes,new InspectorBackend.Command(qualifiedName,commandName,callSignature,replySignature));}
registerEvent(qualifiedName,targetTypes,signature)
{let[domainName,eventName]=qualifiedName.split(".");let domain=this._registeredDomains[domainName];domain._addEvent(targetTypes,new InspectorBackend.Event(qualifiedName,eventName,signature));}
registerDispatcher(domainName,dispatcher)
{let domain=this._registeredDomains[domainName];domain._addDispatcher(dispatcher);}
activateDomain(domainName,debuggableTypes)
{let currentDebuggableType=WI.sharedApp?.debuggableType||InspectorFrontendHost.debuggableInfo.debuggableType;if(debuggableTypes&&!debuggableTypes.includes(currentDebuggableType))
return;let domain=this._registeredDomains[domainName];this._activeDomains[domainName]=domain;let supportedTargetTypes=WI.DebuggableType.supportedTargetTypes(currentDebuggableType);for(let[targetType,command]of domain._supportedCommandsForTargetType){if(!supportedTargetTypes.has(targetType))
continue;let parameters=this._supportedCommandParameters.get(command._qualifiedName);if(!parameters){parameters=new Set;this._supportedCommandParameters.set(command._qualifiedName,parameters);}
parameters.addAll(command._callSignature.map((item)=>item.name));}
for(let[targetType,event]of domain._supportedEventsForTargetType){if(!supportedTargetTypes.has(targetType))
continue;let parameters=this._supportedEventParameters.get(event._qualifiedName);if(!parameters){parameters=new Set;this._supportedEventParameters.set(event._qualifiedName,parameters);}
parameters.addAll(event._parameterNames);}}
dispatch(message)
{InspectorBackend.backendConnection.dispatch(message);}
runAfterPendingDispatches(callback)
{if(!WI.mainTarget){callback();return;}
WI.mainTarget.connection.runAfterPendingDispatches(callback);}
supportedDomainsForTargetType(type)
{return this._supportedDomainsForTargetType.get(type)||new Set;}
hasDomain(domainName)
{return domainName in this._activeDomains;}
hasCommand(qualifiedName,parameterName)
{let parameters=this._supportedCommandParameters.get(qualifiedName);if(!parameters)
return false;return parameterName===undefined||parameters.has(parameterName);}
hasEvent(qualifiedName,parameterName)
{let parameters=this._supportedEventParameters.get(qualifiedName);if(!parameters)
return false;return parameterName===undefined||parameters.has(parameterName);}
getVersion(domainName)
{let domain=this._activeDomains[domainName];if(domain&&"VERSION"in domain)
return domain.VERSION;return-Infinity;}
invokeCommand(qualifiedName,targetType,connection,commandArguments,callback)
{let[domainName,commandName]=qualifiedName.split(".");let domain=this._activeDomains[domainName];return domain._invokeCommand(commandName,targetType,connection,commandArguments,callback);}
_makeAgent(domainName,target)
{let domain=this._activeDomains[domainName];return domain._makeAgent(target);}
_startOrStopAutomaticTracing()
{this._defaultTracer.dumpMessagesToConsole=this.dumpInspectorProtocolMessages;this._defaultTracer.dumpTimingDataToConsole=this.dumpTimingDataToConsole;this._defaultTracer.filterMultiplexingBackend=this.filterMultiplexingBackendInspectorProtocolMessages;}};InspectorBackend=new InspectorBackendClass;InspectorBackend.Domain=class InspectorBackendDomain
{constructor(domainName)
{this._domainName=domainName;this._dispatcher=null;this._supportedCommandsForTargetType=new Multimap;this._supportedEventsForTargetType=new Multimap;}
_addEnum(enumName,enumValues)
{this[enumName]=enumValues;}
_addCommand(targetTypes,command)
{targetTypes=targetTypes||WI.TargetType.all;for(let type of targetTypes)
this._supportedCommandsForTargetType.add(type,command);}
_addEvent(targetTypes,event)
{targetTypes=targetTypes||WI.TargetType.all;for(let type of targetTypes)
this._supportedEventsForTargetType.add(type,event);}
_addDispatcher(dispatcher)
{this._dispatcher=dispatcher;}
_makeAgent(target)
{let commands=this._supportedCommandsForTargetType.get(target.type)||new Set;let events=this._supportedEventsForTargetType.get(target.type)||new Set;return new InspectorBackend.Agent(target,commands,events,this._dispatcher);}
_invokeCommand(commandName,targetType,connection,commandArguments,callback)
{let commands=this._supportedCommandsForTargetType.get(targetType);for(let command of commands){if(command._commandName===commandName)
return command._makeCallable(connection).invoke(commandArguments,callback);}}};InspectorBackend.Agent=class InspectorBackendAgent
{constructor(target,commands,events,dispatcher)
{for(let command of commands){this[command._commandName]=command._makeCallable(target.connection);target._supportedCommandParameters.set(command._qualifiedName,command);}
this._events={};for(let event of events){this._events[event._eventName]=event;target._supportedEventParameters.set(event._qualifiedName,event);}
this._dispatcher=dispatcher?new dispatcher(target):null;}};InspectorBackend.Dispatcher=class InspectorBackendDispatcher
{constructor(target)
{this._target=target;}};InspectorBackend.Command=class InspectorBackendCommand
{constructor(qualifiedName,commandName,callSignature,replySignature)
{this._qualifiedName=qualifiedName;this._commandName=commandName;this._callSignature=callSignature||[];this._replySignature=replySignature||[];}
_hasParameter(parameterName)
{return this._callSignature.some((item)=>item.name===parameterName);}
_makeCallable(connection)
{let instance=new InspectorBackend.Callable(this,connection);function callable(){return instance._invokeWithArguments.call(instance,Array.from(arguments));}
callable._instance=instance;Object.setPrototypeOf(callable,InspectorBackend.Callable.prototype);return callable;}};InspectorBackend.Event=class InspectorBackendEvent
{constructor(qualifiedName,eventName,parameterNames)
{this._qualifiedName=qualifiedName;this._eventName=eventName;this._parameterNames=parameterNames||[];}
_hasParameter(parameterName)
{return this._parameterNames.includes(parameterName);}};InspectorBackend.Callable=function(command,connection)
{"use strict";this._command=command;this._connection=connection;this._instance=this;};InspectorBackend.Callable.prototype={__proto__:Function.prototype,invoke(commandArguments,callback)
{"use strict";let command=this._instance._command;let connection=this._instance._connection;function deliverFailure(message){console.error(`Protocol Error: ${message}`);if(callback)
setTimeout(callback.bind(null,message),0);else
return Promise.reject(new Error(message));}
if(typeof commandArguments!=="object")
return deliverFailure(`invoke expects an object for command arguments but its type is '${typeof commandArguments}'.`);let parameters={};for(let{name,type,optional}of command._callSignature){if(!(name in commandArguments)&&!optional)
return deliverFailure(`Missing argument '${name}' for command '${command._qualifiedName}'.`);let value=commandArguments[name];if(optional&&value===undefined)
continue;if(typeof value!==type)
return deliverFailure(`Invalid type of argument '${name}' for command '${command._qualifiedName}' call. It must be '${type}' but it is '${typeof value}'.`);parameters[name]=value;}
if(typeof callback==="function")
connection._sendCommandToBackendWithCallback(command,parameters,callback);else
return connection._sendCommandToBackendExpectingPromise(command,parameters);},_invokeWithArguments(commandArguments)
{"use strict";let command=this._instance._command;let connection=this._instance._connection;let callback=typeof commandArguments.lastValue==="function"?commandArguments.pop():null;function deliverFailure(message){console.error(`Protocol Error: ${message}`);if(callback)
setTimeout(callback.bind(null,message),0);else
return Promise.reject(new Error(message));}
let parameters={};for(let{name,type,optional}of command._callSignature){if(!commandArguments.length&&!optional)
return deliverFailure(`Invalid number of arguments for command '${command._qualifiedName}'.`);let value=commandArguments.shift();if(optional&&value===undefined)
continue;if(typeof value!==type)
return deliverFailure(`Invalid type of argument '${name}' for command '${command._qualifiedName}' call. It must be '${type}' but it is '${typeof value}'.`);parameters[name]=value;}
if(!callback&&commandArguments.length===1&&commandArguments[0]!==undefined)
return deliverFailure(`Protocol Error: Optional callback argument for command '${command._qualifiedName}' call must be a function but its type is '${typeof commandArguments[0]}'.`);if(callback)
connection._sendCommandToBackendWithCallback(command,parameters,callback);else
return connection._sendCommandToBackendExpectingPromise(command,parameters);}};InspectorBackend.globalSequenceId=1;InspectorBackend.Connection=class InspectorBackendConnection
{constructor()
{this._pendingResponses=new Map;this._deferredCallbacks=[];this._target=null;this._provisionalMessages=[];}
get target()
{return this._target;}
set target(target)
{this._target=target;}
addProvisionalMessage(message)
{this._provisionalMessages.push(message);}
dispatchProvisionalMessages()
{for(let message of this._provisionalMessages)
this.dispatch(message);this._provisionalMessages=[];}
dispatch(message)
{let messageObject=typeof message==="string"?JSON.parse(message):message;if("id"in messageObject)
this._dispatchResponse(messageObject);else
this._dispatchEvent(messageObject);}
runAfterPendingDispatches(callback)
{if(!this._pendingResponses.size)
callback.call(this);else
this._deferredCallbacks.push(callback);}
sendMessageToBackend(message)
{throw new Error("Should be implemented by a InspectorBackend.Connection subclass");}
_dispatchResponse(messageObject)
{if(messageObject.error&&messageObject.error.code!==-32_000)
console.error("Request with id = "+messageObject["id"]+" failed. "+JSON.stringify(messageObject.error));let sequenceId=messageObject["id"];let responseData=this._pendingResponses.take(sequenceId)||{};let{request,command,callback,promise}=responseData;let processingStartTimestamp=performance.now();for(let tracer of InspectorBackend.activeTracers)
tracer.logWillHandleResponse(this,messageObject);InspectorBackend.currentDispatchState.request=request;InspectorBackend.currentDispatchState.response=messageObject;if(typeof callback==="function")
this._dispatchResponseToCallback(command,request,messageObject,callback);else if(typeof promise==="object")
this._dispatchResponseToPromise(command,messageObject,promise);else
console.error("Received a command response without a corresponding callback or promise.",messageObject,command);InspectorBackend.currentDispatchState.request=null;InspectorBackend.currentDispatchState.response=null;let processingTime=(performance.now()-processingStartTimestamp).toFixed(3);let roundTripTime=(processingStartTimestamp-responseData.sendRequestTimestamp).toFixed(3);for(let tracer of InspectorBackend.activeTracers)
tracer.logDidHandleResponse(this,messageObject,{rtt:roundTripTime,dispatch:processingTime});if(this._deferredCallbacks.length&&!this._pendingResponses.size)
this._flushPendingScripts();}
_dispatchResponseToCallback(command,requestObject,responseObject,callback)
{let callbackArguments=[];callbackArguments.push(responseObject["error"]?responseObject["error"].message:null);if(responseObject["result"]){for(let parameterName of command._replySignature)
callbackArguments.push(responseObject["result"][parameterName]);}
try{callback.apply(null,callbackArguments);}catch(e){WI.reportInternalError(e,{"cause":`An uncaught exception was thrown while dispatching response callback for command ${command._qualifiedName}.`});}}
_dispatchResponseToPromise(command,messageObject,promise)
{let{resolve,reject}=promise;if(messageObject["error"])
reject(new Error(messageObject["error"].message));else
resolve(messageObject["result"]);}
_dispatchEvent(messageObject)
{let qualifiedName=messageObject.method;let[domainName,eventName]=qualifiedName.split(".");if(!this._target&&this===InspectorBackend.backendConnection&&WI.sharedApp.debuggableType===WI.DebuggableType.WebPage&&qualifiedName==="Target.targetCreated")
WI.targetManager.createMultiplexingBackendTarget();let agent=this._target._agents[domainName];if(!agent){console.error(`Protocol Error: Attempted to dispatch method '${qualifiedName}' for non-existing domain '${domainName}'`,messageObject);return;}
let dispatcher=agent._dispatcher;if(!dispatcher){console.error(`Protocol Error: Missing dispatcher for domain '${domainName}', for event '${qualifiedName}'`,messageObject);return;}
let event=agent._events[eventName];if(!event){console.error(`Protocol Error: Attempted to dispatch an unspecified method '${qualifiedName}'`,messageObject);return;}
let handler=dispatcher[eventName];if(!handler){console.error(`Protocol Error: Attempted to dispatch an unimplemented method '${qualifiedName}'`,messageObject);return;}
let processingStartTimestamp=performance.now();for(let tracer of InspectorBackend.activeTracers)
tracer.logWillHandleEvent(this,messageObject);InspectorBackend.currentDispatchState.event=messageObject;try{let params=messageObject.params||{};handler.apply(dispatcher,event._parameterNames.map((name)=>params[name]));}catch(e){for(let tracer of InspectorBackend.activeTracers)
tracer.logFrontendException(this,messageObject,e);WI.reportInternalError(e,{"cause":`An uncaught exception was thrown while handling event: ${qualifiedName}`});}
InspectorBackend.currentDispatchState.event=null;let processingDuration=(performance.now()-processingStartTimestamp).toFixed(3);for(let tracer of InspectorBackend.activeTracers)
tracer.logDidHandleEvent(this,messageObject,{dispatch:processingDuration});}
_sendCommandToBackendWithCallback(command,parameters,callback)
{let sequenceId=InspectorBackend.globalSequenceId++;let messageObject={"id":sequenceId,"method":command._qualifiedName,};if(!isEmptyObject(parameters))
messageObject["params"]=parameters;let responseData={command,request:messageObject,callback};if(InspectorBackend.activeTracer)
responseData.sendRequestTimestamp=performance.now();this._pendingResponses.set(sequenceId,responseData);this._sendMessageToBackend(messageObject);}
_sendCommandToBackendExpectingPromise(command,parameters)
{let sequenceId=InspectorBackend.globalSequenceId++;let messageObject={"id":sequenceId,"method":command._qualifiedName,};if(!isEmptyObject(parameters))
messageObject["params"]=parameters;let responseData={command,request:messageObject};if(InspectorBackend.activeTracer)
responseData.sendRequestTimestamp=performance.now();let responsePromise=new Promise(function(resolve,reject){responseData.promise={resolve,reject};});this._pendingResponses.set(sequenceId,responseData);this._sendMessageToBackend(messageObject);return responsePromise;}
_sendMessageToBackend(messageObject)
{for(let tracer of InspectorBackend.activeTracers)
tracer.logFrontendRequest(this,messageObject);this.sendMessageToBackend(JSON.stringify(messageObject));}
_flushPendingScripts()
{let scriptsToRun=this._deferredCallbacks;this._deferredCallbacks=[];for(let script of scriptsToRun)
script.call(this);}};InspectorBackend.BackendConnection=class InspectorBackendBackendConnection extends InspectorBackend.Connection
{sendMessageToBackend(message)
{InspectorFrontendHost.sendMessageToBackend(message);}};InspectorBackend.WorkerConnection=class InspectorBackendWorkerConnection extends InspectorBackend.Connection
{sendMessageToBackend(message)
{let workerId=this.target.identifier;this.target.parentTarget.WorkerAgent.sendMessageToWorker(workerId,message).catch((error)=>{if(this.target.isDestroyed)
return;WI.reportInternalError(error);});}};InspectorBackend.TargetConnection=class InspectorBackendTargetConnection extends InspectorBackend.Connection
{sendMessageToBackend(message)
{let targetId=this.target.identifier;this.target.parentTarget.TargetAgent.sendMessageToTarget(targetId,message).catch((error)=>{if(this.target.isDestroyed)
return;WI.reportInternalError(error);});}};InspectorBackend.backendConnection=new InspectorBackend.BackendConnection;InspectorFrontendAPI={_loaded:false,_pendingCommands:[],isTimelineProfilingEnabled:function()
{return WI.timelineManager.isCapturing();},setTimelineProfilingEnabled:function(enabled)
{if(!WI.targetsAvailable()){WI.whenTargetsAvailable().then(()=>{InspectorFrontendAPI.setTimelineProfilingEnabled(enabled);});return;}
WI.showTimelineTab({initiatorHint:WI.TabBrowser.TabNavigationInitiator.FrontendAPI});if(WI.timelineManager.isCapturing()===enabled)
return;if(enabled)
WI.timelineManager.startCapturing();else
WI.timelineManager.stopCapturing();},setElementSelectionEnabled:function(enabled)
{if(!WI.targetsAvailable()){WI.whenTargetsAvailable().then(()=>{InspectorFrontendAPI.setElementSelectionEnabled(enabled);});return;}
WI.domManager.inspectModeEnabled=enabled;},setDockingUnavailable:function(unavailable)
{WI.updateDockingAvailability(!unavailable);},setDockSide:function(side)
{WI.updateDockedState(side);},setIsVisible:function(visible)
{WI.updateVisibilityState(visible);},updateFindString:function(findString)
{WI.updateFindString(findString);},setDiagnosticLoggingAvailable:function(available)
{if(WI.diagnosticController)
WI.diagnosticController.diagnosticLoggingAvailable=available;},showConsole:function()
{const requestedScope=null;WI.showConsoleTab(requestedScope,{initiatorHint:WI.TabBrowser.TabNavigationInitiator.FrontendAPI,});WI.quickConsole.prompt.focus();if(document.readyState!=="complete")
document.addEventListener("readystatechange",this);if(document.visibilityState!=="visible")
document.addEventListener("visibilitychange",this);},handleEvent:function(event)
{if(document.readyState==="complete"&&document.visibilityState==="visible"){WI.quickConsole.prompt.focus();document.removeEventListener("readystatechange",this);document.removeEventListener("visibilitychange",this);}},showResources:function()
{WI.showSourcesTab({initiatorHint:WI.TabBrowser.TabNavigationInitiator.FrontendAPI,});},showTimelines:function()
{WI.showTimelineTab({initiatorHint:WI.TabBrowser.TabNavigationInitiator.FrontendAPI});},showMainResourceForFrame:function(frameIdentifier)
{WI.showSourceCodeForFrame(frameIdentifier,{ignoreNetworkTab:true,ignoreSearchTab:true,initiatorHint:WI.TabBrowser.TabNavigationInitiator.FrontendAPI,});},contextMenuItemSelected:function(id)
{WI.ContextMenu.contextMenuItemSelected(id);},contextMenuCleared:function()
{WI.ContextMenu.contextMenuCleared();},dispatchMessageAsync:function(messageObject)
{WI.dispatchMessageFromBackend(messageObject);},dispatchMessage:function(messageObject)
{InspectorBackend.dispatch(messageObject);},dispatch:function(signature)
{if(!InspectorFrontendAPI._loaded){InspectorFrontendAPI._pendingCommands.push(signature);return null;}
var methodName=signature.shift();if(!InspectorFrontendAPI[methodName])
return null;return InspectorFrontendAPI[methodName].apply(InspectorFrontendAPI,signature);},loadCompleted:function()
{InspectorFrontendAPI._loaded=true;for(var i=0;i<InspectorFrontendAPI._pendingCommands.length;++i)
InspectorFrontendAPI.dispatch(InspectorFrontendAPI._pendingCommands[i]);delete InspectorFrontendAPI._pendingCommands;},registerExtension(extensionID,extensionBundleIdentifier,displayName)
{return WI.sharedApp.extensionController.registerExtension(extensionID,extensionBundleIdentifier,displayName);},unregisterExtension(extensionID)
{return WI.sharedApp.extensionController.unregisterExtension(extensionID);},createTabForExtension(extensionID,tabName,tabIconURL,sourceURL)
{return WI.sharedApp.extensionController.createTabForExtension(extensionID,tabName,tabIconURL,sourceURL);},evaluateScriptForExtension(extensionID,scriptSource,{frameURL,contextSecurityOrigin,useContentScriptContext}={})
{return WI.sharedApp.extensionController.evaluateScriptForExtension(extensionID,scriptSource,{frameURL,contextSecurityOrigin,useContentScriptContext});},reloadForExtension(extensionID,{ignoreCache,userAgent,injectedScript}={})
{return WI.sharedApp.extensionController.reloadForExtension(extensionID,{ignoreCache,userAgent,injectedScript});},showExtensionTab(extensionTabID)
{return WI.sharedApp.extensionController.showExtensionTab(extensionTabID);},evaluateScriptInExtensionTab(extensionTabID,scriptSource)
{return WI.sharedApp.extensionController.evaluateScriptInExtensionTab(extensionTabID,scriptSource);},};(function(){let backendCommandsURL=InspectorFrontendHost.backendCommandsURL||"Protocol/InspectorBackendCommands.js";document.write("<script src=\""+backendCommandsURL+"\"></script>");})();WI._messagesToDispatch=[];WI.dispatchNextQueuedMessageFromBackend=function()
{const startCount=WI._messagesToDispatch.length;const startTimestamp=performance.now();const timeLimitPerRunLoop=10;let i=0;for(;i<WI._messagesToDispatch.length;++i){if(performance.now()-startTimestamp>timeLimitPerRunLoop)
break;InspectorBackend.dispatch(WI._messagesToDispatch[i]);}
if(i===WI._messagesToDispatch.length){WI._messagesToDispatch=[];WI._dispatchTimeout=null;}else{WI._messagesToDispatch=WI._messagesToDispatch.slice(i);WI._dispatchTimeout=setTimeout(WI.dispatchNextQueuedMessageFromBackend,0);}
if(InspectorBackend.dumpInspectorTimeStats){let messageDuration=(performance.now()-startTimestamp).toFixed(3);let dispatchedCount=startCount-WI._messagesToDispatch.length;let remainingCount=WI._messagesToDispatch.length;console.log(`time-stats: --- RunLoop duration: ${messageDuration}ms; dispatched: ${dispatchedCount}; remaining: ${remainingCount}`);}};WI.dispatchMessageFromBackend=function(message)
{this._messagesToDispatch.push(message);if(window.__uncaughtExceptions&&window.__uncaughtExceptions.length)
return;if(this._dispatchTimeout)
return;this._dispatchTimeout=setTimeout(this.dispatchNextQueuedMessageFromBackend,0);};WI.RemoteObject=class RemoteObject
{constructor(target,objectId,type,subtype,value,description,size,classPrototype,className,preview)
{this._target=target||WI.mainTarget;this._type=type;this._subtype=subtype;if(objectId){this._objectId=objectId;this._description=description||"";this._hasChildren=type!=="symbol";this._size=size;this._classPrototype=classPrototype;this._preview=preview;if(subtype==="class"){this._functionDescription=this._description;this._description="class "+className;}}else{this._description=description||(value+"");this._hasChildren=false;this._value=value;if(type==="bigint"){if(window.BigInt)
this._value=BigInt(description.substring(0,description.length-1));else
this._value=`${description} [BigInt Not Enabled in Web Inspector]`;}}}
static createFakeRemoteObject()
{return new WI.RemoteObject(undefined,WI.RemoteObject.FakeRemoteObjectId,"object");}
static fromPrimitiveValue(value)
{return new WI.RemoteObject(undefined,undefined,typeof value,undefined,value,undefined,undefined,undefined,undefined);}
static createBigIntFromDescriptionString(description)
{return new WI.RemoteObject(undefined,undefined,"bigint",undefined,undefined,description,undefined,undefined,undefined);}
static fromPayload(payload,target)
{if(payload.classPrototype)
payload.classPrototype=WI.RemoteObject.fromPayload(payload.classPrototype,target);if(payload.preview)
payload.preview=WI.ObjectPreview.fromPayload(payload.preview);return new WI.RemoteObject(target,payload.objectId,payload.type,payload.subtype,payload.value,payload.description,payload.size,payload.classPrototype,payload.className,payload.preview);}
static createCallArgument(valueOrObject)
{if(valueOrObject instanceof WI.RemoteObject){if(valueOrObject.objectId)
return{objectId:valueOrObject.objectId};return{value:valueOrObject.value};}
return{value:valueOrObject};}
static resolveNode(node,objectGroup)
{if(node.destroyed)
return Promise.reject("ERROR: node is destroyed");let target=WI.assumingMainTarget();return target.DOMAgent.resolveNode(node.id,objectGroup).then(({object})=>WI.RemoteObject.fromPayload(object,WI.mainTarget));}
static resolveWebSocket(webSocketResource,objectGroup,callback)
{let target=WI.assumingMainTarget();target.NetworkAgent.resolveWebSocket(webSocketResource.requestIdentifier,objectGroup,(error,object)=>{if(error||!object)
callback(null);else
callback(WI.RemoteObject.fromPayload(object,webSocketResource.target));});}
static resolveCanvasContext(canvas,objectGroup,callback)
{function wrapCallback(error,object){if(error||!object)
callback(null);else
callback(WI.RemoteObject.fromPayload(object,WI.mainTarget));}
let target=WI.assumingMainTarget();if(!target.hasCommand("Canvas.resolveContext")){target.CanvasAgent.resolveCanvasContext(canvas.identifier,objectGroup,wrapCallback);return;}
target.CanvasAgent.resolveContext(canvas.identifier,objectGroup,wrapCallback);}
static resolveAnimation(animation,objectGroup,callback)
{function wrapCallback(error,object){if(error||!object)
callback(null);else
callback(WI.RemoteObject.fromPayload(object,WI.mainTarget));}
let target=WI.assumingMainTarget();target.AnimationAgent.resolveAnimation(animation.animationId,objectGroup,wrapCallback);}
get target()
{return this._target;}
get objectId()
{return this._objectId;}
get type()
{return this._type;}
get subtype()
{return this._subtype;}
get description()
{return this._description;}
get functionDescription()
{return this._functionDescription||this._description;}
get hasChildren()
{return this._hasChildren;}
get value()
{return this._value;}
get size()
{return this._size||0;}
get classPrototype()
{return this._classPrototype;}
get preview()
{return this._preview;}
hasSize()
{return this.isArray()||this.isCollectionType();}
hasValue()
{return"_value"in this;}
canLoadPreview()
{if(this._failedToLoadPreview)
return false;if(this._type!=="object")
return false;if(!this._objectId||this._isSymbol()||this._isFakeObject())
return false;return true;}
updatePreview(callback)
{if(!this.canLoadPreview()){callback(null);return;}
if(!this._target.hasCommand("Runtime.getPreview")){this._failedToLoadPreview=true;callback(null);return;}
this._target.RuntimeAgent.getPreview(this._objectId,(error,payload)=>{if(error){this._failedToLoadPreview=true;callback(null);return;}
this._preview=WI.ObjectPreview.fromPayload(payload);callback(this._preview);});}
getPropertyDescriptors(callback,options={})
{if(!this._objectId||this._isSymbol()||this._isFakeObject()){callback([]);return;}
this._getProperties(this._getPropertyDescriptorsResolver.bind(this,callback),options);}
getDisplayablePropertyDescriptors(callback,options={})
{if(!this._objectId||this._isSymbol()||this._isFakeObject()){callback([]);return;}
this._getDisplayableProperties(this._getPropertyDescriptorsResolver.bind(this,callback),options);}
setPropertyValue(name,value,callback)
{if(!this._objectId||this._isSymbol()||this._isFakeObject()){callback("Can't set a property of non-object.");return;}
this._target.RuntimeAgent.evaluate.invoke({expression:appendWebInspectorSourceURL(value),doNotPauseOnExceptionsAndMuteConsole:true},evaluatedCallback.bind(this));function evaluatedCallback(error,result,wasThrown)
{if(error||wasThrown){callback(error||result.description);return;}
function setPropertyValue(propertyName,propertyValue)
{this[propertyName]=propertyValue;}
delete result.description;this._target.RuntimeAgent.callFunctionOn(this._objectId,appendWebInspectorSourceURL(setPropertyValue.toString()),[{value:name},result],true,undefined,propertySetCallback.bind(this));if(result._objectId)
this._target.RuntimeAgent.releaseObject(result._objectId);}
function propertySetCallback(error,result,wasThrown)
{if(error||wasThrown){callback(error||result.description);return;}
callback();}}
isUndefined()
{return this._type==="undefined";}
isNode()
{return this._subtype==="node";}
isArray()
{return this._subtype==="array";}
isClass()
{return this._subtype==="class";}
isCollectionType()
{return this._subtype==="map"||this._subtype==="set"||this._subtype==="weakmap"||this._subtype==="weakset";}
isWeakCollection()
{return this._subtype==="weakmap"||this._subtype==="weakset";}
getCollectionEntries(callback,{fetchStart,fetchCount}={})
{let objectGroup=this.isWeakCollection()?this._weakCollectionObjectGroup():"";this._target.RuntimeAgent.getCollectionEntries(this._objectId,objectGroup,fetchStart,fetchCount,(error,entries)=>{callback(entries.map((x)=>WI.CollectionEntry.fromPayload(x,this._target)));});}
releaseWeakCollectionEntries()
{this._target.RuntimeAgent.releaseObjectGroup(this._weakCollectionObjectGroup());}
pushNodeToFrontend(callback)
{if(this._objectId&&InspectorBackend.hasCommand("DOM.requestNode"))
WI.domManager.pushNodeToFrontend(this._objectId,callback);else
callback(0);}
async fetchProperties(propertyNames,resultObject={})
{let seenPropertyNames=new Set;let requestedValues=[];for(let propertyName of propertyNames){if(typeof propertyName!=="string"&&typeof propertyName!=="number")
throw new Error(`Tried to get property using key is not a string or number: ${propertyName}`);if(seenPropertyNames.has(propertyName))
continue;seenPropertyNames.add(propertyName);requestedValues.push(this.getProperty(propertyName));}
function maybeUnwrapValue(remoteObject){return remoteObject.hasValue()?remoteObject.value:remoteObject;}
let fetchedKeys=Array.from(seenPropertyNames);let fetchedValues=await Promise.all(requestedValues);for(let i=0;i<fetchedKeys.length;++i)
resultObject[fetchedKeys[i]]=maybeUnwrapValue(fetchedValues[i]);return resultObject;}
getProperty(propertyName,callback=null)
{function inspectedPage_object_getProperty(property){if(typeof property!=="string"&&typeof property!=="number")
throw new Error(`Tried to get property using key is not a string or number: ${property}`);return this[property];}
if(callback&&typeof callback==="function")
this.callFunction(inspectedPage_object_getProperty,[propertyName],true,callback);else
return this.callFunction(inspectedPage_object_getProperty,[propertyName],true);}
callFunction(functionDeclaration,args,generatePreview,callback=null)
{let translateResult=(result)=>result?WI.RemoteObject.fromPayload(result,this._target):null;if(args)
args=args.map(WI.RemoteObject.createCallArgument);if(callback&&typeof callback==="function"){this._target.RuntimeAgent.callFunctionOn(this._objectId,appendWebInspectorSourceURL(functionDeclaration.toString()),args,true,undefined,!!generatePreview,(error,result,wasThrown)=>{callback(error,translateResult(result),wasThrown);});}else{return this._target.RuntimeAgent.callFunctionOn(this._objectId,appendWebInspectorSourceURL(functionDeclaration.toString()),args,true,undefined,!!generatePreview).then(({result,wasThrown})=>{result=translateResult(result);if(result&&wasThrown)
return Promise.reject(result);return Promise.resolve(result);});}}
callFunctionJSON(functionDeclaration,args,callback)
{function mycallback(error,result,wasThrown)
{callback((error||wasThrown)?null:result.value);}
this._target.RuntimeAgent.callFunctionOn(this._objectId,appendWebInspectorSourceURL(functionDeclaration.toString()),args,true,true,mycallback);}
invokeGetter(getterRemoteObject,callback)
{function backendInvokeGetter(getter)
{return getter?getter.call(this):undefined;}
this.callFunction(backendInvokeGetter,[getterRemoteObject],true,callback);}
getOwnPropertyDescriptor(propertyName,callback)
{function backendGetOwnPropertyDescriptor(propertyName)
{return this[propertyName];}
function wrappedCallback(error,result,wasThrown)
{if(error||wasThrown||!(result instanceof WI.RemoteObject)){callback(null);return;}
var fakeDescriptor={name:propertyName,value:result,writable:true,configurable:true};var fakePropertyDescriptor=new WI.PropertyDescriptor(fakeDescriptor,null,true,false,false,false);callback(fakePropertyDescriptor);}
this.callFunction(backendGetOwnPropertyDescriptor,[propertyName],false,wrappedCallback.bind(this));}
release()
{if(this._objectId&&!this._isFakeObject())
this._target.RuntimeAgent.releaseObject(this._objectId);}
arrayLength()
{if(this._subtype!=="array")
return 0;var matches=this._description.match(/\[([0-9]+)\]/);if(!matches)
return 0;return parseInt(matches[1],10);}
asCallArgument()
{return WI.RemoteObject.createCallArgument(this);}
findFunctionSourceCodeLocation()
{var result=new WI.WrappedPromise;if(!this._isFunction()||!this._objectId){result.resolve(WI.RemoteObject.SourceCodeLocationPromise.MissingObjectId);return result.promise;}
this._target.DebuggerAgent.getFunctionDetails(this._objectId,(error,response)=>{if(error){result.resolve(WI.RemoteObject.SourceCodeLocationPromise.NoSourceFound);return;}
var location=response.location;var sourceCode=WI.debuggerManager.scriptForIdentifier(location.scriptId,this._target);if(!sourceCode||(!WI.settings.engineeringShowInternalScripts.value&&isWebKitInternalScript(sourceCode.sourceURL))){result.resolve(WI.RemoteObject.SourceCodeLocationPromise.NoSourceFound);return;}
var sourceCodeLocation=sourceCode.createSourceCodeLocation(location.lineNumber,location.columnNumber||0);result.resolve(sourceCodeLocation);});return result.promise;}
_isFakeObject()
{return this._objectId===WI.RemoteObject.FakeRemoteObjectId;}
_isSymbol()
{return this._type==="symbol";}
_isFunction()
{return this._type==="function";}
_weakCollectionObjectGroup()
{return JSON.stringify(this._objectId)+"-"+this._subtype;}
_getProperties(callback,{ownProperties,fetchStart,fetchCount,generatePreview}={})
{this._target.RuntimeAgent.getProperties.invoke({objectId:this._objectId,ownProperties,fetchStart,fetchCount,generatePreview,},callback);}
_getDisplayableProperties(callback,{fetchStart,fetchCount,generatePreview}={})
{this._target.RuntimeAgent.getDisplayableProperties.invoke({objectId:this._objectId,fetchStart,fetchCount,generatePreview,},callback);}
_getPropertyDescriptorsResolver(callback,error,properties,internalProperties)
{if(error){callback(null);return;}
let descriptors=properties.map((payload)=>WI.PropertyDescriptor.fromPayload(payload,false,this._target));if(internalProperties){for(let payload of internalProperties)
descriptors.push(WI.PropertyDescriptor.fromPayload(payload,true,this._target));}
callback(descriptors);}};WI.RemoteObject.FakeRemoteObjectId="fake-remote-object";WI.RemoteObject.SourceCodeLocationPromise={NoSourceFound:"remote-object-source-code-location-promise-no-source-found",MissingObjectId:"remote-object-source-code-location-promise-missing-object-id"};WI.Target=class Target extends WI.Object
{constructor(parentTarget,identifier,name,type,connection,{isPaused,isProvisional}={})
{super();this._parentTarget=parentTarget;this._identifier=identifier;this._name=name;this._type=type;this._connection=connection;this._isPaused=!!isPaused;this._isProvisional=!!isProvisional;this._executionContext=null;this._mainResource=null;this._resourceCollection=new WI.ResourceCollection;this._extraScriptCollection=new WI.ScriptCollection;this._supportedCommandParameters=new Map;this._supportedEventParameters=new Map;this._agents={};for(let domainName of InspectorBackend.supportedDomainsForTargetType(this._type))
this._agents[domainName]=InspectorBackend._makeAgent(domainName,this);this._connection.target=this;}
initialize()
{if(this.hasDomain("Inspector"))
this.InspectorAgent.enable();for(let manager of WI.managers){if(manager.initializeTarget)
manager.initializeTarget(this);}
WI.initializeTarget(this);this.ConsoleAgent.enable();setTimeout(()=>{WI.performOneTimeFrontendInitializationsUsingTarget(this);});Promise.all(Target._initializationPromises).then(()=>{if(this.hasDomain("Inspector"))
this.InspectorAgent.initialized();});this._resumeIfPaused();}
_resumeIfPaused()
{if(this._isPaused){this._parentTarget.TargetAgent.resume(this._identifier,(error)=>{if(error){if(!this.isDestroyed)
WI.reportInternalError(error);return;}
this._isPaused=false;});}}
activateExtraDomain(domainName)
{this._agents[domainName]=InspectorBackend._makeAgent(domainName,this);}
get AnimationAgent(){return this._agents.Animation;}
get ApplicationCacheAgent(){return this._agents.ApplicationCache;}
get AuditAgent(){return this._agents.Audit;}
get BrowserAgent(){return this._agents.Browser;}
get CPUProfilerAgent(){return this._agents.CPUProfiler;}
get CSSAgent(){return this._agents.CSS;}
get CanvasAgent(){return this._agents.Canvas;}
get ConsoleAgent(){return this._agents.Console;}
get DOMAgent(){return this._agents.DOM;}
get DOMDebuggerAgent(){return this._agents.DOMDebugger;}
get DOMStorageAgent(){return this._agents.DOMStorage;}
get DatabaseAgent(){return this._agents.Database;}
get DebuggerAgent(){return this._agents.Debugger;}
get HeapAgent(){return this._agents.Heap;}
get IndexedDBAgent(){return this._agents.IndexedDB;}
get InspectorAgent(){return this._agents.Inspector;}
get LayerTreeAgent(){return this._agents.LayerTree;}
get MemoryAgent(){return this._agents.Memory;}
get NetworkAgent(){return this._agents.Network;}
get PageAgent(){return this._agents.Page;}
get RecordingAgent(){return this._agents.Recording;}
get RuntimeAgent(){return this._agents.Runtime;}
get ScriptProfilerAgent(){return this._agents.ScriptProfiler;}
get ServiceWorkerAgent(){return this._agents.ServiceWorker;}
get TargetAgent(){return this._agents.Target;}
get TimelineAgent(){return this._agents.Timeline;}
get WorkerAgent(){return this._agents.Worker;}
static registerInitializationPromise(promise)
{Target._initializationPromises.push(promise);promise.then(()=>{++Target._completedInitializationPromiseCount;Target._initializationPromises.remove(promise);});}
get parentTarget(){return this._parentTarget;}
get rootTarget()
{if(this._type===WI.TargetType.Page)
return this;if(this._parentTarget)
return this._parentTarget.rootTarget;return this;}
get identifier(){return this._identifier;}
set identifier(identifier){this._identifier=identifier;}
get name(){return this._name;}
set name(name){this._name=name;}
get type(){return this._type;}
get connection(){return this._connection;}
get executionContext(){return this._executionContext;}
get resourceCollection(){return this._resourceCollection;}
get extraScriptCollection(){return this._extraScriptCollection;}
get isProvisional(){return this._isProvisional;}
get isPaused(){return this._isPaused;}
get isDestroyed(){return this._isDestroyed;}
get displayName(){return this._name;}
get mainResource()
{return this._mainResource;}
set mainResource(resource)
{this._mainResource=resource;this.dispatchEventToListeners(WI.Target.Event.MainResourceAdded,{resource});}
addResource(resource)
{this._resourceCollection.add(resource);this.dispatchEventToListeners(WI.Target.Event.ResourceAdded,{resource});}
adoptResource(resource)
{resource._target=this;this.addResource(resource);}
addScript(script)
{this._extraScriptCollection.add(script);this.dispatchEventToListeners(WI.Target.Event.ScriptAdded,{script});}
didCommitProvisionalTarget()
{this._isProvisional=false;}
destroy()
{this._isDestroyed=true;}
hasDomain(domainName)
{return domainName in this._agents;}
hasCommand(qualifiedName,parameterName)
{let command=this._supportedCommandParameters.get(qualifiedName);if(!command)
return false;return parameterName===undefined||command._hasParameter(parameterName);}
hasEvent(qualifiedName,parameterName)
{let event=this._supportedEventParameters.get(qualifiedName);if(!event)
return false;return parameterName===undefined||event._hasParameter(parameterName);}};WI.Target.Event={MainResourceAdded:"target-main-resource-added",ResourceAdded:"target-resource-added",ScriptAdded:"target-script-added",};WI.Target._initializationPromises=[];WI.Target._completedInitializationPromiseCount=0;WI.DirectBackendTarget=class DirectBackendTarget extends WI.Target
{constructor()
{const parentTarget=null;const targetId="direct";let{type,displayName}=DirectBackendTarget.connectionInfoForDebuggable();super(parentTarget,targetId,displayName,type,InspectorBackend.backendConnection);this._executionContext=new WI.ExecutionContext(this,WI.RuntimeManager.TopLevelContextExecutionIdentifier,WI.ExecutionContext.Type.Normal,displayName);this._mainResource=null;}
static connectionInfoForDebuggable()
{switch(WI.sharedApp.debuggableType){case WI.DebuggableType.ITML:return{type:WI.TargetType.ITML,displayName:WI.UIString("ITML Context"),};case WI.DebuggableType.JavaScript:return{type:WI.TargetType.JavaScript,displayName:WI.UIString("JavaScript Context"),};case WI.DebuggableType.Page:return{type:WI.TargetType.Page,displayName:WI.UIString("Page"),};case WI.DebuggableType.ServiceWorker:return{type:WI.TargetType.ServiceWorker,displayName:WI.UIString("ServiceWorker"),};case WI.DebuggableType.WebPage:return{type:WI.TargetType.WebPage,displayName:WI.UIString("Page"),};default:console.error("Unexpected debuggable type: ",WI.sharedApp.debuggableType);return{type:WI.TargetType.JavaScript,displayName:WI.UIString("JavaScript Context"),};}}
get mainResource()
{if(this._mainResource)
return this._mainResource;let mainFrame=WI.networkManager.mainFrame;return mainFrame?mainFrame.mainResource:null;}
set mainResource(resource)
{this._mainResource=resource;}};WI.MultiplexingBackendTarget=class MultiplexingBackendTarget extends WI.Target
{constructor()
{const parentTarget=null;const targetId="multi";super(parentTarget,targetId,WI.UIString("Web Page"),WI.TargetType.WebPage,InspectorBackend.backendConnection);}
initialize()
{WI.browserManager.initializeTarget(this);WI.targetManager.initializeTarget(this);}
get name()
{console.error("Called name on a MultiplexingBackendTarget");return WI.UIString("Page");}
get executionContext()
{console.error("Called executionContext on a MultiplexingBackendTarget");return null;}
get mainResource()
{console.error("Called mainResource on a MultiplexingBackendTarget");return null;}};WI.PageTarget=class PageTarget extends WI.Target
{constructor(parentTarget,targetId,name,connection,options={})
{super(parentTarget,targetId,name,WI.TargetType.Page,connection,options);this._executionContext=new WI.ExecutionContext(this,WI.RuntimeManager.TopLevelContextExecutionIdentifier,WI.ExecutionContext.Type.Normal,this.displayName);}};WI.WorkerTarget=class WorkerTarget extends WI.Target
{constructor(parentTarget,workerId,url,displayName,connection,options={})
{super(parentTarget,workerId,url,WI.TargetType.Worker,connection,options);this._displayName=displayName;this._executionContext=new WI.ExecutionContext(this,WI.RuntimeManager.TopLevelContextExecutionIdentifier,WI.ExecutionContext.Type.Normal,this.displayName);}
get customName()
{return this._displayName;}
get displayName()
{return this._displayName||this.displayURL;}
get displayURL()
{return WI.displayNameForURL(this._name);}};WI.AnimationObserver=class AnimationObserver extends InspectorBackend.Dispatcher
{animationCreated(animation)
{WI.animationManager.animationCreated(animation);}
nameChanged(animationId,name)
{WI.animationManager.nameChanged(animationId,name);}
effectChanged(animationId,effect)
{WI.animationManager.effectChanged(animationId,effect);}
targetChanged(animationId)
{WI.animationManager.targetChanged(animationId);}
animationDestroyed(animationId)
{WI.animationManager.animationDestroyed(animationId);}
trackingStart(timestamp)
{WI.timelineManager.animationTrackingStarted(timestamp);}
trackingUpdate(timestamp,event)
{WI.timelineManager.animationTrackingUpdated(timestamp,event);}
trackingComplete(timestamp)
{WI.timelineManager.animationTrackingCompleted(timestamp);}};WI.ApplicationCacheObserver=class ApplicationCacheObserver extends InspectorBackend.Dispatcher
{applicationCacheStatusUpdated(frameId,manifestURL,status)
{WI.applicationCacheManager.applicationCacheStatusUpdated(frameId,manifestURL,status);}
networkStateUpdated(isNowOnline)
{WI.applicationCacheManager.networkStateUpdated(isNowOnline);}};WI.BrowserObserver=class BrowserObserver extends InspectorBackend.Dispatcher
{extensionsEnabled(extensions)
{WI.browserManager.extensionsEnabled(extensions);}
extensionsDisabled(extensionIds)
{WI.browserManager.extensionsDisabled(extensionIds);}};WI.CPUProfilerObserver=class CPUProfilerObserver extends InspectorBackend.Dispatcher
{trackingStart(timestamp)
{WI.timelineManager.cpuProfilerTrackingStarted(timestamp);}
trackingUpdate(event)
{WI.timelineManager.cpuProfilerTrackingUpdated(event);}
trackingComplete(timestamp)
{WI.timelineManager.cpuProfilerTrackingCompleted(timestamp);}};WI.CSSObserver=class CSSObserver extends InspectorBackend.Dispatcher
{mediaQueryResultChanged()
{WI.cssManager.mediaQueryResultChanged();}
styleSheetChanged(styleSheetId)
{WI.cssManager.styleSheetChanged(styleSheetId);}
styleSheetAdded(styleSheetInfo)
{WI.cssManager.styleSheetAdded(styleSheetInfo);}
styleSheetRemoved(id)
{WI.cssManager.styleSheetRemoved(id);}
nodeLayoutContextTypeChanged(nodeId,layoutContextType)
{WI.domManager.nodeLayoutContextTypeChanged(nodeId,layoutContextType);}
namedFlowCreated(namedFlow)
{}
namedFlowRemoved(documentNodeId,flowName)
{}
regionOversetChanged(namedFlow)
{}
registeredNamedFlowContentElement(documentNodeId,flowName,contentNodeId,nextContentElementNodeId)
{}
unregisteredNamedFlowContentElement(documentNodeId,flowName,contentNodeId)
{}};WI.CanvasObserver=class CanvasObserver extends InspectorBackend.Dispatcher
{canvasAdded(canvas)
{WI.canvasManager.canvasAdded(canvas);}
canvasRemoved(canvasId)
{WI.canvasManager.canvasRemoved(canvasId);}
canvasMemoryChanged(canvasId,memoryCost)
{WI.canvasManager.canvasMemoryChanged(canvasId,memoryCost);}
clientNodesChanged(canvasId)
{WI.canvasManager.clientNodesChanged(canvasId);}
recordingStarted(canvasId,initiator)
{WI.canvasManager.recordingStarted(canvasId,initiator);}
recordingProgress(canvasId,frames,bufferUsed)
{WI.canvasManager.recordingProgress(canvasId,frames,bufferUsed);}
recordingFinished(canvasId,recording)
{WI.canvasManager.recordingFinished(canvasId,recording);}
extensionEnabled(canvasId,extension)
{WI.canvasManager.extensionEnabled(canvasId,extension);}
programCreated(shaderProgram)
{if(arguments.length===2){shaderProgram={canvasId:arguments[0],programId:arguments[1],};}
WI.canvasManager.programCreated(shaderProgram);}
programDeleted(programId)
{WI.canvasManager.programDeleted(programId);}
cssCanvasClientNodesChanged(canvasId)
{WI.canvasManager.clientNodesChanged(canvasId);}};WI.ConsoleObserver=class ConsoleObserver extends InspectorBackend.Dispatcher
{messageAdded(message)
{if(message.source==="console-api"&&message.type==="clear")
return;if(message.type==="assert"&&!message.text)
message.text=WI.UIString("Assertion");WI.consoleManager.messageWasAdded(this._target,message.source,message.level,message.text,message.type,message.url,message.line,message.column||0,message.repeatCount,message.parameters,message.stackTrace,message.networkRequestId,message.timestamp);}
messageRepeatCountUpdated(count)
{WI.consoleManager.messageRepeatCountUpdated(count);}
messagesCleared()
{WI.consoleManager.messagesCleared();}
heapSnapshot(timestamp,snapshotStringData,title)
{let workerProxy=WI.HeapSnapshotWorkerProxy.singleton();workerProxy.createSnapshot(snapshotStringData,title||null,({objectId,snapshot:serializedSnapshot})=>{let snapshot=WI.HeapSnapshotProxy.deserialize(objectId,serializedSnapshot);snapshot.snapshotStringData=snapshotStringData;WI.timelineManager.heapSnapshotAdded(timestamp,snapshot);});}};WI.DOMObserver=class DOMObserver extends InspectorBackend.Dispatcher
{documentUpdated()
{WI.domManager._documentUpdated();}
inspect(nodeId)
{WI.domManager.inspectElement(nodeId);}
setChildNodes(parentId,nodes)
{WI.domManager._setChildNodes(parentId,nodes);}
attributeModified(nodeId,name,value)
{WI.domManager._attributeModified(nodeId,name,value);}
attributeRemoved(nodeId,name)
{WI.domManager._attributeRemoved(nodeId,name);}
inlineStyleInvalidated(nodeIds)
{WI.domManager._inlineStyleInvalidated(nodeIds);}
characterDataModified(nodeId,characterData)
{WI.domManager._characterDataModified(nodeId,characterData);}
childNodeCountUpdated(nodeId,childNodeCount)
{WI.domManager._childNodeCountUpdated(nodeId,childNodeCount);}
childNodeInserted(parentNodeId,previousNodeId,node)
{WI.domManager._childNodeInserted(parentNodeId,previousNodeId,node);}
childNodeRemoved(parentNodeId,nodeId)
{WI.domManager._childNodeRemoved(parentNodeId,nodeId);}
willDestroyDOMNode(nodeId)
{WI.domManager.willDestroyDOMNode(nodeId);}
shadowRootPushed(hostId,root)
{WI.domManager._childNodeInserted(hostId,0,root);}
shadowRootPopped(hostId,rootId)
{WI.domManager._childNodeRemoved(hostId,rootId);}
customElementStateChanged(nodeId,customElementState)
{WI.domManager._customElementStateChanged(nodeId,customElementState);}
pseudoElementAdded(parentNodeId,pseudoElement)
{WI.domManager._pseudoElementAdded(parentNodeId,pseudoElement);}
pseudoElementRemoved(parentNodeId,pseudoElementId)
{WI.domManager._pseudoElementRemoved(parentNodeId,pseudoElementId);}
didAddEventListener(nodeId)
{WI.domManager.didAddEventListener(nodeId);}
willRemoveEventListener(nodeId)
{WI.domManager.willRemoveEventListener(nodeId);}
didFireEvent(nodeId,eventName,timestamp,data)
{WI.domManager.didFireEvent(nodeId,eventName,timestamp,data);}
videoLowPowerChanged(nodeId,timestamp,isLowPower)
{WI.domManager.powerEfficientPlaybackStateChanged(nodeId,timestamp,isLowPower);}
powerEfficientPlaybackStateChanged(nodeId,timestamp,isPowerEfficient)
{WI.domManager.powerEfficientPlaybackStateChanged(nodeId,timestamp,isPowerEfficient);}};WI.DOMStorageObserver=class DOMStorageObserver extends InspectorBackend.Dispatcher
{domStorageItemsCleared(storageId)
{WI.domStorageManager.itemsCleared(storageId);}
domStorageItemRemoved(storageId,key)
{WI.domStorageManager.itemRemoved(storageId,key);}
domStorageItemAdded(storageId,key,value)
{WI.domStorageManager.itemAdded(storageId,key,value);}
domStorageItemUpdated(storageId,key,oldValue,newValue)
{WI.domStorageManager.itemUpdated(storageId,key,oldValue,newValue);}};WI.DatabaseObserver=class DatabaseObserver extends InspectorBackend.Dispatcher
{addDatabase(database)
{WI.databaseManager.databaseWasAdded(database.id,database.domain,database.name,database.version);}};WI.DebuggerObserver=class DebuggerObserver extends InspectorBackend.Dispatcher
{constructor(target)
{super(target);this._legacyScriptParsed=this._target.hasEvent("Debugger.scriptParsed","hasSourceURL");}
globalObjectCleared()
{WI.debuggerManager.globalObjectCleared(this._target);}
scriptParsed(scriptId,url,startLine,startColumn,endLine,endColumn,isContentScript,sourceURL,sourceMapURL,isModule)
{WI.debuggerManager.scriptDidParse(this._target,scriptId,url,startLine,startColumn,endLine,endColumn,isModule,isContentScript,sourceURL,sourceMapURL);}
scriptFailedToParse(url,scriptSource,startLine,errorLine,errorMessage)
{WI.debuggerManager.scriptDidFail(this._target,url,scriptSource);}
breakpointResolved(breakpointId,location)
{WI.debuggerManager.breakpointResolved(this._target,breakpointId,location);}
paused(callFrames,reason,data,asyncStackTrace)
{WI.debuggerManager.debuggerDidPause(this._target,callFrames,reason,data,asyncStackTrace);}
resumed()
{WI.debuggerManager.debuggerDidResume(this._target);}
playBreakpointActionSound(breakpointActionIdentifier)
{WI.debuggerManager.playBreakpointActionSound(breakpointActionIdentifier);}
didSampleProbe(sample)
{WI.debuggerManager.didSampleProbe(this._target,sample);}};WI.HeapObserver=class HeapObserver extends InspectorBackend.Dispatcher
{garbageCollected(collection)
{WI.heapManager.garbageCollected(this._target,collection);}
trackingStart(timestamp,snapshotStringData)
{let workerProxy=WI.HeapSnapshotWorkerProxy.singleton();workerProxy.createSnapshot(snapshotStringData,({objectId,snapshot:serializedSnapshot})=>{let snapshot=WI.HeapSnapshotProxy.deserialize(objectId,serializedSnapshot);snapshot.snapshotStringData=snapshotStringData;WI.timelineManager.heapTrackingStarted(timestamp,snapshot);});}
trackingComplete(timestamp,snapshotStringData)
{let workerProxy=WI.HeapSnapshotWorkerProxy.singleton();workerProxy.createSnapshot(snapshotStringData,({objectId,snapshot:serializedSnapshot})=>{let snapshot=WI.HeapSnapshotProxy.deserialize(objectId,serializedSnapshot);snapshot.snapshotStringData=snapshotStringData;WI.timelineManager.heapTrackingCompleted(timestamp,snapshot);});}};WI.InspectorObserver=class InspectorObserver extends InspectorBackend.Dispatcher
{evaluateForTestInFrontend(script)
{if(!InspectorFrontendHost.isUnderTest())
return;InspectorBackend.runAfterPendingDispatches(function(){window.eval(script);});}
inspect(payload,hints)
{let remoteObject=WI.RemoteObject.fromPayload(payload,WI.mainTarget);if(remoteObject.subtype==="node"){WI.domManager.inspectNodeObject(remoteObject);return;}
if(remoteObject.type==="function"){remoteObject.findFunctionSourceCodeLocation().then((sourceCodeLocation)=>{if(sourceCodeLocation instanceof WI.SourceCodeLocation){WI.showSourceCodeLocation(sourceCodeLocation,{ignoreNetworkTab:true,ignoreSearchTab:true,});}});remoteObject.release();return;}
if(hints.databaseId)
WI.databaseManager.inspectDatabase(hints.databaseId);else if(hints.domStorageId)
WI.domStorageManager.inspectDOMStorage(hints.domStorageId);remoteObject.release();}
activateExtraDomains(domains)
{WI.sharedApp.activateExtraDomains(domains);}};WI.LayerTreeObserver=class LayerTreeObserver extends InspectorBackend.Dispatcher
{layerTreeDidChange()
{WI.layerTreeManager.layerTreeDidChange();}};WI.MemoryObserver=class MemoryObserver extends InspectorBackend.Dispatcher
{memoryPressure(timestamp,severity)
{WI.memoryManager.memoryPressure(timestamp,severity);}
trackingStart(timestamp)
{WI.timelineManager.memoryTrackingStarted(timestamp);}
trackingUpdate(event)
{WI.timelineManager.memoryTrackingUpdated(event);}
trackingComplete(timestamp)
{WI.timelineManager.memoryTrackingCompleted(timestamp);}};WI.NetworkObserver=class NetworkObserver extends InspectorBackend.Dispatcher
{constructor(target)
{super(target);this._legacyRequestWillBeSent=!this._target.hasEvent("Network.requestWillBeSent","walltime");}
requestWillBeSent(requestId,frameId,loaderId,documentURL,request,timestamp,walltime,initiator,redirectResponse,type,targetId)
{if(this._legacyRequestWillBeSent){walltime=undefined;initiator=arguments[6];redirectResponse=arguments[7];type=arguments[8];targetId=arguments[9];}
WI.networkManager.resourceRequestWillBeSent(requestId,frameId,loaderId,request,type,redirectResponse,timestamp,walltime,initiator,targetId);}
requestServedFromCache(requestId)
{WI.networkManager.markResourceRequestAsServedFromMemoryCache(requestId);}
responseReceived(requestId,frameId,loaderId,timestamp,type,response)
{WI.networkManager.resourceRequestDidReceiveResponse(requestId,frameId,loaderId,type,response,timestamp);}
dataReceived(requestId,timestamp,dataLength,encodedDataLength)
{WI.networkManager.resourceRequestDidReceiveData(requestId,dataLength,encodedDataLength,timestamp);}
loadingFinished(requestId,timestamp,sourceMapURL,metrics)
{WI.networkManager.resourceRequestDidFinishLoading(requestId,timestamp,sourceMapURL,metrics);}
loadingFailed(requestId,timestamp,errorText,canceled)
{WI.networkManager.resourceRequestDidFailLoading(requestId,canceled,timestamp,errorText);}
requestServedFromMemoryCache(requestId,frameId,loaderId,documentURL,timestamp,initiator,resource)
{WI.networkManager.resourceRequestWasServedFromMemoryCache(requestId,frameId,loaderId,resource,timestamp,initiator);}
webSocketCreated(requestId,url)
{WI.networkManager.webSocketCreated(requestId,url);}
webSocketWillSendHandshakeRequest(requestId,timestamp,walltime,request)
{WI.networkManager.webSocketWillSendHandshakeRequest(requestId,timestamp,walltime,request);}
webSocketHandshakeResponseReceived(requestId,timestamp,response)
{WI.networkManager.webSocketHandshakeResponseReceived(requestId,timestamp,response);}
webSocketClosed(requestId,timestamp)
{WI.networkManager.webSocketClosed(requestId,timestamp);}
webSocketFrameReceived(requestId,timestamp,response)
{WI.networkManager.webSocketFrameReceived(requestId,timestamp,response);}
webSocketFrameSent(requestId,timestamp,response)
{WI.networkManager.webSocketFrameSent(requestId,timestamp,response);}
webSocketFrameError(requestId,timestamp,errorMessage)
{}
requestIntercepted(requestId,request)
{WI.networkManager.requestIntercepted(this._target,requestId,request);}
responseIntercepted(requestId,response)
{WI.networkManager.responseIntercepted(this._target,requestId,response);}};WI.PageObserver=class PageObserver extends InspectorBackend.Dispatcher
{domContentEventFired(timestamp)
{WI.timelineManager.pageDOMContentLoadedEventFired(timestamp);}
loadEventFired(timestamp)
{WI.timelineManager.pageLoadEventFired(timestamp);}
frameNavigated(frame,loaderId)
{WI.networkManager.frameDidNavigate(frame,loaderId);}
frameDetached(frameId)
{WI.networkManager.frameDidDetach(frameId);}
defaultAppearanceDidChange(appearance)
{WI.cssManager.defaultAppearanceDidChange(appearance);}
frameStartedLoading(frameId)
{}
frameStoppedLoading(frameId)
{}
frameScheduledNavigation(frameId,delay)
{}
frameClearedScheduledNavigation(frameId)
{}};WI.RuntimeObserver=class RuntimeObserver extends InspectorBackend.Dispatcher
{executionContextCreated(contextPayload)
{WI.networkManager.executionContextCreated(contextPayload);}};WI.ScriptProfilerObserver=class ScriptProfilerObserver extends InspectorBackend.Dispatcher
{trackingStart(timestamp)
{WI.timelineManager.scriptProfilerTrackingStarted(timestamp);}
trackingUpdate(event)
{WI.timelineManager.scriptProfilerTrackingUpdated(event);}
trackingComplete(timestamp,samples)
{WI.timelineManager.scriptProfilerTrackingCompleted(timestamp,samples);}
programmaticCaptureStarted()
{}
programmaticCaptureStopped()
{}};WI.TargetObserver=class TargetObserver extends InspectorBackend.Dispatcher
{targetCreated(targetInfo)
{WI.targetManager.targetCreated(this._target,targetInfo);}
didCommitProvisionalTarget(oldTargetId,newTargetId)
{WI.targetManager.didCommitProvisionalTarget(this._target,oldTargetId,newTargetId);}
targetDestroyed(targetId)
{WI.targetManager.targetDestroyed(targetId);}
dispatchMessageFromTarget(targetId,message)
{WI.targetManager.dispatchMessageFromTarget(targetId,message);}};WI.TimelineObserver=class TimelineObserver extends InspectorBackend.Dispatcher
{eventRecorded(record)
{WI.timelineManager.eventRecorded(record);}
recordingStarted(startTime)
{WI.timelineManager.capturingStarted(startTime);}
recordingStopped(endTime)
{WI.timelineManager.capturingStopped(endTime);}
autoCaptureStarted()
{WI.timelineManager.autoCaptureStarted();}
programmaticCaptureStarted()
{}
programmaticCaptureStopped()
{}};WI.WorkerObserver=class WorkerObserver extends InspectorBackend.Dispatcher
{workerCreated(workerId,url,name)
{WI.workerManager.workerCreated(this._target,workerId,url,name);}
workerTerminated(workerId)
{WI.workerManager.workerTerminated(workerId);}
dispatchMessageFromWorker(workerId,message)
{WI.workerManager.dispatchMessageFromWorker(workerId,message);}};WI.Breakpoint=class Breakpoint extends WI.Object
{constructor({disabled,condition,actions,ignoreCount,autoContinue}={})
{super();this._disabled=disabled||false;this._condition=condition||"";this._ignoreCount=ignoreCount||0;this._autoContinue=autoContinue||false;this._actions=actions||[];for(let action of this._actions)
action.addEventListener(WI.BreakpointAction.Event.Modified,this._handleBreakpointActionModified,this);}
toJSON(key)
{let json={};if(this._disabled)
json.disabled=this._disabled;if(this.editable){if(this._condition)
json.condition=this._condition;if(this._ignoreCount)
json.ignoreCount=this._ignoreCount;if(this._actions.length)
json.actions=this._actions.map((action)=>action.toJSON());if(this._autoContinue)
json.autoContinue=this._autoContinue;}
return json;}
get displayName()
{throw WI.NotImplementedError.subclassMustOverride();}
get special()
{return false;}
get removable()
{return true;}
get editable()
{return false;}
get resolved()
{return WI.debuggerManager.breakpointsEnabled;}
get disabled()
{return this._disabled;}
set disabled(disabled)
{if(this._disabled===disabled)
return;this._disabled=disabled||false;this.dispatchEventToListeners(WI.Breakpoint.Event.DisabledStateDidChange);}
get condition()
{return this._condition;}
set condition(condition)
{if(this._condition===condition)
return;this._condition=condition;this.dispatchEventToListeners(WI.Breakpoint.Event.ConditionDidChange);}
get ignoreCount()
{return this._ignoreCount;}
set ignoreCount(ignoreCount)
{if(ignoreCount<0)
return;if(this._ignoreCount===ignoreCount)
return;this._ignoreCount=ignoreCount;this.dispatchEventToListeners(WI.Breakpoint.Event.IgnoreCountDidChange);}
get autoContinue()
{return this._autoContinue;}
set autoContinue(cont)
{if(this._autoContinue===cont)
return;this._autoContinue=cont;this.dispatchEventToListeners(WI.Breakpoint.Event.AutoContinueDidChange);}
get actions()
{return this._actions;}
get probeActions()
{return this._actions.filter(function(action){return action.type===WI.BreakpointAction.Type.Probe;});}
addAction(action,{precedingAction}={})
{action.addEventListener(WI.BreakpointAction.Event.Modified,this._handleBreakpointActionModified,this);if(!precedingAction)
this._actions.push(action);else{var index=this._actions.indexOf(precedingAction);if(index===-1)
this._actions.push(action);else
this._actions.splice(index+1,0,action);}
this.dispatchEventToListeners(WI.Breakpoint.Event.ActionsDidChange);}
removeAction(action)
{var index=this._actions.indexOf(action);if(index===-1)
return;this._actions.splice(index,1);action.removeEventListener(WI.BreakpointAction.Event.Modified,this._handleBreakpointActionModified,this);if(!this._actions.length)
this.autoContinue=false;this.dispatchEventToListeners(WI.Breakpoint.Event.ActionsDidChange);}
clearActions(type)
{if(!type)
this._actions=[];else
this._actions=this._actions.filter(function(action){return action.type!==type;});this.dispatchEventToListeners(WI.Breakpoint.Event.ActionsDidChange);}
reset()
{this.condition="";this.ignoreCount=0;this.autoContinue=false;this.clearActions();}
remove()
{}
optionsToProtocol()
{let payload={};if(this._condition)
payload.condition=this._condition;if(this._actions.length){payload.actions=this._actions.map((action)=>action.toProtocol()).filter((action)=>{if(action.type!==WI.BreakpointAction.Type.Log)
return true;if(!/\$\{.*?\}/.test(action.data))
return true;let lexer=new WI.BreakpointLogMessageLexer;let tokens=lexer.tokenize(action.data);if(!tokens)
return false;let templateLiteral=tokens.reduce((text,token)=>{if(token.type===WI.BreakpointLogMessageLexer.TokenType.PlainText)
return text+token.data.escapeCharacters("`\\");if(token.type===WI.BreakpointLogMessageLexer.TokenType.Expression)
return text+"${"+token.data+"}";return text;},"");action.data="console.log(`"+templateLiteral+"`)";action.type=WI.BreakpointAction.Type.Evaluate;return true;});}
if(this._autoContinue)
payload.autoContinue=this._autoContinue;if(this._ignoreCount)
payload.ignoreCount=this._ignoreCount;return!isEmptyObject(payload)?payload:undefined;}
_handleBreakpointActionModified(event)
{this.dispatchEventToListeners(WI.Breakpoint.Event.ActionsDidChange);}};WI.Breakpoint.TypeIdentifier="breakpoint";WI.Breakpoint.Event={DisabledStateDidChange:"breakpoint-disabled-state-did-change",ConditionDidChange:"breakpoint-condition-did-change",IgnoreCountDidChange:"breakpoint-ignore-count-did-change",ActionsDidChange:"breakpoint-actions-did-change",AutoContinueDidChange:"breakpoint-auto-continue-did-change",};WI.BreakpointAction=class BreakpointAction extends WI.Object
{constructor(type,{data,emulateUserGesture}={})
{super();this._type=type;this._data=data||null;this._id=WI.debuggerManager.nextBreakpointActionIdentifier();this._emulateUserGesture=!!emulateUserGesture;}
static supportsEmulateUserAction()
{return WI.sharedApp.isWebDebuggable()&&InspectorBackend.hasCommand("Debugger.setPauseOnExceptions","options");}
static fromJSON(json)
{return new WI.BreakpointAction(json.type,{data:json.data,emulateUserGesture:json.emulateUserGesture,});}
toJSON()
{let json={type:this._type,};if(this._data)
json.data=this._data;if(this._emulateUserGesture)
json.emulateUserGesture=this._emulateUserGesture;return json;}
get id(){return this._id;}
get type()
{return this._type;}
set type(type)
{if(type===this._type)
return;this._type=type;this.dispatchEventToListeners(WI.BreakpointAction.Event.Modified);}
get data()
{return this._data;}
set data(data)
{if(this._data===data)
return;this._data=data;this.dispatchEventToListeners(WI.BreakpointAction.Event.Modified);}
get emulateUserGesture()
{return this._emulateUserGesture;}
set emulateUserGesture(emulateUserGesture)
{if(this._emulateUserGesture===emulateUserGesture)
return;this._emulateUserGesture=emulateUserGesture;this.dispatchEventToListeners(WI.BreakpointAction.Event.Modified);}
toProtocol()
{let json=this.toJSON();json.id=this._id;return json;}};WI.BreakpointAction.Type={Log:"log",Evaluate:"evaluate",Sound:"sound",Probe:"probe"};WI.BreakpointAction.Event={Modified:"breakpoint-action-modified",};WI.Collection=class Collection extends WI.Object
{constructor(items=[])
{super();this._items=new Set;for(let item of items)
this.add(item);}
get size()
{return this._items.size;}
get displayName()
{throw WI.NotImplementedError.subclassMustOverride();}
objectIsRequiredType(object)
{throw WI.NotImplementedError.subclassMustOverride();}
add(item)
{let isValidType=this.objectIsRequiredType(item);if(!isValidType)
return;this._items.add(item);this.itemAdded(item);this.dispatchEventToListeners(WI.Collection.Event.ItemAdded,{item});}
remove(item)
{let wasRemoved=this._items.delete(item);this.itemRemoved(item);this.dispatchEventToListeners(WI.Collection.Event.ItemRemoved,{item});}
has(...args)
{return this._items.has(...args);}
clear()
{let items=new Set(this._items);this._items.clear();this.itemsCleared(items);for(let item of items)
this.dispatchEventToListeners(WI.Collection.Event.ItemRemoved,{item});}
toJSON()
{return Array.from(this);}
[Symbol.iterator]()
{return this._items[Symbol.iterator]();}
itemAdded(item)
{}
itemRemoved(item)
{}
itemsCleared(items)
{}};WI.Collection.Event={ItemAdded:"collection-item-added",ItemRemoved:"collection-item-removed",};WI.ConsoleMessage=class ConsoleMessage
{constructor(target,source,level,message,type,url,line,column,repeatCount,parameters,callFrames,request,timestamp)
{this._target=target;this._source=source;this._level=level;this._messageText=message;this._type=type||WI.ConsoleMessage.MessageType.Log;this._url=url||null;this._line=line||0;this._column=column||0;this._sourceCodeLocation=undefined;this._repeatCount=repeatCount||0;this._parameters=parameters;callFrames=callFrames||[];this._stackTrace=WI.StackTrace.fromPayload(this._target,{callFrames});this._request=request;this._timestamp=timestamp??NaN;}
get target(){return this._target;}
get source(){return this._source;}
get level(){return this._level;}
get messageText(){return this._messageText;}
get type(){return this._type;}
get url(){return this._url;}
get line(){return this._line;}
get column(){return this._column;}
get repeatCount(){return this._repeatCount;}
get parameters(){return this._parameters;}
get stackTrace(){return this._stackTrace;}
get request(){return this._request;}
get timestamp(){return this._timestamp;}
get sourceCodeLocation()
{if(this._sourceCodeLocation!==undefined)
return this._sourceCodeLocation;let topCallFrame=this._stackTrace.callFrames[0];if(topCallFrame&&topCallFrame.sourceCodeLocation){this._sourceCodeLocation=topCallFrame.sourceCodeLocation;return this._sourceCodeLocation;}
if(this._url&&this._url!=="undefined"){let sourceCode=WI.networkManager.resourcesForURL(this._url).firstValue;if(sourceCode){let lineNumber=this._line>0?this._line-1:0;let columnNumber=this._column>0?this._column-1:0;this._sourceCodeLocation=new WI.SourceCodeLocation(sourceCode,lineNumber,columnNumber);return this._sourceCodeLocation;}}
this._sourceCodeLocation=null;return this._sourceCodeLocation;}};WI.ConsoleMessage.MessageSource={HTML:"html",XML:"xml",JS:"javascript",Network:"network",ConsoleAPI:"console-api",Storage:"storage",Appcache:"appcache",Rendering:"rendering",CSS:"css",Security:"security",Media:"media",MediaSource:"mediasource",WebRTC:"webrtc",ITPDebug:"itp-debug",PrivateClickMeasurement:"private-click-measurement",PaymentRequest:"payment-request",Other:"other",AdClickAttribution:"ad-click-attribution",};WI.ConsoleMessage.MessageType={Log:"log",Dir:"dir",DirXML:"dirxml",Table:"table",Trace:"trace",StartGroup:"startGroup",StartGroupCollapsed:"startGroupCollapsed",EndGroup:"endGroup",Assert:"assert",Timing:"timing",Profile:"profile",ProfileEnd:"profileEnd",Image:"image",Result:"result",};WI.ConsoleMessage.MessageLevel={Log:"log",Info:"info",Warning:"warning",Error:"error",Debug:"debug",};WI.Instrument=class Instrument
{static createForTimelineType(type)
{switch(type){case WI.TimelineRecord.Type.Network:return new WI.NetworkInstrument;case WI.TimelineRecord.Type.Layout:return new WI.LayoutInstrument;case WI.TimelineRecord.Type.Script:return new WI.ScriptInstrument;case WI.TimelineRecord.Type.RenderingFrame:return new WI.FPSInstrument;case WI.TimelineRecord.Type.CPU:return new WI.CPUInstrument;case WI.TimelineRecord.Type.Memory:return new WI.MemoryInstrument;case WI.TimelineRecord.Type.HeapAllocations:return new WI.HeapAllocationsInstrument;case WI.TimelineRecord.Type.Media:return new WI.MediaInstrument;case WI.TimelineRecord.Type.Screenshots:return new WI.ScreenshotsInstrument;default:console.error("Unknown TimelineRecord.Type: "+type);return null;}}
static startLegacyTimelineAgent(initiatedByBackend)
{if(WI.Instrument._legacyTimelineAgentStarted)
return;WI.Instrument._legacyTimelineAgentStarted=true;if(initiatedByBackend)
return;let target=WI.assumingMainTarget();target.TimelineAgent.start();}
static stopLegacyTimelineAgent(initiatedByBackend)
{if(!WI.Instrument._legacyTimelineAgentStarted)
return;WI.Instrument._legacyTimelineAgentStarted=false;if(initiatedByBackend)
return;let target=WI.assumingMainTarget();target.TimelineAgent.stop();}
get timelineRecordType()
{return null;}
startInstrumentation(initiatedByBackend)
{WI.Instrument.startLegacyTimelineAgent(initiatedByBackend);}
stopInstrumentation(initiatedByBackend)
{WI.Instrument.stopLegacyTimelineAgent(initiatedByBackend);}};WI.Instrument._legacyTimelineAgentStarted=false;WI.SourceCode=class SourceCode extends WI.Object
{constructor(url)
{super();this._url=url;this._urlComponents=null;this._originalRevision=new WI.SourceCodeRevision(this);this._currentRevision=this._originalRevision;this._sourceMaps=null;this._formatterSourceMap=null;this._requestContentPromise=null;}
static generateSpecialContentForURL(url)
{if(url==="about:blank"){return Promise.resolve({content:"",message:WI.unlocalizedString("about:blank")});}
return null;}
get displayName()
{console.error("Needs to be implemented by a subclass.");return"";}
get originalRevision()
{return this._originalRevision;}
get currentRevision()
{return this._currentRevision;}
set currentRevision(revision)
{if(!(revision instanceof WI.SourceCodeRevision))
return;if(revision.sourceCode!==this)
return;this._currentRevision=revision;this.dispatchEventToListeners(WI.SourceCode.Event.ContentDidChange);}
get editableRevision()
{if(this._currentRevision===this._originalRevision)
this._currentRevision=this._originalRevision.copy();return this._currentRevision;}
get content()
{return this._currentRevision.content;}
get base64Encoded()
{return this._currentRevision.base64Encoded;}
get url()
{return this._url;}
get urlComponents()
{if(!this._urlComponents)
this._urlComponents=parseURL(this._url);return this._urlComponents;}
get contentIdentifier()
{return this.url;}
get isScript()
{return false;}
get supportsScriptBlackboxing()
{if(!this.isScript)
return false;if(!WI.DebuggerManager.supportsBlackboxingScripts())
return false;let contentIdentifier=this.contentIdentifier;return contentIdentifier&&!isWebKitInjectedScript(contentIdentifier);}
get localResourceOverride()
{return null;}
get sourceMaps()
{return this._sourceMaps||[];}
addSourceMap(sourceMap)
{if(!this._sourceMaps)
this._sourceMaps=[];this._sourceMaps.push(sourceMap);this.dispatchEventToListeners(WI.SourceCode.Event.SourceMapAdded);}
get formatterSourceMap()
{return this._formatterSourceMap;}
set formatterSourceMap(formatterSourceMap)
{this._formatterSourceMap=formatterSourceMap;this.dispatchEventToListeners(WI.SourceCode.Event.FormatterDidChange);}
requestContent()
{this._requestContentPromise=this._requestContentPromise||this.requestContentFromBackend().then(this._processContent.bind(this));return this._requestContentPromise;}
createSourceCodeLocation(lineNumber,columnNumber)
{return new WI.SourceCodeLocation(this,lineNumber,columnNumber);}
createLazySourceCodeLocation(lineNumber,columnNumber)
{return new WI.LazySourceCodeLocation(this,lineNumber,columnNumber);}
createSourceCodeTextRange(textRange)
{return new WI.SourceCodeTextRange(this,textRange);}
revisionContentDidChange(revision)
{if(this._ignoreRevisionContentDidChangeEvent)
return;if(revision!==this._currentRevision)
return;this.handleCurrentRevisionContentChange();this.dispatchEventToListeners(WI.SourceCode.Event.ContentDidChange);}
handleCurrentRevisionContentChange()
{}
get revisionForRequestedContent()
{return this._originalRevision;}
markContentAsStale()
{this._requestContentPromise=null;this._contentReceived=false;}
requestContentFromBackend()
{console.error("Needs to be implemented by a subclass.");return Promise.reject(new Error("Needs to be implemented by a subclass."));}
get mimeType()
{console.error("Needs to be implemented by a subclass.");}
_processContent(parameters)
{let rawContent=parameters.content||parameters.body||parameters.text||parameters.scriptSource;let rawBase64Encoded=!!parameters.base64Encoded;let content=rawContent;let error=parameters.error;let message=parameters.message;if(parameters.base64Encoded)
content=content?WI.BlobUtilities.decodeBase64ToBlob(content,this.mimeType):"";let revision=this.revisionForRequestedContent;this._ignoreRevisionContentDidChangeEvent=true;revision.updateRevisionContent(rawContent,{base64Encoded:rawBase64Encoded,mimeType:this.mimeType,blobContent:content instanceof Blob?content:null,});this._ignoreRevisionContentDidChangeEvent=false;return Promise.resolve({error,message,sourceCode:this,content,rawContent,rawBase64Encoded,});}};WI.SourceCode.Event={ContentDidChange:"source-code-content-did-change",SourceMapAdded:"source-code-source-map-added",FormatterDidChange:"source-code-formatter-did-change",LoadingDidFinish:"source-code-loading-did-finish",LoadingDidFail:"source-code-loading-did-fail"};WI.SourceCodeLocation=class SourceCodeLocation extends WI.Object
{constructor(sourceCode,lineNumber,columnNumber)
{super();this._sourceCode=sourceCode||null;this._lineNumber=lineNumber;this._columnNumber=columnNumber;this._resolveFormattedLocation();if(this._sourceCode){this._sourceCode.addEventListener(WI.SourceCode.Event.SourceMapAdded,this._sourceCodeSourceMapAdded,this);this._sourceCode.addEventListener(WI.SourceCode.Event.FormatterDidChange,this._sourceCodeFormatterDidChange,this);}
this._resetMappedLocation();}
static get specialBreakpointLocation()
{return new WI.SourceCodeLocation(null,Infinity,Infinity);}
isEqual(other)
{if(!other)
return false;return this._sourceCode===other._sourceCode&&this._lineNumber===other._lineNumber&&this._columnNumber===other._columnNumber;}
get sourceCode()
{return this._sourceCode;}
set sourceCode(sourceCode)
{this.setSourceCode(sourceCode);}
get lineNumber()
{return this._lineNumber;}
get columnNumber()
{return this._columnNumber;}
position()
{return new WI.SourceCodePosition(this.lineNumber,this.columnNumber);}
get formattedLineNumber()
{return this._formattedLineNumber;}
get formattedColumnNumber()
{return this._formattedColumnNumber;}
formattedPosition()
{return new WI.SourceCodePosition(this.formattedLineNumber,this.formattedColumnNumber);}
get displaySourceCode()
{this.resolveMappedLocation();return this._mappedResource||this._sourceCode;}
get displayLineNumber()
{this.resolveMappedLocation();return isNaN(this._mappedLineNumber)?this._formattedLineNumber:this._mappedLineNumber;}
get displayColumnNumber()
{this.resolveMappedLocation();return isNaN(this._mappedColumnNumber)?this._formattedColumnNumber:this._mappedColumnNumber;}
displayPosition()
{return new WI.SourceCodePosition(this.displayLineNumber,this.displayColumnNumber);}
originalLocationString(columnStyle,nameStyle,prefix)
{return this._locationString(this.sourceCode,this.lineNumber,this.columnNumber,columnStyle,nameStyle,prefix);}
formattedLocationString(columnStyle,nameStyle,prefix)
{return this._locationString(this.sourceCode,this.formattedLineNumber,this.formattedColumn,columnStyle,nameStyle,prefix);}
displayLocationString(columnStyle,nameStyle,prefix)
{return this._locationString(this.displaySourceCode,this.displayLineNumber,this.displayColumnNumber,columnStyle,nameStyle,prefix);}
tooltipString()
{if(!this.hasDifferentDisplayLocation())
return this.originalLocationString(WI.SourceCodeLocation.ColumnStyle.Shown,WI.SourceCodeLocation.NameStyle.Full);var tooltip=WI.UIString("Located at %s").format(this.displayLocationString(WI.SourceCodeLocation.ColumnStyle.Shown,WI.SourceCodeLocation.NameStyle.Full));tooltip+="\n"+WI.UIString("Originally %s").format(this.originalLocationString(WI.SourceCodeLocation.ColumnStyle.Shown,WI.SourceCodeLocation.NameStyle.Full));return tooltip;}
hasMappedLocation()
{this.resolveMappedLocation();return this._mappedResource!==null;}
hasFormattedLocation()
{return this._formattedLineNumber!==this._lineNumber||this._formattedColumnNumber!==this._columnNumber;}
hasDifferentDisplayLocation()
{return this.hasMappedLocation()||this.hasFormattedLocation();}
update(sourceCode,lineNumber,columnNumber)
{if(sourceCode===this._sourceCode&&lineNumber===this._lineNumber&&columnNumber===this._columnNumber)
return;if(this._mappedResource&&sourceCode===this._mappedResource&&lineNumber===this._mappedLineNumber&&columnNumber===this._mappedColumnNumber)
return;var newSourceCodeLocation=sourceCode.createSourceCodeLocation(lineNumber,columnNumber);this._makeChangeAndDispatchChangeEventIfNeeded(function(){this._lineNumber=newSourceCodeLocation._lineNumber;this._columnNumber=newSourceCodeLocation._columnNumber;if(newSourceCodeLocation._mappedLocationIsResolved){this._mappedLocationIsResolved=true;this._mappedResource=newSourceCodeLocation._mappedResource;this._mappedLineNumber=newSourceCodeLocation._mappedLineNumber;this._mappedColumnNumber=newSourceCodeLocation._mappedColumnNumber;}});}
populateLiveDisplayLocationTooltip(element,prefix,suffix)
{prefix=prefix||"";suffix=suffix||"";element.title=prefix+this.tooltipString()+suffix;this.addEventListener(WI.SourceCodeLocation.Event.DisplayLocationChanged,function(event){if(this.sourceCode)
element.title=prefix+this.tooltipString()+suffix;},this);}
populateLiveDisplayLocationString(element,propertyName,columnStyle,nameStyle,prefix)
{var currentDisplay;function updateDisplayString(showAlternativeLocation,forceUpdate)
{if(!forceUpdate&&currentDisplay===showAlternativeLocation)
return;currentDisplay=showAlternativeLocation;if(!showAlternativeLocation){element[propertyName]=this.displayLocationString(columnStyle,nameStyle,prefix);element.classList.toggle(WI.SourceCodeLocation.DisplayLocationClassName,this.hasDifferentDisplayLocation());}else if(this.hasDifferentDisplayLocation()){element[propertyName]=this.originalLocationString(columnStyle,nameStyle,prefix);element.classList.remove(WI.SourceCodeLocation.DisplayLocationClassName);}}
function mouseOverOrMove(event)
{updateDisplayString.call(this,event.metaKey&&!event.altKey&&!event.shiftKey);}
updateDisplayString.call(this,false);this.addEventListener(WI.SourceCodeLocation.Event.DisplayLocationChanged,function(event){if(this.sourceCode)
updateDisplayString.call(this,currentDisplay,true);},this);var boundMouseOverOrMove=mouseOverOrMove.bind(this);element.addEventListener("mouseover",boundMouseOverOrMove);element.addEventListener("mousemove",boundMouseOverOrMove);element.addEventListener("mouseout",(event)=>{updateDisplayString.call(this,false);});}
setSourceCode(sourceCode)
{if(sourceCode===this._sourceCode)
return;this._makeChangeAndDispatchChangeEventIfNeeded(function(){if(this._sourceCode){this._sourceCode.removeEventListener(WI.SourceCode.Event.SourceMapAdded,this._sourceCodeSourceMapAdded,this);this._sourceCode.removeEventListener(WI.SourceCode.Event.FormatterDidChange,this._sourceCodeFormatterDidChange,this);}
this._sourceCode=sourceCode;if(this._sourceCode){this._sourceCode.addEventListener(WI.SourceCode.Event.SourceMapAdded,this._sourceCodeSourceMapAdded,this);this._sourceCode.addEventListener(WI.SourceCode.Event.FormatterDidChange,this._sourceCodeFormatterDidChange,this);}});}
resolveMappedLocation()
{if(this._mappedLocationIsResolved)
return;this._mappedLocationIsResolved=true;if(!this._sourceCode)
return;var sourceMaps=this._sourceCode.sourceMaps;if(!sourceMaps.length)
return;for(var i=0;i<sourceMaps.length;++i){var sourceMap=sourceMaps[i];var entry=sourceMap.findEntry(this._lineNumber,this._columnNumber);if(!entry||entry.length===2)
continue;var url=entry[2];var sourceMapResource=sourceMap.resourceForURL(url);if(!sourceMapResource)
return;this._mappedResource=sourceMapResource;this._mappedLineNumber=entry[3];this._mappedColumnNumber=entry[4];return;}}
_locationString(sourceCode,lineNumber,columnNumber,columnStyle,nameStyle,prefix)
{if(!sourceCode)
return"";columnStyle=columnStyle||WI.SourceCodeLocation.ColumnStyle.OnlyIfLarge;nameStyle=nameStyle||WI.SourceCodeLocation.NameStyle.Short;prefix=prefix||"";let lineString=lineNumber+1;if(columnStyle===WI.SourceCodeLocation.ColumnStyle.Shown&&columnNumber>0)
lineString+=":"+(columnNumber+1);else if(columnStyle===WI.SourceCodeLocation.ColumnStyle.OnlyIfLarge&&columnNumber>WI.SourceCodeLocation.LargeColumnNumber)
lineString+=":"+(columnNumber+1);else if(columnStyle===WI.SourceCodeLocation.ColumnStyle.Hidden)
lineString="";switch(nameStyle){case WI.SourceCodeLocation.NameStyle.None:return prefix+lineString;case WI.SourceCodeLocation.NameStyle.Short:case WI.SourceCodeLocation.NameStyle.Full:var displayURL=sourceCode.displayURL;var name=nameStyle===WI.SourceCodeLocation.NameStyle.Full&&displayURL?displayURL:sourceCode.displayName;if(columnStyle===WI.SourceCodeLocation.ColumnStyle.Hidden)
return prefix+name;var lineSuffix=displayURL?":"+lineString:WI.UIString(" (line %s)").format(lineString);return prefix+name+lineSuffix;default:console.error("Unknown nameStyle: "+nameStyle);return prefix+lineString;}}
_resetMappedLocation()
{this._mappedLocationIsResolved=false;this._mappedResource=null;this._mappedLineNumber=NaN;this._mappedColumnNumber=NaN;}
_setMappedLocation(mappedResource,mappedLineNumber,mappedColumnNumber)
{this._mappedLocationIsResolved=true;this._mappedResource=mappedResource;this._mappedLineNumber=mappedLineNumber;this._mappedColumnNumber=mappedColumnNumber;}
_resolveFormattedLocation()
{if(this._sourceCode&&this._sourceCode.formatterSourceMap){var formattedLocation=this._sourceCode.formatterSourceMap.originalToFormatted(this._lineNumber,this._columnNumber);this._formattedLineNumber=formattedLocation.lineNumber;this._formattedColumnNumber=formattedLocation.columnNumber;}else{this._formattedLineNumber=this._lineNumber;this._formattedColumnNumber=this._columnNumber;}}
_makeChangeAndDispatchChangeEventIfNeeded(changeFunction)
{var oldSourceCode=this._sourceCode;var oldLineNumber=this._lineNumber;var oldColumnNumber=this._columnNumber;var oldFormattedLineNumber=this._formattedLineNumber;var oldFormattedColumnNumber=this._formattedColumnNumber;var oldDisplaySourceCode=this.displaySourceCode;var oldDisplayLineNumber=this.displayLineNumber;var oldDisplayColumnNumber=this.displayColumnNumber;this._resetMappedLocation();if(changeFunction)
changeFunction.call(this);this.resolveMappedLocation();this._resolveFormattedLocation();var displayLocationChanged=false;var newDisplaySourceCode=this.displaySourceCode;if(oldDisplaySourceCode!==newDisplaySourceCode)
displayLocationChanged=true;else if(newDisplaySourceCode&&(oldDisplayLineNumber!==this.displayLineNumber||oldDisplayColumnNumber!==this.displayColumnNumber))
displayLocationChanged=true;var anyLocationChanged=false;if(displayLocationChanged)
anyLocationChanged=true;else if(oldSourceCode!==this._sourceCode)
anyLocationChanged=true;else if(this._sourceCode&&(oldLineNumber!==this._lineNumber||oldColumnNumber!==this._columnNumber))
anyLocationChanged=true;else if(this._sourceCode&&(oldFormattedLineNumber!==this._formattedLineNumber||oldFormattedColumnNumber!==this._formattedColumnNumber))
anyLocationChanged=true;if(displayLocationChanged||anyLocationChanged){var oldData={oldSourceCode,oldLineNumber,oldColumnNumber,oldFormattedLineNumber,oldFormattedColumnNumber,oldDisplaySourceCode,oldDisplayLineNumber,oldDisplayColumnNumber};if(displayLocationChanged)
this.dispatchEventToListeners(WI.SourceCodeLocation.Event.DisplayLocationChanged,oldData);if(anyLocationChanged)
this.dispatchEventToListeners(WI.SourceCodeLocation.Event.LocationChanged,oldData);}}
_sourceCodeSourceMapAdded()
{this._makeChangeAndDispatchChangeEventIfNeeded(null);}
_sourceCodeFormatterDidChange()
{this._makeChangeAndDispatchChangeEventIfNeeded(null);}};WI.SourceCodeLocation.DisplayLocationClassName="display-location";WI.SourceCodeLocation.LargeColumnNumber=80;WI.SourceCodeLocation.NameStyle={None:"none",Short:"short",Full:"full"};WI.SourceCodeLocation.ColumnStyle={Hidden:"hidden",OnlyIfLarge:"only-if-large",Shown:"shown"};WI.SourceCodeLocation.Event={LocationChanged:"source-code-location-location-changed",DisplayLocationChanged:"source-code-location-display-location-changed"};WI.Timeline=class Timeline extends WI.Object
{constructor(type)
{super();this._type=type;this.reset(true);}
static create(type)
{if(type===WI.TimelineRecord.Type.Network)
return new WI.NetworkTimeline(type);if(type===WI.TimelineRecord.Type.CPU)
return new WI.CPUTimeline(type);if(type===WI.TimelineRecord.Type.Memory)
return new WI.MemoryTimeline(type);if(type===WI.TimelineRecord.Type.Media)
return new WI.MediaTimeline(type);return new WI.Timeline(type);}
get type(){return this._type;}
get startTime(){return this._startTime;}
get endTime(){return this._endTime;}
get records(){return this._records;}
reset(suppressEvents)
{this._records=[];this._startTime=NaN;this._endTime=NaN;if(!suppressEvents){this.dispatchEventToListeners(WI.Timeline.Event.TimesUpdated);this.dispatchEventToListeners(WI.Timeline.Event.Reset);}}
addRecord(record,options={})
{if(record.updatesDynamically)
record.addEventListener(WI.TimelineRecord.Event.Updated,this._recordUpdated,this);this._tryInsertingRecordInSortedOrder(record);this._updateTimesIfNeeded(record);this.dispatchEventToListeners(WI.Timeline.Event.RecordAdded,{record});}
saveIdentityToCookie(cookie)
{cookie[WI.Timeline.TimelineTypeCookieKey]=this._type;}
refresh()
{this.dispatchEventToListeners(WI.Timeline.Event.Refreshed);}
closestRecordTo(timestamp)
{let lowerIndex=this._records.lowerBound(timestamp,(time,record)=>time-record.endTime);let recordBefore=this._records[lowerIndex-1];let recordAfter=this._records[lowerIndex];if(!recordBefore&&!recordAfter)
return null;if(!recordBefore&&recordAfter)
return recordAfter;if(!recordAfter&&recordBefore)
return recordBefore;let before=Math.abs(recordBefore.endTime-timestamp);let after=Math.abs(recordAfter.startTime-timestamp);return(before<after)?recordBefore:recordAfter;}
recordsInTimeRange(startTime,endTime,{includeRecordBeforeStart,includeRecordAfterEnd}={})
{let lowerIndex=this._records.lowerBound(startTime,(time,record)=>time-record.endTime);if(includeRecordBeforeStart&&lowerIndex>0){lowerIndex--;let recordBefore=this._records[lowerIndex];if(recordBefore.parent&&recordBefore.parent.type===recordBefore.type){lowerIndex--;while(this._records[lowerIndex]!==recordBefore.parent)
lowerIndex--;}}
let upperIndex=this._records.upperBound(endTime,(time,record)=>time-record.startTime);if(includeRecordAfterEnd&&upperIndex<this._records.length)
++upperIndex;return this._records.slice(lowerIndex,upperIndex);}
_updateTimesIfNeeded(record)
{let changed=false;let recordStartTime=record.unadjustedStartTime;let recordEndTime=record.unadjustedEndTime;if(isNaN(this._startTime)||recordStartTime<this._startTime){this._startTime=recordStartTime;changed=true;}
if(isNaN(this._endTime)||this._endTime<recordEndTime){this._endTime=recordEndTime;changed=true;}
if(changed)
this.dispatchEventToListeners(WI.Timeline.Event.TimesUpdated);}
_recordUpdated(event)
{this._updateTimesIfNeeded(event.target);}
_tryInsertingRecordInSortedOrder(record)
{let lastValue=this._records.lastValue;if(!lastValue||lastValue.startTime<record.startTime||record.updatesDynamically){this._records.push(record);return;}
let start=this._records.length-2;let end=Math.max(this._records.length-20,0);for(let i=start;i>=end;--i){if(this._records[i].startTime<record.startTime){this._records.insertAtIndex(record,i+1);return;}}
this._records.push(record);}};WI.Timeline.Event={Reset:"timeline-reset",RecordAdded:"timeline-record-added",TimesUpdated:"timeline-times-updated",Refreshed:"timeline-refreshed",};WI.Timeline.TimelineTypeCookieKey="timeline-type";WI.TimelineRange=class TimelineRange
{constructor(startValue,endValue)
{this._startValue=startValue;this._endValue=endValue;}
get startValue(){return this._startValue;}
set startValue(x){this._startValue=x;}
get endValue(){return this._endValue;}
set endValue(x){this._endValue=x;}};WI.TimelineRecord=class TimelineRecord extends WI.Object
{constructor(type,startTime,endTime,callFrames,sourceCodeLocation)
{super();if(type in WI.TimelineRecord.Type)
type=WI.TimelineRecord.Type[type];this._type=type;this._startTime=startTime||NaN;this._endTime=endTime||NaN;this._callFrames=callFrames||null;this._sourceCodeLocation=sourceCodeLocation||null;this._children=[];}
static async fromJSON(json)
{switch(json.type){case WI.TimelineRecord.Type.Network:return WI.ResourceTimelineRecord.fromJSON(json);case WI.TimelineRecord.Type.Layout:return WI.LayoutTimelineRecord.fromJSON(json);case WI.TimelineRecord.Type.Script:return WI.ScriptTimelineRecord.fromJSON(json);case WI.TimelineRecord.Type.RenderingFrame:return WI.RenderingFrameTimelineRecord.fromJSON(json);case WI.TimelineRecord.Type.CPU:return WI.CPUTimelineRecord.fromJSON(json);case WI.TimelineRecord.Type.Memory:return WI.MemoryTimelineRecord.fromJSON(json);case WI.TimelineRecord.Type.HeapAllocations:return WI.HeapAllocationsTimelineRecord.fromJSON(json);case WI.TimelineRecord.Type.Media:return WI.MediaTimelineRecord.fromJSON(json);case WI.TimelineRecord.Type.Screenshots:return WI.ScreenshotsTimelineRecord.fromJSON(json);default:console.error("Unknown TimelineRecord.Type: "+json.type,json);return null;}}
toJSON()
{throw WI.NotImplementedError.subclassMustOverride();}
get type()
{return this._type;}
get startTime()
{return this._startTime;}
get activeStartTime()
{return this.startTime;}
get unadjustedStartTime()
{return this.startTime;}
get endTime()
{return this._endTime;}
get unadjustedEndTime()
{return this.endTime;}
get duration()
{return this.endTime-this.startTime;}
get inactiveDuration()
{return this.activeStartTime-this.startTime;}
get activeDuration()
{return this.endTime-this.activeStartTime;}
get updatesDynamically()
{return false;}
get usesActiveStartTime()
{return false;}
get callFrames()
{return this._callFrames;}
get initiatorCallFrame()
{if(!this._callFrames||!this._callFrames.length)
return null;for(let frame of this._callFrames){if(!frame.nativeCode)
return frame;}
return null;}
get sourceCodeLocation()
{return this._sourceCodeLocation;}
get parent()
{return this._parent;}
set parent(x)
{if(this._parent===x)
return;this._parent=x;}
get children()
{return this._children;}
saveIdentityToCookie(cookie)
{cookie[WI.TimelineRecord.SourceCodeURLCookieKey]=this._sourceCodeLocation?this._sourceCodeLocation.sourceCode.url?this._sourceCodeLocation.sourceCode.url.hash:null:null;cookie[WI.TimelineRecord.SourceCodeLocationLineCookieKey]=this._sourceCodeLocation?this._sourceCodeLocation.lineNumber:null;cookie[WI.TimelineRecord.SourceCodeLocationColumnCookieKey]=this._sourceCodeLocation?this._sourceCodeLocation.columnNumber:null;cookie[WI.TimelineRecord.TypeCookieKey]=this._type||null;}};WI.TimelineRecord.Event={Updated:"timeline-record-updated"};WI.TimelineRecord.Type={Network:"timeline-record-type-network",Layout:"timeline-record-type-layout",Script:"timeline-record-type-script",RenderingFrame:"timeline-record-type-rendering-frame",CPU:"timeline-record-type-cpu",Memory:"timeline-record-type-memory",HeapAllocations:"timeline-record-type-heap-allocations",Media:"timeline-record-type-media",Screenshots:"timeline-record-type-screenshots",};WI.TimelineRecord.TypeIdentifier="timeline-record";WI.TimelineRecord.SourceCodeURLCookieKey="timeline-record-source-code-url";WI.TimelineRecord.SourceCodeLocationLineCookieKey="timeline-record-source-code-location-line";WI.TimelineRecord.SourceCodeLocationColumnCookieKey="timeline-record-source-code-location-column";WI.TimelineRecord.TypeCookieKey="timeline-record-type";WI.Resource=class Resource extends WI.SourceCode
{constructor(url,{mimeType,type,loaderIdentifier,targetId,requestIdentifier,requestMethod,requestHeaders,requestData,requestSentTimestamp,requestSentWalltime,referrerPolicy,integrity,initiatorCallFrames,initiatorSourceCodeLocation,initiatorNode}={})
{super(url);if(type in WI.Resource.Type)
type=WI.Resource.Type[type];else if(type==="Stylesheet"){type=WI.Resource.Type.StyleSheet;}
this._mimeType=mimeType;this._mimeTypeComponents=null;this._type=Resource.resolvedType(type,mimeType);this._loaderIdentifier=loaderIdentifier||null;this._requestIdentifier=requestIdentifier||null;this._queryStringParameters=undefined;this._requestFormParameters=undefined;this._requestMethod=requestMethod||null;this._requestData=requestData||null;this._requestHeaders=requestHeaders||{};this._responseHeaders={};this._requestCookies=null;this._responseCookies=null;this._serverTimingEntries=null;this._parentFrame=null;this._initiatorCallFrames=initiatorCallFrames||null;this._initiatorSourceCodeLocation=initiatorSourceCodeLocation||null;this._initiatorNode=initiatorNode||null;this._initiatedResources=[];this._requestSentTimestamp=requestSentTimestamp||NaN;this._requestSentWalltime=requestSentWalltime||NaN;this._responseReceivedTimestamp=NaN;this._lastDataReceivedTimestamp=NaN;this._finishedOrFailedTimestamp=NaN;this._finishThenRequestContentPromise=null;this._statusCode=NaN;this._statusText=null;this._cached=false;this._canceled=false;this._finished=false;this._failed=false;this._failureReasonText=null;this._receivedNetworkLoadMetrics=false;this._responseSource=WI.Resource.ResponseSource.Unknown;this._security=null;this._timingData=new WI.ResourceTimingData(this);this._protocol=null;this._priority=WI.Resource.NetworkPriority.Unknown;this._remoteAddress=null;this._connectionIdentifier=null;this._isProxyConnection=false;this._target=targetId?WI.targetManager.targetForIdentifier(targetId):WI.mainTarget;this._redirects=[];this._referrerPolicy=referrerPolicy??null;this._integrity=integrity??null;this._requestHeadersTransferSize=NaN;this._requestBodyTransferSize=NaN;this._responseHeadersTransferSize=NaN;this._responseBodyTransferSize=NaN;this._responseBodySize=NaN;this._cachedResponseBodySize=NaN;this._estimatedSize=NaN;this._estimatedTransferSize=NaN;this._estimatedResponseHeadersSize=NaN;if(this._initiatorSourceCodeLocation&&this._initiatorSourceCodeLocation.sourceCode instanceof WI.Resource)
this._initiatorSourceCodeLocation.sourceCode.addInitiatedResource(this);}
static resolvedType(type,mimeType)
{if(type&&type!==WI.Resource.Type.Other)
return type;return Resource.typeFromMIMEType(mimeType);}
static typeFromMIMEType(mimeType)
{if(!mimeType)
return WI.Resource.Type.Other;mimeType=parseMIMEType(mimeType).type;if(mimeType in WI.Resource._mimeTypeMap)
return WI.Resource._mimeTypeMap[mimeType];if(mimeType.startsWith("image/"))
return WI.Resource.Type.Image;if(mimeType.startsWith("font/"))
return WI.Resource.Type.Font;return WI.Resource.Type.Other;}
static displayNameForType(type,plural)
{switch(type){case WI.Resource.Type.Document:if(plural)
return WI.UIString("Documents");return WI.UIString("Document");case WI.Resource.Type.StyleSheet:if(plural)
return WI.UIString("Style Sheets");return WI.UIString("Style Sheet");case WI.Resource.Type.Image:if(plural)
return WI.UIString("Images");return WI.UIString("Image");case WI.Resource.Type.Font:if(plural)
return WI.UIString("Fonts");return WI.UIString("Font");case WI.Resource.Type.Script:if(plural)
return WI.UIString("Scripts");return WI.UIString("Script");case WI.Resource.Type.XHR:if(plural)
return WI.UIString("XHRs");return WI.UIString("XHR");case WI.Resource.Type.Fetch:if(plural)
return WI.UIString("Fetches","Resources loaded via 'fetch' method");return WI.repeatedUIString.fetch();case WI.Resource.Type.Ping:if(plural)
return WI.UIString("Pings");return WI.UIString("Ping");case WI.Resource.Type.Beacon:if(plural)
return WI.UIString("Beacons");return WI.UIString("Beacon");case WI.Resource.Type.WebSocket:if(plural)
return WI.UIString("Sockets");return WI.UIString("Socket");case WI.Resource.Type.EventSource:if(plural)
return WI.UIString("EventSources","Display name for the type of network requests sent via EventSource(s) API (https://developer.mozilla.org/en-US/docs/Web/API/EventSource)");return WI.UIString("EventSource","Display name for the type of network requests sent via EventSource API (https://developer.mozilla.org/en-US/docs/Web/API/EventSource)");case WI.Resource.Type.Other:return WI.UIString("Other");default:console.error("Unknown resource type",type);return null;}}
static classNamesForResource(resource)
{let classes=[];let localResourceOverride=resource.localResourceOverride||WI.networkManager.localResourceOverridesForURL(resource.url).filter((localResourceOverride)=>!localResourceOverride.disabled)[0];let isOverride=!!resource.localResourceOverride;let wasOverridden=resource.responseSource===WI.Resource.ResponseSource.InspectorOverride;let shouldBeOverridden=resource.isLoading()&&localResourceOverride;let shouldBeBlocked=(resource.failed||isOverride)&&localResourceOverride?.type===WI.LocalResourceOverride.InterceptType.Block;if(isOverride||wasOverridden||shouldBeOverridden||shouldBeBlocked){classes.push("override");if(shouldBeBlocked||localResourceOverride?.type===WI.LocalResourceOverride.InterceptType.ResponseSkippingNetwork)
classes.push("skip-network");}
if(resource.type===WI.Resource.Type.Other){if(resource.requestedByteRange)
classes.push("resource-type-range");}else
classes.push(resource.type);return classes;}
static displayNameForProtocol(protocol)
{switch(protocol){case"h2":return"HTTP/2";case"http/1.0":return"HTTP/1.0";case"http/1.1":return"HTTP/1.1";case"spdy/2":return"SPDY/2";case"spdy/3":return"SPDY/3";case"spdy/3.1":return"SPDY/3.1";default:return null;}}
static comparePriority(a,b)
{const map={[WI.Resource.NetworkPriority.Unknown]:0,[WI.Resource.NetworkPriority.Low]:1,[WI.Resource.NetworkPriority.Medium]:2,[WI.Resource.NetworkPriority.High]:3,};let aNum=map[a]||0;let bNum=map[b]||0;return aNum-bNum;}
static displayNameForPriority(priority)
{switch(priority){case WI.Resource.NetworkPriority.Low:return WI.UIString("Low","Low @ Network Priority","Low network request priority");case WI.Resource.NetworkPriority.Medium:return WI.UIString("Medium","Medium @ Network Priority","Medium network request priority");case WI.Resource.NetworkPriority.High:return WI.UIString("High","High @ Network Priority","High network request priority");default:return null;}}
static responseSourceFromPayload(source)
{if(!source)
return WI.Resource.ResponseSource.Unknown;switch(source){case InspectorBackend.Enum.Network.ResponseSource.Unknown:return WI.Resource.ResponseSource.Unknown;case InspectorBackend.Enum.Network.ResponseSource.Network:return WI.Resource.ResponseSource.Network;case InspectorBackend.Enum.Network.ResponseSource.MemoryCache:return WI.Resource.ResponseSource.MemoryCache;case InspectorBackend.Enum.Network.ResponseSource.DiskCache:return WI.Resource.ResponseSource.DiskCache;case InspectorBackend.Enum.Network.ResponseSource.ServiceWorker:return WI.Resource.ResponseSource.ServiceWorker;case InspectorBackend.Enum.Network.ResponseSource.InspectorOverride:return WI.Resource.ResponseSource.InspectorOverride;default:console.error("Unknown response source type",source);return WI.Resource.ResponseSource.Unknown;}}
static networkPriorityFromPayload(priority)
{switch(priority){case InspectorBackend.Enum.Network.MetricsPriority.Low:return WI.Resource.NetworkPriority.Low;case InspectorBackend.Enum.Network.MetricsPriority.Medium:return WI.Resource.NetworkPriority.Medium;case InspectorBackend.Enum.Network.MetricsPriority.High:return WI.Resource.NetworkPriority.High;default:console.error("Unknown metrics priority",priority);return WI.Resource.NetworkPriority.Unknown;}}
static connectionIdentifierFromPayload(connectionIdentifier)
{if(!WI.Resource.connectionIdentifierMap){WI.Resource.connectionIdentifierMap=new Map;WI.Resource.nextConnectionIdentifier=1;}
let id=WI.Resource.connectionIdentifierMap.get(connectionIdentifier);if(id)
return id;id=WI.Resource.nextConnectionIdentifier++;WI.Resource.connectionIdentifierMap.set(connectionIdentifier,id);return id;}
get mimeType(){return this._mimeType;}
get target(){return this._target;}
get type(){return this._type;}
get loaderIdentifier(){return this._loaderIdentifier;}
get requestIdentifier(){return this._requestIdentifier;}
get requestMethod(){return this._requestMethod;}
get requestData(){return this._requestData;}
get initiatorCallFrames(){return this._initiatorCallFrames;}
get initiatorSourceCodeLocation(){return this._initiatorSourceCodeLocation;}
get initiatorNode(){return this._initiatorNode;}
get initiatedResources(){return this._initiatedResources;}
get statusCode(){return this._statusCode;}
get statusText(){return this._statusText;}
get responseSource(){return this._responseSource;}
get security(){return this._security;}
get timingData(){return this._timingData;}
get protocol(){return this._protocol;}
get priority(){return this._priority;}
get remoteAddress(){return this._remoteAddress;}
get connectionIdentifier(){return this._connectionIdentifier;}
get parentFrame(){return this._parentFrame;}
get finished(){return this._finished;}
get failed(){return this._failed;}
get canceled(){return this._canceled;}
get failureReasonText(){return this._failureReasonText;}
get requestHeaders(){return this._requestHeaders;}
get responseHeaders(){return this._responseHeaders;}
get requestSentTimestamp(){return this._requestSentTimestamp;}
get requestSentWalltime(){return this._requestSentWalltime;}
get responseReceivedTimestamp(){return this._responseReceivedTimestamp;}
get lastDataReceivedTimestamp(){return this._lastDataReceivedTimestamp;}
get finishedOrFailedTimestamp(){return this._finishedOrFailedTimestamp;}
get cached(){return this._cached;}
get requestHeadersTransferSize(){return this._requestHeadersTransferSize;}
get requestBodyTransferSize(){return this._requestBodyTransferSize;}
get responseHeadersTransferSize(){return this._responseHeadersTransferSize;}
get responseBodyTransferSize(){return this._responseBodyTransferSize;}
get cachedResponseBodySize(){return this._cachedResponseBodySize;}
get redirects(){return this._redirects;}
get referrerPolicy(){return this._referrerPolicy;}
get integrity(){return this._integrity;}
get loadedSecurely()
{if(this.urlComponents.scheme!=="https"&&this.urlComponents.scheme!=="wss"&&this.urlComponents.scheme!=="sftp")
return false;if(isNaN(this._timingData.secureConnectionStart)&&!isNaN(this._timingData.connectionStart))
return false;return true;}
get isScript()
{return this._type===Resource.Type.Script;}
get supportsScriptBlackboxing()
{if(this.localResourceOverride)
return false;if(!this.finished||this.failed)
return false;return super.supportsScriptBlackboxing;}
get displayName()
{return WI.displayNameForURL(this._url,this.urlComponents);}
get displayURL()
{const isMultiLine=true;const dataURIMaxSize=64;return WI.truncateURL(this._url,isMultiLine,dataURIMaxSize);}
get displayRemoteAddress()
{if(this._isProxyConnection)
return WI.UIString("%s (Proxy)","%s (Proxy) @ Resource Remote Address","Label for the IP address of a proxy server used to retrieve a network resource.").format(this._remoteAddress);return this._remoteAddress;}
get mimeTypeComponents()
{if(!this._mimeTypeComponents)
this._mimeTypeComponents=parseMIMEType(this._mimeType);return this._mimeTypeComponents;}
get syntheticMIMEType()
{if(this._type===WI.Resource.typeFromMIMEType(this._mimeType))
return this._mimeType;switch(this._type){case WI.Resource.Type.StyleSheet:return"text/css";case WI.Resource.Type.Script:return"text/javascript";}
return this._mimeType;}
createObjectURL()
{let revision=this.currentRevision;let blobContent=revision.blobContent;if(blobContent)
return URL.createObjectURL(blobContent)
return this._url;}
isMainResource()
{return this._parentFrame?this._parentFrame.mainResource===this:false;}
addInitiatedResource(resource)
{if(!(resource instanceof WI.Resource))
return;this._initiatedResources.push(resource);this.dispatchEventToListeners(WI.Resource.Event.InitiatedResourcesDidChange);}
get queryStringParameters()
{if(this._queryStringParameters===undefined)
this._queryStringParameters=parseQueryString(this.urlComponents.queryString,true);return this._queryStringParameters;}
get requestFormParameters()
{if(this._requestFormParameters===undefined)
this._requestFormParameters=this.hasRequestFormParameters()?parseQueryString(this.requestData,true):null;return this._requestFormParameters;}
get requestDataContentType()
{return this._requestHeaders.valueForCaseInsensitiveKey("Content-Type")||null;}
get requestCookies()
{if(!this._requestCookies)
this._requestCookies=WI.Cookie.parseCookieRequestHeader(this._requestHeaders.valueForCaseInsensitiveKey("Cookie"));return this._requestCookies;}
get responseCookies()
{if(!this._responseCookies){let rawCombinedHeader=this._responseHeaders.valueForCaseInsensitiveKey("Set-Cookie")||"";let setCookieHeaders=rawCombinedHeader.split(/, (?![0-9])/);let cookies=[];for(let header of setCookieHeaders){let cookie=WI.Cookie.parseSetCookieResponseHeader(header);if(cookie)
cookies.push(cookie);}
this._responseCookies=cookies;}
return this._responseCookies;}
get requestSentDate()
{return isNaN(this._requestSentWalltime)?null:new Date(this._requestSentWalltime*1000);}
get lastRedirectReceivedTimestamp()
{return this._redirects.length?this._redirects.lastValue.timestamp:NaN;}
get firstTimestamp()
{return this.timingData.startTime||this.lastRedirectReceivedTimestamp||this.responseReceivedTimestamp||this.lastDataReceivedTimestamp||this.finishedOrFailedTimestamp;}
get lastTimestamp()
{return this.timingData.responseEnd||this.lastDataReceivedTimestamp||this.responseReceivedTimestamp||this.lastRedirectReceivedTimestamp||this.requestSentTimestamp;}
get latency()
{return this.timingData.responseStart-this.timingData.requestStart;}
get receiveDuration()
{return this.timingData.responseEnd-this.timingData.responseStart;}
get totalDuration()
{return this.timingData.responseEnd-this.timingData.startTime;}
get size()
{if(!isNaN(this._cachedResponseBodySize))
return this._cachedResponseBodySize;if(!isNaN(this._responseBodySize)&&this._responseBodySize!==0)
return this._responseBodySize;return this._estimatedSize;}
get networkEncodedSize()
{return this._responseBodyTransferSize;}
get networkDecodedSize()
{return this._responseBodySize;}
get networkTotalTransferSize()
{return this._responseHeadersTransferSize+this._responseBodyTransferSize;}
get estimatedNetworkEncodedSize()
{let exact=this.networkEncodedSize;if(!isNaN(exact))
return exact;if(this._cached)
return 0;if(WI.Platform.name==="mac"){let contentLength=Number(this._responseHeaders.valueForCaseInsensitiveKey("Content-Length"));if(!isNaN(contentLength))
return contentLength;}
if(!isNaN(this._estimatedTransferSize))
return this._estimatedTransferSize;return Number(this._responseHeaders.valueForCaseInsensitiveKey("Content-Length")||this._estimatedSize);}
get estimatedTotalTransferSize()
{let exact=this.networkTotalTransferSize;if(!isNaN(exact))
return exact;if(this.statusCode===304)
return this._estimatedResponseHeadersSize;if(this._cached)
return 0;return this._estimatedResponseHeadersSize+this.estimatedNetworkEncodedSize;}
get compressed()
{let contentEncoding=this._responseHeaders.valueForCaseInsensitiveKey("Content-Encoding");return!!(contentEncoding&&/\b(?:gzip|deflate|br)\b/.test(contentEncoding));}
get requestedByteRange()
{let range=this._requestHeaders.valueForCaseInsensitiveKey("Range");if(!range)
return null;let rangeValues=range.match(/bytes=(\d+)-(\d+)/);if(!rangeValues)
return null;let start=parseInt(rangeValues[1]);if(isNaN(start))
return null;let end=parseInt(rangeValues[2]);if(isNaN(end))
return null;return{start,end};}
get scripts()
{return this._scripts||[];}
get serverTiming()
{if(!this._serverTimingEntries)
this._serverTimingEntries=WI.ServerTimingEntry.parseHeaders(this._responseHeaders.valueForCaseInsensitiveKey("Server-Timing"));return this._serverTimingEntries;}
scriptForLocation(sourceCodeLocation)
{if(sourceCodeLocation.sourceCode!==this)
return null;var lineNumber=sourceCodeLocation.lineNumber;var columnNumber=sourceCodeLocation.columnNumber;for(var i=0;i<this._scripts.length;++i){var script=this._scripts[i];if(script.range.startLine<=lineNumber&&script.range.endLine>=lineNumber){if(script.range.startLine===lineNumber&&columnNumber<script.range.startColumn)
continue;if(script.range.endLine===lineNumber&&columnNumber>script.range.endColumn)
continue;return script;}}
return null;}
updateForRedirectResponse(request,response,elapsedTime,walltime)
{let oldURL=this._url;let oldHeaders=this._requestHeaders;let oldMethod=this._requestMethod;if(request.url)
this._url=request.url;this._requestHeaders=request.headers||{};this._requestCookies=null;this._requestMethod=request.method||null;this._redirects.push(new WI.Redirect(oldURL,oldMethod,oldHeaders,response.status,response.statusText,response.headers,elapsedTime));this._referrerPolicy=request.referrerPolicy??null;this._integrity=request.integrity??null;if(oldURL!==request.url){this._urlComponents=null;this.dispatchEventToListeners(WI.Resource.Event.URLDidChange,{oldURL});}
this.dispatchEventToListeners(WI.Resource.Event.RequestHeadersDidChange);this.dispatchEventToListeners(WI.Resource.Event.TimestampsDidChange);}
hasResponse()
{return!isNaN(this._statusCode)||this._finished||this._failed;}
hasRequestFormParameters()
{let requestDataContentType=this.requestDataContentType;return requestDataContentType&&requestDataContentType.match(/^application\/x-www-form-urlencoded\s*(;.*)?$/i);}
updateForResponse(url,mimeType,type,responseHeaders,statusCode,statusText,elapsedTime,timingData,source,security)
{let oldURL=this._url;let oldMIMEType=this._mimeType;let oldType=this._type;if(type in WI.Resource.Type)
type=WI.Resource.Type[type];else if(type==="Stylesheet"){type=WI.Resource.Type.StyleSheet;}
if(url)
this._url=url;this._mimeType=mimeType;this._type=Resource.resolvedType(type,mimeType);this._statusCode=statusCode;this._statusText=statusText;this._responseHeaders=responseHeaders||{};this._responseCookies=null;this._serverTimingEntries=null;this._responseReceivedTimestamp=elapsedTime||NaN;this._timingData=WI.ResourceTimingData.fromPayload(timingData,this);if(source)
this._responseSource=WI.Resource.responseSourceFromPayload(source);this._security=security||{};const headerBaseSize=12;const headerPad=4;this._estimatedResponseHeadersSize=String(this._statusCode).length+this._statusText.length+headerBaseSize;for(let name in this._responseHeaders)
this._estimatedResponseHeadersSize+=name.length+this._responseHeaders[name].length+headerPad;if(!this._cached){if(statusCode===304||(this._responseSource===WI.Resource.ResponseSource.MemoryCache||this._responseSource===WI.Resource.ResponseSource.DiskCache))
this.markAsCached();}
if(oldURL!==url){this._urlComponents=null;this.dispatchEventToListeners(WI.Resource.Event.URLDidChange,{oldURL});}
if(oldMIMEType!==mimeType){this._mimeTypeComponents=null;this.dispatchEventToListeners(WI.Resource.Event.MIMETypeDidChange,{oldMIMEType});}
if(oldType!==type)
this.dispatchEventToListeners(WI.Resource.Event.TypeDidChange,{oldType});if(statusCode===304||this._responseHeaders.valueForCaseInsensitiveKey("Content-Length"))
this.dispatchEventToListeners(WI.Resource.Event.TransferSizeDidChange);this.dispatchEventToListeners(WI.Resource.Event.ResponseReceived);this.dispatchEventToListeners(WI.Resource.Event.TimestampsDidChange);}
updateWithMetrics(metrics)
{this._receivedNetworkLoadMetrics=true;if(metrics.protocol)
this._protocol=metrics.protocol;if(metrics.priority)
this._priority=WI.Resource.networkPriorityFromPayload(metrics.priority);if(metrics.remoteAddress)
this._remoteAddress=metrics.remoteAddress;if(metrics.connectionIdentifier)
this._connectionIdentifier=WI.Resource.connectionIdentifierFromPayload(metrics.connectionIdentifier);if(metrics.requestHeaders){this._requestHeaders=metrics.requestHeaders;this._requestCookies=null;this.dispatchEventToListeners(WI.Resource.Event.RequestHeadersDidChange);}
if("requestHeaderBytesSent"in metrics){this._requestHeadersTransferSize=metrics.requestHeaderBytesSent;this._requestBodyTransferSize=metrics.requestBodyBytesSent;this._responseHeadersTransferSize=metrics.responseHeaderBytesReceived;this._responseBodyTransferSize=metrics.responseBodyBytesReceived;this._responseBodySize=metrics.responseBodyDecodedSize;if(isNaN(this._estimatedSize))
this._estimatedSize=0;this.dispatchEventToListeners(WI.Resource.Event.SizeDidChange,{previousSize:this._estimatedSize});this.dispatchEventToListeners(WI.Resource.Event.TransferSizeDidChange);}
if(metrics.securityConnection){if(!this._security)
this._security={};this._security.connection=metrics.securityConnection;}
this._isProxyConnection=!!metrics.isProxyConnection;this.dispatchEventToListeners(WI.Resource.Event.MetricsDidChange);}
setCachedResponseBodySize(size)
{this._cachedResponseBodySize=size;}
requestContentFromBackend()
{let specialContentPromise=WI.SourceCode.generateSpecialContentForURL(this._url);if(specialContentPromise)
return specialContentPromise;if(this._target.type===WI.TargetType.Worker){let scriptForTarget=this.scripts.find((script)=>script.target===this._target);if(scriptForTarget)
return scriptForTarget.requestContentFromBackend();}else{if(this._requestIdentifier)
return this._target.NetworkAgent.getResponseBody(this._requestIdentifier);if(this._parentFrame)
return this._target.PageAgent.getResourceContent(this._parentFrame.id,this._url);}
return Promise.reject(new Error("Content request failed."));}
increaseSize(dataLength,elapsedTime)
{if(isNaN(this._estimatedSize))
this._estimatedSize=0;let previousSize=this._estimatedSize;this._estimatedSize+=dataLength;this._lastDataReceivedTimestamp=elapsedTime||NaN;this.dispatchEventToListeners(WI.Resource.Event.SizeDidChange,{previousSize});if(isNaN(this._estimatedTransferSize)&&this._statusCode!==304&&!this._responseHeaders.valueForCaseInsensitiveKey("Content-Length"))
this.dispatchEventToListeners(WI.Resource.Event.TransferSizeDidChange);}
increaseTransferSize(encodedDataLength)
{if(isNaN(this._estimatedTransferSize))
this._estimatedTransferSize=0;this._estimatedTransferSize+=encodedDataLength;this.dispatchEventToListeners(WI.Resource.Event.TransferSizeDidChange);}
markAsCached()
{this._cached=true;this.dispatchEventToListeners(WI.Resource.Event.CacheStatusDidChange);if(this._statusCode!==304)
this.dispatchEventToListeners(WI.Resource.Event.TransferSizeDidChange);}
markAsFinished(elapsedTime)
{this._finished=true;this._finishedOrFailedTimestamp=elapsedTime||NaN;this._timingData.markResponseEndTime(elapsedTime||NaN);if(this._finishThenRequestContentPromise)
this._finishThenRequestContentPromise=null;this.dispatchEventToListeners(WI.Resource.Event.LoadingDidFinish);this.dispatchEventToListeners(WI.Resource.Event.TimestampsDidChange);}
markAsFailed(canceled,elapsedTime,errorText)
{this._failed=true;this._canceled=canceled;this._finishedOrFailedTimestamp=elapsedTime||NaN;if(!this._failureReasonText)
this._failureReasonText=errorText||null;this.dispatchEventToListeners(WI.Resource.Event.LoadingDidFail);this.dispatchEventToListeners(WI.Resource.Event.TimestampsDidChange);}
revertMarkAsFinished()
{this._finished=false;this._finishedOrFailedTimestamp=NaN;}
legacyMarkServedFromMemoryCache()
{this._responseSource=WI.Resource.ResponseSource.MemoryCache;this.markAsCached();}
legacyMarkServedFromDiskCache()
{this._responseSource=WI.Resource.ResponseSource.DiskCache;this.markAsCached();}
isLoading()
{return!this._finished&&!this._failed;}
hadLoadingError()
{return this._failed||this._canceled||this._statusCode>=400;}
getImageSize(callback)
{if(this.type!==WI.Resource.Type.Image)
throw"Resource is not an image.";if(this._imageSize!==undefined){callback(this._imageSize);return;}
var objectURL=null;function imageDidLoad(){URL.revokeObjectURL(objectURL);this._imageSize={width:image.width,height:image.height};callback(this._imageSize);}
function requestContentFailure(){this._imageSize=null;callback(this._imageSize);}
var image=new Image;image.addEventListener("load",imageDidLoad.bind(this),false);this.requestContent().then((content)=>{objectURL=image.src=content.sourceCode.createObjectURL();if(!objectURL)
requestContentFailure.call(this);},requestContentFailure.bind(this));}
requestContent()
{if(this._finished)
return super.requestContent().catch(this._requestContentFailure.bind(this));if(this._failed)
return this._requestContentFailure();if(!this._finishThenRequestContentPromise){this._finishThenRequestContentPromise=new Promise((resolve,reject)=>{this.singleFireEventListener(WI.Resource.Event.LoadingDidFinish,resolve,this);this.singleFireEventListener(WI.Resource.Event.LoadingDidFail,reject,this);}).then(this.requestContent.bind(this));}
return this._finishThenRequestContentPromise;}
associateWithScript(script)
{if(!this._scripts)
this._scripts=[];this._scripts.push(script);if(this._type===WI.Resource.Type.Other||this._type===WI.Resource.Type.XHR){let oldType=this._type;this._type=WI.Resource.Type.Script;this.dispatchEventToListeners(WI.Resource.Event.TypeDidChange,{oldType});}}
saveIdentityToCookie(cookie)
{cookie[WI.Resource.URLCookieKey]=this.url.hash;cookie[WI.Resource.MainResourceCookieKey]=this.isMainResource();}
async createLocalResourceOverride(type,{mimeType,base64Encoded,content}={})
{let resourceData={requestURL:this.url,};switch(type){case WI.LocalResourceOverride.InterceptType.Request:resourceData.requestMethod=this.requestMethod??WI.HTTPUtilities.RequestMethod.GET;resourceData.requestHeaders=Object.shallowCopy(this.requestHeaders);resourceData.requestData=this.requestData??"";break;case WI.LocalResourceOverride.InterceptType.Response:case WI.LocalResourceOverride.InterceptType.ResponseSkippingNetwork:resourceData.responseMIMEType=this.mimeType??WI.mimeTypeForFileExtension(WI.fileExtensionForFilename(this.urlComponents.lastPathComponent));resourceData.responseStatusCode=this.statusCode;resourceData.responseStatusText=this.statusText;if(!resourceData.responseStatusCode){resourceData.responseStatusCode=200;resourceData.responseStatusText=null;}
resourceData.responseStatusText||=WI.HTTPUtilities.statusTextForStatusCode(resourceData.responseStatusCode);if(base64Encoded===undefined||content===undefined){try{let{rawContent,rawBase64Encoded}=await this.requestContent();content??=rawContent;base64Encoded??=rawBase64Encoded;}catch{content??="";base64Encoded??=!WI.shouldTreatMIMETypeAsText(resourceData.mimeType);}}
resourceData.responseContent=content;resourceData.responseBase64Encoded=base64Encoded;resourceData.responseHeaders=Object.shallowCopy(this.responseHeaders);break;}
return WI.LocalResourceOverride.create(this.url,type,resourceData);}
updateLocalResourceOverrideRequestData(data)
{if(data===this._requestData)
return;this._requestData=data;this.dispatchEventToListeners(WI.Resource.Event.RequestDataDidChange);}
generateFetchCode()
{let options={};if(this.requestData)
options.body=this.requestData;options.cache="default";options.credentials=(this.requestCookies.length||this._requestHeaders.valueForCaseInsensitiveKey("Authorization"))?"include":"omit";const forbiddenHeaders=new Set(["accept-charset","accept-encoding","access-control-request-headers","access-control-request-method","connection","content-length","cookie","cookie2","date","dnt","expect","host","keep-alive","origin","referer","te","trailer","transfer-encoding","upgrade","via",]);let headers=Object.entries(this.requestHeaders).filter((header)=>{let key=header[0].toLowerCase();if(forbiddenHeaders.has(key))
return false;if(key.startsWith("proxy-")||key.startsWith("sec-"))
return false;return true;}).sort((a,b)=>a[0].extendedLocaleCompare(b[0])).reduce((accumulator,current)=>{accumulator[current[0]]=current[1];return accumulator;},{});if(!isEmptyObject(headers))
options.headers=headers;if(this._integrity)
options.integrity=this._integrity;if(this.requestMethod)
options.method=this.requestMethod;options.mode="cors";options.redirect="follow";let referrer=this.requestHeaders.valueForCaseInsensitiveKey("Referer");if(referrer)
options.referrer=referrer;if(this._referrerPolicy)
options.referrerPolicy=this._referrerPolicy;return`fetch(${JSON.stringify(this.url)}, ${JSON.stringify(options, null, WI.indentString())})`;}
generateCURLCommand()
{function escapeStringPosix(str){function escapeCharacter(x){let code=x.charCodeAt(0);let hex=code.toString(16);if(code<256)
return"\\x"+hex.padStart(2,"0");return"\\u"+hex.padStart(4,"0");}
if(/[^\x20-\x7E]|'/.test(str)){return"$'"+str.replace(/\\/g,"\\\\").replace(/'/g,"\\'").replace(/\n/g,"\\n").replace(/\r/g,"\\r").replace(/!/g,"\\041").replace(/[^\x20-\x7E]/g,escapeCharacter)+"'";}
return`'${str}'`;}
let command=["curl "+escapeStringPosix(this.url).replace(/[[{}\]]/g,"\\$&")];command.push("-X "+escapeStringPosix(this.requestMethod));for(let key in this.requestHeaders)
command.push("-H "+escapeStringPosix(`${key}: ${this.requestHeaders[key]}`));if(this.requestDataContentType&&this.requestMethod!=="GET"&&this.requestData){if(this.requestDataContentType.match(/^application\/x-www-form-urlencoded\s*(;.*)?$/i))
command.push("--data "+escapeStringPosix(this.requestData));else
command.push("--data-binary "+escapeStringPosix(this.requestData));}
return command.join(" \\\n");}
stringifyHTTPRequest()
{let lines=[];let protocol=this.protocol||"";if(protocol==="h2"){lines.push(`:method: ${this.requestMethod}`);lines.push(`:scheme: ${this.urlComponents.scheme}`);lines.push(`:authority: ${WI.h2Authority(this.urlComponents)}`);lines.push(`:path: ${WI.h2Path(this.urlComponents)}`);}else{lines.push(`${this.requestMethod} ${this.urlComponents.path}${protocol ? " " + protocol.toUpperCase() : ""}`);}
for(let key in this.requestHeaders)
lines.push(`${key}: ${this.requestHeaders[key]}`);return lines.join("\n")+"\n";}
stringifyHTTPResponse()
{let lines=[];let protocol=this.protocol||"";if(protocol==="h2"){lines.push(`:status: ${this.statusCode}`);}else{lines.push(`${protocol ? protocol.toUpperCase() + " " : ""}${this.statusCode} ${this.statusText}`);}
for(let key in this.responseHeaders)
lines.push(`${key}: ${this.responseHeaders[key]}`);return lines.join("\n")+"\n";}
async showCertificate()
{let errorString=WI.UIString("Unable to show certificate for \u201C%s\u201D").format(this.url);try{let{serializedCertificate}=await this._target.NetworkAgent.getSerializedCertificate(this._requestIdentifier);if(InspectorFrontendHost.showCertificate(serializedCertificate))
return;}catch(e){console.error(e);throw errorString;}
let consoleMessage=new WI.ConsoleMessage(this._target,WI.ConsoleMessage.MessageSource.Other,WI.ConsoleMessage.MessageLevel.Error,errorString);consoleMessage.shouldRevealConsole=true;WI.consoleLogViewController.appendConsoleMessage(consoleMessage);throw errorString;}
_requestContentFailure(error)
{return Promise.resolve({error:WI.UIString("An error occurred trying to load the resource."),reason:error?.message||this._failureReasonText,sourceCode:this,});}};WI.Resource.TypeIdentifier="resource";WI.Resource.URLCookieKey="resource-url";WI.Resource.MainResourceCookieKey="resource-is-main-resource";WI.Resource.Event={URLDidChange:"resource-url-did-change",MIMETypeDidChange:"resource-mime-type-did-change",TypeDidChange:"resource-type-did-change",RequestHeadersDidChange:"resource-request-headers-did-change",RequestDataDidChange:"resource-request-data-did-change",ResponseReceived:"resource-response-received",LoadingDidFinish:"resource-loading-did-finish",LoadingDidFail:"resource-loading-did-fail",TimestampsDidChange:"resource-timestamps-did-change",SizeDidChange:"resource-size-did-change",TransferSizeDidChange:"resource-transfer-size-did-change",CacheStatusDidChange:"resource-cached-did-change",MetricsDidChange:"resource-metrics-did-change",InitiatedResourcesDidChange:"resource-initiated-resources-did-change",};WI.Resource.Type={Document:"resource-type-document",StyleSheet:"resource-type-style-sheet",Image:"resource-type-image",Font:"resource-type-font",Script:"resource-type-script",XHR:"resource-type-xhr",Fetch:"resource-type-fetch",Ping:"resource-type-ping",Beacon:"resource-type-beacon",WebSocket:"resource-type-websocket",EventSource:"resource-type-eventsource",Other:"resource-type-other",};WI.Resource.ResponseSource={Unknown:Symbol("unknown"),Network:Symbol("network"),MemoryCache:Symbol("memory-cache"),DiskCache:Symbol("disk-cache"),ServiceWorker:Symbol("service-worker"),InspectorOverride:Symbol("inspector-override"),};WI.Resource.NetworkPriority={Unknown:Symbol("unknown"),Low:Symbol("low"),Medium:Symbol("medium"),High:Symbol("high"),};WI.Resource.GroupingMode={Path:"group-resource-by-path",Type:"group-resource-by-type",};WI.settings.resourceGroupingMode=new WI.Setting("resource-grouping-mode",WI.Resource.GroupingMode.Type);WI.Resource._mimeTypeMap={"text/html":WI.Resource.Type.Document,"text/xml":WI.Resource.Type.Document,"application/xhtml+xml":WI.Resource.Type.Document,"text/plain":WI.Resource.Type.Other,"text/css":WI.Resource.Type.StyleSheet,"text/xsl":WI.Resource.Type.StyleSheet,"text/x-less":WI.Resource.Type.StyleSheet,"text/x-sass":WI.Resource.Type.StyleSheet,"text/x-scss":WI.Resource.Type.StyleSheet,"application/pdf":WI.Resource.Type.Image,"image/svg+xml":WI.Resource.Type.Image,"application/x-font-type1":WI.Resource.Type.Font,"application/x-font-ttf":WI.Resource.Type.Font,"application/x-font-woff":WI.Resource.Type.Font,"application/x-truetype-font":WI.Resource.Type.Font,"text/javascript":WI.Resource.Type.Script,"text/ecmascript":WI.Resource.Type.Script,"application/javascript":WI.Resource.Type.Script,"application/ecmascript":WI.Resource.Type.Script,"application/x-javascript":WI.Resource.Type.Script,"application/json":WI.Resource.Type.Script,"application/x-json":WI.Resource.Type.Script,"text/x-javascript":WI.Resource.Type.Script,"text/x-json":WI.Resource.Type.Script,"text/javascript1.1":WI.Resource.Type.Script,"text/javascript1.2":WI.Resource.Type.Script,"text/javascript1.3":WI.Resource.Type.Script,"text/jscript":WI.Resource.Type.Script,"text/livescript":WI.Resource.Type.Script,"text/x-livescript":WI.Resource.Type.Script,"text/typescript":WI.Resource.Type.Script,"text/typescript-jsx":WI.Resource.Type.Script,"text/jsx":WI.Resource.Type.Script,"text/x-clojure":WI.Resource.Type.Script,"text/x-coffeescript":WI.Resource.Type.Script,};WI.Script=class Script extends WI.SourceCode
{constructor(target,id,range,url,sourceType,injected,sourceURL,sourceMapURL)
{super(url);this._target=target;this._id=id||null;this._range=range||null;this._sourceType=sourceType||WI.Script.SourceType.Program;this._sourceURL=sourceURL||null;this._sourceMappingURL=sourceMapURL||null;this._injected=injected||false;this._dynamicallyAddedScriptElement=false;this._scriptSyntaxTree=null;this._resource=this._resolveResource();if(this._resource&&this._resource.type===WI.Resource.Type.Document&&!this._range.startLine&&!this._range.startColumn){let documentResource=this._resource;this._resource=null;this._dynamicallyAddedScriptElement=true;documentResource.parentFrame.addExtraScript(this);this._dynamicallyAddedScriptElementNumber=documentResource.parentFrame.extraScriptCollection.size;}else if(this._resource)
this._resource.associateWithScript(this);if(isWebInspectorConsoleEvaluationScript(this._sourceURL)){this._uniqueDisplayNameNumber=this._nextUniqueConsoleDisplayNameNumber();}
if(this._sourceMappingURL)
WI.networkManager.downloadSourceMap(this._sourceMappingURL,this._url,this);}
static resetUniqueDisplayNameNumbers(target)
{if(WI.Script._uniqueDisplayNameNumbersForRootTargetMap)
WI.Script._uniqueDisplayNameNumbersForRootTargetMap.delete(target);}
get target(){return this._target;}
get id(){return this._id;}
get range(){return this._range;}
get sourceType(){return this._sourceType;}
get sourceURL(){return this._sourceURL;}
get sourceMappingURL(){return this._sourceMappingURL;}
get injected(){return this._injected;}
get contentIdentifier()
{if(this._url)
return this._url;if(!this._sourceURL)
return null;if(isWebInspectorConsoleEvaluationScript(this._sourceURL))
return null;if(isWebInspectorInternalScript(this._sourceURL))
return null;return this._sourceURL;}
get mimeType()
{return this._resource?this._resource.mimeType:"text/javascript";}
get isScript()
{return true;}
get displayName()
{if(isWebInspectorBootstrapScript(this._sourceURL||this._url)){return WI.UIString("Inspector Bootstrap Script");}
if(this._url&&!this._dynamicallyAddedScriptElement)
return WI.displayNameForURL(this._url,this.urlComponents);if(isWebInspectorConsoleEvaluationScript(this._sourceURL)){return WI.UIString("Console Evaluation %d").format(this._uniqueDisplayNameNumber);}
if(this._sourceURL){if(!this._sourceURLComponents)
this._sourceURLComponents=parseURL(this._sourceURL);return WI.displayNameForURL(this._sourceURL,this._sourceURLComponents);}
if(this._dynamicallyAddedScriptElement)
return WI.UIString("Script Element %d").format(this._dynamicallyAddedScriptElementNumber);if(!this._uniqueDisplayNameNumber)
this._uniqueDisplayNameNumber=this._nextUniqueDisplayNameNumber();return WI.UIString("Anonymous Script %d").format(this._uniqueDisplayNameNumber);}
get displayURL()
{if(isWebInspectorBootstrapScript(this._sourceURL||this._url)){return WI.UIString("Inspector Bootstrap Script");}
const isMultiLine=true;const dataURIMaxSize=64;if(this._url)
return WI.truncateURL(this._url,isMultiLine,dataURIMaxSize);if(this._sourceURL)
return WI.truncateURL(this._sourceURL,isMultiLine,dataURIMaxSize);return null;}
get dynamicallyAddedScriptElement()
{return this._dynamicallyAddedScriptElement;}
get anonymous()
{return!this._resource&&!this._url&&!this._sourceURL;}
get resource()
{return this._resource;}
get scriptSyntaxTree()
{return this._scriptSyntaxTree;}
isMainResource()
{return this._target&&this._target.mainResource===this;}
requestContentFromBackend()
{let specialContentPromise=WI.SourceCode.generateSpecialContentForURL(this._url);if(specialContentPromise)
return specialContentPromise;if(!this._id){return Promise.reject(new Error("There is no identifier to request content with."));}
return this._target.DebuggerAgent.getScriptSource(this._id);}
saveIdentityToCookie(cookie)
{cookie[WI.Script.URLCookieKey]=this.url;cookie[WI.Script.DisplayNameCookieKey]=this.displayName;}
requestScriptSyntaxTree(callback)
{if(this._scriptSyntaxTree){setTimeout(()=>{callback(this._scriptSyntaxTree);},0);return;}
var makeSyntaxTreeAndCallCallback=(content)=>{this._makeSyntaxTree(content);callback(this._scriptSyntaxTree);};var content=this.content;if(!content&&this._resource&&this._resource.type===WI.Resource.Type.Script&&this._resource.finished)
content=this._resource.content;if(content){setTimeout(makeSyntaxTreeAndCallCallback,0,content);return;}
this.requestContent().then(function(parameters){makeSyntaxTreeAndCallCallback(parameters.sourceCode.content);}).catch(function(error){makeSyntaxTreeAndCallCallback(null);});}
_nextUniqueDisplayNameNumber()
{let numbers=this._uniqueDisplayNameNumbersForRootTarget();return++numbers.lastUniqueDisplayNameNumber;}
_nextUniqueConsoleDisplayNameNumber()
{let numbers=this._uniqueDisplayNameNumbersForRootTarget();return++numbers.lastUniqueConsoleDisplayNameNumber;}
_uniqueDisplayNameNumbersForRootTarget()
{if(!WI.Script._uniqueDisplayNameNumbersForRootTargetMap)
WI.Script._uniqueDisplayNameNumbersForRootTargetMap=new WeakMap();let key=this._target.rootTarget;let numbers=WI.Script._uniqueDisplayNameNumbersForRootTargetMap.get(key);if(!numbers){numbers={lastUniqueDisplayNameNumber:0,lastUniqueConsoleDisplayNameNumber:0};WI.Script._uniqueDisplayNameNumbersForRootTargetMap.set(key,numbers);}
return numbers;}
_resolveResource()
{if(!this._url)
return null;let resolver=WI.networkManager;if(this._target&&this._target!==WI.mainTarget)
resolver=this._target.resourceCollection;function isScriptResource(item){return item.type===WI.Resource.Type.Document||item.type===WI.Resource.Type.Script;}
try{let resource=resolver.resourcesForURL(this._url).find(isScriptResource);if(resource)
return resource;let decodedURL=decodeURI(this._url);if(decodedURL!==this._url){resource=resolver.resourcesForURL(decodedURL).find(isScriptResource);if(resource)
return resource;}
let urlWithoutFragment=removeURLFragment(this._url);if(urlWithoutFragment!==this._url){resource=resolver.resourcesForURL(urlWithoutFragment).find(isScriptResource);if(resource)
return resource;}
let decodedURLWithoutFragment=removeURLFragment(decodedURL);if(decodedURLWithoutFragment!==decodedURL){resource=resolver.resourcesForURL(decodedURLWithoutFragment).find(isScriptResource);if(resource)
return resource;}}catch{}
if(!this.isMainResource()){for(let frame of WI.networkManager.frames){if(frame.mainResource.type===WI.Resource.Type.Document&&frame.mainResource.url.startsWith(this._url))
return frame.mainResource;}}
return null;}
_makeSyntaxTree(sourceText)
{if(this._scriptSyntaxTree||!sourceText)
return;this._scriptSyntaxTree=new WI.ScriptSyntaxTree(sourceText,this);}};WI.Script.SourceType={Program:"script-source-type-program",Module:"script-source-type-module",};WI.Script.TypeIdentifier="script";WI.Script.URLCookieKey="script-url";WI.Script.DisplayNameCookieKey="script-display-name";WI.LocalScript=class LocalScript extends WI.Script
{constructor(target,url,sourceURL,sourceType,source,{injected,editable}={})
{const id=null;super(target,id,WI.TextRange.fromText(source),url,sourceType,injected,sourceURL);this._editable=!!editable;const base64Encoded=false;const mimeType="text/javascript";this._originalRevision=new WI.SourceCodeRevision(this,source,base64Encoded,mimeType);this._currentRevision=this._originalRevision;}
get editable(){return this._editable;}
get supportsScriptBlackboxing()
{return false;}
requestContentFromBackend()
{return Promise.resolve({scriptSource:this._originalRevision.content,});}
handleCurrentRevisionContentChange()
{super.handleCurrentRevisionContentChange();this._range=WI.TextRange.fromText(this._currentRevision.content);}};WI.AlignmentData=class AlignmentData
{constructor(propertyName,text)
{this._type=WI.AlignmentData._propertyNameToType(propertyName);this._propertyName=propertyName;this._text=text;}
static isAlignmentAwarePropertyName(propertyName)
{return!!WI.AlignmentData._propertyNameToType(propertyName);}
static _propertyNameToType(propertyName)
{switch(propertyName){case"align-content":return WI.AlignmentData.Type.AlignContent;case"align-items":return WI.AlignmentData.Type.AlignItems;case"align-self":return WI.AlignmentData.Type.AlignSelf;case"justify-content":return WI.AlignmentData.Type.JustifyContent;case"justify-items":return WI.AlignmentData.Type.JustifyItems;case"justify-self":return WI.AlignmentData.Type.JustifySelf;}
return null;}
get type(){return this._type;}
get text(){return this._text;}
set text(text){this._text=text;}
toString()
{return this._text;}};WI.AlignmentData.Type={AlignContent:"align-content",AlignItems:"align-items",AlignSelf:"align-self",JustifyContent:"justify-content",JustifyItems:"justify-items",JustifySelf:"justify-self",};WI.Animation=class Animation extends WI.Object
{constructor(animationId,{name,cssAnimationName,cssTransitionProperty,effect,backtrace}={})
{super();this._animationId=animationId;this._name=name||null;this._cssAnimationName=cssAnimationName||null;this._cssTransitionProperty=cssTransitionProperty||null;this._updateEffect(effect);this._backtrace=backtrace||[];this._effectTarget=undefined;this._requestEffectTargetCallbacks=null;}
static fromPayload(payload)
{return new WI.Animation(payload.animationId,{name:payload.name,cssAnimationName:payload.cssAnimationName,cssTransitionProperty:payload.cssTransitionProperty,effect:payload.effect,backtrace:Array.isArray(payload.backtrace)?payload.backtrace.map((item)=>WI.CallFrame.fromPayload(WI.mainTarget,item)):[],});}
static displayNameForAnimationType(animationType,plural)
{switch(animationType){case WI.Animation.Type.WebAnimation:return plural?WI.UIString("Web Animations"):WI.UIString("Web Animation");case WI.Animation.Type.CSSAnimation:return plural?WI.UIString("CSS Animations"):WI.UIString("CSS Animation");case WI.Animation.Type.CSSTransition:return plural?WI.UIString("CSS Transitions"):WI.UIString("CSS Transition");}
return null;}
static displayNameForPlaybackDirection(playbackDirection)
{switch(playbackDirection){case WI.Animation.PlaybackDirection.Normal:return WI.UIString("Normal","Web Animation Playback Direction Normal","Indicates that the playback direction of this web animation is normal (e.g. forwards)");case WI.Animation.PlaybackDirection.Reverse:return WI.UIString("Reverse","Web Animation Playback Direction Reverse","Indicates that the playback direction of this web animation is reversed (e.g. backwards)");case WI.Animation.PlaybackDirection.Alternate:return WI.UIString("Alternate","Web Animation Playback Direction Alternate","Indicates that the playback direction of this web animation alternates between normal and reversed on each iteration");case WI.Animation.PlaybackDirection.AlternateReverse:return WI.UIString("Alternate Reverse","Web Animation Playback Direction Alternate Reverse","Indicates that the playback direction of this web animation alternates between reversed and normal on each iteration");}
return null;}
static displayNameForFillMode(fillMode)
{switch(fillMode){case WI.Animation.FillMode.None:return WI.UIString("None","Web Animation Fill Mode None","Indicates that this web animation does not apply any styles before it begins and after it ends");case WI.Animation.FillMode.Forwards:return WI.UIString("Forwards","Web Animation Fill Mode Forwards","Indicates that this web animation also applies styles after it ends");case WI.Animation.FillMode.Backwards:return WI.UIString("Backwards","Web Animation Fill Mode Backwards","Indicates that this web animation also applies styles before it begins");case WI.Animation.FillMode.Both:return WI.UIString("Both","Web Animation Fill Mode Both","Indicates that this web animation also applies styles before it begins and after it ends");case WI.Animation.FillMode.Auto:return WI.UIString("Auto","Web Animation Fill Mode Auto","Indicates that this web animation either does not apply any styles before it begins and after it ends or that it applies to both, depending on it's configuration");}
return null;}
static resetUniqueDisplayNameNumbers()
{WI.Animation._nextUniqueDisplayNameNumber=1;}
get animationId(){return this._animationId;}
get name(){return this._name;}
get cssAnimationName(){return this._cssAnimationName;}
get cssTransitionProperty(){return this._cssTransitionProperty;}
get backtrace(){return this._backtrace;}
get animationType()
{if(this._cssAnimationName)
return WI.Animation.Type.CSSAnimation;if(this._cssTransitionProperty)
return WI.Animation.Type.CSSTransition;return WI.Animation.Type.WebAnimation;}
get startDelay()
{return"startDelay"in this._effect?this._effect.startDelay:NaN;}
get endDelay()
{return"endDelay"in this._effect?this._effect.endDelay:NaN;}
get iterationCount()
{return"iterationCount"in this._effect?this._effect.iterationCount:NaN;}
get iterationStart()
{return"iterationStart"in this._effect?this._effect.iterationStart:NaN;}
get iterationDuration()
{return"iterationDuration"in this._effect?this._effect.iterationDuration:NaN;}
get timingFunction()
{return"timingFunction"in this._effect?this._effect.timingFunction:null;}
get playbackDirection()
{return"playbackDirection"in this._effect?this._effect.playbackDirection:null;}
get fillMode()
{return"fillMode"in this._effect?this._effect.fillMode:null;}
get keyframes()
{return"keyframes"in this._effect?this._effect.keyframes:[];}
get displayName()
{if(this._name)
return this._name;if(this._cssAnimationName)
return this._cssAnimationName;if(this._cssTransitionProperty)
return this._cssTransitionProperty;if(!this._uniqueDisplayNameNumber)
this._uniqueDisplayNameNumber=WI.Animation._nextUniqueDisplayNameNumber++;return WI.UIString("Animation %d").format(this._uniqueDisplayNameNumber);}
requestEffectTarget(callback)
{if(this._effectTarget!==undefined){callback(this._effectTarget);return;}
if(this._requestEffectTargetCallbacks){this._requestEffectTargetCallbacks.push(callback);return;}
this._requestEffectTargetCallbacks=[callback];WI.domManager.ensureDocument();let target=WI.assumingMainTarget();target.AnimationAgent.requestEffectTarget(this._animationId,(error,effectTarget)=>{if(!isNaN(effectTarget))
effectTarget={nodeId:effectTarget};this._effectTarget=!error?WI.DOMStyleable.fromPayload(effectTarget):null;for(let requestEffectTargetCallback of this._requestEffectTargetCallbacks)
requestEffectTargetCallback(this._effectTarget);this._requestEffectTargetCallbacks=null;});}
nameChanged(name)
{this._name=name||null;this.dispatchEventToListeners(WI.Animation.Event.NameChanged);}
effectChanged(effect)
{this._updateEffect(effect);}
targetChanged()
{this._effectTarget=undefined;this.dispatchEventToListeners(WI.Animation.Event.TargetChanged);}
_updateEffect(effect)
{this._effect=effect||{};if("iterationCount"in this._effect){if(this._effect.iterationCount===-1)
this._effect.iterationCount=Infinity;else if(this._effect.iterationCount===null){this._effect.iterationCount=Infinity;}}
if("timingFunction"in this._effect){let timingFunction=this._effect.timingFunction;this._effect.timingFunction=WI.CubicBezier.fromString(timingFunction)||WI.StepsFunction.fromString(timingFunction)||WI.Spring.fromString(timingFunction);}
if("keyframes"in this._effect){for(let keyframe of this._effect.keyframes){if(keyframe.easing){let easing=keyframe.easing;keyframe.easing=WI.CubicBezier.fromString(easing)||WI.StepsFunction.fromString(easing)||WI.Spring.fromString(easing);}
if(keyframe.style)
keyframe.style=keyframe.style.replaceAll(/;\s+/g,";\n");}}
this.dispatchEventToListeners(WI.Animation.Event.EffectChanged);}};WI.Animation._nextUniqueDisplayNameNumber=1;WI.Animation.Type={WebAnimation:"web-animation",CSSAnimation:"css-animation",CSSTransition:"css-transition",};WI.Animation.PlaybackDirection={Normal:"normal",Reverse:"reverse",Alternate:"alternate",AlternateReverse:"alternate-reverse",};WI.Animation.FillMode={None:"none",Forwards:"forwards",Backwards:"backwards",Both:"both",Auto:"auto",};WI.Animation.Event={NameChanged:"animation-name-changed",EffectChanged:"animation-effect-changed",TargetChanged:"animation-target-changed",};WI.AnimationCollection=class AnimationCollection extends WI.Collection
{constructor(animationType)
{super();this._animationType=animationType||null;if(!this._animationType)
this._animationCollectionForTypeMap=null;}
get animationType(){return this._animationType;}
get displayName()
{if(this._animationType){const plural=true;return WI.Animation.displayNameForType(this._animationType,plural);}
return WI.UIString("Web Animations");}
objectIsRequiredType(object)
{if(!(object instanceof WI.Animation))
return false;return!this._animationType||object.animationType===this._animationType;}
animationCollectionForType(animationType)
{if(this._animationType){return this;}
if(!this._animationCollectionForTypeMap)
this._animationCollectionForTypeMap=new Map;let animationCollectionForType=this._animationCollectionForTypeMap.get(animationType);if(!animationCollectionForType){animationCollectionForType=new WI.AnimationCollection(animationType);this._animationCollectionForTypeMap.set(animationType,animationCollectionForType);}
return animationCollectionForType;}
itemAdded(item)
{super.itemAdded(item);if(!this._animationType){let animationCollectionForType=this.animationCollectionForType(item.animationType);animationCollectionForType.add(item);}}
itemRemoved(item)
{if(!this._animationType){let animationCollectionForType=this.animationCollectionForType(item.animationType);animationCollectionForType.remove(item);}
super.itemRemoved(item);}
itemsCleared(items)
{if(this._animationCollectionForTypeMap){for(let animationCollectionForType of this._animationCollectionForTypeMap.values())
animationCollectionForType.clear();}
super.itemsCleared(items);}};WI.ApplicationCacheFrame=class ApplicationCacheFrame
{constructor(frame,manifest,status)
{this._frame=frame;this._manifest=manifest;this._status=status;}
get frame(){return this._frame;}
get manifest(){return this._manifest;}
get status(){return this._status;}
set status(status){this._status=status;}
saveIdentityToCookie(cookie)
{cookie[WI.ApplicationCacheFrame.FrameURLCookieKey]=this.frame.url;cookie[WI.ApplicationCacheFrame.ManifestURLCookieKey]=this.manifest.manifestURL;}};WI.ApplicationCacheFrame.TypeIdentifier="application-cache-frame";WI.ApplicationCacheFrame.FrameURLCookieKey="application-cache-frame-url";WI.ApplicationCacheFrame.ManifestURLCookieKey="application-cache-frame-manifest-url";WI.ApplicationCacheManifest=class ApplicationCacheManifest
{constructor(manifestURL)
{this._manifestURL=manifestURL;}
get manifestURL(){return this._manifestURL;}};WI.BackForwardEntry=class BackForwardEntry
{constructor(contentView,cookie)
{this._contentView=contentView;this._tombstone=false;this._cookie=cookie||{};this._scrollPositions=[];contentView.saveToCookie(this._cookie);}
makeCopy(newCookie)
{let copy=new WI.BackForwardEntry(this._contentView,newCookie||this.cookie);copy._tombstone=this._tombstone;copy._scrollPositions=this._scrollPositions.slice();return copy;}
get contentView()
{return this._contentView;}
get cookie()
{return Object.shallowCopy(this._cookie);}
get tombstone()
{return this._tombstone;}
set tombstone(tombstone)
{this._tombstone=tombstone;}
prepareToShow()
{this._restoreFromCookie();this.contentView.needsLayout();}
prepareToHide()
{this._saveScrollPositions();if(this._contentView.shouldSaveStateWhenHidden){this._cookie={};this._contentView.saveToCookie(this._cookie);}}
isEqual(other)
{if(!other)
return false;return this._contentView===other._contentView&&Object.shallowEqual(this._cookie,other._cookie);}
_restoreFromCookie()
{this._restoreScrollPositions();this.contentView.restoreFromCookie(this.cookie);}
_restoreScrollPositions()
{if(!this._scrollPositions.length)
return;var scrollableElements=this.contentView.scrollableElements||[];for(var i=0;i<scrollableElements.length;++i){var position=this._scrollPositions[i];var element=scrollableElements[i];if(!element)
continue;element.scrollTop=position.isScrolledToBottom?element.scrollHeight:position.scrollTop;element.scrollLeft=position.isScrolledToBottom?0:position.scrollLeft;}}
_saveScrollPositions()
{var scrollableElements=this.contentView.scrollableElements||[];var scrollPositions=[];for(var i=0;i<scrollableElements.length;++i){var element=scrollableElements[i];if(!element)
continue;let position={scrollTop:element.scrollTop,scrollLeft:element.scrollLeft};if(this.contentView.shouldKeepElementsScrolledToBottom)
position.isScrolledToBottom=element.isScrolledToBottom();scrollPositions.push(position);}
this._scrollPositions=scrollPositions;}};WI.BoxShadow=class BoxShadow
{constructor(offsetX,offsetY,blurRadius,spreadRadius,inset,color)
{this._offsetX=offsetX||null;this._offsetY=offsetY||null;this._blurRadius=blurRadius||null;this._spreadRadius=spreadRadius||null;this._inset=!!inset;this._color=color||null;}
static fromString(cssString)
{if(cssString==="none")
return new WI.BoxShadow;let offsetX=null;let offsetY=null;let blurRadius=null;let spreadRadius=null;let inset=false;let color=null;let startIndex=0;let openParentheses=0;let numberComponentCount=0;for(let i=0;i<=cssString.length;++i){if(cssString[i]==="("){++openParentheses;continue;}
if(cssString[i]===")"){--openParentheses;continue;}
if((cssString[i]!==" "||openParentheses)&&i!==cssString.length)
continue;let component=cssString.substring(startIndex,i+1).trim();startIndex=i+1;if(!component.length)
continue;if(component==="inset"){if(inset)
return null;inset=true;continue;}
let possibleColor=WI.Color.fromString(component);if(possibleColor){if(color)
return null;color=possibleColor;continue;}
let numberComponent=WI.BoxShadow.parseNumberComponent(component);if(!numberComponent)
return null;switch(++numberComponentCount){case 1:offsetX=numberComponent;break;case 2:offsetY=numberComponent;break;case 3:blurRadius=numberComponent;if(blurRadius.value<0)
return null;break;case 4:spreadRadius=numberComponent;break;default:return null;}}
if(!offsetX||!offsetY)
return null;return new WI.BoxShadow(offsetX,offsetY,blurRadius,spreadRadius,inset,color);}
static parseNumberComponent(string)
{let value=parseFloat(string);if(isNaN(value))
return null;let unit=string.replace(value,"");if(!unit){if(value)
return null;unit="px";}else if(!WI.CSSCompletions.lengthUnits.has(unit))
return null;return{unit,value};}
get offsetX(){return this._offsetX;}
get offsetY(){return this._offsetY;}
get blurRadius(){return this._blurRadius;}
get spreadRadius(){return this._spreadRadius;}
get inset(){return this._inset;}
get color(){return this._color;}
copy()
{return new WI.BoxShadow(this._offsetX,this._offsetY,this._blurRadius,this._spreadRadius,this._inset,this._color);}
toString()
{if(!this._offsetX||!this._offsetY)
return"none";function stringifyNumberComponent({value,unit}){return value+(value?unit:"");}
let values=[stringifyNumberComponent(this._offsetX),stringifyNumberComponent(this._offsetY),];if(this._blurRadius)
values.push(stringifyNumberComponent(this._blurRadius));if(this._spreadRadius)
values.push(stringifyNumberComponent(this._spreadRadius));if(this._color)
values.push(this._color.toString());if(this._inset)
values.push("inset");return values.join(" ");}};WI.CPUInstrument=class CPUInstrument extends WI.Instrument
{constructor()
{super();}
static supported()
{return InspectorBackend.hasDomain("CPUProfiler");}
get timelineRecordType()
{return WI.TimelineRecord.Type.CPU;}
startInstrumentation(initiatedByBackend)
{if(!initiatedByBackend){let target=WI.assumingMainTarget();target.CPUProfilerAgent.startTracking();}}
stopInstrumentation(initiatedByBackend)
{if(!initiatedByBackend){let target=WI.assumingMainTarget();target.CPUProfilerAgent.stopTracking();}}};WI.CPUTimeline=class CPUTimeline extends WI.Timeline
{addRecord(record,options={})
{let lastRecord=this.records.lastValue;if(lastRecord){let startTime=lastRecord.endTime;if(options.discontinuity)
startTime=options.discontinuity.endTime;record.adjustStartTime(startTime);}
super.addRecord(record,options);}};WI.CPUTimelineRecord=class CPUTimelineRecord extends WI.TimelineRecord
{constructor({timestamp,usage,threads})
{super(WI.TimelineRecord.Type.CPU,timestamp-CPUTimelineRecord.samplingRatePerSecond,timestamp);this._timestamp=timestamp;this._usage=usage;this._threads=threads||[];this._mainThreadUsage=0;this._webkitThreadUsage=0;this._workerThreadUsage=0;this._unknownThreadUsage=0;this._workersData=null;for(let thread of this._threads){if(thread.type===InspectorBackend.Enum.CPUProfiler.ThreadInfoType.Main){this._mainThreadUsage+=thread.usage;continue;}
if(thread.type===InspectorBackend.Enum.CPUProfiler.ThreadInfoType.WebKit){if(thread.targetId){if(!this._workersData)
this._workersData=[];this._workersData.push(thread);this._workerThreadUsage+=thread.usage;continue;}
this._webkitThreadUsage+=thread.usage;continue;}
this._unknownThreadUsage+=thread.usage;}}
static get samplingRatePerSecond()
{return 0.5;}
static async fromJSON(json)
{return new WI.CPUTimelineRecord(json);}
toJSON()
{return{type:this.type,timestamp:this._timestamp,usage:this._usage,threads:this._threads,};}
get timestamp(){return this._timestamp;}
get usage(){return this._usage;}
get unadjustedStartTime(){return this._timestamp;}
get mainThreadUsage(){return this._mainThreadUsage;}
get webkitThreadUsage(){return this._webkitThreadUsage;}
get workerThreadUsage(){return this._workerThreadUsage;}
get unknownThreadUsage(){return this._unknownThreadUsage;}
get workersData(){return this._workersData;}
adjustStartTime(startTime)
{this._startTime=startTime;}};WI.CSSCompletions=class CSSCompletions
{constructor(values,{acceptEmptyPrefix}={})
{this._values=values.slice();this._values.sort();this._acceptEmptyPrefix=!!acceptEmptyPrefix;this._queryController=null;}
static completeUnbalancedValue(value)
{const State={Data:0,SingleQuoteString:1,DoubleQuoteString:2,Comment:3};let state=State.Data;let unclosedParenthesisCount=0;let trailingBackslash=false;let length=value.length;for(let i=0;i<length;++i){switch(value[i]){case"'":if(state===State.Data)
state=State.SingleQuoteString;else if(state===State.SingleQuoteString)
state=State.Data;break;case"\"":if(state===State.Data)
state=State.DoubleQuoteString;else if(state===State.DoubleQuoteString)
state=State.Data;break;case"(":if(state===State.Data)
++unclosedParenthesisCount;break;case")":if(state===State.Data&&unclosedParenthesisCount)
--unclosedParenthesisCount;break;case"/":if(state===State.Data){if(value[i+1]==="*")
state=State.Comment;}
break;case"\\":if(i===length-1)
trailingBackslash=true;else
++i;break;case"*":if(state===State.Comment){if(value[i+1]==="/")
state=State.Data;}
break;}}
let suffix="";if(trailingBackslash)
suffix+="\\";switch(state){case State.SingleQuoteString:suffix+="'";break;case State.DoubleQuoteString:suffix+="\"";break;case State.Comment:suffix+="*/";break;}
suffix+=")".repeat(unclosedParenthesisCount);return suffix;}
static getCompletionText(completion)
{if(typeof completion==="string")
return completion;if(completion instanceof WI.QueryResult)
return completion.value;return"";}
get values()
{return this._values;}
executeQuery(query)
{if(!query)
return this._acceptEmptyPrefix?this._values.slice():[];this._queryController||=new WI.CSSQueryController(this._values);return this._queryController.executeQuery(query);}
startsWith(prefix)
{if(!prefix)
return this._acceptEmptyPrefix?this._values.slice():[];let firstIndex=this._firstIndexOfPrefix(prefix);if(firstIndex===-1)
return[];let results=[];while(firstIndex<this._values.length&&this._values[firstIndex].startsWith(prefix))
results.push(this._values[firstIndex++]);return results;}
replaceValues(values)
{this._values=values;this._values.sort();this._queryController?.reset();this._queryController?.addValues(values);}
_firstIndexOfPrefix(prefix)
{if(!this._values.length)
return-1;if(!prefix)
return this._acceptEmptyPrefix?0:-1;var maxIndex=this._values.length-1;var minIndex=0;var foundIndex;do{var middleIndex=(maxIndex+minIndex)>>1;if(this._values[middleIndex].startsWith(prefix)){foundIndex=middleIndex;break;}
if(this._values[middleIndex]<prefix)
minIndex=middleIndex+1;else
maxIndex=middleIndex-1;}while(minIndex<=maxIndex);if(foundIndex===undefined)
return-1;while(foundIndex&&this._values[foundIndex-1].startsWith(prefix))
foundIndex--;return foundIndex;}};WI.CSSCompletions.lengthUnits=new Set(["ch","cm","dvb","dvh","dvi","dvmax","dvmin","dvw","em","ex","in","lvb","lvh","lvi","lvmax","lvmin","lvw","mm","pc","pt","px","q","rem","svb","svh","svi","svmax","svmin","svw","vb","vh","vi","vmax","vmin","vw",]);WI.CSSGrouping=class CSSGrouping
{constructor(type,text,sourceCodeLocation)
{this._type=type;this._text=text||null;this._sourceCodeLocation=sourceCodeLocation||null;}
get type(){return this._type;}
get text(){return this._text;}
get sourceCodeLocation(){return this._sourceCodeLocation;}
get isMedia()
{return this._type===WI.CSSGrouping.Type.MediaRule||this._type===WI.CSSGrouping.Type.MediaImportRule||this._type===WI.CSSGrouping.Type.MediaLinkNode||this._type===WI.CSSGrouping.Type.MediaStyleNode;}
get isSupports()
{return this._type===WI.CSSGrouping.Type.SupportsRule;}
get isLayer()
{return this._type===WI.CSSGrouping.Type.LayerRule||this._type===WI.CSSGrouping.Type.LayerImportRule;}
get isContainer()
{return this._type===WI.CSSGrouping.Type.ContainerRule;}
get prefix()
{if(this.isSupports)
return"@supports";if(this.isLayer)
return"@layer";if(this.isContainer)
return"@container";return"@media";}};WI.CSSGrouping.Type={MediaRule:"media-rule",MediaImportRule:"media-import-rule",MediaLinkNode:"media-link-node",MediaStyleNode:"media-style-node",SupportsRule:"supports-rule",LayerRule:"layer-rule",LayerImportRule:"layer-import-rule",ContainerRule:"container-rule",};WI.CSSKeywordCompletions={};WI.CSSKeywordCompletions.forPartialPropertyName=function(text,{caretPosition,allowEmptyPrefix}={})
{allowEmptyPrefix??=false;if(caretPosition!==text.length)
return{prefix:"",completions:[]};if(!text.length&&allowEmptyPrefix)
return{prefix:text,completions:WI.cssManager.propertyNameCompletions.values};return{prefix:text,completions:WI.cssManager.propertyNameCompletions.executeQuery(text)};};WI.CSSKeywordCompletions.forPartialPropertyValue=function(text,propertyName,{caretPosition,additionalFunctionValueCompletionsProvider}={})
{caretPosition??=text.length;if(caretPosition<0||caretPosition>text.length)
return{prefix:"",completions:[]};if(!text.length)
return{prefix:"",completions:WI.CSSKeywordCompletions.forProperty(propertyName).values};let tokens=WI.tokenizeCSSValue(text);let indexOfTokenAtCaret=-1;let passedCharacters=0;for(let i=0;i<tokens.length;++i){passedCharacters+=tokens[i].value.length;if(passedCharacters>=caretPosition){indexOfTokenAtCaret=i;break;}}
let tokenAtCaret=tokens[indexOfTokenAtCaret];if(!tokenAtCaret)
return{prefix:"",completions:[]};if(tokenAtCaret.type&&/\b(comment|string)\b/.test(tokenAtCaret.type))
return{prefix:"",completions:[]};let currentTokenValue=tokenAtCaret.value.trim();let caretIsInMiddleOfToken=caretPosition!==passedCharacters;let tokenAfterCaret=tokens[indexOfTokenAtCaret+1];if((caretIsInMiddleOfToken&&currentTokenValue.length)||(!caretIsInMiddleOfToken&&tokenAfterCaret&&/[a-zA-Z0-9-]/.test(tokenAfterCaret.value[0])))
return{prefix:"",completions:[]};if(currentTokenValue==="("||currentTokenValue===",")
currentTokenValue="";let tokenBeforeCaret=tokens[indexOfTokenAtCaret-1];if(currentTokenValue===")"||tokenBeforeCaret?.value===")")
return{prefix:"",completions:[]};if(currentTokenValue.length&&tokenBeforeCaret?.value==="-"){currentTokenValue=tokenBeforeCaret.value+currentTokenValue;}
let functionName=null;let preceedingFunctionDepth=0;for(let i=indexOfTokenAtCaret;i>=0;--i){let value=tokens[i].value;if(value===")")
++preceedingFunctionDepth;else if(value==="("){if(preceedingFunctionDepth)
--preceedingFunctionDepth;else{functionName=tokens[i-1]?.value;break;}}}
let valueCompletions;if(functionName)
valueCompletions=WI.CSSKeywordCompletions.forFunction(functionName,{additionalFunctionValueCompletionsProvider});else
valueCompletions=WI.CSSKeywordCompletions.forProperty(propertyName);return{prefix:currentTokenValue,completions:valueCompletions.executeQuery(currentTokenValue)};};WI.CSSKeywordCompletions.forProperty=function(propertyName)
{let acceptedKeywords=["initial","unset","revert","revert-layer","var()","env()"];function addKeywordsForName(name){let isNotPrefixed=name.charAt(0)!=="-";if(name in WI.CSSKeywordCompletions._propertyKeywordMap)
acceptedKeywords.pushAll(WI.CSSKeywordCompletions._propertyKeywordMap[name]);else if(isNotPrefixed&&("-webkit-"+name)in WI.CSSKeywordCompletions._propertyKeywordMap)
acceptedKeywords.pushAll(WI.CSSKeywordCompletions._propertyKeywordMap["-webkit-"+name]);if(WI.CSSKeywordCompletions.isColorAwareProperty(name))
acceptedKeywords.pushAll(WI.CSSKeywordCompletions._colors);if(WI.CSSKeywordCompletions.InheritedProperties.has(name))
acceptedKeywords.push("inherit");else if(isNotPrefixed&&WI.CSSKeywordCompletions.InheritedProperties.has("-webkit-"+name))
acceptedKeywords.push("inherit");}
addKeywordsForName(propertyName);let unaliasedName=WI.CSSKeywordCompletions.PropertyNameForAlias.get(propertyName);if(unaliasedName)
addKeywordsForName(unaliasedName);let longhandNames=WI.CSSKeywordCompletions.LonghandNamesForShorthandProperty.get(propertyName);if(longhandNames){for(let longhandName of longhandNames)
addKeywordsForName(longhandName);}
if(acceptedKeywords.includes(WI.CSSKeywordCompletions.AllPropertyNamesPlaceholder)&&WI.cssManager.propertyNameCompletions){acceptedKeywords.remove(WI.CSSKeywordCompletions.AllPropertyNamesPlaceholder);acceptedKeywords.pushAll(WI.cssManager.propertyNameCompletions.values);}
return new WI.CSSCompletions(Array.from(new Set(acceptedKeywords)),{acceptEmptyPrefix:true});};WI.CSSKeywordCompletions.isColorAwareProperty=function(name)
{if(WI.CSSKeywordCompletions._colorAwareProperties.has(name))
return true;let isNotPrefixed=name.charAt(0)!=="-";if(isNotPrefixed&&WI.CSSKeywordCompletions._colorAwareProperties.has("-webkit-"+name))
return true;if(name.endsWith("color"))
return true;return false;};WI.CSSKeywordCompletions.isTimingFunctionAwareProperty=function(name)
{if(WI.CSSKeywordCompletions._timingFunctionAwareProperties.has(name))
return true;let isNotPrefixed=name.charAt(0)!=="-";if(isNotPrefixed&&WI.CSSKeywordCompletions._timingFunctionAwareProperties.has("-webkit-"+name))
return true;return false;};WI.CSSKeywordCompletions.forFunction=function(functionName,{additionalFunctionValueCompletionsProvider}={})
{let suggestions=["var()"];if(functionName==="var")
suggestions=[];else if(functionName==="calc"||functionName==="min"||functionName==="max")
suggestions.push("calc()","min()","max()");else if(functionName==="env")
suggestions.push("safe-area-inset-top","safe-area-inset-right","safe-area-inset-bottom","safe-area-inset-left");else if(functionName==="image-set")
suggestions.push("url()");else if(functionName==="repeat")
suggestions.push("auto","auto-fill","auto-fit","min-content","max-content");else if(functionName==="steps")
suggestions.push("jump-none","jump-start","jump-end","jump-both","start","end");else if(functionName.endsWith("gradient")){suggestions.push("to","left","right","top","bottom");suggestions.pushAll(WI.CSSKeywordCompletions._colors);}
if(additionalFunctionValueCompletionsProvider)
suggestions.pushAll(additionalFunctionValueCompletionsProvider(functionName));return new WI.CSSCompletions(suggestions,{acceptEmptyPrefix:true});};WI.CSSKeywordCompletions.addCustomCompletions=function(properties)
{for(var property of properties){if(property.aliases){for(let alias of property.aliases)
WI.CSSKeywordCompletions.PropertyNameForAlias.set(alias,property.name);}
if(property.values)
WI.CSSKeywordCompletions.addPropertyCompletionValues(property.name,property.values);if(property.inherited)
WI.CSSKeywordCompletions.InheritedProperties.add(property.name);if(property.longhands){WI.CSSKeywordCompletions.LonghandNamesForShorthandProperty.set(property.name,property.longhands);for(let longhand of property.longhands){let shorthands=WI.CSSKeywordCompletions.ShorthandNamesForLongHandProperty.getOrInitialize(longhand,[]);shorthands.push(property.name);}}}};WI.CSSKeywordCompletions.addPropertyCompletionValues=function(propertyName,newValues)
{var existingValues=WI.CSSKeywordCompletions._propertyKeywordMap[propertyName];if(!existingValues){WI.CSSKeywordCompletions._propertyKeywordMap[propertyName]=newValues;return;}
var union=new Set;for(var value of existingValues)
union.add(value);for(var value of newValues)
union.add(value);WI.CSSKeywordCompletions._propertyKeywordMap[propertyName]=[...union.values()];};WI.CSSKeywordCompletions.AllPropertyNamesPlaceholder="__all-properties__";WI.CSSKeywordCompletions.PropertyNameForAlias=new Map;WI.CSSKeywordCompletions.LonghandNamesForShorthandProperty=new Map;WI.CSSKeywordCompletions.ShorthandNamesForLongHandProperty=new Map;WI.CSSKeywordCompletions.InheritedProperties=new Set(["-apple-color-filter","-webkit-animation-trigger","-webkit-aspect-ratio","-webkit-border-horizontal-spacing","-webkit-border-vertical-spacing","-webkit-box-direction","-webkit-cursor-visibility","-webkit-font-kerning","-webkit-font-smoothing","-webkit-hyphenate-character","-webkit-hyphenate-limit-after","-webkit-hyphenate-limit-before","-webkit-hyphenate-limit-lines","-webkit-hyphens","-webkit-line-align","-webkit-line-break","-webkit-line-box-contain","-webkit-line-grid","-webkit-line-snap","-webkit-locale","-webkit-nbsp-mode","-webkit-overflow-scrolling","-webkit-rtl-ordering","-webkit-ruby-position","-webkit-text-combine","-webkit-text-decoration-skip","-webkit-text-decorations-in-effect","-webkit-text-emphasis","-webkit-text-emphasis-color","-webkit-text-emphasis-position","-webkit-text-emphasis-style","-webkit-text-fill-color","-webkit-text-orientation","-webkit-text-security","-webkit-text-size-adjust","-webkit-text-stroke","-webkit-text-stroke-color","-webkit-text-stroke-width","-webkit-text-underline-position","-webkit-text-zoom","-webkit-touch-callout","-webkit-user-modify","-webkit-user-select","border-collapse","border-spacing","caption-side","caret-color","clip-rule","color","color-interpolation","color-interpolation-filters","color-rendering","cursor","direction","empty-cells","fill","fill-opacity","fill-rule","font","font-family","font-feature-settings","font-optical-sizing","font-size","font-stretch","font-style","font-synthesis","font-variant","font-variant-alternates","font-variant-caps","font-variant-east-asian","font-variant-ligatures","font-variant-numeric","font-variant-position","font-variation-settings","font-weight","glyph-orientation-horizontal","glyph-orientation-vertical","hanging-punctuation","image-orientation","image-rendering","image-resolution","kerning","letter-spacing","line-break","line-height","list-style","list-style-image","list-style-position","list-style-type","marker","marker-end","marker-mid","marker-start","orphans","pointer-events","print-color-adjust","quotes","resize","shape-rendering","speak-as","stroke","stroke-color","stroke-dasharray","stroke-dashoffset","stroke-linecap","stroke-linejoin","stroke-miterlimit","stroke-opacity","stroke-width","tab-size","text-align","text-align-last","text-anchor","text-indent","text-justify","text-rendering","text-shadow","text-transform","visibility","white-space","widows","word-break","word-spacing","word-wrap","writing-mode",]);WI.CSSKeywordCompletions._colors=["aqua","black","blue","fuchsia","gray","green","lime","maroon","navy","olive","orange","purple","red","silver","teal","white","yellow","transparent","currentcolor","grey","aliceblue","antiquewhite","aquamarine","azure","beige","bisque","blanchedalmond","blueviolet","brown","burlywood","cadetblue","chartreuse","chocolate","coral","cornflowerblue","cornsilk","crimson","cyan","darkblue","darkcyan","darkgoldenrod","darkgray","darkgreen","darkgrey","darkkhaki","darkmagenta","darkolivegreen","darkorange","darkorchid","darkred","darksalmon","darkseagreen","darkslateblue","darkslategray","darkslategrey","darkturquoise","darkviolet","deeppink","deepskyblue","dimgray","dimgrey","dodgerblue","firebrick","floralwhite","forestgreen","gainsboro","ghostwhite","gold","goldenrod","greenyellow","honeydew","hotpink","indianred","indigo","ivory","khaki","lavender","lavenderblush","lawngreen","lemonchiffon","lightblue","lightcoral","lightcyan","lightgoldenrodyellow","lightgray","lightgreen","lightgrey","lightpink","lightsalmon","lightseagreen","lightskyblue","lightslategray","lightslategrey","lightsteelblue","lightyellow","limegreen","linen","magenta","mediumaquamarine","mediumblue","mediumorchid","mediumpurple","mediumseagreen","mediumslateblue","mediumspringgreen","mediumturquoise","mediumvioletred","midnightblue","mintcream","mistyrose","moccasin","navajowhite","oldlace","olivedrab","orangered","orchid","palegoldenrod","palegreen","paleturquoise","palevioletred","papayawhip","peachpuff","peru","pink","plum","powderblue","rebeccapurple","rosybrown","royalblue","saddlebrown","salmon","sandybrown","seagreen","seashell","sienna","skyblue","slateblue","slategray","slategrey","snow","springgreen","steelblue","tan","thistle","tomato","turquoise","violet","wheat","whitesmoke","yellowgreen","rgb()","rgba()","hsl()","hsla()","color()","hwb()","lch()","lab()","color-mix()","color-contrast()",];WI.CSSKeywordCompletions._colorAwareProperties=new Set(["background","background-color","background-image","border","border-color","border-bottom","border-bottom-color","border-left","border-left-color","border-right","border-right-color","border-top","border-top-color","box-shadow","-webkit-box-shadow","color","column-rule","-webkit-column-rule","column-rule-color","-webkit-column-rule-color","fill","outline","outline-color","stroke","text-decoration-color","-webkit-text-decoration-color","text-emphasis","-webkit-text-emphasis","text-emphasis-color","-webkit-text-emphasis-color","text-line-through","text-line-through-color","text-overline","text-overline-color","text-shadow","text-underline","text-underline-color","-webkit-text-fill-color","-webkit-text-stroke","-webkit-text-stroke-color","-webkit-tap-highlight-color",]);WI.CSSKeywordCompletions._timingFunctionAwareProperties=new Set(["animation","-webkit-animation","animation-timing-function","-webkit-animation-timing-function","transition","-webkit-transition","transition-timing-function","-webkit-transition-timing-function",]);WI.CSSKeywordCompletions._propertyKeywordMap={"content":["list-item","close-quote","no-close-quote","no-open-quote","open-quote","attr()","counter()","counters()","url()","linear-gradient()","radial-gradient()","repeating-linear-gradient()","repeating-radial-gradient()","-webkit-canvas()","cross-fade()","image-set()"],"list-style-image":["none","url()","linear-gradient()","radial-gradient()","repeating-linear-gradient()","repeating-radial-gradient()","-webkit-canvas()","cross-fade()","image-set()"],"baseline-shift":["baseline","sub","super"],"block-size":["auto","intrinsic","min-intrinsic","min-content","-webkit-min-content","max-content","-webkit-max-content","-webkit-fill-available","fit-content","-webkit-fit-content","calc()",],"border-block-end-width":["medium","thick","thin","calc()",],"border-block-start-width":["medium","thick","thin","calc()",],"border-bottom-width":["medium","thick","thin","calc()"],"border-inline-end-width":["medium","thick","thin","calc()",],"border-inline-start-width":["medium","thick","thin","calc()",],"font-stretch":["normal","wider","narrower","ultra-condensed","extra-condensed","condensed","semi-condensed","semi-expanded","expanded","extra-expanded","ultra-expanded"],"border-left-width":["medium","thick","thin","calc()"],"border-top-width":["medium","thick","thin","calc()"],"outline-color":["invert","-webkit-focus-ring-color"],"cursor":["auto","default","none","context-menu","help","pointer","progress","wait","cell","crosshair","text","vertical-text","alias","copy","move","no-drop","not-allowed","grab","grabbing","e-resize","n-resize","ne-resize","nw-resize","s-resize","se-resize","sw-resize","w-resize","ew-resize","ns-resize","nesw-resize","nwse-resize","col-resize","row-resize","all-scroll","zoom-in","zoom-out","-webkit-grab","-webkit-grabbing","-webkit-zoom-in","-webkit-zoom-out","url()","image-set()"],"border-width":["medium","thick","thin","calc()"],"size":["a3","a4","a5","b4","b5","landscape","ledger","legal","letter","portrait"],"background":["none","url()","linear-gradient()","radial-gradient()","repeating-linear-gradient()","repeating-radial-gradient()","-webkit-canvas()","cross-fade()","image-set()","repeat","repeat-x","repeat-y","no-repeat","space","round","scroll","fixed","local","auto","contain","cover","top","right","left","bottom","center","border-box","padding-box","content-box"],"background-image":["none","url()","linear-gradient()","radial-gradient()","repeating-linear-gradient()","repeating-radial-gradient()","-webkit-canvas()","cross-fade()","image-set()"],"background-size":["auto","contain","cover"],"background-attachment":["scroll","fixed","local"],"background-repeat":["repeat","repeat-x","repeat-y","no-repeat","space","round"],"background-blend-mode":["normal","multiply","screen","overlay","darken","lighten","color-dodge","color-burn","hard-light","soft-light","difference","exclusion","hue","saturation","color","luminosity"],"background-position":["top","right","left","bottom","center"],"background-origin":["border-box","padding-box","content-box"],"background-clip":["border-box","padding-box","content-box"],"enable-background":["accumulate","new"],"font-palette":["none","normal","light","dark"],"hanging-punctuation":["none","first","last","allow-end","force-end"],"inline-size":["auto","intrinsic","min-intrinsic","min-content","-webkit-min-content","max-content","-webkit-max-content","-webkit-fill-available","fit-content","-webkit-fit-content","calc()",],"overflow":["hidden","auto","visible","scroll","marquee","-webkit-paged-x","-webkit-paged-y"],"-webkit-box-reflect":["none","left","right","above","below"],"margin-block":["auto",],"margin-block-end":["auto",],"margin-block-start":["auto",],"margin-bottom":["auto"],"margin-inline":["auto",],"margin-inline-end":["auto",],"margin-inline-start":["auto",],"font-weight":["normal","bold","bolder","lighter","100","200","300","400","500","600","700","800","900"],"font-synthesis":["none","weight","style"],"font-style":["italic","oblique","normal"],"outline":["none","hidden","inset","groove","ridge","outset","dotted","dashed","solid","double"],"font":["caption","icon","menu","message-box","small-caption","-webkit-mini-control","-webkit-small-control","-webkit-control","status-bar","italic","oblique","small-caps","normal","bold","bolder","lighter","100","200","300","400","500","600","700","800","900","xx-small","x-small","small","medium","large","x-large","xx-large","-webkit-xxx-large","smaller","larger","serif","sans-serif","cursive","fantasy","monospace","-webkit-body","-webkit-pictograph","-apple-system","-apple-system-headline","-apple-system-body","-apple-system-subheadline","-apple-system-footnote","-apple-system-caption1","-apple-system-caption2","-apple-system-short-headline","-apple-system-short-body","-apple-system-short-subheadline","-apple-system-short-footnote","-apple-system-short-caption1","-apple-system-tall-body","-apple-system-title0","-apple-system-title1","-apple-system-title2","-apple-system-title3","-apple-system-title4","system-ui"],"outline-width":["medium","thick","thin","calc()"],"box-shadow":["none"],"text-shadow":["none"],"-webkit-box-shadow":["none"],"border-right-width":["medium","thick","thin"],"line-height":["normal"],"counter-increment":["none"],"counter-reset":["none"],"page-break-after":["left","right","auto","always","avoid"],"page-break-before":["left","right","auto","always","avoid"],"page-break-inside":["auto","avoid"],"-webkit-column-break-after":["left","right","auto","always","avoid"],"-webkit-column-break-before":["left","right","auto","always","avoid"],"-webkit-column-break-inside":["auto","avoid"],"border-image":["repeat","stretch","url()","linear-gradient()","radial-gradient()","repeating-linear-gradient()","repeating-radial-gradient()","-webkit-canvas()","cross-fade()","image-set()"],"border-image-repeat":["repeat","stretch","space","round"],"-webkit-mask-box-image-repeat":["repeat","stretch","space","round"],"font-family":["serif","sans-serif","cursive","fantasy","monospace","-webkit-body","-webkit-pictograph","-apple-system","-apple-system-headline","-apple-system-body","-apple-system-subheadline","-apple-system-footnote","-apple-system-caption1","-apple-system-caption2","-apple-system-short-headline","-apple-system-short-body","-apple-system-short-subheadline","-apple-system-short-footnote","-apple-system-short-caption1","-apple-system-tall-body","-apple-system-title0","-apple-system-title1","-apple-system-title2","-apple-system-title3","-apple-system-title4","system-ui"],"margin-left":["auto"],"margin-top":["auto"],"zoom":["normal","document","reset"],"z-index":["auto"],"width":["auto","intrinsic","min-intrinsic","min-content","-webkit-min-content","max-content","-webkit-max-content","-webkit-fill-available","fit-content","-webkit-fit-content","calc()"],"height":["auto","intrinsic","min-intrinsic","min-content","-webkit-min-content","max-content","-webkit-max-content","-webkit-fill-available","fit-content","-webkit-fit-content","calc()"],"max-width":["auto","intrinsic","min-intrinsic","min-content","-webkit-min-content","max-content","-webkit-max-content","-webkit-fill-available","fit-content","-webkit-fit-content","none","calc()"],"min-width":["auto","intrinsic","min-intrinsic","min-content","-webkit-min-content","max-content","-webkit-max-content","-webkit-fill-available","fit-content","-webkit-fit-content","calc()"],"max-block-size":["auto","intrinsic","min-intrinsic","min-content","-webkit-min-content","max-content","-webkit-max-content","-webkit-fill-available","fit-content","-webkit-fit-content","none","calc()",],"max-height":["auto","intrinsic","min-intrinsic","min-content","-webkit-min-content","max-content","-webkit-max-content","-webkit-fill-available","fit-content","-webkit-fit-content","none","calc()"],"max-inline-size":["auto","intrinsic","min-intrinsic","min-content","-webkit-min-content","max-content","-webkit-max-content","-webkit-fill-available","fit-content","-webkit-fit-content","none","calc()",],"min-block-size":["auto","intrinsic","min-intrinsic","min-content","-webkit-min-content","max-content","-webkit-max-content","-webkit-fill-available","fit-content","-webkit-fit-content","calc()",],"min-height":["auto","intrinsic","min-intrinsic","min-content","-webkit-min-content","max-content","-webkit-max-content","-webkit-fill-available","fit-content","-webkit-fit-content","calc()"],"min-inline-size":["auto","intrinsic","min-intrinsic","min-content","-webkit-min-content","max-content","-webkit-max-content","-webkit-fill-available","fit-content","-webkit-fit-content","calc()",],"letter-spacing":["normal","calc()"],"word-spacing":["normal","calc()"],"border":["none","hidden","inset","groove","ridge","outset","dotted","dashed","solid","double"],"font-size":["xx-small","x-small","small","medium","large","x-large","xx-large","-webkit-xxx-large","smaller","larger"],"font-variant":["small-caps","normal"],"font-variant-numeric":["normal","ordinal","slashed-zero","lining-nums","oldstyle-nums","proportional-nums","tabular-nums","diagonal-fractions","stacked-fractions"],"vertical-align":["baseline","middle","sub","super","text-top","text-bottom","top","bottom","-webkit-baseline-middle"],"text-indent":["-webkit-each-line","-webkit-hanging"],"clip":["auto","rect()"],"clip-path":["none","url()","circle()","ellipse()","inset()","polygon()","margin-box","border-box","padding-box","content-box"],"shape-outside":["none","url()","circle()","ellipse()","inset()","polygon()","margin-box","border-box","padding-box","content-box"],"orphans":["auto"],"widows":["auto"],"margin":["auto"],"page":["auto"],"perspective":["none"],"perspective-origin":["none","left","right","bottom","top","center"],"margin-right":["auto"],"-webkit-text-emphasis":["circle","filled","open","dot","double-circle","triangle","sesame"],"-webkit-text-emphasis-style":["circle","filled","open","dot","double-circle","triangle","sesame"],"-webkit-text-emphasis-position":["over","under","left","right"],"transform":["none","scale()","scaleX()","scaleY()","scale3d()","rotate()","rotateX()","rotateY()","rotateZ()","rotate3d()","skew()","skewX()","skewY()","translate()","translateX()","translateY()","translateZ()","translate3d()","matrix()","matrix3d()","perspective()"],"text-decoration":["none","underline","overline","line-through","blink"],"-webkit-text-decorations-in-effect":["none","underline","overline","line-through","blink"],"-webkit-text-decoration-line":["none","underline","overline","line-through","blink"],"-webkit-text-decoration-skip":["auto","none","objects","ink"],"-webkit-text-underline-position":["auto","alphabetic","under"],"transition":["none","ease","linear","ease-in","ease-out","ease-in-out","step-start","step-end","steps()","cubic-bezier()","spring()","all",WI.CSSKeywordCompletions.AllPropertyNamesPlaceholder],"transition-timing-function":["ease","linear","ease-in","ease-out","ease-in-out","step-start","step-end","steps()","cubic-bezier()","spring()"],"transition-property":["all","none",WI.CSSKeywordCompletions.AllPropertyNamesPlaceholder],"animation-direction":["normal","alternate","reverse","alternate-reverse"],"animation-fill-mode":["none","forwards","backwards","both"],"animation-iteration-count":["infinite"],"animation-play-state":["paused","running"],"animation-timing-function":["ease","linear","ease-in","ease-out","ease-in-out","step-start","step-end","steps()","cubic-bezier()","spring()"],"align-content":["auto","baseline","last-baseline","space-between","space-around","space-evenly","stretch","center","start","end","flex-start","flex-end","left","right","true","safe"],"justify-content":["auto","baseline","last-baseline","space-between","space-around","space-evenly","stretch","center","start","end","flex-start","flex-end","left","right","true","safe"],"align-items":["auto","stretch","baseline","last-baseline","center","start","end","self-start","self-end","flex-start","flex-end","left","right","true","safe"],"align-self":["auto","stretch","baseline","last-baseline","center","start","end","self-start","self-end","flex-start","flex-end","left","right","true","safe"],"justify-items":["auto","stretch","baseline","last-baseline","center","start","end","self-start","self-end","flex-start","flex-end","left","right","true","safe"],"justify-self":["auto","stretch","baseline","last-baseline","center","start","end","self-start","self-end","flex-start","flex-end","left","right","true","safe"],"flex-flow":["row","row-reverse","column","column-reverse","nowrap","wrap","wrap-reverse"],"flex":["none"],"flex-basis":["auto"],"grid":["none"],"grid-area":["auto"],"grid-auto-columns":["auto","max-content","-webkit-max-content","min-content","-webkit-min-content","minmax()",],"grid-auto-flow":["row","column","dense"],"grid-auto-rows":["auto","max-content","-webkit-max-content","min-content","-webkit-min-content","minmax()",],"grid-column":["auto"],"grid-column-start":["auto"],"grid-column-end":["auto"],"grid-row":["auto"],"grid-row-start":["auto"],"grid-row-end":["auto"],"grid-template":["none"],"grid-template-areas":["none"],"grid-template-columns":["none","auto","max-content","-webkit-max-content","min-content","-webkit-min-content","minmax()","repeat()"],"grid-template-rows":["none","auto","max-content","-webkit-max-content","min-content","-webkit-min-content","minmax()","repeat()"],"scroll-snap-align":["none","start","center","end"],"scroll-snap-type":["none","mandatory","proximity","x","y","inline","block","both"],"-webkit-mask-composite":["clear","copy","source-over","source-in","source-out","source-atop","destination-over","destination-in","destination-out","destination-atop","xor","plus-darker","plus-lighter"],"-webkit-text-stroke-width":["medium","thick","thin","calc()"],"-webkit-aspect-ratio":["auto","from-dimensions","from-intrinsic","/"],"filter":["none","grayscale()","sepia()","saturate()","hue-rotate()","invert()","opacity()","brightness()","contrast()","blur()","drop-shadow()","custom()"],"-webkit-backdrop-filter":["none","grayscale()","sepia()","saturate()","hue-rotate()","invert()","opacity()","brightness()","contrast()","blur()","drop-shadow()","custom()"],"-webkit-hyphenate-character":["none"],"-webkit-hyphenate-limit-after":["auto"],"-webkit-hyphenate-limit-before":["auto"],"-webkit-hyphenate-limit-lines":["no-limit"],"-webkit-line-grid":["none"],"-webkit-locale":["auto"],"-webkit-line-box-contain":["block","inline","font","glyphs","replaced","inline-box","none"],"font-feature-settings":["normal"],"-webkit-animation-trigger":["auto","container-scroll()"],"-webkit-text-size-adjust":["none","auto"],"-apple-pay-button-style":["black","white","white-outline",],"-apple-pay-button-type":["plain","buy","set-up","donate","check-out","book","subscribe",],"-webkit-alt":["attr()",],"-webkit-animation-direction":["normal","alternate","reverse","alternate-reverse",],"-webkit-animation-fill-mode":["none","forwards","backwards","both",],"-webkit-animation-iteration-count":["infinite",],"-webkit-animation-play-state":["paused","running",],"-webkit-animation-timing-function":["ease","linear","ease-in","ease-out","ease-in-out","step-start","step-end","steps()","cubic-bezier()","spring()",],"-webkit-appearance":["none","checkbox","radio","push-button","square-button","button","button-bevel","default-button","inner-spin-button","listbox","listitem","media-controls-background","media-controls-dark-bar-background","media-controls-fullscreen-background","media-controls-light-bar-background","media-current-time-display","media-enter-fullscreen-button","media-exit-fullscreen-button","media-fullscreen-volume-slider","media-fullscreen-volume-slider-thumb","media-mute-button","media-overlay-play-button","media-play-button","media-return-to-realtime-button","media-rewind-button","media-seek-back-button","media-seek-forward-button","media-slider","media-sliderthumb","media-time-remaining-display","media-toggle-closed-captions-button","media-volume-slider","media-volume-slider-container","media-volume-slider-mute-button","media-volume-sliderthumb","menulist","menulist-button","menulist-text","menulist-textfield","meter","progress-bar","progress-bar-value","slider-horizontal","slider-vertical","sliderthumb-horizontal","sliderthumb-vertical","caret","searchfield","searchfield-decoration","searchfield-results-decoration","searchfield-results-button","searchfield-cancel-button","snapshotted-plugin-overlay","textfield","relevancy-level-indicator","continuous-capacity-level-indicator","discrete-capacity-level-indicator","rating-level-indicator","-apple-pay-button","textarea","attachment","borderless-attachment","caps-lock-indicator",],"-webkit-backface-visibility":["hidden","visible",],"-webkit-border-after-width":["medium","thick","thin","calc()",],"-webkit-border-before-width":["medium","thick","thin","calc()",],"-webkit-border-end-width":["medium","thick","thin","calc()",],"-webkit-border-start-width":["medium","thick","thin","calc()",],"-webkit-box-align":["baseline","center","stretch","start","end",],"-webkit-box-decoration-break":["clone","slice",],"-webkit-box-direction":["normal","reverse",],"-webkit-box-lines":["single","multiple",],"-webkit-box-orient":["horizontal","vertical","inline-axis","block-axis",],"-webkit-box-pack":["center","justify","start","end",],"-webkit-column-axis":["auto","horizontal","vertical",],"-webkit-column-count":["auto","calc()",],"-webkit-column-fill":["auto","balance",],"-webkit-column-gap":["normal","calc()",],"-webkit-column-progression":["normal","reverse",],"-webkit-column-rule-width":["medium","thick","thin","calc()",],"-webkit-column-span":["all","none","calc()",],"-webkit-column-width":["auto","calc()",],"-webkit-cursor-visibility":["auto","auto-hide",],"-webkit-font-kerning":["none","normal","auto",],"-webkit-font-smoothing":["none","auto","antialiased","subpixel-antialiased",],"-webkit-hyphens":["none","auto","manual",],"-webkit-line-align":["none","edges",],"-webkit-line-break":["auto","loose","normal","strict","after-white-space",],"-webkit-line-snap":["none","baseline","contain",],"-webkit-logical-height":["auto","intrinsic","min-intrinsic","min-content","-webkit-min-content","max-content","-webkit-max-content","-webkit-fill-available","fit-content","-webkit-fit-content","calc()"],"-webkit-logical-width":["auto","intrinsic","min-intrinsic","min-content","-webkit-min-content","max-content","-webkit-max-content","-webkit-fill-available","fit-content","-webkit-fit-content","calc()"],"-webkit-max-logical-height":["auto","intrinsic","min-intrinsic","min-content","-webkit-min-content","max-content","-webkit-max-content","-webkit-fill-available","fit-content","-webkit-fit-content","none","calc()"],"-webkit-max-logical-width":["auto","intrinsic","min-intrinsic","min-content","-webkit-min-content","max-content","-webkit-max-content","-webkit-fill-available","fit-content","-webkit-fit-content","none","calc()"],"-webkit-min-logical-height":["auto","intrinsic","min-intrinsic","min-content","-webkit-min-content","max-content","-webkit-max-content","-webkit-fill-available","fit-content","-webkit-fit-content","calc()"],"-webkit-min-logical-width":["auto","intrinsic","min-intrinsic","min-content","-webkit-min-content","max-content","-webkit-max-content","-webkit-fill-available","fit-content","-webkit-fit-content","calc()"],"-webkit-nbsp-mode":["normal","space",],"-webkit-overflow-scrolling":["auto","touch",],"print-color-adjust":["economy","exact",],"-webkit-rtl-ordering":["logical","visual",],"-webkit-ruby-position":["after","before","inter-character",],"-webkit-text-combine":["none","horizontal",],"-webkit-text-decoration-style":["dotted","dashed","solid","double","wavy",],"-webkit-text-orientation":["sideways","sideways-right","upright","mixed",],"-webkit-text-security":["none","disc","circle","square",],"-webkit-text-zoom":["normal","reset",],"-webkit-transform-style":["flat","preserve-3d",],"-webkit-user-drag":["none","auto","element",],"-webkit-user-modify":["read-only","read-write","read-write-plaintext-only",],"-webkit-user-select":["none","all","auto","text",],"-webkit-writing-mode":["lr","rl","tb","lr-tb","rl-tb","tb-rl","horizontal-tb","vertical-rl","vertical-lr","horizontal-bt",],"alignment-baseline":["baseline","middle","auto","alphabetic","before-edge","after-edge","central","text-before-edge","text-after-edge","ideographic","hanging","mathematical",],"border-block-end-style":["none","hidden","inset","groove","outset","ridge","dotted","dashed","solid","double",],"border-block-start-style":["none","hidden","inset","groove","outset","ridge","dotted","dashed","solid","double",],"border-bottom-style":["none","hidden","inset","groove","outset","ridge","dotted","dashed","solid","double",],"border-collapse":["collapse","separate",],"border-inline-end-style":["none","hidden","inset","groove","outset","ridge","dotted","dashed","solid","double",],"border-inline-start-style":["none","hidden","inset","groove","outset","ridge","dotted","dashed","solid","double",],"border-left-style":["none","hidden","inset","groove","outset","ridge","dotted","dashed","solid","double",],"border-right-style":["none","hidden","inset","groove","outset","ridge","dotted","dashed","solid","double",],"border-top-style":["none","hidden","inset","groove","outset","ridge","dotted","dashed","solid","double",],"box-sizing":["border-box","content-box",],"break-after":["left","right","auto","avoid","column","avoid-column","avoid-page","page","recto","verso",],"break-before":["left","right","auto","avoid","column","avoid-column","avoid-page","page","recto","verso",],"break-inside":["auto","avoid","avoid-column","avoid-page",],"buffered-rendering":["auto","static","dynamic",],"caption-side":["top","bottom","left","right",],"clear":["none","left","right","both",],"clip-rule":["nonzero","evenodd",],"color-interpolation":["auto","sRGB","linearRGB",],"color-interpolation-filters":["auto","sRGB","linearRGB",],"color-rendering":["auto","optimizeSpeed","optimizeQuality",],"column-fill":["auto","balance",],"column-rule-style":["none","hidden","inset","groove","outset","ridge","dotted","dashed","solid","double",],"direction":["ltr","rtl",],"display":["none","inline","block","list-item","compact","inline-block","table","inline-table","table-row-group","table-header-group","table-footer-group","table-row","table-column-group","table-column","table-cell","table-caption","-webkit-box","-webkit-inline-box","flex","-webkit-flex","inline-flex","-webkit-inline-flex","contents","grid","inline-grid",],"dominant-baseline":["middle","auto","alphabetic","central","text-before-edge","text-after-edge","ideographic","hanging","mathematical","use-script","no-change","reset-size",],"empty-cells":["hide","show",],"fill-rule":["nonzero","evenodd",],"flex-direction":["row","row-reverse","column","column-reverse",],"flex-wrap":["nowrap","wrap-reverse","wrap",],"float":["none","left","right",],"font-optical-sizing":["none","auto",],"font-variant-alternates":["historical-forms","normal",],"font-variant-caps":["small-caps","all-small-caps","petite-caps","all-petite-caps","unicase","titling-caps","normal",],"font-variant-position":["normal","sub","super",],"image-rendering":["auto","optimizeSpeed","optimizeQuality","crisp-edges","pixelated","-webkit-crisp-edges","-webkit-optimize-contrast",],"image-resolution":["from-image","snap",],"isolation":["auto","isolate",],"line-break":["normal","auto","loose","strict","after-white-space",],"list-style-position":["outside","inside",],"list-style-type":["none","disc","circle","square","decimal","decimal-leading-zero","arabic-indic","binary","bengali","cambodian","khmer","devanagari","gujarati","gurmukhi","kannada","lower-hexadecimal","lao","malayalam","mongolian","myanmar","octal","oriya","persian","urdu","telugu","tibetan","thai","upper-hexadecimal","lower-roman","upper-roman","lower-greek","lower-alpha","lower-latin","upper-alpha","upper-latin","afar","ethiopic-halehame-aa-et","ethiopic-halehame-aa-er","amharic","ethiopic-halehame-am-et","amharic-abegede","ethiopic-abegede-am-et","cjk-earthly-branch","cjk-heavenly-stem","ethiopic","ethiopic-halehame-gez","ethiopic-abegede","ethiopic-abegede-gez","hangul-consonant","hangul","lower-norwegian","oromo","ethiopic-halehame-om-et","sidama","ethiopic-halehame-sid-et","somali","ethiopic-halehame-so-et","tigre","ethiopic-halehame-tig","tigrinya-er","ethiopic-halehame-ti-er","tigrinya-er-abegede","ethiopic-abegede-ti-er","tigrinya-et","ethiopic-halehame-ti-et","tigrinya-et-abegede","ethiopic-abegede-ti-et","upper-greek","upper-norwegian","asterisks","footnotes","hebrew","armenian","lower-armenian","upper-armenian","georgian","cjk-ideographic","hiragana","katakana","hiragana-iroha","katakana-iroha",],"mask-type":["alpha","luminance",],"max-zoom":["auto",],"min-zoom":["auto",],"mix-blend-mode":["normal","plus-darker","plus-lighter","overlay","multiply","screen","darken","lighten","color-dodge","color-burn","hard-light","soft-light","difference","exclusion","hue","saturation","color","luminosity",],"object-fit":["none","contain","cover","fill","scale-down",],"orientation":["auto","portait","landscape",],"outline-style":["none","inset","groove","outset","ridge","dotted","dashed","solid","double","auto",],"overflow-wrap":["normal","break-word",],"overflow-x":["hidden","auto","visible","scroll",],"overflow-y":["hidden","auto","visible","scroll","-webkit-paged-x","-webkit-paged-y",],"pointer-events":["none","all","auto","visible","visiblePainted","visibleFill","visibleStroke","painted","fill","stroke",],"position":["absolute","fixed","relative","static","sticky","-webkit-sticky",],"resize":["none","auto","both","horizontal","vertical",],"shape-rendering":["auto","optimizeSpeed","geometricPrecision","crispedges",],"stroke-linecap":["square","round","butt",],"stroke-linejoin":["round","miter","bevel",],"table-layout":["auto","fixed",],"text-align":["-webkit-auto","left","right","center","justify","match-parent","-webkit-left","-webkit-right","-webkit-center","-webkit-match-parent","start","end",],"text-align-last":["auto","start","end","left","right","center","justify","match-parent",],"text-anchor":["middle","start","end",],"text-justify":["auto","none","inter-word","inter-character","distribute",],"text-line-through":["none","dotted","dashed","solid","double","dot-dash","dot-dot-dash","wave","continuous","skip-white-space",],"text-line-through-mode":["continuous","skip-white-space",],"text-line-through-style":["none","dotted","dashed","solid","double","dot-dash","dot-dot-dash","wave",],"text-line-through-width":["normal","medium","auto","thick","thin",],"text-overflow":["clip","ellipsis",],"text-overline-mode":["continuous","skip-white-space",],"text-overline-style":["none","dotted","dashed","solid","double","dot-dash","dot-dot-dash","wave",],"text-overline-width":["normal","medium","auto","thick","thin","calc()",],"text-rendering":["auto","optimizeSpeed","optimizeLegibility","geometricPrecision",],"text-transform":["none","capitalize","uppercase","lowercase",],"text-underline":["none","dotted","dashed","solid","double","dot-dash","dot-dot-dash","wave",],"text-underline-mode":["continuous","skip-white-space",],"text-underline-style":["none","dotted","dashed","solid","double","dot-dash","dot-dot-dash","wave",],"text-underline-width":["normal","medium","auto","thick","thin","calc()",],"transform-style":["flat","preserve-3d",],"unicode-bidi":["normal","bidi-override","embed","isolate-override","plaintext","-webkit-isolate","-webkit-isolate-override","-webkit-plaintext","isolate",],"user-zoom":["zoom","fixed",],"vector-effect":["none",],"visibility":["hidden","visible","collapse",],"white-space":["normal","nowrap","pre","pre-line","pre-wrap",],"word-break":["normal","break-all","keep-all","break-word",],"word-wrap":["normal","break-word",],"writing-mode":["lr","rl","tb","lr-tb","rl-tb","tb-rl","horizontal-tb","vertical-rl","vertical-lr","horizontal-bt",],};WI.CSSProperty=class CSSProperty extends WI.Object
{constructor(index,text,name,value,priority,enabled,overridden,implicit,anonymous,valid,styleSheetTextRange)
{WI.CSSProperty._initializePropertyNameCounts();super();this._ownerStyle=null;this._index=index;this._overridingProperty=null;this._initialState=null;this._modified=false;this._isUpdatingText=false;this.update(text,name,value,priority,enabled,overridden,implicit,anonymous,valid,styleSheetTextRange,true);}
static isInheritedPropertyName(name)
{if(WI.CSSKeywordCompletions.InheritedProperties.has(name))
return true;return name.startsWith("--");}
static findVariableNames(string)
{const prefix="var(--";let prefixCursor=0;let cursor=0;let nameStartIndex=0;let names=[];function isTerminatingChar(char){return char===")"||char===","||char===" "||char==="\n"||char==="\t";}
while(cursor<string.length){if(nameStartIndex&&isTerminatingChar(string.charAt(cursor))){names.push("--"+string.substring(nameStartIndex,cursor));nameStartIndex=0;}
if(prefixCursor===prefix.length){prefixCursor=0;nameStartIndex=cursor;}
if(string.charAt(cursor)===prefix.charAt(prefixCursor))
prefixCursor++;cursor++;}
return names;}
static sortByPropertyNameUsageCount(propertyNameA,propertyNameB)
{let countA=WI.CSSProperty._cachedNameCounts[propertyNameA];let countB=WI.CSSProperty._cachedNameCounts[propertyNameB];const minimumCount=100;let validA=countA>=minimumCount;let validB=countB>=minimumCount;if(validA&&!validB)
return-1;if(!validA&&validB)
return 1;if(validA&&validB){if(countA!==countB)
return countB-countA;let canonicalPropertyNameA=WI.cssManager.canonicalNameForPropertyName(propertyNameA);let canonicalPropertyNameB=WI.cssManager.canonicalNameForPropertyName(propertyNameB);if(canonicalPropertyNameA!==propertyNameA||canonicalPropertyNameB!==propertyNameB)
return WI.CSSProperty.sortByPropertyNameUsageCount(canonicalPropertyNameA,canonicalPropertyNameB);}
return 0;}
static _initializePropertyNameCounts()
{if(WI.CSSProperty._cachedNameCounts)
return;WI.CSSProperty._cachedNameCounts={};WI.CSSProperty._storedNameCountsQueue=new Promise((resolve,reject)=>{WI.objectStores.cssPropertyNameCounts.getAllKeys().then((propertyNames)=>{Promise.allSettled(propertyNames.map(async(propertyName)=>{let storedCount=await WI.objectStores.cssPropertyNameCounts.get(propertyName);WI.CSSProperty._cachedNameCounts[propertyName]=(WI.CSSProperty._cachedNameCounts[propertyName]||0)+storedCount;})).then(resolve,reject);});});}
get ownerStyle()
{return this._ownerStyle;}
set ownerStyle(ownerStyle)
{this._ownerStyle=ownerStyle||null;}
get index()
{return this._index;}
set index(index)
{this._index=index;}
update(text,name,value,priority,enabled,overridden,implicit,anonymous,valid,styleSheetTextRange,dontFireEvents)
{if(this._ownerStyle&&this._ownerStyle.locked&&text!==this._text)
return;text=text||"";name=name||"";value=value||"";priority=priority||"";enabled=enabled||false;overridden=overridden||false;implicit=implicit||false;anonymous=anonymous||false;valid=valid||false;var changed=false;if(!dontFireEvents){changed=this._name!==name||this._rawValue!==value||this._priority!==priority||this._enabled!==enabled||this._implicit!==implicit||this._anonymous!==anonymous||this._valid!==valid;}
if(!dontFireEvents)
this.overridden=overridden;else
this._overridden=overridden;if(!overridden)
this._overridingProperty=null;this._text=text;this._rawValue=value;this._value=undefined;this._priority=priority;this._enabled=enabled;this._implicit=implicit;this._anonymous=anonymous;this._inherited=WI.CSSProperty.isInheritedPropertyName(name);this._valid=valid;this._isVariable=name.startsWith("--");this._styleSheetTextRange=styleSheetTextRange||null;this._rawValueNewlineIndent="";if(this._rawValue){let match=this._rawValue.match(/^[^\n]+\n(\s*)/);if(match)
this._rawValueNewlineIndent=match[1];}
this._rawValue=this._rawValue.replace(/\n\s+/g,"\n");this._isShorthand=undefined;this._shorthandPropertyNames=undefined;this._updateName(name);this._relatedShorthandProperty=null;this._relatedLonghandProperties=[];delete this._styleDeclarationTextRange;delete this._canonicalName;delete this._hasOtherVendorNameOrKeyword;if(changed)
this.dispatchEventToListeners(WI.CSSProperty.Event.Changed);}
remove()
{this._markModified();this._updateName("");const forceRemove=true;this._updateStyleText(forceRemove);}
commentOut(disabled)
{if(this._enabled===!disabled)
return;this._markModified();this._enabled=!disabled;if(disabled)
this.text="/* "+this._text+" */";else
this.text=this._text.slice(2,-2).trim();}
get text()
{return this._text;}
set text(newText)
{newText=newText.trim();if(this._text===newText)
return;this._markModified();this._text=newText;this._isUpdatingText=true;this._updateOwnerStyleText();this._isUpdatingText=false;}
get formattedText()
{if(this._isUpdatingText)
return this._text;if(!this._name)
return"";let text=`${this._name}: ${this._rawValue};`;if(!this._enabled)
text="/* "+text+" */";return text;}
get modified()
{return this._modified;}
set modified(value)
{if(this._modified===value)
return;this._modified=value;this.dispatchEventToListeners(WI.CSSProperty.Event.ModifiedChanged);}
get name()
{return this._name;}
set name(name)
{if(name===this._name)
return;if(!name){this._indexBeforeDetached=this._index;}else if(!isNaN(this._indexBeforeDetached)&&isNaN(this._index)){this._ownerStyle.insertProperty(this,this._indexBeforeDetached);this._indexBeforeDetached=NaN;}
this._markModified();this._updateName(name);this._updateStyleText();}
get canonicalName()
{if(this._canonicalName)
return this._canonicalName;this._canonicalName=WI.cssManager.canonicalNameForPropertyName(this.name);return this._canonicalName;}
get value()
{if(!this._value)
this._value=this._rawValue.replace(/\s*!important\s*$/,"");return this._value;}
get rawValue()
{return this._rawValue;}
set rawValue(value)
{if(value===this._rawValue)
return;this._markModified();let suffix=WI.CSSCompletions.completeUnbalancedValue(value);if(suffix)
value+=suffix;this._rawValue=value;this._value=undefined;this._updateStyleText();}
get important()
{return this.priority==="important";}
get priority(){return this._priority;}
get attached()
{return this._enabled&&this._ownerStyle&&(!isNaN(this._index)||this._ownerStyle.type===WI.CSSStyleDeclaration.Type.Computed);}
get enabled(){return this._enabled;}
get overridden(){return this._overridden;}
set overridden(overridden)
{overridden=overridden||false;if(this._overridden===overridden)
return;if(!overridden)
this._overridingProperty=null;var previousOverridden=this._overridden;this._overridden=overridden;if(this._overriddenStatusChangedTimeout)
return;function delayed()
{delete this._overriddenStatusChangedTimeout;if(this._overridden===previousOverridden)
return;this.dispatchEventToListeners(WI.CSSProperty.Event.OverriddenStatusChanged);}
this._overriddenStatusChangedTimeout=setTimeout(delayed.bind(this),0);}
get overridingProperty()
{return this._overridingProperty;}
set overridingProperty(effectiveProperty)
{if(!WI.settings.experimentalEnableStylesJumpToEffective.value)
return;this._overridingProperty=effectiveProperty||null;}
get implicit(){return this._implicit;}
set implicit(implicit){this._implicit=implicit;}
get anonymous(){return this._anonymous;}
get inherited(){return this._inherited;}
get valid(){return this._valid;}
get isVariable(){return this._isVariable;}
get styleSheetTextRange(){return this._styleSheetTextRange;}
get initialState()
{return this._initialState;}
get editable()
{return!!(this._styleSheetTextRange&&this._ownerStyle&&this._ownerStyle.styleSheetTextRange);}
get styleDeclarationTextRange()
{if("_styleDeclarationTextRange"in this)
return this._styleDeclarationTextRange;if(!this._ownerStyle||!this._styleSheetTextRange)
return null;var styleTextRange=this._ownerStyle.styleSheetTextRange;if(!styleTextRange)
return null;var startLine=this._styleSheetTextRange.startLine-styleTextRange.startLine;var endLine=this._styleSheetTextRange.endLine-styleTextRange.startLine;var startColumn=this._styleSheetTextRange.startColumn;if(!startLine)
startColumn-=styleTextRange.startColumn;var endColumn=this._styleSheetTextRange.endColumn;if(!endLine)
endColumn-=styleTextRange.startColumn;this._styleDeclarationTextRange=new WI.TextRange(startLine,startColumn,endLine,endColumn);return this._styleDeclarationTextRange;}
get relatedShorthandProperty(){return this._relatedShorthandProperty;}
set relatedShorthandProperty(property)
{this._relatedShorthandProperty=property||null;}
get relatedLonghandProperties(){return this._relatedLonghandProperties;}
addRelatedLonghandProperty(property)
{this._relatedLonghandProperties.push(property);}
clearRelatedLonghandProperties(property)
{this._relatedLonghandProperties=[];}
get isShorthand()
{if(this._isShorthand===undefined){this._isShorthand=WI.CSSKeywordCompletions.LonghandNamesForShorthandProperty.has(this._name);if(this._isShorthand){let longhands=WI.CSSKeywordCompletions.LonghandNamesForShorthandProperty.get(this._name);if(longhands&&longhands.length===1)
this._isShorthand=false;}}
return this._isShorthand;}
get shorthandPropertyNames()
{if(!this._shorthandPropertyNames){this._shorthandPropertyNames=WI.CSSKeywordCompletions.ShorthandNamesForLongHandProperty.get(this._name)||[];this._shorthandPropertyNames.remove("all");}
return this._shorthandPropertyNames;}
hasOtherVendorNameOrKeyword()
{if("_hasOtherVendorNameOrKeyword"in this)
return this._hasOtherVendorNameOrKeyword;this._hasOtherVendorNameOrKeyword=WI.cssManager.propertyNameHasOtherVendorPrefix(this.name)||WI.cssManager.propertyValueHasOtherVendorKeyword(this.value);return this._hasOtherVendorNameOrKeyword;}
equals(property)
{if(property===this)
return true;if(!property)
return false;return this._name===property.name&&this._rawValue===property.rawValue&&this._enabled===property.enabled;}
clone()
{let cssProperty=new WI.CSSProperty(this._index,this._text,this._name,this._rawValue,this._priority,this._enabled,this._overridden,this._implicit,this._anonymous,this._valid,this._styleSheetTextRange);cssProperty.ownerStyle=this._ownerStyle;return cssProperty;}
_updateName(name)
{if(name===this._name)
return;let changeCount=(propertyName,delta)=>{if(!propertyName||this._implicit||this._anonymous||!this._enabled)
return;let cachedCount=WI.CSSProperty._cachedNameCounts[propertyName];if(isNaN(cachedCount)&&!WI.cssManager.propertyNameCompletions.isValidPropertyName(propertyName))
return;WI.CSSProperty._cachedNameCounts[propertyName]=Math.max(0,(cachedCount||0)+delta);WI.CSSProperty._storedNameCountsQueue=WI.CSSProperty._storedNameCountsQueue.finally(async()=>{let storedCount=await WI.objectStores.cssPropertyNameCounts.get(propertyName);await WI.objectStores.cssPropertyNameCounts.put(Math.max(0,(storedCount||0)+delta),propertyName);});if(propertyName!==this.canonicalName)
changeCount(this.canonicalName,delta);};changeCount(this._name,-1);this._name=name;changeCount(this._name,1);}
_updateStyleText(forceRemove=false)
{let text="";if(this._name&&this._rawValue){let value=this._rawValue.replace(/\n/g,"\n"+this._rawValueNewlineIndent);text=this._name+": "+value+";";}
this._text=text;if(forceRemove)
this._ownerStyle.removeProperty(this);this._updateOwnerStyleText();}
_updateOwnerStyleText()
{if(!this._ownerStyle)
return;this._ownerStyle.text=this._ownerStyle.generateFormattedText({multiline:this._ownerStyle.type===WI.CSSStyleDeclaration.Type.Rule});this._ownerStyle.updatePropertiesModifiedState();}
_markModified()
{if(this._ownerStyle)
this._ownerStyle.markModified();}};WI.CSSProperty._cachedNameCounts=null;WI.CSSProperty._storedNameCountsQueue=null;WI.CSSProperty.Event={Changed:"css-property-changed",ModifiedChanged:"css-property-modified-changed",OverriddenStatusChanged:"css-property-overridden-status-changed"};WI.CSSPropertyNameCompletions=class CSSPropertyNameCompletions extends WI.CSSCompletions
{constructor(properties,options={})
{let values=[];for(let property of properties){values.push(property.name);if(Array.isArray(property.aliases))
values.pushAll(property.aliases);}
super(values,options);this._cachedSortedPropertyNames=this.values.slice();this._needsVariablesFromInspectedNode=true;WI.domManager.addEventListener(WI.DOMManager.Event.InspectedNodeChanged,this._handleInspectedNodeChanged,this);}
isValidPropertyName(name)
{return this.values.includes(name);}
executeQuery(query)
{this._updateValuesWithLatestCSSVariablesIfNeeded();return super.executeQuery(query);}
startsWith(prefix)
{this._updateValuesWithLatestCSSVariablesIfNeeded();return super.startsWith(prefix);}
_updateValuesWithLatestCSSVariablesIfNeeded()
{if(!this._needsVariablesFromInspectedNode)
return;if(!WI.domManager.inspectedNode){this._needsVariablesFromInspectedNode=false;return;}
let values=Array.from(WI.cssManager.stylesForNode(WI.domManager.inspectedNode).allCSSVariables);values.pushAll(this._cachedSortedPropertyNames);this.replaceValues(values);this._needsVariablesFromInspectedNode=false;}
_handleInspectedNodeChanged(event)
{this._needsVariablesFromInspectedNode=true;if(event.data.lastInspectedNode)
WI.cssManager.stylesForNode(event.data.lastInspectedNode).removeEventListener(WI.DOMNodeStyles.Event.NeedsRefresh,this._handleNodesStylesNeedsRefresh,this);WI.cssManager.stylesForNode(WI.domManager.inspectedNode).addEventListener(WI.DOMNodeStyles.Event.NeedsRefresh,this._handleNodesStylesNeedsRefresh,this);}
_handleNodesStylesNeedsRefresh(event)
{this._needsVariablesFromInspectedNode=true;}};WI.CSSRule=class CSSRule extends WI.Object
{constructor(nodeStyles,ownerStyleSheet,id,type,sourceCodeLocation,selectorText,selectors,matchedSelectorIndices,style,groupings)
{super();this._nodeStyles=nodeStyles;this._ownerStyleSheet=ownerStyleSheet||null;this._id=id||null;this._type=type||null;this._initialState=null;this.update(sourceCodeLocation,selectorText,selectors,matchedSelectorIndices,style,groupings,true);}
get ownerStyleSheet(){return this._ownerStyleSheet;}
get id(){return this._id;}
get type(){return this._type;}
get initialState(){return this._initialState;}
get sourceCodeLocation(){return this._sourceCodeLocation;}
get selectors(){return this._selectors;}
get matchedSelectorIndices(){return this._matchedSelectorIndices;}
get style(){return this._style;}
get groupings(){return this._groupings;}
get editable()
{return!!this._id&&this._type!==WI.CSSStyleSheet.Type.UserAgent;}
get selectorText()
{return this._selectorText;}
setSelectorText(selectorText)
{if(!this.editable)
return Promise.reject();return this._nodeStyles.changeRuleSelector(this,selectorText).then(this._selectorResolved.bind(this));}
update(sourceCodeLocation,selectorText,selectors,matchedSelectorIndices,style,groupings)
{sourceCodeLocation=sourceCodeLocation||null;selectorText=selectorText||"";selectors=selectors||[];matchedSelectorIndices=matchedSelectorIndices||[];style=style||null;groupings=groupings||[];if(this._style)
this._style.ownerRule=null;this._sourceCodeLocation=sourceCodeLocation;this._selectorText=selectorText;this._selectors=selectors;this._matchedSelectorIndices=matchedSelectorIndices;this._style=style;this._groupings=groupings;if(this._style)
this._style.ownerRule=this;}
isEqualTo(rule)
{if(!rule)
return false;return Object.shallowEqual(this._id,rule.id);}
get nodeStyles()
{return this._nodeStyles;}
_selectorResolved(rulePayload)
{if(!rulePayload)
return;let selectorText=rulePayload.selectorList.text;if(selectorText===this._selectorText)
return;let selectors=WI.DOMNodeStyles.parseSelectorListPayload(rulePayload.selectorList);let sourceCodeLocation=null;let sourceRange=rulePayload.selectorList.range;if(sourceRange){sourceCodeLocation=WI.DOMNodeStyles.createSourceCodeLocation(rulePayload.sourceURL,{line:sourceRange.startLine,column:sourceRange.startColumn,documentNode:this._nodeStyles.node.ownerDocument,});}
if(this._ownerStyleSheet){if(!sourceCodeLocation&&sourceRange)
sourceCodeLocation=this._ownerStyleSheet.createSourceCodeLocation(sourceRange.startLine,sourceRange.startColumn);sourceCodeLocation=this._ownerStyleSheet.offsetSourceCodeLocation(sourceCodeLocation);}
this.update(sourceCodeLocation,selectorText,selectors,[],this._style,this._groupings);}};WI.CSSSelector=class CSSSelector
{constructor(text,specificity,dynamic)
{this._text=text;this._specificity=specificity||null;this._dynamic=dynamic||false;}
get text(){return this._text;}
get specificity(){return this._specificity;}
get dynamic(){return this._dynamic;}
isPseudoSelector()
{return Object.values(WI.CSSManager.PseudoSelectorNames).some((pseudoId)=>(new RegExp("(?:\\b|^):{1,2}(?:-webkit-)?"+pseudoId+"(?:\\b|$)")).test(this._text));}};WI.CSSStyleDeclaration=class CSSStyleDeclaration extends WI.Object
{constructor(nodeStyles,ownerStyleSheet,id,type,node,inherited,text,properties,styleSheetTextRange)
{super();this._nodeStyles=nodeStyles;this._ownerRule=null;this._ownerStyleSheet=ownerStyleSheet||null;this._id=id||null;this._type=type||null;this._node=node||null;this._inherited=inherited||false;this._initialState=null;this._updatesInProgressCount=0;this._pendingPropertiesChanged=false;this._locked=false;this._pendingProperties=[];this._propertyNameMap={};this._properties=[];this._enabledProperties=null;this._visibleProperties=null;this.update(text,properties,styleSheetTextRange,{dontFireEvents:true});}
get initialState(){return this._initialState;}
get id()
{return this._id;}
get stringId()
{if(this._id)
return this._id.styleSheetId+"/"+this._id.ordinal;else
return"";}
get ownerStyleSheet()
{return this._ownerStyleSheet;}
get type()
{return this._type;}
get inherited()
{return this._inherited;}
get node()
{return this._node;}
get editable()
{if(!this._id)
return false;if(this._type===WI.CSSStyleDeclaration.Type.Rule)
return this._ownerRule&&this._ownerRule.editable;if(this._type===WI.CSSStyleDeclaration.Type.Inline)
return!this._node.isInUserAgentShadowTree()||WI.DOMManager.supportsEditingUserAgentShadowTrees();return false;}
get selectorEditable()
{return this._ownerRule&&this._ownerRule.editable&&InspectorBackend.hasCommand("CSS.setRuleSelector");}
get locked(){return this._locked;}
set locked(value){this._locked=value;}
update(text,properties,styleSheetTextRange,options={})
{let dontFireEvents=options.dontFireEvents||false;if(this._updatesInProgressCount>0&&!options.forceUpdate){if(WI.settings.debugEnableStyleEditingDebugMode.value&&text!==this._text)
console.warn("Style modified while editing:",text);return;}
if(this._locked&&!options.forceUpdate&&text!==this._text)
return;text=text||"";properties=properties||[];let oldProperties=this._properties||[];let oldText=this._text;this._text=text;this._properties=properties;this._styleSheetTextRange=styleSheetTextRange;this._propertyNameMap={};this._enabledProperties=null;this._visibleProperties=null;let editable=this.editable;for(let property of this._properties){property.ownerStyle=this;if(!editable)
this._propertyNameMap[property.name]=property;else{this._pendingProperties.remove(property);}}
for(let oldProperty of oldProperties){if(this.enabledProperties.includes(oldProperty))
continue;oldProperty.index=NaN;if(editable)
this._pendingProperties.push(oldProperty);}
if(dontFireEvents)
return;if(oldText===this._text&&!this._pendingPropertiesChanged&&this._type!==WI.CSSStyleDeclaration.Type.Computed)
return;this._pendingPropertiesChanged=false;function delayed()
{this.dispatchEventToListeners(WI.CSSStyleDeclaration.Event.PropertiesChanged);}
setTimeout(delayed.bind(this),0);}
get ownerRule()
{return this._ownerRule;}
set ownerRule(rule)
{this._ownerRule=rule||null;}
get text()
{return this._text;}
set text(text)
{if(this._text===text)
return;let trimmedText=text.trim();if(this._text===trimmedText)
return;if(!trimmedText.length||this._type===WI.CSSStyleDeclaration.Type.Inline)
text=trimmedText;this._text=text;++this._updatesInProgressCount;let timeoutId=setTimeout(()=>{console.error("Timed out when setting style text:",text);styleTextDidChange();},2000);let styleTextDidChange=()=>{if(!timeoutId)
return;clearTimeout(timeoutId);timeoutId=null;this._updatesInProgressCount=Math.max(0,this._updatesInProgressCount-1);this._pendingPropertiesChanged=true;};this._nodeStyles.changeStyleText(this,text,styleTextDidChange);}
get enabledProperties()
{if(!this._enabledProperties)
this._enabledProperties=this._properties.filter((property)=>property.enabled);return this._enabledProperties;}
get properties()
{return this._properties;}
set properties(properties)
{if(properties===this._properties)
return;this._properties=properties;this._enabledProperties=null;this._visibleProperties=null;}
get visibleProperties()
{if(!this._visibleProperties)
this._visibleProperties=this._properties.filter((property)=>!!property.styleDeclarationTextRange);return this._visibleProperties;}
get pendingProperties()
{return this._pendingProperties;}
get styleSheetTextRange()
{return this._styleSheetTextRange;}
get groupings()
{if(this._ownerRule)
return this._ownerRule.groupings;return[];}
get selectorText()
{if(this._ownerRule)
return this._ownerRule.selectorText;return this._node.appropriateSelectorFor(true);}
propertyForName(name)
{if(!name)
return null;if(!this.editable)
return this._propertyNameMap[name]||null;let bestMatchProperty=null;for(let property of this.enabledProperties){if(property.canonicalName!==name&&property.name!==name)
continue;if(bestMatchProperty&&!bestMatchProperty.overridden&&property.overridden)
continue;bestMatchProperty=property;}
return bestMatchProperty;}
resolveVariableValue(text)
{const invalid=Symbol("invalid");let checkTokens=(tokens)=>{let startIndex=NaN;let openParenthesis=0;for(let i=0;i<tokens.length;i++){let token=tokens[i];if(token.value==="var"&&token.type&&token.type.includes("atom")){if(isNaN(startIndex)){startIndex=i;openParenthesis=0;}
continue;}
if(isNaN(startIndex))
continue;if(token.value==="("){++openParenthesis;continue;}
if(token.value===")"){--openParenthesis;if(openParenthesis>0)
continue;let variableTokens=tokens.slice(startIndex,i+1);startIndex=NaN;let variableNameIndex=variableTokens.findIndex((token)=>token.value.startsWith("--")&&/\bvariable-2\b/.test(token.type));if(variableNameIndex===-1)
continue;let variableProperty=this.propertyForName(variableTokens[variableNameIndex].value);if(variableProperty)
return variableProperty.value.trim();let fallbackStartIndex=variableTokens.findIndex((value,j)=>j>variableNameIndex+1&&/\bm-css\b/.test(value.type));if(fallbackStartIndex===-1)
return invalid;let fallbackTokens=variableTokens.slice(fallbackStartIndex,i);return checkTokens(fallbackTokens)||fallbackTokens.reduce((accumulator,token)=>accumulator+token.value,"").trim();}}
return null;};let resolved=checkTokens(WI.tokenizeCSSValue(text));return resolved===invalid?null:resolved;}
newBlankProperty(propertyIndex)
{let text,name,value,priority,overridden,implicit,anonymous;let enabled=true;let valid=false;let styleSheetTextRange=this._rangeAfterPropertyAtIndex(propertyIndex-1);this.markModified();let property=new WI.CSSProperty(propertyIndex,text,name,value,priority,enabled,overridden,implicit,anonymous,valid,styleSheetTextRange);this.insertProperty(property,propertyIndex);this.update(this._text,this._properties,this._styleSheetTextRange,{dontFireEvents:true,forceUpdate:true});return property;}
markModified()
{if(!this._initialState){let visibleProperties=this.visibleProperties.map((property)=>{return property.clone();});this._initialState=new WI.CSSStyleDeclaration(this._nodeStyles,this._ownerStyleSheet,this._id,this._type,this._node,this._inherited,this._text,visibleProperties,this._styleSheetTextRange);}
WI.cssManager.addModifiedStyle(this);}
insertProperty(cssProperty,propertyIndex)
{this._properties.insertAtIndex(cssProperty,propertyIndex);for(let index=propertyIndex+1;index<this._properties.length;index++)
this._properties[index].index=index;this._enabledProperties=null;this._visibleProperties=null;}
removeProperty(cssProperty)
{let realIndex=this._properties.indexOf(cssProperty);if(realIndex===-1)
return;this._properties.splice(realIndex,1);this._enabledProperties=null;this._visibleProperties=null;}
updatePropertiesModifiedState()
{if(!this._initialState)
return;if(this._type===WI.CSSStyleDeclaration.Type.Computed)
return;let initialCSSProperties=this._initialState.visibleProperties;let cssProperties=this.visibleProperties;let hasModified=false;function onEach(cssProperty,action){if(action!==0)
hasModified=true;cssProperty.modified=action===1;}
function comparator(a,b){return a.equals(b);}
Array.diffArrays(initialCSSProperties,cssProperties,onEach,comparator);if(!hasModified)
WI.cssManager.removeModifiedStyle(this);}
generateFormattedText(options={})
{let indentString=WI.indentString();let styleText="";let groupings=this.groupings.filter((grouping)=>!grouping.isMedia||grouping.text!=="all");let groupingsCount=groupings.length;if(options.includeGroupingsAndSelectors){for(let i=groupingsCount-1;i>=0;--i){if(options.multiline)
styleText+=indentString.repeat(groupingsCount-i-1);styleText+=groupings[i].prefix;if(groupings[i].text)
styleText+=" "+groupings[i].text;styleText+=" {";if(options.multiline)
styleText+="\n";}
if(options.multiline)
styleText+=indentString.repeat(groupingsCount);styleText+=this.selectorText+" {";}
let properties=this._styleSheetTextRange?this.visibleProperties:this._properties;if(properties.length){if(options.multiline){let propertyIndent=indentString.repeat(groupingsCount+1);for(let property of properties)
styleText+="\n"+propertyIndent+property.formattedText;styleText+="\n";if(!options.includeGroupingsAndSelectors){styleText+=indentString.repeat(groupingsCount);}}else
styleText+=properties.map((property)=>property.formattedText).join(" ");}
if(options.includeGroupingsAndSelectors){for(let i=groupingsCount;i>0;--i){if(options.multiline)
styleText+=indentString.repeat(i);styleText+="}";if(options.multiline)
styleText+="\n";}
styleText+="}";}
return styleText;}
get nodeStyles()
{return this._nodeStyles;}
_rangeAfterPropertyAtIndex(index)
{if(index<0)
return this._styleSheetTextRange.collapseToStart();if(index>=this.visibleProperties.length)
return this._styleSheetTextRange.collapseToEnd();let property=this.visibleProperties[index];return property.styleSheetTextRange.collapseToEnd();}};WI.CSSStyleDeclaration.Event={PropertiesChanged:"css-style-declaration-properties-changed",};WI.CSSStyleDeclaration.Type={Rule:"css-style-declaration-type-rule",Inline:"css-style-declaration-type-inline",Attribute:"css-style-declaration-type-attribute",Computed:"css-style-declaration-type-computed"};WI.CSSStyleSheet=class CSSStyleSheet extends WI.SourceCode
{constructor(id)
{super();this._id=id||null;this._parentFrame=null;this._origin=null;this._startLineNumber=0;this._startColumnNumber=0;this._inlineStyleAttribute=false;this._inlineStyleTag=false;this._hasInfo=false;}
static resetUniqueDisplayNameNumbers()
{WI.CSSStyleSheet._nextUniqueDisplayNameNumber=1;}
get id()
{return this._id;}
get parentFrame()
{return this._parentFrame;}
get origin()
{return this._origin;}
get injected()
{return WI.browserManager.isExtensionScheme(this.urlComponents.scheme);}
get anonymous()
{return!this.isInspectorStyleSheet()&&!this._url;}
get mimeType()
{return"text/css";}
get displayName()
{if(this.isInspectorStyleSheet())
return WI.UIString("Inspector Style Sheet");if(this._url)
return WI.displayNameForURL(this._url,this.urlComponents);if(!this._uniqueDisplayNameNumber)
this._uniqueDisplayNameNumber=this.constructor._nextUniqueDisplayNameNumber++;return WI.UIString("Anonymous Style Sheet %d").format(this._uniqueDisplayNameNumber);}
get startLineNumber()
{return this._startLineNumber;}
get startColumnNumber()
{return this._startColumnNumber;}
hasInfo()
{return this._hasInfo;}
isInspectorStyleSheet()
{return this._origin===WI.CSSStyleSheet.Type.Inspector;}
isInlineStyleTag()
{return this._inlineStyleTag;}
isInlineStyleAttributeStyleSheet()
{return this._inlineStyleAttribute;}
markAsInlineStyleAttributeStyleSheet()
{this._inlineStyleAttribute=true;}
offsetSourceCodeLocation(sourceCodeLocation)
{if(!sourceCodeLocation)
return null;if(!this._hasInfo)
return sourceCodeLocation;let sourceCode=sourceCodeLocation.sourceCode;let lineNumber=this._startLineNumber+sourceCodeLocation.lineNumber;let columnNumber=this._startColumnNumber+sourceCodeLocation.columnNumber;return sourceCode.createSourceCodeLocation(lineNumber,columnNumber);}
updateInfo(url,parentFrame,origin,inlineStyle,startLineNumber,startColumnNumber)
{this._hasInfo=true;this._url=url||null;this._urlComponents=undefined;this._parentFrame=parentFrame||null;this._origin=origin;this._inlineStyleTag=inlineStyle;this._startLineNumber=startLineNumber;this._startColumnNumber=startColumnNumber;}
get revisionForRequestedContent()
{return this.currentRevision;}
handleCurrentRevisionContentChange()
{if(!this._id)
return;let target=WI.assumingMainTarget();function contentDidChange(error)
{if(error)
return;if(target.hasCommand("DOM.markUndoableState"))
target.DOMAgent.markUndoableState();this.dispatchEventToListeners(WI.CSSStyleSheet.Event.ContentDidChange);}
this._ignoreNextContentDidChangeNotification=true;target.CSSAgent.setStyleSheetText(this._id,this.currentRevision.content,contentDidChange.bind(this));}
requestContentFromBackend()
{let specialContentPromise=WI.SourceCode.generateSpecialContentForURL(this._url);if(specialContentPromise)
return specialContentPromise;if(!this._id){return Promise.reject(new Error("There is no identifier to request content with."));}
let target=WI.assumingMainTarget();return target.CSSAgent.getStyleSheetText(this._id);}
noteContentDidChange()
{if(this._ignoreNextContentDidChangeNotification){this._ignoreNextContentDidChangeNotification=false;return false;}
this.markContentAsStale();this.dispatchEventToListeners(WI.CSSStyleSheet.Event.ContentDidChange);return true;}};WI.CSSStyleSheet._nextUniqueDisplayNameNumber=1;WI.CSSStyleSheet.Event={ContentDidChange:"css-style-sheet-content-did-change"};WI.CSSStyleSheet.Type={Author:"css-style-sheet-type-author",User:"css-style-sheet-type-user",UserAgent:"css-style-sheet-type-user-agent",Inspector:"css-style-sheet-type-inspector"};WI.CallFrame=class CallFrame
{constructor(target,{id,sourceCodeLocation,functionName,thisObject,scopeChain,nativeCode,programCode,isTailDeleted,blackboxed}={})
{this._isConsoleEvaluation=sourceCodeLocation&&isWebInspectorConsoleEvaluationScript(sourceCodeLocation.sourceCode.sourceURL);if(this._isConsoleEvaluation){functionName=WI.UIString("Console Evaluation");programCode=true;}
this._target=target;this._id=id||null;this._sourceCodeLocation=sourceCodeLocation||null;this._functionName=functionName||"";this._thisObject=thisObject||null;this._scopeChain=scopeChain||[];this._nativeCode=nativeCode||false;this._programCode=programCode||false;this._isTailDeleted=isTailDeleted||false;this._blackboxed=blackboxed||false;}
get target(){return this._target;}
get id(){return this._id;}
get sourceCodeLocation(){return this._sourceCodeLocation;}
get functionName(){return this._functionName;}
get nativeCode(){return this._nativeCode;}
get programCode(){return this._programCode;}
get thisObject(){return this._thisObject;}
get scopeChain(){return this._scopeChain;}
get isTailDeleted(){return this._isTailDeleted;}
get blackboxed(){return this._blackboxed;}
get isConsoleEvaluation(){return this._isConsoleEvaluation;}
get displayName()
{return this._functionName||WI.UIString("(anonymous function)");}
isEqual(other)
{if(!other)
return false;if(this._sourceCodeLocation&&other._sourceCodeLocation)
return this._sourceCodeLocation.isEqual(other._sourceCodeLocation);return false;}
saveIdentityToCookie()
{}
collectScopeChainVariableNames(callback)
{let result=["this","__proto__"];var pendingRequests=this._scopeChain.length;function propertiesCollected(properties)
{for(var i=0;properties&&i<properties.length;++i)
result.push(properties[i].name);if(--pendingRequests)
return;callback(result);}
for(var i=0;i<this._scopeChain.length;++i)
this._scopeChain[i].objects[0].getPropertyDescriptors(propertiesCollected);}
mergedScopeChain()
{let mergedScopes=[];let scopes=this._scopeChain.slice();let lastMarkedHash=null;function markAsBaseIfNeeded(scope){if(!scope.hash)
return false;if(scope.type!==WI.ScopeChainNode.Type.Closure)
return false;if(scope.hash===lastMarkedHash)
return false;lastMarkedHash=scope.hash;scope.__baseClosureScope=true;return true;}
function shouldMergeClosureScopes(youngScope,oldScope,lastMerge){if(!youngScope||!oldScope)
return false;if(!youngScope.hash||!oldScope.hash)
return false;if(youngScope.type!==WI.ScopeChainNode.Type.Closure)
return false;if(oldScope.type!==WI.ScopeChainNode.Type.Closure)
return false;if(youngScope.hash!==oldScope.hash)
return false;if(lastMerge&&youngScope.hash===lastMerge.hash)
return false;return true;}
let lastScope=null;let lastMerge=null;for(let i=scopes.length-1;i>=0;--i){let scope=scopes[i];markAsBaseIfNeeded(scope);if(shouldMergeClosureScopes(scope,lastScope,lastMerge)){let type=WI.ScopeChainNode.Type.Closure;let objects=lastScope.objects.concat(scope.objects);let merged=new WI.ScopeChainNode(type,objects,scope.name,scope.location);merged.__baseClosureScope=true;mergedScopes.pop();mergedScopes.push(merged);lastMerge=merged;lastScope=null;}else{mergedScopes.push(scope);lastMerge=null;lastScope=scope;}}
mergedScopes=mergedScopes.reverse();for(let scope of mergedScopes){if(scope.type===WI.ScopeChainNode.Type.Closure){if(scope.name===this._functionName)
scope.convertToLocalScope();break;}}
return mergedScopes;}
static functionNameFromPayload(payload)
{let functionName=payload.functionName;if(functionName==="global code")
return WI.UIString("Global Code");if(functionName==="eval code")
return WI.UIString("Eval Code");if(functionName==="module code")
return WI.UIString("Module Code");return functionName;}
static programCodeFromPayload(payload)
{return payload.functionName.endsWith(" code");}
static fromDebuggerPayload(target,payload,scopeChain,sourceCodeLocation)
{return new WI.CallFrame(target,{id:payload.callFrameId,sourceCodeLocation,functionName:WI.CallFrame.functionNameFromPayload(payload),thisObject:WI.RemoteObject.fromPayload(payload.this,target),scopeChain,programCode:WI.CallFrame.programCodeFromPayload(payload),isTailDeleted:payload.isTailDeleted,blackboxed:sourceCodeLocation&&!!WI.debuggerManager.blackboxDataForSourceCode(sourceCodeLocation.sourceCode),});}
static fromPayload(target,payload)
{let{url,scriptId}=payload;let nativeCode=false;let sourceCodeLocation=null;if(url==="[native code]"){nativeCode=true;url=null;}else if(url||scriptId){let sourceCode=null;if(scriptId){sourceCode=WI.debuggerManager.scriptForIdentifier(scriptId,target);if(sourceCode&&sourceCode.resource)
sourceCode=sourceCode.resource;}
if(!sourceCode)
sourceCode=WI.networkManager.resourcesForURL(url).firstValue;if(!sourceCode)
sourceCode=WI.debuggerManager.scriptsForURL(url,target)[0];if(sourceCode){let lineNumber=payload.lineNumber-1;sourceCodeLocation=sourceCode.createLazySourceCodeLocation(lineNumber,payload.columnNumber);}else{nativeCode=true;url=null;}}
return new WI.CallFrame(target,{sourceCodeLocation,functionName:WI.CallFrame.functionNameFromPayload(payload),nativeCode,programCode:WI.CallFrame.programCodeFromPayload(payload),blackboxed:sourceCodeLocation&&!!WI.debuggerManager.blackboxDataForSourceCode(sourceCodeLocation.sourceCode),});}};WI.CallingContextTree=class CallingContextTree
{constructor(type)
{this._type=type||WI.CallingContextTree.Type.TopDown;this.reset();}
get type(){return this._type;}
get totalNumberOfSamples(){return this._totalNumberOfSamples;}
reset()
{this._root=new WI.CallingContextTreeNode(-1,-1,-1,"<root>",null);this._totalNumberOfSamples=0;}
totalDurationInTimeRange(startTime,endTime)
{return this._root.filteredTimestampsAndDuration(startTime,endTime).duration;}
updateTreeWithStackTrace({timestamp,stackFrames},duration)
{this._totalNumberOfSamples++;let node=this._root;node.addTimestampAndExpressionLocation(timestamp,duration,null);switch(this._type){case WI.CallingContextTree.Type.TopDown:for(let i=stackFrames.length;i--;){let stackFrame=stackFrames[i];node=node.findOrMakeChild(stackFrame);node.addTimestampAndExpressionLocation(timestamp,duration,stackFrame.expressionLocation||null,i===0);}
break;case WI.CallingContextTree.Type.BottomUp:for(let i=0;i<stackFrames.length;++i){let stackFrame=stackFrames[i];node=node.findOrMakeChild(stackFrame);node.addTimestampAndExpressionLocation(timestamp,duration,stackFrame.expressionLocation||null,i===0);}
break;case WI.CallingContextTree.Type.TopFunctionsTopDown:for(let i=stackFrames.length;i--;){node=this._root;for(let j=i+1;j--;){let stackFrame=stackFrames[j];node=node.findOrMakeChild(stackFrame);node.addTimestampAndExpressionLocation(timestamp,duration,stackFrame.expressionLocation||null,j===0);}}
break;case WI.CallingContextTree.Type.TopFunctionsBottomUp:for(let i=0;i<stackFrames.length;i++){node=this._root;for(let j=i;j<stackFrames.length;j++){let stackFrame=stackFrames[j];node=node.findOrMakeChild(stackFrame);node.addTimestampAndExpressionLocation(timestamp,duration,stackFrame.expressionLocation||null,j===0);}}
break;default:break;}}
toCPUProfilePayload(startTime,endTime)
{let cpuProfile={};let roots=[];let numSamplesInTimeRange=this._root.filteredTimestampsAndDuration(startTime,endTime).timestamps.length;this._root.forEachChild((child)=>{if(child.hasStackTraceInTimeRange(startTime,endTime))
roots.push(child.toCPUProfileNode(numSamplesInTimeRange,startTime,endTime));});cpuProfile.rootNodes=roots;return cpuProfile;}
forEachChild(callback)
{this._root.forEachChild(callback);}
forEachNode(callback)
{this._root.forEachNode(callback);}
static __test_makeTreeFromProtocolMessageObject(messageObject)
{let tree=new WI.CallingContextTree;let stackTraces=messageObject.params.samples.stackTraces;for(let i=0;i<stackTraces.length;i++)
tree.updateTreeWithStackTrace(stackTraces[i]);return tree;}
__test_matchesStackTrace(stackTrace)
{let leaves=this.__test_buildLeafLinkedLists();outer:for(let node of leaves){for(let stackNode of stackTrace){for(let propertyName of Object.getOwnPropertyNames(stackNode)){if(stackNode[propertyName]!==node[propertyName])
continue outer;}
node=node.parent;}
return true;}
return false;}
__test_buildLeafLinkedLists()
{let result=[];let parent=null;this._root.__test_buildLeafLinkedLists(parent,result);return result;}};WI.CallingContextTree.Type={TopDown:Symbol("TopDown"),BottomUp:Symbol("BottomUp"),TopFunctionsTopDown:Symbol("TopFunctionsTopDown"),TopFunctionsBottomUp:Symbol("TopFunctionsBottomUp"),};WI.CallingContextTreeNode=class CallingContextTreeNode
{constructor(sourceID,line,column,name,url,hash)
{this._children={};this._sourceID=sourceID;this._line=line;this._column=column;this._name=name;this._url=url;this._uid=WI.CallingContextTreeNode.__uid++;this._timestamps=[];this._durations=[];this._leafTimestamps=[];this._leafDurations=[];this._expressionLocations={};this._hash=hash||WI.CallingContextTreeNode._hash(this);}
static _hash(stackFrame)
{return stackFrame.name+":"+stackFrame.sourceID+":"+stackFrame.line+":"+stackFrame.column;}
get sourceID(){return this._sourceID;}
get line(){return this._line;}
get column(){return this._column;}
get name(){return this._name;}
get uid(){return this._uid;}
get url(){return this._url;}
get hash(){return this._hash;}
hasChildrenInTimeRange(startTime,endTime)
{for(let propertyName of Object.getOwnPropertyNames(this._children)){let child=this._children[propertyName];if(child.hasStackTraceInTimeRange(startTime,endTime))
return true;}
return false;}
hasStackTraceInTimeRange(startTime,endTime)
{if(startTime>endTime)
return false;let timestamps=this._timestamps;let length=timestamps.length;if(!length)
return false;let index=timestamps.lowerBound(startTime);if(index===length)
return false;let hasTimestampInRange=timestamps[index]<=endTime;return hasTimestampInRange;}
filteredTimestampsAndDuration(startTime,endTime)
{let lowerIndex=this._timestamps.lowerBound(startTime);let upperIndex=this._timestamps.upperBound(endTime);let totalDuration=0;for(let i=lowerIndex;i<upperIndex;++i)
totalDuration+=this._durations[i];return{timestamps:this._timestamps.slice(lowerIndex,upperIndex),duration:totalDuration,};}
filteredLeafTimestampsAndDuration(startTime,endTime)
{let lowerIndex=this._leafTimestamps.lowerBound(startTime);let upperIndex=this._leafTimestamps.upperBound(endTime);let totalDuration=0;for(let i=lowerIndex;i<upperIndex;++i)
totalDuration+=this._leafDurations[i];return{leafTimestamps:this._leafTimestamps.slice(lowerIndex,upperIndex),leafDuration:totalDuration,};}
hasChildren()
{return!isEmptyObject(this._children);}
findOrMakeChild(stackFrame)
{let hash=WI.CallingContextTreeNode._hash(stackFrame);let node=this._children[hash];if(node)
return node;node=new WI.CallingContextTreeNode(stackFrame.sourceID,stackFrame.line,stackFrame.column,stackFrame.name,stackFrame.url,hash);this._children[hash]=node;return node;}
addTimestampAndExpressionLocation(timestamp,duration,expressionLocation,leaf)
{this._timestamps.push(timestamp);this._durations.push(duration);if(leaf){this._leafTimestamps.push(timestamp);this._leafDurations.push(duration);}
if(!expressionLocation)
return;let{line,column}=expressionLocation;let hashCons=line+":"+column;let timestamps=this._expressionLocations[hashCons];if(!timestamps){timestamps=[];this._expressionLocations[hashCons]=timestamps;}
timestamps.push(timestamp);}
forEachChild(callback)
{for(let propertyName of Object.getOwnPropertyNames(this._children))
callback(this._children[propertyName]);}
forEachNode(callback)
{callback(this);this.forEachChild(function(child){child.forEachNode(callback);});}
equals(other)
{return this._hash===other.hash;}
toCPUProfileNode(numSamples,startTime,endTime)
{let children=[];this.forEachChild((child)=>{if(child.hasStackTraceInTimeRange(startTime,endTime))
children.push(child.toCPUProfileNode(numSamples,startTime,endTime));});let cpuProfileNode={id:this._uid,functionName:this._name,url:this._url,lineNumber:this._line,columnNumber:this._column,children:children};let timestamps=[];let frameStartTime=Number.MAX_VALUE;let frameEndTime=Number.MIN_VALUE;for(let i=0;i<this._timestamps.length;i++){let timestamp=this._timestamps[i];if(startTime<=timestamp&&timestamp<=endTime){timestamps.push(timestamp);frameStartTime=Math.min(frameStartTime,timestamp);frameEndTime=Math.max(frameEndTime,timestamp);}}
cpuProfileNode.callInfo={callCount:timestamps.length,startTime:frameStartTime,endTime:frameEndTime,totalTime:(timestamps.length/numSamples)*(endTime-startTime)};return cpuProfileNode;}
__test_buildLeafLinkedLists(parent,result)
{let linkedListNode={name:this._name,url:this._url,parent:parent};if(this.hasChildren()){this.forEachChild((child)=>{child.__test_buildLeafLinkedLists(linkedListNode,result);});}else{result.push(linkedListNode);}}};WI.CallingContextTreeNode.__uid=0;WI.Canvas=class Canvas extends WI.Object
{constructor(identifier,contextType,{domNode,cssCanvasName,contextAttributes,memoryCost,backtrace}={})
{super();this._identifier=identifier;this._contextType=contextType;this._domNode=domNode||null;this._cssCanvasName=cssCanvasName||"";this._contextAttributes=contextAttributes||{};this._extensions=new Set;this._memoryCost=memoryCost||NaN;this._backtrace=backtrace||[];this._clientNodes=null;this._shaderProgramCollection=new WI.ShaderProgramCollection;this._recordingCollection=new WI.RecordingCollection;this._nextShaderProgramDisplayNumber=null;this._requestNodePromise=null;this._recordingState=WI.Canvas.RecordingState.Inactive;this._recordingFrames=[];this._recordingBufferUsed=0;}
static fromPayload(payload)
{let contextType=null;switch(payload.contextType){case InspectorBackend.Enum.Canvas.ContextType.Canvas2D:contextType=WI.Canvas.ContextType.Canvas2D;break;case InspectorBackend.Enum.Canvas.ContextType.BitmapRenderer:contextType=WI.Canvas.ContextType.BitmapRenderer;break;case InspectorBackend.Enum.Canvas.ContextType.WebGL:contextType=WI.Canvas.ContextType.WebGL;break;case InspectorBackend.Enum.Canvas.ContextType.WebGL2:contextType=WI.Canvas.ContextType.WebGL2;break;case InspectorBackend.Enum.Canvas.ContextType.WebGPU:contextType=WI.Canvas.ContextType.WebGPU;break;case InspectorBackend.Enum.Canvas.ContextType.WebMetal:contextType=WI.Canvas.ContextType.WebMetal;break;default:console.error("Invalid canvas context type",payload.contextType);}
return new WI.Canvas(payload.canvasId,contextType,{domNode:payload.nodeId?WI.domManager.nodeForId(payload.nodeId):null,cssCanvasName:payload.cssCanvasName,contextAttributes:payload.contextAttributes,memoryCost:payload.memoryCost,backtrace:Array.isArray(payload.backtrace)?payload.backtrace.map((item)=>WI.CallFrame.fromPayload(WI.mainTarget,item)):[],});}
static displayNameForContextType(contextType)
{switch(contextType){case WI.Canvas.ContextType.Canvas2D:return WI.UIString("2D");case WI.Canvas.ContextType.BitmapRenderer:return WI.UIString("Bitmap Renderer","Canvas Context Type Bitmap Renderer","Bitmap Renderer is a type of rendering context associated with a <canvas> element");case WI.Canvas.ContextType.WebGL:return WI.unlocalizedString("WebGL");case WI.Canvas.ContextType.WebGL2:return WI.unlocalizedString("WebGL2");case WI.Canvas.ContextType.WebGPU:return WI.unlocalizedString("Web GPU");case WI.Canvas.ContextType.WebMetal:return WI.unlocalizedString("WebMetal");}
return null;}
static displayNameForColorSpace(colorSpace)
{switch(colorSpace){case WI.Canvas.ColorSpace.SRGB:return WI.unlocalizedString("sRGB");case WI.Canvas.ColorSpace.DisplayP3:return WI.unlocalizedString("Display P3");}
return null;}
static resetUniqueDisplayNameNumbers()
{Canvas._nextContextUniqueDisplayNameNumber=1;Canvas._nextDeviceUniqueDisplayNameNumber=1;}
static supportsRequestContentForContextType(contextType)
{switch(contextType){case Canvas.ContextType.WebGPU:case Canvas.ContextType.WebMetal:return false;}
return true;}
get identifier(){return this._identifier;}
get contextType(){return this._contextType;}
get cssCanvasName(){return this._cssCanvasName;}
get contextAttributes(){return this._contextAttributes;}
get extensions(){return this._extensions;}
get backtrace(){return this._backtrace;}
get shaderProgramCollection(){return this._shaderProgramCollection;}
get recordingCollection(){return this._recordingCollection;}
get recordingFrameCount(){return this._recordingFrames.length;}
get recordingBufferUsed(){return this._recordingBufferUsed;}
get recordingActive()
{return this._recordingState!==WI.Canvas.RecordingState.Inactive;}
get memoryCost()
{return this._memoryCost;}
set memoryCost(memoryCost)
{if(memoryCost===this._memoryCost)
return;this._memoryCost=memoryCost;this.dispatchEventToListeners(WI.Canvas.Event.MemoryChanged);}
get displayName()
{if(this._cssCanvasName)
return WI.UIString("CSS canvas \u201C%s\u201D").format(this._cssCanvasName);if(this._domNode){let idSelector=this._domNode.escapedIdSelector;if(idSelector)
return WI.UIString("Canvas %s").format(idSelector);}
if(this._contextType===Canvas.ContextType.WebGPU){if(!this._uniqueDisplayNameNumber)
this._uniqueDisplayNameNumber=Canvas._nextDeviceUniqueDisplayNameNumber++;return WI.UIString("Device %d").format(this._uniqueDisplayNameNumber);}
if(!this._uniqueDisplayNameNumber)
this._uniqueDisplayNameNumber=Canvas._nextContextUniqueDisplayNameNumber++;return WI.UIString("Canvas %d").format(this._uniqueDisplayNameNumber);}
requestNode()
{if(!this._requestNodePromise){this._requestNodePromise=new Promise((resolve,reject)=>{WI.domManager.ensureDocument();let target=WI.assumingMainTarget();target.CanvasAgent.requestNode(this._identifier,(error,nodeId)=>{if(error){resolve(null);return;}
this._domNode=WI.domManager.nodeForId(nodeId);if(!this._domNode){resolve(null);return;}
resolve(this._domNode);});});}
return this._requestNodePromise;}
requestContent()
{if(!Canvas.supportsRequestContentForContextType(this._contextType))
return Promise.resolve(null);let target=WI.assumingMainTarget();return target.CanvasAgent.requestContent(this._identifier).then((result)=>result.content).catch((error)=>console.error(error));}
requestClientNodes(callback)
{if(this._clientNodes){callback(this._clientNodes);return;}
WI.domManager.ensureDocument();let wrappedCallback=(error,clientNodeIds)=>{if(error){callback([]);return;}
clientNodeIds=Array.isArray(clientNodeIds)?clientNodeIds:[];this._clientNodes=clientNodeIds.map((clientNodeId)=>WI.domManager.nodeForId(clientNodeId));callback(this._clientNodes);};let target=WI.assumingMainTarget();if(!target.hasCommand("Canvas.requestClientNodes")){target.CanvasAgent.requestCSSCanvasClientNodes(this._identifier,wrappedCallback);return;}
target.CanvasAgent.requestClientNodes(this._identifier,wrappedCallback);}
requestSize()
{function calculateSize(domNode){function getAttributeValue(name){let value=Number(domNode.getAttribute(name));if(!Number.isInteger(value)||value<0)
return NaN;return value;}
return{width:getAttributeValue("width"),height:getAttributeValue("height")};}
function getPropertyValue(remoteObject,name){return new Promise((resolve,reject)=>{remoteObject.getProperty(name,(error,result)=>{if(error){reject(error);return;}
resolve(result);});});}
return this.requestNode().then((domNode)=>{if(!domNode)
return null;let size=calculateSize(domNode);if(!isNaN(size.width)&&!isNaN(size.height))
return size;let remoteObject=null;return WI.RemoteObject.resolveNode(domNode).then((object)=>{remoteObject=object;return Promise.all([getPropertyValue(object,"width"),getPropertyValue(object,"height")]);}).then((values)=>{let width=values[0].value;let height=values[1].value;values[0].release();values[1].release();remoteObject.release();return{width,height};});});}
startRecording(singleFrame)
{let target=WI.assumingMainTarget();let handleStartRecording=(error)=>{if(error){console.error(error);return;}
this._recordingState=WI.Canvas.RecordingState.ActiveFrontend;if(target.hasEvent("Canvas.recordingStarted"))
return;this._recordingFrames=[];this._recordingBufferUsed=0;this.dispatchEventToListeners(WI.Canvas.Event.RecordingStarted);};if(target.hasCommand("Canvas.startRecording","singleFrame")){target.CanvasAgent.startRecording(this._identifier,singleFrame,handleStartRecording);return;}
if(singleFrame){const frameCount=1;target.CanvasAgent.startRecording(this._identifier,frameCount,handleStartRecording);}else
target.CanvasAgent.startRecording(this._identifier,handleStartRecording);}
stopRecording()
{let target=WI.assumingMainTarget();target.CanvasAgent.stopRecording(this._identifier);}
saveIdentityToCookie(cookie)
{if(this._cssCanvasName)
cookie[WI.Canvas.CSSCanvasNameCookieKey]=this._cssCanvasName;else if(this._domNode)
cookie[WI.Canvas.NodePathCookieKey]=this._domNode.path;}
enableExtension(extension)
{this._extensions.add(extension);this.dispatchEventToListeners(WI.Canvas.Event.ExtensionEnabled,{extension});}
clientNodesChanged()
{this._clientNodes=null;this.dispatchEventToListeners(Canvas.Event.ClientNodesChanged);}
recordingStarted(initiator)
{if(initiator===InspectorBackend.Enum.Recording.Initiator.Console)
this._recordingState=WI.Canvas.RecordingState.ActiveConsole;else if(initiator===InspectorBackend.Enum.Recording.Initiator.AutoCapture)
this._recordingState=WI.Canvas.RecordingState.ActiveAutoCapture;else{this._recordingState=WI.Canvas.RecordingState.ActiveFrontend;}
this._recordingFrames=[];this._recordingBufferUsed=0;this.dispatchEventToListeners(WI.Canvas.Event.RecordingStarted);}
recordingProgress(framesPayload,bufferUsed)
{this._recordingFrames.pushAll(framesPayload.map(WI.RecordingFrame.fromPayload));this._recordingBufferUsed=bufferUsed;this.dispatchEventToListeners(WI.Canvas.Event.RecordingProgress);}
recordingFinished(recordingPayload)
{let initiatedByUser=this._recordingState===WI.Canvas.RecordingState.ActiveFrontend;if(!initiatedByUser&&!InspectorBackend.hasEvent("Canvas.recordingStarted"))
initiatedByUser=!!this.recordingActive;let recording=recordingPayload?WI.Recording.fromPayload(recordingPayload,this._recordingFrames):null;if(recording){recording.source=this;recording.createDisplayName(recordingPayload.name);this._recordingCollection.add(recording);}
this._recordingState=WI.Canvas.RecordingState.Inactive;this._recordingFrames=[];this._recordingBufferUsed=0;this.dispatchEventToListeners(WI.Canvas.Event.RecordingStopped,{recording,initiatedByUser});}
nextShaderProgramDisplayNumberForProgramType(programType)
{if(!this._nextShaderProgramDisplayNumber)
this._nextShaderProgramDisplayNumber={};this._nextShaderProgramDisplayNumber[programType]=(this._nextShaderProgramDisplayNumber[programType]||0)+1;return this._nextShaderProgramDisplayNumber[programType];}};WI.Canvas._nextContextUniqueDisplayNameNumber=1;WI.Canvas._nextDeviceUniqueDisplayNameNumber=1;WI.Canvas.FrameURLCookieKey="canvas-frame-url";WI.Canvas.CSSCanvasNameCookieKey="canvas-css-canvas-name";WI.Canvas.ContextType={Canvas2D:"canvas-2d",BitmapRenderer:"bitmaprenderer",WebGL:"webgl",WebGL2:"webgl2",WebGPU:"webgpu",WebMetal:"webmetal",};WI.Canvas.ColorSpace={SRGB:"srgb",DisplayP3:"display-p3",};WI.Canvas.RecordingState={Inactive:"canvas-recording-state-inactive",ActiveFrontend:"canvas-recording-state-active-frontend",ActiveConsole:"canvas-recording-state-active-console",ActiveAutoCapture:"canvas-recording-state-active-auto-capture",};WI.Canvas.Event={MemoryChanged:"canvas-memory-changed",ExtensionEnabled:"canvas-extension-enabled",ClientNodesChanged:"canvas-client-nodes-changed",RecordingStarted:"canvas-recording-started",RecordingProgress:"canvas-recording-progress",RecordingStopped:"canvas-recording-stopped",};WI.CollectionEntry=class CollectionEntry
{constructor(key,value)
{this._key=key;this._value=value;}
static fromPayload(payload,target)
{if(payload.key)
payload.key=WI.RemoteObject.fromPayload(payload.key,target);if(payload.value)
payload.value=WI.RemoteObject.fromPayload(payload.value,target);return new WI.CollectionEntry(payload.key,payload.value);}
get key(){return this._key;}
get value(){return this._value;}};WI.CollectionEntryPreview=class CollectionEntryPreview
{constructor(keyPreview,valuePreview)
{this._key=keyPreview;this._value=valuePreview;}
static fromPayload(payload)
{if(payload.key)
payload.key=WI.ObjectPreview.fromPayload(payload.key);if(payload.value)
payload.value=WI.ObjectPreview.fromPayload(payload.value);return new WI.CollectionEntryPreview(payload.key,payload.value);}
get keyPreview(){return this._key;}
get valuePreview(){return this._value;}};WI.FrameCollection=class FrameCollection extends WI.Collection
{get displayName()
{return WI.UIString("Frames");}
objectIsRequiredType(object)
{return object instanceof WI.Frame;}};WI.ScriptCollection=class ScriptCollection extends WI.Collection
{get displayName()
{return WI.UIString("Scripts");}
objectIsRequiredType(object)
{return object instanceof WI.Script;}};WI.CSSStyleSheetCollection=class CSSStyleSheetCollection extends WI.Collection
{get displayName()
{return WI.UIString("Style Sheets");}
objectIsRequiredType(object)
{return object instanceof WI.CSSStyleSheet;}};WI.CanvasCollection=class CanvasCollection extends WI.Collection
{get displayName()
{return WI.UIString("Canvases");}
objectIsRequiredType(object)
{return object instanceof WI.Canvas;}};WI.ShaderProgramCollection=class ShaderProgramCollection extends WI.Collection
{get displayName()
{return WI.UIString("Shader Programs");}
objectIsRequiredType(object)
{return object instanceof WI.ShaderProgram;}};WI.RecordingCollection=class RecordingCollection extends WI.Collection
{get displayName()
{return WI.UIString("Recordings");}
objectIsRequiredType(object)
{return object instanceof WI.Recording;}};WI.Color=class Color
{constructor(format,components,gamut)
{this.format=format;this._gamut=gamut||WI.Color.Gamut.SRGB;this.alpha=components.length===4?components[3]:1;this._rgb=null;this._normalizedRGB=null;this._hsl=null;if(format===WI.Color.Format.HSL||format===WI.Color.Format.HSLA)
this._hsl=components.slice(0,3);else if(format===WI.Color.Format.ColorFunction)
this._normalizedRGB=components.slice(0,3);else
this._rgb=components.slice(0,3);this.valid=!components.some(isNaN);}
static fromString(colorString)
{const matchRegExp=/^(?:#(?<hex>[0-9a-f]{3,8})|rgba?\((?<rgb>[^)]+)\)|(?<keyword>\w+)|color\((?<color>[^)]+)\)|hsla?\((?<hsl>[^)]+)\))$/i;let match=colorString.match(matchRegExp);if(!match)
return null;if(match.groups.hex){let hex=match.groups.hex.toUpperCase();switch(hex.length){case 3:return new WI.Color(WI.Color.Format.ShortHEX,[parseInt(hex.charAt(0)+hex.charAt(0),16),parseInt(hex.charAt(1)+hex.charAt(1),16),parseInt(hex.charAt(2)+hex.charAt(2),16),1]);case 6:return new WI.Color(WI.Color.Format.HEX,[parseInt(hex.substring(0,2),16),parseInt(hex.substring(2,4),16),parseInt(hex.substring(4,6),16),1]);case 4:return new WI.Color(WI.Color.Format.ShortHEXAlpha,[parseInt(hex.charAt(0)+hex.charAt(0),16),parseInt(hex.charAt(1)+hex.charAt(1),16),parseInt(hex.charAt(2)+hex.charAt(2),16),parseInt(hex.charAt(3)+hex.charAt(3),16)/255]);case 8:return new WI.Color(WI.Color.Format.HEXAlpha,[parseInt(hex.substring(0,2),16),parseInt(hex.substring(2,4),16),parseInt(hex.substring(4,6),16),parseInt(hex.substring(6,8),16)/255]);}
return null;}
if(match.groups.keyword){let keyword=match.groups.keyword.toLowerCase();if(!WI.Color.Keywords.hasOwnProperty(keyword))
return null;let color=new WI.Color(WI.Color.Format.Keyword,WI.Color.Keywords[keyword].slice());color.keyword=keyword;color.original=colorString;return color;}
function splitFunctionString(string){return string.trim().replace(/(\s*(,|\/)\s*|\s+)/g,"|").split("|");}
function parseFunctionAlpha(alpha){let value=parseFloat(alpha);if(alpha.includes("%"))
value/=100;return Number.constrain(value,0,1);}
if(match.groups.rgb){let rgb=splitFunctionString(match.groups.rgb);if(rgb.length!==3&&rgb.length!==4)
return null;function parseFunctionComponent(component){let value=parseFloat(component);if(component.includes("%"))
value=value*255/100;return Number.constrain(value,0,255);}
let alpha=1;if(rgb.length===4)
alpha=parseFunctionAlpha(rgb[3]);return new WI.Color(rgb.length===4?WI.Color.Format.RGBA:WI.Color.Format.RGB,[parseFunctionComponent(rgb[0]),parseFunctionComponent(rgb[1]),parseFunctionComponent(rgb[2]),alpha,]);}
if(match.groups.hsl){let hsl=splitFunctionString(match.groups.hsl);if(hsl.length!==3&&hsl.length!==4)
return null;let alpha=1;if(hsl.length===4)
alpha=parseFunctionAlpha(hsl[3]);function parseHueComponent(hue){let value=parseFloat(hue);if(/(\b|\d)rad\b/.test(hue))
value=value*180/Math.PI;else if(/(\b|\d)grad\b/.test(hue))
value=value*360/400;else if(/(\b|\d)turn\b/.test(hue))
value=value*360;return Number.constrain(value,0,360);}
function parsePercentageComponent(component){let value=parseFloat(component);return Number.constrain(value,0,100);}
return new WI.Color(hsl.length===4?WI.Color.Format.HSLA:WI.Color.Format.HSL,[parseHueComponent(hsl[0]),parsePercentageComponent(hsl[1]),parsePercentageComponent(hsl[2]),alpha,]);}
if(match.groups.color){let colorString=match.groups.color.trim();let components=splitFunctionString(colorString);if(components.length!==4&&components.length!==5)
return null;let gamut=components[0].toLowerCase();if(!Object.values(WI.Color.Gamut).includes(gamut))
return null;let alpha=1;if(components.length===5)
alpha=parseFunctionAlpha(components[4]);function parseFunctionComponent(component){let value=parseFloat(component);return Number.constrain(value,0,1);}
return new WI.Color(WI.Color.Format.ColorFunction,[parseFunctionComponent(components[1]),parseFunctionComponent(components[2]),parseFunctionComponent(components[3]),alpha,],gamut);}
return null;}
static fromStringBestMatchingSuggestedFormatAndGamut(colorString,{suggestedFormat,suggestedGamut,forceSuggestedFormatAndGamut}={})
{let newColor=WI.Color.fromString(colorString);if(forceSuggestedFormatAndGamut){newColor.format=suggestedFormat;newColor.gamut=suggestedGamut;return newColor;}
if(suggestedGamut===WI.Color.Gamut.DisplayP3&&newColor.gamut!==WI.Color.Gamut.DisplayP3)
newColor.gamut=WI.Color.Gamut.DisplayP3;else if(suggestedGamut!==WI.Color.Gamut.DisplayP3&&newColor.gamut===WI.Color.Gamut.DisplayP3&&!newColor.isOutsideSRGB())
newColor.gamut=WI.Color.Gamut.SRGB;if(newColor.gamut!==WI.Color.Gamut.SRGB)
return newColor;switch(suggestedFormat){case WI.Color.Format.Original:break;case WI.Color.Format.Keyword:break;case WI.Color.Format.HEX:newColor.format=newColor.simple?WI.Color.Format.HEX:WI.Color.Format.HEXAlpha;break;case WI.Color.Format.ShortHEX:if(newColor.canBeSerializedAsShortHEX())
newColor.format=newColor.simple?WI.Color.Format.ShortHEX:WI.Color.Format.ShortHEXAlpha;else
newColor.format=newColor.simple?WI.Color.Format.HEX:WI.Color.Format.HEXAlpha;break;case WI.Color.Format.ShortHEXAlpha:newColor.format=newColor.canBeSerializedAsShortHEX()?WI.Color.Format.ShortHEXAlpha:WI.Color.Format.HEXAlpha;break;case WI.Color.Format.RGB:newColor.format=newColor.simple?WI.Color.Format.RGB:WI.Color.Format.RGBA;break;case WI.Color.Format.HSL:newColor.format=newColor.simple?WI.Color.Format.HSL:WI.Color.Format.HSLA;break;case WI.Color.Format.HEXAlpha:case WI.Color.Format.RGBA:case WI.Color.Format.HSLA:case WI.Color.Format.ColorFunction:newColor.format=suggestedFormat;break;default:break;}
return newColor;}
static rgb2hsl(r,g,b)
{r=WI.Color._eightBitChannel(r)/255;g=WI.Color._eightBitChannel(g)/255;b=WI.Color._eightBitChannel(b)/255;let min=Math.min(r,g,b);let max=Math.max(r,g,b);let delta=max-min;let h=0;let s=0;let l=(max+min)/2;if(delta===0)
h=0;else if(max===r)
h=(60*((g-b)/delta))%360;else if(max===g)
h=60*((b-r)/delta)+120;else if(max===b)
h=60*((r-g)/delta)+240;if(h<0)
h+=360;if(delta===0)
s=0;else
s=delta/(1-Math.abs((2*l)-1));return[h,s*100,l*100,];}
static hsl2rgb(h,s,l)
{h=Number.constrain(h,0,360)%360;s=Number.constrain(s,0,100)/100;l=Number.constrain(l,0,100)/100;let c=(1-Math.abs((2*l)-1))*s;let x=c*(1-Math.abs(((h/60)%2)-1));let m=l-(c/2);let r=0;let g=0;let b=0;if(h<60){r=c;g=x;}else if(h<120){r=x;g=c;}else if(h<180){g=c;b=x;}else if(h<240){g=x;b=c;}else if(h<300){r=x;b=c;}else if(h<360){r=c;b=x;}
return[(r+m)*255,(g+m)*255,(b+m)*255,];}
static hsv2hsl(h,s,v)
{h=Number.constrain(h,0,360);s=Number.constrain(s,0,100)/100;v=Number.constrain(v,0,100)/100;let l=v-v*s/2;let saturation;if(l===0||l===1)
saturation=0;else
saturation=(v-l)/Math.min(l,1-l);return[h,saturation*100,l*100];}
static rgb2hsv(r,g,b)
{r=Number.constrain(r,0,1);g=Number.constrain(g,0,1);b=Number.constrain(b,0,1);let max=Math.max(r,g,b);let min=Math.min(r,g,b);let h=0;let delta=max-min;let s=max===0?0:delta/max;let v=max;if(max===min)
h=0;else{switch(max){case r:h=((g-b)/delta)+((g<b)?6:0);break;case g:h=((b-r)/delta)+2;break;case b:h=((r-g)/delta)+4;break;}
h/=6;}
return[h*360,s*100,v*100];}
static hsv2rgb(h,s,v)
{h=Number.constrain(h,0,360);s=Number.constrain(s,0,100)/100;v=Number.constrain(v,0,100)/100;function fraction(n){let k=(n+(h/60))%6;return v-(v*s*Math.max(Math.min(k,4-k,1),0));}
return[fraction(5),fraction(3),fraction(1)];}
static displayP3toSRGB(r,g,b)
{r=Number.constrain(r,0,1);g=Number.constrain(g,0,1);b=Number.constrain(b,0,1);let linearP3=WI.Color._toLinearLight([r,g,b]);const rgbToXYZMatrix=[[0.4865709486482162,0.26566769316909306,0.1982172852343625],[0.2289745640697488,0.6917385218365064,0.079286914093745],[0.0000000000000000,0.04511338185890264,1.043944368900976],];let xyz=Math.multiplyMatrixByVector(rgbToXYZMatrix,linearP3);const xyzToLinearSRGBMatrix=[[3.2404542,-1.5371385,-0.4985314],[-0.9692660,1.8760108,0.0415560],[0.0556434,-0.2040259,1.0572252],];let linearSRGB=Math.multiplyMatrixByVector(xyzToLinearSRGBMatrix,xyz);let srgb=WI.Color._gammaCorrect(linearSRGB);return srgb.map((x)=>x.maxDecimals(4));}
static srgbToDisplayP3(r,g,b)
{r=Number.constrain(r,0,1);g=Number.constrain(g,0,1);b=Number.constrain(b,0,1);let linearSRGB=WI.Color._toLinearLight([r,g,b]);const linearSRGBtoXYZMatrix=[[0.4124564,0.3575761,0.1804375],[0.2126729,0.7151522,0.0721750],[0.0193339,0.1191920,0.9503041],];let xyz=Math.multiplyMatrixByVector(linearSRGBtoXYZMatrix,linearSRGB);const xyzToLinearP3Matrix=[[2.493496911941425,-0.9313836179191239,-0.40271078445071684],[-0.8294889695615747,1.7626640603183463,0.023624685841943577],[0.03584583024378447,-0.07617238926804182,0.9568845240076872],];let linearP3=Math.multiplyMatrixByVector(xyzToLinearP3Matrix,xyz);let p3=WI.Color._gammaCorrect(linearP3);return p3.map((x)=>x.maxDecimals(4));}
static _toLinearLight(rgb)
{return rgb.map(function(value){if(value<0.04045)
return value/12.92;return Math.pow((value+0.055)/1.055,2.4);});}
static _gammaCorrect(rgb)
{return rgb.map(function(value){if(value>0.0031308)
return 1.055*Math.pow(value,1/2.4)-0.055;return 12.92*value;});}
static cmyk2rgb(c,m,y,k)
{c=Number.constrain(c,0,1);m=Number.constrain(m,0,1);y=Number.constrain(y,0,1);k=Number.constrain(k,0,1);return[255*(1-c)*(1-k),255*(1-m)*(1-k),255*(1-y)*(1-k),];}
static normalized2rgb(r,g,b)
{return[WI.Color._eightBitChannel(r*255),WI.Color._eightBitChannel(g*255),WI.Color._eightBitChannel(b*255)];}
static _eightBitChannel(value)
{return Number.constrain(Math.round(value),0,255);}
nextFormat(format)
{format=format||this.format;switch(format){case WI.Color.Format.Original:case WI.Color.Format.HEX:case WI.Color.Format.HEXAlpha:return this.simple?WI.Color.Format.RGB:WI.Color.Format.RGBA;case WI.Color.Format.RGB:case WI.Color.Format.RGBA:return WI.Color.Format.ColorFunction;case WI.Color.Format.ColorFunction:if(this.simple)
return WI.Color.Format.HSL;return WI.Color.Format.HSLA;case WI.Color.Format.HSL:case WI.Color.Format.HSLA:if(this.isKeyword())
return WI.Color.Format.Keyword;if(this.simple)
return this.canBeSerializedAsShortHEX()?WI.Color.Format.ShortHEX:WI.Color.Format.HEX;return this.canBeSerializedAsShortHEX()?WI.Color.Format.ShortHEXAlpha:WI.Color.Format.HEXAlpha;case WI.Color.Format.ShortHEX:return WI.Color.Format.HEX;case WI.Color.Format.ShortHEXAlpha:return WI.Color.Format.HEXAlpha;case WI.Color.Format.Keyword:if(this.simple)
return this.canBeSerializedAsShortHEX()?WI.Color.Format.ShortHEX:WI.Color.Format.HEX;return this.canBeSerializedAsShortHEX()?WI.Color.Format.ShortHEXAlpha:WI.Color.Format.HEXAlpha;default:console.error("Unknown color format.");return null;}}
get simple()
{return this.alpha===1;}
get rgb()
{if(!this._rgb){if(this._hsl)
this._rgb=WI.Color.hsl2rgb(...this._hsl);else if(this._normalizedRGB)
this._rgb=this._normalizedRGB.map((component)=>WI.Color._eightBitChannel(component*255));}
return this._rgb;}
get hsl()
{if(!this._hsl)
this._hsl=WI.Color.rgb2hsl(...this.rgb);return this._hsl;}
get normalizedRGB()
{if(!this._normalizedRGB)
this._normalizedRGB=this.rgb.map((component)=>component/255);return this._normalizedRGB;}
get rgba()
{return[...this.rgb,this.alpha];}
get hsla()
{return[...this.hsl,this.alpha];}
get normalizedRGBA()
{return[...this.normalizedRGB,this.alpha];}
get gamut()
{return this._gamut;}
set gamut(gamut)
{if(this._gamut===WI.Color.Gamut.DisplayP3&&gamut===WI.Color.Gamut.SRGB){this._normalizedRGB=WI.Color.displayP3toSRGB(...this.normalizedRGB).map((x)=>Number.constrain(x,0,1));this._hsl=null;this._rgb=null;}else if(this._gamut===WI.Color.Gamut.SRGB&&gamut===WI.Color.Gamut.DisplayP3){this._normalizedRGB=WI.Color.srgbToDisplayP3(...this.normalizedRGB);this._hsl=null;this._rgb=null;this.format=WI.Color.Format.ColorFunction;}
this._gamut=gamut;}
copy()
{switch(this.format){case WI.Color.Format.RGB:case WI.Color.Format.HEX:case WI.Color.Format.ShortHEX:case WI.Color.Format.HEXAlpha:case WI.Color.Format.ShortHEXAlpha:case WI.Color.Format.Keyword:case WI.Color.Format.RGBA:return new WI.Color(this.format,this.rgba,this._gamut);case WI.Color.Format.HSL:case WI.Color.Format.HSLA:return new WI.Color(this.format,this.hsla,this._gamut);case WI.Color.Format.ColorFunction:return new WI.Color(this.format,this.normalizedRGBA,this._gamut);}
console.error("Invalid color format: "+this.format);}
toString(format)
{if(!format)
format=this.format;switch(format){case WI.Color.Format.Original:return this._toOriginalString();case WI.Color.Format.RGB:return this._toRGBString();case WI.Color.Format.RGBA:return this._toRGBAString();case WI.Color.Format.ColorFunction:return this._toFunctionString();case WI.Color.Format.HSL:return this._toHSLString();case WI.Color.Format.HSLA:return this._toHSLAString();case WI.Color.Format.HEX:return this._toHEXString();case WI.Color.Format.ShortHEX:return this._toShortHEXString();case WI.Color.Format.HEXAlpha:return this._toHEXAlphaString();case WI.Color.Format.ShortHEXAlpha:return this._toShortHEXAlphaString();case WI.Color.Format.Keyword:return this._toKeywordString();}
console.error("Invalid color format: "+format);return"";}
toProtocol()
{let[r,g,b,a]=this.rgba;return{r,g,b,a};}
isKeyword()
{if(this.keyword)
return true;if(this._gamut!==WI.Color.Gamut.SRGB)
return false;if(!this.simple)
return Array.shallowEqual(this.rgba,[0,0,0,0]);return Object.keys(WI.Color.Keywords).some(key=>Array.shallowEqual(WI.Color.Keywords[key],this.rgb));}
isOutsideSRGB()
{if(this._gamut!==WI.Color.Gamut.DisplayP3)
return false;let rgb=WI.Color.displayP3toSRGB(...this.normalizedRGB);const epsilon=(1/255)/2;return rgb.some((x)=>x<=-epsilon||x>=1+epsilon);}
canBeSerializedAsShortHEX()
{let rgb=this.rgb;let r=this._componentToHexValue(rgb[0]);if(r[0]!==r[1])
return false;let g=this._componentToHexValue(rgb[1]);if(g[0]!==g[1])
return false;let b=this._componentToHexValue(rgb[2]);if(b[0]!==b[1])
return false;if(!this.simple){let a=this._componentToHexValue(Math.round(this.alpha*255));if(a[0]!==a[1])
return false;}
return true;}
_toOriginalString()
{return this.original||this._toKeywordString();}
_toKeywordString()
{if(this.keyword)
return this.keyword;let rgba=this.rgba;if(!this.simple){if(Array.shallowEqual(rgba,[0,0,0,0]))
return"transparent";return this._toRGBAString();}
let keywords=WI.Color.Keywords;for(let keyword in keywords){if(!keywords.hasOwnProperty(keyword))
continue;let keywordRGB=keywords[keyword];if(keywordRGB[0]===rgba[0]&&keywordRGB[1]===rgba[1]&&keywordRGB[2]===rgba[2])
return keyword;}
return this._toRGBString();}
_toShortHEXString()
{if(!this.simple)
return this._toRGBAString();let[r,g,b]=this.rgb.map(this._componentToHexValue);if(r[0]===r[1]&&g[0]===g[1]&&b[0]===b[1])
return"#"+r[0]+g[0]+b[0];return"#"+r+g+b;}
_toHEXString()
{if(!this.simple)
return this._toRGBAString();let[r,g,b]=this.rgb.map(this._componentToHexValue);return"#"+r+g+b;}
_toShortHEXAlphaString()
{let[r,g,b]=this.rgb.map(this._componentToHexValue);let a=this._componentToHexValue(Math.round(this.alpha*255));if(r[0]===r[1]&&g[0]===g[1]&&b[0]===b[1]&&a[0]===a[1])
return"#"+r[0]+g[0]+b[0]+a[0];return"#"+r+g+b+a;}
_toHEXAlphaString()
{let[r,g,b]=this.rgb.map(this._componentToHexValue);let a=this._componentToHexValue(Math.round(this.alpha*255));return"#"+r+g+b+a;}
_toRGBString()
{if(!this.simple)
return this._toRGBAString();let[r,g,b]=this.rgb.map(WI.Color._eightBitChannel);return`rgb(${r}, ${g}, ${b})`;}
_toRGBAString()
{let[r,g,b]=this.rgb.map(WI.Color._eightBitChannel);return`rgba(${r}, ${g}, ${b}, ${this.alpha})`;}
_toFunctionString()
{let[r,g,b]=this.normalizedRGB.map((x)=>x.maxDecimals(4));if(this.alpha===1)
return`color(${this._gamut} ${r} ${g} ${b})`;return`color(${this._gamut} ${r} ${g} ${b} / ${this.alpha})`;}
_toHSLString()
{if(!this.simple)
return this._toHSLAString();let[h,s,l]=this.hsl.map((x)=>x.maxDecimals(2));return`hsl(${h}, ${s}%, ${l}%)`;}
_toHSLAString()
{let[h,s,l]=this.hsl.map((x)=>x.maxDecimals(2));return`hsla(${h}, ${s}%, ${l}%, ${this.alpha})`;}
_componentToHexValue(value)
{let hex=WI.Color._eightBitChannel(value).toString(16);if(hex.length===1)
hex="0"+hex;return hex;}};WI.Color.Format={Original:"color-format-original",Keyword:"color-format-keyword",HEX:"color-format-hex",ShortHEX:"color-format-short-hex",HEXAlpha:"color-format-hex-alpha",ShortHEXAlpha:"color-format-short-hex-alpha",RGB:"color-format-rgb",RGBA:"color-format-rgba",HSL:"color-format-hsl",HSLA:"color-format-hsla",ColorFunction:"color-format-color-function",};WI.Color.Gamut={SRGB:"srgb",DisplayP3:"display-p3",};WI.Color.FunctionNames=new Set(["rgb","rgba","hsl","hsla","color",]);WI.Color.Keywords={"aliceblue":[240,248,255,1],"antiquewhite":[250,235,215,1],"aqua":[0,255,255,1],"aquamarine":[127,255,212,1],"azure":[240,255,255,1],"beige":[245,245,220,1],"bisque":[255,228,196,1],"black":[0,0,0,1],"blanchedalmond":[255,235,205,1],"blue":[0,0,255,1],"blueviolet":[138,43,226,1],"brown":[165,42,42,1],"burlywood":[222,184,135,1],"cadetblue":[95,158,160,1],"chartreuse":[127,255,0,1],"chocolate":[210,105,30,1],"coral":[255,127,80,1],"cornflowerblue":[100,149,237,1],"cornsilk":[255,248,220,1],"crimson":[237,164,61,1],"cyan":[0,255,255,1],"darkblue":[0,0,139,1],"darkcyan":[0,139,139,1],"darkgoldenrod":[184,134,11,1],"darkgray":[169,169,169,1],"darkgreen":[0,100,0,1],"darkgrey":[169,169,169,1],"darkkhaki":[189,183,107,1],"darkmagenta":[139,0,139,1],"darkolivegreen":[85,107,47,1],"darkorange":[255,140,0,1],"darkorchid":[153,50,204,1],"darkred":[139,0,0,1],"darksalmon":[233,150,122,1],"darkseagreen":[143,188,143,1],"darkslateblue":[72,61,139,1],"darkslategray":[47,79,79,1],"darkslategrey":[47,79,79,1],"darkturquoise":[0,206,209,1],"darkviolet":[148,0,211,1],"deeppink":[255,20,147,1],"deepskyblue":[0,191,255,1],"dimgray":[105,105,105,1],"dimgrey":[105,105,105,1],"dodgerblue":[30,144,255,1],"firebrick":[178,34,34,1],"floralwhite":[255,250,240,1],"forestgreen":[34,139,34,1],"fuchsia":[255,0,255,1],"gainsboro":[220,220,220,1],"ghostwhite":[248,248,255,1],"gold":[255,215,0,1],"goldenrod":[218,165,32,1],"gray":[128,128,128,1],"green":[0,128,0,1],"greenyellow":[173,255,47,1],"grey":[128,128,128,1],"honeydew":[240,255,240,1],"hotpink":[255,105,180,1],"indianred":[205,92,92,1],"indigo":[75,0,130,1],"ivory":[255,255,240,1],"khaki":[240,230,140,1],"lavender":[230,230,250,1],"lavenderblush":[255,240,245,1],"lawngreen":[124,252,0,1],"lemonchiffon":[255,250,205,1],"lightblue":[173,216,230,1],"lightcoral":[240,128,128,1],"lightcyan":[224,255,255,1],"lightgoldenrodyellow":[250,250,210,1],"lightgray":[211,211,211,1],"lightgreen":[144,238,144,1],"lightgrey":[211,211,211,1],"lightpink":[255,182,193,1],"lightsalmon":[255,160,122,1],"lightseagreen":[32,178,170,1],"lightskyblue":[135,206,250,1],"lightslategray":[119,136,153,1],"lightslategrey":[119,136,153,1],"lightsteelblue":[176,196,222,1],"lightyellow":[255,255,224,1],"lime":[0,255,0,1],"limegreen":[50,205,50,1],"linen":[250,240,230,1],"magenta":[255,0,255,1],"maroon":[128,0,0,1],"mediumaquamarine":[102,205,170,1],"mediumblue":[0,0,205,1],"mediumorchid":[186,85,211,1],"mediumpurple":[147,112,219,1],"mediumseagreen":[60,179,113,1],"mediumslateblue":[123,104,238,1],"mediumspringgreen":[0,250,154,1],"mediumturquoise":[72,209,204,1],"mediumvioletred":[199,21,133,1],"midnightblue":[25,25,112,1],"mintcream":[245,255,250,1],"mistyrose":[255,228,225,1],"moccasin":[255,228,181,1],"navajowhite":[255,222,173,1],"navy":[0,0,128,1],"oldlace":[253,245,230,1],"olive":[128,128,0,1],"olivedrab":[107,142,35,1],"orange":[255,165,0,1],"orangered":[255,69,0,1],"orchid":[218,112,214,1],"palegoldenrod":[238,232,170,1],"palegreen":[152,251,152,1],"paleturquoise":[175,238,238,1],"palevioletred":[219,112,147,1],"papayawhip":[255,239,213,1],"peachpuff":[255,218,185,1],"peru":[205,133,63,1],"pink":[255,192,203,1],"plum":[221,160,221,1],"powderblue":[176,224,230,1],"purple":[128,0,128,1],"rebeccapurple":[102,51,153,1],"red":[255,0,0,1],"rosybrown":[188,143,143,1],"royalblue":[65,105,225,1],"saddlebrown":[139,69,19,1],"salmon":[250,128,114,1],"sandybrown":[244,164,96,1],"seagreen":[46,139,87,1],"seashell":[255,245,238,1],"sienna":[160,82,45,1],"silver":[192,192,192,1],"skyblue":[135,206,235,1],"slateblue":[106,90,205,1],"slategray":[112,128,144,1],"slategrey":[112,128,144,1],"snow":[255,250,250,1],"springgreen":[0,255,127,1],"steelblue":[70,130,180,1],"tan":[210,180,140,1],"teal":[0,128,128,1],"thistle":[216,191,216,1],"tomato":[255,99,71,1],"transparent":[0,0,0,0],"turquoise":[64,224,208,1],"violet":[238,130,238,1],"wheat":[245,222,179,1],"white":[255,255,255,1],"whitesmoke":[245,245,245,1],"yellow":[255,255,0,1],"yellowgreen":[154,205,50,1],};WI.ConsoleCommandResultMessage=class ConsoleCommandResult extends WI.ConsoleMessage
{constructor(target,result,wasThrown,savedResultIndex,shouldRevealConsole=true)
{let source=WI.ConsoleMessage.MessageSource.JS;let level=wasThrown?WI.ConsoleMessage.MessageLevel.Error:WI.ConsoleMessage.MessageLevel.Log;let type=WI.ConsoleMessage.MessageType.Result;super(target,source,level,"",type,undefined,undefined,undefined,0,[result],undefined,undefined);this._savedResultIndex=savedResultIndex;this._shouldRevealConsole=shouldRevealConsole;if(this._savedResultIndex&&this._savedResultIndex>WI.ConsoleCommandResultMessage.maximumSavedResultIndex)
WI.ConsoleCommandResultMessage.maximumSavedResultIndex=this._savedResultIndex;}
static clearMaximumSavedResultIndex()
{WI.ConsoleCommandResultMessage.maximumSavedResultIndex=0;}
get savedResultIndex()
{return this._savedResultIndex;}
get shouldRevealConsole()
{return this._shouldRevealConsole;}};WI.ConsoleCommandResultMessage.maximumSavedResultIndex=0;WI.Cookie=class Cookie
{constructor(type,name,value,{header,expires,session,maxAge,path,domain,secure,httpOnly,sameSite}={})
{this._type=type;this._name=name;this._value=value;this._size=this._name.length+this._value.length;if(this._type===WI.Cookie.Type.Response){this._header=header||"";this._expires=(!session&&expires)||null;this._session=session||false;this._maxAge=maxAge||null;this._path=path||null;this._domain=domain||null;this._secure=secure||false;this._httpOnly=httpOnly||false;this._sameSite=sameSite||WI.Cookie.SameSiteType.None;}}
static fromPayload(payload)
{let{name,value,...options}=payload;options.expires=options.expires?new Date(options.expires.maxDecimals(-3)):null;return new WI.Cookie(WI.Cookie.Type.Response,name,value,options);}
static parseCookieRequestHeader(header)
{if(!header)
return[];header=header.trim();if(!header)
return[];let cookies=[];let pairs=header.split(/; /);for(let pair of pairs){let match=pair.match(/^(?<name>[^\s=]+)[ \t]*=[ \t]*(?<value>.*)$/);if(!match){WI.reportInternalError("Failed to parse Cookie pair",{header,pair});continue;}
let{name,value}=match.groups;cookies.push(new WI.Cookie(WI.Cookie.Type.Request,name,value));}
return cookies;}
static displayNameForSameSiteType(sameSiteType)
{switch(sameSiteType){case WI.Cookie.SameSiteType.None:return WI.unlocalizedString("None");case WI.Cookie.SameSiteType.Lax:return WI.unlocalizedString("Lax");case WI.Cookie.SameSiteType.Strict:return WI.unlocalizedString("Strict");default:console.error("Invalid SameSite type",sameSiteType);return sameSiteType;}}
static parseSameSiteAttributeValue(attributeValue)
{if(!attributeValue)
return WI.Cookie.SameSiteType.None;switch(attributeValue.toLowerCase()){case"lax":return WI.Cookie.SameSiteType.Lax;case"strict":return WI.Cookie.SameSiteType.Strict;}
return WI.Cookie.SameSiteType.None;}
static parseSetCookieResponseHeader(header)
{if(!header)
return null;let nameValueMatch=header.match(/^(?<name>[^\s=]+)[ \t]*=[ \t]*(?<value>[^;]*)/);if(!nameValueMatch){WI.reportInternalError("Failed to parse Set-Cookie header",{header});return null;}
let{name,value}=nameValueMatch.groups;let expires=null;let session=false;let maxAge=null;let path=null;let domain=null;let secure=false;let httpOnly=false;let sameSite=WI.Cookie.SameSiteType.None;let remaining=header.substr(nameValueMatch[0].length);let attributes=remaining.split(/; ?/);for(let attribute of attributes){if(!attribute)
continue;let match=attribute.match(/^(?<name>[^\s=]+)(?:=(?<value>.*))?$/);if(!match){console.error("Failed to parse Set-Cookie attribute:",attribute);continue;}
let attributeName=match.groups.name;let attributeValue=match.groups.value;switch(attributeName.toLowerCase()){case"expires":expires=new Date(attributeValue);if(isNaN(expires.getTime())){console.warn("Invalid Expires date:",attributeValue);expires=null;}
break;case"max-age":maxAge=parseInt(attributeValue,10);if(isNaN(maxAge)||!/^\d+$/.test(attributeValue)){console.warn("Invalid MaxAge value:",attributeValue);maxAge=null;}
break;case"path":path=attributeValue;break;case"domain":domain=attributeValue;break;case"secure":secure=true;break;case"httponly":httpOnly=true;break;case"samesite":sameSite=WI.Cookie.parseSameSiteAttributeValue(attributeValue);break;default:console.warn("Unknown Cookie attribute:",attribute);break;}}
if(!expires)
session=true;return new WI.Cookie(WI.Cookie.Type.Response,name,value,{header,expires,session,maxAge,path,domain,secure,httpOnly,sameSite});}
get type(){return this._type;}
get name(){return this._name;}
get value(){return this._value;}
get header(){return this._header;}
get expires(){return this._expires;}
get session(){return this._session;}
get maxAge(){return this._maxAge;}
get path(){return this._path;}
get domain(){return this._domain;}
get secure(){return this._secure;}
get httpOnly(){return this._httpOnly;}
get sameSite(){return this._sameSite;}
get size(){return this._size;}
get url()
{let url=this._secure?"https://":"http://";url+=this._domain||"";url+=this._path||"";return url;}
expirationDate(requestSentDate)
{if(this._session)
return null;if(this._maxAge){let startDate=requestSentDate||new Date;return new Date(startDate.getTime()+(this._maxAge*1000));}
return this._expires;}
equals(other)
{return this._type===other.type&&this._name===other.name&&this._value===other.value&&this._header===other.header&&this._expires?.getTime()===other.expires?.getTime()&&this._session===other.session&&this._maxAge===other.maxAge&&this._path===other.path&&this._domain===other.domain&&this._secure===other.secure&&this._httpOnly===other.httpOnly&&this._sameSite===other.sameSite;}
toProtocol()
{if(typeof this._name!=="string")
return null;if(typeof this._value!=="string")
return null;if(typeof this._domain!=="string")
return null;if(typeof this._path!=="string")
return null;if(!this._session&&!this._expires)
return null;if(!Object.values(WI.Cookie.SameSiteType).includes(this._sameSite))
return null;let json={name:this._name,value:this._value,domain:this._domain,path:this._path,expires:this._expires?.getTime(),session:this._session,httpOnly:!!this._httpOnly,secure:!!this._secure,sameSite:this._sameSite,};return json;}};WI.Cookie.Type={Request:"request",Response:"response",};WI.Cookie.SameSiteType={None:"None",Lax:"Lax",Strict:"Strict",};WI.CookieStorageObject=class CookieStorageObject
{constructor(host)
{this._host=host;}
static cookieMatchesResourceURL(cookie,resourceURL)
{var parsedURL=parseURL(resourceURL);if(!parsedURL||!WI.CookieStorageObject.cookieDomainMatchesResourceDomain(cookie.domain,parsedURL.host))
return false;return parsedURL.path.startsWith(cookie.path)&&(!cookie.port||parsedURL.port===cookie.port)&&(!cookie.secure||parsedURL.scheme==="https");}
static cookieDomainMatchesResourceDomain(cookieDomain,resourceDomain)
{if(cookieDomain.charAt(0)!==".")
return resourceDomain===cookieDomain;return!!resourceDomain.match(new RegExp("^(?:[^\\.]+\\.)*"+cookieDomain.substring(1).escapeForRegExp()+"$"),"i");}
get host()
{return this._host;}
saveIdentityToCookie(cookie)
{cookie[WI.CookieStorageObject.CookieHostCookieKey]=this.host;}};WI.CookieStorageObject.TypeIdentifier="cookie-storage";WI.CookieStorageObject.CookieHostCookieKey="cookie-storage-host";WI.DOMBreakpoint=class DOMBreakpoint extends WI.Breakpoint
{constructor(domNodeOrInfo,type,{disabled,actions,condition,ignoreCount,autoContinue}={})
{super({disabled,actions,condition,ignoreCount,autoContinue});if(domNodeOrInfo instanceof WI.DOMNode){this._domNode=domNodeOrInfo;this._path=domNodeOrInfo.path();this._url=WI.networkManager.mainFrame.url;}else if(domNodeOrInfo&&typeof domNodeOrInfo==="object"){this._domNode=null;this._path=domNodeOrInfo.path;this._url=domNodeOrInfo.url;}
this._type=type;}
static displayNameForType(type)
{switch(type){case WI.DOMBreakpoint.Type.SubtreeModified:return WI.UIString("Subtree Modified","Subtree Modified @ DOM Breakpoint","A submenu item of 'Break On' that breaks (pauses) before child DOM node is modified");case WI.DOMBreakpoint.Type.AttributeModified:return WI.UIString("Attribute Modified","Attribute Modified @ DOM Breakpoint","A submenu item of 'Break On' that breaks (pauses) before DOM attribute is modified");case WI.DOMBreakpoint.Type.NodeRemoved:return WI.UIString("Node Removed","Node Removed @ DOM Breakpoint","A submenu item of 'Break On' that breaks (pauses) before DOM node is removed");}
return WI.UIString("DOM");}
static fromJSON(json)
{return new WI.DOMBreakpoint(json,json.type,{disabled:json.disabled,condition:json.condition,actions:json.actions?.map((actionJSON)=>WI.BreakpointAction.fromJSON(actionJSON))||[],ignoreCount:json.ignoreCount,autoContinue:json.autoContinue,});}
get type(){return this._type;}
get url(){return this._url;}
get path(){return this._path;}
get displayName()
{return WI.DOMBreakpoint.displayNameForType(this._type);}
get editable()
{return InspectorBackend.hasCommand("DOMDebugger.setDOMBreakpoint","options");}
get domNode()
{return this._domNode;}
set domNode(domNode)
{if(!xor(domNode,this._domNode))
return;this.dispatchEventToListeners(WI.DOMBreakpoint.Event.DOMNodeWillChange);this._domNode=domNode;this.dispatchEventToListeners(WI.DOMBreakpoint.Event.DOMNodeDidChange);}
remove()
{super.remove();WI.domDebuggerManager.removeDOMBreakpoint(this);}
saveIdentityToCookie(cookie)
{cookie["dom-breakpoint-url"]=this._url;cookie["dom-breakpoint-path"]=this._path;cookie["dom-breakpoint-type"]=this._type;}
toJSON(key)
{let json=super.toJSON(key);json.url=this._url;json.path=this._path;json.type=this._type;if(key===WI.ObjectStore.toJSONSymbol)
json[WI.objectStores.domBreakpoints.keyPath]=this._url+":"+this._path+":"+this._type;return json;}};WI.DOMBreakpoint.Type={SubtreeModified:"subtree-modified",AttributeModified:"attribute-modified",NodeRemoved:"node-removed",};WI.DOMBreakpoint.Event={DOMNodeDidChange:"dom-breakpoint-dom-node-did-change",DOMNodeWillChange:"dom-breakpoint-dom-node-will-change",};WI.DOMBreakpoint.ReferencePage=WI.ReferencePage.DOMBreakpoints;WI.DOMNode=class DOMNode extends WI.Object
{constructor(domManager,doc,isInShadowTree,payload)
{super();this._destroyed=false;this._domManager=domManager;this._isInShadowTree=isInShadowTree;this.id=payload.nodeId;this._domManager._idToDOMNode[this.id]=this;this._nodeType=payload.nodeType;this._nodeName=payload.nodeName;this._localName=payload.localName;this._nodeValue=payload.nodeValue;this._pseudoType=payload.pseudoType;this._shadowRootType=payload.shadowRootType;this._computedRole=null;this._contentSecurityPolicyHash=payload.contentSecurityPolicyHash;this._layoutContextType=null;this._layoutOverlayShowing=false;this._layoutOverlayColorSetting=null;if(this._nodeType===Node.DOCUMENT_NODE)
this.ownerDocument=this;else
this.ownerDocument=doc;this._frame=null;if(InspectorBackend.hasDomain("Audit")){if(payload.frameId)
this._frame=WI.networkManager.frameForIdentifier(payload.frameId);}
if(!this._frame&&this.ownerDocument)
this._frame=WI.networkManager.frameForIdentifier(this.ownerDocument.frameIdentifier);this._attributes=[];this._attributesMap=new Map;if(payload.attributes)
this._setAttributesPayload(payload.attributes);this._childNodeCount=payload.childNodeCount;this._children=null;this._nextSibling=null;this._previousSibling=null;this.parentNode=null;this._enabledPseudoClasses=[];this._shadowRoots=[];if(payload.shadowRoots){for(var i=0;i<payload.shadowRoots.length;++i){var root=payload.shadowRoots[i];var node=new WI.DOMNode(this._domManager,this.ownerDocument,true,root);node.parentNode=this;this._shadowRoots.push(node);}}
if(payload.children)
this._setChildrenPayload(payload.children);else if(this._shadowRoots.length&&!this._childNodeCount)
this._children=this._shadowRoots.slice();if(this._nodeType===Node.ELEMENT_NODE)
this._customElementState=payload.customElementState||WI.DOMNode.CustomElementState.Builtin;else
this._customElementState=null;if(payload.templateContent){this._templateContent=new WI.DOMNode(this._domManager,this.ownerDocument,false,payload.templateContent);this._templateContent.parentNode=this;}
this._pseudoElements=new Map;if(payload.pseudoElements){for(var i=0;i<payload.pseudoElements.length;++i){var node=new WI.DOMNode(this._domManager,this.ownerDocument,this._isInShadowTree,payload.pseudoElements[i]);node.parentNode=this;this._pseudoElements.set(node.pseudoType(),node);}}
if(payload.contentDocument){this._contentDocument=new WI.DOMNode(this._domManager,null,false,payload.contentDocument);this._children=[this._contentDocument];this._renumber();}
if(this._nodeType===Node.ELEMENT_NODE){if(this.ownerDocument&&!this.ownerDocument.documentElement&&this._nodeName==="HTML")
this.ownerDocument.documentElement=this;if(this.ownerDocument&&!this.ownerDocument.body&&this._nodeName==="BODY")
this.ownerDocument.body=this;if(payload.documentURL)
this.documentURL=payload.documentURL;}else if(this._nodeType===Node.DOCUMENT_TYPE_NODE){this.publicId=payload.publicId;this.systemId=payload.systemId;}else if(this._nodeType===Node.DOCUMENT_NODE){this.documentURL=payload.documentURL;this.xmlVersion=payload.xmlVersion;}else if(this._nodeType===Node.ATTRIBUTE_NODE){this.name=payload.name;this.value=payload.value;}
this._domEvents=[];this._powerEfficientPlaybackRanges=[];if(this.isMediaElement())
WI.DOMNode.addEventListener(WI.DOMNode.Event.DidFireEvent,this._handleDOMNodeDidFireEvent,this);this.layoutContextType=payload.layoutContextType;}
static resetDefaultLayoutOverlayConfiguration()
{let configuration=WI.DOMNode._defaultLayoutOverlayConfiguration;configuration.nextFlexColorIndex=0;configuration.nextGridColorIndex=0;}
static getFullscreenDOMEvents(domEvents)
{return domEvents.reduce((accumulator,current)=>{if(current.eventName==="webkitfullscreenchange"&&current.data&&(!accumulator.length||accumulator.lastValue.data.enabled!==current.data.enabled))
accumulator.push(current);return accumulator;},[]);}
static isPlayEvent(eventName)
{return eventName==="play"||eventName==="playing";}
static isPauseEvent(eventName)
{return eventName==="pause"||eventName==="stall";}
static isStopEvent(eventName)
{return eventName==="emptied"||eventName==="ended"||eventName==="suspend";}
get destroyed(){return this._destroyed;}
get frame(){return this._frame;}
get nextSibling(){return this._nextSibling;}
get previousSibling(){return this._previousSibling;}
get children(){return this._children;}
get domEvents(){return this._domEvents;}
get powerEfficientPlaybackRanges(){return this._powerEfficientPlaybackRanges;}
get layoutOverlayShowing(){return this._layoutOverlayShowing;}
get attached()
{if(this._destroyed)
return false;for(let node=this;node;node=node.parentNode){if(node.ownerDocument===node)
return true;}
return false;}
get firstChild()
{var children=this.children;if(children&&children.length>0)
return children[0];return null;}
get lastChild()
{var children=this.children;if(children&&children.length>0)
return children.lastValue;return null;}
get childNodeCount()
{var children=this.children;if(children)
return children.length;return this._childNodeCount+this._shadowRoots.length;}
set childNodeCount(count)
{this._childNodeCount=count;}
get layoutContextType()
{return this._layoutContextType;}
set layoutContextType(layoutContextType)
{layoutContextType||=null;if(layoutContextType===this._layoutContextType)
return;let oldLayoutContextType=this._layoutContextType;this._layoutContextType=layoutContextType;this.dispatchEventToListeners(WI.DOMNode.Event.LayoutContextTypeChanged);if(!this._layoutOverlayShowing)
return;this.dispatchEventToListeners(WI.DOMNode.Event.LayoutOverlayHidden);switch(oldLayoutContextType){case WI.DOMNode.LayoutContextType.Flex:WI.settings.flexOverlayShowOrderNumbers.removeEventListener(WI.Setting.Event.Changed,this._handleLayoutOverlaySettingChanged,this);break;case WI.DOMNode.LayoutContextType.Grid:WI.settings.gridOverlayShowExtendedGridLines.removeEventListener(WI.Setting.Event.Changed,this._handleLayoutOverlaySettingChanged,this);WI.settings.gridOverlayShowLineNames.removeEventListener(WI.Setting.Event.Changed,this._handleLayoutOverlaySettingChanged,this);WI.settings.gridOverlayShowLineNumbers.removeEventListener(WI.Setting.Event.Changed,this._handleLayoutOverlaySettingChanged,this);WI.settings.gridOverlayShowTrackSizes.removeEventListener(WI.Setting.Event.Changed,this._handleLayoutOverlaySettingChanged,this);WI.settings.gridOverlayShowAreaNames.removeEventListener(WI.Setting.Event.Changed,this._handleLayoutOverlaySettingChanged,this);break;}}
markDestroyed()
{this._destroyed=true;this.layoutContextType=null;}
computedRole()
{return this._computedRole;}
contentSecurityPolicyHash()
{return this._contentSecurityPolicyHash;}
hasAttributes()
{return this._attributes.length>0;}
hasChildNodes()
{return this.childNodeCount>0;}
hasShadowRoots()
{return!!this._shadowRoots.length;}
isInShadowTree()
{return this._isInShadowTree;}
isInUserAgentShadowTree()
{return this._isInShadowTree&&this.ancestorShadowRoot().isUserAgentShadowRoot();}
isCustomElement()
{return this._customElementState===WI.DOMNode.CustomElementState.Custom;}
customElementState()
{return this._customElementState;}
isShadowRoot()
{return!!this._shadowRootType;}
isUserAgentShadowRoot()
{return this._shadowRootType===WI.DOMNode.ShadowRootType.UserAgent;}
ancestorShadowRoot()
{if(!this._isInShadowTree)
return null;let node=this;while(node&&!node.isShadowRoot())
node=node.parentNode;return node;}
ancestorShadowHost()
{let shadowRoot=this.ancestorShadowRoot();return shadowRoot?shadowRoot.parentNode:null;}
isPseudoElement()
{return this._pseudoType!==undefined;}
nodeType()
{return this._nodeType;}
nodeName()
{return this._nodeName;}
nodeNameInCorrectCase()
{return this.isXMLNode()?this.nodeName():this.nodeName().toLowerCase();}
setNodeName(name,callback)
{if(this._destroyed){callback("ERROR: node is destroyed");return;}
let target=WI.assumingMainTarget();target.DOMAgent.setNodeName(this.id,name,this._makeUndoableCallback(callback));}
localName()
{return this._localName;}
templateContent()
{return this._templateContent||null;}
pseudoType()
{return this._pseudoType;}
hasPseudoElements()
{return this._pseudoElements.size>0;}
pseudoElements()
{return this._pseudoElements;}
beforePseudoElement()
{return this._pseudoElements.get(WI.DOMNode.PseudoElementType.Before)||null;}
afterPseudoElement()
{return this._pseudoElements.get(WI.DOMNode.PseudoElementType.After)||null;}
shadowRoots()
{return this._shadowRoots;}
shadowRootType()
{return this._shadowRootType;}
nodeValue()
{return this._nodeValue;}
setNodeValue(value,callback)
{if(this._destroyed){callback("ERROR: node is destroyed");return;}
let target=WI.assumingMainTarget();target.DOMAgent.setNodeValue(this.id,value,this._makeUndoableCallback(callback));}
getAttribute(name)
{let attr=this._attributesMap.get(name);return attr?attr.value:undefined;}
setAttribute(name,text,callback)
{if(this._destroyed){callback("ERROR: node is destroyed");return;}
let target=WI.assumingMainTarget();target.DOMAgent.setAttributesAsText(this.id,text,name,this._makeUndoableCallback(callback));}
setAttributeValue(name,value,callback)
{if(this._destroyed){callback("ERROR: node is destroyed");return;}
let target=WI.assumingMainTarget();target.DOMAgent.setAttributeValue(this.id,name,value,this._makeUndoableCallback(callback));}
attributes()
{return this._attributes;}
removeAttribute(name,callback)
{if(this._destroyed){callback("ERROR: node is destroyed");return;}
function mycallback(error,success)
{if(!error){this._attributesMap.delete(name);for(var i=0;i<this._attributes.length;++i){if(this._attributes[i].name===name){this._attributes.splice(i,1);break;}}}
this._makeUndoableCallback(callback)(error);}
let target=WI.assumingMainTarget();target.DOMAgent.removeAttribute(this.id,name,mycallback.bind(this));}
toggleClass(className,flag)
{if(!className||!className.length)
return;if(this.isPseudoElement()){this.parentNode.toggleClass(className,flag);return;}
if(this.nodeType()!==Node.ELEMENT_NODE)
return;WI.RemoteObject.resolveNode(this).then((object)=>{function inspectedPage_node_toggleClass(className,flag){this.classList.toggle(className,flag);}
object.callFunction(inspectedPage_node_toggleClass,[className,flag]);object.release();});}
querySelector(selector,callback)
{let target=WI.assumingMainTarget();if(typeof callback!=="function"){if(this._destroyed)
return Promise.reject("ERROR: node is destroyed");return target.DOMAgent.querySelector(this.id,selector).then(({nodeId})=>nodeId);}
if(this._destroyed){callback("ERROR: node is destroyed");return;}
target.DOMAgent.querySelector(this.id,selector,WI.DOMManager.wrapClientCallback(callback));}
querySelectorAll(selector,callback)
{let target=WI.assumingMainTarget();if(typeof callback!=="function"){if(this._destroyed)
return Promise.reject("ERROR: node is destroyed");return target.DOMAgent.querySelectorAll(this.id,selector).then(({nodeIds})=>nodeIds);}
if(this._destroyed){callback("ERROR: node is destroyed");return;}
target.DOMAgent.querySelectorAll(this.id,selector,WI.DOMManager.wrapClientCallback(callback));}
highlight(mode)
{if(this._destroyed)
return;if(this._hideDOMNodeHighlightTimeout){clearTimeout(this._hideDOMNodeHighlightTimeout);this._hideDOMNodeHighlightTimeout=undefined;}
let target=WI.assumingMainTarget();target.DOMAgent.highlightNode(WI.DOMManager.buildHighlightConfig(mode),this.id);}
showLayoutOverlay({color,initiator}={})
{if(this._destroyed)
return Promise.reject("ERROR: node is destroyed");color||=this.layoutOverlayColor;let target=WI.assumingMainTarget();let agentCommandFunction=null;let agentCommandArguments={nodeId:this.id};switch(this._layoutContextType){case WI.DOMNode.LayoutContextType.Grid:agentCommandArguments.gridColor=color.toProtocol();agentCommandArguments.showLineNames=WI.settings.gridOverlayShowLineNames.value;agentCommandArguments.showLineNumbers=WI.settings.gridOverlayShowLineNumbers.value;agentCommandArguments.showExtendedGridLines=WI.settings.gridOverlayShowExtendedGridLines.value;agentCommandArguments.showTrackSizes=WI.settings.gridOverlayShowTrackSizes.value;agentCommandArguments.showAreaNames=WI.settings.gridOverlayShowAreaNames.value;agentCommandFunction=target.DOMAgent.showGridOverlay;if(!this._layoutOverlayShowing){WI.settings.gridOverlayShowExtendedGridLines.addEventListener(WI.Setting.Event.Changed,this._handleLayoutOverlaySettingChanged,this);WI.settings.gridOverlayShowLineNames.addEventListener(WI.Setting.Event.Changed,this._handleLayoutOverlaySettingChanged,this);WI.settings.gridOverlayShowLineNumbers.addEventListener(WI.Setting.Event.Changed,this._handleLayoutOverlaySettingChanged,this);WI.settings.gridOverlayShowTrackSizes.addEventListener(WI.Setting.Event.Changed,this._handleLayoutOverlaySettingChanged,this);WI.settings.gridOverlayShowAreaNames.addEventListener(WI.Setting.Event.Changed,this._handleLayoutOverlaySettingChanged,this);}
break;case WI.DOMNode.LayoutContextType.Flex:agentCommandArguments.flexColor=color.toProtocol();agentCommandArguments.showOrderNumbers=WI.settings.flexOverlayShowOrderNumbers.value;agentCommandFunction=target.DOMAgent.showFlexOverlay;if(!this._layoutOverlayShowing)
WI.settings.flexOverlayShowOrderNumbers.addEventListener(WI.Setting.Event.Changed,this._handleLayoutOverlaySettingChanged,this);break;}
this._layoutOverlayShowing=true;this.dispatchEventToListeners(WI.DOMNode.Event.LayoutOverlayShown,{initiator});return agentCommandFunction.invoke(agentCommandArguments);}
hideLayoutOverlay()
{if(this._destroyed)
return Promise.reject("ERROR: node is destroyed");let target=WI.assumingMainTarget();let agentCommandFunction;let agentCommandArguments={nodeId:this.id};switch(this._layoutContextType){case WI.DOMNode.LayoutContextType.Grid:WI.settings.gridOverlayShowExtendedGridLines.removeEventListener(WI.Setting.Event.Changed,this._handleLayoutOverlaySettingChanged,this);WI.settings.gridOverlayShowLineNames.removeEventListener(WI.Setting.Event.Changed,this._handleLayoutOverlaySettingChanged,this);WI.settings.gridOverlayShowLineNumbers.removeEventListener(WI.Setting.Event.Changed,this._handleLayoutOverlaySettingChanged,this);WI.settings.gridOverlayShowTrackSizes.removeEventListener(WI.Setting.Event.Changed,this._handleLayoutOverlaySettingChanged,this);WI.settings.gridOverlayShowAreaNames.removeEventListener(WI.Setting.Event.Changed,this._handleLayoutOverlaySettingChanged,this);agentCommandFunction=target.DOMAgent.hideGridOverlay;break;case WI.DOMNode.LayoutContextType.Flex:WI.settings.flexOverlayShowOrderNumbers.removeEventListener(WI.Setting.Event.Changed,this._handleLayoutOverlaySettingChanged,this);agentCommandFunction=target.DOMAgent.hideFlexOverlay;break;}
this._layoutOverlayShowing=false;this.dispatchEventToListeners(WI.DOMNode.Event.LayoutOverlayHidden);return agentCommandFunction.invoke(agentCommandArguments);}
get layoutOverlayColor()
{this._createLayoutOverlayColorSettingIfNeeded();return new WI.Color(WI.Color.Format.HSL,this._layoutOverlayColorSetting.value);}
set layoutOverlayColor(color)
{this._createLayoutOverlayColorSettingIfNeeded();this._layoutOverlayColorSetting.value=color.hsl;if(this._layoutOverlayShowing)
this.showLayoutOverlay({color});}
scrollIntoView()
{WI.RemoteObject.resolveNode(this).then((object)=>{function inspectedPage_node_scrollIntoView(){this.scrollIntoViewIfNeeded(true);}
object.callFunction(inspectedPage_node_scrollIntoView);object.release();});}
getChildNodes(callback)
{if(this.children){if(callback)
callback(this.children);return;}
if(this._destroyed){callback(this.children);return;}
function mycallback(error){if(!error&&callback)
callback(this.children);}
let target=WI.assumingMainTarget();target.DOMAgent.requestChildNodes(this.id,mycallback.bind(this));}
getSubtree(depth,callback)
{if(this._destroyed){callback(this.children);return;}
function mycallback(error)
{if(callback)
callback(error?null:this.children);}
let target=WI.assumingMainTarget();target.DOMAgent.requestChildNodes(this.id,depth,mycallback.bind(this));}
getOuterHTML(callback)
{let target=WI.assumingMainTarget();if(typeof callback!=="function"){if(this._destroyed)
return Promise.reject("ERROR: node is destroyed");return target.DOMAgent.getOuterHTML(this.id).then(({outerHTML})=>outerHTML);}
if(this._destroyed){callback("ERROR: node is destroyed");return;}
target.DOMAgent.getOuterHTML(this.id,callback);}
setOuterHTML(html,callback)
{if(this._destroyed){callback("ERROR: node is destroyed");return;}
let target=WI.assumingMainTarget();target.DOMAgent.setOuterHTML(this.id,html,this._makeUndoableCallback(callback));}
insertAdjacentHTML(position,html)
{if(this._destroyed)
return;if(this.nodeType()!==Node.ELEMENT_NODE)
return;let target=WI.assumingMainTarget();if(!target.hasCommand("DOM.insertAdjacentHTML")){WI.RemoteObject.resolveNode(this).then((object)=>{function inspectedPage_node_insertAdjacentHTML(position,html){this.insertAdjacentHTML(position,html);}
object.callFunction(inspectedPage_node_insertAdjacentHTML,[position,html]);object.release();});return;}
target.DOMAgent.insertAdjacentHTML(this.id,position,html,this._makeUndoableCallback());}
removeNode(callback)
{if(this._destroyed){callback("ERROR: node is destroyed");return;}
let target=WI.assumingMainTarget();target.DOMAgent.removeNode(this.id,this._makeUndoableCallback(callback));}
getEventListeners(callback)
{if(this._destroyed){callback("ERROR: node is destroyed");return;}
let target=WI.assumingMainTarget();target.DOMAgent.getEventListenersForNode(this.id,callback);}
accessibilityProperties(callback)
{if(this._destroyed){callback({});return;}
function accessibilityPropertiesCallback(error,accessibilityProperties)
{if(!error&&callback&&accessibilityProperties){this._computedRole=accessibilityProperties.role;callback({activeDescendantNodeId:accessibilityProperties.activeDescendantNodeId,busy:accessibilityProperties.busy,checked:accessibilityProperties.checked,childNodeIds:accessibilityProperties.childNodeIds,controlledNodeIds:accessibilityProperties.controlledNodeIds,current:accessibilityProperties.current,disabled:accessibilityProperties.disabled,exists:accessibilityProperties.exists,expanded:accessibilityProperties.expanded,flowedNodeIds:accessibilityProperties.flowedNodeIds,focused:accessibilityProperties.focused,ignored:accessibilityProperties.ignored,ignoredByDefault:accessibilityProperties.ignoredByDefault,invalid:accessibilityProperties.invalid,isPopupButton:accessibilityProperties.isPopUpButton,headingLevel:accessibilityProperties.headingLevel,hierarchyLevel:accessibilityProperties.hierarchyLevel,hidden:accessibilityProperties.hidden,label:accessibilityProperties.label,liveRegionAtomic:accessibilityProperties.liveRegionAtomic,liveRegionRelevant:accessibilityProperties.liveRegionRelevant,liveRegionStatus:accessibilityProperties.liveRegionStatus,mouseEventNodeId:accessibilityProperties.mouseEventNodeId,nodeId:accessibilityProperties.nodeId,ownedNodeIds:accessibilityProperties.ownedNodeIds,parentNodeId:accessibilityProperties.parentNodeId,pressed:accessibilityProperties.pressed,readonly:accessibilityProperties.readonly,required:accessibilityProperties.required,role:accessibilityProperties.role,selected:accessibilityProperties.selected,selectedChildNodeIds:accessibilityProperties.selectedChildNodeIds});}}
let target=WI.assumingMainTarget();target.DOMAgent.getAccessibilityPropertiesForNode(this.id,accessibilityPropertiesCallback.bind(this));}
path()
{var path=[];var node=this;while(node&&"index"in node&&node._nodeName.length){path.push([node.index,node._nodeName]);node=node.parentNode;}
path.reverse();return path.join(",");}
get escapedIdSelector()
{return this._idSelector(true);}
get escapedClassSelector()
{return this._classSelector(true);}
get displayName()
{if(this.isPseudoElement())
return"::"+this._pseudoType;return this.nodeNameInCorrectCase()+this.escapedIdSelector+this.escapedClassSelector;}
get unescapedSelector()
{if(this.isPseudoElement())
return"::"+this._pseudoType;const shouldEscape=false;return this.nodeNameInCorrectCase()+this._idSelector(shouldEscape)+this._classSelector(shouldEscape);}
appropriateSelectorFor(justSelector)
{if(this.isPseudoElement())
return this.parentNode.appropriateSelectorFor()+"::"+this._pseudoType;let lowerCaseName=this.localName()||this.nodeName().toLowerCase();let id=this.escapedIdSelector;if(id.length)
return justSelector?id:lowerCaseName+id;let classes=this.escapedClassSelector;if(classes.length)
return justSelector?classes:lowerCaseName+classes;if(lowerCaseName==="input"&&this.getAttribute("type"))
return lowerCaseName+"[type=\""+this.getAttribute("type")+"\"]";return lowerCaseName;}
isAncestor(node)
{if(!node)
return false;var currentNode=node.parentNode;while(currentNode){if(this===currentNode)
return true;currentNode=currentNode.parentNode;}
return false;}
isDescendant(descendant)
{return descendant!==null&&descendant.isAncestor(this);}
get ownerSVGElement()
{if(this._nodeName==="svg")
return this;if(!this.parentNode)
return null;return this.parentNode.ownerSVGElement;}
isSVGElement()
{return!!this.ownerSVGElement;}
isMediaElement()
{let lowerCaseName=this.localName()||this.nodeName().toLowerCase();return lowerCaseName==="video"||lowerCaseName==="audio";}
didFireEvent(eventName,timestamp,data)
{this._addDOMEvent({eventName,timestamp:WI.timelineManager.computeElapsedTime(timestamp),data,});}
powerEfficientPlaybackStateChanged(timestamp,isPowerEfficient)
{let lastValue=this._powerEfficientPlaybackRanges.lastValue;if(isPowerEfficient){if(!lastValue||lastValue.endTimestamp)
this._powerEfficientPlaybackRanges.push({startTimestamp:timestamp});}else{if(!lastValue)
this._powerEfficientPlaybackRanges.push({endTimestamp:timestamp});else if(lastValue.startTimestamp)
lastValue.endTimestamp=timestamp;}
this.dispatchEventToListeners(DOMNode.Event.PowerEfficientPlaybackStateChanged,{isPowerEfficient,timestamp});}
canEnterPowerEfficientPlaybackState()
{return this.localName()==="video"||this.nodeName().toLowerCase()==="video";}
_handleDOMNodeDidFireEvent(event)
{if(event.target===this||!event.target.isAncestor(this))
return;let domEvent=Object.shallowCopy(event.data.domEvent);domEvent.originator=event.target;this._addDOMEvent(domEvent);}
_addDOMEvent(domEvent)
{this._domEvents.push(domEvent);this.dispatchEventToListeners(WI.DOMNode.Event.DidFireEvent,{domEvent});}
_setAttributesPayload(attrs)
{this._attributes=[];this._attributesMap=new Map;for(var i=0;i<attrs.length;i+=2)
this._addAttribute(attrs[i],attrs[i+1]);}
_insertChild(prev,payload)
{var node=new WI.DOMNode(this._domManager,this.ownerDocument,this._isInShadowTree,payload);if(!prev){if(!this._children){this._children=this._shadowRoots.concat([node]);}else
this._children.unshift(node);}else
this._children.splice(this._children.indexOf(prev)+1,0,node);this._renumber();return node;}
_removeChild(node)
{if(node.isPseudoElement()){this._pseudoElements.delete(node.pseudoType());node.parentNode=null;}else{this._children.splice(this._children.indexOf(node),1);node.parentNode=null;this._renumber();}}
_setChildrenPayload(payloads)
{if(this._contentDocument)
return;this._children=this._shadowRoots.slice();for(var i=0;i<payloads.length;++i){var node=new WI.DOMNode(this._domManager,this.ownerDocument,this._isInShadowTree,payloads[i]);this._children.push(node);}
this._renumber();}
_renumber()
{var childNodeCount=this._children.length;if(childNodeCount===0)
return;for(var i=0;i<childNodeCount;++i){var child=this._children[i];child.index=i;child._nextSibling=i+1<childNodeCount?this._children[i+1]:null;child._previousSibling=i-1>=0?this._children[i-1]:null;child.parentNode=this;}}
_addAttribute(name,value)
{let attr={name,value,_node:this};this._attributesMap.set(name,attr);this._attributes.push(attr);}
_setAttribute(name,value)
{let attr=this._attributesMap.get(name);if(attr)
attr.value=value;else
this._addAttribute(name,value);}
_removeAttribute(name)
{let attr=this._attributesMap.get(name);if(attr){this._attributes.remove(attr);this._attributesMap.delete(name);}}
moveTo(targetNode,anchorNode,callback)
{if(this._destroyed){callback("ERROR: node is destroyed");return;}
let target=WI.assumingMainTarget();target.DOMAgent.moveTo(this.id,targetNode.id,anchorNode?anchorNode.id:undefined,this._makeUndoableCallback(callback));}
isXMLNode()
{return!!this.ownerDocument&&!!this.ownerDocument.xmlVersion;}
get enabledPseudoClasses()
{return this._enabledPseudoClasses;}
setPseudoClassEnabled(pseudoClass,enabled)
{var pseudoClasses=this._enabledPseudoClasses;if(enabled){if(pseudoClasses.includes(pseudoClass))
return;pseudoClasses.push(pseudoClass);}else{if(!pseudoClasses.includes(pseudoClass))
return;pseudoClasses.remove(pseudoClass);}
function changed(error)
{if(!error)
this.dispatchEventToListeners(WI.DOMNode.Event.EnabledPseudoClassesChanged);}
let target=WI.assumingMainTarget();target.CSSAgent.forcePseudoState(this.id,pseudoClasses,changed.bind(this));}
_makeUndoableCallback(callback)
{return(...args)=>{if(!args[0]){let target=WI.assumingMainTarget();if(target.hasCommand("DOM.markUndoableState"))
target.DOMAgent.markUndoableState();}
if(callback)
callback.apply(null,args);};}
_idSelector(shouldEscape)
{let id=this.getAttribute("id");if(!id)
return"";id=id.trim();if(!id.length)
return"";if(shouldEscape)
id=CSS.escape(id);if(/[\s'"]/.test(id))
return`[id="${id}"]`;return`#${id}`;}
_classSelector(shouldEscape){let classes=this.getAttribute("class");if(!classes)
return"";classes=classes.trim();if(!classes.length)
return"";let foundClasses=new Set;return classes.split(/\s+/).reduce((selector,className)=>{if(!className.length||foundClasses.has(className))
return selector;foundClasses.add(className);return`${selector}.${(shouldEscape ? CSS.escape(className) : className)}`;},"");}
_createLayoutOverlayColorSettingIfNeeded()
{if(this._layoutOverlayColorSetting)
return;let defaultConfiguration=WI.DOMNode._defaultLayoutOverlayConfiguration;let url=this.ownerDocument.documentURL||WI.networkManager.mainFrame.url;let nextColorIndex;switch(this._layoutContextType){case WI.DOMNode.LayoutContextType.Grid:nextColorIndex=defaultConfiguration.nextGridColorIndex;defaultConfiguration.nextGridColorIndex=(nextColorIndex+1)%defaultConfiguration.colors.length;break;case WI.DOMNode.LayoutContextType.Flex:nextColorIndex=defaultConfiguration.nextFlexColorIndex;defaultConfiguration.nextFlexColorIndex=(nextColorIndex+1)%defaultConfiguration.colors.length;break;}
this._layoutOverlayColorSetting=new WI.Setting(`overlay-color-${url.hash}-${this.path().hash}`,defaultConfiguration.colors[nextColorIndex]);}
_handleLayoutOverlaySettingChanged(event)
{if(this._layoutOverlayShowing)
this.showLayoutOverlay();}};WI.DOMNode._defaultLayoutOverlayConfiguration={colors:[[329,91,70],[207,96,69],[92,90,64],[291,73,68],[40,97,57],],nextFlexColorIndex:0,nextGridColorIndex:0,};WI.DOMNode.Event={EnabledPseudoClassesChanged:"dom-node-enabled-pseudo-classes-did-change",AttributeModified:"dom-node-attribute-modified",AttributeRemoved:"dom-node-attribute-removed",EventListenersChanged:"dom-node-event-listeners-changed",DidFireEvent:"dom-node-did-fire-event",PowerEfficientPlaybackStateChanged:"dom-node-power-efficient-playback-state-changed",LayoutContextTypeChanged:"dom-node-layout-context-type-changed",LayoutOverlayShown:"dom-node-layout-overlay-shown",LayoutOverlayHidden:"dom-node-layout-overlay-hidden",};WI.DOMNode.PseudoElementType={Before:"before",After:"after",};WI.DOMNode.ShadowRootType={UserAgent:"user-agent",Closed:"closed",Open:"open",};WI.DOMNode.CustomElementState={Builtin:"builtin",Custom:"custom",Waiting:"waiting",Failed:"failed",};WI.DOMNode.LayoutContextType={Flex:"flex",Grid:"grid",};WI.DOMNodeStyles=class DOMNodeStyles extends WI.Object
{constructor(node)
{super();this._node=node||null;this._rulesMap=new Map;this._stylesMap=new Multimap;this._matchedRules=[];this._inheritedRules=[];this._pseudoElements=new Map;this._inlineStyle=null;this._attributesStyle=null;this._computedStyle=null;this._orderedStyles=[];this._computedPrimaryFont=null;this._propertyNameToEffectivePropertyMap={};this._usedCSSVariables=new Set;this._allCSSVariables=new Set;this._variableStylesByType=null;this._pendingRefreshTask=null;this.refresh();this._trackedStyleSheets=new WeakSet;WI.CSSStyleSheet.addEventListener(WI.CSSStyleSheet.Event.ContentDidChange,this._handleCSSStyleSheetContentDidChange,this);}
static parseSelectorListPayload(selectorList)
{let selectors=selectorList.selectors;if(!selectors.length)
return[];return selectors.map(function(selectorPayload){return new WI.CSSSelector(selectorPayload.text,selectorPayload.specificity,selectorPayload.dynamic);});}
static createSourceCodeLocation(sourceURL,{line,column,documentNode}={})
{if(!sourceURL)
return null;let sourceCode=null;if(documentNode){let mainResource=WI.networkManager.resourcesForURL(documentNode.documentURL).firstValue;if(mainResource){let parentFrame=mainResource.parentFrame;sourceCode=parentFrame.resourcesForURL(sourceURL).firstValue;}}
if(!sourceCode)
sourceCode=WI.networkManager.resourcesForURL(sourceURL).firstValue;if(!sourceCode)
return null;return sourceCode.createSourceCodeLocation(line||0,column||0);}
static uniqueOrderedStyles(orderedStyles)
{let uniqueOrderedStyles=[];for(let style of orderedStyles){let rule=style.ownerRule;if(!rule){uniqueOrderedStyles.push(style);continue;}
let found=false;for(let existingStyle of uniqueOrderedStyles){if(rule.isEqualTo(existingStyle.ownerRule)){found=true;break;}}
if(!found)
uniqueOrderedStyles.push(style);}
return uniqueOrderedStyles;}
get node(){return this._node;}
get matchedRules(){return this._matchedRules;}
get inheritedRules(){return this._inheritedRules;}
get inlineStyle(){return this._inlineStyle;}
get attributesStyle(){return this._attributesStyle;}
get pseudoElements(){return this._pseudoElements;}
get computedStyle(){return this._computedStyle;}
get orderedStyles(){return this._orderedStyles;}
get computedPrimaryFont(){return this._computedPrimaryFont;}
get usedCSSVariables(){return this._usedCSSVariables;}
get allCSSVariables(){return this._allCSSVariables;}
get needsRefresh()
{return this._pendingRefreshTask||this._needsRefresh;}
get uniqueOrderedStyles()
{return WI.DOMNodeStyles.uniqueOrderedStyles(this._orderedStyles);}
get variableStylesByType()
{if(this._variableStylesByType)
return this._variableStylesByType;let properties=this._computedStyle?.properties;if(!properties)
return new Map;const typeCheckFunctions=[{type:WI.DOMNodeStyles.VariablesGroupType.Colors,checker:(property)=>WI.Color.fromString(property.value),},{type:WI.DOMNodeStyles.VariablesGroupType.Dimensions,checker:(property)=>/^-?\d+(\.\d+)?\D+$/.test(property.value),},{type:WI.DOMNodeStyles.VariablesGroupType.Numbers,checker:(property)=>/^-?\d+(\.\d+)?$/.test(property.value),},{type:WI.DOMNodeStyles.VariablesGroupType.Other,checker:(property)=>true,},];let variablesForType={};for(let property of properties){if(!property.isVariable)
continue;for(let{type,checker}of typeCheckFunctions){if(checker(property)){variablesForType[type]||=[];variablesForType[type].push(property);break;}}}
this._variableStylesByType=new Map;for(let{type}of typeCheckFunctions){if(!variablesForType[type]?.length)
continue;const ownerStyleSheet=null;const id=null;const inherited=false;const text=null;let style=new WI.CSSStyleDeclaration(this,ownerStyleSheet,id,WI.CSSStyleDeclaration.Type.Computed,this._node,inherited,text,variablesForType[type]);this._variableStylesByType.set(type,style);}
return this._variableStylesByType;}
refreshIfNeeded()
{if(this._pendingRefreshTask)
return this._pendingRefreshTask;if(!this._needsRefresh)
return Promise.resolve(this);return this.refresh();}
refresh()
{if(this._pendingRefreshTask)
return this._pendingRefreshTask;this._needsRefresh=false;let fetchedMatchedStylesPromise=new WI.WrappedPromise;let fetchedInlineStylesPromise=new WI.WrappedPromise;let fetchedComputedStylesPromise=new WI.WrappedPromise;let fetchedFontDataPromise=new WI.WrappedPromise;function wrap(func,promise){return(...args)=>{try{func.apply(this,args);}catch(e){console.error(e);promise.resolve();}};}
let parseRuleMatchArrayPayload=(matchArray,node,inherited,pseudoId)=>{var result=[];var ruleOccurrences={};for(var i=matchArray.length-1;i>=0;--i){var rule=this._parseRulePayload(matchArray[i].rule,matchArray[i].matchingSelectors,node,inherited,pseudoId,ruleOccurrences);if(!rule)
continue;result.push(rule);}
return result;};function fetchedMatchedStyles(error,matchedRulesPayload,pseudoElementRulesPayload,inheritedRulesPayload)
{matchedRulesPayload=matchedRulesPayload||[];pseudoElementRulesPayload=pseudoElementRulesPayload||[];inheritedRulesPayload=inheritedRulesPayload||[];this._previousStylesMap=this._stylesMap;this._stylesMap=new Multimap;this._matchedRules=parseRuleMatchArrayPayload(matchedRulesPayload,this._node);this._pseudoElements.clear();for(let{pseudoId,matches}of pseudoElementRulesPayload){let pseudoElementRules=parseRuleMatchArrayPayload(matches,this._node,false,pseudoId);this._pseudoElements.set(pseudoId,{matchedRules:pseudoElementRules});}
this._inheritedRules=[];var i=0;var currentNode=this._node.parentNode;while(currentNode&&i<inheritedRulesPayload.length){var inheritedRulePayload=inheritedRulesPayload[i];var inheritedRuleInfo={node:currentNode};inheritedRuleInfo.inlineStyle=inheritedRulePayload.inlineStyle?this._parseStyleDeclarationPayload(inheritedRulePayload.inlineStyle,currentNode,true,null,WI.CSSStyleDeclaration.Type.Inline):null;inheritedRuleInfo.matchedRules=inheritedRulePayload.matchedCSSRules?parseRuleMatchArrayPayload(inheritedRulePayload.matchedCSSRules,currentNode,true):[];if(inheritedRuleInfo.inlineStyle||inheritedRuleInfo.matchedRules.length)
this._inheritedRules.push(inheritedRuleInfo);currentNode=currentNode.parentNode;++i;}
fetchedMatchedStylesPromise.resolve();}
function fetchedInlineStyles(error,inlineStylePayload,attributesStylePayload)
{this._inlineStyle=inlineStylePayload?this._parseStyleDeclarationPayload(inlineStylePayload,this._node,false,null,WI.CSSStyleDeclaration.Type.Inline):null;this._attributesStyle=attributesStylePayload?this._parseStyleDeclarationPayload(attributesStylePayload,this._node,false,null,WI.CSSStyleDeclaration.Type.Attribute):null;this._updateStyleCascade();fetchedInlineStylesPromise.resolve();}
function fetchedComputedStyle(error,computedPropertiesPayload)
{var properties=[];for(var i=0;computedPropertiesPayload&&i<computedPropertiesPayload.length;++i){var propertyPayload=computedPropertiesPayload[i];var canonicalName=WI.cssManager.canonicalNameForPropertyName(propertyPayload.name);propertyPayload.implicit=!this._propertyNameToEffectivePropertyMap[canonicalName];var property=this._parseStylePropertyPayload(propertyPayload,NaN,this._computedStyle);if(!property.implicit)
property.implicit=!this._isPropertyFoundInMatchingRules(property.name);properties.push(property);}
if(this._computedStyle)
this._computedStyle.update(null,properties);else
this._computedStyle=new WI.CSSStyleDeclaration(this,null,null,WI.CSSStyleDeclaration.Type.Computed,this._node,false,null,properties);let significantChange=false;for(let[key,styles]of this._stylesMap.sets()){let previousStyles=this._previousStylesMap.get(key);if(previousStyles){let styleFound=false;for(let style of styles){if(previousStyles.has(style)){styleFound=true;break;}}
if(styleFound)
continue;}
if(!this._includeUserAgentRulesOnNextRefresh){let firstStyle=styles.firstValue;if(firstStyle&&firstStyle.ownerRule&&firstStyle.ownerRule.type===WI.CSSStyleSheet.Type.UserAgent){continue;}}
significantChange=true;break;}
if(!significantChange){for(let[key,previousStyles]of this._previousStylesMap.sets()){if(this._stylesMap.has(key))
continue;if(!this._includeUserAgentRulesOnNextRefresh){let firstStyle=previousStyles.firstValue;if(firstStyle&&firstStyle.ownerRule&&firstStyle.ownerRule.type===WI.CSSStyleSheet.Type.UserAgent)
continue;}
significantChange=true;break;}}
if(significantChange)
this._variableStylesByType=null;this._previousStylesMap=null;this._includeUserAgentRulesOnNextRefresh=false;fetchedComputedStylesPromise.resolve({significantChange});}
function fetchedFontData(error,fontDataPayload)
{if(fontDataPayload)
this._computedPrimaryFont=WI.Font.fromPayload(fontDataPayload);else
this._computedPrimaryFont=null;fetchedFontDataPromise.resolve();}
let target=WI.assumingMainTarget();target.CSSAgent.getMatchedStylesForNode.invoke({nodeId:this._node.id,includePseudo:true,includeInherited:true},wrap.call(this,fetchedMatchedStyles,fetchedMatchedStylesPromise));target.CSSAgent.getInlineStylesForNode.invoke({nodeId:this._node.id},wrap.call(this,fetchedInlineStyles,fetchedInlineStylesPromise));target.CSSAgent.getComputedStyleForNode.invoke({nodeId:this._node.id},wrap.call(this,fetchedComputedStyle,fetchedComputedStylesPromise));if(InspectorBackend.hasCommand("CSS.getFontDataForNode"))
target.CSSAgent.getFontDataForNode.invoke({nodeId:this._node.id},wrap.call(this,fetchedFontData,fetchedFontDataPromise));else
fetchedFontDataPromise.resolve();this._pendingRefreshTask=Promise.all([fetchedComputedStylesPromise.promise,fetchedMatchedStylesPromise.promise,fetchedInlineStylesPromise.promise,fetchedFontDataPromise.promise]).then(([fetchComputedStylesResult])=>{this._pendingRefreshTask=null;this.dispatchEventToListeners(WI.DOMNodeStyles.Event.Refreshed,{significantChange:fetchComputedStylesResult.significantChange,});return this;});return this._pendingRefreshTask;}
addRule(selector,text,styleSheetId)
{selector=selector||this._node.appropriateSelectorFor(true);let target=WI.assumingMainTarget();function completed()
{target.DOMAgent.markUndoableState();this.refresh();}
function styleChanged(error,stylePayload)
{if(error)
return;completed.call(this);}
function addedRule(error,rulePayload)
{if(error)
return;if(!text||!text.length){completed.call(this);return;}
target.CSSAgent.setStyleText(rulePayload.style.styleId,text,styleChanged.bind(this));}
function inspectorStyleSheetAvailable(styleSheet)
{if(!styleSheet)
return;target.CSSAgent.addRule(styleSheet.id,selector,addedRule.bind(this));}
if(styleSheetId)
inspectorStyleSheetAvailable.call(this,WI.cssManager.styleSheetForIdentifier(styleSheetId));else
WI.cssManager.preferredInspectorStyleSheetForFrame(this._node.frame,inspectorStyleSheetAvailable.bind(this));}
effectivePropertyForName(name)
{let property=this._propertyNameToEffectivePropertyMap[name];if(property)
return property;let canonicalName=WI.cssManager.canonicalNameForPropertyName(name);return this._propertyNameToEffectivePropertyMap[canonicalName]||null;}
mediaQueryResultDidChange()
{this._markAsNeedsRefresh();}
pseudoClassesDidChange(node)
{this._includeUserAgentRulesOnNextRefresh=true;this._markAsNeedsRefresh();}
attributeDidChange(node,attributeName)
{this._markAsNeedsRefresh();}
changeRuleSelector(rule,selector)
{selector=selector||"";let result=new WI.WrappedPromise;let target=WI.assumingMainTarget();function ruleSelectorChanged(error,rulePayload)
{if(error){result.reject(error);return;}
target.DOMAgent.markUndoableState();this.refresh().then(()=>{result.resolve(rulePayload);});}
this._needsRefresh=true;this._ignoreNextContentDidChangeForStyleSheet=rule.ownerStyleSheet;target.CSSAgent.setRuleSelector(rule.id,selector,ruleSelectorChanged.bind(this));return result.promise;}
changeStyleText(style,text,callback)
{if(!style.ownerStyleSheet||!style.styleSheetTextRange){callback();return;}
text=text||"";let didSetStyleText=(error,stylePayload)=>{if(error){callback(error);return;}
callback();if(style.ownerRule&&!style.ownerRule.matchedSelectorIndices.length)
this._parseStyleDeclarationPayload(stylePayload,this._node,false,null,style.type,style.ownerRule,false);this.refresh();};let target=WI.assumingMainTarget();target.CSSAgent.setStyleText(style.id,text,didSetStyleText);}
_parseSourceRangePayload(payload)
{if(!payload)
return null;return new WI.TextRange(payload.startLine,payload.startColumn,payload.endLine,payload.endColumn);}
_parseStylePropertyPayload(payload,index,styleDeclaration)
{var text=payload.text||"";var name=payload.name;var value=payload.value||"";var priority=payload.priority||"";let range=payload.range||null;var enabled=true;var overridden=false;var implicit=payload.implicit||false;var anonymous=false;var valid="parsedOk"in payload?payload.parsedOk:true;switch(payload.status||"style"){case"active":enabled=true;break;case"inactive":overridden=true;enabled=true;break;case"disabled":enabled=false;break;case"style":anonymous=true;break;}
if(range){let rangeLineCount=1+range.endLine-range.startLine;if(rangeLineCount>1){let textLineCount=text.lineCount;if(textLineCount===rangeLineCount-1){range.endLine=range.startLine+(textLineCount-1);range.endColumn=range.startColumn+text.lastLine.length;}}}
var styleSheetTextRange=this._parseSourceRangePayload(payload.range);if(styleDeclaration){var property=isNaN(index)?styleDeclaration.propertyForName(name):styleDeclaration.enabledProperties[index];if(property&&property.name===name&&(property.index===index||(isNaN(property.index)&&isNaN(index)))){property.update(text,name,value,priority,enabled,overridden,implicit,anonymous,valid,styleSheetTextRange);return property;}
var pendingProperties=styleDeclaration.pendingProperties;for(var i=0;i<pendingProperties.length;++i){var pendingProperty=pendingProperties[i];if(pendingProperty.name===name&&isNaN(pendingProperty.index)){pendingProperty.index=index;pendingProperty.update(text,name,value,priority,enabled,overridden,implicit,anonymous,valid,styleSheetTextRange);return pendingProperty;}}}
return new WI.CSSProperty(index,text,name,value,priority,enabled,overridden,implicit,anonymous,valid,styleSheetTextRange);}
_parseStyleDeclarationPayload(payload,node,inherited,pseudoId,type,rule,matchesNode=true)
{if(!payload)
return null;rule=rule||null;inherited=inherited||false;var id=payload.styleId;var mapKey=id?id.styleSheetId+":"+id.ordinal:null;if(pseudoId)
mapKey+=":"+pseudoId;if(type===WI.CSSStyleDeclaration.Type.Attribute)
mapKey+=":"+node.id+":attribute";let style=rule?rule.style:null;if(matchesNode){let existingStyles=this._previousStylesMap.get(mapKey);if(existingStyles&&!style){for(let existingStyle of existingStyles){if(existingStyle.node===node&&existingStyle.inherited===inherited){style=existingStyle;break;}}}
if(style)
this._stylesMap.add(mapKey,style);}
var inheritedPropertyCount=0;var properties=[];for(var i=0;payload.cssProperties&&i<payload.cssProperties.length;++i){var propertyPayload=payload.cssProperties[i];if(inherited&&WI.CSSProperty.isInheritedPropertyName(propertyPayload.name))
++inheritedPropertyCount;let property=this._parseStylePropertyPayload(propertyPayload,i,style);properties.push(property);}
let text=payload.cssText;var styleSheetTextRange=this._parseSourceRangePayload(payload.range);if(style){style.update(text,properties,styleSheetTextRange);return style;}
if(!matchesNode)
return null;var styleSheet=id?WI.cssManager.styleSheetForIdentifier(id.styleSheetId):null;if(styleSheet){if(type===WI.CSSStyleDeclaration.Type.Inline)
styleSheet.markAsInlineStyleAttributeStyleSheet();this._trackedStyleSheets.add(styleSheet);}
if(inherited&&!inheritedPropertyCount)
return null;style=new WI.CSSStyleDeclaration(this,styleSheet,id,type,node,inherited,text,properties,styleSheetTextRange);if(mapKey)
this._stylesMap.add(mapKey,style);return style;}
_parseRulePayload(payload,matchedSelectorIndices,node,inherited,pseudoId,ruleOccurrences)
{if(!payload)
return null;var id=payload.ruleId||payload.style.styleId;var mapKey=id?id.styleSheetId+":"+id.ordinal+":"+(inherited?"I":"N")+":"+(pseudoId?pseudoId+":":"")+node.id:null;var occurrence=0;if(mapKey){if(mapKey in ruleOccurrences)
occurrence=++ruleOccurrences[mapKey];else
ruleOccurrences[mapKey]=occurrence;mapKey+=":"+occurrence;}
let rule=this._rulesMap.get(mapKey);var style=this._parseStyleDeclarationPayload(payload.style,node,inherited,pseudoId,WI.CSSStyleDeclaration.Type.Rule,rule);if(!style)
return null;var styleSheet=id?WI.cssManager.styleSheetForIdentifier(id.styleSheetId):null;var selectorText=payload.selectorList.text;let selectors=DOMNodeStyles.parseSelectorListPayload(payload.selectorList);var type=WI.CSSManager.protocolStyleSheetOriginToEnum(payload.origin);var sourceCodeLocation=null;var sourceRange=payload.selectorList.range;if(sourceRange){sourceCodeLocation=DOMNodeStyles.createSourceCodeLocation(payload.sourceURL,{line:sourceRange.startLine,column:sourceRange.startColumn,documentNode:this._node.ownerDocument,});}else{sourceCodeLocation=DOMNodeStyles.createSourceCodeLocation(payload.sourceURL,{line:payload.sourceLine,documentNode:this._node.ownerDocument,});}
if(styleSheet){if(!sourceCodeLocation&&sourceRange)
sourceCodeLocation=styleSheet.createSourceCodeLocation(sourceRange.startLine,sourceRange.startColumn);sourceCodeLocation=styleSheet.offsetSourceCodeLocation(sourceCodeLocation);}
let groupings=(payload.groupings||payload.media||[]).map((grouping)=>{let groupingType=WI.CSSManager.protocolGroupingTypeToEnum(grouping.type||grouping.source);let groupingSourceCodeLocation=DOMNodeStyles.createSourceCodeLocation(grouping.sourceURL);if(styleSheet)
groupingSourceCodeLocation=styleSheet.offsetSourceCodeLocation(groupingSourceCodeLocation);return new WI.CSSGrouping(groupingType,grouping.text,groupingSourceCodeLocation);});if(rule){rule.update(sourceCodeLocation,selectorText,selectors,matchedSelectorIndices,style,groupings);return rule;}
if(styleSheet)
this._trackedStyleSheets.add(styleSheet);rule=new WI.CSSRule(this,styleSheet,id,type,sourceCodeLocation,selectorText,selectors,matchedSelectorIndices,style,groupings);if(mapKey)
this._rulesMap.set(mapKey,rule);return rule;}
_markAsNeedsRefresh()
{this._needsRefresh=true;this.dispatchEventToListeners(WI.DOMNodeStyles.Event.NeedsRefresh);}
_handleCSSStyleSheetContentDidChange(event)
{let styleSheet=event.target;if(!this._trackedStyleSheets.has(styleSheet))
return;if(styleSheet===this._ignoreNextContentDidChangeForStyleSheet){this._ignoreNextContentDidChangeForStyleSheet=null;return;}
this._markAsNeedsRefresh();}
_updateStyleCascade()
{var cascadeOrderedStyleDeclarations=this._collectStylesInCascadeOrder(this._matchedRules,this._inlineStyle,this._attributesStyle);for(var i=0;i<this._inheritedRules.length;++i){var inheritedStyleInfo=this._inheritedRules[i];var inheritedCascadeOrder=this._collectStylesInCascadeOrder(inheritedStyleInfo.matchedRules,inheritedStyleInfo.inlineStyle,null);cascadeOrderedStyleDeclarations.pushAll(inheritedCascadeOrder);}
this._orderedStyles=cascadeOrderedStyleDeclarations;this._propertyNameToEffectivePropertyMap={};this._associateRelatedProperties(cascadeOrderedStyleDeclarations,this._propertyNameToEffectivePropertyMap);this._markOverriddenProperties(cascadeOrderedStyleDeclarations,this._propertyNameToEffectivePropertyMap);this._collectCSSVariables(cascadeOrderedStyleDeclarations);for(let pseudoElementInfo of this._pseudoElements.values()){pseudoElementInfo.orderedStyles=this._collectStylesInCascadeOrder(pseudoElementInfo.matchedRules,null,null);this._associateRelatedProperties(pseudoElementInfo.orderedStyles);this._markOverriddenProperties(pseudoElementInfo.orderedStyles);}}
_collectStylesInCascadeOrder(matchedRules,inlineStyle,attributesStyle)
{var result=[];if(inlineStyle)
result.push(inlineStyle);var userAndUserAgentStyles=[];for(var i=0;i<matchedRules.length;++i){var rule=matchedRules[i];switch(rule.type){case WI.CSSStyleSheet.Type.Inspector:case WI.CSSStyleSheet.Type.Author:result.push(rule.style);break;case WI.CSSStyleSheet.Type.User:case WI.CSSStyleSheet.Type.UserAgent:userAndUserAgentStyles.push(rule.style);break;}}
if(attributesStyle)
result.push(attributesStyle);result.pushAll(userAndUserAgentStyles);return result;}
_markOverriddenProperties(styles,propertyNameToEffectiveProperty)
{propertyNameToEffectiveProperty=propertyNameToEffectiveProperty||{};function isOverriddenByRelatedShorthand(property){let shorthand=property.relatedShorthandProperty;if(!shorthand)
return false;if(property.important&&!shorthand.important)
return false;if(!property.important&&shorthand.important)
return true;if(property.ownerStyle===shorthand.ownerStyle)
return shorthand.index>property.index;let propertyStyleIndex=styles.indexOf(property.ownerStyle);let shorthandStyleIndex=styles.indexOf(shorthand.ownerStyle);return shorthandStyleIndex>propertyStyleIndex;}
for(var i=0;i<styles.length;++i){var style=styles[i];var properties=style.enabledProperties;for(var j=0;j<properties.length;++j){var property=properties[j];if(!property.attached||!property.valid){property.overridden=false;continue;}
if(style.inherited&&!property.inherited){property.overridden=false;continue;}
var canonicalName=property.canonicalName;if(canonicalName in propertyNameToEffectiveProperty){var effectiveProperty=propertyNameToEffectiveProperty[canonicalName];if(effectiveProperty.ownerStyle===property.ownerStyle){if(effectiveProperty.important&&!property.important){property.overridden=true;property.overridingProperty=effectiveProperty;continue;}}else if(effectiveProperty.important||!property.important||effectiveProperty.ownerStyle.node!==property.ownerStyle.node){property.overridden=true;property.overridingProperty=effectiveProperty;continue;}
if(!property.anonymous){effectiveProperty.overridden=true;effectiveProperty.overridingProperty=property;}}
if(isOverriddenByRelatedShorthand(property)){property.overridden=true;property.overridingProperty=property.relatedShorthandProperty;}else
property.overridden=false;propertyNameToEffectiveProperty[canonicalName]=property;}}}
_associateRelatedProperties(styles,propertyNameToEffectiveProperty)
{for(var i=0;i<styles.length;++i){var properties=styles[i].enabledProperties;var knownShorthands={};for(var j=0;j<properties.length;++j){var property=properties[j];if(!property.valid)
continue;if(!WI.CSSKeywordCompletions.LonghandNamesForShorthandProperty.has(property.name))
continue;if(knownShorthands[property.canonicalName]&&!knownShorthands[property.canonicalName].overridden){continue;}
knownShorthands[property.canonicalName]=property;}
for(var j=0;j<properties.length;++j){var property=properties[j];if(!property.valid)
continue;var shorthandProperty=null;if(!isEmptyObject(knownShorthands)){var possibleShorthands=WI.CSSKeywordCompletions.ShorthandNamesForLongHandProperty.get(property.canonicalName)||[];for(var k=0;k<possibleShorthands.length;++k){if(possibleShorthands[k]in knownShorthands){shorthandProperty=knownShorthands[possibleShorthands[k]];break;}}}
if(!shorthandProperty||shorthandProperty.overridden!==property.overridden){property.relatedShorthandProperty=null;property.clearRelatedLonghandProperties();continue;}
shorthandProperty.addRelatedLonghandProperty(property);property.relatedShorthandProperty=shorthandProperty;if(propertyNameToEffectiveProperty&&propertyNameToEffectiveProperty[shorthandProperty.canonicalName]===shorthandProperty)
propertyNameToEffectiveProperty[property.canonicalName]=property;}}}
_collectCSSVariables(styles)
{this._allCSSVariables=new Set;this._usedCSSVariables=new Set;for(let style of styles){for(let property of style.enabledProperties){if(property.isVariable)
this._allCSSVariables.add(property.name);let variables=WI.CSSProperty.findVariableNames(property.value);if(!style.inherited){this._usedCSSVariables.addAll(variables);continue;}
if(WI.CSSKeywordCompletions.InheritedProperties.has(property.name)){this._usedCSSVariables.addAll(variables);continue;}
if(property.isVariable&&this._usedCSSVariables.has(property.name))
this._usedCSSVariables.addAll(variables);}}}
_isPropertyFoundInMatchingRules(propertyName)
{return this._orderedStyles.some((style)=>{return style.enabledProperties.some((property)=>property.name===propertyName);});}};WI.DOMNodeStyles.Event={NeedsRefresh:"dom-node-styles-needs-refresh",Refreshed:"dom-node-styles-refreshed"};WI.DOMNodeStyles.VariablesGroupType={Ungrouped:"ungrouped",Colors:"colors",Dimensions:"dimensions",Numbers:"numbers",Other:"other",};WI.DOMSearchMatchObject=class DOMSearchMatchObject
{constructor(resource,domNode,title,searchTerm,textRange)
{this._resource=resource;this._domNode=domNode;this._title=title;this._searchTerm=searchTerm;this._sourceCodeTextRange=resource.createSourceCodeTextRange(textRange);}
static titleForDOMNode(domNode)
{switch(domNode.nodeType()){case Node.ELEMENT_NODE:var title="<"+domNode.nodeNameInCorrectCase();for(var attribute of domNode.attributes()){title+=" "+attribute.name;if(attribute.value.length)
title+="=\""+attribute.value+"\"";}
return title+">";case Node.TEXT_NODE:return"\""+domNode.nodeValue()+"\"";case Node.COMMENT_NODE:return"<!--"+domNode.nodeValue()+"-->";case Node.DOCUMENT_TYPE_NODE:var title="<!DOCTYPE "+domNode.nodeName();if(domNode.publicId){title+=" PUBLIC \""+domNode.publicId+"\"";if(domNode.systemId)
title+=" \""+domNode.systemId+"\"";}else if(domNode.systemId)
title+=" SYSTEM \""+domNode.systemId+"\"";return title+">";case Node.CDATA_SECTION_NODE:return"<![CDATA["+domNode+"]]>";case Node.PROCESSING_INSTRUCTION_NODE:var data=domNode.nodeValue();var dataString=data.length?" "+data:"";var title="<?"+domNode.nodeNameInCorrectCase()+dataString+"?>";return title;default:console.error("Unknown DOM node type: ",domNode.nodeType());return domNode.nodeNameInCorrectCase();}}
get resource()
{return this._resource;}
get domNode()
{return this._domNode;}
get title()
{return this._title;}
get className()
{if(!this._className)
this._className=this._generateClassName();return this._className;}
get searchTerm()
{return this._searchTerm;}
get sourceCodeTextRange()
{return this._sourceCodeTextRange;}
saveIdentityToCookie(cookie)
{cookie[WI.DOMSearchMatchObject.URLCookieKey]=this._resource.url.hash;cookie[WI.DOMSearchMatchObject.TitleKey]=this._title;var textRange=this._sourceCodeTextRange.textRange;cookie[WI.DOMSearchMatchObject.TextRangeKey]=[textRange.startLine,textRange.startColumn,textRange.endLine,textRange.endColumn].join();}
_generateClassName()
{switch(this._domNode.nodeType()){case Node.ELEMENT_NODE:return WI.DOMSearchMatchObject.DOMMatchElementIconStyleClassName;case Node.TEXT_NODE:return WI.DOMSearchMatchObject.DOMMatchTextNodeIconStyleClassName;case Node.COMMENT_NODE:return WI.DOMSearchMatchObject.DOMMatchCommentIconStyleClassName;case Node.DOCUMENT_TYPE_NODE:return WI.DOMSearchMatchObject.DOMMatchDocumentTypeIconStyleClassName;case Node.CDATA_SECTION_NODE:return WI.DOMSearchMatchObject.DOMMatchCharacterDataIconStyleClassName;case Node.PROCESSING_INSTRUCTION_NODE:return WI.DOMSearchMatchObject.DOMMatchDocumentTypeIconStyleClassName;default:console.error("Unknown DOM node type: ",this._domNode.nodeType());return WI.DOMSearchMatchObject.DOMMatchNodeIconStyleClassName;}}};WI.DOMSearchMatchObject.DOMMatchElementIconStyleClassName="dom-match-element-icon";WI.DOMSearchMatchObject.DOMMatchTextNodeIconStyleClassName="dom-match-text-node-icon";WI.DOMSearchMatchObject.DOMMatchCommentIconStyleClassName="dom-match-comment-icon";WI.DOMSearchMatchObject.DOMMatchDocumentTypeIconStyleClassName="dom-match-document-type-icon";WI.DOMSearchMatchObject.DOMMatchCharacterDataIconStyleClassName="dom-match-character-data-icon";WI.DOMSearchMatchObject.DOMMatchNodeIconStyleClassName="dom-match-node-icon";WI.DOMSearchMatchObject.TypeIdentifier="dom-search-match-object";WI.DOMSearchMatchObject.URLCookieKey="resource-url";WI.DOMSearchMatchObject.TitleKey="title";WI.DOMSearchMatchObject.TextRangeKey="text-range";WI.DOMStorageObject=class DOMStorageObject extends WI.Object
{constructor(id,host,isLocalStorage)
{super();this._id=id;this._host=host;this._isLocalStorage=isLocalStorage;this._entries=new Map;}
get id(){return this._id;}
get host(){return this._host;}
get entries(){return this._entries;}
saveIdentityToCookie(cookie)
{cookie[WI.DOMStorageObject.HostCookieKey]=this.host;cookie[WI.DOMStorageObject.LocalStorageCookieKey]=this.isLocalStorage();}
isLocalStorage()
{return this._isLocalStorage;}
getEntries(callback)
{function innerCallback(error,entries)
{if(error)
return;for(let[key,value]of entries){if(!key||!value)
continue;this._entries.set(key,value);}
callback(error,entries);}
let target=WI.assumingMainTarget();target.DOMStorageAgent.getDOMStorageItems(this._id,innerCallback.bind(this));}
removeItem(key)
{let target=WI.assumingMainTarget();return target.DOMStorageAgent.removeDOMStorageItem(this._id,key);}
setItem(key,value)
{let target=WI.assumingMainTarget();return target.DOMStorageAgent.setDOMStorageItem(this._id,key,value);}
clear()
{let target=WI.assumingMainTarget();if(!target.hasCommand("DOMStorage.clearDOMStorageItems")){let promises=[];for(let key of this._entries.keys())
promises.push(this.removeItem(key));return Promise.all(promises);}
return target.DOMStorageAgent.clearDOMStorageItems(this._id);}
itemsCleared()
{this._entries.clear();this.dispatchEventToListeners(WI.DOMStorageObject.Event.ItemsCleared);}
itemRemoved(key)
{let removed=this._entries.delete(key);this.dispatchEventToListeners(WI.DOMStorageObject.Event.ItemRemoved,{key});}
itemAdded(key,value)
{this._entries.set(key,value);this.dispatchEventToListeners(WI.DOMStorageObject.Event.ItemAdded,{key,value});}
itemUpdated(key,oldValue,newValue)
{this._entries.set(key,newValue);this.dispatchEventToListeners(WI.DOMStorageObject.Event.ItemUpdated,{key,oldValue,newValue});}};WI.DOMStorageObject.TypeIdentifier="dom-storage";WI.DOMStorageObject.HostCookieKey="dom-storage-object-host";WI.DOMStorageObject.LocalStorageCookieKey="dom-storage-object-local-storage";WI.DOMStorageObject.Event={ItemsCleared:"dom-storage-object-items-cleared",ItemAdded:"dom-storage-object-item-added",ItemRemoved:"dom-storage-object-item-removed",ItemUpdated:"dom-storage-object-updated",};WI.DOMStyleable=class DOMStyleable
{constructor(node,{pseudoId}={})
{this._node=node;this._pseudoId=pseudoId||null;}
static fromPayload({nodeId,pseudoId})
{return new WI.DOMStyleable(WI.domManager.nodeForId(nodeId),{pseudoId});}
get node(){return this._node;}
get pseudoId(){return this._pseudoId;}
get displayName()
{if(this._pseudoId)
return WI.CSSManager.displayNameForPseudoId(this._pseudoId);return this._node.displayName;}};WI.DOMTree=class DOMTree extends WI.Object
{constructor(frame)
{super();this._frame=frame;this._rootDOMNode=null;this._requestIdentifier=0;this._frame.addEventListener(WI.Frame.Event.PageExecutionContextChanged,this._framePageExecutionContextChanged,this);WI.domManager.addEventListener(WI.DOMManager.Event.DocumentUpdated,this._documentUpdated,this);if(!this._frame.isMainFrame()){WI.domManager.addEventListener(WI.DOMManager.Event.NodeRemoved,this._nodeRemoved,this);this._frame.addEventListener(WI.Frame.Event.MainResourceDidChange,this._frameMainResourceDidChange,this);}}
get frame(){return this._frame;}
disconnect()
{this._frame.removeEventListener(WI.Frame.Event.PageExecutionContextChanged,this._framePageExecutionContextChanged,this);WI.domManager.removeEventListener(WI.DOMManager.Event.DocumentUpdated,this._documentUpdated,this);if(!this._frame.isMainFrame()){WI.domManager.removeEventListener(WI.DOMManager.Event.NodeRemoved,this._nodeRemoved,this);this._frame.removeEventListener(WI.Frame.Event.MainResourceDidChange,this._frameMainResourceDidChange,this);}}
invalidate()
{this._rootDOMNode=null;this._pendingRootDOMNodeRequests=null;if(this._invalidateTimeoutIdentifier)
return;function performInvalidate()
{this._invalidateTimeoutIdentifier=undefined;this.dispatchEventToListeners(WI.DOMTree.Event.RootDOMNodeInvalidated);}
this._invalidateTimeoutIdentifier=setTimeout(performInvalidate.bind(this),0);}
requestRootDOMNode(callback)
{if(typeof callback!=="function")
return;if(this._rootDOMNode){callback(this._rootDOMNode);return;}
if(!this._frame.isMainFrame()&&!this._frame.pageExecutionContext){this._rootDOMNodeRequestWaitingForExecutionContext=true;if(!this._pendingRootDOMNodeRequests)
this._pendingRootDOMNodeRequests=[];this._pendingRootDOMNodeRequests.push(callback);return;}
if(this._pendingRootDOMNodeRequests){this._pendingRootDOMNodeRequests.push(callback);return;}
this._pendingRootDOMNodeRequests=[callback];this._requestRootDOMNode();}
_requestRootDOMNode()
{var requestIdentifier=++this._requestIdentifier;function rootObjectAvailable(error,result)
{if(!this._pendingRootDOMNodeRequests||requestIdentifier!==this._requestIdentifier)
return;if(error){console.error(JSON.stringify(error));this._rootDOMNode=null;dispatchCallbacks.call(this);return;}
var remoteObject=WI.RemoteObject.fromPayload(result);remoteObject.pushNodeToFrontend(rootDOMNodeAvailable.bind(this,remoteObject));}
function rootDOMNodeAvailable(remoteObject,nodeId)
{remoteObject.release();if(!this._pendingRootDOMNodeRequests||requestIdentifier!==this._requestIdentifier)
return;if(!nodeId){this._rootDOMNode=null;dispatchCallbacks.call(this);return;}
this._rootDOMNode=WI.domManager.nodeForId(nodeId);if(!this._rootDOMNode){dispatchCallbacks.call(this);return;}
this._rootDOMNode.getChildNodes(dispatchCallbacks.bind(this));}
function mainDocumentAvailable(document)
{this._rootDOMNode=document;dispatchCallbacks.call(this);}
function dispatchCallbacks()
{if(!this._pendingRootDOMNodeRequests||requestIdentifier!==this._requestIdentifier)
return;for(var i=0;i<this._pendingRootDOMNodeRequests.length;++i)
this._pendingRootDOMNodeRequests[i](this._rootDOMNode);this._pendingRootDOMNodeRequests=null;}
if(this._frame.isMainFrame())
WI.domManager.requestDocument(mainDocumentAvailable.bind(this));else{let target=WI.assumingMainTarget();var contextId=this._frame.pageExecutionContext.id;target.RuntimeAgent.evaluate.invoke({expression:appendWebInspectorSourceURL("document"),objectGroup:"",includeCommandLineAPI:false,doNotPauseOnExceptionsAndMuteConsole:true,contextId,returnByValue:false,generatePreview:false},rootObjectAvailable.bind(this));}}
_nodeRemoved(event)
{if(event.data.node!==this._rootDOMNode)
return;this.invalidate();}
_documentUpdated(event)
{this.invalidate();}
_frameMainResourceDidChange(event)
{this.invalidate();}
_framePageExecutionContextChanged(event)
{if(this._rootDOMNodeRequestWaitingForExecutionContext){this._rootDOMNodeRequestWaitingForExecutionContext=false;this._requestRootDOMNode();}}};WI.DOMTree.Event={RootDOMNodeInvalidated:"dom-tree-root-dom-node-invalidated",};WI.DatabaseObject=class DatabaseObject
{constructor(id,host,name,version)
{this._id=id;this._host=host?host:WI.UIString("Local File");this._name=name;this._version=version;}
get id(){return this._id;}
get host(){return this._host;}
get name(){return this._name;}
get version(){return this._version;}
saveIdentityToCookie(cookie)
{cookie[WI.DatabaseObject.HostCookieKey]=this.host;cookie[WI.DatabaseObject.NameCookieKey]=this.name;}
getTableNames(callback)
{function sortingCallback(error,names)
{if(!error)
callback(names.sort());}
let target=WI.assumingMainTarget();target.DatabaseAgent.getDatabaseTableNames(this._id,sortingCallback);}
executeSQL(query,successCallback,errorCallback)
{function queryCallback(error,columnNames,values,sqlError)
{if(error){errorCallback(WI.UIString("An unexpected error occurred."));return;}
if(sqlError){switch(sqlError.code){case SQLError.VERSION_ERR:errorCallback(WI.UIString("Database no longer has expected version."));break;case SQLError.TOO_LARGE_ERR:errorCallback(WI.UIString("Data returned from the database is too large."));break;default:errorCallback(WI.UIString("An unexpected error occurred."));break;}
return;}
successCallback(columnNames,values);}
let target=WI.assumingMainTarget();target.DatabaseAgent.executeSQL(this._id,query,queryCallback);}};WI.DatabaseObject.TypeIdentifier="database";WI.DatabaseObject.HostCookieKey="database-object-host";WI.DatabaseObject.NameCookieKey="database-object-name";WI.DatabaseTableObject=class DatabaseTableObject
{constructor(name,database)
{this._name=name;this._database=database;}
get name(){return this._name;}
get database(){return this._database;}
saveIdentityToCookie(cookie)
{cookie[WI.DatabaseTableObject.NameCookieKey]=this.name;}};WI.DatabaseTableObject.TypeIdentifier="database-table";WI.DatabaseTableObject.NameCookieKey="database-table-object-name";WI.DebuggerData=class DebuggerData
{constructor(target)
{this._target=target;this._paused=false;this._pausing=false;this._pauseReason=null;this._pauseData=null;this._callFrames=[];this._asyncStackTrace=null;this._scriptIdMap=new Map;this._scriptContentIdentifierMap=new Map;this._makePausingAfterNextResume=false;}
get target(){return this._target;}
get paused(){return this._paused;}
get pausing(){return this._pausing;}
get pauseReason(){return this._pauseReason;}
get pauseData(){return this._pauseData;}
get callFrames(){return this._callFrames;}
get asyncStackTrace(){return this._asyncStackTrace;}
get scripts()
{return Array.from(this._scriptIdMap.values());}
scriptForIdentifier(id)
{return this._scriptIdMap.get(id);}
scriptsForURL(url)
{return this._scriptContentIdentifierMap.get(url)||[];}
reset()
{this._scriptIdMap.clear();}
addScript(script)
{this._scriptIdMap.set(script.id,script);if(script.contentIdentifier){let scripts=this._scriptContentIdentifierMap.get(script.contentIdentifier);if(!scripts){scripts=[];this._scriptContentIdentifierMap.set(script.contentIdentifier,scripts);}
scripts.push(script);}}
pauseIfNeeded()
{if(this._paused||this._pausing)
return Promise.resolve();this._pausing=true;return this._target.DebuggerAgent.pause();}
resumeIfNeeded()
{if(!this._paused&&!this._pausing)
return Promise.resolve();this._pausing=false;return this._target.DebuggerAgent.resume();}
continueUntilNextRunLoop()
{if(!this._paused||this._pausing)
return Promise.resolve();this._makePausingAfterNextResume=true;return this._target.DebuggerAgent.continueUntilNextRunLoop();}
updateForPause(callFrames,pauseReason,pauseData,asyncStackTrace)
{this._paused=true;this._pausing=false;this._pauseReason=pauseReason;this._pauseData=pauseData;this._callFrames=callFrames;this._asyncStackTrace=asyncStackTrace;this._makePausingAfterNextResume=false;}
updateForResume()
{this._paused=false;this._pausing=false;this._pauseReason=null;this._pauseData=null;this._callFrames=[];this._asyncStackTrace=null;if(this._makePausingAfterNextResume){this._makePausingAfterNextResume=false;this._pausing=true;}}};WI.EventBreakpoint=class EventBreakpoint extends WI.Breakpoint
{constructor(type,{eventName,eventListener,disabled,actions,condition,ignoreCount,autoContinue}={})
{if(type==="timer"){switch(eventName){case"setInterval":type=WI.EventBreakpoint.Type.Interval;break;case"setTimeout":type=WI.EventBreakpoint.Type.Timeout;break;}}
super({disabled,condition,actions,ignoreCount,autoContinue});this._type=type;this._eventName=eventName||null;this._eventListener=eventListener||null;}
static get supportsEditing()
{return InspectorBackend.hasCommand("DOMDebugger.setEventBreakpoint","options");}
static fromJSON(json)
{return new WI.EventBreakpoint(json.type,{eventName:json.eventName,disabled:json.disabled,condition:json.condition,actions:json.actions?.map((actionJSON)=>WI.BreakpointAction.fromJSON(actionJSON))||[],ignoreCount:json.ignoreCount,autoContinue:json.autoContinue,});}
get type(){return this._type;}
get eventName(){return this._eventName;}
get eventListener(){return this._eventListener;}
get displayName()
{switch(this){case WI.domDebuggerManager.allAnimationFramesBreakpoint:return WI.repeatedUIString.allAnimationFrames();case WI.domDebuggerManager.allIntervalsBreakpoint:return WI.repeatedUIString.allIntervals();case WI.domDebuggerManager.allListenersBreakpoint:return WI.repeatedUIString.allEvents();case WI.domDebuggerManager.allTimeoutsBreakpoint:return WI.repeatedUIString.allTimeouts();}
return this._eventName;}
get special()
{switch(this){case WI.domDebuggerManager.allAnimationFramesBreakpoint:case WI.domDebuggerManager.allIntervalsBreakpoint:case WI.domDebuggerManager.allListenersBreakpoint:case WI.domDebuggerManager.allTimeoutsBreakpoint:return true;}
return super.special;}
get editable()
{if(this._eventListener){return InspectorBackend.hasCommand("DOM.setBreakpointForEventListener","options");}
return WI.EventBreakpoint.supportsEditing||super.editable;}
remove()
{super.remove();if(this._eventListener)
WI.domManager.removeBreakpointForEventListener(this._eventListener);else
WI.domDebuggerManager.removeEventBreakpoint(this);}
saveIdentityToCookie(cookie)
{cookie["event-breakpoint-type"]=this._type;if(this._eventName)
cookie["event-breakpoint-event-name"]=this._eventName;if(this._eventListener)
cookie["event-breakpoint-event-listener"]=this._eventListener.eventListenerId;}
toJSON(key)
{let json=super.toJSON(key);json.type=this._type;if(this._eventName)
json.eventName=this._eventName;if(key===WI.ObjectStore.toJSONSymbol)
json[WI.objectStores.eventBreakpoints.keyPath]=this._type+(this._eventName?":"+this._eventName:"");return json;}};WI.EventBreakpoint.Type={AnimationFrame:"animation-frame",Interval:"interval",Listener:"listener",Timeout:"timeout",};WI.EventBreakpoint.ReferencePage=WI.ReferencePage.EventBreakpoints;WI.ExecutionContext=class ExecutionContext
{constructor(target,id,type,name,frame)
{this._target=target;this._id=id;this._type=type||WI.ExecutionContext.Type.Internal;this._name=name||"";this._frame=frame||null;}
static typeFromPayload(payload)
{if(!("type"in payload))
return payload.isPageContext?WI.ExecutionContext.Type.Normal:WI.ExecutionContext.Type.Internal;switch(payload.type){case InspectorBackend.Enum.Runtime.ExecutionContextType.Normal:return WI.ExecutionContext.Type.Normal;case InspectorBackend.Enum.Runtime.ExecutionContextType.User:return WI.ExecutionContext.Type.User;case InspectorBackend.Enum.Runtime.ExecutionContextType.Internal:return WI.ExecutionContext.Type.Internal;}
return WI.ExecutionContext.Type.Internal;}
get target(){return this._target;}
get id(){return this._id;}
get type(){return this._type;}
get name(){return this._name;}
get frame(){return this._frame;}};WI.ExecutionContext.Type={Normal:"normal",User:"user",Internal:"internal",};WI.ExecutionContextList=class ExecutionContextList
{constructor()
{this._contexts=[];this._pageExecutionContext=null;}
get pageExecutionContext()
{return this._pageExecutionContext;}
get contexts()
{return this._contexts;}
add(context)
{if(context.type===WI.ExecutionContext.Type.Normal&&this._pageExecutionContext){return;}
this._contexts.push(context);if(context.type===WI.ExecutionContext.Type.Normal&&context.target.type===WI.TargetType.Page){this._pageExecutionContext=context;}}
clear()
{this._contexts=[];this._pageExecutionContext=null;}};WI.FPSInstrument=class FPSInstrument extends WI.Instrument
{get timelineRecordType()
{return WI.TimelineRecord.Type.RenderingFrame;}};WI.Font=class Font
{constructor(name,variationAxes)
{this._name=name;this._variationAxes=variationAxes;}
static fromPayload(payload)
{let variationAxes=payload.variationAxes.map((axisPayload)=>WI.FontVariationAxis.fromPayload(axisPayload));return new WI.Font(payload.displayName,variationAxes);}
get name(){return this._name;}
get variationAxes(){return this._variationAxes;}
variationAxis(tag)
{return this._variationAxes.find((axis)=>axis.tag===tag);}
calculateFontProperties(domNodeStyle)
{let featuresMap=this._calculateFontFeatureAxes(domNodeStyle);let variationsMap=this._calculateFontVariationAxes(domNodeStyle);let propertiesMap=this._calculateProperties({domNodeStyle,featuresMap,variationsMap});return{propertiesMap,featuresMap,variationsMap};}
_calculateProperties(style)
{let resultProperties=new Map;this._populateProperty("font-size",style,resultProperties,{keywordComputedReplacements:["larger","smaller","xx-small","x-small","small","medium","large","x-large","xx-large","xxx-large"],});this._populateProperty("font-style",style,resultProperties,{variations:["ital","slnt"],keywordReplacements:new Map([["oblique","oblique 14deg"],]),});this._populateProperty("font-weight",style,resultProperties,{variations:["wght"],keywordComputedReplacements:["bolder","lighter"],keywordReplacements:new Map([["normal","400"],["bold","700"],]),});this._populateProperty("font-stretch",style,resultProperties,{variations:["wdth"],keywordReplacements:new Map([["ultra-condensed","50%"],["extra-condensed","62.5%"],["condensed","75%"],["semi-condensed","87.5%"],["normal","100%"],["semi-expanded","112.5%"],["expanded","125%"],["extra-expanded","150%"],["ultra-expanded","200%"],]),});this._populateProperty("font-variant-ligatures",style,resultProperties,{features:["liga","clig","dlig","hlig","calt"]});this._populateProperty("font-variant-position",style,resultProperties,{features:["subs","sups"]});this._populateProperty("font-variant-caps",style,resultProperties,{features:["smcp","c2sc","pcap","c2pc","unic","titl"]});this._populateProperty("font-variant-numeric",style,resultProperties,{features:["lnum","onum","pnum","tnum","frac","afrc","ordn","zero"]});this._populateProperty("font-variant-alternates",style,resultProperties,{features:["hist"]});this._populateProperty("font-variant-east-asian",style,resultProperties,{features:["jp78","jp83","jp90","jp04","smpl","trad","fwid","pwid","ruby"]});return resultProperties;}
_calculateFontFeatureAxes(domNodeStyle)
{return this._parseFontFeatureOrVariationSettings(domNodeStyle,"font-feature-settings");}
_calculateFontVariationAxes(domNodeStyle)
{let cssVariationSettings=this._parseFontFeatureOrVariationSettings(domNodeStyle,"font-variation-settings");let resultAxes=new Map;for(let axis of this._variationAxes){resultAxes.set(axis.tag,{name:axis.name,minimumValue:axis.minimumValue,maximumValue:axis.maximumValue,defaultValue:axis.defaultValue,value:cssVariationSettings.get(axis.tag),});}
return resultAxes;}
_parseFontFeatureOrVariationSettings(domNodeStyle,property)
{let cssSettings=new Map;let cssSettingsRawValue=this._computedPropertyValueForName(domNodeStyle,property);if(cssSettingsRawValue!=="normal"){for(let axis of cssSettingsRawValue.split(",")){let[tag,value]=axis.match(WI.Font.SettingPattern);tag=tag.replaceAll(/["']/g,"");if(!value||value==="on")
value=1;else if(value==="off")
value=0;cssSettings.set(tag,parseFloat(value));}}
return cssSettings;}
_populateProperty(name,style,resultProperties,{variations,features,keywordComputedReplacements,keywordReplacements})
{resultProperties.set(name,this._computeProperty(name,style,{variations,features,keywordComputedReplacements,keywordReplacements}));}
_computeProperty(name,style,{variations,features,keywordComputedReplacements,keywordReplacements})
{variations??=[];features??=[];keywordComputedReplacements??=[];keywordReplacements??=new Map;let resultProperties={};let value=this._effectivePropertyValueForName(style.domNodeStyle,name);if(!value||value==="inherit"||keywordComputedReplacements.includes(value))
value=this._computedPropertyValueForName(style.domNodeStyle,name);if(keywordReplacements.has(value))
value=keywordReplacements.get(value);resultProperties.value=value;for(let fontVariationSetting of variations){let variationSettingValue=style.variationsMap.get(fontVariationSetting);if(variationSettingValue){resultProperties.variations??=new Map;resultProperties.variations.set(fontVariationSetting,variationSettingValue);style.variationsMap.delete(fontVariationSetting);}}
for(let fontFeatureSetting of features){let featureSettingValue=style.featuresMap.get(fontFeatureSetting);if(featureSettingValue||featureSettingValue===0){resultProperties.features??=new Map;resultProperties.features.set(fontFeatureSetting,featureSettingValue);style.featuresMap.delete(fontFeatureSetting);}}
return resultProperties;}
_effectivePropertyValueForName(domNodeStyle,name)
{return domNodeStyle.effectivePropertyForName(name)?.value||"";}
_computedPropertyValueForName(domNodeStyle,name)
{return domNodeStyle.computedStyle?.propertyForName(name)?.value||"";}};WI.Font.SettingPattern=/[^\s"']+|["']([^"']*)["']/g;WI.FontVariationAxis=class FontVariationAxis
{constructor(name,tag,minimumValue,maximumValue,defaultValue)
{this._name=name;this._tag=tag;this._minimumValue=minimumValue;this._maximumValue=maximumValue;this._defaultValue=defaultValue;}
static fromPayload(payload)
{return new WI.FontVariationAxis(payload.name,payload.tag,payload.minimumValue,payload.maximumValue,payload.defaultValue);}
get name(){return this._name;}
get tag(){return this._tag;}
get minimumValue(){return this._minimumValue;}
get maximumValue(){return this._maximumValue;}
get defaultValue(){return this._defaultValue;}};WI.Frame=class Frame extends WI.Object
{constructor(id,name,securityOrigin,loaderIdentifier,mainResource)
{super();this._id=id;this._name=null;this._securityOrigin=null;this._resourceCollection=new WI.ResourceCollection;this._provisionalResourceCollection=new WI.ResourceCollection;this._extraScriptCollection=new WI.ScriptCollection;this._childFrameCollection=new WI.FrameCollection;this._childFrameIdentifierMap=new Map;this._parentFrame=null;this._isMainFrame=false;this._domContentReadyEventTimestamp=NaN;this._loadEventTimestamp=NaN;this._executionContextList=new WI.ExecutionContextList;this.initialize(name,securityOrigin,loaderIdentifier,mainResource);}
get resourceCollection(){return this._resourceCollection;}
get extraScriptCollection(){return this._extraScriptCollection;}
get childFrameCollection(){return this._childFrameCollection;}
initialize(name,securityOrigin,loaderIdentifier,mainResource)
{var oldName=this._name;var oldSecurityOrigin=this._securityOrigin;var oldMainResource=this._mainResource;this._name=name||null;this._securityOrigin=securityOrigin||null;this._loaderIdentifier=loaderIdentifier||null;this._mainResource=mainResource;this._mainResource._parentFrame=this;if(oldMainResource&&this._mainResource!==oldMainResource)
this._disassociateWithResource(oldMainResource);this.removeAllResources();this.removeAllChildFrames();this.clearExecutionContexts();this.clearProvisionalLoad();if(this._mainResource!==oldMainResource)
this._dispatchMainResourceDidChangeEvent(oldMainResource);if(this._securityOrigin!==oldSecurityOrigin)
this.dispatchEventToListeners(WI.Frame.Event.SecurityOriginDidChange,{oldSecurityOrigin});if(this._name!==oldName)
this.dispatchEventToListeners(WI.Frame.Event.NameDidChange,{oldName});}
startProvisionalLoad(provisionalMainResource)
{this._provisionalMainResource=provisionalMainResource;this._provisionalMainResource._parentFrame=this;this._provisionalLoaderIdentifier=provisionalMainResource.loaderIdentifier;this._provisionalResourceCollection.clear();this.dispatchEventToListeners(WI.Frame.Event.ProvisionalLoadStarted);}
commitProvisionalLoad(securityOrigin)
{if(!this._provisionalLoaderIdentifier)
return;var oldSecurityOrigin=this._securityOrigin;var oldMainResource=this._mainResource;this._securityOrigin=securityOrigin||null;this._loaderIdentifier=this._provisionalLoaderIdentifier;this._mainResource=this._provisionalMainResource;this._domContentReadyEventTimestamp=NaN;this._loadEventTimestamp=NaN;if(oldMainResource&&this._mainResource!==oldMainResource)
this._disassociateWithResource(oldMainResource);this.removeAllResources();this._resourceCollection=this._provisionalResourceCollection;this._provisionalResourceCollection=new WI.ResourceCollection;this._extraScriptCollection.clear();this.clearExecutionContexts(true);this.clearProvisionalLoad(true);this.removeAllChildFrames();this.dispatchEventToListeners(WI.Frame.Event.ProvisionalLoadCommitted);if(this._mainResource!==oldMainResource)
this._dispatchMainResourceDidChangeEvent(oldMainResource);if(this._securityOrigin!==oldSecurityOrigin)
this.dispatchEventToListeners(WI.Frame.Event.SecurityOriginDidChange,{oldSecurityOrigin});}
clearProvisionalLoad(skipProvisionalLoadClearedEvent)
{if(!this._provisionalLoaderIdentifier)
return;this._provisionalLoaderIdentifier=null;this._provisionalMainResource=null;this._provisionalResourceCollection.clear();if(!skipProvisionalLoadClearedEvent)
this.dispatchEventToListeners(WI.Frame.Event.ProvisionalLoadCleared);}
get id()
{return this._id;}
get loaderIdentifier()
{return this._loaderIdentifier;}
get provisionalLoaderIdentifier()
{return this._provisionalLoaderIdentifier;}
get name()
{return this._name;}
get securityOrigin()
{return this._securityOrigin;}
get url()
{return this._mainResource.url;}
get urlComponents()
{return this._mainResource.urlComponents;}
get domTree()
{if(!this._domTree)
this._domTree=new WI.DOMTree(this);return this._domTree;}
get pageExecutionContext()
{return this._executionContextList.pageExecutionContext;}
get executionContextList()
{return this._executionContextList;}
clearExecutionContexts(committingProvisionalLoad)
{if(this._executionContextList.contexts.length){let contexts=this._executionContextList.contexts.slice();this._executionContextList.clear();this.dispatchEventToListeners(WI.Frame.Event.ExecutionContextsCleared,{committingProvisionalLoad:!!committingProvisionalLoad,contexts});}}
addExecutionContext(context)
{this._executionContextList.add(context);this.dispatchEventToListeners(WI.Frame.Event.ExecutionContextAdded,{context});if(this._executionContextList.pageExecutionContext===context)
this.dispatchEventToListeners(WI.Frame.Event.PageExecutionContextChanged);}
get mainResource()
{return this._mainResource;}
get provisionalMainResource()
{return this._provisionalMainResource;}
get parentFrame()
{return this._parentFrame;}
get domContentReadyEventTimestamp()
{return this._domContentReadyEventTimestamp;}
get loadEventTimestamp()
{return this._loadEventTimestamp;}
isMainFrame()
{return this._isMainFrame;}
markAsMainFrame()
{this._isMainFrame=true;}
unmarkAsMainFrame()
{this._isMainFrame=false;}
markDOMContentReadyEvent(timestamp)
{this._domContentReadyEventTimestamp=timestamp||NaN;}
markLoadEvent(timestamp)
{this._loadEventTimestamp=timestamp||NaN;}
isDetached()
{var frame=this;while(frame){if(frame.isMainFrame())
return false;frame=frame.parentFrame;}
return true;}
childFrameForIdentifier(frameId)
{return this._childFrameIdentifierMap.get(frameId)||null;}
addChildFrame(frame)
{if(!(frame instanceof WI.Frame))
return;if(frame._parentFrame===this)
return;if(frame._parentFrame)
frame._parentFrame.removeChildFrame(frame);this._childFrameCollection.add(frame);this._childFrameIdentifierMap.set(frame._id,frame);frame._parentFrame=this;this.dispatchEventToListeners(WI.Frame.Event.ChildFrameWasAdded,{childFrame:frame});}
removeChildFrame(frameOrFrameId)
{let childFrameId=frameOrFrameId;if(childFrameId instanceof WI.Frame)
childFrameId=frameOrFrameId._id;let childFrame=this.childFrameForIdentifier(childFrameId);if(!(childFrame instanceof WI.Frame))
return;this._childFrameCollection.remove(childFrame);this._childFrameIdentifierMap.delete(childFrame._id);childFrame._detachFromParentFrame();this.dispatchEventToListeners(WI.Frame.Event.ChildFrameWasRemoved,{childFrame});}
removeAllChildFrames()
{this._detachFromParentFrame();for(let childFrame of this._childFrameCollection)
childFrame.removeAllChildFrames();this._childFrameCollection.clear();this._childFrameIdentifierMap.clear();this.dispatchEventToListeners(WI.Frame.Event.AllChildFramesRemoved);}
resourcesForURL(url,recursivelySearchChildFrames)
{let resources=this._resourceCollection.resourcesForURL(url);for(let childFrame of this._childFrameCollection){if(childFrame.mainResource.url===url)
resources.add(childFrame.mainResource);}
if(recursivelySearchChildFrames){for(let childFrame of this._childFrameCollection)
resources.addAll(childFrame.resourcesForURL(url,recursivelySearchChildFrames));}
return resources;}
resourceCollectionForType(type)
{return this._resourceCollection.resourceCollectionForType(type);}
addResource(resource)
{if(!(resource instanceof WI.Resource))
return;if(resource.parentFrame===this)
return;if(resource.parentFrame)
resource.parentFrame.remove(resource);this._associateWithResource(resource);if(this._isProvisionalResource(resource)){this._provisionalResourceCollection.add(resource);this.dispatchEventToListeners(WI.Frame.Event.ProvisionalResourceWasAdded,{resource});}else{this._resourceCollection.add(resource);this.dispatchEventToListeners(WI.Frame.Event.ResourceWasAdded,{resource});}}
removeResource(resource)
{this._resourceCollection.remove(resource);this._disassociateWithResource(resource);this.dispatchEventToListeners(WI.Frame.Event.ResourceWasRemoved,{resource});}
removeAllResources()
{if(!this._resourceCollection.size)
return;for(let resource of this._resourceCollection)
this._disassociateWithResource(resource);this._resourceCollection.clear();this.dispatchEventToListeners(WI.Frame.Event.AllResourcesRemoved);}
addExtraScript(script)
{this._extraScriptCollection.add(script);this.dispatchEventToListeners(WI.Frame.Event.ExtraScriptAdded,{script});}
saveIdentityToCookie(cookie)
{cookie[WI.Frame.MainResourceURLCookieKey]=this.mainResource.url.hash;cookie[WI.Frame.IsMainFrameCookieKey]=this._isMainFrame;}
_detachFromParentFrame()
{if(this._domTree){this._domTree.disconnect();this._domTree=null;}
this._parentFrame=null;}
_isProvisionalResource(resource)
{return resource.loaderIdentifier&&this._provisionalLoaderIdentifier&&resource.loaderIdentifier===this._provisionalLoaderIdentifier;}
_associateWithResource(resource)
{if(resource._parentFrame)
return;resource._parentFrame=this;}
_disassociateWithResource(resource)
{if(resource.parentFrame!==this)
return;resource._parentFrame=null;}
_dispatchMainResourceDidChangeEvent(oldMainResource)
{this.dispatchEventToListeners(WI.Frame.Event.MainResourceDidChange,{oldMainResource});}};WI.Frame.Event={NameDidChange:"frame-name-did-change",SecurityOriginDidChange:"frame-security-origin-did-change",MainResourceDidChange:"frame-main-resource-did-change",ProvisionalLoadStarted:"frame-provisional-load-started",ProvisionalLoadCommitted:"frame-provisional-load-committed",ProvisionalLoadCleared:"frame-provisional-load-cleared",ProvisionalResourceWasAdded:"frame-provisional-resource-was-added",ResourceWasAdded:"frame-resource-was-added",ResourceWasRemoved:"frame-resource-was-removed",AllResourcesRemoved:"frame-all-resources-removed",ExtraScriptAdded:"frame-extra-script-added",ChildFrameWasAdded:"frame-child-frame-was-added",ChildFrameWasRemoved:"frame-child-frame-was-removed",AllChildFramesRemoved:"frame-all-child-frames-removed",PageExecutionContextChanged:"frame-page-execution-context-changed",ExecutionContextAdded:"frame-execution-context-added",ExecutionContextsCleared:"frame-execution-contexts-cleared"};WI.Frame.TypeIdentifier="Frame";WI.Frame.MainResourceURLCookieKey="frame-main-resource-url";WI.Frame.IsMainFrameCookieKey="frame-is-main-frame";WI.GarbageCollection=class GarbageCollection
{constructor(type,startTime,endTime)
{this._type=type;this._startTime=startTime;this._endTime=endTime;}
static fromPayload(payload)
{let type=WI.GarbageCollection.Type.Full;if(payload.type===InspectorBackend.Enum.Heap.GarbageCollectionType.Partial)
type=WI.GarbageCollection.Type.Partial;return new WI.GarbageCollection(type,payload.startTime,payload.endTime);}
static fromJSON(json)
{let{type,startTime,endTime}=json;return new WI.GarbageCollection(type,startTime,endTime);}
toJSON()
{return{__type:"GarbageCollection",type:this.type,startTime:this.startTime,endTime:this.endTime,};}
get type(){return this._type;}
get startTime(){return this._startTime;}
get endTime(){return this._endTime;}
get duration()
{return this._endTime-this._startTime;}};WI.GarbageCollection.Type={Partial:"partial",Full:"full",};WI.Point=class Point
{constructor(x,y)
{this.x=x||0;this.y=y||0;}
static fromEvent(event)
{return new WI.Point(event.pageX,event.pageY);}
static fromEventInElement(event,element)
{let rect=element.getBoundingClientRect();return new WI.Point(event.pageX-rect.x,event.pageY-rect.y);}
toString()
{return"WI.Point["+this.x+","+this.y+"]";}
copy()
{return new WI.Point(this.x,this.y);}
equals(anotherPoint)
{return this.x===anotherPoint.x&&this.y===anotherPoint.y;}
distance(anotherPoint)
{let dx=anotherPoint.x-this.x;let dy=anotherPoint.y-this.y;return Math.sqrt((dx*dx)+(dy*dy));}};WI.Size=class Size
{constructor(width,height)
{this.width=width||0;this.height=height||0;}
toString()
{return"WI.Size["+this.width+","+this.height+"]";}
copy()
{return new WI.Size(this.width,this.height);}
equals(anotherSize)
{return this.width===anotherSize.width&&this.height===anotherSize.height;}};WI.Size.ZERO_SIZE=new WI.Size(0,0);WI.Rect=class Rect
{constructor(x,y,width,height)
{this.origin=new WI.Point(x||0,y||0);this.size=new WI.Size(width||0,height||0);}
static rectFromClientRect(clientRect)
{return new WI.Rect(clientRect.left,clientRect.top,clientRect.width,clientRect.height);}
static unionOfRects(rects)
{var union=rects[0];for(var i=1;i<rects.length;++i)
union=union.unionWithRect(rects[i]);return union;}
toString()
{return"WI.Rect["+[this.origin.x,this.origin.y,this.size.width,this.size.height].join(", ")+"]";}
copy()
{return new WI.Rect(this.origin.x,this.origin.y,this.size.width,this.size.height);}
equals(anotherRect)
{return this.origin.equals(anotherRect.origin)&&this.size.equals(anotherRect.size);}
inset(insets)
{return new WI.Rect(this.origin.x+insets.left,this.origin.y+insets.top,this.size.width-insets.left-insets.right,this.size.height-insets.top-insets.bottom);}
pad(padding)
{return new WI.Rect(this.origin.x-padding,this.origin.y-padding,this.size.width+padding*2,this.size.height+padding*2);}
minX()
{return this.origin.x;}
minY()
{return this.origin.y;}
midX()
{return this.origin.x+(this.size.width/2);}
midY()
{return this.origin.y+(this.size.height/2);}
maxX()
{return this.origin.x+this.size.width;}
maxY()
{return this.origin.y+this.size.height;}
intersectionWithRect(rect)
{var x1=Math.max(this.minX(),rect.minX());var x2=Math.min(this.maxX(),rect.maxX());if(x1>x2)
return WI.Rect.ZERO_RECT;var intersection=new WI.Rect;intersection.origin.x=x1;intersection.size.width=x2-x1;var y1=Math.max(this.minY(),rect.minY());var y2=Math.min(this.maxY(),rect.maxY());if(y1>y2)
return WI.Rect.ZERO_RECT;intersection.origin.y=y1;intersection.size.height=y2-y1;return intersection;}
unionWithRect(rect)
{var x=Math.min(this.minX(),rect.minX());var y=Math.min(this.minY(),rect.minY());var width=Math.max(this.maxX(),rect.maxX())-x;var height=Math.max(this.maxY(),rect.maxY())-y;return new WI.Rect(x,y,width,height);}
round()
{return new WI.Rect(Math.floor(this.origin.x),Math.floor(this.origin.y),Math.ceil(this.size.width),Math.ceil(this.size.height));}};WI.Rect.ZERO_RECT=new WI.Rect(0,0,0,0);WI.EdgeInsets=class EdgeInsets
{constructor(top,right,bottom,left)
{if(arguments.length===1){this.top=top;this.right=top;this.bottom=top;this.left=top;}else if(arguments.length===4){this.top=top;this.right=right;this.bottom=bottom;this.left=left;}}
equals(anotherInset)
{return this.top===anotherInset.top&&this.right===anotherInset.right&&this.bottom===anotherInset.bottom&&this.left===anotherInset.left;}
copy()
{return new WI.EdgeInsets(this.top,this.right,this.bottom,this.left);}};WI.RectEdge={MIN_X:0,MIN_Y:1,MAX_X:2,MAX_Y:3};WI.Quad=class Quad
{constructor(quad)
{this.points=[new WI.Point(quad[0],quad[1]),new WI.Point(quad[2],quad[3]),new WI.Point(quad[4],quad[5]),new WI.Point(quad[6],quad[7])];this.width=Math.round(Math.sqrt(Math.pow(quad[0]-quad[2],2)+Math.pow(quad[1]-quad[3],2)));this.height=Math.round(Math.sqrt(Math.pow(quad[0]-quad[6],2)+Math.pow(quad[1]-quad[7],2)));}
static fromJSON(json)
{return new WI.Quad(json);}
toJSON()
{return this.toProtocol();}
toProtocol()
{return[this.points[0].x,this.points[0].y,this.points[1].x,this.points[1].y,this.points[2].x,this.points[2].y,this.points[3].x,this.points[3].y];}};WI.Polygon=class Polygon
{constructor(points)
{this.points=points;}
bounds()
{var minX=Number.MAX_VALUE;var minY=Number.MAX_VALUE;var maxX=-Number.MAX_VALUE;var maxY=-Number.MAX_VALUE;for(var point of this.points){minX=Math.min(minX,point.x);maxX=Math.max(maxX,point.x);minY=Math.min(minY,point.y);maxY=Math.max(maxY,point.y);}
return new WI.Rect(minX,minY,maxX-minX,maxY-minY);}};WI.CubicBezier=class CubicBezier
{constructor(x1,y1,x2,y2)
{this._inPoint=new WI.Point(x1,y1);this._outPoint=new WI.Point(x2,y2);this._curveInfo={x:{c:3.0*x1},y:{c:3.0*y1}};this._curveInfo.x.b=3.0*(x2-x1)-this._curveInfo.x.c;this._curveInfo.x.a=1.0-this._curveInfo.x.c-this._curveInfo.x.b;this._curveInfo.y.b=3.0*(y2-y1)-this._curveInfo.y.c;this._curveInfo.y.a=1.0-this._curveInfo.y.c-this._curveInfo.y.b;}
static fromCoordinates(coordinates)
{if(!coordinates||coordinates.length<4)
return null;coordinates=coordinates.map(Number);if(coordinates.includes(NaN))
return null;return new WI.CubicBezier(coordinates[0],coordinates[1],coordinates[2],coordinates[3]);}
static fromString(text)
{if(!text||!text.length)
return null;var trimmedText=text.toLowerCase().replace(/\s/g,"");if(!trimmedText.length)
return null;if(Object.keys(WI.CubicBezier.keywordValues).includes(trimmedText))
return WI.CubicBezier.fromCoordinates(WI.CubicBezier.keywordValues[trimmedText]);var matches=trimmedText.match(/^cubic-bezier\(([-\d.]+),([-\d.]+),([-\d.]+),([-\d.]+)\)$/);if(!matches)
return null;matches.splice(0,1);return WI.CubicBezier.fromCoordinates(matches);}
get inPoint()
{return this._inPoint;}
get outPoint()
{return this._outPoint;}
copy()
{return new WI.CubicBezier(this._inPoint.x,this._inPoint.y,this._outPoint.x,this._outPoint.y);}
toString()
{var values=[this._inPoint.x,this._inPoint.y,this._outPoint.x,this._outPoint.y];for(var key in WI.CubicBezier.keywordValues){if(Array.shallowEqual(WI.CubicBezier.keywordValues[key],values))
return key;}
return"cubic-bezier("+values.join(", ")+")";}
solve(x,epsilon)
{return this._sampleCurveY(this._solveCurveX(x,epsilon));}
_sampleCurveX(t)
{return((this._curveInfo.x.a*t+this._curveInfo.x.b)*t+this._curveInfo.x.c)*t;}
_sampleCurveY(t)
{return((this._curveInfo.y.a*t+this._curveInfo.y.b)*t+this._curveInfo.y.c)*t;}
_sampleCurveDerivativeX(t)
{return(3.0*this._curveInfo.x.a*t+2.0*this._curveInfo.x.b)*t+this._curveInfo.x.c;}
_solveCurveX(x,epsilon)
{var t0,t1,t2,x2,d2,i;for(t2=x,i=0;i<8;i++){x2=this._sampleCurveX(t2)-x;if(Math.abs(x2)<epsilon)
return t2;d2=this._sampleCurveDerivativeX(t2);if(Math.abs(d2)<1e-6)
break;t2=t2-x2/d2;}
t0=0.0;t1=1.0;t2=x;if(t2<t0)
return t0;if(t2>t1)
return t1;while(t0<t1){x2=this._sampleCurveX(t2);if(Math.abs(x2-x)<epsilon)
return t2;if(x>x2)
t0=t2;else
t1=t2;t2=(t1-t0)*0.5+t0;}
return t2;}};WI.CubicBezier.keywordValues={"ease":[0.25,0.1,0.25,1],"ease-in":[0.42,0,1,1],"ease-out":[0,0,0.58,1],"ease-in-out":[0.42,0,0.58,1],"linear":[0,0,1,1]};WI.Spring=class Spring
{constructor(mass,stiffness,damping,initialVelocity)
{this.mass=Math.max(1,mass);this.stiffness=Math.max(1,stiffness);this.damping=Math.max(0,damping);this.initialVelocity=initialVelocity;}
static fromValues(values)
{if(!values||values.length<4)
return null;values=values.map(Number);if(values.includes(NaN))
return null;return new WI.Spring(...values);}
static fromString(text)
{if(!text||!text.length)
return null;let trimmedText=text.toLowerCase().trim();if(!trimmedText.length)
return null;let matches=trimmedText.match(/^spring\(([\d.]+)\s+([\d.]+)\s+([\d.]+)\s+([-\d.]+)\)$/);if(!matches)
return null;return WI.Spring.fromValues(matches.slice(1));}
copy()
{return new WI.Spring(this.mass,this.stiffness,this.damping,this.initialVelocity);}
toString()
{return`spring(${this.mass} ${this.stiffness} ${this.damping} ${this.initialVelocity})`;}
solve(t)
{let w0=Math.sqrt(this.stiffness/this.mass);let zeta=this.damping/(2*Math.sqrt(this.stiffness*this.mass));let wd=0;let A=1;let B=-this.initialVelocity+w0;if(zeta<1){wd=w0*Math.sqrt(1-zeta*zeta);A=1;B=(zeta*w0+-this.initialVelocity)/wd;}
if(zeta<1)
t=Math.exp(-t*zeta*w0)*(A*Math.cos(wd*t)+B*Math.sin(wd*t));else
t=(A+B*t)*Math.exp(-t*w0);return 1-t;}
calculateDuration(epsilon)
{epsilon=epsilon||0.0001;let t=0;let current=0;let minimum=Number.POSITIVE_INFINITY;while(current>=epsilon||minimum>=epsilon){current=Math.abs(1-this.solve(t));if(minimum<epsilon&&current>=epsilon)
minimum=Number.POSITIVE_INFINITY;else if(current<minimum)
minimum=current;t+=0.1;}
return t;}};WI.StepsFunction=class StepsFunction
{constructor(type,count)
{this._type=type;this._count=count;}
static fromString(text)
{if(!text?.length)
return null;let trimmedText=text.toLowerCase().replace(/\s/g,"");if(!trimmedText.length)
return null;let keywordValue=WI.StepsFunction.keywordValues[trimmedText];if(keywordValue)
return new WI.StepsFunction(...keywordValue);let matches=trimmedText.match(/^steps\((\d+)(?:,([a-z-]+))?\)$/);if(!matches)
return null;let type=matches[2]||WI.StepsFunction.Type.JumpEnd;if(Object.values(WI.StepsFunction).includes(type))
return null;let count=Number(matches[1]);if(isNaN(count)||count<=0)
return null;return new WI.StepsFunction(type,count);}
get type(){return this._type;}
get count(){return this._count;}
copy()
{return new WI.StepsFunction(this._type,this._count);}
toString()
{if(this._type===WI.StepsFunction.Type.JumpStart&&this._count===1)
return"step-start";if(this._type===WI.StepsFunction.Type.JumpEnd&&this._count===1)
return"step-end";return`steps(${this._count}, ${this._type})`;}};WI.StepsFunction.Type={JumpStart:"jump-start",JumpEnd:"jump-end",JumpNone:"jump-none",JumpBoth:"jump-both",Start:"start",End:"end",};WI.StepsFunction.keywordValues={"step-start":[WI.StepsFunction.Type.JumpStart,1],"step-end":[WI.StepsFunction.Type.JumpEnd,1],};WI.Gradient=class Gradient
{constructor(type,stops)
{this.type=type;this.stops=stops;}
static angleFromString(string)
{let match=string.match(/([-\d\.]+)(\w+)/);if(!match||!Object.values(WI.Gradient.AngleUnits).includes(match[2]))
return null;return{value:parseFloat(match[1]),units:match[2]};}
static fromString(cssString)
{var type;var openingParenthesisIndex=cssString.indexOf("(");var typeString=cssString.substring(0,openingParenthesisIndex);if(typeString.includes(WI.Gradient.Types.Linear))
type=WI.Gradient.Types.Linear;else if(typeString.includes(WI.Gradient.Types.Radial))
type=WI.Gradient.Types.Radial;else if(typeString.includes(WI.Gradient.Types.Conic))
type=WI.Gradient.Types.Conic;else
return null;var components=[];var currentParams=[];var currentParam="";var openParentheses=0;var ch=openingParenthesisIndex+1;var c=null;while(c=cssString[ch]){if(c==="(")
openParentheses++;if(c===")")
openParentheses--;var isComma=c===",";var isSpace=/\s/.test(c);if(openParentheses===0){if(isSpace){if(currentParam!=="")
currentParams.push(currentParam);currentParam="";}else if(isComma){currentParams.push(currentParam);components.push(currentParams);currentParams=[];currentParam="";}}
if(openParentheses===-1){currentParams.push(currentParam);components.push(currentParams);break;}
if(openParentheses>0||(!isComma&&!isSpace))
currentParam+=c;ch++;}
if(openParentheses!==-1)
return null;let gradient=null;switch(type){case WI.Gradient.Types.Linear:gradient=WI.LinearGradient.fromComponents(components);break;case WI.Gradient.Types.Radial:gradient=WI.RadialGradient.fromComponents(components);break;case WI.Gradient.Types.Conic:gradient=WI.ConicGradient.fromComponents(components);break;}
if(gradient)
gradient.repeats=typeString.startsWith("repeating");return gradient;}
static stopsWithComponents(components)
{var stops=components.map(function(component){while(component.length){var color=WI.Color.fromString(component.shift());if(!color)
continue;var stop={color};if(component.length&&component[0].substr(-1)==="%")
stop.offset=parseFloat(component.shift())/100;return stop;}});if(!stops.length)
return null;for(var i=0,count=stops.length;i<count;++i){var stop=stops[i];if(!stop)
return null;if(!stop.offset)
stop.offset=i/(count-1);}
return stops;}
stringFromStops(stops)
{var count=stops.length-1;return stops.map(function(stop,index){var str=stop.color;if(stop.offset!==index/count)
str+=" "+Math.round(stop.offset*10_000)/100+"%";return str;}).join(", ");}
get angleValue()
{return this._angle.value.maxDecimals(2);}
set angleValue(value)
{this._angle.value=value;}
get angleUnits()
{return this._angle.units;}
set angleUnits(units)
{if(units===this._angle.units)
return;this._angle.value=this._angleValueForUnits(units);this._angle.units=units;}
copy()
{}
toString()
{}
_angleValueForUnits(units)
{if(units===this._angle.units)
return this._angle.value;let deg=0;switch(this._angle.units){case WI.Gradient.AngleUnits.DEG:deg=this._angle.value;break;case WI.Gradient.AngleUnits.RAD:deg=this._angle.value*180/Math.PI;break;case WI.Gradient.AngleUnits.GRAD:deg=this._angle.value/400*360;break;case WI.Gradient.AngleUnits.TURN:deg=this._angle.value*360;break;}
switch(units){case WI.Gradient.AngleUnits.DEG:return deg;case WI.Gradient.AngleUnits.RAD:return deg*Math.PI/180;case WI.Gradient.AngleUnits.GRAD:return deg/360*400;case WI.Gradient.AngleUnits.TURN:return deg/360;}
return 0;}};WI.Gradient.Types={Linear:"linear-gradient",Radial:"radial-gradient",Conic:"conic-gradient",};WI.Gradient.AngleUnits={DEG:"deg",RAD:"rad",GRAD:"grad",TURN:"turn",};WI.LinearGradient=class LinearGradient extends WI.Gradient
{constructor(angle,stops)
{super(WI.Gradient.Types.Linear,stops);this._angle=angle;}
static fromComponents(components)
{let angle={value:180,units:WI.Gradient.AngleUnits.DEG};if(components[0].length===1&&!WI.Color.fromString(components[0][0])){angle=WI.Gradient.angleFromString(components[0][0]);if(!angle)
return null;components.shift();}else if(components[0][0]==="to"){components[0].shift();switch(components[0].sort().join(" ")){case"top":angle.value=0;break;case"right top":angle.value=45;break;case"right":angle.value=90;break;case"bottom right":angle.value=135;break;case"bottom":angle.value=180;break;case"bottom left":angle.value=225;break;case"left":angle.value=270;break;case"left top":angle.value=315;break;default:return null;}
components.shift();}else if(components[0].length!==1&&!WI.Color.fromString(components[0][0])){return null;}
let stops=WI.Gradient.stopsWithComponents(components);if(!stops)
return null;return new WI.LinearGradient(angle,stops);}
copy()
{return new WI.LinearGradient(this._angle,this.stops.concat());}
toString()
{let str="";let deg=this._angleValueForUnits(WI.LinearGradient.AngleUnits.DEG);if(deg===0)
str+="to top";else if(deg===45)
str+="to top right";else if(deg===90)
str+="to right";else if(deg===135)
str+="to bottom right";else if(deg===225)
str+="to bottom left";else if(deg===270)
str+="to left";else if(deg===315)
str+="to top left";else if(deg!==180)
str+=this.angleValue+this.angleUnits;if(str)
str+=", ";str+=this.stringFromStops(this.stops);return(this.repeats?"repeating-":"")+this.type+"("+str+")";}};WI.RadialGradient=class RadialGradient extends WI.Gradient
{constructor(sizing,stops)
{super(WI.Gradient.Types.Radial,stops);this.sizing=sizing;}
static fromComponents(components)
{let sizing=!WI.Color.fromString(components[0].join(" "))?components.shift().join(" "):"";let stops=WI.Gradient.stopsWithComponents(components);if(!stops)
return null;return new WI.RadialGradient(sizing,stops);}
get angleValue()
{return 0;}
set angleValue(value)
{}
get angleUnits()
{return"";}
set angleUnits(units)
{}
copy()
{return new WI.RadialGradient(this.sizing,this.stops.concat());}
toString()
{let str=this.sizing;if(str)
str+=", ";str+=this.stringFromStops(this.stops);return(this.repeats?"repeating-":"")+this.type+"("+str+")";}};WI.ConicGradient=class ConicGradient extends WI.Gradient
{constructor(angle,position,stops)
{super(WI.Gradient.Types.Conic,stops);this._angle=angle;this._position=position;}
static fromComponents(components)
{let angle={value:0,units:WI.Gradient.AngleUnits.DEG};let position=null;let hasCustomAngleOrPosition=false;if(components[0][0]=="from"){components[0].shift();angle=WI.Gradient.angleFromString(components[0][0]);if(!angle)
return null;components[0].shift();hasCustomAngleOrPosition=true;}
if(components[0][0]=="at"){components[0].shift();if(components[0].length<=0)
return null;position=components[0].join(" ");hasCustomAngleOrPosition=true;}
if(hasCustomAngleOrPosition)
components.shift();let stops=WI.Gradient.stopsWithComponents(components);if(!stops)
return null;return new WI.ConicGradient(angle,position,stops);}
copy()
{return new WI.ConicGradient(this._angle,this._position,this.stops.concat());}
toString()
{let str="";if(this._angle.value)
str+=`from ${this._angle.value}${this._angle.units}`;if(this._position){if(str)
str+=" ";str+=`at ${this._position}`;}
if(str)
str+=", ";str+=this.stringFromStops(this.stops);return(this.repeats?"repeating-":"")+this.type+"("+str+")";}};WI.HeapAllocationsInstrument=class HeapAllocationsInstrument extends WI.Instrument
{constructor()
{super();this._snapshotIntervalIdentifier=undefined;}
get timelineRecordType()
{return WI.TimelineRecord.Type.HeapAllocations;}
startInstrumentation(initiatedByBackend)
{if(!initiatedByBackend){let target=WI.assumingMainTarget();target.HeapAgent.startTracking();}
const snapshotInterval=10_000;this._snapshotIntervalIdentifier=setInterval(this._takeHeapSnapshot.bind(this),snapshotInterval);}
stopInstrumentation(initiatedByBackend)
{if(!initiatedByBackend){let target=WI.assumingMainTarget();target.HeapAgent.stopTracking();}
window.clearInterval(this._snapshotIntervalIdentifier);this._snapshotIntervalIdentifier=undefined;}
_takeHeapSnapshot()
{WI.heapManager.snapshot((error,timestamp,snapshotStringData)=>{let workerProxy=WI.HeapSnapshotWorkerProxy.singleton();workerProxy.createSnapshot(snapshotStringData,({objectId,snapshot:serializedSnapshot})=>{let snapshot=WI.HeapSnapshotProxy.deserialize(objectId,serializedSnapshot);snapshot.snapshotStringData=snapshotStringData;WI.timelineManager.heapSnapshotAdded(timestamp,snapshot);});});}};WI.HeapAllocationsTimelineRecord=class HeapAllocationsTimelineRecord extends WI.TimelineRecord
{constructor(timestamp,heapSnapshot)
{super(WI.TimelineRecord.Type.HeapAllocations,timestamp,timestamp);this._timestamp=timestamp;this._heapSnapshot=heapSnapshot;}
static async fromJSON(json)
{let{timestamp,title,snapshotStringData}=json;return await new Promise((resolve,reject)=>{let workerProxy=WI.HeapSnapshotWorkerProxy.singleton();workerProxy.createImportedSnapshot(snapshotStringData,title,({objectId,snapshot:serializedSnapshot})=>{let snapshot=WI.HeapSnapshotProxy.deserialize(objectId,serializedSnapshot);snapshot.snapshotStringData=snapshotStringData;resolve(new WI.HeapAllocationsTimelineRecord(timestamp,snapshot));});});}
toJSON()
{return{type:this.type,timestamp:this._timestamp,title:WI.TimelineTabContentView.displayNameForRecord(this),snapshotStringData:this._heapSnapshot.snapshotStringData,};}
get timestamp(){return this._timestamp;}
get heapSnapshot(){return this._heapSnapshot;}};WI.HeapSnapshotRootPath=class HeapSnapshotRootPath
{constructor(node,pathComponent,parent,isGlobalScope)
{this._node=node||null;this._parent=parent||null;this._pathComponent=typeof pathComponent==="string"?pathComponent:null;this._isGlobalScope=isGlobalScope||false;if(this._parent&&this._parent.isEmpty())
this._parent=null;}
static emptyPath()
{return new WI.HeapSnapshotRootPath(null);}
static pathComponentForIndividualEdge(edge)
{switch(edge.type){case WI.HeapSnapshotEdgeProxy.EdgeType.Internal:return null;case WI.HeapSnapshotEdgeProxy.EdgeType.Index:return"["+edge.data+"]";case WI.HeapSnapshotEdgeProxy.EdgeType.Property:case WI.HeapSnapshotEdgeProxy.EdgeType.Variable:if(WI.HeapSnapshotRootPath.canPropertyNameBeDotAccess(edge.data))
return edge.data;return"["+doubleQuotedString(edge.data)+"]";}}
static canPropertyNameBeDotAccess(propertyName)
{return /^(?![0-9])\w+$/.test(propertyName);}
get node(){return this._node;}
get parent(){return this._parent;}
get pathComponent(){return this._pathComponent;}
get rootNode()
{return this._parent?this._parent.rootNode:this._node;}
get fullPath()
{let components=[];for(let p=this;p&&p.pathComponent;p=p.parent)
components.push(p.pathComponent);components.reverse();return components.join("");}
isRoot()
{return!this._parent;}
isEmpty()
{return!this._node;}
isGlobalScope()
{return this._isGlobalScope;}
isPathComponentImpossible()
{return this._pathComponent&&this._pathComponent.startsWith("@");}
isFullPathImpossible()
{if(this.isEmpty())
return true;if(this.isPathComponentImpossible())
return true;if(this._parent)
return this._parent.isFullPathImpossible();return false;}
appendInternal(node)
{return new WI.HeapSnapshotRootPath(node,WI.HeapSnapshotRootPath.SpecialPathComponent.InternalPropertyName,this);}
appendArrayIndex(node,index)
{let component="["+index+"]";return new WI.HeapSnapshotRootPath(node,component,this);}
appendPropertyName(node,propertyName)
{let component=WI.HeapSnapshotRootPath.canPropertyNameBeDotAccess(propertyName)?"."+propertyName:"["+doubleQuotedString(propertyName)+"]";return new WI.HeapSnapshotRootPath(node,component,this);}
appendVariableName(node,variableName)
{if(this._isGlobalScope)
return this.appendPropertyName(node,variableName);return new WI.HeapSnapshotRootPath(node,variableName,this);}
appendGlobalScopeName(node,globalScopeName)
{return new WI.HeapSnapshotRootPath(node,globalScopeName,this,true);}
appendEdge(edge)
{switch(edge.type){case WI.HeapSnapshotEdgeProxy.EdgeType.Internal:return this.appendInternal(edge.to);case WI.HeapSnapshotEdgeProxy.EdgeType.Index:return this.appendArrayIndex(edge.to,edge.data);case WI.HeapSnapshotEdgeProxy.EdgeType.Property:return this.appendPropertyName(edge.to,edge.data);case WI.HeapSnapshotEdgeProxy.EdgeType.Variable:return this.appendVariableName(edge.to,edge.data);}
console.error("Unexpected edge type",edge.type);}};WI.HeapSnapshotRootPath.SpecialPathComponent={InternalPropertyName:"@internal",};WI.IndexedDatabase=class IndexedDatabase
{constructor(name,securityOrigin,version,objectStores)
{this._name=name;this._securityOrigin=securityOrigin;this._host=parseSecurityOrigin(securityOrigin).host;this._version=version;this._objectStores=objectStores||[];for(var objectStore of this._objectStores)
objectStore.establishRelationship(this);}
get name(){return this._name;}
get securityOrigin(){return this._securityOrigin;}
get host(){return this._host;}
get version(){return this._version;}
get objectStores(){return this._objectStores;}
saveIdentityToCookie(cookie)
{cookie[WI.IndexedDatabase.NameCookieKey]=this._name;cookie[WI.IndexedDatabase.HostCookieKey]=this._host;}};WI.IndexedDatabase.TypeIdentifier="indexed-database";WI.IndexedDatabase.NameCookieKey="indexed-database-name";WI.IndexedDatabase.HostCookieKey="indexed-database-host";WI.IndexedDatabaseObjectStore=class IndexedDatabaseObjectStore
{constructor(name,keyPath,autoIncrement,indexes)
{this._name=name;this._keyPath=keyPath;this._autoIncrement=autoIncrement||false;this._indexes=indexes||[];this._parentDatabase=null;for(var index of this._indexes)
index.establishRelationship(this);}
get name(){return this._name;}
get keyPath(){return this._keyPath;}
get autoIncrement(){return this._autoIncrement;}
get parentDatabase(){return this._parentDatabase;}
get indexes(){return this._indexes;}
saveIdentityToCookie(cookie)
{cookie[WI.IndexedDatabaseObjectStore.NameCookieKey]=this._name;cookie[WI.IndexedDatabaseObjectStore.KeyPathCookieKey]=this._keyPath;}
establishRelationship(parentDatabase)
{this._parentDatabase=parentDatabase||null;}};WI.IndexedDatabaseObjectStore.TypeIdentifier="indexed-database-object-store";WI.IndexedDatabaseObjectStore.NameCookieKey="indexed-database-object-store-name";WI.IndexedDatabaseObjectStore.KeyPathCookieKey="indexed-database-object-store-key-path";WI.IndexedDatabaseObjectStoreIndex=class IndexedDatabaseObjectStoreIndex
{constructor(name,keyPath,unique,multiEntry)
{this._name=name;this._keyPath=keyPath;this._unique=unique||false;this._multiEntry=multiEntry||false;this._parentObjectStore=null;}
get name(){return this._name;}
get keyPath(){return this._keyPath;}
get unique(){return this._unique;}
get multiEntry(){return this._multiEntry;}
get parentObjectStore(){return this._parentObjectStore;}
saveIdentityToCookie(cookie)
{cookie[WI.IndexedDatabaseObjectStoreIndex.NameCookieKey]=this._name;cookie[WI.IndexedDatabaseObjectStoreIndex.KeyPathCookieKey]=this._keyPath;}
establishRelationship(parentObjectStore)
{this._parentObjectStore=parentObjectStore||null;}};WI.IndexedDatabaseObjectStoreIndex.TypeIdentifier="indexed-database-object-store-index";WI.IndexedDatabaseObjectStoreIndex.NameCookieKey="indexed-database-object-store-index-name";WI.IndexedDatabaseObjectStoreIndex.KeyPathCookieKey="indexed-database-object-store-index-key-path";WI.IssueMessage=class IssueMessage extends WI.Object
{constructor(consoleMessage)
{super();this._consoleMessage=consoleMessage;this._text=this._issueText();switch(this._consoleMessage.source){case WI.ConsoleMessage.MessageSource.JS:var prefixRegex=/^([^:]+): (?:DOM Exception \d+: )?/;var match=prefixRegex.exec(this._text);if(match&&match[1]in WI.IssueMessage.Type._prefixTypeMap){this._type=WI.IssueMessage.Type._prefixTypeMap[match[1]];this._text=this._text.substring(match[0].length);}else
this._type=WI.IssueMessage.Type.OtherIssue;break;case WI.ConsoleMessage.MessageSource.CSS:case WI.ConsoleMessage.MessageSource.XML:this._type=WI.IssueMessage.Type.PageIssue;break;case WI.ConsoleMessage.MessageSource.Network:this._type=WI.IssueMessage.Type.NetworkIssue;break;case WI.ConsoleMessage.MessageSource.Security:this._type=WI.IssueMessage.Type.SecurityIssue;break;case WI.ConsoleMessage.MessageSource.ConsoleAPI:case WI.ConsoleMessage.MessageSource.Storage:case WI.ConsoleMessage.MessageSource.Appcache:case WI.ConsoleMessage.MessageSource.Rendering:case WI.ConsoleMessage.MessageSource.Media:case WI.ConsoleMessage.MessageSource.Mediasource:case WI.ConsoleMessage.MessageSource.WebRTC:case WI.ConsoleMessage.MessageSource.ITPDebug:case WI.ConsoleMessage.MessageSource.PrivateClickMeasurement:case WI.ConsoleMessage.MessageSource.PaymentRequest:case WI.ConsoleMessage.MessageSource.AdClickAttribution:case WI.ConsoleMessage.MessageSource.Other:this._type=WI.IssueMessage.Type.OtherIssue;break;default:console.error("Unknown issue source:",this._consoleMessage.source);this._type=WI.IssueMessage.Type.OtherIssue;}
this._sourceCodeLocation=consoleMessage.sourceCodeLocation;if(this._sourceCodeLocation)
this._sourceCodeLocation.addEventListener(WI.SourceCodeLocation.Event.DisplayLocationChanged,this._sourceCodeLocationDisplayLocationChanged,this);}
static displayName(type)
{switch(type){case WI.IssueMessage.Type.SemanticIssue:return WI.UIString("Semantic Issue");case WI.IssueMessage.Type.RangeIssue:return WI.UIString("Range Issue");case WI.IssueMessage.Type.ReferenceIssue:return WI.UIString("Reference Issue");case WI.IssueMessage.Type.TypeIssue:return WI.UIString("Type Issue");case WI.IssueMessage.Type.PageIssue:return WI.UIString("Page Issue");case WI.IssueMessage.Type.NetworkIssue:return WI.UIString("Network Issue");case WI.IssueMessage.Type.SecurityIssue:return WI.UIString("Security Issue");case WI.IssueMessage.Type.OtherIssue:return WI.UIString("Other Issue");default:console.error("Unknown issue message type:",type);return WI.UIString("Other Issue");}}
get text(){return this._text;}
get type(){return this._type;}
get level(){return this._consoleMessage.level;}
get source(){return this._consoleMessage.source;}
get url(){return this._consoleMessage.url;}
get sourceCodeLocation(){return this._sourceCodeLocation;}
saveIdentityToCookie(cookie)
{cookie[WI.IssueMessage.URLCookieKey]=this.url;cookie[WI.IssueMessage.LineNumberCookieKey]=this._sourceCodeLocation?this._sourceCodeLocation.lineNumber:0;cookie[WI.IssueMessage.ColumnNumberCookieKey]=this._sourceCodeLocation?this._sourceCodeLocation.columnNumber:0;}
_issueText()
{let parameters=this._consoleMessage.parameters;if(!parameters)
return this._consoleMessage.messageText;if(parameters[0].type!=="string")
return this._consoleMessage.messageText;function valueFormatter(obj)
{return obj.description;}
let formatters={};formatters.o=valueFormatter;formatters.s=valueFormatter;formatters.f=valueFormatter;formatters.i=valueFormatter;formatters.d=valueFormatter;function append(a,b)
{a+=b;return a;}
let result=String.format(parameters[0].description,parameters.slice(1),formatters,"",append);let resultText=result.formattedResult;for(let i=0;i<result.unusedSubstitutions.length;++i)
resultText+=" "+result.unusedSubstitutions[i].description;return resultText;}
_sourceCodeLocationDisplayLocationChanged(event)
{this.dispatchEventToListeners(WI.IssueMessage.Event.DisplayLocationDidChange,event.data);}};WI.IssueMessage.Level={Error:"error",Warning:"warning"};WI.IssueMessage.Type={SemanticIssue:"issue-message-type-semantic-issue",RangeIssue:"issue-message-type-range-issue",ReferenceIssue:"issue-message-type-reference-issue",TypeIssue:"issue-message-type-type-issue",PageIssue:"issue-message-type-page-issue",NetworkIssue:"issue-message-type-network-issue",SecurityIssue:"issue-message-type-security-issue",OtherIssue:"issue-message-type-other-issue"};WI.IssueMessage.TypeIdentifier="issue-message";WI.IssueMessage.URLCookieKey="issue-message-url";WI.IssueMessage.LineNumberCookieKey="issue-message-line-number";WI.IssueMessage.ColumnNumberCookieKey="issue-message-column-number";WI.IssueMessage.Event={LocationDidChange:"issue-message-location-did-change",DisplayLocationDidChange:"issue-message-display-location-did-change"};WI.IssueMessage.Type._prefixTypeMap={"SyntaxError":WI.IssueMessage.Type.SemanticIssue,"URIError":WI.IssueMessage.Type.SemanticIssue,"AggregateError":WI.IssueMessage.Type.SemanticIssue,"EvalError":WI.IssueMessage.Type.SemanticIssue,"INVALID_CHARACTER_ERR":WI.IssueMessage.Type.SemanticIssue,"SYNTAX_ERR":WI.IssueMessage.Type.SemanticIssue,"RangeError":WI.IssueMessage.Type.RangeIssue,"INDEX_SIZE_ERR":WI.IssueMessage.Type.RangeIssue,"DOMSTRING_SIZE_ERR":WI.IssueMessage.Type.RangeIssue,"ReferenceError":WI.IssueMessage.Type.ReferenceIssue,"HIERARCHY_REQUEST_ERR":WI.IssueMessage.Type.ReferenceIssue,"INVALID_STATE_ERR":WI.IssueMessage.Type.ReferenceIssue,"NOT_FOUND_ERR":WI.IssueMessage.Type.ReferenceIssue,"WRONG_DOCUMENT_ERR":WI.IssueMessage.Type.ReferenceIssue,"TypeError":WI.IssueMessage.Type.TypeIssue,"INVALID_NODE_TYPE_ERR":WI.IssueMessage.Type.TypeIssue,"TYPE_MISMATCH_ERR":WI.IssueMessage.Type.TypeIssue,"SECURITY_ERR":WI.IssueMessage.Type.SecurityIssue,"NETWORK_ERR":WI.IssueMessage.Type.NetworkIssue,"ABORT_ERR":WI.IssueMessage.Type.OtherIssue,"DATA_CLONE_ERR":WI.IssueMessage.Type.OtherIssue,"INUSE_ATTRIBUTE_ERR":WI.IssueMessage.Type.OtherIssue,"INVALID_ACCESS_ERR":WI.IssueMessage.Type.OtherIssue,"INVALID_MODIFICATION_ERR":WI.IssueMessage.Type.OtherIssue,"NAMESPACE_ERR":WI.IssueMessage.Type.OtherIssue,"NOT_SUPPORTED_ERR":WI.IssueMessage.Type.OtherIssue,"NO_DATA_ALLOWED_ERR":WI.IssueMessage.Type.OtherIssue,"NO_MODIFICATION_ALLOWED_ERR":WI.IssueMessage.Type.OtherIssue,"QUOTA_EXCEEDED_ERR":WI.IssueMessage.Type.OtherIssue,"TIMEOUT_ERR":WI.IssueMessage.Type.OtherIssue,"URL_MISMATCH_ERR":WI.IssueMessage.Type.OtherIssue,"VALIDATION_ERR":WI.IssueMessage.Type.OtherIssue};WI.JavaScriptBreakpoint=class JavaScriptBreakpoint extends WI.Breakpoint
{constructor(sourceCodeLocation,{contentIdentifier,resolved,disabled,condition,actions,ignoreCount,autoContinue}={})
{super({disabled,condition,actions,ignoreCount,autoContinue});this._id=null;this._sourceCodeLocation=sourceCodeLocation;let sourceCode=this._sourceCodeLocation.sourceCode;if(sourceCode){this._contentIdentifier=sourceCode.contentIdentifier;}else
this._contentIdentifier=contentIdentifier||null;this._scriptIdentifier=sourceCode instanceof WI.Script?sourceCode.id:null;this._target=sourceCode instanceof WI.Script?sourceCode.target:null;this._resolved=!!resolved;this._sourceCodeLocation.addEventListener(WI.SourceCodeLocation.Event.LocationChanged,this._sourceCodeLocationLocationChanged,this);this._sourceCodeLocation.addEventListener(WI.SourceCodeLocation.Event.DisplayLocationChanged,this._sourceCodeLocationDisplayLocationChanged,this);}
static supportsMicrotasks(parameter)
{return InspectorBackend.hasCommand("Debugger.setPauseOnMicrotasks",parameter);}
static supportsDebuggerStatements(parameter)
{return InspectorBackend.hasCommand("Debugger.setPauseOnDebuggerStatements",parameter);}
static fromJSON(json)
{const sourceCode=null;return new WI.JavaScriptBreakpoint(new WI.SourceCodeLocation(sourceCode,json.lineNumber||0,json.columnNumber||0),{contentIdentifier:json.contentIdentifier||json.url,resolved:json.resolved,disabled:json.disabled,condition:json.condition,actions:json.actions?.map((actionJSON)=>WI.BreakpointAction.fromJSON(actionJSON))||[],ignoreCount:json.ignoreCount,autoContinue:json.autoContinue,});}
toJSON(key)
{let json=super.toJSON(key);if(this._contentIdentifier)
json.contentIdentifier=this._contentIdentifier;if(isFinite(this._sourceCodeLocation.lineNumber))
json.lineNumber=this._sourceCodeLocation.lineNumber;if(isFinite(this._sourceCodeLocation.columnNumber))
json.columnNumber=this._sourceCodeLocation.columnNumber;if(key===WI.ObjectStore.toJSONSymbol)
json[WI.objectStores.breakpoints.keyPath]=this._contentIdentifier+":"+this._sourceCodeLocation.lineNumber+":"+this._sourceCodeLocation.columnNumber;return json;}
get sourceCodeLocation(){return this._sourceCodeLocation;}
get contentIdentifier(){return this._contentIdentifier;}
get scriptIdentifier(){return this._scriptIdentifier;}
get target(){return this._target;}
get displayName()
{switch(this){case WI.debuggerManager.debuggerStatementsBreakpoint:return WI.repeatedUIString.debuggerStatements();case WI.debuggerManager.allExceptionsBreakpoint:return WI.repeatedUIString.allExceptions();case WI.debuggerManager.uncaughtExceptionsBreakpoint:return WI.repeatedUIString.uncaughtExceptions();case WI.debuggerManager.assertionFailuresBreakpoint:return WI.repeatedUIString.assertionFailures();case WI.debuggerManager.allMicrotasksBreakpoint:return WI.repeatedUIString.allMicrotasks();}
return this._sourceCodeLocation.displayLocationString()}
get special()
{switch(this){case WI.debuggerManager.debuggerStatementsBreakpoint:case WI.debuggerManager.allExceptionsBreakpoint:case WI.debuggerManager.uncaughtExceptionsBreakpoint:case WI.debuggerManager.assertionFailuresBreakpoint:case WI.debuggerManager.allMicrotasksBreakpoint:return true;}
if(this._isSpecial())
return true;return super.special;}
get removable()
{switch(this){case WI.debuggerManager.debuggerStatementsBreakpoint:case WI.debuggerManager.allExceptionsBreakpoint:case WI.debuggerManager.uncaughtExceptionsBreakpoint:return false;}
return super.removable;}
get editable()
{switch(this){case WI.debuggerManager.debuggerStatementsBreakpoint:return WI.JavaScriptBreakpoint.supportsDebuggerStatements("options");case WI.debuggerManager.allExceptionsBreakpoint:case WI.debuggerManager.uncaughtExceptionsBreakpoint:return InspectorBackend.hasCommand("Debugger.setPauseOnExceptions","options");case WI.debuggerManager.assertionFailuresBreakpoint:return InspectorBackend.hasCommand("Debugger.setPauseOnAssertions","options");case WI.debuggerManager.allMicrotasksBreakpoint:return WI.JavaScriptBreakpoint.supportsMicrotasks("options");}
return true;}
get identifier()
{return this._id;}
set identifier(id)
{this._id=id||null;}
get resolved()
{return super.resolved&&this._resolved;}
set resolved(resolved)
{if(this._resolved===resolved)
return;this._resolved=resolved||false;this.dispatchEventToListeners(WI.JavaScriptBreakpoint.Event.ResolvedStateDidChange);}
remove()
{super.remove();WI.debuggerManager.removeBreakpoint(this);}
saveIdentityToCookie(cookie)
{cookie["javascript-breakpoint-content-identifier"]=this._contentIdentifier;cookie["javascript-breakpoint-line-number"]=this._sourceCodeLocation.lineNumber;cookie["javascript-breakpoint-column-number"]=this._sourceCodeLocation.columnNumber;}
_isSpecial()
{return this._sourceCodeLocation.isEqual(WI.SourceCodeLocation.specialBreakpointLocation);}
_sourceCodeLocationLocationChanged(event)
{this.dispatchEventToListeners(WI.JavaScriptBreakpoint.Event.LocationDidChange,event.data);}
_sourceCodeLocationDisplayLocationChanged(event)
{this.dispatchEventToListeners(WI.JavaScriptBreakpoint.Event.DisplayLocationDidChange,event.data);}};WI.JavaScriptBreakpoint.TypeIdentifier="javascript-breakpoint";WI.JavaScriptBreakpoint.Event={ResolvedStateDidChange:"javascript-breakpoint-resolved-state-did-change",LocationDidChange:"javascript-breakpoint-location-did-change",DisplayLocationDidChange:"javascript-breakpoint-display-location-did-change",};WI.JavaScriptBreakpoint.ReferencePage=WI.ReferencePage.JavaScriptBreakpoints;WI.KeyboardShortcut=class KeyboardShortcut
{constructor(modifiers,key,callback,targetElement)
{if(typeof key==="string"){key=key[0].toUpperCase();key=new WI.Key(key.charCodeAt(0),key);}
if(callback&&!targetElement)
targetElement=document;this._modifiers=modifiers||WI.KeyboardShortcut.Modifier.None;this._key=key;this._targetElement=targetElement;this._callback=callback;this._disabled=false;this._implicitlyPreventsDefault=true;if(targetElement){var targetKeyboardShortcuts=targetElement._keyboardShortcuts;if(!targetKeyboardShortcuts)
targetKeyboardShortcuts=targetElement._keyboardShortcuts=[];targetKeyboardShortcuts.push(this);if(!WI.KeyboardShortcut._registeredKeyDownListener){WI.KeyboardShortcut._registeredKeyDownListener=true;window.addEventListener("keydown",WI.KeyboardShortcut._handleKeyDown);}}}
static _handleKeyDown(event)
{if(event.defaultPrevented)
return;for(var targetElement=event.target;targetElement;targetElement=targetElement.parentNode){if(!targetElement._keyboardShortcuts)
continue;for(var i=0;i<targetElement._keyboardShortcuts.length;++i){var keyboardShortcut=targetElement._keyboardShortcuts[i];if(!keyboardShortcut.matchesEvent(event))
continue;if(!keyboardShortcut.callback)
continue;keyboardShortcut.callback(event,keyboardShortcut);if(keyboardShortcut.implicitlyPreventsDefault)
event.preventDefault();return;}}}
get modifiers()
{return this._modifiers;}
get key()
{return this._key;}
get displayName()
{var result="";if(this._modifiers&WI.KeyboardShortcut.Modifier.Control)
result+="\u2303";if(this._modifiers&WI.KeyboardShortcut.Modifier.Option)
result+=WI.Platform.name==="mac"?"\u2325":"\u2387";if(this._modifiers&WI.KeyboardShortcut.Modifier.Shift)
result+="\u21e7";if(this._modifiers&WI.KeyboardShortcut.Modifier.Command)
result+="\u2318";result+=this._key.toString();return result;}
get callback()
{return this._callback;}
set callback(callback)
{this._callback=callback||null;}
get disabled()
{return this._disabled;}
set disabled(disabled)
{this._disabled=disabled||false;}
get implicitlyPreventsDefault()
{return this._implicitlyPreventsDefault;}
set implicitlyPreventsDefault(implicitly)
{this._implicitlyPreventsDefault=implicitly;}
unbind()
{this._disabled=true;if(!this._targetElement)
return;var targetKeyboardShortcuts=this._targetElement._keyboardShortcuts;if(!targetKeyboardShortcuts)
return;targetKeyboardShortcuts.remove(this);}
matchesEvent(event)
{if(this._disabled)
return false;if(this._key.keyCode!==event.keyCode)
return false;var eventModifiers=WI.KeyboardShortcut.Modifier.None;if(event.shiftKey)
eventModifiers|=WI.KeyboardShortcut.Modifier.Shift;if(event.ctrlKey)
eventModifiers|=WI.KeyboardShortcut.Modifier.Control;if(event.altKey)
eventModifiers|=WI.KeyboardShortcut.Modifier.Option;if(event.metaKey)
eventModifiers|=WI.KeyboardShortcut.Modifier.Command;return this._modifiers===eventModifiers;}};WI.Key=class Key
{constructor(keyCode,displayName)
{this._keyCode=keyCode;this._displayName=displayName;}
get keyCode()
{return this._keyCode;}
get displayName()
{return this._displayName;}
toString()
{return this._displayName;}};WI.KeyboardShortcut.Modifier={None:0,Shift:1,Control:2,Option:4,Command:8,get CommandOrControl()
{return WI.Platform.name==="mac"?this.Command:this.Control;}};WI.KeyboardShortcut.Key={Backspace:new WI.Key(8,"\u232b"),Tab:new WI.Key(9,"\u21e5"),Enter:new WI.Key(13,"\u21a9"),Escape:new WI.Key(27,"\u238b"),Space:new WI.Key(32,"Space"),PageUp:new WI.Key(33,"\u21de"),PageDown:new WI.Key(34,"\u21df"),End:new WI.Key(35,"\u2198"),Home:new WI.Key(36,"\u2196"),Left:new WI.Key(37,"\u2190"),Up:new WI.Key(38,"\u2191"),Right:new WI.Key(39,"\u2192"),Down:new WI.Key(40,"\u2193"),Delete:new WI.Key(46,"\u2326"),Zero:new WI.Key(48,"0"),F1:new WI.Key(112,"F1"),F2:new WI.Key(113,"F2"),F3:new WI.Key(114,"F3"),F4:new WI.Key(115,"F4"),F5:new WI.Key(116,"F5"),F6:new WI.Key(117,"F6"),F7:new WI.Key(118,"F7"),F8:new WI.Key(119,"F8"),F9:new WI.Key(120,"F9"),F10:new WI.Key(121,"F10"),F11:new WI.Key(122,"F11"),F12:new WI.Key(123,"F12"),Semicolon:new WI.Key(186,";"),Plus:new WI.Key(187,"+"),Comma:new WI.Key(188,","),Minus:new WI.Key(189,"-"),Period:new WI.Key(190,"."),Slash:new WI.Key(191,"/"),Apostrophe:new WI.Key(192,"`"),LeftCurlyBrace:new WI.Key(219,"{"),Backslash:new WI.Key(220,"\\"),RightCurlyBrace:new WI.Key(221,"}"),SingleQuote:new WI.Key(222,"'")};WI.Layer=class Layer{constructor(layerId,nodeId,bounds,paintCount,memory,compositedBounds,isInShadowTree,isReflection,isGeneratedContent,isAnonymous,pseudoElementId,pseudoElement)
{this._layerId=layerId;this._nodeId=nodeId;this._bounds=bounds;this._paintCount=paintCount;this._memory=memory;this._compositedBounds=compositedBounds;this._isInShadowTree=isInShadowTree;this._isReflection=isReflection;this._isGeneratedContent=isGeneratedContent;this._isAnonymous=isAnonymous;this._pseudoElementId=pseudoElementId;this._pseudoElement=pseudoElement;this._compositedBounds.x+=this._bounds.x;this._compositedBounds.y+=this._bounds.y;}
static fromPayload(payload)
{return new WI.Layer(payload.layerId,payload.nodeId,payload.bounds,payload.paintCount,payload.memory,payload.compositedBounds,payload.isInShadowTree,payload.isReflection,payload.isGeneratedContent,payload.isAnonymous,payload.pseudoElementId,payload.pseudoElement);}
get layerId(){return this._layerId;}
get nodeId(){return this._nodeId;}
get bounds(){return this._bounds;}
get paintCount(){return this._paintCount;}
get memory(){return this._memory;}
get compositedBounds(){return this._compositedBounds;}
get isInShadowTree(){return this._isInShadowTree;}
get isReflection(){return this._isReflection;}
get isGeneratedContent(){return this._isGeneratedContent;}
get isAnonymous(){return this._isAnonymous;}
get pseudoElementId(){return this._pseudoElementId;}
get pseudoElement(){return this._pseudoElement;}};WI.LayoutInstrument=class LayoutInstrument extends WI.Instrument
{get timelineRecordType()
{return WI.TimelineRecord.Type.Layout;}};WI.LayoutTimelineRecord=class LayoutTimelineRecord extends WI.TimelineRecord
{constructor(eventType,startTime,endTime,callFrames,sourceCodeLocation,quad)
{super(WI.TimelineRecord.Type.Layout,startTime,endTime,callFrames,sourceCodeLocation);if(eventType in WI.LayoutTimelineRecord.EventType)
eventType=WI.LayoutTimelineRecord.EventType[eventType];this._eventType=eventType;this._quad=quad||null;}
static displayNameForEventType(eventType)
{switch(eventType){case WI.LayoutTimelineRecord.EventType.InvalidateStyles:return WI.UIString("Styles Invalidated");case WI.LayoutTimelineRecord.EventType.RecalculateStyles:return WI.UIString("Styles Recalculated");case WI.LayoutTimelineRecord.EventType.InvalidateLayout:return WI.UIString("Layout Invalidated");case WI.LayoutTimelineRecord.EventType.ForcedLayout:return WI.UIString("Forced Layout","Layout phase records that were imperative (forced)");case WI.LayoutTimelineRecord.EventType.Layout:return WI.repeatedUIString.timelineRecordLayout();case WI.LayoutTimelineRecord.EventType.Paint:return WI.repeatedUIString.timelineRecordPaint();case WI.LayoutTimelineRecord.EventType.Composite:return WI.repeatedUIString.timelineRecordComposite();}}
static async fromJSON(json)
{let{eventType,startTime,endTime,callFrames,sourceCodeLocation,quad}=json;quad=quad?WI.Quad.fromJSON(quad):null;return new WI.LayoutTimelineRecord(eventType,startTime,endTime,callFrames,sourceCodeLocation,quad);}
toJSON()
{return{type:this.type,eventType:this._eventType,startTime:this.startTime,endTime:this.endTime,quad:this._quad||undefined,};}
get eventType()
{return this._eventType;}
get width()
{return this._quad?this._quad.width:NaN;}
get height()
{return this._quad?this._quad.height:NaN;}
get area()
{return this.width*this.height;}
get quad()
{return this._quad;}
saveIdentityToCookie(cookie)
{super.saveIdentityToCookie(cookie);cookie[WI.LayoutTimelineRecord.EventTypeCookieKey]=this._eventType;}};WI.LayoutTimelineRecord.EventType={InvalidateStyles:"invalidate-styles",RecalculateStyles:"recalculate-styles",InvalidateLayout:"invalidate-layout",ForcedLayout:"forced-layout",Layout:"layout",Paint:"paint",Composite:"composite"};WI.LayoutTimelineRecord.TypeIdentifier="layout-timeline-record";WI.LayoutTimelineRecord.EventTypeCookieKey="layout-timeline-record-event-type";WI.LazySourceCodeLocation=class LazySourceCodeLocation extends WI.SourceCodeLocation
{constructor(sourceCode,lineNumber,columnNumber)
{super(null,lineNumber,columnNumber);this._initialized=false;this._lazySourceCode=sourceCode;}
isEqual(other)
{if(!other)
return false;return this._lazySourceCode===other._sourceCode&&this._lineNumber===other._lineNumber&&this._columnNumber===other._columnNumber;}
get sourceCode()
{return this._lazySourceCode;}
set sourceCode(sourceCode)
{this.setSourceCode(sourceCode);}
get formattedLineNumber()
{this._lazyInitialization();return this._formattedLineNumber;}
get formattedColumnNumber()
{this._lazyInitialization();return this._formattedColumnNumber;}
formattedPosition()
{this._lazyInitialization();return new WI.SourceCodePosition(this._formattedLineNumber,this._formattedColumnNumber);}
hasFormattedLocation()
{this._lazyInitialization();return super.hasFormattedLocation();}
hasDifferentDisplayLocation()
{this._lazyInitialization();return super.hasDifferentDisplayLocation();}
resolveMappedLocation()
{this._lazyInitialization();super.resolveMappedLocation();}
_lazyInitialization()
{if(!this._initialized){this._initialized=true;this.sourceCode=this._lazySourceCode;}}};WI.LineWidget=class LineWidget
{constructor(codeMirrorLineWidget,widgetElement)
{this._codeMirrorLineWidget=codeMirrorLineWidget;this._widgetElement=widgetElement;}
get codeMirrorLineWidget()
{return this._codeMirrorLineWidget;}
get widgetElement()
{return this._widgetElement;}
clear()
{this._codeMirrorLineWidget.clear();}
update()
{if(this._codeMirrorLineWidget.update)
this._codeMirrorLineWidget.update();}};WI.LocalResourceOverride=class LocalResourceOverride extends WI.Object
{constructor(url,type,localResource,{resourceErrorType,isCaseSensitive,isRegex,disabled}={})
{super();this._url=WI.urlWithoutFragment(url);this._urlComponents=null;this._type=type;this._localResource=localResource;this._resourceErrorType=resourceErrorType||WI.LocalResourceOverride.ResourceErrorType.General;this._isCaseSensitive=isCaseSensitive!==undefined?isCaseSensitive:true;this._isRegex=isRegex!==undefined?isRegex:false;this._disabled=disabled!==undefined?disabled:false;this._localResource._localResourceOverride=this;}
static create(url,type,{requestURL,requestMethod,requestHeaders,requestData,responseMIMEType,responseContent,responseBase64Encoded,responseStatusCode,responseStatusText,responseHeaders,resourceErrorType,isCaseSensitive,isRegex,disabled}={})
{let localResource=new WI.LocalResource({request:{url:requestURL||url||"",method:requestMethod,headers:requestHeaders,data:requestData,},response:{headers:responseHeaders,mimeType:responseMIMEType,statusCode:responseStatusCode,statusText:responseStatusText,content:responseContent,base64Encoded:responseBase64Encoded,},});return new WI.LocalResourceOverride(url,type,localResource,{resourceErrorType,isCaseSensitive,isRegex,disabled});}
static displayNameForNetworkStageOfType(type)
{switch(type){case WI.LocalResourceOverride.InterceptType.Block:case WI.LocalResourceOverride.InterceptType.Request:return WI.UIString("Request Override","Request Override @ Local Override Network Stage","Text indicating that the local override replaces the request of the network activity.");case WI.LocalResourceOverride.InterceptType.Response:case WI.LocalResourceOverride.InterceptType.ResponseSkippingNetwork:return WI.UIString("Response Override","Response Override @ Local Override Network Stage","Text indicating that the local override replaces the response of the network activity.");}
return"";}
static displayNameForType(type)
{switch(type){case WI.LocalResourceOverride.InterceptType.Block:return WI.UIString("Block","Block @ Local Override Type","Text indicating that the local override will always block the network activity.");case WI.LocalResourceOverride.InterceptType.Request:return WI.UIString("Request","Request @ Local Override Type","Text indicating that the local override intercepts the request phase of network activity.");case WI.LocalResourceOverride.InterceptType.Response:return WI.UIString("Response","Response @ Local Override Type","Text indicating that the local override intercepts the response phase of network activity.");case WI.LocalResourceOverride.InterceptType.ResponseSkippingNetwork:return WI.UIString("Response (skip network)","Response (skip network) @ Local Override Type","Text indicating that the local override will skip all network activity and instead immediately serve the response.");}
return"";}
static displayNameForResourceErrorType(resourceErrorType)
{switch(resourceErrorType){case WI.LocalResourceOverride.ResourceErrorType.AccessControl:return WI.UIString("Access Control","Access Control @ Local Override Type","Text indicating that the local override will block the network activity with an access error.");case WI.LocalResourceOverride.ResourceErrorType.Cancellation:return WI.UIString("Cancellation","Cancellation @ Local Override Type","Text indicating that the local override will block the network activity with a cancellation error.");case WI.LocalResourceOverride.ResourceErrorType.General:return WI.UIString("General","General @ Local Override Type","Text indicating that the local override will block the network activity with a general error.");case WI.LocalResourceOverride.ResourceErrorType.Timeout:return WI.UIString("Timeout","Timeout @ Local Override Type","Text indicating that the local override will block the network activity with an timeout error.");}
return"";}
static fromJSON(json)
{let{url,type,localResource:localResourceJSON,resourceErrorType,isCaseSensitive,isRegex,disabled}=json;let localResource=WI.LocalResource.fromJSON(localResourceJSON);url??=localResource.url;type??=WI.LocalResourceOverride.InterceptType.Response;return new WI.LocalResourceOverride(url,type,localResource,{resourceErrorType,isCaseSensitive,isRegex,disabled});}
toJSON(key)
{let json={url:this._url,type:this._type,localResource:this._localResource.toJSON(key),isCaseSensitive:this._isCaseSensitive,isRegex:this._isRegex,disabled:this._disabled,};if(this._resourceErrorType)
json.resourceErrorType=this._resourceErrorType;if(key===WI.ObjectStore.toJSONSymbol)
json[WI.objectStores.localResourceOverrides.keyPath]=this._url;return json;}
get url(){return this._url;}
get type(){return this._type;}
get localResource(){return this._localResource;}
get isCaseSensitive(){return this._isCaseSensitive;}
get isRegex(){return this._isRegex;}
get urlComponents()
{if(!this._urlComponents)
this._urlComponents=parseURL(this._url);return this._urlComponents;}
get resourceErrorType()
{return this._resourceErrorType;}
set resourceErrorType(resourceErrorType)
{if(this._resourceErrorType===resourceErrorType)
return;this._resourceErrorType=resourceErrorType;this.dispatchEventToListeners(WI.LocalResourceOverride.Event.ResourceErrorTypeChanged);}
get disabled()
{return this._disabled;}
set disabled(disabled)
{if(this._disabled===disabled)
return;this._disabled=!!disabled;this.dispatchEventToListeners(WI.LocalResourceOverride.Event.DisabledChanged);}
get displayName()
{return this.displayURL();}
displayURL({full}={})
{if(this._isRegex)
return"/"+this._url+"/"+(!this._isCaseSensitive?"i":"");let displayName=full?this._url:WI.displayNameForURL(this._url,this.urlComponents);if(!this._isCaseSensitive)
displayName=WI.UIString("%s (Case Insensitive)","%s (Case Insensitive) @ Local Override","Label for case-insensitive URL match pattern of a local override.").format(displayName);return displayName;}
generateRequestRedirectURL(url)
{let redirectURL=this._localResource.url;if(!redirectURL)
return null;if(this._isRegex)
return url.replace(this._urlRegex,redirectURL);return redirectURL;}
get canMapToFile()
{if(!WI.LocalResource.canMapToFile())
return false;switch(this._type){case WI.LocalResourceOverride.InterceptType.Block:case WI.LocalResourceOverride.InterceptType.Request:return false;case WI.LocalResourceOverride.InterceptType.Response:case WI.LocalResourceOverride.InterceptType.ResponseSkippingNetwork:return true;}
return false;}
matches(url)
{url=WI.urlWithoutFragment(url);if(this._isRegex)
return this._urlRegex.test(url);if(!this._isCaseSensitive)
return url.toLowerCase()===this._url.toLowerCase();return url===this._url;}
equals(localResourceOverrideOrSerializedData)
{return localResourceOverrideOrSerializedData.url===this._url&&localResourceOverrideOrSerializedData.isCaseSensitive===this._isCaseSensitive&&localResourceOverrideOrSerializedData.isRegex===this._isRegex;}
saveIdentityToCookie(cookie)
{cookie["local-resource-override-url"]=this._url;cookie["local-resource-override-type"]=this._type;cookie["local-resource-override-is-case-sensitive"]=this._isCaseSensitive;cookie["local-resource-override-is-regex"]=this._isRegex;cookie["local-resource-override-disabled"]=this._disabled;}
get _urlRegex()
{return new RegExp(this._url,!this._isCaseSensitive?"i":"");}};WI.LocalResourceOverride.TypeIdentifier="local-resource-override";WI.LocalResourceOverride.InterceptType={Block:"block",Request:"request",Response:"response",ResponseSkippingNetwork:"response-skipping-network",};WI.LocalResourceOverride.ResourceErrorType={AccessControl:"AccessControl",Cancellation:"Cancellation",General:"General",Timeout:"Timeout",};WI.LocalResourceOverride.Event={DisabledChanged:"local-resource-override-disabled-state-did-change",ResourceErrorTypeChanged:"local-resource-override-resource-error-type-changed",};WI.LogObject=class LogObject
{};WI.LoggingChannel=class LoggingChannel
{constructor(source,level)
{this._source=source;this._level=level;}
static fromPayload(payload)
{return new WI.LoggingChannel(payload.source,payload.level);}
get source(){return this._source;}
get level(){return this._level;}};WI.LoggingChannel.Level={Off:"off",Basic:"basic",Verbose:"verbose",};WI.MediaInstrument=class MediaInstrument extends WI.Instrument
{constructor()
{super();}
static supported()
{return InspectorBackend.hasEvent("DOM.didFireEvent");}
get timelineRecordType()
{return WI.TimelineRecord.Type.Media;}
startInstrumentation(initiatedByBackend)
{if(!initiatedByBackend){if(InspectorBackend.hasDomain("Animation")){let target=WI.assumingMainTarget();target.AnimationAgent.startTracking();}}}
stopInstrumentation(initiatedByBackend)
{if(!initiatedByBackend){if(InspectorBackend.hasDomain("Animation")){let target=WI.assumingMainTarget();target.AnimationAgent.stopTracking();}}}};WI.MediaTimeline=class MediaTimeline extends WI.Timeline
{recordForTrackingAnimationId(trackingAnimationId)
{return this._trackingAnimationIdRecordMap.get(trackingAnimationId)||null;}
recordForMediaElementEvents(domNode)
{return this._mediaElementRecordMap.get(domNode)||null;}
reset(suppressEvents)
{this._trackingAnimationIdRecordMap=new Map;this._mediaElementRecordMap=new Map;super.reset(suppressEvents);}
addRecord(record,options={})
{if(record.trackingAnimationId){this._trackingAnimationIdRecordMap.set(record.trackingAnimationId,record);}
if(record.eventType===WI.MediaTimelineRecord.EventType.MediaElement){this._mediaElementRecordMap.set(record.domNode,record);}
super.addRecord(record,options);}};WI.MediaTimelineRecord=class MediaTimelineRecord extends WI.TimelineRecord
{constructor(eventType,domNodeOrInfo,{trackingAnimationId,animationName,transitionProperty}={})
{super(WI.TimelineRecord.Type.Media);this._eventType=eventType;this._domNode=domNodeOrInfo;this._domNodeDisplayName=domNodeOrInfo?.displayName;this._domNodeCSSPath=domNodeOrInfo instanceof WI.DOMNode?WI.cssPath(domNodeOrInfo,{full:true}):domNodeOrInfo?.cssPath;this._trackingAnimationId=trackingAnimationId||null;this._animationName=animationName||null;this._transitionProperty=transitionProperty||null;this._timestamps=[];this._activeStartTime=NaN;}
static async fromJSON(json)
{let{eventType,domNodeDisplayName,domNodeCSSPath,animationName,transitionProperty,timestamps}=json;let documentNode=null;if(InspectorBackend.hasDomain("DOM"))
documentNode=await new Promise((resolve)=>WI.domManager.requestDocument(resolve));let domNode=null;if(documentNode&&domNodeCSSPath){try{let nodeId=await documentNode.querySelector(domNodeCSSPath);if(nodeId)
domNode=WI.domManager.nodeForId(nodeId);}catch{}}
if(!domNode){domNode={displayName:domNodeDisplayName,cssPath:domNodeCSSPath,};}
let record=new MediaTimelineRecord(eventType,domNode,{animationName,transitionProperty});if(Array.isArray(timestamps)&&timestamps.length){record._timestamps=[];for(let item of timestamps){if(item.type===MediaTimelineRecord.TimestampType.MediaElementDOMEvent){if(documentNode&&item.originatorCSSPath){try{let nodeId=await documentNode.querySelector(item.originatorCSSPath);if(nodeId)
item.originator=WI.domManager.nodeForId(nodeId);}catch{}
if(!item.originator){item.originator={displayName:item.originatorDisplayName,cssPath:item.originatorCSSPath,};}}}
record._timestamps.push(item);}}
return record;}
toJSON()
{let json={eventType:this._eventType,domNodeDisplayName:this._domNodeDisplayName,domNodeCSSPath:this._domNodeCSSPath,};if(this._animationName)
json.animationName=this._animationName;if(this._transitionProperty)
json.transitionProperty=this._transitionProperty;if(this._timestamps.length){json.timestamps=this._timestamps.map((item)=>{if(item.type===MediaTimelineRecord.TimestampType.MediaElementDOMEvent&&item.originator instanceof WI.DOMNode)
delete item.originator;return item;});}
return json;}
get eventType(){return this._eventType;}
get domNode(){return this._domNode;}
get trackingAnimationId(){return this._trackingAnimationId;}
get timestamps(){return this._timestamps;}
get activeStartTime(){return this._activeStartTime;}
get updatesDynamically()
{return true;}
get usesActiveStartTime()
{return true;}
get displayName()
{switch(this._eventType){case MediaTimelineRecord.EventType.CSSAnimation:return this._animationName;case MediaTimelineRecord.EventType.CSSTransition:return this._transitionProperty;case MediaTimelineRecord.EventType.MediaElement:return WI.UIString("Media Element");}
console.error("Unknown media record event type: ",this._eventType,this);return WI.UIString("Media Event");}
get subtitle()
{switch(this._eventType){case MediaTimelineRecord.EventType.CSSAnimation:return WI.UIString("CSS Animation");case MediaTimelineRecord.EventType.CSSTransition:return WI.UIString("CSS Transition");}
return"";}
saveIdentityToCookie(cookie)
{super.saveIdentityToCookie(cookie);cookie["media-timeline-record-event-type"]=this._eventType;cookie["media-timeline-record-dom-node"]=this._domNode instanceof WI.DOMNode?this._domNode.path():this._domNode;if(this._animationName)
cookie["media-timeline-record-animation-name"]=this._animationName;if(this._transitionProperty)
cookie["media-timeline-record-transition-property"]=this._transitionProperty;}
updateAnimationState(timestamp,animationState)
{let type;switch(animationState){case InspectorBackend.Enum.Animation.AnimationState.Ready:type=MediaTimelineRecord.TimestampType.CSSAnimationReady;break;case InspectorBackend.Enum.Animation.AnimationState.Delayed:type=MediaTimelineRecord.TimestampType.CSSAnimationDelay;break;case InspectorBackend.Enum.Animation.AnimationState.Active:type=MediaTimelineRecord.TimestampType.CSSAnimationActive;break;case InspectorBackend.Enum.Animation.AnimationState.Canceled:type=MediaTimelineRecord.TimestampType.CSSAnimationCancel;break;case InspectorBackend.Enum.Animation.AnimationState.Done:type=MediaTimelineRecord.TimestampType.CSSAnimationDone;break;}
this._timestamps.push({type,timestamp});this._updateTimes();}
addDOMEvent(timestamp,domEvent)
{let data={type:MediaTimelineRecord.TimestampType.MediaElementDOMEvent,timestamp,eventName:domEvent.eventName,};if(domEvent.originator instanceof WI.DOMNode){data.originator=domEvent.originator;data.originatorDisplayName=data.originator.displayName;data.originatorCSSPath=WI.cssPath(data.originator,{full:true});}
if(!isEmptyObject(domEvent.data))
data.data=domEvent.data;this._timestamps.push(data);this._updateTimes();}
powerEfficientPlaybackStateChanged(timestamp,isPowerEfficient)
{this._timestamps.push({type:MediaTimelineRecord.TimestampType.MediaElementPowerEfficientPlaybackStateChange,timestamp,isPowerEfficient,});this._updateTimes();}
_updateTimes()
{let oldStartTime=this.startTime;let oldEndTime=this.endTime;let firstItem=this._timestamps[0];let lastItem=this._timestamps.lastValue;if(isNaN(this._startTime))
this._startTime=firstItem.timestamp;if(isNaN(this._activeStartTime)){if(this._eventType===MediaTimelineRecord.EventType.MediaElement)
this._activeStartTime=firstItem.timestamp;else if(firstItem.type===MediaTimelineRecord.TimestampType.CSSAnimationActive)
this._activeStartTime=firstItem.timestamp;}
switch(lastItem.type){case MediaTimelineRecord.TimestampType.CSSAnimationCancel:case MediaTimelineRecord.TimestampType.CSSAnimationDone:this._endTime=lastItem.timestamp;break;case MediaTimelineRecord.TimestampType.MediaElementDOMEvent:if(WI.DOMNode.isPlayEvent(lastItem.eventName))
this._endTime=NaN;else if(!isNaN(this._endTime)||WI.DOMNode.isPauseEvent(lastItem.eventName)||WI.DOMNode.isStopEvent(lastItem.eventName))
this._endTime=lastItem.timestamp;break;}
if(this.startTime!==oldStartTime||this.endTime!==oldEndTime)
this.dispatchEventToListeners(WI.TimelineRecord.Event.Updated);}};WI.MediaTimelineRecord.EventType={CSSAnimation:"css-animation",CSSTransition:"css-transition",MediaElement:"media-element",};WI.MediaTimelineRecord.TimestampType={CSSAnimationReady:"css-animation-ready",CSSAnimationDelay:"css-animation-delay",CSSAnimationActive:"css-animation-active",CSSAnimationCancel:"css-animation-cancel",CSSAnimationDone:"css-animation-done",MediaElementDOMEvent:"media-element-dom-event",MediaElementPowerEfficientPlaybackStateChange:"media-element-power-efficient-playback-state-change",};WI.MemoryCategory=class MemoryCategory
{constructor(type,size)
{this.type=type;this.size=size;}};WI.MemoryCategory.Type={JavaScript:"javascript",Images:"images",Layers:"layers",Page:"page",};WI.MemoryInstrument=class MemoryInstrument extends WI.Instrument
{get timelineRecordType()
{return WI.TimelineRecord.Type.Memory;}
startInstrumentation(initiatedByBackend)
{if(!initiatedByBackend){let target=WI.assumingMainTarget();target.MemoryAgent.startTracking();}}
stopInstrumentation(initiatedByBackend)
{if(!initiatedByBackend){let target=WI.assumingMainTarget();target.MemoryAgent.stopTracking();}}};WI.MemoryPressureEvent=class MemoryPressureEvent
{constructor(timestamp,severity)
{this._timestamp=timestamp;this._severity=severity;}
static fromPayload(timestamp,protocolSeverity)
{let severity;switch(protocolSeverity){case InspectorBackend.Enum.Memory.MemoryPressureSeverity.Critical:severity=WI.MemoryPressureEvent.Severity.Critical;break;case InspectorBackend.Enum.Memory.MemoryPressureSeverity.NonCritical:severity=WI.MemoryPressureEvent.Severity.NonCritical;break;default:console.error("Unexpected memory pressure severity",protocolSeverity);severity=WI.MemoryPressureEvent.Severity.NonCritical;break;}
return new WI.MemoryPressureEvent(timestamp,severity);}
static fromJSON(json)
{let{timestamp,severity}=json;return new WI.MemoryPressureEvent(timestamp,severity);}
toJSON()
{return{timestamp:this._timestamp,severity:this._severity,};}
get timestamp(){return this._timestamp;}
get severity(){return this._severity;}};WI.MemoryPressureEvent.Severity={Critical:"critical",NonCritical:"non-critical",};WI.MemoryTimeline=class MemoryTimeline extends WI.Timeline
{get memoryPressureEvents(){return this._pressureEvents;}
addMemoryPressureEvent(memoryPressureEvent)
{this._pressureEvents.push(memoryPressureEvent);this.dispatchEventToListeners(WI.MemoryTimeline.Event.MemoryPressureEventAdded,{memoryPressureEvent});}
reset(suppressEvents)
{super.reset(suppressEvents);this._pressureEvents=[];}
addRecord(record,options={})
{let lastRecord=this.records.lastValue;if(lastRecord){let startTime=lastRecord.endTime;if(options.discontinuity)
startTime=options.discontinuity.endTime;record.adjustStartTime(startTime);}
super.addRecord(record,options);}};WI.MemoryTimeline.Event={MemoryPressureEventAdded:"memory-timeline-memory-pressure-event-added",};WI.MemoryTimelineRecord=class MemoryTimelineRecord extends WI.TimelineRecord
{constructor(timestamp,categories)
{super(WI.TimelineRecord.Type.Memory,timestamp-MemoryTimelineRecord.samplingRatePerSecond,timestamp);this._timestamp=timestamp;this._categories=WI.MemoryTimelineRecord.memoryCategoriesFromProtocol(categories);this._exportCategories=categories;this._totalSize=0;for(let{size}of categories)
this._totalSize+=size;}
static get samplingRatePerSecond()
{return 0.5;}
static memoryCategoriesFromProtocol(categories)
{let javascriptSize=0;let imagesSize=0;let layersSize=0;let pageSize=0;for(let{type,size}of categories){switch(type){case InspectorBackend.Enum.Memory.CategoryDataType.JavaScript:case InspectorBackend.Enum.Memory.CategoryDataType.JIT:javascriptSize+=size;break;case InspectorBackend.Enum.Memory.CategoryDataType.Images:imagesSize+=size;break;case InspectorBackend.Enum.Memory.CategoryDataType.Layers:layersSize+=size;break;case InspectorBackend.Enum.Memory.CategoryDataType.Page:case InspectorBackend.Enum.Memory.CategoryDataType.Other:pageSize+=size;break;default:console.warn("Unhandled Memory.CategoryDataType: "+type);break;}}
return[{type:WI.MemoryCategory.Type.JavaScript,size:javascriptSize},{type:WI.MemoryCategory.Type.Images,size:imagesSize},{type:WI.MemoryCategory.Type.Layers,size:layersSize},{type:WI.MemoryCategory.Type.Page,size:pageSize},];}
static async fromJSON(json)
{let{timestamp,categories}=json;return new WI.MemoryTimelineRecord(timestamp,categories);}
toJSON()
{return{type:this.type,timestamp:this.startTime,categories:this._exportCategories,};}
get timestamp(){return this._timestamp;}
get categories(){return this._categories;}
get totalSize(){return this._totalSize;}
get unadjustedStartTime(){return this._timestamp;}
adjustStartTime(startTime)
{this._startTime=startTime;}};WI.NativeConstructorFunctionParameters={Object:{assign:"target, ...sources",create:"prototype, [propertiesObject]",defineProperties:"object, properties",defineProperty:"object, propertyName, descriptor",freeze:"object",getOwnPropertyDescriptor:"object, propertyName",getOwnPropertyNames:"object",getOwnPropertySymbols:"object",getPrototypeOf:"object",is:"value1, value2",isExtensible:"object",isFrozen:"object",isSealed:"object",keys:"object",preventExtensions:"object",seal:"object",setPrototypeOf:"object, prototype",__proto__:null,},Array:{from:"arrayLike, [mapFunction], [thisArg]",isArray:"object",of:"[...values]",__proto__:null,},ArrayBuffer:{isView:"object",transfer:"oldBuffer, [newByteLength=length]",__proto__:null,},Number:{isFinite:"value",isInteger:"value",isNaN:"value",isSafeInteger:"value",parseFloat:"string",parseInt:"string, [radix]",__proto__:null,},Math:{abs:"x",acos:"x",acosh:"x",asin:"x",asinh:"x",atan2:"y, x",atan:"x",atanh:"x",cbrt:"x",ceil:"x",clz32:"x",cos:"x",cosh:"x",exp:"x",expm1:"x",floor:"x",fround:"x",hypot:"[...x]",imul:"x",log:"x",log1p:"x",log2:"x",log10:"x",max:"[...x]",min:"[...x]",pow:"x, y",round:"x",sign:"x",sin:"x",sinh:"x",sqrt:"x",tan:"x",tanh:"x",trunc:"x",__proto__:null,},JSON:{parse:"text, [reviver]",stringify:"value, [replacer], [space]",__proto__:null,},Date:{parse:"dateString",UTC:"year, [month], [day], [hour], [minute], [second], [ms]",__proto__:null,},Promise:{all:"iterable",race:"iterable",reject:"reason",resolve:"value",__proto__:null,},Reflect:{apply:"target, thisArgument, argumentsList",construct:"target, argumentsList, [newTarget=target]",defineProperty:"target, propertyKey, attributes",deleteProperty:"target, propertyKey",get:"target, propertyKey, [receiver]",getOwnPropertyDescriptor:"target, propertyKey",getPrototypeOf:"target",has:"target, propertyKey",isExtensible:"target",ownKeys:"target",preventExtensions:"target",set:"target, propertyKey, value, [receiver]",setPrototypeOf:"target, prototype",__proto__:null,},String:{fromCharCode:"...codeUnits",fromCodePoint:"...codePoints",raw:"template, ...substitutions",__proto__:null,},Symbol:{for:"key",keyFor:"symbol",__proto__:null,},Console:{assert:"condition, [message], [...values]",count:"label = \"default\"",countReset:"label = \"default\"",debug:"message, [...values]",dir:"object",dirxml:"object",error:"message, [...values]",group:"[name]",groupCollapsed:"[name]",groupEnd:"[name]",info:"message, [...values]",log:"message, [...values]",profile:"name",profileEnd:"name",record:"object, [options]",recordEnd:"object",screenshot:"[node]",table:"data, [columns]",takeHeapSnapshot:"[label]",time:"label = \"default\"",timeLog:"label = \"default\"",timeEnd:"label = \"default\"",timeStamp:"[label]",trace:"message, [...values]",warn:"message, [...values]",__proto__:null,},IDBKeyRangeConstructor:{bound:"lower, upper, [lowerOpen], [upperOpen]",lowerBound:"lower, [open]",only:"value",upperBound:"upper, [open]",__proto__:null,},MediaSourceConstructor:{isTypeSupported:"type",__proto__:null,},MediaStreamTrackConstructor:{getSources:"callback",__proto__:null,},NotificationConstructor:{requestPermission:"[callback]",__proto__:null,},URLConstructor:{createObjectURL:"blob",revokeObjectURL:"url",__proto__:null,},WebKitMediaKeysConstructor:{isTypeSupported:"keySystem, [type]",__proto__:null,},};WI.NativePrototypeFunctionParameters={Object:{__defineGetter__:"propertyName, getterFunction",__defineSetter__:"propertyName, setterFunction",__lookupGetter__:"propertyName",__lookupSetter__:"propertyName",hasOwnProperty:"propertyName",isPrototypeOf:"property",propertyIsEnumerable:"propertyName",__proto__:null,},Array:{concat:"value, ...",copyWithin:"targetIndex, startIndex, [endIndex=length]",every:"callback, [thisArg]",fill:"value, [startIndex=0], [endIndex=length]",filter:"callback, [thisArg]",find:"callback, [thisArg]",findIndex:"callback, [thisArg]",findLast:"callback, [thisArg]",findLastIndex:"callback, [thisArg]",forEach:"callback, [thisArg]",groupBy:"callback, [thisArg]",groupByToMap:"callback, [thisArg]",includes:"searchValue, [startIndex=0]",indexOf:"searchValue, [startIndex=0]",join:"[separator=\",\"]",lastIndexOf:"searchValue, [startIndex=length]",map:"callback, [thisArg]",push:"value, ...",reduce:"callback, [initialValue]",reduceRight:"callback, [initialValue]",slice:"[startIndex=0], [endIndex=length]",some:"callback, [thisArg]",sort:"[compareFunction]",splice:"startIndex, [deleteCount=0], ...itemsToAdd",__proto__:null,},ArrayBuffer:{slice:"startIndex, [endIndex=byteLength]",__proto__:null,},DataView:{setInt8:"byteOffset, value",setInt16:"byteOffset, value, [littleEndian=false]",setInt23:"byteOffset, value, [littleEndian=false]",setUint8:"byteOffset, value",setUint16:"byteOffset, value, [littleEndian=false]",setUint32:"byteOffset, value, [littleEndian=false]",setFloat32:"byteOffset, value, [littleEndian=false]",setFloat64:"byteOffset, value, [littleEndian=false]",getInt8:"byteOffset",getInt16:"byteOffset, [littleEndian=false]",getInt23:"byteOffset, [littleEndian=false]",getUint8:"byteOffset",getUint16:"byteOffset, [littleEndian=false]",getUint32:"byteOffset, [littleEndian=false]",getFloat32:"byteOffset, [littleEndian=false]",getFloat64:"byteOffset, [littleEndian=false]",__proto__:null,},Date:{setDate:"day",setFullYear:"year, [month=getMonth()], [day=getDate()]",setHours:"hours, [minutes=getMinutes()], [seconds=getSeconds()], [ms=getMilliseconds()]",setMilliseconds:"ms",setMinutes:"minutes, [seconds=getSeconds()], [ms=getMilliseconds()]",setMonth:"month, [day=getDate()]",setSeconds:"seconds, [ms=getMilliseconds()]",setTime:"time",setUTCDate:"day",setUTCFullYear:"year, [month=getUTCMonth()], [day=getUTCDate()]",setUTCHours:"hours, [minutes=getUTCMinutes()], [seconds=getUTCSeconds()], [ms=getUTCMilliseconds()]",setUTCMilliseconds:"ms",setUTCMinutes:"minutes, [seconds=getUTCSeconds()], [ms=getUTCMilliseconds()]",setUTCMonth:"month, [day=getUTCDate()]",setUTCSeconds:"seconds, [ms=getUTCMilliseconds()]",setUTCTime:"time",setYear:"year",__proto__:null,},Function:{apply:"thisObject, [argumentsArray]",bind:"thisObject, ...arguments",call:"thisObject, ...arguments",__proto__:null,},Map:{delete:"key",forEach:"callback, [thisArg]",get:"key",has:"key",set:"key, value",__proto__:null,},Number:{toExponential:"[digits]",toFixed:"[digits]",toPrecision:"[significantDigits]",toString:"[radix=10]",__proto__:null,},RegExp:{compile:"pattern, flags",exec:"string",test:"string",__proto__:null,},Set:{delete:"value",forEach:"callback, [thisArg]",has:"value",add:"value",__proto__:null,},String:{charAt:"index",charCodeAt:"index",codePoints:"index",concat:"string, ...",includes:"searchValue, [startIndex=0]",indexOf:"searchValue, [startIndex=0]",lastIndexOf:"searchValue, [startIndex=length]",localeCompare:"string",match:"regex",repeat:"count",replace:"regex|string, replaceString|replaceHandler, [flags]",search:"regex",slice:"startIndex, [endIndex=length]",split:"[separator], [limit]",substr:"startIndex, [numberOfCharacters]",substring:"startIndex, [endIndex=length]",__proto__:null,},WeakMap:{delete:"key",get:"key",has:"key",set:"key, value",__proto__:null,},WeakSet:{delete:"value",has:"value",add:"value",__proto__:null,},Promise:{catch:"rejectionHandler",then:"resolvedHandler, rejectionHandler",__proto__:null,},Generator:{next:"value",return:"value",throw:"exception",__proto__:null,},Element:{closest:"selectors",getAttribute:"attributeName",getAttributeNS:"namespace, attributeName",getAttributeNode:"attributeName",getAttributeNodeNS:"namespace, attributeName",hasAttribute:"attributeName",hasAttributeNS:"namespace, attributeName",matches:"selector",removeAttribute:"attributeName",removeAttributeNS:"namespace, attributeName",removeAttributeNode:"attributeName",scrollIntoView:"[alignWithTop]",scrollIntoViewIfNeeded:"[centerIfNeeded]",setAttribute:"name, value",setAttributeNS:"namespace, name, value",setAttributeNode:"attributeNode",setAttributeNodeNS:"namespace, attributeNode",webkitMatchesSelector:"selectors",__proto__:null,},Node:{appendChild:"child",cloneNode:"[deep]",compareDocumentPosition:"[node]",contains:"[node]",insertBefore:"insertElement, referenceElement",isDefaultNamespace:"[namespace]",isEqualNode:"[node]",lookupNamespaceURI:"prefix",removeChild:"node",replaceChild:"newChild, oldChild",__proto__:null,},Window:{alert:"[message]",atob:"encodedData",btoa:"stringToEncode",cancelAnimationFrame:"id",clearInterval:"intervalId",clearTimeout:"timeoutId",confirm:"[message]",find:"string, [caseSensitive], [backwards], [wrapAround]",getComputedStyle:"[element], [pseudoElement]",getMatchedCSSRules:"[element], [pseudoElement]",matchMedia:"mediaQueryString",moveBy:"[deltaX], [deltaY]",moveTo:"[screenX], [screenY]",open:"url, windowName, [featuresString]",openDatabase:"name, version, displayName, estimatedSize, [creationCallback]",postMessage:"message, targetOrigin, [...transferables]",prompt:"[message], [value]",requestAnimationFrame:"callback",resizeBy:"[deltaX], [deltaY]",resizeTo:"[width], [height]",scrollBy:"[deltaX], [deltaY]",scrollTo:"[x], [y]",setInterval:"func, [delay], [...params]",setTimeout:"func, [delay], [...params]",showModalDialog:"url, [arguments], [options]",__proto__:null,},Document:{adoptNode:"[node]",caretRangeFromPoint:"[x], [y]",createAttribute:"attributeName",createAttributeNS:"namespace, qualifiedName",createCDATASection:"data",createComment:"data",createElement:"tagName",createElementNS:"namespace, qualifiedName",createEntityReference:"name",createEvent:"type",createExpression:"xpath, resolver",createNSResolver:"node",createNodeIterator:"root, whatToShow, filter",createProcessingInstruction:"target, data",createTextNode:"data",createTreeWalker:"root, whatToShow, filter, entityReferenceExpansion",elementFromPoint:"x, y",evaluate:"xpath, contextNode, namespaceResolver, resultType, result",execCommand:"command, userInterface, value",getCSSCanvasContext:"contextId, name, width, height",getElementById:"id",getElementsByName:"name",importNode:"node, deep",queryCommandEnabled:"command",queryCommandIndeterm:"command",queryCommandState:"command",queryCommandSupported:"command",queryCommandValue:"command",__proto__:null,},ANGLEInstancedArrays:{drawArraysInstancedANGLE:"mode, first, count, primcount",drawElementsInstancedANGLE:"mode, count, type, offset, primcount",vertexAttribDivisorANGLE:"index, divisor",__proto__:null,},AnalyserNode:{getByteFrequencyData:"array",getByteTimeDomainData:"array",getFloatFrequencyData:"array",__proto__:null,},AudioBuffer:{getChannelData:"channelIndex",__proto__:null,},AudioBufferCallback:{handleEvent:"audioBuffer",__proto__:null,},AudioBufferSourceNode:{noteGrainOn:"when, grainOffset, grainDuration",noteOff:"when",noteOn:"when",start:"[when], [grainOffset], [grainDuration]",stop:"[when]",__proto__:null,},AudioListener:{setOrientation:"x, y, z, xUp, yUp, zUp",setPosition:"x, y, z",setVelocity:"x, y, z",__proto__:null,},AudioNode:{connect:"destination, [output], [input]",disconnect:"[output]",__proto__:null,},AudioParam:{cancelScheduledValues:"startTime",exponentialRampToValueAtTime:"value, time",linearRampToValueAtTime:"value, time",setTargetAtTime:"target, time, timeConstant",setTargetValueAtTime:"targetValue, time, timeConstant",setValueAtTime:"value, time",setValueCurveAtTime:"values, time, duration",__proto__:null,},AudioTrackList:{getTrackById:"id",item:"index",__proto__:null,},BiquadFilterNode:{getFrequencyResponse:"frequencyHz, magResponse, phaseResponse",__proto__:null,},Blob:{slice:"[start], [end], [contentType]",__proto__:null,},CSS:{supports:"property, value",__proto__:null,},CSSKeyframesRule:{appendRule:"[rule]",deleteRule:"[key]",findRule:"[key]",insertRule:"[rule]",__proto__:null,},CSSMediaRule:{deleteRule:"[index]",insertRule:"[rule], [index]",__proto__:null,},CSSPrimitiveValue:{getFloatValue:"[unitType]",setFloatValue:"[unitType], [floatValue]",setStringValue:"[stringType], [stringValue]",__proto__:null,},CSSRuleList:{item:"[index]",__proto__:null,},CSSStyleDeclaration:{getPropertyCSSValue:"[propertyName]",getPropertyPriority:"[propertyName]",getPropertyShorthand:"[propertyName]",getPropertyValue:"[propertyName]",isPropertyImplicit:"[propertyName]",item:"[index]",removeProperty:"[propertyName]",setProperty:"[propertyName], [value], [priority]",__proto__:null,},CSSStyleSheet:{addRule:"[selector], [style], [index]",deleteRule:"[index]",insertRule:"[rule], [index]",removeRule:"[index]",__proto__:null,},CSSSupportsRule:{deleteRule:"[index]",insertRule:"[rule], [index]",__proto__:null,},CSSValueList:{item:"[index]",__proto__:null,},CanvasGradient:{addColorStop:"[offset], [color]",__proto__:null,},CanvasRenderingContext2D:{arc:"x, y, radius, startAngle, endAngle, [anticlockwise]",arcTo:"x1, y1, x2, y2, radius",bezierCurveTo:"cp1x, cp1y, cp2x, cp2y, x, y",clearRect:"x, y, width, height",clip:"path, [winding]",createImageData:"imagedata",createConicGradient:"angle, x, y",createLinearGradient:"x0, y0, x1, y1",createPattern:"canvas, repetitionType",createRadialGradient:"x0, y0, r0, x1, y1, r1",drawFocusIfNeeded:"element",drawImage:"image, x, y",drawImageFromRect:"image, [sx], [sy], [sw], [sh], [dx], [dy], [dw], [dh], [compositeOperation]",ellipse:"x, y, radiusX, radiusY, rotation, startAngle, endAngle, [anticlockwise]",fill:"path, [winding]",fillRect:"x, y, width, height",fillText:"text, x, y, [maxWidth]",getImageData:"sx, sy, sw, sh",isPointInPath:"path, x, y, [winding]",isPointInStroke:"path, x, y",lineTo:"x, y",measureText:"text",moveTo:"x, y",putImageData:"imagedata, dx, dy",quadraticCurveTo:"cpx, cpy, x, y",rect:"x, y, width, height",rotate:"angle",scale:"sx, sy",setAlpha:"[alpha]",setCompositeOperation:"[compositeOperation]",setFillColor:"color, [alpha]",setLineCap:"[cap]",setLineDash:"dash",setLineJoin:"[join]",setLineWidth:"[width]",setMiterLimit:"[limit]",setShadow:"width, height, blur, [color], [alpha]",setStrokeColor:"color, [alpha]",setTransform:"m11, m12, m21, m22, dx, dy",stroke:"path",strokeRect:"x, y, width, height",strokeText:"text, x, y, [maxWidth]",transform:"m11, m12, m21, m22, dx, dy",translate:"tx, ty",__proto__:null,},CharacterData:{appendData:"[data]",deleteData:"[offset], [length]",insertData:"[offset], [data]",replaceData:"[offset], [length], [data]",substringData:"[offset], [length]",__proto__:null,},CommandLineAPIHost:{copyText:"text",databaseId:"database",getEventListeners:"target",inspect:"objectId, hints",storageId:"storage",__proto__:null,},CompositionEvent:{initCompositionEvent:"[typeArg], [canBubbleArg], [cancelableArg], [viewArg], [dataArg]",__proto__:null,},Crypto:{getRandomValues:"array",__proto__:null,},CustomElementRegistry:{define:"name, constructor",get:"name",whenDefined:"name",__proto__:null,},CustomEvent:{initCustomEvent:"type, [bubbles], [cancelable], [detail]",__proto__:null,},DOMApplicationCache:{__proto__:null,},DOMImplementation:{createCSSStyleSheet:"[title], [media]",createDocument:"[namespaceURI], [qualifiedName], [doctype]",createDocumentType:"[qualifiedName], [publicId], [systemId]",createHTMLDocument:"[title]",hasFeature:"[feature], [version]",__proto__:null,},DOMParser:{parseFromString:"[str], [contentType]",__proto__:null,},DOMStringList:{contains:"[string]",item:"[index]",__proto__:null,},DOMTokenList:{add:"tokens...",contains:"token",item:"index",remove:"tokens...",toggle:"token, [force]",__proto__:null,},DataTransfer:{clearData:"[type]",getData:"type",setData:"type, data",setDragImage:"image, x, y",__proto__:null,},DataTransferItem:{getAsString:"[callback]",__proto__:null,},DataTransferItemList:{add:"file",item:"[index]",__proto__:null,},Database:{changeVersion:"oldVersion, newVersion, [callback], [errorCallback], [successCallback]",readTransaction:"callback, [errorCallback], [successCallback]",transaction:"callback, [errorCallback], [successCallback]",__proto__:null,},DatabaseCallback:{handleEvent:"database",__proto__:null,},DedicatedWorkerGlobalScope:{postMessage:"message, [messagePorts]",__proto__:null,},DeviceMotionEvent:{initDeviceMotionEvent:"[type], [bubbles], [cancelable], [acceleration], [accelerationIncludingGravity], [rotationRate], [interval]",__proto__:null,},DeviceOrientationEvent:{initDeviceOrientationEvent:"[type], [bubbles], [cancelable], [alpha], [beta], [gamma], [absolute]",__proto__:null,},DocumentFragment:{getElementById:"id",querySelector:"selectors",querySelectorAll:"selectors",__proto__:null,},Event:{initEvent:"type, [bubbles], [cancelable]",__proto__:null,},FileList:{item:"index",__proto__:null,},FileReader:{readAsArrayBuffer:"blob",readAsBinaryString:"blob",readAsDataURL:"blob",readAsText:"blob, [encoding]",__proto__:null,},FileReaderSync:{readAsArrayBuffer:"blob",readAsBinaryString:"blob",readAsDataURL:"blob",readAsText:"blob, [encoding]",__proto__:null,},FontFaceSet:{add:"font",check:"font, [text=\" \"]",delete:"font",load:"font, [text=\" \"]",__proto__:null,},FormData:{append:"[name], [value], [filename]",__proto__:null,},Geolocation:{clearWatch:"watchID",getCurrentPosition:"successCallback, [errorCallback], [options]",watchPosition:"successCallback, [errorCallback], [options]",__proto__:null,},HTMLAllCollection:{item:"[index]",namedItem:"name",tags:"name",__proto__:null,},HTMLButtonElement:{setCustomValidity:"error",__proto__:null,},HTMLCanvasElement:{getContext:"contextId",toDataURL:"[type]",__proto__:null,},HTMLCollection:{item:"[index]",namedItem:"[name]",__proto__:null,},HTMLDocument:{write:"[html]",writeln:"[html]",__proto__:null,},HTMLElement:{insertAdjacentElement:"[position], [element]",insertAdjacentHTML:"[position], [html]",insertAdjacentText:"[position], [text]",__proto__:null,},HTMLFieldSetElement:{setCustomValidity:"error",__proto__:null,},HTMLFormControlsCollection:{namedItem:"[name]",__proto__:null,},HTMLInputElement:{setCustomValidity:"error",setRangeText:"replacement",setSelectionRange:"start, end, [direction]",stepDown:"[n]",stepUp:"[n]",__proto__:null,},HTMLKeygenElement:{setCustomValidity:"error",__proto__:null,},HTMLMediaElement:{addTextTrack:"kind, [label], [language]",canPlayType:"[type], [keySystem]",fastSeek:"time",webkitAddKey:"keySystem, key, [initData], [sessionId]",webkitCancelKeyRequest:"keySystem, [sessionId]",webkitGenerateKeyRequest:"keySystem, [initData]",webkitSetMediaKeys:"mediaKeys",__proto__:null,},HTMLObjectElement:{setCustomValidity:"error",__proto__:null,},HTMLOptionsCollection:{add:"element, [before]",namedItem:"[name]",remove:"[index]",__proto__:null,},HTMLOutputElement:{setCustomValidity:"error",__proto__:null,},HTMLSelectElement:{add:"element, [before]",item:"index",namedItem:"[name]",setCustomValidity:"error",__proto__:null,},HTMLSlotElement:{assignedNodes:"[options]",__proto__:null,},HTMLTableElement:{deleteRow:"index",insertRow:"[index]",__proto__:null,},HTMLTableRowElement:{deleteCell:"index",insertCell:"[index]",__proto__:null,},HTMLTableSectionElement:{deleteRow:"index",insertRow:"[index]",__proto__:null,},HTMLTextAreaElement:{setCustomValidity:"error",setRangeText:"replacement",setSelectionRange:"[start], [end], [direction]",__proto__:null,},HTMLVideoElement:{webkitSetPresentationMode:"mode",webkitSupportsPresentationMode:"mode",__proto__:null,},HashChangeEvent:{initHashChangeEvent:"[type], [canBubble], [cancelable], [oldURL], [newURL]",__proto__:null,},History:{go:"[distance]",pushState:"data, title, [url]",replaceState:"data, title, [url]",__proto__:null,},IDBCursor:{advance:"count",continue:"[key]",update:"value",__proto__:null,},IDBDatabase:{createObjectStore:"name, [options]",deleteObjectStore:"name",transaction:"storeName, [mode]",__proto__:null,},IDBFactory:{cmp:"first, second",deleteDatabase:"name",open:"name, [version]",__proto__:null,},IDBIndex:{count:"[range]",get:"key",getKey:"key",openCursor:"[range], [direction]",openKeyCursor:"[range], [direction]",__proto__:null,},IDBObjectStore:{add:"value, [key]",count:"[range]",createIndex:"name, keyPath, [options]",delete:"keyRange",deleteIndex:"name",get:"key",index:"name",openCursor:"[range], [direction]",put:"value, [key]",__proto__:null,},IDBTransaction:{objectStore:"name",__proto__:null,},ImageBitmapRenderingContext:{transferFromImageBitmap:"[bitmap]",__proto__:null,},KeyboardEvent:{initKeyboardEvent:"[type], [canBubble], [cancelable], [view], [keyIdentifier], [location], [ctrlKey], [altKey], [shiftKey], [metaKey], [altGraphKey]",__proto__:null,},Location:{assign:"[url]",reload:"[force=false]",replace:"[url]",__proto__:null,},MediaController:{__proto__:null,},MediaControlsHost:{displayNameForTrack:"track",mediaUIImageData:"partID",setSelectedTextTrack:"track",sortedTrackListForMenu:"trackList",__proto__:null,},MediaList:{appendMedium:"[newMedium]",deleteMedium:"[oldMedium]",item:"[index]",__proto__:null,},MediaQueryList:{addListener:"[listener]",removeListener:"[listener]",__proto__:null,},MediaSource:{addSourceBuffer:"type",endOfStream:"[error]",removeSourceBuffer:"buffer",__proto__:null,},MediaStreamTrack:{applyConstraints:"constraints",__proto__:null,},MediaStreamTrackSourcesCallback:{handleEvent:"sources",__proto__:null,},MessageEvent:{initMessageEvent:"type, [bubbles], [cancelable], [data], [origin], [lastEventId], [source], [messagePorts]",__proto__:null,},MessagePort:{__proto__:null,},MimeTypeArray:{item:"[index]",namedItem:"[name]",__proto__:null,},MouseEvent:{initMouseEvent:"[type], [canBubble], [cancelable], [view], [detail], [screenX], [screenY], [clientX], [clientY], [ctrlKey], [altKey], [shiftKey], [metaKey], [button], [relatedTarget]",__proto__:null,},MutationEvent:{initMutationEvent:"[type], [canBubble], [cancelable], [relatedNode], [prevValue], [newValue], [attrName], [attrChange]",__proto__:null,},MutationObserver:{observe:"target, options",__proto__:null,},NamedNodeMap:{getNamedItem:"[name]",getNamedItemNS:"[namespaceURI], [localName]",item:"[index]",removeNamedItem:"[name]",removeNamedItemNS:"[namespaceURI], [localName]",setNamedItem:"[node]",setNamedItemNS:"[node]",__proto__:null,},Navigator:{getUserMedia:"options, successCallback, errorCallback",__proto__:null,},NavigatorUserMediaErrorCallback:{handleEvent:"error",__proto__:null,},NavigatorUserMediaSuccessCallback:{handleEvent:"stream",__proto__:null,},NodeFilter:{acceptNode:"[n]",__proto__:null,},NodeList:{item:"index",__proto__:null,},Notification:{__proto__:null,},NotificationCenter:{createNotification:"iconUrl, title, body",requestPermission:"[callback]",__proto__:null,},NotificationPermissionCallback:{handleEvent:"permission",__proto__:null,},OESVertexArrayObject:{bindVertexArrayOES:"[arrayObject]",deleteVertexArrayOES:"[arrayObject]",isVertexArrayOES:"[arrayObject]",__proto__:null,},OscillatorNode:{noteOff:"when",noteOn:"when",setPeriodicWave:"wave",start:"[when]",stop:"[when]",__proto__:null,},Path2D:{addPath:"path, [transform]",arc:"[x], [y], [radius], [startAngle], [endAngle], [anticlockwise]",arcTo:"[x1], [y1], [x2], [y2], [radius]",bezierCurveTo:"[cp1x], [cp1y], [cp2x], [cp2y], [x], [y]",ellipse:"x, y, radiusX, radiusY, rotation, startAngle, endAngle, [anticlockwise]",lineTo:"[x], [y]",moveTo:"[x], [y]",quadraticCurveTo:"[cpx], [cpy], [x], [y]",rect:"[x], [y], [width], [height]",__proto__:null,},Performance:{clearMarks:"[name]",clearMeasures:"name",getEntriesByName:"name, [type]",getEntriesByType:"type",mark:"name",measure:"name, [startMark], [endMark]",__proto__:null,},PerformanceObserver:{observe:"options",__proto__:null,},PerformanceObserverEntryList:{getEntriesByName:"name, [type]",getEntriesByType:"type",__proto__:null,},Plugin:{item:"[index]",namedItem:"[name]",__proto__:null,},PluginArray:{item:"[index]",namedItem:"[name]",refresh:"[reload]",__proto__:null,},PositionCallback:{handleEvent:"position",__proto__:null,},PositionErrorCallback:{handleEvent:"error",__proto__:null,},RTCDTMFSender:{insertDTMF:"tones, [duration], [interToneGap]",__proto__:null,},RTCDataChannel:{send:"data",__proto__:null,},RTCPeerConnectionErrorCallback:{handleEvent:"error",__proto__:null,},RTCSessionDescriptionCallback:{handleEvent:"sdp",__proto__:null,},RTCStatsCallback:{handleEvent:"response",__proto__:null,},RTCStatsReport:{stat:"name",__proto__:null,},RTCStatsResponse:{namedItem:"[name]",__proto__:null,},Range:{collapse:"[toStart]",compareBoundaryPoints:"[how], [sourceRange]",compareNode:"[refNode]",comparePoint:"[refNode], [offset]",createContextualFragment:"[html]",expand:"[unit]",insertNode:"[newNode]",intersectsNode:"[refNode]",isPointInRange:"[refNode], [offset]",selectNode:"[refNode]",selectNodeContents:"[refNode]",setEnd:"[refNode], [offset]",setEndAfter:"[refNode]",setEndBefore:"[refNode]",setStart:"[refNode], [offset]",setStartAfter:"[refNode]",setStartBefore:"[refNode]",surroundContents:"[newParent]",__proto__:null,},ReadableStream:{cancel:"reason",pipeThrough:"dest, options",pipeTo:"streams, options",__proto__:null,},WritableStream:{abort:"reason",close:"",write:"chunk",__proto__:null,},RequestAnimationFrameCallback:{handleEvent:"highResTime",__proto__:null,},SQLResultSetRowList:{item:"index",__proto__:null,},SQLStatementCallback:{handleEvent:"transaction, resultSet",__proto__:null,},SQLStatementErrorCallback:{handleEvent:"transaction, error",__proto__:null,},SQLTransaction:{executeSql:"sqlStatement, arguments, [callback], [errorCallback]",__proto__:null,},SQLTransactionCallback:{handleEvent:"transaction",__proto__:null,},SQLTransactionErrorCallback:{handleEvent:"error",__proto__:null,},SVGAngle:{convertToSpecifiedUnits:"unitType",newValueSpecifiedUnits:"unitType, valueInSpecifiedUnits",__proto__:null,},SVGAnimationElement:{beginElementAt:"[offset]",endElementAt:"[offset]",hasExtension:"[extension]",__proto__:null,},SVGColor:{setColor:"colorType, rgbColor, iccColor",setRGBColor:"rgbColor",setRGBColorICCColor:"rgbColor, iccColor",__proto__:null,},SVGCursorElement:{hasExtension:"[extension]",__proto__:null,},SVGDocument:{createEvent:"[eventType]",__proto__:null,},SVGElement:{getPresentationAttribute:"[name]",__proto__:null,},SVGFEDropShadowElement:{setStdDeviation:"[stdDeviationX], [stdDeviationY]",__proto__:null,},SVGFEGaussianBlurElement:{setStdDeviation:"[stdDeviationX], [stdDeviationY]",__proto__:null,},SVGFEMorphologyElement:{setRadius:"[radiusX], [radiusY]",__proto__:null,},SVGFilterElement:{setFilterRes:"[filterResX], [filterResY]",__proto__:null,},SVGGraphicsElement:{getTransformToElement:"[element]",hasExtension:"[extension]",__proto__:null,},SVGLength:{convertToSpecifiedUnits:"unitType",newValueSpecifiedUnits:"unitType, valueInSpecifiedUnits",__proto__:null,},SVGLengthList:{appendItem:"item",getItem:"index",initialize:"item",insertItemBefore:"item, index",removeItem:"index",replaceItem:"item, index",__proto__:null,},SVGMarkerElement:{setOrientToAngle:"[angle]",__proto__:null,},SVGMaskElement:{hasExtension:"[extension]",__proto__:null,},SVGMatrix:{multiply:"secondMatrix",rotate:"angle",rotateFromVector:"x, y",scale:"scaleFactor",scaleNonUniform:"scaleFactorX, scaleFactorY",skewX:"angle",skewY:"angle",translate:"x, y",__proto__:null,},SVGNumberList:{appendItem:"item",getItem:"index",initialize:"item",insertItemBefore:"item, index",removeItem:"index",replaceItem:"item, index",__proto__:null,},SVGPaint:{setPaint:"paintType, uri, rgbColor, iccColor",setUri:"uri",__proto__:null,},SVGPathElement:{createSVGPathSegArcAbs:"[x], [y], [r1], [r2], [angle], [largeArcFlag], [sweepFlag]",createSVGPathSegArcRel:"[x], [y], [r1], [r2], [angle], [largeArcFlag], [sweepFlag]",createSVGPathSegCurvetoCubicAbs:"[x], [y], [x1], [y1], [x2], [y2]",createSVGPathSegCurvetoCubicRel:"[x], [y], [x1], [y1], [x2], [y2]",createSVGPathSegCurvetoCubicSmoothAbs:"[x], [y], [x2], [y2]",createSVGPathSegCurvetoCubicSmoothRel:"[x], [y], [x2], [y2]",createSVGPathSegCurvetoQuadraticAbs:"[x], [y], [x1], [y1]",createSVGPathSegCurvetoQuadraticRel:"[x], [y], [x1], [y1]",createSVGPathSegCurvetoQuadraticSmoothAbs:"[x], [y]",createSVGPathSegCurvetoQuadraticSmoothRel:"[x], [y]",createSVGPathSegLinetoAbs:"[x], [y]",createSVGPathSegLinetoHorizontalAbs:"[x]",createSVGPathSegLinetoHorizontalRel:"[x]",createSVGPathSegLinetoRel:"[x], [y]",createSVGPathSegLinetoVerticalAbs:"[y]",createSVGPathSegLinetoVerticalRel:"[y]",createSVGPathSegMovetoAbs:"[x], [y]",createSVGPathSegMovetoRel:"[x], [y]",getPathSegAtLength:"[distance]",getPointAtLength:"[distance]",__proto__:null,},SVGPathSegList:{appendItem:"newItem",getItem:"index",initialize:"newItem",insertItemBefore:"newItem, index",removeItem:"index",replaceItem:"newItem, index",__proto__:null,},SVGPatternElement:{hasExtension:"[extension]",__proto__:null,},SVGPoint:{matrixTransform:"matrix",__proto__:null,},SVGPointList:{appendItem:"item",getItem:"index",initialize:"item",insertItemBefore:"item, index",removeItem:"index",replaceItem:"item, index",__proto__:null,},SVGSVGElement:{checkEnclosure:"[element], [rect]",checkIntersection:"[element], [rect]",createSVGTransformFromMatrix:"[matrix]",getElementById:"[elementId]",getEnclosureList:"[rect], [referenceElement]",getIntersectionList:"[rect], [referenceElement]",setCurrentTime:"[seconds]",suspendRedraw:"[maxWaitMilliseconds]",unsuspendRedraw:"[suspendHandleId]",__proto__:null,},SVGStringList:{appendItem:"item",getItem:"index",initialize:"item",insertItemBefore:"item, index",removeItem:"index",replaceItem:"item, index",__proto__:null,},SVGTextContentElement:{getCharNumAtPosition:"[point]",getEndPositionOfChar:"[offset]",getExtentOfChar:"[offset]",getRotationOfChar:"[offset]",getStartPositionOfChar:"[offset]",getSubStringLength:"[offset], [length]",selectSubString:"[offset], [length]",__proto__:null,},SVGTransform:{setMatrix:"matrix",setRotate:"angle, cx, cy",setScale:"sx, sy",setSkewX:"angle",setSkewY:"angle",setTranslate:"tx, ty",__proto__:null,},SVGTransformList:{appendItem:"item",createSVGTransformFromMatrix:"matrix",getItem:"index",initialize:"item",insertItemBefore:"item, index",removeItem:"index",replaceItem:"item, index",__proto__:null,},SecurityPolicy:{allowsConnectionTo:"url",allowsFontFrom:"url",allowsFormAction:"url",allowsFrameFrom:"url",allowsImageFrom:"url",allowsMediaFrom:"url",allowsObjectFrom:"url",allowsPluginType:"type",allowsScriptFrom:"url",allowsStyleFrom:"url",__proto__:null,},Selection:{addRange:"[range]",collapse:"[node], [index]",containsNode:"[node], [allowPartial]",extend:"[node], [offset]",getRangeAt:"[index]",modify:"[alter], [direction], [granularity]",selectAllChildren:"[node]",setBaseAndExtent:"[baseNode], [baseOffset], [extentNode], [extentOffset]",setPosition:"[node], [offset]",__proto__:null,},SourceBuffer:{appendBuffer:"data",remove:"start, end",__proto__:null,},SourceBufferList:{item:"index",__proto__:null,},SpeechSynthesis:{speak:"utterance",__proto__:null,},SpeechSynthesisUtterance:{__proto__:null,},Storage:{getItem:"key",key:"index",removeItem:"key",setItem:"key, data",__proto__:null,},StorageErrorCallback:{handleEvent:"error",__proto__:null,},StorageEvent:{initStorageEvent:"[typeArg], [canBubbleArg], [cancelableArg], [keyArg], [oldValueArg], [newValueArg], [urlArg], [storageAreaArg]",__proto__:null,},StorageInfo:{queryUsageAndQuota:"storageType, [usageCallback], [errorCallback]",requestQuota:"storageType, newQuotaInBytes, [quotaCallback], [errorCallback]",__proto__:null,},StorageQuota:{queryUsageAndQuota:"usageCallback, [errorCallback]",requestQuota:"newQuotaInBytes, [quotaCallback], [errorCallback]",__proto__:null,},StorageQuotaCallback:{handleEvent:"grantedQuotaInBytes",__proto__:null,},StorageUsageCallback:{handleEvent:"currentUsageInBytes, currentQuotaInBytes",__proto__:null,},StringCallback:{handleEvent:"data",__proto__:null,},StyleMedia:{matchMedium:"[mediaquery]",__proto__:null,},StyleSheetList:{item:"[index]",__proto__:null,},Text:{replaceWholeText:"[content]",splitText:"offset",__proto__:null,},TextEvent:{initTextEvent:"[typeArg], [canBubbleArg], [cancelableArg], [viewArg], [dataArg]",__proto__:null,},TextTrack:{addCue:"cue",addRegion:"region",removeCue:"cue",removeRegion:"region",__proto__:null,},TextTrackCue:{__proto__:null,},TextTrackCueList:{getCueById:"id",item:"index",__proto__:null,},TextTrackList:{getTrackById:"id",item:"index",__proto__:null,},TimeRanges:{end:"index",start:"index",__proto__:null,},TouchEvent:{initTouchEvent:"[touches], [targetTouches], [changedTouches], [type], [view], [screenX], [screenY], [clientX], [clientY], [ctrlKey], [altKey], [shiftKey], [metaKey]",__proto__:null,},TouchList:{item:"index",__proto__:null,},UIEvent:{initUIEvent:"[type], [canBubble], [cancelable], [view], [detail]",__proto__:null,},UserMessageHandler:{postMessage:"message",__proto__:null,},VTTRegionList:{getRegionById:"id",item:"index",__proto__:null,},VideoTrackList:{getTrackById:"id",item:"index",__proto__:null,},WebGL2RenderingContext:{beginQuery:"target, query",beginTransformFeedback:"primitiveMode",bindBufferBase:"target, index, buffer",bindBufferRange:"target, index, buffer, offset, size",bindSampler:"unit, sampler",bindTransformFeedback:"target, id",bindVertexArray:"vertexArray",blitFramebuffer:"srcX0, srcY0, srcX1, srcY1, dstX0, dstY0, dstX1, dstY1, mask, filter",clearBufferfi:"buffer, drawbuffer, depth, stencil",clearBufferfv:"buffer, drawbuffer, value",clearBufferiv:"buffer, drawbuffer, value",clearBufferuiv:"buffer, drawbuffer, value",clientWaitSync:"sync, flags, timeout",compressedTexImage3D:"target, level, internalformat, width, height, depth, border, imageSize, data",compressedTexSubImage3D:"target, level, xoffset, yoffset, zoffset, width, height, depth, format, imageSize, data",copyBufferSubData:"readTarget, writeTarget, readOffset, writeOffset, size",copyTexSubImage3D:"target, level, xoffset, yoffset, zoffset, x, y, width, height",deleteQuery:"query",deleteSampler:"sampler",deleteSync:"sync",deleteTransformFeedback:"id",deleteVertexArray:"vertexArray",drawArraysInstanced:"mode, first, count, instanceCount",drawBuffers:"buffers",drawElementsInstanced:"mode, count, type, offset, instanceCount",drawRangeElements:"mode, start, end, count, type, offset",endQuery:"target",fenceSync:"condition, flags",framebufferTextureLayer:"target, attachment, texture, level, layer",getActiveUniformBlockName:"program, uniformBlockIndex",getActiveUniformBlockParameter:"program, uniformBlockIndex, pname",getActiveUniforms:"program, uniformIndices, pname",getBufferSubData:"target, offset, returnedData",getFragDataLocation:"program, name",getIndexedParameter:"target, index",getInternalformatParameter:"target, internalformat, pname",getQuery:"target, pname",getQueryParameter:"query, pname",getSamplerParameter:"sampler, pname",getSyncParameter:"sync, pname",getTransformFeedbackVarying:"program, index",getUniformBlockIndex:"program, uniformBlockName",getUniformIndices:"program, uniformNames",invalidateFramebuffer:"target, attachments",invalidateSubFramebuffer:"target, attachments, x, y, width, height",isQuery:"query",isSampler:"sampler",isSync:"sync",isTransformFeedback:"id",isVertexArray:"vertexArray",readBuffer:"src",renderbufferStorageMultisample:"target, samples, internalformat, width, height",samplerParameterf:"sampler, pname, param",samplerParameteri:"sampler, pname, param",texImage3D:"target, level, internalformat, width, height, depth, border, format, type, pixels",texStorage2D:"target, levels, internalformat, width, height",texStorage3D:"target, levels, internalformat, width, height, depth",texSubImage3D:"target, level, xoffset, yoffset, zoffset, width, height, depth, format, type, pixels",transformFeedbackVaryings:"program, varyings, bufferMode",uniform1ui:"location, v0",uniform1uiv:"location, value",uniform2ui:"location, v0, v1",uniform2uiv:"location, value",uniform3ui:"location, v0, v1, v2",uniform3uiv:"location, value",uniform4ui:"location, v0, v1, v2, v3",uniform4uiv:"location, value",uniformBlockBinding:"program, uniformBlockIndex, uniformBlockBinding",uniformMatrix2x3fv:"location, transpose, value",uniformMatrix2x4fv:"location, transpose, value",uniformMatrix3x2fv:"location, transpose, value",uniformMatrix3x4fv:"location, transpose, value",uniformMatrix4x2fv:"location, transpose, value",uniformMatrix4x3fv:"location, transpose, value",vertexAttribDivisor:"index, divisor",vertexAttribI4i:"index, x, y, z, w",vertexAttribI4iv:"index, v",vertexAttribI4ui:"index, x, y, z, w",vertexAttribI4uiv:"index, v",vertexAttribIPointer:"index, size, type, stride, offset",waitSync:"sync, flags, timeout",__proto__:null,},WebGLDebugShaders:{getTranslatedShaderSource:"shader",__proto__:null,},WebGLDrawBuffers:{drawBuffersWEBGL:"buffers",__proto__:null,},WebGLMultiDraw:{multiDrawArraysWebGL:"mode, firstsList, firstsOffset, countsList, countsOffset, drawcount",multiDrawArraysInstancedWebGL:"mode, firstsList, firstsOffset, countsList, countsOffset, instanceCountsList, instanceCountsOffset, drawcount",multiDrawElementsWebGL:"mode, countsList, countsOffset, type, offsetsList, offsetsOffset, drawcount",multiDrawElementsInstancedWebGL:"mode, countsList, countsOffset, type, offsetsList, offsetsOffset, instanceCountsList, instanceCountsOffset, drawcount",__proto__:null,},WebGLRenderingContextBase:{activeTexture:"texture",attachShader:"program, shader",bindAttribLocation:"program, index, name",bindBuffer:"target, buffer",bindFramebuffer:"target, framebuffer",bindRenderbuffer:"target, renderbuffer",bindTexture:"target, texture",blendColor:"red, green, blue, alpha",blendEquation:"mode",blendEquationSeparate:"modeRGB, modeAlpha",blendFunc:"sfactor, dfactor",blendFuncSeparate:"srcRGB, dstRGB, srcAlpha, dstAlpha",bufferData:"target, data, usage",bufferSubData:"target, offset, data",checkFramebufferStatus:"target",clear:"mask",clearColor:"red, green, blue, alpha",clearDepth:"depth",clearStencil:"s",colorMask:"red, green, blue, alpha",compileShader:"shader",compressedTexImage2D:"target, level, internalformat, width, height, border, data",compressedTexSubImage2D:"target, level, xoffset, yoffset, width, height, format, data",copyTexImage2D:"target, level, internalformat, x, y, width, height, border",copyTexSubImage2D:"target, level, xoffset, yoffset, x, y, width, height",createShader:"type",cullFace:"mode",deleteBuffer:"buffer",deleteFramebuffer:"framebuffer",deleteProgram:"program",deleteRenderbuffer:"renderbuffer",deleteShader:"shader",deleteTexture:"texture",depthFunc:"func",depthMask:"flag",depthRange:"zNear, zFar",detachShader:"program, shader",disable:"cap",disableVertexAttribArray:"index",drawArrays:"mode, first, count",drawElements:"mode, count, type, offset",enable:"cap",enableVertexAttribArray:"index",framebufferRenderbuffer:"target, attachment, renderbuffertarget, renderbuffer",framebufferTexture2D:"target, attachment, textarget, texture, level",frontFace:"mode",generateMipmap:"target",getActiveAttrib:"program, index",getActiveUniform:"program, index",getAttachedShaders:"program",getAttribLocation:"program, name",getBufferParameter:"target, pname",getExtension:"name",getFramebufferAttachmentParameter:"target, attachment, pname",getParameter:"pname",getProgramInfoLog:"program",getProgramParameter:"program, pname",getRenderbufferParameter:"target, pname",getShaderInfoLog:"shader",getShaderParameter:"shader, pname",getShaderPrecisionFormat:"shadertype, precisiontype",getShaderSource:"shader",getTexParameter:"target, pname",getUniform:"program, location",getUniformLocation:"program, name",getVertexAttrib:"index, pname",getVertexAttribOffset:"index, pname",hint:"target, mode",isBuffer:"buffer",isEnabled:"cap",isFramebuffer:"framebuffer",isProgram:"program",isRenderbuffer:"renderbuffer",isShader:"shader",isTexture:"texture",lineWidth:"width",linkProgram:"program",pixelStorei:"pname, param",polygonOffset:"factor, units",readPixels:"x, y, width, height, format, type, pixels",renderbufferStorage:"target, internalformat, width, height",sampleCoverage:"value, invert",scissor:"x, y, width, height",shaderSource:"shader, string",stencilFunc:"func, ref, mask",stencilFuncSeparate:"face, func, ref, mask",stencilMask:"mask",stencilMaskSeparate:"face, mask",stencilOp:"fail, zfail, zpass",stencilOpSeparate:"face, fail, zfail, zpass",texImage2D:"target, level, internalformat, width, height, border, format, type, pixels",texParameterf:"target, pname, param",texParameteri:"target, pname, param",texSubImage2D:"target, level, xoffset, yoffset, width, height, format, type, pixels",uniform1f:"location, x",uniform1fv:"location, v",uniform1i:"location, x",uniform1iv:"location, v",uniform2f:"location, x, y",uniform2fv:"location, v",uniform2i:"location, x, y",uniform2iv:"location, v",uniform3f:"location, x, y, z",uniform3fv:"location, v",uniform3i:"location, x, y, z",uniform3iv:"location, v",uniform4f:"location, x, y, z, w",uniform4fv:"location, v",uniform4i:"location, x, y, z, w",uniform4iv:"location, v",uniformMatrix2fv:"location, transpose, array",uniformMatrix3fv:"location, transpose, array",uniformMatrix4fv:"location, transpose, array",useProgram:"program",validateProgram:"program",vertexAttrib1f:"indx, x",vertexAttrib1fv:"indx, values",vertexAttrib2f:"indx, x, y",vertexAttrib2fv:"indx, values",vertexAttrib3f:"indx, x, y, z",vertexAttrib3fv:"indx, values",vertexAttrib4f:"indx, x, y, z, w",vertexAttrib4fv:"indx, values",vertexAttribPointer:"indx, size, type, normalized, stride, offset",viewport:"x, y, width, height",__proto__:null,},WebKitCSSMatrix:{multiply:"[secondMatrix]",rotate:"[rotX], [rotY], [rotZ]",rotateAxisAngle:"[x], [y], [z], [angle]",scale:"[scaleX], [scaleY], [scaleZ]",setMatrixValue:"[string]",skewX:"[angle]",skewY:"[angle]",translate:"[x], [y], [z]",__proto__:null,},WebKitMediaKeySession:{update:"key",__proto__:null,},WebKitMediaKeys:{createSession:"[type], [initData]",__proto__:null,},WebKitNamedFlow:{getRegionsByContent:"contentNode",__proto__:null,},WebKitNamedFlowCollection:{item:"index",namedItem:"name",__proto__:null,},WebKitSubtleCrypto:{decrypt:"algorithm, key, data",digest:"algorithm, data",encrypt:"algorithm, key, data",exportKey:"format, key",generateKey:"algorithm, [extractable], [keyUsages]",importKey:"format, keyData, algorithm, [extractable], [keyUsages]",sign:"algorithm, key, data",unwrapKey:"format, wrappedKey, unwrappingKey, unwrapAlgorithm, unwrappedKeyAlgorithm, [extractable], [keyUsages]",verify:"algorithm, key, signature, data",wrapKey:"format, key, wrappingKey, wrapAlgorithm",__proto__:null,},WebSocket:{close:"[code], [reason]",send:"data",__proto__:null,},WheelEvent:{initWebKitWheelEvent:"[wheelDeltaX], [wheelDeltaY], [view], [screenX], [screenY], [clientX], [clientY], [ctrlKey], [altKey], [shiftKey], [metaKey]",__proto__:null,},Worker:{postMessage:"message, [messagePorts]",__proto__:null,},WorkerGlobalScope:{clearInterval:"[handle]",clearTimeout:"[handle]",setInterval:"handler, [timeout]",setTimeout:"handler, [timeout]",__proto__:null,},XMLHttpRequest:{getResponseHeader:"header",open:"method, url, [async], [user], [password]",overrideMimeType:"override",setRequestHeader:"header, value",__proto__:null,},XMLHttpRequestUpload:{__proto__:null,},XMLSerializer:{serializeToString:"[node]",__proto__:null,},XPathEvaluator:{createExpression:"[expression], [resolver]",createNSResolver:"[nodeResolver]",evaluate:"[expression], [contextNode], [resolver], [type], [inResult]",__proto__:null,},XPathExpression:{evaluate:"[contextNode], [type], [inResult]",__proto__:null,},XPathNSResolver:{lookupNamespaceURI:"[prefix]",__proto__:null,},XPathResult:{snapshotItem:"[index]",__proto__:null,},XSLTProcessor:{getParameter:"namespaceURI, localName",importStylesheet:"[stylesheet]",removeParameter:"namespaceURI, localName",setParameter:"namespaceURI, localName, value",transformToDocument:"[source]",transformToFragment:"[source], [docVal]",__proto__:null,},webkitAudioContext:{createBuffer:"numberOfChannels, numberOfFrames, sampleRate",createChannelMerger:"[numberOfInputs]",createChannelSplitter:"[numberOfOutputs]",createDelay:"[maxDelayTime]",createDelayNode:"[maxDelayTime]",createJavaScriptNode:"bufferSize, [numberOfInputChannels], [numberOfOutputChannels]",createMediaElementSource:"mediaElement",createPeriodicWave:"real, imag",createScriptProcessor:"bufferSize, [numberOfInputChannels], [numberOfOutputChannels]",decodeAudioData:"audioData, successCallback, [errorCallback]",__proto__:null,},webkitAudioPannerNode:{setOrientation:"x, y, z",setPosition:"x, y, z",setVelocity:"x, y, z",__proto__:null,},webkitMediaStream:{addTrack:"track",getTrackById:"trackId",removeTrack:"track",__proto__:null,},webkitRTCPeerConnection:{addIceCandidate:"candidate, successCallback, failureCallback",addStream:"stream",createAnswer:"successCallback, failureCallback, [answerOptions]",createDTMFSender:"track",createDataChannel:"label, [options]",createOffer:"successCallback, failureCallback, [offerOptions]",getStats:"successCallback, failureCallback, [selector]",getStreamById:"streamId",removeStream:"stream",setLocalDescription:"description, successCallback, failureCallback",setRemoteDescription:"description, successCallback, failureCallback",updateIce:"configuration",__proto__:null,},EventTarget:{addEventListener:"type, listener, [useCapture=false]",removeEventListener:"type, listener, [useCapture=false]",dispatchEvent:"event",__proto__:null,},};(function(){var ElementQueries={getElementsByClassName:"classNames",getElementsByTagName:"tagName",getElementsByTagNameNS:"namespace, localName",querySelector:"selectors",querySelectorAll:"selectors",};Object.assign(WI.NativePrototypeFunctionParameters.Element,ElementQueries);Object.assign(WI.NativePrototypeFunctionParameters.Document,ElementQueries);var ChildNode={after:"[node|string]...",before:"[node|string]...",replaceWith:"[node|string]...",};Object.assign(WI.NativePrototypeFunctionParameters.Element,ChildNode);Object.assign(WI.NativePrototypeFunctionParameters.CharacterData,ChildNode);var ParentNode={append:"[node|string]...",prepend:"[node|string]...",};Object.assign(WI.NativePrototypeFunctionParameters.Element,ParentNode);Object.assign(WI.NativePrototypeFunctionParameters.Document,ParentNode);Object.assign(WI.NativePrototypeFunctionParameters.DocumentFragment,ParentNode);})();WI.NetworkInstrument=class NetworkInstrument extends WI.Instrument
{get timelineRecordType()
{return WI.TimelineRecord.Type.Network;}
startInstrumentation(initiatedByBackend)
{}
stopInstrumentation(initiatedByBackend)
{}};WI.NetworkTimeline=class NetworkTimeline extends WI.Timeline
{recordForResource(resource)
{return this._resourceRecordMap.get(resource)||null;}
reset(suppressEvents)
{this._resourceRecordMap=new Map;super.reset(suppressEvents);}
addRecord(record,options={})
{if(this._resourceRecordMap.has(record.resource))
return;this._resourceRecordMap.set(record.resource,record);super.addRecord(record,options);}};WI.ObjectPreview=class ObjectPreview
{constructor(type,subtype,description,lossless,overflow,properties,entries,size)
{this._type=type;this._subtype=subtype;this._description=description||"";this._lossless=lossless;this._overflow=overflow||false;this._size=size;this._properties=properties||null;this._entries=entries||null;}
static fromPayload(payload)
{if(payload.properties)
payload.properties=payload.properties.map(WI.PropertyPreview.fromPayload);if(payload.entries)
payload.entries=payload.entries.map(WI.CollectionEntryPreview.fromPayload);return new WI.ObjectPreview(payload.type,payload.subtype,payload.description,payload.lossless,payload.overflow,payload.properties,payload.entries,payload.size);}
get type(){return this._type;}
get subtype(){return this._subtype;}
get description(){return this._description;}
get lossless(){return this._lossless;}
get overflow(){return this._overflow;}
get propertyPreviews(){return this._properties;}
get collectionEntryPreviews(){return this._entries;}
get size(){return this._size;}
hasSize()
{return this._size!==undefined&&(this._subtype==="array"||this._subtype==="set"||this._subtype==="map"||this._subtype==="weakmap"||this._subtype==="weakset");}};WI.ProbeSample=class ProbeSample
{constructor(sampleId,batchId,elapsedTime,object)
{this.sampleId=sampleId;this.batchId=batchId;this.timestamp=elapsedTime;this.object=object;}};WI.Probe=class Probe extends WI.Object
{constructor(id,breakpoint,expression)
{super();this._id=id;this._breakpoint=breakpoint;this._expression=expression;this._samples=[];}
get id()
{return this._id;}
get breakpoint()
{return this._breakpoint;}
get expression()
{return this._expression;}
set expression(value)
{if(this._expression===value)
return;var data={oldValue:this._expression,newValue:value};this._expression=value;this.clearSamples();this.dispatchEventToListeners(WI.Probe.Event.ExpressionChanged,data);}
get samples()
{return this._samples.slice();}
clearSamples()
{this._samples=[];this.dispatchEventToListeners(WI.Probe.Event.SamplesCleared);}
addSample(sample)
{this._samples.push(sample);this.dispatchEventToListeners(WI.Probe.Event.SampleAdded,sample);}};WI.Probe.Event={ExpressionChanged:"probe-object-expression-changed",SampleAdded:"probe-object-sample-added",SamplesCleared:"probe-object-samples-cleared"};WI.ProbeSet=class ProbeSet extends WI.Object
{constructor(breakpoint)
{super();this._breakpoint=breakpoint;this._probes=[];this._probesByIdentifier=new Map;this._createDataTable();WI.Frame.addEventListener(WI.Frame.Event.MainResourceDidChange,this._mainResourceChanged,this);WI.Probe.addEventListener(WI.Probe.Event.SampleAdded,this._sampleCollected,this);}
get breakpoint(){return this._breakpoint;}
get probes(){return this._probes.slice();}
get dataTable(){return this._dataTable;}
clear()
{this._breakpoint.clearActions(WI.BreakpointAction.Type.Probe);}
clearSamples()
{for(var probe of this._probes)
probe.clearSamples();var oldTable=this._dataTable;this._createDataTable();this.dispatchEventToListeners(WI.ProbeSet.Event.SamplesCleared,{oldTable});}
createProbe(expression)
{this._breakpoint.addAction(new WI.BreakpointAction(WI.BreakpointAction.Type.Probe,{data:expression}));}
addProbe(probe)
{this._probes.push(probe);this._probesByIdentifier.set(probe.id,probe);this.dataTable.addProbe(probe);this.dispatchEventToListeners(WI.ProbeSet.Event.ProbeAdded,probe);}
removeProbe(probe)
{this._probes.splice(this._probes.indexOf(probe),1);this._probesByIdentifier.delete(probe.id);this.dataTable.removeProbe(probe);this.dispatchEventToListeners(WI.ProbeSet.Event.ProbeRemoved,probe);}
willRemove()
{WI.Frame.removeEventListener(WI.Frame.Event.MainResourceDidChange,this._mainResourceChanged,this);WI.Probe.removeEventListener(WI.Probe.Event.SampleAdded,this._sampleCollected,this);}
_mainResourceChanged()
{this.dataTable.mainResourceChanged();}
_createDataTable()
{if(this.dataTable)
this.dataTable.willRemove();this._dataTable=new WI.ProbeSetDataTable(this);}
_sampleCollected(event)
{var sample=event.data;var probe=event.target;if(!this._probesByIdentifier.has(probe.id))
return;this.dataTable.addSampleForProbe(probe,sample);this.dispatchEventToListeners(WI.ProbeSet.Event.SampleAdded,{probe,sample});}};WI.ProbeSet.Event={ProbeAdded:"probe-set-probe-added",ProbeRemoved:"probe-set-probe-removed",SampleAdded:"probe-set-sample-added",SamplesCleared:"probe-set-samples-cleared",};WI.ProbeSetDataFrame=class ProbeSetDataFrame
{constructor(index)
{this._count=0;this._index=index;this._separator=false;}
static compare(a,b)
{return a.index-b.index;}
get key()
{return String(this._index);}
get count()
{return this._count;}
get index()
{return this._index;}
get isSeparator()
{return this._separator;}
set isSeparator(value)
{this._separator=!!value;}
addSampleForProbe(probe,sample)
{this[probe.id]=sample;this._count++;}
missingKeys(probeSet)
{return probeSet.probes.filter(function(probe){return!this.hasOwnProperty(probe.id);},this);}
isComplete(probeSet)
{return!this.missingKeys(probeSet).length;}
fillMissingValues(probeSet)
{for(var key of this.missingKeys(probeSet))
this[key]=WI.ProbeSetDataFrame.MissingValue;}};WI.ProbeSetDataFrame.MissingValue="?";WI.ProbeSetDataTable=class ProbeSetDataTable extends WI.Object
{constructor(probeSet)
{super();this._probeSet=probeSet;this._frames=[];this._previousBatchIdentifier=WI.ProbeSetDataTable.SentinelValue;}
get frames()
{return this._frames.slice();}
get separators()
{return this._frames.filter(function(frame){return frame.isSeparator;});}
willRemove()
{this.dispatchEventToListeners(WI.ProbeSetDataTable.Event.WillRemove);this._frames=[];delete this._probeSet;}
mainResourceChanged()
{this.addSeparator();}
addSampleForProbe(probe,sample)
{if(sample.batchId!==this._previousBatchIdentifier){if(this._openFrame){this._openFrame.fillMissingValues(this._probeSet);this.addFrame(this._openFrame);}
this._openFrame=this.createFrame();this._previousBatchIdentifier=sample.batchId;}
this._openFrame.addSampleForProbe(probe,sample);if(this._openFrame.count===this._probeSet.probes.length){this.addFrame(this._openFrame);this._openFrame=null;}}
addProbe(probe)
{for(var frame of this.frames)
if(!frame[probe.id])
frame[probe.id]=WI.ProbeSetDataTable.UnknownValue;}
removeProbe(probe)
{for(var frame of this.frames)
delete frame[probe.id];}
createFrame()
{return new WI.ProbeSetDataFrame(this._frames.length);}
addFrame(frame)
{this._frames.push(frame);this.dispatchEventToListeners(WI.ProbeSetDataTable.Event.FrameInserted,frame);}
addSeparator()
{if(!this._frames.length)
return;var previousFrame=this._frames.lastValue;if(previousFrame.isSeparator)
return;previousFrame.isSeparator=true;this.dispatchEventToListeners(WI.ProbeSetDataTable.Event.SeparatorInserted,previousFrame);}};WI.ProbeSetDataTable.Event={FrameInserted:"probe-set-data-table-frame-inserted",SeparatorInserted:"probe-set-data-table-separator-inserted",WillRemove:"probe-set-data-table-will-remove"};WI.ProbeSetDataTable.SentinelValue=-1;WI.ProbeSetDataTable.UnknownValue="?";WI.Profile=class Profile
{constructor(topDownRootNodes)
{topDownRootNodes=topDownRootNodes||[];this._topDownRootNodes=topDownRootNodes;}
get topDownRootNodes()
{return this._topDownRootNodes;}
get bottomUpRootNodes()
{return[];}};WI.ProfileNode=class ProfileNode
{constructor(id,type,functionName,sourceCodeLocation,callInfo,childNodes)
{childNodes=childNodes||[];this._id=id;this._type=type||WI.ProfileNode.Type.Function;this._functionName=functionName||null;this._sourceCodeLocation=sourceCodeLocation||null;this._callInfo=callInfo;this._childNodes=childNodes;this._parentNode=null;this._previousSibling=null;this._nextSibling=null;this._computedTotalTimes=false;this._startTime=this._callInfo.startTime;this._endTime=this._callInfo.endTime;this._totalTime=this._callInfo.totalTime;this._callCount=this._callInfo.callCount;for(var i=0;i<this._childNodes.length;++i)
this._childNodes[i].establishRelationships(this,this._childNodes[i-1],this._childNodes[i+1]);}
get id(){return this._id;}
get type(){return this._type;}
get functionName(){return this._functionName;}
get sourceCodeLocation(){return this._sourceCodeLocation;}
get callInfo(){return this._callInfo;}
get previousSibling(){return this._previousSibling;}
get nextSibling(){return this._nextSibling;}
get parentNode(){return this._parentNode;}
get childNodes(){return this._childNodes;}
get startTime(){return this._startTime;}
get endTime(){return this._endTime;}
get selfTime()
{this._computeTotalTimesIfNeeded();return this._selfTime;}
get totalTime()
{this._computeTotalTimesIfNeeded();return this._totalTime;}
computeCallInfoForTimeRange(rangeStartTime,rangeEndTime)
{if(this._selfTime===undefined){var childNodesTotalTime=0;for(var childNode of this._childNodes)
childNodesTotalTime+=childNode.totalTime;this._selfTime=this._totalTime-childNodesTotalTime;if(this._selfTime<0.0001)
this._selfTime=0.0;}
return{callCount:this._callCount,startTime:this._startTime,endTime:this._endTime,selfTime:this._selfTime,totalTime:this._totalTime,averageTime:this._selfTime/this._callCount,};}
traverseNextProfileNode(stayWithin)
{var profileNode=this._childNodes[0];if(profileNode)
return profileNode;if(this===stayWithin)
return null;profileNode=this._nextSibling;if(profileNode)
return profileNode;profileNode=this;while(profileNode&&!profileNode.nextSibling&&profileNode.parentNode!==stayWithin)
profileNode=profileNode.parentNode;if(!profileNode)
return null;return profileNode.nextSibling;}
saveIdentityToCookie(cookie)
{cookie[WI.ProfileNode.TypeCookieKey]=this._type||null;cookie[WI.ProfileNode.FunctionNameCookieKey]=this._functionName||null;cookie[WI.ProfileNode.SourceCodeURLCookieKey]=this._sourceCodeLocation?this._sourceCodeLocation.sourceCode.url?this._sourceCodeLocation.sourceCode.url.hash:null:null;cookie[WI.ProfileNode.SourceCodeLocationLineCookieKey]=this._sourceCodeLocation?this._sourceCodeLocation.lineNumber:null;cookie[WI.ProfileNode.SourceCodeLocationColumnCookieKey]=this._sourceCodeLocation?this._sourceCodeLocation.columnNumber:null;}
establishRelationships(parentNode,previousSibling,nextSibling)
{this._parentNode=parentNode||null;this._previousSibling=previousSibling||null;this._nextSibling=nextSibling||null;}
_computeTotalTimesIfNeeded()
{if(this._computedTotalTimes)
return;this._computedTotalTimes=true;var info=this.computeCallInfoForTimeRange(0,Infinity);this._startTime=info.startTime;this._endTime=info.endTime;this._selfTime=info.selfTime;this._totalTime=info.totalTime;}};WI.ProfileNode.Type={Function:"profile-node-type-function",Program:"profile-node-type-program"};WI.ProfileNode.TypeIdentifier="profile-node";WI.ProfileNode.TypeCookieKey="profile-node-type";WI.ProfileNode.FunctionNameCookieKey="profile-node-function-name";WI.ProfileNode.SourceCodeURLCookieKey="profile-node-source-code-url";WI.ProfileNode.SourceCodeLocationLineCookieKey="profile-node-source-code-location-line";WI.ProfileNode.SourceCodeLocationColumnCookieKey="profile-node-source-code-location-column";WI.ProfileNodeCall=class ProfileNodeCall
{constructor(startTime,totalTime)
{this._startTime=startTime;this._totalTime=totalTime||0;this._parentNode=null;this._previousSibling=null;this._nextSibling=null;}
get startTime()
{return this._startTime;}
get totalTime()
{return this._totalTime;}
get endTime()
{return this._startTime+this._totalTime;}
establishRelationships(parentNode,previousSibling,nextSibling)
{this._parentNode=parentNode||null;this._previousSibling=previousSibling||null;this._nextSibling=nextSibling||null;}};WI.PropertyDescriptor=class PropertyDescriptor
{constructor(descriptor,symbol,isOwnProperty,wasThrown,nativeGetter,isInternalProperty)
{this._name=descriptor.name;this._value=descriptor.value;this._hasValue="value"in descriptor;this._get=descriptor.get;this._set=descriptor.set;this._symbol=symbol;this._writable=descriptor.writable||false;this._configurable=descriptor.configurable||false;this._enumerable=descriptor.enumerable||false;this._own=isOwnProperty||false;this._wasThrown=wasThrown||false;this._nativeGetterValue=nativeGetter||false;this._internal=isInternalProperty||false;}
static fromPayload(payload,internal,target)
{if(payload.value)
payload.value=WI.RemoteObject.fromPayload(payload.value,target);if(payload.get)
payload.get=WI.RemoteObject.fromPayload(payload.get,target);if(payload.set)
payload.set=WI.RemoteObject.fromPayload(payload.set,target);if(payload.symbol)
payload.symbol=WI.RemoteObject.fromPayload(payload.symbol,target);if(internal){payload.writable=payload.configurable=payload.enumerable=false;payload.isOwn=true;}
return new WI.PropertyDescriptor(payload,payload.symbol,payload.isOwn,payload.wasThrown,payload.nativeGetter,internal);}
get name(){return this._name;}
get value(){return this._value;}
get get(){return this._get;}
get set(){return this._set;}
get writable(){return this._writable;}
get configurable(){return this._configurable;}
get enumerable(){return this._enumerable;}
get symbol(){return this._symbol;}
get isOwnProperty(){return this._own;}
get wasThrown(){return this._wasThrown;}
get nativeGetter(){return this._nativeGetterValue;}
get isInternalProperty(){return this._internal;}
hasValue()
{return this._hasValue;}
hasGetter()
{return this._get&&this._get.type==="function";}
hasSetter()
{return this._set&&this._set.type==="function";}
isIndexProperty()
{return!isNaN(Number(this._name));}
isSymbolProperty()
{return!!this._symbol;}};WI.PropertyPath=class PropertyPath
{constructor(object,pathComponent,parent,isPrototype)
{if(parent&&!parent.object)
throw new Error("Attempted to append to a PropertyPath with null object.");this._object=object;this._pathComponent=typeof pathComponent==="string"?pathComponent:null;this._parent=parent||null;this._isPrototype=isPrototype||false;}
static emptyPropertyPathForScope(object)
{return new WI.PropertyPath(object,WI.PropertyPath.SpecialPathComponent.EmptyPathComponentForScope);}
get object(){return this._object;}
get parent(){return this._parent;}
get isPrototype(){return this._isPrototype;}
get pathComponent(){return this._pathComponent;}
set pathComponent(pathComponent){this._pathComponent=pathComponent;}
get rootObject()
{return this._parent?this._parent.rootObject:this._object;}
get lastNonPrototypeObject()
{if(!this._parent)
return this._object;var p=this._parent;while(p){if(!p.isPrototype)
break;if(!p.parent)
break;p=p.parent;}
return p.object;}
get fullPath()
{var components=[];for(var p=this;p&&p.pathComponent;p=p.parent)
components.push(p.pathComponent);components.reverse();return components.join("");}
get reducedPath()
{var components=[];var p=this;for(;p&&p.isPrototype;p=p.parent)
components.push(p.pathComponent);for(;p&&p.pathComponent;p=p.parent){if(p.isPrototype)
continue;components.push(p.pathComponent);}
components.reverse();return components.join("");}
displayPath(type)
{return type===WI.PropertyPath.Type.Value?this.reducedPath:this.fullPath;}
isRoot()
{return!this._parent;}
isScope()
{return this._pathComponent===WI.PropertyPath.SpecialPathComponent.EmptyPathComponentForScope;}
isPathComponentImpossible()
{return this._pathComponent&&this._pathComponent.startsWith("@");}
isFullPathImpossible()
{if(this.isPathComponentImpossible())
return true;if(this._parent)
return this._parent.isFullPathImpossible();return false;}
appendPropertyName(object,propertyName)
{var isPrototype=propertyName==="__proto__";if(this.isScope())
return new WI.PropertyPath(object,propertyName,this,isPrototype);var component=this._canPropertyNameBeDotAccess(propertyName)?"."+propertyName:"["+doubleQuotedString(propertyName)+"]";return new WI.PropertyPath(object,component,this,isPrototype);}
appendPropertySymbol(object,symbolName)
{var component=WI.PropertyPath.SpecialPathComponent.SymbolPropertyName+(symbolName.length?"("+symbolName+")":"");return new WI.PropertyPath(object,component,this);}
appendInternalPropertyName(object,propertyName)
{var component=WI.PropertyPath.SpecialPathComponent.InternalPropertyName+"["+propertyName+"]";return new WI.PropertyPath(object,component,this);}
appendGetterPropertyName(object,propertyName)
{var component=".__lookupGetter__("+doubleQuotedString(propertyName)+")";return new WI.PropertyPath(object,component,this);}
appendSetterPropertyName(object,propertyName)
{var component=".__lookupSetter__("+doubleQuotedString(propertyName)+")";return new WI.PropertyPath(object,component,this);}
appendArrayIndex(object,indexString)
{var component="["+indexString+"]";return new WI.PropertyPath(object,component,this);}
appendMapKey(object)
{var component=WI.PropertyPath.SpecialPathComponent.MapKey;return new WI.PropertyPath(object,component,this);}
appendMapValue(object,keyObject)
{if(keyObject&&keyObject.hasValue()){if(keyObject.type==="string"){var component=".get("+doubleQuotedString(keyObject.description)+")";return new WI.PropertyPath(object,component,this);}
var component=".get("+keyObject.description+")";return new WI.PropertyPath(object,component,this);}
var component=WI.PropertyPath.SpecialPathComponent.MapValue;return new WI.PropertyPath(object,component,this);}
appendSetIndex(object)
{var component=WI.PropertyPath.SpecialPathComponent.SetIndex;return new WI.PropertyPath(object,component,this);}
appendSymbolProperty(object)
{var component=WI.PropertyPath.SpecialPathComponent.SymbolPropertyName;return new WI.PropertyPath(object,component,this);}
appendPropertyDescriptor(object,descriptor,type)
{if(descriptor.isInternalProperty)
return this.appendInternalPropertyName(object,descriptor.name);if(descriptor.symbol)
return this.appendSymbolProperty(object);if(type===WI.PropertyPath.Type.Getter)
return this.appendGetterPropertyName(object,descriptor.name);if(type===WI.PropertyPath.Type.Setter)
return this.appendSetterPropertyName(object,descriptor.name);if(this._object.subtype==="array"&&!isNaN(parseInt(descriptor.name)))
return this.appendArrayIndex(object,descriptor.name);return this.appendPropertyName(object,descriptor.name);}
_canPropertyNameBeDotAccess(propertyName)
{return /^(?![0-9])\w+$/.test(propertyName);}};WI.PropertyPath.SpecialPathComponent={InternalPropertyName:"@internal",SymbolPropertyName:"@symbol",MapKey:"@mapkey",MapValue:"@mapvalue",SetIndex:"@setindex",EmptyPathComponentForScope:"",};WI.PropertyPath.Type={Value:"value",Getter:"getter",Setter:"setter",};WI.PropertyPreview=class PropertyPreview
{constructor(name,type,subtype,value,valuePreview,isInternalProperty)
{this._name=name;this._type=type;this._subtype=subtype;this._value=value;this._valuePreview=valuePreview;this._internal=isInternalProperty;}
static fromPayload(payload)
{if(payload.valuePreview)
payload.valuePreview=WI.ObjectPreview.fromPayload(payload.valuePreview);return new WI.PropertyPreview(payload.name,payload.type,payload.subtype,payload.value,payload.valuePreview,payload.internal);}
get name(){return this._name;}
get type(){return this._type;}
get subtype(){return this._subtype;}
get value(){return this._value;}
get valuePreview(){return this._valuePreview;}
get internal(){return this._internal;}};WI.QueryMatch=class QueryMatch
{constructor(type,index,queryIndex)
{this._type=type;this._index=index;this._queryIndex=queryIndex;}
get type(){return this._type;}
get index(){return this._index;}
get queryIndex(){return this._queryIndex;}};WI.QueryMatch.Type={Normal:Symbol("normal"),Special:Symbol("special"),};WI.QueryResult=class QueryResult
{constructor(value,matches)
{this._value=value;this._matches=matches;}
get value(){return this._value;}
get matches(){return this._matches;}
get rank()
{if(this._rank===undefined)
this._calculateRank();return this._rank;}
get matchingTextRanges()
{this._matchingTextRanges??=this._createMatchingTextRanges();return this._matchingTextRanges;}
_calculateRank()
{const normalWeight=10;const consecutiveWeight=5;const specialMultiplier=5;function getMultiplier(match){if(match.type===WI.QueryMatch.Type.Special)
return specialMultiplier;return 1;}
this._rank=0;let previousMatch=null;let consecutiveMatchStart=null;for(let match of this._matches){this._rank+=normalWeight*getMultiplier(match);let consecutive=previousMatch&&previousMatch.index===match.index-1;if(consecutive){if(!consecutiveMatchStart)
consecutiveMatchStart=previousMatch;this._rank+=consecutiveWeight*getMultiplier(consecutiveMatchStart)*(match.index-consecutiveMatchStart.index);}else if(consecutiveMatchStart)
consecutiveMatchStart=null;previousMatch=match;if(!consecutive)
this._rank-=match.index*getMultiplier(match);}}
_createMatchingTextRanges()
{if(!this._matches.length)
return[];let ranges=[];let startIndex=this._matches[0].index;let endIndex=startIndex;for(let i=1;i<this._matches.length;++i){let match=this._matches[i];if(match.index===endIndex+1){endIndex++;continue;}
ranges.push(new WI.TextRange(0,startIndex,0,endIndex+1));startIndex=match.index;endIndex=startIndex;}
ranges.push(new WI.TextRange(0,startIndex,0,endIndex+1));return ranges;}};WI.Recording=class Recording extends WI.Object
{constructor(version,type,initialState,frames,data)
{super();this._version=version;this._type=type;this._initialState=initialState;this._frames=frames;this._data=data;this._displayName=WI.UIString("Recording");this._swizzle=null;this._actions=[new WI.RecordingInitialStateAction].concat(...this._frames.map((frame)=>frame.actions));this._visualActionIndexes=[];this._source=null;this._processContext=null;this._processStates=[];this._processing=false;}
static fromPayload(payload,frames)
{if(typeof payload!=="object"||payload===null)
return null;if(typeof payload.version!=="number"){WI.Recording.synthesizeError(WI.UIString("non-number %s").format(WI.unlocalizedString("version")));return null;}
if(payload.version<1||payload.version>WI.Recording.Version){WI.Recording.synthesizeError(WI.UIString("unsupported %s").format(WI.unlocalizedString("version")));return null;}
if(parseInt(payload.version)!==payload.version){WI.Recording.synthesizeWarning(WI.UIString("non-integer %s").format(WI.unlocalizedString("version")));payload.version=parseInt(payload.version);}
let type=null;switch(payload.type){case InspectorBackend.Enum.Recording.Type.Canvas2D:type=WI.Recording.Type.Canvas2D;break;case InspectorBackend.Enum.Recording.Type.CanvasBitmapRenderer:type=WI.Recording.Type.CanvasBitmapRenderer;break;case InspectorBackend.Enum.Recording.Type.CanvasWebGL:type=WI.Recording.Type.CanvasWebGL;break;case InspectorBackend.Enum.Recording.Type.CanvasWebGL2:type=WI.Recording.Type.CanvasWebGL2;break;default:WI.Recording.synthesizeWarning(WI.UIString("unknown %s \u0022%s\u0022").format(WI.unlocalizedString("type"),payload.type));type=String(payload.type);break;}
if(typeof payload.initialState!=="object"||payload.initialState===null){if("initialState"in payload)
WI.Recording.synthesizeWarning(WI.UIString("non-object %s").format(WI.unlocalizedString("initialState")));payload.initialState={};}
if(typeof payload.initialState.attributes!=="object"||payload.initialState.attributes===null){if("attributes"in payload.initialState)
WI.Recording.synthesizeWarning(WI.UIString("non-object %s").format(WI.unlocalizedString("initialState.attributes")));payload.initialState.attributes={};}
if(!Array.isArray(payload.initialState.states)||payload.initialState.states.some((item)=>typeof item!=="object"||item===null)){if("states"in payload.initialState)
WI.Recording.synthesizeWarning(WI.UIString("non-array %s").format(WI.unlocalizedString("initialState.states")));payload.initialState.states=[];if(!isEmptyObject(payload.initialState.attributes)){let{width,height,...state}=payload.initialState.attributes;if(!isEmptyObject(state))
payload.initialState.states.push(state);}}
if(!Array.isArray(payload.initialState.parameters)){if("parameters"in payload.initialState)
WI.Recording.synthesizeWarning(WI.UIString("non-array %s").format(WI.unlocalizedString("initialState.attributes")));payload.initialState.parameters=[];}
if(typeof payload.initialState.content!=="string"){if("content"in payload.initialState)
WI.Recording.synthesizeWarning(WI.UIString("non-string %s").format(WI.unlocalizedString("initialState.content")));payload.initialState.content="";}
if(!Array.isArray(payload.frames)){if("frames"in payload)
WI.Recording.synthesizeWarning(WI.UIString("non-array %s").format(WI.unlocalizedString("frames")));payload.frames=[];}
if(!Array.isArray(payload.data)){if("data"in payload)
WI.Recording.synthesizeWarning(WI.UIString("non-array %s").format(WI.unlocalizedString("data")));payload.data=[];}
if(!frames)
frames=payload.frames.map(WI.RecordingFrame.fromPayload)
return new WI.Recording(payload.version,type,payload.initialState,frames,payload.data);}
static displayNameForRecordingType(recordingType)
{switch(recordingType){case Recording.Type.Canvas2D:return WI.UIString("2D");case Recording.Type.CanvasBitmapRenderer:return WI.UIString("Bitmap Renderer","Recording Type Canvas Bitmap Renderer","A type of canvas recording in the Graphics Tab");case Recording.Type.CanvasWebGL:return WI.unlocalizedString("WebGL");case Recording.Type.CanvasWebGL2:return WI.unlocalizedString("WebGL2");}
return null;}
static displayNameForSwizzleType(swizzleType)
{switch(swizzleType){case WI.Recording.Swizzle.None:return WI.unlocalizedString("None");case WI.Recording.Swizzle.Number:return WI.unlocalizedString("Number");case WI.Recording.Swizzle.Boolean:return WI.unlocalizedString("Boolean");case WI.Recording.Swizzle.String:return WI.unlocalizedString("String");case WI.Recording.Swizzle.Array:return WI.unlocalizedString("Array");case WI.Recording.Swizzle.TypedArray:return WI.unlocalizedString("TypedArray");case WI.Recording.Swizzle.Image:return WI.unlocalizedString("Image");case WI.Recording.Swizzle.ImageData:return WI.unlocalizedString("ImageData");case WI.Recording.Swizzle.DOMMatrix:return WI.unlocalizedString("DOMMatrix");case WI.Recording.Swizzle.Path2D:return WI.unlocalizedString("Path2D");case WI.Recording.Swizzle.CanvasGradient:return WI.unlocalizedString("CanvasGradient");case WI.Recording.Swizzle.CanvasPattern:return WI.unlocalizedString("CanvasPattern");case WI.Recording.Swizzle.WebGLBuffer:return WI.unlocalizedString("WebGLBuffer");case WI.Recording.Swizzle.WebGLFramebuffer:return WI.unlocalizedString("WebGLFramebuffer");case WI.Recording.Swizzle.WebGLRenderbuffer:return WI.unlocalizedString("WebGLRenderbuffer");case WI.Recording.Swizzle.WebGLTexture:return WI.unlocalizedString("WebGLTexture");case WI.Recording.Swizzle.WebGLShader:return WI.unlocalizedString("WebGLShader");case WI.Recording.Swizzle.WebGLProgram:return WI.unlocalizedString("WebGLProgram");case WI.Recording.Swizzle.WebGLUniformLocation:return WI.unlocalizedString("WebGLUniformLocation");case WI.Recording.Swizzle.ImageBitmap:return WI.unlocalizedString("ImageBitmap");case WI.Recording.Swizzle.WebGLQuery:return WI.unlocalizedString("WebGLQuery");case WI.Recording.Swizzle.WebGLSampler:return WI.unlocalizedString("WebGLSampler");case WI.Recording.Swizzle.WebGLSync:return WI.unlocalizedString("WebGLSync");case WI.Recording.Swizzle.WebGLTransformFeedback:return WI.unlocalizedString("WebGLTransformFeedback");case WI.Recording.Swizzle.WebGLVertexArrayObject:return WI.unlocalizedString("WebGLVertexArrayObject");case WI.Recording.Swizzle.DOMPointInit:return WI.unlocalizedString("DOMPointInit");default:console.error("Unknown swizzle type",swizzleType);return null;}}
static synthesizeWarning(message)
{message=WI.UIString("Recording Warning: %s").format(message);if(window.InspectorTest){console.warn(message);return;}
let consoleMessage=new WI.ConsoleMessage(WI.mainTarget,WI.ConsoleMessage.MessageSource.Other,WI.ConsoleMessage.MessageLevel.Warning,message);consoleMessage.shouldRevealConsole=true;WI.consoleLogViewController.appendConsoleMessage(consoleMessage);}
static synthesizeError(message)
{message=WI.UIString("Recording Error: %s").format(message);if(window.InspectorTest){console.error(message);return;}
let consoleMessage=new WI.ConsoleMessage(WI.mainTarget,WI.ConsoleMessage.MessageSource.Other,WI.ConsoleMessage.MessageLevel.Error,message);consoleMessage.shouldRevealConsole=true;WI.consoleLogViewController.appendConsoleMessage(consoleMessage);}
get displayName(){return this._displayName;}
get type(){return this._type;}
get initialState(){return this._initialState;}
get frames(){return this._frames;}
get data(){return this._data;}
get actions(){return this._actions;}
get visualActionIndexes(){return this._visualActionIndexes;}
get source(){return this._source;}
set source(source){this._source=source;}
get processing(){return this._processing;}
get ready()
{return this._actions.lastValue.ready;}
startProcessing()
{if(this._processing||this.ready)
return;this._processing=true;this._process();}
stopProcessing()
{if(!this._processing||this.ready)
return;this._processing=false;}
createDisplayName(suggestedName)
{let recordingNameSet;if(this._source){recordingNameSet=this._source[WI.Recording.CanvasRecordingNamesSymbol];if(!recordingNameSet)
this._source[WI.Recording.CanvasRecordingNamesSymbol]=recordingNameSet=new Set;}else
recordingNameSet=WI.Recording._importedRecordingNameSet;let name;if(suggestedName){name=suggestedName;let duplicateNumber=2;while(recordingNameSet.has(name))
name=`${suggestedName} (${duplicateNumber++})`;}else{let recordingNumber=1;do{name=WI.UIString("Recording %d").format(recordingNumber++);}while(recordingNameSet.has(name));}
recordingNameSet.add(name);this._displayName=name;}
async swizzle(index,type)
{if(!this._swizzle)
this._swizzle={};if(typeof this._swizzle[index]!=="object")
this._swizzle[index]={};if(type===WI.Recording.Swizzle.Number)
return parseFloat(index);if(type===WI.Recording.Swizzle.Boolean)
return!!index;if(type===WI.Recording.Swizzle.Array)
return Array.isArray(index)?index:[];if(type===WI.Recording.Swizzle.DOMMatrix)
return new DOMMatrix(index);if(type===WI.Recording.Swizzle.TypedArray||type===WI.Recording.Swizzle.WebGLBuffer||type===WI.Recording.Swizzle.WebGLFramebuffer||type===WI.Recording.Swizzle.WebGLRenderbuffer||type===WI.Recording.Swizzle.WebGLTexture||type===WI.Recording.Swizzle.WebGLShader||type===WI.Recording.Swizzle.WebGLProgram||type===WI.Recording.Swizzle.WebGLUniformLocation||type===WI.Recording.Swizzle.WebGLQuery||type===WI.Recording.Swizzle.WebGLSampler||type===WI.Recording.Swizzle.WebGLSync||type===WI.Recording.Swizzle.WebGLTransformFeedback||type===WI.Recording.Swizzle.WebGLVertexArrayObject){return index;}
if(!(type in this._swizzle[index])){try{let data=this._data[index];switch(type){case WI.Recording.Swizzle.None:this._swizzle[index][type]=data;break;case WI.Recording.Swizzle.String:if(Array.isArray(data))
this._swizzle[index][type]=await Promise.all(data.map((item)=>this.swizzle(item,WI.Recording.Swizzle.String)));else
this._swizzle[index][type]=String(data);break;case WI.Recording.Swizzle.Image:this._swizzle[index][type]=await WI.ImageUtilities.promisifyLoad(data);this._swizzle[index][type].__data=data;break;case WI.Recording.Swizzle.ImageData:{let[object,width,height]=await Promise.all([this.swizzle(data[0],WI.Recording.Swizzle.Array),this.swizzle(data[1],WI.Recording.Swizzle.Number),this.swizzle(data[2],WI.Recording.Swizzle.Number),]);object=await Promise.all(object.map((item)=>this.swizzle(item,WI.Recording.Swizzle.Number)));this._swizzle[index][type]=new ImageData(new Uint8ClampedArray(object),width,height);this._swizzle[index][type].__data={data:object,width,height};break;}
case WI.Recording.Swizzle.Path2D:this._swizzle[index][type]=new Path2D(data);this._swizzle[index][type].__data=data;break;case WI.Recording.Swizzle.CanvasGradient:{let[gradientType,points]=await Promise.all([this.swizzle(data[0],WI.Recording.Swizzle.String),this.swizzle(data[1],WI.Recording.Swizzle.Array),]);points=await Promise.all(points.map((item)=>this.swizzle(item,WI.Recording.Swizzle.Number)));WI.ImageUtilities.scratchCanvasContext2D((context)=>{if(gradientType=="radial-gradient")
this._swizzle[index][type]=context.createRadialGradient(...points);else if(gradientType=="linear-gradient")
this._swizzle[index][type]=context.createLinearGradient(...points);else
this._swizzle[index][type]=context.createConicGradient(...points);});let stops=[];for(let stop of data[2]){let[offset,color]=await Promise.all([this.swizzle(stop[0],WI.Recording.Swizzle.Number),this.swizzle(stop[1],WI.Recording.Swizzle.String),]);this._swizzle[index][type].addColorStop(offset,color);stops.push({offset,color});}
this._swizzle[index][type].__data={type:gradientType,points,stops};break;}
case WI.Recording.Swizzle.CanvasPattern:{let[image,repeat]=await Promise.all([this.swizzle(data[0],WI.Recording.Swizzle.Image),this.swizzle(data[1],WI.Recording.Swizzle.String),]);WI.ImageUtilities.scratchCanvasContext2D((context)=>{this._swizzle[index][type]=context.createPattern(image,repeat);this._swizzle[index][type].__image=image;});this._swizzle[index][type].__data={image:image.__data,repeat};break;}
case WI.Recording.Swizzle.ImageBitmap:{let image=await this.swizzle(index,WI.Recording.Swizzle.Image);this._swizzle[index][type]=await createImageBitmap(image);this._swizzle[index][type].__data=data;break;}
case WI.Recording.Swizzle.CallStack:{let array=await this.swizzle(data,WI.Recording.Swizzle.Array);this._swizzle[index][type]=await Promise.all(array.map((item)=>this.swizzle(item,WI.Recording.Swizzle.CallFrame)));break;}
case WI.Recording.Swizzle.CallFrame:{let array=await this.swizzle(data,WI.Recording.Swizzle.Array);let[functionName,url]=await Promise.all([this.swizzle(array[0],WI.Recording.Swizzle.String),this.swizzle(array[1],WI.Recording.Swizzle.String),]);this._swizzle[index][type]=WI.CallFrame.fromPayload(WI.assumingMainTarget(),{functionName,url,lineNumber:array[2],columnNumber:array[3],});break;}}}catch{}}
return this._swizzle[index][type];}
createContext()
{let createCanvasContext=(type)=>{let canvas=document.createElement("canvas");if("width"in this._initialState.attributes)
canvas.width=this._initialState.attributes.width;if("height"in this._initialState.attributes)
canvas.height=this._initialState.attributes.height;return canvas.getContext(type,...this._initialState.parameters);};if(this._type===WI.Recording.Type.Canvas2D)
return createCanvasContext("2d");if(this._type===WI.Recording.Type.CanvasBitmapRenderer)
return createCanvasContext("bitmaprenderer");if(this._type===WI.Recording.Type.CanvasWebGL)
return createCanvasContext("webgl");if(this._type===WI.Recording.Type.CanvasWebGL2)
return createCanvasContext("webgl2");console.error("Unknown recording type",this._type);return null;}
toJSON()
{let initialState={};if(!isEmptyObject(this._initialState.attributes))
initialState.attributes=this._initialState.attributes;if(this._initialState.states.length)
initialState.states=this._initialState.states;if(this._initialState.parameters.length)
initialState.parameters=this._initialState.parameters;if(this._initialState.content&&this._initialState.content.length)
initialState.content=this._initialState.content;return{version:this._version,type:this._type,initialState,frames:this._frames.map((frame)=>frame.toJSON()),data:this._data,};}
toHTML()
{let lines=[];let objects=[];function processObject(object){objects.push({object,index:objects.length});return`objects[${objects.length - 1}]`;}
function processValue(value){if(typeof value==="object"&&!Array.isArray(value))
return processObject(value);return JSON.stringify(value);}
function escapeHTML(s){return s.replace(/[^0-9A-Za-z ]/g,(c)=>{return`&#${c.charCodeAt(0)};`;});}
lines.push(`<!DOCTYPE html>`);lines.push(`<head>`);lines.push(`<title>${escapeHTML(this._displayName)}</title>`);lines.push(`<style>`);lines.push(`    body {`);lines.push(`        margin: 0;`);lines.push(`    }`);lines.push(`    canvas {`);lines.push(`        max-width: calc(100% - 40px);`);lines.push(`        max-height: calc(100% - 40px);`);lines.push(`        padding: 20px;`);lines.push(`    }`);lines.push(`</style>`);lines.push(`</head>`);lines.push(`<body>`);lines.push(`<script>`);lines.push(`"use strict";`);lines.push(``);lines.push(`let promises = [];`);lines.push(`let objects = {};`);lines.push(``);lines.push(`let canvas = document.body.appendChild(document.createElement("canvas"));`);for(let[attribute,value]of Object.entries(this._initialState.attributes))
lines.push(`canvas.${attribute} = ${JSON.stringify(value)};`);lines.push(``);let parametersString=this._initialState.parameters.map(processValue).join(`, `);lines.push(`let context = canvas.getContext("2d"${parametersString ? ", " + parametersString : ""});`);lines.push(``);lines.push(`let frames = [`);lines.push(`    function initialState() {`);if(this._initialState.content){let image=new Image;image.__data=this._initialState.content;lines.push(`        context.drawImage(${processObject(image)}, 0, 0);`);lines.push(``);}
for(let state of this._actions[0].states){for(let[name,value]of state){if(name==="getPath"||name==="currentX"||name==="currentY")
continue;let contextString=`context`;if(name==="setPath"){lines.push(`        if (${JSON.stringify(name)} in context)`);contextString=`    `+contextString;}
let callString=``;if(WI.RecordingAction.isFunctionForType(this._type,name))
callString=`(`+value.map(processValue).join(`, `)+`)`;else
callString=` = ${processValue(value)}`;lines.push(`        ${contextString}.${name}${callString};`);}
if(state!==this._actions[0].states.lastValue){lines.push(`        context.save();`);lines.push(``);}}
lines.push(`    },`);lines.push(`    function startRecording() {`);lines.push(`        if (typeof console.record === "function")`);lines.push(`            console.record(context, {name: ${JSON.stringify(this._displayName)}});`);lines.push(`    },`);for(let i=0;i<this._frames.length;++i){lines.push(`    function frame${i + 1}() {`);for(let action of this._frames[i].actions){let contextString=`context`;if(action.contextReplacer)
contextString+=`.${action.contextReplacer}`;if(!action.valid)
contextString=`// `+contextString;let callString=``;if(action.isFunction)
callString+=`(`+action.parameters.map(processValue).join(`, `)+`)`;else if(!action.isGetter)
callString+=` = `+processValue(action.parameters[0]);lines.push(`        ${contextString}.${action.name}${callString};`);}
lines.push(`    },`);}
lines.push(`    function stopRecording() {`);lines.push(`        if (typeof console.recordEnd === "function")`);lines.push(`            console.recordEnd(context);`);lines.push(`    },`);lines.push(`];`);lines.push(``);if(objects.length){if(objects.some(({object})=>object instanceof CanvasGradient)){lines.push(`function rebuildCanvasGradient(key, data) {`);lines.push(`    let gradient = null;`);lines.push(`    if (data.type === "radial-gradient")`);lines.push(`        gradient = context.createRadialGradient(data.points[0], data.points[1], data.points[2], data.points[3], data.points[4], data.points[5]);`);lines.push(`    else if (data.type === "linear-gradient")`);lines.push(`        gradient = context.createLinearGradient(data.points[0], data.points[1], data.points[2], data.points[3]);`);lines.push(`    else`);lines.push(`        gradient = context.createConicGradient(data.points[0], data.points[1], data.points[2]);`);lines.push(`    for (let stop of data.stops)`);lines.push(`        gradient.addColorStop(stop.offset, stop.color);`);lines.push(`    objects[key] = gradient;`);lines.push(`}`);}
if(objects.some(({object})=>object instanceof CanvasPattern)){lines.push(`function rebuildCanvasPattern(key, data) {`);lines.push(`    promises.push(new Promise(function(resolve, reject) {`);lines.push(`        let image = new Image;`);lines.push(`        function resolveWithImage(event) {`);lines.push(`            objects[key] = context.createPattern(image, data.repeat);`);lines.push(`            resolve();`);lines.push(`        }`);lines.push(`        image.addEventListener("load", resolveWithImage);`);lines.push(`        image.addEventListener("error", resolveWithImage);`);lines.push(`        image.src = data.image;`);lines.push(`    }));`);lines.push(`}`);}
if(objects.some(({object})=>object instanceof DOMMatrix)){lines.push(`function rebuildDOMMatrix(key, data) {`);lines.push(`    objects[key] = new DOMMatrix(data);`);lines.push(`}`);}
if(objects.some(({object})=>object instanceof Image)){lines.push(`function rebuildImage(key, data) {`);lines.push(`    promises.push(new Promise(function(resolve, reject) {`);lines.push(`        let image = new Image;`);lines.push(`        function resolveWithImage(event) {`);lines.push(`            objects[key] = image;`);lines.push(`            resolve();`);lines.push(`        }`);lines.push(`        image.addEventListener("load", resolveWithImage);`);lines.push(`        image.addEventListener("error", resolveWithImage);`);lines.push(`        image.src = data;`);lines.push(`    }));`);lines.push(`}`);}
if(objects.some(({object})=>object instanceof ImageBitmap)){lines.push(`function rebuildImageBitmap(key, data) {`);lines.push(`    promises.push(new Promise(function(resolve, reject) {`);lines.push(`        let image = new Image;`);lines.push(`        function resolveWithImage(event) {`);lines.push(`            createImageBitmap(image).then(function(imageBitmap) {`);lines.push(`                objects[key] = imageBitmap;`);lines.push(`                resolve();`);lines.push(`            });`);lines.push(`        }`);lines.push(`        image.addEventListener("load", resolveWithImage);`);lines.push(`        image.addEventListener("error", resolveWithImage);`);lines.push(`        image.src = data;`);lines.push(`    }));`);lines.push(`}`);}
if(objects.some(({object})=>object instanceof ImageData)){lines.push(`function rebuildImageData(key, data) {`);lines.push(`    objects[key] = new ImageData(new Uint8ClampedArray(data.data), parseInt(data.width), parseInt(data.height));`);lines.push(`}`);}
if(objects.some(({object})=>object instanceof Path2D)){lines.push(`function rebuildPath2D(key, data) {`);lines.push(`    objects[key] = new Path2D(data);`);lines.push(`}`);}
lines.push(``);for(let{object,index}of objects){if(object instanceof CanvasGradient){lines.push(`rebuildCanvasGradient(${index}, ${JSON.stringify(object.__data)});`);continue;}
if(object instanceof CanvasPattern){lines.push(`rebuildCanvasPattern(${index}, ${JSON.stringify(object.__data)});`);continue;}
if(object instanceof DOMMatrix){lines.push(`rebuildDOMMatrix(${index}, ${JSON.stringify(object.toString())});`)
continue;}
if(object instanceof Image){lines.push(`rebuildImage(${index}, ${JSON.stringify(object.__data)});`)
continue;}
if(object instanceof ImageBitmap){lines.push(`rebuildImageBitmap(${index}, ${JSON.stringify(object.__data)});`)
continue;}
if(object instanceof ImageData){lines.push(`rebuildImageData(${index}, ${JSON.stringify(object.__data)});`);continue;}
if(object instanceof Path2D){lines.push(`rebuildPath2D(${index}, ${JSON.stringify(object.__data || "")});`)
continue;}}
lines.push(``);}
lines.push(`Promise.all(promises).then(function() {`);lines.push(`    window.requestAnimationFrame(function executeFrame() {`);lines.push(`        frames.shift()();`);lines.push(`        if (frames.length)`);lines.push(`            window.requestAnimationFrame(executeFrame);`);lines.push(`    });`);lines.push(`});`);lines.push(`</script>`);lines.push(`</body>`);return lines.join(`\n`);}
async _process()
{if(!this._processContext){this._processContext=this.createContext();if(this._type===WI.Recording.Type.Canvas2D){let initialContent=await WI.ImageUtilities.promisifyLoad(this._initialState.content);this._processContext.drawImage(initialContent,0,0);for(let initialState of this._initialState.states){let state=await WI.RecordingState.swizzleInitialState(this,initialState);state.apply(this._type,this._processContext);if(initialState!==this._initialState.states.lastValue){this._processContext.save();this._processStates.push(WI.RecordingState.fromContext(this._type,this._processContext));}}}}
if(!this._actions[0].ready){this._actions[0].process(this,this._processContext,this._processStates);this.dispatchEventToListeners(WI.Recording.Event.ProcessedAction,{action:this._actions[0],index:0});}
const workInterval=10;let startTime=Date.now();let cumulativeActionIndex=0;let lastAction=this._actions[cumulativeActionIndex];for(let frameIndex=0;frameIndex<this._frames.length;++frameIndex){let frame=this._frames[frameIndex];if(frame.actions.lastValue.ready){cumulativeActionIndex+=frame.actions.length;lastAction=frame.actions.lastValue;continue;}
for(let actionIndex=0;actionIndex<frame.actions.length;++actionIndex){++cumulativeActionIndex;let action=frame.actions[actionIndex];if(action.ready){lastAction=action;continue;}
await action.swizzle(this);action.process(this,this._processContext,this._processStates,{lastAction});if(action.isVisual)
this._visualActionIndexes.push(cumulativeActionIndex);if(!actionIndex)
this.dispatchEventToListeners(WI.Recording.Event.StartProcessingFrame,{frame,index:frameIndex});this.dispatchEventToListeners(WI.Recording.Event.ProcessedAction,{action,index:cumulativeActionIndex});if(Date.now()-startTime>workInterval){await Promise.delay();startTime=Date.now();}
lastAction=action;if(!this._processing)
return;}
if(!this._processing)
return;}
this._swizzle=null;this._processContext=null;this._processing=false;}};WI.Recording.Version=1;WI.Recording.Event={ProcessedAction:"recording-processed-action",StartProcessingFrame:"recording-start-processing-frame",};WI.Recording._importedRecordingNameSet=new Set;WI.Recording.CanvasRecordingNamesSymbol=Symbol("canvas-recording-names");WI.Recording.Type={Canvas2D:"canvas-2d",CanvasBitmapRenderer:"canvas-bitmaprenderer",CanvasWebGL:"canvas-webgl",CanvasWebGL2:"canvas-webgl2",};WI.Recording.Swizzle={None:0,Number:1,Boolean:2,String:3,Array:4,TypedArray:5,Image:6,ImageData:7,DOMMatrix:8,Path2D:9,CanvasGradient:10,CanvasPattern:11,WebGLBuffer:12,WebGLFramebuffer:13,WebGLRenderbuffer:14,WebGLTexture:15,WebGLShader:16,WebGLProgram:17,WebGLUniformLocation:18,ImageBitmap:19,WebGLQuery:20,WebGLSampler:21,WebGLSync:22,WebGLTransformFeedback:23,WebGLVertexArrayObject:24,CallStack:Symbol("CallStack"),CallFrame:Symbol("CallFrame"),};WI.RecordingAction=class RecordingAction extends WI.Object
{constructor(name,parameters,swizzleTypes,trace,snapshot)
{super();this._payloadName=name;this._payloadParameters=parameters;this._payloadSwizzleTypes=swizzleTypes;this._payloadTrace=trace;this._payloadSnapshot=snapshot??-1;this._name="";this._parameters=[];this._trace=[];this._snapshot="";this._valid=true;this._isFunction=false;this._isGetter=false;this._isVisual=false;this._contextReplacer=null;this._states=[];this._stateModifiers=new Set;this._warning=null;this._swizzled=false;this._processed=false;}
static fromPayload(payload)
{if(!Array.isArray(payload))
payload=[];if(typeof payload[0]!=="number"){if(payload.length>0)
WI.Recording.synthesizeWarning(WI.UIString("non-number %s").format(WI.unlocalizedString("name")));payload[0]=-1;}
if(!Array.isArray(payload[1])){if(payload.length>1)
WI.Recording.synthesizeWarning(WI.UIString("non-array %s").format(WI.unlocalizedString("parameters")));payload[1]=[];}
if(!Array.isArray(payload[2])){if(payload.length>2)
WI.Recording.synthesizeWarning(WI.UIString("non-array %s").format(WI.unlocalizedString("swizzleTypes")));payload[2]=[];}
if(typeof payload[3]!=="number"||isNaN(payload[3])||(!payload[3]&&payload[3]!==0)){if(!Array.isArray(payload[3])){if(payload.length>3)
WI.Recording.synthesizeWarning(WI.UIString("non-number %s").format(WI.unlocalizedString("trace")));payload[3]=[];}}
if(typeof payload[4]!=="number"||isNaN(payload[4])){if(payload.length>4)
WI.Recording.synthesizeWarning(WI.UIString("non-number %s").format(WI.unlocalizedString("snapshot")));payload[4]=-1;}
return new WI.RecordingAction(...payload);}
static isFunctionForType(type,name)
{let prototype=WI.RecordingAction._prototypeForType(type);if(!prototype)
return false;let propertyDescriptor=Object.getOwnPropertyDescriptor(prototype,name);if(!propertyDescriptor)
return false;return typeof propertyDescriptor.value==="function";}
static bitfieldNamesForParameter(type,name,value,index,count)
{if(!value)
return null;let prototype=WI.RecordingAction._prototypeForType(type);if(!prototype)
return null;function testAndClearBit(name){let bit=prototype[name];if(!bit)
return;if(value&bit)
names.push(name);value=value&~bit;}
function hexString(value){return"0x"+value.toString(16);}
let names=[];if((name==="clear"&&index===0&&(type===WI.Recording.Type.CanvasWebGL||type===WI.Recording.Type.CanvasWebGL2))||(name==="blitFramebuffer"&&index===8&&type===WI.Recording.Type.CanvasWebGL2)){testAndClearBit("COLOR_BUFFER_BIT");testAndClearBit("DEPTH_BUFFER_BIT");testAndClearBit("STENCIL_BUFFER_BIT");if(value)
names.push(hexString(value));}
if(name==="clientWaitSync"&&index===1&&type===WI.Recording.Type.CanvasWebGL2){testAndClearBit("SYNC_FLUSH_COMMANDS_BIT");if(value)
names.push(hexString(value));}
if(!names.length)
return null;return names;}
static constantNameForParameter(type,name,value,index,count)
{let indexesForType=WI.RecordingAction._constantIndexes[type];if(!indexesForType)
return null;let indexesForAction=indexesForType[name];if(!indexesForAction)
return null;if(Array.isArray(indexesForAction)){if(!indexesForAction.includes(index))
return null;}else if(typeof indexesForAction==="object"){let indexesForActionVariant=indexesForAction[count];if(!indexesForActionVariant)
return null;if(Array.isArray(indexesForActionVariant)&&!indexesForActionVariant.includes(index))
return null;}
if(value===0&&(type===WI.Recording.Type.CanvasWebGL||type===WI.Recording.Type.CanvasWebGL2)){if(name==="blendFunc"||name==="blendFuncSeparate")
return"ZERO";if(index===0){if(name==="drawArrays"||name==="drawElements")
return"POINTS";if(name==="pixelStorei")
return"NONE";}}
let prototype=WI.RecordingAction._prototypeForType(type);if(prototype){for(let key in prototype){let descriptor=Object.getOwnPropertyDescriptor(prototype,key);if(descriptor&&descriptor.value===value)
return key;}}
return null;}
static _prototypeForType(type)
{switch(type){case WI.Recording.Type.Canvas2D:return CanvasRenderingContext2D.prototype;case WI.Recording.Type.CanvasBitmapRenderer:if(window.ImageBitmapRenderingContext)
return ImageBitmapRenderingContext.prototype;break;case WI.Recording.Type.CanvasWebGL:if(window.WebGLRenderingContext)
return WebGLRenderingContext.prototype;break;case WI.Recording.Type.CanvasWebGL2:if(window.WebGL2RenderingContext)
return WebGL2RenderingContext.prototype;break;}
WI.reportInternalError("Unknown recording type: "+type);return null;}
get name(){return this._name;}
get parameters(){return this._parameters;}
get swizzleTypes(){return this._payloadSwizzleTypes;}
get trace(){return this._trace;}
get snapshot(){return this._snapshot;}
get valid(){return this._valid;}
get isFunction(){return this._isFunction;}
get isGetter(){return this._isGetter;}
get isVisual(){return this._isVisual;}
get contextReplacer(){return this._contextReplacer;}
get states(){return this._states;}
get stateModifiers(){return this._stateModifiers;}
get warning(){return this._warning;}
get ready()
{return this._swizzled&&this._processed;}
process(recording,context,states,{lastAction}={})
{this._processed=true;if(recording.type===WI.Recording.Type.CanvasWebGL||recording.type===WI.Recording.Type.CanvasWebGL2){if(this._valid&&this._isVisual){let contentBefore=recording.visualActionIndexes.length?recording.actions[recording.visualActionIndexes.lastValue].snapshot:recording.initialState.content;if(this._snapshot===contentBefore)
this._warning=WI.UIString("This action causes no visual change");}
return;}
function getContent(){if(context instanceof CanvasRenderingContext2D)
return context.getImageData(0,0,context.canvas.width,context.canvas.height).data;if((window.WebGLRenderingContext&&context instanceof WebGLRenderingContext)||(window.WebGL2RenderingContext&&context instanceof WebGL2RenderingContext)){let pixels=new Uint8Array(context.drawingBufferWidth*context.drawingBufferHeight*4);context.readPixels(0,0,context.canvas.width,context.canvas.height,context.RGBA,context.UNSIGNED_BYTE,pixels);return pixels;}
if(context.canvas instanceof HTMLCanvasElement)
return[context.canvas.toDataURL()];return[];}
let contentBefore=null;let shouldCheckHasVisualEffect=this._valid&&this._isVisual;if(shouldCheckHasVisualEffect)
contentBefore=getContent();this.apply(context);if(shouldCheckHasVisualEffect){let contentAfter=getContent();if(Array.shallowEqual(contentBefore,contentAfter))
this._warning=WI.UIString("This action causes no visual change");}
if(recording.type===WI.Recording.Type.Canvas2D){let currentState=WI.RecordingState.fromContext(recording.type,context,{source:this});if(this.name==="save")
states.push(currentState);else if(this.name==="restore")
states.pop();this._states=states.slice();this._states.push(currentState);let lastState=null;if(lastAction){lastState=lastAction.states.lastValue;for(let[name,value]of currentState){let previousValue=lastState.get(name);if(value!==previousValue&&!Object.shallowEqual(value,previousValue))
this._stateModifiers.add(name);}}
let currentX=currentState.get("currentX");let invalidX=(currentX<0||currentX>=context.canvas.width)&&(!lastState||currentX!==lastState.get("currentX"));let currentY=currentState.get("currentY");let invalidY=(currentY<0||currentY>=context.canvas.height)&&(!lastState||currentY!==lastState.get("currentY"));if(invalidX||invalidY)
this._warning=WI.UIString("This action moves the path outside the visible area");}}
async swizzle(recording,lastAction)
{if(!this._valid){this._swizzled=true;return;}
let swizzleParameter=(item,index)=>{return recording.swizzle(item,this._payloadSwizzleTypes[index]);};let swizzlePromises=[recording.swizzle(this._payloadName,WI.Recording.Swizzle.String),Promise.all(this._payloadParameters.map(swizzleParameter)),];if(!isNaN(this._payloadTrace))
swizzlePromises.push(recording.swizzle(this._payloadTrace,WI.Recording.Swizzle.CallStack))
else{swizzlePromises.push(Promise.all(this._payloadTrace.map((item)=>recording.swizzle(item,WI.Recording.Swizzle.CallFrame))));}
if(this._payloadSnapshot>=0)
swizzlePromises.push(recording.swizzle(this._payloadSnapshot,WI.Recording.Swizzle.String));let[name,parameters,callFrames,snapshot]=await Promise.all(swizzlePromises);this._name=name;this._parameters=parameters;this._trace=callFrames;if(this._payloadSnapshot>=0)
this._snapshot=snapshot;if(recording.type===WI.Recording.Type.Canvas2D||recording.type===WI.Recording.Type.CanvasBitmapRenderer||recording.type===WI.Recording.Type.CanvasWebGL||recording.type===WI.Recording.Type.CanvasWebGL2){if(this._name==="width"||this._name==="height"){this._contextReplacer="canvas";this._isFunction=false;this._isGetter=!this._parameters.length;this._isVisual=!this._isGetter;}
}
if(!this._contextReplacer){this._isFunction=WI.RecordingAction.isFunctionForType(recording.type,this._name);this._isGetter=!this._isFunction&&!this._parameters.length;if(this._snapshot)
this._isVisual=true;else{let visualNames=WI.RecordingAction._visualNames[recording.type];this._isVisual=visualNames?visualNames.has(this._name):false;}
if(this._valid){let prototype=WI.RecordingAction._prototypeForType(recording.type);if(prototype&&!(name in prototype)){this.markInvalid();WI.Recording.synthesizeWarning(WI.UIString("\u0022%s\u0022 is not valid for %s").format(name,prototype.constructor.name));}}}
if(this._valid){let parametersSpecified=this._parameters.every((parameter)=>parameter!==undefined);let parametersCanBeSwizzled=this._payloadSwizzleTypes.every((swizzleType)=>swizzleType!==WI.Recording.Swizzle.None);if(!parametersSpecified||!parametersCanBeSwizzled)
this.markInvalid();}
if(this._valid){let stateModifiers=WI.RecordingAction._stateModifiers[recording.type];if(stateModifiers){this._stateModifiers.add(this._name);let modifiedByAction=stateModifiers[this._name]||[];for(let item of modifiedByAction)
this._stateModifiers.add(item);}}
this._swizzled=true;}
apply(context,options={})
{if(!this.valid)
return;try{let name=options.nameOverride||this._name;if(this._contextReplacer)
context=context[this._contextReplacer];if(this.isFunction)
context[name](...this._parameters);else{if(this.isGetter)
context[name];else
context[name]=this._parameters[0];}}catch{this.markInvalid();WI.Recording.synthesizeWarning(WI.UIString("\u0022%s\u0022 threw an error").format(this._name));}}
markInvalid()
{if(!this._valid)
return;this._valid=false;this.dispatchEventToListeners(WI.RecordingAction.Event.ValidityChanged);}
getColorParameters()
{switch(this._name){case"fillStyle":case"strokeStyle":case"shadowColor":case"setFillColor":case"setStrokeColor":case"blendColor":case"clearColor":case"colorMask":return this._parameters;case"setShadow":return this._parameters.slice(3);}
return[];}
getImageParameters()
{switch(this._name){case"createImageData":case"createPattern":case"drawImage":case"fillStyle":case"putImageData":case"strokeStyle":case"drawImageFromRect":case"transferFromImageBitmap":return this._parameters.slice(0,1);case"texImage2D":case"texSubImage2D":case"compressedTexImage2D":return[this._parameters.lastValue];}
return[];}
toJSON()
{let json=[this._payloadName,this._payloadParameters,this._payloadSwizzleTypes,this._payloadTrace];if(this._payloadSnapshot>=0)
json.push(this._payloadSnapshot);return json;}};WI.RecordingAction.Event={ValidityChanged:"recording-action-marked-invalid",};WI.RecordingAction._constantIndexes={[WI.Recording.Type.CanvasWebGL]:{"activeTexture":true,"bindBuffer":true,"bindFramebuffer":true,"bindRenderbuffer":true,"bindTexture":true,"blendEquation":true,"blendEquationSeparate":true,"blendFunc":true,"blendFuncSeparate":true,"bufferData":[0,2],"bufferSubData":[0],"checkFramebufferStatus":true,"compressedTexImage2D":[0,2],"compressedTexSubImage2D":[0],"copyTexImage2D":[0,2],"copyTexSubImage2D":[0],"createShader":true,"cullFace":true,"depthFunc":true,"disable":true,"drawArrays":[0],"drawElements":[0,2],"enable":true,"framebufferRenderbuffer":true,"framebufferTexture2D":[0,1,2],"frontFace":true,"generateMipmap":true,"getBufferParameter":true,"getFramebufferAttachmentParameter":true,"getParameter":true,"getProgramParameter":true,"getRenderbufferParameter":true,"getShaderParameter":true,"getShaderPrecisionFormat":true,"getTexParameter":true,"getVertexAttrib":[1],"getVertexAttribOffset":[1],"hint":true,"isEnabled":true,"pixelStorei":[0],"readPixels":[4,5],"renderbufferStorage":[0,1],"stencilFunc":[0],"stencilFuncSeparate":[0,1],"stencilMaskSeparate":[0],"stencilOp":true,"stencilOpSeparate":true,"texImage2D":{5:[0,2,3,4],6:[0,2,3,4],8:[0,2,6,7],9:[0,2,6,7],},"texParameterf":[0,1],"texParameteri":[0,1],"texSubImage2D":{6:[0,4,5],7:[0,4,5],8:[0,6,7],9:[0,6,7],},"vertexAttribPointer":[2],},[WI.Recording.Type.CanvasWebGL2]:{"activeTexture":true,"beginQuery":[0],"beginTransformFeedback":true,"bindBuffer":true,"bindBufferBase":[0],"bindBufferRange":[0],"bindFramebuffer":true,"bindRenderbuffer":true,"bindTexture":true,"bindTransformFeedback":[0],"blendEquation":true,"blendEquationSeparate":true,"blendFunc":true,"blendFuncSeparate":true,"blitFramebuffer":[10],"bufferData":[0,2],"bufferSubData":[0],"checkFramebufferStatus":true,"clearBufferfi":[0],"clearBufferfv":[0],"clearBufferiv":[0],"clearBufferuiv":[0],"compressedTexImage2D":[0,2],"compressedTexSubImage2D":[0],"compressedTexSubImage3D":[0],"copyBufferSubData":[0,1],"copyTexImage2D":[0,2],"copyTexSubImage2D":[0],"copyTexSubImage3D":[0],"createShader":true,"cullFace":true,"depthFunc":true,"disable":true,"drawArrays":[0],"drawArraysInstanced":[0],"drawBuffers":true,"drawElements":[0,2],"drawElementsInstanced":[0,2],"drawRangeElements":[0,4],"enable":true,"endQuery":true,"fenceSync":[0],"framebufferRenderbuffer":true,"framebufferTexture2D":[0,1,2],"framebufferTextureLayer":[0,1],"frontFace":true,"generateMipmap":true,"getActiveUniformBlockParameter":[2],"getActiveUniforms":[2],"getBufferParameter":true,"getBufferSubData":[0],"getFramebufferAttachmentParameter":true,"getIndexedParameter":[0],"getInternalformatParameter":true,"getParameter":true,"getProgramParameter":true,"getQuery":true,"getQueryParameter":[1],"getRenderbufferParameter":true,"getSamplerParameter":[1],"getShaderParameter":true,"getShaderPrecisionFormat":true,"getSyncParameter":[1],"getTexParameter":true,"getVertexAttrib":[1],"getVertexAttribOffset":[1],"hint":true,"invalidateFramebuffer":[0,1],"invalidateSubFramebuffer":[0,1],"isEnabled":true,"pixelStorei":[0],"readBuffer":true,"readPixels":[4,5],"renderbufferStorage":[0,1],"renderbufferStorageMultisample":[0,2],"samplerParameterf":[1],"samplerParameteri":[1],"stencilFunc":[0],"stencilFuncSeparate":[0,1],"stencilMaskSeparate":[0],"stencilOp":true,"stencilOpSeparate":true,"texImage2D":{5:[0,2,3,4],6:[0,2,3,4],8:[0,2,6,7],9:[0,2,6,7],10:[0,2,6,7],11:[0,2,7,8],},"texParameterf":[0,1],"texParameteri":[0,1],"texStorage2D":[0,2],"texSubImage2D":{6:[0,4,5],7:[0,4,5],8:[0,6,7],9:[0,6,7],10:[0,6,7],11:[0,8,9],12:[0,8,9],},"transformFeedbackVaryings":[2],"vertexAttribIPointer":[2],"vertexAttribPointer":[2],},};WI.RecordingAction._visualNames={[WI.Recording.Type.Canvas2D]:new Set(["clearRect","drawFocusIfNeeded","drawImage","drawImageFromRect","fill","fillRect","fillText","putImageData","stroke","strokeRect","strokeText",]),[WI.Recording.Type.CanvasBitmapRenderer]:new Set(["transferFromImageBitmap",]),[WI.Recording.Type.CanvasWebGL]:new Set(["clear","drawArrays","drawElements",]),[WI.Recording.Type.CanvasWebGL2]:new Set(["clear","drawArrays","drawArraysInstanced","drawElements","drawElementsInstanced",]),};WI.RecordingAction._stateModifiers={[WI.Recording.Type.Canvas2D]:{arc:["currentX","currentY"],arcTo:["currentX","currentY"],beginPath:["currentX","currentY"],bezierCurveTo:["currentX","currentY"],clearShadow:["shadowOffsetX","shadowOffsetY","shadowBlur","shadowColor"],closePath:["currentX","currentY"],ellipse:["currentX","currentY"],lineTo:["currentX","currentY"],moveTo:["currentX","currentY"],quadraticCurveTo:["currentX","currentY"],rect:["currentX","currentY"],resetTransform:["transform"],rotate:["transform"],scale:["transform"],setAlpha:["globalAlpha"],setCompositeOperation:["globalCompositeOperation"],setFillColor:["fillStyle"],setLineCap:["lineCap"],setLineJoin:["lineJoin"],setLineWidth:["lineWidth"],setMiterLimit:["miterLimit"],setShadow:["shadowOffsetX","shadowOffsetY","shadowBlur","shadowColor"],setStrokeColor:["strokeStyle"],setTransform:["transform"],translate:["transform"],},};WI.RecordingFrame=class RecordingFrame
{constructor(actions,{duration,incomplete}={})
{this._actions=actions;this._duration=duration||NaN;this._incomplete=incomplete||false;}
static fromPayload(payload)
{if(typeof payload!=="object"||payload===null)
payload={};if(!Array.isArray(payload.actions)){if("actions"in payload)
WI.Recording.synthesizeWarning(WI.UIString("non-array %s").format(WI.unlocalizedString("actions")));payload.actions=[];}
let actions=payload.actions.map(WI.RecordingAction.fromPayload);return new WI.RecordingFrame(actions,{duration:payload.duration||NaN,incomplete:!!payload.incomplete,});}
get actions(){return this._actions;}
get duration(){return this._duration;}
get incomplete(){return this._incomplete;}
toJSON()
{let json={actions:this._actions.map((action)=>action.toJSON()),};if(!isNaN(this._duration))
json.duration=this._duration;if(this._incomplete)
json.incomplete=this._incomplete;return json;}};WI.RecordingInitialStateAction=class RecordingInitialStateAction extends WI.RecordingAction
{constructor()
{super();this._name=WI.UIString("Initial State");this._valid=false;this._swizzled=true;}};WI.RecordingState=class RecordingState
{constructor(data,{source}={})
{this._data=data;this._source=source||null;}
static fromContext(type,context,options={})
{if(type!==WI.Recording.Type.Canvas2D)
return null;let matrix=context.getTransform();let data={};data.direction=context.direction;data.fillStyle=context.fillStyle;data.font=context.font;data.globalAlpha=context.globalAlpha;data.globalCompositeOperation=context.globalCompositeOperation;data.imageSmoothingEnabled=context.imageSmoothingEnabled;data.imageSmoothingQuality=context.imageSmoothingQuality;data.lineCap=context.lineCap;data.lineDash=context.getLineDash();data.lineDashOffset=context.lineDashOffset;data.lineJoin=context.lineJoin;data.lineWidth=context.lineWidth;data.miterLimit=context.miterLimit;data.shadowBlur=context.shadowBlur;data.shadowColor=context.shadowColor;data.shadowOffsetX=context.shadowOffsetX;data.shadowOffsetY=context.shadowOffsetY;data.strokeStyle=context.strokeStyle;data.textAlign=context.textAlign;data.textBaseline=context.textBaseline;data.transform=[matrix.a,matrix.b,matrix.c,matrix.d,matrix.e,matrix.f];data.webkitImageSmoothingEnabled=context.webkitImageSmoothingEnabled;data.webkitLineDash=context.webkitLineDash;data.webkitLineDashOffset=context.webkitLineDashOffset;data.currentX=context.currentX;data.currentY=context.currentY;data.setPath=[context.getPath()];return new WI.RecordingState(data,options);}
static async swizzleInitialState(recording,initialState)
{if(recording.type===WI.Recording.Type.Canvas2D){let swizzledState={};for(let[name,value]of Object.entries(initialState)){let nameIndex=parseInt(name);if(!isNaN(nameIndex))
name=await recording.swizzle(nameIndex,WI.Recording.Swizzle.String);switch(name){case"setTransform":value=[await recording.swizzle(value,WI.Recording.Swizzle.DOMMatrix)];break;case"fillStyle":case"strokeStyle":var[gradient,pattern,string]=await Promise.all([recording.swizzle(value,WI.Recording.Swizzle.CanvasGradient),recording.swizzle(value,WI.Recording.Swizzle.CanvasPattern),recording.swizzle(value,WI.Recording.Swizzle.String),]);if(gradient&&!pattern)
value=gradient;else if(pattern&&!gradient)
value=pattern;else
value=string;break;case"direction":case"font":case"globalCompositeOperation":case"imageSmoothingQuality":case"lineCap":case"lineJoin":case"shadowColor":case"textAlign":case"textBaseline":value=await recording.swizzle(value,WI.Recording.Swizzle.String);break;case"globalAlpha":case"lineWidth":case"miterLimit":case"shadowOffsetX":case"shadowOffsetY":case"shadowBlur":case"lineDashOffset":value=await recording.swizzle(value,WI.Recording.Swizzle.Number);break;case"setPath":value=[await recording.swizzle(value[0],WI.Recording.Swizzle.Path2D)];break;}
if(value===undefined||(Array.isArray(value)&&value.includes(undefined)))
continue;swizzledState[name]=value;}
return new WI.RecordingState(swizzledState);}
return null;}
get source(){return this._source;}
has(name)
{return name in this._data;}
get(name)
{return this._data[name];}
apply(type,context)
{for(let[name,value]of this){if(!(name in context))
continue;if(name==="currentX"||name==="currentY")
continue;try{if(WI.RecordingAction.isFunctionForType(type,name))
context[name](...value);else
context[name]=value;}catch{}}}
toJSON()
{return this._data;}
[Symbol.iterator]()
{return Object.entries(this._data)[Symbol.iterator]();}};WI.Redirect=class Redirect
{constructor(url,requestMethod,requestHeaders,responseStatusCode,responseStatusText,responseHeaders,timestamp)
{this._url=url;this._urlComponents=null;this._requestMethod=requestMethod;this._requestHeaders=requestHeaders;this._responseStatusCode=responseStatusCode;this._responseStatusText=responseStatusText;this._responseHeaders=responseHeaders;this._timestamp=timestamp;}
get url(){return this._url;}
get requestMethod(){return this._requestMethod;}
get requestHeaders(){return this._requestHeaders;}
get responseStatusCode(){return this._responseStatusCode;}
get responseStatusText(){return this._responseStatusText;}
get responseHeaders(){return this._responseHeaders;}
get timestamp(){return this._timestamp;}
get urlComponents()
{if(!this._urlComponents)
this._urlComponents=parseURL(this._url);return this._urlComponents;}};WI.RenderingFrameTimelineRecord=class RenderingFrameTimelineRecord extends WI.TimelineRecord
{constructor(startTime,endTime,name)
{super(WI.TimelineRecord.Type.RenderingFrame,startTime,endTime);this._name=name||"";this._durationByTaskType=new Map;this._frameIndex=-1;}
static resetFrameIndex()
{WI.RenderingFrameTimelineRecord._nextFrameIndex=0;}
static displayNameForTaskType(taskType)
{switch(taskType){case WI.RenderingFrameTimelineRecord.TaskType.Script:return WI.UIString("Script");case WI.RenderingFrameTimelineRecord.TaskType.Layout:return WI.repeatedUIString.timelineRecordLayout();case WI.RenderingFrameTimelineRecord.TaskType.Paint:return WI.repeatedUIString.timelineRecordPaint();case WI.RenderingFrameTimelineRecord.TaskType.Other:return WI.UIString("Other");}}
static taskTypeForTimelineRecord(record)
{switch(record.type){case WI.TimelineRecord.Type.Script:return WI.RenderingFrameTimelineRecord.TaskType.Script;case WI.TimelineRecord.Type.Layout:if(record.eventType===WI.LayoutTimelineRecord.EventType.Paint||record.eventType===WI.LayoutTimelineRecord.EventType.Composite)
return WI.RenderingFrameTimelineRecord.TaskType.Paint;return WI.RenderingFrameTimelineRecord.TaskType.Layout;default:console.error("Unsupported timeline record type: "+record.type);return null;}}
static async fromJSON(json)
{let{startTime,endTime}=json;let record=new WI.RenderingFrameTimelineRecord(startTime,endTime);record.setupFrameIndex();return record;}
toJSON()
{return{type:this.type,startTime:this.startTime,endTime:this.endTime,};}
get frameIndex()
{return this._frameIndex;}
get frameNumber()
{return this._frameIndex+1;}
get name()
{return this._name;}
setupFrameIndex()
{if(this._frameIndex>=0)
return;this._frameIndex=WI.RenderingFrameTimelineRecord._nextFrameIndex++;}
durationForTask(taskType)
{if(this._durationByTaskType.has(taskType))
return this._durationByTaskType.get(taskType);var duration;if(taskType===WI.RenderingFrameTimelineRecord.TaskType.Other)
duration=this._calculateDurationRemainder();else{duration=this.children.reduce(function(previousValue,currentValue){if(taskType!==WI.RenderingFrameTimelineRecord.taskTypeForTimelineRecord(currentValue))
return previousValue;var currentDuration=currentValue.duration;if(currentValue.usesActiveStartTime)
currentDuration-=currentValue.inactiveDuration;return previousValue+currentDuration;},0);if(taskType===WI.RenderingFrameTimelineRecord.TaskType.Script){duration-=this.children.reduce(function(previousValue,currentValue){if(currentValue.type===WI.TimelineRecord.Type.Layout&&(currentValue.sourceCodeLocation||currentValue.callFrames))
return previousValue+currentValue.duration;return previousValue;},0);}}
this._durationByTaskType.set(taskType,duration);return duration;}
_calculateDurationRemainder()
{return Object.keys(WI.RenderingFrameTimelineRecord.TaskType).reduce((previousValue,key)=>{let taskType=WI.RenderingFrameTimelineRecord.TaskType[key];if(taskType===WI.RenderingFrameTimelineRecord.TaskType.Other)
return previousValue;return previousValue-this.durationForTask(taskType);},this.duration);}};WI.RenderingFrameTimelineRecord.TaskType={Script:"rendering-frame-timeline-record-script",Layout:"rendering-frame-timeline-record-layout",Paint:"rendering-frame-timeline-record-paint",Other:"rendering-frame-timeline-record-other"};WI.RenderingFrameTimelineRecord.TypeIdentifier="rendering-frame-timeline-record";WI.RenderingFrameTimelineRecord._nextFrameIndex=0;WI.ResourceCollection=class ResourceCollection extends WI.Collection
{constructor(resourceType)
{super();this._resourceType=resourceType||null;this._resourceURLMap=new Multimap;this._resourcesTypeMap=new Map;}
get resourceType(){return this._resourceType;}
get displayName()
{const plural=true;return this._resourceType?WI.Resource.displayNameForType(this._resourceType,plural):WI.UIString("Resources");}
objectIsRequiredType(object)
{if(this._resourceType===WI.Resource.Type.StyleSheet&&object instanceof WI.CSSStyleSheet)
return true;if(!(object instanceof WI.Resource))
return false;if(!this._resourceType)
return true;return object.type===this._resourceType;}
resourcesForURL(url)
{return this._resourceURLMap.get(url)||new Set;}
resourceCollectionForType(type)
{if(this._resourceType){return this;}
let resourcesCollectionForType=this._resourcesTypeMap.get(type);if(!resourcesCollectionForType){resourcesCollectionForType=new WI.ResourceCollection(type);this._resourcesTypeMap.set(type,resourcesCollectionForType);}
return resourcesCollectionForType;}
clear()
{super.clear();this._resourceURLMap.clear();if(!this._resourceType)
this._resourcesTypeMap.clear();}
itemAdded(item)
{this._associateWithResource(item);}
itemRemoved(item)
{this._disassociateWithResource(item);}
itemsCleared(items)
{const skipRemoval=true;for(let item of items)
this._disassociateWithResource(item,skipRemoval);}
_associateWithResource(resource)
{this._resourceURLMap.add(resource.url,resource);if(!this._resourceType){let resourcesCollectionForType=this.resourceCollectionForType(resource.type);resourcesCollectionForType.add(resource);}
resource.addEventListener(WI.Resource.Event.URLDidChange,this._resourceURLDidChange,this);resource.addEventListener(WI.Resource.Event.TypeDidChange,this._resourceTypeDidChange,this);}
_disassociateWithResource(resource,skipRemoval)
{resource.removeEventListener(WI.Resource.Event.URLDidChange,this._resourceURLDidChange,this);resource.removeEventListener(WI.Resource.Event.TypeDidChange,this._resourceTypeDidChange,this);if(skipRemoval)
return;if(!this._resourceType){let resourcesCollectionForType=this.resourceCollectionForType(resource.type);resourcesCollectionForType.remove(resource);}
this._resourceURLMap.delete(resource.url,resource);}
_resourceURLDidChange(event)
{let resource=event.target;if(!(resource instanceof WI.Resource))
return;let oldURL=event.data.oldURL;if(!oldURL)
return;this._resourceURLMap.add(resource.url,resource);this._resourceURLMap.delete(oldURL,resource);}
_resourceTypeDidChange(event)
{let resource=event.target;if(!(resource instanceof WI.Resource))
return;if(this._resourceType){this.remove(resource);return;}
let resourcesWithNewType=this.resourceCollectionForType(resource.type);resourcesWithNewType.add(resource);}};WI.ResourceQueryResult=class ResourceQueryResult extends WI.QueryResult
{constructor(resource,searchString,matches,cookie)
{super(resource,matches);this._searchString=searchString;this._cookie=cookie||null;}
get resource(){return this.value;}
get searchString(){return this._searchString;}
get cookie(){return this._cookie;}
__test_createMatchesMask()
{let filename=this.resource.displayName;let lastIndex=-1;let result="";for(let match of this._matches){let gap=" ".repeat(match.index-lastIndex-1);result+=gap;result+=filename[match.index];lastIndex=match.index;}
return result;}};WI.ResourceTimelineRecord=class ResourceTimelineRecord extends WI.TimelineRecord
{constructor(resource)
{super(WI.TimelineRecord.Type.Network);this._resource=resource;this._resource.addEventListener(WI.Resource.Event.TimestampsDidChange,this._dispatchUpdatedEvent,this);}
static async fromJSON(json)
{let{entry,archiveStartTime}=json;let localResource=WI.LocalResource.fromHAREntry(entry,archiveStartTime);return new WI.ResourceTimelineRecord(localResource);}
toJSON()
{const content="";return{type:this.type,archiveStartTime:this._resource.requestSentWalltime-this.startTime,entry:WI.HARBuilder.entry(this._resource,content),};}
get resource()
{return this._resource;}
get updatesDynamically()
{return true;}
get usesActiveStartTime()
{return true;}
get startTime()
{return this._resource.timingData.startTime;}
get activeStartTime()
{return this._resource.timingData.responseStart;}
get endTime()
{return this._resource.timingData.responseEnd;}
_dispatchUpdatedEvent()
{this.dispatchEventToListeners(WI.TimelineRecord.Event.Updated);}};WI.ResourceTimingData=class ResourceTimingData
{constructor(resource,data)
{data=data||{};this._resource=resource;this._startTime=data.startTime||NaN;this._redirectStart=data.redirectStart||NaN;this._redirectEnd=data.redirectEnd||NaN;this._fetchStart=data.fetchStart||NaN;this._domainLookupStart=data.domainLookupStart||NaN;this._domainLookupEnd=data.domainLookupEnd||NaN;this._connectStart=data.connectStart||NaN;this._connectEnd=data.connectEnd||NaN;this._secureConnectionStart=data.secureConnectionStart||NaN;this._requestStart=data.requestStart||NaN;this._responseStart=data.responseStart||NaN;this._responseEnd=data.responseEnd||NaN;if(this._domainLookupStart>=this._domainLookupEnd)
this._domainLookupStart=this._domainLookupEnd=NaN;if(this._connectStart>=this._connectEnd)
this._connectStart=this._connectEnd=NaN;}
static fromPayload(payload,resource)
{payload=payload||{};let startTime=payload.startTime;let fetchStart=payload.fetchStart;let redirectStart=payload.redirectStart;let redirectEnd=payload.redirectEnd;if(isNaN(fetchStart)||fetchStart<startTime)
fetchStart=startTime;if(redirectStart<startTime||redirectStart>fetchStart||redirectStart>redirectEnd)
redirectStart=NaN;if(redirectEnd<startTime||redirectEnd>fetchStart||redirectEnd<redirectStart)
redirectEnd=NaN;function offsetToTimestamp(offset){return offset>0?fetchStart+(offset/1000):NaN;}
let data={startTime,redirectStart,redirectEnd,fetchStart,domainLookupStart:offsetToTimestamp(payload.domainLookupStart),domainLookupEnd:offsetToTimestamp(payload.domainLookupEnd),connectStart:offsetToTimestamp(payload.connectStart),connectEnd:offsetToTimestamp(payload.connectEnd),secureConnectionStart:offsetToTimestamp(payload.secureConnectionStart),requestStart:offsetToTimestamp(payload.requestStart),responseStart:offsetToTimestamp(payload.responseStart),responseEnd:offsetToTimestamp(payload.responseEnd)};return new WI.ResourceTimingData(resource,data);}
get startTime(){return this._startTime||this._resource.requestSentTimestamp;}
get redirectStart(){return this._redirectStart;}
get redirectEnd(){return this._redirectEnd;}
get fetchStart(){return this._fetchStart||this._resource.requestSentTimestamp;}
get domainLookupStart(){return this._domainLookupStart;}
get domainLookupEnd(){return this._domainLookupEnd;}
get connectStart(){return this._connectStart;}
get connectEnd(){return this._connectEnd;}
get secureConnectionStart(){return this._secureConnectionStart;}
get requestStart(){return this._requestStart||this._startTime||this._resource.requestSentTimestamp;}
get responseStart(){return this._responseStart||this._startTime||this._resource.responseReceivedTimestamp||this._resource.finishedOrFailedTimestamp;}
get responseEnd(){return this._responseEnd||this._resource.finishedOrFailedTimestamp;}
markResponseEndTime(responseEnd)
{this._responseEnd=responseEnd;}};WI.Revision=class Revision
{apply()
{console.error("Needs to be implemented by a subclass.");}
revert()
{console.error("Needs to be implemented by a subclass.");}
copy()
{return this;}};WI.ScopeChainNode=class ScopeChainNode
{constructor(type,objects,name,location,empty)
{if(type in WI.ScopeChainNode.Type)
type=WI.ScopeChainNode.Type[type];this._type=type||null;this._objects=objects||[];this._name=name||"";this._location=location||null;this._empty=empty||false;}
get type(){return this._type;}
get objects(){return this._objects;}
get name(){return this._name;}
get location(){return this._location;}
get empty(){return this._empty;}
get hash()
{if(this._hash)
return this._hash;this._hash=this._name;if(this._location)
this._hash+=`:${this._location.scriptId}:${this._location.lineNumber}:${this._location.columnNumber}`;return this._hash;}
convertToLocalScope()
{this._type=WI.ScopeChainNode.Type.Local;}};WI.ScopeChainNode.Type={Local:"scope-chain-type-local",Global:"scope-chain-type-global",GlobalLexicalEnvironment:"scope-chain-type-global-lexical-environment",With:"scope-chain-type-with",Closure:"scope-chain-type-closure",Catch:"scope-chain-type-catch",FunctionName:"scope-chain-type-function-name",Block:"scope-chain-type-block",};WI.ScreenshotsInstrument=class ScreenshotsInstrument extends WI.Instrument
{constructor()
{super();}
static supported()
{return InspectorBackend.Enum.Timeline.Instrument.Screenshot;}
get timelineRecordType()
{return WI.TimelineRecord.Type.Screenshots;}};WI.ScreenshotsTimelineRecord=class ScreenshotsTimelineRecord extends WI.TimelineRecord
{constructor(timestamp,imageData)
{super(WI.TimelineRecord.Type.Screenshots,timestamp,timestamp);this._imageData=imageData;}
static async fromJSON(json)
{return new WI.ScreenshotsTimelineRecord(json.timestamp,json.imageData);}
toJSON()
{return{type:this.type,timestamp:this.startTime,imageData:this._imageData,};}
get imageData(){return this._imageData;}};WI.ScriptInstrument=class ScriptInstrument extends WI.Instrument
{get timelineRecordType()
{return WI.TimelineRecord.Type.Script;}
startInstrumentation(initiatedByBackend)
{let target=WI.assumingMainTarget();const includeSamples=true;if(!initiatedByBackend)
target.ScriptProfilerAgent.startTracking(includeSamples);}
stopInstrumentation(initiatedByBackend)
{let target=WI.assumingMainTarget();if(!initiatedByBackend)
target.ScriptProfilerAgent.stopTracking();}};WI.ScriptSyntaxTree=class ScriptSyntaxTree
{constructor(sourceText,script)
{this._script=script;try{let sourceType=this._script.sourceType===WI.Script.SourceType.Module?"module":"script";let esprimaSyntaxTree=esprima.parse(sourceText,{loc:true,range:true,sourceType});this._syntaxTree=this._createInternalSyntaxTree(esprimaSyntaxTree);this._parsedSuccessfully=true;}catch(error){this._parsedSuccessfully=false;this._syntaxTree=null;console.error("Couldn't parse JavaScript File: "+script.url,error);}}
get parsedSuccessfully()
{return this._parsedSuccessfully;}
forEachNode(callback)
{if(!this._parsedSuccessfully)
return;this._recurse(this._syntaxTree,callback,this._defaultParserState());}
filter(predicate,startNode)
{if(!this._parsedSuccessfully)
return[];var nodes=[];function filter(node,state)
{if(predicate(node))
nodes.push(node);else
state.skipChildNodes=true;}
this._recurse(startNode,filter,this._defaultParserState());return nodes;}
containersOfPosition(position)
{if(!this._parsedSuccessfully)
return[];let allNodes=[];this.forEachNode((node,state)=>{if(node.endPosition.isBefore(position))
state.skipChildNodes=true;else if(node.startPosition.isAfter(position))
state.shouldStopEarly=true;else
allNodes.push(node);});return allNodes;}
filterByRange(startPosition,endPosition)
{if(!this._parsedSuccessfully)
return[];var allNodes=[];function filterForNodesInRange(node,state)
{if(node.endPosition.isBefore(startPosition)){state.skipChildNodes=true;return;}
if(node.startPosition.isWithin(startPosition,endPosition)){allNodes.push(node);return;}
if(node.startPosition.isAfter(endPosition))
state.shouldStopEarly=true;}
this.forEachNode(filterForNodesInRange);return allNodes;}
containsNonEmptyReturnStatement(startNode)
{if(!this._parsedSuccessfully)
return false;if(startNode.attachments._hasNonEmptyReturnStatement!==undefined)
return startNode.attachments._hasNonEmptyReturnStatement;function removeFunctionsFilter(node)
{return node.type!==WI.ScriptSyntaxTree.NodeType.FunctionExpression&&node.type!==WI.ScriptSyntaxTree.NodeType.FunctionDeclaration&&node.type!==WI.ScriptSyntaxTree.NodeType.ArrowFunctionExpression;}
var nodes=this.filter(removeFunctionsFilter,startNode);var hasNonEmptyReturnStatement=false;var returnStatementType=WI.ScriptSyntaxTree.NodeType.ReturnStatement;for(var node of nodes){if(node.type===returnStatementType&&node.argument){hasNonEmptyReturnStatement=true;break;}}
startNode.attachments._hasNonEmptyReturnStatement=hasNonEmptyReturnStatement;return hasNonEmptyReturnStatement;}
static functionReturnDivot(node)
{return node.typeProfilingReturnDivot;}
updateTypes(nodesToUpdate,callback)
{if(!this._parsedSuccessfully)
return;var allRequests=[];var allRequestNodes=[];var sourceID=this._script.id;for(var node of nodesToUpdate){switch(node.type){case WI.ScriptSyntaxTree.NodeType.FunctionDeclaration:case WI.ScriptSyntaxTree.NodeType.FunctionExpression:case WI.ScriptSyntaxTree.NodeType.ArrowFunctionExpression:for(var param of node.params){for(var identifier of this._gatherIdentifiersInDeclaration(param)){allRequests.push({typeInformationDescriptor:WI.ScriptSyntaxTree.TypeProfilerSearchDescriptor.NormalExpression,sourceID,divot:identifier.range[0]});allRequestNodes.push(identifier);}}
allRequests.push({typeInformationDescriptor:WI.ScriptSyntaxTree.TypeProfilerSearchDescriptor.FunctionReturn,sourceID,divot:WI.ScriptSyntaxTree.functionReturnDivot(node)});allRequestNodes.push(node);break;case WI.ScriptSyntaxTree.NodeType.VariableDeclarator:for(var identifier of this._gatherIdentifiersInDeclaration(node.id)){allRequests.push({typeInformationDescriptor:WI.ScriptSyntaxTree.TypeProfilerSearchDescriptor.NormalExpression,sourceID,divot:identifier.range[0]});allRequestNodes.push(identifier);}
break;}}
function handleTypes(error,typeInformationArray)
{if(error)
return;for(var i=0;i<typeInformationArray.length;i++){var node=allRequestNodes[i];var typeInformation=WI.TypeDescription.fromPayload(typeInformationArray[i]);if(allRequests[i].typeInformationDescriptor===WI.ScriptSyntaxTree.TypeProfilerSearchDescriptor.FunctionReturn)
node.attachments.returnTypes=typeInformation;else
node.attachments.types=typeInformation;}
callback(allRequestNodes);}
this._script.target.RuntimeAgent.getRuntimeTypesForVariablesAtOffsets(allRequests,handleTypes);}
_gatherIdentifiersInDeclaration(node)
{function gatherIdentifiers(node)
{switch(node.type){case WI.ScriptSyntaxTree.NodeType.Identifier:return[node];case WI.ScriptSyntaxTree.NodeType.Property:return gatherIdentifiers(node.value);case WI.ScriptSyntaxTree.NodeType.ObjectPattern:var identifiers=[];for(var property of node.properties){for(var identifier of gatherIdentifiers(property))
identifiers.push(identifier);}
return identifiers;case WI.ScriptSyntaxTree.NodeType.ArrayPattern:var identifiers=[];for(var element of node.elements){for(var identifier of gatherIdentifiers(element))
identifiers.push(identifier);}
return identifiers;case WI.ScriptSyntaxTree.NodeType.AssignmentPattern:return gatherIdentifiers(node.left);case WI.ScriptSyntaxTree.NodeType.RestElement:return gatherIdentifiers(node.argument);default:return[];}}
return gatherIdentifiers(node);}
_defaultParserState()
{return{shouldStopEarly:false,skipChildNodes:false};}
_recurse(node,callback,state)
{if(!node)
return;if(state.shouldStopEarly||state.skipChildNodes)
return;callback(node,state);switch(node.type){case WI.ScriptSyntaxTree.NodeType.AssignmentExpression:this._recurse(node.left,callback,state);this._recurse(node.right,callback,state);break;case WI.ScriptSyntaxTree.NodeType.ArrayExpression:case WI.ScriptSyntaxTree.NodeType.ArrayPattern:this._recurseArray(node.elements,callback,state);break;case WI.ScriptSyntaxTree.NodeType.AssignmentPattern:this._recurse(node.left,callback,state);this._recurse(node.right,callback,state);break;case WI.ScriptSyntaxTree.NodeType.AwaitExpression:this._recurse(node.argument,callback,state);break;case WI.ScriptSyntaxTree.NodeType.BlockStatement:this._recurseArray(node.body,callback,state);break;case WI.ScriptSyntaxTree.NodeType.BinaryExpression:this._recurse(node.left,callback,state);this._recurse(node.right,callback,state);break;case WI.ScriptSyntaxTree.NodeType.BreakStatement:this._recurse(node.label,callback,state);break;case WI.ScriptSyntaxTree.NodeType.CatchClause:this._recurse(node.param,callback,state);this._recurse(node.body,callback,state);break;case WI.ScriptSyntaxTree.NodeType.CallExpression:this._recurse(node.callee,callback,state);this._recurseArray(node.arguments,callback,state);break;case WI.ScriptSyntaxTree.NodeType.ClassBody:this._recurseArray(node.body,callback,state);break;case WI.ScriptSyntaxTree.NodeType.ClassDeclaration:case WI.ScriptSyntaxTree.NodeType.ClassExpression:this._recurse(node.id,callback,state);this._recurse(node.superClass,callback,state);this._recurse(node.body,callback,state);break;case WI.ScriptSyntaxTree.NodeType.ContinueStatement:this._recurse(node.label,callback,state);break;case WI.ScriptSyntaxTree.NodeType.DoWhileStatement:this._recurse(node.body,callback,state);this._recurse(node.test,callback,state);break;case WI.ScriptSyntaxTree.NodeType.ExpressionStatement:this._recurse(node.expression,callback,state);break;case WI.ScriptSyntaxTree.NodeType.ForStatement:this._recurse(node.init,callback,state);this._recurse(node.test,callback,state);this._recurse(node.update,callback,state);this._recurse(node.body,callback,state);break;case WI.ScriptSyntaxTree.NodeType.ForInStatement:case WI.ScriptSyntaxTree.NodeType.ForOfStatement:this._recurse(node.left,callback,state);this._recurse(node.right,callback,state);this._recurse(node.body,callback,state);break;case WI.ScriptSyntaxTree.NodeType.FunctionDeclaration:case WI.ScriptSyntaxTree.NodeType.FunctionExpression:case WI.ScriptSyntaxTree.NodeType.ArrowFunctionExpression:this._recurse(node.id,callback,state);this._recurseArray(node.params,callback,state);this._recurse(node.body,callback,state);break;case WI.ScriptSyntaxTree.NodeType.IfStatement:this._recurse(node.test,callback,state);this._recurse(node.consequent,callback,state);this._recurse(node.alternate,callback,state);break;case WI.ScriptSyntaxTree.NodeType.LabeledStatement:this._recurse(node.label,callback,state);this._recurse(node.body,callback,state);break;case WI.ScriptSyntaxTree.NodeType.LogicalExpression:this._recurse(node.left,callback,state);this._recurse(node.right,callback,state);break;case WI.ScriptSyntaxTree.NodeType.MemberExpression:this._recurse(node.object,callback,state);this._recurse(node.property,callback,state);break;case WI.ScriptSyntaxTree.NodeType.MethodDefinition:this._recurse(node.key,callback,state);this._recurse(node.value,callback,state);break;case WI.ScriptSyntaxTree.NodeType.NewExpression:this._recurse(node.callee,callback,state);this._recurseArray(node.arguments,callback,state);break;case WI.ScriptSyntaxTree.NodeType.ObjectExpression:case WI.ScriptSyntaxTree.NodeType.ObjectPattern:this._recurseArray(node.properties,callback,state);break;case WI.ScriptSyntaxTree.NodeType.Program:this._recurseArray(node.body,callback,state);break;case WI.ScriptSyntaxTree.NodeType.Property:this._recurse(node.key,callback,state);this._recurse(node.value,callback,state);break;case WI.ScriptSyntaxTree.NodeType.RestElement:this._recurse(node.argument,callback,state);break;case WI.ScriptSyntaxTree.NodeType.ReturnStatement:this._recurse(node.argument,callback,state);break;case WI.ScriptSyntaxTree.NodeType.SequenceExpression:this._recurseArray(node.expressions,callback,state);break;case WI.ScriptSyntaxTree.NodeType.SpreadElement:this._recurse(node.argument,callback,state);break;case WI.ScriptSyntaxTree.NodeType.SwitchStatement:this._recurse(node.discriminant,callback,state);this._recurseArray(node.cases,callback,state);break;case WI.ScriptSyntaxTree.NodeType.SwitchCase:this._recurse(node.test,callback,state);this._recurseArray(node.consequent,callback,state);break;case WI.ScriptSyntaxTree.NodeType.ConditionalExpression:this._recurse(node.test,callback,state);this._recurse(node.consequent,callback,state);this._recurse(node.alternate,callback,state);break;case WI.ScriptSyntaxTree.NodeType.TaggedTemplateExpression:this._recurse(node.tag,callback,state);this._recurse(node.quasi,callback,state);break;case WI.ScriptSyntaxTree.NodeType.TemplateLiteral:this._recurseArray(node.quasis,callback,state);this._recurseArray(node.expressions,callback,state);break;case WI.ScriptSyntaxTree.NodeType.ThrowStatement:this._recurse(node.argument,callback,state);break;case WI.ScriptSyntaxTree.NodeType.TryStatement:this._recurse(node.block,callback,state);this._recurse(node.handler,callback,state);this._recurse(node.finalizer,callback,state);break;case WI.ScriptSyntaxTree.NodeType.UnaryExpression:this._recurse(node.argument,callback,state);break;case WI.ScriptSyntaxTree.NodeType.UpdateExpression:this._recurse(node.argument,callback,state);break;case WI.ScriptSyntaxTree.NodeType.VariableDeclaration:this._recurseArray(node.declarations,callback,state);break;case WI.ScriptSyntaxTree.NodeType.VariableDeclarator:this._recurse(node.id,callback,state);this._recurse(node.init,callback,state);break;case WI.ScriptSyntaxTree.NodeType.WhileStatement:this._recurse(node.test,callback,state);this._recurse(node.body,callback,state);break;case WI.ScriptSyntaxTree.NodeType.WithStatement:this._recurse(node.object,callback,state);this._recurse(node.body,callback,state);break;case WI.ScriptSyntaxTree.NodeType.YieldExpression:this._recurse(node.argument,callback,state);break;case WI.ScriptSyntaxTree.NodeType.ExportAllDeclaration:this._recurse(node.source,callback,state);break;case WI.ScriptSyntaxTree.NodeType.ExportNamedDeclaration:this._recurse(node.declaration,callback,state);this._recurseArray(node.specifiers,callback,state);this._recurse(node.source,callback,state);break;case WI.ScriptSyntaxTree.NodeType.ExportDefaultDeclaration:this._recurse(node.declaration,callback,state);break;case WI.ScriptSyntaxTree.NodeType.ExportSpecifier:this._recurse(node.local,callback,state);this._recurse(node.exported,callback,state);break;case WI.ScriptSyntaxTree.NodeType.ImportDeclaration:this._recurseArray(node.specifiers,callback,state);this._recurse(node.source,callback,state);break;case WI.ScriptSyntaxTree.NodeType.ImportDefaultSpecifier:this._recurse(node.local,callback,state);break;case WI.ScriptSyntaxTree.NodeType.ImportNamespaceSpecifier:this._recurse(node.local,callback,state);break;case WI.ScriptSyntaxTree.NodeType.ImportSpecifier:this._recurse(node.imported,callback,state);this._recurse(node.local,callback,state);break;case WI.ScriptSyntaxTree.NodeType.DebuggerStatement:case WI.ScriptSyntaxTree.NodeType.EmptyStatement:case WI.ScriptSyntaxTree.NodeType.Identifier:case WI.ScriptSyntaxTree.NodeType.Import:case WI.ScriptSyntaxTree.NodeType.Literal:case WI.ScriptSyntaxTree.NodeType.MetaProperty:case WI.ScriptSyntaxTree.NodeType.Super:case WI.ScriptSyntaxTree.NodeType.ThisExpression:case WI.ScriptSyntaxTree.NodeType.TemplateElement:break;}
state.skipChildNodes=false;}
_recurseArray(array,callback,state)
{for(var node of array)
this._recurse(node,callback,state);}
_createInternalSyntaxTree(node)
{if(!node)
return null;var result=null;switch(node.type){case"ArrayExpression":result={type:WI.ScriptSyntaxTree.NodeType.ArrayExpression,elements:node.elements.map(this._createInternalSyntaxTree,this)};break;case"ArrayPattern":result={type:WI.ScriptSyntaxTree.NodeType.ArrayPattern,elements:node.elements.map(this._createInternalSyntaxTree,this)};break;case"ArrowFunctionExpression":result={type:WI.ScriptSyntaxTree.NodeType.ArrowFunctionExpression,id:this._createInternalSyntaxTree(node.id),params:node.params.map(this._createInternalSyntaxTree,this),body:this._createInternalSyntaxTree(node.body),generator:node.generator,expression:node.expression,async:node.async,typeProfilingReturnDivot:node.range[0]};break;case"AssignmentExpression":result={type:WI.ScriptSyntaxTree.NodeType.AssignmentExpression,operator:node.operator,left:this._createInternalSyntaxTree(node.left),right:this._createInternalSyntaxTree(node.right)};break;case"AssignmentPattern":result={type:WI.ScriptSyntaxTree.NodeType.AssignmentPattern,left:this._createInternalSyntaxTree(node.left),right:this._createInternalSyntaxTree(node.right),};break;case"AwaitExpression":result={type:WI.ScriptSyntaxTree.NodeType.AwaitExpression,argument:this._createInternalSyntaxTree(node.argument),};break;case"BlockStatement":result={type:WI.ScriptSyntaxTree.NodeType.BlockStatement,body:node.body.map(this._createInternalSyntaxTree,this)};break;case"BinaryExpression":result={type:WI.ScriptSyntaxTree.NodeType.BinaryExpression,operator:node.operator,left:this._createInternalSyntaxTree(node.left),right:this._createInternalSyntaxTree(node.right)};break;case"BreakStatement":result={type:WI.ScriptSyntaxTree.NodeType.BreakStatement,label:this._createInternalSyntaxTree(node.label)};break;case"CallExpression":result={type:WI.ScriptSyntaxTree.NodeType.CallExpression,callee:this._createInternalSyntaxTree(node.callee),arguments:node.arguments.map(this._createInternalSyntaxTree,this)};break;case"CatchClause":result={type:WI.ScriptSyntaxTree.NodeType.CatchClause,param:this._createInternalSyntaxTree(node.param),body:this._createInternalSyntaxTree(node.body)};break;case"ClassBody":result={type:WI.ScriptSyntaxTree.NodeType.ClassBody,body:node.body.map(this._createInternalSyntaxTree,this)};break;case"ClassDeclaration":result={type:WI.ScriptSyntaxTree.NodeType.ClassDeclaration,id:this._createInternalSyntaxTree(node.id),superClass:this._createInternalSyntaxTree(node.superClass),body:this._createInternalSyntaxTree(node.body),};break;case"ClassExpression":result={type:WI.ScriptSyntaxTree.NodeType.ClassExpression,id:this._createInternalSyntaxTree(node.id),superClass:this._createInternalSyntaxTree(node.superClass),body:this._createInternalSyntaxTree(node.body),};break;case"ConditionalExpression":result={type:WI.ScriptSyntaxTree.NodeType.ConditionalExpression,test:this._createInternalSyntaxTree(node.test),consequent:this._createInternalSyntaxTree(node.consequent),alternate:this._createInternalSyntaxTree(node.alternate)};break;case"ContinueStatement":result={type:WI.ScriptSyntaxTree.NodeType.ContinueStatement,label:this._createInternalSyntaxTree(node.label)};break;case"DoWhileStatement":result={type:WI.ScriptSyntaxTree.NodeType.DoWhileStatement,body:this._createInternalSyntaxTree(node.body),test:this._createInternalSyntaxTree(node.test)};break;case"DebuggerStatement":result={type:WI.ScriptSyntaxTree.NodeType.DebuggerStatement};break;case"EmptyStatement":result={type:WI.ScriptSyntaxTree.NodeType.EmptyStatement};break;case"ExpressionStatement":result={type:WI.ScriptSyntaxTree.NodeType.ExpressionStatement,expression:this._createInternalSyntaxTree(node.expression)};break;case"ForStatement":result={type:WI.ScriptSyntaxTree.NodeType.ForStatement,init:this._createInternalSyntaxTree(node.init),test:this._createInternalSyntaxTree(node.test),update:this._createInternalSyntaxTree(node.update),body:this._createInternalSyntaxTree(node.body)};break;case"ForInStatement":result={type:WI.ScriptSyntaxTree.NodeType.ForInStatement,left:this._createInternalSyntaxTree(node.left),right:this._createInternalSyntaxTree(node.right),body:this._createInternalSyntaxTree(node.body)};break;case"ForOfStatement":result={type:WI.ScriptSyntaxTree.NodeType.ForOfStatement,left:this._createInternalSyntaxTree(node.left),right:this._createInternalSyntaxTree(node.right),body:this._createInternalSyntaxTree(node.body),await:node.await};break;case"FunctionDeclaration":result={type:WI.ScriptSyntaxTree.NodeType.FunctionDeclaration,id:this._createInternalSyntaxTree(node.id),params:node.params.map(this._createInternalSyntaxTree,this),body:this._createInternalSyntaxTree(node.body),generator:node.generator,async:node.async,typeProfilingReturnDivot:node.range[0]};break;case"FunctionExpression":result={type:WI.ScriptSyntaxTree.NodeType.FunctionExpression,id:this._createInternalSyntaxTree(node.id),params:node.params.map(this._createInternalSyntaxTree,this),body:this._createInternalSyntaxTree(node.body),generator:node.generator,async:node.async,typeProfilingReturnDivot:node.range[0]};break;case"Identifier":result={type:WI.ScriptSyntaxTree.NodeType.Identifier,name:node.name};break;case"IfStatement":result={type:WI.ScriptSyntaxTree.NodeType.IfStatement,test:this._createInternalSyntaxTree(node.test),consequent:this._createInternalSyntaxTree(node.consequent),alternate:this._createInternalSyntaxTree(node.alternate)};break;case"Literal":result={type:WI.ScriptSyntaxTree.NodeType.Literal,value:node.value,raw:node.raw};break;case"LabeledStatement":result={type:WI.ScriptSyntaxTree.NodeType.LabeledStatement,label:this._createInternalSyntaxTree(node.label),body:this._createInternalSyntaxTree(node.body)};break;case"LogicalExpression":result={type:WI.ScriptSyntaxTree.NodeType.LogicalExpression,left:this._createInternalSyntaxTree(node.left),right:this._createInternalSyntaxTree(node.right),operator:node.operator};break;case"MemberExpression":result={type:WI.ScriptSyntaxTree.NodeType.MemberExpression,object:this._createInternalSyntaxTree(node.object),property:this._createInternalSyntaxTree(node.property),computed:node.computed};break;case"MetaProperty":result={type:WI.ScriptSyntaxTree.NodeType.MetaProperty,meta:this._createInternalSyntaxTree(node.meta),property:this._createInternalSyntaxTree(node.property),};break;case"MethodDefinition":result={type:WI.ScriptSyntaxTree.NodeType.MethodDefinition,key:this._createInternalSyntaxTree(node.key),value:this._createInternalSyntaxTree(node.value),computed:node.computed,kind:node.kind,static:node.static};result.value.typeProfilingReturnDivot=node.range[0];break;case"NewExpression":result={type:WI.ScriptSyntaxTree.NodeType.NewExpression,callee:this._createInternalSyntaxTree(node.callee),arguments:node.arguments.map(this._createInternalSyntaxTree,this)};break;case"ObjectExpression":result={type:WI.ScriptSyntaxTree.NodeType.ObjectExpression,properties:node.properties.map(this._createInternalSyntaxTree,this)};break;case"ObjectPattern":result={type:WI.ScriptSyntaxTree.NodeType.ObjectPattern,properties:node.properties.map(this._createInternalSyntaxTree,this)};break;case"Program":result={type:WI.ScriptSyntaxTree.NodeType.Program,sourceType:node.sourceType,body:node.body.map(this._createInternalSyntaxTree,this)};break;case"Property":result={type:WI.ScriptSyntaxTree.NodeType.Property,key:this._createInternalSyntaxTree(node.key),value:this._createInternalSyntaxTree(node.value),kind:node.kind,method:node.method,computed:node.computed};if(result.kind==="get"||result.kind==="set"||result.method)
result.value.typeProfilingReturnDivot=node.range[0];break;case"RestElement":result={type:WI.ScriptSyntaxTree.NodeType.RestElement,argument:this._createInternalSyntaxTree(node.argument)};break;case"ReturnStatement":result={type:WI.ScriptSyntaxTree.NodeType.ReturnStatement,argument:this._createInternalSyntaxTree(node.argument)};break;case"SequenceExpression":result={type:WI.ScriptSyntaxTree.NodeType.SequenceExpression,expressions:node.expressions.map(this._createInternalSyntaxTree,this)};break;case"SpreadElement":result={type:WI.ScriptSyntaxTree.NodeType.SpreadElement,argument:this._createInternalSyntaxTree(node.argument),};break;case"Super":result={type:WI.ScriptSyntaxTree.NodeType.Super};break;case"SwitchStatement":result={type:WI.ScriptSyntaxTree.NodeType.SwitchStatement,discriminant:this._createInternalSyntaxTree(node.discriminant),cases:node.cases.map(this._createInternalSyntaxTree,this)};break;case"SwitchCase":result={type:WI.ScriptSyntaxTree.NodeType.SwitchCase,test:this._createInternalSyntaxTree(node.test),consequent:node.consequent.map(this._createInternalSyntaxTree,this)};break;case"TaggedTemplateExpression":result={type:WI.ScriptSyntaxTree.NodeType.TaggedTemplateExpression,tag:this._createInternalSyntaxTree(node.tag),quasi:this._createInternalSyntaxTree(node.quasi)};break;case"TemplateElement":result={type:WI.ScriptSyntaxTree.NodeType.TemplateElement,value:node.value,tail:node.tail};break;case"TemplateLiteral":result={type:WI.ScriptSyntaxTree.NodeType.TemplateLiteral,quasis:node.quasis.map(this._createInternalSyntaxTree,this),expressions:node.expressions.map(this._createInternalSyntaxTree,this)};break;case"ThisExpression":result={type:WI.ScriptSyntaxTree.NodeType.ThisExpression};break;case"ThrowStatement":result={type:WI.ScriptSyntaxTree.NodeType.ThrowStatement,argument:this._createInternalSyntaxTree(node.argument)};break;case"TryStatement":result={type:WI.ScriptSyntaxTree.NodeType.TryStatement,block:this._createInternalSyntaxTree(node.block),handler:this._createInternalSyntaxTree(node.handler),finalizer:this._createInternalSyntaxTree(node.finalizer)};break;case"UnaryExpression":result={type:WI.ScriptSyntaxTree.NodeType.UnaryExpression,operator:node.operator,argument:this._createInternalSyntaxTree(node.argument)};break;case"UpdateExpression":result={type:WI.ScriptSyntaxTree.NodeType.UpdateExpression,operator:node.operator,prefix:node.prefix,argument:this._createInternalSyntaxTree(node.argument)};break;case"VariableDeclaration":result={type:WI.ScriptSyntaxTree.NodeType.VariableDeclaration,declarations:node.declarations.map(this._createInternalSyntaxTree,this),kind:node.kind};break;case"VariableDeclarator":result={type:WI.ScriptSyntaxTree.NodeType.VariableDeclarator,id:this._createInternalSyntaxTree(node.id),init:this._createInternalSyntaxTree(node.init)};break;case"WhileStatement":result={type:WI.ScriptSyntaxTree.NodeType.WhileStatement,test:this._createInternalSyntaxTree(node.test),body:this._createInternalSyntaxTree(node.body)};break;case"WithStatement":result={type:WI.ScriptSyntaxTree.NodeType.WithStatement,object:this._createInternalSyntaxTree(node.object),body:this._createInternalSyntaxTree(node.body)};break;case"YieldExpression":result={type:WI.ScriptSyntaxTree.NodeType.YieldExpression,argument:this._createInternalSyntaxTree(node.argument),delegate:node.delegate};break;case"ExportAllDeclaration":result={type:WI.ScriptSyntaxTree.NodeType.ExportAllDeclaration,source:this._createInternalSyntaxTree(node.source),};break;case"ExportNamedDeclaration":result={type:WI.ScriptSyntaxTree.NodeType.ExportNamedDeclaration,declaration:this._createInternalSyntaxTree(node.declaration),specifiers:node.specifiers.map(this._createInternalSyntaxTree,this),source:this._createInternalSyntaxTree(node.source),};break;case"ExportDefaultDeclaration":result={type:WI.ScriptSyntaxTree.NodeType.ExportDefaultDeclaration,declaration:this._createInternalSyntaxTree(node.declaration),};break;case"ExportSpecifier":result={type:WI.ScriptSyntaxTree.NodeType.ExportSpecifier,local:this._createInternalSyntaxTree(node.local),exported:this._createInternalSyntaxTree(node.exported),};break;case"Import":result={type:WI.ScriptSyntaxTree.NodeType.Import,};break;case"ImportDeclaration":result={type:WI.ScriptSyntaxTree.NodeType.ImportDeclaration,specifiers:node.specifiers.map(this._createInternalSyntaxTree,this),source:this._createInternalSyntaxTree(node.source),};break;case"ImportDefaultSpecifier":result={type:WI.ScriptSyntaxTree.NodeType.ImportDefaultSpecifier,local:this._createInternalSyntaxTree(node.local),};break;case"ImportNamespaceSpecifier":result={type:WI.ScriptSyntaxTree.NodeType.ImportNamespaceSpecifier,local:this._createInternalSyntaxTree(node.local),};break;case"ImportSpecifier":result={type:WI.ScriptSyntaxTree.NodeType.ImportSpecifier,imported:this._createInternalSyntaxTree(node.imported),local:this._createInternalSyntaxTree(node.local),};break;default:console.error("Unsupported Syntax Tree Node: "+node.type,node);return null;}
let{start,end}=node.loc;result.startPosition=new WI.SourceCodePosition(start.line-1,start.column);result.endPosition=new WI.SourceCodePosition(end.line-1,end.column);result.range=node.range;result.attachments={};return result;}};WI.ScriptSyntaxTree.TypeProfilerSearchDescriptor={NormalExpression:1,FunctionReturn:2};WI.ScriptSyntaxTree.NodeType={ArrayExpression:Symbol("array-expression"),ArrayPattern:Symbol("array-pattern"),ArrowFunctionExpression:Symbol("arrow-function-expression"),AssignmentExpression:Symbol("assignment-expression"),AssignmentPattern:Symbol("assignment-pattern"),AwaitExpression:Symbol("await-expression"),BinaryExpression:Symbol("binary-expression"),BlockStatement:Symbol("block-statement"),BreakStatement:Symbol("break-statement"),CallExpression:Symbol("call-expression"),CatchClause:Symbol("catch-clause"),ClassBody:Symbol("class-body"),ClassDeclaration:Symbol("class-declaration"),ClassExpression:Symbol("class-expression"),ConditionalExpression:Symbol("conditional-expression"),ContinueStatement:Symbol("continue-statement"),DebuggerStatement:Symbol("debugger-statement"),DoWhileStatement:Symbol("do-while-statement"),EmptyStatement:Symbol("empty-statement"),ExportAllDeclaration:Symbol("export-all-declaration"),ExportDefaultDeclaration:Symbol("export-default-declaration"),ExportNamedDeclaration:Symbol("export-named-declaration"),ExportSpecifier:Symbol("export-specifier"),ExpressionStatement:Symbol("expression-statement"),ForInStatement:Symbol("for-in-statement"),ForOfStatement:Symbol("for-of-statement"),ForStatement:Symbol("for-statement"),FunctionDeclaration:Symbol("function-declaration"),FunctionExpression:Symbol("function-expression"),Identifier:Symbol("identifier"),IfStatement:Symbol("if-statement"),Import:Symbol("import"),ImportDeclaration:Symbol("import-declaration"),ImportDefaultSpecifier:Symbol("import-default-specifier"),ImportNamespaceSpecifier:Symbol("import-namespace-specifier"),ImportSpecifier:Symbol("import-specifier"),LabeledStatement:Symbol("labeled-statement"),Literal:Symbol("literal"),LogicalExpression:Symbol("logical-expression"),MemberExpression:Symbol("member-expression"),MetaProperty:Symbol("meta-property"),MethodDefinition:Symbol("method-definition"),NewExpression:Symbol("new-expression"),ObjectExpression:Symbol("object-expression"),ObjectPattern:Symbol("object-pattern"),Program:Symbol("program"),Property:Symbol("property"),RestElement:Symbol("rest-element"),ReturnStatement:Symbol("return-statement"),SequenceExpression:Symbol("sequence-expression"),SpreadElement:Symbol("spread-element"),Super:Symbol("super"),SwitchCase:Symbol("switch-case"),SwitchStatement:Symbol("switch-statement"),TaggedTemplateExpression:Symbol("tagged-template-expression"),TemplateElement:Symbol("template-element"),TemplateLiteral:Symbol("template-literal"),ThisExpression:Symbol("this-expression"),ThrowStatement:Symbol("throw-statement"),TryStatement:Symbol("try-statement"),UnaryExpression:Symbol("unary-expression"),UpdateExpression:Symbol("update-expression"),VariableDeclaration:Symbol("variable-declaration"),VariableDeclarator:Symbol("variable-declarator"),WhileStatement:Symbol("while-statement"),WithStatement:Symbol("with-statement"),YieldExpression:Symbol("yield-expression"),};WI.ScriptTimelineRecord=class ScriptTimelineRecord extends WI.TimelineRecord
{constructor(eventType,startTime,endTime,callFrames,sourceCodeLocation,details,profilePayload,extraDetails)
{super(WI.TimelineRecord.Type.Script,startTime,endTime,callFrames,sourceCodeLocation);if(eventType in WI.ScriptTimelineRecord.EventType)
eventType=WI.ScriptTimelineRecord.EventType[eventType];this._eventType=eventType;this._details=details||"";this._profilePayload=profilePayload||null;this._profile=null;this._extraDetails=extraDetails||null;this._callCountOrSamples=0;}
static async fromJSON(json)
{let{eventType,startTime,endTime,callFrames,sourceCodeLocation,details,profilePayload,extraDetails}=json;if(typeof details==="object"&&details.__type==="GarbageCollection")
details=WI.GarbageCollection.fromJSON(details);return new WI.ScriptTimelineRecord(eventType,startTime,endTime,callFrames,sourceCodeLocation,details,profilePayload,extraDetails);}
toJSON()
{return{type:this.type,eventType:this._eventType,startTime:this.startTime,endTime:this.endTime,details:this._details,extraDetails:this._extraDetails,};}
get eventType(){return this._eventType;}
get details(){return this._details;}
get extraDetails(){return this._extraDetails;}
get callCountOrSamples(){return this._callCountOrSamples;}
get profile()
{this._initializeProfileFromPayload();return this._profile;}
isGarbageCollection()
{return this._eventType===WI.ScriptTimelineRecord.EventType.GarbageCollected;}
saveIdentityToCookie(cookie)
{super.saveIdentityToCookie(cookie);cookie[WI.ScriptTimelineRecord.EventTypeCookieKey]=this._eventType;cookie[WI.ScriptTimelineRecord.DetailsCookieKey]=this._details;}
get profilePayload()
{return this._profilePayload;}
set profilePayload(payload)
{this._profilePayload=payload;}
_initializeProfileFromPayload(payload)
{if(this._profile||!this._profilePayload)
return;var payload=this._profilePayload;this._profilePayload=undefined;function profileNodeFromPayload(nodePayload)
{if(nodePayload.url){let sourceCode=WI.networkManager.resourcesForURL(nodePayload.url).firstValue;if(!sourceCode)
sourceCode=WI.debuggerManager.scriptsForURL(nodePayload.url,WI.assumingMainTarget())[0];var lineNumber=nodePayload.lineNumber-1;var sourceCodeLocation=sourceCode?sourceCode.createLazySourceCodeLocation(lineNumber,nodePayload.columnNumber):null;}
var isProgramCode=nodePayload.functionName==="(program)";var isAnonymousFunction=nodePayload.functionName==="(anonymous function)";var type=isProgramCode?WI.ProfileNode.Type.Program:WI.ProfileNode.Type.Function;var functionName=!isProgramCode&&!isAnonymousFunction&&nodePayload.functionName!=="(unknown)"?nodePayload.functionName:null;return new WI.ProfileNode(nodePayload.id,type,functionName,sourceCodeLocation,nodePayload.callInfo,nodePayload.children);}
function profileNodeCallFromPayload(nodeCallPayload)
{var startTime=WI.timelineManager.computeElapsedTime(nodeCallPayload.startTime);return new WI.ProfileNodeCall(startTime,nodeCallPayload.totalTime);}
var rootNodes=payload.rootNodes;var stack=[{parent:{children:rootNodes},index:0,root:true}];while(stack.length){var entry=stack.lastValue;if(entry.index<entry.parent.children.length){var childNodePayload=entry.parent.children[entry.index];if(childNodePayload.children&&childNodePayload.children.length)
stack.push({parent:childNodePayload,index:0});++entry.index;}else{if(!entry.root)
entry.parent.children=entry.parent.children.map(profileNodeFromPayload);else
rootNodes=rootNodes.map(profileNodeFromPayload);stack.pop();}}
for(let rootNode of rootNodes)
this._callCountOrSamples+=rootNode.callInfo.callCount;this._profile=new WI.Profile(rootNodes);}};WI.ScriptTimelineRecord.EventType={ScriptEvaluated:"script-evaluated",APIScriptEvaluated:"api-script-evaluated",MicrotaskDispatched:"microtask-dispatched",EventDispatched:"event-dispatched",ProbeSampleRecorded:"probe-sample-recorded",TimerFired:"timer-fired",TimerInstalled:"timer-installed",TimerRemoved:"timer-removed",AnimationFrameFired:"animation-frame-fired",AnimationFrameRequested:"animation-frame-requested",AnimationFrameCanceled:"animation-frame-canceled",ObserverCallback:"observer-callback",ConsoleProfileRecorded:"console-profile-recorded",GarbageCollected:"garbage-collected",};WI.ScriptTimelineRecord.EventType.displayName=function(eventType,details,includeDetailsInMainTitle)
{if(details&&!WI.ScriptTimelineRecord._eventDisplayNames){var nameMap=new Map;nameMap.set("DOMActivate","DOM Activate");nameMap.set("DOMCharacterDataModified","DOM Character Data Modified");nameMap.set("DOMContentLoaded","DOM Content Loaded");nameMap.set("DOMNodeInserted","DOM Node Inserted");nameMap.set("DOMNodeInsertedIntoDocument","DOM Node Inserted Into Document");nameMap.set("DOMNodeRemoved","DOM Node Removed");nameMap.set("DOMNodeRemovedFromDocument","DOM Node Removed From Document");nameMap.set("DOMSubtreeModified","DOM Sub-Tree Modified");nameMap.set("addsourcebuffer","Add Source Buffer");nameMap.set("addstream","Add Stream");nameMap.set("addtrack","Add Track");nameMap.set("animationcancel","Animation Cancel");nameMap.set("animationend","Animation End");nameMap.set("animationiteration","Animation Iteration");nameMap.set("animationstart","Animation Start");nameMap.set("audioend","Audio End");nameMap.set("audioprocess","Audio Process");nameMap.set("audiostart","Audio Start");nameMap.set("beforecopy","Before Copy");nameMap.set("beforecut","Before Cut");nameMap.set("beforeload","Before Load");nameMap.set("beforepaste","Before Paste");nameMap.set("beforeunload","Before Unload");nameMap.set("cancel","Animation Cancel");nameMap.set("canplay","Can Play");nameMap.set("canplaythrough","Can Play Through");nameMap.set("chargingchange","Charging Change");nameMap.set("chargingtimechange","Charging Time Change");nameMap.set("compositionend","Composition End");nameMap.set("compositionstart","Composition Start");nameMap.set("compositionupdate","Composition Update");nameMap.set("contextmenu","Context Menu");nameMap.set("cuechange","Cue Change");nameMap.set("datachannel","Data Channel");nameMap.set("dblclick","Double Click");nameMap.set("devicemotion","Device Motion");nameMap.set("deviceorientation","Device Orientation");nameMap.set("dischargingtimechange","Discharging Time Change");nameMap.set("dragend","Drag End");nameMap.set("dragenter","Drag Enter");nameMap.set("dragleave","Drag Leave");nameMap.set("dragover","Drag Over");nameMap.set("dragstart","Drag Start");nameMap.set("durationchange","Duration Change");nameMap.set("finish","Animation Finish");nameMap.set("focusin","Focus In");nameMap.set("focusout","Focus Out");nameMap.set("formdata","Form submission or invocation of FormData()");nameMap.set("gesturechange","Gesture Change");nameMap.set("gestureend","Gesture End");nameMap.set("gesturescrollend","Gesture Scroll End");nameMap.set("gesturescrollstart","Gesture Scroll Start");nameMap.set("gesturescrollupdate","Gesture Scroll Update");nameMap.set("gesturestart","Gesture Start");nameMap.set("gesturetap","Gesture Tap");nameMap.set("gesturetapdown","Gesture Tap Down");nameMap.set("hashchange","Hash Change");nameMap.set("icecandidate","ICE Candidate");nameMap.set("iceconnectionstatechange","ICE Connection State Change");nameMap.set("keydown","Key Down");nameMap.set("keypress","Key Press");nameMap.set("keyup","Key Up");nameMap.set("levelchange","Level Change");nameMap.set("loadeddata","Loaded Data");nameMap.set("loadedmetadata","Loaded Metadata");nameMap.set("loadend","Load End");nameMap.set("loadingdone","Loading Done");nameMap.set("loadstart","Load Start");nameMap.set("mousedown","Mouse Down");nameMap.set("mouseenter","Mouse Enter");nameMap.set("mouseleave","Mouse Leave");nameMap.set("mousemove","Mouse Move");nameMap.set("mouseout","Mouse Out");nameMap.set("mouseover","Mouse Over");nameMap.set("mouseup","Mouse Up");nameMap.set("mousewheel","Mouse Wheel");nameMap.set("negotiationneeded","Negotiation Needed");nameMap.set("nomatch","No Match");nameMap.set("noupdate","No Update");nameMap.set("orientationchange","Orientation Change");nameMap.set("overflowchanged","Overflow Changed");nameMap.set("pagehide","Page Hide");nameMap.set("pageshow","Page Show");nameMap.set("popstate","Pop State");nameMap.set("ratechange","Rate Change");nameMap.set("readystatechange","Ready State Change");nameMap.set("remove","Animation Remove");nameMap.set("removesourcebuffer","Remove Source Buffer");nameMap.set("removestream","Remove Stream");nameMap.set("removetrack","Remove Track");nameMap.set("resize","Resize");nameMap.set("securitypolicyviolation","Security Policy Violation");nameMap.set("selectionchange","Selection Change");nameMap.set("selectstart","Select Start");nameMap.set("signalingstatechange","Signaling State Change");nameMap.set("soundend","Sound End");nameMap.set("soundstart","Sound Start");nameMap.set("sourceclose","Source Close");nameMap.set("sourceended","Source Ended");nameMap.set("sourceopen","Source Open");nameMap.set("speechend","Speech End");nameMap.set("speechstart","Speech Start");nameMap.set("textInput","Text Input");nameMap.set("timeupdate","Time Update");nameMap.set("tonechange","Tone Change");nameMap.set("touchcancel","Touch Cancel");nameMap.set("touchend","Touch End");nameMap.set("touchmove","Touch Move");nameMap.set("touchstart","Touch Start");nameMap.set("transitioncancel","Transition Cancel");nameMap.set("transitionend","Transition End");nameMap.set("transitionrun","Transition Run");nameMap.set("transitionstart","Transition Start");nameMap.set("updateend","Update End");nameMap.set("updateready","Update Ready");nameMap.set("updatestart","Update Start");nameMap.set("upgradeneeded","Upgrade Needed");nameMap.set("versionchange","Version Change");nameMap.set("visibilitychange","Visibility Change");nameMap.set("volumechange","Volume Change");nameMap.set("webglcontextcreationerror","WebGL Context Creation Error");nameMap.set("webglcontextlost","WebGL Context Lost");nameMap.set("webglcontextrestored","WebGL Context Restored");nameMap.set("webkitAnimationEnd","Animation End");nameMap.set("webkitAnimationIteration","Animation Iteration");nameMap.set("webkitAnimationStart","Animation Start");nameMap.set("webkitBeforeTextInserted","Before Text Inserted");nameMap.set("webkitEditableContentChanged","Editable Content Changed");nameMap.set("webkitTransitionEnd","Transition End");nameMap.set("webkitaddsourcebuffer","Add Source Buffer");nameMap.set("webkitbeginfullscreen","Begin Full-Screen");nameMap.set("webkitcurrentplaybacktargetiswirelesschanged","Current Playback Target Is Wireless Changed");nameMap.set("webkitendfullscreen","End Full-Screen");nameMap.set("webkitfullscreenchange","Full-Screen Change");nameMap.set("webkitfullscreenerror","Full-Screen Error");nameMap.set("webkitkeyadded","Key Added");nameMap.set("webkitkeyerror","Key Error");nameMap.set("webkitkeymessage","Key Message");nameMap.set("webkitneedkey","Need Key");nameMap.set("webkitnetworkinfochange","Network Info Change");nameMap.set("webkitplaybacktargetavailabilitychanged","Playback Target Availability Changed");nameMap.set("webkitpointerlockchange","Pointer Lock Change");nameMap.set("webkitpointerlockerror","Pointer Lock Error");nameMap.set("webkitremovesourcebuffer","Remove Source Buffer");nameMap.set("webkitresourcetimingbufferfull","Resource Timing Buffer Full");nameMap.set("webkitsourceclose","Source Close");nameMap.set("webkitsourceended","Source Ended");nameMap.set("webkitsourceopen","Source Open");nameMap.set("writeend","Write End");nameMap.set("writestart","Write Start");WI.ScriptTimelineRecord._eventDisplayNames=nameMap;}
switch(eventType){case WI.ScriptTimelineRecord.EventType.ScriptEvaluated:case WI.ScriptTimelineRecord.EventType.APIScriptEvaluated:return WI.UIString("Script Evaluated");case WI.ScriptTimelineRecord.EventType.MicrotaskDispatched:return WI.UIString("Microtask Dispatched");case WI.ScriptTimelineRecord.EventType.EventDispatched:if(details&&(details instanceof String||typeof details==="string")){var eventDisplayName=WI.ScriptTimelineRecord._eventDisplayNames.get(details)||details.capitalize();return WI.UIString("%s Event Dispatched").format(eventDisplayName);}
return WI.UIString("Event Dispatched");case WI.ScriptTimelineRecord.EventType.ProbeSampleRecorded:return WI.UIString("Probe Sample Recorded");case WI.ScriptTimelineRecord.EventType.ConsoleProfileRecorded:if(details&&(details instanceof String||typeof details==="string"))
return WI.UIString("\u201C%s\u201D Profile Recorded").format(details);return WI.UIString("Console Profile Recorded");case WI.ScriptTimelineRecord.EventType.GarbageCollected:if(details&&(details instanceof WI.GarbageCollection)&&includeDetailsInMainTitle){switch(details.type){case WI.GarbageCollection.Type.Partial:return WI.UIString("Partial Garbage Collection");case WI.GarbageCollection.Type.Full:return WI.UIString("Full Garbage Collection");}}
return WI.UIString("Garbage Collection");case WI.ScriptTimelineRecord.EventType.TimerFired:if(details&&includeDetailsInMainTitle)
return WI.UIString("Timer %d Fired").format(details);return WI.UIString("Timer Fired");case WI.ScriptTimelineRecord.EventType.TimerInstalled:if(details&&includeDetailsInMainTitle)
return WI.UIString("Timer %d Installed").format(details.timerId);return WI.UIString("Timer Installed");case WI.ScriptTimelineRecord.EventType.TimerRemoved:if(details&&includeDetailsInMainTitle)
return WI.UIString("Timer %d Removed").format(details);return WI.UIString("Timer Removed");case WI.ScriptTimelineRecord.EventType.AnimationFrameFired:if(details&&includeDetailsInMainTitle)
return WI.UIString("Animation Frame %d Fired").format(details);return WI.UIString("Animation Frame Fired");case WI.ScriptTimelineRecord.EventType.ObserverCallback:if(details&&(details instanceof String||typeof details==="string"))
return WI.UIString("%s Callback").format(details);return WI.UIString("Observer Callback");case WI.ScriptTimelineRecord.EventType.AnimationFrameRequested:if(details&&includeDetailsInMainTitle)
return WI.UIString("Animation Frame %d Requested").format(details);return WI.UIString("Animation Frame Requested");case WI.ScriptTimelineRecord.EventType.AnimationFrameCanceled:if(details&&includeDetailsInMainTitle)
return WI.UIString("Animation Frame %d Canceled").format(details);return WI.UIString("Animation Frame Canceled");}};WI.ScriptTimelineRecord.TypeIdentifier="script-timeline-record";WI.ScriptTimelineRecord.EventTypeCookieKey="script-timeline-record-event-type";WI.ScriptTimelineRecord.DetailsCookieKey="script-timeline-record-details";WI.ServerTimingEntry=class ServerTimingEntry
{constructor(name)
{this._name=name;this._duration=undefined;this._description=undefined;}
static parseHeaders(valueString="")
{function trimLeadingWhiteSpace(){valueString=valueString.trimStart();}
function consumeDelimiter(char){trimLeadingWhiteSpace();if(valueString.charAt(0)!==char)
return false;valueString=valueString.substring(1);return true;}
function consumeToken(){let result=/^(?:\s*)([\w!#$%&'*+\-.^`|~]+)(?:\s*)(.*)/.exec(valueString);if(!result)
return null;valueString=result[2];return result[1];}
function consumeTokenOrQuotedString(){trimLeadingWhiteSpace();if(valueString.charAt(0)==="\"")
return consumeQuotedString();return consumeToken();}
function consumeQuotedString(){valueString=valueString.substring(1);let unescapedValueString="";for(let i=0;i<valueString.length;++i){let char=valueString.charAt(i);switch(char){case"\\":++i;if(i<valueString.length){unescapedValueString+=valueString.charAt(i);}
break;case"\"":valueString=valueString.substring(i+1);return unescapedValueString;default:unescapedValueString+=char;break;}}
valueString="";return null;}
function consumeExtraneous(){let result=/([,;].*)/.exec(valueString);if(result)
valueString=result[1];}
function getParserForParameter(paramName){switch(paramName){case"dur":return function(paramValue,entry){if(paramValue!==null){let duration=parseFloat(paramValue);if(!isNaN(duration)){entry.duration=duration;return;}}
entry.duration=0;};case"desc":return function(paramValue,entry){entry.description=paramValue||"";};default:return null;}}
let entries=[];let name;while((name=consumeToken())!==null){let entry=new WI.ServerTimingEntry(name);while(consumeDelimiter(";")){let paramName;if((paramName=consumeToken())===null)
continue;paramName=paramName.toLowerCase();let parseParameter=getParserForParameter(paramName);let paramValue=null;if(consumeDelimiter("=")){paramValue=consumeTokenOrQuotedString();consumeExtraneous();}
if(parseParameter)
parseParameter(paramValue,entry);else
console.warn("Unknown Server-Timing parameter:",paramName,paramValue);}
entries.push(entry);if(!consumeDelimiter(","))
break;}
return entries;}
get name(){return this._name;}
get duration(){return this._duration;}
get description(){return this._description;}
set duration(duration)
{if(this._duration!==undefined){console.warn("Ignoring redundant duration.");return;}
this._duration=duration;}
set description(description)
{if(this._description!==undefined){console.warn("Ignoring redundant description.");return;}
this._description=description;}};WI.ShaderProgram=class ShaderProgram extends WI.Object
{constructor(identifier,programType,canvas,{sharesVertexFragmentShader}={})
{super();this._identifier=identifier;this._programType=programType;this._canvas=canvas;this._sharesVertexFragmentShader=!!sharesVertexFragmentShader;this._disabled=false;}
static contextTypeSupportsProgramType(contextType,programType)
{switch(contextType){case WI.Canvas.ContextType.WebGL:case WI.Canvas.ContextType.WebGL2:return programType===ShaderProgram.ProgramType.Render;case WI.Canvas.ContextType.WebGPU:return programType===ShaderProgram.ProgramType.Compute||programType===ShaderProgram.ProgramType.Render;}
return false;}
static programTypeSupportsShaderType(programType,shaderType)
{switch(programType){case ShaderProgram.ProgramType.Compute:return shaderType===ShaderProgram.ShaderType.Compute;case ShaderProgram.ProgramType.Render:return shaderType===ShaderProgram.ShaderType.Fragment||shaderType===ShaderProgram.ShaderType.Vertex;}
return false;}
get identifier(){return this._identifier;}
get programType(){return this._programType;}
get canvas(){return this._canvas;}
get sharesVertexFragmentShader(){return this._sharesVertexFragmentShader;}
get displayName()
{let format=null;switch(this._canvas.contextType){case WI.Canvas.ContextType.WebGL:case WI.Canvas.ContextType.WebGL2:format=WI.UIString("Program %d");break;case WI.Canvas.ContextType.WebGPU:switch(this._programType){case ShaderProgram.ProgramType.Compute:format=WI.UIString("Compute Pipeline %d");break;case ShaderProgram.ProgramType.Render:format=WI.UIString("Render Pipeline %d");break;}
break;}
if(!this._uniqueDisplayNumber)
this._uniqueDisplayNumber=this._canvas.nextShaderProgramDisplayNumberForProgramType(this._programType);return format.format(this._uniqueDisplayNumber);}
get disabled()
{return this._disabled;}
set disabled(disabled)
{if(this._canvas.contextType===WI.Canvas.ContextType.WebGPU)
return;if(this._disabled===disabled)
return;this._disabled=disabled;let target=WI.assumingMainTarget();target.CanvasAgent.setShaderProgramDisabled(this._identifier,disabled);this.dispatchEventToListeners(ShaderProgram.Event.DisabledChanged);}
requestShaderSource(shaderType,callback)
{let target=WI.assumingMainTarget();target.CanvasAgent.requestShaderSource(this._identifier,shaderType,(error,source)=>{if(error){WI.reportInternalError(error);callback(null);return;}
callback(source);});}
updateShader(shaderType,source)
{let target=WI.assumingMainTarget();target.CanvasAgent.updateShader(this._identifier,shaderType,source);}
showHighlight()
{let target=WI.assumingMainTarget();target.CanvasAgent.setShaderProgramHighlighted(this._identifier,true);}
hideHighlight()
{let target=WI.assumingMainTarget();target.CanvasAgent.setShaderProgramHighlighted(this._identifier,false);}};WI.ShaderProgram.ProgramType={Compute:"compute",Render:"render",};WI.ShaderProgram.ShaderType={Compute:"compute",Fragment:"fragment",Vertex:"vertex",};WI.ShaderProgram.Event={DisabledChanged:"shader-program-disabled-changed",};WI.SourceCodePosition=class SourceCodePosition
{constructor(lineNumber,columNumber)
{this._lineNumber=lineNumber||0;this._columnNumber=columNumber||0;}
get lineNumber(){return this._lineNumber;}
get columnNumber(){return this._columnNumber;}
offsetColumn(delta)
{return new WI.SourceCodePosition(this._lineNumber,this._columnNumber+delta);}
equals(position)
{return this._lineNumber===position.lineNumber&&this._columnNumber===position.columnNumber;}
isBefore(position)
{if(this._lineNumber<position.lineNumber)
return true;if(this._lineNumber===position.lineNumber&&this._columnNumber<position.columnNumber)
return true;return false;}
isAfter(position)
{if(this._lineNumber>position.lineNumber)
return true;if(this._lineNumber===position.lineNumber&&this._columnNumber>position.columnNumber)
return true;return false;}
isWithin(startPosition,endPosition)
{if(this.equals(startPosition)||this.equals(endPosition))
return true;if(this.isAfter(startPosition)&&this.isBefore(endPosition))
return true;return false;}
toCodeMirror()
{return{line:this._lineNumber,ch:this._columnNumber};}};WI.SourceCodeRevision=class SourceCodeRevision extends WI.Revision
{constructor(sourceCode,content,base64Encoded,mimeType)
{super();this._sourceCode=sourceCode;this._content=content||"";this._base64Encoded=!!base64Encoded;this._mimeType=mimeType;this._blobContent=null;}
get sourceCode(){return this._sourceCode;}
get content(){return this._content;}
get base64Encoded(){return this._base64Encoded;}
get mimeType(){return this._mimeType;}
get blobContent()
{if(!this._blobContent&&this._content)
this._blobContent=WI.BlobUtilities.blobForContent(this._content,this._base64Encoded,this._mimeType);return this._blobContent;}
updateRevisionContent(content,{base64Encoded,mimeType,blobContent}={})
{this._content=content||"";if(base64Encoded!==undefined){this._base64Encoded=!!base64Encoded;}
if(mimeType!==undefined){this._mimeType=mimeType;}
this._blobContent=blobContent!==undefined?blobContent:null;this._sourceCode.revisionContentDidChange(this);}
apply()
{this._sourceCode.currentRevision=this;}
revert()
{this._sourceCode.currentRevision=this._sourceCode.originalRevision;}
copy()
{return new WI.SourceCodeRevision(this._sourceCode,this._content,this._base64Encoded,this._mimeType);}};WI.SourceCodeSearchMatchObject=class SourceCodeSearchMatchObject
{constructor(sourceCode,lineText,searchTerm,textRange)
{this._sourceCode=sourceCode;this._lineText=lineText;this._searchTerm=searchTerm;this._sourceCodeTextRange=sourceCode.createSourceCodeTextRange(textRange);}
get sourceCode(){return this._sourceCode;}
get title(){return this._lineText;}
get searchTerm(){return this._searchTerm;}
get sourceCodeTextRange(){return this._sourceCodeTextRange;}
get className()
{return"source-code-match";}
saveIdentityToCookie(cookie)
{if(this._sourceCode.url)
cookie[WI.SourceCodeSearchMatchObject.URLCookieKey]=this._sourceCode.url.hash;var textRange=this._sourceCodeTextRange.textRange;cookie[WI.SourceCodeSearchMatchObject.TextRangeKey]=[textRange.startLine,textRange.startColumn,textRange.endLine,textRange.endColumn].join();}};WI.SourceCodeSearchMatchObject.TypeIdentifier="source-code-search-match-object";WI.SourceCodeSearchMatchObject.URLCookieKey="source-code-url";WI.SourceCodeSearchMatchObject.TextRangeKey="text-range";WI.SourceCodeTextRange=class SourceCodeTextRange extends WI.Object
{constructor(sourceCode)
{super();this._sourceCode=sourceCode;if(arguments.length===2){var textRange=arguments[1];this._startLocation=sourceCode.createSourceCodeLocation(textRange.startLine,textRange.startColumn);this._endLocation=sourceCode.createSourceCodeLocation(textRange.endLine,textRange.endColumn);}else{this._startLocation=arguments[1];this._endLocation=arguments[2];}
this._startLocation.addEventListener(WI.SourceCodeLocation.Event.LocationChanged,this._sourceCodeLocationChanged,this);this._endLocation.addEventListener(WI.SourceCodeLocation.Event.LocationChanged,this._sourceCodeLocationChanged,this);}
get sourceCode()
{return this._sourceCode;}
get textRange()
{var startLine=this._startLocation.lineNumber;var startColumn=this._startLocation.columnNumber;var endLine=this._endLocation.lineNumber;var endColumn=this._endLocation.columnNumber;return new WI.TextRange(startLine,startColumn,endLine,endColumn);}
get formattedTextRange()
{var startLine=this._startLocation.formattedLineNumber;var startColumn=this._startLocation.formattedColumnNumber;var endLine=this._endLocation.formattedLineNumber;var endColumn=this._endLocation.formattedColumnNumber;return new WI.TextRange(startLine,startColumn,endLine,endColumn);}
get displaySourceCode()
{if(!this._startAndEndLocationsInSameMappedResource())
return this._sourceCode;return this._startLocation.displaySourceCode;}
get displayTextRange()
{if(!this._startAndEndLocationsInSameMappedResource())
return this.formattedTextRange;var startLine=this._startLocation.displayLineNumber;var startColumn=this._startLocation.displayColumnNumber;var endLine=this._endLocation.displayLineNumber;var endColumn=this._endLocation.displayColumnNumber;return new WI.TextRange(startLine,startColumn,endLine,endColumn);}
get synthesizedTextValue()
{return this._sourceCode.url+":"+(this._startLocation.lineNumber+1);}
_startAndEndLocationsInSameMappedResource()
{return this._startLocation.hasMappedLocation()&&this._endLocation.hasMappedLocation()&&this._startLocation.displaySourceCode===this._endLocation.displaySourceCode;}
_sourceCodeLocationChanged(event)
{this.dispatchEventToListeners(WI.SourceCodeLocation.Event.RangeChanged);}};WI.SourceCodeTextRange.Event={RangeChanged:"source-code-text-range-range-changed"};WI.SourceCodeTimeline=class SourceCodeTimeline extends WI.Timeline
{constructor(sourceCode,sourceCodeLocation,recordType,recordEventType)
{super();this._sourceCode=sourceCode;this._sourceCodeLocation=sourceCodeLocation||null;this._recordType=recordType;this._recordEventType=recordEventType||null;}
get sourceCode(){return this._sourceCode;}
get sourceCodeLocation(){return this._sourceCodeLocation;}
get recordType(){return this._recordType;}
get recordEventType(){return this._recordEventType;}
saveIdentityToCookie(cookie)
{cookie[WI.SourceCodeTimeline.SourceCodeURLCookieKey]=this._sourceCode.url?this._sourceCode.url.hash:null;cookie[WI.SourceCodeTimeline.SourceCodeLocationLineCookieKey]=this._sourceCodeLocation?this._sourceCodeLocation.lineNumber:null;cookie[WI.SourceCodeTimeline.SourceCodeLocationColumnCookieKey]=this._sourceCodeLocation?this._sourceCodeLocation.columnNumber:null;cookie[WI.SourceCodeTimeline.RecordTypeCookieKey]=this._recordType||null;cookie[WI.SourceCodeTimeline.RecordEventTypeCookieKey]=this._recordEventType||null;}};WI.SourceCodeTimeline.TypeIdentifier="source-code-timeline";WI.SourceCodeTimeline.SourceCodeURLCookieKey="source-code-timeline-source-code-url";WI.SourceCodeTimeline.SourceCodeLocationLineCookieKey="source-code-timeline-source-code-location-line";WI.SourceCodeTimeline.SourceCodeLocationColumnCookieKey="source-code-timeline-source-code-location-column";WI.SourceCodeTimeline.SourceCodeURLCookieKey="source-code-timeline-source-code-url";WI.SourceCodeTimeline.RecordTypeCookieKey="source-code-timeline-record-type";WI.SourceCodeTimeline.RecordEventTypeCookieKey="source-code-timeline-record-event-type";WI.SourceMap=class SourceMap
{constructor(sourceMappingURL,payload,originalSourceCode)
{if(!WI.SourceMap._base64Map){var base64Digits="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/";WI.SourceMap._base64Map={};for(var i=0;i<base64Digits.length;++i)
WI.SourceMap._base64Map[base64Digits.charAt(i)]=i;}
this._originalSourceCode=originalSourceCode||null;this._sourceMapResources={};this._sourceMapResourcesList=[];this._sourceMappingURL=sourceMappingURL;this._reverseMappingsBySourceURL={};this._mappings=[];this._sources={};this._sourceRoot=null;this._sourceContentByURL={};this._parseMappingPayload(payload);}
get originalSourceCode()
{return this._originalSourceCode;}
get sourceMappingBasePathURLComponents()
{if(this._sourceMappingURLBasePathComponents)
return this._sourceMappingURLBasePathComponents;if(this._sourceRoot){var baseURLPath=absoluteURL(this._sourceRoot,this._sourceMappingURL);if(baseURLPath){var urlComponents=parseURL(baseURLPath);if(!/\/$/.test(urlComponents.path))
urlComponents.path+="/";this._sourceMappingURLBasePathComponents=urlComponents;return this._sourceMappingURLBasePathComponents;}}
var urlComponents=parseURL(this._sourceMappingURL);if(!urlComponents.path)
urlComponents.path=this._sourceMappingURL||"";urlComponents.path=urlComponents.path.substr(0,urlComponents.path.lastIndexOf(urlComponents.lastPathComponent));urlComponents.lastPathComponent=null;this._sourceMappingURLBasePathComponents=urlComponents;return this._sourceMappingURLBasePathComponents;}
get resources()
{return this._sourceMapResourcesList;}
addResource(resource)
{this._sourceMapResources[resource.url]=resource;this._sourceMapResourcesList.push(resource);}
resourceForURL(url)
{return this._sourceMapResources[url];}
sources()
{return Object.keys(this._sources);}
sourceContent(sourceURL)
{return this._sourceContentByURL[sourceURL];}
_parseMappingPayload(mappingPayload)
{if(mappingPayload.sections)
this._parseSections(mappingPayload.sections);else
this._parseMap(mappingPayload,0,0);}
_parseSections(sections)
{for(var i=0;i<sections.length;++i){var section=sections[i];this._parseMap(section.map,section.offset.line,section.offset.column);}}
findEntry(lineNumber,columnNumber)
{var first=0;var count=this._mappings.length;while(count>1){var step=count>>1;var middle=first+step;var mapping=this._mappings[middle];if(lineNumber<mapping[0]||(lineNumber===mapping[0]&&columnNumber<mapping[1]))
count=step;else{first=middle;count-=step;}}
var entry=this._mappings[first];if(!first&&entry&&(lineNumber<entry[0]||(lineNumber===entry[0]&&columnNumber<entry[1])))
return null;return entry;}
findEntryReversed(sourceURL,lineNumber)
{var mappings=this._reverseMappingsBySourceURL[sourceURL];for(;lineNumber<mappings.length;++lineNumber){var mapping=mappings[lineNumber];if(mapping)
return mapping;}
return this._mappings[0];}
_parseMap(map,lineNumber,columnNumber)
{var sourceIndex=0;var sourceLineNumber=0;var sourceColumnNumber=0;var nameIndex=0;var sources=[];var originalToCanonicalURLMap={};for(var i=0;i<map.sources.length;++i){var originalSourceURL=map.sources[i];var href=originalSourceURL;if(map.sourceRoot&&href.charAt(0)!=="/")
href=map.sourceRoot.replace(/\/+$/,"")+"/"+href;var url=absoluteURL(href,this._sourceMappingURL)||href;originalToCanonicalURLMap[originalSourceURL]=url;sources.push(url);this._sources[url]=true;if(map.sourcesContent&&map.sourcesContent[i])
this._sourceContentByURL[url]=map.sourcesContent[i];}
this._sourceRoot=map.sourceRoot||null;var stringCharIterator=new WI.SourceMap.StringCharIterator(map.mappings);var sourceURL=sources[sourceIndex];while(true){if(stringCharIterator.peek()===",")
stringCharIterator.next();else{while(stringCharIterator.peek()===";"){lineNumber+=1;columnNumber=0;stringCharIterator.next();}
if(!stringCharIterator.hasNext())
break;}
columnNumber+=this._decodeVLQ(stringCharIterator);if(this._isSeparator(stringCharIterator.peek())){this._mappings.push([lineNumber,columnNumber]);continue;}
var sourceIndexDelta=this._decodeVLQ(stringCharIterator);if(sourceIndexDelta){sourceIndex+=sourceIndexDelta;sourceURL=sources[sourceIndex];}
sourceLineNumber+=this._decodeVLQ(stringCharIterator);sourceColumnNumber+=this._decodeVLQ(stringCharIterator);if(!this._isSeparator(stringCharIterator.peek()))
nameIndex+=this._decodeVLQ(stringCharIterator);this._mappings.push([lineNumber,columnNumber,sourceURL,sourceLineNumber,sourceColumnNumber]);}
for(var i=0;i<this._mappings.length;++i){var mapping=this._mappings[i];var url=mapping[2];if(!url)
continue;if(!this._reverseMappingsBySourceURL[url])
this._reverseMappingsBySourceURL[url]=[];var reverseMappings=this._reverseMappingsBySourceURL[url];var sourceLine=mapping[3];if(!reverseMappings[sourceLine])
reverseMappings[sourceLine]=[mapping[0],mapping[1]];}}
_isSeparator(char)
{return char===","||char===";";}
_decodeVLQ(stringCharIterator)
{var result=0;var shift=0;do{var digit=WI.SourceMap._base64Map[stringCharIterator.next()];result+=(digit&WI.SourceMap.VLQ_BASE_MASK)<<shift;shift+=WI.SourceMap.VLQ_BASE_SHIFT;}while(digit&WI.SourceMap.VLQ_CONTINUATION_MASK);var negative=result&1;result>>=1;return negative?-result:result;}};WI.SourceMap.VLQ_BASE_SHIFT=5;WI.SourceMap.VLQ_BASE_MASK=(1<<5)-1;WI.SourceMap.VLQ_CONTINUATION_MASK=1<<5;WI.SourceMap.StringCharIterator=class StringCharIterator
{constructor(string)
{this._string=string;this._position=0;}
next()
{return this._string.charAt(this._position++);}
peek()
{return this._string.charAt(this._position);}
hasNext()
{return this._position<this._string.length;}};WI.StackTrace=class StackTrace
{constructor(callFrames,{topCallFrameIsBoundary,truncated,parentStackTrace}={})
{this._callFrames=callFrames;this._topCallFrameIsBoundary=topCallFrameIsBoundary||false;this._truncated=truncated||false;this._parentStackTrace=parentStackTrace||null;}
static fromPayload(target,payload)
{let result=null;let previousStackTrace=null;while(payload){let callFrames=payload.callFrames.map((x)=>WI.CallFrame.fromPayload(target,x));let stackTrace=new WI.StackTrace(callFrames,{topCallFrameIsBoundary:payload.topCallFrameIsBoundary,truncated:payload.truncated,});if(!result)
result=stackTrace;if(previousStackTrace)
previousStackTrace._parentStackTrace=stackTrace;previousStackTrace=stackTrace;payload=payload.parentStackTrace;}
return result;}
static fromString(target,stack)
{let callFrames=WI.StackTrace._parseStackTrace(stack);return WI.StackTrace.fromPayload(target,{callFrames});}
static isLikelyStackTrace(stack)
{const smallestPossibleStackTraceLength="http://a.bc/:9:1".length;if(stack.length<smallestPossibleStackTraceLength.length*2)
return false;const approximateStackLengthOf50Items=5000;if(stack.length>approximateStackLengthOf50Items)
return false;if(/^[^a-z$_@]/i.test(stack[0]))
return false;if(!WI.StackTrace._likelyStackTraceRegex){const reasonablyLongProtocolLength=10;const reasonablyLongLineLength=500;const reasonablyLongNativeMethodLength=120;const stackTraceLine=`(global code|eval code|module code|\\w+)?([^:]{1,${reasonablyLongProtocolLength}}://[^:]{1,${reasonablyLongLineLength}}:\\d+:\\d+|[^@]{1,${reasonablyLongNativeMethodLength}}@\\[native code\\])`;WI.StackTrace._likelyStackTraceRegex=new RegExp(`^${stackTraceLine}([\\n\\r]${stackTraceLine})+$`);}
WI.StackTrace._likelyStackTraceRegex.lastIndex=0;return WI.StackTrace._likelyStackTraceRegex.test(stack);}
static _parseStackTrace(stack)
{var lines=stack.split(/\n/g);var result=[];for(var line of lines){var functionName="";var url="";var lineNumber=0;var columnNumber=0;var atIndex=line.indexOf("@");if(atIndex!==-1){functionName=line.slice(0,atIndex);({url,lineNumber,columnNumber}=WI.StackTrace._parseLocation(line.slice(atIndex+1)));}else if(line.includes("/"))
({url,lineNumber,columnNumber}=WI.StackTrace._parseLocation(line));else
functionName=line;result.push({functionName,url,lineNumber,columnNumber});}
return result;}
static _parseLocation(locationString)
{var result={url:"",lineNumber:0,columnNumber:0};var locationRegEx=/(.+?)(?::(\d+)(?::(\d+))?)?$/;var matched=locationString.match(locationRegEx);if(!matched)
return result;result.url=matched[1];if(matched[2])
result.lineNumber=parseInt(matched[2]);if(matched[3])
result.columnNumber=parseInt(matched[3]);return result;}
get callFrames(){return this._callFrames;}
get topCallFrameIsBoundary(){return this._topCallFrameIsBoundary;}
get truncated(){return this._truncated;}
get parentStackTrace(){return this._parentStackTrace;}
get firstNonNativeNonAnonymousNotBlackboxedCallFrame()
{let firstNonNativeNonAnonymousCallFrame=null;for(let frame of this._callFrames){if(frame.nativeCode)
continue;if(frame.sourceCodeLocation){let sourceCode=frame.sourceCodeLocation.sourceCode;if(sourceCode instanceof WI.Script&&sourceCode.anonymous)
continue;firstNonNativeNonAnonymousCallFrame??=frame;}
if(frame.blackboxed)
continue;return frame;}
return firstNonNativeNonAnonymousCallFrame;}};WI.StructureDescription=class StructureDescription
{constructor(fields,optionalFields,constructorName,prototypeStructure,imprecise)
{this._fields=fields||null;this._optionalFields=optionalFields||null;this._constructorName=constructorName||"";this._prototypeStructure=prototypeStructure||null;this._imprecise=imprecise||false;}
static fromPayload(payload)
{if(payload.prototypeStructure)
payload.prototypeStructure=WI.StructureDescription.fromPayload(payload.prototypeStructure);return new WI.StructureDescription(payload.fields,payload.optionalFields,payload.constructorName,payload.prototypeStructure,payload.imprecise);}
get fields(){return this._fields;}
get optionalFields(){return this._optionalFields;}
get constructorName(){return this._constructorName;}
get prototypeStructure(){return this._prototypeStructure;}
get imprecise(){return this._imprecise;}};WI.TextMarker=class TextMarker
{constructor(codeMirrorTextMarker,type)
{this._codeMirrorTextMarker=codeMirrorTextMarker;codeMirrorTextMarker.__webInspectorTextMarker=this;this._type=type||WI.TextMarker.Type.Plain;}
static textMarkerForCodeMirrorTextMarker(codeMirrorTextMarker)
{return codeMirrorTextMarker.__webInspectorTextMarker||new WI.TextMarker(codeMirrorTextMarker);}
get codeMirrorTextMarker()
{return this._codeMirrorTextMarker;}
get type()
{return this._type;}
get range()
{var range=this._codeMirrorTextMarker.find();if(!range)
return null;return new WI.TextRange(range.from.line,range.from.ch,range.to.line,range.to.ch);}
get rects()
{var range=this._codeMirrorTextMarker.find();if(!range)
return WI.Rect.ZERO_RECT;return this._codeMirrorTextMarker.doc.cm.rectsForRange({start:range.from,end:range.to});}
clear()
{this._codeMirrorTextMarker.clear();}};WI.TextMarker.Type={Color:"text-marker-type-color",Gradient:"text-marker-type-gradient",Plain:"text-marker-type-plain",CubicBezier:"text-marker-type-cubic-bezier",Spring:"text-marker-type-spring",Variable:"text-marker-type-variable",};WI.TextRange=class TextRange
{constructor(startLineOrStartOffset,startColumnOrEndOffset,endLine,endColumn)
{if(arguments.length===4){this._startLine=typeof startLineOrStartOffset==="number"?startLineOrStartOffset:NaN;this._startColumn=typeof startColumnOrEndOffset==="number"?startColumnOrEndOffset:NaN;this._endLine=typeof endLine==="number"?endLine:NaN;this._endColumn=typeof endColumn==="number"?endColumn:NaN;this._startOffset=NaN;this._endOffset=NaN;}else if(arguments.length===2){this._startOffset=typeof startLineOrStartOffset==="number"?startLineOrStartOffset:NaN;this._endOffset=typeof startColumnOrEndOffset==="number"?startColumnOrEndOffset:NaN;this._startLine=NaN;this._startColumn=NaN;this._endLine=NaN;this._endColumn=NaN;}}
static fromText(text)
{let lines=text.split("\n");return new WI.TextRange(0,0,lines.length-1,lines.lastValue.length);}
get startLine(){return this._startLine;}
get startColumn(){return this._startColumn;}
get endLine(){return this._endLine;}
get endColumn(){return this._endColumn;}
get startOffset(){return this._startOffset;}
get endOffset(){return this._endOffset;}
startPosition()
{return new WI.SourceCodePosition(this._startLine,this._startColumn);}
endPosition()
{return new WI.SourceCodePosition(this._endLine,this._endColumn);}
resolveOffsets(text)
{if(typeof text!=="string")
return;if(isNaN(this._startLine)||isNaN(this._startColumn)||isNaN(this._endLine)||isNaN(this._endColumn))
return;var lastNewLineOffset=0;for(var i=0;i<this._startLine;++i)
lastNewLineOffset=text.indexOf("\n",lastNewLineOffset)+1;this._startOffset=lastNewLineOffset+this._startColumn;for(var i=this._startLine;i<this._endLine;++i)
lastNewLineOffset=text.indexOf("\n",lastNewLineOffset)+1;this._endOffset=lastNewLineOffset+this._endColumn;}
contains(line,column)
{if(line<this._startLine||line>this._endLine)
return false;if(line===this._startLine&&column<this._startColumn)
return false;if(line===this._endLine&&column>this._endColumn)
return false;return true;}
clone()
{return new WI.TextRange(this._startLine,this._startColumn,this._endLine,this._endColumn);}
cloneAndModify(deltaStartLine,deltaStartColumn,deltaEndLine,deltaEndColumn)
{let startLine=this._startLine+deltaStartLine;let startColumn=this._startColumn+deltaStartColumn;let endLine=this._endLine+deltaEndLine;let endColumn=this._endColumn+deltaEndColumn;return new WI.TextRange(startLine,startColumn,endLine,endColumn);}
collapseToStart()
{return new WI.TextRange(this._startLine,this._startColumn,this._startLine,this._startColumn);}
collapseToEnd()
{return new WI.TextRange(this._endLine,this._endColumn,this._endLine,this._endColumn);}
relativeTo(line,column)
{let deltaStartColumn=0;if(this._startLine===line)
deltaStartColumn=-column;let deltaEndColumn=0;if(this._endLine===line)
deltaEndColumn=-column;return this.cloneAndModify(-line,deltaStartColumn,-line,deltaEndColumn);}};WI.TimelineMarker=class TimelineMarker extends WI.Object
{constructor(time,type,details)
{super();this._time=time||0;this._type=type;this._details=details||null;}
static fromJSON(json)
{let{time,type,details}=json;return new WI.TimelineMarker(time,type,details);}
toJSON()
{return{time:this._time,type:this._type,details:this._details||undefined,};}
get type(){return this._type;}
get details(){return this._details;}
get time()
{return this._time;}
set time(x)
{x=x||0;if(this._time===x)
return;this._time=x;this.dispatchEventToListeners(WI.TimelineMarker.Event.TimeChanged);}};WI.TimelineMarker.Event={TimeChanged:"timeline-marker-time-changed"};WI.TimelineMarker.Type={CurrentTime:"current-time",LoadEvent:"load-event",DOMContentEvent:"dom-content-event",TimeStamp:"timestamp",Scanner:"scanner",};WI.TimelineRecording=class TimelineRecording extends WI.Object
{constructor(identifier,displayName,instruments)
{super();this._identifier=identifier;this._timelines=new Map;this._displayName=displayName;this._capturing=false;this._readonly=false;this._imported=false;this._instruments=instruments||[];this._startTime=NaN;this._endTime=NaN;this._discontinuityStartTime=NaN;this._discontinuities=null;this._firstRecordOfTypeAfterDiscontinuity=new Set;this._exportDataRecords=null;this._exportDataMarkers=null;this._exportDataMemoryPressureEvents=null;this._exportDataSampleStackTraces=null;this._exportDataSampleDurations=null;this._topDownCallingContextTree=new WI.CallingContextTree(WI.CallingContextTree.Type.TopDown);this._bottomUpCallingContextTree=new WI.CallingContextTree(WI.CallingContextTree.Type.BottomUp);this._topFunctionsTopDownCallingContextTree=new WI.CallingContextTree(WI.CallingContextTree.Type.TopFunctionsTopDown);this._topFunctionsBottomUpCallingContextTree=new WI.CallingContextTree(WI.CallingContextTree.Type.TopFunctionsBottomUp);for(let type of WI.TimelineManager.availableTimelineTypes()){let timeline=WI.Timeline.create(type);this._timelines.set(type,timeline);timeline.addEventListener(WI.Timeline.Event.TimesUpdated,this._timelineTimesUpdated,this);}
this.reset(true);}
static sourceCodeTimelinesSupported()
{return WI.sharedApp.isWebDebuggable();}
static async import(identifier,json,displayName)
{let{startTime,endTime,discontinuities,instrumentTypes,records,markers,memoryPressureEvents,sampleStackTraces,sampleDurations}=json;let importedDisplayName=WI.UIString("Imported - %s").format(displayName);let instruments=instrumentTypes.map((type)=>WI.Instrument.createForTimelineType(type));let recording=new WI.TimelineRecording(identifier,importedDisplayName,instruments);recording._readonly=true;recording._imported=true;recording._startTime=startTime;recording._endTime=endTime;recording._discontinuities=discontinuities;recording.initializeCallingContextTrees(sampleStackTraces,sampleDurations);for(let recordJSON of records){let record=await WI.TimelineRecord.fromJSON(recordJSON);if(record){recording.addRecord(record);if(record instanceof WI.ScriptTimelineRecord)
record.profilePayload=recording._topDownCallingContextTree.toCPUProfilePayload(record.startTime,record.endTime);}}
for(let memoryPressureJSON of memoryPressureEvents){let memoryPressureEvent=WI.MemoryPressureEvent.fromJSON(memoryPressureJSON);if(memoryPressureEvent)
recording.addMemoryPressureEvent(memoryPressureEvent);}
setTimeout(()=>{recording.__importing=true;for(let markerJSON of markers){let marker=WI.TimelineMarker.fromJSON(markerJSON);if(marker)
recording.addEventMarker(marker);}
recording.__importing=false;});return recording;}
exportData()
{return{displayName:this._displayName,startTime:this._startTime,endTime:this._endTime,discontinuities:this._discontinuities,instrumentTypes:this._instruments.map((instrument)=>instrument.timelineRecordType),records:this._exportDataRecords,markers:this._exportDataMarkers,memoryPressureEvents:this._exportDataMemoryPressureEvents,sampleStackTraces:this._exportDataSampleStackTraces,sampleDurations:this._exportDataSampleDurations,};}
get displayName(){return this._displayName;}
get identifier(){return this._identifier;}
get timelines(){return this._timelines;}
get instruments(){return this._instruments;}
get capturing(){return this._capturing;}
get readonly(){return this._readonly;}
get imported(){return this._imported;}
get startTime(){return this._startTime;}
get endTime(){return this._endTime;}
get topDownCallingContextTree(){return this._topDownCallingContextTree;}
get bottomUpCallingContextTree(){return this._bottomUpCallingContextTree;}
get topFunctionsTopDownCallingContextTree(){return this._topFunctionsTopDownCallingContextTree;}
get topFunctionsBottomUpCallingContextTree(){return this._topFunctionsBottomUpCallingContextTree;}
start(initiatedByBackend)
{this._capturing=true;for(let instrument of this._instruments)
instrument.startInstrumentation(initiatedByBackend);if(!isNaN(this._discontinuityStartTime)){for(let instrument of this._instruments)
this._firstRecordOfTypeAfterDiscontinuity.add(instrument.timelineRecordType);}}
stop(initiatedByBackend)
{this._capturing=false;for(let instrument of this._instruments)
instrument.stopInstrumentation(initiatedByBackend);}
capturingStarted(startTime)
{if(!isNaN(this._discontinuityStartTime)){this._discontinuities.push({startTime:this._discontinuityStartTime,endTime:startTime,});this._discontinuityStartTime=NaN;}}
capturingStopped(endTime)
{this._discontinuityStartTime=endTime;}
saveIdentityToCookie()
{}
isEmpty()
{for(var timeline of this._timelines.values()){if(timeline.records.length)
return false;}
return true;}
unloaded(importing)
{this._readonly=true;this.dispatchEventToListeners(WI.TimelineRecording.Event.Unloaded);}
reset(suppressEvents)
{this._sourceCodeTimelinesMap=new Map;this._startTime=NaN;this._endTime=NaN;this._discontinuityStartTime=NaN;this._discontinuities=[];this._firstRecordOfTypeAfterDiscontinuity.clear();this._exportDataRecords=[];this._exportDataMarkers=[];this._exportDataMemoryPressureEvents=[];this._exportDataSampleStackTraces=[];this._exportDataSampleDurations=[];this._topDownCallingContextTree.reset();this._bottomUpCallingContextTree.reset();this._topFunctionsTopDownCallingContextTree.reset();this._topFunctionsBottomUpCallingContextTree.reset();for(var timeline of this._timelines.values())
timeline.reset(suppressEvents);WI.RenderingFrameTimelineRecord.resetFrameIndex();if(!suppressEvents){this.dispatchEventToListeners(WI.TimelineRecording.Event.Reset);this.dispatchEventToListeners(WI.TimelineRecording.Event.TimesUpdated);}}
get sourceCodeTimelines()
{let timelines=[];for(let timelinesForSourceCode of this._sourceCodeTimelinesMap.values())
timelines.pushAll(timelinesForSourceCode.values());return timelines;}
timelineForInstrument(instrument)
{return this._timelines.get(instrument.timelineRecordType);}
instrumentForTimeline(timeline)
{return this._instruments.find((instrument)=>instrument.timelineRecordType===timeline.type);}
timelineForRecordType(recordType)
{return this._timelines.get(recordType);}
addInstrument(instrument)
{this._instruments.push(instrument);this.dispatchEventToListeners(WI.TimelineRecording.Event.InstrumentAdded,{instrument});}
removeInstrument(instrument)
{this._instruments.remove(instrument);this.dispatchEventToListeners(WI.TimelineRecording.Event.InstrumentRemoved,{instrument});}
addEventMarker(marker)
{this._exportDataMarkers.push(marker);if(!this._capturing&&!this.__importing)
return;this.dispatchEventToListeners(WI.TimelineRecording.Event.MarkerAdded,{marker});}
addRecord(record)
{this._exportDataRecords.push(record);let timeline=this._timelines.get(record.type);if(!timeline)
return;let discontinuity=null;if(this._firstRecordOfTypeAfterDiscontinuity.take(record.type))
discontinuity=this._discontinuities.lastValue;timeline.addRecord(record,{discontinuity});if(record.type===WI.TimelineRecord.Type.Network||record.type===WI.TimelineRecord.Type.RenderingFrame||record.type===WI.TimelineRecord.Type.CPU||record.type===WI.TimelineRecord.Type.Memory||record.type===WI.TimelineRecord.Type.HeapAllocations||record.type===WI.TimelineRecord.Type.Screenshots)
return;if(!WI.TimelineRecording.sourceCodeTimelinesSupported())
return;let sourceCode=null;if(record.sourceCodeLocation)
sourceCode=record.sourceCodeLocation.sourceCode;else if(record.type===WI.TimelineRecord.Type.Media){if(record.domNode&&record.domNode.frame)
sourceCode=record.domNode.frame.mainResource;}
if(!sourceCode)
sourceCode=WI.networkManager.mainFrame.provisionalMainResource||WI.networkManager.mainFrame.mainResource;var sourceCodeTimelines=this._sourceCodeTimelinesMap.get(sourceCode);if(!sourceCodeTimelines){sourceCodeTimelines=new Map;this._sourceCodeTimelinesMap.set(sourceCode,sourceCodeTimelines);}
var newTimeline=false;var key=this._keyForRecord(record);var sourceCodeTimeline=sourceCodeTimelines.get(key);if(!sourceCodeTimeline){sourceCodeTimeline=new WI.SourceCodeTimeline(sourceCode,record.sourceCodeLocation,record.type,record.eventType);sourceCodeTimelines.set(key,sourceCodeTimeline);newTimeline=true;}
sourceCodeTimeline.addRecord(record);if(newTimeline)
this.dispatchEventToListeners(WI.TimelineRecording.Event.SourceCodeTimelineAdded,{sourceCodeTimeline});}
addMemoryPressureEvent(memoryPressureEvent)
{this._exportDataMemoryPressureEvents.push(memoryPressureEvent);let memoryTimeline=this._timelines.get(WI.TimelineRecord.Type.Memory);if(!memoryTimeline)
return;memoryTimeline.addMemoryPressureEvent(memoryPressureEvent);}
discontinuitiesInTimeRange(startTime,endTime)
{return this._discontinuities.filter((item)=>item.startTime<=endTime&&item.endTime>=startTime);}
addScriptInstrumentForProgrammaticCapture()
{for(let instrument of this._instruments){if(instrument instanceof WI.ScriptInstrument)
return;}
this.addInstrument(new WI.ScriptInstrument);let instrumentTypes=this._instruments.map((instrument)=>instrument.timelineRecordType);WI.timelineManager.enabledTimelineTypes=instrumentTypes;}
computeElapsedTime(timestamp)
{if(!timestamp||isNaN(timestamp))
return NaN;return timestamp;}
initializeTimeBoundsIfNecessary(timestamp)
{if(isNaN(this._startTime)){this._startTime=timestamp;this._endTime=timestamp;this.dispatchEventToListeners(WI.TimelineRecording.Event.TimesUpdated);}}
initializeCallingContextTrees(stackTraces,sampleDurations)
{this._exportDataSampleStackTraces.pushAll(stackTraces);this._exportDataSampleDurations.pushAll(sampleDurations);for(let i=0;i<stackTraces.length;i++){this._topDownCallingContextTree.updateTreeWithStackTrace(stackTraces[i],sampleDurations[i]);this._bottomUpCallingContextTree.updateTreeWithStackTrace(stackTraces[i],sampleDurations[i]);this._topFunctionsTopDownCallingContextTree.updateTreeWithStackTrace(stackTraces[i],sampleDurations[i]);this._topFunctionsBottomUpCallingContextTree.updateTreeWithStackTrace(stackTraces[i],sampleDurations[i]);}}
get exportMode()
{return WI.FileUtilities.SaveMode.SingleFile;}
canExport()
{if(!WI.FileUtilities.canSave(this.exportMode))
return false;if(this._capturing)
return false;if(isNaN(this._startTime))
return false;return true;}
_keyForRecord(record)
{var key=record.type;if(record instanceof WI.ScriptTimelineRecord||record instanceof WI.LayoutTimelineRecord)
key+=":"+record.eventType;if(record instanceof WI.ScriptTimelineRecord&&record.eventType===WI.ScriptTimelineRecord.EventType.EventDispatched)
key+=":"+record.details;if(record instanceof WI.MediaTimelineRecord){key+=":"+record.eventType;if(record.eventType===WI.MediaTimelineRecord.EventType.DOMEvent){if(record.domEvent&&record.domEvent.eventName)
key+=":"+record.domEvent.eventName;}else if(record.eventType===WI.MediaTimelineRecord.EventType.PowerEfficientPlaybackStateChanged)
key+=":"+(record.isPowerEfficient?"enabled":"disabled");}
if(record.sourceCodeLocation)
key+=":"+record.sourceCodeLocation.lineNumber+":"+record.sourceCodeLocation.columnNumber;return key;}
_timelineTimesUpdated(event)
{var timeline=event.target;var changed=false;if(isNaN(this._startTime)||timeline.startTime<this._startTime){this._startTime=timeline.startTime;changed=true;}
if(isNaN(this._endTime)||this._endTime<timeline.endTime){this._endTime=timeline.endTime;changed=true;}
if(changed)
this.dispatchEventToListeners(WI.TimelineRecording.Event.TimesUpdated);}};WI.TimelineRecording.Event={Reset:"timeline-recording-reset",Unloaded:"timeline-recording-unloaded",SourceCodeTimelineAdded:"timeline-recording-source-code-timeline-added",InstrumentAdded:"timeline-recording-instrument-added",InstrumentRemoved:"timeline-recording-instrument-removed",TimesUpdated:"timeline-recording-times-updated",MarkerAdded:"timeline-recording-marker-added",};WI.TimelineRecording.SerializationVersion=1;WI.TypeDescription=class TypeDescription
{constructor(leastCommonAncestor,typeSet,structures,valid,truncated)
{this._leastCommonAncestor=leastCommonAncestor||null;this._typeSet=typeSet||null;this._structures=structures||null;this._valid=valid||false;this._truncated=truncated||false;}
static fromPayload(payload)
{var typeSet=undefined;if(payload.typeSet)
typeSet=WI.TypeSet.fromPayload(payload.typeSet);var structures=undefined;if(payload.structures)
structures=payload.structures.map(WI.StructureDescription.fromPayload);return new WI.TypeDescription(payload.leastCommonAncestor,typeSet,structures,payload.isValid,payload.isTruncated);}
get leastCommonAncestor(){return this._leastCommonAncestor;}
get typeSet(){return this._typeSet;}
get structures(){return this._structures;}
get valid(){return this._valid;}
get truncated(){return this._truncated;}};WI.TypeSet=class TypeSet
{constructor(typeSet)
{var bitString=0x0;if(typeSet.isFunction)
bitString|=WI.TypeSet.TypeBit.Function;if(typeSet.isUndefined)
bitString|=WI.TypeSet.TypeBit.Undefined;if(typeSet.isNull)
bitString|=WI.TypeSet.TypeBit.Null;if(typeSet.isBoolean)
bitString|=WI.TypeSet.TypeBit.Boolean;if(typeSet.isInteger)
bitString|=WI.TypeSet.TypeBit.Integer;if(typeSet.isNumber)
bitString|=WI.TypeSet.TypeBit.Number;if(typeSet.isString)
bitString|=WI.TypeSet.TypeBit.String;if(typeSet.isObject)
bitString|=WI.TypeSet.TypeBit.Object;if(typeSet.isSymbol)
bitString|=WI.TypeSet.TypeBit.Symbol;if(typeSet.isBigInt)
bitString|=WI.TypeSet.TypeBit.BigInt;this._typeSet=typeSet;this._bitString=bitString;this._primitiveTypeNames=null;}
static fromPayload(payload)
{return new WI.TypeSet(payload);}
isContainedIn(test)
{return this._bitString&&(this._bitString&test)===this._bitString;}
get primitiveTypeNames()
{if(this._primitiveTypeNames)
return this._primitiveTypeNames;this._primitiveTypeNames=[];var typeSet=this._typeSet;if(typeSet.isUndefined)
this._primitiveTypeNames.push("Undefined");if(typeSet.isNull)
this._primitiveTypeNames.push("Null");if(typeSet.isBoolean)
this._primitiveTypeNames.push("Boolean");if(typeSet.isString)
this._primitiveTypeNames.push("String");if(typeSet.isSymbol)
this._primitiveTypeNames.push("Symbol");if(typeSet.isBigInt)
this._primitiveTypeNames.push("BigInt");if(typeSet.isNumber)
this._primitiveTypeNames.push("Number");else if(typeSet.isInteger)
this._primitiveTypeNames.push("Integer");return this._primitiveTypeNames;}};WI.TypeSet.TypeBit={"Function":0x1,"Undefined":0x2,"Null":0x4,"Boolean":0x8,"Integer":0x10,"Number":0x20,"String":0x40,"Object":0x80,"Symbol":0x100,"BigInt":0x200,};WI.TypeSet.NullOrUndefinedTypeBits=WI.TypeSet.TypeBit.Null|WI.TypeSet.TypeBit.Undefined;WI.URLBreakpoint=class URLBreakpoint extends WI.Breakpoint
{constructor(type,url,{disabled,actions,condition,ignoreCount,autoContinue}={})
{super({disabled,actions,condition,ignoreCount,autoContinue});this._type=type;this._url=url;}
static get supportsEditing()
{return InspectorBackend.hasCommand("DOMDebugger.setURLBreakpoint","options");}
static fromJSON(json)
{return new WI.URLBreakpoint(json.type,json.url,{disabled:json.disabled,condition:json.condition,actions:json.actions?.map((actionJSON)=>WI.BreakpointAction.fromJSON(actionJSON))||[],ignoreCount:json.ignoreCount,autoContinue:json.autoContinue,});}
get type(){return this._type;}
get url(){return this._url;}
get displayName()
{if(this===WI.domDebuggerManager.allRequestsBreakpoint)
return WI.repeatedUIString.allRequests();switch(this._type){case WI.URLBreakpoint.Type.Text:return doubleQuotedString(this._url);case WI.URLBreakpoint.Type.RegularExpression:return"/"+this._url+"/";}
return WI.UIString("URL");}
get special()
{return this===WI.domDebuggerManager.allRequestsBreakpoint||super.special;}
get editable()
{return WI.URLBreakpoint.supportsEditing||super.editable;}
remove()
{super.remove();WI.domDebuggerManager.removeURLBreakpoint(this);}
saveIdentityToCookie(cookie)
{cookie["url-breakpoint-type"]=this._type;cookie["url-breakpoint-url"]=this._url;}
toJSON(key)
{let json=super.toJSON(key);json.type=this._type;json.url=this._url;if(key===WI.ObjectStore.toJSONSymbol)
json[WI.objectStores.urlBreakpoints.keyPath]=this._type+":"+this._url;return json;}};WI.URLBreakpoint.Type={Text:"text",RegularExpression:"regex",};WI.URLBreakpoint.ReferencePage=WI.ReferencePage.URLBreakpoints;WI.WebInspectorExtension=class WebInspectorExtension
{constructor(extensionID,extensionBundleIdentifier,displayName)
{this._extensionID=extensionID;this._extensionBundleIdentifier=extensionBundleIdentifier;this._displayName=displayName;}
get extensionID(){return this._extensionID;}
get extensionBundleIdentifier(){return this._extensionBundleIdentifier;}
get displayName(){return this._displayName;}};WI.WebInspectorExtension.ErrorCode={ContextDestroyed:"ContextDestroyed",InternalError:"InternalError",InvalidRequest:"InvalidRequest",RegistrationFailed:"RegistrationFailed",NotImplemented:"NotImplemented",};WI.WebSocketResource=class WebSocketResource extends WI.Resource
{constructor(url,{loaderIdentifier,requestIdentifier,requestHeaders,timestamp,walltime,requestSentTimestamp}={})
{super(url,{type:WI.Resource.Type.WebSocket,loaderIdentifier,requestIdentifier,requestMethod:"GET",requestHeaders,requestSentTimestamp,});this._timestamp=timestamp;this._walltime=walltime;this._readyState=WI.WebSocketResource.ReadyState.Connecting;this._frames=[];}
get frames(){return this._frames;}
get walltime(){return this._walltime;}
get readyState()
{return this._readyState;}
set readyState(state)
{if(state===this._readyState)
return;let previousState=this._readyState;this._readyState=state;this.dispatchEventToListeners(WI.WebSocketResource.Event.ReadyStateChanged,{previousState,state});}
addFrame(data,payloadLength,isOutgoing,opcode,timestamp,elapsedTime)
{let frameData;if(opcode===WI.WebSocketResource.OpCodes.BinaryFrame)
frameData=null;else
frameData=data;let frame={data:frameData,isOutgoing,opcode,walltime:this._walltimeForWebSocketTimestamp(timestamp)};this._frames.push(frame);if(InspectorFrontendHost.isUnderTest())
frame.dataForTest=data;if(payloadLength===undefined)
payloadLength=new TextEncoder("utf-8").encode(data).length;this.increaseSize(payloadLength,elapsedTime);this.dispatchEventToListeners(WI.WebSocketResource.Event.FrameAdded,frame);}
requestContentFromBackend()
{return super.requestContentFromBackend();}
_walltimeForWebSocketTimestamp(timestamp)
{return this._walltime+(timestamp-this._timestamp);}};WI.WebSocketResource.Event={FrameAdded:"web-socket-frame-added",ReadyStateChanged:"web-socket-resource-ready-state-changed",};WI.WebSocketResource.ReadyState={Closed:Symbol("closed"),Connecting:Symbol("connecting"),Open:Symbol("open"),};WI.WebSocketResource.OpCodes={ContinuationFrame:0,TextFrame:1,BinaryFrame:2,ConnectionCloseFrame:8,PingFrame:9,PongFrame:10,};WI.WrappedPromise=class WrappedPromise
{constructor(work)
{this._settled=false;this._promise=new Promise((resolve,reject)=>{this._resolveCallback=resolve;this._rejectCallback=reject;if(work&&typeof work==="function")
return work(this.resolve.bind(this),this.reject.bind(this));});}
get settled()
{return this._settled;}
get promise()
{return this._promise;}
resolve(value)
{if(this._settled)
throw new Error("Promise is already settled, cannot call resolve().");this._settled=true;this._resolveCallback(value);}
reject(value)
{if(this._settled)
throw new Error("Promise is already settled, cannot call reject().");this._settled=true;this._rejectCallback(value);}};WI.LocalResource=class LocalResource extends WI.Resource
{constructor({request,response,metrics,timing,mappedFilePath})
{metrics=metrics||{};timing=timing||{};super(request.url,{mimeType:response.mimeType||(response.headers||{}).valueForCaseInsensitiveKey("Content-Type")||null,requestMethod:request.method,requestHeaders:request.headers,requestData:request.data,requestSentTimestamp:request.timestamp,requestSentWalltime:request.walltime,});this._finishedOrFailedTimestamp=request.finishedTimestamp||NaN;this._statusCode=response.statusCode||NaN;this._statusText=response.statusText||null;this._responseHeaders=response.headers||{};this._failureReasonText=response.failureReasonText||null;this._timingData=new WI.ResourceTimingData(this,timing);this._responseSource=metrics.responseSource||WI.Resource.ResponseSource.Unknown;this._protocol=metrics.protocol||null;this._priority=metrics.priority||WI.Resource.NetworkPriority.Unknown;this._remoteAddress=metrics.remoteAddress||null;this._connectionIdentifier=metrics.connectionIdentifier||null;this._requestHeadersTransferSize=!isNaN(metrics.requestHeaderBytesSent)?metrics.requestHeaderBytesSent:NaN;this._requestBodyTransferSize=!isNaN(metrics.requestBodyBytesSent)?metrics.requestBodyBytesSent:NaN;this._responseHeadersTransferSize=!isNaN(metrics.responseHeaderBytesReceived)?metrics.responseHeaderBytesReceived:NaN;this._responseBodyTransferSize=!isNaN(metrics.responseBodyBytesReceived)?metrics.responseBodyBytesReceived:NaN;this._responseBodySize=!isNaN(metrics.responseBodyDecodedSize)?metrics.responseBodyDecodedSize:NaN;this._isProxyConnection=!!metrics.isProxyConnection;this._localResourceOverride=null;this._finished=true;this._failed=false;this._cached=false;let content=response.content||"";let base64Encoded=response.base64Encoded||false;this._originalRevision=new WI.SourceCodeRevision(this,content,base64Encoded,this._mimeType);this._currentRevision=this._originalRevision;this._mappedFilePath=mappedFilePath||null;}
static canMapToFile()
{return InspectorFrontendHost.canLoad();}
static headersArrayToHeadersObject(headers)
{let result={};if(headers){for(let{name,value}of headers)
result[name]=value;}
return result;}
static fromHAREntry(entry,archiveStartWalltime)
{let{request,response,startedDateTime,timings}=entry;let requestSentWalltime=WI.HARBuilder.dateFromHARDate(startedDateTime)/1000;let requestSentTimestamp=requestSentWalltime-archiveStartWalltime;let finishedTimestamp=NaN;let timing={startTime:NaN,domainLookupStart:NaN,domainLookupEnd:NaN,connectStart:NaN,connectEnd:NaN,secureConnectionStart:NaN,requestStart:NaN,responseStart:NaN,responseEnd:NaN,};if(!isNaN(requestSentWalltime)&&!isNaN(archiveStartWalltime)){let hasBlocked=timings.blocked!==-1;let hasDNS=timings.dns!==-1;let hasConnect=timings.connect!==-1;let hasSecureConnect=timings.ssl!==-1;timing.startTime=requestSentTimestamp||Number.EPSILON;timing.fetchStart=timing.startTime;let accumulation=timing.startTime;if(hasBlocked)
accumulation+=(timings.blocked/1000);if(hasDNS){timing.domainLookupStart=accumulation;accumulation+=(timings.dns/1000);timing.domainLookupEnd=accumulation;}
if(hasConnect){timing.connectStart=accumulation;accumulation+=(timings.connect/1000);timing.connectEnd=accumulation;if(hasSecureConnect)
timing.secureConnectionStart=timing.connectEnd-(timings.ssl/1000);}
accumulation+=(timings.send/1000);timing.requestStart=accumulation;accumulation+=(timings.wait/1000);timing.responseStart=accumulation;accumulation+=(timings.receive/1000);timing.responseEnd=accumulation;finishedTimestamp=timing.responseEnd;}
let serverAddress=entry.serverIPAddress||null;if(serverAddress&&typeof entry._serverPort==="number")
serverAddress+=":"+entry._serverPort;return new WI.LocalResource({request:{url:request.url,method:request.method,headers:LocalResource.headersArrayToHeadersObject(request.headers),timestamp:requestSentTimestamp,walltime:requestSentWalltime,finishedTimestamp:finishedTimestamp,data:request.postData?request.postData.text:null,},response:{headers:LocalResource.headersArrayToHeadersObject(response.headers),mimeType:response.content.mimeType,statusCode:response.status,statusText:response.statusText,failureReasonText:response._error||null,content:response.content.text,base64Encoded:response.content.encoding==="base64",},metrics:{responseSource:WI.HARBuilder.responseSourceFromHARFetchType(entry._fetchType),protocol:WI.HARBuilder.protocolFromHARProtocol(response.httpVersion),priority:WI.HARBuilder.networkPriorityFromHARPriority(entry._priority),remoteAddress:serverAddress,connectionIdentifier:entry.connection?parseInt(entry.connection):null,requestHeaderBytesSent:request.headersSize>=0?request.headersSize:NaN,requestBodyBytesSent:request.bodySize>=0?request.bodySize:NaN,responseHeaderBytesReceived:response.headersSize>=0?response.headersSize:NaN,responseBodyBytesReceived:response.bodySize>=0?response.bodySize:NaN,responseBodyDecodedSize:response.content.size||NaN,},timing,});}
static fromJSON(json)
{return new WI.LocalResource(json);}
toJSON(key)
{return{request:{url:this.url,method:this.requestMethod,headers:this.requestHeaders,data:this.requestData,},response:{headers:this.responseHeaders,mimeType:this.mimeType,statusCode:this.statusCode,statusText:this.statusText,content:this.currentRevision.content,base64Encoded:this.currentRevision.base64Encoded,},mappedFilePath:this._mappedFilePath,};}
get localResourceOverride(){return this._localResourceOverride;}
get mappedFilePath()
{return this._mappedFilePath;}
set mappedFilePath(mappedFilePath)
{if(mappedFilePath===this._mappedFilePath)
return;this._mappedFilePath=mappedFilePath;const forceUpdate=true;this._loadFromFileSystem(forceUpdate).then(()=>{this.dispatchEventToListeners(WI.LocalResource.Event.MappedFilePathChanged);});}
async requestContent()
{await this._loadFromFileSystem();return super.requestContent();}
requestContentFromBackend()
{return Promise.resolve({content:this._originalRevision.content,base64Encoded:this._originalRevision.base64Encoded,});}
handleCurrentRevisionContentChange()
{if(this._mimeType!==this.currentRevision.mimeType){let oldMIMEType=this._mimeType;this._mimeType=this.currentRevision.mimeType;this.dispatchEventToListeners(WI.Resource.Event.MIMETypeDidChange,{oldMIMEType});}}
async _loadFromFileSystem(forceUpdate)
{if(!this._mappedFilePath)
return;let content="";try{content=await InspectorFrontendHost.load(this._mappedFilePath);}catch{if(this._didWarnAboutFailureToLoadFromFileSystem)
return;this._didWarnAboutFailureToLoadFromFileSystem=true;setTimeout(()=>{this._didWarnAboutFailureToLoadFromFileSystem=false;});let message=WI.UIString("Local Override: could not load \u201C%s\u201D").format(this._mappedFilePath);if(window.InspectorTest){console.warn(message);return;}
let consoleMessage=new WI.ConsoleMessage(WI.mainTarget,WI.ConsoleMessage.MessageSource.Other,WI.ConsoleMessage.MessageLevel.Warning,message);consoleMessage.shouldRevealConsole=true;WI.consoleLogViewController.appendConsoleMessage(consoleMessage);return;}
if(!forceUpdate&&content===this.currentRevision.content)
return;this.editableRevision.updateRevisionContent(content);}};WI.LocalResource.Event={MappedFilePathChanged:"local-resource-mapped-file-path-changed",};WI.SourceMapResource=class SourceMapResource extends WI.Resource
{constructor(url,sourceMap)
{super(url);this._sourceMap=sourceMap;var inheritedMIMEType=this._sourceMap.originalSourceCode instanceof WI.Resource?this._sourceMap.originalSourceCode.syntheticMIMEType:null;let fileExtension=WI.fileExtensionForURL(url)||"";let fileExtensionMIMEType=fileExtension==="js"?"text/jsx":WI.mimeTypeForFileExtension(fileExtension,true);this._mimeType=fileExtensionMIMEType||inheritedMIMEType||"text/javascript";this._type=WI.Resource.typeFromMIMEType(this._mimeType);this.markAsFinished();}
get sourceMap(){return this._sourceMap;}
get sourceMapDisplaySubpath()
{var sourceMappingBasePathURLComponents=this._sourceMap.sourceMappingBasePathURLComponents;var resourceURLComponents=this.urlComponents;if(!resourceURLComponents.path)
resourceURLComponents.path=this.url;if(resourceURLComponents.scheme!==sourceMappingBasePathURLComponents.scheme||resourceURLComponents.host!==sourceMappingBasePathURLComponents.host){let subpath="";if(resourceURLComponents.host){subpath+=resourceURLComponents.host;if(resourceURLComponents.port)
subpath+=":"+resourceURLComponents.port;subpath+=resourceURLComponents.path;}else{subpath+=resourceURLComponents.path.substring(1);}
return subpath;}
if(!resourceURLComponents.path.startsWith(sourceMappingBasePathURLComponents.path))
return relativePath(resourceURLComponents.path,sourceMappingBasePathURLComponents.path);return resourceURLComponents.path.substring(sourceMappingBasePathURLComponents.path.length,resourceURLComponents.length);}
get supportsScriptBlackboxing()
{return false;}
requestContentFromBackend()
{this.revertMarkAsFinished();var inlineContent=this._sourceMap.sourceContent(this.url);if(inlineContent){return Promise.resolve().then(sourceMapResourceLoaded.bind(this,{content:inlineContent,mimeType:this.mimeType,statusCode:200}));}
function sourceMapResourceNotAvailable(error,content,mimeType,statusCode)
{this.markAsFailed();return Promise.resolve({error:WI.UIString("An error occurred trying to load the resource."),content,mimeType,statusCode});}
function sourceMapResourceLoadError(error)
{console.error(error||"There was an unknown error calling Network.loadResource.");this.markAsFailed();return Promise.resolve({error:WI.UIString("An error occurred trying to load the resource.")});}
function sourceMapResourceLoaded(parameters)
{var{error,content,mimeType,statusCode}=parameters;var base64encoded=false;if(statusCode>=400||error)
return sourceMapResourceNotAvailable(error,content,mimeType,statusCode);this.markAsFinished();return Promise.resolve({content,mimeType,base64encoded,statusCode});}
if(!this._target.hasCommand("Network.loadResource"))
return sourceMapResourceLoadError.call(this);var frameIdentifier=null;if(this._sourceMap.originalSourceCode instanceof WI.Resource&&this._sourceMap.originalSourceCode.parentFrame)
frameIdentifier=this._sourceMap.originalSourceCode.parentFrame.id;if(!frameIdentifier)
frameIdentifier=WI.networkManager.mainFrame?WI.networkManager.mainFrame.id:"";return this._target.NetworkAgent.loadResource(frameIdentifier,this.url).then(sourceMapResourceLoaded.bind(this)).catch(sourceMapResourceLoadError.bind(this));}
createSourceCodeLocation(lineNumber,columnNumber)
{var entry=this._sourceMap.findEntryReversed(this.url,lineNumber);var rawLineNumber=entry[0];var rawColumnNumber=entry[1];var originalSourceCode=this._sourceMap.originalSourceCode;if(originalSourceCode instanceof WI.Script){if(rawLineNumber===0)
rawColumnNumber+=originalSourceCode.range.startColumn;rawLineNumber+=originalSourceCode.range.startLine;}
var location=originalSourceCode.createSourceCodeLocation(rawLineNumber,rawColumnNumber);location._setMappedLocation(this,lineNumber,columnNumber);return location;}
createSourceCodeTextRange(textRange)
{var startSourceCodeLocation=this.createSourceCodeLocation(textRange.startLine,textRange.startColumn);var endSourceCodeLocation=this.createSourceCodeLocation(textRange.endLine,textRange.endColumn);return new WI.SourceCodeTextRange(this._sourceMap.originalSourceCode,startSourceCodeLocation,endSourceCodeLocation);}};WI.AuditTestBase=class AuditTestBase extends WI.Object
{constructor(name,{description,supports,setup,disabled}={})
{super();this._name=name;this._description=description||"";this._supports=supports??NaN;this._setup=setup||"";this.determineIfSupported({warn:true});this._runningState=disabled?WI.AuditManager.RunningState.Disabled:WI.AuditManager.RunningState.Inactive;this._result=null;this._parent=null;this._default=false;}
get runningState(){return this._runningState;}
get result(){return this._result;}
get supported(){return this._supported;}
get name()
{return this._name;}
set name(name)
{if(name===this._name)
return;let oldName=this._name;this._name=name;this.dispatchEventToListeners(WI.AuditTestBase.Event.NameChanged,{oldName});}
get description()
{return this._description;}
set description(description)
{if(description===this._description)
return;this._description=description;}
get supports()
{return this._supports;}
set supports(supports)
{if(supports===this._supports)
return;this._supports=supports;this.determineIfSupported();}
get setup()
{return this._setup;}
set setup(setup)
{if(setup===this._setup)
return;this._setup=setup;this.clearResult();}
get disabled()
{return this._runningState===WI.AuditManager.RunningState.Disabled;}
set disabled(disabled)
{this.updateDisabled(disabled);}
get editable()
{return!this._default;}
get default()
{return this._default;}
markAsDefault()
{this._default=true;}
get topLevelTest()
{let test=this;while(test._parent)
test=test._parent;return test;}
async runSetup()
{if(!this._setup)
return;let target=WI.assumingMainTarget();let agentCommandFunction=null;let agentCommandArguments={};if(target.hasDomain("Audit")){agentCommandFunction=target.AuditAgent.run;agentCommandArguments.test=this._setup;}else{agentCommandFunction=target.RuntimeAgent.evaluate;agentCommandArguments.expression=`(function() { "use strict"; return eval(\`(${this._setup.replace(/`/g,"\\`")})\`)(); })()`;agentCommandArguments.objectGroup=AuditTestBase.ObjectGroup;agentCommandArguments.doNotPauseOnExceptionsAndMuteConsole=true;}
try{let response=await agentCommandFunction.invoke(agentCommandArguments);if(response.result.type==="object"&&response.result.className==="Promise"){if(WI.RuntimeManager.supportsAwaitPromise())
response=await target.RuntimeAgent.awaitPromise(response.result.objectId);else{response=null;WI.AuditManager.synthesizeError(WI.UIString("Async audits are not supported."));}}
if(response){let remoteObject=WI.RemoteObject.fromPayload(response.result,WI.mainTarget);if(response.wasThrown||(remoteObject.type==="object"&&remoteObject.subtype==="error"))
WI.AuditManager.synthesizeError(remoteObject.description);}}catch(error){WI.AuditManager.synthesizeError(error.message);}}
async start()
{if(!this._supported||this.disabled)
return;if(this._runningState!==WI.AuditManager.RunningState.Inactive)
return;this._runningState=WI.AuditManager.RunningState.Active;this.dispatchEventToListeners(WI.AuditTestBase.Event.Scheduled);await this.run();this._runningState=WI.AuditManager.RunningState.Inactive;this.dispatchEventToListeners(WI.AuditTestBase.Event.Completed);}
stop()
{if(!this._supported||this.disabled)
return;if(this._runningState!==WI.AuditManager.RunningState.Active)
return;this._runningState=WI.AuditManager.RunningState.Stopping;this.dispatchEventToListeners(WI.AuditTestBase.Event.Stopping);}
clearResult(options={})
{if(!this._result)
return false;this._result=null;if(!options.suppressResultChangedEvent)
this.dispatchEventToListeners(WI.AuditTestBase.Event.ResultChanged);return true;}
async clone()
{return this.constructor.fromPayload(this.toJSON());}
remove()
{if(!this._parent||this._default){WI.auditManager.removeTest(this);return;}
this._parent.removeTest(this);}
saveIdentityToCookie(cookie)
{let path=[];let test=this;while(test){path.push(test.name);test=test._parent;}
path.reverse();cookie["audit-path"]=path.join(",");}
toJSON(key)
{let json={type:this.constructor.TypeIdentifier,name:this._name,};if(this._description)
json.description=this._description;if(!isNaN(this._supports))
json.supports=Number.isFinite(this._supports)?this._supports:WI.AuditTestBase.Version+1;if(this._setup)
json.setup=this._setup;if(key===WI.ObjectStore.toJSONSymbol)
json.disabled=this.disabled;return json;}
async run()
{throw WI.NotImplementedError.subclassMustOverride();}
determineIfSupported(options={})
{let supportedBefore=this._supported;if(this._supports>WI.AuditTestBase.Version){this.updateSupported(false,options);if(options.warn&&supportedBefore!==this._supported&&Number.isFinite(this._supports))
WI.AuditManager.synthesizeWarning(WI.UIString("\u0022%s\u0022 is too new to run in this Web Inspector").format(this.name));}else if(InspectorBackend.hasDomain("Audit")&&this._supports>InspectorBackend.getVersion("Audit")){this.updateSupported(false,options);if(options.warn&&supportedBefore!==this._supported&&Number.isFinite(this._supports))
WI.AuditManager.synthesizeWarning(WI.UIString("\u0022%s\u0022 is too new to run in the inspected page").format(this.name));}else
this.updateSupported(true,options);return this._supported;}
updateSupported(supported,options={})
{if(supported===this._supported)
return;this._supported=supported;if(!options.silent)
this.dispatchEventToListeners(WI.AuditTestBase.Event.SupportedChanged);if(!this._supported)
this.clearResult();}
updateDisabled(disabled,options={})
{if(this._runningState!==WI.AuditManager.RunningState.Disabled&&this._runningState!==WI.AuditManager.RunningState.Inactive)
return;let runningState=disabled?WI.AuditManager.RunningState.Disabled:WI.AuditManager.RunningState.Inactive;if(runningState===this._runningState)
return;this._runningState=runningState;if(!options.silent)
this.dispatchEventToListeners(WI.AuditTestBase.Event.DisabledChanged);if(this.disabled)
this.clearResult();}
updateResult(result)
{this._result=result;this.dispatchEventToListeners(WI.AuditTestBase.Event.ResultChanged);}};WI.AuditTestBase.Version=4;WI.AuditTestBase.ObjectGroup="audit";WI.AuditTestBase.Event={Completed:"audit-test-base-completed",DisabledChanged:"audit-test-base-disabled-changed",NameChanged:"audit-test-base-name-changed",Progress:"audit-test-base-progress",ResultChanged:"audit-test-base-result-changed",Scheduled:"audit-test-base-scheduled",Stopping:"audit-test-base-stopping",SupportedChanged:"audit-test-base-supported-changed",TestChanged:"audit-test-base-test-changed",};WI.AuditTestCase=class AuditTestCase extends WI.AuditTestBase
{constructor(name,test,options={})
{super(name,options);this._test=test;}
static async fromPayload(payload)
{if(typeof payload!=="object"||payload===null)
return null;if(payload.type!==WI.AuditTestCase.TypeIdentifier)
return null;if(typeof payload.name!=="string"){WI.AuditManager.synthesizeError(WI.UIString("\u0022%s\u0022 has a non-string \u0022%s\u0022 value").format(payload.name,WI.unlocalizedString("name")));return null;}
if(typeof payload.test!=="string"){WI.AuditManager.synthesizeError(WI.UIString("\u0022%s\u0022 has a non-string \u0022%s\u0022 value").format(payload.name,WI.unlocalizedString("test")));return null;}
let options={};if(typeof payload.description==="string")
options.description=payload.description;else if("description"in payload)
WI.AuditManager.synthesizeWarning(WI.UIString("\u0022%s\u0022 has a non-string \u0022%s\u0022 value").format(payload.name,WI.unlocalizedString("description")));if(typeof payload.supports==="number")
options.supports=payload.supports;else if("supports"in payload)
WI.AuditManager.synthesizeWarning(WI.UIString("\u0022%s\u0022 has a non-number \u0022%s\u0022 value").format(payload.name,WI.unlocalizedString("supports")));if(typeof payload.setup==="string")
options.setup=payload.setup;else if("setup"in payload)
WI.AuditManager.synthesizeWarning(WI.UIString("\u0022%s\u0022 has a non-string \u0022%s\u0022 value").format(payload.name,WI.unlocalizedString("setup")));if(typeof payload.disabled==="boolean")
options.disabled=payload.disabled;return new WI.AuditTestCase(payload.name,payload.test,options);}
get test()
{return this._test;}
set test(test)
{if(test===this._test)
return;this._test=test;this.clearResult();this.dispatchEventToListeners(WI.AuditTestBase.Event.TestChanged);}
toJSON(key)
{let json=super.toJSON(key);json.test=this._test;return json;}
async run()
{const levelStrings=Object.values(WI.AuditTestCaseResult.Level);let level=null;let data={};let metadata={url:WI.networkManager.mainFrame.url,startTimestamp:null,endTimestamp:null,};let resolvedDOMNodes=null;function setLevel(newLevel){let newLevelIndex=levelStrings.indexOf(newLevel);if(newLevelIndex<0){addError(WI.UIString("Return string must be one of %s").format(JSON.stringify(levelStrings)));return;}
if(newLevelIndex<=levelStrings.indexOf(level))
return;level=newLevel;}
function addError(value){setLevel(WI.AuditTestCaseResult.Level.Error);if(!data.errors)
data.errors=[];data.errors.push(value);}
async function parseResponse(response){let remoteObject=WI.RemoteObject.fromPayload(response.result,WI.mainTarget);if(response.wasThrown||(remoteObject.type==="object"&&remoteObject.subtype==="error")){addError(remoteObject.description);return;}
if(remoteObject.type==="boolean"){setLevel(remoteObject.value?WI.AuditTestCaseResult.Level.Pass:WI.AuditTestCaseResult.Level.Fail);return;}
if(remoteObject.type==="string"){setLevel(remoteObject.value.trim().toLowerCase());return;}
if(remoteObject.type!=="object"||remoteObject.subtype){addError(WI.UIString("Return value is not an object, string, or boolean"));return;}
const options={ownProperties:true,};function checkResultProperty(key,value,type,subtype){function addErrorForValueType(valueType){let errorString=null;if(valueType==="object"||valueType==="array")
errorString=WI.UIString("\u0022%s\u0022 must be an %s");else
errorString=WI.UIString("\u0022%s\u0022 must be a %s");addError(errorString.format(key,valueType));}
if(value.subtype!==subtype){addErrorForValueType(subtype);return null;}
if(value.type!==type){addErrorForValueType(type);return null;}
if(type==="boolean"||type==="string")
return value.value;return value;}
async function resultArrayForEach(key,value,callback){let array=checkResultProperty(key,value,"object","array");if(!array)
return;let arrayProperties=await new Promise((resolve,reject)=>array.getPropertyDescriptors(resolve,options));for(let i=0;i<array.size;++i){let arrayPropertyForIndex=arrayProperties.find((arrayProperty)=>arrayProperty.name===String(i));if(arrayPropertyForIndex)
await callback(arrayPropertyForIndex);}}
let properties=await new Promise((resolve,reject)=>remoteObject.getPropertyDescriptors(resolve,options));for(let property of properties){let key=property.name;if(key==="__proto__")
continue;let value=property.value;switch(key){case"level":{let levelString=checkResultProperty(key,value,"string");if(levelString)
setLevel(levelString.trim().toLowerCase());break;}
case"pass":if(checkResultProperty(key,value,"boolean"))
setLevel(WI.AuditTestCaseResult.Level.Pass);break;case"warn":if(checkResultProperty(key,value,"boolean"))
setLevel(WI.AuditTestCaseResult.Level.Warn);break;case"fail":if(checkResultProperty(key,value,"boolean"))
setLevel(WI.AuditTestCaseResult.Level.Fail);break;case"error":if(checkResultProperty(key,value,"boolean"))
setLevel(WI.AuditTestCaseResult.Level.Error);break;case"unsupported":if(checkResultProperty(key,value,"boolean"))
setLevel(WI.AuditTestCaseResult.Level.Unsupported);break;case"domNodes":await resultArrayForEach(key,value,async(item)=>{if(!item||!item.value||item.value.type!=="object"||item.value.subtype!=="node"){addError(WI.UIString("All items in \u0022%s\u0022 must be valid DOM nodes").format(WI.unlocalizedString("domNodes")));return;}
let domNodeId=await new Promise((resolve,reject)=>item.value.pushNodeToFrontend(resolve));let domNode=WI.domManager.nodeForId(domNodeId);if(!domNode)
return;if(!data.domNodes)
data.domNodes=[];data.domNodes.push(WI.cssPath(domNode,{full:true}));if(!resolvedDOMNodes)
resolvedDOMNodes=[];resolvedDOMNodes.push(domNode);});break;case"domAttributes":await resultArrayForEach(key,value,(item)=>{if(!item||!item.value||item.value.type!=="string"||!item.value.value.length){addError(WI.UIString("All items in \u0022%s\u0022 must be non-empty strings").format(WI.unlocalizedString("domAttributes")));return;}
if(!data.domAttributes)
data.domAttributes=[];data.domAttributes.push(item.value.value);});break;case"errors":await resultArrayForEach(key,value,(item)=>{if(!item||!item.value||item.value.type!=="object"||item.value.subtype!=="error"){addError(WI.UIString("All items in \u0022%s\u0022 must be error objects").format(WI.unlocalizedString("errors")));return;}
addError(item.value.description);});break;default:if(value.objectId){try{function inspectedPage_stringify(){return JSON.stringify(this);}
let stringifiedValue=await value.callFunction(inspectedPage_stringify);data[key]=JSON.parse(stringifiedValue.value);}catch{addError(WI.UIString("\u0022%s\u0022 is not JSON serializable").format(key));}}else
data[key]=value.value;break;}}}
let target=WI.assumingMainTarget();let agentCommandFunction=null;let agentCommandArguments={};if(target.hasDomain("Audit")){agentCommandFunction=target.AuditAgent.run;agentCommandArguments.test=this._test;}else{agentCommandFunction=target.RuntimeAgent.evaluate;agentCommandArguments.expression=`(function() { "use strict"; return eval(\`(${this._test.replace(/`/g,"\\`")})\`)(); })()`;agentCommandArguments.objectGroup=WI.AuditTestCase.ObjectGroup;agentCommandArguments.doNotPauseOnExceptionsAndMuteConsole=true;}
try{metadata.startTimestamp=new Date;let response=await agentCommandFunction.invoke(agentCommandArguments);metadata.endTimestamp=new Date;if(response.result.type==="object"&&response.result.className==="Promise"){if(WI.RuntimeManager.supportsAwaitPromise()){metadata.asyncTimestamp=metadata.endTimestamp;response=await target.RuntimeAgent.awaitPromise(response.result.objectId);metadata.endTimestamp=new Date;}else{response=null;addError(WI.UIString("Async audits are not supported."));setLevel(WI.AuditTestCaseResult.Level.Unsupported);}}
if(response)
await parseResponse(response);}catch(error){metadata.endTimestamp=new Date;addError(error.message);}
if(!level)
addError(WI.UIString("Missing result level"));let options={description:this.description,metadata,};if(!isEmptyObject(data))
options.data=data;if(resolvedDOMNodes)
options.resolvedDOMNodes=resolvedDOMNodes;this.updateResult(new WI.AuditTestCaseResult(this.name,level,options));}};WI.AuditTestCase.TypeIdentifier="test-case";WI.AuditTestGroup=class AuditTestGroup extends WI.AuditTestBase
{constructor(name,tests,options={})
{let disabled=options.disabled;options.disabled=false;super(name,options);this._tests=[];for(let test of tests)
this.addTest(test);if(disabled)
this.updateDisabled(true);}
static async fromPayload(payload)
{if(typeof payload!=="object"||payload===null)
return null;if(payload.type!==WI.AuditTestGroup.TypeIdentifier)
return null;if(typeof payload.name!=="string"){WI.AuditManager.synthesizeError(WI.UIString("\u0022%s\u0022 has a non-string \u0022%s\u0022 value").format(payload.name,WI.unlocalizedString("name")));return null;}
if(!Array.isArray(payload.tests)){WI.AuditManager.synthesizeError(WI.UIString("\u0022%s\u0022 has a non-array \u0022%s\u0022 value").format(payload.name,WI.unlocalizedString("tests")));return null;}
let tests=await Promise.all(payload.tests.map(async(test)=>{let testCase=await WI.AuditTestCase.fromPayload(test);if(testCase)
return testCase;let testGroup=await WI.AuditTestGroup.fromPayload(test);if(testGroup)
return testGroup;return null;}));tests=tests.filter((test)=>!!test);if(!tests.length)
return null;let options={};if(typeof payload.description==="string")
options.description=payload.description;else if("description"in payload)
WI.AuditManager.synthesizeWarning(WI.UIString("\u0022%s\u0022 has a non-string \u0022%s\u0022 value").format(payload.name,WI.unlocalizedString("description")));if(typeof payload.supports==="number")
options.supports=payload.supports;else if("supports"in payload)
WI.AuditManager.synthesizeWarning(WI.UIString("\u0022%s\u0022 has a non-number \u0022%s\u0022 value").format(payload.name,WI.unlocalizedString("supports")));if(typeof payload.setup==="string")
options.setup=payload.setup;else if("setup"in payload)
WI.AuditManager.synthesizeWarning(WI.UIString("\u0022%s\u0022 has a non-string \u0022%s\u0022 value").format(payload.name,WI.unlocalizedString("setup")));if(typeof payload.disabled==="boolean")
options.disabled=payload.disabled;return new WI.AuditTestGroup(payload.name,tests,options);}
get tests(){return this._tests;}
addTest(test)
{this._tests.push(test);test._parent=this;test.addEventListener(WI.AuditTestBase.Event.Completed,this._handleTestCompleted,this);test.addEventListener(WI.AuditTestBase.Event.DisabledChanged,this._handleTestDisabledChanged,this);test.addEventListener(WI.AuditTestBase.Event.Progress,this._handleTestProgress,this);if(this.editable){test.addEventListener(WI.AuditTestBase.Event.SupportedChanged,this._handleTestSupportedChanged,this);test.addEventListener(WI.AuditTestBase.Event.TestChanged,this._handleTestChanged,this);}
this.dispatchEventToListeners(WI.AuditTestGroup.Event.TestAdded,{test});this.determineIfSupported();if(this._checkDisabled(test))
test.updateDisabled(true,{silent:true});}
removeTest(test)
{test.removeEventListener(WI.AuditTestBase.Event.Completed,this._handleTestCompleted,this);test.removeEventListener(WI.AuditTestBase.Event.DisabledChanged,this._handleTestDisabledChanged,this);test.removeEventListener(WI.AuditTestBase.Event.Progress,this._handleTestProgress,this);test.removeEventListener(WI.AuditTestBase.Event.SupportedChanged,this._handleTestSupportedChanged,this);test.removeEventListener(WI.AuditTestBase.Event.TestChanged,this._handleTestChanged,this);this._tests.remove(test);test._parent=null;this.dispatchEventToListeners(WI.AuditTestGroup.Event.TestRemoved,{test});this.determineIfSupported();this._checkDisabled();}
stop()
{for(let test of this._tests)
test.stop();super.stop();}
clearResult(options={})
{let cleared=!!this.result;if(!options.excludeTests&&this._tests){for(let test of this._tests){if(test.clearResult(options))
cleared=true;}}
return super.clearResult({...options,suppressResultChangedEvent:!cleared,});}
toJSON(key)
{let json=super.toJSON(key);json.tests=this._tests.map((testCase)=>testCase.toJSON(key));return json;}
async run()
{let count=this._tests.length;for(let index=0;index<count&&this._runningState===WI.AuditManager.RunningState.Active;++index){let test=this._tests[index];if(test.disabled||!test.supported)
continue;await test.start();if(test instanceof WI.AuditTestCase)
this.dispatchEventToListeners(WI.AuditTestBase.Event.Progress,{index,count});}
this.updateResult();}
determineIfSupported(options={})
{if(this._tests){for(let test of this._tests)
test.determineIfSupported({...options,warn:false,silent:true});}
return super.determineIfSupported(options);}
updateSupported(supported,options={})
{if(this._tests&&(!supported||this._tests.every((test)=>!test.supported))){supported=false;for(let test of this._tests)
test.updateSupported(supported,{silent:true});}
super.updateSupported(supported,options);}
updateDisabled(disabled,options={})
{if(!options.excludeTests&&this._tests){for(let test of this._tests)
test.updateDisabled(disabled,options);}
super.updateDisabled(disabled,options);}
updateResult()
{let results=this._tests.map((test)=>test.result).filter((result)=>!!result);if(!results.length)
return;super.updateResult(new WI.AuditTestGroupResult(this.name,results,{description:this.description,}));}
_checkDisabled(test)
{let testDisabled=!test||!test.supported||test.disabled;let enabledTestCount=this._tests.filter((existing)=>existing.supported&&!existing.disabled).length;if(testDisabled&&!enabledTestCount)
this.updateDisabled(true);else if(!testDisabled&&enabledTestCount===1)
this.updateDisabled(false,{excludeTests:true});else{this.dispatchEventToListeners(WI.AuditTestBase.Event.DisabledChanged);}
return this.disabled;}
_handleTestCompleted(event)
{if(this._runningState===WI.AuditManager.RunningState.Active)
return;this.updateResult();this.dispatchEventToListeners(WI.AuditTestBase.Event.Completed);}
_handleTestDisabledChanged(event)
{this._checkDisabled(event.target);}
_handleTestProgress(event)
{if(this._runningState!==WI.AuditManager.RunningState.Active)
return;let walk=(tests)=>{let count=0;for(let test of tests){if(test.disabled||!test.supported)
continue;if(test instanceof WI.AuditTestCase)
++count;else if(test instanceof WI.AuditTestGroup)
count+=walk(test.tests);}
return count;};this.dispatchEventToListeners(WI.AuditTestBase.Event.Progress,{index:event.data.index+walk(this._tests.slice(0,this._tests.indexOf(event.target))),count:walk(this._tests),});}
_handleTestSupportedChanged(event)
{this.determineIfSupported();}
_handleTestChanged(event)
{this.clearResult({excludeTests:true});this.dispatchEventToListeners(WI.AuditTestBase.Event.TestChanged);}};WI.AuditTestGroup.TypeIdentifier="test-group";WI.AuditTestGroup.Event={TestAdded:"audit-test-group-test-added",TestRemoved:"audit-test-group-test-removed",};WI.AuditTestResultBase=class AuditTestResultBase
{constructor(name,{description}={})
{this._name=name;this._description=description||null;}
get name(){return this._name;}
get description(){return this._description;}
get result()
{return this;}
get didPass()
{throw WI.NotImplementedError.subclassMustOverride();}
get didWarn()
{throw WI.NotImplementedError.subclassMustOverride();}
get didFail()
{throw WI.NotImplementedError.subclassMustOverride();}
get didError()
{throw WI.NotImplementedError.subclassMustOverride();}
get unsupported()
{throw WI.NotImplementedError.subclassMustOverride();}
get disabled()
{return false;}
get editable()
{return false;}
saveIdentityToCookie(cookie)
{cookie["audit-"+this.constructor.TypeIdentifier+"-name"]=this._name;}
toJSON()
{let json={type:this.constructor.TypeIdentifier,name:this._name,};if(this._description)
json.description=this._description;return json;}};WI.AuditTestCaseResult=class AuditTestCaseResult extends WI.AuditTestResultBase
{constructor(name,level,{description,data,metadata,resolvedDOMNodes}={})
{super(name,{description});this._level=level;this._data=data||{};this._metadata=metadata||{};this._resolvedDOMNodes=resolvedDOMNodes||[];}
static async fromPayload(payload)
{if(typeof payload!=="object"||payload===null)
return null;if(payload.type!==WI.AuditTestCaseResult.TypeIdentifier)
return null;if(typeof payload.name!=="string"){WI.AuditManager.synthesizeError(WI.UIString("\u0022%s\u0022 has a non-string \u0022%s\u0022 value").format(payload.name,WI.unlocalizedString("name")));return null;}
if(!Object.values(WI.AuditTestCaseResult.Level).includes(payload.level)){WI.AuditManager.synthesizeError(WI.UIString("\u0022%s\u0022 has an invalid \u0022%s\u0022 value").format(payload.name,WI.unlocalizedString("level")));return null;}
if(typeof payload.data!=="object"||payload.data===null){if("data"in payload)
WI.AuditManager.synthesizeWarning(WI.UIString("\u0022%s\u0022 has a non-object \u0022%s\u0022 value").format(payload.name,WI.unlocalizedString("data")));payload.data={};}else{function checkArray(key){if(!(key in payload.data))
return;if(!Array.isArray(payload.data[key])){WI.AuditManager.synthesizeWarning(WI.UIString("\u0022%s\u0022 has a non-array \u0022%s\u0022 value").format(payload.name,WI.unlocalizedString("data.%s").format(key)));payload.data[key]=[];}
payload.data[key]=payload.data[key].filter((item)=>typeof item==="string");}
checkArray("domNodes");checkArray("domAttributes");checkArray("errors");}
if(typeof payload.metadata!=="object"||payload.metadata===null){if("metadata"in payload)
WI.AuditManager.synthesizeWarning(WI.UIString("\u0022%s\u0022 has a non-object \u0022%s\u0022 value").format(payload.name,WI.unlocalizedString("metadata")));payload.metadata={};}else{if(typeof payload.metadata.startTimestamp==="string")
payload.metadata.startTimestamp=new Date(payload.metadata.startTimestamp);else{if("startTimestamp"in payload.metadata)
WI.AuditManager.synthesizeWarning(WI.UIString("\u0022%s\u0022 has a non-object \u0022%s\u0022 value").format(payload.name,WI.unlocalizedString("metadata.startTimestamp")));payload.metadata.startTimestamp=null;}
if(typeof payload.metadata.asyncTimestamp==="string")
payload.metadata.asyncTimestamp=new Date(payload.metadata.asyncTimestamp);else{if("asyncTimestamp"in payload.metadata)
WI.AuditManager.synthesizeWarning(WI.UIString("\u0022%s\u0022 has a non-object \u0022%s\u0022 value").format(payload.name,WI.unlocalizedString("metadata.asyncTimestamp")));payload.metadata.asyncTimestamp=null;}
if(typeof payload.metadata.endTimestamp==="string")
payload.metadata.endTimestamp=new Date(payload.metadata.endTimestamp);else{if("endTimestamp"in payload.metadata)
WI.AuditManager.synthesizeWarning(WI.UIString("\u0022%s\u0022 has a non-object \u0022%s\u0022 value").format(payload.name,WI.unlocalizedString("metadata.endTimestamp")));payload.metadata.endTimestamp=null;}
if(typeof payload.metadata.url!=="string"){if("url"in payload.metadata)
WI.AuditManager.synthesizeWarning(WI.UIString("\u0022%s\u0022 has a non-object \u0022%s\u0022 value").format(payload.name,WI.unlocalizedString("metadata.url")));payload.metadata.url=null;}}
let options={};if(typeof payload.description==="string")
options.description=payload.description;else if("description"in payload)
WI.AuditManager.synthesizeWarning(WI.UIString("\u0022%s\u0022 has a non-string \u0022%s\u0022 value").format(payload.name,WI.unlocalizedString("description")));if(!isEmptyObject(payload.data)){options.data={};for(let key in payload.data){if(key==="domNodes"||key==="domAttributes"||key==="errors"){if(!payload.data[key].length)
continue;}
if(key==="domNodes"){if(InspectorBackend.hasDomain("DOM")&&(!payload.metadata.url||payload.metadata.url===WI.networkManager.mainFrame.url)){let documentNode=await new Promise((resolve)=>WI.domManager.requestDocument(resolve));options.resolvedDOMNodes=await Promise.all(payload.data.domNodes.map(async(domNodeString)=>{let nodeId=0;try{nodeId=await documentNode.querySelector(domNodeString);}catch{}
return WI.domManager.nodeForId(nodeId);}));}}
options.data[key]=payload.data[key];}}
if(!isEmptyObject(payload.metadata)){options.metadata={};if(payload.metadata.startTimestamp&&!isNaN(payload.metadata.startTimestamp))
options.metadata.startTimestamp=payload.metadata.startTimestamp;if(payload.metadata.asyncTimestamp&&!isNaN(payload.metadata.asyncTimestamp))
options.metadata.asyncTimestamp=payload.metadata.asyncTimestamp;if(payload.metadata.endTimestamp&&!isNaN(payload.metadata.endTimestamp))
options.metadata.endTimestamp=payload.metadata.endTimestamp;if(payload.metadata.url)
options.metadata.url=payload.metadata.url;}
return new WI.AuditTestCaseResult(payload.name,payload.level,options);}
get level(){return this._level;}
get data(){return this._data;}
get metadata(){return this._metadata;}
get resolvedDOMNodes(){return this._resolvedDOMNodes;}
get result()
{return this;}
get didPass()
{return this._level===WI.AuditTestCaseResult.Level.Pass;}
get didWarn()
{return this._level===WI.AuditTestCaseResult.Level.Warn;}
get didFail()
{return this._level===WI.AuditTestCaseResult.Level.Fail;}
get didError()
{return this._level===WI.AuditTestCaseResult.Level.Error;}
get unsupported()
{return this._level===WI.AuditTestCaseResult.Level.Unsupported;}
toJSON()
{let json=super.toJSON();json.level=this._level;let data={};for(let key in this._data){if(key==="domNodes"||key==="domAttributes"||key==="errors"){if(!this._data[key].length)
continue;}
data[key]=this._data[key];}
if(!isEmptyObject(data))
json.data=data;let metadata={};if(this._metadata.startTimestamp&&!isNaN(this._metadata.startTimestamp))
metadata.startTimestamp=this._metadata.startTimestamp;if(this._metadata.asyncTimestamp&&!isNaN(this._metadata.asyncTimestamp))
metadata.asyncTimestamp=this._metadata.asyncTimestamp;if(this._metadata.endTimestamp&&!isNaN(this._metadata.endTimestamp))
metadata.endTimestamp=this._metadata.endTimestamp;if(this._metadata.url)
metadata.url=this._metadata.url;if(!isEmptyObject(metadata))
json.metadata=metadata;return json;}};WI.AuditTestCaseResult.TypeIdentifier="test-case-result";WI.AuditTestCaseResult.Level={Pass:"pass",Warn:"warn",Fail:"fail",Error:"error",Unsupported:"unsupported",};WI.AuditTestGroupResult=class AuditTestGroupResult extends WI.AuditTestResultBase
{constructor(name,results,{description}={})
{super(name,{description});this._results=results;}
static async fromPayload(payload)
{if(typeof payload!=="object"||payload===null)
return null;if(payload.type!==WI.AuditTestGroupResult.TypeIdentifier)
return null;if(typeof payload.name!=="string"){WI.AuditManager.synthesizeError(WI.UIString("\u0022%s\u0022 has a non-string \u0022%s\u0022 value").format(payload.name,WI.unlocalizedString("name")));return null;}
if(!Array.isArray(payload.results)){WI.AuditManager.synthesizeError(WI.UIString("\u0022%s\u0022 has a non-array \u0022%s\u0022 value").format(payload.name,WI.unlocalizedString("results")));return null;}
let results=await Promise.all(payload.results.map(async(test)=>{let testCaseResult=await WI.AuditTestCaseResult.fromPayload(test);if(testCaseResult)
return testCaseResult;let testGroupResult=await WI.AuditTestGroupResult.fromPayload(test);if(testGroupResult)
return testGroupResult;return null;}));results=results.filter((result)=>!!result);if(!results.length)
return null;let options={};if(typeof payload.description==="string")
options.description=payload.description;else if("description"in payload)
WI.AuditManager.synthesizeWarning(WI.UIString("\u0022%s\u0022 has a non-string \u0022%s\u0022 value").format(payload.name,WI.unlocalizedString("description")));return new WI.AuditTestGroupResult(payload.name,results,options);}
get results(){return this._results;}
get levelCounts()
{let counts={};for(let level of Object.values(WI.AuditTestCaseResult.Level))
counts[level]=0;for(let result of this._results){if(result instanceof WI.AuditTestCaseResult)
++counts[result.level];else if(result instanceof WI.AuditTestGroupResult){for(let[level,count]of Object.entries(result.levelCounts))
counts[level]+=count;}}
return counts;}
get didPass()
{return this._results.some((result)=>result.didPass);}
get didWarn()
{return this._results.some((result)=>result.didWarn);}
get didFail()
{return this._results.some((result)=>result.didFail);}
get didError()
{return this._results.some((result)=>result.didError);}
get unsupported()
{return this._results.some((result)=>result.unsupported);}
toJSON()
{let json=super.toJSON();json.results=this._results.map((result)=>result.toJSON());return json;}};WI.AuditTestGroupResult.TypeIdentifier="test-group-result";WI.FormatterWorkerProxy=class FormatterWorkerProxy
{constructor()
{this._formatterWorker=new Worker("Workers/Formatter/FormatterWorker.js");this._formatterWorker.addEventListener("message",this._handleMessage.bind(this));this._nextCallId=1;this._callbacks=new Map;}
static singleton()
{if(!FormatterWorkerProxy.instance)
FormatterWorkerProxy.instance=new FormatterWorkerProxy;return FormatterWorkerProxy.instance;}
formatJavaScript(sourceText,isModule,indentString,includeSourceMapData)
{this.performAction("formatJavaScript",...arguments);}
formatCSS(sourceText,indentString,includeSourceMapData)
{this.performAction("formatCSS",...arguments);}
formatHTML(sourceText,indentString,includeSourceMapData)
{this.performAction("formatHTML",...arguments);}
formatXML(sourceText,indentString,includeSourceMapData)
{this.performAction("formatXML",...arguments);}
performAction(actionName)
{let callId=this._nextCallId++;let callback=arguments[arguments.length-1];let actionArguments=Array.prototype.slice.call(arguments,1,arguments.length-1);this._callbacks.set(callId,callback);this._postMessage({callId,actionName,actionArguments});}
_postMessage()
{this._formatterWorker.postMessage(...arguments);}
_handleMessage(event)
{let data=event.data;if(data.callId){let callback=this._callbacks.get(data.callId);this._callbacks.delete(data.callId);callback(data.result);return;}
console.error("Unexpected FormatterWorker message",data);}};WI.HeapSnapshotDiffProxy=class HeapSnapshotDiffProxy extends WI.Object
{constructor(snapshotDiffObjectId,snapshot1,snapshot2,totalSize,totalObjectCount,categories)
{super();this._proxyObjectId=snapshotDiffObjectId;this._snapshot1=snapshot1;this._snapshot2=snapshot2;this._totalSize=totalSize;this._totalObjectCount=totalObjectCount;this._categories=Map.fromObject(categories);}
static deserialize(objectId,serializedSnapshotDiff)
{let{snapshot1:serializedSnapshot1,snapshot2:serializedSnapshot2,totalSize,totalObjectCount,categories}=serializedSnapshotDiff;let snapshot1=WI.HeapSnapshotProxy.deserialize(objectId,serializedSnapshot1);let snapshot2=WI.HeapSnapshotProxy.deserialize(objectId,serializedSnapshot2);return new WI.HeapSnapshotDiffProxy(objectId,snapshot1,snapshot2,totalSize,totalObjectCount,categories);}
get snapshot1(){return this._snapshot1;}
get snapshot2(){return this._snapshot2;}
get totalSize(){return this._totalSize;}
get totalObjectCount(){return this._totalObjectCount;}
get categories(){return this._categories;}
get invalid(){return this._snapshot1.invalid||this._snapshot2.invalid;}
updateForCollectionEvent(event)
{if(!event.data.affectedSnapshots.includes(this._snapshot2._identifier))
return;this.update(()=>{this.dispatchEventToListeners(WI.HeapSnapshotProxy.Event.CollectedNodes,event.data);});}
allocationBucketCounts(bucketSizes,callback)
{WI.HeapSnapshotWorkerProxy.singleton().callMethod(this._proxyObjectId,"allocationBucketCounts",bucketSizes,callback);}
instancesWithClassName(className,callback)
{WI.HeapSnapshotWorkerProxy.singleton().callMethod(this._proxyObjectId,"instancesWithClassName",className,(serializedNodes)=>{callback(serializedNodes.map(WI.HeapSnapshotNodeProxy.deserialize.bind(null,this._proxyObjectId)));});}
update(callback)
{WI.HeapSnapshotWorkerProxy.singleton().callMethod(this._proxyObjectId,"update",({liveSize,categories})=>{this._categories=Map.fromObject(categories);callback();});}
nodeWithIdentifier(nodeIdentifier,callback)
{WI.HeapSnapshotWorkerProxy.singleton().callMethod(this._proxyObjectId,"nodeWithIdentifier",nodeIdentifier,(serializedNode)=>{callback(WI.HeapSnapshotNodeProxy.deserialize(this._proxyObjectId,serializedNode));});}};WI.HeapSnapshotEdgeProxy=class HeapSnapshotEdgeProxy
{constructor(objectId,fromIdentifier,toIdentifier,type,data)
{this._proxyObjectId=objectId;this.fromIdentifier=fromIdentifier;this.toIdentifier=toIdentifier;this.type=type;this.data=data;this.from=null;this.to=null;}
isPrivateSymbol()
{if(WI.settings.engineeringShowPrivateSymbolsInHeapSnapshot.value)
return false;return typeof this.data==="string"&&this.data.startsWith("PrivateSymbol");}
static deserialize(objectId,serializedEdge)
{let{from,to,type,data}=serializedEdge;return new WI.HeapSnapshotEdgeProxy(objectId,from,to,type,data);}};WI.HeapSnapshotEdgeProxy.EdgeType={Internal:"Internal",Property:"Property",Index:"Index",Variable:"Variable",};WI.HeapSnapshotNodeProxy=class HeapSnapshotNodeProxy
{constructor(snapshotObjectId,{id,className,size,retainedSize,internal,isObjectType,gcRoot,dead,dominatorNodeIdentifier,hasChildren})
{this._proxyObjectId=snapshotObjectId;this.id=id;this.className=className;this.size=size;this.retainedSize=retainedSize;this.internal=internal;this.isObjectType=isObjectType;this.gcRoot=gcRoot;this.dead=dead;this.dominatorNodeIdentifier=dominatorNodeIdentifier;this.hasChildren=hasChildren;}
static deserialize(objectId,serializedNode)
{return new WI.HeapSnapshotNodeProxy(objectId,serializedNode);}
shortestGCRootPath(callback)
{WI.HeapSnapshotWorkerProxy.singleton().callMethod(this._proxyObjectId,"shortestGCRootPath",this.id,(serializedPath)=>{let isNode=false;let path=serializedPath.map((component)=>{isNode=!isNode;if(isNode)
return WI.HeapSnapshotNodeProxy.deserialize(this._proxyObjectId,component);return WI.HeapSnapshotEdgeProxy.deserialize(this._proxyObjectId,component);});for(let i=1;i<path.length;i+=2){let edge=path[i];edge.from=path[i-1];edge.to=path[i+1];}
callback(path);});}
dominatedNodes(callback)
{WI.HeapSnapshotWorkerProxy.singleton().callMethod(this._proxyObjectId,"dominatedNodes",this.id,(serializedNodes)=>{callback(serializedNodes.map(WI.HeapSnapshotNodeProxy.deserialize.bind(null,this._proxyObjectId)));});}
retainedNodes(callback)
{WI.HeapSnapshotWorkerProxy.singleton().callMethod(this._proxyObjectId,"retainedNodes",this.id,({retainedNodes:serializedNodes,edges:serializedEdges})=>{let deserializedNodes=serializedNodes.map(WI.HeapSnapshotNodeProxy.deserialize.bind(null,this._proxyObjectId));let deserializedEdges=serializedEdges.map(WI.HeapSnapshotEdgeProxy.deserialize.bind(null,this._proxyObjectId));callback(deserializedNodes,deserializedEdges);});}
retainers(callback)
{WI.HeapSnapshotWorkerProxy.singleton().callMethod(this._proxyObjectId,"retainers",this.id,({retainers:serializedNodes,edges:serializedEdges})=>{let deserializedNodes=serializedNodes.map(WI.HeapSnapshotNodeProxy.deserialize.bind(null,this._proxyObjectId));let deserializedEdges=serializedEdges.map(WI.HeapSnapshotEdgeProxy.deserialize.bind(null,this._proxyObjectId));callback(deserializedNodes,deserializedEdges);});}};WI.HeapSnapshotProxy=class HeapSnapshotProxy extends WI.Object
{constructor(snapshotObjectId,identifier,title,totalSize,totalObjectCount,liveSize,categories,imported)
{super();this._proxyObjectId=snapshotObjectId;this._identifier=identifier;this._title=title;this._totalSize=totalSize;this._totalObjectCount=totalObjectCount;this._liveSize=liveSize;this._categories=Map.fromObject(categories);this._imported=imported;this._snapshotStringData=null;if(!WI.HeapSnapshotProxy.ValidSnapshotProxies)
WI.HeapSnapshotProxy.ValidSnapshotProxies=[];WI.HeapSnapshotProxy.ValidSnapshotProxies.push(this);}
static deserialize(objectId,serializedSnapshot)
{let{identifier,title,totalSize,totalObjectCount,liveSize,categories,imported}=serializedSnapshot;return new WI.HeapSnapshotProxy(objectId,identifier,title,totalSize,totalObjectCount,liveSize,categories,imported);}
static invalidateSnapshotProxies()
{if(!WI.HeapSnapshotProxy.ValidSnapshotProxies)
return;for(let snapshotProxy of WI.HeapSnapshotProxy.ValidSnapshotProxies)
snapshotProxy._invalidate();WI.HeapSnapshotProxy.ValidSnapshotProxies=null;}
get proxyObjectId(){return this._proxyObjectId;}
get identifier(){return this._identifier;}
get title(){return this._title;}
get totalSize(){return this._totalSize;}
get totalObjectCount(){return this._totalObjectCount;}
get liveSize(){return this._liveSize;}
get categories(){return this._categories;}
get imported(){return this._imported;}
get invalid(){return this._proxyObjectId===0;}
get snapshotStringData()
{return this._snapshotStringData;}
set snapshotStringData(data)
{this._snapshotStringData=data;}
updateForCollectionEvent(event)
{if(!event.data.affectedSnapshots.includes(this._identifier))
return;this.update(()=>{this.dispatchEventToListeners(WI.HeapSnapshotProxy.Event.CollectedNodes,event.data);});}
allocationBucketCounts(bucketSizes,callback)
{WI.HeapSnapshotWorkerProxy.singleton().callMethod(this._proxyObjectId,"allocationBucketCounts",bucketSizes,callback);}
instancesWithClassName(className,callback)
{WI.HeapSnapshotWorkerProxy.singleton().callMethod(this._proxyObjectId,"instancesWithClassName",className,(serializedNodes)=>{callback(serializedNodes.map(WI.HeapSnapshotNodeProxy.deserialize.bind(null,this._proxyObjectId)));});}
update(callback)
{WI.HeapSnapshotWorkerProxy.singleton().callMethod(this._proxyObjectId,"update",({liveSize,categories})=>{this._liveSize=liveSize;this._categories=Map.fromObject(categories);callback();});}
nodeWithIdentifier(nodeIdentifier,callback)
{WI.HeapSnapshotWorkerProxy.singleton().callMethod(this._proxyObjectId,"nodeWithIdentifier",nodeIdentifier,(serializedNode)=>{callback(WI.HeapSnapshotNodeProxy.deserialize(this._proxyObjectId,serializedNode));});}
_invalidate()
{this._proxyObjectId=0;this._liveSize=0;this.dispatchEventToListeners(WI.HeapSnapshotProxy.Event.Invalidated);}};WI.HeapSnapshotProxy.Event={CollectedNodes:"heap-snapshot-proxy-collected-nodes",Invalidated:"heap-snapshot-proxy-invalidated",};WI.HeapSnapshotWorkerProxy=class HeapSnapshotWorkerProxy extends WI.Object
{constructor()
{super();this._heapSnapshotWorker=new Worker("Workers/HeapSnapshot/HeapSnapshotWorker.js");this._heapSnapshotWorker.addEventListener("message",this._handleMessage.bind(this));this._nextCallId=1;this._callbacks=new Map;WI.Frame.addEventListener(WI.Frame.Event.MainResourceDidChange,this._mainResourceDidChange,this);}
static singleton()
{if(!HeapSnapshotWorkerProxy.instance)
HeapSnapshotWorkerProxy.instance=new HeapSnapshotWorkerProxy;return HeapSnapshotWorkerProxy.instance;}
clearSnapshots(callback)
{this.performAction("clearSnapshots",callback);}
createSnapshot(snapshotStringData,callback)
{this.performAction("createSnapshot",...arguments);}
createSnapshotDiff(objectId1,objectId2,callback)
{this.performAction("createSnapshotDiff",...arguments);}
createImportedSnapshot(snapshotStringData,title,callback)
{const imported=true;this.performAction("createSnapshot",snapshotStringData,title,imported,callback);}
performAction(actionName)
{let callId=this._nextCallId++;let callback=arguments[arguments.length-1];let actionArguments=Array.prototype.slice.call(arguments,1,arguments.length-1);this._callbacks.set(callId,callback);this._postMessage({callId,actionName,actionArguments});}
callMethod(objectId,methodName)
{let callId=this._nextCallId++;let callback=arguments[arguments.length-1];let methodArguments=Array.prototype.slice.call(arguments,2,arguments.length-1);this._callbacks.set(callId,callback);this._postMessage({callId,objectId,methodName,methodArguments});}
_mainResourceDidChange(event)
{if(!event.target.isMainFrame())
return;this.clearSnapshots(()=>{WI.HeapSnapshotProxy.invalidateSnapshotProxies();});}
_postMessage()
{this._heapSnapshotWorker.postMessage(...arguments);}
_handleMessage(event)
{let data=event.data;if(data.error){this._callbacks.delete(data.callId);return;}
if(data.eventName){this.dispatchEventToListeners(data.eventName,data.eventData);return;}
if(data.callId){let callback=this._callbacks.get(data.callId);this._callbacks.delete(data.callId);callback(data.result);return;}
console.error("Unexpected HeapSnapshotWorker message",data);}};WI.HeapSnapshotWorkerProxy.Event={Collection:"heap-snapshot-collection",};WI.View=class View extends WI.Object
{constructor(element)
{super();this._element=element||document.createElement("div");this._element.__view=this;this._parentView=null;this._subviews=[];this._dirty=false;this._dirtyDescendantsCount=0;this._isAttachedToRoot=false;this._layoutReason=null;this._didInitialLayout=false;}
static fromElement(element)
{if(!element||!(element instanceof HTMLElement))
return null;if(element.__view instanceof WI.View)
return element.__view;return null;}
static rootView()
{if(!WI.View._rootView){WI.View._rootView=new WI.View(document.body);WI.View._rootView._isAttachedToRoot=true;}
return WI.View._rootView;}
get element(){return this._element;}
get layoutPending(){return this._dirty;}
get parentView(){return this._parentView;}
get subviews(){return this._subviews;}
get isAttached(){return this._isAttachedToRoot;}
isDescendantOf(view)
{let parentView=this._parentView;while(parentView){if(parentView===view)
return true;parentView=parentView.parentView;}
return false;}
addSubview(view)
{this.insertSubviewBefore(view,null);}
insertSubviewBefore(view,referenceView)
{if(this._subviews.includes(view)){return;}
const beforeIndex=referenceView?this._subviews.indexOf(referenceView):this._subviews.length;if(beforeIndex===-1){return;}
this._subviews.insertAtIndex(view,beforeIndex);if(!view.element.parentNode)
this._element.insertBefore(view.element,referenceView?referenceView.element:null);view._didMoveToParent(this);}
removeSubview(view)
{let index=this._subviews.lastIndexOf(view);if(index===-1){return;}
view._didMoveToParent(null);this._subviews.splice(index,1);view.element.remove();}
removeAllSubviews()
{for(let subview of this._subviews)
subview._didMoveToParent(null);this._subviews=[];this._element.removeChildren();}
replaceSubview(oldView,newView)
{if(oldView===newView)
return;this.insertSubviewBefore(newView,oldView);this.removeSubview(oldView);}
updateLayout(layoutReason)
{this._setLayoutReason(layoutReason);this._layoutSubtree();}
updateLayoutIfNeeded(layoutReason)
{if(!this._dirty&&this._didInitialLayout)
return;this.updateLayout(layoutReason);}
needsLayout(layoutReason)
{this._setLayoutReason(layoutReason);if(this._dirty)
return;WI.View._scheduleLayoutForView(this);}
get layoutReason(){return this._layoutReason;}
get didInitialLayout(){return this._didInitialLayout;}
attached()
{}
detached()
{}
initialLayout()
{}
layout()
{}
didLayoutSubtree()
{}
sizeDidChange()
{}
_setDirty(dirty)
{if(this._dirty===dirty)
return;this._dirty=dirty;for(let parentView=this.parentView;parentView;parentView=parentView.parentView){parentView._dirtyDescendantsCount+=this._dirty?1:-1;}}
_didMoveToParent(parentView)
{if(this._parentView===parentView)
return;let dirtyDescendantsCount=this._dirtyDescendantsCount;if(this._dirty)
++dirtyDescendantsCount;if(dirtyDescendantsCount){for(let view=this.parentView;view;view=view.parentView){view._dirtyDescendantsCount-=dirtyDescendantsCount;}}
this._parentView=parentView;let isAttachedToRoot=this.isDescendantOf(WI.View._rootView);let views=[this];for(let i=0;i<views.length;++i){let view=views[i];views.pushAll(view.subviews);view._dirty=false;view._dirtyDescendantsCount=0;if(view._isAttachedToRoot===isAttachedToRoot)
continue;view._isAttachedToRoot=isAttachedToRoot;if(view._isAttachedToRoot)
view.attached();else
view.detached();}
if(isAttachedToRoot)
WI.View._scheduleLayoutForView(this);}
_layoutSubtree()
{this._setDirty(false);let isInitialLayout=!this._didInitialLayout;if(isInitialLayout){this.initialLayout();this._didInitialLayout=true;}
if(this._layoutReason===WI.View.LayoutReason.Resize||isInitialLayout){this.sizeDidChange();}
let savedLayoutReason=this._layoutReason;if(isInitialLayout){this._setLayoutReason();}
this.layout();this._layoutReason=savedLayoutReason;if(WI.settings.debugEnableLayoutFlashing.value)
this._drawLayoutFlashingOutline(isInitialLayout);for(let view of this._subviews){view._setLayoutReason(this._layoutReason);view._layoutSubtree();}
this._layoutReason=null;this.didLayoutSubtree();}
_setLayoutReason(layoutReason)
{this._layoutReason=layoutReason||WI.View.LayoutReason.Dirty;}
_drawLayoutFlashingOutline(isInitialLayout)
{if(this._layoutFlashingTimeout)
clearTimeout(this._layoutFlashingTimeout);else
this._layoutFlashingPreviousOutline=this._element.style.outline;let hue=isInitialLayout?20:40;this._element.style.outline=`1px solid hsla(${hue}, 100%, 51%, 0.8)`;this._layoutFlashingTimeout=setTimeout(()=>{if(this._element)
this._element.style.outline=this._layoutFlashingPreviousOutline;this._layoutFlashingTimeout=undefined;this._layoutFlashingPreviousOutline=null;},500);}
static _scheduleLayoutForView(view)
{if(!view._isAttachedToRoot)
return;view._setDirty(true);if(WI.View._scheduledLayoutUpdateIdentifier)
return;WI.View._scheduledLayoutUpdateIdentifier=requestAnimationFrame(WI.View._visitViewTreeForLayout);}
static _visitViewTreeForLayout()
{WI.View._scheduledLayoutUpdateIdentifier=undefined;let views=[WI.View._rootView];for(let i=0;i<views.length;++i){let view=views[i];if(view.layoutPending)
view._layoutSubtree();else if(view._dirtyDescendantsCount)
views.pushAll(view.subviews);}}};WI.View.LayoutReason={Dirty:Symbol("layout-reason-dirty"),Resize:Symbol("layout-reason-resize")};WI.View._rootView=null;WI.View._scheduledLayoutUpdateIdentifier=undefined;WI.SelectionController=class SelectionController extends WI.Object
{constructor(delegate,comparator)
{super();this._delegate=delegate;this._comparator=comparator;this._allowsEmptySelection=true;this._allowsMultipleSelection=false;this._lastSelectedItem=null;this._shiftAnchorItem=null;this._selectedItems=new Set;this._suppressSelectionDidChange=false;}
static createTreeComparator(itemForRepresentedObject)
{return(a,b)=>{a=itemForRepresentedObject(a);b=itemForRepresentedObject(b);if(!a||!b)
return 0;let getLevel=(item)=>{let level=0;while(item=item.parent)
level++;return level;};let compareSiblings=(s,t)=>{return s.parent.children.indexOf(s)-s.parent.children.indexOf(t);};if(a.parent===b.parent)
return compareSiblings(a,b);let aLevel=getLevel(a);let bLevel=getLevel(b);while(aLevel>bLevel){if(a.parent===b)
return 1;a=a.parent;aLevel--;}
while(bLevel>aLevel){if(b.parent===a)
return-1;b=b.parent;bLevel--;}
while(a.parent!==b.parent){a=a.parent;b=b.parent;}
return compareSiblings(a,b);};}
static createListComparator(indexForRepresentedObject)
{return(a,b)=>{return indexForRepresentedObject(a)-indexForRepresentedObject(b);};}
get delegate(){return this._delegate;}
get lastSelectedItem(){return this._lastSelectedItem;}
get selectedItems(){return this._selectedItems;}
get allowsEmptySelection(){return this._allowsEmptySelection;}
set allowsEmptySelection(flag){this._allowsEmptySelection=flag;}
get allowsMultipleSelection()
{return this._allowsMultipleSelection;}
set allowsMultipleSelection(flag)
{if(this._allowsMultipleSelection===flag)
return;this._allowsMultipleSelection=flag;if(this._allowsMultipleSelection)
return;if(this._selectedItems.size>1)
this._updateSelectedItems(new Set([this._lastSelectedItem]));}
hasSelectedItem(item)
{return this._selectedItems.has(item);}
selectItem(item,extendSelection=false)
{if(!this._allowsMultipleSelection)
extendSelection=false;this._lastSelectedItem=item;this._shiftAnchorItem=null;let newItems=new Set(extendSelection?this._selectedItems:null);newItems.add(item);this._updateSelectedItems(newItems);}
selectItems(items)
{if(!this._allowsMultipleSelection)
return;if(!this._lastSelectedItem||!items.has(this._lastSelectedItem))
this._lastSelectedItem=items.lastValue;if(!this._shiftAnchorItem||!items.has(this._shiftAnchorItem))
this._shiftAnchorItem=this._lastSelectedItem;this._updateSelectedItems(items);}
deselectItem(item)
{if(!this.hasSelectedItem(item))
return;if(!this._allowsEmptySelection&&this._selectedItems.size===1)
return;let newItems=new Set(this._selectedItems);newItems.delete(item);if(this._lastSelectedItem===item){this._lastSelectedItem=null;if(newItems.size){const operation=WI.SelectionController.Operation.Extend;let previous=item;let next=item;while(!this._lastSelectedItem&&previous&&next){previous=this._previousSelectableItem(previous,operation);if(this.hasSelectedItem(previous)){this._lastSelectedItem=previous;break;}
next=this._nextSelectableItem(next,operation);if(this.hasSelectedItem(next)){this._lastSelectedItem=next;break;}}}}
if(this._shiftAnchorItem===item)
this._shiftAnchorItem=null;this._updateSelectedItems(newItems);}
selectAll()
{if(!this._allowsMultipleSelection)
return;const operation=WI.SelectionController.Operation.Extend;let newItems=new Set;this._addRange(newItems,this._firstSelectableItem(operation),this._lastSelectableItem(operation));this.selectItems(newItems);}
deselectAll()
{this._deselectAllAndSelect(null);}
removeSelectedItems()
{if(!this._selectedItems.size)
return;let operation=this._allowsMultipleSelection?WI.SelectionController.Operation.Extend:WI.SelectionController.Operation.Direct;let orderedSelection=Array.from(this._selectedItems).sort(this._comparator);let firstSelectedItem=orderedSelection[0];let itemToSelect=this._previousSelectableItem(firstSelectedItem,operation);if(!itemToSelect){itemToSelect=firstSelectedItem;while(itemToSelect&&this.hasSelectedItem(itemToSelect))
itemToSelect=this._nextSelectableItem(itemToSelect,operation);if(!itemToSelect||this.hasSelectedItem(itemToSelect)){itemToSelect=this._nextSelectableItem(orderedSelection.lastValue,operation);}}
this._deselectAllAndSelect(itemToSelect);}
reset()
{this._lastSelectedItem=null;this._shiftAnchorItem=null;this._selectedItems.clear();}
didRemoveItems(items)
{if(!items.size||!this._selectedItems.size)
return;this._updateSelectedItems(this._selectedItems.difference(items));}
handleKeyDown(event)
{if(event.key==="a"&&event.commandOrControlKey){this.selectAll();return true;}
if(event.metaKey||event.ctrlKey)
return false;if(event.keyIdentifier==="Up"||event.keyIdentifier==="Down"){this._selectItemsFromArrowKey(event.keyIdentifier==="Up",event.shiftKey);event.preventDefault();event.stopPropagation();return true;}
return false;}
handleItemMouseDown(item,event)
{if(event.button!==0||event.ctrlKey)
return;if(event.commandOrControlKey){if(this.hasSelectedItem(item))
this.deselectItem(item);else
this.selectItem(item,this._allowsMultipleSelection);return;}
let shiftExtendSelection=this._allowsMultipleSelection&&event.shiftKey;if(!shiftExtendSelection){this.selectItem(item);return;}
let newItems=new Set(this._selectedItems);if(!newItems.size){this._lastSelectedItem=item;this._shiftAnchorItem=this._firstSelectableItem(WI.SelectionController.Operation.Extend);this._addRange(newItems,this._shiftAnchorItem,this._lastSelectedItem);this._updateSelectedItems(newItems);return;}
if(!this._shiftAnchorItem)
this._shiftAnchorItem=this._lastSelectedItem;let sortItemPair=(a,b)=>{return[a,b].sort(this._comparator);};if(this._shiftAnchorItem!==this._lastSelectedItem){let[startItem,endItem]=sortItemPair(this._shiftAnchorItem,this._lastSelectedItem);this._deleteRange(newItems,startItem,endItem);}
let[startItem,endItem]=sortItemPair(this._shiftAnchorItem,item);this._addRange(newItems,startItem,endItem);this._lastSelectedItem=item;this._updateSelectedItems(newItems);}
_deselectAllAndSelect(item)
{if(!this._selectedItems.size&&!item)
return;if(this._selectedItems.size===1&&this.hasSelectedItem(item))
return;this._lastSelectedItem=item;this._shiftAnchorItem=null;let newItems=new Set;if(item)
newItems.add(item);this._updateSelectedItems(newItems);}
_selectItemsFromArrowKey(goingUp,shiftKey)
{let extendSelection=shiftKey&&this._allowsMultipleSelection;let operation=extendSelection?WI.SelectionController.Operation.Extend:WI.SelectionController.Operation.Direct;if(!this._selectedItems.size){this.selectItem(goingUp?this._lastSelectableItem(operation):this._firstSelectableItem(operation));return;}
let item=goingUp?this._previousSelectableItem(this._lastSelectedItem,operation):this._nextSelectableItem(this._lastSelectedItem,operation);if(!item)
return;if(!extendSelection||!this.hasSelectedItem(item)){this.selectItem(item,extendSelection);return;}
let priorItem=goingUp?this._nextSelectableItem(this._lastSelectedItem,operation):this._previousSelectableItem(this._lastSelectedItem,operation);if(!priorItem||!this.hasSelectedItem(priorItem)){this.deselectItem(this._lastSelectedItem);return;}
while(item){if(!this.hasSelectedItem(item)){this.selectItem(item,extendSelection);break;}
this._lastSelectedItem=item;item=goingUp?this._previousSelectableItem(item,operation):this._nextSelectableItem(item,operation);}}
_firstSelectableItem(operation)
{return this._delegate.selectionControllerFirstSelectableItem(this,operation);}
_lastSelectableItem(operation)
{return this._delegate.selectionControllerLastSelectableItem(this,operation);}
_previousSelectableItem(item,operation)
{return this._delegate.selectionControllerPreviousSelectableItem(this,item,operation);}
_nextSelectableItem(item,operation)
{return this._delegate.selectionControllerNextSelectableItem(this,item,operation);}
_updateSelectedItems(items)
{let oldSelectedItems=this._selectedItems;this._selectedItems=items;if(this._suppressSelectionDidChange||!this._delegate.selectionControllerSelectionDidChange)
return;let deselectedItems=oldSelectedItems.difference(items);let selectedItems=items.difference(oldSelectedItems);if(deselectedItems.size||selectedItems.size)
this._delegate.selectionControllerSelectionDidChange(this,deselectedItems,selectedItems);}
_addRange(items,firstItem,lastItem)
{const operation=WI.SelectionController.Operation.Extend;let current=firstItem;while(current){items.add(current);if(current===lastItem)
break;current=this._nextSelectableItem(current,operation);}}
_deleteRange(items,firstItem,lastItem)
{const operation=WI.SelectionController.Operation.Extend;let current=firstItem;while(current){items.delete(current);if(current===lastItem)
break;current=this._nextSelectableItem(current,operation);}}};WI.SelectionController.Operation={Direct:Symbol("selection-operation-direct"),Extend:Symbol("selection-operation-extend"),};WI.ConsoleCommandView=class ConsoleCommandView
{constructor(commandText,className)
{this._commandText=commandText;this._className=className||"";}
render()
{this._element=document.createElement("div");this._element.classList.add("console-user-command");this._element.dir="ltr";this._element.setAttribute("data-labelprefix",WI.UIString("Input: "));if(this._className)
this._element.classList.add(this._className);this._formattedCommandElement=this._element.appendChild(document.createElement("span"));this._formattedCommandElement.classList.add("console-message-body");this._formattedCommandElement.textContent=this._commandText;this._element.__commandView=this;}
get element()
{return this._element;}
get commandText()
{return this._commandText;}
toClipboardString(isPrefixOptional)
{return(isPrefixOptional?"":"> ")+this._commandText.removeWordBreakCharacters();}};WI.ConsoleMessageView=class ConsoleMessageView extends WI.Object
{constructor(message)
{super();this._message=message;this._expandable=false;this._repeatCount=message._repeatCount||0;this._extraParameters=message.parameters;}
render()
{this._element=document.createElement("div");this._element.classList.add("console-message");this._element.dir="ltr";this._element.__message=this._message;this._element.__messageView=this;if(this._message.type===WI.ConsoleMessage.MessageType.Result){this._element.classList.add("console-user-command-result");this._element.setAttribute("data-labelprefix",WI.UIString("Output: "));}else if(this._message.type===WI.ConsoleMessage.MessageType.StartGroup||this._message.type===WI.ConsoleMessage.MessageType.StartGroupCollapsed)
this._element.classList.add("console-group-title");switch(this._message.level){case WI.ConsoleMessage.MessageLevel.Log:this._element.classList.add("console-log-level");this._element.setAttribute("data-labelprefix",WI.UIString("Log: "));break;case WI.ConsoleMessage.MessageLevel.Info:this._element.classList.add("console-info-level");this._element.setAttribute("data-labelprefix",WI.UIString("Info: "));break;case WI.ConsoleMessage.MessageLevel.Debug:this._element.classList.add("console-debug-level");this._element.setAttribute("data-labelprefix",WI.UIString("Debug: "));break;case WI.ConsoleMessage.MessageLevel.Warning:this._element.classList.add("console-warning-level");this._element.setAttribute("data-labelprefix",WI.UIString("Warning: "));break;case WI.ConsoleMessage.MessageLevel.Error:this._element.classList.add("console-error-level");this._element.setAttribute("data-labelprefix",WI.UIString("Error: "));break;}
this._appendLocationLink();this._messageBodyElement=this._element.appendChild(document.createElement("span"));this._messageBodyElement.classList.add("console-top-level-message","console-message-body");this._appendMessageTextAndArguments(this._messageBodyElement);this._appendSavedResultIndex();this._appendExtraParameters();this._appendStackTrace();this._renderRepeatCount();if(this._message.type===WI.ConsoleMessage.MessageType.Dir)
this.expand();else if(this._message.type===WI.ConsoleMessage.MessageType.Image){this._element.classList.add("console-image");this._element.addEventListener("contextmenu",this._handleContextMenu.bind(this));}
WI.debuggerManager.addEventListener(WI.DebuggerManager.Event.BlackboxChanged,this._handleDebuggerBlackboxChanged,this);}
get element()
{return this._element;}
get message()
{return this._message;}
get repeatCount()
{return this._repeatCount;}
set repeatCount(count)
{if(this._repeatCount===count)
return;this._repeatCount=count;if(this._element)
this._renderRepeatCount();}
_renderRepeatCount()
{let count=this._repeatCount;if(count<=1){if(this._repeatCountElement){this._repeatCountElement.remove();this._repeatCountElement=null;}
return;}
if(!this._repeatCountElement){this._repeatCountElement=document.createElement("span");this._repeatCountElement.classList.add("repeat-count");this._element.insertBefore(this._repeatCountElement,this._element.firstChild);}
this._repeatCountElement.textContent=Number.abbreviate(count);}
get expandable()
{if(this._expandable)
return true;if(this._objectTree)
return true;return false;}
expand()
{if(this._expandable)
this._element.classList.add("expanded");if(this._objectTree&&this._message.type!==WI.ConsoleMessage.MessageType.Trace){if(!this._extraParameters||this._extraParameters.length<=1)
this._objectTree.expand();}}
collapse()
{if(this._expandable)
this._element.classList.remove("expanded");if(this._objectTree){if(!this._extraParameters||this._extraParameters.length<=1)
this._objectTree.collapse();}}
toggle()
{if(this._element.classList.contains("expanded"))
this.collapse();else
this.expand();}
toClipboardString(isPrefixOptional)
{let clipboardString=this._messageBodyElement.innerText.removeWordBreakCharacters();if(this._message.savedResultIndex){let escapedSavedResultPrefix=WI.RuntimeManager.preferredSavedResultPrefix().escapeForRegExp();clipboardString=clipboardString.replace(new RegExp(`\\s*=\\s*${escapedSavedResultPrefix}\\d+\\s*$`),"");}
let hasStackTrace=this._shouldShowStackTrace();if(!hasStackTrace){let repeatString=this.repeatCount>1?"x"+this.repeatCount:"";let urlLine="";if(this._message.url){let components=[WI.displayNameForURL(this._message.url),"line "+this._message.line];if(repeatString)
components.push(repeatString);urlLine=" ("+components.join(", ")+")";}else if(repeatString)
urlLine=" ("+repeatString+")";if(urlLine){let lines=clipboardString.split("\n");lines[0]+=urlLine;clipboardString=lines.join("\n");}}
if(this._extraElementsList)
clipboardString+="\n"+this._extraElementsList.innerText.removeWordBreakCharacters().trim();if(hasStackTrace){this._message.stackTrace.callFrames.forEach(function(frame){clipboardString+="\n\t"+frame.displayName;if(frame.sourceCodeLocation)
clipboardString+=" ("+frame.sourceCodeLocation.originalLocationString()+")";});}
if(!isPrefixOptional||this._enforcesClipboardPrefixString())
return this._clipboardPrefixString()+clipboardString;return clipboardString;}
clearSessionState()
{for(let node of this._messageBodyElement.querySelectorAll(".console-saved-variable"))
node.remove();if(this._objectTree instanceof WI.ObjectTreeView)
this._objectTree.resetPropertyPath();WI.debuggerManager.removeEventListener(WI.DebuggerManager.Event.BlackboxChanged,this._handleDebuggerBlackboxChanged,this);}
_appendMessageTextAndArguments(element)
{if(this._message.source===WI.ConsoleMessage.MessageSource.ConsoleAPI){switch(this._message.type){case WI.ConsoleMessage.MessageType.Trace:var args=[WI.UIString("Trace")];if(this._message.parameters){if(this._message.parameters[0].type==="string"){var prefixedFormatString=WI.UIString("Trace: %s").format(this._message.parameters[0].description);args=[prefixedFormatString].concat(this._message.parameters.slice(1));}else
args.pushAll(this._message.parameters);}
this._appendFormattedArguments(element,args);return;case WI.ConsoleMessage.MessageType.Assert:var args=[WI.UIString("Assertion Failed")];if(this._message.parameters){if(this._message.parameters[0].type==="string"){var prefixedFormatString=WI.UIString("Assertion Failed: %s").format(this._message.parameters[0].description);args=[prefixedFormatString].concat(this._message.parameters.slice(1));}else
args.pushAll(this._message.parameters);}
this._appendFormattedArguments(element,args);return;case WI.ConsoleMessage.MessageType.Dir:var obj=this._message.parameters?this._message.parameters[0]:undefined;this._appendFormattedArguments(element,["%O",obj]);return;case WI.ConsoleMessage.MessageType.Table:var args=this._message.parameters;element.appendChild(this._formatParameterAsTable(args));this._extraParameters=null;return;case WI.ConsoleMessage.MessageType.StartGroup:case WI.ConsoleMessage.MessageType.StartGroupCollapsed:var args=this._message.parameters||[this._message.messageText||WI.UIString("Group")];this._formatWithSubstitutionString(args,element);this._extraParameters=null;return;case WI.ConsoleMessage.MessageType.Timing:{let args=[this._message.messageText];if(this._extraParameters)
args.pushAll(this._extraParameters);this._appendFormattedArguments(element,args);return;}
case WI.ConsoleMessage.MessageType.Image:{if(this._message.level===WI.ConsoleMessage.MessageLevel.Log){let divider=null;if(this._message.parameters.length>1){this._appendFormattedArguments(element,this._message.parameters.slice(1));divider=element.appendChild(document.createElement("hr"));}
let target=this._message.parameters[0];if(target==="Viewport")
target=WI.UIString("Viewport");this._appendFormattedArguments(element,[target]);if(this._message.messageText){let img=document.createElement("img");img.classList.add("show-grid");img.src=this._message.messageText;img.setAttribute("filename",WI.FileUtilities.screenshotString()+".png");img.addEventListener("load",(event)=>{if(img.width>=img.height)
img.width=img.width/window.devicePixelRatio;else
img.height=img.height/window.devicePixelRatio;element.appendChild(img);});img.addEventListener("error",(event)=>{this._element.setAttribute("data-labelprefix",WI.UIString("Error: "));this._element.classList.add("console-error-level");this._element.classList.remove("console-log-level");if(divider){while(divider.nextSibling)
divider.nextSibling.remove();}else
element.removeChildren();let args=[WI.UIString("Could not capture screenshot"),this._message.messageText];if(this._extraParameters)
args.pushAll(this._extraParameters);this._appendFormattedArguments(element,args);});}
return;}
if(this._message.level===WI.ConsoleMessage.MessageLevel.Error){let args=[];if(this._message.messageText==="Could not capture screenshot")
args.push(WI.UIString("Could not capture screenshot"));else
args.push(this._message.messageText);if(this._extraParameters)
args.pushAll(this._extraParameters);this._appendFormattedArguments(element,args);return;}
break;}}}
var args=this._message.parameters||[this._message.messageText];this._appendFormattedArguments(element,args);}
_appendSavedResultIndex(element)
{let savedResultIndex=this._message.savedResultIndex;if(!savedResultIndex)
return;var savedVariableElement=document.createElement("span");savedVariableElement.classList.add("console-saved-variable");function updateSavedVariableText(){savedVariableElement.textContent=" = "+WI.RuntimeManager.preferredSavedResultPrefix()+savedResultIndex;}
WI.settings.consoleSavedResultAlias.addEventListener(WI.Setting.Event.Changed,updateSavedVariableText,savedVariableElement);updateSavedVariableText();if(this._objectTree)
this._objectTree.appendTitleSuffix(savedVariableElement);else
this._messageBodyElement.appendChild(savedVariableElement);}
_appendLocationLink()
{if(this._message.source===WI.ConsoleMessage.MessageSource.Network){if(this._message.url){var anchor=WI.linkifyURLAsNode(this._message.url,this._message.url,"console-message-url");anchor.classList.add("console-message-location");this._element.appendChild(anchor);}
return;}
var callFrame;let firstNonNativeNonAnonymousNotBlackboxedCallFrame=this._message.stackTrace.firstNonNativeNonAnonymousNotBlackboxedCallFrame;if(firstNonNativeNonAnonymousNotBlackboxedCallFrame){callFrame=firstNonNativeNonAnonymousNotBlackboxedCallFrame;}else if(this._message.url&&!this._shouldHideURL(this._message.url)){callFrame=WI.CallFrame.fromPayload(this._message.target,{functionName:"",url:this._message.url,lineNumber:this._message.line,columnNumber:this._message.column});}
if(callFrame&&(!callFrame.isConsoleEvaluation||WI.settings.debugShowConsoleEvaluations.value)){let existingCallFrameView=this._callFrameView;this._callFrameView=new WI.CallFrameView(callFrame,{showFunctionName:!!callFrame.functionName});this._callFrameView.classList.add("console-message-location");if(existingCallFrameView)
this._element.replaceChild(this._callFrameView,existingCallFrameView);else
this._element.appendChild(this._callFrameView);return;}
if(this._message.parameters&&this._message.parameters.length===1){var parameter=this._createRemoteObjectIfNeeded(this._message.parameters[0]);parameter.findFunctionSourceCodeLocation().then((result)=>{if(result===WI.RemoteObject.SourceCodeLocationPromise.NoSourceFound||result===WI.RemoteObject.SourceCodeLocationPromise.MissingObjectId)
return;let link=WI.linkifySourceCode(result.sourceCode,new WI.SourceCodePosition(result.lineNumber,result.columnNumber),{className:"console-message-url",ignoreNetworkTab:true,ignoreSearchTab:true,});link.classList.add("console-message-location");if(this._element.hasChildNodes())
this._element.insertBefore(link,this._element.firstChild);else
this._element.appendChild(link);});}}
_appendExtraParameters()
{if(!this._extraParameters||!this._extraParameters.length)
return;this._makeExpandable();if(this._extraParameters.length>1)
this.expand();this._extraElementsList=this._element.appendChild(document.createElement("ol"));this._extraElementsList.classList.add("console-message-extra-parameters-container");for(var parameter of this._extraParameters){var listItemElement=this._extraElementsList.appendChild(document.createElement("li"));const forceObjectFormat=parameter.type==="object"&&(parameter.subtype!=="null"&&parameter.subtype!=="regexp"&&parameter.subtype!=="node"&&parameter.subtype!=="error");listItemElement.classList.add("console-message-extra-parameter");listItemElement.appendChild(this._formatParameter(parameter,forceObjectFormat));}}
_appendStackTrace()
{if(!this._shouldShowStackTrace())
return;this._makeExpandable();if(this._message.type===WI.ConsoleMessage.MessageType.Trace&&WI.settings.consoleAutoExpandTrace.value)
this.expand();this._stackTraceElement=this._element.appendChild(document.createElement("div"));this._stackTraceElement.classList.add("console-message-body","console-message-stack-trace-container");var callFramesElement=new WI.StackTraceView(this._message.stackTrace).element;this._stackTraceElement.appendChild(callFramesElement);}
_createRemoteObjectIfNeeded(parameter)
{if(parameter instanceof WI.RemoteObject)
return parameter;if(typeof parameter==="object")
return WI.RemoteObject.fromPayload(parameter,this._message.target);return WI.RemoteObject.fromPrimitiveValue(parameter);}
_appendFormattedArguments(element,parameters)
{if(!parameters.length)
return;for(let i=0;i<parameters.length;++i)
parameters[i]=this._createRemoteObjectIfNeeded(parameters[i]);let builderElement=element.appendChild(document.createElement("span"));let shouldFormatWithStringSubstitution=parameters[0].type==="string"&&this._message.type!==WI.ConsoleMessage.MessageType.Result;if(parameters.length===1&&!shouldFormatWithStringSubstitution){this._extraParameters=null;builderElement.appendChild(this._formatParameter(parameters[0],false));return;}
if(shouldFormatWithStringSubstitution&&this._isStackTrace(parameters[0]))
shouldFormatWithStringSubstitution=false;let needsDivider=false;function appendDividerIfNeeded(){if(!needsDivider)
return null;let element=builderElement.appendChild(document.createElement("span"));element.classList.add("console-message-preview-divider");element.textContent=` ${enDash} `;return element;}
if(shouldFormatWithStringSubstitution){let result=this._formatWithSubstitutionString(parameters,builderElement);parameters=result.unusedSubstitutions;this._extraParameters=parameters;needsDivider=true;}
if(parameters.length){let simpleParametersCount=0;for(let parameter of parameters){if(!this._hasSimpleDisplay(parameter))
break;simpleParametersCount++;}
if(simpleParametersCount){let simpleParameters=parameters.splice(0,simpleParametersCount);this._extraParameters=parameters;for(let parameter of simpleParameters){let dividerElement=appendDividerIfNeeded();if(dividerElement)
dividerElement.classList.add("inline-lossless");let previewContainer=builderElement.appendChild(document.createElement("span"));previewContainer.classList.add("inline-lossless");let preview=WI.FormattedValue.createObjectPreviewOrFormattedValueForRemoteObject(parameter,WI.ObjectPreviewView.Mode.Brief);let isPreviewView=preview instanceof WI.ObjectPreviewView;if(isPreviewView)
preview.setOriginatingObjectInfo(parameter,null);let previewElement=isPreviewView?preview.element:preview;previewContainer.appendChild(previewElement);needsDivider=true;}}
if(parameters.length===1&&!this._isStackTrace(parameters[0])){let parameter=parameters[0];let dividerElement=appendDividerIfNeeded();let previewContainer=builderElement.appendChild(document.createElement("span"));previewContainer.classList.add("console-message-preview");let preview=WI.FormattedValue.createObjectPreviewOrFormattedValueForRemoteObject(parameter,WI.ObjectPreviewView.Mode.Brief);let isPreviewView=preview instanceof WI.ObjectPreviewView;if(isPreviewView)
preview.setOriginatingObjectInfo(parameter,null);let previewElement=isPreviewView?preview.element:preview;previewContainer.appendChild(previewElement);needsDivider=true;if((isPreviewView&&preview.lossless)||(!isPreviewView&&this._shouldConsiderObjectLossless(parameter))){this._extraParameters=null;if(dividerElement)
dividerElement.classList.add("inline-lossless");previewContainer.classList.add("inline-lossless");}}else if(parameters.length){let enclosedElement=document.createElement("span");builderElement.append(" ",enclosedElement);enclosedElement.classList.add("console-message-enclosed");enclosedElement.textContent="("+parameters.length+")";}}}
_hasSimpleDisplay(parameter)
{return WI.FormattedValue.hasSimpleDisplay(parameter)&&!this._isStackTrace(parameter);}
_isStackTrace(parameter)
{return parameter.type==="string"&&WI.StackTrace.isLikelyStackTrace(parameter.description);}
_shouldConsiderObjectLossless(object)
{if(object.type==="string")
return WI.FormattedValue.isSimpleString(object.description);return object.type!=="object"||object.subtype==="null"||object.subtype==="regexp";}
_formatParameter(parameter,forceObjectFormat)
{var type;if(forceObjectFormat)
type="object";else if(parameter instanceof WI.RemoteObject)
type=parameter.subtype||parameter.type;else{type=typeof parameter;}
var formatters={"object":this._formatParameterAsObject,"error":this._formatParameterAsError,"map":this._formatParameterAsObject,"set":this._formatParameterAsObject,"weakmap":this._formatParameterAsObject,"weakset":this._formatParameterAsObject,"iterator":this._formatParameterAsObject,"class":this._formatParameterAsObject,"proxy":this._formatParameterAsObject,"array":this._formatParameterAsArray,"node":this._formatParameterAsNode,"string":this._formatParameterAsString,};var formatter=formatters[type]||this._formatParameterAsValue;const fragment=document.createDocumentFragment();formatter.call(this,parameter,fragment,forceObjectFormat);return fragment;}
_formatParameterAsValue(value,fragment)
{fragment.appendChild(WI.FormattedValue.createElementForRemoteObject(value));}
_formatParameterAsString(object,fragment)
{if(this._isStackTrace(object)){let stackTrace=WI.StackTrace.fromString(this._message.target,object.description);if(stackTrace.callFrames.length){let stackView=new WI.StackTraceView(stackTrace);fragment.appendChild(stackView.element);return;}}
fragment.appendChild(WI.FormattedValue.createLinkifiedElementString(object.description));}
_formatParameterAsNode(object,fragment)
{fragment.appendChild(WI.FormattedValue.createElementForNode(object));}
_formatParameterAsObject(object,fragment,forceExpansion)
{this._objectTree=new WI.ObjectTreeView(object,null,this._rootPropertyPathForObject(object),forceExpansion);fragment.appendChild(this._objectTree.element);}
_formatParameterAsError(object,fragment)
{this._objectTree=new WI.ErrorObjectView(object);fragment.appendChild(this._objectTree.element);}
_formatParameterAsArray(array,fragment)
{this._objectTree=new WI.ObjectTreeView(array,WI.ObjectTreeView.Mode.Properties,this._rootPropertyPathForObject(array));fragment.appendChild(this._objectTree.element);}
_rootPropertyPathForObject(object)
{let savedResultIndex=this._message.savedResultIndex;if(!savedResultIndex)
return null;function prefixSavedResultIndex(){return WI.RuntimeManager.preferredSavedResultPrefix()+savedResultIndex;}
let propertyPath=new WI.PropertyPath(object,prefixSavedResultIndex());WI.settings.consoleSavedResultAlias.addEventListener(WI.Setting.Event.Changed,function(event){this.pathComponent=prefixSavedResultIndex();},propertyPath);return propertyPath;}
_formatWithSubstitutionString(parameters,formattedResult)
{function parameterFormatter(force,obj)
{return this._formatParameter(obj,force);}
function stringFormatter(obj)
{return obj.description;}
function floatFormatter(obj,token)
{let value=typeof obj.value==="number"?obj.value:obj.description;return String.standardFormatters.f(value,token);}
function integerFormatter(obj)
{let value=typeof obj.value==="number"?obj.value:obj.description;return String.standardFormatters.d(value);}
var currentStyle=null;function styleFormatter(obj)
{currentStyle={};var buffer=document.createElement("span");buffer.setAttribute("style",obj.description);for(var i=0;i<buffer.style.length;i++){var property=buffer.style[i];if(isAllowedProperty(property))
currentStyle[property]=buffer.style[property];}}
function isAllowedProperty(property)
{for(var prefix of["background","border","color","font","line","margin","padding","text"]){if(property.startsWith(prefix)||property.startsWith("-webkit-"+prefix))
return true;}
return false;}
var formatters={};formatters.o=parameterFormatter.bind(this,false);formatters.s=stringFormatter;formatters.f=floatFormatter;formatters.i=integerFormatter;formatters.d=integerFormatter;formatters.c=styleFormatter;formatters.O=parameterFormatter.bind(this,true);function append(a,b)
{if(b instanceof Node)
a.appendChild(b);else if(b!==undefined){var toAppend=WI.linkifyStringAsFragment(b.toString());if(currentStyle){var wrapper=document.createElement("span");for(var key in currentStyle)
wrapper.style[key]=currentStyle[key];wrapper.appendChild(toAppend);toAppend=wrapper;}
a.appendChild(toAppend);}
return a;}
return String.format(parameters[0].description,parameters.slice(1),formatters,formattedResult,append);}
_shouldShowStackTrace()
{if(!this._message.stackTrace.callFrames.length)
return false;return this._message.source===WI.ConsoleMessage.MessageSource.Network||this._message.level===WI.ConsoleMessage.MessageLevel.Error||this._message.type===WI.ConsoleMessage.MessageType.Trace;}
_shouldHideURL(url)
{return url==="undefined"||url==="[native code]";}
_userProvidedColumnNames(columnNamesArgument)
{if(!columnNamesArgument)
return null;if(columnNamesArgument.type==="string"||columnNamesArgument.type==="number")
return[String(columnNamesArgument.value)];if(columnNamesArgument.type!=="object"||columnNamesArgument.subtype!=="array"||!columnNamesArgument.preview||!columnNamesArgument.preview.propertyPreviews)
return null;var extractedColumnNames=[];for(var propertyPreview of columnNamesArgument.preview.propertyPreviews){if(propertyPreview.type==="string"||propertyPreview.type==="number")
extractedColumnNames.push(String(propertyPreview.value));}
return extractedColumnNames.length?extractedColumnNames:null;}
_formatParameterAsTable(parameters)
{var element=document.createElement("span");var table=parameters[0];if(!table||!table.preview)
return element;var rows=[];var columnNames=[];var flatValues=[];var preview=table.preview;var userProvidedColumnNames=false;var extractedColumnNames=this._userProvidedColumnNames(parameters[1]);if(extractedColumnNames){userProvidedColumnNames=true;columnNames=extractedColumnNames;}
if(preview.propertyPreviews){for(var i=0;i<preview.propertyPreviews.length;++i){var rowProperty=preview.propertyPreviews[i];var rowPreview=rowProperty.valuePreview;if(!rowPreview||!rowPreview.propertyPreviews)
continue;var rowValue={};var maxColumnsToRender=15;for(var j=0;j<rowPreview.propertyPreviews.length;++j){var cellProperty=rowPreview.propertyPreviews[j];var columnRendered=columnNames.includes(cellProperty.name);if(!columnRendered){if(userProvidedColumnNames||columnNames.length===maxColumnsToRender)
continue;columnRendered=true;columnNames.push(cellProperty.name);}
rowValue[cellProperty.name]=WI.FormattedValue.createElementForPropertyPreview(cellProperty);}
rows.push([rowProperty.name,rowValue]);}}
if(rows.length){columnNames.unshift(WI.UIString("(Index)"));for(var i=0;i<rows.length;++i){var rowName=rows[i][0];var rowValue=rows[i][1];flatValues.push(rowName);for(var j=1;j<columnNames.length;++j){var columnName=columnNames[j];if(!(columnName in rowValue))
flatValues.push(emDash);else
flatValues.push(rowValue[columnName]);}}}
if(!flatValues.length&&preview.propertyPreviews){for(var i=0;i<preview.propertyPreviews.length;++i){var rowProperty=preview.propertyPreviews[i];if(!("value"in rowProperty))
continue;if(!columnNames.length){columnNames.push(WI.UIString("Index"));columnNames.push(WI.UIString("Value"));}
flatValues.push(rowProperty.name);flatValues.push(WI.FormattedValue.createElementForPropertyPreview(rowProperty));}}
if(!flatValues.length)
return element;var dataGrid=WI.DataGrid.createSortableDataGrid(columnNames,flatValues);dataGrid.inline=true;dataGrid.variableHeightRows=true;element.appendChild(dataGrid.element);dataGrid.updateLayoutIfNeeded();return element;}
_levelString()
{switch(this._message.level){case WI.ConsoleMessage.MessageLevel.Log:return"Log";case WI.ConsoleMessage.MessageLevel.Info:return"Info";case WI.ConsoleMessage.MessageLevel.Warning:return"Warning";case WI.ConsoleMessage.MessageLevel.Debug:return"Debug";case WI.ConsoleMessage.MessageLevel.Error:return"Error";}}
_enforcesClipboardPrefixString()
{return this._message.type!==WI.ConsoleMessage.MessageType.Result;}
_clipboardPrefixString()
{if(this._message.type===WI.ConsoleMessage.MessageType.Result)
return"< ";return"["+this._levelString()+"] ";}
_makeExpandable()
{if(this._expandable)
return;this._expandable=true;this._element.classList.add("expandable");this._boundClickHandler=this.toggle.bind(this);this._messageBodyElement.addEventListener("click",this._boundClickHandler);}
_handleContextMenu(event)
{let image=event.target.closest(".console-image > .console-message-body > img");if(!image)
return;let contextMenu=WI.ContextMenu.createFromEvent(event);if(WI.FileUtilities.canSave(WI.FileUtilities.SaveMode.SingleFile)){contextMenu.appendItem(WI.UIString("Save Image"),()=>{const forceSaveAs=true;WI.FileUtilities.save(WI.FileUtilities.SaveMode.SingleFile,{content:parseDataURL(this._message.messageText).data,base64Encoded:true,suggestedName:image.getAttribute("filename"),},forceSaveAs);});}
contextMenu.appendSeparator();}
_handleDebuggerBlackboxChanged(event)
{if(this._callFrameView)
this._appendLocationLink();}};WI.ContentBrowser=class ContentBrowser extends WI.View
{constructor(element,delegate,{hideBackForwardButtons,disableBackForwardNavigation,disableFindBanner,flexibleNavigationItem,contentViewNavigationItemGroup}={})
{super(element);this.element.classList.add("content-browser");this._navigationBar=new WI.NavigationBar;this.addSubview(this._navigationBar);this._contentViewContainer=new WI.ContentViewContainer({disableBackForwardNavigation});this._contentViewContainer.addEventListener(WI.ContentViewContainer.Event.CurrentContentViewDidChange,this._currentContentViewDidChange,this);this.addSubview(this._contentViewContainer);if(!hideBackForwardButtons){let isRTL=WI.resolvedLayoutDirection()===WI.LayoutDirection.RTL;let goBack=()=>{this.goBack();};let goForward=()=>{this.goForward();};let backShortcutKey=isRTL?WI.KeyboardShortcut.Key.Right:WI.KeyboardShortcut.Key.Left;let forwardShortcutKey=isRTL?WI.KeyboardShortcut.Key.Left:WI.KeyboardShortcut.Key.Right;this._backKeyboardShortcut=new WI.KeyboardShortcut(WI.KeyboardShortcut.Modifier.CommandOrControl|WI.KeyboardShortcut.Modifier.Control,backShortcutKey,goBack,this.element);this._forwardKeyboardShortcut=new WI.KeyboardShortcut(WI.KeyboardShortcut.Modifier.CommandOrControl|WI.KeyboardShortcut.Modifier.Control,forwardShortcutKey,goForward,this.element);let leftArrow="Images/BackForwardArrows.svg#left-arrow-mask";let rightArrow="Images/BackForwardArrows.svg#right-arrow-mask";let backButtonImage=isRTL?rightArrow:leftArrow;let forwardButtonImage=isRTL?leftArrow:rightArrow;this._backNavigationItem=new WI.ButtonNavigationItem("back",WI.UIString("Back (%s)").format(this._backKeyboardShortcut.displayName),backButtonImage,8,13);this._backNavigationItem.addEventListener(WI.ButtonNavigationItem.Event.Clicked,goBack,this);this._backNavigationItem.enabled=false;this._forwardNavigationItem=new WI.ButtonNavigationItem("forward",WI.UIString("Forward (%s)").format(this._forwardKeyboardShortcut.displayName),forwardButtonImage,8,13);this._forwardNavigationItem.addEventListener(WI.ButtonNavigationItem.Event.Clicked,goForward,this);this._forwardNavigationItem.enabled=false;let navigationButtonsGroup=new WI.GroupNavigationItem([this._backNavigationItem,this._forwardNavigationItem]);this._navigationBar.addNavigationItem(navigationButtonsGroup);}
if(!disableFindBanner){this._findBanner=new WI.FindBanner(this);this._findBanner.addEventListener(WI.FindBanner.Event.DidShow,this._findBannerDidShow,this);this._findBanner.addEventListener(WI.FindBanner.Event.DidHide,this._findBannerDidHide,this);}
this._hierarchicalPathNavigationItem=new WI.HierarchicalPathNavigationItem;this._hierarchicalPathNavigationItem.addEventListener(WI.HierarchicalPathNavigationItem.Event.PathComponentWasSelected,this._hierarchicalPathComponentWasSelected,this);this._navigationBar.addNavigationItem(this._hierarchicalPathNavigationItem);this._contentViewSelectionPathNavigationItem=new WI.HierarchicalPathNavigationItem;this._flexibleNavigationItem=flexibleNavigationItem||new WI.FlexibleSpaceNavigationItem;this._navigationBar.addNavigationItem(this._flexibleNavigationItem);this._currentContentViewNavigationItemsGroup=contentViewNavigationItemGroup||null;WI.ContentView.addEventListener(WI.ContentView.Event.SelectionPathComponentsDidChange,this._contentViewSelectionPathComponentDidChange,this);WI.ContentView.addEventListener(WI.ContentView.Event.SupplementalRepresentedObjectsDidChange,this._contentViewSupplementalRepresentedObjectsDidChange,this);WI.ContentView.addEventListener(WI.ContentView.Event.NumberOfSearchResultsDidChange,this._contentViewNumberOfSearchResultsDidChange,this);WI.ContentView.addEventListener(WI.ContentView.Event.NavigationItemsDidChange,this._contentViewNavigationItemsDidChange,this);this._delegate=delegate||null;this._currentContentViewNavigationItems=[];this._dispatchCurrentRepresentedObjectsDidChangeDebouncer=new Debouncer(()=>{this.dispatchEventToListeners(WI.ContentBrowser.Event.CurrentRepresentedObjectsDidChange);});}
get navigationBar()
{return this._navigationBar;}
get contentViewContainer()
{return this._contentViewContainer;}
get delegate()
{return this._delegate;}
set delegate(newDelegate)
{this._delegate=newDelegate||null;}
get currentContentView()
{return this._contentViewContainer.currentContentView;}
get currentRepresentedObjects()
{var representedObjects=[];var lastComponent=this._hierarchicalPathNavigationItem.lastComponent;if(lastComponent&&lastComponent.representedObject)
representedObjects.push(lastComponent.representedObject);lastComponent=this._contentViewSelectionPathNavigationItem.lastComponent;if(lastComponent&&lastComponent.representedObject)
representedObjects.push(lastComponent.representedObject);var currentContentView=this.currentContentView;if(currentContentView){var supplementalRepresentedObjects=currentContentView.supplementalRepresentedObjects;if(supplementalRepresentedObjects&&supplementalRepresentedObjects.length)
representedObjects.pushAll(supplementalRepresentedObjects);}
return representedObjects;}
showContentViewForRepresentedObject(representedObject,cookie,extraArguments)
{var contentView=this.contentViewForRepresentedObject(representedObject,false,extraArguments);return this._contentViewContainer.showContentView(contentView,cookie);}
showContentView(contentView,cookie)
{return this._contentViewContainer.showContentView(contentView,cookie);}
contentViewForRepresentedObject(representedObject,onlyExisting,extraArguments)
{return this._contentViewContainer.contentViewForRepresentedObject(representedObject,onlyExisting,extraArguments);}
updateHierarchicalPathForCurrentContentView()
{var currentContentView=this.currentContentView;this._updateHierarchicalPathNavigationItem(currentContentView?currentContentView.representedObject:null);}
canGoBack()
{var currentContentView=this.currentContentView;if(currentContentView&&currentContentView.canGoBack())
return true;return this._contentViewContainer.canGoBack();}
canGoForward()
{var currentContentView=this.currentContentView;if(currentContentView&&currentContentView.canGoForward())
return true;return this._contentViewContainer.canGoForward();}
goBack()
{var currentContentView=this.currentContentView;if(currentContentView&&currentContentView.canGoBack()){currentContentView.goBack();this._updateBackForwardButtons();return;}
this._contentViewContainer.goBack();}
goForward()
{var currentContentView=this.currentContentView;if(currentContentView&&currentContentView.canGoForward()){currentContentView.goForward();this._updateBackForwardButtons();return;}
this._contentViewContainer.goForward();}
showFindBanner()
{if(!this._findBanner)
return;var currentContentView=this.currentContentView;if(!currentContentView||!currentContentView.supportsSearch)
return;if(currentContentView.supportsCustomFindBanner){currentContentView.showCustomFindBanner();return;}
this._findBanner.show();}
attached()
{super.attached();this._updateContentViewSelectionPathNavigationItem(this.currentContentView);this.updateHierarchicalPathForCurrentContentView();}
handlePopulateFindShortcut()
{let currentContentView=this.currentContentView;if(!currentContentView?.supportsSearch)
return;if(!WI.updateFindString(currentContentView.searchQueryWithSelection()))
return;this._findBanner.searchQuery=WI.findString;currentContentView.performSearch(this._findBanner.searchQuery);}
async handleFindNextShortcut()
{if(!this._findBanner.showing&&this._findBanner.searchQuery!==WI.findString){let searchQuery=WI.findString;this._findBanner.searchQuery=searchQuery;let currentContentView=this.currentContentView;if(currentContentView?.supportsSearch){currentContentView.performSearch(this._findBanner.searchQuery);await currentContentView.awaitEvent(WI.ContentView.Event.NumberOfSearchResultsDidChange,this);if(this._findBanner.searchQuery!==searchQuery||this.currentContentView!==currentContentView)
return;}}
this.findBannerRevealNextResult(this._findBanner);}
async handleFindPreviousShortcut()
{if(!this._findBanner.showing&&this._findBanner.searchQuery!==WI.findString){let searchQuery=WI.findString;this._findBanner.searchQuery=searchQuery;let currentContentView=this.currentContentView;if(currentContentView?.supportsSearch){currentContentView.performSearch(this._findBanner.searchQuery);await currentContentView.awaitEvent(WI.ContentView.Event.NumberOfSearchResultsDidChange,this);if(this._findBanner.searchQuery!==searchQuery||this.currentContentView!==currentContentView)
return;}}
this.findBannerRevealPreviousResult(this._findBanner);}
findBannerPerformSearch(findBanner,query)
{let currentContentView=this.currentContentView;if(!currentContentView||!currentContentView.supportsSearch)
return;currentContentView.performSearch(query);}
findBannerSearchCleared(findBanner)
{let currentContentView=this.currentContentView;if(!currentContentView||!currentContentView.supportsSearch)
return;currentContentView.searchCleared();}
findBannerRevealPreviousResult(findBanner)
{let currentContentView=this.currentContentView;if(!currentContentView||!currentContentView.supportsSearch)
return;currentContentView.revealPreviousSearchResult(!findBanner.showing);}
findBannerRevealNextResult(findBanner)
{let currentContentView=this.currentContentView;if(!currentContentView||!currentContentView.supportsSearch)
return;currentContentView.revealNextSearchResult(!findBanner.showing);}
_findBannerDidShow(event)
{var currentContentView=this.currentContentView;if(!currentContentView||!currentContentView.supportsSearch)
return;currentContentView.automaticallyRevealFirstSearchResult=true;if(this._findBanner.searchQuery!=="")
currentContentView.performSearch(this._findBanner.searchQuery);}
_findBannerDidHide(event)
{var currentContentView=this.currentContentView;if(!currentContentView||!currentContentView.supportsSearch)
return;currentContentView.automaticallyRevealFirstSearchResult=false;currentContentView.searchHidden();}
_contentViewNumberOfSearchResultsDidChange(event)
{if(!this._findBanner)
return;if(event.target!==this.currentContentView)
return;this._findBanner.numberOfResults=this.currentContentView.numberOfSearchResults;}
_updateHierarchicalPathNavigationItem(representedObject)
{if(!this.delegate||typeof this.delegate.contentBrowserTreeElementForRepresentedObject!=="function")
return;var treeElement=representedObject?this.delegate.contentBrowserTreeElementForRepresentedObject(this,representedObject):null;var pathComponents=[];while(treeElement&&!treeElement.root){var pathComponent=new WI.GeneralTreeElementPathComponent(treeElement);pathComponents.unshift(pathComponent);treeElement=treeElement.parent;}
this._hierarchicalPathNavigationItem.components=pathComponents;}
_updateContentViewSelectionPathNavigationItem(contentView)
{var selectionPathComponents=contentView?contentView.selectionPathComponents||[]:[];this._contentViewSelectionPathNavigationItem.components=selectionPathComponents;if(this._currentContentViewNavigationItemsGroup)
return;if(!selectionPathComponents.length){this._hierarchicalPathNavigationItem.alwaysShowLastPathComponentSeparator=false;this._navigationBar.removeNavigationItem(this._contentViewSelectionPathNavigationItem);return;}
if(!this._navigationBar.navigationItems.includes(this._contentViewSelectionPathNavigationItem)){var hierarchicalPathItemIndex=this._navigationBar.navigationItems.indexOf(this._hierarchicalPathNavigationItem);this._navigationBar.insertNavigationItem(this._contentViewSelectionPathNavigationItem,hierarchicalPathItemIndex+1);this._hierarchicalPathNavigationItem.alwaysShowLastPathComponentSeparator=true;}}
_updateBackForwardButtons()
{if(!this._backNavigationItem||!this._forwardNavigationItem)
return;this._backNavigationItem.enabled=this.canGoBack();this._forwardNavigationItem.enabled=this.canGoForward();}
_updateContentViewNavigationItems(forceUpdate)
{let currentContentView=this.currentContentView;if(!currentContentView){this._removeAllNavigationItems();this._currentContentViewNavigationItems=[];if(this._currentContentViewNavigationItemsGroup)
this._currentContentViewNavigationItems.push(this._contentViewSelectionPathNavigationItem);return;}
if(currentContentView.parentContainer!==this._contentViewContainer)
return;if(!forceUpdate){let previousItems=this._currentContentViewNavigationItems.filter((item)=>!(item instanceof WI.DividerNavigationItem));let isUnchanged=Array.shallowEqual(previousItems,currentContentView.navigationItems);if(isUnchanged)
return;}
this._removeAllNavigationItems();let navigationBar=this.navigationBar;let insertionIndex=navigationBar.navigationItems.indexOf(this._flexibleNavigationItem)+1;let newNavigationItems=[];let shouldInsert=!this._currentContentViewNavigationItemsGroup;currentContentView.navigationItems.forEach(function(navigationItem,index){if(shouldInsert)
navigationBar.insertNavigationItem(navigationItem,insertionIndex++);newNavigationItems.push(navigationItem);});if(this._currentContentViewNavigationItemsGroup)
this._currentContentViewNavigationItemsGroup.navigationItems=[this._contentViewSelectionPathNavigationItem].concat(newNavigationItems);this._currentContentViewNavigationItems=newNavigationItems;}
_removeAllNavigationItems()
{if(this._currentContentViewNavigationItemsGroup)
this._currentContentViewNavigationItemsGroup.navigationItems=[];else{for(let navigationItem of this._currentContentViewNavigationItems){if(navigationItem.parentNavigationBar)
navigationItem.parentNavigationBar.removeNavigationItem(navigationItem);}}}
_updateFindBanner(currentContentView)
{if(!this._findBanner)
return;if(!currentContentView){this._findBanner.targetElement=null;this._findBanner.numberOfResults=null;return;}
this._findBanner.targetElement=currentContentView.element;this._findBanner.numberOfResults=currentContentView.hasPerformedSearch?currentContentView.numberOfSearchResults:null;if(currentContentView.supportsSearch&&this._findBanner.searchQuery){currentContentView.automaticallyRevealFirstSearchResult=this._findBanner.showing;currentContentView.performSearch(this._findBanner.searchQuery);}}
_contentViewSelectionPathComponentDidChange(event)
{if(event.target!==this.currentContentView)
return;if(event.target.parentContainer!==this._contentViewContainer)
return;this._updateContentViewSelectionPathNavigationItem(event.target);this._updateBackForwardButtons();this._updateContentViewNavigationItems();this._navigationBar.needsLayout();this._dispatchCurrentRepresentedObjectsDidChangeDebouncer.delayForTime(0);}
_contentViewSupplementalRepresentedObjectsDidChange(event)
{if(event.target!==this.currentContentView)
return;if(event.target.parentContainer!==this._contentViewContainer)
return;this._dispatchCurrentRepresentedObjectsDidChangeDebouncer.delayForTime(0);}
_currentContentViewDidChange(event)
{var currentContentView=this.currentContentView;this._updateHierarchicalPathNavigationItem(currentContentView?currentContentView.representedObject:null);this._updateContentViewSelectionPathNavigationItem(currentContentView);this._updateBackForwardButtons();this._updateContentViewNavigationItems();this._updateFindBanner(currentContentView);this._navigationBar.needsLayout();this.dispatchEventToListeners(WI.ContentBrowser.Event.CurrentContentViewDidChange);this._dispatchCurrentRepresentedObjectsDidChangeDebouncer.force();}
_contentViewNavigationItemsDidChange(event)
{if(event.target!==this.currentContentView)
return;if(event.target.parentContainer!==this._contentViewContainer)
return;const forceUpdate=true;this._updateContentViewNavigationItems(forceUpdate);this._navigationBar.needsLayout();}
_hierarchicalPathComponentWasSelected(event)
{var treeElement=event.data.pathComponent.generalTreeElement;var originalTreeElement=treeElement;while(treeElement&&!WI.ContentView.isViewable(treeElement.representedObject))
treeElement=treeElement.traverseNextTreeElement(false,originalTreeElement,false);if(!treeElement)
return;treeElement.revealAndSelect();}};WI.ContentBrowser.Event={CurrentRepresentedObjectsDidChange:"content-browser-current-represented-objects-did-change",CurrentContentViewDidChange:"content-browser-current-content-view-did-change"};WI.ContentView=class ContentView extends WI.View
{constructor(representedObject,extraArguments)
{super();this._representedObject=representedObject;this.element.classList.add("content-view");this._parentContainer=null;this._isClosed=false;this._visible=false;}
static shouldNotRemoveFromDOMWhenHidden()
{return false;}
static createFromRepresentedObject(representedObject,extraArguments)
{if(representedObject instanceof WI.Frame)
return new WI.ResourceClusterContentView(representedObject.mainResource,extraArguments);if(representedObject instanceof WI.Resource)
return new WI.ResourceClusterContentView(representedObject,extraArguments);if(representedObject instanceof WI.Script)
return new WI.ScriptContentView(representedObject,extraArguments);if(representedObject instanceof WI.CSSStyleSheet)
return new WI.TextResourceContentView(representedObject,extraArguments);if(representedObject instanceof WI.Canvas)
return new WI.CanvasContentView(representedObject,extraArguments);if(representedObject instanceof WI.ShaderProgram)
return new WI.ShaderProgramContentView(representedObject,extraArguments);if(representedObject instanceof WI.TimelineRecording)
return new WI.TimelineRecordingContentView(representedObject,extraArguments);if(representedObject instanceof WI.Timeline){var timelineType=representedObject.type;if(timelineType===WI.TimelineRecord.Type.Network)
return new WI.NetworkTimelineView(representedObject,extraArguments);if(timelineType===WI.TimelineRecord.Type.Layout)
return new WI.LayoutTimelineView(representedObject,extraArguments);if(timelineType===WI.TimelineRecord.Type.Script)
return new WI.ScriptClusterTimelineView(representedObject,extraArguments);if(timelineType===WI.TimelineRecord.Type.RenderingFrame)
return new WI.RenderingFrameTimelineView(representedObject,extraArguments);if(timelineType===WI.TimelineRecord.Type.CPU)
return new WI.CPUTimelineView(representedObject,extraArguments);if(timelineType===WI.TimelineRecord.Type.Memory)
return new WI.MemoryTimelineView(representedObject,extraArguments);if(timelineType===WI.TimelineRecord.Type.HeapAllocations)
return new WI.HeapAllocationsTimelineView(representedObject,extraArguments);if(timelineType===WI.TimelineRecord.Type.Media)
return new WI.MediaTimelineView(representedObject,extraArguments);if(timelineType===WI.TimelineRecord.Type.Screenshots)
return new WI.ScreenshotsTimelineView(representedObject,extraArguments);}
if(representedObject instanceof WI.JavaScriptBreakpoint||representedObject instanceof WI.IssueMessage){if(representedObject.sourceCodeLocation)
return WI.ContentView.createFromRepresentedObject(representedObject.sourceCodeLocation.displaySourceCode,extraArguments);}
if(representedObject instanceof WI.LocalResourceOverride){if(representedObject.type===WI.LocalResourceOverride.InterceptType.Block||representedObject.type===WI.LocalResourceOverride.InterceptType.Request)
return new WI.LocalResourceOverrideRequestContentView(representedObject);return WI.ContentView.createFromRepresentedObject(representedObject.localResource);}
if(representedObject instanceof WI.DOMStorageObject)
return new WI.DOMStorageContentView(representedObject,extraArguments);if(representedObject instanceof WI.CookieStorageObject)
return new WI.CookieStorageContentView(representedObject,extraArguments);if(representedObject instanceof WI.DatabaseTableObject)
return new WI.DatabaseTableContentView(representedObject,extraArguments);if(representedObject instanceof WI.DatabaseObject)
return new WI.DatabaseContentView(representedObject,extraArguments);if(representedObject instanceof WI.IndexedDatabase)
return new WI.IndexedDatabaseContentView(representedObject,extraArguments);if(representedObject instanceof WI.IndexedDatabaseObjectStore)
return new WI.IndexedDatabaseObjectStoreContentView(representedObject,extraArguments);if(representedObject instanceof WI.IndexedDatabaseObjectStoreIndex)
return new WI.IndexedDatabaseObjectStoreContentView(representedObject,extraArguments);if(representedObject instanceof WI.ApplicationCacheFrame)
return new WI.ApplicationCacheFrameContentView(representedObject,extraArguments);if(representedObject instanceof WI.DOMTree)
return new WI.FrameDOMTreeContentView(representedObject,extraArguments);if(representedObject instanceof WI.DOMSearchMatchObject){var resultView=new WI.FrameDOMTreeContentView(WI.networkManager.mainFrame.domTree,extraArguments);resultView.restoreFromCookie({nodeToSelect:representedObject.domNode});return resultView;}
if(representedObject instanceof WI.DOMNode){if(representedObject.frame){let resultView=WI.ContentView.createFromRepresentedObject(representedObject.frame,extraArguments);resultView.restoreFromCookie({nodeToSelect:representedObject});return resultView;}}
if(representedObject instanceof WI.SourceCodeSearchMatchObject){var resultView;if(representedObject.sourceCode instanceof WI.Resource)
resultView=new WI.ResourceClusterContentView(representedObject.sourceCode,extraArguments);else if(representedObject.sourceCode instanceof WI.Script)
resultView=new WI.ScriptContentView(representedObject.sourceCode,extraArguments);else
console.error("Unknown SourceCode",representedObject.sourceCode);var textRangeToSelect=representedObject.sourceCodeTextRange.formattedTextRange;var startPosition=textRangeToSelect.startPosition();resultView.restoreFromCookie({lineNumber:startPosition.lineNumber,columnNumber:startPosition.columnNumber});return resultView;}
if(representedObject instanceof WI.LogObject)
return new WI.LogContentView(representedObject,extraArguments);if(representedObject instanceof WI.CallingContextTree)
return new WI.ProfileView(representedObject,extraArguments);if(representedObject instanceof WI.HeapSnapshotProxy||representedObject instanceof WI.HeapSnapshotDiffProxy)
return new WI.HeapSnapshotClusterContentView(representedObject,extraArguments);if(representedObject instanceof WI.Recording)
return new WI.RecordingContentView(representedObject,extraArguments);if(representedObject instanceof WI.ResourceCollection)
return new WI.ResourceCollectionContentView(representedObject,extraArguments);if(representedObject instanceof WI.AuditTestCase||representedObject instanceof WI.AuditTestCaseResult)
return new WI.AuditTestCaseContentView(representedObject,extraArguments);if(representedObject instanceof WI.AuditTestGroup||representedObject instanceof WI.AuditTestGroupResult)
return new WI.AuditTestGroupContentView(representedObject,extraArguments);if(representedObject instanceof WI.Animation)
return new WI.AnimationContentView(representedObject,extraArguments);if(representedObject instanceof WI.Collection)
return new WI.CollectionContentView(representedObject,extraArguments);if(typeof representedObject==="string"||representedObject instanceof String)
return new WI.TextContentView(representedObject,extraArguments);throw new Error("Can't make a ContentView for an unknown representedObject of type: "+representedObject.constructor.name);}
static contentViewForRepresentedObject(representedObject,onlyExisting,extraArguments)
{let resolvedRepresentedObject=WI.ContentView.resolvedRepresentedObjectForRepresentedObject(representedObject);if(!resolvedRepresentedObject)
return null;let existingContentView=resolvedRepresentedObject[WI.ContentView.ContentViewForRepresentedObjectSymbol];if(existingContentView)
return existingContentView;if(onlyExisting)
return null;let newContentView=WI.ContentView.createFromRepresentedObject(representedObject,extraArguments);if(!newContentView)
return null;if(typeof resolvedRepresentedObject==="object")
newContentView.representedObject[WI.ContentView.ContentViewForRepresentedObjectSymbol]=newContentView;return newContentView;}
static closedContentViewForRepresentedObject(representedObject)
{let resolvedRepresentedObject=WI.ContentView.resolvedRepresentedObjectForRepresentedObject(representedObject);if(typeof resolvedRepresentedObject==="object")
resolvedRepresentedObject[WI.ContentView.ContentViewForRepresentedObjectSymbol]=null;}
static resolvedRepresentedObjectForRepresentedObject(representedObject)
{if(representedObject instanceof WI.Frame)
return representedObject.mainResource;if(representedObject instanceof WI.JavaScriptBreakpoint||representedObject instanceof WI.IssueMessage){if(representedObject.sourceCodeLocation)
return representedObject.sourceCodeLocation.displaySourceCode;return representedObject;}
if(representedObject instanceof WI.DOMBreakpoint){if(representedObject.domNode)
return WI.ContentView.resolvedRepresentedObjectForRepresentedObject(representedObject.domNode);return representedObject;}
if(representedObject instanceof WI.DOMNode){if(representedObject.frame)
return WI.ContentView.resolvedRepresentedObjectForRepresentedObject(representedObject.frame);return representedObject;}
if(representedObject instanceof WI.DOMSearchMatchObject)
return WI.networkManager.mainFrame.domTree;if(representedObject instanceof WI.SourceCodeSearchMatchObject)
return representedObject.sourceCode;if(representedObject instanceof WI.LocalResourceOverride){if(representedObject.type===WI.LocalResourceOverride.InterceptType.Response||representedObject.type===WI.LocalResourceOverride.InterceptType.ResponseSkippingNetwork)
return representedObject.localResource;return representedObject;}
return representedObject;}
static isViewable(representedObject)
{if(representedObject instanceof WI.Frame)
return true;if(representedObject instanceof WI.Resource)
return true;if(representedObject instanceof WI.Script)
return true;if(representedObject instanceof WI.CSSStyleSheet)
return true;if(representedObject instanceof WI.Canvas)
return true;if(representedObject instanceof WI.ShaderProgram)
return true;if(representedObject instanceof WI.TimelineRecording)
return true;if(representedObject instanceof WI.Timeline)
return true;if(representedObject instanceof WI.JavaScriptBreakpoint||representedObject instanceof WI.IssueMessage)
return representedObject.sourceCodeLocation;if(representedObject instanceof WI.LocalResourceOverride)
return true;if(representedObject instanceof WI.DOMStorageObject)
return true;if(representedObject instanceof WI.CookieStorageObject)
return true;if(representedObject instanceof WI.DatabaseTableObject)
return true;if(representedObject instanceof WI.DatabaseObject)
return true;if(representedObject instanceof WI.IndexedDatabase)
return true;if(representedObject instanceof WI.IndexedDatabaseObjectStore)
return true;if(representedObject instanceof WI.IndexedDatabaseObjectStoreIndex)
return true;if(representedObject instanceof WI.ApplicationCacheFrame)
return true;if(representedObject instanceof WI.DOMTree)
return true;if(representedObject instanceof WI.DOMSearchMatchObject)
return true;if(representedObject instanceof WI.SourceCodeSearchMatchObject)
return true;if(representedObject instanceof WI.LogObject)
return true;if(representedObject instanceof WI.CallingContextTree)
return true;if(representedObject instanceof WI.HeapSnapshotProxy||representedObject instanceof WI.HeapSnapshotDiffProxy)
return true;if(representedObject instanceof WI.Recording)
return true;if(representedObject instanceof WI.AuditTestCase||representedObject instanceof WI.AuditTestGroup||representedObject instanceof WI.AuditTestCaseResult||representedObject instanceof WI.AuditTestGroupResult)
return true;if(representedObject instanceof WI.Animation)
return true;if(representedObject instanceof WI.Collection)
return true;if(typeof representedObject==="string"||representedObject instanceof String)
return true;if(representedObject[WI.ContentView.isViewableSymbol])
return true;return false;}
get isClosed(){return this._isClosed;}
get visible()
{return!this.isClosed&&this._visible;}
set visible(value)
{this._visible=!!value;this.element.classList.toggle("not-visible",!this._visible);}
get representedObject()
{return this._representedObject;}
get navigationItems()
{return[];}
get parentContainer()
{return this._parentContainer;}
get scrollableElements()
{return[];}
get shouldKeepElementsScrolledToBottom()
{return false;}
get shouldSaveStateWhenHidden()
{return false;}
get selectionPathComponents()
{return[];}
get supplementalRepresentedObjects()
{return[];}
get supportsSplitContentBrowser()
{return WI.dockedConfigurationSupportsSplitContentBrowser();}
closed()
{this._isClosed=true;}
saveToCookie(cookie)
{}
restoreFromCookie(cookie)
{}
canGoBack()
{return false;}
canGoForward()
{return false;}
goBack()
{}
goForward()
{}
get supportsSearch()
{return false;}
get supportsCustomFindBanner()
{return false;}
showCustomFindBanner()
{}
get numberOfSearchResults()
{return null;}
get hasPerformedSearch()
{return false;}
set automaticallyRevealFirstSearchResult(reveal)
{}
performSearch(query)
{}
searchHidden()
{}
searchCleared()
{}
searchQueryWithSelection()
{let selection=window.getSelection();if(selection.isCollapsed)
return null;return selection.toString().removeWordBreakCharacters();}
revealPreviousSearchResult(changeFocus)
{}
revealNextSearchResult(changeFocus)
{}};WI.ContentView.Event={SelectionPathComponentsDidChange:"content-view-selection-path-components-did-change",SupplementalRepresentedObjectsDidChange:"content-view-supplemental-represented-objects-did-change",NumberOfSearchResultsDidChange:"content-view-number-of-search-results-did-change",NavigationItemsDidChange:"content-view-navigation-items-did-change"};WI.ContentView.isViewableSymbol=Symbol("is-viewable");WI.ContentView.ContentViewForRepresentedObjectSymbol=Symbol("content-view-for-represented-object");WI.DataGrid=class DataGrid extends WI.View
{constructor(columnsData,{editCallback,copyCallback,deleteCallback,preferredColumnOrder}={})
{super();this.columns=new Map;this.orderedColumns=[];this._settingsIdentifier=null;this._sortColumnIdentifier=null;this._sortColumnIdentifierSetting=null;this._sortOrder=WI.DataGrid.SortOrder.Indeterminate;this._sortOrderSetting=null;this._columnVisibilitySetting=null;this._columnChooserEnabled=false;this._headerVisible=true;this._rows=[];this.children=[];this.expandNodesWhenArrowing=false;this.root=true;this.hasChildren=false;this.expanded=true;this.revealed=true;this.selected=false;this.dataGrid=this;this.indentWidth=15;this.rowHeight=20;this.resizers=[];this._columnWidthsInitialized=false;this._scrollbarWidth=0;this._cachedScrollTop=NaN;this._cachedScrollableOffsetHeight=NaN;this._previousRevealedRowCount=NaN;this._topDataTableMarginHeight=NaN;this._bottomDataTableMarginHeight=NaN;this._filterText="";this._filterDelegate=null;this._filterDidModifyNodeWhileProcessingItems=false;let itemForRepresentedObject=this.dataGridNodeForSelectionItem.bind(this);let selectionComparator=WI.SelectionController.createTreeComparator(itemForRepresentedObject);this._selectionController=new WI.SelectionController(this,selectionComparator);this._processingSelectionChange=false;this._suppressNextSelectionDidChangeEvent=false;this.element.className="data-grid";this.element.tabIndex=0;this.element.addEventListener("keydown",this._keyDown.bind(this),false);this.element.copyHandler=this;this._headerWrapperElement=document.createElement("div");this._headerWrapperElement.classList.add("header-wrapper");this._headerTableElement=document.createElement("table");this._headerTableElement.className="header";this._headerWrapperElement.appendChild(this._headerTableElement);this._headerTableColumnGroupElement=this._headerTableElement.createChild("colgroup");this._headerTableBodyElement=this._headerTableElement.createChild("tbody");this._headerTableRowElement=this._headerTableBodyElement.createChild("tr");this._headerTableRowElement.addEventListener("contextmenu",this._contextMenuInHeader.bind(this),true);this._headerTableCellElements=new Map;this._scrollContainerElement=document.createElement("div");this._scrollContainerElement.className="data-container";this._scrollListener=()=>this._noteScrollPositionChanged();this._updateScrollListeners();this._topDataTableMarginElement=this._scrollContainerElement.createChild("div");this._dataTableElement=this._scrollContainerElement.createChild("table","data");this._bottomDataTableMarginElement=this._scrollContainerElement.createChild("div");this._dataTableElement.addEventListener("mousedown",this._mouseDownInDataTable.bind(this));this._dataTableElement.addEventListener("click",this._clickInDataTable.bind(this));this._dataTableElement.addEventListener("contextmenu",this._contextMenuInDataTable.bind(this),true);if(editCallback){this._dataTableElement.addEventListener("dblclick",this._ondblclick.bind(this),false);this._editCallback=editCallback;}
if(copyCallback)
this._copyCallback=copyCallback;if(deleteCallback)
this._deleteCallback=deleteCallback;this._dataTableColumnGroupElement=this._headerTableColumnGroupElement.cloneNode(true);this._dataTableElement.appendChild(this._dataTableColumnGroupElement);this.dataTableBodyElement=this._dataTableElement.createChild("tbody");this._fillerRowElement=this.dataTableBodyElement.createChild("tr","filler");this.element.appendChild(this._headerWrapperElement);this.element.appendChild(this._scrollContainerElement);if(preferredColumnOrder){for(var columnIdentifier of preferredColumnOrder)
this.insertColumn(columnIdentifier,columnsData[columnIdentifier]);}else{for(var columnIdentifier in columnsData)
this.insertColumn(columnIdentifier,columnsData[columnIdentifier]);}
this._updateScrollbarPadding();this._copyTextDelimiter="\t";}
_updateScrollbarPadding()
{if(this._inline)
return;let scrollbarWidth=this._scrollContainerElement.offsetWidth-this._scrollContainerElement.scrollWidth;if(this._scrollbarWidth===scrollbarWidth)
return;if(WI.resolvedLayoutDirection()===WI.LayoutDirection.RTL)
this._headerWrapperElement.style.setProperty("padding-left",`${scrollbarWidth}px`);else
this._headerWrapperElement.style.setProperty("padding-right",`${scrollbarWidth}px`);this._scrollbarWidth=scrollbarWidth;}
static createSortableDataGrid(columnNames,values)
{var numColumns=columnNames.length;if(!numColumns)
return null;var columnsData={};for(var columnName of columnNames){columnsData[columnName]={width:columnName.length,title:columnName,sortable:true,};}
let dataGrid=new WI.DataGrid(columnsData,{preferredColumnOrder:columnNames});for(var i=0;i<values.length/numColumns;++i){var data={};for(var j=0;j<columnNames.length;++j)
data[columnNames[j]]=values[numColumns*i+j];var node=new WI.DataGridNode(data);dataGrid.appendChild(node);}
function sortDataGrid()
{var sortColumnIdentifier=dataGrid.sortColumnIdentifier;var columnIsNumeric=true;for(var node of dataGrid.children){var value=dataGrid.textForDataGridNodeColumn(node,sortColumnIdentifier);if(isNaN(Number(value)))
columnIsNumeric=false;}
function comparator(dataGridNode1,dataGridNode2)
{var item1=dataGrid.textForDataGridNodeColumn(dataGridNode1,sortColumnIdentifier);var item2=dataGrid.textForDataGridNodeColumn(dataGridNode2,sortColumnIdentifier);var comparison;if(columnIsNumeric){var number1=parseFloat(item1);var number2=parseFloat(item2);comparison=number1<number2?-1:(number1>number2?1:0);}else
comparison=item1<item2?-1:(item1>item2?1:0);return comparison;}
dataGrid.sortNodes(comparator);}
dataGrid.addEventListener(WI.DataGrid.Event.SortChanged,sortDataGrid,this);dataGrid.sortOrder=WI.DataGrid.SortOrder.Ascending;dataGrid.sortColumnIdentifier=columnNames[0];return dataGrid;}
get headerVisible(){return this._headerVisible;}
set headerVisible(x)
{if(x===this._headerVisible)
return;this._headerVisible=x;this.element.classList.toggle("no-header",!this._headerVisible);}
get columnChooserEnabled(){return this._columnChooserEnabled;}
set columnChooserEnabled(x){this._columnChooserEnabled=x;}
get copyTextDelimiter(){return this._copyTextDelimiter;}
set copyTextDelimiter(x){this._copyTextDelimiter=x;}
get refreshCallback()
{return this._refreshCallback;}
set refreshCallback(refreshCallback)
{this._refreshCallback=refreshCallback;}
get sortOrder()
{return this._sortOrder;}
set sortOrder(order)
{if(!order||order===this._sortOrder)
return;this._sortOrder=order;if(this._sortOrderSetting)
this._sortOrderSetting.value=this._sortOrder;if(!this._sortColumnIdentifier)
return;var sortHeaderCellElement=this._headerTableCellElements.get(this._sortColumnIdentifier);sortHeaderCellElement.classList.toggle(WI.DataGrid.SortColumnAscendingStyleClassName,this._sortOrder===WI.DataGrid.SortOrder.Ascending);sortHeaderCellElement.classList.toggle(WI.DataGrid.SortColumnDescendingStyleClassName,this._sortOrder===WI.DataGrid.SortOrder.Descending);this.dispatchEventToListeners(WI.DataGrid.Event.SortChanged);}
get sortColumnIdentifier()
{return this._sortColumnIdentifier;}
set sortColumnIdentifier(columnIdentifier)
{if(this._sortColumnIdentifier===columnIdentifier)
return;let oldSortColumnIdentifier=this._sortColumnIdentifier;this._sortColumnIdentifier=columnIdentifier;this._updateSortedColumn(oldSortColumnIdentifier);}
get inline(){return this._inline;}
set inline(x)
{if(this._inline===x)
return;this._inline=x||false;this._element.classList.toggle("inline",this._inline);this._updateScrollListeners();}
get variableHeightRows(){return this._variableHeightRows;}
set variableHeightRows(x)
{if(this._variableHeightRows===x)
return;this._variableHeightRows=x||false;this._element.classList.toggle("variable-height-rows",this._variableHeightRows);this._updateScrollListeners();}
get allowsMultipleSelection()
{return this._selectionController.allowsMultipleSelection;}
set allowsMultipleSelection(flag)
{this._selectionController.allowsMultipleSelection=flag;}
get selectedNode()
{return this.dataGridNodeForSelectionItem(this._selectionController.lastSelectedItem);}
set selectedNode(dataGridNode)
{if(dataGridNode)
this._selectionController.selectItem(this.selectionItemForDataGridNode(dataGridNode));else
this._selectionController.deselectAll();}
get selectedDataGridNodes()
{if(this.allowsMultipleSelection){let selectedDataGridNodes=[];for(let item of this._selectionController.selectedItems)
selectedDataGridNodes.push(this.dataGridNodeForSelectionItem(item));return selectedDataGridNodes;}
let selectedNode=this.selectedNode;if(selectedNode)
return[selectedNode];return[];}
get filterText(){return this._filterText;}
set filterText(x)
{if(this._filterText===x)
return;this._filterText=x;this.filterDidChange();}
get filterDelegate(){return this._filterDelegate;}
set filterDelegate(delegate)
{this._filterDelegate=delegate;this.filterDidChange();}
filterDidChange()
{if(this._scheduledFilterUpdateIdentifier)
return;if(this._applyFilterToNodesTask){this._applyFilterToNodesTask.cancel();this._applyFilterToNodesTask=null;}
this._scheduledFilterUpdateIdentifier=requestAnimationFrame(this._updateFilter.bind(this));}
hasFilters()
{return this._textFilterRegex||this._hasFilterDelegate();}
matchNodeAgainstCustomFilters(node)
{if(!this._hasFilterDelegate())
return true;return this._filterDelegate.dataGridMatchNodeAgainstCustomFilters(node);}
createSettings(identifier)
{if(this._settingsIdentifier===identifier)
return;this._settingsIdentifier=identifier;this._sortColumnIdentifierSetting=new WI.Setting(this._settingsIdentifier+"-sort",this._sortColumnIdentifier);this._sortOrderSetting=new WI.Setting(this._settingsIdentifier+"-sort-order",this._sortOrder);this._columnVisibilitySetting=new WI.Setting(this._settingsIdentifier+"-column-visibility",{});if(!this.columns)
return;if(this._sortColumnIdentifierSetting.value){this.sortColumnIdentifier=this._sortColumnIdentifierSetting.value;this.sortOrder=this._sortOrderSetting.value;}
let visibilitySettings=this._columnVisibilitySetting.value;for(let columnIdentifier in visibilitySettings){let visible=visibilitySettings[columnIdentifier];this.setColumnVisible(columnIdentifier,visible);}}
startEditingNode(node)
{if(this._editing||this._editingNode)
return;this._startEditingNodeAtColumnIndex(node,0);}
_updateScrollListeners()
{if(this._inline||this._variableHeightRows){this._scrollContainerElement.removeEventListener("scroll",this._scrollListener);this._scrollContainerElement.removeEventListener("mousewheel",this._scrollListener);}else{this._scrollContainerElement.addEventListener("scroll",this._scrollListener);this._scrollContainerElement.addEventListener("mousewheel",this._scrollListener);}}
_applyFiltersToNodeAndDispatchEvent(node)
{const nodeWasHidden=node.hidden;this._applyFiltersToNode(node);if(nodeWasHidden!==node.hidden)
this.dispatchEventToListeners(WI.DataGrid.Event.NodeWasFiltered,{node});return nodeWasHidden!==node.hidden;}
_applyFiltersToNode(node)
{if(!this.hasFilters()){node.hidden=false;if(node.expanded&&node[WI.DataGrid.WasExpandedDuringFilteringSymbol]){node[WI.DataGrid.WasExpandedDuringFilteringSymbol]=false;node.collapse();}
return;}
let filterableData=node.filterableData||[];let flags={expandNode:false};let filterRegex=this._textFilterRegex;function matchTextFilter()
{if(!filterableData.length||!filterRegex)
return true;if(filterableData.some((value)=>filterRegex.test(value))){flags.expandNode=true;return true;}
return false;}
function makeVisible()
{node.hidden=false;let currentAncestor=node.parent;while(currentAncestor&&!currentAncestor.root){currentAncestor.hidden=false;if(flags.expandNode&&!currentAncestor.expanded){currentAncestor[WI.DataGrid.WasExpandedDuringFilteringSymbol]=true;currentAncestor.expand();}
currentAncestor=currentAncestor.parent;}}
if(matchTextFilter()&&this.matchNodeAgainstCustomFilters(node)){makeVisible();if(!flags.expandNode&&node.expanded&&node[WI.DataGrid.WasExpandedDuringFilteringSymbol]){node[WI.DataGrid.WasExpandedDuringFilteringSymbol]=false;node.collapse();}
return;}
node.hidden=true;}
_updateSortedColumn(oldSortColumnIdentifier)
{if(this._sortColumnIdentifierSetting)
this._sortColumnIdentifierSetting.value=this._sortColumnIdentifier;if(oldSortColumnIdentifier){let oldSortHeaderCellElement=this._headerTableCellElements.get(oldSortColumnIdentifier);oldSortHeaderCellElement.classList.remove(WI.DataGrid.SortColumnAscendingStyleClassName);oldSortHeaderCellElement.classList.remove(WI.DataGrid.SortColumnDescendingStyleClassName);}
if(this._sortColumnIdentifier){let newSortHeaderCellElement=this._headerTableCellElements.get(this._sortColumnIdentifier);newSortHeaderCellElement.classList.toggle(WI.DataGrid.SortColumnAscendingStyleClassName,this._sortOrder===WI.DataGrid.SortOrder.Ascending);newSortHeaderCellElement.classList.toggle(WI.DataGrid.SortColumnDescendingStyleClassName,this._sortOrder===WI.DataGrid.SortOrder.Descending);}
this.dispatchEventToListeners(WI.DataGrid.Event.SortChanged);}
_hasFilterDelegate()
{return this._filterDelegate&&typeof this._filterDelegate.dataGridMatchNodeAgainstCustomFilters==="function";}
_ondblclick(event)
{if(this._editing||this._editingNode)
return;this._startEditing(event.target);}
_startEditingNodeAtColumnIndex(node,columnIndex)
{this.updateLayoutIfNeeded();this._editing=true;this._editingNode=node;this._editingNode.select();var element=this._editingNode.element.children[columnIndex];WI.startEditing(element,this._startEditingConfig(element));window.getSelection().setBaseAndExtent(element,0,element,1);}
_startEditing(target)
{let element=target.closest("td");if(!element)
return;let node=this.dataGridNodeFromNode(target);if(!node.editable)
return;this._editingNode=node;if(!this._editingNode){if(!this.placeholderNode)
return;this._editingNode=this.placeholderNode;}
if(this._editingNode.isPlaceholderNode)
return this._startEditingNodeAtColumnIndex(this._editingNode,0);this._editing=true;WI.startEditing(element,this._startEditingConfig(element));window.getSelection().setBaseAndExtent(element,0,element,1);}
_startEditingConfig(element)
{return new WI.EditingConfig(this._editingCommitted.bind(this),this._editingCancelled.bind(this),element.textContent);}
_editingCommitted(element,newText,oldText,context,moveDirection)
{var columnIdentifier=element.__columnIdentifier;var columnIndex=this.orderedColumns.indexOf(columnIdentifier);var textBeforeEditing=this._editingNode.data[columnIdentifier]||"";var currentEditingNode=this._editingNode;currentEditingNode.data[columnIdentifier]=newText.trim();function determineNextCell(valueDidChange){if(moveDirection==="forward"){if(columnIndex<this.orderedColumns.length-1)
return{shouldSort:false,editingNode:currentEditingNode,columnIndex:columnIndex+1};var nextDataGridNode=currentEditingNode.traverseNextNode(true,null,true);return{shouldSort:true,editingNode:nextDataGridNode||currentEditingNode,columnIndex:0};}
if(moveDirection==="backward"){if(columnIndex>0)
return{shouldSort:false,editingNode:currentEditingNode,columnIndex:columnIndex-1};var previousDataGridNode=currentEditingNode.traversePreviousNode(true,null,true);return{shouldSort:true,editingNode:previousDataGridNode||currentEditingNode,columnIndex:this.orderedColumns.length-1};}
return{shouldSort:true};}
function moveToNextCell(valueDidChange){var moveCommand=determineNextCell.call(this,valueDidChange);if(moveCommand.shouldSort&&this._sortAfterEditingCallback){this._sortAfterEditingCallback();this._sortAfterEditingCallback=null;}
if(moveCommand.editingNode)
this._startEditingNodeAtColumnIndex(moveCommand.editingNode,moveCommand.columnIndex);}
this._editingCancelled(element);this._editCallback(currentEditingNode,columnIdentifier,textBeforeEditing,newText,moveDirection);var textDidChange=textBeforeEditing.trim()!==newText.trim();moveToNextCell.call(this,textDidChange);}
_editingCancelled(element)
{this._editingNode.refresh();this._editing=false;this._editingNode=null;}
autoSizeColumns(minPercent,maxPercent,maxDescentLevel)
{if(minPercent)
minPercent=Math.min(minPercent,Math.floor(100/this.orderedColumns.length));var widths={};for(var[identifier,column]of this.columns)
widths[identifier]=(column["title"]||"").length;var children=maxDescentLevel?this._enumerateChildren(this,[],maxDescentLevel+1):this.children;for(var node of children){for(var identifier of this.columns.keys()){var text=this.textForDataGridNodeColumn(node,identifier);if(text.length>widths[identifier])
widths[identifier]=text.length;}}
var totalColumnWidths=0;for(var identifier of this.columns.keys())
totalColumnWidths+=widths[identifier];var recoupPercent=0;for(var identifier of this.columns.keys()){var width=Math.round(100*widths[identifier]/totalColumnWidths);if(minPercent&&width<minPercent){recoupPercent+=minPercent-width;width=minPercent;}else if(maxPercent&&width>maxPercent){recoupPercent-=width-maxPercent;width=maxPercent;}
widths[identifier]=width;}
while(minPercent&&recoupPercent>0){for(var identifier of this.columns.keys()){if(widths[identifier]>minPercent){--widths[identifier];--recoupPercent;if(!recoupPercent)
break;}}}
while(maxPercent&&recoupPercent<0){for(var identifier of this.columns.keys()){if(widths[identifier]<maxPercent){++widths[identifier];++recoupPercent;if(!recoupPercent)
break;}}}
for(var[identifier,column]of this.columns){column["element"].style.width=widths[identifier]+"%";column["bodyElement"].style.width=widths[identifier]+"%";}
this._columnWidthsInitialized=false;this.needsLayout();}
insertColumn(columnIdentifier,columnData,insertionIndex)
{if(insertionIndex===undefined)
insertionIndex=this.orderedColumns.length;insertionIndex=Number.constrain(insertionIndex,0,this.orderedColumns.length);var column=Object.shallowCopy(columnData);column["ordinal"]=insertionIndex;column["columnIdentifier"]=columnIdentifier;this.orderedColumns.splice(insertionIndex,0,columnIdentifier);for(var[identifier,existingColumn]of this.columns){var ordinal=existingColumn["ordinal"];if(ordinal>=insertionIndex)
existingColumn["ordinal"]=ordinal+1;}
this.columns.set(columnIdentifier,column);if(column["disclosure"])
this.disclosureColumnIdentifier=columnIdentifier;var headerColumnElement=document.createElement("col");if(column["width"])
headerColumnElement.style.width=column["width"];column["element"]=headerColumnElement;var referenceElement=this._headerTableColumnGroupElement.children[insertionIndex];this._headerTableColumnGroupElement.insertBefore(headerColumnElement,referenceElement);var headerCellElement=document.createElement("th");headerCellElement.className=columnIdentifier+"-column";headerCellElement.columnIdentifier=columnIdentifier;if(column["aligned"])
headerCellElement.classList.add(column["aligned"]);this._headerTableCellElements.set(columnIdentifier,headerCellElement);var referenceElement=this._headerTableRowElement.children[insertionIndex];this._headerTableRowElement.insertBefore(headerCellElement,referenceElement);if(column["headerView"]){let headerView=column["headerView"];headerView.element.classList.add("header-cell-content");headerCellElement.appendChild(headerView.element);this.addSubview(headerView);}else{let titleElement=headerCellElement.createChild("div","header-cell-content");if(column["titleDOMFragment"])
titleElement.appendChild(column["titleDOMFragment"]);else
titleElement.textContent=column["title"]||"";}
if(column["sortable"]){headerCellElement.addEventListener("click",this._headerCellClicked.bind(this));headerCellElement.classList.add(WI.DataGrid.SortableColumnStyleClassName);}
if(column["group"])
headerCellElement.classList.add("column-group-"+column["group"]);if(column["tooltip"])
headerCellElement.title=column["tooltip"];if(column["collapsesGroup"]){headerCellElement.createChild("div","divider");var collapseDiv=headerCellElement.createChild("div","collapser-button");collapseDiv.title=this._collapserButtonCollapseColumnsToolTip();collapseDiv.addEventListener("mouseover",this._mouseoverColumnCollapser.bind(this));collapseDiv.addEventListener("mouseout",this._mouseoutColumnCollapser.bind(this));collapseDiv.addEventListener("click",this._clickInColumnCollapser.bind(this));headerCellElement.collapsesGroup=column["collapsesGroup"];headerCellElement.classList.add("collapser");}
this._headerTableColumnGroupElement.span=this.orderedColumns.length;var dataColumnElement=headerColumnElement.cloneNode();var referenceElement=this._dataTableColumnGroupElement.children[insertionIndex];this._dataTableColumnGroupElement.insertBefore(dataColumnElement,referenceElement);column["bodyElement"]=dataColumnElement;var fillerCellElement=document.createElement("td");fillerCellElement.className=columnIdentifier+"-column";fillerCellElement.__columnIdentifier=columnIdentifier;if(column["group"])
fillerCellElement.classList.add("column-group-"+column["group"]);var referenceElement=this._fillerRowElement.children[insertionIndex];this._fillerRowElement.insertBefore(fillerCellElement,referenceElement);this.setColumnVisible(columnIdentifier,!column.hidden);}
removeColumn(columnIdentifier)
{var removedColumn=this.columns.get(columnIdentifier);this.columns.delete(columnIdentifier);this.orderedColumns.splice(this.orderedColumns.indexOf(columnIdentifier),1);var removedOrdinal=removedColumn["ordinal"];for(var[identifier,column]of this.columns){var ordinal=column["ordinal"];if(ordinal>removedOrdinal)
column["ordinal"]=ordinal-1;}
if(removedColumn["disclosure"])
this.disclosureColumnIdentifier=undefined;if(this.sortColumnIdentifier===columnIdentifier)
this.sortColumnIdentifier=null;this._headerTableCellElements.delete(columnIdentifier);this._headerTableRowElement.children[removedOrdinal].remove();this._headerTableColumnGroupElement.children[removedOrdinal].remove();this._dataTableColumnGroupElement.children[removedOrdinal].remove();this._fillerRowElement.children[removedOrdinal].remove();this._headerTableColumnGroupElement.span=this.orderedColumns.length;for(var child of this.children)
child.refresh();}
_enumerateChildren(rootNode,result,maxLevel)
{if(!rootNode.root)
result.push(rootNode);if(!maxLevel)
return;for(var i=0;i<rootNode.children.length;++i)
this._enumerateChildren(rootNode.children[i],result,maxLevel-1);return result;}
layout()
{if(!this._columnWidthsInitialized&&this.element.offsetWidth){let headerTableColumnElements=this._headerTableColumnGroupElement.children;let tableWidth=this._dataTableElement.offsetWidth;let numColumns=headerTableColumnElements.length;let cells=this._headerTableBodyElement.rows[0].cells;let columnWidths=[];for(let i=0;i<numColumns;++i){let headerCellElement=cells[i];if(this.isColumnVisible(headerCellElement.columnIdentifier)){let columnWidth=headerCellElement.offsetWidth;let percentWidth=((columnWidth/tableWidth)*100)+"%";columnWidths.push(percentWidth);}else
columnWidths.push(0);}
for(let i=0;i<numColumns;i++){let percentWidth=columnWidths[i];this._headerTableColumnGroupElement.children[i].style.width=percentWidth;this._dataTableColumnGroupElement.children[i].style.width=percentWidth;}
this._columnWidthsInitialized=true;this._updateHeaderAndScrollbar();}
this.updateVisibleRows();}
sizeDidChange()
{this._updateHeaderAndScrollbar();}
_updateHeaderAndScrollbar()
{this._positionResizerElements();this._positionHeaderViews();this._updateScrollbarPadding();this._cachedScrollTop=NaN;this._cachedScrollableOffsetHeight=NaN;}
isColumnVisible(columnIdentifier)
{return!this.columns.get(columnIdentifier)["hidden"];}
setColumnVisible(columnIdentifier,visible)
{let column=this.columns.get(columnIdentifier);if(!column||visible===!column.hidden)
return;column.element.style.width=visible?column.width:0;column.hidden=!visible;if(this._columnVisibilitySetting){if(this._columnVisibilitySetting.value[columnIdentifier]!==visible){let copy=Object.shallowCopy(this._columnVisibilitySetting.value);copy[columnIdentifier]=visible;this._columnVisibilitySetting.value=copy;}}
this._columnWidthsInitialized=false;this.updateLayout();}
get scrollContainer()
{return this._scrollContainerElement;}
isScrolledToLastRow()
{return this._scrollContainerElement.isScrolledToBottom();}
scrollToLastRow()
{this._scrollContainerElement.scrollTop=this._scrollContainerElement.scrollHeight-this._scrollContainerElement.offsetHeight;}
_positionResizerElements()
{let leadingOffset=0;var previousResizer=null;var numResizers=this.orderedColumns.length-1;var cells=this._headerTableBodyElement.rows[0].cells;var columnWidths=[];for(var i=0;i<numResizers;++i){leadingOffset+=cells[i].getBoundingClientRect().width;columnWidths.push(leadingOffset);}
for(var i=0;i<numResizers;++i){var resizer=this.resizers[i];if(!resizer){resizer=this.resizers[i]=new WI.Resizer(WI.Resizer.RuleOrientation.Vertical,this);this.element.appendChild(resizer.element);}
leadingOffset=columnWidths[i];if(this.isColumnVisible(this.orderedColumns[i])){resizer.element.style.removeProperty("display");resizer.element.style.setProperty(WI.resolvedLayoutDirection()===WI.LayoutDirection.RTL?"right":"left",`${leadingOffset}px`);resizer[WI.DataGrid.PreviousColumnOrdinalSymbol]=i;if(previousResizer)
previousResizer[WI.DataGrid.NextColumnOrdinalSymbol]=i;previousResizer=resizer;}else{resizer.element.style.setProperty("display","none");resizer[WI.DataGrid.PreviousColumnOrdinalSymbol]=0;resizer[WI.DataGrid.NextColumnOrdinalSymbol]=0;}}
if(previousResizer)
previousResizer[WI.DataGrid.NextColumnOrdinalSymbol]=this.orderedColumns.length-1;}
_positionHeaderViews()
{let leadingOffset=0;let headerViews=[];let offsets=[];let columnWidths=[];for(let columnIdentifier of this.orderedColumns){let column=this.columns.get(columnIdentifier);if(!column)
continue;let columnWidth=this._headerTableCellElements.get(columnIdentifier).offsetWidth;let headerView=column["headerView"];if(headerView){headerViews.push(headerView);offsets.push(leadingOffset);columnWidths.push(columnWidth);}
leadingOffset+=columnWidth;}
for(let i=0;i<headerViews.length;++i){let headerView=headerViews[i];headerView.element.style.setProperty(WI.resolvedLayoutDirection()===WI.LayoutDirection.RTL?"right":"left",`${offsets[i]}px`);headerView.element.style.width=columnWidths[i]+"px";headerView.updateLayout(WI.View.LayoutReason.Resize);}}
_noteRowsChanged()
{this._previousRevealedRowCount=NaN;this.needsLayout();}
_noteRowRemoved(dataGridNode)
{if(this._inline||this._variableHeightRows){if(dataGridNode.element&&dataGridNode.element.parentNode)
dataGridNode.element.parentNode.removeChild(dataGridNode.element);return;}
this._noteRowsChanged();}
_noteScrollPositionChanged()
{this._cachedScrollTop=NaN;this.needsLayout();}
updateVisibleRows(focusedDataGridNode)
{if(this._inline||this._variableHeightRows){let nextElement=this.dataTableBodyElement.lastChild;for(let i=this._rows.length-1;i>=0;--i){let rowElement=this._rows[i].element;if(rowElement.nextSibling!==nextElement)
this.dataTableBodyElement.insertBefore(rowElement,nextElement);nextElement=rowElement;}
if(focusedDataGridNode)
focusedDataGridNode.element.scrollIntoViewIfNeeded(false);return;}
let rowHeight=this.rowHeight;let updateOffsetThreshold=rowHeight*5;let overflowPadding=updateOffsetThreshold*3;if(isNaN(this._cachedScrollTop))
this._cachedScrollTop=this._scrollContainerElement.scrollTop;if(isNaN(this._cachedScrollableOffsetHeight))
this._cachedScrollableOffsetHeight=this._scrollContainerElement.offsetHeight;let visibleRowCount=Math.ceil((this._cachedScrollableOffsetHeight+(overflowPadding*2))/rowHeight);if(!focusedDataGridNode){let currentTopMargin=this._topDataTableMarginHeight;let currentBottomMargin=this._bottomDataTableMarginHeight;let currentTableBottom=currentTopMargin+(visibleRowCount*rowHeight);let belowTopThreshold=!currentTopMargin||this._cachedScrollTop>currentTopMargin+updateOffsetThreshold;let aboveBottomThreshold=!currentBottomMargin||this._cachedScrollTop+this._cachedScrollableOffsetHeight<currentTableBottom-updateOffsetThreshold;if(belowTopThreshold&&aboveBottomThreshold&&!isNaN(this._previousRevealedRowCount))
return;}
let revealedRows=this._rows.filter((row)=>row.revealed&&!row.hidden);this._previousRevealedRowCount=revealedRows.length;if(focusedDataGridNode){let focusedIndex=revealedRows.indexOf(focusedDataGridNode);let firstVisibleRowIndex=this._cachedScrollTop/rowHeight;if(focusedIndex<firstVisibleRowIndex||focusedIndex>firstVisibleRowIndex+visibleRowCount)
this._scrollContainerElement.scrollTop=this._cachedScrollTop=(focusedIndex*rowHeight)-(this._cachedScrollableOffsetHeight/2)+(rowHeight/2);}
let topHiddenRowCount=Math.max(0,Math.floor((this._cachedScrollTop-overflowPadding)/rowHeight));let bottomHiddenRowCount=Math.max(0,this._previousRevealedRowCount-topHiddenRowCount-visibleRowCount);let marginTop=topHiddenRowCount*rowHeight;let marginBottom=bottomHiddenRowCount*rowHeight;if(this._topDataTableMarginHeight!==marginTop){this._topDataTableMarginHeight=marginTop;this._topDataTableMarginElement.style.height=marginTop+"px";}
if(this._bottomDataTableMarginElement!==marginBottom){this._bottomDataTableMarginHeight=marginBottom;this._bottomDataTableMarginElement.style.height=marginBottom+"px";}
this._dataTableElement.classList.toggle("even-first-zebra-stripe",!!(topHiddenRowCount%2));this.dataTableBodyElement.removeChildren();for(let i=topHiddenRowCount;i<topHiddenRowCount+visibleRowCount;++i){let rowDataGridNode=revealedRows[i];if(!rowDataGridNode)
continue;this.dataTableBodyElement.appendChild(rowDataGridNode.element);}
this.dataTableBodyElement.appendChild(this._fillerRowElement);}
addPlaceholderNode()
{if(this.placeholderNode)
this.placeholderNode.makeNormal();var emptyData={};for(var identifier of this.columns.keys())
emptyData[identifier]="";this.placeholderNode=new WI.PlaceholderDataGridNode(emptyData);this.appendChild(this.placeholderNode);}
appendChild(child)
{this.insertChild(child,this.children.length);}
insertChild(child,index)
{if(!child)
return;if(child.parent===this)
return;if(child.parent)
child.parent.removeChild(child);this.children.splice(index,0,child);this.hasChildren=true;child.parent=this;child.dataGrid=this.dataGrid;child._recalculateSiblings(index);delete child._depth;delete child._revealed;delete child._attached;delete child._leftPadding;child._shouldRefreshChildren=true;var current=child.children[0];while(current){current.dataGrid=this.dataGrid;delete current._depth;delete current._revealed;delete current._attached;delete current._leftPadding;current._shouldRefreshChildren=true;current=current.traverseNextNode(false,child,true);}
if(this.expanded)
child._attach();if(!this.dataGrid.hasFilters())
return;this.dataGrid._applyFiltersToNodeAndDispatchEvent(child);}
removeChild(child)
{if(!child)
return;if(child.parent!==this)
return;let wasSelected=this.selectedNode===child||child.selected;child.deselect();child._detach();this.children.remove(child,true);if(child.previousSibling)
child.previousSibling.nextSibling=child.nextSibling;if(child.nextSibling)
child.nextSibling.previousSibling=child.previousSibling;let nextChildToSelect=wasSelected?(child.nextSibling||child.previousSibling):null;child.dataGrid=null;child.parent=null;child.nextSibling=null;child.previousSibling=null;if(this.children.length<=0)
this.hasChildren=false;else if(nextChildToSelect)
nextChildToSelect.select();}
removeChildren()
{for(var i=0;i<this.children.length;++i){var child=this.children[i];child.deselect();child._detach();child.dataGrid=null;child.parent=null;child.nextSibling=null;child.previousSibling=null;}
this.children=[];this.hasChildren=false;}
findNode(comparator,skipHidden,stayWithin,dontPopulate)
{let currentNode=this._rows[0];while(currentNode&&!currentNode.root){if(!currentNode.isPlaceholderNode&&!(skipHidden&&currentNode.hidden)){if(comparator(currentNode))
return currentNode;}
currentNode=currentNode.traverseNextNode(skipHidden,stayWithin,dontPopulate);}
return null;}
sortNodes(comparator)
{this._sortNodesComparator=comparator;if(this._sortNodesRequestId)
return;this._sortNodesRequestId=window.requestAnimationFrame(()=>{if(this._sortNodesComparator)
this._sortNodesCallback(this._sortNodesComparator);});}
sortNodesImmediately(comparator)
{this._sortNodesCallback(comparator);}
_sortNodesCallback(comparator)
{function comparatorWrapper(aNode,bNode)
{if(aNode.isPlaceholderNode)
return 1;if(bNode.isPlaceholderNode)
return-1;var reverseFactor=this.sortOrder!==WI.DataGrid.SortOrder.Ascending?-1:1;return reverseFactor*comparator(aNode,bNode);}
this._sortNodesRequestId=undefined;this._sortNodesComparator=null;if(this._editing){this._sortAfterEditingCallback=this.sortNodes.bind(this,comparator);return;}
this._rows.sort(comparatorWrapper.bind(this));this._noteRowsChanged();let previousSiblingNode=null;for(let node of this._rows){node.previousSibling=previousSiblingNode;if(previousSiblingNode)
previousSiblingNode.nextSibling=node;previousSiblingNode=node;}
if(previousSiblingNode)
previousSiblingNode.nextSibling=null;if(!this.parentView)
this.updateLayoutIfNeeded();}
_toggledSortOrder()
{return this._sortOrder!==WI.DataGrid.SortOrder.Descending?WI.DataGrid.SortOrder.Descending:WI.DataGrid.SortOrder.Ascending;}
_selectSortColumnAndSetOrder(columnIdentifier,sortOrder)
{this.sortColumnIdentifier=columnIdentifier;this.sortOrder=sortOrder;}
_keyDown(event)
{if(this._editing)
return;let isRTL=WI.resolveLayoutDirectionForElement(this.element)===WI.LayoutDirection.RTL;let expandKeyIdentifier=isRTL?"Left":"Right";let collapseKeyIdentifier=isRTL?"Right":"Left";var handled=false;var nextSelectedNode;if(this.selectedNode){if(event.keyIdentifier===collapseKeyIdentifier){if(this.selectedNode.expanded){if(event.altKey)
this.selectedNode.collapseRecursively();else
this.selectedNode.collapse();handled=true;}else if(this.selectedNode.parent&&!this.selectedNode.parent.root){handled=true;if(this.selectedNode.parent.selectable){nextSelectedNode=this.selectedNode.parent;while(nextSelectedNode&&!nextSelectedNode.selectable)
nextSelectedNode=nextSelectedNode.parent;handled=!!nextSelectedNode;}else if(this.selectedNode.parent)
this.selectedNode.parent.collapse();}}else if(event.keyIdentifier===expandKeyIdentifier){if(!this.selectedNode.revealed){this.selectedNode.reveal();handled=true;}else if(this.selectedNode.hasChildren){handled=true;if(this.selectedNode.expanded){nextSelectedNode=this.selectedNode.children[0];while(nextSelectedNode&&!nextSelectedNode.selectable)
nextSelectedNode=nextSelectedNode.nextSibling;handled=!!nextSelectedNode;}else{if(event.altKey)
this.selectedNode.expandRecursively();else
this.selectedNode.expand();}}}else if(event.keyCode===8 ||event.keyCode===46 ){if(this._deleteCallback){handled=true;this._deleteCallback(this.selectedNode);}}else if(isEnterKey(event)){if(this._editCallback){handled=true;this._startEditing(this.selectedNode.element.children[0]);}}}
if(!handled){handled=this._selectionController.handleKeyDown(event);if(handled)
nextSelectedNode=this.selectedNode;}
if(nextSelectedNode){nextSelectedNode.reveal();nextSelectedNode.select();}
if(handled){event.preventDefault();event.stopPropagation();}}
closed()
{}
expand()
{}
collapse()
{}
reveal()
{}
revealAndSelect()
{}
selectNodes(nodes)
{if(!nodes.length)
return;if(nodes.length===1){this.selectedNode=nodes[0];return;}
if(!this.allowsMultipleSelection)
return;let selectableObjects=nodes.map((node)=>this.selectionItemForDataGridNode(node));this._selectionController.selectItems(new Set(selectableObjects));}
dataGridNodeFromNode(target)
{var rowElement=target.closest("tr");return rowElement&&rowElement._dataGridNode;}
dataGridNodeFromPoint(x,y)
{var node=this._dataTableElement.ownerDocument.elementFromPoint(x,y);var rowElement=node.closest("tr");return rowElement&&rowElement._dataGridNode;}
_headerCellClicked(event)
{let cell=event.target.closest("th");if(!cell||!cell.columnIdentifier||!cell.classList.contains(WI.DataGrid.SortableColumnStyleClassName))
return;let sortOrder=this._sortColumnIdentifier===cell.columnIdentifier?this._toggledSortOrder():this.sortOrder;this._selectSortColumnAndSetOrder(cell.columnIdentifier,sortOrder);}
_mouseoverColumnCollapser(event)
{var cell=event.target.closest("th");if(!cell||!cell.collapsesGroup)
return;cell.classList.add("mouse-over-collapser");}
_mouseoutColumnCollapser(event)
{var cell=event.target.closest("th");if(!cell||!cell.collapsesGroup)
return;cell.classList.remove("mouse-over-collapser");}
_clickInColumnCollapser(event)
{var cell=event.target.closest("th");if(!cell||!cell.collapsesGroup)
return;this._collapseColumnGroupWithCell(cell);event.stopPropagation();event.preventDefault();}
collapseColumnGroup(columnGroup)
{var collapserColumnIdentifier=null;for(var[identifier,column]of this.columns){if(column["collapsesGroup"]===columnGroup){collapserColumnIdentifier=identifier;break;}}
if(!collapserColumnIdentifier)
return;var cell=this._headerTableCellElements.get(collapserColumnIdentifier);this._collapseColumnGroupWithCell(cell);}
_collapseColumnGroupWithCell(cell)
{var columnsWillCollapse=cell.classList.toggle("collapsed");this.willToggleColumnGroup(cell.collapsesGroup,columnsWillCollapse);for(var[identifier,column]of this.columns){if(column["group"]===cell.collapsesGroup)
this.setColumnVisible(identifier,!columnsWillCollapse);}
var collapserButton=cell.querySelector(".collapser-button");if(collapserButton)
collapserButton.title=columnsWillCollapse?this._collapserButtonExpandColumnsToolTip():this._collapserButtonCollapseColumnsToolTip();this.didToggleColumnGroup(cell.collapsesGroup,columnsWillCollapse);}
_collapserButtonCollapseColumnsToolTip()
{return WI.UIString("Collapse columns");}
_collapserButtonExpandColumnsToolTip()
{return WI.UIString("Expand columns");}
willToggleColumnGroup(columnGroup,willCollapse)
{}
didToggleColumnGroup(columnGroup,didCollapse)
{}
headerTableHeader(columnIdentifier)
{return this._headerTableCellElements.get(columnIdentifier);}
_mouseDownInDataTable(event)
{let dataGridNode=this.dataGridNodeFromNode(event.target);if(!dataGridNode){this._selectionController.deselectAll();return;}
if(!dataGridNode.selectable||dataGridNode.isEventWithinDisclosureTriangle(event))
return;this._selectionController.handleItemMouseDown(this.selectionItemForDataGridNode(dataGridNode),event);}
_contextMenuInHeader(event)
{let contextMenu=WI.ContextMenu.createFromEvent(event);if(this._hasCopyableData())
contextMenu.appendItem(WI.UIString("Copy Table"),this._copyTable.bind(this));let headerCellElement=event.target.closest("th");if(!headerCellElement)
return;let columnIdentifier=headerCellElement.columnIdentifier;let column=this.columns.get(columnIdentifier);if(!column)
return;if(column.sortable){contextMenu.appendSeparator();if(this.sortColumnIdentifier!==columnIdentifier||this.sortOrder!==WI.DataGrid.SortOrder.Ascending){contextMenu.appendItem(WI.UIString("Sort Ascending"),()=>{this._selectSortColumnAndSetOrder(columnIdentifier,WI.DataGrid.SortOrder.Ascending);});}
if(this.sortColumnIdentifier!==columnIdentifier||this.sortOrder!==WI.DataGrid.SortOrder.Descending){contextMenu.appendItem(WI.UIString("Sort Descending"),()=>{this._selectSortColumnAndSetOrder(columnIdentifier,WI.DataGrid.SortOrder.Descending);});}}
if(this._columnChooserEnabled){let didAddSeparator=false;for(let[identifier,columnInfo]of this.columns){if(columnInfo.locked)
continue;if(!didAddSeparator){contextMenu.appendSeparator();didAddSeparator=true;const disabled=true;contextMenu.appendItem(WI.UIString("Displayed Columns"),()=>{},disabled);}
contextMenu.appendCheckboxItem(columnInfo.title,()=>{this.setColumnVisible(identifier,!!columnInfo.hidden);},!columnInfo.hidden);}}}
_contextMenuInDataTable(event)
{let contextMenu=WI.ContextMenu.createFromEvent(event);let gridNode=this.dataGridNodeFromNode(event.target);if(gridNode)
gridNode.appendContextMenuItems(contextMenu);if(this.dataGrid._refreshCallback&&(!gridNode||gridNode!==this.placeholderNode))
contextMenu.appendItem(WI.UIString("Refresh"),this._refreshCallback.bind(this));if(gridNode){if(gridNode.selectable&&gridNode.copyable&&!gridNode.isEventWithinDisclosureTriangle(event)){contextMenu.appendItem(WI.UIString("Copy Row"),this._copyRow.bind(this,gridNode));contextMenu.appendItem(WI.UIString("Copy Table"),this._copyTable.bind(this));if(this.dataGrid._editCallback){if(gridNode===this.placeholderNode)
contextMenu.appendItem(WI.UIString("Add New"),this._startEditing.bind(this,event.target));else if(gridNode.editable){let element=event.target.closest("td");let columnIdentifier=element.__columnIdentifier;let columnTitle=this.dataGrid.columns.get(columnIdentifier)["title"];contextMenu.appendItem(WI.UIString("Edit %s").format(columnTitle),this._startEditing.bind(this,event.target));}}
if(this.dataGrid._deleteCallback&&gridNode!==this.placeholderNode&&gridNode.editable)
contextMenu.appendItem(WI.UIString("Delete"),this._deleteCallback.bind(this,gridNode));}
if(gridNode.children.some((child)=>child.hasChildren)||(gridNode.hasChildren&&!gridNode.children.length)){contextMenu.appendSeparator();contextMenu.appendItem(WI.UIString("Expand All"),gridNode.expandRecursively.bind(gridNode));contextMenu.appendItem(WI.UIString("Collapse All"),gridNode.collapseRecursively.bind(gridNode));}}}
_clickInDataTable(event)
{var gridNode=this.dataGridNodeFromNode(event.target);if(!gridNode||!gridNode.hasChildren)
return;if(!gridNode.isEventWithinDisclosureTriangle(event))
return;if(gridNode.expanded){if(event.altKey)
gridNode.collapseRecursively();else
gridNode.collapse();}else{if(event.altKey)
gridNode.expandRecursively();else
gridNode.expand();}}
textForDataGridNodeColumn(node,columnIdentifier)
{var data=node.data[columnIdentifier];return(data instanceof Node?data.textContent:data)||"";}
_copyTextForDataGridNode(node)
{let fields=node.dataGrid.orderedColumns.map((identifier)=>{let text=this.textForDataGridNodeColumn(node,identifier);if(this._copyCallback)
text=this._copyCallback(node,identifier,text);return text;});return fields.join(this._copyTextDelimiter);}
_copyTextForDataGridHeaders()
{let fields=this.orderedColumns.map((identifier)=>this.headerTableHeader(identifier).textContent);return fields.join(this._copyTextDelimiter);}
handleBeforeCopyEvent(event)
{if(this.selectedNode&&window.getSelection().isCollapsed)
event.preventDefault();}
handleCopyEvent(event)
{if(!window.getSelection().isCollapsed)
return;let copyData=[];for(let dataGridNode of this.selectedDataGridNodes){if(!dataGridNode.copyable||dataGridNode.isPlaceholderNode)
continue;copyData.push(this._copyTextForDataGridNode(dataGridNode));}
if(!copyData.length)
return;event.clipboardData.setData("text/plain",copyData.join("\n"));event.stopPropagation();event.preventDefault();}
_copyRow(dataGridNode)
{if(!dataGridNode.copyable||dataGridNode.isPlaceholderNode)
return;let copyText=this._copyTextForDataGridNode(dataGridNode);InspectorFrontendHost.copyText(copyText);}
_copyTable()
{let copyData=[];copyData.push(this._copyTextForDataGridHeaders());for(let dataGridNode of this._rows){if(!dataGridNode.copyable||dataGridNode.isPlaceholderNode)
continue;copyData.push(this._copyTextForDataGridNode(dataGridNode));}
if(!copyData.length)
return;InspectorFrontendHost.copyText(copyData.join("\n"));}
_hasCopyableData()
{const skipHidden=true;const stayWithin=null;const dontPopulate=true;let dataGridNode=this._rows[0];while(dataGridNode&&(!dataGridNode.selectable||!dataGridNode.copyable||dataGridNode.isPlaceholderNode))
dataGridNode=dataGridNode.traverseNextNode(skipHidden,stayWithin,dontPopulate);return!!dataGridNode;}
resizerDragStarted(resizer)
{if(!resizer[WI.DataGrid.NextColumnOrdinalSymbol])
return true;this._currentResizer=resizer;}
resizerDragging(resizer,positionDelta)
{if(resizer!==this._currentResizer)
return;let isRTL=WI.resolvedLayoutDirection()===WI.LayoutDirection.RTL;if(isRTL)
positionDelta*=-1;let dragPoint=0;if(isRTL)
dragPoint+=this.element.totalOffsetRight-resizer.initialPosition-positionDelta;else
dragPoint+=resizer.initialPosition-this.element.totalOffsetLeft-positionDelta;var leftColumnIndex=resizer[WI.DataGrid.PreviousColumnOrdinalSymbol];var rightColumnIndex=resizer[WI.DataGrid.NextColumnOrdinalSymbol];var firstRowCells=this._headerTableBodyElement.rows[0].cells;let leadingEdgeOfPreviousColumn=0;for(let i=0;i<leftColumnIndex;++i)
leadingEdgeOfPreviousColumn+=firstRowCells[i].offsetWidth;let trailingEdgeOfNextColumn=leadingEdgeOfPreviousColumn+firstRowCells[leftColumnIndex].offsetWidth+firstRowCells[rightColumnIndex].offsetWidth;let leftMinimum=leadingEdgeOfPreviousColumn+WI.DataGrid.ColumnResizePadding;let rightMaximum=trailingEdgeOfNextColumn-WI.DataGrid.ColumnResizePadding;dragPoint=Number.constrain(dragPoint,leftMinimum,rightMaximum);resizer.element.style.setProperty(isRTL?"right":"left",`${dragPoint - this.CenterResizerOverBorderAdjustment}px`);let percentLeftColumn=(((dragPoint-leadingEdgeOfPreviousColumn)/this._dataTableElement.offsetWidth)*100)+"%";this._headerTableColumnGroupElement.children[leftColumnIndex].style.width=percentLeftColumn;this._dataTableColumnGroupElement.children[leftColumnIndex].style.width=percentLeftColumn;let percentRightColumn=(((trailingEdgeOfNextColumn-dragPoint)/this._dataTableElement.offsetWidth)*100)+"%";this._headerTableColumnGroupElement.children[rightColumnIndex].style.width=percentRightColumn;this._dataTableColumnGroupElement.children[rightColumnIndex].style.width=percentRightColumn;this._positionResizerElements();this._positionHeaderViews();const skipHidden=true;const dontPopulate=true;let leftColumnIdentifier=this.orderedColumns[leftColumnIndex];let rightColumnIdentifier=this.orderedColumns[rightColumnIndex];let child=this.children[0];while(child){child.didResizeColumn(leftColumnIdentifier);child.didResizeColumn(rightColumnIdentifier);child=child.traverseNextNode(skipHidden,this,dontPopulate);}
event.preventDefault();}
resizerDragEnded(resizer)
{if(resizer!==this._currentResizer)
return;this._currentResizer=null;}
_updateFilter()
{if(this._scheduledFilterUpdateIdentifier){cancelAnimationFrame(this._scheduledFilterUpdateIdentifier);this._scheduledFilterUpdateIdentifier=undefined;}
if(!this._rows.length)
return;this._textFilterRegex=this._filterText?WI.SearchUtilities.filterRegExpForString(this._filterText,WI.SearchUtilities.defaultSettings):null;if(this._applyFilterToNodesTask&&this._applyFilterToNodesTask.processing)
this._applyFilterToNodesTask.cancel();function*createIteratorForNodesToBeFiltered()
{let hasFilters=this.hasFilters();let currentNode=this._rows[0];while(currentNode&&!currentNode.root){yield currentNode;let dontPopulate=!hasFilters;if(hasFilters&&this._filterDelegate&&this._filterDelegate.dataGridMatchShouldPopulateWhenFilteringNode)
dontPopulate=this._filterDelegate.dataGridMatchShouldPopulateWhenFilteringNode(currentNode);currentNode=currentNode.traverseNextNode(false,null,dontPopulate);}}
let items=createIteratorForNodesToBeFiltered.call(this);this._applyFilterToNodesTask=new WI.YieldableTask(this,items,{workInterval:100});this._filterDidModifyNodeWhileProcessingItems=false;this._applyFilterToNodesTask.start();}
selectDataGridNodeInternal(dataGridNode,suppressSelectedEvent)
{if(this._processingSelectionChange)
return;this._suppressNextSelectionDidChangeEvent=suppressSelectedEvent;this._selectionController.selectItem(this.selectionItemForDataGridNode(dataGridNode));}
deselectDataGridNodeInternal(dataGridNode,suppressDeselectedEvent)
{if(this._processingSelectionChange)
return;this._suppressNextSelectionDidChangeEvent=suppressDeselectedEvent;this._selectionController.deselectItem(this.selectionItemForDataGridNode(dataGridNode));}
_dispatchSelectedNodeChangedEvent()
{if(this._suppressNextSelectionDidChangeEvent){this._suppressNextSelectionDidChangeEvent=false;return;}
this.dispatchEventToListeners(WI.DataGrid.Event.SelectedNodeChanged);}
yieldableTaskWillProcessItem(task,node)
{let nodeWasModified=this._applyFiltersToNodeAndDispatchEvent(node);if(nodeWasModified)
this._filterDidModifyNodeWhileProcessingItems=true;}
yieldableTaskDidYield(task,processedItems,elapsedTime)
{if(!this._filterDidModifyNodeWhileProcessingItems)
return;this._filterDidModifyNodeWhileProcessingItems=false;this.dispatchEventToListeners(WI.DataGrid.Event.FilterDidChange);}
yieldableTaskDidFinish(task)
{this._applyFilterToNodesTask=null;}
dataGridNodeForSelectionItem(item)
{return item;}
selectionItemForDataGridNode(dataGridNode)
{return dataGridNode;}
selectionControllerSelectionDidChange(selectionController,deselectedItems,selectedItems)
{this._processingSelectionChange=true;for(let item of deselectedItems){let dataGridNode=this.dataGridNodeForSelectionItem(item);dataGridNode?.deselect();}
for(let item of selectedItems){let dataGridNode=this.dataGridNodeForSelectionItem(item);dataGridNode?.select();}
this._dispatchSelectedNodeChangedEvent();this._processingSelectionChange=false;}
selectionControllerFirstSelectableItem(controller,operation)
{let firstChild=this._rows[0];let item=this.selectionItemForDataGridNode(firstChild);if(firstChild.selectable&&(!firstChild.isPlaceholderNode||operation===WI.SelectionController.Operation.Direct))
return item;return this.selectionControllerNextSelectableItem(controller,item,operation);}
selectionControllerLastSelectableItem(controller,operation)
{let lastChild=this._rows.lastValue;while(lastChild.expanded&&lastChild.children.length)
lastChild=lastChild.children.lastValue;let item=this.selectionItemForDataGridNode(lastChild);if(lastChild.selectable&&(!lastChild.isPlaceholderNode||operation===WI.SelectionController.Operation.Direct))
return item;return this.selectionControllerPreviousSelectableItem(controller,item,operation);}
selectionControllerPreviousSelectableItem(controller,item,operation)
{let dataGridNode=this.dataGridNodeForSelectionItem(item);if(!dataGridNode)
return null;const skipUnrevealed=true;const dontPopulate=true;while(dataGridNode=dataGridNode.traversePreviousNode(skipUnrevealed,dontPopulate)){if(dataGridNode.selectable&&(!dataGridNode.isPlaceholderNode||operation===WI.SelectionController.Operation.Direct))
return this.selectionItemForDataGridNode(dataGridNode);}
return null;}
selectionControllerNextSelectableItem(controller,item,operation)
{let dataGridNode=this.dataGridNodeForSelectionItem(item);if(!dataGridNode)
return null;const skipUnrevealed=true;const stayWithin=null;const dontPopulate=true;while(dataGridNode=dataGridNode.traverseNextNode(skipUnrevealed,stayWithin,dontPopulate)){if(dataGridNode.selectable&&(!dataGridNode.isPlaceholderNode||operation===WI.SelectionController.Operation.Direct))
return this.selectionItemForDataGridNode(dataGridNode);}
return null;}};WI.DataGrid.Event={SortChanged:"datagrid-sort-changed",SelectedNodeChanged:"datagrid-selected-node-changed",ExpandedNode:"datagrid-expanded-node",CollapsedNode:"datagrid-collapsed-node",FilterDidChange:"datagrid-filter-did-change",NodeWasFiltered:"datagrid-node-was-filtered"};WI.DataGrid.SortOrder={Indeterminate:"data-grid-sort-order-indeterminate",Ascending:"data-grid-sort-order-ascending",Descending:"data-grid-sort-order-descending"};WI.DataGrid.PreviousColumnOrdinalSymbol=Symbol("previous-column-ordinal");WI.DataGrid.NextColumnOrdinalSymbol=Symbol("next-column-ordinal");WI.DataGrid.WasExpandedDuringFilteringSymbol=Symbol("was-expanded-during-filtering");WI.DataGrid.ColumnResizePadding=10;WI.DataGrid.CenterResizerOverBorderAdjustment=3;WI.DataGrid.SortColumnAscendingStyleClassName="sort-ascending";WI.DataGrid.SortColumnDescendingStyleClassName="sort-descending";WI.DataGrid.SortableColumnStyleClassName="sortable";WI.DataGridNode=class DataGridNode extends WI.Object
{constructor(data,{selectable,copyable,editable,hasChildren,classNames}={})
{super();this._expanded=false;this._hidden=false;this._selected=false;this._selectable=selectable!==undefined?selectable:true;this._copyable=copyable!==undefined?copyable:true;this._editable=editable!==undefined?editable:true;this._shouldRefreshChildren=true;this._data=data||{};this.hasChildren=hasChildren||false;this.children=[];this.dataGrid=null;this.parent=null;this.previousSibling=null;this.nextSibling=null;this.disclosureToggleWidth=10;this._classNames=classNames||[];}
get hidden()
{return this._hidden;}
set hidden(x)
{x=!!x;if(this._hidden===x)
return;this._hidden=x;if(this._element)
this._element.classList.toggle("hidden",this._hidden);if(this.dataGrid)
this.dataGrid._noteRowsChanged();}
get selectable()
{return this._element&&!this._hidden&&this._selectable;}
get copyable()
{return this._copyable;}
set copyable(x)
{this._copyable=x;}
get editable()
{return this._editable;}
set editable(x)
{this._editable=x;}
get element()
{if(this._element)
return this._element;if(!this.dataGrid)
return null;this._element=document.createElement("tr");this._element._dataGridNode=this;if(this.hasChildren)
this._element.classList.add("parent");if(this.expanded)
this._element.classList.add("expanded");if(this.selected)
this._element.classList.add("selected");if(this.revealed)
this._element.classList.add("revealed");if(this._hidden)
this._element.classList.add("hidden");this._element.classList.add(...this._classNames);this.createCells();return this._element;}
createCells()
{for(var columnIdentifier of this.dataGrid.orderedColumns)
this._element.appendChild(this.createCell(columnIdentifier));}
refreshIfNeeded()
{if(!this._needsRefresh)
return;this._needsRefresh=false;this.refresh();}
needsRefresh()
{this._needsRefresh=true;if(!this._revealed)
return;if(this._scheduledRefreshIdentifier)
return;this._scheduledRefreshIdentifier=requestAnimationFrame(this.refresh.bind(this));}
get data()
{return this._data;}
set data(x)
{x=x||{};if(Object.shallowEqual(this._data,x))
return;this._data=x;this.needsRefresh();}
get filterableData()
{if(this._cachedFilterableData)
return this._cachedFilterableData;this._cachedFilterableData=[];for(let column of this.dataGrid.columns.values()){if(column.hidden)
continue;let value=this.filterableDataForColumn(column.columnIdentifier);if(!value)
continue;if(!(value instanceof Array))
value=[value];if(!value.length)
continue;this._cachedFilterableData.pushAll(value);}
return this._cachedFilterableData;}
get revealed()
{if("_revealed"in this)
return this._revealed;var currentAncestor=this.parent;while(currentAncestor&&!currentAncestor.root){if(!currentAncestor.expanded){this._revealed=false;return false;}
currentAncestor=currentAncestor.parent;}
this._revealed=true;return true;}
set hasChildren(x)
{if(this._hasChildren===x)
return;this._hasChildren=x;if(!this._element)
return;if(this._hasChildren){this._element.classList.add("parent");if(this.expanded)
this._element.classList.add("expanded");}else
this._element.classList.remove("parent","expanded");}
get hasChildren()
{return this._hasChildren;}
set revealed(x)
{if(this._revealed===x)
return;this._revealed=x;if(this._element){if(this._revealed)
this._element.classList.add("revealed");else
this._element.classList.remove("revealed");}
this.refreshIfNeeded();for(var i=0;i<this.children.length;++i)
this.children[i].revealed=x&&this.expanded;}
get depth()
{if("_depth"in this)
return this._depth;if(this.parent&&!this.parent.root)
this._depth=this.parent.depth+1;else
this._depth=0;return this._depth;}
get indentPadding()
{if(typeof this._indentPadding==="number")
return this._indentPadding;this._indentPadding=this.depth*this.dataGrid.indentWidth;return this._indentPadding;}
get shouldRefreshChildren()
{return this._shouldRefreshChildren;}
set shouldRefreshChildren(x)
{this._shouldRefreshChildren=x;if(x&&this.expanded)
this.expand();}
get selected()
{return this._selected;}
set selected(x)
{if(x)
this.select();else
this.deselect();}
get expanded()
{return this._expanded;}
set expanded(x)
{if(x)
this.expand();else
this.collapse();}
hasAncestor(ancestor)
{if(!ancestor)
return false;let currentAncestor=this.parent;while(currentAncestor){if(ancestor===currentAncestor)
return true;currentAncestor=currentAncestor.parent;}
return false;}
refresh()
{if(!this._element||!this.dataGrid)
return;if(this._scheduledRefreshIdentifier){cancelAnimationFrame(this._scheduledRefreshIdentifier);this._scheduledRefreshIdentifier=undefined;}
this._cachedFilterableData=null;this._needsRefresh=false;this._element.removeChildren();this.createCells();}
refreshRecursively()
{this.refresh();this.forEachChildInSubtree((node)=>node.refresh());}
updateLayout()
{}
createCell(columnIdentifier)
{var cellElement=document.createElement("td");cellElement.className=columnIdentifier+"-column";cellElement.__columnIdentifier=columnIdentifier;var div=cellElement.createChild("div","cell-content");var content=this.createCellContent(columnIdentifier,cellElement);div.append(content);let column=this.dataGrid.columns.get(columnIdentifier);if(column){if(column["aligned"])
cellElement.classList.add(column["aligned"]);if(column["group"])
cellElement.classList.add("column-group-"+column["group"]);if(column["icon"]){let iconElement=document.createElement("div");iconElement.classList.add("icon");iconElement.title=this.generateIconTitle(columnIdentifier);div.insertBefore(iconElement,div.firstChild);}}
if(columnIdentifier===this.dataGrid.disclosureColumnIdentifier){cellElement.classList.add("disclosure");if(this.indentPadding){if(WI.resolvedLayoutDirection()===WI.LayoutDirection.RTL)
cellElement.style.setProperty("padding-right",`${this.indentPadding}px`);else
cellElement.style.setProperty("padding-left",`${this.indentPadding}px`);}}
return cellElement;}
createCellContent(columnIdentifier)
{if(!(columnIdentifier in this.data))
return zeroWidthSpace;let data=this.data[columnIdentifier];return typeof data==="number"?data.maxDecimals(2).toLocaleString():data;}
generateIconTitle(columnIdentifier)
{return"";}
elementWithColumnIdentifier(columnIdentifier)
{if(!this.dataGrid)
return null;let index=this.dataGrid.orderedColumns.indexOf(columnIdentifier);if(index===-1)
return null;return this.element.children[index];}
appendChild(){return WI.DataGrid.prototype.appendChild.apply(this,arguments);}
insertChild(){return WI.DataGrid.prototype.insertChild.apply(this,arguments);}
removeChild(){return WI.DataGrid.prototype.removeChild.apply(this,arguments);}
removeChildren(){return WI.DataGrid.prototype.removeChildren.apply(this,arguments);}
_recalculateSiblings(myIndex)
{if(!this.parent)
return;var previousChild=myIndex>0?this.parent.children[myIndex-1]:null;if(previousChild){previousChild.nextSibling=this;this.previousSibling=previousChild;}else
this.previousSibling=null;var nextChild=this.parent.children[myIndex+1];if(nextChild){nextChild.previousSibling=this;this.nextSibling=nextChild;}else
this.nextSibling=null;}
collapse()
{if(this._element)
this._element.classList.remove("expanded");this._expanded=false;for(var i=0;i<this.children.length;++i)
this.children[i].revealed=false;if(this.dataGrid){this.dataGrid.dispatchEventToListeners(WI.DataGrid.Event.CollapsedNode,{dataGridNode:this});this.dataGrid._noteRowsChanged();}}
collapseRecursively()
{var item=this;while(item){if(item.expanded)
item.collapse();item=item.traverseNextNode(false,this,true);}}
expand()
{if(!this.hasChildren||this.expanded)
return;if(this.revealed&&!this._shouldRefreshChildren)
for(var i=0;i<this.children.length;++i)
this.children[i].revealed=true;if(this._shouldRefreshChildren){for(var i=0;i<this.children.length;++i)
this.children[i]._detach();this.dispatchEventToListeners(DataGridNode.Event.Populate);if(this._attached){for(var i=0;i<this.children.length;++i){var child=this.children[i];if(this.revealed)
child.revealed=true;child._attach();}}
this._shouldRefreshChildren=false;}
if(this._element)
this._element.classList.add("expanded");this._expanded=true;if(this.dataGrid){this.dataGrid.dispatchEventToListeners(WI.DataGrid.Event.ExpandedNode,{dataGridNode:this});this.dataGrid._noteRowsChanged();}}
expandRecursively()
{var item=this;while(item){item.expand();item=item.traverseNextNode(false,this);}}
forEachImmediateChild(callback)
{for(let node of this.children)
callback(node);}
forEachChildInSubtree(callback)
{let node=this.traverseNextNode(false,this,true);while(node){callback(node);node=node.traverseNextNode(false,this,true);}}
isInSubtreeOfNode(baseNode)
{let node=baseNode;while(node){if(node===this)
return true;node=node.traverseNextNode(false,baseNode,true);}
return false;}
reveal()
{var currentAncestor=this.parent;while(currentAncestor&&!currentAncestor.root){if(!currentAncestor.expanded)
currentAncestor.expand();currentAncestor=currentAncestor.parent;}
this.dataGrid.updateVisibleRows(this);}
select(suppressSelectedEvent)
{if(!this.dataGrid||!this.selectable||this.selected)
return;this._selected=true;this._element?.classList.add("selected");this.dataGrid.selectDataGridNodeInternal(this,suppressSelectedEvent);}
revealAndSelect(suppressSelectedEvent)
{this.reveal();this.select(suppressSelectedEvent);}
deselect(suppressDeselectedEvent)
{if(!this.dataGrid||!this.selectable||!this.selected)
return;this._selected=false;this._element?.classList.remove("selected");this.dataGrid.deselectDataGridNodeInternal(this,suppressDeselectedEvent);}
traverseNextNode(skipHidden,stayWithin,dontPopulate,info)
{if(!dontPopulate&&this.hasChildren)
this.dispatchEventToListeners(DataGridNode.Event.Populate);if(info)
info.depthChange=0;var node=(!skipHidden||this.revealed)?this.children[0]:null;if(node&&(!skipHidden||this.expanded)){if(info)
info.depthChange=1;return node;}
if(this===stayWithin)
return null;node=(!skipHidden||this.revealed)?this.nextSibling:null;if(node)
return node;node=this;while(node&&!node.root&&!((!skipHidden||node.revealed)?node.nextSibling:null)&&node.parent!==stayWithin){if(info)
info.depthChange-=1;node=node.parent;}
if(!node)
return null;return(!skipHidden||node.revealed)?node.nextSibling:null;}
traversePreviousNode(skipHidden,dontPopulate)
{var node=(!skipHidden||this.revealed)?this.previousSibling:null;if(!dontPopulate&&node&&node.hasChildren)
node.dispatchEventToListeners(DataGridNode.Event.Populate);while(node&&((!skipHidden||(node.revealed&&node.expanded))?node.children.lastValue:null)){if(!dontPopulate&&node.hasChildren)
node.dispatchEventToListeners(DataGridNode.Event.Populate);node=(!skipHidden||(node.revealed&&node.expanded))?node.children.lastValue:null;}
if(node)
return node;if(!this.parent||this.parent.root)
return null;return this.parent;}
isEventWithinDisclosureTriangle(event)
{if(!this.hasChildren)
return false;let cell=event.target.closest("td");if(!cell||!cell.classList.contains("disclosure"))
return false;let start=0;if(WI.resolvedLayoutDirection()===WI.LayoutDirection.RTL)
start+=cell.totalOffsetRight-cell.getComputedCSSPropertyNumberValue("padding-right")-this.disclosureToggleWidth;else
start+=cell.totalOffsetLeft+cell.getComputedCSSPropertyNumberValue("padding-left");return event.pageX>=start&&event.pageX<=start+this.disclosureToggleWidth;}
_attach()
{if(!this.dataGrid||this._attached)
return;this._attached=true;let insertionIndex=-1;if(!this.isPlaceholderNode){var previousGridNode=this.traversePreviousNode(true,true);insertionIndex=this.dataGrid._rows.indexOf(previousGridNode);if(insertionIndex===-1)
insertionIndex=0;else
insertionIndex++;}
if(insertionIndex===-1)
this.dataGrid._rows.push(this);else
this.dataGrid._rows.insertAtIndex(this,insertionIndex);this.dataGrid._noteRowsChanged();if(this.expanded){for(var i=0;i<this.children.length;++i)
this.children[i]._attach();}}
_detach()
{if(!this._attached)
return;this._attached=false;this.dataGrid._rows.remove(this,true);this.dataGrid._noteRowRemoved(this);for(var i=0;i<this.children.length;++i)
this.children[i]._detach();}
savePosition()
{if(this._savedPosition)
return;if(!this.parent)
return;this._savedPosition={parent:this.parent,index:this.parent.children.indexOf(this)};}
restorePosition()
{if(!this._savedPosition)
return;if(this.parent!==this._savedPosition.parent)
this._savedPosition.parent.insertChild(this,this._savedPosition.index);this._savedPosition=null;}
appendContextMenuItems(contextMenu)
{return null;}
filterableDataForColumn(columnIdentifier)
{let value=this.data[columnIdentifier];return typeof value==="string"?value:null;}
didResizeColumn(columnIdentifier)
{}};WI.DataGridNode.Event={Populate:"data-grid-node-populate",};WI.PlaceholderDataGridNode=class PlaceholderDataGridNode extends WI.DataGridNode
{constructor(data)
{super(data);this.isPlaceholderNode=true;}
makeNormal()
{this.isPlaceholderNode=false;}};WI.DetailsSectionRow=class DetailsSectionRow extends WI.Object
{constructor(emptyMessage)
{super();this._element=document.createElement("div");this._element.className="row";this._emptyMessage=emptyMessage||"";}
get element()
{return this._element;}
get emptyMessage()
{return this._emptyMessage;}
set emptyMessage(emptyMessage)
{this._emptyMessage=emptyMessage||"";if(!this._element.childNodes.length)
this.showEmptyMessage();}
showEmptyMessage()
{this.element.classList.add(WI.DetailsSectionRow.EmptyStyleClassName);if(this._emptyMessage instanceof Node){this.element.removeChildren();this.element.appendChild(this._emptyMessage);}else
this.element.textContent=this._emptyMessage;}
hideEmptyMessage()
{this.element.classList.remove(WI.DetailsSectionRow.EmptyStyleClassName);this.element.removeChildren();}};WI.DetailsSectionRow.EmptyStyleClassName="empty";WI.Dialog=class Dialog extends WI.View
{constructor(delegate)
{super();this._delegate=delegate;this._dismissing=false;this._representedObject=null;this._cookie=null;this._visible=false;}
get visible(){return this._visible;}
get delegate(){return this._delegate;}
get representedObject(){return this._representedObject;}
get cookie(){return this._cookie;}
present(parentElement)
{parentElement.appendChild(this.element);this._visible=true;this.didPresentDialog();}
dismiss(representedObject,cookie)
{if(this._dismissing)
return;let parent=this.element.parentNode;if(!parent)
return;this._dismissing=true;this._representedObject=representedObject||null;this._cookie=cookie||null;this._visible=false;this.element.remove();if(this.representedObjectIsValid(this._representedObject)){if(this._delegate&&typeof this._delegate.dialogWasDismissedWithRepresentedObject==="function")
this._delegate.dialogWasDismissedWithRepresentedObject(this,this._representedObject);}
this._dismissing=false;this.didDismissDialog();}
didDismissDialog()
{}
didPresetDialog()
{}
representedObjectIsValid(value)
{if(this.delegate&&typeof this.delegate.isDialogRepresentedObjectValid==="function")
return this.delegate.isDialogRepresentedObjectValid(this,value);return true;}};WI.HierarchicalPathComponent=class HierarchicalPathComponent extends WI.Object
{constructor(displayName,styleClassNames,representedObject,textOnly,showSelectorArrows)
{super();this._representedObject=representedObject||null;this._element=document.createElement("div");this._element.className="hierarchical-path-component";if(!Array.isArray(styleClassNames))
styleClassNames=[styleClassNames];this._element.classList.add(...styleClassNames);if(!textOnly){this._iconElement=document.createElement("img");this._iconElement.className="icon";this._element.appendChild(this._iconElement);}else
this._element.classList.add("text-only");this._titleElement=document.createElement("div");this._titleElement.className="title";this._titleElement.setAttribute("dir","auto");this._element.appendChild(this._titleElement);this._titleContentElement=document.createElement("div");this._titleContentElement.className="content";this._titleElement.appendChild(this._titleContentElement);this._separatorElement=document.createElement("div");this._separatorElement.className="separator";this._element.appendChild(this._separatorElement);this._selectElement=document.createElement("select");this._selectElement.setAttribute("dir","auto");this._selectElement.addEventListener("mouseover",this._selectElementMouseOver.bind(this));this._selectElement.addEventListener("mouseout",this._selectElementMouseOut.bind(this));this._selectElement.addEventListener("mousedown",this._selectElementMouseDown.bind(this));this._selectElement.addEventListener("mouseup",this._selectElementMouseUp.bind(this));this._selectElement.addEventListener("change",this._selectElementSelectionChanged.bind(this));this._element.appendChild(this._selectElement);this._previousSibling=null;this._nextSibling=null;this._truncatedDisplayNameLength=0;this._collapsed=false;this._hidden=false;this._selectorArrows=false;this.displayName=displayName;this.tooltip=displayName;this.selectorArrows=showSelectorArrows;}
get selectedPathComponent()
{let selectedOption=this._selectElement[this._selectElement.selectedIndex];if(!selectedOption&&this._selectElement.options.length===1)
selectedOption=this._selectElement.options[0];return selectedOption&&selectedOption._pathComponent||null;}
get element(){return this._element;}
get representedObject(){return this._representedObject;}
get displayName()
{return this._displayName;}
set displayName(newDisplayName)
{if(newDisplayName===this._displayName)
return;this._displayName=newDisplayName;this._updateElementTitleAndText();}
get truncatedDisplayNameLength()
{return this._truncatedDisplayNameLength;}
set truncatedDisplayNameLength(truncatedDisplayNameLength)
{truncatedDisplayNameLength=truncatedDisplayNameLength||0;if(truncatedDisplayNameLength===this._truncatedDisplayNameLength)
return;this._truncatedDisplayNameLength=truncatedDisplayNameLength;this._updateElementTitleAndText();}
get minimumWidth()
{if(this._collapsed)
return WI.HierarchicalPathComponent.MinimumWidthCollapsed;if(this._selectorArrows)
return WI.HierarchicalPathComponent.MinimumWidth+WI.HierarchicalPathComponent.SelectorArrowsWidth;return WI.HierarchicalPathComponent.MinimumWidth;}
get forcedWidth()
{let maxWidth=this._element.style.getProperty("width");if(typeof maxWidth==="string")
return parseInt(maxWidth);return null;}
set forcedWidth(width)
{if(typeof width==="number"){let minimumWidthForOneCharacterTruncatedTitle=WI.HierarchicalPathComponent.MinimumWidthForOneCharacterTruncatedTitle;if(this.selectorArrows)
minimumWidthForOneCharacterTruncatedTitle+=WI.HierarchicalPathComponent.SelectorArrowsWidth;if(width<minimumWidthForOneCharacterTruncatedTitle)
width=0;this._element.style.setProperty("width",Math.max(1,width)+"px");}else
this._element.style.removeProperty("width");}
get hidden()
{return this._hidden;}
set hidden(flag)
{if(this._hidden===flag)
return;this._hidden=flag;this._element.classList.toggle("hidden",this._hidden);}
get collapsed()
{return this._collapsed;}
set collapsed(flag)
{if(this._collapsed===flag)
return;this._collapsed=flag;this._element.classList.toggle("collapsed",this._collapsed);}
get selectorArrows()
{return this._selectorArrows;}
set selectorArrows(flag)
{if(this._selectorArrows===flag)
return;this._selectorArrows=flag;if(this._selectorArrows){this._selectorArrowsElement=WI.ImageUtilities.useSVGSymbol("Images/UpDownArrows.svg","selector-arrows");this._element.insertBefore(this._selectorArrowsElement,this._separatorElement);}else if(this._selectorArrowsElement){this._selectorArrowsElement.remove();this._selectorArrowsElement=null;}
this._element.classList.toggle("show-selector-arrows",!!this._selectorArrows);}
get tooltip()
{return this._tooltip;}
set tooltip(x)
{if(x===this._tooltip)
return;this._tooltip=x;this._updateElementTitleAndText();}
get hideTooltip()
{return this._hideTooltip;}
set hideTooltip(hide)
{this._hideTooltip=hide;this._updateElementTitleAndText();}
get previousSibling(){return this._previousSibling;}
set previousSibling(newSlibling){this._previousSibling=newSlibling||null;}
get nextSibling(){return this._nextSibling;}
set nextSibling(newSlibling){this._nextSibling=newSlibling||null;}
_updateElementTitleAndText()
{let truncatedDisplayName=this._displayName;if(this._truncatedDisplayNameLength&&truncatedDisplayName.length>this._truncatedDisplayNameLength)
truncatedDisplayName=truncatedDisplayName.substring(0,this._truncatedDisplayNameLength)+ellipsis;this._titleContentElement.textContent=truncatedDisplayName;if(this.hideTooltip)
this._element.title="";else
this._element.title=this._tooltip;}
_updateSelectElement()
{this._selectElement.removeChildren();function createOption(component)
{let optionElement=document.createElement("option");let maxPopupMenuLength=130;optionElement.textContent=component.displayName.length<=maxPopupMenuLength?component.displayName:component.displayName.substring(0,maxPopupMenuLength)+ellipsis;optionElement._pathComponent=component;return optionElement;}
let previousSiblingCount=0;let sibling=this.previousSibling;while(sibling){this._selectElement.insertBefore(createOption(sibling),this._selectElement.firstChild);sibling=sibling.previousSibling;++previousSiblingCount;}
this._selectElement.appendChild(createOption(this));sibling=this.nextSibling;while(sibling){this._selectElement.appendChild(createOption(sibling));sibling=sibling.nextSibling;}
this._selectElement.selectedIndex=previousSiblingCount;}
_selectElementMouseOver(event)
{if(typeof this.mouseOver==="function")
this.mouseOver();}
_selectElementMouseOut(event)
{if(typeof this.mouseOut==="function")
this.mouseOut();}
_selectElementMouseDown(event)
{this._updateSelectElement();if(this._selectElement.options.length===1){event.preventDefault();this._selectElementSelectionChanged();}}
_selectElementMouseUp(event)
{this.dispatchEventToListeners(WI.HierarchicalPathComponent.Event.Clicked,{pathComponent:this.selectedPathComponent});}
_selectElementSelectionChanged(event)
{this.dispatchEventToListeners(WI.HierarchicalPathComponent.Event.SiblingWasSelected,{pathComponent:this.selectedPathComponent});}};WI.HierarchicalPathComponent.MinimumWidth=32;WI.HierarchicalPathComponent.MinimumWidthCollapsed=24;WI.HierarchicalPathComponent.MinimumWidthForOneCharacterTruncatedTitle=54;WI.HierarchicalPathComponent.SelectorArrowsWidth=12;WI.HierarchicalPathComponent.Event={SiblingWasSelected:"hierarchical-path-component-sibling-was-selected",Clicked:"hierarchical-path-component-clicked"};WI.NavigationItem=class NavigationItem extends WI.Object
{constructor(identifier,role,label)
{super();this._identifier=identifier||null;this._element=document.createElement("div");this._hidden=false;this._parentNavigationBar=null;this._visibilityPriority=WI.NavigationItem.VisibilityPriority.Normal;this._cachedWidth=NaN;if(label)
this._element.setAttribute("aria-label",label);this._element.classList.add(...this._classNames);this._element.role=role;this._element.navigationItem=this;}
get identifier(){return this._identifier;}
get element(){return this._element;}
get minimumWidth(){return this.width;}
get parentNavigationBar(){return this._parentNavigationBar;}
get width()
{if(isNaN(this._cachedWidth))
this._cachedWidth=this._element.realOffsetWidth+this.totalMargin;return this._cachedWidth;}
get visibilityPriority(){return this._visibilityPriority;}
set visibilityPriority(priority){this._visibilityPriority=priority;}
update(options={})
{this._cachedWidth=NaN;}
get hidden()
{return this._hidden;}
set hidden(flag)
{if(this._hidden===flag)
return;this._hidden=flag;this._element.classList.toggle("hidden",flag);if(this._parentNavigationBar)
this._parentNavigationBar.needsLayout();}
get tooltip()
{return this.element.title;}
set tooltip(x)
{this.element.title=x;}
get totalMargin()
{return 0;}
didAttach(navigationBar)
{this._parentNavigationBar=navigationBar;}
didDetach()
{this._cachedWidth=NaN;this._parentNavigationBar=null;}
get _classNames()
{var classNames=["item"];if(this._identifier)
classNames.push(this._identifier);if(Array.isArray(this.additionalClassNames))
classNames.pushAll(this.additionalClassNames);return classNames;}};WI.NavigationItem.VisibilityPriority={Low:-100,Normal:0,High:100,};WI.Popover=class Popover extends WI.Object
{constructor(delegate)
{super();this.delegate=delegate;this._edge=null;this._frame=new WI.Rect;this._content=null;this._targetFrame=new WI.Rect;this._anchorPoint=new WI.Point;this._preferredEdges=null;this._resizeHandler=null;this._contentNeedsUpdate=false;this._dismissing=false;this._element=document.createElement("div");this._element.className="popover";this._element.addEventListener("transitionend",this,true);this._container=this._element.appendChild(document.createElement("div"));this._container.className="container";this._drawBackgroundAnimationIdentifier=undefined;}
get element(){return this._element;}
get visible()
{return this._element.parentNode===document.body&&!this._element.classList.contains(WI.Popover.FadeOutClassName);}
get frame()
{return this._frame;}
set frame(frame)
{this._element.style.left=frame.minX()+"px";this._element.style.top=frame.minY()+"px";this._element.style.width=frame.size.width+"px";this._element.style.height=frame.size.height+"px";this._element.style.backgroundSize=frame.size.width+"px "+frame.size.height+"px";this._frame=frame;}
set content(content)
{if(content===this._content)
return;this._content=content;this._contentNeedsUpdate=true;if(this.visible)
this._update(true);}
set windowResizeHandler(resizeHandler)
{this._resizeHandler=resizeHandler;}
resize()
{if(this.visible&&this._resizeHandler)
this._resizeHandler();}
update(shouldAnimate=true)
{if(!this.visible)
return;var previouslyFocusedElement=document.activeElement;this._contentNeedsUpdate=true;this._update(shouldAnimate);if(previouslyFocusedElement)
previouslyFocusedElement.focus();}
present(targetFrame,preferredEdges)
{this._targetFrame=targetFrame;this._preferredEdges=preferredEdges;if(!this._content)
return;this._addListenersIfNeeded();this._update();}
presentNewContentWithFrame(content,targetFrame,preferredEdges)
{this._content=content;this._contentNeedsUpdate=true;this._targetFrame=targetFrame;this._preferredEdges=preferredEdges;this._addListenersIfNeeded();var shouldAnimate=this.visible;this._update(shouldAnimate);}
dismiss()
{if(this._dismissing||this._element.parentNode!==document.body)
return;this._dismissing=true;this._isListeningForPopoverEvents=false;window.removeEventListener("mousedown",this,true);window.removeEventListener("scroll",this,true);window.removeEventListener("resize",this,true);window.removeEventListener("keypress",this,true);this._prefersDarkColorSchemeMediaQueryList.removeListener(this._boundUpdate);WI.quickConsole.keyboardShortcutDisabled=false;this._element.classList.add(WI.Popover.FadeOutClassName);if(this.delegate&&typeof this.delegate.willDismissPopover==="function")
this.delegate.willDismissPopover(this);}
handleEvent(event)
{switch(event.type){case"mousedown":case"scroll":if(!this._element.contains(event.target)&&!event.target.closest("."+WI.Popover.IgnoreAutoDismissClassName)&&!event[WI.Popover.EventPreventDismissSymbol]){this.dismiss();}
break;case"resize":this.resize();break;case"keypress":if(event.keyCode===WI.KeyboardShortcut.Key.Escape.keyCode)
this.dismiss();break;case"transitionend":if(event.target===this._element){document.body.removeChild(this._element);this._element.classList.remove(WI.Popover.FadeOutClassName);this._container.textContent="";if(this.delegate&&typeof this.delegate.didDismissPopover==="function")
this.delegate.didDismissPopover(this);this._dismissing=false;break;}
break;}}
_update(shouldAnimate)
{if(shouldAnimate)
var previousEdge=this._edge;var targetFrame=this._targetFrame;var preferredEdges=this._preferredEdges;if(this._element.parentNode!==document.body)
document.body.appendChild(this._element);else
this._element.classList.remove(WI.Popover.FadeOutClassName);this._dismissing=false;if(this._edge!==null)
this._element.classList.remove(this._cssClassNameForEdge());if(this._contentNeedsUpdate){this._element.style.removeProperty("left");this._element.style.removeProperty("top");this._element.style.removeProperty("width");this._element.style.removeProperty("height");this._container.replaceWith(this._content);var popoverBounds=this._element.getBoundingClientRect();this._preferredSize=new WI.Size(Math.ceil(popoverBounds.width),Math.ceil(popoverBounds.height));}
var titleBarOffset=WI.undockedTitleAreaHeight();var containerFrame=new WI.Rect(0,titleBarOffset,window.innerWidth,window.innerHeight-titleBarOffset);containerFrame=containerFrame.inset(WI.Popover.ShadowEdgeInsets);var metrics=new Array(preferredEdges.length);for(var edgeName in WI.RectEdge){var edge=WI.RectEdge[edgeName];var item={edge,metrics:this._bestMetricsForEdge(this._preferredSize,targetFrame,containerFrame,edge)};var preferredIndex=preferredEdges.indexOf(edge);if(preferredIndex!==-1)
metrics[preferredIndex]=item;else
metrics.push(item);}
function area(size)
{return Math.max(0,size.width)*Math.max(0,size.height);}
var bestEdge=metrics[0].edge;var bestMetrics=metrics[0].metrics;for(var i=1;i<metrics.length;i++){var itemMetrics=metrics[i].metrics;if(area(itemMetrics.contentSize)>area(bestMetrics.contentSize)){bestEdge=metrics[i].edge;bestMetrics=itemMetrics;}}
var anchorPoint;var bestFrame=bestMetrics.frame.round();this._edge=bestEdge;if(bestFrame===WI.Rect.ZERO_RECT){this.dismiss();}else{switch(bestEdge){case WI.RectEdge.MIN_X:anchorPoint=new WI.Point(bestFrame.size.width-WI.Popover.ShadowPadding,targetFrame.midY()-bestFrame.minY());break;case WI.RectEdge.MAX_X:anchorPoint=new WI.Point(WI.Popover.ShadowPadding,targetFrame.midY()-bestFrame.minY());break;case WI.RectEdge.MIN_Y:anchorPoint=new WI.Point(targetFrame.midX()-bestFrame.minX(),bestFrame.size.height-WI.Popover.ShadowPadding);break;case WI.RectEdge.MAX_Y:anchorPoint=new WI.Point(targetFrame.midX()-bestFrame.minX(),WI.Popover.ShadowPadding);break;}
this._element.classList.add(this._cssClassNameForEdge());if(shouldAnimate&&this._edge===previousEdge)
this._animateFrame(bestFrame,anchorPoint);else{this.frame=bestFrame;this._setAnchorPoint(anchorPoint);this._drawBackground();}
if(this._preferredSize.width<WI.Popover.MinWidth||this._preferredSize.height<WI.Popover.MinHeight)
this._container.classList.add("center");else
this._container.classList.remove("center");}
if(this._contentNeedsUpdate){this._container.textContent="";this._content.replaceWith(this._container);this._container.appendChild(this._content);}
this._contentNeedsUpdate=false;}
_cssClassNameForEdge()
{switch(this._edge){case WI.RectEdge.MIN_X:return"arrow-right";case WI.RectEdge.MAX_X:return"arrow-left";case WI.RectEdge.MIN_Y:return"arrow-down";case WI.RectEdge.MAX_Y:return"arrow-up";}
console.error("Unknown edge.");return"arrow-up";}
_setAnchorPoint(anchorPoint)
{anchorPoint.x=Math.floor(anchorPoint.x);anchorPoint.y=Math.floor(anchorPoint.y);this._anchorPoint=anchorPoint;}
_animateFrame(toFrame,toAnchor)
{var startTime=Date.now();var duration=350;var epsilon=1/(200*duration);var spline=new WI.CubicBezier(0.25,0.1,0.25,1);var fromFrame=this._frame.copy();var fromAnchor=this._anchorPoint.copy();function animatedValue(from,to,progress)
{return from+(to-from)*progress;}
function drawBackground()
{var progress=spline.solve(Math.min((Date.now()-startTime)/duration,1),epsilon);this.frame=new WI.Rect(animatedValue(fromFrame.minX(),toFrame.minX(),progress),animatedValue(fromFrame.minY(),toFrame.minY(),progress),animatedValue(fromFrame.size.width,toFrame.size.width,progress),animatedValue(fromFrame.size.height,toFrame.size.height,progress)).round();this._setAnchorPoint(new WI.Point(animatedValue(fromAnchor.x,toAnchor.x,progress),animatedValue(fromAnchor.y,toAnchor.y,progress)));this._drawBackground();if(progress<1)
this._drawBackgroundAnimationIdentifier=requestAnimationFrame(drawBackground.bind(this));}
drawBackground.call(this);}
_drawBackground()
{if(this._drawBackgroundAnimationIdentifier){cancelAnimationFrame(this._drawBackgroundAnimationIdentifier);this._drawBackgroundAnimationIdentifier=undefined;}
let scaleFactor=window.devicePixelRatio;let width=this._frame.size.width;let height=this._frame.size.height;let scaledWidth=width*scaleFactor;let scaledHeight=height*scaleFactor;let bounds;switch(this._edge){case WI.RectEdge.MIN_X:bounds=new WI.Rect(0,0,width-WI.Popover.AnchorSize,height);break;case WI.RectEdge.MAX_X:bounds=new WI.Rect(WI.Popover.AnchorSize,0,width-WI.Popover.AnchorSize,height);break;case WI.RectEdge.MIN_Y:bounds=new WI.Rect(0,0,width,height-WI.Popover.AnchorSize);break;case WI.RectEdge.MAX_Y:bounds=new WI.Rect(0,WI.Popover.AnchorSize,width,height-WI.Popover.AnchorSize);break;}
bounds=bounds.inset(WI.Popover.ShadowEdgeInsets);let computedStyle=window.getComputedStyle(this._element,null);let context=document.getCSSCanvasContext("2d","popover",scaledWidth,scaledHeight);context.clearRect(0,0,scaledWidth,scaledHeight);function isolate(callback){context.save();callback();context.restore();}
isolate(()=>{context.scale(scaleFactor,scaleFactor);this._drawFrame(context,bounds,this._edge,this._anchorPoint);isolate(()=>{context.shadowBlur=4;context.shadowColor=computedStyle.getPropertyValue("--popover-shadow-color").trim();context.strokeStyle=computedStyle.getPropertyValue("--popover-border-color").trim();context.lineWidth=2;context.stroke();});isolate(()=>{context.fillStyle=computedStyle.getPropertyValue("--popover-background-color").trim();context.fill();});});}
_bestMetricsForEdge(preferredSize,targetFrame,containerFrame,edge)
{var x,y;var width=preferredSize.width+(WI.Popover.ShadowPadding*2)+(WI.Popover.ContentPadding*2);var height=preferredSize.height+(WI.Popover.ShadowPadding*2)+(WI.Popover.ContentPadding*2);switch(edge){case WI.RectEdge.MIN_X:width+=WI.Popover.AnchorSize;x=targetFrame.origin.x-width+WI.Popover.ShadowPadding;y=targetFrame.origin.y-(height-targetFrame.size.height)/2;break;case WI.RectEdge.MAX_X:width+=WI.Popover.AnchorSize;x=targetFrame.origin.x+targetFrame.size.width-WI.Popover.ShadowPadding;y=targetFrame.origin.y-(height-targetFrame.size.height)/2;break;case WI.RectEdge.MIN_Y:height+=WI.Popover.AnchorSize;x=targetFrame.origin.x-(width-targetFrame.size.width)/2;y=targetFrame.origin.y-height+WI.Popover.ShadowPadding;break;case WI.RectEdge.MAX_Y:height+=WI.Popover.AnchorSize;x=targetFrame.origin.x-(width-targetFrame.size.width)/2;y=targetFrame.origin.y+targetFrame.size.height-WI.Popover.ShadowPadding;break;}
if(edge!==WI.RectEdge.MIN_X&&x<containerFrame.minX())
x=containerFrame.minX();if(edge!==WI.RectEdge.MAX_X&&x+width>containerFrame.maxX())
x=containerFrame.maxX()-width;if(edge!==WI.RectEdge.MIN_Y&&y<containerFrame.minY())
y=containerFrame.minY();if(edge!==WI.RectEdge.MAX_Y&&y+height>containerFrame.maxY())
y=containerFrame.maxY()-height;var preferredFrame=new WI.Rect(x,y,width,height);var bestFrame=preferredFrame.intersectionWithRect(containerFrame);width=bestFrame.size.width-(WI.Popover.ShadowPadding*2);height=bestFrame.size.height-(WI.Popover.ShadowPadding*2);switch(edge){case WI.RectEdge.MIN_X:case WI.RectEdge.MAX_X:width-=WI.Popover.AnchorSize;break;case WI.RectEdge.MIN_Y:case WI.RectEdge.MAX_Y:height-=WI.Popover.AnchorSize;break;}
return{frame:bestFrame,contentSize:new WI.Size(width,height)};}
_drawFrame(ctx,bounds,anchorEdge)
{let cornerRadius=WI.Popover.CornerRadius;let anchorPoint=this._anchorPoint;let arrowPadding=cornerRadius+WI.Popover.AnchorSize;if(anchorEdge===WI.RectEdge.MIN_Y||anchorEdge===WI.RectEdge.MAX_Y)
anchorPoint.x=Number.constrain(anchorPoint.x,bounds.minX()+arrowPadding,bounds.maxX()-arrowPadding);else
anchorPoint.y=Number.constrain(anchorPoint.y,bounds.minY()+arrowPadding,bounds.maxY()-arrowPadding);ctx.beginPath();switch(anchorEdge){case WI.RectEdge.MIN_X:ctx.moveTo(bounds.maxX(),bounds.minY()+cornerRadius);ctx.lineTo(bounds.maxX(),anchorPoint.y-WI.Popover.AnchorSize);ctx.lineTo(anchorPoint.x,anchorPoint.y);ctx.lineTo(bounds.maxX(),anchorPoint.y+WI.Popover.AnchorSize);ctx.arcTo(bounds.maxX(),bounds.maxY(),bounds.minX(),bounds.maxY(),cornerRadius);ctx.arcTo(bounds.minX(),bounds.maxY(),bounds.minX(),bounds.minY(),cornerRadius);ctx.arcTo(bounds.minX(),bounds.minY(),bounds.maxX(),bounds.minY(),cornerRadius);ctx.arcTo(bounds.maxX(),bounds.minY(),bounds.maxX(),bounds.maxY(),cornerRadius);break;case WI.RectEdge.MAX_X:ctx.moveTo(bounds.minX(),bounds.maxY()-cornerRadius);ctx.lineTo(bounds.minX(),anchorPoint.y+WI.Popover.AnchorSize);ctx.lineTo(anchorPoint.x,anchorPoint.y);ctx.lineTo(bounds.minX(),anchorPoint.y-WI.Popover.AnchorSize);ctx.arcTo(bounds.minX(),bounds.minY(),bounds.maxX(),bounds.minY(),cornerRadius);ctx.arcTo(bounds.maxX(),bounds.minY(),bounds.maxX(),bounds.maxY(),cornerRadius);ctx.arcTo(bounds.maxX(),bounds.maxY(),bounds.minX(),bounds.maxY(),cornerRadius);ctx.arcTo(bounds.minX(),bounds.maxY(),bounds.minX(),bounds.minY(),cornerRadius);break;case WI.RectEdge.MIN_Y:ctx.moveTo(bounds.maxX()-cornerRadius,bounds.maxY());ctx.lineTo(anchorPoint.x+WI.Popover.AnchorSize,bounds.maxY());ctx.lineTo(anchorPoint.x,anchorPoint.y);ctx.lineTo(anchorPoint.x-WI.Popover.AnchorSize,bounds.maxY());ctx.arcTo(bounds.minX(),bounds.maxY(),bounds.minX(),bounds.minY(),cornerRadius);ctx.arcTo(bounds.minX(),bounds.minY(),bounds.maxX(),bounds.minY(),cornerRadius);ctx.arcTo(bounds.maxX(),bounds.minY(),bounds.maxX(),bounds.maxY(),cornerRadius);ctx.arcTo(bounds.maxX(),bounds.maxY(),bounds.minX(),bounds.maxY(),cornerRadius);break;case WI.RectEdge.MAX_Y:ctx.moveTo(bounds.minX()+cornerRadius,bounds.minY());ctx.lineTo(anchorPoint.x-WI.Popover.AnchorSize,bounds.minY());ctx.lineTo(anchorPoint.x,anchorPoint.y);ctx.lineTo(anchorPoint.x+WI.Popover.AnchorSize,bounds.minY());ctx.arcTo(bounds.maxX(),bounds.minY(),bounds.maxX(),bounds.maxY(),cornerRadius);ctx.arcTo(bounds.maxX(),bounds.maxY(),bounds.minX(),bounds.maxY(),cornerRadius);ctx.arcTo(bounds.minX(),bounds.maxY(),bounds.minX(),bounds.minY(),cornerRadius);ctx.arcTo(bounds.minX(),bounds.minY(),bounds.maxX(),bounds.minY(),cornerRadius);break;}
ctx.closePath();}
_addListenersIfNeeded()
{if(!this._isListeningForPopoverEvents){this._isListeningForPopoverEvents=true;window.addEventListener("mousedown",this,true);window.addEventListener("scroll",this,true);window.addEventListener("resize",this,true);window.addEventListener("keypress",this,true);if(!this._boundUpdate)
this._boundUpdate=this._update.bind(this);if(!this._prefersDarkColorSchemeMediaQueryList)
this._prefersDarkColorSchemeMediaQueryList=window.matchMedia("(prefers-color-scheme: dark)");this._prefersDarkColorSchemeMediaQueryList.addListener(this._boundUpdate);WI.quickConsole.keyboardShortcutDisabled=true;}}};WI.Popover.FadeOutClassName="fade-out";WI.Popover.CornerRadius=5;WI.Popover.MinWidth=40;WI.Popover.MinHeight=40;WI.Popover.ShadowPadding=5;WI.Popover.ContentPadding=5;WI.Popover.AnchorSize=11;WI.Popover.ShadowEdgeInsets=new WI.EdgeInsets(WI.Popover.ShadowPadding);WI.Popover.IgnoreAutoDismissClassName="popover-ignore-auto-dismiss";WI.Popover.EventPreventDismissSymbol=Symbol("popover-event-prevent-dismiss");WI.Sidebar=class Sidebar extends WI.View
{constructor(element,side,label)
{super(element);this._side=side;this._collapsed=true;this._collapsable=true;this.element.classList.add("sidebar",this._side,WI.Sidebar.CollapsedStyleClassName);this.element.setAttribute("role","group");if(label)
this.element.setAttribute("aria-label",label);this._sidebarPanels=[];this._selectedSidebarPanel=null;}
get sidebarPanels(){return this._sidebarPanels;}
get side(){return this._side;}
addSidebarPanel(sidebarPanel)
{this.insertSidebarPanel(sidebarPanel,this.sidebarPanels.length);}
insertSidebarPanel(sidebarPanel,index)
{if(!(sidebarPanel instanceof WI.SidebarPanel))
return;if(!this.shouldInsertSidebarPanel(sidebarPanel,index))
return;this._sidebarPanels.splice(index,0,sidebarPanel);this.didInsertSidebarPanel(sidebarPanel,index);}
removeSidebarPanel(sidebarPanelOrIdentifierOrIndex)
{let sidebarPanel=this._findSidebarPanel(sidebarPanelOrIdentifierOrIndex);if(!sidebarPanel)
return;this._sidebarPanels.remove(sidebarPanel);if(this.selectedSidebarPanel===sidebarPanel)
this.selectedSidebarPanel=0;this.didRemoveSidebarPanel(sidebarPanel);}
get selectedSidebarPanel()
{return this._selectedSidebarPanel;}
set selectedSidebarPanel(sidebarPanelOrIdentifierOrIndex)
{let sidebarPanel=this._findSidebarPanel(sidebarPanelOrIdentifierOrIndex);if(!sidebarPanel)
sidebarPanel=this._findSidebarPanel(0);if(this._selectedSidebarPanel===sidebarPanel)
return;this.willSetSelectedSidebarPanel(sidebarPanel);this._selectedSidebarPanel=sidebarPanel;this.didSetSelectedSidebarPanel(sidebarPanel);this.dispatchEventToListeners(WI.Sidebar.Event.SidebarPanelSelected);}
get collapsed()
{return this._collapsed;}
set collapsed(flag)
{if(flag===this._collapsed)
return;if(flag&&!this._collapsable)
return;this._collapsed=flag||false;this.element.classList.toggle(WI.Sidebar.CollapsedStyleClassName);this.didSetCollapsed();this.dispatchEventToListeners(WI.Sidebar.Event.CollapsedStateDidChange);}
get collapsable()
{return this._collapsable;}
set collapsable(allow){if(allow===this._collapsable)
return;this._collapsable=!!allow;if(!allow&&this.collapsed)
this.collapsed=false;}
get minimumWidth()
{let minimumWidth=WI.Sidebar.AbsoluteMinimumWidth;if(this.selectedSidebarPanel)
minimumWidth=Math.max(minimumWidth,this.selectedSidebarPanel.minimumWidth);return minimumWidth;}
get maximumWidth()
{return WI.getMaximumSidebarWidth(this);}
shouldInsertSidebarPanel(sidebarPanel,index)
{return true;}
didInsertSidebarPanel(sidebarPanel,index)
{}
didRemoveSidebarPanel(sidebarPanel)
{}
willSetSelectedSidebarPanel(sidebarPanel)
{}
didSetSelectedSidebarPanel(sidebarPanel)
{}
didSetCollapsed(flag)
{}
_findSidebarPanel(sidebarPanelOrIdentifierOrIndex)
{let sidebarPanel=null;if(sidebarPanelOrIdentifierOrIndex instanceof WI.SidebarPanel){if(this._sidebarPanels.includes(sidebarPanelOrIdentifierOrIndex))
sidebarPanel=sidebarPanelOrIdentifierOrIndex;}else if(typeof sidebarPanelOrIdentifierOrIndex==="number"){sidebarPanel=this._sidebarPanels[sidebarPanelOrIdentifierOrIndex];}else if(typeof sidebarPanelOrIdentifierOrIndex==="string"){sidebarPanel=this._sidebarPanels.find((existingSidebarPanel)=>existingSidebarPanel.identifier===sidebarPanelOrIdentifierOrIndex)||null;}
return sidebarPanel;}};WI.Sidebar.CollapsedStyleClassName="collapsed";WI.Sidebar.AbsoluteMinimumWidth=250;WI.Sidebar.Sides={Leading:"leading",Trailing:"trailing",};WI.Sidebar.Event={SidebarPanelSelected:"sidebar-panel-selected",CollapsedStateDidChange:"sidebar-collapsed-state-did-change",WidthDidChange:"sidebar-width-did-change",};WI.SidebarPanel=class SidebarPanel extends WI.View
{constructor(identifier,displayName)
{super();this._identifier=identifier;this._displayName=displayName;this._selected=false;this._exclusive=false;this._savedScrollPosition=0;this.element.classList.add("panel",identifier);this.element.setAttribute("role","group");this.element.setAttribute("aria-label",displayName);this._contentView=new WI.View;this._contentView.element.classList.add("content");this.addSubview(this._contentView);}
get identifier()
{return this._identifier;}
get contentView()
{return this._contentView;}
get displayName()
{return this._displayName;}
get visible()
{return this.selected&&this.parentSidebar&&!this.parentSidebar.collapsed;}
get selected()
{return this._selected;}
set selected(flag)
{if(flag===this._selected)
return;this._selected=flag||false;this.element.classList.toggle("selected",this._selected);}
get parentSidebar()
{return this.parentView;}
get minimumWidth()
{return 0;}
get exclusive()
{return this._exclusive;}
set exclusive(exclusive)
{if(exclusive===this._exclusive)
return;this._exclusive=!!exclusive;this.element.classList.toggle("exclusive-presentation",this._exclusive);}
get allowExclusivePresentation()
{return false;}
attached()
{super.attached();this.scrollElement.scrollTop=this._savedScrollPosition;}
detached()
{this._savedScrollPosition=this.scrollElement.scrollTop;super.detached();}
get scrollElement()
{return this.contentView.element;}};WI.TabBar=class TabBar extends WI.View
{constructor(element)
{super(element);this.element.classList.add("tab-bar");this.element.addEventListener("mousedown",this._handleMouseDown.bind(this));this.element.createChild("div","border top");const navigationBarBeforeElement=null;this._navigationBarBefore=new WI.NavigationBar(navigationBarBeforeElement,{sizesToFit:true});this.addSubview(this._navigationBarBefore);this._tabContainer=this.element.appendChild(document.createElement("div"));this._tabContainer.className="tabs";this._tabContainer.setAttribute("role","tablist");this._tabContainer.addEventListener("mousedown",this._handleTabContainerMouseDown.bind(this));this._tabContainer.addEventListener("mouseleave",this._handleTabContainerMouseLeave.bind(this));this._tabContainer.addEventListener("contextmenu",this._handleTabContainerContextMenu.bind(this));const navigationBarAfterElement=null;this._navigationBarAfter=new WI.NavigationBar(navigationBarAfterElement,{sizesToFit:true});this.addSubview(this._navigationBarAfter);this.element.createChild("div","border bottom");this._tabBarItems=[];this._hiddenTabBarItems=[];const showHiddenTabsRepresentedObject=null;const showHiddenTabsDisplayName=null;this._showHiddenTabsTabBarItem=new WI.PinnedTabBarItem(showHiddenTabsRepresentedObject,"Images/Overflow.svg",showHiddenTabsDisplayName,WI.UIString("Show hidden tabs\u2026"));this._showHiddenTabsTabBarItem.hidden=true;this.addTabBarItem(this._showHiddenTabsTabBarItem,{suppressAnimations:true});const openClosedTabsRepresentedObject=null;const openClosedTabsDisplayName=null;this._openClosedTabsTabBarItem=new WI.PinnedTabBarItem(openClosedTabsRepresentedObject,"Images/Plus15.svg",openClosedTabsDisplayName,WI.UIString("Open closed tabs\u2026"));this._openClosedTabsTabBarItem.hidden=true;this.addTabBarItem(this._openClosedTabsTabBarItem,{suppressAnimations:true});this._mouseDownPageX=NaN;this._isDragging=false;}
addNavigationItemBefore(navigationItem)
{this._navigationBarBefore.addNavigationItem(navigationItem);this.needsLayout();}
addNavigationItemAfter(navigationItem)
{this._navigationBarAfter.addNavigationItem(navigationItem);this.needsLayout();}
addTabBarItem(tabBarItem,options={})
{return this.insertTabBarItem(tabBarItem,this._tabBarItems.length,options);}
insertTabBarItem(tabBarItem,index,options={})
{if(!(tabBarItem instanceof WI.TabBarItem))
return null;if(tabBarItem.parentTabBar===this)
return null;if(this._tabAnimatedClosedSinceMouseEnter){this._finishExpandingTabsAfterClose().then(()=>{this.insertTabBarItem(tabBarItem,index,options);});return null;}
if(tabBarItem.parentTabBar)
tabBarItem.parentTabBar.removeTabBarItem(tabBarItem);tabBarItem.parentTabBar=this;if(tabBarItem instanceof WI.GeneralTabBarItem)
index=Number.constrain(index,0,this.normalTabCount);else
index=Number.constrain(index,this.normalTabCount,this._tabBarItems.length);if(this._tabContainer.classList.contains("animating")){requestAnimationFrame(removeStyles.bind(this));options.suppressAnimations=true;}
var beforeTabSizesAndPositions;if(!options.suppressAnimations)
beforeTabSizesAndPositions=this._recordTabBarItemSizesAndPositions();this._tabBarItems.splice(index,0,tabBarItem);let nextSibling=this._tabBarItems[index+1]||this._tabBarItems.lastValue;if(this._tabContainer.contains(nextSibling.element)){if(!(tabBarItem instanceof WI.PinnedTabBarItem)&&nextSibling instanceof WI.PinnedTabBarItem)
this._tabContainer.insertBefore(tabBarItem.element,this._pinnedButtons()[0].element);else
this._tabContainer.insertBefore(tabBarItem.element,nextSibling.element);}else{if(tabBarItem instanceof WI.PinnedTabBarItem)
this._tabContainer.appendChild(tabBarItem.element);else
this._tabContainer.insertBefore(tabBarItem.element,this._pinnedButtons()[0].element);}
tabBarItem.element.style.left=null;tabBarItem.element.style.width=null;function animateTabs()
{this._tabContainer.classList.add("animating");this._tabContainer.classList.add("inserting-tab");this._applyTabBarItemSizesAndPositions(afterTabSizesAndPositions);this._tabContainer.addEventListener("transitionend",removeStylesListener);}
function removeStyles()
{this._tabContainer.classList.remove("static-layout");this._tabContainer.classList.remove("animating");this._tabContainer.classList.remove("inserting-tab");tabBarItem.element.classList.remove("being-inserted");this._clearTabBarItemSizesAndPositions();this._tabContainer.removeEventListener("transitionend",removeStylesListener);}
if(!options.suppressAnimations){var afterTabSizesAndPositions=this._recordTabBarItemSizesAndPositions();this.updateLayout();let tabBarItems=this._tabBarItemsFromLeftToRight();let previousTabBarItem=tabBarItems[tabBarItems.indexOf(tabBarItem)-1]||null;let previousTabBarItemSizeAndPosition=previousTabBarItem?beforeTabSizesAndPositions.get(previousTabBarItem):null;if(previousTabBarItemSizeAndPosition)
beforeTabSizesAndPositions.set(tabBarItem,{left:previousTabBarItemSizeAndPosition.left+previousTabBarItemSizeAndPosition.width,width:0});else
beforeTabSizesAndPositions.set(tabBarItem,{left:0,width:0});this._tabContainer.classList.add("static-layout");tabBarItem.element.classList.add("being-inserted");this._applyTabBarItemSizesAndPositions(beforeTabSizesAndPositions);var removeStylesListener=removeStyles.bind(this);requestAnimationFrame(animateTabs.bind(this));}else
this.needsLayout();this.dispatchEventToListeners(WI.TabBar.Event.TabBarItemAdded,{tabBarItem});return tabBarItem;}
removeTabBarItem(tabBarItemOrIndex,options={})
{let tabBarItem=this._findTabBarItem(tabBarItemOrIndex);if(!tabBarItem||tabBarItem instanceof WI.PinnedTabBarItem)
return null;if(this.normalTabCount===1)
return null;tabBarItem.parentTabBar=null;if(this._selectedTabBarItem===tabBarItem){var index=this._tabBarItems.indexOf(tabBarItem);var nextTabBarItem=this._tabBarItems[index+1];if(!nextTabBarItem||nextTabBarItem instanceof WI.PinnedTabBarItem)
nextTabBarItem=this._tabBarItems[index-1];this.selectedTabBarItem=nextTabBarItem;}
if(this._tabContainer.classList.contains("animating")){requestAnimationFrame(removeStyles.bind(this));options.suppressAnimations=true;}
var beforeTabSizesAndPositions;if(!options.suppressAnimations)
beforeTabSizesAndPositions=this._recordTabBarItemSizesAndPositions();let wasLastNormalTab=this._tabBarItems.indexOf(tabBarItem)===this.normalTabCount-1;this._tabBarItems.remove(tabBarItem);tabBarItem.element.remove();this._openClosedTabsTabBarItem.hidden=!this._closedTabClasses().length;if(!this._hasMoreThanOneNormalTab()||wasLastNormalTab||!options.suppressExpansion){if(!options.suppressAnimations){this._tabAnimatedClosedSinceMouseEnter=true;this._finishExpandingTabsAfterClose(beforeTabSizesAndPositions);}else
this.needsLayout();this.dispatchEventToListeners(WI.TabBar.Event.TabBarItemRemoved,{tabBarItem});return tabBarItem;}
var lastNormalTabBarItem;function animateTabs()
{this._tabContainer.classList.add("animating");this._tabContainer.classList.add("closing-tab");let extraSpaceBetweenNormalAndPinnedTabs=0;if(WI.resolvedLayoutDirection()===WI.LayoutDirection.RTL){extraSpaceBetweenNormalAndPinnedTabs=this._tabContainer.getBoundingClientRect().width;for(let currentTabBarItem of this._tabBarItemsFromLeftToRight())
extraSpaceBetweenNormalAndPinnedTabs-=currentTabBarItem.element.getBoundingClientRect().width;}
let left=0;for(let currentTabBarItem of this._tabBarItemsFromLeftToRight()){let sizeAndPosition=beforeTabSizesAndPositions.get(currentTabBarItem);if(!(currentTabBarItem instanceof WI.PinnedTabBarItem)){currentTabBarItem.element.style.left=extraSpaceBetweenNormalAndPinnedTabs+left+"px";left+=sizeAndPosition.width;lastNormalTabBarItem=currentTabBarItem;}else
left=sizeAndPosition.left+sizeAndPosition.width;}
if(this._selectedTabBarItem)
this._selectedTabBarItem.element.style.width=(parseFloat(this._selectedTabBarItem.element.style.width)+1)+"px";if(lastNormalTabBarItem!==this._selectedTabBarItem)
lastNormalTabBarItem.element.style.width=(parseFloat(lastNormalTabBarItem.element.style.width)+1)+"px";this._tabContainer.addEventListener("transitionend",removeStylesListener);}
function removeStyles()
{if(this._selectedTabBarItem&&this._selectedTabBarItem!==lastNormalTabBarItem)
this._selectedTabBarItem.element.style.width=(parseFloat(this._selectedTabBarItem.element.style.width)-1)+"px";this._tabContainer.classList.remove("animating");this._tabContainer.classList.remove("closing-tab");this.updateLayout();this._tabContainer.removeEventListener("transitionend",removeStylesListener);}
if(!options.suppressAnimations){this._tabContainer.classList.add("static-layout");this._tabAnimatedClosedSinceMouseEnter=true;this._applyTabBarItemSizesAndPositions(beforeTabSizesAndPositions);var removeStylesListener=removeStyles.bind(this);requestAnimationFrame(animateTabs.bind(this));}else
this.needsLayout();this.dispatchEventToListeners(WI.TabBar.Event.TabBarItemRemoved,{tabBarItem});return tabBarItem;}
selectPreviousTab()
{if(this._tabBarItems.length<=1)
return;var startIndex=this._tabBarItems.indexOf(this._selectedTabBarItem);var newIndex=startIndex;do{if(newIndex===0)
newIndex=this._tabBarItems.length-1;else
newIndex--;if(!(this._tabBarItems[newIndex]instanceof WI.PinnedTabBarItem))
break;}while(newIndex!==startIndex);if(newIndex===startIndex)
return;this.selectedTabBarItem=this._tabBarItems[newIndex];}
selectNextTab()
{if(this._tabBarItems.length<=1)
return;var startIndex=this._tabBarItems.indexOf(this._selectedTabBarItem);var newIndex=startIndex;do{if(newIndex===this._tabBarItems.length-1)
newIndex=0;else
newIndex++;if(!(this._tabBarItems[newIndex]instanceof WI.PinnedTabBarItem))
break;}while(newIndex!==startIndex);if(newIndex===startIndex)
return;this.selectedTabBarItem=this._tabBarItems[newIndex];}
get selectedTabBarItem()
{return this._selectedTabBarItem;}
set selectedTabBarItem(tabBarItemOrIndex)
{this.selectTabBarItem(tabBarItemOrIndex);}
selectTabBarItem(tabBarItemOrIndex,options={})
{let tabBarItem=this._findTabBarItem(tabBarItemOrIndex);if(this._pinnedButtons().includes(tabBarItem)){tabBarItem=this._tabBarItems[this.normalTabCount-1];}
if(this._selectedTabBarItem===tabBarItem)
return;let previousTabBarItem=this._selectedTabBarItem;if(this._selectedTabBarItem)
this._selectedTabBarItem.selected=false;this._selectedTabBarItem=tabBarItem||null;if(this._selectedTabBarItem){this._selectedTabBarItem.selected=true;if(this._selectedTabBarItem.hidden)
this.needsLayout();}
let initiatorHint=options.initiatorHint||WI.TabBrowser.TabNavigationInitiator.Unknown;this.dispatchEventToListeners(WI.TabBar.Event.TabBarItemSelected,{previousTabBarItem,initiatorHint});}
get tabBarItems()
{return this._tabBarItems;}
get visibleTabBarItemsFromLeftToRight()
{return this._tabBarItemsFromLeftToRight().filter((item)=>!item.hidden);}
get tabCount()
{return this._tabBarItems.filter((item)=>item.representedObject instanceof WI.TabContentView).length;}
get normalTabCount()
{return this._tabBarItems.filter((item)=>!(item instanceof WI.PinnedTabBarItem)).length;}
resetCachedWidths()
{for(let tabBarItem of this._tabBarItems)
tabBarItem[WI.TabBar.CachedWidthSymbol]=0;}
layout()
{if(this._tabContainer.classList.contains("static-layout"))
return;let undocked=WI.dockConfiguration===WI.DockConfiguration.Undocked;function measureWidth(tabBarItem){if(!tabBarItem[WI.TabBar.CachedWidthSymbol])
tabBarItem[WI.TabBar.CachedWidthSymbol]=tabBarItem.element.realOffsetWidth;return tabBarItem[WI.TabBar.CachedWidthSymbol];}
let availableSpace=this._tabContainer.realOffsetWidth;this._tabContainer.classList.add("calculate-width");this._hiddenTabBarItems=[];let normalTabBarItems=[];for(let tabBarItem of this._tabBarItemsFromLeftToRight()){switch(tabBarItem){case this._showHiddenTabsTabBarItem:tabBarItem.hidden=true;continue;case this._openClosedTabsTabBarItem:tabBarItem.hidden=!this._closedTabClasses().length;if(tabBarItem.hidden)
continue;else
break;}
tabBarItem.hidden=false;if(tabBarItem instanceof WI.PinnedTabBarItem){availableSpace-=measureWidth(tabBarItem);continue;}
normalTabBarItems.push(tabBarItem);if(undocked)
tabBarItem[WI.TabBar.CachedWidthSymbol]=0;}
let normalTabBarItemsWidth=normalTabBarItems.reduce((accumulator,tabBarItem)=>accumulator+measureWidth(tabBarItem),0);if(Math.round(normalTabBarItemsWidth)>=Math.floor(availableSpace)){this._showHiddenTabsTabBarItem.hidden=false;availableSpace-=measureWidth(this._showHiddenTabsTabBarItem);let index=normalTabBarItems.length-1;do{let tabBarItem=normalTabBarItems[index];if(tabBarItem===this._selectedTabBarItem)
continue;normalTabBarItemsWidth-=measureWidth(tabBarItem);tabBarItem.hidden=true;this._hiddenTabBarItems.push(tabBarItem);}while(normalTabBarItemsWidth>=availableSpace&&--index>=0);}
this._hiddenTabBarItems.reverse();this._tabContainer.classList.remove("calculate-width");}
didLayoutSubtree()
{super.didLayoutSubtree();this._tabContainer.classList.toggle("hide-border-start",this._navigationBarBefore.navigationItems.every((item)=>item.hidden));this._tabContainer.classList.toggle("hide-border-end",this._navigationBarAfter.navigationItems.every((item)=>item.hidden));}
_pinnedButtons()
{return[this._showHiddenTabsTabBarItem,this._openClosedTabsTabBarItem];}
_tabBarItemsFromLeftToRight()
{return WI.resolvedLayoutDirection()===WI.LayoutDirection.LTR?this._tabBarItems:this._tabBarItems.slice().reverse();}
_closedTabClasses()
{return Array.from(WI.knownTabClasses()).filter((tabClass)=>WI.isNewTabWithTypeAllowed(tabClass.Type));}
_findTabBarItem(tabBarItemOrIndex)
{if(typeof tabBarItemOrIndex==="number")
return this._tabBarItems[tabBarItemOrIndex]||null;if(tabBarItemOrIndex instanceof WI.TabBarItem){if(this._tabBarItems.includes(tabBarItemOrIndex))
return tabBarItemOrIndex;}
return null;}
_hasMoreThanOneNormalTab()
{let normalTabCount=0;for(let tabBarItem of this._tabBarItems){if(tabBarItem instanceof WI.PinnedTabBarItem)
continue;++normalTabCount;if(normalTabCount>=2)
return true;}
return false;}
_recordTabBarItemSizesAndPositions()
{var tabBarItemSizesAndPositions=new Map;let barRect=this._tabContainer.getBoundingClientRect();for(let tabBarItem of this._tabBarItems){if(tabBarItem.hidden)
continue;let boundingRect=tabBarItem.element.getBoundingClientRect();tabBarItemSizesAndPositions.set(tabBarItem,{left:boundingRect.left-barRect.left,width:boundingRect.width,});}
return tabBarItemSizesAndPositions;}
_applyTabBarItemSizesAndPositions(tabBarItemSizesAndPositions,skipTabBarItem)
{for(var[tabBarItem,sizeAndPosition]of tabBarItemSizesAndPositions){if(skipTabBarItem&&tabBarItem===skipTabBarItem)
continue;tabBarItem.element.style.left=sizeAndPosition.left+"px";tabBarItem.element.style.width=sizeAndPosition.width+"px";}}
_clearTabBarItemSizesAndPositions(skipTabBarItem)
{for(var tabBarItem of this._tabBarItems){if(skipTabBarItem&&tabBarItem===skipTabBarItem)
continue;tabBarItem.element.style.left=null;tabBarItem.element.style.width=null;}}
_finishExpandingTabsAfterClose(beforeTabSizesAndPositions)
{return new Promise(function(resolve,reject){this._tabAnimatedClosedSinceMouseEnter=false;if(!beforeTabSizesAndPositions)
beforeTabSizesAndPositions=this._recordTabBarItemSizesAndPositions();this._tabContainer.classList.remove("static-layout");this._clearTabBarItemSizesAndPositions();var afterTabSizesAndPositions=this._recordTabBarItemSizesAndPositions();this._applyTabBarItemSizesAndPositions(beforeTabSizesAndPositions);this._tabContainer.classList.add("static-layout");function animateTabs()
{this._tabContainer.classList.add("static-layout");this._tabContainer.classList.add("animating");this._tabContainer.classList.add("expanding-tabs");this._applyTabBarItemSizesAndPositions(afterTabSizesAndPositions);this._tabContainer.addEventListener("transitionend",removeStylesListener);}
function removeStyles()
{this._tabContainer.classList.remove("static-layout");this._tabContainer.classList.remove("animating");this._tabContainer.classList.remove("expanding-tabs");this._clearTabBarItemSizesAndPositions();this.updateLayout();this._tabContainer.removeEventListener("transitionend",removeStylesListener);resolve();}
var removeStylesListener=removeStyles.bind(this);requestAnimationFrame(animateTabs.bind(this));}.bind(this));}
_handleMouseDown(event)
{if(event.button!==0||event.ctrlKey)
return;if(event.target!==this.element)
return;switch(WI.dockConfiguration){case WI.DockConfiguration.Bottom:WI.resizeDockedFrameMouseDown(event);break;case WI.DockConfiguration.Undocked:WI.moveUndockedWindowMouseDown(event);break;}}
_handleTabContainerMouseDown(event)
{if(event.button!==0||event.ctrlKey)
return;let itemElement=event.target.closest("."+WI.TabBarItem.StyleClassName);if(!itemElement)
return;let tabBarItem=itemElement[WI.TabBarItem.ElementReferenceSymbol];if(!tabBarItem)
return;if(tabBarItem.disabled)
return;switch(tabBarItem){case this._showHiddenTabsTabBarItem:this._handleShowHiddenTabsTabBarItemMouseDown(event);return;case this._openClosedTabsTabBarItem:this._handleAddClosedTabsTabBarItemMouseDown(event);return;}
this.selectTabBarItem(tabBarItem,{initiatorHint:WI.TabBrowser.TabNavigationInitiator.TabClick});if(tabBarItem instanceof WI.PinnedTabBarItem||!this._hasMoreThanOneNormalTab())
return;this._firstNormalTabItemIndex=0;for(let i=0;i<this._tabBarItems.length;++i){if(this._tabBarItems[i]instanceof WI.PinnedTabBarItem)
continue;this._firstNormalTabItemIndex=i;break;}
this._mouseDownPageX=event.pageX;this._mouseMovedEventListener=this._handleMouseMoved.bind(this);this._mouseUpEventListener=this._handleMouseUp.bind(this);document.addEventListener("mousemove",this._mouseMovedEventListener,true);document.addEventListener("mouseup",this._mouseUpEventListener,true);event.preventDefault();event.stopPropagation();}
_handleShowHiddenTabsTabBarItemMouseDown(event)
{if(!this._hiddenTabBarItems.length)
return;if(this._ignoreShowHiddenTabsTabBarItemMouseDown)
return;this._ignoreShowHiddenTabsTabBarItemMouseDown=true;let contextMenu=WI.ContextMenu.createFromEvent(event);contextMenu.addBeforeShowCallback(()=>{this._ignoreShowHiddenTabsTabBarItemMouseDown=false;});for(let item of this._hiddenTabBarItems){contextMenu.appendItem(item.displayName,()=>{this.selectTabBarItem(item,{initiator:WI.TabBrowser.TabNavigationInitiator.ContextMenu});});}
contextMenu.show();}
_handleAddClosedTabsTabBarItemMouseDown(event)
{let closedTabClasses=this._closedTabClasses();if(!closedTabClasses.length)
return;if(this._ignoreAddClosedTabsTabBarItemMouseDown)
return;this._ignoreAddClosedTabsTabBarItemMouseDown=true;let contextMenu=WI.ContextMenu.createFromEvent(event);contextMenu.addBeforeShowCallback(()=>{this._ignoreAddClosedTabsTabBarItemMouseDown=false;});for(let closedTabClass of closedTabClasses){if(!closedTabClass.shouldSaveTab())
continue;contextMenu.appendItem(closedTabClass.tabInfo().displayName,()=>{WI.createNewTabWithType(closedTabClass.Type,{shouldShowNewTab:true});});}
WI.sharedApp.extensionController.addContextMenuItemsForClosedExtensionTabs(contextMenu);contextMenu.show();}
_handleMouseMoved(event)
{if(isNaN(this._mouseDownPageX))
return;if(!this._selectedTabBarItem)
return;if(this._mouseOffset===undefined)
this._mouseOffset=event.pageX-this._selectedTabBarItem.element.totalOffsetLeft;if(!this._isDragging){const dragThreshold=12;if(Math.abs(this._mouseDownPageX-event.pageX)<dragThreshold)
return;this._isDragging=true;}
event.preventDefault();event.stopPropagation();if(!this._tabContainer.classList.contains("static-layout")){this._applyTabBarItemSizesAndPositions(this._recordTabBarItemSizesAndPositions());this._tabContainer.classList.add("static-layout");this._tabContainer.classList.add("dragging-tab");}
let containerOffset=this._tabContainer.totalOffsetLeft;let tabBarMouseOffset=event.pageX-containerOffset;var newLeft=tabBarMouseOffset-this._mouseOffset;this._selectedTabBarItem.element.style.left=newLeft+"px";let selectedTabMidX=containerOffset+newLeft+(this._selectedTabBarItem.element.realOffsetWidth/2);var currentIndex=this._tabBarItems.indexOf(this._selectedTabBarItem);var newIndex=currentIndex;for(let tabBarItem of this._tabBarItems){if(tabBarItem.hidden)
continue;if(tabBarItem===this._selectedTabBarItem)
continue;var tabBarItemRect=tabBarItem.element.getBoundingClientRect();if(selectedTabMidX<tabBarItemRect.left||selectedTabMidX>tabBarItemRect.right)
continue;newIndex=this._tabBarItems.indexOf(tabBarItem);break;}
newIndex=Number.constrain(newIndex,this._firstNormalTabItemIndex,this.normalTabCount-1);if(currentIndex===newIndex)
return;this._tabBarItems.splice(currentIndex,1);this._tabBarItems.splice(newIndex,0,this._selectedTabBarItem);let nextSibling=this._tabBarItems[newIndex+1];let nextSiblingElement=nextSibling?nextSibling.element:null;this._tabContainer.insertBefore(this._selectedTabBarItem.element,nextSiblingElement);function inlineStyleValue(element,property){return element.getComputedCSSPropertyNumberValue(property)||0;}
let accumulatedLeft=0;for(let tabBarItem of this._tabBarItemsFromLeftToRight()){if(tabBarItem.hidden)
continue;if(tabBarItem!==this._selectedTabBarItem&&inlineStyleValue(tabBarItem.element,"left")!==accumulatedLeft)
tabBarItem.element.style.left=accumulatedLeft+"px";accumulatedLeft+=inlineStyleValue(tabBarItem.element,"width");}}
_handleMouseUp(event)
{if(isNaN(this._mouseDownPageX))
return;this._tabContainer.classList.remove("dragging-tab");if(!this._tabAnimatedClosedSinceMouseEnter){this._tabContainer.classList.remove("static-layout");this._clearTabBarItemSizesAndPositions();}else{let left=0;for(let tabBarItem of this._tabBarItemsFromLeftToRight()){if(tabBarItem===this._selectedTabBarItem)
tabBarItem.element.style.left=left+"px";left+=parseFloat(tabBarItem.element.style.width);}}
this._isDragging=false;this._mouseDownPageX=NaN;this._mouseOffset=undefined;document.removeEventListener("mousemove",this._mouseMovedEventListener,true);document.removeEventListener("mouseup",this._mouseUpEventListener,true);this._mouseMovedEventListener=null;this._mouseUpEventListener=null;event.preventDefault();event.stopPropagation();this.dispatchEventToListeners(WI.TabBar.Event.TabBarItemsReordered);}
_handleTabContainerMouseLeave(event)
{if(!isNaN(this._mouseDownPageX)||!this._tabAnimatedClosedSinceMouseEnter||!this._tabContainer.classList.contains("static-layout")||this._tabContainer.classList.contains("animating"))
return;let barRect=this._tabContainer.getBoundingClientRect();if(event.pageY>barRect.top&&event.pageY<barRect.bottom&&event.pageX>barRect.left&&event.pageX<barRect.right)
return;this._finishExpandingTabsAfterClose();}
_handleTabContainerContextMenu(event)
{let contextMenu=WI.ContextMenu.createFromEvent(event);for(let tabClass of WI.knownTabClasses()){if(!tabClass.isTabAllowed()||!tabClass.shouldSaveTab())
continue;let openTabBarItem=null;for(let tabBarItem of this._tabBarItems){let tabContentView=tabBarItem.representedObject;if(!(tabContentView instanceof WI.TabContentView))
continue;if(tabContentView.type===tabClass.Type){openTabBarItem=tabBarItem;break;}}
let checked=!!openTabBarItem;let disabled=checked&&this.normalTabCount===1;contextMenu.appendCheckboxItem(tabClass.tabInfo().displayName,()=>{if(openTabBarItem)
this.removeTabBarItem(openTabBarItem);else
WI.createNewTabWithType(tabClass.Type,{shouldShowNewTab:true});},checked,disabled);}
WI.sharedApp.extensionController.addContextMenuItemsForAllExtensionTabs(contextMenu);}};WI.TabBar.CachedWidthSymbol=Symbol("cached-width");WI.TabBar.Event={TabBarItemSelected:"tab-bar-tab-bar-item-selected",TabBarItemAdded:"tab-bar-tab-bar-item-added",TabBarItemRemoved:"tab-bar-tab-bar-item-removed",TabBarItemsReordered:"tab-bar-tab-bar-items-reordered",};WI.TabBarItem=class TabBarItem
{constructor