/*
 * THIS FILE WAS AUTOMATICALLY GENERATED, DO NOT EDIT.
 *
 * This file was generated by the dom/make_names.pl script.
 *
 * Copyright (C) 2005, 2006, 2007, 2008, 2009, 2013 Apple Inc.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY APPLE INC. ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL APPLE INC. OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY
 * OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#pragma once

#include <wtf/EnumeratedArray.h>
#include <wtf/NeverDestroyed.h>
#include <wtf/text/AtomString.h>

namespace WebCore {

class QualifiedName;

enum class TagName : uint16_t {
    Unknown,

    // HTML
    abbr,
    acronym,
    address,
    applet,
    area,
    article,
    aside,
    attachment,
    audio,
    b,
    base,
    basefont,
    bdi,
    bdo,
    bgsound,
    big,
    blockquote,
    body,
    br,
    button,
    canvas,
    caption,
    center,
    cite,
    code,
    col,
    colgroup,
    color_profile,
    data,
    datalist,
    dd,
    del,
    details,
    dfn,
    dialog,
    dir,
    div,
    dl,
    dt,
    em,
    embed,
    fieldset,
    figcaption,
    figure,
    footer,
    form,
    frame,
    frameset,
    h1,
    h2,
    h3,
    h4,
    h5,
    h6,
    head,
    header,
    hgroup,
    hr,
    html,
    i,
    iframe,
    img,
    input,
    ins,
    kbd,
    keygen,
    label,
    legend,
    li,
    link,
    listing,
    main,
    map,
    mark,
    marquee,
    menu,
    meta,
    meter,
    model,
    nav,
    nobr,
    noembed,
    noframes,
    noscript,
    object,
    ol,
    optgroup,
    option,
    output,
    p,
    param,
    picture,
    plaintext,
    pre,
    progress,
    q,
    rb,
    rp,
    rt,
    rtc,
    ruby,
    s,
    samp,
    search,
    section,
    select,
    slot,
    small_,
    source,
    span,
    strike,
    strong,
    sub,
    summary,
    sup,
    table,
    tbody,
    td,
    template_,
    textarea,
    tfoot,
    th,
    thead,
    time,
    tr,
    track,
    tt,
    u,
    ul,
    var,
    video,
    wbr,
    xmp,

    // MathML
    annotation,
    maction,
    maligngroup,
    malignmark,
    math,
    menclose,
    merror,
    mfenced,
    mfrac,
    mglyph,
    mi,
    mlabeledtr,
    mlongdiv,
    mmultiscripts,
    mn,
    mo,
    mover,
    mpadded,
    mphantom,
    mprescripts,
    mroot,
    mrow,
    ms,
    mscarries,
    mscarry,
    msgroup,
    msline,
    mspace,
    msqrt,
    msrow,
    mstack,
    mstyle,
    msub,
    msubsup,
    msup,
    mtable,
    mtd,
    mtext,
    mtr,
    munder,
    munderover,
    none,
    semantics,

    // SVG
    altGlyph,
    altGlyphDef,
    altGlyphItem,
    animate,
    animateColor,
    animateMotion,
    animateTransform,
    circle,
    clipPath,
    cursor,
    defs,
    desc,
    ellipse,
    feBlend,
    feColorMatrix,
    feComponentTransfer,
    feComposite,
    feConvolveMatrix,
    feDiffuseLighting,
    feDisplacementMap,
    feDistantLight,
    feDropShadow,
    feFlood,
    feFuncA,
    feFuncB,
    feFuncG,
    feFuncR,
    feGaussianBlur,
    feImage,
    feMerge,
    feMergeNode,
    feMorphology,
    feOffset,
    fePointLight,
    feSpecularLighting,
    feSpotLight,
    feTile,
    feTurbulence,
    filter,
    foreignObject,
    g,
    glyph,
    glyphRef,
    hkern,
    line,
    linearGradient,
    marker,
    mask,
    metadata,
    mpath,
    path,
    pattern,
    polygon,
    polyline,
    radialGradient,
    rect,
    set,
    stop,
    svg,
    switch_,
    symbol,
    text,
    textPath,
    tref,
    tspan,
    use,
    view,
    vkern,

    // Tags in multiple namespaces
    a, // HTML, SVG
    annotation_xml, // HTML, MathML
    font, // HTML, SVG
    font_face, // HTML, SVG
    font_face_format, // HTML, SVG
    font_face_name, // HTML, SVG
    font_face_src, // HTML, SVG
    font_face_uri, // HTML, SVG
    image, // HTML, SVG
    missing_glyph, // HTML, SVG
    script, // HTML, SVG
    style, // HTML, SVG
    title, // HTML, SVG

    // Foreign namespace tag names requiring adjustment
    altglyphCaseUnadjusted,
    altglyphdefCaseUnadjusted,
    altglyphitemCaseUnadjusted,
    animatecolorCaseUnadjusted,
    animatemotionCaseUnadjusted,
    animatetransformCaseUnadjusted,
    clippathCaseUnadjusted,
    feblendCaseUnadjusted,
    fecolormatrixCaseUnadjusted,
    fecomponenttransferCaseUnadjusted,
    fecompositeCaseUnadjusted,
    feconvolvematrixCaseUnadjusted,
    fediffuselightingCaseUnadjusted,
    fedisplacementmapCaseUnadjusted,
    fedistantlightCaseUnadjusted,
    fedropshadowCaseUnadjusted,
    fefloodCaseUnadjusted,
    fefuncaCaseUnadjusted,
    fefuncbCaseUnadjusted,
    fefuncgCaseUnadjusted,
    fefuncrCaseUnadjusted,
    fegaussianblurCaseUnadjusted,
    feimageCaseUnadjusted,
    femergeCaseUnadjusted,
    femergenodeCaseUnadjusted,
    femorphologyCaseUnadjusted,
    feoffsetCaseUnadjusted,
    fepointlightCaseUnadjusted,
    fespecularlightingCaseUnadjusted,
    fespotlightCaseUnadjusted,
    fetileCaseUnadjusted,
    feturbulenceCaseUnadjusted,
    foreignobjectCaseUnadjusted,
    glyphrefCaseUnadjusted,
    lineargradientCaseUnadjusted,
    radialgradientCaseUnadjusted,
    textpathCaseUnadjusted,
};

inline constexpr auto lastTagNameEnumValue = TagName::textpathCaseUnadjusted;
inline LazyNeverDestroyed<EnumeratedArray<TagName, AtomString, lastTagNameEnumValue>> tagNameStrings;

WEBCORE_EXPORT void initializeTagNameStrings();
TagName findTagName(std::span<const UChar>);
#if ASSERT_ENABLED
TagName findTagName(const String&);
#endif
TagName adjustSVGTagName(TagName);

inline const AtomString& tagNameAsString(TagName tagName)
{
    return tagNameStrings.get()[tagName];
}

inline TagName adjustSVGTagName(TagName tagName)
{
    switch (tagName) {
    case TagName::altglyphCaseUnadjusted:
        return TagName::altGlyph;
    case TagName::altglyphdefCaseUnadjusted:
        return TagName::altGlyphDef;
    case TagName::altglyphitemCaseUnadjusted:
        return TagName::altGlyphItem;
    case TagName::animatecolorCaseUnadjusted:
        return TagName::animateColor;
    case TagName::animatemotionCaseUnadjusted:
        return TagName::animateMotion;
    case TagName::animatetransformCaseUnadjusted:
        return TagName::animateTransform;
    case TagName::clippathCaseUnadjusted:
        return TagName::clipPath;
    case TagName::feblendCaseUnadjusted:
        return TagName::feBlend;
    case TagName::fecolormatrixCaseUnadjusted:
        return TagName::feColorMatrix;
    case TagName::fecomponenttransferCaseUnadjusted:
        return TagName::feComponentTransfer;
    case TagName::fecompositeCaseUnadjusted:
        return TagName::feComposite;
    case TagName::feconvolvematrixCaseUnadjusted:
        return TagName::feConvolveMatrix;
    case TagName::fediffuselightingCaseUnadjusted:
        return TagName::feDiffuseLighting;
    case TagName::fedisplacementmapCaseUnadjusted:
        return TagName::feDisplacementMap;
    case TagName::fedistantlightCaseUnadjusted:
        return TagName::feDistantLight;
    case TagName::fedropshadowCaseUnadjusted:
        return TagName::feDropShadow;
    case TagName::fefloodCaseUnadjusted:
        return TagName::feFlood;
    case TagName::fefuncaCaseUnadjusted:
        return TagName::feFuncA;
    case TagName::fefuncbCaseUnadjusted:
        return TagName::feFuncB;
    case TagName::fefuncgCaseUnadjusted:
        return TagName::feFuncG;
    case TagName::fefuncrCaseUnadjusted:
        return TagName::feFuncR;
    case TagName::fegaussianblurCaseUnadjusted:
        return TagName::feGaussianBlur;
    case TagName::feimageCaseUnadjusted:
        return TagName::feImage;
    case TagName::femergeCaseUnadjusted:
        return TagName::feMerge;
    case TagName::femergenodeCaseUnadjusted:
        return TagName::feMergeNode;
    case TagName::femorphologyCaseUnadjusted:
        return TagName::feMorphology;
    case TagName::feoffsetCaseUnadjusted:
        return TagName::feOffset;
    case TagName::fepointlightCaseUnadjusted:
        return TagName::fePointLight;
    case TagName::fespecularlightingCaseUnadjusted:
        return TagName::feSpecularLighting;
    case TagName::fespotlightCaseUnadjusted:
        return TagName::feSpotLight;
    case TagName::fetileCaseUnadjusted:
        return TagName::feTile;
    case TagName::feturbulenceCaseUnadjusted:
        return TagName::feTurbulence;
    case TagName::foreignobjectCaseUnadjusted:
        return TagName::foreignObject;
    case TagName::glyphrefCaseUnadjusted:
        return TagName::glyphRef;
    case TagName::lineargradientCaseUnadjusted:
        return TagName::linearGradient;
    case TagName::radialgradientCaseUnadjusted:
        return TagName::radialGradient;
    case TagName::textpathCaseUnadjusted:
        return TagName::textPath;
    default:
        return tagName;
    }
}

} // namespace WebCore
