// Copyright 2023-2024 Buf Technologies, Inc.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.34.2
// 	protoc        (unknown)
// source: buf/registry/module/v1beta1/module_service.proto

package modulev1beta1

import (
	_ "buf.build/gen/go/bufbuild/protovalidate/protocolbuffers/go/buf/validate"
	v1 "buf.build/gen/go/bufbuild/registry/protocolbuffers/go/buf/registry/owner/v1"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	reflect "reflect"
	sync "sync"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// The list order.
type ListModulesRequest_Order int32

const (
	ListModulesRequest_ORDER_UNSPECIFIED ListModulesRequest_Order = 0
	// Order by create_time newest to oldest.
	ListModulesRequest_ORDER_CREATE_TIME_DESC ListModulesRequest_Order = 1
	// Order by create_time oldest to newest.
	ListModulesRequest_ORDER_CREATE_TIME_ASC ListModulesRequest_Order = 2
)

// Enum value maps for ListModulesRequest_Order.
var (
	ListModulesRequest_Order_name = map[int32]string{
		0: "ORDER_UNSPECIFIED",
		1: "ORDER_CREATE_TIME_DESC",
		2: "ORDER_CREATE_TIME_ASC",
	}
	ListModulesRequest_Order_value = map[string]int32{
		"ORDER_UNSPECIFIED":      0,
		"ORDER_CREATE_TIME_DESC": 1,
		"ORDER_CREATE_TIME_ASC":  2,
	}
)

func (x ListModulesRequest_Order) Enum() *ListModulesRequest_Order {
	p := new(ListModulesRequest_Order)
	*p = x
	return p
}

func (x ListModulesRequest_Order) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ListModulesRequest_Order) Descriptor() protoreflect.EnumDescriptor {
	return file_buf_registry_module_v1beta1_module_service_proto_enumTypes[0].Descriptor()
}

func (ListModulesRequest_Order) Type() protoreflect.EnumType {
	return &file_buf_registry_module_v1beta1_module_service_proto_enumTypes[0]
}

func (x ListModulesRequest_Order) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ListModulesRequest_Order.Descriptor instead.
func (ListModulesRequest_Order) EnumDescriptor() ([]byte, []int) {
	return file_buf_registry_module_v1beta1_module_service_proto_rawDescGZIP(), []int{2, 0}
}

type GetModulesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The Modules to request.
	ModuleRefs []*ModuleRef `protobuf:"bytes,1,rep,name=module_refs,json=moduleRefs,proto3" json:"module_refs,omitempty"`
}

func (x *GetModulesRequest) Reset() {
	*x = GetModulesRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_buf_registry_module_v1beta1_module_service_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetModulesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetModulesRequest) ProtoMessage() {}

func (x *GetModulesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_buf_registry_module_v1beta1_module_service_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetModulesRequest.ProtoReflect.Descriptor instead.
func (*GetModulesRequest) Descriptor() ([]byte, []int) {
	return file_buf_registry_module_v1beta1_module_service_proto_rawDescGZIP(), []int{0}
}

func (x *GetModulesRequest) GetModuleRefs() []*ModuleRef {
	if x != nil {
		return x.ModuleRefs
	}
	return nil
}

type GetModulesResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The retrieved Modules in the same order as requested.
	Modules []*Module `protobuf:"bytes,1,rep,name=modules,proto3" json:"modules,omitempty"`
}

func (x *GetModulesResponse) Reset() {
	*x = GetModulesResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_buf_registry_module_v1beta1_module_service_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetModulesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetModulesResponse) ProtoMessage() {}

func (x *GetModulesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_buf_registry_module_v1beta1_module_service_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetModulesResponse.ProtoReflect.Descriptor instead.
func (*GetModulesResponse) Descriptor() ([]byte, []int) {
	return file_buf_registry_module_v1beta1_module_service_proto_rawDescGZIP(), []int{1}
}

func (x *GetModulesResponse) GetModules() []*Module {
	if x != nil {
		return x.Modules
	}
	return nil
}

type ListModulesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The maximum number of items to return.
	//
	// The default value is 10.
	PageSize uint32 `protobuf:"varint,1,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// The page to start from.
	//
	// If empty, the first page is returned.
	PageToken string `protobuf:"bytes,2,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// The specific Users or Organizations to list Modules for.
	//
	// If empty, all Modules for all owners are listed, but this functionality
	// is limited to Users with the necessary permissions.
	OwnerRefs []*v1.OwnerRef `protobuf:"bytes,3,rep,name=owner_refs,json=ownerRefs,proto3" json:"owner_refs,omitempty"`
	// The order to return the Modules.
	//
	// If not specified, defaults to ORDER_CREATE_TIME_DESC.
	Order ListModulesRequest_Order `protobuf:"varint,4,opt,name=order,proto3,enum=buf.registry.module.v1beta1.ListModulesRequest_Order" json:"order,omitempty"`
}

func (x *ListModulesRequest) Reset() {
	*x = ListModulesRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_buf_registry_module_v1beta1_module_service_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListModulesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListModulesRequest) ProtoMessage() {}

func (x *ListModulesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_buf_registry_module_v1beta1_module_service_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListModulesRequest.ProtoReflect.Descriptor instead.
func (*ListModulesRequest) Descriptor() ([]byte, []int) {
	return file_buf_registry_module_v1beta1_module_service_proto_rawDescGZIP(), []int{2}
}

func (x *ListModulesRequest) GetPageSize() uint32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListModulesRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListModulesRequest) GetOwnerRefs() []*v1.OwnerRef {
	if x != nil {
		return x.OwnerRefs
	}
	return nil
}

func (x *ListModulesRequest) GetOrder() ListModulesRequest_Order {
	if x != nil {
		return x.Order
	}
	return ListModulesRequest_ORDER_UNSPECIFIED
}

type ListModulesResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The next page token.
	//
	// If empty, there are no more pages.
	NextPageToken string `protobuf:"bytes,1,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	// The listed Modules.
	Modules []*Module `protobuf:"bytes,2,rep,name=modules,proto3" json:"modules,omitempty"`
}

func (x *ListModulesResponse) Reset() {
	*x = ListModulesResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_buf_registry_module_v1beta1_module_service_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListModulesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListModulesResponse) ProtoMessage() {}

func (x *ListModulesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_buf_registry_module_v1beta1_module_service_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListModulesResponse.ProtoReflect.Descriptor instead.
func (*ListModulesResponse) Descriptor() ([]byte, []int) {
	return file_buf_registry_module_v1beta1_module_service_proto_rawDescGZIP(), []int{3}
}

func (x *ListModulesResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

func (x *ListModulesResponse) GetModules() []*Module {
	if x != nil {
		return x.Modules
	}
	return nil
}

type CreateModulesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The Modules to create.
	Values []*CreateModulesRequest_Value `protobuf:"bytes,1,rep,name=values,proto3" json:"values,omitempty"`
}

func (x *CreateModulesRequest) Reset() {
	*x = CreateModulesRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_buf_registry_module_v1beta1_module_service_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateModulesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateModulesRequest) ProtoMessage() {}

func (x *CreateModulesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_buf_registry_module_v1beta1_module_service_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateModulesRequest.ProtoReflect.Descriptor instead.
func (*CreateModulesRequest) Descriptor() ([]byte, []int) {
	return file_buf_registry_module_v1beta1_module_service_proto_rawDescGZIP(), []int{4}
}

func (x *CreateModulesRequest) GetValues() []*CreateModulesRequest_Value {
	if x != nil {
		return x.Values
	}
	return nil
}

type CreateModulesResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The created Modules in the same order as given on the request.
	Modules []*Module `protobuf:"bytes,1,rep,name=modules,proto3" json:"modules,omitempty"`
}

func (x *CreateModulesResponse) Reset() {
	*x = CreateModulesResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_buf_registry_module_v1beta1_module_service_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateModulesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateModulesResponse) ProtoMessage() {}

func (x *CreateModulesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_buf_registry_module_v1beta1_module_service_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateModulesResponse.ProtoReflect.Descriptor instead.
func (*CreateModulesResponse) Descriptor() ([]byte, []int) {
	return file_buf_registry_module_v1beta1_module_service_proto_rawDescGZIP(), []int{5}
}

func (x *CreateModulesResponse) GetModules() []*Module {
	if x != nil {
		return x.Modules
	}
	return nil
}

type UpdateModulesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The Modules to update.
	Values []*UpdateModulesRequest_Value `protobuf:"bytes,1,rep,name=values,proto3" json:"values,omitempty"`
}

func (x *UpdateModulesRequest) Reset() {
	*x = UpdateModulesRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_buf_registry_module_v1beta1_module_service_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateModulesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateModulesRequest) ProtoMessage() {}

func (x *UpdateModulesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_buf_registry_module_v1beta1_module_service_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateModulesRequest.ProtoReflect.Descriptor instead.
func (*UpdateModulesRequest) Descriptor() ([]byte, []int) {
	return file_buf_registry_module_v1beta1_module_service_proto_rawDescGZIP(), []int{6}
}

func (x *UpdateModulesRequest) GetValues() []*UpdateModulesRequest_Value {
	if x != nil {
		return x.Values
	}
	return nil
}

type UpdateModulesResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The updated Modules in the same order as given on the request.
	Modules []*Module `protobuf:"bytes,1,rep,name=modules,proto3" json:"modules,omitempty"`
}

func (x *UpdateModulesResponse) Reset() {
	*x = UpdateModulesResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_buf_registry_module_v1beta1_module_service_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateModulesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateModulesResponse) ProtoMessage() {}

func (x *UpdateModulesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_buf_registry_module_v1beta1_module_service_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateModulesResponse.ProtoReflect.Descriptor instead.
func (*UpdateModulesResponse) Descriptor() ([]byte, []int) {
	return file_buf_registry_module_v1beta1_module_service_proto_rawDescGZIP(), []int{7}
}

func (x *UpdateModulesResponse) GetModules() []*Module {
	if x != nil {
		return x.Modules
	}
	return nil
}

type DeleteModulesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The Modules to delete.
	ModuleRefs []*ModuleRef `protobuf:"bytes,1,rep,name=module_refs,json=moduleRefs,proto3" json:"module_refs,omitempty"`
}

func (x *DeleteModulesRequest) Reset() {
	*x = DeleteModulesRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_buf_registry_module_v1beta1_module_service_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteModulesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteModulesRequest) ProtoMessage() {}

func (x *DeleteModulesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_buf_registry_module_v1beta1_module_service_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteModulesRequest.ProtoReflect.Descriptor instead.
func (*DeleteModulesRequest) Descriptor() ([]byte, []int) {
	return file_buf_registry_module_v1beta1_module_service_proto_rawDescGZIP(), []int{8}
}

func (x *DeleteModulesRequest) GetModuleRefs() []*ModuleRef {
	if x != nil {
		return x.ModuleRefs
	}
	return nil
}

type DeleteModulesResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *DeleteModulesResponse) Reset() {
	*x = DeleteModulesResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_buf_registry_module_v1beta1_module_service_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteModulesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteModulesResponse) ProtoMessage() {}

func (x *DeleteModulesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_buf_registry_module_v1beta1_module_service_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteModulesResponse.ProtoReflect.Descriptor instead.
func (*DeleteModulesResponse) Descriptor() ([]byte, []int) {
	return file_buf_registry_module_v1beta1_module_service_proto_rawDescGZIP(), []int{9}
}

// An individual request to create a Module.
type CreateModulesRequest_Value struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The User or Organization to create the Module under.
	OwnerRef *v1.OwnerRef `protobuf:"bytes,1,opt,name=owner_ref,json=ownerRef,proto3" json:"owner_ref,omitempty"`
	// The name of the Module.
	Name string `protobuf:"bytes,2,opt,name=name,proto3" json:"name,omitempty"`
	// The module's visibility.
	Visibility ModuleVisibility `protobuf:"varint,3,opt,name=visibility,proto3,enum=buf.registry.module.v1beta1.ModuleVisibility" json:"visibility,omitempty"`
	// The configurable description of the Module.
	Description string `protobuf:"bytes,4,opt,name=description,proto3" json:"description,omitempty"`
	// The configurable URL in the description of the module.
	Url string `protobuf:"bytes,5,opt,name=url,proto3" json:"url,omitempty"`
	// The name of the default Label of the Module.
	//
	// If not set, the default Label will be named "main" upon creation.
	//
	// This may point to an archived Label.
	DefaultLabelName string `protobuf:"bytes,6,opt,name=default_label_name,json=defaultLabelName,proto3" json:"default_label_name,omitempty"`
}

func (x *CreateModulesRequest_Value) Reset() {
	*x = CreateModulesRequest_Value{}
	if protoimpl.UnsafeEnabled {
		mi := &file_buf_registry_module_v1beta1_module_service_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateModulesRequest_Value) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateModulesRequest_Value) ProtoMessage() {}

func (x *CreateModulesRequest_Value) ProtoReflect() protoreflect.Message {
	mi := &file_buf_registry_module_v1beta1_module_service_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateModulesRequest_Value.ProtoReflect.Descriptor instead.
func (*CreateModulesRequest_Value) Descriptor() ([]byte, []int) {
	return file_buf_registry_module_v1beta1_module_service_proto_rawDescGZIP(), []int{4, 0}
}

func (x *CreateModulesRequest_Value) GetOwnerRef() *v1.OwnerRef {
	if x != nil {
		return x.OwnerRef
	}
	return nil
}

func (x *CreateModulesRequest_Value) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *CreateModulesRequest_Value) GetVisibility() ModuleVisibility {
	if x != nil {
		return x.Visibility
	}
	return ModuleVisibility_MODULE_VISIBILITY_UNSPECIFIED
}

func (x *CreateModulesRequest_Value) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *CreateModulesRequest_Value) GetUrl() string {
	if x != nil {
		return x.Url
	}
	return ""
}

func (x *CreateModulesRequest_Value) GetDefaultLabelName() string {
	if x != nil {
		return x.DefaultLabelName
	}
	return ""
}

// An individual request to update a Module.
type UpdateModulesRequest_Value struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The Module to update.
	ModuleRef *ModuleRef `protobuf:"bytes,1,opt,name=module_ref,json=moduleRef,proto3" json:"module_ref,omitempty"`
	// The module's visibility.
	Visibility *ModuleVisibility `protobuf:"varint,3,opt,name=visibility,proto3,enum=buf.registry.module.v1beta1.ModuleVisibility,oneof" json:"visibility,omitempty"`
	// The deprecation status of the module.
	State *ModuleState `protobuf:"varint,4,opt,name=state,proto3,enum=buf.registry.module.v1beta1.ModuleState,oneof" json:"state,omitempty"`
	// The configurable description of the module.
	Description *string `protobuf:"bytes,5,opt,name=description,proto3,oneof" json:"description,omitempty"`
	// The configurable URL in the description of the module.
	Url *string `protobuf:"bytes,6,opt,name=url,proto3,oneof" json:"url,omitempty"`
	// The name of the default Label of the Module.
	//
	// This Label may not yet exist.
	//
	// This may not point to an archived Label.
	DefaultLabelName *string `protobuf:"bytes,7,opt,name=default_label_name,json=defaultLabelName,proto3,oneof" json:"default_label_name,omitempty"`
}

func (x *UpdateModulesRequest_Value) Reset() {
	*x = UpdateModulesRequest_Value{}
	if protoimpl.UnsafeEnabled {
		mi := &file_buf_registry_module_v1beta1_module_service_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateModulesRequest_Value) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateModulesRequest_Value) ProtoMessage() {}

func (x *UpdateModulesRequest_Value) ProtoReflect() protoreflect.Message {
	mi := &file_buf_registry_module_v1beta1_module_service_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateModulesRequest_Value.ProtoReflect.Descriptor instead.
func (*UpdateModulesRequest_Value) Descriptor() ([]byte, []int) {
	return file_buf_registry_module_v1beta1_module_service_proto_rawDescGZIP(), []int{6, 0}
}

func (x *UpdateModulesRequest_Value) GetModuleRef() *ModuleRef {
	if x != nil {
		return x.ModuleRef
	}
	return nil
}

func (x *UpdateModulesRequest_Value) GetVisibility() ModuleVisibility {
	if x != nil && x.Visibility != nil {
		return *x.Visibility
	}
	return ModuleVisibility_MODULE_VISIBILITY_UNSPECIFIED
}

func (x *UpdateModulesRequest_Value) GetState() ModuleState {
	if x != nil && x.State != nil {
		return *x.State
	}
	return ModuleState_MODULE_STATE_UNSPECIFIED
}

func (x *UpdateModulesRequest_Value) GetDescription() string {
	if x != nil && x.Description != nil {
		return *x.Description
	}
	return ""
}

func (x *UpdateModulesRequest_Value) GetUrl() string {
	if x != nil && x.Url != nil {
		return *x.Url
	}
	return ""
}

func (x *UpdateModulesRequest_Value) GetDefaultLabelName() string {
	if x != nil && x.DefaultLabelName != nil {
		return *x.DefaultLabelName
	}
	return ""
}

var File_buf_registry_module_v1beta1_module_service_proto protoreflect.FileDescriptor

var file_buf_registry_module_v1beta1_module_service_proto_rawDesc = []byte{
	0x0a, 0x30, 0x62, 0x75, 0x66, 0x2f, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2f, 0x6d,
	0x6f, 0x64, 0x75, 0x6c, 0x65, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x6d, 0x6f,
	0x64, 0x75, 0x6c, 0x65, 0x5f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x12, 0x1b, 0x62, 0x75, 0x66, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79,
	0x2e, 0x6d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x1a,
	0x28, 0x62, 0x75, 0x66, 0x2f, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2f, 0x6d, 0x6f,
	0x64, 0x75, 0x6c, 0x65, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x6d, 0x6f, 0x64,
	0x75, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x21, 0x62, 0x75, 0x66, 0x2f, 0x72,
	0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2f, 0x6f, 0x77, 0x6e, 0x65, 0x72, 0x2f, 0x76, 0x31,
	0x2f, 0x6f, 0x77, 0x6e, 0x65, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1b, 0x62, 0x75,
	0x66, 0x2f, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x65, 0x2f, 0x76, 0x61, 0x6c, 0x69, 0x64,
	0x61, 0x74, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0x69, 0x0a, 0x11, 0x47, 0x65, 0x74,
	0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x54,
	0x0a, 0x0b, 0x6d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x5f, 0x72, 0x65, 0x66, 0x73, 0x18, 0x01, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74,
	0x72, 0x79, 0x2e, 0x6d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x31, 0x2e, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x52, 0x65, 0x66, 0x42, 0x0b, 0xba, 0x48, 0x08,
	0x92, 0x01, 0x05, 0x08, 0x01, 0x10, 0xfa, 0x01, 0x52, 0x0a, 0x6d, 0x6f, 0x64, 0x75, 0x6c, 0x65,
	0x52, 0x65, 0x66, 0x73, 0x22, 0x5d, 0x0a, 0x12, 0x47, 0x65, 0x74, 0x4d, 0x6f, 0x64, 0x75, 0x6c,
	0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x47, 0x0a, 0x07, 0x6d, 0x6f,
	0x64, 0x75, 0x6c, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x23, 0x2e, 0x62, 0x75,
	0x66, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x6d, 0x6f, 0x64, 0x75, 0x6c,
	0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65,
	0x42, 0x08, 0xba, 0x48, 0x05, 0x92, 0x01, 0x02, 0x08, 0x01, 0x52, 0x07, 0x6d, 0x6f, 0x64, 0x75,
	0x6c, 0x65, 0x73, 0x22, 0xd2, 0x02, 0x0a, 0x12, 0x4c, 0x69, 0x73, 0x74, 0x4d, 0x6f, 0x64, 0x75,
	0x6c, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x25, 0x0a, 0x09, 0x70, 0x61,
	0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0d, 0x42, 0x08, 0xba,
	0x48, 0x05, 0x2a, 0x03, 0x18, 0xfa, 0x01, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a,
	0x65, 0x12, 0x27, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x08, 0xba, 0x48, 0x05, 0x72, 0x03, 0x18, 0x80, 0x20, 0x52,
	0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x3e, 0x0a, 0x0a, 0x6f, 0x77,
	0x6e, 0x65, 0x72, 0x5f, 0x72, 0x65, 0x66, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x1f,
	0x2e, 0x62, 0x75, 0x66, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x6f, 0x77,
	0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x4f, 0x77, 0x6e, 0x65, 0x72, 0x52, 0x65, 0x66, 0x52,
	0x09, 0x6f, 0x77, 0x6e, 0x65, 0x72, 0x52, 0x65, 0x66, 0x73, 0x12, 0x55, 0x0a, 0x05, 0x6f, 0x72,
	0x64, 0x65, 0x72, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x35, 0x2e, 0x62, 0x75, 0x66, 0x2e,
	0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x6d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x2e,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x4d, 0x6f, 0x64, 0x75,
	0x6c, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x2e, 0x4f, 0x72, 0x64, 0x65, 0x72,
	0x42, 0x08, 0xba, 0x48, 0x05, 0x82, 0x01, 0x02, 0x10, 0x01, 0x52, 0x05, 0x6f, 0x72, 0x64, 0x65,
	0x72, 0x22, 0x55, 0x0a, 0x05, 0x4f, 0x72, 0x64, 0x65, 0x72, 0x12, 0x15, 0x0a, 0x11, 0x4f, 0x52,
	0x44, 0x45, 0x52, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10,
	0x00, 0x12, 0x1a, 0x0a, 0x16, 0x4f, 0x52, 0x44, 0x45, 0x52, 0x5f, 0x43, 0x52, 0x45, 0x41, 0x54,
	0x45, 0x5f, 0x54, 0x49, 0x4d, 0x45, 0x5f, 0x44, 0x45, 0x53, 0x43, 0x10, 0x01, 0x12, 0x19, 0x0a,
	0x15, 0x4f, 0x52, 0x44, 0x45, 0x52, 0x5f, 0x43, 0x52, 0x45, 0x41, 0x54, 0x45, 0x5f, 0x54, 0x49,
	0x4d, 0x45, 0x5f, 0x41, 0x53, 0x43, 0x10, 0x02, 0x22, 0x86, 0x01, 0x0a, 0x13, 0x4c, 0x69, 0x73,
	0x74, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x12, 0x30, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f,
	0x6b, 0x65, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x08, 0xba, 0x48, 0x05, 0x72, 0x03,
	0x18, 0x80, 0x20, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b,
	0x65, 0x6e, 0x12, 0x3d, 0x0a, 0x07, 0x6d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x73, 0x18, 0x02, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x23, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74,
	0x72, 0x79, 0x2e, 0x6d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x31, 0x2e, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x52, 0x07, 0x6d, 0x6f, 0x64, 0x75, 0x6c, 0x65,
	0x73, 0x22, 0xc5, 0x03, 0x0a, 0x14, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x4d, 0x6f, 0x64, 0x75,
	0x6c, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x5c, 0x0a, 0x06, 0x76, 0x61,
	0x6c, 0x75, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x37, 0x2e, 0x62, 0x75, 0x66,
	0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x6d, 0x6f, 0x64, 0x75, 0x6c, 0x65,
	0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x4d,
	0x6f, 0x64, 0x75, 0x6c, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x2e, 0x56, 0x61,
	0x6c, 0x75, 0x65, 0x42, 0x0b, 0xba, 0x48, 0x08, 0x92, 0x01, 0x05, 0x08, 0x01, 0x10, 0xfa, 0x01,
	0x52, 0x06, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x1a, 0xce, 0x02, 0x0a, 0x05, 0x56, 0x61, 0x6c,
	0x75, 0x65, 0x12, 0x44, 0x0a, 0x09, 0x6f, 0x77, 0x6e, 0x65, 0x72, 0x5f, 0x72, 0x65, 0x66, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1f, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x72, 0x65, 0x67, 0x69,
	0x73, 0x74, 0x72, 0x79, 0x2e, 0x6f, 0x77, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x4f, 0x77,
	0x6e, 0x65, 0x72, 0x52, 0x65, 0x66, 0x42, 0x06, 0xba, 0x48, 0x03, 0xc8, 0x01, 0x01, 0x52, 0x08,
	0x6f, 0x77, 0x6e, 0x65, 0x72, 0x52, 0x65, 0x66, 0x12, 0x1d, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x09, 0xba, 0x48, 0x06, 0x72, 0x04, 0x10, 0x02, 0x18,
	0x64, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x5a, 0x0a, 0x0a, 0x76, 0x69, 0x73, 0x69, 0x62,
	0x69, 0x6c, 0x69, 0x74, 0x79, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2d, 0x2e, 0x62, 0x75,
	0x66, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x6d, 0x6f, 0x64, 0x75, 0x6c,
	0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65,
	0x56, 0x69, 0x73, 0x69, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x42, 0x0b, 0xba, 0x48, 0x08, 0xc8,
	0x01, 0x01, 0x82, 0x01, 0x02, 0x10, 0x01, 0x52, 0x0a, 0x76, 0x69, 0x73, 0x69, 0x62, 0x69, 0x6c,
	0x69, 0x74, 0x79, 0x12, 0x2a, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69,
	0x6f, 0x6e, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x08, 0xba, 0x48, 0x05, 0x72, 0x03, 0x18,
	0xde, 0x02, 0x52, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12,
	0x20, 0x0a, 0x03, 0x75, 0x72, 0x6c, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x42, 0x0e, 0xba, 0x48,
	0x0b, 0xd8, 0x01, 0x01, 0x72, 0x06, 0x18, 0xff, 0x01, 0x88, 0x01, 0x01, 0x52, 0x03, 0x75, 0x72,
	0x6c, 0x12, 0x36, 0x0a, 0x12, 0x64, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x5f, 0x6c, 0x61, 0x62,
	0x65, 0x6c, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x42, 0x08, 0xba,
	0x48, 0x05, 0x72, 0x03, 0x18, 0xfa, 0x01, 0x52, 0x10, 0x64, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74,
	0x4c, 0x61, 0x62, 0x65, 0x6c, 0x4e, 0x61, 0x6d, 0x65, 0x22, 0x60, 0x0a, 0x15, 0x43, 0x72, 0x65,
	0x61, 0x74, 0x65, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e,
	0x73, 0x65, 0x12, 0x47, 0x0a, 0x07, 0x6d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x73, 0x18, 0x01, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x23, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74,
	0x72, 0x79, 0x2e, 0x6d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x31, 0x2e, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x42, 0x08, 0xba, 0x48, 0x05, 0x92, 0x01, 0x02,
	0x08, 0x01, 0x52, 0x07, 0x6d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x73, 0x22, 0xdf, 0x04, 0x0a, 0x14,
	0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x73, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x5c, 0x0a, 0x06, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x18, 0x01,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x37, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73,
	0x74, 0x72, 0x79, 0x2e, 0x6d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x31, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x73,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x2e, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x42, 0x0b, 0xba,
	0x48, 0x08, 0x92, 0x01, 0x05, 0x08, 0x01, 0x10, 0xfa, 0x01, 0x52, 0x06, 0x76, 0x61, 0x6c, 0x75,
	0x65, 0x73, 0x1a, 0xe8, 0x03, 0x0a, 0x05, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x4d, 0x0a, 0x0a,
	0x6d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x5f, 0x72, 0x65, 0x66, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x26, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e,
	0x6d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4d,
	0x6f, 0x64, 0x75, 0x6c, 0x65, 0x52, 0x65, 0x66, 0x42, 0x06, 0xba, 0x48, 0x03, 0xc8, 0x01, 0x01,
	0x52, 0x09, 0x6d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x52, 0x65, 0x66, 0x12, 0x5f, 0x0a, 0x0a, 0x76,
	0x69, 0x73, 0x69, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0e, 0x32,
	0x2d, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x6d,
	0x6f, 0x64, 0x75, 0x6c, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4d, 0x6f,
	0x64, 0x75, 0x6c, 0x65, 0x56, 0x69, 0x73, 0x69, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x42, 0x0b,
	0xba, 0x48, 0x08, 0x82, 0x01, 0x05, 0x10, 0x01, 0x22, 0x01, 0x00, 0x48, 0x00, 0x52, 0x0a, 0x76,
	0x69, 0x73, 0x69, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x88, 0x01, 0x01, 0x12, 0x50, 0x0a, 0x05,
	0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x28, 0x2e, 0x62, 0x75,
	0x66, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x6d, 0x6f, 0x64, 0x75, 0x6c,
	0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65,
	0x53, 0x74, 0x61, 0x74, 0x65, 0x42, 0x0b, 0xba, 0x48, 0x08, 0x82, 0x01, 0x05, 0x10, 0x01, 0x22,
	0x01, 0x00, 0x48, 0x01, 0x52, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x88, 0x01, 0x01, 0x12, 0x2f,
	0x0a, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x05, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x08, 0xba, 0x48, 0x05, 0x72, 0x03, 0x18, 0xde, 0x02, 0x48, 0x02, 0x52,
	0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x88, 0x01, 0x01, 0x12,
	0x25, 0x0a, 0x03, 0x75, 0x72, 0x6c, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x42, 0x0e, 0xba, 0x48,
	0x0b, 0xd8, 0x01, 0x02, 0x72, 0x06, 0x18, 0xff, 0x01, 0x88, 0x01, 0x01, 0x48, 0x03, 0x52, 0x03,
	0x75, 0x72, 0x6c, 0x88, 0x01, 0x01, 0x12, 0x3d, 0x0a, 0x12, 0x64, 0x65, 0x66, 0x61, 0x75, 0x6c,
	0x74, 0x5f, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x07, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x0a, 0xba, 0x48, 0x07, 0x72, 0x05, 0x10, 0x01, 0x18, 0xfa, 0x01, 0x48, 0x04,
	0x52, 0x10, 0x64, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x4e, 0x61,
	0x6d, 0x65, 0x88, 0x01, 0x01, 0x42, 0x0d, 0x0a, 0x0b, 0x5f, 0x76, 0x69, 0x73, 0x69, 0x62, 0x69,
	0x6c, 0x69, 0x74, 0x79, 0x42, 0x08, 0x0a, 0x06, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x65, 0x42, 0x0e,
	0x0a, 0x0c, 0x5f, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x06,
	0x0a, 0x04, 0x5f, 0x75, 0x72, 0x6c, 0x42, 0x15, 0x0a, 0x13, 0x5f, 0x64, 0x65, 0x66, 0x61, 0x75,
	0x6c, 0x74, 0x5f, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x60, 0x0a,
	0x15, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x73, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x47, 0x0a, 0x07, 0x6d, 0x6f, 0x64, 0x75, 0x6c, 0x65,
	0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x23, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x72, 0x65,
	0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x6d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x2e, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x42, 0x08, 0xba, 0x48,
	0x05, 0x92, 0x01, 0x02, 0x08, 0x01, 0x52, 0x07, 0x6d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x73, 0x22,
	0x6c, 0x0a, 0x14, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x73,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x54, 0x0a, 0x0b, 0x6d, 0x6f, 0x64, 0x75, 0x6c,
	0x65, 0x5f, 0x72, 0x65, 0x66, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x62,
	0x75, 0x66, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x6d, 0x6f, 0x64, 0x75,
	0x6c, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4d, 0x6f, 0x64, 0x75, 0x6c,
	0x65, 0x52, 0x65, 0x66, 0x42, 0x0b, 0xba, 0x48, 0x08, 0x92, 0x01, 0x05, 0x08, 0x01, 0x10, 0xfa,
	0x01, 0x52, 0x0a, 0x6d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x52, 0x65, 0x66, 0x73, 0x22, 0x17, 0x0a,
	0x15, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x73, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x32, 0xf1, 0x04, 0x0a, 0x0d, 0x4d, 0x6f, 0x64, 0x75, 0x6c,
	0x65, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x12, 0x72, 0x0a, 0x0a, 0x47, 0x65, 0x74, 0x4d,
	0x6f, 0x64, 0x75, 0x6c, 0x65, 0x73, 0x12, 0x2e, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x72, 0x65, 0x67,
	0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x6d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x2e, 0x76, 0x31, 0x62,
	0x65, 0x74, 0x61, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x73, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2f, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x72, 0x65, 0x67,
	0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x6d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x2e, 0x76, 0x31, 0x62,
	0x65, 0x74, 0x61, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x73, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x03, 0x90, 0x02, 0x01, 0x12, 0x75, 0x0a, 0x0b,
	0x4c, 0x69, 0x73, 0x74, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x73, 0x12, 0x2f, 0x2e, 0x62, 0x75,
	0x66, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x6d, 0x6f, 0x64, 0x75, 0x6c,
	0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x4d, 0x6f,
	0x64, 0x75, 0x6c, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x30, 0x2e, 0x62,
	0x75, 0x66, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x6d, 0x6f, 0x64, 0x75,
	0x6c, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x4d,
	0x6f, 0x64, 0x75, 0x6c, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x03,
	0x90, 0x02, 0x01, 0x12, 0x7b, 0x0a, 0x0d, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x4d, 0x6f, 0x64,
	0x75, 0x6c, 0x65, 0x73, 0x12, 0x31, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73,
	0x74, 0x72, 0x79, 0x2e, 0x6d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x31, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x73,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x32, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x72, 0x65,
	0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x6d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x2e, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x4d, 0x6f, 0x64, 0x75,
	0x6c, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x03, 0x90, 0x02, 0x02,
	0x12, 0x7b, 0x0a, 0x0d, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65,
	0x73, 0x12, 0x31, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79,
	0x2e, 0x6d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e,
	0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x73, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x1a, 0x32, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73,
	0x74, 0x72, 0x79, 0x2e, 0x6d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x31, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x73,
	0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x03, 0x90, 0x02, 0x02, 0x12, 0x7b, 0x0a,
	0x0d, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x73, 0x12, 0x31,
	0x2e, 0x62, 0x75, 0x66, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x6d, 0x6f,
	0x64, 0x75, 0x6c, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x44, 0x65, 0x6c,
	0x65, 0x74, 0x65, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x1a, 0x32, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79,
	0x2e, 0x6d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e,
	0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x73, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x03, 0x90, 0x02, 0x02, 0x42, 0x61, 0x5a, 0x5f, 0x62, 0x75,
	0x66, 0x2e, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x2f, 0x67, 0x65, 0x6e, 0x2f, 0x67, 0x6f, 0x2f, 0x62,
	0x75, 0x66, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x2f, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79,
	0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x62, 0x75, 0x66, 0x66, 0x65, 0x72, 0x73,
	0x2f, 0x67, 0x6f, 0x2f, 0x62, 0x75, 0x66, 0x2f, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79,
	0x2f, 0x6d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x3b,
	0x6d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x62, 0x06, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_buf_registry_module_v1beta1_module_service_proto_rawDescOnce sync.Once
	file_buf_registry_module_v1beta1_module_service_proto_rawDescData = file_buf_registry_module_v1beta1_module_service_proto_rawDesc
)

func file_buf_registry_module_v1beta1_module_service_proto_rawDescGZIP() []byte {
	file_buf_registry_module_v1beta1_module_service_proto_rawDescOnce.Do(func() {
		file_buf_registry_module_v1beta1_module_service_proto_rawDescData = protoimpl.X.CompressGZIP(file_buf_registry_module_v1beta1_module_service_proto_rawDescData)
	})
	return file_buf_registry_module_v1beta1_module_service_proto_rawDescData
}

var file_buf_registry_module_v1beta1_module_service_proto_enumTypes = make([]protoimpl.EnumInfo, 1)
var file_buf_registry_module_v1beta1_module_service_proto_msgTypes = make([]protoimpl.MessageInfo, 12)
var file_buf_registry_module_v1beta1_module_service_proto_goTypes = []any{
	(ListModulesRequest_Order)(0),      // 0: buf.registry.module.v1beta1.ListModulesRequest.Order
	(*GetModulesRequest)(nil),          // 1: buf.registry.module.v1beta1.GetModulesRequest
	(*GetModulesResponse)(nil),         // 2: buf.registry.module.v1beta1.GetModulesResponse
	(*ListModulesRequest)(nil),         // 3: buf.registry.module.v1beta1.ListModulesRequest
	(*ListModulesResponse)(nil),        // 4: buf.registry.module.v1beta1.ListModulesResponse
	(*CreateModulesRequest)(nil),       // 5: buf.registry.module.v1beta1.CreateModulesRequest
	(*CreateModulesResponse)(nil),      // 6: buf.registry.module.v1beta1.CreateModulesResponse
	(*UpdateModulesRequest)(nil),       // 7: buf.registry.module.v1beta1.UpdateModulesRequest
	(*UpdateModulesResponse)(nil),      // 8: buf.registry.module.v1beta1.UpdateModulesResponse
	(*DeleteModulesRequest)(nil),       // 9: buf.registry.module.v1beta1.DeleteModulesRequest
	(*DeleteModulesResponse)(nil),      // 10: buf.registry.module.v1beta1.DeleteModulesResponse
	(*CreateModulesRequest_Value)(nil), // 11: buf.registry.module.v1beta1.CreateModulesRequest.Value
	(*UpdateModulesRequest_Value)(nil), // 12: buf.registry.module.v1beta1.UpdateModulesRequest.Value
	(*ModuleRef)(nil),                  // 13: buf.registry.module.v1beta1.ModuleRef
	(*Module)(nil),                     // 14: buf.registry.module.v1beta1.Module
	(*v1.OwnerRef)(nil),                // 15: buf.registry.owner.v1.OwnerRef
	(ModuleVisibility)(0),              // 16: buf.registry.module.v1beta1.ModuleVisibility
	(ModuleState)(0),                   // 17: buf.registry.module.v1beta1.ModuleState
}
var file_buf_registry_module_v1beta1_module_service_proto_depIdxs = []int32{
	13, // 0: buf.registry.module.v1beta1.GetModulesRequest.module_refs:type_name -> buf.registry.module.v1beta1.ModuleRef
	14, // 1: buf.registry.module.v1beta1.GetModulesResponse.modules:type_name -> buf.registry.module.v1beta1.Module
	15, // 2: buf.registry.module.v1beta1.ListModulesRequest.owner_refs:type_name -> buf.registry.owner.v1.OwnerRef
	0,  // 3: buf.registry.module.v1beta1.ListModulesRequest.order:type_name -> buf.registry.module.v1beta1.ListModulesRequest.Order
	14, // 4: buf.registry.module.v1beta1.ListModulesResponse.modules:type_name -> buf.registry.module.v1beta1.Module
	11, // 5: buf.registry.module.v1beta1.CreateModulesRequest.values:type_name -> buf.registry.module.v1beta1.CreateModulesRequest.Value
	14, // 6: buf.registry.module.v1beta1.CreateModulesResponse.modules:type_name -> buf.registry.module.v1beta1.Module
	12, // 7: buf.registry.module.v1beta1.UpdateModulesRequest.values:type_name -> buf.registry.module.v1beta1.UpdateModulesRequest.Value
	14, // 8: buf.registry.module.v1beta1.UpdateModulesResponse.modules:type_name -> buf.registry.module.v1beta1.Module
	13, // 9: buf.registry.module.v1beta1.DeleteModulesRequest.module_refs:type_name -> buf.registry.module.v1beta1.ModuleRef
	15, // 10: buf.registry.module.v1beta1.CreateModulesRequest.Value.owner_ref:type_name -> buf.registry.owner.v1.OwnerRef
	16, // 11: buf.registry.module.v1beta1.CreateModulesRequest.Value.visibility:type_name -> buf.registry.module.v1beta1.ModuleVisibility
	13, // 12: buf.registry.module.v1beta1.UpdateModulesRequest.Value.module_ref:type_name -> buf.registry.module.v1beta1.ModuleRef
	16, // 13: buf.registry.module.v1beta1.UpdateModulesRequest.Value.visibility:type_name -> buf.registry.module.v1beta1.ModuleVisibility
	17, // 14: buf.registry.module.v1beta1.UpdateModulesRequest.Value.state:type_name -> buf.registry.module.v1beta1.ModuleState
	1,  // 15: buf.registry.module.v1beta1.ModuleService.GetModules:input_type -> buf.registry.module.v1beta1.GetModulesRequest
	3,  // 16: buf.registry.module.v1beta1.ModuleService.ListModules:input_type -> buf.registry.module.v1beta1.ListModulesRequest
	5,  // 17: buf.registry.module.v1beta1.ModuleService.CreateModules:input_type -> buf.registry.module.v1beta1.CreateModulesRequest
	7,  // 18: buf.registry.module.v1beta1.ModuleService.UpdateModules:input_type -> buf.registry.module.v1beta1.UpdateModulesRequest
	9,  // 19: buf.registry.module.v1beta1.ModuleService.DeleteModules:input_type -> buf.registry.module.v1beta1.DeleteModulesRequest
	2,  // 20: buf.registry.module.v1beta1.ModuleService.GetModules:output_type -> buf.registry.module.v1beta1.GetModulesResponse
	4,  // 21: buf.registry.module.v1beta1.ModuleService.ListModules:output_type -> buf.registry.module.v1beta1.ListModulesResponse
	6,  // 22: buf.registry.module.v1beta1.ModuleService.CreateModules:output_type -> buf.registry.module.v1beta1.CreateModulesResponse
	8,  // 23: buf.registry.module.v1beta1.ModuleService.UpdateModules:output_type -> buf.registry.module.v1beta1.UpdateModulesResponse
	10, // 24: buf.registry.module.v1beta1.ModuleService.DeleteModules:output_type -> buf.registry.module.v1beta1.DeleteModulesResponse
	20, // [20:25] is the sub-list for method output_type
	15, // [15:20] is the sub-list for method input_type
	15, // [15:15] is the sub-list for extension type_name
	15, // [15:15] is the sub-list for extension extendee
	0,  // [0:15] is the sub-list for field type_name
}

func init() { file_buf_registry_module_v1beta1_module_service_proto_init() }
func file_buf_registry_module_v1beta1_module_service_proto_init() {
	if File_buf_registry_module_v1beta1_module_service_proto != nil {
		return
	}
	file_buf_registry_module_v1beta1_module_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_buf_registry_module_v1beta1_module_service_proto_msgTypes[0].Exporter = func(v any, i int) any {
			switch v := v.(*GetModulesRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_buf_registry_module_v1beta1_module_service_proto_msgTypes[1].Exporter = func(v any, i int) any {
			switch v := v.(*GetModulesResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_buf_registry_module_v1beta1_module_service_proto_msgTypes[2].Exporter = func(v any, i int) any {
			switch v := v.(*ListModulesRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_buf_registry_module_v1beta1_module_service_proto_msgTypes[3].Exporter = func(v any, i int) any {
			switch v := v.(*ListModulesResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_buf_registry_module_v1beta1_module_service_proto_msgTypes[4].Exporter = func(v any, i int) any {
			switch v := v.(*CreateModulesRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_buf_registry_module_v1beta1_module_service_proto_msgTypes[5].Exporter = func(v any, i int) any {
			switch v := v.(*CreateModulesResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_buf_registry_module_v1beta1_module_service_proto_msgTypes[6].Exporter = func(v any, i int) any {
			switch v := v.(*UpdateModulesRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_buf_registry_module_v1beta1_module_service_proto_msgTypes[7].Exporter = func(v any, i int) any {
			switch v := v.(*UpdateModulesResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_buf_registry_module_v1beta1_module_service_proto_msgTypes[8].Exporter = func(v any, i int) any {
			switch v := v.(*DeleteModulesRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_buf_registry_module_v1beta1_module_service_proto_msgTypes[9].Exporter = func(v any, i int) any {
			switch v := v.(*DeleteModulesResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_buf_registry_module_v1beta1_module_service_proto_msgTypes[10].Exporter = func(v any, i int) any {
			switch v := v.(*CreateModulesRequest_Value); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_buf_registry_module_v1beta1_module_service_proto_msgTypes[11].Exporter = func(v any, i int) any {
			switch v := v.(*UpdateModulesRequest_Value); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_buf_registry_module_v1beta1_module_service_proto_msgTypes[11].OneofWrappers = []any{}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_buf_registry_module_v1beta1_module_service_proto_rawDesc,
			NumEnums:      1,
			NumMessages:   12,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_buf_registry_module_v1beta1_module_service_proto_goTypes,
		DependencyIndexes: file_buf_registry_module_v1beta1_module_service_proto_depIdxs,
		EnumInfos:         file_buf_registry_module_v1beta1_module_service_proto_enumTypes,
		MessageInfos:      file_buf_registry_module_v1beta1_module_service_proto_msgTypes,
	}.Build()
	File_buf_registry_module_v1beta1_module_service_proto = out.File
	file_buf_registry_module_v1beta1_module_service_proto_rawDesc = nil
	file_buf_registry_module_v1beta1_module_service_proto_goTypes = nil
	file_buf_registry_module_v1beta1_module_service_proto_depIdxs = nil
}
