// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.34.2
// 	protoc        v4.25.3
// source: google/cloud/securitycenter/v1/event_threat_detection_custom_module.proto

package securitycenterpb

import (
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	structpb "google.golang.org/protobuf/types/known/structpb"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// The enablement state of the module.
type EventThreatDetectionCustomModule_EnablementState int32

const (
	// Unspecified enablement state.
	EventThreatDetectionCustomModule_ENABLEMENT_STATE_UNSPECIFIED EventThreatDetectionCustomModule_EnablementState = 0
	// The module is enabled at the given level.
	EventThreatDetectionCustomModule_ENABLED EventThreatDetectionCustomModule_EnablementState = 1
	// The module is disabled at the given level.
	EventThreatDetectionCustomModule_DISABLED EventThreatDetectionCustomModule_EnablementState = 2
	// When the enablement state is inherited.
	EventThreatDetectionCustomModule_INHERITED EventThreatDetectionCustomModule_EnablementState = 3
)

// Enum value maps for EventThreatDetectionCustomModule_EnablementState.
var (
	EventThreatDetectionCustomModule_EnablementState_name = map[int32]string{
		0: "ENABLEMENT_STATE_UNSPECIFIED",
		1: "ENABLED",
		2: "DISABLED",
		3: "INHERITED",
	}
	EventThreatDetectionCustomModule_EnablementState_value = map[string]int32{
		"ENABLEMENT_STATE_UNSPECIFIED": 0,
		"ENABLED":                      1,
		"DISABLED":                     2,
		"INHERITED":                    3,
	}
)

func (x EventThreatDetectionCustomModule_EnablementState) Enum() *EventThreatDetectionCustomModule_EnablementState {
	p := new(EventThreatDetectionCustomModule_EnablementState)
	*p = x
	return p
}

func (x EventThreatDetectionCustomModule_EnablementState) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (EventThreatDetectionCustomModule_EnablementState) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_securitycenter_v1_event_threat_detection_custom_module_proto_enumTypes[0].Descriptor()
}

func (EventThreatDetectionCustomModule_EnablementState) Type() protoreflect.EnumType {
	return &file_google_cloud_securitycenter_v1_event_threat_detection_custom_module_proto_enumTypes[0]
}

func (x EventThreatDetectionCustomModule_EnablementState) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use EventThreatDetectionCustomModule_EnablementState.Descriptor instead.
func (EventThreatDetectionCustomModule_EnablementState) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_securitycenter_v1_event_threat_detection_custom_module_proto_rawDescGZIP(), []int{0, 0}
}

// Represents an instance of an Event Threat Detection custom module,
// including its full module name, display name, enablement state, and last
// updated time. You can create a custom module at the organization, folder, or
// project level. Custom modules that you create at the organization or folder
// level are inherited by child folders and projects.
type EventThreatDetectionCustomModule struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Immutable. The resource name of the Event Threat Detection custom module.
	//
	// Its format is:
	//
	//   - `organizations/{organization}/eventThreatDetectionSettings/customModules/{module}`.
	//   - `folders/{folder}/eventThreatDetectionSettings/customModules/{module}`.
	//   - `projects/{project}/eventThreatDetectionSettings/customModules/{module}`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Config for the module. For the resident module, its config value is defined
	// at this level. For the inherited module, its config value is inherited from
	// the ancestor module.
	Config *structpb.Struct `protobuf:"bytes,2,opt,name=config,proto3" json:"config,omitempty"`
	// Output only. The closest ancestor module that this module inherits the
	// enablement state from. The format is the same as the
	// EventThreatDetectionCustomModule resource name.
	AncestorModule string `protobuf:"bytes,3,opt,name=ancestor_module,json=ancestorModule,proto3" json:"ancestor_module,omitempty"`
	// The state of enablement for the module at the given level of the hierarchy.
	EnablementState EventThreatDetectionCustomModule_EnablementState `protobuf:"varint,4,opt,name=enablement_state,json=enablementState,proto3,enum=google.cloud.securitycenter.v1.EventThreatDetectionCustomModule_EnablementState" json:"enablement_state,omitempty"`
	// Type for the module. e.g. CONFIGURABLE_BAD_IP.
	Type string `protobuf:"bytes,5,opt,name=type,proto3" json:"type,omitempty"`
	// The human readable name to be displayed for the module.
	DisplayName string `protobuf:"bytes,6,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// The description for the module.
	Description string `protobuf:"bytes,7,opt,name=description,proto3" json:"description,omitempty"`
	// Output only. The time the module was last updated.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,8,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// Output only. The editor the module was last updated by.
	LastEditor string `protobuf:"bytes,9,opt,name=last_editor,json=lastEditor,proto3" json:"last_editor,omitempty"`
}

func (x *EventThreatDetectionCustomModule) Reset() {
	*x = EventThreatDetectionCustomModule{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_securitycenter_v1_event_threat_detection_custom_module_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *EventThreatDetectionCustomModule) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*EventThreatDetectionCustomModule) ProtoMessage() {}

func (x *EventThreatDetectionCustomModule) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_securitycenter_v1_event_threat_detection_custom_module_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use EventThreatDetectionCustomModule.ProtoReflect.Descriptor instead.
func (*EventThreatDetectionCustomModule) Descriptor() ([]byte, []int) {
	return file_google_cloud_securitycenter_v1_event_threat_detection_custom_module_proto_rawDescGZIP(), []int{0}
}

func (x *EventThreatDetectionCustomModule) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *EventThreatDetectionCustomModule) GetConfig() *structpb.Struct {
	if x != nil {
		return x.Config
	}
	return nil
}

func (x *EventThreatDetectionCustomModule) GetAncestorModule() string {
	if x != nil {
		return x.AncestorModule
	}
	return ""
}

func (x *EventThreatDetectionCustomModule) GetEnablementState() EventThreatDetectionCustomModule_EnablementState {
	if x != nil {
		return x.EnablementState
	}
	return EventThreatDetectionCustomModule_ENABLEMENT_STATE_UNSPECIFIED
}

func (x *EventThreatDetectionCustomModule) GetType() string {
	if x != nil {
		return x.Type
	}
	return ""
}

func (x *EventThreatDetectionCustomModule) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

func (x *EventThreatDetectionCustomModule) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *EventThreatDetectionCustomModule) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

func (x *EventThreatDetectionCustomModule) GetLastEditor() string {
	if x != nil {
		return x.LastEditor
	}
	return ""
}

var File_google_cloud_securitycenter_v1_event_threat_detection_custom_module_proto protoreflect.FileDescriptor

var file_google_cloud_securitycenter_v1_event_threat_detection_custom_module_proto_rawDesc = []byte{
	0x0a, 0x49, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x73,
	0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2f, 0x76, 0x31,
	0x2f, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x5f, 0x74, 0x68, 0x72, 0x65, 0x61, 0x74, 0x5f, 0x64, 0x65,
	0x74, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x5f, 0x6d,
	0x6f, 0x64, 0x75, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x1e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69,
	0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x1a, 0x1f, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65,
	0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xa1, 0x07, 0x0a, 0x20, 0x45, 0x76, 0x65, 0x6e, 0x74,
	0x54, 0x68, 0x72, 0x65, 0x61, 0x74, 0x44, 0x65, 0x74, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x43,
	0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x12, 0x17, 0x0a, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x05, 0x52, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x12, 0x2f, 0x0a, 0x06, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53, 0x74, 0x72, 0x75, 0x63, 0x74, 0x52, 0x06, 0x63,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x6f, 0x0a, 0x0f, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x74, 0x6f,
	0x72, 0x5f, 0x6d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x46,
	0xe0, 0x41, 0x03, 0xfa, 0x41, 0x40, 0x0a, 0x3e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79,
	0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69,
	0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x54, 0x68, 0x72, 0x65, 0x61,
	0x74, 0x44, 0x65, 0x74, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d,
	0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x52, 0x0e, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x74, 0x6f, 0x72,
	0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x12, 0x7b, 0x0a, 0x10, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65,
	0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0e,
	0x32, 0x50, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76,
	0x31, 0x2e, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x54, 0x68, 0x72, 0x65, 0x61, 0x74, 0x44, 0x65, 0x74,
	0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x6f, 0x64, 0x75,
	0x6c, 0x65, 0x2e, 0x45, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x53, 0x74, 0x61,
	0x74, 0x65, 0x52, 0x0f, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x53, 0x74,
	0x61, 0x74, 0x65, 0x12, 0x12, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x04, 0x74, 0x79, 0x70, 0x65, 0x12, 0x21, 0x0a, 0x0c, 0x64, 0x69, 0x73, 0x70, 0x6c,
	0x61, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x64,
	0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x20, 0x0a, 0x0b, 0x64, 0x65,
	0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x07, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x40, 0x0a, 0x0b,
	0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x08, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0,
	0x41, 0x03, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x24,
	0x0a, 0x0b, 0x6c, 0x61, 0x73, 0x74, 0x5f, 0x65, 0x64, 0x69, 0x74, 0x6f, 0x72, 0x18, 0x09, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x6c, 0x61, 0x73, 0x74, 0x45, 0x64,
	0x69, 0x74, 0x6f, 0x72, 0x22, 0x5d, 0x0a, 0x0f, 0x45, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x6d, 0x65,
	0x6e, 0x74, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x20, 0x0a, 0x1c, 0x45, 0x4e, 0x41, 0x42, 0x4c,
	0x45, 0x4d, 0x45, 0x4e, 0x54, 0x5f, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50,
	0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0b, 0x0a, 0x07, 0x45, 0x4e, 0x41,
	0x42, 0x4c, 0x45, 0x44, 0x10, 0x01, 0x12, 0x0c, 0x0a, 0x08, 0x44, 0x49, 0x53, 0x41, 0x42, 0x4c,
	0x45, 0x44, 0x10, 0x02, 0x12, 0x0d, 0x0a, 0x09, 0x49, 0x4e, 0x48, 0x45, 0x52, 0x49, 0x54, 0x45,
	0x44, 0x10, 0x03, 0x3a, 0xa4, 0x02, 0xea, 0x41, 0xa0, 0x02, 0x0a, 0x3e, 0x73, 0x65, 0x63, 0x75,
	0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x54,
	0x68, 0x72, 0x65, 0x61, 0x74, 0x44, 0x65, 0x74, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x75,
	0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x12, 0x50, 0x6f, 0x72, 0x67, 0x61,
	0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6f, 0x72, 0x67, 0x61, 0x6e,
	0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x54, 0x68,
	0x72, 0x65, 0x61, 0x74, 0x44, 0x65, 0x74, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x65, 0x74,
	0x74, 0x69, 0x6e, 0x67, 0x73, 0x2f, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x6f, 0x64, 0x75,
	0x6c, 0x65, 0x73, 0x2f, 0x7b, 0x6d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x7d, 0x12, 0x44, 0x66, 0x6f,
	0x6c, 0x64, 0x65, 0x72, 0x73, 0x2f, 0x7b, 0x66, 0x6f, 0x6c, 0x64, 0x65, 0x72, 0x7d, 0x2f, 0x65,
	0x76, 0x65, 0x6e, 0x74, 0x54, 0x68, 0x72, 0x65, 0x61, 0x74, 0x44, 0x65, 0x74, 0x65, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x2f, 0x63, 0x75, 0x73, 0x74,
	0x6f, 0x6d, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x73, 0x2f, 0x7b, 0x6d, 0x6f, 0x64, 0x75, 0x6c,
	0x65, 0x7d, 0x12, 0x46, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x54, 0x68, 0x72, 0x65,
	0x61, 0x74, 0x44, 0x65, 0x74, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x65, 0x74, 0x74, 0x69,
	0x6e, 0x67, 0x73, 0x2f, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65,
	0x73, 0x2f, 0x7b, 0x6d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x7d, 0x42, 0xff, 0x01, 0x0a, 0x22, 0x63,
	0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76,
	0x31, 0x42, 0x25, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x54, 0x68, 0x72, 0x65, 0x61, 0x74, 0x44, 0x65,
	0x74, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x6f, 0x64,
	0x75, 0x6c, 0x65, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x4a, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x67, 0x6f, 0x2f,
	0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2f, 0x61,
	0x70, 0x69, 0x76, 0x31, 0x2f, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e,
	0x74, 0x65, 0x72, 0x70, 0x62, 0x3b, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65,
	0x6e, 0x74, 0x65, 0x72, 0x70, 0x62, 0xaa, 0x02, 0x1e, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x43, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x53, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x43, 0x65,
	0x6e, 0x74, 0x65, 0x72, 0x2e, 0x56, 0x31, 0xca, 0x02, 0x1e, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x5c, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x5c, 0x53, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x43,
	0x65, 0x6e, 0x74, 0x65, 0x72, 0x5c, 0x56, 0x31, 0xea, 0x02, 0x21, 0x47, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x3a, 0x3a, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x3a, 0x3a, 0x53, 0x65, 0x63, 0x75, 0x72, 0x69,
	0x74, 0x79, 0x43, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x3a, 0x3a, 0x56, 0x31, 0x62, 0x06, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_securitycenter_v1_event_threat_detection_custom_module_proto_rawDescOnce sync.Once
	file_google_cloud_securitycenter_v1_event_threat_detection_custom_module_proto_rawDescData = file_google_cloud_securitycenter_v1_event_threat_detection_custom_module_proto_rawDesc
)

func file_google_cloud_securitycenter_v1_event_threat_detection_custom_module_proto_rawDescGZIP() []byte {
	file_google_cloud_securitycenter_v1_event_threat_detection_custom_module_proto_rawDescOnce.Do(func() {
		file_google_cloud_securitycenter_v1_event_threat_detection_custom_module_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_securitycenter_v1_event_threat_detection_custom_module_proto_rawDescData)
	})
	return file_google_cloud_securitycenter_v1_event_threat_detection_custom_module_proto_rawDescData
}

var file_google_cloud_securitycenter_v1_event_threat_detection_custom_module_proto_enumTypes = make([]protoimpl.EnumInfo, 1)
var file_google_cloud_securitycenter_v1_event_threat_detection_custom_module_proto_msgTypes = make([]protoimpl.MessageInfo, 1)
var file_google_cloud_securitycenter_v1_event_threat_detection_custom_module_proto_goTypes = []any{
	(EventThreatDetectionCustomModule_EnablementState)(0), // 0: google.cloud.securitycenter.v1.EventThreatDetectionCustomModule.EnablementState
	(*EventThreatDetectionCustomModule)(nil),              // 1: google.cloud.securitycenter.v1.EventThreatDetectionCustomModule
	(*structpb.Struct)(nil),                               // 2: google.protobuf.Struct
	(*timestamppb.Timestamp)(nil),                         // 3: google.protobuf.Timestamp
}
var file_google_cloud_securitycenter_v1_event_threat_detection_custom_module_proto_depIdxs = []int32{
	2, // 0: google.cloud.securitycenter.v1.EventThreatDetectionCustomModule.config:type_name -> google.protobuf.Struct
	0, // 1: google.cloud.securitycenter.v1.EventThreatDetectionCustomModule.enablement_state:type_name -> google.cloud.securitycenter.v1.EventThreatDetectionCustomModule.EnablementState
	3, // 2: google.cloud.securitycenter.v1.EventThreatDetectionCustomModule.update_time:type_name -> google.protobuf.Timestamp
	3, // [3:3] is the sub-list for method output_type
	3, // [3:3] is the sub-list for method input_type
	3, // [3:3] is the sub-list for extension type_name
	3, // [3:3] is the sub-list for extension extendee
	0, // [0:3] is the sub-list for field type_name
}

func init() { file_google_cloud_securitycenter_v1_event_threat_detection_custom_module_proto_init() }
func file_google_cloud_securitycenter_v1_event_threat_detection_custom_module_proto_init() {
	if File_google_cloud_securitycenter_v1_event_threat_detection_custom_module_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_google_cloud_securitycenter_v1_event_threat_detection_custom_module_proto_msgTypes[0].Exporter = func(v any, i int) any {
			switch v := v.(*EventThreatDetectionCustomModule); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_securitycenter_v1_event_threat_detection_custom_module_proto_rawDesc,
			NumEnums:      1,
			NumMessages:   1,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_cloud_securitycenter_v1_event_threat_detection_custom_module_proto_goTypes,
		DependencyIndexes: file_google_cloud_securitycenter_v1_event_threat_detection_custom_module_proto_depIdxs,
		EnumInfos:         file_google_cloud_securitycenter_v1_event_threat_detection_custom_module_proto_enumTypes,
		MessageInfos:      file_google_cloud_securitycenter_v1_event_threat_detection_custom_module_proto_msgTypes,
	}.Build()
	File_google_cloud_securitycenter_v1_event_threat_detection_custom_module_proto = out.File
	file_google_cloud_securitycenter_v1_event_threat_detection_custom_module_proto_rawDesc = nil
	file_google_cloud_securitycenter_v1_event_threat_detection_custom_module_proto_goTypes = nil
	file_google_cloud_securitycenter_v1_event_threat_detection_custom_module_proto_depIdxs = nil
}
