package bart

// noCopy may be added to structs which must not be copied
// after the first use.
//
//	type My struct {
//		_ noCopy
//		A state
//		b foo
//	}
//
// See https://golang.org/issues/8005#issuecomment-190753527
// for details.
//
// Note that it must not be embedded, due to the Lock and Unlock methods.
type noCopy struct{}

// Lock is a no-op used by -copylocks checker from `go vet`.
func (*noCopy) Lock()   {}
func (*noCopy) Unlock() {}
