// Code generated by cuelang.org/go/pkg/gen. DO NOT EDIT.

package strings

import (
	"cuelang.org/go/internal/core/adt"
	"cuelang.org/go/pkg/internal"
)

func init() {
	internal.Register("strings", pkg)
}

var _ = adt.TopKind // in case the adt package isn't used

var pkg = &internal.Package{
	Native: []*internal.Builtin{{
		Name: "ByteAt",
		Params: []internal.Param{
			{Kind: adt.BytesKind | adt.StringKind},
			{Kind: adt.IntKind},
		},
		Result: adt.IntKind,
		Func: func(c *internal.CallCtxt) {
			b, i := c.Bytes(0), c.Int(1)
			if c.Do() {
				c.Ret, c.Err = ByteAt(b, i)
			}
		},
	}, {
		Name: "ByteSlice",
		Params: []internal.Param{
			{Kind: adt.BytesKind | adt.StringKind},
			{Kind: adt.IntKind},
			{Kind: adt.IntKind},
		},
		Result: adt.BytesKind | adt.StringKind,
		Func: func(c *internal.CallCtxt) {
			b, start, end := c.Bytes(0), c.Int(1), c.Int(2)
			if c.Do() {
				c.Ret, c.Err = ByteSlice(b, start, end)
			}
		},
	}, {
		Name: "Runes",
		Params: []internal.Param{
			{Kind: adt.StringKind},
		},
		Result: adt.ListKind,
		Func: func(c *internal.CallCtxt) {
			s := c.String(0)
			if c.Do() {
				c.Ret = Runes(s)
			}
		},
	}, {
		Name: "MinRunes",
		Params: []internal.Param{
			{Kind: adt.StringKind},
			{Kind: adt.IntKind},
		},
		Result: adt.BoolKind,
		Func: func(c *internal.CallCtxt) {
			s, min := c.String(0), c.Int(1)
			if c.Do() {
				c.Ret = MinRunes(s, min)
			}
		},
	}, {
		Name: "MaxRunes",
		Params: []internal.Param{
			{Kind: adt.StringKind},
			{Kind: adt.IntKind},
		},
		Result: adt.BoolKind,
		Func: func(c *internal.CallCtxt) {
			s, max := c.String(0), c.Int(1)
			if c.Do() {
				c.Ret = MaxRunes(s, max)
			}
		},
	}, {
		Name: "ToTitle",
		Params: []internal.Param{
			{Kind: adt.StringKind},
		},
		Result: adt.StringKind,
		Func: func(c *internal.CallCtxt) {
			s := c.String(0)
			if c.Do() {
				c.Ret = ToTitle(s)
			}
		},
	}, {
		Name: "ToCamel",
		Params: []internal.Param{
			{Kind: adt.StringKind},
		},
		Result: adt.StringKind,
		Func: func(c *internal.CallCtxt) {
			s := c.String(0)
			if c.Do() {
				c.Ret = ToCamel(s)
			}
		},
	}, {
		Name: "SliceRunes",
		Params: []internal.Param{
			{Kind: adt.StringKind},
			{Kind: adt.IntKind},
			{Kind: adt.IntKind},
		},
		Result: adt.StringKind,
		Func: func(c *internal.CallCtxt) {
			s, start, end := c.String(0), c.Int(1), c.Int(2)
			if c.Do() {
				c.Ret, c.Err = SliceRunes(s, start, end)
			}
		},
	}, {
		Name: "Compare",
		Params: []internal.Param{
			{Kind: adt.StringKind},
			{Kind: adt.StringKind},
		},
		Result: adt.IntKind,
		Func: func(c *internal.CallCtxt) {
			a, b := c.String(0), c.String(1)
			if c.Do() {
				c.Ret = Compare(a, b)
			}
		},
	}, {
		Name: "Count",
		Params: []internal.Param{
			{Kind: adt.StringKind},
			{Kind: adt.StringKind},
		},
		Result: adt.IntKind,
		Func: func(c *internal.CallCtxt) {
			s, substr := c.String(0), c.String(1)
			if c.Do() {
				c.Ret = Count(s, substr)
			}
		},
	}, {
		Name: "Contains",
		Params: []internal.Param{
			{Kind: adt.StringKind},
			{Kind: adt.StringKind},
		},
		Result: adt.BoolKind,
		Func: func(c *internal.CallCtxt) {
			s, substr := c.String(0), c.String(1)
			if c.Do() {
				c.Ret = Contains(s, substr)
			}
		},
	}, {
		Name: "ContainsAny",
		Params: []internal.Param{
			{Kind: adt.StringKind},
			{Kind: adt.StringKind},
		},
		Result: adt.BoolKind,
		Func: func(c *internal.CallCtxt) {
			s, chars := c.String(0), c.String(1)
			if c.Do() {
				c.Ret = ContainsAny(s, chars)
			}
		},
	}, {
		Name: "LastIndex",
		Params: []internal.Param{
			{Kind: adt.StringKind},
			{Kind: adt.StringKind},
		},
		Result: adt.IntKind,
		Func: func(c *internal.CallCtxt) {
			s, substr := c.String(0), c.String(1)
			if c.Do() {
				c.Ret = LastIndex(s, substr)
			}
		},
	}, {
		Name: "IndexAny",
		Params: []internal.Param{
			{Kind: adt.StringKind},
			{Kind: adt.StringKind},
		},
		Result: adt.IntKind,
		Func: func(c *internal.CallCtxt) {
			s, chars := c.String(0), c.String(1)
			if c.Do() {
				c.Ret = IndexAny(s, chars)
			}
		},
	}, {
		Name: "LastIndexAny",
		Params: []internal.Param{
			{Kind: adt.StringKind},
			{Kind: adt.StringKind},
		},
		Result: adt.IntKind,
		Func: func(c *internal.CallCtxt) {
			s, chars := c.String(0), c.String(1)
			if c.Do() {
				c.Ret = LastIndexAny(s, chars)
			}
		},
	}, {
		Name: "SplitN",
		Params: []internal.Param{
			{Kind: adt.StringKind},
			{Kind: adt.StringKind},
			{Kind: adt.IntKind},
		},
		Result: adt.ListKind,
		Func: func(c *internal.CallCtxt) {
			s, sep, n := c.String(0), c.String(1), c.Int(2)
			if c.Do() {
				c.Ret = SplitN(s, sep, n)
			}
		},
	}, {
		Name: "SplitAfterN",
		Params: []internal.Param{
			{Kind: adt.StringKind},
			{Kind: adt.StringKind},
			{Kind: adt.IntKind},
		},
		Result: adt.ListKind,
		Func: func(c *internal.CallCtxt) {
			s, sep, n := c.String(0), c.String(1), c.Int(2)
			if c.Do() {
				c.Ret = SplitAfterN(s, sep, n)
			}
		},
	}, {
		Name: "Split",
		Params: []internal.Param{
			{Kind: adt.StringKind},
			{Kind: adt.StringKind},
		},
		Result: adt.ListKind,
		Func: func(c *internal.CallCtxt) {
			s, sep := c.String(0), c.String(1)
			if c.Do() {
				c.Ret = Split(s, sep)
			}
		},
	}, {
		Name: "SplitAfter",
		Params: []internal.Param{
			{Kind: adt.StringKind},
			{Kind: adt.StringKind},
		},
		Result: adt.ListKind,
		Func: func(c *internal.CallCtxt) {
			s, sep := c.String(0), c.String(1)
			if c.Do() {
				c.Ret = SplitAfter(s, sep)
			}
		},
	}, {
		Name: "Fields",
		Params: []internal.Param{
			{Kind: adt.StringKind},
		},
		Result: adt.ListKind,
		Func: func(c *internal.CallCtxt) {
			s := c.String(0)
			if c.Do() {
				c.Ret = Fields(s)
			}
		},
	}, {
		Name: "Join",
		Params: []internal.Param{
			{Kind: adt.ListKind},
			{Kind: adt.StringKind},
		},
		Result: adt.StringKind,
		Func: func(c *internal.CallCtxt) {
			elems, sep := c.StringList(0), c.String(1)
			if c.Do() {
				c.Ret = Join(elems, sep)
			}
		},
	}, {
		Name: "HasPrefix",
		Params: []internal.Param{
			{Kind: adt.StringKind},
			{Kind: adt.StringKind},
		},
		Result: adt.BoolKind,
		Func: func(c *internal.CallCtxt) {
			s, prefix := c.String(0), c.String(1)
			if c.Do() {
				c.Ret = HasPrefix(s, prefix)
			}
		},
	}, {
		Name: "HasSuffix",
		Params: []internal.Param{
			{Kind: adt.StringKind},
			{Kind: adt.StringKind},
		},
		Result: adt.BoolKind,
		Func: func(c *internal.CallCtxt) {
			s, suffix := c.String(0), c.String(1)
			if c.Do() {
				c.Ret = HasSuffix(s, suffix)
			}
		},
	}, {
		Name: "Repeat",
		Params: []internal.Param{
			{Kind: adt.StringKind},
			{Kind: adt.IntKind},
		},
		Result: adt.StringKind,
		Func: func(c *internal.CallCtxt) {
			s, count := c.String(0), c.Int(1)
			if c.Do() {
				c.Ret = Repeat(s, count)
			}
		},
	}, {
		Name: "ToUpper",
		Params: []internal.Param{
			{Kind: adt.StringKind},
		},
		Result: adt.StringKind,
		Func: func(c *internal.CallCtxt) {
			s := c.String(0)
			if c.Do() {
				c.Ret = ToUpper(s)
			}
		},
	}, {
		Name: "ToLower",
		Params: []internal.Param{
			{Kind: adt.StringKind},
		},
		Result: adt.StringKind,
		Func: func(c *internal.CallCtxt) {
			s := c.String(0)
			if c.Do() {
				c.Ret = ToLower(s)
			}
		},
	}, {
		Name: "Trim",
		Params: []internal.Param{
			{Kind: adt.StringKind},
			{Kind: adt.StringKind},
		},
		Result: adt.StringKind,
		Func: func(c *internal.CallCtxt) {
			s, cutset := c.String(0), c.String(1)
			if c.Do() {
				c.Ret = Trim(s, cutset)
			}
		},
	}, {
		Name: "TrimLeft",
		Params: []internal.Param{
			{Kind: adt.StringKind},
			{Kind: adt.StringKind},
		},
		Result: adt.StringKind,
		Func: func(c *internal.CallCtxt) {
			s, cutset := c.String(0), c.String(1)
			if c.Do() {
				c.Ret = TrimLeft(s, cutset)
			}
		},
	}, {
		Name: "TrimRight",
		Params: []internal.Param{
			{Kind: adt.StringKind},
			{Kind: adt.StringKind},
		},
		Result: adt.StringKind,
		Func: func(c *internal.CallCtxt) {
			s, cutset := c.String(0), c.String(1)
			if c.Do() {
				c.Ret = TrimRight(s, cutset)
			}
		},
	}, {
		Name: "TrimSpace",
		Params: []internal.Param{
			{Kind: adt.StringKind},
		},
		Result: adt.StringKind,
		Func: func(c *internal.CallCtxt) {
			s := c.String(0)
			if c.Do() {
				c.Ret = TrimSpace(s)
			}
		},
	}, {
		Name: "TrimPrefix",
		Params: []internal.Param{
			{Kind: adt.StringKind},
			{Kind: adt.StringKind},
		},
		Result: adt.StringKind,
		Func: func(c *internal.CallCtxt) {
			s, prefix := c.String(0), c.String(1)
			if c.Do() {
				c.Ret = TrimPrefix(s, prefix)
			}
		},
	}, {
		Name: "TrimSuffix",
		Params: []internal.Param{
			{Kind: adt.StringKind},
			{Kind: adt.StringKind},
		},
		Result: adt.StringKind,
		Func: func(c *internal.CallCtxt) {
			s, suffix := c.String(0), c.String(1)
			if c.Do() {
				c.Ret = TrimSuffix(s, suffix)
			}
		},
	}, {
		Name: "Replace",
		Params: []internal.Param{
			{Kind: adt.StringKind},
			{Kind: adt.StringKind},
			{Kind: adt.StringKind},
			{Kind: adt.IntKind},
		},
		Result: adt.StringKind,
		Func: func(c *internal.CallCtxt) {
			s, old, new, n := c.String(0), c.String(1), c.String(2), c.Int(3)
			if c.Do() {
				c.Ret = Replace(s, old, new, n)
			}
		},
	}, {
		Name: "Index",
		Params: []internal.Param{
			{Kind: adt.StringKind},
			{Kind: adt.StringKind},
		},
		Result: adt.IntKind,
		Func: func(c *internal.CallCtxt) {
			s, substr := c.String(0), c.String(1)
			if c.Do() {
				c.Ret = Index(s, substr)
			}
		},
	}},
}
