// Code generated by go-swagger; DO NOT EDIT.

package admin

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/grafana/grafana-openapi-client-go/models"
)

// AdminGetSettingsReader is a Reader for the AdminGetSettings structure.
type AdminGetSettingsReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *AdminGetSettingsReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewAdminGetSettingsOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 401:
		result := NewAdminGetSettingsUnauthorized()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 403:
		result := NewAdminGetSettingsForbidden()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("[GET /admin/settings] adminGetSettings", response, response.Code())
	}
}

// NewAdminGetSettingsOK creates a AdminGetSettingsOK with default headers values
func NewAdminGetSettingsOK() *AdminGetSettingsOK {
	return &AdminGetSettingsOK{}
}

/*
AdminGetSettingsOK describes a response with status code 200, with default header values.

(empty)
*/
type AdminGetSettingsOK struct {
	Payload models.SettingsBag
}

// IsSuccess returns true when this admin get settings Ok response has a 2xx status code
func (o *AdminGetSettingsOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this admin get settings Ok response has a 3xx status code
func (o *AdminGetSettingsOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this admin get settings Ok response has a 4xx status code
func (o *AdminGetSettingsOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this admin get settings Ok response has a 5xx status code
func (o *AdminGetSettingsOK) IsServerError() bool {
	return false
}

// IsCode returns true when this admin get settings Ok response a status code equal to that given
func (o *AdminGetSettingsOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the admin get settings Ok response
func (o *AdminGetSettingsOK) Code() int {
	return 200
}

func (o *AdminGetSettingsOK) Error() string {
	return fmt.Sprintf("[GET /admin/settings][%d] adminGetSettingsOk  %+v", 200, o.Payload)
}

func (o *AdminGetSettingsOK) String() string {
	return fmt.Sprintf("[GET /admin/settings][%d] adminGetSettingsOk  %+v", 200, o.Payload)
}

func (o *AdminGetSettingsOK) GetPayload() models.SettingsBag {
	return o.Payload
}

func (o *AdminGetSettingsOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// response payload
	if err := consumer.Consume(response.Body(), &o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewAdminGetSettingsUnauthorized creates a AdminGetSettingsUnauthorized with default headers values
func NewAdminGetSettingsUnauthorized() *AdminGetSettingsUnauthorized {
	return &AdminGetSettingsUnauthorized{}
}

/*
AdminGetSettingsUnauthorized describes a response with status code 401, with default header values.

UnauthorizedError is returned when the request is not authenticated.
*/
type AdminGetSettingsUnauthorized struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this admin get settings unauthorized response has a 2xx status code
func (o *AdminGetSettingsUnauthorized) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this admin get settings unauthorized response has a 3xx status code
func (o *AdminGetSettingsUnauthorized) IsRedirect() bool {
	return false
}

// IsClientError returns true when this admin get settings unauthorized response has a 4xx status code
func (o *AdminGetSettingsUnauthorized) IsClientError() bool {
	return true
}

// IsServerError returns true when this admin get settings unauthorized response has a 5xx status code
func (o *AdminGetSettingsUnauthorized) IsServerError() bool {
	return false
}

// IsCode returns true when this admin get settings unauthorized response a status code equal to that given
func (o *AdminGetSettingsUnauthorized) IsCode(code int) bool {
	return code == 401
}

// Code gets the status code for the admin get settings unauthorized response
func (o *AdminGetSettingsUnauthorized) Code() int {
	return 401
}

func (o *AdminGetSettingsUnauthorized) Error() string {
	return fmt.Sprintf("[GET /admin/settings][%d] adminGetSettingsUnauthorized  %+v", 401, o.Payload)
}

func (o *AdminGetSettingsUnauthorized) String() string {
	return fmt.Sprintf("[GET /admin/settings][%d] adminGetSettingsUnauthorized  %+v", 401, o.Payload)
}

func (o *AdminGetSettingsUnauthorized) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *AdminGetSettingsUnauthorized) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewAdminGetSettingsForbidden creates a AdminGetSettingsForbidden with default headers values
func NewAdminGetSettingsForbidden() *AdminGetSettingsForbidden {
	return &AdminGetSettingsForbidden{}
}

/*
AdminGetSettingsForbidden describes a response with status code 403, with default header values.

ForbiddenError is returned if the user/token has insufficient permissions to access the requested resource.
*/
type AdminGetSettingsForbidden struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this admin get settings forbidden response has a 2xx status code
func (o *AdminGetSettingsForbidden) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this admin get settings forbidden response has a 3xx status code
func (o *AdminGetSettingsForbidden) IsRedirect() bool {
	return false
}

// IsClientError returns true when this admin get settings forbidden response has a 4xx status code
func (o *AdminGetSettingsForbidden) IsClientError() bool {
	return true
}

// IsServerError returns true when this admin get settings forbidden response has a 5xx status code
func (o *AdminGetSettingsForbidden) IsServerError() bool {
	return false
}

// IsCode returns true when this admin get settings forbidden response a status code equal to that given
func (o *AdminGetSettingsForbidden) IsCode(code int) bool {
	return code == 403
}

// Code gets the status code for the admin get settings forbidden response
func (o *AdminGetSettingsForbidden) Code() int {
	return 403
}

func (o *AdminGetSettingsForbidden) Error() string {
	return fmt.Sprintf("[GET /admin/settings][%d] adminGetSettingsForbidden  %+v", 403, o.Payload)
}

func (o *AdminGetSettingsForbidden) String() string {
	return fmt.Sprintf("[GET /admin/settings][%d] adminGetSettingsForbidden  %+v", 403, o.Payload)
}

func (o *AdminGetSettingsForbidden) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *AdminGetSettingsForbidden) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
