// Code generated by go-swagger; DO NOT EDIT.

package org

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/grafana/grafana-openapi-client-go/models"
)

// UpdateCurrentOrgReader is a Reader for the UpdateCurrentOrg structure.
type UpdateCurrentOrgReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *UpdateCurrentOrgReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewUpdateCurrentOrgOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 400:
		result := NewUpdateCurrentOrgBadRequest()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 401:
		result := NewUpdateCurrentOrgUnauthorized()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 403:
		result := NewUpdateCurrentOrgForbidden()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 500:
		result := NewUpdateCurrentOrgInternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("[PUT /org] updateCurrentOrg", response, response.Code())
	}
}

// NewUpdateCurrentOrgOK creates a UpdateCurrentOrgOK with default headers values
func NewUpdateCurrentOrgOK() *UpdateCurrentOrgOK {
	return &UpdateCurrentOrgOK{}
}

/*
UpdateCurrentOrgOK describes a response with status code 200, with default header values.

An OKResponse is returned if the request was successful.
*/
type UpdateCurrentOrgOK struct {
	Payload *models.SuccessResponseBody
}

// IsSuccess returns true when this update current org Ok response has a 2xx status code
func (o *UpdateCurrentOrgOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this update current org Ok response has a 3xx status code
func (o *UpdateCurrentOrgOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this update current org Ok response has a 4xx status code
func (o *UpdateCurrentOrgOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this update current org Ok response has a 5xx status code
func (o *UpdateCurrentOrgOK) IsServerError() bool {
	return false
}

// IsCode returns true when this update current org Ok response a status code equal to that given
func (o *UpdateCurrentOrgOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the update current org Ok response
func (o *UpdateCurrentOrgOK) Code() int {
	return 200
}

func (o *UpdateCurrentOrgOK) Error() string {
	return fmt.Sprintf("[PUT /org][%d] updateCurrentOrgOk  %+v", 200, o.Payload)
}

func (o *UpdateCurrentOrgOK) String() string {
	return fmt.Sprintf("[PUT /org][%d] updateCurrentOrgOk  %+v", 200, o.Payload)
}

func (o *UpdateCurrentOrgOK) GetPayload() *models.SuccessResponseBody {
	return o.Payload
}

func (o *UpdateCurrentOrgOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.SuccessResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewUpdateCurrentOrgBadRequest creates a UpdateCurrentOrgBadRequest with default headers values
func NewUpdateCurrentOrgBadRequest() *UpdateCurrentOrgBadRequest {
	return &UpdateCurrentOrgBadRequest{}
}

/*
UpdateCurrentOrgBadRequest describes a response with status code 400, with default header values.

BadRequestError is returned when the request is invalid and it cannot be processed.
*/
type UpdateCurrentOrgBadRequest struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this update current org bad request response has a 2xx status code
func (o *UpdateCurrentOrgBadRequest) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this update current org bad request response has a 3xx status code
func (o *UpdateCurrentOrgBadRequest) IsRedirect() bool {
	return false
}

// IsClientError returns true when this update current org bad request response has a 4xx status code
func (o *UpdateCurrentOrgBadRequest) IsClientError() bool {
	return true
}

// IsServerError returns true when this update current org bad request response has a 5xx status code
func (o *UpdateCurrentOrgBadRequest) IsServerError() bool {
	return false
}

// IsCode returns true when this update current org bad request response a status code equal to that given
func (o *UpdateCurrentOrgBadRequest) IsCode(code int) bool {
	return code == 400
}

// Code gets the status code for the update current org bad request response
func (o *UpdateCurrentOrgBadRequest) Code() int {
	return 400
}

func (o *UpdateCurrentOrgBadRequest) Error() string {
	return fmt.Sprintf("[PUT /org][%d] updateCurrentOrgBadRequest  %+v", 400, o.Payload)
}

func (o *UpdateCurrentOrgBadRequest) String() string {
	return fmt.Sprintf("[PUT /org][%d] updateCurrentOrgBadRequest  %+v", 400, o.Payload)
}

func (o *UpdateCurrentOrgBadRequest) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *UpdateCurrentOrgBadRequest) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewUpdateCurrentOrgUnauthorized creates a UpdateCurrentOrgUnauthorized with default headers values
func NewUpdateCurrentOrgUnauthorized() *UpdateCurrentOrgUnauthorized {
	return &UpdateCurrentOrgUnauthorized{}
}

/*
UpdateCurrentOrgUnauthorized describes a response with status code 401, with default header values.

UnauthorizedError is returned when the request is not authenticated.
*/
type UpdateCurrentOrgUnauthorized struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this update current org unauthorized response has a 2xx status code
func (o *UpdateCurrentOrgUnauthorized) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this update current org unauthorized response has a 3xx status code
func (o *UpdateCurrentOrgUnauthorized) IsRedirect() bool {
	return false
}

// IsClientError returns true when this update current org unauthorized response has a 4xx status code
func (o *UpdateCurrentOrgUnauthorized) IsClientError() bool {
	return true
}

// IsServerError returns true when this update current org unauthorized response has a 5xx status code
func (o *UpdateCurrentOrgUnauthorized) IsServerError() bool {
	return false
}

// IsCode returns true when this update current org unauthorized response a status code equal to that given
func (o *UpdateCurrentOrgUnauthorized) IsCode(code int) bool {
	return code == 401
}

// Code gets the status code for the update current org unauthorized response
func (o *UpdateCurrentOrgUnauthorized) Code() int {
	return 401
}

func (o *UpdateCurrentOrgUnauthorized) Error() string {
	return fmt.Sprintf("[PUT /org][%d] updateCurrentOrgUnauthorized  %+v", 401, o.Payload)
}

func (o *UpdateCurrentOrgUnauthorized) String() string {
	return fmt.Sprintf("[PUT /org][%d] updateCurrentOrgUnauthorized  %+v", 401, o.Payload)
}

func (o *UpdateCurrentOrgUnauthorized) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *UpdateCurrentOrgUnauthorized) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewUpdateCurrentOrgForbidden creates a UpdateCurrentOrgForbidden with default headers values
func NewUpdateCurrentOrgForbidden() *UpdateCurrentOrgForbidden {
	return &UpdateCurrentOrgForbidden{}
}

/*
UpdateCurrentOrgForbidden describes a response with status code 403, with default header values.

ForbiddenError is returned if the user/token has insufficient permissions to access the requested resource.
*/
type UpdateCurrentOrgForbidden struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this update current org forbidden response has a 2xx status code
func (o *UpdateCurrentOrgForbidden) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this update current org forbidden response has a 3xx status code
func (o *UpdateCurrentOrgForbidden) IsRedirect() bool {
	return false
}

// IsClientError returns true when this update current org forbidden response has a 4xx status code
func (o *UpdateCurrentOrgForbidden) IsClientError() bool {
	return true
}

// IsServerError returns true when this update current org forbidden response has a 5xx status code
func (o *UpdateCurrentOrgForbidden) IsServerError() bool {
	return false
}

// IsCode returns true when this update current org forbidden response a status code equal to that given
func (o *UpdateCurrentOrgForbidden) IsCode(code int) bool {
	return code == 403
}

// Code gets the status code for the update current org forbidden response
func (o *UpdateCurrentOrgForbidden) Code() int {
	return 403
}

func (o *UpdateCurrentOrgForbidden) Error() string {
	return fmt.Sprintf("[PUT /org][%d] updateCurrentOrgForbidden  %+v", 403, o.Payload)
}

func (o *UpdateCurrentOrgForbidden) String() string {
	return fmt.Sprintf("[PUT /org][%d] updateCurrentOrgForbidden  %+v", 403, o.Payload)
}

func (o *UpdateCurrentOrgForbidden) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *UpdateCurrentOrgForbidden) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewUpdateCurrentOrgInternalServerError creates a UpdateCurrentOrgInternalServerError with default headers values
func NewUpdateCurrentOrgInternalServerError() *UpdateCurrentOrgInternalServerError {
	return &UpdateCurrentOrgInternalServerError{}
}

/*
UpdateCurrentOrgInternalServerError describes a response with status code 500, with default header values.

InternalServerError is a general error indicating something went wrong internally.
*/
type UpdateCurrentOrgInternalServerError struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this update current org internal server error response has a 2xx status code
func (o *UpdateCurrentOrgInternalServerError) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this update current org internal server error response has a 3xx status code
func (o *UpdateCurrentOrgInternalServerError) IsRedirect() bool {
	return false
}

// IsClientError returns true when this update current org internal server error response has a 4xx status code
func (o *UpdateCurrentOrgInternalServerError) IsClientError() bool {
	return false
}

// IsServerError returns true when this update current org internal server error response has a 5xx status code
func (o *UpdateCurrentOrgInternalServerError) IsServerError() bool {
	return true
}

// IsCode returns true when this update current org internal server error response a status code equal to that given
func (o *UpdateCurrentOrgInternalServerError) IsCode(code int) bool {
	return code == 500
}

// Code gets the status code for the update current org internal server error response
func (o *UpdateCurrentOrgInternalServerError) Code() int {
	return 500
}

func (o *UpdateCurrentOrgInternalServerError) Error() string {
	return fmt.Sprintf("[PUT /org][%d] updateCurrentOrgInternalServerError  %+v", 500, o.Payload)
}

func (o *UpdateCurrentOrgInternalServerError) String() string {
	return fmt.Sprintf("[PUT /org][%d] updateCurrentOrgInternalServerError  %+v", 500, o.Payload)
}

func (o *UpdateCurrentOrgInternalServerError) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *UpdateCurrentOrgInternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
