// Copyright 2024 Google LLC.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// Code generated file. DO NOT EDIT.

// Package contentwarehouse provides access to the Document AI Warehouse API.
//
// For product documentation, see: https://cloud.google.com/document-warehouse
//
// # Library status
//
// These client libraries are officially supported by Google. However, this
// library is considered complete and is in maintenance mode. This means
// that we will address critical bugs and security issues but will not add
// any new features.
//
// When possible, we recommend using our newer
// [Cloud Client Libraries for Go](https://pkg.go.dev/cloud.google.com/go)
// that are still actively being worked and iterated on.
//
// # Creating a client
//
// Usage example:
//
//	import "google.golang.org/api/contentwarehouse/v1"
//	...
//	ctx := context.Background()
//	contentwarehouseService, err := contentwarehouse.NewService(ctx)
//
// In this example, Google Application Default Credentials are used for
// authentication. For information on how to create and obtain Application
// Default Credentials, see https://developers.google.com/identity/protocols/application-default-credentials.
//
// # Other authentication options
//
// To use an API key for authentication (note: some APIs do not support API
// keys), use [google.golang.org/api/option.WithAPIKey]:
//
//	contentwarehouseService, err := contentwarehouse.NewService(ctx, option.WithAPIKey("AIza..."))
//
// To use an OAuth token (e.g., a user token obtained via a three-legged OAuth
// flow, use [google.golang.org/api/option.WithTokenSource]:
//
//	config := &oauth2.Config{...}
//	// ...
//	token, err := config.Exchange(ctx, ...)
//	contentwarehouseService, err := contentwarehouse.NewService(ctx, option.WithTokenSource(config.TokenSource(ctx, token)))
//
// See [google.golang.org/api/option.ClientOption] for details on options.
package contentwarehouse // import "google.golang.org/api/contentwarehouse/v1"

import (
	"bytes"
	"context"
	"encoding/json"
	"errors"
	"fmt"
	"io"
	"net/http"
	"net/url"
	"strconv"
	"strings"

	googleapi "google.golang.org/api/googleapi"
	internal "google.golang.org/api/internal"
	gensupport "google.golang.org/api/internal/gensupport"
	option "google.golang.org/api/option"
	internaloption "google.golang.org/api/option/internaloption"
	htransport "google.golang.org/api/transport/http"
)

// Always reference these packages, just in case the auto-generated code
// below doesn't.
var _ = bytes.NewBuffer
var _ = strconv.Itoa
var _ = fmt.Sprintf
var _ = json.NewDecoder
var _ = io.Copy
var _ = url.Parse
var _ = gensupport.MarshalJSON
var _ = googleapi.Version
var _ = errors.New
var _ = strings.Replace
var _ = context.Canceled
var _ = internaloption.WithDefaultEndpoint
var _ = internal.Version

const apiId = "contentwarehouse:v1"
const apiName = "contentwarehouse"
const apiVersion = "v1"
const basePath = "https://contentwarehouse.googleapis.com/"
const basePathTemplate = "https://contentwarehouse.UNIVERSE_DOMAIN/"
const mtlsBasePath = "https://contentwarehouse.mtls.googleapis.com/"

// OAuth2 scopes used by this API.
const (
	// See, edit, configure, and delete your Google Cloud data and see the email
	// address for your Google Account.
	CloudPlatformScope = "https://www.googleapis.com/auth/cloud-platform"
)

// NewService creates a new Service.
func NewService(ctx context.Context, opts ...option.ClientOption) (*Service, error) {
	scopesOption := internaloption.WithDefaultScopes(
		"https://www.googleapis.com/auth/cloud-platform",
	)
	// NOTE: prepend, so we don't override user-specified scopes.
	opts = append([]option.ClientOption{scopesOption}, opts...)
	opts = append(opts, internaloption.WithDefaultEndpoint(basePath))
	opts = append(opts, internaloption.WithDefaultEndpointTemplate(basePathTemplate))
	opts = append(opts, internaloption.WithDefaultMTLSEndpoint(mtlsBasePath))
	opts = append(opts, internaloption.EnableNewAuthLibrary())
	client, endpoint, err := htransport.NewClient(ctx, opts...)
	if err != nil {
		return nil, err
	}
	s, err := New(client)
	if err != nil {
		return nil, err
	}
	if endpoint != "" {
		s.BasePath = endpoint
	}
	return s, nil
}

// New creates a new Service. It uses the provided http.Client for requests.
//
// Deprecated: please use NewService instead.
// To provide a custom HTTP client, use option.WithHTTPClient.
// If you are using google.golang.org/api/googleapis/transport.APIKey, use option.WithAPIKey with NewService instead.
func New(client *http.Client) (*Service, error) {
	if client == nil {
		return nil, errors.New("client is nil")
	}
	s := &Service{client: client, BasePath: basePath}
	s.Projects = NewProjectsService(s)
	return s, nil
}

type Service struct {
	client    *http.Client
	BasePath  string // API endpoint base URL
	UserAgent string // optional additional User-Agent fragment

	Projects *ProjectsService
}

func (s *Service) userAgent() string {
	if s.UserAgent == "" {
		return googleapi.UserAgent
	}
	return googleapi.UserAgent + " " + s.UserAgent
}

func NewProjectsService(s *Service) *ProjectsService {
	rs := &ProjectsService{s: s}
	rs.Locations = NewProjectsLocationsService(s)
	return rs
}

type ProjectsService struct {
	s *Service

	Locations *ProjectsLocationsService
}

func NewProjectsLocationsService(s *Service) *ProjectsLocationsService {
	rs := &ProjectsLocationsService{s: s}
	rs.DocumentSchemas = NewProjectsLocationsDocumentSchemasService(s)
	rs.Documents = NewProjectsLocationsDocumentsService(s)
	rs.Operations = NewProjectsLocationsOperationsService(s)
	rs.RuleSets = NewProjectsLocationsRuleSetsService(s)
	rs.SynonymSets = NewProjectsLocationsSynonymSetsService(s)
	return rs
}

type ProjectsLocationsService struct {
	s *Service

	DocumentSchemas *ProjectsLocationsDocumentSchemasService

	Documents *ProjectsLocationsDocumentsService

	Operations *ProjectsLocationsOperationsService

	RuleSets *ProjectsLocationsRuleSetsService

	SynonymSets *ProjectsLocationsSynonymSetsService
}

func NewProjectsLocationsDocumentSchemasService(s *Service) *ProjectsLocationsDocumentSchemasService {
	rs := &ProjectsLocationsDocumentSchemasService{s: s}
	return rs
}

type ProjectsLocationsDocumentSchemasService struct {
	s *Service
}

func NewProjectsLocationsDocumentsService(s *Service) *ProjectsLocationsDocumentsService {
	rs := &ProjectsLocationsDocumentsService{s: s}
	rs.DocumentLinks = NewProjectsLocationsDocumentsDocumentLinksService(s)
	rs.ReferenceId = NewProjectsLocationsDocumentsReferenceIdService(s)
	return rs
}

type ProjectsLocationsDocumentsService struct {
	s *Service

	DocumentLinks *ProjectsLocationsDocumentsDocumentLinksService

	ReferenceId *ProjectsLocationsDocumentsReferenceIdService
}

func NewProjectsLocationsDocumentsDocumentLinksService(s *Service) *ProjectsLocationsDocumentsDocumentLinksService {
	rs := &ProjectsLocationsDocumentsDocumentLinksService{s: s}
	return rs
}

type ProjectsLocationsDocumentsDocumentLinksService struct {
	s *Service
}

func NewProjectsLocationsDocumentsReferenceIdService(s *Service) *ProjectsLocationsDocumentsReferenceIdService {
	rs := &ProjectsLocationsDocumentsReferenceIdService{s: s}
	return rs
}

type ProjectsLocationsDocumentsReferenceIdService struct {
	s *Service
}

func NewProjectsLocationsOperationsService(s *Service) *ProjectsLocationsOperationsService {
	rs := &ProjectsLocationsOperationsService{s: s}
	return rs
}

type ProjectsLocationsOperationsService struct {
	s *Service
}

func NewProjectsLocationsRuleSetsService(s *Service) *ProjectsLocationsRuleSetsService {
	rs := &ProjectsLocationsRuleSetsService{s: s}
	return rs
}

type ProjectsLocationsRuleSetsService struct {
	s *Service
}

func NewProjectsLocationsSynonymSetsService(s *Service) *ProjectsLocationsSynonymSetsService {
	rs := &ProjectsLocationsSynonymSetsService{s: s}
	return rs
}

type ProjectsLocationsSynonymSetsService struct {
	s *Service
}

// CloudAiPlatformTenantresourceCloudSqlInstanceConfig: The identity to
// configure a CloudSQL instance provisioned via SLM Terraform.
type CloudAiPlatformTenantresourceCloudSqlInstanceConfig struct {
	// CloudSqlInstanceConnectionName: Output only. The CloudSQL instance
	// connection name.
	CloudSqlInstanceConnectionName string `json:"cloudSqlInstanceConnectionName,omitempty"`
	// CloudSqlInstanceName: Input/Output [Optional]. The CloudSQL instance name
	// within SLM instance. If not set, a random UUIC will be generated as instance
	// name.
	CloudSqlInstanceName string `json:"cloudSqlInstanceName,omitempty"`
	// KmsKeyReference: Input [Optional]. The KMS key name or the KMS grant name
	// used for CMEK encryption. Only set this field when provisioning new CloudSQL
	// instances. For existing CloudSQL instances, this field will be ignored
	// because CMEK re-encryption is not supported.
	KmsKeyReference string `json:"kmsKeyReference,omitempty"`
	// MdbRolesForCorpAccess: Input [Optional]. MDB roles for corp access to
	// CloudSQL instance.
	MdbRolesForCorpAccess []string `json:"mdbRolesForCorpAccess,omitempty"`
	// SlmInstanceName: Output only. The SLM instance's full resource name.
	SlmInstanceName string `json:"slmInstanceName,omitempty"`
	// SlmInstanceTemplate: Input [Required]. The SLM instance template to
	// provision CloudSQL.
	SlmInstanceTemplate string `json:"slmInstanceTemplate,omitempty"`
	// SlmInstanceType: Input [Required]. The SLM instance type to provision
	// CloudSQL.
	SlmInstanceType string `json:"slmInstanceType,omitempty"`
	// ForceSendFields is a list of field names (e.g.
	// "CloudSqlInstanceConnectionName") to unconditionally include in API
	// requests. By default, fields with empty or default values are omitted from
	// API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CloudSqlInstanceConnectionName")
	// to include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s CloudAiPlatformTenantresourceCloudSqlInstanceConfig) MarshalJSON() ([]byte, error) {
	type NoMethod CloudAiPlatformTenantresourceCloudSqlInstanceConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// CloudAiPlatformTenantresourceGcsBucketConfig: The identity to configure a
// GCS bucket.
type CloudAiPlatformTenantresourceGcsBucketConfig struct {
	Admins []string `json:"admins,omitempty"`
	// BucketName: Input/Output [Optional]. The name of a GCS bucket with max
	// length of 63 chars. If not set, a random UUID will be generated as bucket
	// name.
	BucketName string `json:"bucketName,omitempty"`
	// EntityName: Input/Output [Optional]. Only needed for per-entity tenant GCP
	// resources. During Deprovision API, the on-demand deletion will only cover
	// the tenant GCP resources with the specified entity name.
	EntityName string `json:"entityName,omitempty"`
	// KmsKeyReference: Input/Output [Optional]. The KMS key name or the KMS grant
	// name used for CMEK encryption. Only set this field when provisioning new GCS
	// bucket. For existing GCS bucket, this field will be ignored because CMEK
	// re-encryption is not supported.
	KmsKeyReference string `json:"kmsKeyReference,omitempty"`
	// TtlDays: Input/Output [Optional]. Only needed when the content in bucket
	// need to be garbage collected within some amount of days.
	TtlDays int64 `json:"ttlDays,omitempty"`
	// Viewers: Input/Output [Required]. IAM roles (viewer/admin) put on the
	// bucket.
	Viewers []string `json:"viewers,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Admins") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Admins") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s CloudAiPlatformTenantresourceGcsBucketConfig) MarshalJSON() ([]byte, error) {
	type NoMethod CloudAiPlatformTenantresourceGcsBucketConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// CloudAiPlatformTenantresourceIamPolicyBinding: The dynamic IAM bindings to
// be granted after tenant projects are created.
type CloudAiPlatformTenantresourceIamPolicyBinding struct {
	// Members: Input/Output [Required]. The member service accounts with the roles
	// above. Note: placeholders are same as the resource above.
	Members []string `json:"members,omitempty"`
	// Resource: Input/Output [Required]. The resource name that will be accessed
	// by members, which also depends on resource_type. Note: placeholders are
	// supported in resource names. For example, ${tpn} will be used when the
	// tenant project number is not ready.
	Resource string `json:"resource,omitempty"`
	// ResourceType: Input/Output [Required]. Specifies the type of resource that
	// will be accessed by members.
	//
	// Possible values:
	//   "RESOURCE_TYPE_UNSPECIFIED"
	//   "PROJECT" - The value of resource field is the ID or number of a project.
	// Format is
	//   "SERVICE_ACCOUNT" - The value of resource field is the resource name of a
	// service account. Format is projects//serviceAccounts/
	//   "GCS_BUCKET" - The value of resource field is the name of a GCS bucket
	// (not its resource name). Format is .
	//   "SERVICE_CONSUMER" - The value of resource field is the resource name of a
	// service consumer. Format is services//consumers/
	//   "AR_REPO" - The value of the resource field is the AR Image Uri which
	// identifies an AR REPO. Allowed formats are: /// ///: ///@
	ResourceType string `json:"resourceType,omitempty"`
	// Role: Input/Output [Required]. The role for members below.
	Role string `json:"role,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Members") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Members") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s CloudAiPlatformTenantresourceIamPolicyBinding) MarshalJSON() ([]byte, error) {
	type NoMethod CloudAiPlatformTenantresourceIamPolicyBinding
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// CloudAiPlatformTenantresourceInfraSpannerConfig: The configuration for a
// spanner database provisioning. Next ID: 8
type CloudAiPlatformTenantresourceInfraSpannerConfig struct {
	// CreateDatabaseOptions: Input [Optional]. The options to create a spanner
	// database. Note: give the right options to ensure the right KMS key access
	// audit logging and AxT logging in expected logging category.
	CreateDatabaseOptions *CloudAiPlatformTenantresourceInfraSpannerConfigCreateDatabaseOptions `json:"createDatabaseOptions,omitempty"`
	// KmsKeyReference: Input [Optional]. The KMS key name or the KMS grant name
	// used for CMEK encryption. Only set this field when provisioning new Infra
	// Spanner databases. For existing Infra Spanner databases, this field will be
	// ignored because CMEK re-encryption is not supported. For example,
	// projects//locations//keyRings//cryptoKeys/
	KmsKeyReference string `json:"kmsKeyReference,omitempty"`
	// SdlBundlePath: Input [Required]. The file path to the spanner SDL bundle.
	SdlBundlePath string `json:"sdlBundlePath,omitempty"`
	// SpannerBorgServiceAccount: Input [Optional]. The spanner borg service
	// account for delegating the kms key to. For example,
	// spanner-infra-cmek-nonprod@system.gserviceaccount.com, for the nonprod
	// universe.
	SpannerBorgServiceAccount string `json:"spannerBorgServiceAccount,omitempty"`
	SpannerLocalNamePrefix    string `json:"spannerLocalNamePrefix,omitempty"`
	SpannerNamespace          string `json:"spannerNamespace,omitempty"`
	// SpannerUniverse: Input [Required]. Every database in Spanner can be
	// identified by the following path name: /span//:
	SpannerUniverse string `json:"spannerUniverse,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CreateDatabaseOptions") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateDatabaseOptions") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s CloudAiPlatformTenantresourceInfraSpannerConfig) MarshalJSON() ([]byte, error) {
	type NoMethod CloudAiPlatformTenantresourceInfraSpannerConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// CloudAiPlatformTenantresourceInfraSpannerConfigCreateDatabaseOptions: The
// options to create a spanner database. KMS key access audit logging and AxT
// logging will be associated with the given resource name, resource type and
// service name. Please ensure to give right options to enable correct audit
// logging and AxT logging.
type CloudAiPlatformTenantresourceInfraSpannerConfigCreateDatabaseOptions struct {
	// CmekCloudResourceName: The cloud resource name for the CMEK encryption. For
	// example, projects//locations/
	CmekCloudResourceName string `json:"cmekCloudResourceName,omitempty"`
	// CmekCloudResourceType: The cloud resource type for the CMEK encryption. For
	// example, contentwarehouse.googleapis.com/Location
	CmekCloudResourceType string `json:"cmekCloudResourceType,omitempty"`
	// CmekServiceName: The service name for the CMEK encryption. For example,
	// contentwarehouse.googleapis.com
	CmekServiceName string `json:"cmekServiceName,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CmekCloudResourceName") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CmekCloudResourceName") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s CloudAiPlatformTenantresourceInfraSpannerConfigCreateDatabaseOptions) MarshalJSON() ([]byte, error) {
	type NoMethod CloudAiPlatformTenantresourceInfraSpannerConfigCreateDatabaseOptions
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// CloudAiPlatformTenantresourceServiceAccountIdentity: The identity to
// configure a service account.
type CloudAiPlatformTenantresourceServiceAccountIdentity struct {
	// ServiceAccountEmail: Output only. The service account email that has been
	// created.
	ServiceAccountEmail string `json:"serviceAccountEmail,omitempty"`
	// Tag: Input/Output [Optional]. The tag that configures the service account,
	// as defined in
	// google3/configs/production/cdpush/acl-zanzibar-cloud-prod/activation_grants/a
	// ctivation_grants.gcl. Note: The default P4 service account has the empty
	// tag.
	Tag string `json:"tag,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ServiceAccountEmail") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ServiceAccountEmail") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s CloudAiPlatformTenantresourceServiceAccountIdentity) MarshalJSON() ([]byte, error) {
	type NoMethod CloudAiPlatformTenantresourceServiceAccountIdentity
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// CloudAiPlatformTenantresourceTenantProjectConfig: The identity to configure
// a tenant project.
type CloudAiPlatformTenantresourceTenantProjectConfig struct {
	// BillingConfig: Input/Output [Required]. The billing account properties to
	// create the tenant project.
	BillingConfig *GoogleApiServiceconsumermanagementV1BillingConfig `json:"billingConfig,omitempty"`
	// Folder: Input/Output [Required]. The folder that holds tenant projects and
	// folder-level permissions will be automatically granted to all tenant
	// projects under the folder. Note: the valid folder format is
	// `folders/{folder_number}`.
	Folder string `json:"folder,omitempty"`
	// PolicyBindings: Input/Output [Required]. The policy bindings that are
	// applied to the tenant project during creation. At least one binding must
	// have the role `roles/owner` with either `user` or `group` type.
	PolicyBindings []*GoogleApiServiceconsumermanagementV1PolicyBinding `json:"policyBindings,omitempty"`
	// Services: Input/Output [Required]. The API services that are enabled on the
	// tenant project during creation.
	Services []string `json:"services,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BillingConfig") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BillingConfig") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s CloudAiPlatformTenantresourceTenantProjectConfig) MarshalJSON() ([]byte, error) {
	type NoMethod CloudAiPlatformTenantresourceTenantProjectConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// CloudAiPlatformTenantresourceTenantProjectResource: The tenant project and
// tenant resources. Next ID: 10
type CloudAiPlatformTenantresourceTenantProjectResource struct {
	// CloudSqlInstances: The CloudSQL instances that are provisioned under the
	// tenant project.
	CloudSqlInstances []*CloudAiPlatformTenantresourceCloudSqlInstanceConfig `json:"cloudSqlInstances,omitempty"`
	// GcsBuckets: The GCS buckets that are provisioned under the tenant project.
	GcsBuckets []*CloudAiPlatformTenantresourceGcsBucketConfig `json:"gcsBuckets,omitempty"`
	// IamPolicyBindings: The dynamic IAM bindings that are granted under the
	// tenant project. Note: this should only add new bindings to the project if
	// they don't exist and the existing bindings won't be affected.
	IamPolicyBindings []*CloudAiPlatformTenantresourceIamPolicyBinding `json:"iamPolicyBindings,omitempty"`
	// InfraSpannerConfigs: The Infra Spanner databases that are provisioned under
	// the tenant project. Note: this is an experimental feature.
	InfraSpannerConfigs []*CloudAiPlatformTenantresourceInfraSpannerConfig `json:"infraSpannerConfigs,omitempty"`
	// Tag: Input/Output [Required]. The tag that uniquely identifies a tenant
	// project within a tenancy unit. Note: for the same tenant project tag, all
	// tenant manager operations should be idempotent.
	Tag string `json:"tag,omitempty"`
	// TenantProjectConfig: The configurations of a tenant project.
	TenantProjectConfig *CloudAiPlatformTenantresourceTenantProjectConfig `json:"tenantProjectConfig,omitempty"`
	// TenantProjectId: Output only. The tenant project ID that has been created.
	TenantProjectId string `json:"tenantProjectId,omitempty"`
	// TenantProjectNumber: Output only. The tenant project number that has been
	// created.
	TenantProjectNumber int64 `json:"tenantProjectNumber,omitempty,string"`
	// TenantServiceAccounts: The service account identities (or enabled API
	// service's P4SA) that are expclicitly created under the tenant project
	// (before JIT provisioning during enabled API services).
	TenantServiceAccounts []*CloudAiPlatformTenantresourceTenantServiceAccountIdentity `json:"tenantServiceAccounts,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CloudSqlInstances") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CloudSqlInstances") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s CloudAiPlatformTenantresourceTenantProjectResource) MarshalJSON() ([]byte, error) {
	type NoMethod CloudAiPlatformTenantresourceTenantProjectResource
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// CloudAiPlatformTenantresourceTenantResource: A collection of tenant
// resources.
type CloudAiPlatformTenantresourceTenantResource struct {
	// P4ServiceAccounts: A list of P4 service accounts (go/p4sa) to provision or
	// deprovision.
	P4ServiceAccounts []*CloudAiPlatformTenantresourceServiceAccountIdentity `json:"p4ServiceAccounts,omitempty"`
	// TenantProjectResources: A list of tenant projects and tenant resources to
	// provision or deprovision.
	TenantProjectResources []*CloudAiPlatformTenantresourceTenantProjectResource `json:"tenantProjectResources,omitempty"`
	// ForceSendFields is a list of field names (e.g. "P4ServiceAccounts") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "P4ServiceAccounts") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s CloudAiPlatformTenantresourceTenantResource) MarshalJSON() ([]byte, error) {
	type NoMethod CloudAiPlatformTenantresourceTenantResource
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// CloudAiPlatformTenantresourceTenantServiceAccountIdentity: The identity of
// service accounts that have been explicitly created under tenant projects.
type CloudAiPlatformTenantresourceTenantServiceAccountIdentity struct {
	// ServiceAccountEmail: Output only. The email address of the generated service
	// account.
	ServiceAccountEmail string `json:"serviceAccountEmail,omitempty"`
	// ServiceName: Input/Output [Required]. The service that the service account
	// belongs to. (e.g. cloudbuild.googleapis.com for GCB service accounts)
	ServiceName string `json:"serviceName,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ServiceAccountEmail") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ServiceAccountEmail") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s CloudAiPlatformTenantresourceTenantServiceAccountIdentity) MarshalJSON() ([]byte, error) {
	type NoMethod CloudAiPlatformTenantresourceTenantServiceAccountIdentity
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleApiServiceconsumermanagementV1BillingConfig: Describes the billing
// configuration for a new tenant project.
type GoogleApiServiceconsumermanagementV1BillingConfig struct {
	// BillingAccount: Name of the billing account. For example
	// `billingAccounts/012345-567890-ABCDEF`.
	BillingAccount string `json:"billingAccount,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BillingAccount") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BillingAccount") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleApiServiceconsumermanagementV1BillingConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleApiServiceconsumermanagementV1BillingConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleApiServiceconsumermanagementV1PolicyBinding: Translates to IAM Policy
// bindings (without auditing at this level)
type GoogleApiServiceconsumermanagementV1PolicyBinding struct {
	// Members: Uses the same format as in IAM policy. `member` must include both a
	// prefix and ID. For example, `user:{emailId}`, `serviceAccount:{emailId}`,
	// `group:{emailId}`.
	Members []string `json:"members,omitempty"`
	// Role: Role. (https://cloud.google.com/iam/docs/understanding-roles) For
	// example, `roles/viewer`, `roles/editor`, or `roles/owner`.
	Role string `json:"role,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Members") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Members") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleApiServiceconsumermanagementV1PolicyBinding) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleApiServiceconsumermanagementV1PolicyBinding
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContentwarehouseV1AccessControlAction: Represents the action
// responsible for access control list management operations.
type GoogleCloudContentwarehouseV1AccessControlAction struct {
	// OperationType: Identifies the type of operation.
	//
	// Possible values:
	//   "UNKNOWN" - The unknown operation type.
	//   "ADD_POLICY_BINDING" - Adds newly given policy bindings in the existing
	// bindings list.
	//   "REMOVE_POLICY_BINDING" - Removes newly given policy bindings from the
	// existing bindings list.
	//   "REPLACE_POLICY_BINDING" - Replaces existing policy bindings with the
	// given policy binding list
	OperationType string `json:"operationType,omitempty"`
	// Policy: Represents the new policy from which bindings are added, removed or
	// replaced based on the type of the operation. the policy is limited to a few
	// 10s of KB.
	Policy *GoogleIamV1Policy `json:"policy,omitempty"`
	// ForceSendFields is a list of field names (e.g. "OperationType") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "OperationType") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContentwarehouseV1AccessControlAction) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContentwarehouseV1AccessControlAction
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContentwarehouseV1Action: Represents the action triggered by Rule
// Engine when the rule is true.
type GoogleCloudContentwarehouseV1Action struct {
	// AccessControl: Action triggering access control operations.
	AccessControl *GoogleCloudContentwarehouseV1AccessControlAction `json:"accessControl,omitempty"`
	// ActionId: ID of the action. Managed internally.
	ActionId string `json:"actionId,omitempty"`
	// AddToFolder: Action triggering create document link operation.
	AddToFolder *GoogleCloudContentwarehouseV1AddToFolderAction `json:"addToFolder,omitempty"`
	// DataUpdate: Action triggering data update operations.
	DataUpdate *GoogleCloudContentwarehouseV1DataUpdateAction `json:"dataUpdate,omitempty"`
	// DataValidation: Action triggering data validation operations.
	DataValidation *GoogleCloudContentwarehouseV1DataValidationAction `json:"dataValidation,omitempty"`
	// DeleteDocumentAction: Action deleting the document.
	DeleteDocumentAction *GoogleCloudContentwarehouseV1DeleteDocumentAction `json:"deleteDocumentAction,omitempty"`
	// PublishToPubSub: Action publish to Pub/Sub operation.
	PublishToPubSub *GoogleCloudContentwarehouseV1PublishAction `json:"publishToPubSub,omitempty"`
	// RemoveFromFolderAction: Action removing a document from a folder.
	RemoveFromFolderAction *GoogleCloudContentwarehouseV1RemoveFromFolderAction `json:"removeFromFolderAction,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AccessControl") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AccessControl") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContentwarehouseV1Action) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContentwarehouseV1Action
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContentwarehouseV1ActionExecutorOutput: Represents the output of
// the Action Executor.
type GoogleCloudContentwarehouseV1ActionExecutorOutput struct {
	// RuleActionsPairs: List of rule and corresponding actions result.
	RuleActionsPairs []*GoogleCloudContentwarehouseV1RuleActionsPair `json:"ruleActionsPairs,omitempty"`
	// ForceSendFields is a list of field names (e.g. "RuleActionsPairs") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "RuleActionsPairs") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContentwarehouseV1ActionExecutorOutput) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContentwarehouseV1ActionExecutorOutput
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContentwarehouseV1ActionOutput: Represents the result of
// executing an action.
type GoogleCloudContentwarehouseV1ActionOutput struct {
	// ActionId: ID of the action.
	ActionId string `json:"actionId,omitempty"`
	// ActionState: State of an action.
	//
	// Possible values:
	//   "UNKNOWN" - The unknown state.
	//   "ACTION_SUCCEEDED" - State indicating action executed successfully.
	//   "ACTION_FAILED" - State indicating action failed.
	//   "ACTION_TIMED_OUT" - State indicating action timed out.
	//   "ACTION_PENDING" - State indicating action is pending.
	ActionState string `json:"actionState,omitempty"`
	// OutputMessage: Action execution output message.
	OutputMessage string `json:"outputMessage,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ActionId") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ActionId") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContentwarehouseV1ActionOutput) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContentwarehouseV1ActionOutput
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContentwarehouseV1AddToFolderAction: Represents the action
// responsible for adding document under a folder.
type GoogleCloudContentwarehouseV1AddToFolderAction struct {
	// Folders: Names of the folder under which new document is to be added.
	// Format:
	// projects/{project_number}/locations/{location}/documents/{document_id}.
	Folders []string `json:"folders,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Folders") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Folders") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContentwarehouseV1AddToFolderAction) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContentwarehouseV1AddToFolderAction
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContentwarehouseV1CloudAIDocumentOption: Request Option for
// processing Cloud AI Document in CW Document.
type GoogleCloudContentwarehouseV1CloudAIDocumentOption struct {
	// CustomizedEntitiesPropertiesConversions: If set, only selected entities will
	// be converted to properties.
	CustomizedEntitiesPropertiesConversions map[string]string `json:"customizedEntitiesPropertiesConversions,omitempty"`
	// EnableEntitiesConversions: Whether to convert all the entities to
	// properties.
	EnableEntitiesConversions bool `json:"enableEntitiesConversions,omitempty"`
	// ForceSendFields is a list of field names (e.g.
	// "CustomizedEntitiesPropertiesConversions") to unconditionally include in API
	// requests. By default, fields with empty or default values are omitted from
	// API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g.
	// "CustomizedEntitiesPropertiesConversions") to include in API requests with
	// the JSON null value. By default, fields with empty values are omitted from
	// API requests. See https://pkg.go.dev/google.golang.org/api#hdr-NullFields
	// for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContentwarehouseV1CloudAIDocumentOption) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContentwarehouseV1CloudAIDocumentOption
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContentwarehouseV1CreateDocumentLinkRequest: Request message for
// DocumentLinkService.CreateDocumentLink.
type GoogleCloudContentwarehouseV1CreateDocumentLinkRequest struct {
	// DocumentLink: Required. Document links associated with the source documents
	// (source_document_id).
	DocumentLink *GoogleCloudContentwarehouseV1DocumentLink `json:"documentLink,omitempty"`
	// RequestMetadata: The meta information collected about the document creator,
	// used to enforce access control for the service.
	RequestMetadata *GoogleCloudContentwarehouseV1RequestMetadata `json:"requestMetadata,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DocumentLink") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DocumentLink") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContentwarehouseV1CreateDocumentLinkRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContentwarehouseV1CreateDocumentLinkRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContentwarehouseV1CreateDocumentMetadata: Metadata object for
// CreateDocument request (currently empty).
type GoogleCloudContentwarehouseV1CreateDocumentMetadata struct {
}

// GoogleCloudContentwarehouseV1CreateDocumentRequest: Request message for
// DocumentService.CreateDocument.
type GoogleCloudContentwarehouseV1CreateDocumentRequest struct {
	// CloudAiDocumentOption: Request Option for processing Cloud AI Document in
	// Document Warehouse. This field offers limited support for mapping entities
	// from Cloud AI Document to Warehouse Document. Please consult with product
	// team before using this field and other available options.
	CloudAiDocumentOption *GoogleCloudContentwarehouseV1CloudAIDocumentOption `json:"cloudAiDocumentOption,omitempty"`
	// CreateMask: Field mask for creating Document fields. If mask path is empty,
	// it means all fields are masked. For the `FieldMask` definition, see
	// https://developers.google.com/protocol-buffers/docs/reference/google.protobuf#fieldmask.
	CreateMask string `json:"createMask,omitempty"`
	// Document: Required. The document to create.
	Document *GoogleCloudContentwarehouseV1Document `json:"document,omitempty"`
	// Policy: Default document policy during creation. This refers to an Identity
	// and Access (IAM) policy, which specifies access controls for the Document.
	// Conditions defined in the policy will be ignored.
	Policy *GoogleIamV1Policy `json:"policy,omitempty"`
	// RequestMetadata: The meta information collected about the end user, used to
	// enforce access control for the service.
	RequestMetadata *GoogleCloudContentwarehouseV1RequestMetadata `json:"requestMetadata,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CloudAiDocumentOption") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CloudAiDocumentOption") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContentwarehouseV1CreateDocumentRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContentwarehouseV1CreateDocumentRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContentwarehouseV1CreateDocumentResponse: Response message for
// DocumentService.CreateDocument.
type GoogleCloudContentwarehouseV1CreateDocumentResponse struct {
	// Document: Document created after executing create request.
	Document *GoogleCloudContentwarehouseV1Document `json:"document,omitempty"`
	// LongRunningOperations: post-processing LROs
	LongRunningOperations []*GoogleLongrunningOperation `json:"longRunningOperations,omitempty"`
	// Metadata: Additional information for the API invocation, such as the request
	// tracking id.
	Metadata *GoogleCloudContentwarehouseV1ResponseMetadata `json:"metadata,omitempty"`
	// RuleEngineOutput: Output from Rule Engine recording the rule evaluator and
	// action executor's output. Refer format in:
	// google/cloud/contentwarehouse/v1/rule_engine.proto
	RuleEngineOutput *GoogleCloudContentwarehouseV1RuleEngineOutput `json:"ruleEngineOutput,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Document") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Document") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContentwarehouseV1CreateDocumentResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContentwarehouseV1CreateDocumentResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContentwarehouseV1CustomWeightsMetadata: To support the custom
// weighting across document schemas.
type GoogleCloudContentwarehouseV1CustomWeightsMetadata struct {
	// WeightedSchemaProperties: List of schema and property name. Allows a maximum
	// of 10 schemas to be specified for relevance boosting.
	WeightedSchemaProperties []*GoogleCloudContentwarehouseV1WeightedSchemaProperty `json:"weightedSchemaProperties,omitempty"`
	// ForceSendFields is a list of field names (e.g. "WeightedSchemaProperties")
	// to unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "WeightedSchemaProperties") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContentwarehouseV1CustomWeightsMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContentwarehouseV1CustomWeightsMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContentwarehouseV1DataUpdateAction: Represents the action
// responsible for properties update operations.
type GoogleCloudContentwarehouseV1DataUpdateAction struct {
	// Entries: Map of (K, V) -> (valid name of the field, new value of the field)
	// E.g., ("age", "60") entry triggers update of field age with a value of 60.
	// If the field is not present then new entry is added. During update action
	// execution, value strings will be casted to appropriate types.
	Entries map[string]string `json:"entries,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Entries") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Entries") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContentwarehouseV1DataUpdateAction) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContentwarehouseV1DataUpdateAction
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContentwarehouseV1DataValidationAction: Represents the action
// responsible for data validation operations.
type GoogleCloudContentwarehouseV1DataValidationAction struct {
	// Conditions: Map of (K, V) -> (field, string condition to be evaluated on the
	// field) E.g., ("age", "age > 18 && age < 60") entry triggers validation of
	// field age with the given condition. Map entries will be ANDed during
	// validation.
	Conditions map[string]string `json:"conditions,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Conditions") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Conditions") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContentwarehouseV1DataValidationAction) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContentwarehouseV1DataValidationAction
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContentwarehouseV1DateTimeArray: DateTime values.
type GoogleCloudContentwarehouseV1DateTimeArray struct {
	// Values: List of datetime values. Both OffsetDateTime and ZonedDateTime are
	// supported.
	Values []*GoogleTypeDateTime `json:"values,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Values") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Values") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContentwarehouseV1DateTimeArray) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContentwarehouseV1DateTimeArray
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContentwarehouseV1DateTimeTypeOptions: Configurations for a date
// time property.
type GoogleCloudContentwarehouseV1DateTimeTypeOptions struct {
}

// GoogleCloudContentwarehouseV1DeleteDocumentAction: Represents the action
// responsible for deleting the document.
type GoogleCloudContentwarehouseV1DeleteDocumentAction struct {
	// EnableHardDelete: Boolean field to select between hard vs soft delete
	// options. Set 'true' for 'hard delete' and 'false' for 'soft delete'.
	EnableHardDelete bool `json:"enableHardDelete,omitempty"`
	// ForceSendFields is a list of field names (e.g. "EnableHardDelete") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EnableHardDelete") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContentwarehouseV1DeleteDocumentAction) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContentwarehouseV1DeleteDocumentAction
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContentwarehouseV1DeleteDocumentLinkRequest: Request message for
// DocumentLinkService.DeleteDocumentLink.
type GoogleCloudContentwarehouseV1DeleteDocumentLinkRequest struct {
	// RequestMetadata: The meta information collected about the document creator,
	// used to enforce access control for the service.
	RequestMetadata *GoogleCloudContentwarehouseV1RequestMetadata `json:"requestMetadata,omitempty"`
	// ForceSendFields is a list of field names (e.g. "RequestMetadata") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "RequestMetadata") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContentwarehouseV1DeleteDocumentLinkRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContentwarehouseV1DeleteDocumentLinkRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContentwarehouseV1DeleteDocumentRequest: Request message for
// DocumentService.DeleteDocument.
type GoogleCloudContentwarehouseV1DeleteDocumentRequest struct {
	// RequestMetadata: The meta information collected about the end user, used to
	// enforce access control for the service.
	RequestMetadata *GoogleCloudContentwarehouseV1RequestMetadata `json:"requestMetadata,omitempty"`
	// ForceSendFields is a list of field names (e.g. "RequestMetadata") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "RequestMetadata") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContentwarehouseV1DeleteDocumentRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContentwarehouseV1DeleteDocumentRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContentwarehouseV1Document: Defines the structure for content
// warehouse document proto.
type GoogleCloudContentwarehouseV1Document struct {
	// CloudAiDocument: Document AI format to save the structured content,
	// including OCR.
	CloudAiDocument *GoogleCloudDocumentaiV1Document `json:"cloudAiDocument,omitempty"`
	// ContentCategory: Indicates the category (image, audio, video etc.) of the
	// original content.
	//
	// Possible values:
	//   "CONTENT_CATEGORY_UNSPECIFIED" - No category is specified.
	//   "CONTENT_CATEGORY_IMAGE" - Content is of image type.
	//   "CONTENT_CATEGORY_AUDIO" - Content is of audio type.
	//   "CONTENT_CATEGORY_VIDEO" - Content is of video type.
	ContentCategory string `json:"contentCategory,omitempty"`
	// CreateTime: Output only. The time when the document is created.
	CreateTime string `json:"createTime,omitempty"`
	// Creator: The user who creates the document.
	Creator string `json:"creator,omitempty"`
	// DisplayName: Required. Display name of the document given by the user. This
	// name will be displayed in the UI. Customer can populate this field with the
	// name of the document. This differs from the 'title' field as 'title' is
	// optional and stores the top heading in the document.
	DisplayName string `json:"displayName,omitempty"`
	// DisplayUri: Uri to display the document, for example, in the UI.
	DisplayUri string `json:"displayUri,omitempty"`
	// DispositionTime: Output only. If linked to a Collection with
	// RetentionPolicy, the date when the document becomes mutable.
	DispositionTime string `json:"dispositionTime,omitempty"`
	// DocumentSchemaName: The Document schema name. Format:
	// projects/{project_number}/locations/{location}/documentSchemas/{document_sche
	// ma_id}.
	DocumentSchemaName string `json:"documentSchemaName,omitempty"`
	// InlineRawDocument: Raw document content.
	InlineRawDocument string `json:"inlineRawDocument,omitempty"`
	// LegalHold: Output only. Indicates if the document has a legal hold on it.
	LegalHold bool `json:"legalHold,omitempty"`
	// Name: The resource name of the document. Format:
	// projects/{project_number}/locations/{location}/documents/{document_id}. The
	// name is ignored when creating a document.
	Name string `json:"name,omitempty"`
	// PlainText: Other document format, such as PPTX, XLXS
	PlainText string `json:"plainText,omitempty"`
	// Properties: List of values that are user supplied metadata.
	Properties []*GoogleCloudContentwarehouseV1Property `json:"properties,omitempty"`
	// RawDocumentFileType: This is used when DocAI was not used to load the
	// document and parsing/ extracting is needed for the inline_raw_document. For
	// example, if inline_raw_document is the byte representation of a PDF file,
	// then this should be set to: RAW_DOCUMENT_FILE_TYPE_PDF.
	//
	// Possible values:
	//   "RAW_DOCUMENT_FILE_TYPE_UNSPECIFIED" - No raw document specified or it is
	// non-parsable
	//   "RAW_DOCUMENT_FILE_TYPE_PDF" - Adobe PDF format
	//   "RAW_DOCUMENT_FILE_TYPE_DOCX" - Microsoft Word format
	//   "RAW_DOCUMENT_FILE_TYPE_XLSX" - Microsoft Excel format
	//   "RAW_DOCUMENT_FILE_TYPE_PPTX" - Microsoft Powerpoint format
	//   "RAW_DOCUMENT_FILE_TYPE_TEXT" - UTF-8 encoded text format
	//   "RAW_DOCUMENT_FILE_TYPE_TIFF" - TIFF or TIF image file format
	RawDocumentFileType string `json:"rawDocumentFileType,omitempty"`
	// RawDocumentPath: Raw document file in Cloud Storage path.
	RawDocumentPath string `json:"rawDocumentPath,omitempty"`
	// ReferenceId: The reference ID set by customers. Must be unique per project
	// and location.
	ReferenceId string `json:"referenceId,omitempty"`
	// TextExtractionDisabled: If true, text extraction will not be performed.
	TextExtractionDisabled bool `json:"textExtractionDisabled,omitempty"`
	// TextExtractionEnabled: If true, text extraction will be performed.
	TextExtractionEnabled bool `json:"textExtractionEnabled,omitempty"`
	// Title: Title that describes the document. This can be the top heading or
	// text that describes the document.
	Title string `json:"title,omitempty"`
	// UpdateTime: Output only. The time when the document is last updated.
	UpdateTime string `json:"updateTime,omitempty"`
	// Updater: The user who lastly updates the document.
	Updater string `json:"updater,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "CloudAiDocument") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CloudAiDocument") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContentwarehouseV1Document) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContentwarehouseV1Document
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContentwarehouseV1DocumentLink: A document-link between source
// and target document.
type GoogleCloudContentwarehouseV1DocumentLink struct {
	// CreateTime: Output only. The time when the documentLink is created.
	CreateTime string `json:"createTime,omitempty"`
	// Description: Description of this document-link.
	Description string `json:"description,omitempty"`
	// Name: Name of this document-link. It is required that the parent derived
	// form the name to be consistent with the source document reference. Otherwise
	// an exception will be thrown. Format:
	// projects/{project_number}/locations/{location}/documents/{source_document_id}
	// /documentLinks/{document_link_id}.
	Name string `json:"name,omitempty"`
	// SourceDocumentReference: Document references of the source document.
	SourceDocumentReference *GoogleCloudContentwarehouseV1DocumentReference `json:"sourceDocumentReference,omitempty"`
	// State: The state of the documentlink. If target node has been deleted, the
	// link is marked as invalid. Removing a source node will result in removal of
	// all associated links.
	//
	// Possible values:
	//   "STATE_UNSPECIFIED" - Unknown state of documentlink.
	//   "ACTIVE" - The documentlink has both source and target documents detected.
	//   "SOFT_DELETED" - Target document is deleted, and mark the documentlink as
	// soft-deleted.
	State string `json:"state,omitempty"`
	// TargetDocumentReference: Document references of the target document.
	TargetDocumentReference *GoogleCloudContentwarehouseV1DocumentReference `json:"targetDocumentReference,omitempty"`
	// UpdateTime: Output only. The time when the documentLink is last updated.
	UpdateTime string `json:"updateTime,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContentwarehouseV1DocumentLink) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContentwarehouseV1DocumentLink
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudContentwarehouseV1DocumentQuery struct {
	// CustomPropertyFilter: This filter specifies a structured syntax to match
	// against the [PropertyDefinition].is_filterable marked as `true`. The syntax
	// for this expression is a subset of SQL syntax. Supported operators are: `=`,
	// `!=`, `<`, `<=`, `>`, and `>=` where the left of the operator is a property
	// name and the right of the operator is a number or a quoted string. You must
	// escape backslash (\\) and quote (\") characters. Supported functions are
	// `LOWER([property_name])` to perform a case insensitive match and
	// `EMPTY([property_name])` to filter on the existence of a key. Boolean
	// expressions (AND/OR/NOT) are supported up to 3 levels of nesting (for
	// example, "((A AND B AND C) OR NOT D) AND E"), a maximum of 100 comparisons
	// or functions are allowed in the expression. The expression must be < 6000
	// bytes in length. Sample Query: `(LOWER(driving_license)="class \"a\"" OR
	// EMPTY(driving_license)) AND driving_years > 10`
	CustomPropertyFilter string `json:"customPropertyFilter,omitempty"`
	// CustomWeightsMetadata: To support the custom weighting across document
	// schemas, customers need to provide the properties to be used to boost the
	// ranking in the search request. For a search query with CustomWeightsMetadata
	// specified, only the RetrievalImportance for the properties in the
	// CustomWeightsMetadata will be honored.
	CustomWeightsMetadata *GoogleCloudContentwarehouseV1CustomWeightsMetadata `json:"customWeightsMetadata,omitempty"`
	// DocumentCreatorFilter: The exact creator(s) of the documents to search
	// against. If a value isn't specified, documents within the search results are
	// associated with any creator. If multiple values are specified, documents
	// within the search results may be associated with any of the specified
	// creators.
	DocumentCreatorFilter []string `json:"documentCreatorFilter,omitempty"`
	// DocumentNameFilter: Search the documents in the list. Format:
	// projects/{project_number}/locations/{location}/documents/{document_id}.
	DocumentNameFilter []string `json:"documentNameFilter,omitempty"`
	// DocumentSchemaNames: This filter specifies the exact document schema
	// Document.document_schema_name of the documents to search against. If a value
	// isn't specified, documents within the search results are associated with any
	// schema. If multiple values are specified, documents within the search
	// results may be associated with any of the specified schemas. At most 20
	// document schema names are allowed.
	DocumentSchemaNames []string `json:"documentSchemaNames,omitempty"`
	// FileTypeFilter: This filter specifies the types of files to return: ALL,
	// FOLDER, or FILE. If FOLDER or FILE is specified, then only either folders or
	// files will be returned, respectively. If ALL is specified, both folders and
	// files will be returned. If no value is specified, ALL files will be
	// returned.
	FileTypeFilter *GoogleCloudContentwarehouseV1FileTypeFilter `json:"fileTypeFilter,omitempty"`
	// FolderNameFilter: Search all the documents under this specified folder.
	// Format:
	// projects/{project_number}/locations/{location}/documents/{document_id}.
	FolderNameFilter string `json:"folderNameFilter,omitempty"`
	// IsNlQuery: Experimental, do not use. If the query is a natural language
	// question. False by default. If true, then the question-answering feature
	// will be used instead of search, and `result_count` in SearchDocumentsRequest
	// must be set. In addition, all other input fields related to search
	// (pagination, histograms, etc.) will be ignored.
	IsNlQuery bool `json:"isNlQuery,omitempty"`
	// PropertyFilter: This filter specifies a structured syntax to match against
	// the PropertyDefinition.is_filterable marked as `true`. The relationship
	// between the PropertyFilters is OR.
	PropertyFilter []*GoogleCloudContentwarehouseV1PropertyFilter `json:"propertyFilter,omitempty"`
	// Query: The query string that matches against the full text of the document
	// and the searchable properties. The query partially supports Google AIP style
	// syntax (https://google.aip.dev/160). Specifically, the query supports
	// literals, logical operators, negation operators, comparison operators, and
	// functions. Literals: A bare literal value (examples: "42", "Hugo") is a
	// value to be matched against. It searches over the full text of the document
	// and the searchable properties. Logical operators: "AND", "and", "OR", and
	// "or" are binary logical operators (example: "engineer OR developer").
	// Negation operators: "NOT" and "!" are negation operators (example: "NOT
	// software"). Comparison operators: support the binary comparison operators =,
	// !=, <, >, <= and >= for string, numeric, enum, boolean. Also support like
	// operator `~~` for string. It provides semantic search functionality by
	// parsing, stemming and doing synonyms expansion against the input query. To
	// specify a property in the query, the left hand side expression in the
	// comparison must be the property ID including the parent. The right hand side
	// must be literals. For example: "\"projects/123/locations/us\".property_a <
	// 1" matches results whose "property_a" is less than 1 in project 123 and us
	// location. The literals and comparison expression can be connected in a
	// single query (example: "software engineer
	// \"projects/123/locations/us\".salary > 100"). Functions: supported functions
	// are `LOWER([property_name])` to perform a case insensitive match and
	// `EMPTY([property_name])` to filter on the existence of a key. Support nested
	// expressions connected using parenthesis and logical operators. The default
	// logical operators is `AND` if there is no operators between expressions. The
	// query can be used with other filters e.g. `time_filters` and
	// `folder_name_filter`. They are connected with `AND` operator under the hood.
	// The maximum number of allowed characters is 255.
	Query string `json:"query,omitempty"`
	// QueryContext: For custom synonyms. Customers provide the synonyms based on
	// context. One customer can provide multiple set of synonyms based on
	// different context. The search query will be expanded based on the custom
	// synonyms of the query context set. By default, no custom synonyms wll be
	// applied if no query context is provided. It is not supported for CMEK
	// compliant deployment.
	QueryContext []string `json:"queryContext,omitempty"`
	// TimeFilters: Documents created/updated within a range specified by this
	// filter are searched against.
	TimeFilters []*GoogleCloudContentwarehouseV1TimeFilter `json:"timeFilters,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CustomPropertyFilter") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CustomPropertyFilter") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContentwarehouseV1DocumentQuery) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContentwarehouseV1DocumentQuery
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContentwarehouseV1DocumentReference: References to the documents.
type GoogleCloudContentwarehouseV1DocumentReference struct {
	// CreateTime: Output only. The time when the document is created.
	CreateTime string `json:"createTime,omitempty"`
	// DeleteTime: Output only. The time when the document is deleted.
	DeleteTime string `json:"deleteTime,omitempty"`
	// DisplayName: display_name of the referenced document; this name does not
	// need to be consistent to the display_name in the Document proto, depending
	// on the ACL constraint.
	DisplayName string `json:"displayName,omitempty"`
	// DocumentIsFolder: The document type of the document being referenced.
	DocumentIsFolder bool `json:"documentIsFolder,omitempty"`
	// DocumentIsLegalHoldFolder: Document is a folder with legal hold.
	DocumentIsLegalHoldFolder bool `json:"documentIsLegalHoldFolder,omitempty"`
	// DocumentIsRetentionFolder: Document is a folder with retention policy.
	DocumentIsRetentionFolder bool `json:"documentIsRetentionFolder,omitempty"`
	// DocumentName: Required. Name of the referenced document.
	DocumentName string `json:"documentName,omitempty"`
	// Snippet: Stores the subset of the referenced document's content. This is
	// useful to allow user peek the information of the referenced document.
	Snippet string `json:"snippet,omitempty"`
	// UpdateTime: Output only. The time when the document is last updated.
	UpdateTime string `json:"updateTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContentwarehouseV1DocumentReference) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContentwarehouseV1DocumentReference
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContentwarehouseV1DocumentSchema: A document schema used to
// define document structure.
type GoogleCloudContentwarehouseV1DocumentSchema struct {
	// CreateTime: Output only. The time when the document schema is created.
	CreateTime string `json:"createTime,omitempty"`
	// Description: Schema description.
	Description string `json:"description,omitempty"`
	// DisplayName: Required. Name of the schema given by the user. Must be unique
	// per project.
	DisplayName string `json:"displayName,omitempty"`
	// DocumentIsFolder: Document Type, true refers the document is a folder,
	// otherwise it is a typical document.
	DocumentIsFolder bool `json:"documentIsFolder,omitempty"`
	// Name: The resource name of the document schema. Format:
	// projects/{project_number}/locations/{location}/documentSchemas/{document_sche
	// ma_id}. The name is ignored when creating a document schema.
	Name string `json:"name,omitempty"`
	// PropertyDefinitions: Document details.
	PropertyDefinitions []*GoogleCloudContentwarehouseV1PropertyDefinition `json:"propertyDefinitions,omitempty"`
	// UpdateTime: Output only. The time when the document schema is last updated.
	UpdateTime string `json:"updateTime,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContentwarehouseV1DocumentSchema) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContentwarehouseV1DocumentSchema
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContentwarehouseV1EnumArray: Enum values.
type GoogleCloudContentwarehouseV1EnumArray struct {
	// Values: List of enum values.
	Values []string `json:"values,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Values") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Values") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContentwarehouseV1EnumArray) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContentwarehouseV1EnumArray
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContentwarehouseV1EnumTypeOptions: Configurations for an
// enum/categorical property.
type GoogleCloudContentwarehouseV1EnumTypeOptions struct {
	// PossibleValues: Required. List of possible enum values.
	PossibleValues []string `json:"possibleValues,omitempty"`
	// ValidationCheckDisabled: Make sure the Enum property value provided in the
	// document is in the possile value list during document creation. The
	// validation check runs by default.
	ValidationCheckDisabled bool `json:"validationCheckDisabled,omitempty"`
	// ForceSendFields is a list of field names (e.g. "PossibleValues") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "PossibleValues") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContentwarehouseV1EnumTypeOptions) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContentwarehouseV1EnumTypeOptions
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContentwarehouseV1EnumValue: Represents the string value of the
// enum field.
type GoogleCloudContentwarehouseV1EnumValue struct {
	// Value: String value of the enum field. This must match defined set of enums
	// in document schema using EnumTypeOptions.
	Value string `json:"value,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Value") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Value") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContentwarehouseV1EnumValue) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContentwarehouseV1EnumValue
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContentwarehouseV1ExportToCdwPipeline: The configuration of
// exporting documents from the Document Warehouse to CDW pipeline.
type GoogleCloudContentwarehouseV1ExportToCdwPipeline struct {
	// DocAiDataset: Optional. The CDW dataset resource name. This field is
	// optional. If not set, the documents will be exported to Cloud Storage only.
	// Format:
	// projects/{project}/locations/{location}/processors/{processor}/dataset
	DocAiDataset string `json:"docAiDataset,omitempty"`
	// Documents: The list of all the resource names of the documents to be
	// processed. Format:
	// projects/{project_number}/locations/{location}/documents/{document_id}.
	Documents []string `json:"documents,omitempty"`
	// ExportFolderPath: The Cloud Storage folder path used to store the exported
	// documents before being sent to CDW. Format: `gs:///`.
	ExportFolderPath string `json:"exportFolderPath,omitempty"`
	// TrainingSplitRatio: Ratio of training dataset split. When importing into
	// Document AI Workbench, documents will be automatically split into training
	// and test split category with the specified ratio. This field is required if
	// doc_ai_dataset is set.
	TrainingSplitRatio float64 `json:"trainingSplitRatio,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DocAiDataset") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DocAiDataset") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContentwarehouseV1ExportToCdwPipeline) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContentwarehouseV1ExportToCdwPipeline
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudContentwarehouseV1ExportToCdwPipeline) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudContentwarehouseV1ExportToCdwPipeline
	var s1 struct {
		TrainingSplitRatio gensupport.JSONFloat64 `json:"trainingSplitRatio"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.TrainingSplitRatio = float64(s1.TrainingSplitRatio)
	return nil
}

// GoogleCloudContentwarehouseV1FetchAclRequest: Request message for
// DocumentService.FetchAcl
type GoogleCloudContentwarehouseV1FetchAclRequest struct {
	// ProjectOwner: For Get Project ACL only. Authorization check for end user
	// will be ignored when project_owner=true.
	ProjectOwner bool `json:"projectOwner,omitempty"`
	// RequestMetadata: The meta information collected about the end user, used to
	// enforce access control for the service.
	RequestMetadata *GoogleCloudContentwarehouseV1RequestMetadata `json:"requestMetadata,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ProjectOwner") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ProjectOwner") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContentwarehouseV1FetchAclRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContentwarehouseV1FetchAclRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContentwarehouseV1FetchAclResponse: Response message for
// DocumentService.FetchAcl.
type GoogleCloudContentwarehouseV1FetchAclResponse struct {
	// Metadata: Additional information for the API invocation, such as the request
	// tracking id.
	Metadata *GoogleCloudContentwarehouseV1ResponseMetadata `json:"metadata,omitempty"`
	// Policy: The IAM policy.
	Policy *GoogleIamV1Policy `json:"policy,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Metadata") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Metadata") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContentwarehouseV1FetchAclResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContentwarehouseV1FetchAclResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContentwarehouseV1FileTypeFilter: Filter for the specific types
// of documents returned.
type GoogleCloudContentwarehouseV1FileTypeFilter struct {
	// FileType: The type of files to return.
	//
	// Possible values:
	//   "FILE_TYPE_UNSPECIFIED" - Default document type. If set, disables the
	// filter.
	//   "ALL" - Returns all document types, including folders.
	//   "FOLDER" - Returns only folders.
	//   "DOCUMENT" - Returns only non-folder documents.
	//   "ROOT_FOLDER" - Returns only root folders
	FileType string `json:"fileType,omitempty"`
	// ForceSendFields is a list of field names (e.g. "FileType") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "FileType") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContentwarehouseV1FileTypeFilter) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContentwarehouseV1FileTypeFilter
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContentwarehouseV1FloatArray: Float values.
type GoogleCloudContentwarehouseV1FloatArray struct {
	// Values: List of float values.
	Values []float64 `json:"values,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Values") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Values") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContentwarehouseV1FloatArray) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContentwarehouseV1FloatArray
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudContentwarehouseV1FloatArray) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudContentwarehouseV1FloatArray
	var s1 struct {
		Values []gensupport.JSONFloat64 `json:"values"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Values = make([]float64, len(s1.Values))
	for i := range s1.Values {
		s.Values[i] = float64(s1.Values[i])
	}
	return nil
}

// GoogleCloudContentwarehouseV1FloatTypeOptions: Configurations for a float
// property.
type GoogleCloudContentwarehouseV1FloatTypeOptions struct {
}

// GoogleCloudContentwarehouseV1GcsIngestPipeline: The configuration of the
// Cloud Storage Ingestion pipeline.
type GoogleCloudContentwarehouseV1GcsIngestPipeline struct {
	// InputPath: The input Cloud Storage folder. All files under this folder will
	// be imported to Document Warehouse. Format: `gs:///`.
	InputPath string `json:"inputPath,omitempty"`
	// PipelineConfig: Optional. The config for the Cloud Storage Ingestion
	// pipeline. It provides additional customization options to run the pipeline
	// and can be skipped if it is not applicable.
	PipelineConfig *GoogleCloudContentwarehouseV1IngestPipelineConfig `json:"pipelineConfig,omitempty"`
	// ProcessorType: The Doc AI processor type name. Only used when the format of
	// ingested files is Doc AI Document proto format.
	ProcessorType string `json:"processorType,omitempty"`
	// SchemaName: The Document Warehouse schema resource name. All documents
	// processed by this pipeline will use this schema. Format:
	// projects/{project_number}/locations/{location}/documentSchemas/{document_sche
	// ma_id}.
	SchemaName string `json:"schemaName,omitempty"`
	// SkipIngestedDocuments: The flag whether to skip ingested documents. If it is
	// set to true, documents in Cloud Storage contains key "status" with value
	// "status=ingested" in custom metadata will be skipped to ingest.
	SkipIngestedDocuments bool `json:"skipIngestedDocuments,omitempty"`
	// ForceSendFields is a list of field names (e.g. "InputPath") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "InputPath") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContentwarehouseV1GcsIngestPipeline) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContentwarehouseV1GcsIngestPipeline
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContentwarehouseV1GcsIngestWithDocAiProcessorsPipeline: The
// configuration of the Cloud Storage Ingestion with DocAI Processors pipeline.
type GoogleCloudContentwarehouseV1GcsIngestWithDocAiProcessorsPipeline struct {
	// ExtractProcessorInfos: The extract processors information. One matched
	// extract processor will be used to process documents based on the classify
	// processor result. If no classify processor is specified, the first extract
	// processor will be used.
	ExtractProcessorInfos []*GoogleCloudContentwarehouseV1ProcessorInfo `json:"extractProcessorInfos,omitempty"`
	// InputPath: The input Cloud Storage folder. All files under this folder will
	// be imported to Document Warehouse. Format: `gs:///`.
	InputPath string `json:"inputPath,omitempty"`
	// PipelineConfig: Optional. The config for the Cloud Storage Ingestion with
	// DocAI Processors pipeline. It provides additional customization options to
	// run the pipeline and can be skipped if it is not applicable.
	PipelineConfig *GoogleCloudContentwarehouseV1IngestPipelineConfig `json:"pipelineConfig,omitempty"`
	// ProcessorResultsFolderPath: The Cloud Storage folder path used to store the
	// raw results from processors. Format: `gs:///`.
	ProcessorResultsFolderPath string `json:"processorResultsFolderPath,omitempty"`
	// SkipIngestedDocuments: The flag whether to skip ingested documents. If it is
	// set to true, documents in Cloud Storage contains key "status" with value
	// "status=ingested" in custom metadata will be skipped to ingest.
	SkipIngestedDocuments bool `json:"skipIngestedDocuments,omitempty"`
	// SplitClassifyProcessorInfo: The split and classify processor information.
	// The split and classify result will be used to find a matched extract
	// processor.
	SplitClassifyProcessorInfo *GoogleCloudContentwarehouseV1ProcessorInfo `json:"splitClassifyProcessorInfo,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ExtractProcessorInfos") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ExtractProcessorInfos") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContentwarehouseV1GcsIngestWithDocAiProcessorsPipeline) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContentwarehouseV1GcsIngestWithDocAiProcessorsPipeline
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContentwarehouseV1GetDocumentRequest: Request message for
// DocumentService.GetDocument.
type GoogleCloudContentwarehouseV1GetDocumentRequest struct {
	// RequestMetadata: The meta information collected about the end user, used to
	// enforce access control for the service.
	RequestMetadata *GoogleCloudContentwarehouseV1RequestMetadata `json:"requestMetadata,omitempty"`
	// ForceSendFields is a list of field names (e.g. "RequestMetadata") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "RequestMetadata") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContentwarehouseV1GetDocumentRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContentwarehouseV1GetDocumentRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContentwarehouseV1HistogramQuery: The histogram request.
type GoogleCloudContentwarehouseV1HistogramQuery struct {
	// Filters: Optional. Filter the result of histogram query by the property
	// names. It only works with histogram query count('FilterableProperties'). It
	// is an optional. It will perform histogram on all the property names for all
	// the document schemas. Setting this field will have a better performance.
	Filters *GoogleCloudContentwarehouseV1HistogramQueryPropertyNameFilter `json:"filters,omitempty"`
	// HistogramQuery: An expression specifies a histogram request against matching
	// documents for searches. See SearchDocumentsRequest.histogram_queries for
	// details about syntax.
	HistogramQuery string `json:"histogramQuery,omitempty"`
	// RequirePreciseResultSize: Controls if the histogram query requires the
	// return of a precise count. Enable this flag may adversely impact
	// performance. Defaults to true.
	RequirePreciseResultSize bool `json:"requirePreciseResultSize,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Filters") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Filters") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContentwarehouseV1HistogramQuery) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContentwarehouseV1HistogramQuery
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudContentwarehouseV1HistogramQueryPropertyNameFilter struct {
	// DocumentSchemas: This filter specifies the exact document schema(s)
	// Document.document_schema_name to run histogram query against. It is
	// optional. It will perform histogram for property names for all the document
	// schemas if it is not set. At most 10 document schema names are allowed.
	// Format:
	// projects/{project_number}/locations/{location}/documentSchemas/{document_sche
	// ma_id}.
	DocumentSchemas []string `json:"documentSchemas,omitempty"`
	// PropertyNames: It is optional. It will perform histogram for all the
	// property names if it is not set. The properties need to be defined with the
	// is_filterable flag set to true and the name of the property should be in the
	// format: "schemaId.propertyName". The property needs to be defined in the
	// schema. Example: the schema id is abc. Then the name of property for
	// property MORTGAGE_TYPE will be "abc.MORTGAGE_TYPE".
	PropertyNames []string `json:"propertyNames,omitempty"`
	// YAxis: By default, the y_axis is HISTOGRAM_YAXIS_DOCUMENT if this field is
	// not set.
	//
	// Possible values:
	//   "HISTOGRAM_YAXIS_DOCUMENT" - Count the documents per property name.
	//   "HISTOGRAM_YAXIS_PROPERTY" - Count the properties per property name.
	YAxis string `json:"yAxis,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DocumentSchemas") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DocumentSchemas") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContentwarehouseV1HistogramQueryPropertyNameFilter) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContentwarehouseV1HistogramQueryPropertyNameFilter
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContentwarehouseV1HistogramQueryResult: Histogram result that
// matches HistogramQuery specified in searches.
type GoogleCloudContentwarehouseV1HistogramQueryResult struct {
	// Histogram: A map from the values of the facet associated with distinct
	// values to the number of matching entries with corresponding value. The key
	// format is: * (for string histogram) string values stored in the field.
	Histogram map[string]string `json:"histogram,omitempty"`
	// HistogramQuery: Requested histogram expression.
	HistogramQuery string `json:"histogramQuery,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Histogram") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Histogram") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContentwarehouseV1HistogramQueryResult) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContentwarehouseV1HistogramQueryResult
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContentwarehouseV1IngestPipelineConfig: The ingestion pipeline
// config.
type GoogleCloudContentwarehouseV1IngestPipelineConfig struct {
	// CloudFunction: The Cloud Function resource name. The Cloud Function needs to
	// live inside consumer project and is accessible to Document AI Warehouse
	// P4SA. Only Cloud Functions V2 is supported. Cloud function execution should
	// complete within 5 minutes or this file ingestion may fail due to timeout.
	// Format: `https://{region}-{project_id}.cloudfunctions.net/{cloud_function}`
	// The following keys are available the request json payload. * display_name *
	// properties * plain_text * reference_id * document_schema_name *
	// raw_document_path * raw_document_file_type The following keys from the cloud
	// function json response payload will be ingested to the Document AI Warehouse
	// as part of Document proto content and/or related information. The original
	// values will be overridden if any key is present in the response. *
	// display_name * properties * plain_text * document_acl_policy * folder
	CloudFunction string `json:"cloudFunction,omitempty"`
	// DocumentAclPolicy: The document level acl policy config. This refers to an
	// Identity and Access (IAM) policy, which specifies access controls for all
	// documents ingested by the pipeline. The role and members under the policy
	// needs to be specified. The following roles are supported for document level
	// acl control: * roles/contentwarehouse.documentAdmin *
	// roles/contentwarehouse.documentEditor *
	// roles/contentwarehouse.documentViewer The following members are supported
	// for document level acl control: * user:user-email@example.com *
	// group:group-email@example.com Note that for documents searched with LLM,
	// only single level user or group acl check is supported.
	DocumentAclPolicy *GoogleIamV1Policy `json:"documentAclPolicy,omitempty"`
	// EnableDocumentTextExtraction: The document text extraction enabled flag. If
	// the flag is set to true, DWH will perform text extraction on the raw
	// document.
	EnableDocumentTextExtraction bool `json:"enableDocumentTextExtraction,omitempty"`
	// Folder: Optional. The name of the folder to which all ingested documents
	// will be linked during ingestion process. Format is
	// `projects/{project}/locations/{location}/documents/{folder_id}`
	Folder string `json:"folder,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CloudFunction") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CloudFunction") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContentwarehouseV1IngestPipelineConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContentwarehouseV1IngestPipelineConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContentwarehouseV1InitializeProjectRequest: Request message for
// projectService.InitializeProject
type GoogleCloudContentwarehouseV1InitializeProjectRequest struct {
	// AccessControlMode: Required. The access control mode for accessing the
	// customer data
	//
	// Possible values:
	//   "ACL_MODE_UNKNOWN" - This value is required by protobuf best practices
	//   "ACL_MODE_UNIVERSAL_ACCESS" - Universal Access: No document level access
	// control.
	//   "ACL_MODE_DOCUMENT_LEVEL_ACCESS_CONTROL_BYOID" - Document level access
	// control with customer own Identity Service.
	//   "ACL_MODE_DOCUMENT_LEVEL_ACCESS_CONTROL_GCI" - Document level access
	// control using Google Cloud Identity.
	AccessControlMode string `json:"accessControlMode,omitempty"`
	// DatabaseType: Required. The type of database used to store customer data
	//
	// Possible values:
	//   "DB_UNKNOWN" - This value is required by protobuf best practices
	//   "DB_INFRA_SPANNER" - Internal Spanner
	//   "DB_CLOUD_SQL_POSTGRES" - Cloud Sql with a Postgres Sql instance
	DatabaseType string `json:"databaseType,omitempty"`
	// DocumentCreatorDefaultRole: Optional. The default role for the person who
	// create a document.
	//
	// Possible values:
	//   "DOCUMENT_CREATOR_DEFAULT_ROLE_UNSPECIFIED" - Unspecified, will be default
	// to document admin role.
	//   "DOCUMENT_ADMIN" - Document Admin, same as
	// contentwarehouse.googleapis.com/documentAdmin.
	//   "DOCUMENT_EDITOR" - Document Editor, same as
	// contentwarehouse.googleapis.com/documentEditor.
	//   "DOCUMENT_VIEWER" - Document Viewer, same as
	// contentwarehouse.googleapis.com/documentViewer.
	DocumentCreatorDefaultRole string `json:"documentCreatorDefaultRole,omitempty"`
	// EnableCalUserEmailLogging: Optional. Whether to enable CAL user email
	// logging.
	EnableCalUserEmailLogging bool `json:"enableCalUserEmailLogging,omitempty"`
	// KmsKey: Optional. The KMS key used for CMEK encryption. It is required that
	// the kms key is in the same region as the endpoint. The same key will be used
	// for all provisioned resources, if encryption is available. If the kms_key is
	// left empty, no encryption will be enforced.
	KmsKey string `json:"kmsKey,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AccessControlMode") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AccessControlMode") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContentwarehouseV1InitializeProjectRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContentwarehouseV1InitializeProjectRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContentwarehouseV1InitializeProjectResponse: Response message for
// projectService.InitializeProject
type GoogleCloudContentwarehouseV1InitializeProjectResponse struct {
	// Message: The message of the project initialization process.
	Message string `json:"message,omitempty"`
	// State: The state of the project initialization process.
	//
	// Possible values:
	//   "STATE_UNSPECIFIED" - Clients should never see this.
	//   "SUCCEEDED" - Finished project initialization without error.
	//   "FAILED" - Finished project initialization with an error.
	//   "CANCELLED" - Client canceled the LRO.
	//   "RUNNING" - Ask the customer to check the operation for results.
	State string `json:"state,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Message") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Message") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContentwarehouseV1InitializeProjectResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContentwarehouseV1InitializeProjectResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContentwarehouseV1IntegerArray: Integer values.
type GoogleCloudContentwarehouseV1IntegerArray struct {
	// Values: List of integer values.
	Values []int64 `json:"values,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Values") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Values") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContentwarehouseV1IntegerArray) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContentwarehouseV1IntegerArray
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContentwarehouseV1IntegerTypeOptions: Configurations for an
// integer property.
type GoogleCloudContentwarehouseV1IntegerTypeOptions struct {
}

// GoogleCloudContentwarehouseV1InvalidRule: A triggered rule that failed the
// validation check(s) after parsing.
type GoogleCloudContentwarehouseV1InvalidRule struct {
	// Error: Validation error on a parsed expression.
	Error string `json:"error,omitempty"`
	// Rule: Triggered rule.
	Rule *GoogleCloudContentwarehouseV1Rule `json:"rule,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Error") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Error") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContentwarehouseV1InvalidRule) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContentwarehouseV1InvalidRule
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContentwarehouseV1ListDocumentSchemasResponse: Response message
// for DocumentSchemaService.ListDocumentSchemas.
type GoogleCloudContentwarehouseV1ListDocumentSchemasResponse struct {
	// DocumentSchemas: The document schemas from the specified parent.
	DocumentSchemas []*GoogleCloudContentwarehouseV1DocumentSchema `json:"documentSchemas,omitempty"`
	// NextPageToken: A token, which can be sent as `page_token` to retrieve the
	// next page. If this field is omitted, there are no subsequent pages.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "DocumentSchemas") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DocumentSchemas") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContentwarehouseV1ListDocumentSchemasResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContentwarehouseV1ListDocumentSchemasResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContentwarehouseV1ListLinkedSourcesRequest: Response message for
// DocumentLinkService.ListLinkedSources.
type GoogleCloudContentwarehouseV1ListLinkedSourcesRequest struct {
	// PageSize: The maximum number of document-links to return. The service may
	// return fewer than this value. If unspecified, at most 50 document-links will
	// be returned. The maximum value is 1000; values above 1000 will be coerced to
	// 1000.
	PageSize int64 `json:"pageSize,omitempty"`
	// PageToken: A page token, received from a previous `ListLinkedSources` call.
	// Provide this to retrieve the subsequent page. When paginating, all other
	// parameters provided to `ListLinkedSources` must match the call that provided
	// the page token.
	PageToken string `json:"pageToken,omitempty"`
	// RequestMetadata: The meta information collected about the document creator,
	// used to enforce access control for the service.
	RequestMetadata *GoogleCloudContentwarehouseV1RequestMetadata `json:"requestMetadata,omitempty"`
	// ForceSendFields is a list of field names (e.g. "PageSize") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "PageSize") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContentwarehouseV1ListLinkedSourcesRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContentwarehouseV1ListLinkedSourcesRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContentwarehouseV1ListLinkedSourcesResponse: Response message for
// DocumentLinkService.ListLinkedSources.
type GoogleCloudContentwarehouseV1ListLinkedSourcesResponse struct {
	// DocumentLinks: Source document-links.
	DocumentLinks []*GoogleCloudContentwarehouseV1DocumentLink `json:"documentLinks,omitempty"`
	// NextPageToken: A token, which can be sent as `page_token` to retrieve the
	// next page. If this field is omitted, there are no subsequent pages.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "DocumentLinks") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DocumentLinks") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContentwarehouseV1ListLinkedSourcesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContentwarehouseV1ListLinkedSourcesResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContentwarehouseV1ListLinkedTargetsRequest: Request message for
// DocumentLinkService.ListLinkedTargets.
type GoogleCloudContentwarehouseV1ListLinkedTargetsRequest struct {
	// RequestMetadata: The meta information collected about the document creator,
	// used to enforce access control for the service.
	RequestMetadata *GoogleCloudContentwarehouseV1RequestMetadata `json:"requestMetadata,omitempty"`
	// ForceSendFields is a list of field names (e.g. "RequestMetadata") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "RequestMetadata") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContentwarehouseV1ListLinkedTargetsRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContentwarehouseV1ListLinkedTargetsRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContentwarehouseV1ListLinkedTargetsResponse: Response message for
// DocumentLinkService.ListLinkedTargets.
type GoogleCloudContentwarehouseV1ListLinkedTargetsResponse struct {
	// DocumentLinks: Target document-links.
	DocumentLinks []*GoogleCloudContentwarehouseV1DocumentLink `json:"documentLinks,omitempty"`
	// NextPageToken: A token, which can be sent as `page_token` to retrieve the
	// next page. If this field is omitted, there are no subsequent pages.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "DocumentLinks") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DocumentLinks") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContentwarehouseV1ListLinkedTargetsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContentwarehouseV1ListLinkedTargetsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContentwarehouseV1ListRuleSetsResponse: Response message for
// RuleSetService.ListRuleSets.
type GoogleCloudContentwarehouseV1ListRuleSetsResponse struct {
	// NextPageToken: A token, which can be sent as `page_token` to retrieve the
	// next page. If this field is omitted, there are no subsequent pages.
	NextPageToken string `json:"nextPageToken,omitempty"`
	// RuleSets: The rule sets from the specified parent.
	RuleSets []*GoogleCloudContentwarehouseV1RuleSet `json:"ruleSets,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NextPageToken") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContentwarehouseV1ListRuleSetsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContentwarehouseV1ListRuleSetsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContentwarehouseV1ListSynonymSetsResponse: Response message for
// SynonymSetService.ListSynonymSets.
type GoogleCloudContentwarehouseV1ListSynonymSetsResponse struct {
	// NextPageToken: A page token, received from a previous `ListSynonymSets`
	// call. Provide this to retrieve the subsequent page.
	NextPageToken string `json:"nextPageToken,omitempty"`
	// SynonymSets: The synonymSets from the specified parent.
	SynonymSets []*GoogleCloudContentwarehouseV1SynonymSet `json:"synonymSets,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NextPageToken") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContentwarehouseV1ListSynonymSetsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContentwarehouseV1ListSynonymSetsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContentwarehouseV1LockDocumentRequest: Request message for
// DocumentService.LockDocument.
type GoogleCloudContentwarehouseV1LockDocumentRequest struct {
	// CollectionId: The collection the document connects to.
	CollectionId string `json:"collectionId,omitempty"`
	// LockingUser: The user information who locks the document.
	LockingUser *GoogleCloudContentwarehouseV1UserInfo `json:"lockingUser,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CollectionId") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CollectionId") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContentwarehouseV1LockDocumentRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContentwarehouseV1LockDocumentRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContentwarehouseV1MapProperty: Map property value. Represents a
// structured entries of key value pairs, consisting of field names which map
// to dynamically typed values.
type GoogleCloudContentwarehouseV1MapProperty struct {
	// Fields: Unordered map of dynamically typed values.
	Fields map[string]GoogleCloudContentwarehouseV1Value `json:"fields,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Fields") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Fields") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContentwarehouseV1MapProperty) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContentwarehouseV1MapProperty
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContentwarehouseV1MapTypeOptions: Configurations for a Map
// property.
type GoogleCloudContentwarehouseV1MapTypeOptions struct {
}

// GoogleCloudContentwarehouseV1MergeFieldsOptions: Options for merging updated
// fields.
type GoogleCloudContentwarehouseV1MergeFieldsOptions struct {
	// ReplaceMessageFields: When merging message fields, the default behavior is
	// to merge the content of two message fields together. If you instead want to
	// use the field from the source message to replace the corresponding field in
	// the destination message, set this flag to true. When this flag is set,
	// specified submessage fields that are missing in source will be cleared in
	// destination.
	ReplaceMessageFields bool `json:"replaceMessageFields,omitempty"`
	// ReplaceRepeatedFields: When merging repeated fields, the default behavior is
	// to append entries from the source repeated field to the destination repeated
	// field. If you instead want to keep only the entries from the source repeated
	// field, set this flag to true. If you want to replace a repeated field within
	// a message field on the destination message, you must set both
	// replace_repeated_fields and replace_message_fields to true, otherwise the
	// repeated fields will be appended.
	ReplaceRepeatedFields bool `json:"replaceRepeatedFields,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ReplaceMessageFields") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ReplaceMessageFields") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContentwarehouseV1MergeFieldsOptions) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContentwarehouseV1MergeFieldsOptions
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContentwarehouseV1ProcessWithDocAiPipeline: The configuration of
// processing documents in Document Warehouse with DocAi processors pipeline.
type GoogleCloudContentwarehouseV1ProcessWithDocAiPipeline struct {
	// Documents: The list of all the resource names of the documents to be
	// processed. Format:
	// projects/{project_number}/locations/{location}/documents/{document_id}.
	Documents []string `json:"documents,omitempty"`
	// ExportFolderPath: The Cloud Storage folder path used to store the exported
	// documents before being sent to CDW. Format: `gs:///`.
	ExportFolderPath string `json:"exportFolderPath,omitempty"`
	// ProcessorInfo: The CDW processor information.
	ProcessorInfo *GoogleCloudContentwarehouseV1ProcessorInfo `json:"processorInfo,omitempty"`
	// ProcessorResultsFolderPath: The Cloud Storage folder path used to store the
	// raw results from processors. Format: `gs:///`.
	ProcessorResultsFolderPath string `json:"processorResultsFolderPath,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Documents") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Documents") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContentwarehouseV1ProcessWithDocAiPipeline) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContentwarehouseV1ProcessWithDocAiPipeline
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContentwarehouseV1ProcessorInfo: The DocAI processor information.
type GoogleCloudContentwarehouseV1ProcessorInfo struct {
	// DocumentType: The processor will process the documents with this document
	// type.
	DocumentType string `json:"documentType,omitempty"`
	// ProcessorName: The processor resource name. Format is
	// `projects/{project}/locations/{location}/processors/{processor}`, or
	// `projects/{project}/locations/{location}/processors/{processor}/processorVers
	// ions/{processorVersion}`
	ProcessorName string `json:"processorName,omitempty"`
	// SchemaName: The Document schema resource name. All documents processed by
	// this processor will use this schema. Format:
	// projects/{project_number}/locations/{location}/documentSchemas/{document_sche
	// ma_id}.
	SchemaName string `json:"schemaName,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DocumentType") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DocumentType") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContentwarehouseV1ProcessorInfo) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContentwarehouseV1ProcessorInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContentwarehouseV1ProjectStatus: Status of a project, including
// the project state, dbType, aclMode and etc.
type GoogleCloudContentwarehouseV1ProjectStatus struct {
	// AccessControlMode: Access control mode.
	//
	// Possible values:
	//   "ACL_MODE_UNKNOWN" - This value is required by protobuf best practices
	//   "ACL_MODE_UNIVERSAL_ACCESS" - Universal Access: No document level access
	// control.
	//   "ACL_MODE_DOCUMENT_LEVEL_ACCESS_CONTROL_BYOID" - Document level access
	// control with customer own Identity Service.
	//   "ACL_MODE_DOCUMENT_LEVEL_ACCESS_CONTROL_GCI" - Document level access
	// control using Google Cloud Identity.
	AccessControlMode string `json:"accessControlMode,omitempty"`
	// DatabaseType: Database type.
	//
	// Possible values:
	//   "DB_UNKNOWN" - This value is required by protobuf best practices
	//   "DB_INFRA_SPANNER" - Internal Spanner
	//   "DB_CLOUD_SQL_POSTGRES" - Cloud Sql with a Postgres Sql instance
	DatabaseType string `json:"databaseType,omitempty"`
	// DocumentCreatorDefaultRole: The default role for the person who create a
	// document.
	DocumentCreatorDefaultRole string `json:"documentCreatorDefaultRole,omitempty"`
	// Location: The location of the queried project.
	Location string `json:"location,omitempty"`
	// QaEnabled: If the qa is enabled on this project.
	QaEnabled bool `json:"qaEnabled,omitempty"`
	// State: State of the project.
	//
	// Possible values:
	//   "PROJECT_STATE_UNSPECIFIED" - Default status, required by protobuf best
	// practices.
	//   "PROJECT_STATE_PENDING" - The project is in the middle of a provision
	// process.
	//   "PROJECT_STATE_COMPLETED" - All dependencies have been provisioned.
	//   "PROJECT_STATE_FAILED" - A provision process was previously initiated, but
	// failed.
	//   "PROJECT_STATE_DELETING" - The project is in the middle of a deletion
	// process.
	//   "PROJECT_STATE_DELETING_FAILED" - A deleting process was initiated, but
	// failed.
	//   "PROJECT_STATE_DELETED" - The project is deleted.
	//   "PROJECT_STATE_NOT_FOUND" - The project is not found.
	State string `json:"state,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "AccessControlMode") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AccessControlMode") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContentwarehouseV1ProjectStatus) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContentwarehouseV1ProjectStatus
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContentwarehouseV1Property: Property of a document.
type GoogleCloudContentwarehouseV1Property struct {
	// DateTimeValues: Date time property values. It is not supported by CMEK
	// compliant deployment.
	DateTimeValues *GoogleCloudContentwarehouseV1DateTimeArray `json:"dateTimeValues,omitempty"`
	// EnumValues: Enum property values.
	EnumValues *GoogleCloudContentwarehouseV1EnumArray `json:"enumValues,omitempty"`
	// FloatValues: Float property values.
	FloatValues *GoogleCloudContentwarehouseV1FloatArray `json:"floatValues,omitempty"`
	// IntegerValues: Integer property values.
	IntegerValues *GoogleCloudContentwarehouseV1IntegerArray `json:"integerValues,omitempty"`
	// MapProperty: Map property values.
	MapProperty *GoogleCloudContentwarehouseV1MapProperty `json:"mapProperty,omitempty"`
	// Name: Required. Must match the name of a PropertyDefinition in the
	// DocumentSchema.
	Name string `json:"name,omitempty"`
	// PropertyValues: Nested structured data property values.
	PropertyValues *GoogleCloudContentwarehouseV1PropertyArray `json:"propertyValues,omitempty"`
	// TextValues: String/text property values.
	TextValues *GoogleCloudContentwarehouseV1TextArray `json:"textValues,omitempty"`
	// TimestampValues: Timestamp property values. It is not supported by CMEK
	// compliant deployment.
	TimestampValues *GoogleCloudContentwarehouseV1TimestampArray `json:"timestampValues,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DateTimeValues") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DateTimeValues") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContentwarehouseV1Property) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContentwarehouseV1Property
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContentwarehouseV1PropertyArray: Property values.
type GoogleCloudContentwarehouseV1PropertyArray struct {
	// Properties: List of property values.
	Properties []*GoogleCloudContentwarehouseV1Property `json:"properties,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Properties") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Properties") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContentwarehouseV1PropertyArray) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContentwarehouseV1PropertyArray
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContentwarehouseV1PropertyDefinition: Defines the metadata for a
// schema property.
type GoogleCloudContentwarehouseV1PropertyDefinition struct {
	// DateTimeTypeOptions: Date time property. It is not supported by CMEK
	// compliant deployment.
	DateTimeTypeOptions *GoogleCloudContentwarehouseV1DateTimeTypeOptions `json:"dateTimeTypeOptions,omitempty"`
	// DisplayName: The display-name for the property, used for front-end.
	DisplayName string `json:"displayName,omitempty"`
	// EnumTypeOptions: Enum/categorical property.
	EnumTypeOptions *GoogleCloudContentwarehouseV1EnumTypeOptions `json:"enumTypeOptions,omitempty"`
	// FloatTypeOptions: Float property.
	FloatTypeOptions *GoogleCloudContentwarehouseV1FloatTypeOptions `json:"floatTypeOptions,omitempty"`
	// IntegerTypeOptions: Integer property.
	IntegerTypeOptions *GoogleCloudContentwarehouseV1IntegerTypeOptions `json:"integerTypeOptions,omitempty"`
	// IsFilterable: Whether the property can be filtered. If this is a
	// sub-property, all the parent properties must be marked filterable.
	IsFilterable bool `json:"isFilterable,omitempty"`
	// IsMetadata: Whether the property is user supplied metadata. This out-of-the
	// box placeholder setting can be used to tag derived properties. Its value and
	// interpretation logic should be implemented by API user.
	IsMetadata bool `json:"isMetadata,omitempty"`
	// IsRepeatable: Whether the property can have multiple values.
	IsRepeatable bool `json:"isRepeatable,omitempty"`
	// IsRequired: Whether the property is mandatory. Default is 'false', i.e.
	// populating property value can be skipped. If 'true' then user must populate
	// the value for this property.
	IsRequired bool `json:"isRequired,omitempty"`
	// IsSearchable: Indicates that the property should be included in a global
	// search.
	IsSearchable bool `json:"isSearchable,omitempty"`
	// MapTypeOptions: Map property.
	MapTypeOptions *GoogleCloudContentwarehouseV1MapTypeOptions `json:"mapTypeOptions,omitempty"`
	// Name: Required. The name of the metadata property. Must be unique within a
	// document schema and is case insensitive. Names must be non-blank, start with
	// a letter, and can contain alphanumeric characters and: /, :, -, _, and .
	Name string `json:"name,omitempty"`
	// PropertyTypeOptions: Nested structured data property.
	PropertyTypeOptions *GoogleCloudContentwarehouseV1PropertyTypeOptions `json:"propertyTypeOptions,omitempty"`
	// RetrievalImportance: The retrieval importance of the property during search.
	//
	// Possible values:
	//   "RETRIEVAL_IMPORTANCE_UNSPECIFIED" - No importance specified. Default
	// medium importance.
	//   "HIGHEST" - Highest importance.
	//   "HIGHER" - Higher importance.
	//   "HIGH" - High importance.
	//   "MEDIUM" - Medium importance.
	//   "LOW" - Low importance (negative).
	//   "LOWEST" - Lowest importance (negative).
	RetrievalImportance string `json:"retrievalImportance,omitempty"`
	// SchemaSources: The mapping information between this property to another
	// schema source.
	SchemaSources []*GoogleCloudContentwarehouseV1PropertyDefinitionSchemaSource `json:"schemaSources,omitempty"`
	// TextTypeOptions: Text/string property.
	TextTypeOptions *GoogleCloudContentwarehouseV1TextTypeOptions `json:"textTypeOptions,omitempty"`
	// TimestampTypeOptions: Timestamp property. It is not supported by CMEK
	// compliant deployment.
	TimestampTypeOptions *GoogleCloudContentwarehouseV1TimestampTypeOptions `json:"timestampTypeOptions,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DateTimeTypeOptions") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DateTimeTypeOptions") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContentwarehouseV1PropertyDefinition) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContentwarehouseV1PropertyDefinition
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContentwarehouseV1PropertyDefinitionSchemaSource: The schema
// source information.
type GoogleCloudContentwarehouseV1PropertyDefinitionSchemaSource struct {
	// Name: The schema name in the source.
	Name string `json:"name,omitempty"`
	// ProcessorType: The Doc AI processor type name.
	ProcessorType string `json:"processorType,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Name") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Name") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContentwarehouseV1PropertyDefinitionSchemaSource) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContentwarehouseV1PropertyDefinitionSchemaSource
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudContentwarehouseV1PropertyFilter struct {
	// Condition: The filter condition. The syntax for this expression is a subset
	// of SQL syntax. Supported operators are: `=`, `!=`, `<`, `<=`, `>`, `>=`, and
	// `~~` where the left of the operator is a property name and the right of the
	// operator is a number or a quoted string. You must escape backslash (\\) and
	// quote (\") characters. `~~` is the LIKE operator. The right of the operator
	// must be a string. The only supported property data type for LIKE is
	// text_values. It provides semantic search functionality by parsing, stemming
	// and doing synonyms expansion against the input query. It matches if the
	// property contains semantic similar content to the query. It is not regex
	// matching or wildcard matching. For example, "property.company ~~ \"google\""
	// will match records whose property `property.compnay` have values like
	// "Google Inc.", "Google LLC" or "Google Company". Supported functions are
	// `LOWER([property_name])` to perform a case insensitive match and
	// `EMPTY([property_name])` to filter on the existence of a key. Boolean
	// expressions (AND/OR/NOT) are supported up to 3 levels of nesting (for
	// example, "((A AND B AND C) OR NOT D) AND E"), a maximum of 100 comparisons
	// or functions are allowed in the expression. The expression must be < 6000
	// bytes in length. Only properties that are marked filterable are allowed
	// (PropertyDefinition.is_filterable). Property names do not need to be
	// prefixed by the document schema id (as is the case with histograms), however
	// property names will need to be prefixed by its parent hierarchy, if any. For
	// example: top_property_name.sub_property_name. Sample Query:
	// `(LOWER(driving_license)="class \"a\"" OR EMPTY(driving_license)) AND
	// driving_years > 10` CMEK compliant deployment only supports: * Operators:
	// `=`, `<`, `<=`, `>`, and `>=`. * Boolean expressions: AND and OR.
	Condition string `json:"condition,omitempty"`
	// DocumentSchemaName: The Document schema name Document.document_schema_name.
	// Format:
	// projects/{project_number}/locations/{location}/documentSchemas/{document_sche
	// ma_id}.
	DocumentSchemaName string `json:"documentSchemaName,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Condition") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Condition") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContentwarehouseV1PropertyFilter) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContentwarehouseV1PropertyFilter
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContentwarehouseV1PropertyTypeOptions: Configurations for a
// nested structured data property.
type GoogleCloudContentwarehouseV1PropertyTypeOptions struct {
	// PropertyDefinitions: Required. List of property definitions.
	PropertyDefinitions []*GoogleCloudContentwarehouseV1PropertyDefinition `json:"propertyDefinitions,omitempty"`
	// ForceSendFields is a list of field names (e.g. "PropertyDefinitions") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "PropertyDefinitions") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContentwarehouseV1PropertyTypeOptions) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContentwarehouseV1PropertyTypeOptions
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContentwarehouseV1PublishAction: Represents the action
// responsible for publishing messages to a Pub/Sub topic.
type GoogleCloudContentwarehouseV1PublishAction struct {
	// Messages: Messages to be published.
	Messages []string `json:"messages,omitempty"`
	// TopicId: The topic id in the Pub/Sub service for which messages will be
	// published to.
	TopicId string `json:"topicId,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Messages") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Messages") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContentwarehouseV1PublishAction) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContentwarehouseV1PublishAction
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContentwarehouseV1QAResult: Additional result info for the
// question-answering feature.
type GoogleCloudContentwarehouseV1QAResult struct {
	// ConfidenceScore: The calibrated confidence score for this document, in the
	// range [0., 1.]. This represents the confidence level for whether the
	// returned document and snippet answers the user's query.
	ConfidenceScore float64 `json:"confidenceScore,omitempty"`
	// Highlights: Highlighted sections in the snippet.
	Highlights []*GoogleCloudContentwarehouseV1QAResultHighlight `json:"highlights,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ConfidenceScore") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ConfidenceScore") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContentwarehouseV1QAResult) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContentwarehouseV1QAResult
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudContentwarehouseV1QAResult) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudContentwarehouseV1QAResult
	var s1 struct {
		ConfidenceScore gensupport.JSONFloat64 `json:"confidenceScore"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.ConfidenceScore = float64(s1.ConfidenceScore)
	return nil
}

// GoogleCloudContentwarehouseV1QAResultHighlight: A text span in the search
// text snippet that represents a highlighted section (answer context, highly
// relevant sentence, etc.).
type GoogleCloudContentwarehouseV1QAResultHighlight struct {
	// EndIndex: End index of the highlight, exclusive.
	EndIndex int64 `json:"endIndex,omitempty"`
	// StartIndex: Start index of the highlight.
	StartIndex int64 `json:"startIndex,omitempty"`
	// ForceSendFields is a list of field names (e.g. "EndIndex") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EndIndex") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContentwarehouseV1QAResultHighlight) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContentwarehouseV1QAResultHighlight
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContentwarehouseV1RemoveFromFolderAction: Represents the action
// responsible for remove a document from a specific folder.
type GoogleCloudContentwarehouseV1RemoveFromFolderAction struct {
	// Condition: Condition of the action to be executed.
	Condition string `json:"condition,omitempty"`
	// Folder: Name of the folder under which new document is to be added. Format:
	// projects/{project_number}/locations/{location}/documents/{document_id}.
	Folder string `json:"folder,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Condition") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Condition") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContentwarehouseV1RemoveFromFolderAction) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContentwarehouseV1RemoveFromFolderAction
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContentwarehouseV1RequestMetadata: Meta information is used to
// improve the performance of the service.
type GoogleCloudContentwarehouseV1RequestMetadata struct {
	// UserInfo: Provides user unique identification and groups information.
	UserInfo *GoogleCloudContentwarehouseV1UserInfo `json:"userInfo,omitempty"`
	// ForceSendFields is a list of field names (e.g. "UserInfo") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "UserInfo") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContentwarehouseV1RequestMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContentwarehouseV1RequestMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContentwarehouseV1ResponseMetadata: Additional information
// returned to client, such as debugging information.
type GoogleCloudContentwarehouseV1ResponseMetadata struct {
	// RequestId: A unique id associated with this call. This id is logged for
	// tracking purpose.
	RequestId string `json:"requestId,omitempty"`
	// ForceSendFields is a list of field names (e.g. "RequestId") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "RequestId") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContentwarehouseV1ResponseMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContentwarehouseV1ResponseMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContentwarehouseV1Rule: Represents the rule for a content
// warehouse trigger.
type GoogleCloudContentwarehouseV1Rule struct {
	// Actions: List of actions that are executed when the rule is satisfied.
	Actions []*GoogleCloudContentwarehouseV1Action `json:"actions,omitempty"`
	// Condition: Represents the conditional expression to be evaluated. Expression
	// should evaluate to a boolean result. When the condition is true actions are
	// executed. Example: user_role = "hsbc_role_1" AND doc.salary > 20000
	Condition string `json:"condition,omitempty"`
	// Description: Short description of the rule and its context.
	Description string `json:"description,omitempty"`
	// RuleId: ID of the rule. It has to be unique across all the examples. This is
	// managed internally.
	RuleId string `json:"ruleId,omitempty"`
	// TriggerType: Identifies the trigger type for running the policy.
	//
	// Possible values:
	//   "UNKNOWN" - Trigger for unknown action.
	//   "ON_CREATE" - Trigger for create document action.
	//   "ON_UPDATE" - Trigger for update document action.
	//   "ON_CREATE_LINK" - Trigger for create link action.
	//   "ON_DELETE_LINK" - Trigger for delete link action.
	TriggerType string `json:"triggerType,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Actions") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Actions") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContentwarehouseV1Rule) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContentwarehouseV1Rule
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContentwarehouseV1RuleActionsPair: Represents a rule and outputs
// of associated actions.
type GoogleCloudContentwarehouseV1RuleActionsPair struct {
	// ActionOutputs: Outputs of executing the actions associated with the above
	// rule.
	ActionOutputs []*GoogleCloudContentwarehouseV1ActionOutput `json:"actionOutputs,omitempty"`
	// Rule: Represents the rule.
	Rule *GoogleCloudContentwarehouseV1Rule `json:"rule,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ActionOutputs") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ActionOutputs") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContentwarehouseV1RuleActionsPair) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContentwarehouseV1RuleActionsPair
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContentwarehouseV1RuleEngineOutput: Records the output of Rule
// Engine including rule evaluation and actions result.
type GoogleCloudContentwarehouseV1RuleEngineOutput struct {
	// ActionExecutorOutput: Output from Action Executor containing rule and
	// corresponding actions execution result.
	ActionExecutorOutput *GoogleCloudContentwarehouseV1ActionExecutorOutput `json:"actionExecutorOutput,omitempty"`
	// DocumentName: Name of the document against which the rules and actions were
	// evaluated.
	DocumentName string `json:"documentName,omitempty"`
	// RuleEvaluatorOutput: Output from Rule Evaluator containing matched,
	// unmatched and invalid rules.
	RuleEvaluatorOutput *GoogleCloudContentwarehouseV1RuleEvaluatorOutput `json:"ruleEvaluatorOutput,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ActionExecutorOutput") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ActionExecutorOutput") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContentwarehouseV1RuleEngineOutput) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContentwarehouseV1RuleEngineOutput
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContentwarehouseV1RuleEvaluatorOutput: Represents the output of
// the Rule Evaluator.
type GoogleCloudContentwarehouseV1RuleEvaluatorOutput struct {
	// InvalidRules: A subset of triggered rules that failed the validation
	// check(s) after parsing.
	InvalidRules []*GoogleCloudContentwarehouseV1InvalidRule `json:"invalidRules,omitempty"`
	// MatchedRules: A subset of triggered rules that are evaluated true for a
	// given request.
	MatchedRules []*GoogleCloudContentwarehouseV1Rule `json:"matchedRules,omitempty"`
	// TriggeredRules: List of rules fetched from database for the given request
	// trigger type.
	TriggeredRules []*GoogleCloudContentwarehouseV1Rule `json:"triggeredRules,omitempty"`
	// ForceSendFields is a list of field names (e.g. "InvalidRules") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "InvalidRules") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContentwarehouseV1RuleEvaluatorOutput) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContentwarehouseV1RuleEvaluatorOutput
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContentwarehouseV1RuleSet: Represents a set of rules from a
// single customer.
type GoogleCloudContentwarehouseV1RuleSet struct {
	// Description: Short description of the rule-set.
	Description string `json:"description,omitempty"`
	// Name: The resource name of the rule set. Managed internally. Format:
	// projects/{project_number}/locations/{location}/ruleSet/{rule_set_id}. The
	// name is ignored when creating a rule set.
	Name string `json:"name,omitempty"`
	// Rules: List of rules given by the customer.
	Rules []*GoogleCloudContentwarehouseV1Rule `json:"rules,omitempty"`
	// Source: Source of the rules i.e., customer name.
	Source string `json:"source,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Description") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Description") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContentwarehouseV1RuleSet) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContentwarehouseV1RuleSet
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContentwarehouseV1RunPipelineMetadata: Metadata message of
// RunPipeline method.
type GoogleCloudContentwarehouseV1RunPipelineMetadata struct {
	// ExportToCdwPipelineMetadata: The pipeline metadata for Export-to-CDW
	// pipeline.
	ExportToCdwPipelineMetadata *GoogleCloudContentwarehouseV1RunPipelineMetadataExportToCdwPipelineMetadata `json:"exportToCdwPipelineMetadata,omitempty"`
	// FailedFileCount: Number of files that have failed at some point in the
	// pipeline.
	FailedFileCount int64 `json:"failedFileCount,omitempty"`
	// GcsIngestPipelineMetadata: The pipeline metadata for GcsIngest pipeline.
	GcsIngestPipelineMetadata *GoogleCloudContentwarehouseV1RunPipelineMetadataGcsIngestPipelineMetadata `json:"gcsIngestPipelineMetadata,omitempty"`
	// IndividualDocumentStatuses: The list of response details of each document.
	IndividualDocumentStatuses []*GoogleCloudContentwarehouseV1RunPipelineMetadataIndividualDocumentStatus `json:"individualDocumentStatuses,omitempty"`
	// ProcessWithDocAiPipelineMetadata: The pipeline metadata for
	// Process-with-DocAi pipeline.
	ProcessWithDocAiPipelineMetadata *GoogleCloudContentwarehouseV1RunPipelineMetadataProcessWithDocAiPipelineMetadata `json:"processWithDocAiPipelineMetadata,omitempty"`
	// TotalFileCount: Number of files that were processed by the pipeline.
	TotalFileCount int64 `json:"totalFileCount,omitempty"`
	// UserInfo: User unique identification and groups information.
	UserInfo *GoogleCloudContentwarehouseV1UserInfo `json:"userInfo,omitempty"`
	// ForceSendFields is a list of field names (e.g.
	// "ExportToCdwPipelineMetadata") to unconditionally include in API requests.
	// By default, fields with empty or default values are omitted from API
	// requests. See https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields
	// for more details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ExportToCdwPipelineMetadata") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContentwarehouseV1RunPipelineMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContentwarehouseV1RunPipelineMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContentwarehouseV1RunPipelineMetadataExportToCdwPipelineMetadata:
// The metadata message for Export-to-CDW pipeline.
type GoogleCloudContentwarehouseV1RunPipelineMetadataExportToCdwPipelineMetadata struct {
	// DocAiDataset: The output CDW dataset resource name.
	DocAiDataset string `json:"docAiDataset,omitempty"`
	// Documents: The input list of all the resource names of the documents to be
	// exported.
	Documents []string `json:"documents,omitempty"`
	// OutputPath: The output Cloud Storage folder in this pipeline.
	OutputPath string `json:"outputPath,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DocAiDataset") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DocAiDataset") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContentwarehouseV1RunPipelineMetadataExportToCdwPipelineMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContentwarehouseV1RunPipelineMetadataExportToCdwPipelineMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContentwarehouseV1RunPipelineMetadataGcsIngestPipelineMetadata:
// The metadata message for GcsIngest pipeline.
type GoogleCloudContentwarehouseV1RunPipelineMetadataGcsIngestPipelineMetadata struct {
	// InputPath: The input Cloud Storage folder in this pipeline. Format:
	// `gs:///`.
	InputPath string `json:"inputPath,omitempty"`
	// ForceSendFields is a list of field names (e.g. "InputPath") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "InputPath") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContentwarehouseV1RunPipelineMetadataGcsIngestPipelineMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContentwarehouseV1RunPipelineMetadataGcsIngestPipelineMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContentwarehouseV1RunPipelineMetadataIndividualDocumentStatus:
// The status of processing a document.
type GoogleCloudContentwarehouseV1RunPipelineMetadataIndividualDocumentStatus struct {
	// DocumentId: Document identifier of an existing document.
	DocumentId string `json:"documentId,omitempty"`
	// Status: The status processing the document.
	Status *GoogleRpcStatus `json:"status,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DocumentId") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DocumentId") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContentwarehouseV1RunPipelineMetadataIndividualDocumentStatus) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContentwarehouseV1RunPipelineMetadataIndividualDocumentStatus
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContentwarehouseV1RunPipelineMetadataProcessWithDocAiPipelineMetad
// ata: The metadata message for Process-with-DocAi pipeline.
type GoogleCloudContentwarehouseV1RunPipelineMetadataProcessWithDocAiPipelineMetadata struct {
	// Documents: The input list of all the resource names of the documents to be
	// processed.
	Documents []string `json:"documents,omitempty"`
	// ProcessorInfo: The DocAI processor to process the documents with.
	ProcessorInfo *GoogleCloudContentwarehouseV1ProcessorInfo `json:"processorInfo,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Documents") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Documents") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContentwarehouseV1RunPipelineMetadataProcessWithDocAiPipelineMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContentwarehouseV1RunPipelineMetadataProcessWithDocAiPipelineMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContentwarehouseV1RunPipelineRequest: Request message for
// DocumentService.RunPipeline.
type GoogleCloudContentwarehouseV1RunPipelineRequest struct {
	// ExportCdwPipeline: Export docuemnts from Document Warehouse to CDW for
	// training purpose.
	ExportCdwPipeline *GoogleCloudContentwarehouseV1ExportToCdwPipeline `json:"exportCdwPipeline,omitempty"`
	// GcsIngestPipeline: Cloud Storage ingestion pipeline.
	GcsIngestPipeline *GoogleCloudContentwarehouseV1GcsIngestPipeline `json:"gcsIngestPipeline,omitempty"`
	// GcsIngestWithDocAiProcessorsPipeline: Use DocAI processors to process
	// documents in Cloud Storage and ingest them to Document Warehouse.
	GcsIngestWithDocAiProcessorsPipeline *GoogleCloudContentwarehouseV1GcsIngestWithDocAiProcessorsPipeline `json:"gcsIngestWithDocAiProcessorsPipeline,omitempty"`
	// ProcessWithDocAiPipeline: Use a DocAI processor to process documents in
	// Document Warehouse, and re-ingest the updated results into Document
	// Warehouse.
	ProcessWithDocAiPipeline *GoogleCloudContentwarehouseV1ProcessWithDocAiPipeline `json:"processWithDocAiPipeline,omitempty"`
	// RequestMetadata: The meta information collected about the end user, used to
	// enforce access control for the service.
	RequestMetadata *GoogleCloudContentwarehouseV1RequestMetadata `json:"requestMetadata,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ExportCdwPipeline") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ExportCdwPipeline") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContentwarehouseV1RunPipelineRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContentwarehouseV1RunPipelineRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContentwarehouseV1SearchDocumentsRequest: Request message for
// DocumentService.SearchDocuments.
type GoogleCloudContentwarehouseV1SearchDocumentsRequest struct {
	// DocumentQuery: Query used to search against documents (keyword, filters,
	// etc.).
	DocumentQuery *GoogleCloudContentwarehouseV1DocumentQuery `json:"documentQuery,omitempty"`
	// HistogramQueries: An expression specifying a histogram request against
	// matching documents. Expression syntax is an aggregation function call with
	// histogram facets and other options. The following aggregation functions are
	// supported: * `count(string_histogram_facet)`: Count the number of matching
	// entities for each distinct attribute value. Data types: * Histogram facet
	// (aka filterable properties): Facet names with format <schema id>.<facet>.
	// Facets will have the format of: `a-zA-Z`. If the facet is a child facet,
	// then the parent hierarchy needs to be specified separated by dots in the
	// prefix after the schema id. Thus, the format for a multi- level facet is:
	// <schema id>.<parent facet name>. <child facet name>. Example:
	// schema123.root_parent_facet.middle_facet.child_facet * DocumentSchemaId:
	// (with no schema id prefix) to get histograms for each document type (returns
	// the schema id path, e.g.
	// projects/12345/locations/us-west/documentSchemas/abc123). Example
	// expression: * Document type counts: count('DocumentSchemaId') * For schema
	// id, abc123, get the counts for MORTGAGE_TYPE: count('abc123.MORTGAGE_TYPE')
	HistogramQueries []*GoogleCloudContentwarehouseV1HistogramQuery `json:"histogramQueries,omitempty"`
	// Offset: An integer that specifies the current offset (that is, starting
	// result location, amongst the documents deemed by the API as relevant) in
	// search results. This field is only considered if page_token is unset. The
	// maximum allowed value is 5000. Otherwise an error is thrown. For example, 0
	// means to return results starting from the first matching document, and 10
	// means to return from the 11th document. This can be used for pagination,
	// (for example, pageSize = 10 and offset = 10 means to return from the second
	// page).
	Offset int64 `json:"offset,omitempty"`
	// OrderBy: The criteria determining how search results are sorted. For
	// non-empty query, default is "relevance desc". For empty query, default is
	// "upload_date desc". Supported options are: * "relevance desc": By
	// relevance descending, as determined by the API algorithms. * "upload_date
	// desc": By upload date descending. * "upload_date": By upload date
	// ascending. * "update_date desc": By last updated date descending. *
	// "update_date": By last updated date ascending. * "retrieval_importance
	// desc": By retrieval importance of properties descending. This feature is
	// still under development, please do not use unless otherwise instructed to do
	// so.
	OrderBy string `json:"orderBy,omitempty"`
	// PageSize: A limit on the number of documents returned in the search results.
	// Increasing this value above the default value of 10 can increase search
	// response time. The value can be between 1 and 100.
	PageSize int64 `json:"pageSize,omitempty"`
	// PageToken: The token specifying the current offset within search results.
	// See SearchDocumentsResponse.next_page_token for an explanation of how to
	// obtain the next set of query results.
	PageToken string `json:"pageToken,omitempty"`
	// QaSizeLimit: Experimental, do not use. The limit on the number of documents
	// returned for the question-answering feature. To enable the
	// question-answering feature, set [DocumentQuery].is_nl_query to true.
	QaSizeLimit int64 `json:"qaSizeLimit,omitempty"`
	// RequestMetadata: The meta information collected about the end user, used to
	// enforce access control and improve the search quality of the service.
	RequestMetadata *GoogleCloudContentwarehouseV1RequestMetadata `json:"requestMetadata,omitempty"`
	// RequireTotalSize: Controls if the search document request requires the
	// return of a total size of matched documents. See
	// SearchDocumentsResponse.total_size. Enabling this flag may adversely impact
	// performance. Hint: If this is used with pagination, set this flag on the
	// initial query but set this to false on subsequent page calls (keep the total
	// count locally). Defaults to false.
	RequireTotalSize bool `json:"requireTotalSize,omitempty"`
	// TotalResultSize: Controls if the search document request requires the return
	// of a total size of matched documents. See
	// SearchDocumentsResponse.total_size.
	//
	// Possible values:
	//   "TOTAL_RESULT_SIZE_UNSPECIFIED" - Total number calculation will be
	// skipped.
	//   "ESTIMATED_SIZE" - Estimate total number. The total result size will be
	// accurated up to 10,000. This option will add cost and latency to your
	// request.
	//   "ACTUAL_SIZE" - It may adversely impact performance. The limit is
	// 1000,000.
	TotalResultSize string `json:"totalResultSize,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DocumentQuery") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DocumentQuery") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContentwarehouseV1SearchDocumentsRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContentwarehouseV1SearchDocumentsRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContentwarehouseV1SearchDocumentsResponse: Response message for
// DocumentService.SearchDocuments.
type GoogleCloudContentwarehouseV1SearchDocumentsResponse struct {
	// HistogramQueryResults: The histogram results that match with the specified
	// SearchDocumentsRequest.histogram_queries.
	HistogramQueryResults []*GoogleCloudContentwarehouseV1HistogramQueryResult `json:"histogramQueryResults,omitempty"`
	// MatchingDocuments: The document entities that match the specified
	// SearchDocumentsRequest.
	MatchingDocuments []*GoogleCloudContentwarehouseV1SearchDocumentsResponseMatchingDocument `json:"matchingDocuments,omitempty"`
	// Metadata: Additional information for the API invocation, such as the request
	// tracking id.
	Metadata *GoogleCloudContentwarehouseV1ResponseMetadata `json:"metadata,omitempty"`
	// NextPageToken: The token that specifies the starting position of the next
	// page of results. This field is empty if there are no more results.
	NextPageToken string `json:"nextPageToken,omitempty"`
	// QuestionAnswer: Experimental. Question answer from the query against the
	// document.
	QuestionAnswer string `json:"questionAnswer,omitempty"`
	// TotalSize: The total number of matched documents which is available only if
	// the client set SearchDocumentsRequest.require_total_size to `true` or set
	// SearchDocumentsRequest.total_result_size to `ESTIMATED_SIZE` or
	// `ACTUAL_SIZE`. Otherwise, the value will be `-1`. Typically a UI would
	// handle this condition by displaying "of many", for example: "Displaying 10
	// of many".
	TotalSize int64 `json:"totalSize,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "HistogramQueryResults") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "HistogramQueryResults") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContentwarehouseV1SearchDocumentsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContentwarehouseV1SearchDocumentsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContentwarehouseV1SearchDocumentsResponseMatchingDocument:
// Document entry with metadata inside SearchDocumentsResponse
type GoogleCloudContentwarehouseV1SearchDocumentsResponseMatchingDocument struct {
	// Document: Document that matches the specified SearchDocumentsRequest. This
	// document only contains indexed metadata information.
	Document *GoogleCloudContentwarehouseV1Document `json:"document,omitempty"`
	// MatchedTokenPageIndices: Return the 1-based page indices where those pages
	// have one or more matched tokens.
	MatchedTokenPageIndices googleapi.Int64s `json:"matchedTokenPageIndices,omitempty"`
	// QaResult: Experimental. Additional result info if the question-answering
	// feature is enabled.
	QaResult *GoogleCloudContentwarehouseV1QAResult `json:"qaResult,omitempty"`
	// SearchTextSnippet: Contains snippets of text from the document full raw text
	// that most closely match a search query's keywords, if available. All HTML
	// tags in the original fields are stripped when returned in this field, and
	// matching query keywords are enclosed in HTML bold tags. If the
	// question-answering feature is enabled, this field will instead contain a
	// snippet that answers the user's natural-language query. No HTML bold tags
	// will be present, and highlights in the answer snippet can be found in
	// QAResult.highlights.
	SearchTextSnippet string `json:"searchTextSnippet,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Document") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Document") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContentwarehouseV1SearchDocumentsResponseMatchingDocument) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContentwarehouseV1SearchDocumentsResponseMatchingDocument
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContentwarehouseV1SetAclRequest: Request message for
// DocumentService.SetAcl.
type GoogleCloudContentwarehouseV1SetAclRequest struct {
	// Policy: Required. REQUIRED: The complete policy to be applied to the
	// `resource`. The size of the policy is limited to a few 10s of KB. This
	// refers to an Identity and Access (IAM) policy, which specifies access
	// controls for the Document. You can set ACL with condition for projects only.
	// Supported operators are: `=`, `!=`, `<`, `<=`, `>`, and `>=` where the left
	// of the operator is `DocumentSchemaId` or property name and the right of the
	// operator is a number or a quoted string. You must escape backslash (\\) and
	// quote (\") characters. Boolean expressions (AND/OR) are supported up to 3
	// levels of nesting (for example, "((A AND B AND C) OR D) AND E"), a maximum
	// of 10 comparisons are allowed in the expression. The expression must be <
	// 6000 bytes in length. Sample condition: "DocumentSchemaId = \"some schema
	// id\" OR SchemaId.floatPropertyName >= 10"
	Policy *GoogleIamV1Policy `json:"policy,omitempty"`
	// ProjectOwner: For Set Project ACL only. Authorization check for end user
	// will be ignored when project_owner=true.
	ProjectOwner bool `json:"projectOwner,omitempty"`
	// RequestMetadata: The meta information collected about the end user, used to
	// enforce access control for the service.
	RequestMetadata *GoogleCloudContentwarehouseV1RequestMetadata `json:"requestMetadata,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Policy") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Policy") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContentwarehouseV1SetAclRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContentwarehouseV1SetAclRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContentwarehouseV1SetAclResponse: Response message for
// DocumentService.SetAcl.
type GoogleCloudContentwarehouseV1SetAclResponse struct {
	// Metadata: Additional information for the API invocation, such as the request
	// tracking id.
	Metadata *GoogleCloudContentwarehouseV1ResponseMetadata `json:"metadata,omitempty"`
	// Policy: The policy will be attached to a resource (e.g. projecct, document).
	Policy *GoogleIamV1Policy `json:"policy,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Metadata") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Metadata") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContentwarehouseV1SetAclResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContentwarehouseV1SetAclResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContentwarehouseV1SynonymSet: Represents a list of synonyms for a
// given context. For example a context "sales" could contain: Synonym 1: sale,
// invoice, bill, order Synonym 2: money, credit, finance, payment Synonym 3:
// shipping, freight, transport Each SynonymSets should be disjoint
type GoogleCloudContentwarehouseV1SynonymSet struct {
	// Context: This is a freeform field. Example contexts can be "sales,"
	// "engineering," "real estate," "accounting," etc. The context can be supplied
	// during search requests.
	Context string `json:"context,omitempty"`
	// Name: The resource name of the SynonymSet This is mandatory for
	// google.api.resource. Format:
	// projects/{project_number}/locations/{location}/synonymSets/{context}.
	Name string `json:"name,omitempty"`
	// Synonyms: List of Synonyms for the context.
	Synonyms []*GoogleCloudContentwarehouseV1SynonymSetSynonym `json:"synonyms,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Context") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Context") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContentwarehouseV1SynonymSet) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContentwarehouseV1SynonymSet
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContentwarehouseV1SynonymSetSynonym: Represents a list of words
// given by the customer All these words are synonyms of each other.
type GoogleCloudContentwarehouseV1SynonymSetSynonym struct {
	// Words: For example: sale, invoice, bill, order
	Words []string `json:"words,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Words") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Words") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContentwarehouseV1SynonymSetSynonym) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContentwarehouseV1SynonymSetSynonym
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContentwarehouseV1TextArray: String/text values.
type GoogleCloudContentwarehouseV1TextArray struct {
	// Values: List of text values.
	Values []string `json:"values,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Values") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Values") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContentwarehouseV1TextArray) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContentwarehouseV1TextArray
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContentwarehouseV1TextTypeOptions: Configurations for a text
// property.
type GoogleCloudContentwarehouseV1TextTypeOptions struct {
}

// GoogleCloudContentwarehouseV1TimeFilter: Filter on create timestamp or
// update timestamp of documents.
type GoogleCloudContentwarehouseV1TimeFilter struct {
	// TimeField: Specifies which time field to filter documents on. Defaults to
	// TimeField.UPLOAD_TIME.
	//
	// Possible values:
	//   "TIME_FIELD_UNSPECIFIED" - Default value.
	//   "CREATE_TIME" - Earliest document create time.
	//   "UPDATE_TIME" - Latest document update time.
	//   "DISPOSITION_TIME" - Time when document becomes mutable again.
	TimeField string              `json:"timeField,omitempty"`
	TimeRange *GoogleTypeInterval `json:"timeRange,omitempty"`
	// ForceSendFields is a list of field names (e.g. "TimeField") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "TimeField") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContentwarehouseV1TimeFilter) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContentwarehouseV1TimeFilter
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContentwarehouseV1TimestampArray: Timestamp values.
type GoogleCloudContentwarehouseV1TimestampArray struct {
	// Values: List of timestamp values.
	Values []*GoogleCloudContentwarehouseV1TimestampValue `json:"values,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Values") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Values") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContentwarehouseV1TimestampArray) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContentwarehouseV1TimestampArray
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContentwarehouseV1TimestampTypeOptions: Configurations for a
// timestamp property.
type GoogleCloudContentwarehouseV1TimestampTypeOptions struct {
}

// GoogleCloudContentwarehouseV1TimestampValue: Timestamp value type.
type GoogleCloudContentwarehouseV1TimestampValue struct {
	// TextValue: The string must represent a valid instant in UTC and is parsed
	// using java.time.format.DateTimeFormatter.ISO_INSTANT. e.g.
	// "2013-09-29T18:46:19Z"
	TextValue string `json:"textValue,omitempty"`
	// TimestampValue: Timestamp value
	TimestampValue string `json:"timestampValue,omitempty"`
	// ForceSendFields is a list of field names (e.g. "TextValue") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "TextValue") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContentwarehouseV1TimestampValue) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContentwarehouseV1TimestampValue
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContentwarehouseV1UpdateDocumentMetadata: Metadata object for
// UpdateDocument request (currently empty).
type GoogleCloudContentwarehouseV1UpdateDocumentMetadata struct {
}

// GoogleCloudContentwarehouseV1UpdateDocumentRequest: Request message for
// DocumentService.UpdateDocument.
type GoogleCloudContentwarehouseV1UpdateDocumentRequest struct {
	// CloudAiDocumentOption: Request Option for processing Cloud AI Document in
	// Document Warehouse. This field offers limited support for mapping entities
	// from Cloud AI Document to Warehouse Document. Please consult with product
	// team before using this field and other available options.
	CloudAiDocumentOption *GoogleCloudContentwarehouseV1CloudAIDocumentOption `json:"cloudAiDocumentOption,omitempty"`
	// Document: Required. The document to update.
	Document *GoogleCloudContentwarehouseV1Document `json:"document,omitempty"`
	// RequestMetadata: The meta information collected about the end user, used to
	// enforce access control for the service.
	RequestMetadata *GoogleCloudContentwarehouseV1RequestMetadata `json:"requestMetadata,omitempty"`
	// UpdateOptions: Options for the update operation.
	UpdateOptions *GoogleCloudContentwarehouseV1UpdateOptions `json:"updateOptions,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CloudAiDocumentOption") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CloudAiDocumentOption") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContentwarehouseV1UpdateDocumentRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContentwarehouseV1UpdateDocumentRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContentwarehouseV1UpdateDocumentResponse: Response message for
// DocumentService.UpdateDocument.
type GoogleCloudContentwarehouseV1UpdateDocumentResponse struct {
	// Document: Updated document after executing update request.
	Document *GoogleCloudContentwarehouseV1Document `json:"document,omitempty"`
	// Metadata: Additional information for the API invocation, such as the request
	// tracking id.
	Metadata *GoogleCloudContentwarehouseV1ResponseMetadata `json:"metadata,omitempty"`
	// RuleEngineOutput: Output from Rule Engine recording the rule evaluator and
	// action executor's output. Refer format in:
	// google/cloud/contentwarehouse/v1/rule_engine.proto
	RuleEngineOutput *GoogleCloudContentwarehouseV1RuleEngineOutput `json:"ruleEngineOutput,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Document") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Document") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContentwarehouseV1UpdateDocumentResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContentwarehouseV1UpdateDocumentResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContentwarehouseV1UpdateDocumentSchemaRequest: Request message
// for DocumentSchemaService.UpdateDocumentSchema.
type GoogleCloudContentwarehouseV1UpdateDocumentSchemaRequest struct {
	// DocumentSchema: Required. The document schema to update with.
	DocumentSchema *GoogleCloudContentwarehouseV1DocumentSchema `json:"documentSchema,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DocumentSchema") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DocumentSchema") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContentwarehouseV1UpdateDocumentSchemaRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContentwarehouseV1UpdateDocumentSchemaRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContentwarehouseV1UpdateOptions: Options for Update operations.
type GoogleCloudContentwarehouseV1UpdateOptions struct {
	// MergeFieldsOptions: Options for merging.
	MergeFieldsOptions *GoogleCloudContentwarehouseV1MergeFieldsOptions `json:"mergeFieldsOptions,omitempty"`
	// UpdateMask: Field mask for merging Document fields. For the `FieldMask`
	// definition, see
	// https://developers.google.com/protocol-buffers/docs/reference/google.protobuf#fieldmask
	UpdateMask string `json:"updateMask,omitempty"`
	// UpdateType: Type for update.
	//
	// Possible values:
	//   "UPDATE_TYPE_UNSPECIFIED" - Defaults to full replace behavior, ie.
	// FULL_REPLACE.
	//   "UPDATE_TYPE_REPLACE" - Fully replace all the fields (including previously
	// linked raw document). Any field masks will be ignored.
	//   "UPDATE_TYPE_MERGE" - Merge the fields into the existing entities.
	//   "UPDATE_TYPE_INSERT_PROPERTIES_BY_NAMES" - Inserts the properties by
	// names.
	//   "UPDATE_TYPE_REPLACE_PROPERTIES_BY_NAMES" - Replace the properties by
	// names.
	//   "UPDATE_TYPE_DELETE_PROPERTIES_BY_NAMES" - Delete the properties by names.
	//   "UPDATE_TYPE_MERGE_AND_REPLACE_OR_INSERT_PROPERTIES_BY_NAMES" - For each
	// of the property, replaces the property if the it exists, otherwise inserts a
	// new property. And for the rest of the fields, merge them based on update
	// mask and merge fields options.
	UpdateType string `json:"updateType,omitempty"`
	// ForceSendFields is a list of field names (e.g. "MergeFieldsOptions") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "MergeFieldsOptions") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContentwarehouseV1UpdateOptions) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContentwarehouseV1UpdateOptions
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContentwarehouseV1UpdateRuleSetRequest: Request message for
// RuleSetService.UpdateRuleSet.
type GoogleCloudContentwarehouseV1UpdateRuleSetRequest struct {
	// RuleSet: Required. The rule set to update.
	RuleSet *GoogleCloudContentwarehouseV1RuleSet `json:"ruleSet,omitempty"`
	// ForceSendFields is a list of field names (e.g. "RuleSet") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "RuleSet") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContentwarehouseV1UpdateRuleSetRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContentwarehouseV1UpdateRuleSetRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContentwarehouseV1UserInfo: The user information.
type GoogleCloudContentwarehouseV1UserInfo struct {
	// GroupIds: The unique group identifications which the user is belong to. The
	// format is "group:yyyy@example.com";
	GroupIds []string `json:"groupIds,omitempty"`
	// Id: A unique user identification string, as determined by the client. The
	// maximum number of allowed characters is 255. Allowed characters include
	// numbers 0 to 9, uppercase and lowercase letters, and restricted special
	// symbols (:, @, +, -, _, ~) The format is "user:xxxx@example.com";
	Id string `json:"id,omitempty"`
	// ForceSendFields is a list of field names (e.g. "GroupIds") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "GroupIds") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContentwarehouseV1UserInfo) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContentwarehouseV1UserInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContentwarehouseV1Value: `Value` represents a dynamically typed
// value which can be either be a float, a integer, a string, or a datetime
// value. A producer of value is expected to set one of these variants. Absence
// of any variant indicates an error.
type GoogleCloudContentwarehouseV1Value struct {
	// BooleanValue: Represents a boolean value.
	BooleanValue bool `json:"booleanValue,omitempty"`
	// DatetimeValue: Represents a datetime value.
	DatetimeValue *GoogleTypeDateTime `json:"datetimeValue,omitempty"`
	// EnumValue: Represents an enum value.
	EnumValue *GoogleCloudContentwarehouseV1EnumValue `json:"enumValue,omitempty"`
	// FloatValue: Represents a float value.
	FloatValue float64 `json:"floatValue,omitempty"`
	// IntValue: Represents a integer value.
	IntValue int64 `json:"intValue,omitempty"`
	// StringValue: Represents a string value.
	StringValue string `json:"stringValue,omitempty"`
	// TimestampValue: Represents a timestamp value.
	TimestampValue *GoogleCloudContentwarehouseV1TimestampValue `json:"timestampValue,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BooleanValue") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BooleanValue") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContentwarehouseV1Value) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContentwarehouseV1Value
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudContentwarehouseV1Value) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudContentwarehouseV1Value
	var s1 struct {
		FloatValue gensupport.JSONFloat64 `json:"floatValue"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.FloatValue = float64(s1.FloatValue)
	return nil
}

// GoogleCloudContentwarehouseV1WeightedSchemaProperty: Specifies the schema
// property name.
type GoogleCloudContentwarehouseV1WeightedSchemaProperty struct {
	// DocumentSchemaName: The document schema name.
	DocumentSchemaName string `json:"documentSchemaName,omitempty"`
	// PropertyNames: The property definition names in the schema.
	PropertyNames []string `json:"propertyNames,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DocumentSchemaName") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DocumentSchemaName") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContentwarehouseV1WeightedSchemaProperty) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContentwarehouseV1WeightedSchemaProperty
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContentwarehouseV1beta1CreateDocumentMetadata: Metadata object
// for CreateDocument request (currently empty).
type GoogleCloudContentwarehouseV1beta1CreateDocumentMetadata struct {
}

// GoogleCloudContentwarehouseV1beta1InitializeProjectResponse: Response
// message for projectService.InitializeProject
type GoogleCloudContentwarehouseV1beta1InitializeProjectResponse struct {
	// Message: The message of the project initialization process.
	Message string `json:"message,omitempty"`
	// State: The state of the project initialization process.
	//
	// Possible values:
	//   "STATE_UNSPECIFIED" - Clients should never see this.
	//   "SUCCEEDED" - Finished project initialization without error.
	//   "FAILED" - Finished project initialization with an error.
	//   "CANCELLED" - Client canceled the LRO.
	//   "RUNNING" - Ask the customer to check the operation for results.
	State string `json:"state,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Message") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Message") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContentwarehouseV1beta1InitializeProjectResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContentwarehouseV1beta1InitializeProjectResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContentwarehouseV1beta1UpdateDocumentMetadata: Metadata object
// for UpdateDocument request (currently empty).
type GoogleCloudContentwarehouseV1beta1UpdateDocumentMetadata struct {
}

// GoogleCloudDocumentaiV1Barcode: Encodes the detailed information of a
// barcode.
type GoogleCloudDocumentaiV1Barcode struct {
	// Format: Format of a barcode. The supported formats are: - `CODE_128`: Code
	// 128 type. - `CODE_39`: Code 39 type. - `CODE_93`: Code 93 type. - `CODABAR`:
	// Codabar type. - `DATA_MATRIX`: 2D Data Matrix type. - `ITF`: ITF type. -
	// `EAN_13`: EAN-13 type. - `EAN_8`: EAN-8 type. - `QR_CODE`: 2D QR code type.
	// - `UPC_A`: UPC-A type. - `UPC_E`: UPC-E type. - `PDF417`: PDF417 type. -
	// `AZTEC`: 2D Aztec code type. - `DATABAR`: GS1 DataBar code type.
	Format string `json:"format,omitempty"`
	// RawValue: Raw value encoded in the barcode. For example:
	// `'MEBKM:TITLE:Google;URL:https://www.google.com;;'`.
	RawValue string `json:"rawValue,omitempty"`
	// ValueFormat: Value format describes the format of the value that a barcode
	// encodes. The supported formats are: - `CONTACT_INFO`: Contact information. -
	// `EMAIL`: Email address. - `ISBN`: ISBN identifier. - `PHONE`: Phone number.
	// - `PRODUCT`: Product. - `SMS`: SMS message. - `TEXT`: Text string. - `URL`:
	// URL address. - `WIFI`: Wifi information. - `GEO`: Geo-localization. -
	// `CALENDAR_EVENT`: Calendar event. - `DRIVER_LICENSE`: Driver's license.
	ValueFormat string `json:"valueFormat,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Format") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Format") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiV1Barcode) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1Barcode
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1BoundingPoly: A bounding polygon for the detected
// image annotation.
type GoogleCloudDocumentaiV1BoundingPoly struct {
	// NormalizedVertices: The bounding polygon normalized vertices.
	NormalizedVertices []*GoogleCloudDocumentaiV1NormalizedVertex `json:"normalizedVertices,omitempty"`
	// Vertices: The bounding polygon vertices.
	Vertices []*GoogleCloudDocumentaiV1Vertex `json:"vertices,omitempty"`
	// ForceSendFields is a list of field names (e.g. "NormalizedVertices") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NormalizedVertices") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiV1BoundingPoly) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1BoundingPoly
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1Document: Document represents the canonical document
// resource in Document AI. It is an interchange format that provides insights
// into documents and allows for collaboration between users and Document AI to
// iterate and optimize for quality.
type GoogleCloudDocumentaiV1Document struct {
	// Content: Optional. Inline document content, represented as a stream of
	// bytes. Note: As with all `bytes` fields, protobuffers use a pure binary
	// representation, whereas JSON representations use base64.
	Content string `json:"content,omitempty"`
	// Entities: A list of entities detected on Document.text. For document shards,
	// entities in this list may cross shard boundaries.
	Entities []*GoogleCloudDocumentaiV1DocumentEntity `json:"entities,omitempty"`
	// EntityRelations: Placeholder. Relationship among Document.entities.
	EntityRelations []*GoogleCloudDocumentaiV1DocumentEntityRelation `json:"entityRelations,omitempty"`
	// Error: Any error that occurred while processing this document.
	Error *GoogleRpcStatus `json:"error,omitempty"`
	// MimeType: An IANA published media type (MIME type)
	// (https://www.iana.org/assignments/media-types/media-types.xhtml).
	MimeType string `json:"mimeType,omitempty"`
	// Pages: Visual page layout for the Document.
	Pages []*GoogleCloudDocumentaiV1DocumentPage `json:"pages,omitempty"`
	// Revisions: Placeholder. Revision history of this document.
	Revisions []*GoogleCloudDocumentaiV1DocumentRevision `json:"revisions,omitempty"`
	// ShardInfo: Information about the sharding if this document is sharded part
	// of a larger document. If the document is not sharded, this message is not
	// specified.
	ShardInfo *GoogleCloudDocumentaiV1DocumentShardInfo `json:"shardInfo,omitempty"`
	// Text: Optional. UTF-8 encoded text in reading order from the document.
	Text string `json:"text,omitempty"`
	// TextChanges: Placeholder. A list of text corrections made to Document.text.
	// This is usually used for annotating corrections to OCR mistakes. Text
	// changes for a given revision may not overlap with each other.
	TextChanges []*GoogleCloudDocumentaiV1DocumentTextChange `json:"textChanges,omitempty"`
	// TextStyles: Styles for the Document.text.
	TextStyles []*GoogleCloudDocumentaiV1DocumentStyle `json:"textStyles,omitempty"`
	// Uri: Optional. Currently supports Google Cloud Storage URI of the form
	// `gs://bucket_name/object_name`. Object versioning is not supported. For more
	// information, refer to Google Cloud Storage Request URIs
	// (https://cloud.google.com/storage/docs/reference-uris).
	Uri string `json:"uri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Content") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Content") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiV1Document) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1Document
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1DocumentEntity: An entity that could be a phrase in
// the text or a property that belongs to the document. It is a known entity
// type, such as a person, an organization, or location.
type GoogleCloudDocumentaiV1DocumentEntity struct {
	// Confidence: Optional. Confidence of detected Schema entity. Range `[0, 1]`.
	Confidence float64 `json:"confidence,omitempty"`
	// Id: Optional. Canonical id. This will be a unique value in the entity list
	// for this document.
	Id string `json:"id,omitempty"`
	// MentionId: Optional. Deprecated. Use `id` field instead.
	MentionId string `json:"mentionId,omitempty"`
	// MentionText: Optional. Text value of the entity e.g. `1600 Amphitheatre
	// Pkwy`.
	MentionText string `json:"mentionText,omitempty"`
	// NormalizedValue: Optional. Normalized entity value. Absent if the extracted
	// value could not be converted or the type (e.g. address) is not supported for
	// certain parsers. This field is also only populated for certain supported
	// document types.
	NormalizedValue *GoogleCloudDocumentaiV1DocumentEntityNormalizedValue `json:"normalizedValue,omitempty"`
	// PageAnchor: Optional. Represents the provenance of this entity wrt. the
	// location on the page where it was found.
	PageAnchor *GoogleCloudDocumentaiV1DocumentPageAnchor `json:"pageAnchor,omitempty"`
	// Properties: Optional. Entities can be nested to form a hierarchical data
	// structure representing the content in the document.
	Properties []*GoogleCloudDocumentaiV1DocumentEntity `json:"properties,omitempty"`
	// Provenance: Optional. The history of this annotation.
	Provenance *GoogleCloudDocumentaiV1DocumentProvenance `json:"provenance,omitempty"`
	// Redacted: Optional. Whether the entity will be redacted for
	// de-identification purposes.
	Redacted bool `json:"redacted,omitempty"`
	// TextAnchor: Optional. Provenance of the entity. Text anchor indexing into
	// the Document.text.
	TextAnchor *GoogleCloudDocumentaiV1DocumentTextAnchor `json:"textAnchor,omitempty"`
	// Type: Required. Entity type from a schema e.g. `Address`.
	Type string `json:"type,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Confidence") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Confidence") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiV1DocumentEntity) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1DocumentEntity
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDocumentaiV1DocumentEntity) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDocumentaiV1DocumentEntity
	var s1 struct {
		Confidence gensupport.JSONFloat64 `json:"confidence"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Confidence = float64(s1.Confidence)
	return nil
}

// GoogleCloudDocumentaiV1DocumentEntityNormalizedValue: Parsed and normalized
// entity value.
type GoogleCloudDocumentaiV1DocumentEntityNormalizedValue struct {
	// AddressValue: Postal address. See also:
	// https://github.com/googleapis/googleapis/blob/master/google/type/postal_address.proto
	AddressValue *GoogleTypePostalAddress `json:"addressValue,omitempty"`
	// BooleanValue: Boolean value. Can be used for entities with binary values, or
	// for checkboxes.
	BooleanValue bool `json:"booleanValue,omitempty"`
	// DateValue: Date value. Includes year, month, day. See also:
	// https://github.com/googleapis/googleapis/blob/master/google/type/date.proto
	DateValue *GoogleTypeDate `json:"dateValue,omitempty"`
	// DatetimeValue: DateTime value. Includes date, time, and timezone. See also:
	// https://github.com/googleapis/googleapis/blob/master/google/type/datetime.proto
	DatetimeValue *GoogleTypeDateTime `json:"datetimeValue,omitempty"`
	// FloatValue: Float value.
	FloatValue float64 `json:"floatValue,omitempty"`
	// IntegerValue: Integer value.
	IntegerValue int64 `json:"integerValue,omitempty"`
	// MoneyValue: Money value. See also:
	// https://github.com/googleapis/googleapis/blob/master/google/type/money.proto
	MoneyValue *GoogleTypeMoney `json:"moneyValue,omitempty"`
	// Text: Optional. An optional field to store a normalized string. For some
	// entity types, one of respective `structured_value` fields may also be
	// populated. Also not all the types of `structured_value` will be normalized.
	// For example, some processors may not generate `float` or `integer`
	// normalized text by default. Below are sample formats mapped to structured
	// values. - Money/Currency type (`money_value`) is in the ISO 4217 text
	// format. - Date type (`date_value`) is in the ISO 8601 text format. -
	// Datetime type (`datetime_value`) is in the ISO 8601 text format.
	Text string `json:"text,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AddressValue") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AddressValue") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiV1DocumentEntityNormalizedValue) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1DocumentEntityNormalizedValue
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDocumentaiV1DocumentEntityNormalizedValue) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDocumentaiV1DocumentEntityNormalizedValue
	var s1 struct {
		FloatValue gensupport.JSONFloat64 `json:"floatValue"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.FloatValue = float64(s1.FloatValue)
	return nil
}

// GoogleCloudDocumentaiV1DocumentEntityRelation: Relationship between
// Entities.
type GoogleCloudDocumentaiV1DocumentEntityRelation struct {
	// ObjectId: Object entity id.
	ObjectId string `json:"objectId,omitempty"`
	// Relation: Relationship description.
	Relation string `json:"relation,omitempty"`
	// SubjectId: Subject entity id.
	SubjectId string `json:"subjectId,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ObjectId") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ObjectId") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiV1DocumentEntityRelation) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1DocumentEntityRelation
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1DocumentPage: A page in a Document.
type GoogleCloudDocumentaiV1DocumentPage struct {
	// Blocks: A list of visually detected text blocks on the page. A block has a
	// set of lines (collected into paragraphs) that have a common line-spacing and
	// orientation.
	Blocks []*GoogleCloudDocumentaiV1DocumentPageBlock `json:"blocks,omitempty"`
	// DetectedBarcodes: A list of detected barcodes.
	DetectedBarcodes []*GoogleCloudDocumentaiV1DocumentPageDetectedBarcode `json:"detectedBarcodes,omitempty"`
	// DetectedLanguages: A list of detected languages together with confidence.
	DetectedLanguages []*GoogleCloudDocumentaiV1DocumentPageDetectedLanguage `json:"detectedLanguages,omitempty"`
	// Dimension: Physical dimension of the page.
	Dimension *GoogleCloudDocumentaiV1DocumentPageDimension `json:"dimension,omitempty"`
	// FormFields: A list of visually detected form fields on the page.
	FormFields []*GoogleCloudDocumentaiV1DocumentPageFormField `json:"formFields,omitempty"`
	// Image: Rendered image for this page. This image is preprocessed to remove
	// any skew, rotation, and distortions such that the annotation bounding boxes
	// can be upright and axis-aligned.
	Image *GoogleCloudDocumentaiV1DocumentPageImage `json:"image,omitempty"`
	// ImageQualityScores: Image quality scores.
	ImageQualityScores *GoogleCloudDocumentaiV1DocumentPageImageQualityScores `json:"imageQualityScores,omitempty"`
	// Layout: Layout for the page.
	Layout *GoogleCloudDocumentaiV1DocumentPageLayout `json:"layout,omitempty"`
	// Lines: A list of visually detected text lines on the page. A collection of
	// tokens that a human would perceive as a line.
	Lines []*GoogleCloudDocumentaiV1DocumentPageLine `json:"lines,omitempty"`
	// PageNumber: 1-based index for current Page in a parent Document. Useful when
	// a page is taken out of a Document for individual processing.
	PageNumber int64 `json:"pageNumber,omitempty"`
	// Paragraphs: A list of visually detected text paragraphs on the page. A
	// collection of lines that a human would perceive as a paragraph.
	Paragraphs []*GoogleCloudDocumentaiV1DocumentPageParagraph `json:"paragraphs,omitempty"`
	// Provenance: The history of this page.
	Provenance *GoogleCloudDocumentaiV1DocumentProvenance `json:"provenance,omitempty"`
	// Symbols: A list of visually detected symbols on the page.
	Symbols []*GoogleCloudDocumentaiV1DocumentPageSymbol `json:"symbols,omitempty"`
	// Tables: A list of visually detected tables on the page.
	Tables []*GoogleCloudDocumentaiV1DocumentPageTable `json:"tables,omitempty"`
	// Tokens: A list of visually detected tokens on the page.
	Tokens []*GoogleCloudDocumentaiV1DocumentPageToken `json:"tokens,omitempty"`
	// Transforms: Transformation matrices that were applied to the original
	// document image to produce Page.image.
	Transforms []*GoogleCloudDocumentaiV1DocumentPageMatrix `json:"transforms,omitempty"`
	// VisualElements: A list of detected non-text visual elements e.g. checkbox,
	// signature etc. on the page.
	VisualElements []*GoogleCloudDocumentaiV1DocumentPageVisualElement `json:"visualElements,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Blocks") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Blocks") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiV1DocumentPage) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1DocumentPage
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1DocumentPageAnchor: Referencing the visual context of
// the entity in the Document.pages. Page anchors can be cross-page, consist of
// multiple bounding polygons and optionally reference specific layout element
// types.
type GoogleCloudDocumentaiV1DocumentPageAnchor struct {
	// PageRefs: One or more references to visual page elements
	PageRefs []*GoogleCloudDocumentaiV1DocumentPageAnchorPageRef `json:"pageRefs,omitempty"`
	// ForceSendFields is a list of field names (e.g. "PageRefs") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "PageRefs") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiV1DocumentPageAnchor) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1DocumentPageAnchor
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1DocumentPageAnchorPageRef: Represents a weak
// reference to a page element within a document.
type GoogleCloudDocumentaiV1DocumentPageAnchorPageRef struct {
	// BoundingPoly: Optional. Identifies the bounding polygon of a layout element
	// on the page. If `layout_type` is set, the bounding polygon must be exactly
	// the same to the layout element it's referring to.
	BoundingPoly *GoogleCloudDocumentaiV1BoundingPoly `json:"boundingPoly,omitempty"`
	// Confidence: Optional. Confidence of detected page element, if applicable.
	// Range `[0, 1]`.
	Confidence float64 `json:"confidence,omitempty"`
	// LayoutId: Optional. Deprecated. Use PageRef.bounding_poly instead.
	LayoutId string `json:"layoutId,omitempty"`
	// LayoutType: Optional. The type of the layout element that is being
	// referenced if any.
	//
	// Possible values:
	//   "LAYOUT_TYPE_UNSPECIFIED" - Layout Unspecified.
	//   "BLOCK" - References a Page.blocks element.
	//   "PARAGRAPH" - References a Page.paragraphs element.
	//   "LINE" - References a Page.lines element.
	//   "TOKEN" - References a Page.tokens element.
	//   "VISUAL_ELEMENT" - References a Page.visual_elements element.
	//   "TABLE" - Refrrences a Page.tables element.
	//   "FORM_FIELD" - References a Page.form_fields element.
	LayoutType string `json:"layoutType,omitempty"`
	// Page: Required. Index into the Document.pages element, for example using
	// `Document.pages` to locate the related page element. This field is skipped
	// when its value is the default `0`. See
	// https://developers.google.com/protocol-buffers/docs/proto3#json.
	Page int64 `json:"page,omitempty,string"`
	// ForceSendFields is a list of field names (e.g. "BoundingPoly") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BoundingPoly") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiV1DocumentPageAnchorPageRef) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1DocumentPageAnchorPageRef
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDocumentaiV1DocumentPageAnchorPageRef) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDocumentaiV1DocumentPageAnchorPageRef
	var s1 struct {
		Confidence gensupport.JSONFloat64 `json:"confidence"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Confidence = float64(s1.Confidence)
	return nil
}

// GoogleCloudDocumentaiV1DocumentPageBlock: A block has a set of lines
// (collected into paragraphs) that have a common line-spacing and orientation.
type GoogleCloudDocumentaiV1DocumentPageBlock struct {
	// DetectedLanguages: A list of detected languages together with confidence.
	DetectedLanguages []*GoogleCloudDocumentaiV1DocumentPageDetectedLanguage `json:"detectedLanguages,omitempty"`
	// Layout: Layout for Block.
	Layout *GoogleCloudDocumentaiV1DocumentPageLayout `json:"layout,omitempty"`
	// Provenance: The history of this annotation.
	Provenance *GoogleCloudDocumentaiV1DocumentProvenance `json:"provenance,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DetectedLanguages") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DetectedLanguages") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiV1DocumentPageBlock) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1DocumentPageBlock
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1DocumentPageDetectedBarcode: A detected barcode.
type GoogleCloudDocumentaiV1DocumentPageDetectedBarcode struct {
	// Barcode: Detailed barcode information of the DetectedBarcode.
	Barcode *GoogleCloudDocumentaiV1Barcode `json:"barcode,omitempty"`
	// Layout: Layout for DetectedBarcode.
	Layout *GoogleCloudDocumentaiV1DocumentPageLayout `json:"layout,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Barcode") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Barcode") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiV1DocumentPageDetectedBarcode) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1DocumentPageDetectedBarcode
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1DocumentPageDetectedLanguage: Detected language for a
// structural component.
type GoogleCloudDocumentaiV1DocumentPageDetectedLanguage struct {
	// Confidence: Confidence of detected language. Range `[0, 1]`.
	Confidence float64 `json:"confidence,omitempty"`
	// LanguageCode: The BCP-47 language code
	// (https://www.unicode.org/reports/tr35/#Unicode_locale_identifier), such as
	// `en-US` or `sr-Latn`.
	LanguageCode string `json:"languageCode,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Confidence") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Confidence") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiV1DocumentPageDetectedLanguage) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1DocumentPageDetectedLanguage
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDocumentaiV1DocumentPageDetectedLanguage) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDocumentaiV1DocumentPageDetectedLanguage
	var s1 struct {
		Confidence gensupport.JSONFloat64 `json:"confidence"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Confidence = float64(s1.Confidence)
	return nil
}

// GoogleCloudDocumentaiV1DocumentPageDimension: Dimension for the page.
type GoogleCloudDocumentaiV1DocumentPageDimension struct {
	// Height: Page height.
	Height float64 `json:"height,omitempty"`
	// Unit: Dimension unit.
	Unit string `json:"unit,omitempty"`
	// Width: Page width.
	Width float64 `json:"width,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Height") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Height") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiV1DocumentPageDimension) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1DocumentPageDimension
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDocumentaiV1DocumentPageDimension) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDocumentaiV1DocumentPageDimension
	var s1 struct {
		Height gensupport.JSONFloat64 `json:"height"`
		Width  gensupport.JSONFloat64 `json:"width"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Height = float64(s1.Height)
	s.Width = float64(s1.Width)
	return nil
}

// GoogleCloudDocumentaiV1DocumentPageFormField: A form field detected on the
// page.
type GoogleCloudDocumentaiV1DocumentPageFormField struct {
	// CorrectedKeyText: Created for Labeling UI to export key text. If corrections
	// were made to the text identified by the `field_name.text_anchor`, this field
	// will contain the correction.
	CorrectedKeyText string `json:"correctedKeyText,omitempty"`
	// CorrectedValueText: Created for Labeling UI to export value text. If
	// corrections were made to the text identified by the
	// `field_value.text_anchor`, this field will contain the correction.
	CorrectedValueText string `json:"correctedValueText,omitempty"`
	// FieldName: Layout for the FormField name. e.g. `Address`, `Email`, `Grand
	// total`, `Phone number`, etc.
	FieldName *GoogleCloudDocumentaiV1DocumentPageLayout `json:"fieldName,omitempty"`
	// FieldValue: Layout for the FormField value.
	FieldValue *GoogleCloudDocumentaiV1DocumentPageLayout `json:"fieldValue,omitempty"`
	// NameDetectedLanguages: A list of detected languages for name together with
	// confidence.
	NameDetectedLanguages []*GoogleCloudDocumentaiV1DocumentPageDetectedLanguage `json:"nameDetectedLanguages,omitempty"`
	// Provenance: The history of this annotation.
	Provenance *GoogleCloudDocumentaiV1DocumentProvenance `json:"provenance,omitempty"`
	// ValueDetectedLanguages: A list of detected languages for value together with
	// confidence.
	ValueDetectedLanguages []*GoogleCloudDocumentaiV1DocumentPageDetectedLanguage `json:"valueDetectedLanguages,omitempty"`
	// ValueType: If the value is non-textual, this field represents the type.
	// Current valid values are: - blank (this indicates the `field_value` is
	// normal text) - `unfilled_checkbox` - `filled_checkbox`
	ValueType string `json:"valueType,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CorrectedKeyText") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CorrectedKeyText") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiV1DocumentPageFormField) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1DocumentPageFormField
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1DocumentPageImage: Rendered image contents for this
// page.
type GoogleCloudDocumentaiV1DocumentPageImage struct {
	// Content: Raw byte content of the image.
	Content string `json:"content,omitempty"`
	// Height: Height of the image in pixels.
	Height int64 `json:"height,omitempty"`
	// MimeType: Encoding media type (MIME type)
	// (https://www.iana.org/assignments/media-types/media-types.xhtml) for the
	// image.
	MimeType string `json:"mimeType,omitempty"`
	// Width: Width of the image in pixels.
	Width int64 `json:"width,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Content") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Content") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiV1DocumentPageImage) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1DocumentPageImage
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1DocumentPageImageQualityScores: Image quality scores
// for the page image.
type GoogleCloudDocumentaiV1DocumentPageImageQualityScores struct {
	// DetectedDefects: A list of detected defects.
	DetectedDefects []*GoogleCloudDocumentaiV1DocumentPageImageQualityScoresDetectedDefect `json:"detectedDefects,omitempty"`
	// QualityScore: The overall quality score. Range `[0, 1]` where `1` is perfect
	// quality.
	QualityScore float64 `json:"qualityScore,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DetectedDefects") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DetectedDefects") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiV1DocumentPageImageQualityScores) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1DocumentPageImageQualityScores
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDocumentaiV1DocumentPageImageQualityScores) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDocumentaiV1DocumentPageImageQualityScores
	var s1 struct {
		QualityScore gensupport.JSONFloat64 `json:"qualityScore"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.QualityScore = float64(s1.QualityScore)
	return nil
}

// GoogleCloudDocumentaiV1DocumentPageImageQualityScoresDetectedDefect: Image
// Quality Defects
type GoogleCloudDocumentaiV1DocumentPageImageQualityScoresDetectedDefect struct {
	// Confidence: Confidence of detected defect. Range `[0, 1]` where `1`
	// indicates strong confidence that the defect exists.
	Confidence float64 `json:"confidence,omitempty"`
	// Type: Name of the defect type. Supported values are: -
	// `quality/defect_blurry` - `quality/defect_noisy` - `quality/defect_dark` -
	// `quality/defect_faint` - `quality/defect_text_too_small` -
	// `quality/defect_document_cutoff` - `quality/defect_text_cutoff` -
	// `quality/defect_glare`
	Type string `json:"type,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Confidence") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Confidence") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiV1DocumentPageImageQualityScoresDetectedDefect) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1DocumentPageImageQualityScoresDetectedDefect
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDocumentaiV1DocumentPageImageQualityScoresDetectedDefect) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDocumentaiV1DocumentPageImageQualityScoresDetectedDefect
	var s1 struct {
		Confidence gensupport.JSONFloat64 `json:"confidence"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Confidence = float64(s1.Confidence)
	return nil
}

// GoogleCloudDocumentaiV1DocumentPageLayout: Visual element describing a
// layout unit on a page.
type GoogleCloudDocumentaiV1DocumentPageLayout struct {
	// BoundingPoly: The bounding polygon for the Layout.
	BoundingPoly *GoogleCloudDocumentaiV1BoundingPoly `json:"boundingPoly,omitempty"`
	// Confidence: Confidence of the current Layout within context of the object
	// this layout is for. e.g. confidence can be for a single token, a table, a
	// visual element, etc. depending on context. Range `[0, 1]`.
	Confidence float64 `json:"confidence,omitempty"`
	// Orientation: Detected orientation for the Layout.
	//
	// Possible values:
	//   "ORIENTATION_UNSPECIFIED" - Unspecified orientation.
	//   "PAGE_UP" - Orientation is aligned with page up.
	//   "PAGE_RIGHT" - Orientation is aligned with page right. Turn the head 90
	// degrees clockwise from upright to read.
	//   "PAGE_DOWN" - Orientation is aligned with page down. Turn the head 180
	// degrees from upright to read.
	//   "PAGE_LEFT" - Orientation is aligned with page left. Turn the head 90
	// degrees counterclockwise from upright to read.
	Orientation string `json:"orientation,omitempty"`
	// TextAnchor: Text anchor indexing into the Document.text.
	TextAnchor *GoogleCloudDocumentaiV1DocumentTextAnchor `json:"textAnchor,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BoundingPoly") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BoundingPoly") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiV1DocumentPageLayout) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1DocumentPageLayout
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDocumentaiV1DocumentPageLayout) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDocumentaiV1DocumentPageLayout
	var s1 struct {
		Confidence gensupport.JSONFloat64 `json:"confidence"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Confidence = float64(s1.Confidence)
	return nil
}

// GoogleCloudDocumentaiV1DocumentPageLine: A collection of tokens that a human
// would perceive as a line. Does not cross column boundaries, can be
// horizontal, vertical, etc.
type GoogleCloudDocumentaiV1DocumentPageLine struct {
	// DetectedLanguages: A list of detected languages together with confidence.
	DetectedLanguages []*GoogleCloudDocumentaiV1DocumentPageDetectedLanguage `json:"detectedLanguages,omitempty"`
	// Layout: Layout for Line.
	Layout *GoogleCloudDocumentaiV1DocumentPageLayout `json:"layout,omitempty"`
	// Provenance: The history of this annotation.
	Provenance *GoogleCloudDocumentaiV1DocumentProvenance `json:"provenance,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DetectedLanguages") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DetectedLanguages") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiV1DocumentPageLine) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1DocumentPageLine
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1DocumentPageMatrix: Representation for transformation
// matrix, intended to be compatible and used with OpenCV format for image
// manipulation.
type GoogleCloudDocumentaiV1DocumentPageMatrix struct {
	// Cols: Number of columns in the matrix.
	Cols int64 `json:"cols,omitempty"`
	// Data: The matrix data.
	Data string `json:"data,omitempty"`
	// Rows: Number of rows in the matrix.
	Rows int64 `json:"rows,omitempty"`
	// Type: This encodes information about what data type the matrix uses. For
	// example, 0 (CV_8U) is an unsigned 8-bit image. For the full list of OpenCV
	// primitive data types, please refer to
	// https://docs.opencv.org/4.3.0/d1/d1b/group__core__hal__interface.html
	Type int64 `json:"type,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Cols") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Cols") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiV1DocumentPageMatrix) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1DocumentPageMatrix
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1DocumentPageParagraph: A collection of lines that a
// human would perceive as a paragraph.
type GoogleCloudDocumentaiV1DocumentPageParagraph struct {
	// DetectedLanguages: A list of detected languages together with confidence.
	DetectedLanguages []*GoogleCloudDocumentaiV1DocumentPageDetectedLanguage `json:"detectedLanguages,omitempty"`
	// Layout: Layout for Paragraph.
	Layout *GoogleCloudDocumentaiV1DocumentPageLayout `json:"layout,omitempty"`
	// Provenance: The history of this annotation.
	Provenance *GoogleCloudDocumentaiV1DocumentProvenance `json:"provenance,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DetectedLanguages") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DetectedLanguages") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiV1DocumentPageParagraph) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1DocumentPageParagraph
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1DocumentPageSymbol: A detected symbol.
type GoogleCloudDocumentaiV1DocumentPageSymbol struct {
	// DetectedLanguages: A list of detected languages together with confidence.
	DetectedLanguages []*GoogleCloudDocumentaiV1DocumentPageDetectedLanguage `json:"detectedLanguages,omitempty"`
	// Layout: Layout for Symbol.
	Layout *GoogleCloudDocumentaiV1DocumentPageLayout `json:"layout,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DetectedLanguages") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DetectedLanguages") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiV1DocumentPageSymbol) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1DocumentPageSymbol
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1DocumentPageTable: A table representation similar to
// HTML table structure.
type GoogleCloudDocumentaiV1DocumentPageTable struct {
	// BodyRows: Body rows of the table.
	BodyRows []*GoogleCloudDocumentaiV1DocumentPageTableTableRow `json:"bodyRows,omitempty"`
	// DetectedLanguages: A list of detected languages together with confidence.
	DetectedLanguages []*GoogleCloudDocumentaiV1DocumentPageDetectedLanguage `json:"detectedLanguages,omitempty"`
	// HeaderRows: Header rows of the table.
	HeaderRows []*GoogleCloudDocumentaiV1DocumentPageTableTableRow `json:"headerRows,omitempty"`
	// Layout: Layout for Table.
	Layout *GoogleCloudDocumentaiV1DocumentPageLayout `json:"layout,omitempty"`
	// Provenance: The history of this table.
	Provenance *GoogleCloudDocumentaiV1DocumentProvenance `json:"provenance,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BodyRows") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BodyRows") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiV1DocumentPageTable) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1DocumentPageTable
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1DocumentPageTableTableCell: A cell representation
// inside the table.
type GoogleCloudDocumentaiV1DocumentPageTableTableCell struct {
	// ColSpan: How many columns this cell spans.
	ColSpan int64 `json:"colSpan,omitempty"`
	// DetectedLanguages: A list of detected languages together with confidence.
	DetectedLanguages []*GoogleCloudDocumentaiV1DocumentPageDetectedLanguage `json:"detectedLanguages,omitempty"`
	// Layout: Layout for TableCell.
	Layout *GoogleCloudDocumentaiV1DocumentPageLayout `json:"layout,omitempty"`
	// RowSpan: How many rows this cell spans.
	RowSpan int64 `json:"rowSpan,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ColSpan") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ColSpan") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiV1DocumentPageTableTableCell) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1DocumentPageTableTableCell
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1DocumentPageTableTableRow: A row of table cells.
type GoogleCloudDocumentaiV1DocumentPageTableTableRow struct {
	// Cells: Cells that make up this row.
	Cells []*GoogleCloudDocumentaiV1DocumentPageTableTableCell `json:"cells,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Cells") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Cells") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiV1DocumentPageTableTableRow) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1DocumentPageTableTableRow
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1DocumentPageToken: A detected token.
type GoogleCloudDocumentaiV1DocumentPageToken struct {
	// DetectedBreak: Detected break at the end of a Token.
	DetectedBreak *GoogleCloudDocumentaiV1DocumentPageTokenDetectedBreak `json:"detectedBreak,omitempty"`
	// DetectedLanguages: A list of detected languages together with confidence.
	DetectedLanguages []*GoogleCloudDocumentaiV1DocumentPageDetectedLanguage `json:"detectedLanguages,omitempty"`
	// Layout: Layout for Token.
	Layout *GoogleCloudDocumentaiV1DocumentPageLayout `json:"layout,omitempty"`
	// Provenance: The history of this annotation.
	Provenance *GoogleCloudDocumentaiV1DocumentProvenance `json:"provenance,omitempty"`
	// StyleInfo: Text style attributes.
	StyleInfo *GoogleCloudDocumentaiV1DocumentPageTokenStyleInfo `json:"styleInfo,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DetectedBreak") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DetectedBreak") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiV1DocumentPageToken) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1DocumentPageToken
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1DocumentPageTokenDetectedBreak: Detected break at the
// end of a Token.
type GoogleCloudDocumentaiV1DocumentPageTokenDetectedBreak struct {
	// Type: Detected break type.
	//
	// Possible values:
	//   "TYPE_UNSPECIFIED" - Unspecified break type.
	//   "SPACE" - A single whitespace.
	//   "WIDE_SPACE" - A wider whitespace.
	//   "HYPHEN" - A hyphen that indicates that a token has been split across
	// lines.
	Type string `json:"type,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Type") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Type") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiV1DocumentPageTokenDetectedBreak) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1DocumentPageTokenDetectedBreak
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1DocumentPageTokenStyleInfo: Font and other text style
// attributes.
type GoogleCloudDocumentaiV1DocumentPageTokenStyleInfo struct {
	// BackgroundColor: Color of the background.
	BackgroundColor *GoogleTypeColor `json:"backgroundColor,omitempty"`
	// Bold: Whether the text is bold (equivalent to font_weight is at least
	// `700`).
	Bold bool `json:"bold,omitempty"`
	// FontSize: Font size in points (`1` point is `¹⁄₇₂` inches).
	FontSize int64 `json:"fontSize,omitempty"`
	// FontType: Name or style of the font.
	FontType string `json:"fontType,omitempty"`
	// FontWeight: TrueType weight on a scale `100` (thin) to `1000` (ultra-heavy).
	// Normal is `400`, bold is `700`.
	FontWeight int64 `json:"fontWeight,omitempty"`
	// Handwritten: Whether the text is handwritten.
	Handwritten bool `json:"handwritten,omitempty"`
	// Italic: Whether the text is italic.
	Italic bool `json:"italic,omitempty"`
	// LetterSpacing: Letter spacing in points.
	LetterSpacing float64 `json:"letterSpacing,omitempty"`
	// PixelFontSize: Font size in pixels, equal to _unrounded font_size_ *
	// _resolution_ ÷ `72.0`.
	PixelFontSize float64 `json:"pixelFontSize,omitempty"`
	// Smallcaps: Whether the text is in small caps. This feature is not supported
	// yet.
	Smallcaps bool `json:"smallcaps,omitempty"`
	// Strikeout: Whether the text is strikethrough. This feature is not supported
	// yet.
	Strikeout bool `json:"strikeout,omitempty"`
	// Subscript: Whether the text is a subscript. This feature is not supported
	// yet.
	Subscript bool `json:"subscript,omitempty"`
	// Superscript: Whether the text is a superscript. This feature is not
	// supported yet.
	Superscript bool `json:"superscript,omitempty"`
	// TextColor: Color of the text.
	TextColor *GoogleTypeColor `json:"textColor,omitempty"`
	// Underlined: Whether the text is underlined.
	Underlined bool `json:"underlined,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BackgroundColor") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BackgroundColor") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiV1DocumentPageTokenStyleInfo) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1DocumentPageTokenStyleInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDocumentaiV1DocumentPageTokenStyleInfo) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDocumentaiV1DocumentPageTokenStyleInfo
	var s1 struct {
		LetterSpacing gensupport.JSONFloat64 `json:"letterSpacing"`
		PixelFontSize gensupport.JSONFloat64 `json:"pixelFontSize"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.LetterSpacing = float64(s1.LetterSpacing)
	s.PixelFontSize = float64(s1.PixelFontSize)
	return nil
}

// GoogleCloudDocumentaiV1DocumentPageVisualElement: Detected non-text visual
// elements e.g. checkbox, signature etc. on the page.
type GoogleCloudDocumentaiV1DocumentPageVisualElement struct {
	// DetectedLanguages: A list of detected languages together with confidence.
	DetectedLanguages []*GoogleCloudDocumentaiV1DocumentPageDetectedLanguage `json:"detectedLanguages,omitempty"`
	// Layout: Layout for VisualElement.
	Layout *GoogleCloudDocumentaiV1DocumentPageLayout `json:"layout,omitempty"`
	// Type: Type of the VisualElement.
	Type string `json:"type,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DetectedLanguages") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DetectedLanguages") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiV1DocumentPageVisualElement) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1DocumentPageVisualElement
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1DocumentProvenance: Structure to identify provenance
// relationships between annotations in different revisions.
type GoogleCloudDocumentaiV1DocumentProvenance struct {
	// Id: The Id of this operation. Needs to be unique within the scope of the
	// revision.
	Id int64 `json:"id,omitempty"`
	// Parents: References to the original elements that are replaced.
	Parents []*GoogleCloudDocumentaiV1DocumentProvenanceParent `json:"parents,omitempty"`
	// Revision: The index of the revision that produced this element.
	Revision int64 `json:"revision,omitempty"`
	// Type: The type of provenance operation.
	//
	// Possible values:
	//   "OPERATION_TYPE_UNSPECIFIED" - Operation type unspecified. If no operation
	// is specified a provenance entry is simply used to match against a `parent`.
	//   "ADD" - Add an element.
	//   "REMOVE" - Remove an element identified by `parent`.
	//   "UPDATE" - Updates any fields within the given provenance scope of the
	// message. It overwrites the fields rather than replacing them. Use this when
	// you want to update a field value of an entity without also updating all the
	// child properties.
	//   "REPLACE" - Currently unused. Replace an element identified by `parent`.
	//   "EVAL_REQUESTED" - Deprecated. Request human review for the element
	// identified by `parent`.
	//   "EVAL_APPROVED" - Deprecated. Element is reviewed and approved at human
	// review, confidence will be set to 1.0.
	//   "EVAL_SKIPPED" - Deprecated. Element is skipped in the validation process.
	Type string `json:"type,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Id") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Id") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiV1DocumentProvenance) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1DocumentProvenance
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1DocumentProvenanceParent: The parent element the
// current element is based on. Used for referencing/aligning, removal and
// replacement operations.
type GoogleCloudDocumentaiV1DocumentProvenanceParent struct {
	// Id: The id of the parent provenance.
	Id int64 `json:"id,omitempty"`
	// Index: The index of the parent item in the corresponding item list (eg. list
	// of entities, properties within entities, etc.) in the parent revision.
	Index int64 `json:"index,omitempty"`
	// Revision: The index of the index into current revision's parent_ids list.
	Revision int64 `json:"revision,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Id") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Id") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiV1DocumentProvenanceParent) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1DocumentProvenanceParent
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1DocumentRevision: Contains past or forward revisions
// of this document.
type GoogleCloudDocumentaiV1DocumentRevision struct {
	// Agent: If the change was made by a person specify the name or id of that
	// person.
	Agent string `json:"agent,omitempty"`
	// CreateTime: The time that the revision was created, internally generated by
	// doc proto storage at the time of create.
	CreateTime string `json:"createTime,omitempty"`
	// HumanReview: Human Review information of this revision.
	HumanReview *GoogleCloudDocumentaiV1DocumentRevisionHumanReview `json:"humanReview,omitempty"`
	// Id: Id of the revision, internally generated by doc proto storage. Unique
	// within the context of the document.
	Id string `json:"id,omitempty"`
	// Parent: The revisions that this revision is based on. This can include one
	// or more parent (when documents are merged.) This field represents the index
	// into the `revisions` field.
	Parent []int64 `json:"parent,omitempty"`
	// ParentIds: The revisions that this revision is based on. Must include all
	// the ids that have anything to do with this revision - eg. there are
	// `provenance.parent.revision` fields that index into this field.
	ParentIds []string `json:"parentIds,omitempty"`
	// Processor: If the annotation was made by processor identify the processor by
	// its resource name.
	Processor string `json:"processor,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Agent") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Agent") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiV1DocumentRevision) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1DocumentRevision
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1DocumentRevisionHumanReview: Human Review information
// of the document.
type GoogleCloudDocumentaiV1DocumentRevisionHumanReview struct {
	// State: Human review state. e.g. `requested`, `succeeded`, `rejected`.
	State string `json:"state,omitempty"`
	// StateMessage: A message providing more details about the current state of
	// processing. For example, the rejection reason when the state is `rejected`.
	StateMessage string `json:"stateMessage,omitempty"`
	// ForceSendFields is a list of field names (e.g. "State") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "State") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiV1DocumentRevisionHumanReview) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1DocumentRevisionHumanReview
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1DocumentShardInfo: For a large document, sharding may
// be performed to produce several document shards. Each document shard
// contains this field to detail which shard it is.
type GoogleCloudDocumentaiV1DocumentShardInfo struct {
	// ShardCount: Total number of shards.
	ShardCount int64 `json:"shardCount,omitempty,string"`
	// ShardIndex: The 0-based index of this shard.
	ShardIndex int64 `json:"shardIndex,omitempty,string"`
	// TextOffset: The index of the first character in Document.text in the overall
	// document global text.
	TextOffset int64 `json:"textOffset,omitempty,string"`
	// ForceSendFields is a list of field names (e.g. "ShardCount") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ShardCount") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiV1DocumentShardInfo) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1DocumentShardInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1DocumentStyle: Annotation for common text style
// attributes. This adheres to CSS conventions as much as possible.
type GoogleCloudDocumentaiV1DocumentStyle struct {
	// BackgroundColor: Text background color.
	BackgroundColor *GoogleTypeColor `json:"backgroundColor,omitempty"`
	// Color: Text color.
	Color *GoogleTypeColor `json:"color,omitempty"`
	// FontFamily: Font family such as `Arial`, `Times New Roman`.
	// https://www.w3schools.com/cssref/pr_font_font-family.asp
	FontFamily string `json:"fontFamily,omitempty"`
	// FontSize: Font size.
	FontSize *GoogleCloudDocumentaiV1DocumentStyleFontSize `json:"fontSize,omitempty"`
	// FontWeight: Font weight
	// (https://www.w3schools.com/cssref/pr_font_weight.asp). Possible values are
	// `normal`, `bold`, `bolder`, and `lighter`.
	FontWeight string `json:"fontWeight,omitempty"`
	// TextAnchor: Text anchor indexing into the Document.text.
	TextAnchor *GoogleCloudDocumentaiV1DocumentTextAnchor `json:"textAnchor,omitempty"`
	// TextDecoration: Text decoration
	// (https://www.w3schools.com/cssref/pr_text_text-decoration.asp). Follows CSS
	// standard.
	TextDecoration string `json:"textDecoration,omitempty"`
	// TextStyle: Text style
	// (https://www.w3schools.com/cssref/pr_font_font-style.asp). Possible values
	// are `normal`, `italic`, and `oblique`.
	TextStyle string `json:"textStyle,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BackgroundColor") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BackgroundColor") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiV1DocumentStyle) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1DocumentStyle
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1DocumentStyleFontSize: Font size with unit.
type GoogleCloudDocumentaiV1DocumentStyleFontSize struct {
	// Size: Font size for the text.
	Size float64 `json:"size,omitempty"`
	// Unit: Unit for the font size. Follows CSS naming (such as `in`, `px`, and
	// `pt`).
	Unit string `json:"unit,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Size") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Size") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiV1DocumentStyleFontSize) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1DocumentStyleFontSize
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDocumentaiV1DocumentStyleFontSize) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDocumentaiV1DocumentStyleFontSize
	var s1 struct {
		Size gensupport.JSONFloat64 `json:"size"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Size = float64(s1.Size)
	return nil
}

// GoogleCloudDocumentaiV1DocumentTextAnchor: Text reference indexing into the
// Document.text.
type GoogleCloudDocumentaiV1DocumentTextAnchor struct {
	// Content: Contains the content of the text span so that users do not have to
	// look it up in the text_segments. It is always populated for formFields.
	Content string `json:"content,omitempty"`
	// TextSegments: The text segments from the Document.text.
	TextSegments []*GoogleCloudDocumentaiV1DocumentTextAnchorTextSegment `json:"textSegments,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Content") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Content") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiV1DocumentTextAnchor) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1DocumentTextAnchor
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1DocumentTextAnchorTextSegment: A text segment in the
// Document.text. The indices may be out of bounds which indicate that the text
// extends into another document shard for large sharded documents. See
// ShardInfo.text_offset
type GoogleCloudDocumentaiV1DocumentTextAnchorTextSegment struct {
	// EndIndex: TextSegment half open end UTF-8 char index in the Document.text.
	EndIndex int64 `json:"endIndex,omitempty,string"`
	// StartIndex: TextSegment start UTF-8 char index in the Document.text.
	StartIndex int64 `json:"startIndex,omitempty,string"`
	// ForceSendFields is a list of field names (e.g. "EndIndex") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EndIndex") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiV1DocumentTextAnchorTextSegment) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1DocumentTextAnchorTextSegment
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1DocumentTextChange: This message is used for text
// changes aka. OCR corrections.
type GoogleCloudDocumentaiV1DocumentTextChange struct {
	// ChangedText: The text that replaces the text identified in the
	// `text_anchor`.
	ChangedText string `json:"changedText,omitempty"`
	// Provenance: The history of this annotation.
	Provenance []*GoogleCloudDocumentaiV1DocumentProvenance `json:"provenance,omitempty"`
	// TextAnchor: Provenance of the correction. Text anchor indexing into the
	// Document.text. There can only be a single `TextAnchor.text_segments`
	// element. If the start and end index of the text segment are the same, the
	// text change is inserted before that index.
	TextAnchor *GoogleCloudDocumentaiV1DocumentTextAnchor `json:"textAnchor,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ChangedText") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ChangedText") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiV1DocumentTextChange) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1DocumentTextChange
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDocumentaiV1NormalizedVertex: A vertex represents a 2D point in
// the image. NOTE: the normalized vertex coordinates are relative to the
// original image and range from 0 to 1.
type GoogleCloudDocumentaiV1NormalizedVertex struct {
	// X: X coordinate.
	X float64 `json:"x,omitempty"`
	// Y: Y coordinate (starts from the top of the image).
	Y float64 `json:"y,omitempty"`
	// ForceSendFields is a list of field names (e.g. "X") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "X") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiV1NormalizedVertex) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1NormalizedVertex
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDocumentaiV1NormalizedVertex) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDocumentaiV1NormalizedVertex
	var s1 struct {
		X gensupport.JSONFloat64 `json:"x"`
		Y gensupport.JSONFloat64 `json:"y"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.X = float64(s1.X)
	s.Y = float64(s1.Y)
	return nil
}

// GoogleCloudDocumentaiV1Vertex: A vertex represents a 2D point in the image.
// NOTE: the vertex coordinates are in the same scale as the original image.
type GoogleCloudDocumentaiV1Vertex struct {
	// X: X coordinate.
	X int64 `json:"x,omitempty"`
	// Y: Y coordinate (starts from the top of the image).
	Y int64 `json:"y,omitempty"`
	// ForceSendFields is a list of field names (e.g. "X") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "X") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDocumentaiV1Vertex) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDocumentaiV1Vertex
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleIamV1AuditConfig: Specifies the audit configuration for a service. The
// configuration determines which permission types are logged, and what
// identities, if any, are exempted from logging. An AuditConfig must have one
// or more AuditLogConfigs. If there are AuditConfigs for both `allServices`
// and a specific service, the union of the two AuditConfigs is used for that
// service: the log_types specified in each AuditConfig are enabled, and the
// exempted_members in each AuditLogConfig are exempted. Example Policy with
// multiple AuditConfigs: { "audit_configs": [ { "service": "allServices",
// "audit_log_configs": [ { "log_type": "DATA_READ", "exempted_members": [
// "user:jose@example.com" ] }, { "log_type": "DATA_WRITE" }, { "log_type":
// "ADMIN_READ" } ] }, { "service": "sampleservice.googleapis.com",
// "audit_log_configs": [ { "log_type": "DATA_READ" }, { "log_type":
// "DATA_WRITE", "exempted_members": [ "user:aliya@example.com" ] } ] } ] } For
// sampleservice, this policy enables DATA_READ, DATA_WRITE and ADMIN_READ
// logging. It also exempts `jose@example.com` from DATA_READ logging, and
// `aliya@example.com` from DATA_WRITE logging.
type GoogleIamV1AuditConfig struct {
	// AuditLogConfigs: The configuration for logging of each type of permission.
	AuditLogConfigs []*GoogleIamV1AuditLogConfig `json:"auditLogConfigs,omitempty"`
	// Service: Specifies a service that will be enabled for audit logging. For
	// example, `storage.googleapis.com`, `cloudsql.googleapis.com`. `allServices`
	// is a special value that covers all services.
	Service string `json:"service,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AuditLogConfigs") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AuditLogConfigs") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleIamV1AuditConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleIamV1AuditConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleIamV1AuditLogConfig: Provides the configuration for logging a type of
// permissions. Example: { "audit_log_configs": [ { "log_type": "DATA_READ",
// "exempted_members": [ "user:jose@example.com" ] }, { "log_type":
// "DATA_WRITE" } ] } This enables 'DATA_READ' and 'DATA_WRITE' logging, while
// exempting jose@example.com from DATA_READ logging.
type GoogleIamV1AuditLogConfig struct {
	// ExemptedMembers: Specifies the identities that do not cause logging for this
	// type of permission. Follows the same format of Binding.members.
	ExemptedMembers []string `json:"exemptedMembers,omitempty"`
	// LogType: The log type that this config enables.
	//
	// Possible values:
	//   "LOG_TYPE_UNSPECIFIED" - Default case. Should never be this.
	//   "ADMIN_READ" - Admin reads. Example: CloudIAM getIamPolicy
	//   "DATA_WRITE" - Data writes. Example: CloudSQL Users create
	//   "DATA_READ" - Data reads. Example: CloudSQL Users list
	LogType string `json:"logType,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ExemptedMembers") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ExemptedMembers") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleIamV1AuditLogConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleIamV1AuditLogConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleIamV1Binding: Associates `members`, or principals, with a `role`.
type GoogleIamV1Binding struct {
	// Condition: The condition that is associated with this binding. If the
	// condition evaluates to `true`, then this binding applies to the current
	// request. If the condition evaluates to `false`, then this binding does not
	// apply to the current request. However, a different role binding might grant
	// the same role to one or more of the principals in this binding. To learn
	// which resources support conditions in their IAM policies, see the IAM
	// documentation
	// (https://cloud.google.com/iam/help/conditions/resource-policies).
	Condition *GoogleTypeExpr `json:"condition,omitempty"`
	// Members: Specifies the principals requesting access for a Google Cloud
	// resource. `members` can have the following values: * `allUsers`: A special
	// identifier that represents anyone who is on the internet; with or without a
	// Google account. * `allAuthenticatedUsers`: A special identifier that
	// represents anyone who is authenticated with a Google account or a service
	// account. Does not include identities that come from external identity
	// providers (IdPs) through identity federation. * `user:{emailid}`: An email
	// address that represents a specific Google account. For example,
	// `alice@example.com` . * `serviceAccount:{emailid}`: An email address that
	// represents a Google service account. For example,
	// `my-other-app@appspot.gserviceaccount.com`. *
	// `serviceAccount:{projectid}.svc.id.goog[{namespace}/{kubernetes-sa}]`: An
	// identifier for a Kubernetes service account
	// (https://cloud.google.com/kubernetes-engine/docs/how-to/kubernetes-service-accounts).
	// For example, `my-project.svc.id.goog[my-namespace/my-kubernetes-sa]`. *
	// `group:{emailid}`: An email address that represents a Google group. For
	// example, `admins@example.com`. * `domain:{domain}`: The G Suite domain
	// (primary) that represents all the users of that domain. For example,
	// `google.com` or `example.com`. *
	// `principal://iam.googleapis.com/locations/global/workforcePools/{pool_id}/sub
	// ject/{subject_attribute_value}`: A single identity in a workforce identity
	// pool. *
	// `principalSet://iam.googleapis.com/locations/global/workforcePools/{pool_id}/
	// group/{group_id}`: All workforce identities in a group. *
	// `principalSet://iam.googleapis.com/locations/global/workforcePools/{pool_id}/
	// attribute.{attribute_name}/{attribute_value}`: All workforce identities with
	// a specific attribute value. *
	// `principalSet://iam.googleapis.com/locations/global/workforcePools/{pool_id}/
	// *`: All identities in a workforce identity pool. *
	// `principal://iam.googleapis.com/projects/{project_number}/locations/global/wo
	// rkloadIdentityPools/{pool_id}/subject/{subject_attribute_value}`: A single
	// identity in a workload identity pool. *
	// `principalSet://iam.googleapis.com/projects/{project_number}/locations/global
	// /workloadIdentityPools/{pool_id}/group/{group_id}`: A workload identity pool
	// group. *
	// `principalSet://iam.googleapis.com/projects/{project_number}/locations/global
	// /workloadIdentityPools/{pool_id}/attribute.{attribute_name}/{attribute_value}
	// `: All identities in a workload identity pool with a certain attribute. *
	// `principalSet://iam.googleapis.com/projects/{project_number}/locations/global
	// /workloadIdentityPools/{pool_id}/*`: All identities in a workload identity
	// pool. * `deleted:user:{emailid}?uid={uniqueid}`: An email address (plus
	// unique identifier) representing a user that has been recently deleted. For
	// example, `alice@example.com?uid=123456789012345678901`. If the user is
	// recovered, this value reverts to `user:{emailid}` and the recovered user
	// retains the role in the binding. *
	// `deleted:serviceAccount:{emailid}?uid={uniqueid}`: An email address (plus
	// unique identifier) representing a service account that has been recently
	// deleted. For example,
	// `my-other-app@appspot.gserviceaccount.com?uid=123456789012345678901`. If the
	// service account is undeleted, this value reverts to
	// `serviceAccount:{emailid}` and the undeleted service account retains the
	// role in the binding. * `deleted:group:{emailid}?uid={uniqueid}`: An email
	// address (plus unique identifier) representing a Google group that has been
	// recently deleted. For example,
	// `admins@example.com?uid=123456789012345678901`. If the group is recovered,
	// this value reverts to `group:{emailid}` and the recovered group retains the
	// role in the binding. *
	// `deleted:principal://iam.googleapis.com/locations/global/workforcePools/{pool
	// _id}/subject/{subject_attribute_value}`: Deleted single identity in a
	// workforce identity pool. For example,
	// `deleted:principal://iam.googleapis.com/locations/global/workforcePools/my-po
	// ol-id/subject/my-subject-attribute-value`.
	Members []string `json:"members,omitempty"`
	// Role: Role that is assigned to the list of `members`, or principals. For
	// example, `roles/viewer`, `roles/editor`, or `roles/owner`. For an overview
	// of the IAM roles and permissions, see the IAM documentation
	// (https://cloud.google.com/iam/docs/roles-overview). For a list of the
	// available pre-defined roles, see here
	// (https://cloud.google.com/iam/docs/understanding-roles).
	Role string `json:"role,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Condition") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Condition") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleIamV1Binding) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleIamV1Binding
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleIamV1Policy: An Identity and Access Management (IAM) policy, which
// specifies access controls for Google Cloud resources. A `Policy` is a
// collection of `bindings`. A `binding` binds one or more `members`, or
// principals, to a single `role`. Principals can be user accounts, service
// accounts, Google groups, and domains (such as G Suite). A `role` is a named
// list of permissions; each `role` can be an IAM predefined role or a
// user-created custom role. For some types of Google Cloud resources, a
// `binding` can also specify a `condition`, which is a logical expression that
// allows access to a resource only if the expression evaluates to `true`. A
// condition can add constraints based on attributes of the request, the
// resource, or both. To learn which resources support conditions in their IAM
// policies, see the IAM documentation
// (https://cloud.google.com/iam/help/conditions/resource-policies). **JSON
// example:** ``` { "bindings": [ { "role":
// "roles/resourcemanager.organizationAdmin", "members": [
// "user:mike@example.com", "group:admins@example.com", "domain:google.com",
// "serviceAccount:my-project-id@appspot.gserviceaccount.com" ] }, { "role":
// "roles/resourcemanager.organizationViewer", "members": [
// "user:eve@example.com" ], "condition": { "title": "expirable access",
// "description": "Does not grant access after Sep 2020", "expression":
// "request.time < timestamp('2020-10-01T00:00:00.000Z')", } } ], "etag":
// "BwWWja0YfJA=", "version": 3 } ``` **YAML example:** ``` bindings: -
// members: - user:mike@example.com - group:admins@example.com -
// domain:google.com - serviceAccount:my-project-id@appspot.gserviceaccount.com
// role: roles/resourcemanager.organizationAdmin - members: -
// user:eve@example.com role: roles/resourcemanager.organizationViewer
// condition: title: expirable access description: Does not grant access after
// Sep 2020 expression: request.time < timestamp('2020-10-01T00:00:00.000Z')
// etag: BwWWja0YfJA= version: 3 ``` For a description of IAM and its features,
// see the IAM documentation (https://cloud.google.com/iam/docs/).
type GoogleIamV1Policy struct {
	// AuditConfigs: Specifies cloud audit logging configuration for this policy.
	AuditConfigs []*GoogleIamV1AuditConfig `json:"auditConfigs,omitempty"`
	// Bindings: Associates a list of `members`, or principals, with a `role`.
	// Optionally, may specify a `condition` that determines how and when the
	// `bindings` are applied. Each of the `bindings` must contain at least one
	// principal. The `bindings` in a `Policy` can refer to up to 1,500 principals;
	// up to 250 of these principals can be Google groups. Each occurrence of a
	// principal counts towards these limits. For example, if the `bindings` grant
	// 50 different roles to `user:alice@example.com`, and not to any other
	// principal, then you can add another 1,450 principals to the `bindings` in
	// the `Policy`.
	Bindings []*GoogleIamV1Binding `json:"bindings,omitempty"`
	// Etag: `etag` is used for optimistic concurrency control as a way to help
	// prevent simultaneous updates of a policy from overwriting each other. It is
	// strongly suggested that systems make use of the `etag` in the
	// read-modify-write cycle to perform policy updates in order to avoid race
	// conditions: An `etag` is returned in the response to `getIamPolicy`, and
	// systems are expected to put that etag in the request to `setIamPolicy` to
	// ensure that their change will be applied to the same version of the policy.
	// **Important:** If you use IAM Conditions, you must include the `etag` field
	// whenever you call `setIamPolicy`. If you omit this field, then IAM allows
	// you to overwrite a version `3` policy with a version `1` policy, and all of
	// the conditions in the version `3` policy are lost.
	Etag string `json:"etag,omitempty"`
	// Version: Specifies the format of the policy. Valid values are `0`, `1`, and
	// `3`. Requests that specify an invalid value are rejected. Any operation that
	// affects conditional role bindings must specify version `3`. This requirement
	// applies to the following operations: * Getting a policy that includes a
	// conditional role binding * Adding a conditional role binding to a policy *
	// Changing a conditional role binding in a policy * Removing any role binding,
	// with or without a condition, from a policy that includes conditions
	// **Important:** If you use IAM Conditions, you must include the `etag` field
	// whenever you call `setIamPolicy`. If you omit this field, then IAM allows
	// you to overwrite a version `3` policy with a version `1` policy, and all of
	// the conditions in the version `3` policy are lost. If a policy does not
	// include any conditions, operations on that policy may specify any valid
	// version or leave the field unset. To learn which resources support
	// conditions in their IAM policies, see the IAM documentation
	// (https://cloud.google.com/iam/help/conditions/resource-policies).
	Version int64 `json:"version,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AuditConfigs") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AuditConfigs") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleIamV1Policy) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleIamV1Policy
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleLongrunningOperation: This resource represents a long-running
// operation that is the result of a network API call.
type GoogleLongrunningOperation struct {
	// Done: If the value is `false`, it means the operation is still in progress.
	// If `true`, the operation is completed, and either `error` or `response` is
	// available.
	Done bool `json:"done,omitempty"`
	// Error: The error result of the operation in case of failure or cancellation.
	Error *GoogleRpcStatus `json:"error,omitempty"`
	// Metadata: Service-specific metadata associated with the operation. It
	// typically contains progress information and common metadata such as create
	// time. Some services might not provide such metadata. Any method that returns
	// a long-running operation should document the metadata type, if any.
	Metadata googleapi.RawMessage `json:"metadata,omitempty"`
	// Name: The server-assigned name, which is only unique within the same service
	// that originally returns it. If you use the default HTTP mapping, the `name`
	// should be a resource name ending with `operations/{unique_id}`.
	Name string `json:"name,omitempty"`
	// Response: The normal, successful response of the operation. If the original
	// method returns no data on success, such as `Delete`, the response is
	// `google.protobuf.Empty`. If the original method is standard
	// `Get`/`Create`/`Update`, the response should be the resource. For other
	// methods, the response should have the type `XxxResponse`, where `Xxx` is the
	// original method name. For example, if the original method name is
	// `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.
	Response googleapi.RawMessage `json:"response,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Done") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Done") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleLongrunningOperation) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleLongrunningOperation
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleProtobufEmpty: A generic empty message that you can re-use to avoid
// defining duplicated empty messages in your APIs. A typical example is to use
// it as the request or the response type of an API method. For instance:
// service Foo { rpc Bar(google.protobuf.Empty) returns
// (google.protobuf.Empty); }
type GoogleProtobufEmpty struct {
	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
}

// GoogleRpcStatus: The `Status` type defines a logical error model that is
// suitable for different programming environments, including REST APIs and RPC
// APIs. It is used by gRPC (https://github.com/grpc). Each `Status` message
// contains three pieces of data: error code, error message, and error details.
// You can find out more about this error model and how to work with it in the
// API Design Guide (https://cloud.google.com/apis/design/errors).
type GoogleRpcStatus struct {
	// Code: The status code, which should be an enum value of google.rpc.Code.
	Code int64 `json:"code,omitempty"`
	// Details: A list of messages that carry the error details. There is a common
	// set of message types for APIs to use.
	Details []googleapi.RawMessage `json:"details,omitempty"`
	// Message: A developer-facing error message, which should be in English. Any
	// user-facing error message should be localized and sent in the
	// google.rpc.Status.details field, or localized by the client.
	Message string `json:"message,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Code") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Code") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleRpcStatus) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleRpcStatus
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleTypeColor: Represents a color in the RGBA color space. This
// representation is designed for simplicity of conversion to and from color
// representations in various languages over compactness. For example, the
// fields of this representation can be trivially provided to the constructor
// of `java.awt.Color` in Java; it can also be trivially provided to UIColor's
// `+colorWithRed:green:blue:alpha` method in iOS; and, with just a little
// work, it can be easily formatted into a CSS `rgba()` string in JavaScript.
// This reference page doesn't have information about the absolute color space
// that should be used to interpret the RGB value—for example, sRGB, Adobe
// RGB, DCI-P3, and BT.2020. By default, applications should assume the sRGB
// color space. When color equality needs to be decided, implementations,
// unless documented otherwise, treat two colors as equal if all their red,
// green, blue, and alpha values each differ by at most `1e-5`. Example (Java):
// import com.google.type.Color; // ... public static java.awt.Color
// fromProto(Color protocolor) { float alpha = protocolor.hasAlpha() ?
// protocolor.getAlpha().getValue() : 1.0; return new java.awt.Color(
// protocolor.getRed(), protocolor.getGreen(), protocolor.getBlue(), alpha); }
// public static Color toProto(java.awt.Color color) { float red = (float)
// color.getRed(); float green = (float) color.getGreen(); float blue = (float)
// color.getBlue(); float denominator = 255.0; Color.Builder resultBuilder =
// Color .newBuilder() .setRed(red / denominator) .setGreen(green /
// denominator) .setBlue(blue / denominator); int alpha = color.getAlpha(); if
// (alpha != 255) { result.setAlpha( FloatValue .newBuilder()
// .setValue(((float) alpha) / denominator) .build()); } return
// resultBuilder.build(); } // ... Example (iOS / Obj-C): // ... static
// UIColor* fromProto(Color* protocolor) { float red = [protocolor red]; float
// green = [protocolor green]; float blue = [protocolor blue]; FloatValue*
// alpha_wrapper = [protocolor alpha]; float alpha = 1.0; if (alpha_wrapper !=
// nil) { alpha = [alpha_wrapper value]; } return [UIColor colorWithRed:red
// green:green blue:blue alpha:alpha]; } static Color* toProto(UIColor* color)
// { CGFloat red, green, blue, alpha; if (![color getRed:&red green:&green
// blue:&blue alpha:&alpha]) { return nil; } Color* result = [[Color alloc]
// init]; [result setRed:red]; [result setGreen:green]; [result setBlue:blue];
// if (alpha <= 0.9999) { [result setAlpha:floatWrapperWithValue(alpha)]; }
// [result autorelease]; return result; } // ... Example (JavaScript): // ...
// var protoToCssColor = function(rgb_color) { var redFrac = rgb_color.red ||
// 0.0; var greenFrac = rgb_color.green || 0.0; var blueFrac = rgb_color.blue
// || 0.0; var red = Math.floor(redFrac * 255); var green =
// Math.floor(greenFrac * 255); var blue = Math.floor(blueFrac * 255); if
// (!('alpha' in rgb_color)) { return rgbToCssColor(red, green, blue); } var
// alphaFrac = rgb_color.alpha.value || 0.0; var rgbParams = [red, green,
// blue].join(','); return ['rgba(', rgbParams, ',', alphaFrac, ')'].join(”);
// }; var rgbToCssColor = function(red, green, blue) { var rgbNumber = new
// Number((red << 16) | (green << 8) | blue); var hexString =
// rgbNumber.toString(16); var missingZeros = 6 - hexString.length; var
// resultBuilder = ['#']; for (var i = 0; i < missingZeros; i++) {
// resultBuilder.push('0'); } resultBuilder.push(hexString); return
// resultBuilder.join(”); }; // ...
type GoogleTypeColor struct {
	// Alpha: The fraction of this color that should be applied to the pixel. That
	// is, the final pixel color is defined by the equation: `pixel color = alpha *
	// (this color) + (1.0 - alpha) * (background color)` This means that a value
	// of 1.0 corresponds to a solid color, whereas a value of 0.0 corresponds to a
	// completely transparent color. This uses a wrapper message rather than a
	// simple float scalar so that it is possible to distinguish between a default
	// value and the value being unset. If omitted, this color object is rendered
	// as a solid color (as if the alpha value had been explicitly given a value of
	// 1.0).
	Alpha float64 `json:"alpha,omitempty"`
	// Blue: The amount of blue in the color as a value in the interval [0, 1].
	Blue float64 `json:"blue,omitempty"`
	// Green: The amount of green in the color as a value in the interval [0, 1].
	Green float64 `json:"green,omitempty"`
	// Red: The amount of red in the color as a value in the interval [0, 1].
	Red float64 `json:"red,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Alpha") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Alpha") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleTypeColor) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleTypeColor
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleTypeColor) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleTypeColor
	var s1 struct {
		Alpha gensupport.JSONFloat64 `json:"alpha"`
		Blue  gensupport.JSONFloat64 `json:"blue"`
		Green gensupport.JSONFloat64 `json:"green"`
		Red   gensupport.JSONFloat64 `json:"red"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Alpha = float64(s1.Alpha)
	s.Blue = float64(s1.Blue)
	s.Green = float64(s1.Green)
	s.Red = float64(s1.Red)
	return nil
}

// GoogleTypeDate: Represents a whole or partial calendar date, such as a
// birthday. The time of day and time zone are either specified elsewhere or
// are insignificant. The date is relative to the Gregorian Calendar. This can
// represent one of the following: * A full date, with non-zero year, month,
// and day values. * A month and day, with a zero year (for example, an
// anniversary). * A year on its own, with a zero month and a zero day. * A
// year and month, with a zero day (for example, a credit card expiration
// date). Related types: * google.type.TimeOfDay * google.type.DateTime *
// google.protobuf.Timestamp
type GoogleTypeDate struct {
	// Day: Day of a month. Must be from 1 to 31 and valid for the year and month,
	// or 0 to specify a year by itself or a year and month where the day isn't
	// significant.
	Day int64 `json:"day,omitempty"`
	// Month: Month of a year. Must be from 1 to 12, or 0 to specify a year without
	// a month and day.
	Month int64 `json:"month,omitempty"`
	// Year: Year of the date. Must be from 1 to 9999, or 0 to specify a date
	// without a year.
	Year int64 `json:"year,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Day") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Day") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleTypeDate) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleTypeDate
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleTypeDateTime: Represents civil time (or occasionally physical time).
// This type can represent a civil time in one of a few possible ways: * When
// utc_offset is set and time_zone is unset: a civil time on a calendar day
// with a particular offset from UTC. * When time_zone is set and utc_offset is
// unset: a civil time on a calendar day in a particular time zone. * When
// neither time_zone nor utc_offset is set: a civil time on a calendar day in
// local time. The date is relative to the Proleptic Gregorian Calendar. If
// year, month, or day are 0, the DateTime is considered not to have a specific
// year, month, or day respectively. This type may also be used to represent a
// physical time if all the date and time fields are set and either case of the
// `time_offset` oneof is set. Consider using `Timestamp` message for physical
// time instead. If your use case also would like to store the user's timezone,
// that can be done in another field. This type is more flexible than some
// applications may want. Make sure to document and validate your application's
// limitations.
type GoogleTypeDateTime struct {
	// Day: Optional. Day of month. Must be from 1 to 31 and valid for the year and
	// month, or 0 if specifying a datetime without a day.
	Day int64 `json:"day,omitempty"`
	// Hours: Optional. Hours of day in 24 hour format. Should be from 0 to 23,
	// defaults to 0 (midnight). An API may choose to allow the value "24:00:00"
	// for scenarios like business closing time.
	Hours int64 `json:"hours,omitempty"`
	// Minutes: Optional. Minutes of hour of day. Must be from 0 to 59, defaults to
	// 0.
	Minutes int64 `json:"minutes,omitempty"`
	// Month: Optional. Month of year. Must be from 1 to 12, or 0 if specifying a
	// datetime without a month.
	Month int64 `json:"month,omitempty"`
	// Nanos: Optional. Fractions of seconds in nanoseconds. Must be from 0 to
	// 999,999,999, defaults to 0.
	Nanos int64 `json:"nanos,omitempty"`
	// Seconds: Optional. Seconds of minutes of the time. Must normally be from 0
	// to 59, defaults to 0. An API may allow the value 60 if it allows
	// leap-seconds.
	Seconds int64 `json:"seconds,omitempty"`
	// TimeZone: Time zone.
	TimeZone *GoogleTypeTimeZone `json:"timeZone,omitempty"`
	// UtcOffset: UTC offset. Must be whole seconds, between -18 hours and +18
	// hours. For example, a UTC offset of -4:00 would be represented as { seconds:
	// -14400 }.
	UtcOffset string `json:"utcOffset,omitempty"`
	// Year: Optional. Year of date. Must be from 1 to 9999, or 0 if specifying a
	// datetime without a year.
	Year int64 `json:"year,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Day") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Day") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleTypeDateTime) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleTypeDateTime
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleTypeExpr: Represents a textual expression in the Common Expression
// Language (CEL) syntax. CEL is a C-like expression language. The syntax and
// semantics of CEL are documented at https://github.com/google/cel-spec.
// Example (Comparison): title: "Summary size limit" description: "Determines
// if a summary is less than 100 chars" expression: "document.summary.size() <
// 100" Example (Equality): title: "Requestor is owner" description:
// "Determines if requestor is the document owner" expression: "document.owner
// == request.auth.claims.email" Example (Logic): title: "Public documents"
// description: "Determine whether the document should be publicly visible"
// expression: "document.type != 'private' && document.type != 'internal'"
// Example (Data Manipulation): title: "Notification string" description:
// "Create a notification string with a timestamp." expression: "'New message
// received at ' + string(document.create_time)" The exact variables and
// functions that may be referenced within an expression are determined by the
// service that evaluates it. See the service documentation for additional
// information.
type GoogleTypeExpr struct {
	// Description: Optional. Description of the expression. This is a longer text
	// which describes the expression, e.g. when hovered over it in a UI.
	Description string `json:"description,omitempty"`
	// Expression: Textual representation of an expression in Common Expression
	// Language syntax.
	Expression string `json:"expression,omitempty"`
	// Location: Optional. String indicating the location of the expression for
	// error reporting, e.g. a file name and a position in the file.
	Location string `json:"location,omitempty"`
	// Title: Optional. Title for the expression, i.e. a short string describing
	// its purpose. This can be used e.g. in UIs which allow to enter the
	// expression.
	Title string `json:"title,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Description") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Description") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleTypeExpr) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleTypeExpr
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleTypeInterval: Represents a time interval, encoded as a Timestamp start
// (inclusive) and a Timestamp end (exclusive). The start must be less than or
// equal to the end. When the start equals the end, the interval is empty
// (matches no time). When both start and end are unspecified, the interval
// matches any time.
type GoogleTypeInterval struct {
	// EndTime: Optional. Exclusive end of the interval. If specified, a Timestamp
	// matching this interval will have to be before the end.
	EndTime string `json:"endTime,omitempty"`
	// StartTime: Optional. Inclusive start of the interval. If specified, a
	// Timestamp matching this interval will have to be the same or after the
	// start.
	StartTime string `json:"startTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "EndTime") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EndTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleTypeInterval) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleTypeInterval
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleTypeMoney: Represents an amount of money with its currency type.
type GoogleTypeMoney struct {
	// CurrencyCode: The three-letter currency code defined in ISO 4217.
	CurrencyCode string `json:"currencyCode,omitempty"`
	// Nanos: Number of nano (10^-9) units of the amount. The value must be between
	// -999,999,999 and +999,999,999 inclusive. If `units` is positive, `nanos`
	// must be positive or zero. If `units` is zero, `nanos` can be positive, zero,
	// or negative. If `units` is negative, `nanos` must be negative or zero. For
	// example $-1.75 is represented as `units`=-1 and `nanos`=-750,000,000.
	Nanos int64 `json:"nanos,omitempty"`
	// Units: The whole units of the amount. For example if `currencyCode` is
	// "USD", then 1 unit is one US dollar.
	Units int64 `json:"units,omitempty,string"`
	// ForceSendFields is a list of field names (e.g. "CurrencyCode") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CurrencyCode") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleTypeMoney) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleTypeMoney
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleTypePostalAddress: Represents a postal address, e.g. for postal
// delivery or payments addresses. Given a postal address, a postal service can
// deliver items to a premise, P.O. Box or similar. It is not intended to model
// geographical locations (roads, towns, mountains). In typical usage an
// address would be created via user input or from importing existing data,
// depending on the type of process. Advice on address input / editing: - Use
// an internationalization-ready address widget such as
// https://github.com/google/libaddressinput) - Users should not be presented
// with UI elements for input or editing of fields outside countries where that
// field is used. For more guidance on how to use this schema, please see:
// https://support.google.com/business/answer/6397478
type GoogleTypePostalAddress struct {
	// AddressLines: Unstructured address lines describing the lower levels of an
	// address. Because values in address_lines do not have type information and
	// may sometimes contain multiple values in a single field (e.g. "Austin, TX"),
	// it is important that the line order is clear. The order of address lines
	// should be "envelope order" for the country/region of the address. In places
	// where this can vary (e.g. Japan), address_language is used to make it
	// explicit (e.g. "ja" for large-to-small ordering and "ja-Latn" or "en" for
	// small-to-large). This way, the most specific line of an address can be
	// selected based on the language. The minimum permitted structural
	// representation of an address consists of a region_code with all remaining
	// information placed in the address_lines. It would be possible to format such
	// an address very approximately without geocoding, but no semantic reasoning
	// could be made about any of the address components until it was at least
	// partially resolved. Creating an address only containing a region_code and
	// address_lines, and then geocoding is the recommended way to handle
	// completely unstructured addresses (as opposed to guessing which parts of the
	// address should be localities or administrative areas).
	AddressLines []string `json:"addressLines,omitempty"`
	// AdministrativeArea: Optional. Highest administrative subdivision which is
	// used for postal addresses of a country or region. For example, this can be a
	// state, a province, an oblast, or a prefecture. Specifically, for Spain this
	// is the province and not the autonomous community (e.g. "Barcelona" and not
	// "Catalonia"). Many countries don't use an administrative area in postal
	// addresses. E.g. in Switzerland this should be left unpopulated.
	AdministrativeArea string `json:"administrativeArea,omitempty"`
	// LanguageCode: Optional. BCP-47 language code of the contents of this address
	// (if known). This is often the UI language of the input form or is expected
	// to match one of the languages used in the address' country/region, or their
	// transliterated equivalents. This can affect formatting in certain countries,
	// but is not critical to the correctness of the data and will never affect any
	// validation or other non-formatting related operations. If this value is not
	// known, it should be omitted (rather than specifying a possibly incorrect
	// default). Examples: "zh-Hant", "ja", "ja-Latn", "en".
	LanguageCode string `json:"languageCode,omitempty"`
	// Locality: Optional. Generally refers to the city/town portion of the
	// address. Examples: US city, IT comune, UK post town. In regions of the world
	// where localities are not well defined or do not fit into this structure
	// well, leave locality empty and use address_lines.
	Locality string `json:"locality,omitempty"`
	// Organization: Optional. The name of the organization at the address.
	Organization string `json:"organization,omitempty"`
	// PostalCode: Optional. Postal code of the address. Not all countries use or
	// require postal codes to be present, but where they are used, they may
	// trigger additional validation with other parts of the address (e.g.
	// state/zip validation in the U.S.A.).
	PostalCode string `json:"postalCode,omitempty"`
	// Recipients: Optional. The recipient at the address. This field may, under
	// certain circumstances, contain multiline information. For example, it might
	// contain "care of" information.
	Recipients []string `json:"recipients,omitempty"`
	// RegionCode: Required. CLDR region code of the country/region of the address.
	// This is never inferred and it is up to the user to ensure the value is
	// correct. See https://cldr.unicode.org/ and
	// https://www.unicode.org/cldr/charts/30/supplemental/territory_information.html
	// for details. Example: "CH" for Switzerland.
	RegionCode string `json:"regionCode,omitempty"`
	// Revision: The schema revision of the `PostalAddress`. This must be set to 0,
	// which is the latest revision. All new revisions **must** be backward
	// compatible with old revisions.
	Revision int64 `json:"revision,omitempty"`
	// SortingCode: Optional. Additional, country-specific, sorting code. This is
	// not used in most regions. Where it is used, the value is either a string
	// like "CEDEX", optionally followed by a number (e.g. "CEDEX 7"), or just a
	// number alone, representing the "sector code" (Jamaica), "delivery area
	// indicator" (Malawi) or "post office indicator" (e.g. Côte d'Ivoire).
	SortingCode string `json:"sortingCode,omitempty"`
	// Sublocality: Optional. Sublocality of the address. For example, this can be
	// neighborhoods, boroughs, districts.
	Sublocality string `json:"sublocality,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AddressLines") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AddressLines") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleTypePostalAddress) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleTypePostalAddress
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleTypeTimeZone: Represents a time zone from the IANA Time Zone Database
// (https://www.iana.org/time-zones).
type GoogleTypeTimeZone struct {
	// Id: IANA Time Zone Database time zone, e.g. "America/New_York".
	Id string `json:"id,omitempty"`
	// Version: Optional. IANA Time Zone Database version number, e.g. "2019a".
	Version string `json:"version,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Id") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Id") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleTypeTimeZone) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleTypeTimeZone
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type ProjectsFetchAclCall struct {
	s                                            *Service
	resource                                     string
	googlecloudcontentwarehousev1fetchaclrequest *GoogleCloudContentwarehouseV1FetchAclRequest
	urlParams_                                   gensupport.URLParams
	ctx_                                         context.Context
	header_                                      http.Header
}

// FetchAcl: Gets the access control policy for a resource. Returns NOT_FOUND
// error if the resource does not exist. Returns an empty policy if the
// resource exists but does not have a policy set.
//
//   - resource: REQUIRED: The resource for which the policy is being requested.
//     Format for document:
//     projects/{project_number}/locations/{location}/documents/{document_id}.
//     Format for collection:
//     projects/{project_number}/locations/{location}/collections/{collection_id}.
//     Format for project: projects/{project_number}.
func (r *ProjectsService) FetchAcl(resource string, googlecloudcontentwarehousev1fetchaclrequest *GoogleCloudContentwarehouseV1FetchAclRequest) *ProjectsFetchAclCall {
	c := &ProjectsFetchAclCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.resource = resource
	c.googlecloudcontentwarehousev1fetchaclrequest = googlecloudcontentwarehousev1fetchaclrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsFetchAclCall) Fields(s ...googleapi.Field) *ProjectsFetchAclCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsFetchAclCall) Context(ctx context.Context) *ProjectsFetchAclCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsFetchAclCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsFetchAclCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googlecloudcontentwarehousev1fetchaclrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+resource}:fetchAcl")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"resource": c.resource,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "contentwarehouse.projects.fetchAcl" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudContentwarehouseV1FetchAclResponse.ServerResponse.Header or (if
// a response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsFetchAclCall) Do(opts ...googleapi.CallOption) (*GoogleCloudContentwarehouseV1FetchAclResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudContentwarehouseV1FetchAclResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ProjectsSetAclCall struct {
	s                                          *Service
	resource                                   string
	googlecloudcontentwarehousev1setaclrequest *GoogleCloudContentwarehouseV1SetAclRequest
	urlParams_                                 gensupport.URLParams
	ctx_                                       context.Context
	header_                                    http.Header
}

// SetAcl: Sets the access control policy for a resource. Replaces any existing
// policy.
//
//   - resource: REQUIRED: The resource for which the policy is being requested.
//     Format for document:
//     projects/{project_number}/locations/{location}/documents/{document_id}.
//     Format for collection:
//     projects/{project_number}/locations/{location}/collections/{collection_id}.
//     Format for project: projects/{project_number}.
func (r *ProjectsService) SetAcl(resource string, googlecloudcontentwarehousev1setaclrequest *GoogleCloudContentwarehouseV1SetAclRequest) *ProjectsSetAclCall {
	c := &ProjectsSetAclCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.resource = resource
	c.googlecloudcontentwarehousev1setaclrequest = googlecloudcontentwarehousev1setaclrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsSetAclCall) Fields(s ...googleapi.Field) *ProjectsSetAclCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsSetAclCall) Context(ctx context.Context) *ProjectsSetAclCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsSetAclCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsSetAclCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googlecloudcontentwarehousev1setaclrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+resource}:setAcl")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"resource": c.resource,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "contentwarehouse.projects.setAcl" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudContentwarehouseV1SetAclResponse.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsSetAclCall) Do(opts ...googleapi.CallOption) (*GoogleCloudContentwarehouseV1SetAclResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudContentwarehouseV1SetAclResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ProjectsLocationsGetStatusCall struct {
	s            *Service
	location     string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// GetStatus: Get the project status.
//
//   - location: The location to be queried Format:
//     projects/{project_number}/locations/{location}.
func (r *ProjectsLocationsService) GetStatus(location string) *ProjectsLocationsGetStatusCall {
	c := &ProjectsLocationsGetStatusCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.location = location
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsGetStatusCall) Fields(s ...googleapi.Field) *ProjectsLocationsGetStatusCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsGetStatusCall) IfNoneMatch(entityTag string) *ProjectsLocationsGetStatusCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsGetStatusCall) Context(ctx context.Context) *ProjectsLocationsGetStatusCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsGetStatusCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsGetStatusCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+location}:getStatus")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"location": c.location,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "contentwarehouse.projects.locations.getStatus" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudContentwarehouseV1ProjectStatus.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsGetStatusCall) Do(opts ...googleapi.CallOption) (*GoogleCloudContentwarehouseV1ProjectStatus, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudContentwarehouseV1ProjectStatus{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ProjectsLocationsInitializeCall struct {
	s                                                     *Service
	location                                              string
	googlecloudcontentwarehousev1initializeprojectrequest *GoogleCloudContentwarehouseV1InitializeProjectRequest
	urlParams_                                            gensupport.URLParams
	ctx_                                                  context.Context
	header_                                               http.Header
}

// Initialize: Provisions resources for given tenant project. Returns a long
// running operation.
//
//   - location: The location to be initialized Format:
//     projects/{project_number}/locations/{location}.
func (r *ProjectsLocationsService) Initialize(location string, googlecloudcontentwarehousev1initializeprojectrequest *GoogleCloudContentwarehouseV1InitializeProjectRequest) *ProjectsLocationsInitializeCall {
	c := &ProjectsLocationsInitializeCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.location = location
	c.googlecloudcontentwarehousev1initializeprojectrequest = googlecloudcontentwarehousev1initializeprojectrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsInitializeCall) Fields(s ...googleapi.Field) *ProjectsLocationsInitializeCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsInitializeCall) Context(ctx context.Context) *ProjectsLocationsInitializeCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsInitializeCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsInitializeCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googlecloudcontentwarehousev1initializeprojectrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+location}:initialize")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"location": c.location,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "contentwarehouse.projects.locations.initialize" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleLongrunningOperation.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsInitializeCall) Do(opts ...googleapi.CallOption) (*GoogleLongrunningOperation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleLongrunningOperation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ProjectsLocationsRunPipelineCall struct {
	s                                               *Service
	name                                            string
	googlecloudcontentwarehousev1runpipelinerequest *GoogleCloudContentwarehouseV1RunPipelineRequest
	urlParams_                                      gensupport.URLParams
	ctx_                                            context.Context
	header_                                         http.Header
}

// RunPipeline: Run a predefined pipeline.
//
//   - name: The resource name which owns the resources of the pipeline. Format:
//     projects/{project_number}/locations/{location}.
func (r *ProjectsLocationsService) RunPipeline(name string, googlecloudcontentwarehousev1runpipelinerequest *GoogleCloudContentwarehouseV1RunPipelineRequest) *ProjectsLocationsRunPipelineCall {
	c := &ProjectsLocationsRunPipelineCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.googlecloudcontentwarehousev1runpipelinerequest = googlecloudcontentwarehousev1runpipelinerequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsRunPipelineCall) Fields(s ...googleapi.Field) *ProjectsLocationsRunPipelineCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsRunPipelineCall) Context(ctx context.Context) *ProjectsLocationsRunPipelineCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsRunPipelineCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsRunPipelineCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googlecloudcontentwarehousev1runpipelinerequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}:runPipeline")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "contentwarehouse.projects.locations.runPipeline" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleLongrunningOperation.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsRunPipelineCall) Do(opts ...googleapi.CallOption) (*GoogleLongrunningOperation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleLongrunningOperation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ProjectsLocationsDocumentSchemasCreateCall struct {
	s                                           *Service
	parent                                      string
	googlecloudcontentwarehousev1documentschema *GoogleCloudContentwarehouseV1DocumentSchema
	urlParams_                                  gensupport.URLParams
	ctx_                                        context.Context
	header_                                     http.Header
}

// Create: Creates a document schema.
//
// - parent: The parent name.
func (r *ProjectsLocationsDocumentSchemasService) Create(parent string, googlecloudcontentwarehousev1documentschema *GoogleCloudContentwarehouseV1DocumentSchema) *ProjectsLocationsDocumentSchemasCreateCall {
	c := &ProjectsLocationsDocumentSchemasCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.googlecloudcontentwarehousev1documentschema = googlecloudcontentwarehousev1documentschema
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsDocumentSchemasCreateCall) Fields(s ...googleapi.Field) *ProjectsLocationsDocumentSchemasCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsDocumentSchemasCreateCall) Context(ctx context.Context) *ProjectsLocationsDocumentSchemasCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsDocumentSchemasCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDocumentSchemasCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googlecloudcontentwarehousev1documentschema)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/documentSchemas")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "contentwarehouse.projects.locations.documentSchemas.create" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudContentwarehouseV1DocumentSchema.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsDocumentSchemasCreateCall) Do(opts ...googleapi.CallOption) (*GoogleCloudContentwarehouseV1DocumentSchema, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudContentwarehouseV1DocumentSchema{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ProjectsLocationsDocumentSchemasDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes a document schema. Returns NOT_FOUND if the document schema
// does not exist. Returns BAD_REQUEST if the document schema has documents
// depending on it.
//
// - name: The name of the document schema to delete.
func (r *ProjectsLocationsDocumentSchemasService) Delete(name string) *ProjectsLocationsDocumentSchemasDeleteCall {
	c := &ProjectsLocationsDocumentSchemasDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsDocumentSchemasDeleteCall) Fields(s ...googleapi.Field) *ProjectsLocationsDocumentSchemasDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsDocumentSchemasDeleteCall) Context(ctx context.Context) *ProjectsLocationsDocumentSchemasDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsDocumentSchemasDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDocumentSchemasDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "contentwarehouse.projects.locations.documentSchemas.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleProtobufEmpty.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsDocumentSchemasDeleteCall) Do(opts ...googleapi.CallOption) (*GoogleProtobufEmpty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleProtobufEmpty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ProjectsLocationsDocumentSchemasGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets a document schema. Returns NOT_FOUND if the document schema does
// not exist.
//
// - name: The name of the document schema to retrieve.
func (r *ProjectsLocationsDocumentSchemasService) Get(name string) *ProjectsLocationsDocumentSchemasGetCall {
	c := &ProjectsLocationsDocumentSchemasGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsDocumentSchemasGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsDocumentSchemasGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsDocumentSchemasGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsDocumentSchemasGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsDocumentSchemasGetCall) Context(ctx context.Context) *ProjectsLocationsDocumentSchemasGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsDocumentSchemasGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDocumentSchemasGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "contentwarehouse.projects.locations.documentSchemas.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudContentwarehouseV1DocumentSchema.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsDocumentSchemasGetCall) Do(opts ...googleapi.CallOption) (*GoogleCloudContentwarehouseV1DocumentSchema, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudContentwarehouseV1DocumentSchema{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ProjectsLocationsDocumentSchemasListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists document schemas.
//
//   - parent: The parent, which owns this collection of document schemas.
//     Format: projects/{project_number}/locations/{location}.
func (r *ProjectsLocationsDocumentSchemasService) List(parent string) *ProjectsLocationsDocumentSchemasListCall {
	c := &ProjectsLocationsDocumentSchemasListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number of
// document schemas to return. The service may return fewer than this value. If
// unspecified, at most 50 document schemas will be returned. The maximum value
// is 1000; values above 1000 will be coerced to 1000.
func (c *ProjectsLocationsDocumentSchemasListCall) PageSize(pageSize int64) *ProjectsLocationsDocumentSchemasListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": A page token, received
// from a previous `ListDocumentSchemas` call. Provide this to retrieve the
// subsequent page. When paginating, all other parameters provided to
// `ListDocumentSchemas` must match the call that provided the page token.
func (c *ProjectsLocationsDocumentSchemasListCall) PageToken(pageToken string) *ProjectsLocationsDocumentSchemasListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsDocumentSchemasListCall) Fields(s ...googleapi.Field) *ProjectsLocationsDocumentSchemasListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsDocumentSchemasListCall) IfNoneMatch(entityTag string) *ProjectsLocationsDocumentSchemasListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsDocumentSchemasListCall) Context(ctx context.Context) *ProjectsLocationsDocumentSchemasListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsDocumentSchemasListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDocumentSchemasListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/documentSchemas")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "contentwarehouse.projects.locations.documentSchemas.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudContentwarehouseV1ListDocumentSchemasResponse.ServerResponse.Head
// er or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsDocumentSchemasListCall) Do(opts ...googleapi.CallOption) (*GoogleCloudContentwarehouseV1ListDocumentSchemasResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudContentwarehouseV1ListDocumentSchemasResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsDocumentSchemasListCall) Pages(ctx context.Context, f func(*GoogleCloudContentwarehouseV1ListDocumentSchemasResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type ProjectsLocationsDocumentSchemasPatchCall struct {
	s                                                        *Service
	name                                                     string
	googlecloudcontentwarehousev1updatedocumentschemarequest *GoogleCloudContentwarehouseV1UpdateDocumentSchemaRequest
	urlParams_                                               gensupport.URLParams
	ctx_                                                     context.Context
	header_                                                  http.Header
}

// Patch: Updates a Document Schema. Returns INVALID_ARGUMENT if the name of
// the Document Schema is non-empty and does not equal the existing name.
// Supports only appending new properties, adding new ENUM possible values, and
// updating the EnumTypeOptions.validation_check_disabled flag for ENUM
// possible values. Updating existing properties will result into
// INVALID_ARGUMENT.
//
//   - name: The name of the document schema to update. Format:
//     projects/{project_number}/locations/{location}/documentSchemas/{document_sc
//     hema_id}.
func (r *ProjectsLocationsDocumentSchemasService) Patch(name string, googlecloudcontentwarehousev1updatedocumentschemarequest *GoogleCloudContentwarehouseV1UpdateDocumentSchemaRequest) *ProjectsLocationsDocumentSchemasPatchCall {
	c := &ProjectsLocationsDocumentSchemasPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.googlecloudcontentwarehousev1updatedocumentschemarequest = googlecloudcontentwarehousev1updatedocumentschemarequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsDocumentSchemasPatchCall) Fields(s ...googleapi.Field) *ProjectsLocationsDocumentSchemasPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsDocumentSchemasPatchCall) Context(ctx context.Context) *ProjectsLocationsDocumentSchemasPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsDocumentSchemasPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDocumentSchemasPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googlecloudcontentwarehousev1updatedocumentschemarequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "contentwarehouse.projects.locations.documentSchemas.patch" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudContentwarehouseV1DocumentSchema.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsDocumentSchemasPatchCall) Do(opts ...googleapi.CallOption) (*GoogleCloudContentwarehouseV1DocumentSchema, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudContentwarehouseV1DocumentSchema{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ProjectsLocationsDocumentsCreateCall struct {
	s                                                  *Service
	parent                                             string
	googlecloudcontentwarehousev1createdocumentrequest *GoogleCloudContentwarehouseV1CreateDocumentRequest
	urlParams_                                         gensupport.URLParams
	ctx_                                               context.Context
	header_                                            http.Header
}

// Create: Creates a document.
//
//   - parent: The parent name. Format:
//     projects/{project_number}/locations/{location}.
func (r *ProjectsLocationsDocumentsService) Create(parent string, googlecloudcontentwarehousev1createdocumentrequest *GoogleCloudContentwarehouseV1CreateDocumentRequest) *ProjectsLocationsDocumentsCreateCall {
	c := &ProjectsLocationsDocumentsCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.googlecloudcontentwarehousev1createdocumentrequest = googlecloudcontentwarehousev1createdocumentrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsDocumentsCreateCall) Fields(s ...googleapi.Field) *ProjectsLocationsDocumentsCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsDocumentsCreateCall) Context(ctx context.Context) *ProjectsLocationsDocumentsCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsDocumentsCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDocumentsCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googlecloudcontentwarehousev1createdocumentrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/documents")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "contentwarehouse.projects.locations.documents.create" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudContentwarehouseV1CreateDocumentResponse.ServerResponse.Header
// or (if a response was returned at all) in error.(*googleapi.Error).Header.
// Use googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsDocumentsCreateCall) Do(opts ...googleapi.CallOption) (*GoogleCloudContentwarehouseV1CreateDocumentResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudContentwarehouseV1CreateDocumentResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ProjectsLocationsDocumentsDeleteCall struct {
	s                                                  *Service
	name                                               string
	googlecloudcontentwarehousev1deletedocumentrequest *GoogleCloudContentwarehouseV1DeleteDocumentRequest
	urlParams_                                         gensupport.URLParams
	ctx_                                               context.Context
	header_                                            http.Header
}

// Delete: Deletes a document. Returns NOT_FOUND if the document does not
// exist.
//
//   - name: The name of the document to delete. Format:
//     projects/{project_number}/locations/{location}/documents/{document_id} or
//     projects/{project_number}/locations/{location}/documents/referenceId/{refer
//     ence_id}.
func (r *ProjectsLocationsDocumentsService) Delete(name string, googlecloudcontentwarehousev1deletedocumentrequest *GoogleCloudContentwarehouseV1DeleteDocumentRequest) *ProjectsLocationsDocumentsDeleteCall {
	c := &ProjectsLocationsDocumentsDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.googlecloudcontentwarehousev1deletedocumentrequest = googlecloudcontentwarehousev1deletedocumentrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsDocumentsDeleteCall) Fields(s ...googleapi.Field) *ProjectsLocationsDocumentsDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsDocumentsDeleteCall) Context(ctx context.Context) *ProjectsLocationsDocumentsDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsDocumentsDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDocumentsDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googlecloudcontentwarehousev1deletedocumentrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}:delete")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "contentwarehouse.projects.locations.documents.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleProtobufEmpty.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsDocumentsDeleteCall) Do(opts ...googleapi.CallOption) (*GoogleProtobufEmpty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleProtobufEmpty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ProjectsLocationsDocumentsFetchAclCall struct {
	s                                            *Service
	resource                                     string
	googlecloudcontentwarehousev1fetchaclrequest *GoogleCloudContentwarehouseV1FetchAclRequest
	urlParams_                                   gensupport.URLParams
	ctx_                                         context.Context
	header_                                      http.Header
}

// FetchAcl: Gets the access control policy for a resource. Returns NOT_FOUND
// error if the resource does not exist. Returns an empty policy if the
// resource exists but does not have a policy set.
//
//   - resource: REQUIRED: The resource for which the policy is being requested.
//     Format for document:
//     projects/{project_number}/locations/{location}/documents/{document_id}.
//     Format for collection:
//     projects/{project_number}/locations/{location}/collections/{collection_id}.
//     Format for project: projects/{project_number}.
func (r *ProjectsLocationsDocumentsService) FetchAcl(resource string, googlecloudcontentwarehousev1fetchaclrequest *GoogleCloudContentwarehouseV1FetchAclRequest) *ProjectsLocationsDocumentsFetchAclCall {
	c := &ProjectsLocationsDocumentsFetchAclCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.resource = resource
	c.googlecloudcontentwarehousev1fetchaclrequest = googlecloudcontentwarehousev1fetchaclrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsDocumentsFetchAclCall) Fields(s ...googleapi.Field) *ProjectsLocationsDocumentsFetchAclCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsDocumentsFetchAclCall) Context(ctx context.Context) *ProjectsLocationsDocumentsFetchAclCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsDocumentsFetchAclCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDocumentsFetchAclCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googlecloudcontentwarehousev1fetchaclrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+resource}:fetchAcl")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"resource": c.resource,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "contentwarehouse.projects.locations.documents.fetchAcl" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudContentwarehouseV1FetchAclResponse.ServerResponse.Header or (if
// a response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsDocumentsFetchAclCall) Do(opts ...googleapi.CallOption) (*GoogleCloudContentwarehouseV1FetchAclResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudContentwarehouseV1FetchAclResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ProjectsLocationsDocumentsGetCall struct {
	s                                               *Service
	name                                            string
	googlecloudcontentwarehousev1getdocumentrequest *GoogleCloudContentwarehouseV1GetDocumentRequest
	urlParams_                                      gensupport.URLParams
	ctx_                                            context.Context
	header_                                         http.Header
}

// Get: Gets a document. Returns NOT_FOUND if the document does not exist.
//
//   - name: The name of the document to retrieve. Format:
//     projects/{project_number}/locations/{location}/documents/{document_id} or
//     projects/{project_number}/locations/{location}/documents/referenceId/{refer
//     ence_id}.
func (r *ProjectsLocationsDocumentsService) Get(name string, googlecloudcontentwarehousev1getdocumentrequest *GoogleCloudContentwarehouseV1GetDocumentRequest) *ProjectsLocationsDocumentsGetCall {
	c := &ProjectsLocationsDocumentsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.googlecloudcontentwarehousev1getdocumentrequest = googlecloudcontentwarehousev1getdocumentrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsDocumentsGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsDocumentsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsDocumentsGetCall) Context(ctx context.Context) *ProjectsLocationsDocumentsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsDocumentsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDocumentsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googlecloudcontentwarehousev1getdocumentrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}:get")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "contentwarehouse.projects.locations.documents.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudContentwarehouseV1Document.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsDocumentsGetCall) Do(opts ...googleapi.CallOption) (*GoogleCloudContentwarehouseV1Document, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudContentwarehouseV1Document{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ProjectsLocationsDocumentsLinkedSourcesCall struct {
	s                                                     *Service
	parent                                                string
	googlecloudcontentwarehousev1listlinkedsourcesrequest *GoogleCloudContentwarehouseV1ListLinkedSourcesRequest
	urlParams_                                            gensupport.URLParams
	ctx_                                                  context.Context
	header_                                               http.Header
}

// LinkedSources: Return all source document-links from the document.
//
//   - parent: The name of the document, for which all source links are returned.
//     Format:
//     projects/{project_number}/locations/{location}/documents/{source_document_i
//     d}.
func (r *ProjectsLocationsDocumentsService) LinkedSources(parent string, googlecloudcontentwarehousev1listlinkedsourcesrequest *GoogleCloudContentwarehouseV1ListLinkedSourcesRequest) *ProjectsLocationsDocumentsLinkedSourcesCall {
	c := &ProjectsLocationsDocumentsLinkedSourcesCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.googlecloudcontentwarehousev1listlinkedsourcesrequest = googlecloudcontentwarehousev1listlinkedsourcesrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsDocumentsLinkedSourcesCall) Fields(s ...googleapi.Field) *ProjectsLocationsDocumentsLinkedSourcesCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsDocumentsLinkedSourcesCall) Context(ctx context.Context) *ProjectsLocationsDocumentsLinkedSourcesCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsDocumentsLinkedSourcesCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDocumentsLinkedSourcesCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googlecloudcontentwarehousev1listlinkedsourcesrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/linkedSources")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "contentwarehouse.projects.locations.documents.linkedSources" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudContentwarehouseV1ListLinkedSourcesResponse.ServerResponse.Header
//
//	or (if a response was returned at all) in error.(*googleapi.Error).Header.
//
// Use googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsDocumentsLinkedSourcesCall) Do(opts ...googleapi.CallOption) (*GoogleCloudContentwarehouseV1ListLinkedSourcesResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudContentwarehouseV1ListLinkedSourcesResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsDocumentsLinkedSourcesCall) Pages(ctx context.Context, f func(*GoogleCloudContentwarehouseV1ListLinkedSourcesResponse) error) error {
	c.ctx_ = ctx
	defer func(pt string) { c.googlecloudcontentwarehousev1listlinkedsourcesrequest.PageToken = pt }(c.googlecloudcontentwarehousev1listlinkedsourcesrequest.PageToken)
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.googlecloudcontentwarehousev1listlinkedsourcesrequest.PageToken = x.NextPageToken
	}
}

type ProjectsLocationsDocumentsLinkedTargetsCall struct {
	s                                                     *Service
	parent                                                string
	googlecloudcontentwarehousev1listlinkedtargetsrequest *GoogleCloudContentwarehouseV1ListLinkedTargetsRequest
	urlParams_                                            gensupport.URLParams
	ctx_                                                  context.Context
	header_                                               http.Header
}

// LinkedTargets: Return all target document-links from the document.
//
//   - parent: The name of the document, for which all target links are returned.
//     Format:
//     projects/{project_number}/locations/{location}/documents/{target_document_i
//     d}.
func (r *ProjectsLocationsDocumentsService) LinkedTargets(parent string, googlecloudcontentwarehousev1listlinkedtargetsrequest *GoogleCloudContentwarehouseV1ListLinkedTargetsRequest) *ProjectsLocationsDocumentsLinkedTargetsCall {
	c := &ProjectsLocationsDocumentsLinkedTargetsCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.googlecloudcontentwarehousev1listlinkedtargetsrequest = googlecloudcontentwarehousev1listlinkedtargetsrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsDocumentsLinkedTargetsCall) Fields(s ...googleapi.Field) *ProjectsLocationsDocumentsLinkedTargetsCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsDocumentsLinkedTargetsCall) Context(ctx context.Context) *ProjectsLocationsDocumentsLinkedTargetsCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsDocumentsLinkedTargetsCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDocumentsLinkedTargetsCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googlecloudcontentwarehousev1listlinkedtargetsrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/linkedTargets")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "contentwarehouse.projects.locations.documents.linkedTargets" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudContentwarehouseV1ListLinkedTargetsResponse.ServerResponse.Header
//
//	or (if a response was returned at all) in error.(*googleapi.Error).Header.
//
// Use googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsDocumentsLinkedTargetsCall) Do(opts ...googleapi.CallOption) (*GoogleCloudContentwarehouseV1ListLinkedTargetsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudContentwarehouseV1ListLinkedTargetsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ProjectsLocationsDocumentsLockCall struct {
	s                                                *Service
	name                                             string
	googlecloudcontentwarehousev1lockdocumentrequest *GoogleCloudContentwarehouseV1LockDocumentRequest
	urlParams_                                       gensupport.URLParams
	ctx_                                             context.Context
	header_                                          http.Header
}

// Lock: Lock the document so the document cannot be updated by other users.
//
//   - name: The name of the document to lock. Format:
//     projects/{project_number}/locations/{location}/documents/{document}.
func (r *ProjectsLocationsDocumentsService) Lock(name string, googlecloudcontentwarehousev1lockdocumentrequest *GoogleCloudContentwarehouseV1LockDocumentRequest) *ProjectsLocationsDocumentsLockCall {
	c := &ProjectsLocationsDocumentsLockCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.googlecloudcontentwarehousev1lockdocumentrequest = googlecloudcontentwarehousev1lockdocumentrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsDocumentsLockCall) Fields(s ...googleapi.Field) *ProjectsLocationsDocumentsLockCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsDocumentsLockCall) Context(ctx context.Context) *ProjectsLocationsDocumentsLockCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsDocumentsLockCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDocumentsLockCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googlecloudcontentwarehousev1lockdocumentrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}:lock")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "contentwarehouse.projects.locations.documents.lock" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudContentwarehouseV1Document.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsDocumentsLockCall) Do(opts ...googleapi.CallOption) (*GoogleCloudContentwarehouseV1Document, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudContentwarehouseV1Document{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ProjectsLocationsDocumentsPatchCall struct {
	s                                                  *Service
	name                                               string
	googlecloudcontentwarehousev1updatedocumentrequest *GoogleCloudContentwarehouseV1UpdateDocumentRequest
	urlParams_                                         gensupport.URLParams
	ctx_                                               context.Context
	header_                                            http.Header
}

// Patch: Updates a document. Returns INVALID_ARGUMENT if the name of the
// document is non-empty and does not equal the existing name.
//
//   - name: The name of the document to update. Format:
//     projects/{project_number}/locations/{location}/documents/{document_id} or
//     projects/{project_number}/locations/{location}/documents/referenceId/{refer
//     ence_id}.
func (r *ProjectsLocationsDocumentsService) Patch(name string, googlecloudcontentwarehousev1updatedocumentrequest *GoogleCloudContentwarehouseV1UpdateDocumentRequest) *ProjectsLocationsDocumentsPatchCall {
	c := &ProjectsLocationsDocumentsPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.googlecloudcontentwarehousev1updatedocumentrequest = googlecloudcontentwarehousev1updatedocumentrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsDocumentsPatchCall) Fields(s ...googleapi.Field) *ProjectsLocationsDocumentsPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsDocumentsPatchCall) Context(ctx context.Context) *ProjectsLocationsDocumentsPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsDocumentsPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDocumentsPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googlecloudcontentwarehousev1updatedocumentrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "contentwarehouse.projects.locations.documents.patch" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudContentwarehouseV1UpdateDocumentResponse.ServerResponse.Header
// or (if a response was returned at all) in error.(*googleapi.Error).Header.
// Use googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsDocumentsPatchCall) Do(opts ...googleapi.CallOption) (*GoogleCloudContentwarehouseV1UpdateDocumentResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudContentwarehouseV1UpdateDocumentResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ProjectsLocationsDocumentsSearchCall struct {
	s                                                   *Service
	parent                                              string
	googlecloudcontentwarehousev1searchdocumentsrequest *GoogleCloudContentwarehouseV1SearchDocumentsRequest
	urlParams_                                          gensupport.URLParams
	ctx_                                                context.Context
	header_                                             http.Header
}

// Search: Searches for documents using provided SearchDocumentsRequest. This
// call only returns documents that the caller has permission to search
// against.
//
//   - parent: The parent, which owns this collection of documents. Format:
//     projects/{project_number}/locations/{location}.
func (r *ProjectsLocationsDocumentsService) Search(parent string, googlecloudcontentwarehousev1searchdocumentsrequest *GoogleCloudContentwarehouseV1SearchDocumentsRequest) *ProjectsLocationsDocumentsSearchCall {
	c := &ProjectsLocationsDocumentsSearchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.googlecloudcontentwarehousev1searchdocumentsrequest = googlecloudcontentwarehousev1searchdocumentsrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsDocumentsSearchCall) Fields(s ...googleapi.Field) *ProjectsLocationsDocumentsSearchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsDocumentsSearchCall) Context(ctx context.Context) *ProjectsLocationsDocumentsSearchCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsDocumentsSearchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDocumentsSearchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googlecloudcontentwarehousev1searchdocumentsrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/documents:search")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "contentwarehouse.projects.locations.documents.search" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudContentwarehouseV1SearchDocumentsResponse.ServerResponse.Header
// or (if a response was returned at all) in error.(*googleapi.Error).Header.
// Use googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsDocumentsSearchCall) Do(opts ...googleapi.CallOption) (*GoogleCloudContentwarehouseV1SearchDocumentsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudContentwarehouseV1SearchDocumentsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsDocumentsSearchCall) Pages(ctx context.Context, f func(*GoogleCloudContentwarehouseV1SearchDocumentsResponse) error) error {
	c.ctx_ = ctx
	defer func(pt string) { c.googlecloudcontentwarehousev1searchdocumentsrequest.PageToken = pt }(c.googlecloudcontentwarehousev1searchdocumentsrequest.PageToken)
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.googlecloudcontentwarehousev1searchdocumentsrequest.PageToken = x.NextPageToken
	}
}

type ProjectsLocationsDocumentsSetAclCall struct {
	s                                          *Service
	resource                                   string
	googlecloudcontentwarehousev1setaclrequest *GoogleCloudContentwarehouseV1SetAclRequest
	urlParams_                                 gensupport.URLParams
	ctx_                                       context.Context
	header_                                    http.Header
}

// SetAcl: Sets the access control policy for a resource. Replaces any existing
// policy.
//
//   - resource: REQUIRED: The resource for which the policy is being requested.
//     Format for document:
//     projects/{project_number}/locations/{location}/documents/{document_id}.
//     Format for collection:
//     projects/{project_number}/locations/{location}/collections/{collection_id}.
//     Format for project: projects/{project_number}.
func (r *ProjectsLocationsDocumentsService) SetAcl(resource string, googlecloudcontentwarehousev1setaclrequest *GoogleCloudContentwarehouseV1SetAclRequest) *ProjectsLocationsDocumentsSetAclCall {
	c := &ProjectsLocationsDocumentsSetAclCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.resource = resource
	c.googlecloudcontentwarehousev1setaclrequest = googlecloudcontentwarehousev1setaclrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsDocumentsSetAclCall) Fields(s ...googleapi.Field) *ProjectsLocationsDocumentsSetAclCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsDocumentsSetAclCall) Context(ctx context.Context) *ProjectsLocationsDocumentsSetAclCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsDocumentsSetAclCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDocumentsSetAclCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googlecloudcontentwarehousev1setaclrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+resource}:setAcl")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"resource": c.resource,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "contentwarehouse.projects.locations.documents.setAcl" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudContentwarehouseV1SetAclResponse.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsDocumentsSetAclCall) Do(opts ...googleapi.CallOption) (*GoogleCloudContentwarehouseV1SetAclResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudContentwarehouseV1SetAclResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ProjectsLocationsDocumentsDocumentLinksCreateCall struct {
	s                                                      *Service
	parent                                                 string
	googlecloudcontentwarehousev1createdocumentlinkrequest *GoogleCloudContentwarehouseV1CreateDocumentLinkRequest
	urlParams_                                             gensupport.URLParams
	ctx_                                                   context.Context
	header_                                                http.Header
}

// Create: Create a link between a source document and a target document.
//
//   - parent: Parent of the document-link to be created. parent of document-link
//     should be a document. Format:
//     projects/{project_number}/locations/{location}/documents/{source_document_i
//     d}.
func (r *ProjectsLocationsDocumentsDocumentLinksService) Create(parent string, googlecloudcontentwarehousev1createdocumentlinkrequest *GoogleCloudContentwarehouseV1CreateDocumentLinkRequest) *ProjectsLocationsDocumentsDocumentLinksCreateCall {
	c := &ProjectsLocationsDocumentsDocumentLinksCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.googlecloudcontentwarehousev1createdocumentlinkrequest = googlecloudcontentwarehousev1createdocumentlinkrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsDocumentsDocumentLinksCreateCall) Fields(s ...googleapi.Field) *ProjectsLocationsDocumentsDocumentLinksCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsDocumentsDocumentLinksCreateCall) Context(ctx context.Context) *ProjectsLocationsDocumentsDocumentLinksCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsDocumentsDocumentLinksCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDocumentsDocumentLinksCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googlecloudcontentwarehousev1createdocumentlinkrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/documentLinks")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "contentwarehouse.projects.locations.documents.documentLinks.create" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudContentwarehouseV1DocumentLink.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsDocumentsDocumentLinksCreateCall) Do(opts ...googleapi.CallOption) (*GoogleCloudContentwarehouseV1DocumentLink, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudContentwarehouseV1DocumentLink{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ProjectsLocationsDocumentsDocumentLinksDeleteCall struct {
	s                                                      *Service
	name                                                   string
	googlecloudcontentwarehousev1deletedocumentlinkrequest *GoogleCloudContentwarehouseV1DeleteDocumentLinkRequest
	urlParams_                                             gensupport.URLParams
	ctx_                                                   context.Context
	header_                                                http.Header
}

// Delete: Remove the link between the source and target documents.
//
//   - name: The name of the document-link to be deleted. Format:
//     projects/{project_number}/locations/{location}/documents/{source_document_i
//     d}/documentLinks/{document_link_id}.
func (r *ProjectsLocationsDocumentsDocumentLinksService) Delete(name string, googlecloudcontentwarehousev1deletedocumentlinkrequest *GoogleCloudContentwarehouseV1DeleteDocumentLinkRequest) *ProjectsLocationsDocumentsDocumentLinksDeleteCall {
	c := &ProjectsLocationsDocumentsDocumentLinksDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.googlecloudcontentwarehousev1deletedocumentlinkrequest = googlecloudcontentwarehousev1deletedocumentlinkrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsDocumentsDocumentLinksDeleteCall) Fields(s ...googleapi.Field) *ProjectsLocationsDocumentsDocumentLinksDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsDocumentsDocumentLinksDeleteCall) Context(ctx context.Context) *ProjectsLocationsDocumentsDocumentLinksDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsDocumentsDocumentLinksDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDocumentsDocumentLinksDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googlecloudcontentwarehousev1deletedocumentlinkrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}:delete")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "contentwarehouse.projects.locations.documents.documentLinks.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleProtobufEmpty.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsDocumentsDocumentLinksDeleteCall) Do(opts ...googleapi.CallOption) (*GoogleProtobufEmpty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleProtobufEmpty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ProjectsLocationsDocumentsReferenceIdDeleteCall struct {
	s                                                  *Service
	name                                               string
	googlecloudcontentwarehousev1deletedocumentrequest *GoogleCloudContentwarehouseV1DeleteDocumentRequest
	urlParams_                                         gensupport.URLParams
	ctx_                                               context.Context
	header_                                            http.Header
}

// Delete: Deletes a document. Returns NOT_FOUND if the document does not
// exist.
//
//   - name: The name of the document to delete. Format:
//     projects/{project_number}/locations/{location}/documents/{document_id} or
//     projects/{project_number}/locations/{location}/documents/referenceId/{refer
//     ence_id}.
func (r *ProjectsLocationsDocumentsReferenceIdService) Delete(name string, googlecloudcontentwarehousev1deletedocumentrequest *GoogleCloudContentwarehouseV1DeleteDocumentRequest) *ProjectsLocationsDocumentsReferenceIdDeleteCall {
	c := &ProjectsLocationsDocumentsReferenceIdDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.googlecloudcontentwarehousev1deletedocumentrequest = googlecloudcontentwarehousev1deletedocumentrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsDocumentsReferenceIdDeleteCall) Fields(s ...googleapi.Field) *ProjectsLocationsDocumentsReferenceIdDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsDocumentsReferenceIdDeleteCall) Context(ctx context.Context) *ProjectsLocationsDocumentsReferenceIdDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsDocumentsReferenceIdDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDocumentsReferenceIdDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googlecloudcontentwarehousev1deletedocumentrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}:delete")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "contentwarehouse.projects.locations.documents.referenceId.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleProtobufEmpty.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsDocumentsReferenceIdDeleteCall) Do(opts ...googleapi.CallOption) (*GoogleProtobufEmpty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleProtobufEmpty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ProjectsLocationsDocumentsReferenceIdGetCall struct {
	s                                               *Service
	name                                            string
	googlecloudcontentwarehousev1getdocumentrequest *GoogleCloudContentwarehouseV1GetDocumentRequest
	urlParams_                                      gensupport.URLParams
	ctx_                                            context.Context
	header_                                         http.Header
}

// Get: Gets a document. Returns NOT_FOUND if the document does not exist.
//
//   - name: The name of the document to retrieve. Format:
//     projects/{project_number}/locations/{location}/documents/{document_id} or
//     projects/{project_number}/locations/{location}/documents/referenceId/{refer
//     ence_id}.
func (r *ProjectsLocationsDocumentsReferenceIdService) Get(name string, googlecloudcontentwarehousev1getdocumentrequest *GoogleCloudContentwarehouseV1GetDocumentRequest) *ProjectsLocationsDocumentsReferenceIdGetCall {
	c := &ProjectsLocationsDocumentsReferenceIdGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.googlecloudcontentwarehousev1getdocumentrequest = googlecloudcontentwarehousev1getdocumentrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsDocumentsReferenceIdGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsDocumentsReferenceIdGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsDocumentsReferenceIdGetCall) Context(ctx context.Context) *ProjectsLocationsDocumentsReferenceIdGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsDocumentsReferenceIdGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDocumentsReferenceIdGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googlecloudcontentwarehousev1getdocumentrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}:get")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "contentwarehouse.projects.locations.documents.referenceId.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudContentwarehouseV1Document.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsDocumentsReferenceIdGetCall) Do(opts ...googleapi.CallOption) (*GoogleCloudContentwarehouseV1Document, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudContentwarehouseV1Document{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ProjectsLocationsDocumentsReferenceIdPatchCall struct {
	s                                                  *Service
	name                                               string
	googlecloudcontentwarehousev1updatedocumentrequest *GoogleCloudContentwarehouseV1UpdateDocumentRequest
	urlParams_                                         gensupport.URLParams
	ctx_                                               context.Context
	header_                                            http.Header
}

// Patch: Updates a document. Returns INVALID_ARGUMENT if the name of the
// document is non-empty and does not equal the existing name.
//
//   - name: The name of the document to update. Format:
//     projects/{project_number}/locations/{location}/documents/{document_id} or
//     projects/{project_number}/locations/{location}/documents/referenceId/{refer
//     ence_id}.
func (r *ProjectsLocationsDocumentsReferenceIdService) Patch(name string, googlecloudcontentwarehousev1updatedocumentrequest *GoogleCloudContentwarehouseV1UpdateDocumentRequest) *ProjectsLocationsDocumentsReferenceIdPatchCall {
	c := &ProjectsLocationsDocumentsReferenceIdPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.googlecloudcontentwarehousev1updatedocumentrequest = googlecloudcontentwarehousev1updatedocumentrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsDocumentsReferenceIdPatchCall) Fields(s ...googleapi.Field) *ProjectsLocationsDocumentsReferenceIdPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsDocumentsReferenceIdPatchCall) Context(ctx context.Context) *ProjectsLocationsDocumentsReferenceIdPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsDocumentsReferenceIdPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDocumentsReferenceIdPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googlecloudcontentwarehousev1updatedocumentrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "contentwarehouse.projects.locations.documents.referenceId.patch" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudContentwarehouseV1UpdateDocumentResponse.ServerResponse.Header
// or (if a response was returned at all) in error.(*googleapi.Error).Header.
// Use googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsDocumentsReferenceIdPatchCall) Do(opts ...googleapi.CallOption) (*GoogleCloudContentwarehouseV1UpdateDocumentResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudContentwarehouseV1UpdateDocumentResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ProjectsLocationsOperationsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets the latest state of a long-running operation. Clients can use this
// method to poll the operation result at intervals as recommended by the API
// service.
//
// - name: The name of the operation resource.
func (r *ProjectsLocationsOperationsService) Get(name string) *ProjectsLocationsOperationsGetCall {
	c := &ProjectsLocationsOperationsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsOperationsGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsOperationsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsOperationsGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsOperationsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsOperationsGetCall) Context(ctx context.Context) *ProjectsLocationsOperationsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsOperationsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsOperationsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "contentwarehouse.projects.locations.operations.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleLongrunningOperation.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsOperationsGetCall) Do(opts ...googleapi.CallOption) (*GoogleLongrunningOperation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleLongrunningOperation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ProjectsLocationsRuleSetsCreateCall struct {
	s                                    *Service
	parent                               string
	googlecloudcontentwarehousev1ruleset *GoogleCloudContentwarehouseV1RuleSet
	urlParams_                           gensupport.URLParams
	ctx_                                 context.Context
	header_                              http.Header
}

// Create: Creates a ruleset.
//
//   - parent: The parent name. Format:
//     projects/{project_number}/locations/{location}.
func (r *ProjectsLocationsRuleSetsService) Create(parent string, googlecloudcontentwarehousev1ruleset *GoogleCloudContentwarehouseV1RuleSet) *ProjectsLocationsRuleSetsCreateCall {
	c := &ProjectsLocationsRuleSetsCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.googlecloudcontentwarehousev1ruleset = googlecloudcontentwarehousev1ruleset
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsRuleSetsCreateCall) Fields(s ...googleapi.Field) *ProjectsLocationsRuleSetsCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsRuleSetsCreateCall) Context(ctx context.Context) *ProjectsLocationsRuleSetsCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsRuleSetsCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsRuleSetsCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googlecloudcontentwarehousev1ruleset)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/ruleSets")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "contentwarehouse.projects.locations.ruleSets.create" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudContentwarehouseV1RuleSet.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsRuleSetsCreateCall) Do(opts ...googleapi.CallOption) (*GoogleCloudContentwarehouseV1RuleSet, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudContentwarehouseV1RuleSet{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ProjectsLocationsRuleSetsDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes a ruleset. Returns NOT_FOUND if the document does not exist.
//
//   - name: The name of the rule set to delete. Format:
//     projects/{project_number}/locations/{location}/ruleSets/{rule_set_id}.
func (r *ProjectsLocationsRuleSetsService) Delete(name string) *ProjectsLocationsRuleSetsDeleteCall {
	c := &ProjectsLocationsRuleSetsDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsRuleSetsDeleteCall) Fields(s ...googleapi.Field) *ProjectsLocationsRuleSetsDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsRuleSetsDeleteCall) Context(ctx context.Context) *ProjectsLocationsRuleSetsDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsRuleSetsDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsRuleSetsDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "contentwarehouse.projects.locations.ruleSets.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleProtobufEmpty.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsRuleSetsDeleteCall) Do(opts ...googleapi.CallOption) (*GoogleProtobufEmpty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleProtobufEmpty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ProjectsLocationsRuleSetsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets a ruleset. Returns NOT_FOUND if the ruleset does not exist.
//
//   - name: The name of the rule set to retrieve. Format:
//     projects/{project_number}/locations/{location}/ruleSets/{rule_set_id}.
func (r *ProjectsLocationsRuleSetsService) Get(name string) *ProjectsLocationsRuleSetsGetCall {
	c := &ProjectsLocationsRuleSetsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsRuleSetsGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsRuleSetsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsRuleSetsGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsRuleSetsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsRuleSetsGetCall) Context(ctx context.Context) *ProjectsLocationsRuleSetsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsRuleSetsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsRuleSetsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "contentwarehouse.projects.locations.ruleSets.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudContentwarehouseV1RuleSet.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsRuleSetsGetCall) Do(opts ...googleapi.CallOption) (*GoogleCloudContentwarehouseV1RuleSet, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudContentwarehouseV1RuleSet{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ProjectsLocationsRuleSetsListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists rulesets.
//
//   - parent: The parent, which owns this collection of document. Format:
//     projects/{project_number}/locations/{location}.
func (r *ProjectsLocationsRuleSetsService) List(parent string) *ProjectsLocationsRuleSetsListCall {
	c := &ProjectsLocationsRuleSetsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number of rule
// sets to return. The service may return fewer than this value. If
// unspecified, at most 50 rule sets will be returned. The maximum value is
// 1000; values above 1000 will be coerced to 1000.
func (c *ProjectsLocationsRuleSetsListCall) PageSize(pageSize int64) *ProjectsLocationsRuleSetsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": A page token, received
// from a previous `ListRuleSets` call. Provide this to retrieve the subsequent
// page. When paginating, all other parameters provided to `ListRuleSets` must
// match the call that provided the page token.
func (c *ProjectsLocationsRuleSetsListCall) PageToken(pageToken string) *ProjectsLocationsRuleSetsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsRuleSetsListCall) Fields(s ...googleapi.Field) *ProjectsLocationsRuleSetsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsRuleSetsListCall) IfNoneMatch(entityTag string) *ProjectsLocationsRuleSetsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsRuleSetsListCall) Context(ctx context.Context) *ProjectsLocationsRuleSetsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsRuleSetsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsRuleSetsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/ruleSets")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "contentwarehouse.projects.locations.ruleSets.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudContentwarehouseV1ListRuleSetsResponse.ServerResponse.Header or
// (if a response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsRuleSetsListCall) Do(opts ...googleapi.CallOption) (*GoogleCloudContentwarehouseV1ListRuleSetsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudContentwarehouseV1ListRuleSetsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsRuleSetsListCall) Pages(ctx context.Context, f func(*GoogleCloudContentwarehouseV1ListRuleSetsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type ProjectsLocationsRuleSetsPatchCall struct {
	s                                                 *Service
	name                                              string
	googlecloudcontentwarehousev1updaterulesetrequest *GoogleCloudContentwarehouseV1UpdateRuleSetRequest
	urlParams_                                        gensupport.URLParams
	ctx_                                              context.Context
	header_                                           http.Header
}

// Patch: Updates a ruleset. Returns INVALID_ARGUMENT if the name of the
// ruleset is non-empty and does not equal the existing name.
//
//   - name: The name of the rule set to update. Format:
//     projects/{project_number}/locations/{location}/ruleSets/{rule_set_id}.
func (r *ProjectsLocationsRuleSetsService) Patch(name string, googlecloudcontentwarehousev1updaterulesetrequest *GoogleCloudContentwarehouseV1UpdateRuleSetRequest) *ProjectsLocationsRuleSetsPatchCall {
	c := &ProjectsLocationsRuleSetsPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.googlecloudcontentwarehousev1updaterulesetrequest = googlecloudcontentwarehousev1updaterulesetrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsRuleSetsPatchCall) Fields(s ...googleapi.Field) *ProjectsLocationsRuleSetsPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsRuleSetsPatchCall) Context(ctx context.Context) *ProjectsLocationsRuleSetsPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsRuleSetsPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsRuleSetsPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googlecloudcontentwarehousev1updaterulesetrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "contentwarehouse.projects.locations.ruleSets.patch" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudContentwarehouseV1RuleSet.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsRuleSetsPatchCall) Do(opts ...googleapi.CallOption) (*GoogleCloudContentwarehouseV1RuleSet, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudContentwarehouseV1RuleSet{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ProjectsLocationsSynonymSetsCreateCall struct {
	s                                       *Service
	parent                                  string
	googlecloudcontentwarehousev1synonymset *GoogleCloudContentwarehouseV1SynonymSet
	urlParams_                              gensupport.URLParams
	ctx_                                    context.Context
	header_                                 http.Header
}

// Create: Creates a SynonymSet for a single context. Throws an ALREADY_EXISTS
// exception if a synonymset already exists for the context.
//
//   - parent: The parent name. Format:
//     projects/{project_number}/locations/{location}.
func (r *ProjectsLocationsSynonymSetsService) Create(parent string, googlecloudcontentwarehousev1synonymset *GoogleCloudContentwarehouseV1SynonymSet) *ProjectsLocationsSynonymSetsCreateCall {
	c := &ProjectsLocationsSynonymSetsCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.googlecloudcontentwarehousev1synonymset = googlecloudcontentwarehousev1synonymset
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsSynonymSetsCreateCall) Fields(s ...googleapi.Field) *ProjectsLocationsSynonymSetsCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsSynonymSetsCreateCall) Context(ctx context.Context) *ProjectsLocationsSynonymSetsCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsSynonymSetsCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsSynonymSetsCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googlecloudcontentwarehousev1synonymset)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/synonymSets")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "contentwarehouse.projects.locations.synonymSets.create" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudContentwarehouseV1SynonymSet.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsSynonymSetsCreateCall) Do(opts ...googleapi.CallOption) (*GoogleCloudContentwarehouseV1SynonymSet, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudContentwarehouseV1SynonymSet{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ProjectsLocationsSynonymSetsDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes a SynonymSet for a given context. Throws a NOT_FOUND
// exception if the SynonymSet is not found.
//
//   - name: The name of the synonymSet to delete Format:
//     projects/{project_number}/locations/{location}/synonymSets/{context}.
func (r *ProjectsLocationsSynonymSetsService) Delete(name string) *ProjectsLocationsSynonymSetsDeleteCall {
	c := &ProjectsLocationsSynonymSetsDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsSynonymSetsDeleteCall) Fields(s ...googleapi.Field) *ProjectsLocationsSynonymSetsDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsSynonymSetsDeleteCall) Context(ctx context.Context) *ProjectsLocationsSynonymSetsDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsSynonymSetsDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsSynonymSetsDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "contentwarehouse.projects.locations.synonymSets.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleProtobufEmpty.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsSynonymSetsDeleteCall) Do(opts ...googleapi.CallOption) (*GoogleProtobufEmpty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleProtobufEmpty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ProjectsLocationsSynonymSetsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets a SynonymSet for a particular context. Throws a NOT_FOUND
// exception if the Synonymset does not exist
//
//   - name: The name of the synonymSet to retrieve Format:
//     projects/{project_number}/locations/{location}/synonymSets/{context}.
func (r *ProjectsLocationsSynonymSetsService) Get(name string) *ProjectsLocationsSynonymSetsGetCall {
	c := &ProjectsLocationsSynonymSetsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsSynonymSetsGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsSynonymSetsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsSynonymSetsGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsSynonymSetsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsSynonymSetsGetCall) Context(ctx context.Context) *ProjectsLocationsSynonymSetsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsSynonymSetsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsSynonymSetsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "contentwarehouse.projects.locations.synonymSets.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudContentwarehouseV1SynonymSet.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsSynonymSetsGetCall) Do(opts ...googleapi.CallOption) (*GoogleCloudContentwarehouseV1SynonymSet, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudContentwarehouseV1SynonymSet{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ProjectsLocationsSynonymSetsListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Returns all SynonymSets (for all contexts) for the specified location.
//
//   - parent: The parent name. Format:
//     projects/{project_number}/locations/{location}.
func (r *ProjectsLocationsSynonymSetsService) List(parent string) *ProjectsLocationsSynonymSetsListCall {
	c := &ProjectsLocationsSynonymSetsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number of
// synonymSets to return. The service may return fewer than this value. If
// unspecified, at most 50 rule sets will be returned. The maximum value is
// 1000; values above 1000 will be coerced to 1000.
func (c *ProjectsLocationsSynonymSetsListCall) PageSize(pageSize int64) *ProjectsLocationsSynonymSetsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": A page token, received
// from a previous `ListSynonymSets` call. Provide this to retrieve the
// subsequent page. When paginating, all other parameters provided to
// `ListSynonymSets` must match the call that provided the page token.
func (c *ProjectsLocationsSynonymSetsListCall) PageToken(pageToken string) *ProjectsLocationsSynonymSetsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsSynonymSetsListCall) Fields(s ...googleapi.Field) *ProjectsLocationsSynonymSetsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsSynonymSetsListCall) IfNoneMatch(entityTag string) *ProjectsLocationsSynonymSetsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsSynonymSetsListCall) Context(ctx context.Context) *ProjectsLocationsSynonymSetsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsSynonymSetsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsSynonymSetsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/synonymSets")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "contentwarehouse.projects.locations.synonymSets.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudContentwarehouseV1ListSynonymSetsResponse.ServerResponse.Header
// or (if a response was returned at all) in error.(*googleapi.Error).Header.
// Use googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsSynonymSetsListCall) Do(opts ...googleapi.CallOption) (*GoogleCloudContentwarehouseV1ListSynonymSetsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudContentwarehouseV1ListSynonymSetsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsSynonymSetsListCall) Pages(ctx context.Context, f func(*GoogleCloudContentwarehouseV1ListSynonymSetsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type ProjectsLocationsSynonymSetsPatchCall struct {
	s                                       *Service
	name                                    string
	googlecloudcontentwarehousev1synonymset *GoogleCloudContentwarehouseV1SynonymSet
	urlParams_                              gensupport.URLParams
	ctx_                                    context.Context
	header_                                 http.Header
}

// Patch: Remove the existing SynonymSet for the context and replaces it with a
// new one. Throws a NOT_FOUND exception if the SynonymSet is not found.
//
//   - name: The name of the synonymSet to update Format:
//     projects/{project_number}/locations/{location}/synonymSets/{context}.
func (r *ProjectsLocationsSynonymSetsService) Patch(name string, googlecloudcontentwarehousev1synonymset *GoogleCloudContentwarehouseV1SynonymSet) *ProjectsLocationsSynonymSetsPatchCall {
	c := &ProjectsLocationsSynonymSetsPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.googlecloudcontentwarehousev1synonymset = googlecloudcontentwarehousev1synonymset
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsSynonymSetsPatchCall) Fields(s ...googleapi.Field) *ProjectsLocationsSynonymSetsPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsSynonymSetsPatchCall) Context(ctx context.Context) *ProjectsLocationsSynonymSetsPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsSynonymSetsPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsSynonymSetsPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googlecloudcontentwarehousev1synonymset)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "contentwarehouse.projects.locations.synonymSets.patch" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudContentwarehouseV1SynonymSet.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsSynonymSetsPatchCall) Do(opts ...googleapi.CallOption) (*GoogleCloudContentwarehouseV1SynonymSet, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudContentwarehouseV1SynonymSet{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}
